/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.macos;

import java.awt.Component;
import java.awt.MenuComponent;
import sun.awt.macos.MComponentPeer;

public class InterfaceEvent {
    public static final int NONE = 0;
    public static final int EXPOSE = 1;
    public static final int REPAINT = 2;
    public static final int MOUSE_DOWN = 3;
    public static final int MOUSE_UP = 4;
    public static final int MOUSE_MOVED = 5;
    public static final int MOUSE_DRAGGED = 6;
    public static final int KEY_PRESS = 7;
    public static final int KEY_RELEASE = 8;
    public static final int KEY_ACTION = 9;
    public static final int KEY_ACTION_RELEASE = 10;
    public static final int MOUSE_ENTER = 11;
    public static final int MOUSE_EXIT = 12;
    public static final int ACTION_VOID = 13;
    public static final int ACTION_BOOL = 14;
    public static final int ACTION_INT = 15;
    public static final int ACTION_MENU = 16;
    public static final int LIST_SELECT = 17;
    public static final int LIST_DESELECT = 18;
    public static final int kRepaintsBetweenSleeps = 2;
    static InterfaceEvent gFirstInterfaceEvent = null;
    static InterfaceEvent gLastInterfaceEvent = null;
    static Thread mInterfaceThread = null;
    static int gCountTilSleep = 2;
    InterfaceEvent next = null;
    InterfaceEvent prev = null;
    int type;
    Component component;
    MenuComponent menuComponent;
    int x;
    int y;
    int width;
    int height;
    long when;
    int flags;
    int key;
    int clickCount;
    boolean actionState;
    int eventNumber;

    public InterfaceEvent(int n, Component component, MenuComponent menuComponent, int n2, int n3, int n4, int n5, long l, int n6, int n7, int n8, boolean bl, int n9) {
        this.component = component;
        this.type = n;
        this.width = n4;
        this.height = n5;
        this.x = n2;
        this.y = n3;
        this.when = l;
        this.flags = n6;
        this.key = n7;
        this.clickCount = n8;
        this.actionState = bl;
        this.menuComponent = menuComponent;
        this.eventNumber = n9;
    }

    public int getEventNumber() {
        return this.eventNumber;
    }

    public int getClickCount() {
        return this.clickCount;
    }

    public int getType() {
        return this.type;
    }

    public Component getComponent() {
        return this.component;
    }

    public MenuComponent getMenuComponent() {
        return this.menuComponent;
    }

    public int getKey() {
        return this.key;
    }

    public long getWhen() {
        return this.when;
    }

    public int getFlags() {
        return this.flags;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean getActionState() {
        return this.actionState;
    }

    public boolean enqueue() {
        if (this.type == 2 || this.type == 1) {
            InterfaceEvent interfaceEvent = gLastInterfaceEvent;
            while (interfaceEvent != null) {
                if (interfaceEvent.getType() == this.type && interfaceEvent.getComponent() == this.getComponent()) {
                    if (this.x < interfaceEvent.x) {
                        interfaceEvent.width += interfaceEvent.x - this.x;
                        interfaceEvent.x = this.x;
                    }
                    if (this.y < interfaceEvent.y) {
                        interfaceEvent.height += interfaceEvent.y - this.y;
                        interfaceEvent.y = this.y;
                    }
                    if (this.x + this.width > interfaceEvent.x + interfaceEvent.width) {
                        interfaceEvent.width = this.x + this.width - interfaceEvent.x;
                    }
                    if (this.y + this.height > interfaceEvent.y + interfaceEvent.height) {
                        interfaceEvent.height = this.y + this.height - interfaceEvent.y;
                    }
                    return false;
                }
                interfaceEvent = interfaceEvent.next;
            }
            if (this.type == 2) {
                try {
                    if (gCountTilSleep == 0) {
                        Thread.currentThread();
                        Thread.sleep(15L);
                        gCountTilSleep = 2;
                    } else {
                        --gCountTilSleep;
                    }
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.next = null;
        this.prev = gLastInterfaceEvent;
        if (gLastInterfaceEvent != null) {
            InterfaceEvent.gLastInterfaceEvent.next = this;
        }
        gLastInterfaceEvent = this;
        if (gFirstInterfaceEvent == null) {
            gFirstInterfaceEvent = this;
        }
        return true;
    }

    public void dequeue() {
        if (this.next != null) {
            this.next.prev = this.prev;
        } else {
            gLastInterfaceEvent = this.prev;
        }
        if (this.prev != null) {
            this.prev.next = this.next;
            return;
        }
        gFirstInterfaceEvent = this.next;
    }

    public static InterfaceEvent firstEvent() {
        return gFirstInterfaceEvent;
    }

    public static void flushInterfaceQueue(MComponentPeer mComponentPeer) {
        InterfaceEvent interfaceEvent = gFirstInterfaceEvent;
        while (interfaceEvent != null) {
            if (interfaceEvent.component == mComponentPeer.target) {
                if (interfaceEvent.prev == null) {
                    gFirstInterfaceEvent = interfaceEvent.next;
                } else {
                    interfaceEvent.prev.next = interfaceEvent.next;
                }
                if (interfaceEvent.next == null) {
                    gLastInterfaceEvent = interfaceEvent.prev;
                } else {
                    interfaceEvent.next.prev = interfaceEvent.prev;
                }
            }
            interfaceEvent = interfaceEvent.next;
        }
    }
}

