/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.TextComponent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.peer.TextFieldPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class TextField
extends TextComponent {
    int columns;
    char echoChar;
    transient ActionListener actionListener;
    private static final String base = "textfield";
    private static int nameCounter;
    private static final long serialVersionUID = -2966288784432217853L;
    private int textFieldSerializedDataVersion = 1;

    public TextField() {
        this("", 0);
    }

    public TextField(String string) {
        this(string, string.length());
    }

    public TextField(int n) {
        this("", n);
    }

    public TextField(String string, int n) {
        super(string);
        this.name = base + nameCounter++;
        this.columns = n;
    }

    public void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createTextField(this);
        }
        super.addNotify();
    }

    public char getEchoChar() {
        return this.echoChar;
    }

    public void setEchoChar(char c) {
        this.setEchoCharacter(c);
    }

    public void setEchoCharacter(char c) {
        this.echoChar = c;
        TextFieldPeer textFieldPeer = (TextFieldPeer)this.peer;
        if (textFieldPeer != null) {
            textFieldPeer.setEchoCharacter(c);
        }
    }

    public boolean echoCharIsSet() {
        return this.echoChar != '\u0000';
    }

    public int getColumns() {
        return this.columns;
    }

    public void setColumns(int n) {
        int n2 = this.columns;
        if (n < 0) {
            throw new IllegalArgumentException("columns less than zero.");
        }
        if (n != n2) {
            this.columns = n;
            this.invalidate();
        }
    }

    public Dimension getPreferredSize(int n) {
        return this.preferredSize(n);
    }

    public Dimension preferredSize(int n) {
        Object object = Component.LOCK;
        synchronized (object) {
            TextFieldPeer textFieldPeer = (TextFieldPeer)this.peer;
            Dimension dimension = textFieldPeer != null ? textFieldPeer.preferredSize(n) : super.preferredSize();
            Object var4_5 = null;
            return dimension;
        }
    }

    public Dimension getPreferredSize() {
        return this.preferredSize();
    }

    public Dimension preferredSize() {
        Object object = Component.LOCK;
        synchronized (object) {
            Dimension dimension = this.columns > 0 ? this.preferredSize(this.columns) : super.preferredSize();
            Object var3_3 = null;
            return dimension;
        }
    }

    public Dimension getMinimumSize(int n) {
        return this.minimumSize(n);
    }

    public Dimension minimumSize(int n) {
        Object object = Component.LOCK;
        synchronized (object) {
            TextFieldPeer textFieldPeer = (TextFieldPeer)this.peer;
            Dimension dimension = textFieldPeer != null ? textFieldPeer.minimumSize(n) : super.minimumSize();
            Object var4_5 = null;
            return dimension;
        }
    }

    public Dimension getMinimumSize() {
        return this.minimumSize();
    }

    public Dimension minimumSize() {
        Object object = Component.LOCK;
        synchronized (object) {
            Dimension dimension = this.columns > 0 ? this.minimumSize(this.columns) : super.minimumSize();
            Object var3_3 = null;
            return dimension;
        }
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
        this.newEventsOnly = true;
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    boolean eventEnabled(AWTEvent aWTEvent) {
        if (aWTEvent.id == 1001) {
            return (this.eventMask & 0x80L) != 0L || this.actionListener != null;
        }
        return super.eventEnabled(aWTEvent);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)aWTEvent);
            return;
        }
        super.processEvent(aWTEvent);
    }

    protected void processActionEvent(ActionEvent actionEvent) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(actionEvent);
        }
    }

    protected String paramString() {
        String string = super.paramString();
        if (this.echoChar != '\u0000') {
            string = String.valueOf(string) + ",echo=" + this.echoChar;
        }
        return string;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        AWTEventMulticaster.save(objectOutputStream, "actionL", this.actionListener);
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        Object object;
        objectInputStream.defaultReadObject();
        while ((object = objectInputStream.readObject()) != null) {
            String string = ((String)object).intern();
            if (string == "actionL") {
                this.addActionListener((ActionListener)objectInputStream.readObject());
                continue;
            }
            objectInputStream.readObject();
        }
    }
}

