/*
 * Decompiled with CFR 0.152.
 */
package server;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import server.DXServerThread;

public class ConnectionEntry {
    private Long dxlcon;
    private Hashtable users;
    private static int next_id = 100;
    private boolean using;
    private int idle_time;
    private int user_time;
    private long lock_time;
    private static final long SecondScale = new Date().getTime() / 1000L;
    private boolean failed;
    private Hashtable available_programs;
    private Hashtable inuse_programs;

    public boolean isFailed() {
        return this.failed;
    }

    private static synchronized int NextID() {
        return next_id++;
    }

    public Long getDXLConnection() {
        return this.dxlcon;
    }

    public int getUserCount() {
        return this.users.size();
    }

    public int getUserTime() {
        return this.user_time;
    }

    public int getIdleTime() {
        int n = (int)(new Date().getTime() / 1000L - SecondScale);
        return n - this.idle_time;
    }

    public ConnectionEntry() {
        this.dxlcon = null;
        this.users = new Hashtable(10, 4.0f);
        this.available_programs = new Hashtable(10, 4.0f);
        this.inuse_programs = new Hashtable(10, 4.0f);
        this.using = false;
        this.idle_time = 0;
        this.user_time = 0;
        this.lock_time = 0L;
    }

    public ConnectionEntry(Long l) {
        this.dxlcon = l;
        this.users = new Hashtable(10, 4.0f);
        this.available_programs = new Hashtable(10, 4.0f);
        this.inuse_programs = new Hashtable(10, 4.0f);
        this.using = false;
        this.idle_time = 0;
        this.user_time = 0;
        this.lock_time = 0L;
    }

    public String getNetName(DXServerThread dXServerThread) {
        return (String)this.users.get(dXServerThread);
    }

    public void attachUser(DXServerThread dXServerThread, String string) {
        try {
            this.users.put(dXServerThread, this.useNet(string, dXServerThread.getIdDX()));
            this.idle_time = 0;
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("ConnectionEntry: file not found: " + string);
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            System.out.println("ConnectionEntry: io error: " + string);
        }
    }

    public void deleteFiles() {
        Enumeration enumeration = this.available_programs.elements();
        while (enumeration.hasMoreElements()) {
            Vector vector = (Vector)enumeration.nextElement();
            Enumeration enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                String string = (String)enumeration2.nextElement();
                try {
                    File file = new File(string);
                    file.delete();
                }
                catch (Exception exception) {}
            }
        }
        this.available_programs.clear();
    }

    public void detachUser(DXServerThread dXServerThread) {
        if (dXServerThread.isFailed()) {
            this.failed = true;
        }
        this.unUseNet((String)this.users.remove(dXServerThread));
        if (this.users.size() == 0) {
            this.idle_time = (int)(new Date().getTime() / 1000L - SecondScale);
        }
    }

    private void unUseNet(String string) {
        String string2 = (String)this.inuse_programs.remove(string);
        Vector vector = (Vector)this.available_programs.get(string2);
        vector.addElement(string);
    }

    private String useNet(String string, int n) throws FileNotFoundException, IOException {
        Vector<String> vector = (Vector<String>)this.available_programs.get(string);
        if (vector == null) {
            vector = new Vector<String>(4);
            this.available_programs.put(string, vector);
        }
        if (vector.size() == 0) {
            vector.addElement(this.munge(string));
        }
        String string2 = (String)vector.elementAt(0);
        vector.removeElementAt(0);
        this.inuse_programs.put(string2, string);
        return string2;
    }

    private String munge(String string) throws FileNotFoundException, IOException {
        String string2;
        String string3 = "_" + ConnectionEntry.NextID();
        File file = new File(string);
        String string4 = null;
        string4 = file.getParent();
        boolean bl = false;
        if (string4 == null && File.separatorChar == '\\') {
            string2 = string.replace('/', '\\');
            if (string2 != string) {
                string4 = new File(string2).getParent();
            }
            bl = true;
        }
        if (string4 == null) {
            string4 = ".";
        }
        string2 = string4 + "/" + string3 + ".net";
        if (bl) {
            string2 = string2.replace('\\', '/');
        }
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        new File(string2).delete();
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(new File(string2)));
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = "// MODULE ";
        while ((string7 = bufferedReader.readLine()) != null) {
            if (string5 == null && string7.startsWith(string8)) {
                string5 = string7.substring(string8.length());
                string5.trim();
                string6 = string8 + string3 + "\n";
            } else {
                string6 = string7 + "\n";
                if (!string7.startsWith("//") && !string7.startsWith("    //") && string5 != null) {
                    int n;
                    while ((n = string6.indexOf(string5)) != -1) {
                        String string9;
                        string6 = string9 = string6.substring(0, n) + string3 + string6.substring(n + string5.length());
                    }
                }
            }
            bufferedWriter.write(string6, 0, string6.length());
            bufferedWriter.flush();
        }
        bufferedReader.close();
        bufferedWriter.close();
        return string2;
    }

    public synchronized void getConnectionLock() {
        while (!this.lock_available()) {
            try {
                this.wait();
            }
            catch (Exception exception) {}
        }
        this.lock_time = new Date().getTime();
    }

    private synchronized boolean lock_available() {
        if (this.using) {
            return false;
        }
        this.using = true;
        return true;
    }

    public synchronized void releaseConnectionLock() {
        this.using = false;
        this.notify();
        if (this.lock_time > 0L) {
            long l = new Date().getTime();
            this.user_time = (int)((long)this.user_time + (l - this.lock_time));
            this.lock_time = 0L;
        }
    }
}

