/*
 * Decompiled with CFR 0.152.
 */
package server;

import dx.protocol.server.serverMsg;
import dx.protocol.server.serverVersionMsg;
import dx.protocol.server.shutdownMsg;
import dx.protocol.server.startMsg;
import dx.protocol.server.statusMsg;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import server.CleanUpDaemon;
import server.ConnectThread;
import server.ConnectionEntry;
import server.DXServerThread;
import server.ServerCommand;
import server.StatusThread;

public class DXServer {
    private static ServerSocket serverSocket = null;
    private static int java_id = 1;
    public static Vector actions;
    private static Vector users;
    private static Date started_at;
    private static CleanUpDaemon Cud;
    private static boolean debug;
    private static String output_dir;
    private static String output_url;
    private static int max_sessions;
    private static String max_session_str;
    private static final int DXIdleTime = 600;
    private static Hashtable CachedConns;
    private static String HostFileUsed;
    private static long HostFileModified;
    private static Vector HostNames;
    private static Enumeration HostEnum;
    private static int maxThreads;
    private static final int Port = 4655;
    static final int MajorVersion = 2;
    static final int MinorVersion = 0;
    static final int MicroVersion = 0;
    public static final String VersionString = "2.0.0";
    public static final int STARTDX = 1;
    public static final int STATUS = 4;
    public static final int SHUTDOWN = 5;

    public static native int DXLSend(long var0, String var2);

    private static native long DXLStartDX(String var0, String var1);

    private static native int DXLExitDX(long var0);

    public static String getStartDate() {
        return DateFormat.getDateInstance().format(started_at);
    }

    public static int getServedCount() {
        return java_id - 1;
    }

    public static int getMaxThreads() {
        return maxThreads;
    }

    public static String getOutputDir() {
        return output_dir;
    }

    public static String getOutputUrl() {
        return output_url;
    }

    public static void main(String[] stringArray) {
        try {
            serverSocket = new ServerSocket(4655);
        }
        catch (IOException iOException) {
            System.out.println("Could not listen on port: 4655, " + iOException);
            System.exit(1);
        }
        String string = System.getProperty("DXServer.debug");
        debug = string != null;
        users = new Vector(50);
        DXServerThread.ClassInitialize();
        HostFileUsed = null;
        HostFileModified = 0L;
        HostNames = new Vector(20);
        HostEnum = null;
        DXServer.ReadHostFile();
        CachedConns = new Hashtable();
        Cud = new CleanUpDaemon();
        Cud.start();
        maxThreads = 1;
        String string2 = System.getProperty("DXServer.dxsessions");
        if (string2 != null) {
            try {
                maxThreads = new Integer(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((output_dir = System.getProperty("DXServer.outDir")) == null) {
            output_dir = "./";
        }
        if ((output_url = System.getProperty("DXServer.outUrl")) == null) {
            output_url = "./";
        }
        if (output_dir == null || output_url == null) {
            System.out.println("DXServer requires output file name and url.");
            System.exit(1);
        }
        actions = new Vector(10);
        try {
            actions.addElement(new ServerCommand(startMsg.GetCommand(), 1));
            actions.addElement(new ServerCommand(statusMsg.GetCommand(), 4));
            actions.addElement(new ServerCommand(shutdownMsg.GetCommand(), 5));
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            System.exit(1);
        }
        System.out.println("Starting DXServer... ready for clients");
        started_at = new Date();
        try {
            while (true) {
                Socket socket = serverSocket.accept();
                ConnectThread connectThread = new ConnectThread(socket);
                connectThread.start();
                connectThread = null;
            }
        }
        catch (IOException iOException) {
            System.out.println("Accept failed: 4655, " + iOException);
        }
        catch (Exception exception) {
            System.out.println("Unknown error");
        }
        DXServer.shutdown(null, null);
    }

    public static boolean versionMatch(String string) {
        boolean bl = false;
        serverVersionMsg serverVersionMsg2 = new serverVersionMsg(string);
        if (serverVersionMsg2.getMajor() >= 2 && serverVersionMsg2.getMinor() >= 0) {
            bl = true;
        }
        if (debug) {
            System.out.println("DXServer: versionMatch(" + bl + ") " + string);
        }
        return bl;
    }

    public static synchronized int getUserCount() {
        return users.size();
    }

    public static synchronized boolean startDX(serverMsg serverMsg2, Socket socket) {
        if (debug) {
            System.out.println("DXServer: " + serverMsg2.toString());
        }
        DXServerThread dXServerThread = new DXServerThread(socket, java_id);
        dXServerThread.start();
        users.addElement(dXServerThread);
        ++java_id;
        return true;
    }

    public static boolean status(serverMsg serverMsg2, Socket socket) {
        StatusThread statusThread = new StatusThread(socket);
        statusThread.start();
        return true;
    }

    public static boolean shutdown(serverMsg serverMsg2, Socket socket) {
        if (debug) {
            System.out.println("DXServer: " + serverMsg2.toString());
        }
        Cud.interrupt();
        DXServer.CleanUp();
        Enumeration enumeration = users.elements();
        while (enumeration.hasMoreElements()) {
            DXServerThread dXServerThread = (DXServerThread)enumeration.nextElement();
            if (!dXServerThread.isAlive()) continue;
            if (debug) {
                System.out.println("     ***** DXServer: requesting thread shutdown");
            }
            dXServerThread.cleanUp();
            dXServerThread.interrupt();
        }
        System.exit(0);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void CleanUp() {
        Object object;
        Vector<DXServerThread> vector = new Vector<DXServerThread>(10);
        Enumeration<Object> enumeration = users.elements();
        while (enumeration.hasMoreElements()) {
            object = (DXServerThread)enumeration.nextElement();
            if (((Thread)object).isAlive()) continue;
            vector.addElement((DXServerThread)object);
        }
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object = (DXServerThread)enumeration.nextElement();
            users.removeElement(object);
        }
        object = CachedConns;
        synchronized (object) {
            Object object2;
            Object object3;
            Vector<Object> vector2 = new Vector<Object>(4);
            enumeration = CachedConns.elements();
            while (enumeration.hasMoreElements()) {
                object3 = (ConnectionEntry)enumeration.nextElement();
                if (((ConnectionEntry)object3).getUserCount() != 0 || ((ConnectionEntry)object3).getIdleTime() <= 600) continue;
                object2 = ((ConnectionEntry)object3).getDXLConnection();
                DXServer.DXLExitDX((Long)object2);
                vector2.addElement(object2);
                if (!debug) continue;
                System.out.println("DXServer: terminate Data Explorer session");
            }
            enumeration = vector2.elements();
            while (enumeration.hasMoreElements()) {
                object3 = (Long)enumeration.nextElement();
                object2 = (ConnectionEntry)CachedConns.get(object3);
                ((ConnectionEntry)object2).deleteFiles();
                CachedConns.remove(object3);
            }
            vector2.removeAllElements();
        }
    }

    public static synchronized DXServerThread GetThread(int n) {
        int n2;
        DXServerThread dXServerThread = null;
        Enumeration enumeration = users.elements();
        while (enumeration.hasMoreElements() && (!(dXServerThread = (DXServerThread)enumeration.nextElement()).isAlive() || (n2 = dXServerThread.getIdDX()) != n)) {
        }
        return dXServerThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void EndConnection(Long l, DXServerThread dXServerThread) {
        Hashtable hashtable = CachedConns;
        synchronized (hashtable) {
            ConnectionEntry connectionEntry = (ConnectionEntry)CachedConns.get(l);
            connectionEntry.detachUser(dXServerThread);
        }
    }

    public static synchronized String createNet(String string, DXServerThread dXServerThread) {
        ConnectionEntry connectionEntry = (ConnectionEntry)CachedConns.get(dXServerThread.getDXLConnection());
        return connectionEntry.getNetName(dXServerThread);
    }

    public static void LockConnection(DXServerThread dXServerThread) {
        ConnectionEntry connectionEntry = (ConnectionEntry)CachedConns.get(dXServerThread.getDXLConnection());
        connectionEntry.getConnectionLock();
    }

    public static void UnlockConnection(DXServerThread dXServerThread) {
        ConnectionEntry connectionEntry = (ConnectionEntry)CachedConns.get(dXServerThread.getDXLConnection());
        connectionEntry.releaseConnectionLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long NewConnection(DXServerThread dXServerThread, String string) {
        ConnectionEntry connectionEntry = null;
        Hashtable hashtable = CachedConns;
        synchronized (hashtable) {
            Object object;
            if (CachedConns.size() > 0) {
                ConnectionEntry connectionEntry2 = null;
                object = CachedConns.elements();
                while (object.hasMoreElements()) {
                    ConnectionEntry connectionEntry3 = (ConnectionEntry)object.nextElement();
                    if (!connectionEntry3.isFailed()) {
                        if (connectionEntry2 == null) {
                            connectionEntry2 = connectionEntry3;
                        } else if (connectionEntry3.getUserCount() < connectionEntry2.getUserCount()) {
                            connectionEntry2 = connectionEntry3;
                        } else if (connectionEntry3.getUserCount() == connectionEntry2.getUserCount() && connectionEntry3.getUserTime() < connectionEntry2.getUserTime()) {
                            connectionEntry2 = connectionEntry3;
                        }
                    }
                    if (connectionEntry2 == null || connectionEntry2.getUserCount() != 0) continue;
                    break;
                }
                connectionEntry = connectionEntry2;
            }
            boolean bl = false;
            if (DXServer.GetMaxSessions() > CachedConns.size()) {
                bl = true;
            }
            if (connectionEntry != null && connectionEntry.getUserCount() >= 1 && bl) {
                connectionEntry = null;
            }
            if (connectionEntry == null) {
                object = DXServer.GetNextHost();
                long l = 0L;
                try {
                    l = DXServer.DXLStartDX("dx -optimize memory -execonly -processors 1 -highlight off", (String)object);
                }
                catch (Exception exception) {
                    System.out.println("Problem starting one of your hosts.");
                    System.out.println("Startup was: dx -optimize memory -execonly -processors 1 -highlight off :" + (String)object);
                    System.exit(1);
                }
                if (l == 0L) {
                    System.out.println("Problem starting one of your hosts.");
                    System.out.println("Startup was: dx -optimize memory -execonly -processors 1 -highlight off :" + (String)object);
                    System.exit(1);
                }
                Long l2 = new Long(l);
                connectionEntry = new ConnectionEntry(l2);
                CachedConns.put(l2, connectionEntry);
            }
            if (connectionEntry == null) {
                return null;
            }
            connectionEntry.attachUser(dXServerThread, string);
        }
        return connectionEntry.getDXLConnection();
    }

    public static int GetMaxSessions() {
        if (max_session_str == null) {
            max_session_str = System.getProperty("DXServer.max_sessions");
            if (max_session_str == null) {
                max_session_str = "1";
            }
            try {
                Integer n = new Integer(max_session_str);
                max_sessions = n;
            }
            catch (NumberFormatException numberFormatException) {
                max_session_str = "1";
                max_sessions = 1;
            }
        }
        return max_sessions;
    }

    private static String GetNextHost() {
        if (!HostEnum.hasMoreElements()) {
            HostEnum = HostNames.elements();
        }
        return (String)HostEnum.nextElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ReadHostFile() {
        boolean bl = false;
        boolean bl2 = false;
        Vector<String> vector = new Vector<String>(5);
        if (HostFileUsed != null) {
            vector.addElement(HostFileUsed);
        }
        vector.addElement(File.separator + "etc" + File.separator + "dxserver.hosts");
        vector.addElement("." + File.separator + "dxserver.hosts");
        vector.addElement(System.getProperty("DXServer.hostsFile"));
        Vector vector2 = HostNames;
        synchronized (vector2) {
            try {
                Enumeration enumeration = vector.elements();
                while (!bl2 && enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    File file = new File(string);
                    if (!file.exists() || !file.canRead() || !file.isFile()) continue;
                    bl = true;
                    long l = file.lastModified();
                    if (HostFileUsed == null || !HostFileUsed.equals(string) || HostFileModified < l) {
                        String string2;
                        HostNames.removeAllElements();
                        FileReader fileReader = new FileReader(file);
                        BufferedReader bufferedReader = new BufferedReader(fileReader);
                        while ((string2 = bufferedReader.readLine()) != null) {
                            if ((string2 = string2.trim()).startsWith("//") || string2.startsWith("!#") || string2.startsWith("#") || string2.length() == 0) continue;
                            HostNames.addElement(string2);
                        }
                        HostFileUsed = file.getPath();
                        HostFileModified = l;
                        bl2 = true;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (!bl) {
                HostFileUsed = null;
                HostNames.removeAllElements();
            }
            if (HostNames.size() == 0) {
                HostNames.addElement("localhost");
            }
            if (!bl || bl2) {
                HostEnum = HostNames.elements();
            }
        }
    }

    static {
        debug = false;
        output_dir = null;
        output_url = null;
        max_sessions = 1;
        max_session_str = null;
        CachedConns = null;
        HostFileUsed = null;
        HostFileModified = 0L;
        HostNames = null;
    }
}

