/*
 * Decompiled with CFR 0.152.
 */
package server;

import dx.protocol.doneMsg;
import dx.protocol.endExecMsg;
import dx.protocol.execOnceMsg;
import dx.protocol.loadMsg;
import dx.protocol.messageMsg;
import dx.protocol.noopMsg;
import dx.protocol.sendValueMsg;
import dx.protocol.setidMsg;
import dx.protocol.setmacroMsg;
import dx.protocol.stepSeqMsg;
import dx.protocol.stopMsg;
import dx.protocol.threadMsg;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.Socket;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import server.DXServer;
import server.DXThread;
import server.FileStyle;
import server.FileStyleANY;
import server.FileStyleHTM;
import server.FileStyleHTML;
import server.ServerThreadCommand;

public class DXServerThread
extends DXThread {
    private Long dxlconnection;
    private int java_id;
    private String java_dir = null;
    private String url = null;
    private Vector shown = null;
    private int latest_sequence = -1;
    private String java_version;
    private Vector frame_threads = null;
    private static final int NotLoaded = 0;
    private static final int NotExecuting = 1;
    private static final int ExecuteOnChange = 2;
    private static final int Executing = 3;
    private int exec_state = 0;
    private Vector setvalues = null;
    private static String PathFileUsed = null;
    private static long PathFileModified = 0L;
    private static Vector PathNames = null;
    private static int RecentOperation;
    private static boolean Initialized;
    public static final int DISCONNECT = 1;
    public static final int EXECUTE = 2;
    public static final int SENDVALUE = 3;
    public static final int SETFILECNT = 4;
    public static final int LOAD = 5;
    public static final int SETUIVERSION = 7;
    public static final int ENDEXECUTION = 8;
    public static final int NOOP = 12;
    public static final int SEQUENCE = 13;
    private static final int START = 1;
    private static final int EXIT = 2;
    private static final int CLEANUP = 3;

    private native int DXLExecuteOnce(long var1, String var3);

    private native int DXLHandlePendingMessages(long var1);

    private native int DXLLoadVisualProgram(long var1, String var3);

    public int getIdDX() {
        return this.java_id;
    }

    public Long getDXLConnection() {
        return this.dxlconnection;
    }

    public void executionFinished() {
        this.transmit(new doneMsg());
    }

    private long getConnection() {
        if (this.dxlconnection == null) {
            return 0L;
        }
        return this.dxlconnection;
    }

    public void fileNotify(String string) {
        FileStyle fileStyle;
        boolean bl = false;
        Enumeration enumeration = this.shown.elements();
        while (enumeration.hasMoreElements()) {
            fileStyle = (FileStyle)enumeration.nextElement();
            String string2 = fileStyle.getFileName();
            if (!string2.equals(string)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            fileStyle = DXServerThread.Allocator(string);
            if (fileStyle.isSequenced()) {
                int n = fileStyle.getSequence();
                if (n > this.latest_sequence) {
                    FileStyle fileStyle2;
                    enumeration = this.shown.elements();
                    Vector<FileStyle> vector = new Vector<FileStyle>(4);
                    while (enumeration.hasMoreElements()) {
                        fileStyle2 = (FileStyle)enumeration.nextElement();
                        int n2 = fileStyle2.getSequence();
                        if (n2 > this.latest_sequence) continue;
                        vector.addElement(fileStyle2);
                    }
                    enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        fileStyle2 = (FileStyle)enumeration.nextElement();
                        this.shown.removeElement(fileStyle2);
                        fileStyle2.delete();
                    }
                    enumeration = null;
                    vector.removeAllElements();
                }
                this.latest_sequence = n;
            }
            this.shown.addElement(fileStyle);
        }
    }

    private boolean isImageNotify(String string) {
        String string2 = "ECHO:  ";
        String string3 = " 0:  ECHO:  ";
        int n = -1;
        if (string.startsWith(string3)) {
            n = string3.length();
        } else if (string.startsWith(string2)) {
            n = string2.length();
        }
        if (n == -1) {
            return false;
        }
        int n2 = string.substring(n).indexOf("Image_");
        if (n2 == -1) {
            return false;
        }
        return n2 <= 6;
    }

    public void infoNotify(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        if (this.isImageNotify(string)) {
            Object object;
            stringTokenizer = new StringTokenizer(string, ";");
            Object object2 = null;
            while (stringTokenizer.hasMoreTokens()) {
                object = stringTokenizer.nextToken();
                StringTokenizer stringTokenizer2 = new StringTokenizer((String)object, "=");
                String string2 = null;
                if (stringTokenizer2.hasMoreTokens()) {
                    string2 = stringTokenizer2.nextToken();
                }
                if (string2 != null && string2.endsWith("show")) {
                    String string3 = stringTokenizer2.nextToken();
                    this.fileNotify(string3);
                    int n = string3.lastIndexOf(47);
                    String string4 = null;
                    string4 = n == -1 ? string3 : string3.substring(n + 1);
                    String string5 = DXServer.getOutputUrl() + "/" + string4;
                    if (object2 == null) {
                        object2 = string2 + "=" + string5 + ";";
                        continue;
                    }
                    object2 = (String)object2 + ";" + string2 + "=" + string5 + ";";
                    continue;
                }
                if (object2 == null) {
                    object2 = object;
                    continue;
                }
                object2 = (String)object2 + ";" + (String)object;
            }
            object = new messageMsg();
            ((messageMsg)object).setMessage((String)object2);
            this.transmit((threadMsg)object);
        } else if (string.startsWith("Connection to DX broken")) {
            this.setFailed();
            this.executionFinished();
            messageMsg messageMsg2 = new messageMsg();
            messageMsg2.setMessage("Connection to DX broken");
            this.transmit(messageMsg2);
        } else {
            while (stringTokenizer.hasMoreTokens()) {
                String string6 = stringTokenizer.nextToken();
                messageMsg messageMsg3 = new messageMsg();
                messageMsg3.setMessage(string6);
                this.transmit(messageMsg3);
            }
        }
    }

    public static FileStyle Allocator(String string) {
        int n = string.lastIndexOf(46);
        String string2 = string.substring(n + 1);
        if (string2.equals("html")) {
            return new FileStyleHTML(string);
        }
        if (string2.equals("htm")) {
            return new FileStyleHTM(string);
        }
        return new FileStyleANY(string);
    }

    public DXServerThread(Socket socket, int n) {
        super(socket);
        this.java_id = n;
        this.java_dir = null;
        this.url = null;
        this.dxlconnection = new Long(0L);
        this.frame_threads = new Vector(10);
        this.setName("DXServerThread " + n);
        this.shown = new Vector(4);
        try {
            this.actions.addElement(new ServerThreadCommand(this, stopMsg.GetCommand(), 1));
            this.actions.addElement(new ServerThreadCommand(this, execOnceMsg.GetCommand(), 2));
            this.actions.addElement(new ServerThreadCommand(this, stepSeqMsg.GetCommand(), 13));
            this.actions.addElement(new ServerThreadCommand(this, endExecMsg.GetCommand(), 8));
            this.actions.addElement(new ServerThreadCommand(this, sendValueMsg.GetCommand(), 3));
            this.actions.addElement(new ServerThreadCommand(this, loadMsg.GetCommand(), 5));
            this.actions.addElement(new ServerThreadCommand(this, noopMsg.GetCommand(), 12));
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        DXServerThread.ClassInitialize();
        setidMsg setidMsg2 = new setidMsg();
        setidMsg2.setOutputDir(DXServer.getOutputDir());
        setidMsg2.setOutputUrl(DXServer.getOutputUrl());
        setidMsg2.setJavaId(this.getIdDX());
        this.transmit(setidMsg2);
    }

    public static synchronized void ClassInitialize() {
        if (!Initialized) {
            PathFileUsed = null;
            PathFileModified = 0L;
            PathNames = new Vector(20);
            Initialized = true;
            DXServerThread.ReadPathFile();
        }
    }

    public synchronized boolean sendValue(threadMsg threadMsg2) {
        if (this.getConnection() == 0L) {
            return true;
        }
        boolean bl = this.exec_state != 2 && this.exec_state != 0;
        sendValueMsg sendValueMsg2 = (sendValueMsg)threadMsg2;
        if (bl) {
            int n = this.dxlSend(sendValueMsg2.getValue());
            if (n == 0) {
                this.setFailed();
            }
        } else {
            if (this.setvalues == null) {
                this.setvalues = new Vector(20);
            }
            this.setvalues.addElement(threadMsg2);
        }
        return true;
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        if (this.getConnection() != 0L) {
            DXServer.EndConnection(this.getDXLConnection(), this);
        }
        this.dxlconnection = new Long(0L);
        Enumeration enumeration = this.shown.elements();
        while (enumeration.hasMoreElements()) {
            FileStyle fileStyle = (FileStyle)enumeration.nextElement();
            fileStyle.delete();
        }
        this.shown = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean loadProgram(threadMsg threadMsg2) {
        Object object;
        loadMsg loadMsg2 = (loadMsg)threadMsg2;
        String string = loadMsg2.getProgram();
        Object[] objectArray = new String[128];
        Vector vector = PathNames;
        synchronized (vector) {
            PathNames.copyInto(objectArray);
        }
        int n = objectArray.length;
        String string2 = null;
        boolean bl = false;
        for (int i = 0; i < n && objectArray[i] != null; ++i) {
            Object object2 = objectArray[i];
            string2 = ((String)object2).endsWith("/") ? (String)object2 + string : (String)object2 + "/" + string;
            object = new File(string2);
            if (!((File)object).exists() || !((File)object).isFile() || !((File)object).canRead()) continue;
            bl = true;
            break;
        }
        int n2 = 0;
        if (bl) {
            if (this.getConnection() == 0L) {
                this.dxlconnection = DXServer.NewConnection(this, string2);
            }
            if (this.getConnection() == 0L) {
                object = new messageMsg();
                ((messageMsg)object).setMessage("Error: Unable to start Data Explorer");
                this.transmit((threadMsg)object);
                return true;
            }
            object = DXServer.createNet(string2, this);
            DXServer.LockConnection(this);
            n2 = this.DXLLoadVisualProgram(this.getConnection(), (String)object);
            DXServer.UnlockConnection(this);
            if (n2 == 0) {
                messageMsg messageMsg2 = new messageMsg();
                messageMsg2.setMessage("Error: Visual program not loaded: " + string);
                this.transmit(messageMsg2);
            } else {
                String string3 = null;
                if (File.separatorChar == '\\') {
                    String string4 = ((String)object).replace('/', '\\');
                    string3 = new File(string4).getName().replace('\\', '/');
                } else {
                    string3 = new File((String)object).getName();
                }
                int n3 = string3.indexOf(46);
                setmacroMsg setmacroMsg2 = new setmacroMsg();
                setmacroMsg2.setMacroName(string3.substring(0, n3));
                this.transmit(setmacroMsg2);
                this.exec_state = 1;
                if (this.setvalues != null) {
                    Enumeration enumeration = this.setvalues.elements();
                    block4: while (enumeration.hasMoreElements()) {
                        threadMsg threadMsg3 = (threadMsg)enumeration.nextElement();
                        Enumeration enumeration2 = this.actions.elements();
                        while (enumeration2.hasMoreElements()) {
                            ServerThreadCommand serverThreadCommand = (ServerThreadCommand)enumeration2.nextElement();
                            if (!threadMsg3.getCommand().equals(serverThreadCommand.getCommandString())) continue;
                            serverThreadCommand.execute(threadMsg3);
                            continue block4;
                        }
                    }
                    this.setvalues.removeAllElements();
                    this.setvalues = null;
                }
            }
        } else {
            object = new messageMsg();
            ((messageMsg)object).setMessage("Error: Visual program not found: " + string);
            this.transmit((threadMsg)object);
        }
        return true;
    }

    public synchronized boolean checkConnection(threadMsg threadMsg2) {
        boolean bl = true;
        DXServer.LockConnection(this);
        this.DXLHandlePendingMessages(this.getConnection());
        DXServer.UnlockConnection(this);
        return bl;
    }

    private void flushQueue() {
        if (this.getConnection() == 0L) {
            return;
        }
        this.exec_state = 1;
        if (this.setvalues != null) {
            Enumeration enumeration = this.setvalues.elements();
            block0: while (enumeration.hasMoreElements()) {
                threadMsg threadMsg2 = (threadMsg)enumeration.nextElement();
                Enumeration enumeration2 = this.actions.elements();
                while (enumeration2.hasMoreElements()) {
                    ServerThreadCommand serverThreadCommand = (ServerThreadCommand)enumeration2.nextElement();
                    if (!threadMsg2.getCommand().equals(serverThreadCommand.getCommandString())) continue;
                    serverThreadCommand.execute(threadMsg2);
                    continue block0;
                }
            }
            this.setvalues.removeAllElements();
            this.setvalues = null;
        }
    }

    public synchronized boolean stepSequencer(threadMsg threadMsg2) {
        int n = 1;
        if (this.getConnection() == 0L) {
            return true;
        }
        this.flushQueue();
        stepSeqMsg stepSeqMsg2 = (stepSeqMsg)threadMsg2;
        if (n > 0) {
            DXServer.LockConnection(this);
            DXServer.DXLSend(this.getConnection(), stepSeqMsg2.getSequencerParams());
            DXServer.DXLSend(this.getConnection(), stepSeqMsg2.getSequencerFrame());
            n = this.DXLExecuteOnce(this.getConnection(), stepSeqMsg2.getMacroName());
            DXServer.UnlockConnection(this);
        }
        if (n > 0) {
            this.exec_state = 3;
        }
        if (n == 0) {
            this.setFailed();
        }
        this.executionFinished();
        return true;
    }

    public synchronized boolean executeOnce(threadMsg threadMsg2) {
        int n = 1;
        if (this.getConnection() == 0L) {
            return true;
        }
        this.flushQueue();
        execOnceMsg execOnceMsg2 = (execOnceMsg)threadMsg2;
        if (n > 0) {
            DXServer.LockConnection(this);
            n = this.DXLExecuteOnce(this.getConnection(), execOnceMsg2.getMacroName());
            DXServer.UnlockConnection(this);
        }
        if (n > 0) {
            this.exec_state = 3;
        }
        if (n == 0) {
            this.setFailed();
        }
        this.executionFinished();
        return true;
    }

    public synchronized int dxlSend(String string) {
        if (this.getConnection() == 0L) {
            return 1;
        }
        DXServer.LockConnection(this);
        int n = DXServer.DXLSend(this.getConnection(), string);
        DXServer.UnlockConnection(this);
        if (n <= 0) {
            return 0;
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ReadPathFile() {
        boolean bl = false;
        boolean bl2 = false;
        Vector<String> vector = new Vector<String>(5);
        if (PathFileUsed != null) {
            vector.addElement(PathFileUsed);
        }
        vector.addElement(File.separator + "etc" + File.separator + "dxserver.paths");
        vector.addElement("." + File.separator + "dxserver.paths");
        vector.addElement(System.getProperty("DXServer.pathsFile"));
        Vector vector2 = PathNames;
        synchronized (vector2) {
            try {
                Enumeration enumeration = vector.elements();
                while (!bl2 && enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    File file = new File(string);
                    if (!file.exists() || !file.canRead() || !file.isFile()) continue;
                    bl = true;
                    long l = file.lastModified();
                    if (PathFileUsed == null || !PathFileUsed.equals(string) || PathFileModified < l) {
                        String string2;
                        PathNames.removeAllElements();
                        FileReader fileReader = new FileReader(file);
                        BufferedReader bufferedReader = new BufferedReader(fileReader);
                        int n = 0;
                        while (n < 128 && (string2 = bufferedReader.readLine()) != null) {
                            if (string2.startsWith("//") || string2.startsWith("!#") || string2.startsWith("#")) continue;
                            PathNames.addElement(string2);
                            ++n;
                        }
                        PathFileUsed = file.getPath();
                        PathFileModified = l;
                        bl2 = true;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (!bl) {
                PathFileUsed = null;
            }
            if (PathNames.size() == 0) {
                PathNames.addElement(".");
            }
        }
    }

    public int hasEndMsg() {
        boolean bl = false;
        try {
            String string = new endExecMsg().getCommand();
            String string2 = this.peekQueue(string, false);
            if (string2 != null) {
                bl = true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.isFailed()) {
            bl = true;
        }
        return bl ? 1 : 0;
    }

    static {
        Initialized = false;
        boolean bl = true;
        String string = System.getProperty("jx.lib");
        if (string != null) {
            try {
                String string2 = System.getProperty("os.name");
                if (string.length() == 0) {
                    if (string2.equals("AIX")) {
                        string = "../lib_ibm6000/libAnyDX.so";
                    }
                    if (string2.equals("Solaris")) {
                        string = "../lib_solaris/libAnyDX.so";
                    }
                    if (string2.equals("Irix")) {
                        string = "../lib_sgi/libAnyDX.so";
                    }
                }
                if (string.length() != 0) {
                    System.load(string);
                    bl = false;
                }
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                System.out.println(" ");
                System.out.println("DXServer: normal library loading is suppressed because jx.lib is set.");
                System.out.println("However DXServer is unable to load AnyDX shared lib from file " + string);
                System.out.println("Put correct system-dependent path and name in -Djx.lib (startserver script?) ");
                System.out.println("Alternatively remove the jx.lib definition entirely and normal library loading will be the default ");
                System.out.println("We will now try to load the library normally via System.loadLibrary() .");
                bl = true;
            }
        }
        if (bl) {
            try {
                System.loadLibrary("AnyDX");
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                System.out.println("Unable to load AnyDX shared library: is PATH or LD_LIBRARY_PATH correct?");
                System.out.println("Try setting -Djx.lib to the full name including path in startserver script");
                if (System.getProperty("os.name").equals("Irix")) {
                    System.out.println("Irix platform: if library exists then possibly its abi is not -n32 ");
                }
                System.exit(1);
            }
        }
    }
}

