/*
 * Decompiled with CFR 0.152.
 */
package server;

import dx.protocol.threadMsg;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Vector;
import server.DXThreadCommand;

public abstract class DXThread
extends Thread {
    protected Socket clientSocket = null;
    protected Vector actions;
    private BufferedReader is;
    private PrintStream os;
    private Vector msg_queue;
    private boolean failed = false;
    private boolean debug = false;

    protected void setFailed() {
        this.failed = true;
    }

    protected boolean isFailed() {
        return this.failed;
    }

    protected boolean isDebug() {
        return this.debug;
    }

    public void cleanUp() {
    }

    protected DXThread(Socket socket) {
        this.clientSocket = socket;
        try {
            this.is = new BufferedReader(new InputStreamReader(this.clientSocket.getInputStream()));
            this.os = new PrintStream(this.clientSocket.getOutputStream(), false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.is = null;
            this.os = null;
        }
        this.actions = new Vector(20);
        this.msg_queue = new Vector(10);
        String string = this.getClass().getName() + ".debug";
        String string2 = System.getProperty(string);
        this.debug = string2 != null;
        this.failed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getNextString() throws IOException {
        String string = null;
        Vector vector = this.msg_queue;
        synchronized (vector) {
            if (this.getQueueSize() > 0) {
                String string2 = (String)this.msg_queue.firstElement();
                this.msg_queue.removeElementAt(0);
                string = string2;
            } else {
                string = this.is.readLine();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getQueueSize() throws IOException {
        int n = 0;
        Vector vector = this.msg_queue;
        synchronized (vector) {
            while (this.is.ready()) {
                String string = this.is.readLine();
                this.msg_queue.addElement(string);
            }
            n = this.msg_queue.size();
        }
        return n;
    }

    @Override
    public final void run() {
        String string = null;
        try {
            while (!this.failed && (string = this.getNextString()) != null) {
                DXThreadCommand dXThreadCommand;
                if (this.debug) {
                    System.out.println(this.getName() + ": " + string);
                }
                Enumeration enumeration = this.actions.elements();
                boolean bl = false;
                while (!(!enumeration.hasMoreElements() || string.startsWith((dXThreadCommand = (DXThreadCommand)enumeration.nextElement()).getCommandString()) && (bl = dXThreadCommand.execute(string)))) {
                }
                if (bl) continue;
                System.out.println(this.getName() + ": Unrecognized: " + string);
            }
        }
        catch (SocketException socketException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.setFailed();
        }
        this.disconnect();
    }

    protected void transmit(threadMsg threadMsg2) {
        if (this.isDebug()) {
            System.out.println("                                       " + this.getName() + ": " + threadMsg2.toString());
        }
        this.os.println(threadMsg2.toString());
        this.os.flush();
    }

    protected boolean disconnect(threadMsg threadMsg2) {
        this.cleanUp();
        try {
            this.clientSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.is.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.os.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    protected boolean disconnect() {
        return this.disconnect(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String peekQueue(String string, boolean bl) throws IOException {
        String string2 = null;
        Vector vector = this.msg_queue;
        synchronized (vector) {
            if (this.getQueueSize() > 0) {
                Enumeration enumeration = this.msg_queue.elements();
                while (enumeration.hasMoreElements()) {
                    String string3 = (String)enumeration.nextElement();
                    if (!string3.startsWith(string)) continue;
                    string2 = string3;
                    break;
                }
                if (bl) {
                    this.msg_queue.removeElement(string2);
                }
            }
        }
        return string2;
    }
}

