/*
 * Decompiled with CFR 0.152.
 */
import dx.net.DXLinkApplication;
import dx.net.DXLinkHandler;
import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.JApplet;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

public class HTMLDisplay
extends JApplet
implements DXLinkHandler,
HyperlinkListener {
    public static final String CONTENT_PARAM_NAME = "CONTENT-TYPE";
    public static final String CONTENT_TYPE_HTML = "text/html";
    public static final String CONTENT_TYPE_PLAIN = "text/plain";
    public static final String CONTENT_TYPE_RTF = "text/rtf";
    public static final String CONTENT_TYPE_URL = "text/url";
    public static final String[] CONTENT_TYPES = new String[]{"text/html", "text/plain", "text/rtf", "text/url"};
    private HashMap names2index = null;
    private String[] strings = null;
    private JEditorPane pane = null;
    private String contentType = null;
    private boolean doingUrls = false;

    @Override
    public synchronized void init() {
        Color color;
        String string;
        Object object;
        int n = 0;
        this.names2index = new HashMap();
        while ((object = this.getParameter(string = "DXLOutput" + n)) != null) {
            this.names2index.put(object, new Integer(n));
            ++n;
        }
        if (n == 0) {
            return;
        }
        this.strings = new String[n];
        for (int i = 0; i < n; ++i) {
            this.strings[i] = "";
        }
        object = new Font("Helvetica", 1, 14);
        Object object2 = null;
        String string2 = this.getParameter("FONT");
        if (string2 == null || (object2 = Font.decode(string2)) == null) {
            object2 = object;
        }
        this.setFont((Font)object2);
        Color color2 = this.parseColor("BACKGROUND");
        if (color2 != null) {
            this.setBackground(color2);
        }
        if ((color = this.parseColor("FOREGROUND")) != null) {
            this.setForeground(color);
        }
        this.contentType = CONTENT_TYPE_HTML;
        this.doingUrls = false;
        String string3 = this.getParameter(CONTENT_PARAM_NAME);
        if (string3 != null) {
            int n2;
            string3 = string3.toLowerCase();
            for (n2 = 0; n2 < CONTENT_TYPES.length; ++n2) {
                if (!string3.equals(CONTENT_TYPES[n2])) continue;
                this.contentType = CONTENT_TYPES[n2];
                break;
            }
            if (n2 >= CONTENT_TYPES.length) {
                this.contentType = CONTENT_TYPE_PLAIN;
                System.err.println("WARNING: Unknown content-type: " + string3 + ".  Defaulting to: " + this.contentType + ".");
            }
        }
        if (this.contentType == CONTENT_TYPE_URL) {
            this.contentType = CONTENT_TYPE_HTML;
            this.doingUrls = true;
        }
        this.pane = new JEditorPane();
        this.pane.setContentType(this.contentType);
        if (color != null) {
            this.pane.setForeground(color);
        }
        if (color2 != null) {
            this.pane.setBackground(color2);
        }
        this.pane.setEditable(false);
        if (this.contentType == CONTENT_TYPE_HTML) {
            this.pane.addHyperlinkListener(this);
        }
        JScrollPane jScrollPane = new JScrollPane(this.pane);
        jScrollPane.setPreferredSize(new Dimension(640, 480));
        jScrollPane.setMinimumSize(new Dimension(10, 10));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jScrollPane, "Center");
    }

    @Override
    public void outputHandler(String string, String string2, Object object) {
        try {
            Integer n = (Integer)this.names2index.get(string);
            if (n == null) {
                return;
            }
            int n2 = n;
            this.strings[n2] = string2;
            if (this.doingUrls) {
                this.loadURL(n2);
            }
            this.display();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    private DXLinkApplication findDXLinkApplication() {
        AppletContext appletContext = this.getAppletContext();
        Enumeration<Applet> enumeration = appletContext.getApplets();
        while (enumeration.hasMoreElements()) {
            Applet applet = enumeration.nextElement();
            if (!(applet instanceof DXLinkApplication)) continue;
            return (DXLinkApplication)applet;
        }
        throw new RuntimeException("No DXLinkApplication in applet context.");
    }

    private void display() {
        if (this.pane == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.strings.length; ++i) {
            stringBuffer.append(this.strings[i]);
        }
        this.pane.setDocument(this.pane.getEditorKit().createDefaultDocument());
        this.pane.setText(stringBuffer.toString());
    }

    private void loadURL(int n) {
        String string = this.strings[n];
        String[] stringArray = string.split("[ \t]+");
        URL uRL = null;
        String string2 = null;
        try {
            uRL = new URL(stringArray[0]);
            if (stringArray.length >= 2) {
                string2 = stringArray[1];
            }
            this.strings[n] = this.strings[n] + "<BR>";
        }
        catch (Exception exception) {
            System.err.println("URL string: " + stringArray[0]);
            exception.printStackTrace();
            return;
        }
        AppletContext appletContext = this.getAppletContext();
        if (string2 == null) {
            appletContext.showDocument(uRL);
        } else {
            appletContext.showDocument(uRL, string2);
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            JEditorPane jEditorPane = (JEditorPane)hyperlinkEvent.getSource();
            if (hyperlinkEvent instanceof HTMLFrameHyperlinkEvent) {
                System.err.println("Warning: frames support not verified. This might not work...");
                HTMLFrameHyperlinkEvent hTMLFrameHyperlinkEvent = (HTMLFrameHyperlinkEvent)hyperlinkEvent;
                HTMLDocument hTMLDocument = (HTMLDocument)jEditorPane.getDocument();
                hTMLDocument.processHTMLFrameHyperlinkEvent(hTMLFrameHyperlinkEvent);
            } else {
                try {
                    URL uRL = hyperlinkEvent.getURL();
                    if ((uRL.getAuthority() == null || uRL.getAuthority().equals("")) && uRL.getHost().equals("") && uRL.getFile().equals("")) {
                        String string = uRL.getRef();
                        this.findDXLinkApplication().DXLSend(string);
                        return;
                    }
                    String string = null;
                    AttributeSet attributeSet = hyperlinkEvent.getSourceElement().getAttributes();
                    if ((attributeSet = (AttributeSet)attributeSet.getAttribute(HTML.Tag.A)) == null) {
                        System.err.println("Sorry, only A tags supported for hyperlinking.");
                        return;
                    }
                    if (uRL == null) {
                        String string2 = (String)attributeSet.getAttribute(HTML.Attribute.HREF);
                        uRL = new URL(this.getDocumentBase(), string2);
                    }
                    if ((string = (String)attributeSet.getAttribute(HTML.Attribute.TARGET)) == null) {
                        this.getAppletContext().showDocument(uRL);
                    } else {
                        this.getAppletContext().showDocument(uRL, string);
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
    }

    @Override
    public synchronized boolean hasHandler(String string) {
        boolean bl = this.names2index.containsKey(string);
        return bl;
    }

    private Color parseColor(String string) {
        Color color = null;
        String string2 = this.getParameter(string);
        if (string2 == null) {
            return null;
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "[, ]");
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            String string5 = stringTokenizer.nextToken();
            float f = Float.valueOf(string3).floatValue();
            float f2 = Float.valueOf(string4).floatValue();
            float f3 = Float.valueOf(string5).floatValue();
            color = new Color(f, f2, f3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return color;
    }

    private void debug(Object object) {
        System.err.println(object.toString());
    }
}

