/*
 * Decompiled with CFR 0.152.
 */
package dx.client;

import dx.client.AppletLoadThread;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class AppletClient
extends Applet {
    private Image current_image = null;
    private Vector fclts = new Vector(4);
    private String gifname = null;
    private String mostRecentUrl = null;
    private int current_iteration = 0;
    private int current_sequence;
    private boolean initial_loading;

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    protected Image getCurrentImage() {
        return this.current_image;
    }

    protected int getCurrentSequence() {
        return this.current_sequence;
    }

    protected int getCurrentLoop() {
        return this.current_iteration;
    }

    protected boolean getImageHandling() {
        return true;
    }

    protected boolean getIsEmbedded() {
        return false;
    }

    protected int getNextIter(int n) {
        return n + 1;
    }

    protected boolean loadNextImage() {
        return this.initial_loading;
    }

    protected boolean isLoopValid(String string, int n, int n2) {
        if (n < this.current_sequence) {
            return false;
        }
        if (n > this.current_sequence) {
            return true;
        }
        return n2 >= this.current_iteration;
    }

    protected synchronized void setCurrentImage(Image image, int n, int n2) {
        this.current_image = image;
        this.current_sequence = n;
        this.current_iteration = n2;
    }

    protected String getImageUrl() {
        return this.mostRecentUrl;
    }

    protected AppletClient() {
    }

    @Override
    public void init() {
        super.init();
        this.fclts.removeAllElements();
        this.gifname = this.getParameter("INITIAL_IMAGE");
        this.initial_loading = true;
        if (!this.getIsEmbedded()) {
            this.current_sequence = 0;
            if (this.getLoopCount(this.gifname) > 0) {
                String string = this.getImageName(this.gifname, 0);
                this.requestImage(string, 0, 0);
            } else {
                this.requestImage(this.gifname, 0, 0);
            }
            this.repaint();
        }
    }

    @Override
    public void stop() {
        super.stop();
        Enumeration enumeration = this.fclts.elements();
        while (enumeration.hasMoreElements()) {
            AppletLoadThread appletLoadThread = (AppletLoadThread)enumeration.nextElement();
            if (appletLoadThread == null || !appletLoadThread.isAlive()) continue;
            appletLoadThread.interrupt();
        }
        this.fclts.removeAllElements();
    }

    public synchronized void imageAvailable(Image image, String string, int n, int n2, String string2) {
        if (!this.isLoopValid(string, n, n2)) {
            return;
        }
        if (image != null) {
            Object object;
            if (this.loadNextImage()) {
                int n3 = this.getNextIter(n2);
                object = this.getImageName(string, n3);
                this.requestImage((String)object, n, n3);
            }
            if (n > this.current_sequence) {
                AppletLoadThread appletLoadThread;
                Enumeration enumeration = this.fclts.elements();
                object = new Vector(4);
                while (enumeration.hasMoreElements()) {
                    appletLoadThread = (AppletLoadThread)enumeration.nextElement();
                    if (appletLoadThread != null && appletLoadThread.getSequence() < n) {
                        if (appletLoadThread.isAlive()) {
                            appletLoadThread.interrupt();
                        }
                        ((Vector)object).addElement(appletLoadThread);
                        continue;
                    }
                    if (appletLoadThread == null || appletLoadThread.isAlive()) continue;
                    ((Vector)object).addElement(appletLoadThread);
                }
                enumeration = ((Vector)object).elements();
                while (enumeration.hasMoreElements()) {
                    appletLoadThread = (AppletLoadThread)enumeration.nextElement();
                    this.fclts.removeElement(appletLoadThread);
                }
            }
            this.mostRecentUrl = string2;
            this.setCurrentImage(image, n, n2);
        } else if (!this.initial_loading) {
            System.out.println("AppletClient: couldn't load " + string);
        } else {
            this.initial_loading = false;
            this.current_sequence = -1;
        }
        if (image != null) {
            this.repaint();
        }
    }

    protected void requestImage(String string, int n, int n2) {
        AppletLoadThread appletLoadThread = new AppletLoadThread(this, string, n, n2);
        appletLoadThread.start();
        this.fclts.addElement(appletLoadThread);
    }

    protected void requestImage(String string) {
        int n = this.getSequenceCount(string);
        int n2 = this.getLoopCount(string);
        this.requestImage(string, n, n2);
    }

    @Override
    public void paint(Graphics graphics) {
        if (!this.getIsEmbedded()) {
            Dimension dimension = this.getSize();
            if (this.getCurrentImage() == null) {
                graphics.setColor(Color.black);
                graphics.fillRect(0, 0, dimension.width, dimension.height);
            } else {
                Image image = this.getCurrentImage();
                graphics.drawImage(image, 0, 0, dimension.width, dimension.height, Color.black, this);
            }
        }
    }

    protected int getLoopCount(String string) {
        int n = string.lastIndexOf(47);
        String string2 = n >= 0 ? string.substring(n + 1) : string;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ".");
        int n2 = 0;
        boolean bl = false;
        int n3 = 0;
        boolean bl2 = false;
        while (!bl2 && !bl && stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            switch (n3) {
                case 0: {
                    break;
                }
                case 1: {
                    Integer n4;
                    try {
                        n4 = new Integer(string3);
                        int n5 = n4;
                    }
                    catch (Exception exception) {
                        bl2 = true;
                    }
                    break;
                }
                case 2: {
                    Integer n4;
                    try {
                        n4 = new Integer(string3);
                        n2 = n4;
                        bl = true;
                    }
                    catch (Exception exception) {
                        bl2 = true;
                    }
                    break;
                }
                default: {
                    bl2 = true;
                }
            }
            ++n3;
        }
        if (bl) {
            return n2;
        }
        this.initial_loading = false;
        return -1;
    }

    protected int getSequenceCount(String string) {
        int n = string.lastIndexOf(47);
        String string2 = n >= 0 ? string.substring(n + 1) : string;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ".");
        int n2 = 0;
        boolean bl = false;
        int n3 = 0;
        boolean bl2 = false;
        while (!bl2 && !bl && stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            switch (n3) {
                case 0: {
                    break;
                }
                case 1: {
                    try {
                        Integer n4 = new Integer(string3);
                        n2 = n4;
                        bl = true;
                    }
                    catch (Exception exception) {
                        bl2 = true;
                    }
                    break;
                }
                default: {
                    bl2 = true;
                }
            }
            ++n3;
        }
        if (bl) {
            return n2;
        }
        this.initial_loading = false;
        return -1;
    }

    protected String getImageName(String string, int n) {
        String string2;
        String string3;
        int n2 = this.getLoopCount(string);
        int n3 = string.lastIndexOf(47);
        if (n3 >= 0) {
            string3 = string.substring(n3 + 1);
            string2 = string.substring(0, n3 + 1);
        } else {
            string3 = string;
            string2 = null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3, ".");
        boolean bl = false;
        int n4 = 0;
        boolean bl2 = false;
        while (!bl2 && !bl && stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            switch (n4) {
                case 0: {
                    if (string2 == null) {
                        string2 = string4;
                        break;
                    }
                    string2 = string2 + string4;
                    break;
                }
                case 1: {
                    string2 = string2 + "." + string4;
                    break;
                }
                case 2: {
                    string2 = string2 + "." + n;
                    break;
                }
                default: {
                    string2 = string2 + "." + string4;
                }
            }
            ++n4;
        }
        return string2;
    }
}

