/*
 * Decompiled with CFR 0.152.
 */
package dx.client;

import dx.client.DXClientThread;
import dx.client.StopThread;
import dx.protocol.server.serverMsg;
import dx.protocol.server.serverVersionMsg;
import java.applet.Applet;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.Socket;
import java.util.StringTokenizer;

public abstract class DXClient
extends Applet {
    private StopThread stoptr = null;
    private DXClientThread extr = null;
    private Socket dxSocket = null;
    protected PrintStream os;
    protected BufferedReader is;
    private int ServerMajor = 0;
    private int ServerMinor = 0;
    private int ServerMicro = 0;
    protected static final int MajorVersion = 2;
    protected static final int MinorVersion = 0;
    protected static final int MicroVersion = 0;
    protected static final String version_string = "2.0.0";
    protected static final String formal_version_string = "IBM Visualization Data Explorer / Java Explorer version 2.0.0";

    protected abstract DXClientThread createCommandThread();

    protected int getPort() {
        return 4655;
    }

    protected abstract serverMsg getRequest();

    public boolean isConnected() {
        if (this.dxSocket != null && this.os.checkError()) {
            this.dxSocket = null;
            this.disconnect(null);
        }
        return this.dxSocket != null;
    }

    protected DXClient() {
    }

    @Override
    public void init() {
        this.disconnect(null);
        try {
            String string = this.getParameter("BACKGROUND");
            if (string != null) {
                float f;
                float f2;
                StringTokenizer stringTokenizer = new StringTokenizer(string, "[, ]");
                String string2 = stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                String string4 = stringTokenizer.nextToken();
                float f3 = Float.valueOf(string2).floatValue();
                Color color = new Color(f3, f2 = Float.valueOf(string3).floatValue(), f = Float.valueOf(string4).floatValue());
                if (color != null) {
                    this.setBackground(color);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void destroy() {
        this.disconnect(null);
    }

    protected void disconnect(Thread thread) {
        try {
            if (this.dxSocket != null) {
                this.dxSocket.close();
            }
            if (this.os != null) {
                this.os.close();
            }
            if (this.is != null) {
                this.is.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.dxSocket = null;
        this.os = null;
        this.is = null;
        if (this.extr != null && this.extr.isAlive() && this.extr != thread) {
            this.extr.interrupt();
        }
        if (this.stoptr != null && this.stoptr.isAlive() && this.stoptr != thread) {
            this.stoptr.interrupt();
        }
        this.stoptr = null;
        if (thread != null && thread.isAlive()) {
            thread.interrupt();
        }
    }

    public void interrupt() {
        if (this.stoptr != null && this.stoptr.isAlive()) {
            this.stoptr.interrupt();
        }
        this.stoptr = new StopThread(this);
        this.stoptr.start();
    }

    @Override
    public void start() {
        if (this.stoptr != null && this.stoptr.isAlive()) {
            this.stoptr.interrupt();
        }
        this.stoptr = null;
        if (!this.isConnected()) {
            this.connect();
        }
    }

    protected void connect() {
        String string = this.getDocumentBase().getHost();
        try {
            this.dxSocket = new Socket(string, this.getPort());
            this.os = new PrintStream(this.dxSocket.getOutputStream());
            this.is = new BufferedReader(new InputStreamReader(this.dxSocket.getInputStream()));
            serverMsg serverMsg2 = this.getRequest();
            this.send(serverMsg2.toString() + "," + version_string);
            String string2 = this.is.readLine();
            if (!this.versionMatch(string2)) {
                System.out.println("ERROR: IBM Visualization Data Explorer / Java Explorer version 2.0.0 is incompatible with server " + string2);
                this.disconnect(null);
            }
        }
        catch (Exception exception) {
            System.err.println("DXClient: Couldn't get I/O for " + string);
            this.dxSocket = null;
            this.os = null;
            this.is = null;
        }
        if (this.isConnected()) {
            this.extr = this.createCommandThread();
        }
    }

    protected boolean send(String string) {
        boolean bl = this.isConnected();
        if (this.isConnected()) {
            try {
                this.os.println(string);
                this.os.flush();
            }
            catch (Exception exception) {
                this.dxSocket = null;
                this.disconnect(null);
                bl = false;
            }
        }
        return bl;
    }

    protected boolean versionMatch(String string) {
        boolean bl = false;
        serverVersionMsg serverVersionMsg2 = new serverVersionMsg(string);
        this.ServerMajor = serverVersionMsg2.getMajor();
        this.ServerMinor = serverVersionMsg2.getMinor();
        this.ServerMicro = serverVersionMsg2.getMicro();
        if (this.ServerMajor >= 2 && this.ServerMinor >= 0) {
            bl = true;
        }
        if (bl && this.ServerMicro < 0) {
            System.out.println("WARNING: Server is a earlier version.");
        }
        return bl;
    }
}

