/*
 * Decompiled with CFR 0.152.
 */
package dx.net;

import dx.net.InteractorNode;
import dx.net.Network;
import dx.runtime.Interactor;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Panel;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;

public class ControlPanel
extends Panel {
    private Network net;
    private String name;
    private int instance;
    private Vector interactors;
    private Vector decorators;
    private Dimension size = new Dimension(0, 0);

    public ControlPanel(Network network, String string, int n) {
        this.name = string == null ? "ControlPanel " + n : string;
        this.instance = n;
        this.net = network;
        this.interactors = null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public synchronized void addInteractor(Interactor interactor) {
        if (this.interactors == null) {
            this.interactors = new Vector(4);
        }
        this.interactors.addElement(interactor);
    }

    public synchronized void addDecorator(Component component) {
        if (this.decorators == null) {
            this.decorators = new Vector(4);
        }
        this.decorators.addElement(component);
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.size.width > 0 || this.size.height > 0) {
            return this.size;
        }
        if (this.getLayout() == null) {
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Rectangle rectangle = this.getComponent(i).getBounds();
                n = Math.max(n, rectangle.x + rectangle.width);
                n2 = Math.max(n2, rectangle.y + rectangle.height);
            }
            return new Dimension(n, n2);
        }
        return super.getMinimumSize();
    }

    @Override
    public void setSize(Dimension dimension) {
        this.size = dimension;
    }

    @Override
    public Dimension getSize() {
        return this.getMinimumSize();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.size.width > 0 || this.size.height > 0) {
            return this.size;
        }
        if (this.getLayout() == null) {
            return this.getMinimumSize();
        }
        return super.getPreferredSize();
    }

    public synchronized void buildPanel() {
        Component component;
        Enumeration enumeration;
        this.setLayout(null);
        if (this.interactors != null) {
            enumeration = this.interactors.elements();
            while (enumeration.hasMoreElements()) {
                component = (Interactor)enumeration.nextElement();
                component.init();
                InteractorNode interactorNode = (InteractorNode)component.getNode();
                interactorNode.installValues((Interactor)component);
                this.add(component);
            }
        }
        if (this.decorators != null) {
            enumeration = this.decorators.elements();
            while (enumeration.hasMoreElements()) {
                component = (Component)enumeration.nextElement();
                this.add(component);
            }
        }
    }
}

