/*
 * Decompiled with CFR 0.152.
 */
package dx.net;

import dx.client.DXClient;
import dx.net.ControlPanel;
import dx.net.ImageNode;
import dx.net.ImageWindow;
import dx.net.Network;
import dx.net.Node;
import dx.net.PickNode;
import dx.net.SequencerNode;
import dx.net.TabbedPanel;
import dx.runtime.Separator;
import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import layout.TableLayout;

public abstract class DXApplication
extends DXClient
implements KeyListener,
ActionListener,
ItemListener {
    private boolean makesGui = true;
    private boolean shadows = true;
    private boolean eocMode = false;
    private String bwcompat_string = null;
    private boolean bwcompat_checked = false;
    protected boolean cachingMode = false;
    protected Network network = null;
    protected Button execute_once = null;
    protected Button end_execution = null;
    protected Button connect_btn = null;
    protected Checkbox exec_on_change = null;
    protected Checkbox set_caching = null;
    protected TextField cache_size = null;
    protected Choice cache_options = null;
    protected Label speed_label;
    private Vector imageWindows = new Vector(4);
    private Vector named_image_list = null;
    private Vector panels = null;
    private int selected_panel = 0;
    private TabbedPanel cardPanel = null;
    private TabbedPanel tabPanel = null;
    private CheckboxGroup selector = null;
    private static final int SHADOW = 8;
    private ControlPanel execCtrl = null;
    private Node sequencer = null;
    private boolean in_connect_callback;
    private boolean dirty = false;
    private String macro_name = null;
    private Panel executing = null;
    private int[] modes = new int[10];
    private int sequence_mode_choice = -1;
    private Choice image_chooser;
    private ImageNode selected_image;
    private Choice pick_chooser = null;
    private PickNode selected_pick = null;
    private Choice mode_chooser = null;
    private Choice view_chooser = null;
    private int selected_mode = 0;

    public void setMakesGui(boolean bl) {
        this.makesGui = bl;
    }

    public boolean getMakesGui() {
        return this.makesGui;
    }

    public ImageNode getSelectedImageNode() {
        return this.selected_image;
    }

    public PickNode getSelectedPickNode() {
        return this.selected_pick;
    }

    public boolean getCachingFeaturesEnabled() {
        return this.cache_size != null;
    }

    protected SequencerNode getSequencerNode() {
        return (SequencerNode)this.sequencer;
    }

    protected DXApplication() {
    }

    public String getMacroName() {
        return this.macro_name;
    }

    public void setNetwork(Network network) {
        Object object;
        Object object2;
        this.network = network;
        network.setApplet(this);
        Vector vector = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("dx.net.ImageNode");
        }
        catch (Exception exception) {
            System.out.println("DXApplication: failed to list ImageNodes");
        }
        if (clazz != null) {
            vector = this.network.makeNodeList(clazz, false);
        }
        this.named_image_list = null;
        if (vector != null && vector.size() > 0) {
            object2 = vector.elements();
            while (object2.hasMoreElements()) {
                object = (ImageNode)object2.nextElement();
                String string = ((ImageNode)object).getTitle();
                boolean bl = ((ImageNode)object).isInteractionModeConnected();
                if (string == null) continue;
                this.selected_image = object;
                if (bl) continue;
                if (this.named_image_list == null) {
                    this.named_image_list = new Vector(4);
                }
                this.named_image_list.addElement(object);
            }
        }
        object2 = null;
        try {
            object2 = Class.forName("dx.net.SequencerNode");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        object = this.network.makeNodeList((Class)object2, false);
        if (object != null && ((Vector)object).size() >= 1) {
            this.sequencer = (Node)((Vector)object).elementAt(0);
        }
    }

    @Override
    public void start() {
        super.start();
        if (this.getMakesGui() && this.network != null) {
            Dimension dimension = this.getSize();
            int n = this.shadows ? 8 : 0;
            int n2 = dimension.width - (2 + n);
        }
        if (this.executing != null) {
            this.executing.setVisible(false);
        }
    }

    @Override
    public void init() {
        Object object;
        Object object2;
        Serializable serializable;
        Serializable serializable2;
        Component component;
        Object object3;
        Serializable serializable3;
        Serializable serializable4;
        this.addKeyListener(this);
        boolean bl = false;
        super.init();
        this.setFont(new Font("Default", 0, 10));
        int n = this.shadows ? 8 : 0;
        double d = 5.0;
        double d2 = -2.0;
        double d3 = -1.0;
        double[][] dArrayArray = new double[][]{{0.5, 0.5}, {d2, d2, d2, d2, d2, d2, d2, d2, d2, d3}};
        TableLayout tableLayout = new TableLayout(dArrayArray);
        if (this.network != null) {
            if (this.getMakesGui()) {
                Dimension dimension = this.getSize();
                int n2 = dimension.width - (2 + n);
            }
            return;
        }
        this.network = new Network();
        this.readNetwork();
        this.setNetwork(this.network);
        if (!this.getMakesGui()) {
            return;
        }
        Dimension dimension = this.getSize();
        int n3 = this.network.getPanelCount();
        this.cardPanel = new TabbedPanel();
        this.add(this.cardPanel);
        for (int i = 0; i < n3; ++i) {
            serializable4 = this.network.getPanel(i);
            serializable4.buildPanel();
            this.cardPanel.addPanel((Panel)serializable4, serializable4.getName());
        }
        this.execCtrl = new ControlPanel(this.network, "Execution", this.network.getPanelCount() + 1);
        this.execCtrl.buildPanel();
        this.execCtrl.setLayout(tableLayout);
        this.cardPanel.addPanel(this.execCtrl, this.execCtrl.getName());
        serializable4 = this.cardPanel.getSize();
        ((Dimension)serializable4).height = dimension.height - (47 + n + this.cardPanel.getInsets().top + this.cardPanel.getInsets().bottom);
        ((Dimension)serializable4).width = dimension.width - (20 + n + this.cardPanel.getInsets().left + this.cardPanel.getInsets().right);
        ((Dimension)serializable4).width = ((Dimension)serializable4).width > 400 ? 400 : ((Dimension)serializable4).width;
        this.execCtrl.setSize(new Dimension(((Dimension)serializable4).width, ((Dimension)serializable4).height));
        this.executing = new Panel();
        Label label = new Label("Running, Please Wait ...");
        label.setFont(new Font("Helvetica", 2, 12));
        label.setForeground(new Color(0.0f, 1.0f, 0.49f));
        this.executing.add(label);
        this.executing.setLocation(dimension.height + 5, 60);
        this.add(this.executing);
        this.executing.setVisible(true);
        String string = this.getParameter("CONNECT_OPTION");
        boolean bl2 = false;
        if (string != null) {
            bl2 = Boolean.valueOf(string);
        }
        if (bl2) {
            this.connect_btn = new Button("Connect");
            this.connect_btn.setBackground(this.getBackground());
            this.execCtrl.add((Component)this.connect_btn, "0, 0, 1, 0");
            this.connect_btn.addActionListener(this);
            serializable3 = new Separator();
            ((Separator)serializable3).setForeground(new Color(200, 200, 200));
            ((Separator)serializable3).setSize(new Dimension(((Dimension)serializable4).width - 20, 2));
            this.execCtrl.add((Component)serializable3, "0, 1, 1, 1, c, c");
        }
        serializable3 = new FlowLayout(1, 5, 0);
        String string2 = this.getParameter("EXECUTE_ON_CHANGE");
        this.eocMode = string2 != null ? Boolean.valueOf(string2) : false;
        this.exec_on_change = new Checkbox("Execute On Change");
        this.exec_on_change.setBackground(this.getBackground());
        this.exec_on_change.setState(this.eocMode);
        this.execCtrl.add((Component)this.exec_on_change, "0, 2, 1, 2, c, c");
        this.exec_on_change.addItemListener(this);
        this.execute_once = new Button("Execute Once");
        this.execute_once.setBackground(this.getBackground());
        this.execCtrl.add((Component)this.execute_once, "0, 3, c, c");
        this.execute_once.addActionListener(this);
        this.end_execution = new Button("End Execution");
        this.end_execution.setBackground(this.getBackground());
        this.execCtrl.add((Component)this.end_execution, "1, 3, c, c");
        this.end_execution.addActionListener(this);
        Separator separator = new Separator();
        separator.setForeground(new Color(200, 200, 200));
        separator.setSize(new Dimension(((Dimension)serializable4).width - 20, 2));
        this.execCtrl.add((Component)separator, "0, 4, 1, 4, c, c");
        this.setCachingMode(false, false);
        String string3 = this.getParameter("CACHING_FEATURES");
        boolean bl3 = false;
        if (string3 != null) {
            bl3 = Boolean.valueOf(string3);
        }
        if (bl3 || this.sequencer != null) {
            this.set_caching = new Checkbox("Enable Animation");
            this.set_caching.setState(this.getCachingMode());
            this.set_caching.setBackground(this.getBackground());
            this.execCtrl.add((Component)this.set_caching, "0, 5, 1, 5, c, c");
            this.set_caching.addItemListener(this);
            this.cache_options = new Choice();
            this.cache_options.setBackground(this.getBackground());
            this.cache_options.addItem("Loop");
            this.cache_options.addItem("Palindrome");
            this.cache_options.addItem("Faster");
            this.cache_options.addItem("Slower");
            this.cache_options.addItem("Reset");
            this.execCtrl.add((Component)this.cache_options, "0, 6, c, c");
            this.cache_options.setEnabled(this.getCachingMode());
            this.cache_options.addItemListener(this);
            object3 = new Panel();
            ((Container)object3).setLayout((LayoutManager)((Object)serializable3));
            component = new Label("Frames:");
            ((Label)component).setAlignment(2);
            ((Container)object3).add(component);
            this.cache_size = new TextField("0", 4);
            this.cache_size.setBackground(this.getBackground());
            ((Container)object3).add(this.cache_size);
            this.cache_size.setEnabled(this.getCachingMode());
            this.execCtrl.add((Component)object3, "1, 6, c, c");
            this.cache_size.addActionListener(this);
            this.cache_size.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                    char c = keyEvent.getKeyChar();
                    if (!Character.isDigit(c) && c != '\b' && c != '\u007f' && c != '\n' && c != '\u001e') {
                        keyEvent.consume();
                    }
                }

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    char c = keyEvent.getKeyChar();
                    if (!Character.isDigit(c) && c != '\b' && c != '\u007f' && c != '\n' && c != '\u001e') {
                        keyEvent.consume();
                    }
                }
            });
            serializable2 = new Separator();
            ((Separator)serializable2).setForeground(new Color(200, 200, 200));
            ((Separator)serializable2).setSize(new Dimension(((Dimension)serializable4).width - 20, 2));
            this.execCtrl.add((Component)serializable2, "0, 7, 1, 7, c, c");
        }
        object3 = new double[][]{{75.0, d3}, {d2, d2, d2, d2, d3}};
        component = new Panel();
        serializable2 = new TableLayout((double[][])object3);
        ((Container)component).setLayout((LayoutManager)((Object)serializable2));
        if (this.named_image_list != null && this.named_image_list.size() > 1) {
            serializable = new Label("Image: ");
            ((Label)serializable).setAlignment(2);
            ((Container)component).add((Component)serializable, "0, 0, r, c");
            this.image_chooser = new Choice();
            this.image_chooser.setBackground(this.getBackground());
            object2 = this.named_image_list.elements();
            while (object2.hasMoreElements()) {
                object = (ImageNode)object2.nextElement();
                String string4 = ((ImageNode)object).getTitle();
                this.image_chooser.addItem(string4);
            }
            this.image_chooser.addItemListener(this);
            this.image_chooser.select(0);
            this.selected_image = (ImageNode)this.named_image_list.elementAt(0);
            ((Container)component).add(this.image_chooser, "1, 0, l, c");
        }
        serializable = null;
        object2 = null;
        try {
            object2 = Class.forName("dx.net.PickNode");
        }
        catch (Exception exception) {
            System.out.println("DXApplication: failed to list PickNodes");
        }
        if (object2 != null) {
            serializable = this.network.makeNodeList((Class)object2, false);
        }
        if (this.named_image_list != null && this.named_image_list.size() > 0) {
            object = new Label("View: ");
            ((Label)object).setAlignment(2);
            ((Container)component).add((Component)object, "0, 1, r, c");
            this.view_chooser = new Choice();
            this.view_chooser.setBackground(this.getBackground());
            this.view_chooser.addItem("Front");
            this.view_chooser.addItem("Back");
            this.view_chooser.addItem("Top");
            this.view_chooser.addItem("Bottom");
            this.view_chooser.addItem("Right");
            this.view_chooser.addItem("Left");
            this.view_chooser.addItem("Diagonal");
            this.view_chooser.addItem("Off Front");
            this.view_chooser.addItem("Off Back");
            this.view_chooser.addItem("Off Top");
            this.view_chooser.addItem("Off Bottom");
            this.view_chooser.addItem("Off Right");
            this.view_chooser.addItem("Off Left");
            this.view_chooser.addItem("Off Diagonal");
            this.view_chooser.addItemListener(this);
            ((Container)component).add(this.view_chooser, "1, 1, l, c");
            object = new Label("Mode: ");
            ((Label)object).setAlignment(2);
            ((Container)component).add((Component)object, "0, 2, r, c");
            int n4 = 0;
            this.mode_chooser = new Choice();
            this.mode_chooser.setBackground(this.getBackground());
            this.mode_chooser.addItem("(None)");
            this.modes[n4++] = 0;
            this.mode_chooser.addItem("Rotate");
            this.modes[n4++] = 1;
            if (serializable != null) {
                this.mode_chooser.addItem("Pick");
                this.modes[n4++] = 6;
            }
            this.mode_chooser.addItem("Pan");
            this.modes[n4++] = 3;
            this.mode_chooser.addItem("Zoom");
            this.modes[n4++] = 4;
            this.mode_chooser.addItem("Orbit");
            this.modes[n4++] = 2;
            this.mode_chooser.addItem("Reset Camera");
            this.modes[n4++] = 7;
            if (this.sequencer != null) {
                this.sequence_mode_choice = n4;
                this.mode_chooser.addItem("Sequence");
                this.modes[n4++] = 5;
            } else if (bl3) {
                this.mode_chooser.addItem("Review");
                this.modes[n4++] = 5;
            }
            this.mode_chooser.addItemListener(this);
            if (this.selected_image != null) {
                this.selected_mode = this.selected_image.getInteractionMode();
                this.mode_chooser.select(this.selected_mode);
            } else {
                this.mode_chooser.select(0);
                this.selected_mode = 0;
            }
            ((Container)component).add(this.mode_chooser, "1, 2, l, c");
        }
        this.pick_chooser = null;
        if (serializable != null && ((Vector)serializable).size() == 1) {
            this.selected_pick = (PickNode)((Vector)serializable).elementAt(0);
        } else if (serializable != null && ((Vector)serializable).size() > 1) {
            object = new Label("Pick: ");
            ((Label)object).setAlignment(2);
            ((Container)component).add((Component)object, "0, 3, r, c");
            this.pick_chooser = new Choice();
            this.pick_chooser.setBackground(this.getBackground());
            Enumeration enumeration = ((Vector)serializable).elements();
            while (enumeration.hasMoreElements()) {
                PickNode pickNode = (PickNode)enumeration.nextElement();
                String string5 = pickNode.getName() + "_" + pickNode.getInstanceNumber();
                this.pick_chooser.addItem(string5);
            }
            this.pick_chooser.setEnabled(false);
            this.pick_chooser.select(0);
            this.pick_chooser.addItemListener(this);
            this.selected_pick = (PickNode)((Vector)serializable).elementAt(0);
            ((Container)component).add(this.pick_chooser, "1, 3, l, c");
        }
        this.execCtrl.add(component, "0, 8, 1, 8, l, c");
        object = this.getParameter("SHADOWS");
        if (object != null) {
            this.shadows = Boolean.valueOf((String)object);
        }
    }

    public void setJavaId(int n) {
    }

    public void setMacroName(String string) {
        String string2;
        this.macro_name = string;
        if (this.isConnected()) {
            boolean bl = this.eocMode;
            this.setEocMode(false);
            Enumeration enumeration = this.network.elements();
            while (enumeration.hasMoreElements()) {
                Node node = (Node)enumeration.nextElement();
                node.enableJava();
            }
            this.DXLSend("_java_control=1;");
            this.locateImageWindows();
            enumeration = this.imageWindows.elements();
            int n = -1;
            while (enumeration.hasMoreElements()) {
                Vector vector;
                ImageWindow imageWindow2 = (ImageWindow)enumeration.nextElement();
                ++n;
                String string3 = imageWindow2.getInitialNodeName(this.network);
                if (string3 == null || (vector = this.network.makeNodeList(string3)) == null || vector.size() != 1) continue;
                ImageNode imageNode = (ImageNode)vector.elementAt(0);
                imageNode.associate(imageWindow2, n);
            }
            this.setEocMode(bl);
        }
        if ((string2 = this.getParameter("DXLInput")) != null) {
            this.DXLSend(string2);
        }
        this.setEnabled(true);
    }

    @Override
    protected void connect() {
        boolean bl = this.isConnected();
        if (this.connect_btn == null || this.in_connect_callback) {
            this.in_connect_callback = false;
            super.connect();
        }
        if (this.connect_btn != null && this.isConnected()) {
            this.connect_btn.setLabel("Disconnect");
        }
        if (!bl && this.isConnected()) {
            this.setEnabled(false);
        }
        if (this.isConnected()) {
            if (this.execute_once != null) {
                this.execute_once.setEnabled(true);
            }
            if (this.exec_on_change != null) {
                this.exec_on_change.setEnabled(true);
            }
            if (this.end_execution != null) {
                this.end_execution.setEnabled(true);
            }
            if (this.set_caching != null) {
                this.set_caching.setEnabled(true);
            }
        } else {
            if (this.execute_once != null) {
                this.execute_once.setEnabled(false);
            }
            if (this.exec_on_change != null) {
                this.exec_on_change.setEnabled(false);
            }
            if (this.end_execution != null) {
                this.end_execution.setEnabled(false);
            }
            if (this.set_caching != null) {
                this.set_caching.setEnabled(false);
            }
        }
    }

    public void updateCaching(ImageNode imageNode) {
        if (this.cache_size == null) {
            return;
        }
        Integer n = new Integer(imageNode.getCacheCount());
        this.cache_size.setText(n.toString());
    }

    @Override
    protected void disconnect(Thread thread) {
        super.disconnect(thread);
        if (this.connect_btn != null) {
            this.connect_btn.setLabel("Connect");
        }
        if (this.execCtrl != null && this.executing != null) {
            this.executing.setVisible(false);
        }
        if (this.execute_once != null) {
            this.execute_once.setEnabled(false);
        }
        if (this.exec_on_change != null) {
            this.exec_on_change.setEnabled(false);
        }
        if (this.end_execution != null) {
            this.end_execution.setEnabled(false);
        }
        if (this.set_caching != null) {
            this.set_caching.setEnabled(false);
        }
        if (this.mode_chooser != null) {
            this.mode_chooser.select(0);
            this.selected_mode = 0;
            if (this.selected_image != null) {
                this.applyInteractionMode(0, 0L);
            }
        }
    }

    protected abstract void readNetwork();

    protected abstract boolean isExecuting();

    protected void DXLExecuteOnce() {
        if (this.executing != null) {
            this.executing.setVisible(true);
            this.executing.repaint();
        }
        this.dirty = false;
    }

    public void updateSelectedImageNode(KeyEvent keyEvent, ImageNode imageNode) {
        if (this.named_image_list != null && this.selected_image != imageNode && imageNode != null && this.named_image_list.contains(imageNode)) {
            int n = this.named_image_list.indexOf(imageNode);
            this.image_chooser.select(n);
            this.selected_image = imageNode;
        }
        this.keyPressed(keyEvent);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        int n2 = keyEvent.getModifiers();
        if (n == 35 && (n2 & 2) > 0) {
            this.setEocMode(false);
        } else if (n == 69 && (n2 & 2) > 0) {
            this.DXLExecuteOnce();
        } else if (n == 82 && (n2 & 2) > 0) {
            this.setInteractionMode(1, 0L);
        } else if (n == 70 && (n2 & 2) > 0) {
            if (this.selected_image != null) {
                this.selected_image.resetCamera(true, false);
                this.DXLExecuteOnce();
                this.selected_image.resetCamera(false, false);
                this.setInteractionMode(0, 0L);
            }
        } else if (n == 9 && (n2 & 2) > 0) {
            this.setInteractionMode(3, 0L);
        } else if (n == 32 && (n2 & 2) > 0) {
            this.setInteractionMode(4, 0L);
        } else if (n == 67 && (n2 & 2) > 0) {
            this.setEocMode(true);
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (actionEvent.getSource() == this.cache_size) {
            String string2 = this.cache_size.getText();
            Integer n = new Integer(string2);
            int n2 = n;
            this.setCacheSize(n2);
        } else if (string.equals("Execute Once")) {
            this.DXLExecuteOnce();
        } else if (string.equals("End Execution")) {
            this.DXLEndExecution();
        } else if (string.equals("Connect")) {
            this.in_connect_callback = true;
            this.connect();
            this.in_connect_callback = false;
        } else if (string.equals("Disconnect") && this.isConnected()) {
            this.disconnect(null);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.exec_on_change) {
            this.setEocMode(this.exec_on_change.getState());
        } else if (itemEvent.getSource() == this.set_caching) {
            this.setCachingMode(this.set_caching.getState(), false);
        } else if (itemEvent.getSource() == this.cache_options) {
            int n = this.cache_options.getSelectedIndex();
            this.setCacheOption(n);
            if (n == 4) {
                this.set_caching.setState(false);
                this.setCachingMode(false, true);
                this.mode_chooser.select(0);
            }
        } else if (itemEvent.getSource() == this.pick_chooser) {
            Date date = new Date();
            long l = date.getTime();
            Vector vector = null;
            Class<?> clazz = null;
            try {
                clazz = Class.forName("dx.net.PickNode");
            }
            catch (Exception exception) {
                System.out.println("DXApplication: failed to list PickNodes");
            }
            if (clazz != null) {
                vector = this.network.makeNodeList(clazz, false);
            }
            String string = this.pick_chooser.getSelectedItem();
            PickNode pickNode = this.selected_pick;
            if (vector != null && vector.size() > 0) {
                int n = this.pick_chooser.getSelectedIndex();
                this.selected_pick = (PickNode)vector.elementAt(n);
            }
            if (this.selected_image != null) {
                if (this.selected_mode == 6) {
                    PickNode pickNode2 = this.selected_pick;
                    this.selected_pick = pickNode;
                    this.applyInteractionMode(0, l);
                    this.selected_pick = pickNode2;
                    this.applyInteractionMode(6, l);
                } else {
                    this.applyInteractionMode(this.selected_mode, l);
                }
            }
        } else if (itemEvent.getSource() == this.image_chooser) {
            String string = this.image_chooser.getSelectedItem();
            Date date = new Date();
            long l = date.getTime();
            if (this.named_image_list != null && this.named_image_list.size() > 0) {
                if (this.selected_image != null) {
                    this.applyInteractionMode(0, l);
                }
                int n = this.image_chooser.getSelectedIndex();
                this.selected_image = (ImageNode)this.named_image_list.elementAt(n);
                this.applyInteractionMode(this.selected_mode, l);
                if (this.mode_chooser != null && this.modes != null) {
                    int n2 = this.selected_image.getInteractionMode();
                    int n3 = this.modes.length;
                    for (int i = 0; i < n3; ++i) {
                        if (this.modes[i] != n2) continue;
                        this.mode_chooser.select(i);
                        break;
                    }
                }
            }
            this.updateCaching(this.selected_image);
        } else if (itemEvent.getSource() == this.view_chooser) {
            if (this.selected_image != null) {
                this.selected_image.setView(this.view_chooser.getSelectedIndex(), true);
            }
        } else if (itemEvent.getSource() == this.mode_chooser) {
            Object object;
            int n = this.selected_mode;
            int n4 = this.mode_chooser.getSelectedIndex();
            this.selected_mode = this.modes[n4];
            if (this.selected_mode == 7) {
                if (this.selected_image != null) {
                    this.selected_image.resetCamera(true, false);
                    this.DXLExecuteOnce();
                    this.selected_image.resetCamera(false, false);
                }
                this.mode_chooser.select(0);
                this.selected_mode = 0;
            }
            if (this.selected_mode == n && n == 5) {
                this.applyInteractionMode(0, 0L);
                n = 0;
            }
            if (this.selected_mode == 5 && this.set_caching != null) {
                this.setCachingMode(true, false);
            }
            if (this.pick_chooser != null) {
                if (this.selected_mode == 6) {
                    this.pick_chooser.setEnabled(true);
                } else {
                    this.pick_chooser.setEnabled(false);
                }
            }
            if (this.selected_mode == 2 && this.sequencer != null) {
                object = (SequencerNode)this.sequencer;
                ((SequencerNode)object).reset();
            }
            if (this.selected_image != null) {
                long l;
                boolean bl;
                if (this.dirty && n4 == this.sequence_mode_choice && this.sequencer != null) {
                    object = (SequencerNode)this.sequencer;
                    ((SequencerNode)object).reset();
                    this.setCacheOption(4);
                }
                if (!(bl = this.applyInteractionMode(this.selected_mode, l = ((Date)(object = new Date())).getTime())) && this.selected_mode == 5 && n4 == this.sequence_mode_choice && this.sequencer != null) {
                    this.applyInteractionMode(0, 0L);
                    SequencerNode sequencerNode = (SequencerNode)this.sequencer;
                    sequencerNode.reset();
                    this.setCacheOption(4);
                    this.setCacheSize(sequencerNode.getSteps());
                    this.DXLExecuteOnce();
                    sequencerNode.stepQuietly();
                    bl = true;
                }
                if (!bl) {
                    this.mode_chooser.select(n);
                    this.selected_mode = n;
                }
            }
        }
    }

    private void setCacheOption(int n) {
        ImageNode imageNode;
        String string;
        if (n == 4) {
            this.cache_options.select(0);
        }
        if ((string = (imageNode = this.selected_image).getGroupName()) == null) {
            imageNode.setCacheOption(n);
            return;
        }
        Vector vector = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("dx.net.ImageNode");
        }
        catch (Exception exception) {
            System.out.println("DXApplication: failed to list ImageNodes");
        }
        if (clazz != null) {
            vector = this.network.makeNodeList(clazz, false);
        }
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                ImageNode imageNode2 = (ImageNode)enumeration.nextElement();
                if (!string.equals(imageNode2.getGroupName())) continue;
                imageNode2.setCacheOption(n);
            }
        }
    }

    private void setCacheSize(int n) {
        ImageNode imageNode = this.selected_image;
        String string = imageNode.getGroupName();
        if (string == null) {
            imageNode.setCacheSize(n);
            return;
        }
        Vector vector = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("dx.net.ImageNode");
        }
        catch (Exception exception) {
            System.out.println("DXApplication: failed to list ImageNodes");
        }
        if (clazz != null) {
            vector = this.network.makeNodeList(clazz, false);
        }
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                ImageNode imageNode2 = (ImageNode)enumeration.nextElement();
                if (!string.equals(imageNode2.getGroupName())) continue;
                imageNode2.setCacheSize(n);
            }
        }
    }

    public boolean setInteractionMode(int n, long l) {
        if (!this.applyInteractionMode(n, l)) {
            return false;
        }
        if (this.mode_chooser != null) {
            int n2 = this.modes.length;
            for (int i = 0; i < n2; ++i) {
                if (this.modes[i] != n) continue;
                this.mode_chooser.select(i);
                if (n != 6) break;
                this.pick_chooser.setEnabled(true);
                break;
            }
        }
        this.selected_mode = n;
        return true;
    }

    private boolean applyInteractionMode(int n, long l) {
        ImageNode imageNode = this.selected_image;
        boolean bl = imageNode.setInteractionMode(n, l);
        if (!bl) {
            return false;
        }
        String string = imageNode.getGroupName();
        if (string == null) {
            return true;
        }
        if (ImageWindow.IsGroupInteraction(n)) {
            Vector vector = null;
            Class<?> clazz = null;
            try {
                clazz = Class.forName("dx.net.ImageNode");
            }
            catch (Exception exception) {
                System.out.println("DXApplication: failed to list ImageNodes");
            }
            if (clazz != null) {
                vector = this.network.makeNodeList(clazz, false);
            }
            if (vector != null) {
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    ImageNode imageNode2 = (ImageNode)enumeration.nextElement();
                    if (!string.equals(imageNode2.getGroupName())) continue;
                    imageNode2.setInteractionMode(n, l);
                }
            }
        }
        return true;
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (!this.getMakesGui()) {
            return;
        }
        if (!this.shadows) {
            return;
        }
        Dimension dimension = this.getSize();
        graphics.setColor(Color.black);
        graphics.drawRect(0, 0, dimension.width - 8, dimension.height - 8);
        graphics.fillRect(8, dimension.height - 8, dimension.width - 8, 8);
        graphics.fillRect(dimension.width - 8, 8, 8, dimension.height - 8);
    }

    public ImageWindow getImageWindow(int n) {
        ImageWindow imageWindow2 = null;
        if (this.imageWindows.size() == 0) {
            this.locateImageWindows();
        }
        try {
            imageWindow2 = (ImageWindow)this.imageWindows.elementAt(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return imageWindow2;
    }

    public void showWorld(String string, String string2, int n) {
    }

    private void locateImageWindows() {
        AppletContext appletContext = this.getAppletContext();
        Enumeration<Applet> enumeration = appletContext.getApplets();
        while (enumeration.hasMoreElements()) {
            Applet applet = enumeration.nextElement();
            if (applet == null || !applet.isActive() || !(applet instanceof ImageWindow) || this.imageWindows.contains(applet)) continue;
            this.imageWindows.addElement(applet);
        }
    }

    public synchronized void DXLSend(String string) {
        if (string.lastIndexOf("assign noexecute") == -1) {
            this.dirty = true;
            if (this.eocMode) {
                this.DXLExecuteOnce();
            }
        }
    }

    public void enableModeSelector(boolean bl) {
        if (this.mode_chooser == null) {
            return;
        }
        if (bl) {
            this.mode_chooser.setEnabled(true);
        } else {
            this.mode_chooser.setEnabled(false);
        }
    }

    public synchronized void finishedExecuting() {
        if (!this.isExecuting() && this.executing != null) {
            this.executing.setVisible(false);
            if (this.sequencer != null && this.selected_mode == 5) {
                int n = this.mode_chooser.getSelectedIndex();
                if (n == this.sequence_mode_choice && this.selected_image.getInteractionMode() != 5) {
                    int n2;
                    SequencerNode sequencerNode = (SequencerNode)this.sequencer;
                    int n3 = sequencerNode.getSteps();
                    if (n3 != (n2 = this.selected_image.getCacheCount())) {
                        this.setCacheSize(sequencerNode.getSteps());
                    }
                    Date date = new Date();
                    long l = date.getTime();
                    if (sequencerNode.hasMoreFrames()) {
                        this.DXLExecuteOnce();
                        sequencerNode.stepQuietly();
                    } else if (this.selected_image != null) {
                        this.applyInteractionMode(this.selected_mode, l);
                    }
                }
            } else if (this.selected_mode == 6) {
                PickNode pickNode = this.getSelectedPickNode();
                ImageNode imageNode = this.getSelectedImageNode();
                if (pickNode != null && imageNode != null) {
                    imageNode.resetPickList();
                }
            }
        }
    }

    public void DXLEndExecution() {
        if (this.sequencer != null && this.selected_mode == 5) {
            this.setInteractionMode(0, 0L);
        }
    }

    public String getBWCompatString() {
        if (this.bwcompat_checked) {
            return this.bwcompat_string;
        }
        this.bwcompat_string = null;
        this.bwcompat_checked = true;
        try {
            String string = this.getDocumentBase().toString();
            String string2 = this.getCodeBase().toString();
            int n = string.lastIndexOf(47);
            int n2 = string2.lastIndexOf(47);
            string = string.substring(0, n);
            string2 = string2.substring(0, n2);
            if (string.equals(string2)) {
                this.bwcompat_string = "../";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.bwcompat_string;
    }

    public boolean getEocMode() {
        return this.eocMode;
    }

    public void setEocMode(boolean bl) {
        if (bl) {
            this.eocMode = true;
            if (this.exec_on_change != null) {
                this.exec_on_change.setState(true);
            }
            this.DXLExecuteOnce();
        } else {
            this.eocMode = false;
            if (this.exec_on_change != null) {
                this.exec_on_change.setState(false);
            }
            if (this.isExecuting() || this.execCtrl != null) {
                // empty if block
            }
        }
    }

    public void setShadows(boolean bl) {
        this.shadows = bl;
    }

    public boolean getShadows() {
        return this.shadows;
    }

    public boolean getCachingMode() {
        return this.cachingMode;
    }

    public void setCachingMode(boolean bl, boolean bl2) {
        Object object;
        this.cachingMode = bl;
        if (bl) {
            if (this.cache_size != null) {
                this.cache_size.setEnabled(true);
            }
            if (this.cache_options != null) {
                this.cache_options.setEnabled(true);
            }
            if (this.selected_image != null && this.selected_image.getInteractionMode() != 5) {
                object = new Date();
                long l = ((Date)object).getTime();
                this.applyInteractionMode(this.selected_mode, l);
            }
        } else {
            if (this.cache_size != null) {
                this.cache_size.setEnabled(false);
            }
            if (this.cache_options != null) {
                this.cache_options.setEnabled(false);
            }
            if (this.selected_image != null && this.selected_image.getInteractionMode() == 5) {
                this.applyInteractionMode(0, 0L);
            }
        }
        if (this.imageWindows == null) {
            return;
        }
        if (bl2) {
            object = this.imageWindows.elements();
            while (object.hasMoreElements()) {
                ImageWindow imageWindow2 = (ImageWindow)object.nextElement();
                imageWindow2.clearImageCache();
            }
        }
    }
}

