/*
 * Decompiled with CFR 0.152.
 */
package dx.net;

import dx.client.DXClientThread;
import dx.net.DXApplication;
import dx.net.DXLAppThread;
import dx.net.DXLOutputNode;
import dx.net.DXLinkHandler;
import dx.net.DXViewIF;
import dx.net.PacketIF;
import dx.net.SequencerNode;
import dx.protocol.endExecMsg;
import dx.protocol.execOnceMsg;
import dx.protocol.loadMsg;
import dx.protocol.messageMsg;
import dx.protocol.sendValueMsg;
import dx.protocol.server.serverMsg;
import dx.protocol.server.startMsg;
import dx.protocol.stepSeqMsg;
import dx.protocol.threadMsg;
import java.applet.Applet;
import java.applet.AppletContext;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class DXLinkApplication
extends DXApplication {
    private String netName = null;
    private int executing;
    private Hashtable handlers;
    private int java_id;
    private String output_dir;
    private String output_url;
    private DXClientThread pending_start;
    private Vector object_applets;
    private Vector unassociated_dxloutputs;

    public void setNetName(String string) {
        this.netName = string;
    }

    public String getNetName() {
        if (this.netName == null) {
            this.netName = this.getParameter("NETNAME");
        }
        return this.netName;
    }

    @Override
    protected serverMsg getRequest() {
        return new startMsg();
    }

    public void setOutputDir(String string) {
        this.output_dir = string;
    }

    public void setOutputUrl(String string) {
        this.output_url = string;
    }

    public String getOutputDir() {
        return this.output_dir;
    }

    public String getOutputUrl() {
        return this.output_url;
    }

    @Override
    public boolean isExecuting() {
        return this.executing > 0;
    }

    public int getJavaId() {
        return this.java_id;
    }

    @Override
    public void setJavaId(int n) {
        this.java_id = n;
        super.setJavaId(n);
    }

    public DXLinkApplication() {
        System.out.println("IBM Visualization Data Explorer / Java Explorer version 2.0.0");
        this.java_id = 0;
        this.executing = 0;
        this.handlers = null;
        this.pending_start = null;
        this.unassociated_dxloutputs = null;
        this.object_applets = null;
    }

    @Override
    public void disconnect(Thread thread) {
        if (this.isExecuting()) {
            this.finishedExecuting();
        }
        super.disconnect(null);
    }

    @Override
    protected DXClientThread createCommandThread() {
        DXLAppThread dXLAppThread = new DXLAppThread(this, this.is);
        this.pending_start = dXLAppThread;
        return dXLAppThread;
    }

    @Override
    protected void connect() {
        super.connect();
        this.executing = 0;
        if (this.isConnected()) {
            loadMsg loadMsg2 = new loadMsg();
            loadMsg2.setProgram(this.getNetName());
            this.send(loadMsg2.toString());
        }
        if (this.pending_start != null) {
            this.pending_start.start();
            this.pending_start = null;
        }
    }

    @Override
    public synchronized void DXLExecuteOnce() {
        if (this.isConnected()) {
            execOnceMsg execOnceMsg2;
            SequencerNode sequencerNode = this.getSequencerNode();
            ++this.executing;
            if (sequencerNode != null) {
                stepSeqMsg stepSeqMsg2 = new stepSeqMsg();
                stepSeqMsg2.setFrame(sequencerNode.getFrame());
                stepSeqMsg2.setMin(sequencerNode.getMin());
                stepSeqMsg2.setMax(sequencerNode.getMax());
                stepSeqMsg2.setDelta(sequencerNode.getDelta());
                stepSeqMsg2.setName(sequencerNode.getName());
                stepSeqMsg2.setInstance(sequencerNode.getInstanceNumber());
                execOnceMsg2 = stepSeqMsg2;
            } else {
                execOnceMsg2 = new execOnceMsg();
            }
            execOnceMsg2.setMacroName(this.getMacroName());
            this.send(execOnceMsg2.toString());
            this.showStatus("IBM Visualization Data Explorer is executing...");
        } else {
            this.showStatus("...Data Explorer disconnected");
        }
        super.DXLExecuteOnce();
    }

    @Override
    public synchronized void finishedExecuting() {
        --this.executing;
        this.showStatus("Execution Finished");
        if (this.isExecuting()) {
            this.showStatus("IBM Visualization Data Explorer is executing...");
        }
        super.finishedExecuting();
    }

    @Override
    public synchronized void DXLEndExecution() {
        super.DXLEndExecution();
        endExecMsg endExecMsg2 = new endExecMsg();
        this.send(endExecMsg2.toString());
    }

    @Override
    public synchronized void DXLSend(String string) {
        if (this.isConnected()) {
            sendValueMsg sendValueMsg2 = new sendValueMsg();
            sendValueMsg2.setValue(string);
            this.send(sendValueMsg2.toString());
        }
        super.DXLSend(string);
    }

    public synchronized void registerHandler(String string, PacketIF packetIF) {
        if (this.handlers == null) {
            this.handlers = new Hashtable(40);
        }
        this.handlers.put(string, packetIF);
    }

    public boolean handleMessage(threadMsg threadMsg2) {
        if (this.handlers == null) {
            return false;
        }
        messageMsg messageMsg2 = (messageMsg)threadMsg2;
        String string = messageMsg2.getMessage();
        int n = 0;
        PacketIF packetIF = null;
        Enumeration enumeration = this.handlers.keys();
        while (enumeration.hasMoreElements()) {
            int n2;
            String string2 = (String)enumeration.nextElement();
            if (!string.startsWith(string2) || (n2 = string2.length()) <= n) continue;
            packetIF = (PacketIF)this.handlers.get(string2);
            n = n2;
        }
        if (packetIF != null) {
            packetIF.handleMessage(string);
            return true;
        }
        return false;
    }

    @Override
    public void start() {
        Class<?> clazz;
        super.start();
        if (this.unassociated_dxloutputs == null) {
            try {
                clazz = Class.forName("dx.net.DXLOutputNode");
                this.unassociated_dxloutputs = this.network.makeNodeList(clazz, false);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.unassociated_dxloutputs == null) {
            return;
        }
        if (this.unassociated_dxloutputs.size() > 0) {
            DXLOutputNode dXLOutputNode;
            clazz = null;
            try {
                clazz = Class.forName("dx.net.DXLinkHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (clazz == null) {
                return;
            }
            Vector<DXLOutputNode> vector = null;
            Enumeration enumeration = this.unassociated_dxloutputs.elements();
            while (enumeration.hasMoreElements()) {
                dXLOutputNode = (DXLOutputNode)enumeration.nextElement();
                if (dXLOutputNode.hasHandler()) {
                    if (vector == null) {
                        vector = new Vector<DXLOutputNode>(4);
                    }
                    vector.addElement(dXLOutputNode);
                    continue;
                }
                String string = dXLOutputNode.getNotation();
                boolean bl = false;
                int n = 0;
                while (!bl) {
                    ++n;
                    Enumeration<Applet> enumeration2 = this.getAppletContext().getApplets();
                    boolean bl2 = true;
                    while (enumeration2.hasMoreElements()) {
                        DXLinkHandler dXLinkHandler;
                        Applet applet = enumeration2.nextElement();
                        if (!clazz.isInstance(applet) || !(dXLinkHandler = (DXLinkHandler)((Object)applet)).hasHandler(string)) continue;
                        dXLOutputNode.setOutputHandler(dXLinkHandler, null);
                        if (vector == null) {
                            vector = new Vector(4);
                        }
                        vector.addElement(dXLOutputNode);
                        bl = true;
                        break;
                    }
                    if (n > 120) {
                        throw new NullPointerException("Unable to locate DXLOutputHandler for: " + string);
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {}
                }
            }
            if (vector != null) {
                enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    dXLOutputNode = (DXLOutputNode)enumeration.nextElement();
                    this.unassociated_dxloutputs.removeElement(dXLOutputNode);
                }
            }
        }
    }

    public void showObject(String string, String string2, int n) {
        Object object;
        Object object2;
        if (this.object_applets == null || this.object_applets.size() < 1) {
            this.locateObjectWindows();
        }
        if (this.object_applets == null) {
            return;
        }
        if (this.object_applets.size() < 1) {
            return;
        }
        Enumeration enumeration = this.object_applets.elements();
        DXViewIF dXViewIF = null;
        while (enumeration.hasMoreElements()) {
            object2 = (DXViewIF)enumeration.nextElement();
            object = object2.getNodeName();
            if (object == null || !((String)object).equals(string)) continue;
            dXViewIF = object2;
            break;
        }
        if (dXViewIF == null && n < this.object_applets.size()) {
            dXViewIF = (DXViewIF)this.object_applets.elementAt(n);
        }
        if (dXViewIF == null) {
            dXViewIF = (DXViewIF)this.object_applets.elementAt(0);
        }
        object2 = null;
        try {
            object = null;
            object = new URL(this.getCodeBase(), string2);
            object2 = ((URL)object).toString();
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("ActiveXApp: cannot create url from " + string2);
        }
        if (object2 != null) {
            dXViewIF.setUrl("!tear " + (String)object2);
        }
    }

    private void locateObjectWindows() {
        AppletContext appletContext = this.getAppletContext();
        Class<?> clazz = null;
        try {
            clazz = Class.forName("dx.net.DXViewIF");
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            return;
        }
        if (this.object_applets == null) {
            this.object_applets = new Vector(4);
        }
        Enumeration<Applet> enumeration = appletContext.getApplets();
        while (enumeration.hasMoreElements()) {
            Applet applet = enumeration.nextElement();
            Class<?> clazz2 = applet.getClass();
            Class<?>[] classArray = clazz2.getInterfaces();
            int n = classArray.length;
            for (int i = 0; i < n; ++i) {
                if (!classArray[i].equals(clazz)) continue;
                this.object_applets.addElement(applet);
            }
        }
    }
}

