/*
 * Decompiled with CFR 0.152.
 */
package dx.net;

import dx.net.ImageNode;
import dx.net.ImageWindow;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;

public class Gnomon
extends Canvas {
    private ImageNode node;
    private Image bg;
    private float[] xaxis;
    private float[] yaxis;
    private float[] zaxis;
    private int[] ixaxis;
    private int[] iyaxis;
    private int[] izaxis;
    private double[] upvec;
    private double[] frompt;
    private double[] topt;
    private static final byte[] Xbytes = new String("X").getBytes();
    private static final byte[] Ybytes = new String("Y").getBytes();
    private static final byte[] Zbytes = new String("Z").getBytes();
    private int x;
    private int y;
    private int iww;
    private int iwh;
    private Point start_point;
    private boolean button_down;
    private boolean just_pushed;
    private boolean xydrag;

    public void setImage(Image image) {
        this.bg = image;
        this.setup();
        this.setBackground(Color.black);
        this.repaint();
    }

    public Gnomon(ImageNode imageNode, int n, int n2) {
        this.node = imageNode;
        this.bg = null;
        this.xaxis = null;
        this.yaxis = null;
        this.zaxis = null;
        this.y = 0;
        this.x = 0;
        this.iww = n;
        this.iwh = n2;
        this.button_down = false;
        this.just_pushed = false;
        this.xydrag = false;
        this.ixaxis = new int[2];
        this.iyaxis = new int[2];
        this.izaxis = new int[2];
        this.start_point = new Point();
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.x = n;
        this.y = n2;
    }

    public void doneDrag() {
        this.button_down = false;
        this.node.setTo(this.topt, false);
        this.node.setFrom(this.frompt, false);
        this.node.setUp(this.upvec, true);
    }

    public void doDrag(int n, int n2) {
        if (this.xydrag) {
            float f = this.iww >> 1;
            float f2 = ((float)n + f - (float)this.start_point.x) / f;
            this.drag(f2, 2);
            f = this.iwh >> 1;
            f2 = ((float)n2 + f - (float)this.start_point.y) / f;
            this.drag(f2, 1);
            this.start_point.setLocation(n, n2);
        } else {
            float f = this.iwh >> 1;
            float f3 = ((float)n2 + f - (float)this.start_point.y) / f;
            this.drag(f3, 3);
            this.start_point.setLocation(n, n2);
        }
    }

    public void initDrag(int n, int n2, int n3) {
        this.just_pushed = true;
        this.button_down = true;
        this.start_point.setLocation(n2, n3);
        this.xydrag = n == 0;
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        Dimension dimension = this.getSize();
        int n = dimension.width >> 1;
        int n2 = dimension.height >> 1;
        graphics.setPaintMode();
        Dimension dimension2 = this.getSize();
        if (this.bg != null) {
            graphics.drawImage(this.bg, 0, 0, dimension2.width, dimension2.height, this.x, this.y, this.x + dimension2.width, this.y + dimension2.height, Color.black, this);
        }
        if (this.xaxis != null) {
            graphics.setColor(Color.black);
            graphics.drawLine(n + 1, n2, this.ixaxis[0] + 1, this.ixaxis[1]);
            graphics.drawLine(n + 1, n2, this.iyaxis[0] + 1, this.iyaxis[1]);
            graphics.drawLine(n + 1, n2, this.izaxis[0] + 1, this.izaxis[1]);
            graphics.setColor(Color.white);
            graphics.drawLine(n, n2, this.ixaxis[0], this.ixaxis[1]);
            graphics.drawLine(n, n2, this.iyaxis[0], this.iyaxis[1]);
            graphics.drawLine(n, n2, this.izaxis[0], this.izaxis[1]);
            this.labelAxis(graphics, Xbytes, n, n2, this.ixaxis[0], this.ixaxis[1]);
            this.labelAxis(graphics, Ybytes, n, n2, this.iyaxis[0], this.iyaxis[1]);
            this.labelAxis(graphics, Zbytes, n, n2, this.izaxis[0], this.izaxis[1]);
        }
    }

    private void labelAxis(Graphics graphics, byte[] byArray, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        if (n <= n3 && n2 <= n4) {
            n6 = n3 + 4;
            n5 = n4 + 4;
        } else if (n <= n3 && n2 > n4) {
            n6 = n3 + 4;
            n5 = n4;
        } else if (n > n3 && n2 <= n4) {
            n5 = n4 + 4;
            n6 = n3 - 8;
        } else if (n > n3 && n2 > n4) {
            n6 = n3 + 4;
            n5 = n4 - 4;
        } else {
            n6 = n;
            n5 = n2;
        }
        graphics.drawBytes(byArray, 0, 1, n6, n5);
    }

    private void drag(float f, int n) {
        double[] dArray = new double[]{0.0, 0.0, 0.0};
        double d = 1.5707963;
        double d2 = d - (double)f * d;
        double[][] dArray2 = null;
        if (n == 1) {
            double[] dArray3 = new double[]{this.frompt[0] - this.topt[0], this.frompt[1] - this.topt[1], this.frompt[2] - this.topt[2], 0.0};
            double[] dArray4 = ImageWindow.cross(this.upvec, dArray3);
            dArray2 = ImageWindow.getTransform(dArray4, dArray, d2);
            this.frompt[0] = this.frompt[0] - this.topt[0];
            this.frompt[1] = this.frompt[1] - this.topt[1];
            this.frompt[2] = this.frompt[2] - this.topt[2];
            double[] dArray5 = ImageWindow.Rotate(this.frompt, dArray2);
            dArray5[0] = dArray5[0] + this.topt[0];
            dArray5[1] = dArray5[1] + this.topt[1];
            dArray5[2] = dArray5[2] + this.topt[2];
            this.frompt = dArray5;
            this.upvec = ImageWindow.Rotate(this.upvec, dArray2);
        } else if (n == 2) {
            dArray2 = ImageWindow.getTransform(this.upvec, dArray, d2);
            this.frompt[0] = this.frompt[0] - this.topt[0];
            this.frompt[1] = this.frompt[1] - this.topt[1];
            this.frompt[2] = this.frompt[2] - this.topt[2];
            double[] dArray6 = ImageWindow.Rotate(this.frompt, dArray2);
            dArray6[0] = dArray6[0] + this.topt[0];
            dArray6[1] = dArray6[1] + this.topt[1];
            dArray6[2] = dArray6[2] + this.topt[2];
            this.frompt = dArray6;
        } else if (n == 3) {
            dArray2 = ImageWindow.getTransform(this.frompt, this.topt, -d2);
            this.upvec = ImageWindow.Rotate(this.upvec, dArray2);
        }
        this.recompute();
        if (!this.button_down) {
            this.repaint();
        }
    }

    private void setup() {
        this.frompt = this.node.getFrom();
        this.topt = this.node.getTo();
        this.upvec = this.node.getUp();
        if (this.xaxis == null) {
            this.xaxis = new float[4];
            this.yaxis = new float[4];
            this.zaxis = new float[4];
        }
        this.recompute();
    }

    private void recompute() {
        Object[] objectArray;
        Object object;
        Dimension dimension = this.getSize();
        int n = dimension.width >> 1;
        int n2 = dimension.height >> 1;
        if (this.button_down) {
            object = this.getGraphics();
            if (this.just_pushed) {
                objectArray = this.xaxis;
                this.xaxis = null;
                this.paint((Graphics)object);
                this.xaxis = objectArray;
            } else {
                ((Graphics)object).setColor(Color.white);
                ((Graphics)object).setXORMode(Color.black);
                ((Graphics)object).drawLine(n, n2, this.ixaxis[0], this.ixaxis[1]);
                ((Graphics)object).drawLine(n, n2, this.iyaxis[0], this.iyaxis[1]);
                ((Graphics)object).drawLine(n, n2, this.izaxis[0], this.izaxis[1]);
                this.labelAxis((Graphics)object, Xbytes, n, n2, this.ixaxis[0], this.ixaxis[1]);
                this.labelAxis((Graphics)object, Ybytes, n, n2, this.iyaxis[0], this.iyaxis[1]);
                this.labelAxis((Graphics)object, Zbytes, n, n2, this.izaxis[0], this.izaxis[1]);
            }
            this.just_pushed = false;
        }
        object = ImageWindow.normalize(this.frompt, this.topt);
        objectArray = ImageWindow.cross(this.upvec, (double[])object);
        for (int i = 0; i < 4; ++i) {
            this.zaxis[i] = 0.0f;
            this.yaxis[i] = 0.0f;
            this.xaxis[i] = 0.0f;
        }
        this.yaxis[1] = 0.8f;
        this.xaxis[0] = 0.8f;
        this.zaxis[2] = -0.8f;
        float f = (float)n + (float)n * (float)ImageWindow.dot(this.xaxis, objectArray);
        float f2 = (float)n2 - (float)n * (float)ImageWindow.dot(this.xaxis, this.upvec);
        this.xaxis[0] = f;
        this.ixaxis[0] = (int)this.xaxis[0];
        this.xaxis[1] = f2;
        this.ixaxis[1] = (int)this.xaxis[1];
        f = (float)n + (float)n * (float)ImageWindow.dot(this.yaxis, objectArray);
        f2 = (float)n2 - (float)n * (float)ImageWindow.dot(this.yaxis, this.upvec);
        this.yaxis[0] = f;
        this.iyaxis[0] = (int)this.yaxis[0];
        this.yaxis[1] = f2;
        this.iyaxis[1] = (int)this.yaxis[1];
        f = (float)n + (float)n * (float)ImageWindow.dot(this.zaxis, objectArray);
        f2 = (float)n2 - (float)n * (float)ImageWindow.dot(this.zaxis, this.upvec);
        this.zaxis[0] = f;
        this.izaxis[0] = (int)this.zaxis[0];
        this.zaxis[1] = f2;
        this.izaxis[1] = (int)this.zaxis[1];
        if (this.button_down) {
            Graphics graphics = this.getGraphics();
            graphics.setColor(Color.white);
            graphics.setXORMode(Color.black);
            graphics.drawLine(n, n2, this.ixaxis[0], this.ixaxis[1]);
            graphics.drawLine(n, n2, this.iyaxis[0], this.iyaxis[1]);
            graphics.drawLine(n, n2, this.izaxis[0], this.izaxis[1]);
            this.labelAxis(graphics, Xbytes, n, n2, this.ixaxis[0], this.ixaxis[1]);
            this.labelAxis(graphics, Ybytes, n, n2, this.iyaxis[0], this.iyaxis[1]);
            this.labelAxis(graphics, Zbytes, n, n2, this.izaxis[0], this.izaxis[1]);
        }
    }
}

