/*
 * Decompiled with CFR 0.152.
 */
package dx.net;

import dx.net.DXApplication;
import dx.net.DXLinkApplication;
import dx.net.DrivenNode;
import dx.net.ImageWindow;
import dx.net.Network;
import dx.net.Node;
import dx.net.PickNode;
import dx.net.WebOptionsNode;
import java.applet.AppletContext;
import java.awt.Dimension;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.StringTokenizer;

public class ImageNode
extends DrivenNode {
    private static final int IMAGETAG = 1;
    private static final int WHERE = 3;
    private static final int USEVECTOR = 4;
    private static final int TO = 5;
    private static final int FROM = 6;
    private static final int WIDTH = 7;
    private static final int RESOLUTION = 8;
    private static final int ASPECT = 9;
    private static final int UP = 10;
    private static final int VIEWANGLE = 11;
    private static final int PROJECTION = 12;
    private static final int RESET_CAMERA = 21;
    private static final int INTERACTIONMODE = 41;
    private static final int IMAGENAME = 42;
    private static final int JAVA_OPTIONS = 49;
    private static final int WEB_FORMAT = 1;
    private static final int WEB_FILE = 2;
    private static final int WEB_ENABLED = 3;
    private static final int WEB_COUNTERS = 4;
    private static final int WEB_ORBIT = 5;
    private static final int WEB_ID = 6;
    private static final int WEB_IMGID = 7;
    private static final int WEB_ORBIT_DELTA = 8;
    private static final int WEB_CACHE_SIZE = 9;
    private static final int WEB_GROUP_NAME = 10;
    public static final int NO_PALINDROME = 0;
    public static final int PALINDROME = 1;
    public static final int FASTER = 2;
    public static final int SLOWER = 3;
    public static final int RESET = 4;
    private int image_id = -1;
    private boolean orbit_mode = false;
    private int interaction_mode = 0;
    private ImageWindow iw = null;
    private String pick_list = null;
    private int reset_camera = 0;
    private boolean perspective = false;
    private WebOptionsNode web_options_node = null;
    private String group_name = null;
    private int cache_count = 0;
    private int cache_speed = 200;
    private boolean palindrome = false;

    public void setPalindromeMode(boolean bl) {
        this.palindrome = bl;
    }

    public boolean getPalindromeMode() {
        return this.palindrome;
    }

    public ImageNode(Network network, String string, int n, String string2) {
        super(network, string, n, string2);
    }

    public boolean isPerspective() {
        return this.perspective;
    }

    public synchronized void setCacheOption(int n) {
        switch (n) {
            case 2: {
                int n2 = this.getCacheSpeed();
                n2 = (n2 -= 50) < 50 ? 50 : n2;
                this.setCacheSpeed(n2);
                break;
            }
            case 3: {
                int n3 = this.getCacheSpeed();
                n3 = (n3 += 50) > 2000 ? 2000 : n3;
                this.setCacheSpeed(n3);
                break;
            }
            case 1: {
                this.setPalindromeMode(true);
                break;
            }
            case 0: {
                this.setPalindromeMode(false);
                break;
            }
            case 4: {
                this.setPalindromeMode(false);
                this.setCacheSpeed(200);
                this.setCacheSize(0);
                if (this.iw == null) break;
                this.iw.clearImageCache();
            }
        }
    }

    public synchronized int getCacheSpeed() {
        return this.cache_speed;
    }

    public synchronized void setCacheSpeed(int n) {
        this.cache_speed = n;
    }

    public void setInitialInteractionMode(int n) {
        if (this.iw == null) {
            this.interaction_mode = n;
        }
    }

    public String getTitle() {
        return this.getInputValueString(42);
    }

    public int getInteractionMode() {
        return this.interaction_mode;
    }

    @Override
    public boolean handleAssignment(String string, String string2) {
        boolean bl = false;
        if (string.equals("imgId")) {
            if (this.image_id != -1 && this.iw != null && this.iw.getInitialNodeName(this.getNetwork()).equals(this.getMatchString())) {
                bl = true;
            } else {
                try {
                    Integer n = new Integer(string2);
                    int n2 = n;
                    if (n2 != this.image_id) {
                        this.image_id = n2;
                        this.iw = null;
                    }
                    bl = true;
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("ImageNode: Couldn't parse: " + string2);
                }
            }
        } else if (string.equals("orbit")) {
            try {
                Integer n = new Integer(string2);
                this.forceOrbitMode(n == 1);
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("ImageNode: Couldn't parse: " + string2);
            }
        } else if (string.equals("show")) {
            DXApplication dXApplication = this.getNetwork().getApplet();
            String string3 = dXApplication.getBWCompatString();
            String string4 = string2;
            if (string3 != null) {
                string4 = string3 + string2;
            }
            bl = string2.endsWith(".wrl") ? this.showWorld(string4) : (string2.endsWith(".dx") ? this.showObject(string4) : this.showImage(string4));
        } else if (string.equals("reset")) {
            try {
                Integer n = new Integer(string2);
                this.reset_camera = n;
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("ImageNode: Couldn't parse: " + string2);
                this.reset_camera = 0;
            }
        } else if (string.equals("width")) {
            if (this.reset_camera == 1) {
                this.setInputValueQuietly(7, string2);
            }
            this.setInputValueString(7, string2);
            this.perspective = false;
            bl = true;
        } else if (string.equals("angle")) {
            if (this.reset_camera == 1) {
                this.setInputValueQuietly(11, string2);
            }
            this.setInputValueString(11, string2);
            this.perspective = true;
            bl = true;
        } else if (string.equals("to")) {
            if (this.reset_camera == 1) {
                this.setInputValueQuietly(5, string2);
            }
            this.setInputValueString(5, string2);
            bl = true;
        } else if (string.equals("from")) {
            if (this.reset_camera == 1) {
                this.setInputValueQuietly(6, string2);
            }
            this.setInputValueString(6, string2);
            bl = true;
        } else if (string.equals("up")) {
            if (this.reset_camera == 1) {
                this.setInputValueQuietly(10, string2);
            }
            this.setInputValueString(10, string2);
            bl = true;
        } else if (string.equals("group")) {
            if (string2.equals("untitled")) {
                this.setGroupName(null);
            } else {
                this.setGroupName(string2);
            }
            bl = true;
        } else if (string.equals("mode")) {
            if (this.isInputConnected(41)) {
                DXApplication dXApplication = this.getNetwork().getApplet();
                boolean bl2 = false;
                try {
                    if (string2.equals("none")) {
                        bl2 = dXApplication.setInteractionMode(0, 0L);
                    } else if (string2.equals("pick")) {
                        bl2 = dXApplication.setInteractionMode(6, 0L);
                    } else if (string2.equals("zoom")) {
                        bl2 = dXApplication.setInteractionMode(4, 0L);
                    } else if (string2.equals("panzoom")) {
                        bl2 = dXApplication.setInteractionMode(3, 0L);
                    } else if (string2.equals("rotate")) {
                        bl2 = dXApplication.setInteractionMode(1, 0L);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            bl = true;
        } else if (string.equals("cache")) {
            try {
                Integer n = new Integer(string2);
                this.setCacheSize(n);
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("ImageNode: Couldn't parse: " + string2);
                this.cache_count = 0;
            }
        }
        if (bl) {
            return true;
        }
        return super.handleAssignment(string, string2);
    }

    public void setCacheSize(int n) {
        this.cache_count = n;
        DXApplication dXApplication = this.getNetwork().getApplet();
        if (this == dXApplication.getSelectedImageNode()) {
            dXApplication.updateCaching(this);
        }
    }

    public int getCacheCount() {
        return this.cache_count;
    }

    public String getGroupName() {
        return this.group_name;
    }

    public void setGroupName(String string) {
        this.group_name = string;
    }

    private void forceOrbitMode(boolean bl) {
        if (bl == this.orbit_mode) {
            return;
        }
        this.orbit_mode = bl;
        DXApplication dXApplication = this.getNetwork().getApplet();
        if (this == dXApplication.getSelectedImageNode()) {
            dXApplication.enableModeSelector(!this.orbit_mode);
        }
    }

    protected boolean showImage(String string) {
        Network network = this.getNetwork();
        DXApplication dXApplication = this.getNetwork().getApplet();
        if (this.iw == null) {
            this.associate(dXApplication.getImageWindow(this.image_id));
            if (dXApplication.getImageWindow(this.image_id) == null) {
                System.err.println("this.iw is null and id is: " + this.image_id);
                System.err.println("ImageNode.showImage: ImageWindow still null - unable to display in applet.");
            }
        }
        if (this.iw == null) {
            AppletContext appletContext = dXApplication.getAppletContext();
            try {
                URL uRL = new URL(dXApplication.getCodeBase(), string);
                appletContext.showDocument(uRL, this.getName() + "_" + this.getInstanceNumber());
            }
            catch (MalformedURLException malformedURLException) {
                return false;
            }
        } else {
            if (!this.orbit_mode) {
                if (this.interaction_mode != this.iw.getInteractionMode()) {
                    long l = new Date().getTime();
                    this.iw.setInteractionMode(this.interaction_mode, l);
                }
            } else {
                this.iw.setInteractionMode(2, 0L);
            }
            this.iw.showImage(string);
        }
        return true;
    }

    public void associate(ImageWindow imageWindow2, int n) {
        this.image_id = n;
        this.associate(imageWindow2);
        if (!this.isInputConnected(41)) {
            String string = this.getInputValueString(41);
            DXApplication dXApplication = this.getNetwork().getApplet();
            ImageNode imageNode = dXApplication.getSelectedImageNode();
            if (string != null && this.interaction_mode == 0 && imageNode == this) {
                try {
                    if (string.equals("none")) {
                        dXApplication.setInteractionMode(0, 0L);
                    } else if (string.equals("pick")) {
                        dXApplication.setInteractionMode(6, 0L);
                    } else if (string.equals("zoom")) {
                        dXApplication.setInteractionMode(4, 0L);
                    } else if (string.equals("panzoom")) {
                        dXApplication.setInteractionMode(3, 0L);
                    } else if (string.equals("rotate")) {
                        dXApplication.setInteractionMode(1, 0L);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (this.getCacheCount() == 0) {
            int n2 = imageWindow2.getCacheSize();
            this.setCacheSize(n2);
        }
    }

    public void associate(ImageWindow imageWindow2) {
        if (this.iw == imageWindow2) {
            return;
        }
        this.iw = imageWindow2;
        if (this.iw == null) {
            return;
        }
        this.iw.associate(this);
        Network network = this.getNetwork();
        DXLinkApplication dXLinkApplication = (DXLinkApplication)network.getApplet();
        boolean bl = dXLinkApplication.getEocMode();
        if (bl) {
            dXLinkApplication.setEocMode(false);
        }
        Dimension dimension = this.iw.getSize();
        this.setInputValue(8, "" + dimension.width);
        this.setInputValue(4, "1");
        Double d = new Double(((double)dimension.height + 0.5) / (double)dimension.width);
        StringBuffer stringBuffer = new StringBuffer(d.toString());
        if (stringBuffer.length() > 8) {
            stringBuffer.setLength(8);
        }
        this.setInputValue(9, new String(stringBuffer));
        if (bl) {
            dXLinkApplication.setEocMode(true);
        }
    }

    protected boolean showWorld(String string) {
        Network network = this.getNetwork();
        DXApplication dXApplication = this.getNetwork().getApplet();
        dXApplication.showWorld(this.getName() + "_" + this.getInstanceNumber(), string, this.image_id);
        return true;
    }

    protected boolean showObject(String string) {
        Network network = this.getNetwork();
        DXLinkApplication dXLinkApplication = (DXLinkApplication)this.getNetwork().getApplet();
        dXLinkApplication.showObject(this.getName() + "_" + this.getInstanceNumber(), string, this.image_id);
        return true;
    }

    public boolean setInteractionMode(int n, long l) {
        if (!(n != 1 && n != 6 && n != 4 && n != 3 || this.hasCamera())) {
            return false;
        }
        if (n == 3 && this.isPerspective()) {
            return false;
        }
        if (n == 5) {
            if (this.getCacheCount() <= 1) {
                return false;
            }
            if (this.iw != null && this.iw.getCacheSize() <= 1) {
                return false;
            }
            DXApplication dXApplication = this.getNetwork().getApplet();
            if (!dXApplication.getCachingMode()) {
                return false;
            }
        }
        if (n == this.interaction_mode) {
            return true;
        }
        int n2 = this.interaction_mode;
        this.interaction_mode = n;
        DXApplication dXApplication = this.getNetwork().getApplet();
        PickNode pickNode = dXApplication.getSelectedPickNode();
        if (this.iw != null && !this.orbit_mode) {
            this.iw.setInteractionMode(this.interaction_mode, l);
            if (this.interaction_mode == 6) {
                if (pickNode != null) {
                    pickNode.setInputValueQuietly(2, "\"" + this.getMatchString() + "\"");
                }
            } else if (this.interaction_mode == 2) {
                this.orbit_mode = true;
                this.setCacheSize(9);
                if (this.web_options_node != null) {
                    this.web_options_node.setOrbitMode(true);
                }
            }
        }
        if (n2 == 6) {
            if (pickNode != null) {
                pickNode.setInputValueQuietly(2, "NULL");
                pickNode.setInputValueQuietly(3, "NULL");
                this.resetPickList();
            }
        } else if (n2 == 2) {
            this.orbit_mode = false;
            if (this.web_options_node != null) {
                this.web_options_node.setOrbitMode(false);
            }
        }
        return true;
    }

    public void addPickLocation(int n, int n2) {
        String string = "[" + n + ", " + n2 + "]}";
        if (this.pick_list == null) {
            this.pick_list = "{" + string;
        } else {
            this.pick_list = this.pick_list.replace('}', ',');
            this.pick_list = this.pick_list + string;
        }
        DXApplication dXApplication = this.getNetwork().getApplet();
        PickNode pickNode = dXApplication.getSelectedPickNode();
        if (pickNode != null) {
            if (this.iw != null) {
                this.iw.addPickLocation(n, n2);
            }
            pickNode.setInputValue(3, this.pick_list);
        }
    }

    protected void resetPickList() {
        this.pick_list = null;
        if (this.iw != null) {
            this.iw.resetPickList();
        }
        DXApplication dXApplication = this.getNetwork().getApplet();
        PickNode pickNode = dXApplication.getSelectedPickNode();
        pickNode.setInputValueQuietly(3, "NULL");
    }

    public double[] getTo() {
        return this.getVector(this.getInputValueString(5));
    }

    public double[] getFrom() {
        return this.getVector(this.getInputValueString(6));
    }

    public double[] getUp() {
        return this.getVector(this.getInputValueString(10));
    }

    public boolean hasCamera() {
        if (this.getInputValueString(5) == null) {
            return false;
        }
        if (this.getInputValueString(6) == null) {
            return false;
        }
        if (this.getInputValueString(10) == null) {
            return false;
        }
        if (this.getInputValueString(7) == null && this.getInputValueString(11) == null) {
            return false;
        }
        DXApplication dXApplication = this.getNetwork().getApplet();
        return dXApplication.isConnected();
    }

    public double getWidth() {
        String string = this.getInputValueString(7);
        Double d = new Double(string);
        return d;
    }

    public double getAngle() {
        Double d = new Double(this.getInputValueString(11));
        return d;
    }

    private double[] getVector(String string) {
        double[] dArray = new double[4];
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "[, ]");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            Double d = new Double(string2);
            dArray[n++] = d;
        }
        if (n < 3) {
            dArray[3] = 1.0;
        }
        return dArray;
    }

    public void setTo(double[] dArray, boolean bl) {
        String string = "[ " + new Float(dArray[0]).toString() + ", " + new Float(dArray[1]).toString() + ", " + new Float(dArray[2]).toString() + " ]";
        this.setInputValueString(5, string);
        if (bl) {
            this.setInputValue(5, string);
        } else {
            this.setInputValueQuietly(5, string);
        }
    }

    public void setUp(double[] dArray, boolean bl) {
        String string = "[ " + new Float(dArray[0]).toString() + ", " + new Float(dArray[1]).toString() + ", " + new Float(dArray[2]).toString() + " ]";
        this.setInputValueString(10, string);
        if (bl) {
            this.setInputValue(10, string);
        } else {
            this.setInputValueQuietly(10, string);
        }
    }

    public void setFrom(double[] dArray, boolean bl) {
        String string = "[ " + new Float(dArray[0]).toString() + ", " + new Float(dArray[1]).toString() + ", " + new Float(dArray[2]).toString() + " ]";
        this.setInputValueString(6, string);
        if (bl) {
            this.setInputValue(6, string);
        } else {
            this.setInputValueQuietly(6, string);
        }
    }

    public void setWidth(double d, boolean bl) {
        String string = new Float(d).toString();
        this.setInputValueString(7, string);
        if (bl) {
            this.setInputValue(7, string);
        } else {
            this.setInputValueQuietly(7, string);
        }
    }

    public void setAngle(double d, boolean bl) {
        String string = new Float(d).toString();
        this.setInputValueString(11, string);
        if (bl) {
            this.setInputValue(11, string);
        } else {
            this.setInputValueQuietly(11, string);
        }
    }

    public void resetCamera(boolean bl, boolean bl2) {
        String string;
        String string2 = string = bl ? "1" : "0";
        if (this.isPerspective()) {
            if (bl2) {
                this.setInputValue(21, string);
                this.setInputValue(11, "30.0");
            } else {
                this.setInputValueQuietly(21, string);
                this.setInputValueQuietly(11, "30.0");
            }
        } else if (bl2) {
            this.setInputValue(21, string);
        } else {
            this.setInputValueQuietly(21, string);
        }
    }

    @Override
    public void addInputArc(int n, Node node, int n2) {
        super.addInputArc(n, node, n2);
        if (n == 49) {
            this.web_options_node = (WebOptionsNode)node;
            this.setGroupName(node.getInputValueString(10));
        }
    }

    public boolean isInteractionModeConnected() {
        return this.isInputConnected(41);
    }

    public void setView(int n, boolean bl) {
        if (this.iw != null) {
            this.iw.setView(n, bl);
        }
    }

    @Override
    public String getMatchString() {
        DXLinkApplication dXLinkApplication = (DXLinkApplication)this.getNetwork().getApplet();
        return dXLinkApplication.getMacroName() + "_Image_" + this.getInstanceNumber();
    }

    @Override
    public void enableJava() {
        super.enableJava();
        DXLinkApplication dXLinkApplication = (DXLinkApplication)this.getNetwork().getApplet();
        this.setInputValueQuietly(1, "\"" + this.getMatchString() + "\"");
    }
}

