/*
 * Decompiled with CFR 0.152.
 */
package dx.net;

import dx.client.AppletClient;
import dx.net.DXApplication;
import dx.net.Gnomon;
import dx.net.ImageNode;
import dx.net.Network;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public abstract class ImageWindow
extends AppletClient
implements Runnable,
KeyListener,
MouseListener,
MouseMotionListener {
    public static final int NO_MODE = 0;
    public static final int ROTATE_MODE = 1;
    public static final int ORBIT_MODE = 2;
    public static final int PAN_MODE = 3;
    public static final int ZOOM_MODE = 4;
    public static final int LOOP_MODE = 5;
    public static final int PICK_MODE = 6;
    public static final int RESET_CAMERA = 7;
    public static final int LAST_MODE = 7;
    public static final int FRONT = 0;
    public static final int BACK = 1;
    public static final int TOP = 2;
    public static final int BOTTOM = 3;
    public static final int RIGHT = 4;
    public static final int LEFT = 5;
    public static final int DIAGONAL = 6;
    public static final int OFF_FRONT = 7;
    public static final int OFF_BACK = 8;
    public static final int OFF_TOP = 9;
    public static final int OFF_BOTTOM = 10;
    public static final int OFF_RIGHT = 11;
    public static final int OFF_LEFT = 12;
    public static final int OFF_DIAGONAL = 13;
    private static final int GRID_SIZE = 2;
    private static final double COS05 = 0.996;
    private static final double SIN15 = 0.259;
    private static final double COS15 = 0.966;
    private static final double SIN25 = 0.423;
    private static final double COS25 = 0.906;
    private static final double SIN45 = 0.707;
    private static final double SIN35 = 0.574;
    public static final double PI = 3.1415926;
    public static final int XAXIS = 1;
    public static final int YAXIS = 2;
    public static final int ZAXIS = 3;
    private String initial_node_name = null;
    private Thread animation = null;
    private long start_time;
    private ImageNode node = null;
    public Vector pick_list = null;
    private int interactionMode = 0;
    private Point start_point;
    private Point pan_point;
    private Gnomon gnomon = null;
    private Point edge;
    private double aspect;
    private int orbit_seq = -1;
    private Vector images = null;
    private boolean using_image = false;
    private int orbit_x;
    private int orbit_y;
    private int orbit_frame;

    public void associate(ImageNode imageNode) {
        this.node = imageNode;
    }

    public String getInitialNodeName(Network network) {
        DXApplication dXApplication = network.getApplet();
        return dXApplication.getMacroName() + "_" + this.initial_node_name;
    }

    @Override
    public String getName() {
        return this.initial_node_name;
    }

    public static boolean IsGroupInteraction(int n) {
        switch (n) {
            case 0: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (this.interactionMode == 2) {
            this.orbitDrag(n, n2);
            return;
        }
        if (this.interactionMode == 1) {
            this.gnomon.doDrag(n, n2);
            return;
        }
        if (this.interactionMode == 4) {
            if (this.node == null) {
                return;
            }
            if (n > this.edge.x) {
                return;
            }
            if (n < this.edge.x >> 1) {
                return;
            }
            this.rubberBand(this.start_point);
            int n3 = (int)(this.aspect * (double)n);
            this.start_point.setLocation(n, n3);
            this.rubberBand(this.start_point);
            return;
        }
        if (this.interactionMode == 3) {
            if (this.node == null) {
                return;
            }
            if (n > this.edge.x) {
                return;
            }
            if (n < 0) {
                return;
            }
            if (n2 > this.edge.y) {
                return;
            }
            if (n2 < 0) {
                return;
            }
            this.crosshair(this.start_point);
            this.start_point.setLocation(n, n2);
            this.crosshair(this.start_point);
            return;
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (this.interactionMode == 1) {
            this.gnomon.doneDrag();
            return;
        }
        if (this.interactionMode == 4) {
            if (this.node == null) {
                return;
            }
            this.rubberBand(this.start_point);
            int n3 = this.start_point.x - (this.edge.x - this.start_point.x);
            float f = (float)n3 / (float)this.edge.x;
            if ((mouseEvent.getModifiers() & 2) != 0) {
                f = 1.0f + f;
            }
            if (!this.node.isPerspective()) {
                double d = this.node.getWidth();
                this.node.setWidth(d *= (double)f, true);
            } else {
                double d = this.node.getAngle();
                this.node.setTo(this.node.getTo(), false);
                this.node.setFrom(this.node.getFrom(), false);
                this.node.setAngle(d *= (double)f, true);
            }
            return;
        }
        if (this.interactionMode == 3) {
            if (this.node == null) {
                return;
            }
            float f = 1.0f + (float)(n2 - this.pan_point.y) / (float)this.edge.y;
            double[] dArray = this.node.getTo();
            double[] dArray2 = this.node.getFrom();
            double[] dArray3 = this.node.getUp();
            double d = this.node.getWidth();
            double[] dArray4 = new double[3];
            double d2 = d * this.aspect;
            dArray4[0] = dArray3[0] * d2;
            dArray4[1] = dArray3[1] * d2;
            dArray4[2] = dArray3[2] * d2;
            dArray2[0] = dArray2[0] - dArray4[0] + dArray4[0] * (double)f;
            dArray2[1] = dArray2[1] - dArray4[1] + dArray4[1] * (double)f;
            dArray2[2] = dArray2[2] - dArray4[2] + dArray4[2] * (double)f;
            dArray[0] = dArray[0] - dArray4[0] + dArray4[0] * (double)f;
            dArray[1] = dArray[1] - dArray4[1] + dArray4[1] * (double)f;
            dArray[2] = dArray[2] - dArray4[2] + dArray4[2] * (double)f;
            f = 1.0f + (float)(n - this.pan_point.x) / (float)this.edge.x;
            double[] dArray5 = new double[]{dArray2[0] - dArray[0], dArray2[1] - dArray[1], dArray2[2] - dArray[2], 0.0};
            double[] dArray6 = ImageWindow.cross(dArray3, dArray5);
            double[] dArray7 = new double[3];
            double d3 = Math.pow(dArray6[0], 2.0) + Math.pow(dArray6[1], 2.0) + Math.pow(dArray6[2], 2.0);
            d3 = Math.sqrt(d3);
            dArray6[0] = dArray6[0] / d3;
            dArray6[1] = dArray6[1] / d3;
            dArray6[2] = dArray6[2] / d3;
            dArray7[0] = dArray6[0] * d;
            dArray7[1] = dArray6[1] * d;
            dArray7[2] = dArray6[2] * d;
            dArray2[0] = dArray2[0] + dArray7[0] - dArray7[0] * (double)f;
            dArray2[1] = dArray2[1] + dArray7[1] - dArray7[1] * (double)f;
            dArray2[2] = dArray2[2] + dArray7[2] - dArray7[2] * (double)f;
            dArray[0] = dArray[0] + dArray7[0] - dArray7[0] * (double)f;
            dArray[1] = dArray[1] + dArray7[1] - dArray7[1] * (double)f;
            dArray[2] = dArray[2] + dArray7[2] - dArray7[2] * (double)f;
            this.node.setTo(dArray, false);
            this.node.setFrom(dArray2, true);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        Dimension dimension = this.getSize();
        this.edge.setLocation(dimension.width, dimension.height);
        this.aspect = (double)dimension.height / (double)dimension.width;
        if ((mouseEvent.getModifiers() & 1) != 0) {
            try {
                this.getAppletContext().showDocument(new URL(this.getImageUrl()), "temp");
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        if (this.interactionMode == 2) {
            this.orbitDown(n, n2);
            return;
        }
        if (this.interactionMode == 6) {
            if (this.node == null) {
                return;
            }
            int n3 = dimension.height - n2;
            this.node.addPickLocation(n, n3);
            return;
        }
        if (this.interactionMode == 4) {
            if (this.node == null) {
                return;
            }
            int n4 = (int)(this.aspect * (double)n);
            this.start_point.setLocation(n, n4);
            this.rubberBand(this.start_point);
            return;
        }
        if (this.interactionMode == 1) {
            if (this.node == null) {
                return;
            }
            this.gnomon.initDrag(mouseEvent.getModifiers() & 2, n, n2);
            return;
        }
        if (this.interactionMode == 3) {
            if (this.node == null) {
                return;
            }
            this.start_point.setLocation(n, n2);
            this.pan_point = new Point(n, n2);
            this.crosshair(this.start_point);
        }
    }

    public int getInteractionMode() {
        return this.interactionMode;
    }

    public void setInteractionMode(int n, long l) {
        int n2 = this.interactionMode;
        if (n >= 0 && n <= 7) {
            this.interactionMode = n;
        }
        if (n2 == 1) {
            this.setRotateMode(false);
        }
        if (n2 == 5) {
            this.setLoopMode(false, l);
        }
        if (n == 1) {
            this.setRotateMode(true);
        }
        if (n == 5) {
            this.setLoopMode(true, l);
        }
    }

    private void crosshair(Point point) {
        Graphics graphics = this.getGraphics();
        graphics.setXORMode(Color.black);
        graphics.setColor(Color.white);
        graphics.drawLine(point.x - 6, point.y, point.x + 6, point.y);
        graphics.drawLine(point.x, point.y - 6, point.x, point.y + 6);
    }

    private void rubberBand(Point point) {
        Graphics graphics = this.getGraphics();
        int n = this.edge.x - point.x;
        int n2 = this.edge.y - point.y;
        int n3 = point.x - n;
        int n4 = point.y - n2;
        graphics.setXORMode(Color.black);
        graphics.setColor(Color.white);
        graphics.drawRect(n, n2, n3, n4);
    }

    public void showImage(String string) {
        this.requestImage(string);
    }

    public ImageWindow() {
        Date date = new Date();
        this.start_time = date.getTime();
        this.start_point = new Point();
        this.edge = new Point();
        this.aspect = 0.0;
    }

    public void setCurrentImage(int n) {
        try {
            Image image = (Image)this.images.elementAt(n);
            super.setCurrentImage(image, this.getCurrentSequence(), this.getCurrentLoop());
            if (this.interactionMode == 1 && this.gnomon != null) {
                this.gnomon.setImage(image);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public synchronized void clearImageCache() {
        if (this.images != null) {
            this.images.removeAllElements();
            this.images = null;
        }
    }

    public synchronized int getCacheSize() {
        if (this.images == null) {
            return 0;
        }
        return this.images.size();
    }

    @Override
    protected void setCurrentImage(Image image, int n, int n2) {
        if (this.interactionMode == 2) {
            this.setOrbitImage(image, n, n2);
        } else {
            int n3 = 0;
            boolean bl = false;
            if (this.loadNextImage()) {
                n3 = n2 + 1;
                bl = true;
            } else {
                try {
                    DXApplication dXApplication = this.node.getNetwork().getApplet();
                    bl = dXApplication.getCachingMode();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.node != null) {
                    n3 = this.node.getCacheCount();
                }
            }
            if (n3 > 0 && bl) {
                if (this.images == null) {
                    this.images = new Vector(n3);
                }
                this.images.addElement(image);
                while (n3 < this.images.size()) {
                    this.images.removeElementAt(0);
                }
            }
            super.setCurrentImage(image, n, n2);
            if (this.interactionMode == 1 && this.gnomon != null) {
                this.gnomon.setImage(image);
            }
        }
    }

    private void setOrbitImage(Image image, int n, int n2) {
        if (n < this.orbit_seq) {
            return;
        }
        if (n > this.orbit_seq) {
            if (this.images != null) {
                this.images.removeAllElements();
            }
            this.images = null;
            this.orbit_frame = 0;
            super.setCurrentImage(image, n, n2);
        }
        if (this.images == null) {
            this.images = new Vector(10);
        }
        this.images.addElement(image);
        this.orbit_seq = n;
    }

    private boolean orbitDown(int n, int n2) {
        this.orbit_x = n;
        this.orbit_y = n2;
        return true;
    }

    private boolean orbitDrag(int n, int n2) {
        int n3 = this.orbit_frame;
        if (Math.abs(n - this.orbit_x) > 10) {
            if (n > this.orbit_x && n3 % 3 != 2) {
                ++n3;
            } else if (n < this.orbit_x && n3 % 3 != 0) {
                --n3;
            }
            this.orbit_x = n;
        }
        if (Math.abs(n2 - this.orbit_y) > 10) {
            if (n2 > this.orbit_y && n3 / 3 != 2) {
                n3 += 3;
            } else if (n2 < this.orbit_y && n3 / 3 != 0) {
                n3 -= 3;
            }
            this.orbit_y = n2;
        }
        if (n3 != this.orbit_frame) {
            try {
                Image image = (Image)this.images.elementAt(n3);
                super.setCurrentImage(image, this.orbit_seq, n3);
                this.orbit_frame = n3;
                this.repaint();
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return true;
    }

    @Override
    public void init() {
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        super.init();
        this.initial_node_name = this.getParameter("IMAGE_NODE");
        String string = this.getParameter("OPEN_IN_ORBIT_MODE");
        if (string != null && Boolean.valueOf(string).booleanValue()) {
            this.setInteractionMode(2, 0L);
        }
    }

    protected synchronized int getAnimateSpeed() {
        if (this.node != null) {
            return this.node.getCacheSpeed();
        }
        return 250;
    }

    protected void setLoopMode(boolean bl, long l) {
        if (bl) {
            this.animate(l);
        } else {
            if (this.animation != null) {
                this.animation.interrupt();
                this.animation = null;
            }
            try {
                Image image = (Image)this.images.lastElement();
                int n = this.getCurrentSequence();
                super.setCurrentImage(image, n, this.getCurrentLoop());
                this.repaint();
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    protected void animate(long l) {
        if (this.animation != null) {
            this.animation.interrupt();
            this.animation = null;
        }
        if (this.images == null) {
            return;
        }
        this.start_time = l;
        this.animation = new Thread(this);
        this.animation.start();
    }

    public void interrupt() {
        if (this.animation != null) {
            this.animation.interrupt();
            this.animation = null;
        }
    }

    @Override
    public void run() {
        boolean bl = false;
        try {
            long l = this.start_time + (long)this.getAnimateSpeed();
            block6: while (!bl && this.images != null && this.images.size() > 1) {
                if (this.node.getPalindromeMode()) {
                    int n = this.images.size();
                    for (int i = n - 2; i >= 1; --i) {
                        block16: {
                            Image image = (Image)this.images.elementAt(i);
                            super.setCurrentImage(image, this.getCurrentSequence(), 0);
                            this.repaint();
                            try {
                                long l2 = new Date().getTime();
                                int n2 = (int)(l - l2);
                                if (n2 > 0) {
                                    Thread.sleep(n2);
                                } else if (n2 < -10000) {
                                    bl = true;
                                }
                                break block16;
                            }
                            catch (InterruptedException interruptedException) {
                                bl = true;
                            }
                            break;
                        }
                        l += (long)this.getAnimateSpeed();
                    }
                }
                Enumeration enumeration = this.images.elements();
                while (!bl && enumeration.hasMoreElements()) {
                    block17: {
                        Image image = (Image)enumeration.nextElement();
                        super.setCurrentImage(image, this.getCurrentSequence(), 0);
                        this.repaint();
                        try {
                            long l3 = new Date().getTime();
                            int n = (int)(l - l3);
                            if (n > 0) {
                                Thread.sleep(n);
                            } else if (n < -10000) {
                                bl = true;
                            }
                            break block17;
                        }
                        catch (InterruptedException interruptedException) {
                            bl = true;
                        }
                        continue block6;
                    }
                    l += (long)this.getAnimateSpeed();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addPickLocation(int n, int n2) {
        if (this.pick_list == null) {
            this.pick_list = new Vector(4);
        }
        Dimension dimension = this.getSize();
        int n3 = dimension.height - n2;
        Point point = new Point(n, n3);
        this.pick_list.addElement(point);
        this.repaint();
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.interactionMode == 6) {
            if (this.pick_list == null) {
                return;
            }
            Enumeration enumeration = this.pick_list.elements();
            graphics.setColor(Color.white);
            while (enumeration.hasMoreElements()) {
                Point point = (Point)enumeration.nextElement();
                graphics.fill3DRect(point.x - 2, point.y - 2, 4, 4, true);
            }
        } else if (this.interactionMode == 1) {
            this.gnomon.repaint();
        }
    }

    public void resetPickList() {
        this.pick_list = null;
        this.repaint();
    }

    protected void setRotateMode(boolean bl) {
        if (this.gnomon == null && bl) {
            this.createGnomon();
        }
        if (bl) {
            this.gnomon.setImage(this.getCurrentImage());
            this.add(this.gnomon);
        } else if (this.gnomon != null) {
            this.remove(this.gnomon);
        }
    }

    private void createGnomon() {
        this.setLayout(null);
        Dimension dimension = this.getSize();
        this.gnomon = new Gnomon(this.node, dimension.width, dimension.height);
        int n = dimension.width - 95;
        int n2 = dimension.height - 95;
        this.gnomon.setBounds(n, n2, 90, 90);
        this.gnomon.setImage(this.getCurrentImage());
    }

    public static double[] normalize(double[] dArray, double[] dArray2) {
        double d = Math.pow(dArray[0] - dArray2[0], 2.0);
        d += Math.pow(dArray[1] - dArray2[1], 2.0);
        d += Math.pow(dArray[2] - dArray2[2], 2.0);
        d = Math.sqrt(d);
        double[] dArray3 = new double[]{(dArray[0] - dArray2[0]) / d, (dArray[1] - dArray2[1]) / d, (dArray[2] - dArray2[2]) / d};
        return dArray3;
    }

    public static double[][] getTransform(double[] dArray, double[] dArray2, double d) {
        double[] dArray3 = ImageWindow.normalize(dArray, dArray2);
        double[][] dArray4 = new double[4][4];
        ImageWindow.I44(dArray4);
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        dArray4[0][0] = d2 + Math.pow(dArray3[0], 2.0) * (1.0 - d2);
        dArray4[1][1] = d2 + Math.pow(dArray3[1], 2.0) * (1.0 - d2);
        dArray4[2][2] = d2 + Math.pow(dArray3[2], 2.0) * (1.0 - d2);
        dArray4[0][1] = dArray3[0] * dArray3[1] * (1.0 - d2) + dArray3[2] * d3;
        dArray4[1][0] = dArray3[0] * dArray3[1] * (1.0 - d2) - dArray3[2] * d3;
        dArray4[2][1] = dArray3[1] * dArray3[2] * (1.0 - d2) - dArray3[0] * d3;
        dArray4[1][2] = dArray3[1] * dArray3[2] * (1.0 - d2) + dArray3[0] * d3;
        dArray4[2][0] = dArray3[0] * dArray3[2] * (1.0 - d2) + dArray3[1] * d3;
        dArray4[0][2] = dArray3[0] * dArray3[2] * (1.0 - d2) - dArray3[1] * d3;
        return dArray4;
    }

    public static double[] Rotate(double[] dArray, double[][] dArray2) {
        int n;
        double[] dArray3 = new double[4];
        for (n = 0; n < 4; ++n) {
            dArray3[n] = 0.0;
        }
        for (int i = 0; i < 4; ++i) {
            for (n = 0; n < 4; ++n) {
                int n2 = i;
                dArray3[n2] = dArray3[n2] + dArray[n] * dArray2[n][i];
            }
        }
        return dArray3;
    }

    private static void I44(double[][] dArray) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                dArray[i][j] = i == j ? 1.0 : 0.0;
            }
        }
    }

    public static double[] cross(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[]{dArray[1] * dArray2[2] - dArray[2] * dArray2[1], dArray[2] * dArray2[0] - dArray[0] * dArray2[2], dArray[0] * dArray2[1] - dArray[1] * dArray2[0], 1.0};
        return dArray3;
    }

    public static double dot(float[] fArray, double[] dArray) {
        int n = fArray.length;
        if (n != dArray.length) {
            return 0.0;
        }
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += (double)fArray[i] * dArray[i];
        }
        return d;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        int n2 = keyEvent.getModifiers();
        if (this.node != null) {
            boolean bl = false;
            if (n == 69 && (n2 & 2) > 0) {
                bl = true;
            } else if (n == 82 && (n2 & 2) > 0) {
                bl = true;
            } else if (n == 70 && (n2 & 2) > 0) {
                bl = true;
            } else if (n == 9 && (n2 & 2) > 0) {
                bl = true;
            } else if (n == 32 && (n2 & 2) > 0) {
                bl = true;
            } else if (n == 67 && (n2 & 2) > 0) {
                bl = true;
            }
            if (bl) {
                DXApplication dXApplication = this.node.getNetwork().getApplet();
                dXApplication.updateSelectedImageNode(keyEvent, this.node);
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    public void setView(int n, boolean bl) {
        double[] dArray = this.node.getFrom();
        double[] dArray2 = this.node.getUp();
        double[] dArray3 = this.node.getTo();
        double[] dArray4 = new double[3];
        int n2 = 0;
        int n3 = 1;
        int n4 = 2;
        dArray4[n2] = dArray[0] - dArray3[0];
        dArray4[n3] = dArray[1] - dArray3[1];
        dArray4[n4] = dArray[2] - dArray3[2];
        double d = Math.sqrt(dArray4[n2] * dArray4[n2] + dArray4[n3] * dArray4[n3] + dArray4[n4] * dArray4[n4]);
        dArray2[n2] = 0.0;
        dArray2[n3] = 1.0;
        dArray2[n4] = 0.0;
        switch (n) {
            case 0: {
                dArray4[n2] = 0.0;
                dArray4[n3] = 0.0;
                dArray4[n4] = 1.0;
                break;
            }
            case 7: {
                dArray4[n3] = 0.259;
                dArray4[n2] = 0.259;
                dArray4[n4] = 0.966;
                break;
            }
            case 1: {
                dArray4[n2] = 0.0;
                dArray4[n3] = 0.0;
                dArray4[n4] = -1.0;
                break;
            }
            case 8: {
                dArray4[n3] = 0.259;
                dArray4[n2] = 0.259;
                dArray4[n4] = -0.966;
                break;
            }
            case 2: {
                dArray4[n2] = 0.0;
                dArray4[n3] = 1.0;
                dArray4[n4] = 0.0;
                dArray2[n3] = 0.0;
                dArray2[n2] = 0.0;
                dArray2[n4] = -1.0;
                break;
            }
            case 9: {
                dArray4[n4] = -0.259;
                dArray4[n2] = -0.259;
                dArray4[n3] = 0.966;
                dArray2[n3] = 0.0;
                dArray2[n2] = 0.0;
                dArray2[n4] = -1.0;
                break;
            }
            case 3: {
                dArray4[n2] = 0.0;
                dArray4[n3] = -1.0;
                dArray4[n4] = 0.0;
                dArray2[n3] = 0.0;
                dArray2[n2] = 0.0;
                dArray2[n4] = 1.0;
                break;
            }
            case 10: {
                dArray4[n4] = 0.259;
                dArray4[n2] = 0.259;
                dArray4[n3] = -0.966;
                dArray2[n3] = 0.0;
                dArray2[n2] = 0.0;
                dArray2[n4] = 1.0;
                break;
            }
            case 4: {
                dArray4[n2] = 1.0;
                dArray4[n3] = 0.0;
                dArray4[n4] = 0.0;
                break;
            }
            case 11: {
                dArray4[n2] = 0.996;
                dArray4[n4] = 0.259;
                dArray4[n3] = 0.259;
                break;
            }
            case 5: {
                dArray4[n2] = -1.0;
                dArray4[n3] = 0.0;
                dArray4[n4] = 0.0;
                break;
            }
            case 12: {
                dArray4[n2] = -0.996;
                dArray4[n4] = 0.259;
                dArray4[n3] = 0.259;
                break;
            }
            case 6: {
                dArray4[n4] = 0.707;
                dArray4[n3] = 0.707;
                dArray4[n2] = 0.707;
                break;
            }
            case 13: {
                dArray4[n4] = 0.574;
                dArray4[n3] = 0.574;
                dArray4[n2] = 0.574;
            }
        }
        double d2 = Math.sqrt(dArray4[n2] * dArray4[n2] + dArray4[n3] * dArray4[n3] + dArray4[n4] * dArray4[n4]);
        dArray4[n2] = dArray4[n2] / d2;
        dArray4[n3] = dArray4[n3] / d2;
        dArray4[n4] = dArray4[n4] / d2;
        int n5 = n2;
        dArray4[n5] = dArray4[n5] * d;
        int n6 = n3;
        dArray4[n6] = dArray4[n6] * d;
        int n7 = n4;
        dArray4[n7] = dArray4[n7] * d;
        dArray[n2] = dArray4[n2] + dArray3[n2];
        dArray[n3] = dArray4[n3] + dArray3[n3];
        dArray[n4] = dArray4[n4] + dArray3[n4];
        this.node.setFrom(dArray, false);
        this.node.setUp(dArray2, bl);
    }
}

