/*
 * Decompiled with CFR 0.152.
 */
package dx.net;

import dx.net.DXApplication;
import dx.net.DrivenNode;
import dx.net.Network;

public final class SequencerNode
extends DrivenNode {
    private int next;
    private boolean reset = true;
    private static final int ID_PARAM_NUM = 1;
    private static final int DATA_PARAM_NUM = 2;
    private static final int FRAME_PARAM_NUM = 3;
    private static final int MIN_PARAM_NUM = 4;
    private static final int MAX_PARAM_NUM = 5;
    private static final int DELTA_PARAM_NUM = 6;
    private static final int ATTR_PARAM_NUM = 7;

    public SequencerNode(Network network, String string, int n, String string2) {
        super(network, string, n, string2);
    }

    @Override
    public boolean handleAssignment(String string, String string2) {
        boolean bl = false;
        if (string.equals("min")) {
            this.setInputValueString(4, string2);
            bl = true;
        } else if (string.equals("max")) {
            this.setInputValueString(5, string2);
            bl = true;
        } else if (string.equals("delta")) {
            this.setInputValueString(6, string2);
            bl = true;
        } else if (string.equals("frame")) {
            this.setInputValueString(3, string2);
            bl = true;
        }
        if (bl) {
            return true;
        }
        return super.handleAssignment(string, string2);
    }

    public synchronized void step(DXApplication dXApplication) {
        int n = this.getMin();
        int n2 = this.getMax();
        int n3 = this.getDelta();
        if (this.reset) {
            this.next = n;
            this.reset = false;
            String string = "{ " + n + " " + n2 + " " + n3 + " " + n + " " + n2 + " 1 }";
            this.setInputValueQuietly(7, string);
        }
        if (this.next > n2) {
            this.reset = true;
            if (!dXApplication.getEocMode()) {
                dXApplication.DXLSend("@frame=" + n + ";");
            }
        } else {
            int n4 = this.next;
            this.next += n3;
            dXApplication.DXLSend("@frame=" + n4 + ";");
            if (!dXApplication.getEocMode()) {
                dXApplication.DXLExecuteOnce();
            }
        }
    }

    public void reset() {
        this.reset = true;
    }

    public boolean hasMoreFrames() {
        return this.next <= this.getMax();
    }

    public int getSteps() {
        int n = this.getMin();
        int n2 = this.getMax();
        int n3 = this.getDelta();
        if (n3 == 0) {
            return 10;
        }
        int n4 = (n2 - n) / n3;
        return n4 + 1;
    }

    @Override
    protected boolean needsSpacesReplaced() {
        return true;
    }

    public int getMin() {
        int n = 0;
        String string = this.getInputValueString(4);
        try {
            n = Integer.parseInt(string);
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("SequencerNode: Missing min value");
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("SequencerNode: Illegal min value: " + string);
        }
        return n;
    }

    public int getMax() {
        int n = 100;
        String string = this.getInputValueString(5);
        try {
            n = Integer.parseInt(string);
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("SequencerNode: Missing max value");
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("SequencerNode: Illegal max value: " + string);
        }
        return n;
    }

    public int getDelta() {
        int n = 1;
        String string = this.getInputValueString(6);
        try {
            n = Integer.parseInt(string);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    public int getFrame() {
        if (this.reset) {
            this.next = this.getMin();
            this.reset = false;
        }
        return this.next;
    }

    public void stepQuietly() {
        if (this.reset) {
            this.next = this.getMin();
            this.reset = false;
        } else {
            this.next += this.getDelta();
            if (this.next > this.getMax()) {
                this.reset = true;
            }
        }
    }
}

