/*
 * Decompiled with CFR 0.152.
 */
package dx.net;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;

public class TabbedPanel
extends Panel
implements MouseListener {
    protected Vector tabName = new Vector();
    protected Vector panels = new Vector();
    protected Panel cardPanel = new Panel();
    protected int[] tabWidths;
    protected String selectedPanel;
    protected Font tabFont = null;
    protected Insets insets = new Insets(this.insetPadding + this.tabHeight, this.insetPadding, this.insetPadding, this.insetPadding);
    protected int tabHeight = 21;
    protected int tabWidthBuffer = 13;
    protected int insetPadding = 14;

    public TabbedPanel() {
        this.setLayout(null);
        this.addMouseListener(this);
        this.cardPanel.setLayout(new CardLayout());
        this.add(this.cardPanel);
        this.tabFont = new Font("Dialog", 12, 0);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getY() < this.tabHeight) {
            int n = 0;
            for (int i = 0; i < this.tabName.size(); ++i) {
                if (mouseEvent.getX() >= (n += this.tabWidths[i])) continue;
                this.setPanel((String)this.tabName.elementAt(i));
                return;
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public Dimension getMinimumSize() {
        Object object;
        int n;
        int n2 = 0;
        int n3 = 0;
        FontMetrics fontMetrics = this.getFontMetrics(this.tabFont);
        for (n = 0; n < this.tabName.size(); ++n) {
            object = (String)this.tabName.elementAt(n);
            if (fontMetrics.stringWidth((String)object) == 0) {
                n2 += 7 * ((String)object).length() + this.tabWidthBuffer;
                continue;
            }
            n2 += fontMetrics.stringWidth((String)object) + this.tabWidthBuffer;
        }
        for (n = 0; n < this.panels.size(); ++n) {
            object = ((Panel)this.panels.elementAt(n)).getMinimumSize();
            n2 = Math.max(n2, ((Dimension)object).width + this.insets.left + this.insets.right);
            n3 = Math.max(n3, ((Dimension)object).height);
        }
        return new Dimension(n2, n3 += this.insets.top + this.insets.bottom);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        this.cardPanel.setBounds(this.insets.left, this.insets.top, n3 - this.insets.left - this.insets.right, n4 - this.insets.top - this.insets.bottom);
        super.setBounds(n, n2, n3, n4);
    }

    public void addPanel(Panel panel, String string) {
        this.tabName.addElement(string);
        this.panels.addElement(panel);
        this.cardPanel.add(string, panel);
        if (this.panels.size() == 1) {
            this.selectedPanel = string;
        }
    }

    public void removePanel(String string) {
        int n = this.tabName.indexOf(string);
        if (n == -1) {
            throw new IllegalArgumentException(string + " is not a panel in this TabbedPanel");
        }
        this.tabName.removeElementAt(n);
        this.panels.removeElementAt(n);
        if (string.equals(this.selectedPanel)) {
            if (this.tabName.size() > 0) {
                this.setPanel((String)this.tabName.elementAt(0));
            } else {
                this.selectedPanel = null;
            }
        }
    }

    public void setPanel(String string) {
        if (string.equals(this.selectedPanel)) {
            return;
        }
        this.selectedPanel = string;
        ((CardLayout)this.cardPanel.getLayout()).show(this.cardPanel, string);
        this.repaint();
    }

    public String getSelectedPanelName() {
        return this.selectedPanel;
    }

    public Panel getSelectedPanel() {
        return (Panel)this.panels.elementAt(this.tabName.indexOf(this.selectedPanel));
    }

    @Override
    public Insets getInsets() {
        return this.insets;
    }

    public void setInsets(Insets insets) {
        this.insets = insets;
    }

    public int getTabHeight() {
        return this.tabHeight;
    }

    public void setTabHeight(int n) {
        this.tabHeight = n;
    }

    public int getTabWidthBuffer() {
        return this.tabWidthBuffer;
    }

    public void setTabWidthBuffer(int n) {
        this.tabWidthBuffer = n;
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        Color color = Color.white;
        Color color2 = this.getBackground();
        if (color2.equals(color)) {
            color = new Color(220, 220, 220);
        }
        int n = this.tabHeight - 1;
        int n2 = 0;
        int n3 = this.getSize().height - 1;
        int n4 = n2 + this.getSize().width - 1;
        graphics.setColor(Color.darkGray);
        graphics.drawLine(n2, n3, n4 - 1, n3);
        graphics.drawLine(n4, n, n4, n3);
        graphics.setColor(Color.gray);
        graphics.drawLine(n2 + 1, n3 - 1, n4 - 2, n3 - 1);
        graphics.drawLine(n4 - 1, n + 1, n4 - 1, n3 - 1);
        graphics.setColor(color);
        graphics.drawLine(n2, n, n2, n3 - 1);
        this.tabWidths = new int[this.tabName.size()];
        int n5 = -1;
        int n6 = 0;
        int n7 = 2;
        FontMetrics fontMetrics = null;
        fontMetrics = graphics.getFontMetrics(this.tabFont);
        for (int i = 0; i < this.tabName.size(); ++i) {
            String string = (String)this.tabName.elementAt(i);
            int n8 = fontMetrics.stringWidth(string) == 0 ? 7 * string.length() : fontMetrics.stringWidth(string);
            this.tabWidths[i] = n8 + this.tabWidthBuffer;
            if (this.tabName.elementAt(i).equals(this.selectedPanel)) {
                n5 = i;
                n6 = n7;
            } else {
                this.paintTab(graphics, false, n7, 0, this.tabWidths[i], n, string);
            }
            n7 += this.tabWidths[i] - 1;
        }
        if (n5 > -1) {
            this.paintTab(graphics, true, n6, 0, this.tabWidths[n5], n, (String)this.tabName.elementAt(n5));
            graphics.setColor(color);
            graphics.drawLine(n2, n, n6 - 2, n);
            graphics.drawLine(n6 + this.tabWidths[n5] + 2, n, n4 - 1, n);
        } else {
            graphics.setColor(color);
            graphics.drawLine(n2, n, n4 - 1, n);
        }
    }

    private void paintTab(Graphics graphics, boolean bl, int n, int n2, int n3, int n4, String string) {
        int n5;
        int n6;
        Color color = Color.white;
        Color color2 = this.getBackground();
        if (color2.equals(color)) {
            color = new Color(220, 220, 220);
        }
        int n7 = n;
        int n8 = n2 + 2;
        int n9 = n + n3 - 1;
        int n10 = n2 + n4 - 1;
        n4 -= 2;
        if (bl) {
            n8 -= 2;
            n7 -= 2;
            n9 += 2;
            ++n10;
        }
        graphics.setColor(Color.darkGray);
        graphics.drawLine(n9 - 1, n8 + 2, n9 - 1, n10);
        graphics.drawRect(n9 - 2, n8 + 1, 0, 0);
        graphics.setColor(Color.gray);
        graphics.drawLine(n9 - 2, n8 + 2, n9 - 2, n10);
        graphics.setColor(color);
        graphics.drawLine(n7, n8 + 2, n7, n10);
        graphics.drawLine(n7 + 2, n8, n9 - 3, n8);
        graphics.drawRect(n7 + 1, n8 + 1, 0, 0);
        graphics.setColor(Color.black);
        FontMetrics fontMetrics = graphics.getFontMetrics(this.tabFont);
        if (fontMetrics.stringWidth(string) != 0) {
            graphics.setFont(this.tabFont);
            n6 = fontMetrics.stringWidth(string);
            n5 = fontMetrics.getHeight();
        } else {
            n6 = string.length() * 7;
            n5 = 14;
        }
        graphics.drawString(string, n + (n3 - n6) / 2, n5 + n8 + 1);
        if (bl) {
            graphics.setColor(this.getBackground());
            graphics.drawLine(n7 + 1, n10, n9 - 3, n10);
            graphics.drawLine(n7 + 1, n8 + 3, n7 + 1, n10);
        }
    }
}

