/*
 * Decompiled with CFR 0.152.
 */
package dx.runtime;

import dx.runtime.Stepper;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;

public class ArrowButton
extends Canvas {
    private static int OUT = 1;
    private static int IN = 2;
    private int direction;
    private int state = OUT;
    private Stepper stepper;
    public static int LEFT = 1;
    public static int RIGHT = 2;

    public ArrowButton(int n, Stepper stepper) {
        this.direction = n;
        this.stepper = stepper;
    }

    @Override
    public boolean handleEvent(Event event) {
        if (event.id == 501) {
            this.state = IN;
            this.repaint();
            return true;
        }
        if (event.id == 502) {
            if (this.state == IN && this.changeValue()) {
                this.stepper.callCallback(this);
            }
            this.state = OUT;
            this.repaint();
            return true;
        }
        return false;
    }

    private boolean changeValue() {
        if (this.direction == LEFT) {
            return this.stepper.decrement();
        }
        return this.stepper.increment();
    }

    @Override
    public Dimension preferredSize() {
        return new Dimension(20, 20);
    }

    @Override
    public Dimension minimumSize() {
        return new Dimension(15, 15);
    }

    @Override
    public void paint(Graphics graphics) {
        Color color;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        Dimension dimension = this.getSize();
        Color color2 = Color.white;
        Color color3 = Color.black;
        if (this.direction == LEFT) {
            n6 = 4;
            n5 = dimension.width - 1;
            n4 = dimension.height - 5;
            n3 = n5;
            n2 = dimension.height >> 1;
            n = 4;
            color = this.state == OUT ? color3 : color2;
        } else {
            n6 = 0;
            n5 = dimension.width - 5;
            n4 = dimension.height - 5;
            n3 = 0;
            n2 = 4;
            n = dimension.height >> 1;
            color = this.state == OUT ? color2 : color3;
        }
        int[] nArray = new int[]{n6, n5, n3};
        int[] nArray2 = new int[]{n2, n, n4};
        graphics.setColor(new Color(187, 187, 187));
        graphics.fillPolygon(nArray, nArray2, 3);
        graphics.setColor(this.state == OUT ? color2 : color3);
        graphics.drawLine(n6, n2, n5, n);
        graphics.setColor(this.state == OUT ? color3 : color2);
        graphics.drawLine(n5, n, n3, n4);
        graphics.setColor(color);
        graphics.drawLine(n3, n4, n6, n2);
    }
}

