/*
 * Decompiled with CFR 0.152.
 */
package dx.runtime;

import dx.runtime.Interactor;
import java.util.Vector;

public abstract class BinaryInstance
extends Interactor {
    public static final int INTEGER = 1;
    public static final int SCALAR = 5;
    public static final int STRING = 32;
    public static final int VECTOR = 8;
    public static final int LIST = 0x1000000;
    protected int option_count;
    protected int output_type = 32;
    protected String[] output_values;
    protected String[] option_names;

    protected abstract void newItem(int var1, String var2);

    public abstract boolean isOptionSelected(int var1);

    public abstract void selectOption(int var1);

    public abstract void clearOptions();

    public int getOptionCount() {
        return this.option_count;
    }

    public int getOutputType() {
        return this.output_type;
    }

    public void setOptionCount(int n) {
        this.option_count = n;
        this.output_values = new String[n];
        this.option_names = new String[n];
    }

    public String getOptionValue(int n) {
        if (n > this.option_count) {
            return null;
        }
        return this.output_values[n - 1];
    }

    public void setOutputType(int n) {
        this.output_type = n;
    }

    public String getOutputValue() {
        boolean bl = false;
        String string = null;
        if ((this.output_type & 0x1000000) == 0x1000000) {
            string = "{ ";
        }
        for (int i = 1; i <= this.option_count; ++i) {
            if (!this.isOptionSelected(i)) continue;
            bl = true;
            if ((this.output_type & 0x20) == 32) {
                if (string == null) {
                    string = "\"" + this.getOptionValue(i) + "\" ";
                    continue;
                }
                string = string + "\"" + this.getOptionValue(i) + "\" ";
                continue;
            }
            string = string == null ? "" + this.getOptionValue(i) : string + " " + this.getOptionValue(i);
        }
        if (!bl) {
            string = "NULL";
        } else if ((this.output_type & 0x1000000) == 0x1000000) {
            string = string + " }";
        }
        return string;
    }

    public String getOutput2Value() {
        boolean bl = false;
        String string = null;
        if ((this.output_type & 0x1000000) == 0x1000000) {
            string = "{ ";
        }
        for (int i = 1; i <= this.option_count; ++i) {
            if (!this.isOptionSelected(i)) continue;
            bl = true;
            string = string == null ? "\"" + this.getOptionName(i) + "\" " : string + "\"" + this.getOptionName(i) + "\" ";
        }
        if (!bl) {
            string = "NULL";
        } else if ((this.output_type & 0x1000000) == 0x1000000) {
            string = string + " }";
        }
        return string;
    }

    @Override
    public String getValue() {
        return this.getOutputValue();
    }

    public void setOptions(Vector vector, Vector vector2) {
        this.clearOptions();
        int n = vector.size();
        this.setOptionCount(vector.size());
        vector.copyInto(this.option_names);
        vector2.copyInto(this.output_values);
        for (int i = 1; i <= n; ++i) {
            String string = (String)vector.elementAt(i - 1);
            this.newItem(i, string);
        }
    }

    public String getOptionName(int n) {
        if (n > this.option_count) {
            return null;
        }
        return this.option_names[n - 1];
    }
}

