/*
 * Decompiled with CFR 0.152.
 */
package dx.runtime;

import dx.net.PacketIF;
import dx.runtime.Selector;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Event;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Panel;

public class RadioGroup
extends Selector {
    Object[] buttons;
    Color local_fg = null;
    Color local_bg = null;
    Font local_font = null;
    CheckboxGroup cbg = null;
    Panel pan = null;
    boolean initialized = false;

    @Override
    public boolean action(Event event, Object object) {
        if (event.target instanceof Checkbox) {
            PacketIF packetIF = this.getNode();
            packetIF.setOutputValues(this.getOutputValue(), this.getOutput2Value());
            return true;
        }
        return false;
    }

    @Override
    protected void createPart() {
        this.pan = new Panel();
        if (this.local_bg != null) {
            this.pan.setBackground(this.local_bg);
        }
        this.ipart = this.pan;
        this.cbg = new CheckboxGroup();
        if (this.option_count > 0) {
            GridLayout gridLayout = new GridLayout(this.option_count, 0, 0, 0);
            this.pan.setLayout(gridLayout);
        }
        this.initialized = true;
        if (this.option_count == 0) {
            return;
        }
        try {
            for (int i = 1; i <= this.option_count; ++i) {
                this.newItem(i, this.getOptionName(i));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.validate();
    }

    @Override
    protected String getTypeName() {
        return "RadioButtons";
    }

    @Override
    public boolean isOptionSelected(int n) {
        Checkbox checkbox = (Checkbox)this.buttons[n - 1];
        return checkbox.getState();
    }

    @Override
    public void selectOption(int n) {
        if (this.buttons == null) {
            return;
        }
        Checkbox checkbox = (Checkbox)this.buttons[n - 1];
        if (checkbox == null) {
            return;
        }
        checkbox.setState(true);
    }

    @Override
    public void newItem(int n, String string) {
        if (!this.initialized) {
            return;
        }
        if (n > this.option_count) {
            return;
        }
        Checkbox checkbox = new Checkbox(string);
        checkbox.setCheckboxGroup(this.cbg);
        this.pan.add(checkbox);
        this.buttons[n - 1] = checkbox;
        if (this.local_fg != null) {
            checkbox.setForeground(this.local_fg);
        }
        if (this.local_bg != null) {
            checkbox.setBackground(this.local_bg);
        }
        if (this.local_font != null) {
            checkbox.setFont(this.local_font);
        }
    }

    @Override
    public void clearOptions() {
        this.pan.removeAll();
        this.buttons = null;
    }

    @Override
    public void setOptionCount(int n) {
        super.setOptionCount(n);
        this.buttons = new Object[n];
        if (this.initialized) {
            GridLayout gridLayout = new GridLayout(this.option_count, 0, 0, 0);
            this.pan.setLayout(gridLayout);
        }
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        this.local_bg = color;
        if (this.pan != null) {
            this.pan.setBackground(color);
        }
        if (this.buttons != null) {
            int n = this.buttons.length;
            for (int i = 0; i < n; ++i) {
                Checkbox checkbox = (Checkbox)this.buttons[i];
                checkbox.setBackground(color);
            }
        }
    }
}

