/*
 * Decompiled with CFR 0.152.
 */
package dx.runtime;

import dx.net.PacketIF;
import dx.runtime.BinaryInstance;
import java.awt.Choice;
import java.awt.Event;

public class Selector
extends BinaryInstance {
    protected boolean[] selected;

    protected boolean singleItemSelectable() {
        return false;
    }

    @Override
    public boolean action(Event event, Object object) {
        if (event.target == this.ipart && event.target instanceof Choice) {
            PacketIF packetIF = this.getNode();
            packetIF.setOutputValues(this.getOutputValue(), this.getOutput2Value());
            return true;
        }
        return false;
    }

    @Override
    protected void createPart() {
        this.ipart = new Choice();
    }

    @Override
    protected void newItem(int n, String string) {
        Choice choice = (Choice)this.ipart;
        choice.addItem(string);
    }

    @Override
    public void clearOptions() {
        Choice choice = (Choice)this.ipart;
        try {
            int n = choice.getItemCount();
            for (int i = n - 1; i >= 0; --i) {
                choice.remove(i);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("SelectorInteractor error: Your Java implementation is pre 1.1");
            System.out.println("    Data-driven OptionMenu-style SelectorInteractors aren't available.");
            System.out.println("    Try using ScrolledList-style instead.");
        }
    }

    @Override
    protected String getTypeName() {
        return "Selector";
    }

    @Override
    public String getValue() {
        return this.getOutputValue();
    }

    @Override
    public void setValue(String string) {
    }

    @Override
    public void selectOption(int n) {
        Choice choice = (Choice)this.ipart;
        choice.select(n - 1);
    }

    @Override
    public boolean isOptionSelected(int n) {
        int n2 = n - 1;
        Choice choice = (Choice)this.ipart;
        return n2 == choice.getSelectedIndex();
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this.isEnabled() && this.getOptionCount() < 2 && !this.singleItemSelectable()) {
            this.setEnabled(false);
        }
    }
}

