/*
 * Decompiled with CFR 0.152.
 */
package dx.runtime;

import dx.runtime.ArrowButton;
import dx.runtime.Notifier;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Event;
import java.awt.Font;
import java.awt.Panel;
import java.awt.TextField;

public class Stepper
extends Panel
implements Notifier {
    private int decimal_places;
    private boolean integers = false;
    private double min = -1000000.0;
    private double max = 1000000.0;
    private double value = 0.0;
    private double step = 1.0;
    private boolean use_arrows = true;
    private ArrowButton left;
    private ArrowButton right;
    private TextField txt;
    private Font local_font;
    private Color local_bg;
    private Color local_fg;
    private boolean initialized = false;
    private Notifier notifier = null;

    @Override
    public void callCallback(Object object) {
        if (this.notifier != null) {
            this.notifier.callCallback(this);
        }
    }

    public void setValue(String string) {
        double d = this.value;
        try {
            this.value = this.integers ? (double)Integer.valueOf(string).intValue() : (double)Float.valueOf(string).floatValue();
            this.setText(string);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Illegal numeric entry: " + string);
            this.value = d;
            this.setText(this.getValue());
        }
    }

    private void setText(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = stringBuffer.length();
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c;
            try {
                c = stringBuffer.charAt(i);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                System.out.println("index " + i + " is longer than " + n);
                break;
            }
            if (c == '.') {
                bl = true;
                continue;
            }
            if (c == 'E') {
                bl2 = true;
            }
            if (bl && c >= '0' && c <= '9') {
                ++n2;
            }
            if (n2 <= this.decimal_places || bl2 || c < '0' || c > '9') continue;
            stringBuffer.setCharAt(i, '0');
        }
        String string2 = new String(stringBuffer);
        try {
            this.value = this.integers ? (double)Integer.valueOf(string2).intValue() : (double)Float.valueOf(string2).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        Float f = new Float(string2);
        if (this.integers) {
            this.txt.setText(Integer.toString(f.intValue()));
        } else {
            this.txt.setText(f.toString());
        }
    }

    public Stepper(Notifier notifier) {
        this.notifier = notifier;
    }

    public void setValues(double d, double d2, double d3, int n, double d4) {
        this.min = d;
        this.max = d2;
        this.step = d3;
        this.value = d4;
        this.integers = false;
        this.decimal_places = n;
        this.setText("" + this.value);
    }

    public void setValues(int n, int n2, int n3, int n4) {
        this.min = n;
        this.max = n2;
        this.step = n3;
        this.value = n4;
        this.integers = true;
        this.decimal_places = 0;
        this.setText("" + this.value);
    }

    @Override
    public void setFont(Font font) {
        if (this.initialized) {
            this.txt.setFont(font);
        }
        this.local_font = font;
    }

    public boolean decrement() {
        double d = this.value;
        this.value -= this.step;
        if (this.value < this.min) {
            this.value = this.min;
        }
        this.setText(this.getValue());
        return this.value != d;
    }

    public boolean increment() {
        double d = this.value;
        this.value += this.step;
        if (this.value > this.max) {
            this.value = this.max;
        }
        this.setText(this.getValue());
        return this.value != d;
    }

    @Override
    public boolean action(Event event, Object object) {
        if (event.target == this.txt) {
            String string = this.txt.getText();
            double d = this.value;
            try {
                Float f = new Float(string);
                if (!this.integers) {
                    this.value = f.floatValue();
                    if (this.value > this.max || this.value < this.min) {
                        if (this.value < this.min) {
                            this.value = this.min;
                        }
                        if (this.value > this.max) {
                            this.value = this.max;
                        }
                        f = new Float(this.value);
                    }
                    this.setText(f.toString());
                } else {
                    Integer n = new Integer(f.intValue());
                    this.value = n.intValue();
                    if (this.value > this.max || this.value < this.min) {
                        if (this.value < this.min) {
                            this.value = this.min;
                        }
                        if (this.value > this.max) {
                            this.value = this.max;
                        }
                        f = new Float(this.value);
                        n = new Integer(f.intValue());
                    }
                    this.setText(n.toString());
                }
                if (this.notifier != null && this.value != d) {
                    this.notifier.callCallback(this);
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.value = d;
                System.out.println("Illegal numeric entry: " + string);
                this.setText(this.getValue());
            }
            return true;
        }
        return false;
    }

    public String getValue() {
        Float f = new Float(this.value);
        if (this.integers) {
            Integer n = new Integer(f.intValue());
            return n.toString();
        }
        return f.toString();
    }

    @Override
    public void setBackground(Color color) {
        if (this.initialized) {
            this.txt.setBackground(Color.white);
            if (this.use_arrows) {
                this.left.setBackground(color);
                this.right.setBackground(color);
            }
        }
        this.local_bg = color;
        super.setBackground(color);
    }

    @Override
    public void setForeground(Color color) {
        if (this.initialized) {
            this.txt.setForeground(Color.black);
            if (this.use_arrows) {
                this.left.setForeground(color);
                this.right.setForeground(color);
            }
        }
        this.local_bg = color;
        super.setForeground(color);
    }

    public void setUseArrows(boolean bl) {
        if (this.initialized) {
            return;
        }
        this.use_arrows = bl;
    }

    public void init() {
        BorderLayout borderLayout = new BorderLayout(4, 4);
        this.setLayout(borderLayout);
        try {
            if (this.use_arrows) {
                this.left = new ArrowButton(ArrowButton.LEFT, this);
                this.add("West", this.left);
                this.right = new ArrowButton(ArrowButton.RIGHT, this);
                this.add("East", this.right);
            }
            this.txt = new TextField("", 10);
            this.add("Center", this.txt);
            this.txt.setBackground(Color.white);
            this.txt.setForeground(Color.black);
            if (this.local_bg != null && this.use_arrows) {
                this.left.setBackground(this.local_bg);
                this.right.setBackground(this.local_bg);
            }
            if (this.local_fg != null && this.use_arrows) {
                this.left.setForeground(this.local_fg);
                this.right.setForeground(this.local_fg);
            }
            if (this.local_font != null) {
                this.txt.setFont(this.local_font);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.initialized = true;
    }
}

