/*
 * Decompiled with CFR 0.152.
 */
package dx.runtime;

import dx.runtime.Stepper;
import dx.runtime.StepperInteractor;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Panel;

public class StepperGroup
extends Panel {
    int stepper_count;
    int next;
    Object[] stepper_array;
    Font local_font;
    Color local_fg;
    Color local_bg;
    boolean initialized;
    StepperInteractor notifier;
    boolean use_arrows = true;

    public StepperGroup(int n, StepperInteractor stepperInteractor, boolean bl) {
        this.use_arrows = bl;
        this.stepper_count = n;
        this.stepper_array = new Object[this.stepper_count];
        this.next = 0;
        this.local_font = null;
        this.local_fg = null;
        this.local_bg = null;
        this.initialized = false;
        this.notifier = stepperInteractor;
    }

    public StepperGroup(int n, StepperInteractor stepperInteractor) {
        this.use_arrows = true;
        this.stepper_count = n;
        this.stepper_array = new Object[this.stepper_count];
        this.next = 0;
        this.local_font = null;
        this.local_fg = null;
        this.local_bg = null;
        this.initialized = false;
        this.notifier = stepperInteractor;
    }

    @Override
    public void setFont(Font font) {
        if (this.initialized) {
            for (int i = 0; i < this.next; ++i) {
                Stepper stepper = (Stepper)this.stepper_array[i];
                stepper.setFont(font);
            }
        }
        this.local_font = font;
    }

    @Override
    public void setBackground(Color color) {
        if (this.initialized) {
            for (int i = 0; i < this.next; ++i) {
                Stepper stepper = (Stepper)this.stepper_array[i];
                stepper.setBackground(color);
            }
        }
        this.local_bg = color;
        super.setBackground(color);
    }

    @Override
    public void setForeground(Color color) {
        if (this.initialized) {
            for (int i = 0; i < this.next; ++i) {
                Stepper stepper = (Stepper)this.stepper_array[i];
                stepper.setBackground(color);
            }
        }
        this.local_fg = color;
        super.setForeground(color);
    }

    public void init() {
        GridLayout gridLayout = new GridLayout(this.stepper_count, 1, 0, 0);
        this.setLayout(gridLayout);
        try {
            for (int i = 0; i < this.stepper_count; ++i) {
                Stepper stepper = new Stepper(this.notifier);
                if (this.local_fg != null) {
                    stepper.setForeground(this.local_fg);
                }
                if (this.local_bg != null) {
                    stepper.setBackground(this.local_bg);
                }
                if (this.local_font != null) {
                    stepper.setFont(this.local_font);
                }
                if (!this.use_arrows) {
                    stepper.setUseArrows(false);
                }
                stepper.init();
                this.add(stepper);
                this.stepper_array[i] = stepper;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.initialized = true;
    }

    public void setValues(int n, double d, double d2, double d3, int n2, double d4) {
        Stepper stepper = (Stepper)this.stepper_array[n - 1];
        stepper.setValues(d, d2, d3, n2, d4);
    }

    public void setValues(int n, int n2, int n3, int n4, int n5) {
        Stepper stepper = (Stepper)this.stepper_array[n - 1];
        stepper.setValues(n2, n3, n4, n5);
    }

    public String getValue() {
        if (this.stepper_count == 1) {
            Stepper stepper = (Stepper)this.stepper_array[0];
            return stepper.getValue();
        }
        String string = "[ ";
        for (int i = 0; i < this.stepper_count; ++i) {
            Stepper stepper = (Stepper)this.stepper_array[i];
            string = string + " " + stepper.getValue();
        }
        string = string + " ]";
        return string;
    }
}

