/*
 * Decompiled with CFR 0.152.
 */
package dx.runtime;

import dx.net.PacketIF;
import dx.runtime.ListSelector;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Panel;

public class ToggleGroup
extends ListSelector {
    private Object[] buttons;
    private Color local_fg = null;
    private Font local_font = null;
    private Panel pan = null;
    private boolean initialized = false;

    @Override
    protected boolean singleItemSelectable() {
        return true;
    }

    @Override
    public boolean action(Event event, Object object) {
        if (event.target instanceof Checkbox) {
            PacketIF packetIF = this.getNode();
            packetIF.setOutputValues(this.getOutputValue(), this.getOutput2Value());
            return true;
        }
        return false;
    }

    @Override
    protected void createPart() {
        this.pan = new Panel();
        if (this.local_bg != null) {
            this.pan.setBackground(this.local_bg);
        }
        this.ipart = this.pan;
        if (this.option_count > 0) {
            GridLayout gridLayout = new GridLayout(this.option_count, 0, 0, 0);
            this.pan.setLayout(gridLayout);
        }
        this.initialized = true;
        if (this.option_count == 0) {
            return;
        }
        try {
            for (int i = 1; i <= this.option_count; ++i) {
                this.newItem(i, this.getOptionName(i));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.validate();
    }

    @Override
    protected String getTypeName() {
        return "ButtonList";
    }

    @Override
    public boolean isOptionSelected(int n) {
        Checkbox checkbox = (Checkbox)this.buttons[n - 1];
        return checkbox.getState();
    }

    @Override
    public void selectOption(int n) {
        if (this.buttons == null) {
            return;
        }
        Checkbox checkbox = (Checkbox)this.buttons[n - 1];
        if (checkbox == null) {
            return;
        }
        checkbox.setState(true);
    }

    @Override
    public void newItem(int n, String string) {
        if (!this.initialized) {
            return;
        }
        if (n > this.option_count) {
            return;
        }
        Checkbox checkbox = new Checkbox(string);
        this.pan.add((Component)checkbox, n - 1);
        this.buttons[n - 1] = checkbox;
        if (this.local_fg != null) {
            checkbox.setForeground(this.local_fg);
        }
        if (this.local_bg != null) {
            checkbox.setBackground(this.local_bg);
        }
        if (this.local_font != null) {
            checkbox.setFont(this.local_font);
        }
    }

    @Override
    public void clearOptions() {
        this.pan.removeAll();
        this.buttons = null;
    }

    @Override
    public void setOptionCount(int n) {
        super.setOptionCount(n);
        this.buttons = new Object[n];
        if (this.initialized) {
            GridLayout gridLayout = new GridLayout(n, 0, 0, 0);
            this.pan.setLayout(gridLayout);
        }
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.pan != null) {
            this.pan.setBackground(color);
        }
        if (this.buttons != null) {
            for (int i = this.option_count; i >= 0; --i) {
                Checkbox checkbox = (Checkbox)this.buttons[i];
                checkbox.setBackground(color);
            }
        }
    }
}

