/*
 * Copyright (c) 2012, 2020, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_or extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_FJ = "\u0b2b\u0b3f\u0b1c\u0b3f";
        final String metaValue_NR = "\u0b28\u0b3e\u0b09\u0b30\u0b41";
        final String metaValue_SO = "\u0b38\u0b4b\u0b2e\u0b3e\u0b32\u0b3f\u0b06";
        final String metaValue_TK = "\u0b1f\u0b4b\u0b15\u0b47\u0b32\u0b3e\u0b09";
        final String metaValue_TO = "\u0b1f\u0b4b\u0b19\u0b4d\u0b17\u0b3e";
        final String metaValue_TV = "\u0b24\u0b41\u0b2d\u0b3e\u0b32\u0b41";
        final String metaValue_ar = "\u0b06\u0b30\u0b2c\u0b3f\u0b15\u0b4d";
        final String metaValue_bn = "\u0b2c\u0b19\u0b4d\u0b17\u0b3e\u0b33\u0b40";
        final String metaValue_el = "\u0b17\u0b4d\u0b30\u0b40\u0b15\u0b4d";
        final String metaValue_gu = "\u0b17\u0b41\u0b1c\u0b41\u0b30\u0b3e\u0b1f\u0b40";
        final String metaValue_jv = "\u0b1c\u0b3e\u0b2d\u0b3e\u0b28\u0b40\u0b1c\u0b4d";
        final String metaValue_ka = "\u0b1c\u0b30\u0b4d\u0b1c\u0b3f\u0b5f";
        final String metaValue_ko = "\u0b15\u0b4b\u0b30\u0b3f\u0b06\u0b28\u0b4d";
        final String metaValue_la = "\u0b32\u0b3e\u0b1f\u0b3f\u0b28\u0b4d";
        final String metaValue_lo = "\u0b32\u0b3e\u0b13";
        final String metaValue_or = "\u0b13\u0b21\u0b3c\u0b3f\u0b06";
        final String metaValue_su = "\u0b38\u0b41\u0b26\u0b3e\u0b28\u0b40\u0b1c\u0b4d";
        final String metaValue_ta = "\u0b24\u0b3e\u0b2e\u0b3f\u0b32\u0b4d";
        final String metaValue_te = "\u0b24\u0b47\u0b32\u0b41\u0b17\u0b41";
        final String metaValue_th = "\u0b25\u0b3e\u0b07";
        final String metaValue_ban = "\u0b2c\u0b3e\u0b32\u0b3f\u0b28\u0b40\u0b1c\u0b4d";
        final String metaValue_got = "\u0b17\u0b4b\u0b25\u0b3f\u0b15\u0b4d";
        final String metaValue_zbl = "\u0b2c\u0b4d\u0b32\u0b3f\u0b38\u0b3f\u0b2e\u0b4d\u0b2c\u0b32\u0b38\u0b4d";
        final Object[][] data = new Object[][] {
            { "ksh", "\u0b15\u0b4b\u0b32\u0b4b\u0b2c\u0b28\u0b3f\u0b5f" },
            { "Ogam", "\u0b13\u0b18\u0b3e\u0b2e\u0b3e" },
            { "mwl", "\u0b2e\u0b3f\u0b30\u0b3e\u0b23\u0b4d\u0b21\u0b3f\u0b1c\u0b4d" },
            { "Zsym", "\u0b38\u0b19\u0b4d\u0b15\u0b47\u0b24\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "cch", "\u0b06\u0b24\u0b4d\u0b38\u0b2e\u0b4d" },
            { "mwr", "\u0b2e\u0b3e\u0b30\u0b71\u0b3e\u0b30\u0b40" },
            { "Tagb", "\u0b24\u0b17\u0b2c\u0b3e\u0b28\u0b4d\u0b71\u0b3e" },
            { "Zsye", "\u0b07\u0b2e\u0b4b\u0b1c\u0b3f" },
            { "egy", "\u0b2a\u0b4d\u0b30\u0b3e\u0b1a\u0b40\u0b28\u0b4d \u0b2e\u0b3f\u0b36\u0b3f\u0b30\u0b3f" },
            { "raj", "\u0b30\u0b3e\u0b1c\u0b38\u0b4d\u0b25\u0b3e\u0b28\u0b40" },
            { "Phag", "\u0b2b\u0b3e\u0b17\u0b38\u0b4d-\u0b2a\u0b3e" },
            { "tem", "\u0b24\u0b3f\u0b2e\u0b28\u0b47" },
            { "teo", "\u0b24\u0b47\u0b38\u0b3e" },
            { "rap", "\u0b30\u0b3e\u0b2a\u0b3e\u0b28\u0b41\u0b07" },
            { "ter", "\u0b24\u0b47\u0b30\u0b47\u0b28\u0b4b" },
            { "AC", "\u0b06\u0b38\u0b47\u0b28\u0b38\u0b3f\u0b05\u0b28\u0b4d\u200c \u0b26\u0b4d\u0b71\u0b40\u0b2a" },
            { "rar", "\u0b30\u0b3e\u0b30\u0b4b\u0b24\u0b4b\u0b19\u0b4d\u0b17\u0b28\u0b4d" },
            { "tet", "\u0b24\u0b47\u0b24\u0b41\u0b2e\u0b4d" },
            { "AD", "\u0b06\u0b23\u0b4d\u0b21\u0b4b\u0b30\u0b3e" },
            { "AE", "\u0b38\u0b02\u0b2f\u0b41\u0b15\u0b4d\u0b24 \u0b06\u0b30\u0b2c \u0b0f\u0b2e\u0b3f\u0b30\u0b47\u0b1f\u0b38\u0b4d" },
            { "nl_BE", "\u0b2b\u0b4d\u0b32\u0b47\u0b2e\u0b3f\u0b36\u0b4d" },
            { "AF", "\u0b06\u0b2b\u0b17\u0b3e\u0b28\u0b3f\u0b38\u0b4d\u0b24\u0b3e\u0b28\u0b4d" },
            { "AG", "\u0b06\u0b23\u0b4d\u0b1f\u0b3f\u0b17\u0b41\u0b06 \u0b0f\u0b2c\u0b02 \u0b2c\u0b3e\u0b30\u0b2c\u0b41\u0b26\u0b3e" },
            { "type.ca.ethiopic", "\u0b07\u0b25\u0b3f\u0b13\u0b2a\u0b3f\u0b15\u0b4d\u200c \u0b15\u0b4d\u0b5f\u0b3e\u0b32\u0b47\u0b23\u0b4d\u0b21\u0b30\u0b4d\u200c" },
            { "AI", "\u0b06\u0b19\u0b4d\u0b17\u0b41\u0b07\u0b32\u0b4d\u0b32\u0b3e" },
            { "AL", "\u0b06\u0b32\u0b2c\u0b3e\u0b28\u0b3f\u0b06" },
            { "AM", "\u0b06\u0b30\u0b4d\u0b2e\u0b47\u0b28\u0b3f\u0b06" },
            { "Teng", "\u0b24\u0b47\u0b19\u0b4d\u0b17\u0b71\u0b3e\u0b30\u0b4d" },
            { "AO", "\u0b06\u0b19\u0b4d\u0b17\u0b4b\u0b32\u0b3e" },
            { "AQ", "\u0b06\u0b23\u0b4d\u0b1f\u0b3e\u0b30\u0b4d\u0b15\u0b3e\u0b1f\u0b3f\u0b15\u0b3e" },
            { "AR", "\u0b06\u0b30\u0b4d\u0b1c\u0b47\u0b23\u0b4d\u0b1f\u0b3f\u0b28\u0b3e" },
            { "Prti", "\u0b07\u0b28\u0b38\u0b4d\u0b15\u0b4d\u0b30\u0b40\u0b2a\u0b38\u0b3e\u0b28\u0b32\u0b4d \u0b2a\u0b3e\u0b30\u0b4d\u0b25\u0b3f\u0b06\u0b28\u0b4d" },
            { "AS", "\u0b06\u0b2e\u0b47\u0b30\u0b3f\u0b15\u0b3e\u0b28\u0b4d \u0b38\u0b3e\u0b2e\u0b4b\u0b06" },
            { "AT", "\u0b05\u0b37\u0b4d\u0b1f\u0b4d\u0b30\u0b3f\u0b06" },
            { "AU", "\u0b05\u0b37\u0b4d\u0b1f\u0b4d\u0b30\u0b47\u0b32\u0b3f\u0b06" },
            { "AW", "\u0b06\u0b30\u0b41\u0b2c\u0b3e" },
            { "en_US", "\u0b06\u0b2e\u0b47\u0b30\u0b3f\u0b15\u0b40\u0b5f \u0b07\u0b02\u0b30\u0b3e\u0b1c\u0b40" },
            { "AX", "\u0b05\u0b32\u0b3e\u0b23\u0b4d\u0b21 \u0b26\u0b4d\u0b35\u0b40\u0b2a\u0b2a\u0b41\u0b1e\u0b4d\u0b1c" },
            { "AZ", "\u0b06\u0b1c\u0b47\u0b30\u0b2c\u0b3e\u0b07\u0b1c\u0b3e\u0b28\u0b4d" },
            { "BA", "\u0b2c\u0b4b\u0b38\u0b28\u0b3f\u0b06 \u0b0f\u0b2c\u0b02 \u0b39\u0b30\u0b4d\u0b1c\u0b17\u0b4b\u0b2d\u0b3f\u0b28\u0b3e" },
            { "BB", "\u0b2c\u0b3e\u0b30\u0b2c\u0b3e\u0b21\u0b4b\u0b38\u0b4d" },
            { "ceb", "\u0b38\u0b40\u0b2c\u0b41\u0b06\u0b28\u0b4b" },
            { "BD", "\u0b2c\u0b3e\u0b02\u0b32\u0b3e\u0b26\u0b47\u0b36" },
            { "kum", "\u0b15\u0b41\u0b2e\u0b40\u0b15\u0b4d" },
            { "BE", "\u0b2c\u0b47\u0b32\u0b1c\u0b3f\u0b5f\u0b2e\u0b4d" },
            { "gmh", "\u0b2e\u0b3f\u0b21\u0b3f\u0b32\u0b4d \u0b39\u0b3e\u0b07 \u0b1c\u0b30\u0b4d\u0b2e\u0b3e\u0b28\u0b4d" },
            { "BF", "\u0b2c\u0b41\u0b30\u0b4d\u0b15\u0b3f\u0b28\u0b3e \u0b2b\u0b3e\u0b38\u0b4b" },
            { "BG", "\u0b2c\u0b41\u0b32\u0b17\u0b47\u0b30\u0b3f\u0b06" },
            { "BH", "\u0b2c\u0b3e\u0b39\u0b3e\u0b30\u0b3f\u0b28\u0b4d" },
            { "BI", "\u0b2c\u0b41\u0b30\u0b41\u0b23\u0b4d\u0b21\u0b3f" },
            { "BJ", "\u0b2c\u0b47\u0b28\u0b3f\u0b28\u0b4d" },
            { "BL", "\u0b38\u0b47\u0b23\u0b4d\u0b1f \u0b2c\u0b3e\u0b30\u0b4d\u0b25\u0b47\u0b32\u0b47\u0b2e\u0b3f" },
            { "BM", "\u0b2c\u0b30\u0b4d\u0b2e\u0b41\u0b21\u0b3e" },
            { "kut", "\u0b15\u0b41\u0b24\u0b47\u0b28\u0b3e\u0b09" },
            { "myv", "\u0b0f\u0b30\u0b4d\u0b1c\u0b5f\u0b3e" },
            { "BN", "\u0b2c\u0b4d\u0b30\u0b41\u0b28\u0b47\u0b07" },
            { "BO", "\u0b2c\u0b4b\u0b32\u0b2d\u0b3f\u0b06" },
            { "BQ", "\u0b15\u0b3e\u0b30\u0b2c\u0b3f\u0b5f\u0b28\u0b4d\u200c \u0b28\u0b47\u0b26\u0b30\u0b32\u0b4d\u0b5f\u0b3e\u0b23\u0b4d\u0b21" },
            { "BR", "\u0b2c\u0b4d\u0b30\u0b3e\u0b1c\u0b3f\u0b32\u0b4d" },
            { "BS", "\u0b2c\u0b3e\u0b39\u0b3e\u0b2e\u0b3e\u0b38\u0b4d" },
            { "xog", "\u0b38\u0b4b\u0b17\u0b3e" },
            { "BT", "\u0b2d\u0b41\u0b1f\u0b3e\u0b28" },
            { "BV", "\u0b2c\u0b4c\u0b2d\u0b47\u0b1f\u0b4d\u200c \u0b26\u0b4d\u0b71\u0b40\u0b2a" },
            { "BW", "\u0b2c\u0b4b\u0b1f\u0b38\u0b4d\u0b71\u0b3e\u0b28\u0b3e" },
            { "BY", "\u0b2c\u0b47\u0b32\u0b3e\u0b30\u0b41\u0b37\u0b4d" },
            { "BZ", "\u0b2c\u0b47\u0b32\u0b3f\u0b1c\u0b4d" },
            { "Visp", "\u0b2d\u0b3f\u0b1c\u0b3f\u0b2c\u0b32\u0b4d \u0b38\u0b4d\u0b2a\u0b3f\u0b1a\u0b4d" },
            { "type.ca.persian", "\u0b2a\u0b30\u0b4d\u0b38\u0b3f\u0b06\u0b28\u0b4d\u200c \u0b15\u0b4d\u0b5f\u0b3e\u0b32\u0b47\u0b23\u0b4d\u0b21\u0b30\u0b4d\u200c" },
            { "type.nu.hebr", "\u0b39\u0b3f\u0b2c\u0b43 \u0b38\u0b02\u0b16\u0b4d\u0b5f\u0b3e\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "CA", "\u0b15\u0b3e\u0b28\u0b3e\u0b21\u0b3e" },
            { "CC", "\u0b15\u0b4b\u0b15\u0b4b\u0b38\u0b4d (\u0b15\u0b40\u0b32\u0b3f\u0b02) \u0b26\u0b4d\u0b35\u0b40\u0b2a\u0b2a\u0b41\u0b1e\u0b4d\u0b1c" },
            { "mzn", "\u0b2e\u0b3e\u0b1c\u0b3e\u0b28\u0b21\u0b47\u0b30\u0b3e\u0b28\u0b3f" },
            { "CD", "\u0b15\u0b19\u0b4d\u0b17\u0b4b-\u0b15\u0b3f\u0b28\u0b38\u0b3e\u0b38\u0b3e" },
            { "CF", "\u0b2e\u0b27\u0b4d\u0b5f \u0b06\u0b2b\u0b4d\u0b30\u0b3f\u0b15\u0b40\u0b5f \u0b38\u0b3e\u0b27\u0b3e\u0b30\u0b23\u0b24\u0b28\u0b4d\u0b24\u0b4d\u0b30" },
            { "CG", "\u0b15\u0b19\u0b4d\u0b17\u0b4b-\u0b2c\u0b4d\u0b30\u0b3e\u0b1c\u0b3f\u0b2d\u0b3f\u0b32\u0b4d\u0b32\u0b47" },
            { "CH", "\u0b38\u0b4d\u0b71\u0b3f\u0b1c\u0b30\u0b32\u0b4d\u0b5f\u0b3e\u0b23\u0b4d\u0b21" },
            { "CI", "\u0b15\u0b4b\u0b24\u0b4d \u0b21\u0b3f \u0b2d\u0b4d\u0b35\u0b3e\u0b30\u0b4d" },
            { "CK", "\u0b15\u0b41\u0b15\u0b4d\u200c \u0b26\u0b4d\u0b71\u0b40\u0b2a\u0b2a\u0b41\u0b1e\u0b4d\u0b1c" },
            { "CL", "\u0b1a\u0b3f\u0b32\u0b4d\u0b32\u0b40" },
            { "Kthi", "\u0b15\u0b48\u0b25\u0b3f" },
            { "CM", "\u0b15\u0b3e\u0b2e\u0b47\u0b30\u0b41\u0b28\u0b4d" },
            { "CN", "\u0b1a\u0b3f\u0b28\u0b4d" },
            { "CO", "\u0b15\u0b4b\u0b32\u0b2e\u0b4d\u0b2c\u0b3f\u0b06" },
            { "CP", "\u0b15\u0b4d\u0b32\u0b3f\u0b2a\u0b30\u0b1f\u0b28\u0b4d\u200c \u0b26\u0b4d\u0b71\u0b40\u0b2a" },
            { "CR", "\u0b15\u0b4b\u0b37\u0b4d\u0b1f\u0b3e \u0b30\u0b3f\u0b15\u0b3e" },
            { "CU", "\u0b15\u0b4d\u0b71\u0b3f\u0b2c\u0b3e" },
            { "CV", "\u0b15\u0b47\u0b2a\u0b4d \u0b2d\u0b30\u0b4d\u0b26\u0b47" },
            { "CW", "\u0b15\u0b41\u0b30\u0b3e\u0b15\u0b3e\u0b13" },
            { "CX", "\u0b16\u0b4d\u0b30\u0b40\u0b37\u0b4d\u0b1f\u0b2e\u0b3e\u0b38 \u0b26\u0b4d\u0b71\u0b40\u0b2a" },
            { "CY", "\u0b38\u0b3e\u0b07\u0b2a\u0b4d\u0b30\u0b38\u0b4d" },
            { "CZ", "\u0b1a\u0b47\u0b1a\u0b3f\u0b06" },
            { "eka", "\u0b0f\u0b15\u0b3e\u0b1c\u0b41\u0b15\u0b4d" },
            { "DE", "\u0b1c\u0b30\u0b4d\u0b2e\u0b3e\u0b28\u0b40" },
            { "goh", "\u0b2a\u0b41\u0b30\u0b41\u0b23\u0b3e \u0b39\u0b3e\u0b07 \u0b1c\u0b30\u0b4d\u0b2e\u0b3e\u0b28\u0b4d" },
            { "ace", "\u0b06\u0b1a\u0b3e\u0b07\u0b28\u0b40\u0b1c\u0b4d" },
            { "cgg", "\u0b1a\u0b3f\u0b17\u0b3e" },
            { "DG", "\u0b21\u0b3f\u0b0f\u0b17\u0b4b \u0b17\u0b3e\u0b30\u0b4d\u0b38\u0b3f\u0b06" },
            { "type.nu.deva", "\u0b26\u0b47\u0b2c\u0b28\u0b3e\u0b17\u0b30\u0b40 \u0b05\u0b19\u0b4d\u0b15\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "DJ", "\u0b1c\u0b3f\u0b2c\u0b4b\u0b1f\u0b3f" },
            { "DK", "\u0b21\u0b47\u0b28\u0b2e\u0b3e\u0b30\u0b4d\u0b15" },
            { "ach", "\u0b06\u0b15\u0b4b\u0b32\u0b3f" },
            { "gon", "\u0b17\u0b4b\u0b23\u0b4d\u0b21\u0b3f" },
            { "Brai", "\u0b2c\u0b4d\u0b30\u0b47\u0b32\u0b4d" },
            { "Brah", "\u0b2c\u0b4d\u0b30\u0b3e\u0b39\u0b4d\u0b2e\u0b40" },
            { "DM", "\u0b21\u0b4b\u0b2e\u0b3f\u0b28\u0b3f\u0b15\u0b3e" },
            { "type.nu.armnlow", "\u0b06\u0b30\u0b4d\u0b2e\u0b47\u0b28\u0b3f\u0b5f \u0b1b\u0b4b\u0b1f \u0b05\u0b15\u0b4d\u0b37\u0b30 \u0b38\u0b02\u0b16\u0b4d\u0b5f\u0b3e\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "DO", "\u0b21\u0b4b\u0b2e\u0b3f\u0b28\u0b3f\u0b15\u0b3e\u0b28\u0b4d\u200c \u0b38\u0b3e\u0b27\u0b3e\u0b30\u0b23\u0b24\u0b28\u0b4d\u0b24\u0b4d\u0b30" },
            { "gor", "\u0b17\u0b4b\u0b30\u0b4b\u0b23\u0b4d\u0b1f\u0b3e\u0b32\u0b4b" },
            { "got", metaValue_got },
            { "Mtei", "\u0b2e\u0b3e\u0b0f\u0b24\u0b3f \u0b2e\u0b3e\u0b5f\u0b47\u0b15\u0b4d" },
            { "zun", "\u0b1c\u0b41\u0b28\u0b40" },
            { "tig", "\u0b1f\u0b3e\u0b07\u0b17\u0b4d\u0b30\u0b47" },
            { "DZ", "\u0b06\u0b32\u0b1c\u0b47\u0b30\u0b3f\u0b06" },
            { "pag", "\u0b2a\u0b3e\u0b19\u0b4d\u0b17\u0b3e\u0b38\u0b3f\u0b28\u0b3f\u0b06\u0b28\u0b4d" },
            { "pal", "\u0b2a\u0b3e\u0b39\u0b4d\u0b32\u0b3e\u0b2d\u0b3f" },
            { "EA", "\u0b38\u0b3f\u0b09\u0b1f\u0b3e \u0b0f\u0b2c\u0b02 \u0b2e\u0b47\u0b32\u0b3f\u0b32\u0b3e" },
            { "chb", "\u0b1a\u0b3f\u0b2c\u0b4d\u0b1a\u0b3e" },
            { "pam", "\u0b2a\u0b3e\u0b2e\u0b4d\u0b2a\u0b3e\u0b19\u0b4d\u0b17\u0b3e" },
            { "EC", "\u0b07\u0b15\u0b4d\u0b71\u0b3e\u0b21\u0b4b\u0b30\u0b4d" },
            { "pap", "\u0b2a\u0b3e\u0b2a\u0b3f\u0b06\u0b2e\u0b47\u0b23\u0b4d\u0b1f\u0b4b" },
            { "ada", "\u0b06\u0b26\u0b3e\u0b19\u0b4d\u0b17\u0b47\u0b2e\u0b4d" },
            { "EE", "\u0b0f\u0b38\u0b4d\u0b24\u0b4b\u0b28\u0b3f\u0b06" },
            { "tiv", "\u0b24\u0b40\u0b2d\u0b4d" },
            { "EG", "\u0b07\u0b1c\u0b3f\u0b2a\u0b4d\u0b1f" },
            { "EH", "\u0b2a\u0b36\u0b4d\u0b1a\u0b3f\u0b2e \u0b38\u0b3e\u0b39\u0b3e\u0b30\u0b3e" },
            { "chg", "\u0b1b\u0b17\u0b24\u0b3e\u0b07" },
            { "pau", "\u0b2a\u0b3e\u0b32\u0b3e\u0b09\u0b06\u0b28\u0b4d" },
            { "chk", "\u0b1a\u0b41\u0b15\u0b40\u0b38\u0b47" },
            { "chn", "\u0b1a\u0b3f\u0b28\u0b41\u0b15\u0b4d \u0b1c\u0b3e\u0b30\u0b17\u0b3e\u0b01\u0b28\u0b4d" },
            { "chm", "\u0b2e\u0b3e\u0b30\u0b40" },
            { "chp", "\u0b1a\u0b3f\u0b2a\u0b47\u0b71\u0b3e\u0b28\u0b4d" },
            { "cho", "\u0b1a\u0b4b\u0b1f\u0b71\u0b3e" },
            { "chr", "\u0b1a\u0b47\u0b30\u0b4b\u0b15\u0b40" },
            { "ER", "\u0b07\u0b30\u0b3f\u0b1f\u0b4d\u0b30\u0b3f\u0b5f\u0b3e" },
            { "ES", "\u0b38\u0b4d\u0b2a\u0b47\u0b28\u0b4d" },
            { "ET", "\u0b07\u0b25\u0b3f\u0b13\u0b2a\u0b3f\u0b06" },
            { "EU", "\u0b5f\u0b41\u0b30\u0b4b\u0b2a\u0b40\u0b5f \u0b38\u0b02\u0b18" },
            { "elx", "\u0b0f\u0b32\u0b3e\u0b2e\u0b3e\u0b07\u0b1f\u0b4d" },
            { "type.ca.gregorian", "\u0b17\u0b4d\u0b30\u0b47\u0b17\u0b4b\u0b30\u0b3f\u0b5f \u0b15\u0b4d\u0b5f\u0b3e\u0b32\u0b47\u0b23\u0b4d\u0b21\u0b30\u0b4d" },
            { "EZ", "\u0b5f\u0b41\u0b30\u0b4b\u0b15\u0b4d\u0b37\u0b47\u0b24\u0b4d\u0b30" },
            { "chy", "\u0b1a\u0b47\u0b1a\u0b47\u0b28\u0b3e" },
            { "type.nu.gujr", "\u0b17\u0b41\u0b1c\u0b30\u0b3e\u0b1f\u0b40 \u0b05\u0b19\u0b4d\u0b15\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "Inds", "\u0b38\u0b3f\u0b28\u0b4d\u0b27\u0b41" },
            { "ady", "\u0b05\u0b26\u0b4d\u0b5f\u0b18\u0b47" },
            { "FI", "\u0b2b\u0b3f\u0b28\u0b32\u0b4d\u0b5f\u0b3e\u0b23\u0b4d\u0b21" },
            { "FJ", metaValue_FJ },
            { "FK", "\u0b2b\u0b15\u0b4d\u200c\u0b32\u0b4d\u0b5f\u0b3e\u0b23\u0b4d\u0b21 \u0b26\u0b4d\u0b35\u0b40\u0b2a\u0b2a\u0b41\u0b1e\u0b4d\u0b1c" },
            { "FM", "\u0b2e\u0b3e\u0b07\u0b15\u0b4d\u0b30\u0b4b\u0b28\u0b47\u0b38\u0b3f\u0b06" },
            { "FO", "\u0b2b\u0b3e\u0b30\u0b4b\u0b07 \u0b26\u0b4d\u0b71\u0b40\u0b2a\u0b2a\u0b41\u0b1e\u0b4d\u0b1c" },
            { "Taml", metaValue_ta },
            { "FR", "\u0b2b\u0b4d\u0b30\u0b3e\u0b28\u0b4d\u0b38" },
            { "tkl", metaValue_TK },
            { "grb", "\u0b17\u0b4d\u0b30\u0b47\u0b2c\u0b4b" },
            { "root", "\u0b30\u0b4b\u0b1f\u0b4d" },
            { "grc", "\u0b2a\u0b4d\u0b30\u0b3e\u0b1a\u0b40\u0b28\u0b4d \u0b5f\u0b41\u0b28\u0b3e\u0b28\u0b40" },
            { "GA", "\u0b17\u0b3e\u0b2c\u0b4b\u0b28\u0b4d" },
            { "vot", "\u0b2d\u0b4b\u0b1f\u0b3f\u0b15\u0b4d" },
            { "GB", "\u0b2f\u0b41\u0b15\u0b4d\u0b24\u0b30\u0b3e\u0b1c\u0b4d\u0b5f" },
            { "pcm", "\u0b28\u0b3e\u0b07\u0b1c\u0b47\u0b30\u0b40\u0b5f \u0b2a\u0b3f\u0b21\u0b17\u0b3f\u0b28\u0b4d" },
            { "GD", "\u0b17\u0b4d\u0b30\u0b47\u0b28\u0b3e\u0b21\u0b3e" },
            { "GE", "\u0b1c\u0b30\u0b4d\u0b1c\u0b3f\u0b06" },
            { "GF", "\u0b2b\u0b4d\u0b30\u0b47\u0b1e\u0b4d\u0b1a \u0b17\u0b41\u0b07\u0b28\u0b3e" },
            { "GG", "\u0b17\u0b41\u0b0f\u0b30\u0b28\u0b47\u0b38\u0b3f" },
            { "GH", "\u0b18\u0b3e\u0b28\u0b3e" },
            { "Tale", "\u0b24\u0b3e\u0b07 \u0b32\u0b47" },
            { "GI", "\u0b1c\u0b3f\u0b2c\u0b4d\u0b30\u0b3e\u0b32\u0b4d\u0b1f\u0b30\u0b4d" },
            { "afh", "\u0b06\u0b2b\u0b4d\u0b30\u0b3f\u0b39\u0b3f\u0b32\u0b3f" },
            { "GL", "\u0b17\u0b4d\u0b30\u0b40\u0b28\u0b32\u0b4d\u0b5f\u0b3e\u0b23\u0b4d\u0b21" },
            { "enm", "\u0b2e\u0b27\u0b4d\u0b5f \u0b07\u0b01\u0b30\u0b3e\u0b1c\u0b40" },
            { "GM", "\u0b17\u0b3e\u0b2e\u0b4d\u0b2c\u0b3f\u0b06" },
            { "GN", "\u0b17\u0b41\u0b07\u0b28\u0b3f\u0b06" },
            { "GP", "\u0b17\u0b41\u0b06\u0b21\u0b47\u0b32\u0b4b\u0b2a\u0b4d\u200c" },
            { "GQ", "\u0b07\u0b15\u0b4d\u0b2c\u0b3e\u0b1f\u0b47\u0b30\u0b3f\u0b06\u0b32\u0b4d \u0b17\u0b41\u0b07\u0b28\u0b3f\u0b06" },
            { "GR", "\u0b17\u0b4d\u0b30\u0b40\u0b38\u0b4d" },
            { "GS", "\u0b26\u0b15\u0b4d\u0b37\u0b3f\u0b23 \u0b1c\u0b30\u0b4d\u0b1c\u0b3f\u0b06 \u0b0f\u0b2c\u0b02 \u0b26\u0b15\u0b4d\u0b37\u0b3f\u0b23 \u0b38\u0b3e\u0b23\u0b4d\u0b21\u0b71\u0b3f\u0b1a\u0b4d \u0b26\u0b4d\u0b71\u0b40\u0b2a\u0b2a\u0b41\u0b1e\u0b4d\u0b1c" },
            { "GT", "\u0b17\u0b41\u0b0f\u0b24\u0b2e\u0b3e\u0b32\u0b3e" },
            { "GU", "\u0b17\u0b41\u0b06\u0b2e\u0b4d" },
            { "GW", "\u0b17\u0b41\u0b07\u0b28\u0b3f\u0b06-\u0b2c\u0b3f\u0b38\u0b3e\u0b09" },
            { "tli", "\u0b24\u0b4d\u0b32\u0b3f\u0b19\u0b4d\u0b17\u0b3f\u0b1f\u0b4d" },
            { "tlh", "\u0b15\u0b4d\u0b32\u0b3f\u0b19\u0b4d\u0b17\u0b28\u0b4d" },
            { "Talu", "\u0b28\u0b42\u0b24\u0b28 \u0b24\u0b3e\u0b07 \u0b32\u0b41\u0b0f" },
            { "GY", "\u0b17\u0b41\u0b07\u0b28\u0b3e" },
            { "ckb", "\u0b15\u0b47\u0b28\u0b4d\u0b26\u0b4d\u0b30\u0b40\u0b5f \u0b15\u0b41\u0b30\u0b21\u0b3f\u0b38\u0b4d" },
            { "zxx", "\u0b15\u0b4c\u0b23\u0b38\u0b3f \u0b32\u0b3f\u0b19\u0b4d\u0b17\u0b41\u0b07\u0b37\u0b4d\u0b1f \u0b38\u0b3e\u0b2e\u0b17\u0b4d\u0b30\u0b40 \u0b28\u0b3e\u0b39\u0b3f\u0b01" },
            { "de_AT", "\u0b05\u0b37\u0b4d\u0b1f\u0b4d\u0b30\u0b3f\u0b06\u0b28\u0b4d \u0b1c\u0b30\u0b4d\u0b2e\u0b3e\u0b28" },
            { "HK", "\u0b39\u0b02 \u0b15\u0b02 \u0b0f\u0b38\u0b0f\u0b06\u0b30\u0b4d\u200c \u0b1a\u0b3e\u0b07\u0b28\u0b3e" },
            { "Vaii", "\u0b71\u0b3e\u0b07" },
            { "HM", "\u0b39\u0b3e\u0b30\u0b4d\u0b21\u0b4d\u200c \u0b0f\u0b2c\u0b02 \u0b2e\u0b4d\u0b5f\u0b3e\u0b15\u0b21\u0b4b\u0b28\u0b3e\u0b32\u0b4d\u0b21 \u0b26\u0b4d\u0b71\u0b40\u0b2a\u0b2a\u0b41\u0b1e\u0b4d\u0b1c" },
            { "HN", "\u0b39\u0b4b\u0b23\u0b4d\u0b21\u0b41\u0b30\u0b3e\u0b38\u0b4d\u200c" },
            { "HR", "\u0b15\u0b4d\u0b30\u0b4b\u0b0f\u0b38\u0b3f\u0b06" },
            { "agq", "\u0b06\u0b18\u0b47\u0b2e" },
            { "gsw", "\u0b38\u0b41\u0b07\u0b38\u0b4d \u0b1c\u0b30\u0b4d\u0b2e\u0b3e\u0b28\u0b4d" },
            { "HT", "\u0b39\u0b3e\u0b07\u0b24\u0b3f" },
            { "HU", "\u0b39\u0b19\u0b4d\u0b17\u0b47\u0b30\u0b40" },
            { "tmh", "\u0b24\u0b3e\u0b2e\u0b3e\u0b36\u0b47\u0b15\u0b4d" },
            { "IC", "\u0b15\u0b47\u0b28\u0b47\u0b30\u0b40 \u0b26\u0b4d\u0b71\u0b40\u0b2a\u0b2a\u0b41\u0b1e\u0b4d\u0b1c" },
            { "ID", "\u0b07\u0b23\u0b4d\u0b21\u0b4b\u0b28\u0b47\u0b38\u0b3f\u0b06" },
            { "peo", "\u0b2a\u0b41\u0b30\u0b41\u0b23\u0b3e \u0b2a\u0b30\u0b4d\u0b38\u0b3f\u0b06\u0b28\u0b4d" },
            { "IE", "\u0b06\u0b5f\u0b30\u0b32\u0b4d\u0b5f\u0b3e\u0b23\u0b4d\u0b21" },
            { "nap", "\u0b28\u0b40\u0b2a\u0b4b\u0b32\u0b3f\u0b1f\u0b3e\u0b28\u0b4d" },
            { "naq", "\u0b28\u0b3e\u0b2e\u0b3e" },
            { "zza", "\u0b1c\u0b3e\u0b1c\u0b3e" },
            { "IL", "\u0b07\u0b38\u0b4d\u0b30\u0b3e\u0b0f\u0b32\u0b4d" },
            { "IM", "\u0b06\u0b07\u0b32\u0b4d\u200c \u0b05\u0b2b\u0b4d\u200c \u0b2e\u0b4d\u0b5f\u0b3e\u0b28\u0b4d\u200c" },
            { "IN", "\u0b2d\u0b3e\u0b30\u0b24" },
            { "IO", "\u0b2c\u0b4d\u0b30\u0b3f\u0b1f\u0b3f\u0b36\u0b4d\u200c \u0b2d\u0b3e\u0b30\u0b24 \u0b2e\u0b3e\u0b39\u0b3e\u0b38\u0b3e\u0b17\u0b30 \u0b15\u0b4d\u0b37\u0b47\u0b24\u0b4d\u0b30" },
            { "IQ", "\u0b07\u0b30\u0b3e\u0b15\u0b4d" },
            { "IR", "\u0b07\u0b30\u0b3e\u0b28" },
            { "IS", "\u0b06\u0b07\u0b38\u0b32\u0b4d\u0b5f\u0b3e\u0b23\u0b4d\u0b21" },
            { "IT", "\u0b07\u0b1f\u0b3e\u0b32\u0b40" },
            { "Zmth", "\u0b17\u0b3e\u0b23\u0b3f\u0b24\u0b3f\u0b15 \u0b28\u0b4b\u0b1f\u0b47\u0b38\u0b28\u0b4d" },
            { "type.nu.thai", "\u0b25\u0b3e\u0b07 \u0b05\u0b19\u0b4d\u0b15\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "type.nu.beng", "\u0b2c\u0b19\u0b4d\u0b17\u0b33\u0b3e \u0b05\u0b19\u0b4d\u0b15\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "JE", "\u0b1c\u0b30\u0b4d\u0b38\u0b3f" },
            { "type.ca.islamic", "\u0b07\u0b38\u0b32\u0b3e\u0b2e\u0b3f\u0b15\u0b4d\u200c \u0b15\u0b4d\u0b5f\u0b3e\u0b32\u0b47\u0b23\u0b4d\u0b21\u0b30\u0b4d\u200c" },
            { "Beng", metaValue_bn },
            { "JM", "\u0b1c\u0b3e\u0b2e\u0b3e\u0b07\u0b15\u0b3e" },
            { "JO", "\u0b1c\u0b4b\u0b30\u0b4d\u0b21\u0b3e\u0b28\u0b4d" },
            { "JP", "\u0b1c\u0b3e\u0b2a\u0b3e\u0b28" },
            { "ain", "\u0b06\u0b07\u0b28\u0b41" },
            { "guz", "\u0b17\u0b41\u0b38\u0b3f" },
            { "tog", "\u0b28\u0b4d\u0b5f\u0b3e\u0b38\u0b3e \u0b1f\u0b4b\u0b19\u0b4d\u0b17\u0b4b" },
            { "type.nu.knda", "\u0b15\u0b28\u0b4d\u0b28\u0b21\u0b3c \u0b05\u0b19\u0b4d\u0b15\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "Kali", "\u0b15\u0b3e\u0b5f\u0b3e\u0b39\u0b3e \u0b32\u0b40" },
            { "de_CH", "\u0b38\u0b4d\u0b71\u0b3f\u0b38\u0b4d\u200c \u0b39\u0b3e\u0b07 \u0b1c\u0b30\u0b4d\u0b2e\u0b3e\u0b28" },
            { "type.ca.buddhist", "\u0b2c\u0b4c\u0b26\u0b4d\u0b27\u0b27\u0b30\u0b4d\u0b2e\u0b3e\u0b32\u0b2e\u0b4d\u0b2c\u0b40\u0b19\u0b4d\u0b15 \u0b15\u0b4d\u0b5f\u0b3e\u0b32\u0b47\u0b23\u0b4d\u0b21\u0b30\u0b4d\u200c" },
            { "KE", "\u0b15\u0b47\u0b28\u0b3f\u0b5f\u0b3e" },
            { "419", "\u0b32\u0b3e\u0b1f\u0b3f\u0b28\u0b4d\u200c \u0b06\u0b2e\u0b47\u0b30\u0b3f\u0b15\u0b3e" },
            { "KG", "\u0b15\u0b3f\u0b30\u0b4d\u0b17\u0b3f\u0b1c\u0b3f\u0b38\u0b4d\u0b24\u0b3e\u0b28" },
            { "KH", "\u0b15\u0b3e\u0b2e\u0b4d\u0b2c\u0b4b\u0b21\u0b3f\u0b06" },
            { "KI", "\u0b15\u0b3f\u0b30\u0b3f\u0b2c\u0b3e\u0b1f\u0b3f" },
            { "KM", "\u0b15\u0b4b\u0b2e\u0b4b\u0b30\u0b38\u0b4d\u200c" },
            { "KN", "\u0b38\u0b47\u0b23\u0b4d\u0b1f \u0b15\u0b3f\u0b1f\u0b38\u0b4d\u200c \u0b0f\u0b2c\u0b02 \u0b28\u0b47\u0b2d\u0b3f\u0b38\u0b4d\u200c" },
            { "Knda", "\u0b15\u0b28\u0b4d\u0b28\u0b21\u0b3c" },
            { "Zinh", "\u0b2c\u0b02\u0b36\u0b17\u0b24" },
            { "fr_CA", "\u0b15\u0b3e\u0b28\u0b3e\u0b21\u0b3f\u0b5f \u0b2b\u0b4d\u0b30\u0b47\u0b1e\u0b4d\u0b1a" },
            { "KP", "\u0b09\u0b24\u0b4d\u0b24\u0b30 \u0b15\u0b4b\u0b30\u0b3f\u0b06" },
            { "KR", "\u0b26\u0b15\u0b4d\u0b37\u0b3f\u0b23 \u0b15\u0b4b\u0b30\u0b3f\u0b06" },
            { "Plrd", "\u0b2a\u0b4b\u0b32\u0b3e\u0b30\u0b4d\u0b21 \u0b2b\u0b4b\u0b28\u0b47\u0b1f\u0b3f\u0b15\u0b4d" },
            { "fr_CH", "\u0b38\u0b4d\u0b71\u0b3f\u0b38\u0b4d \u0b2b\u0b4d\u0b30\u0b47\u0b1e\u0b4d\u0b1a" },
            { "KW", "\u0b15\u0b41\u0b0f\u0b24\u0b4d" },
            { "tpi", "\u0b1f\u0b4b\u0b15\u0b4d \u0b2a\u0b3f\u0b38\u0b3f\u0b28\u0b4d" },
            { "KY", "\u0b15\u0b47\u0b2e\u0b4d\u0b5f\u0b3e\u0b28\u0b4d\u200c \u0b26\u0b4d\u0b71\u0b40\u0b2a\u0b2a\u0b41\u0b1e\u0b4d\u0b1c" },
            { "KZ", "\u0b15\u0b3e\u0b1c\u0b3e\u0b15\u0b3e\u0b38\u0b4d\u0b24\u0b3e\u0b28" },
            { "Cyrl", "\u0b38\u0b3f\u0b30\u0b3f\u0b32\u0b3f\u0b15\u0b4d" },
            { "LA", "\u0b32\u0b3e\u0b13\u0b38\u0b4d" },
            { "LB", "\u0b32\u0b47\u0b2c\u0b3e\u0b28\u0b28\u0b4d" },
            { "LC", "\u0b38\u0b47\u0b23\u0b4d\u0b1f \u0b32\u0b41\u0b38\u0b3f\u0b06" },
            { "phn", "\u0b2b\u0b4b\u0b28\u0b47\u0b38\u0b3f\u0b06\u0b28\u0b4d" },
            { "Cyrs", "\u0b13\u0b32\u0b4d\u0b21 \u0b1a\u0b30\u0b4d\u0b1a\u0b4d\u0b1a \u0b38\u0b3e\u0b32\u0b2d\u0b4b\u0b28\u0b3f\u0b15\u0b4d \u0b38\u0b3f\u0b30\u0b3f\u0b32\u0b3f\u0b15\u0b4d" },
            { "gwi", "\u0b17\u0b71\u0b3f\u0b1a\u2019\u0b07\u0b28\u0b4d" },
            { "nds", "\u0b32\u0b4b \u0b1c\u0b30\u0b4d\u0b2e\u0b3e\u0b28\u0b4d" },
            { "LI", "\u0b32\u0b3f\u0b1a\u0b47\u0b1f\u0b28\u0b37\u0b4d\u0b1f\u0b47\u0b07\u0b28\u0b4d" },
            { "LK", "\u0b36\u0b4d\u0b30\u0b40\u0b32\u0b19\u0b4d\u0b15\u0b3e" },
            { "akk", "\u0b06\u0b15\u0b3e\u0b21\u0b3f\u0b06\u0b28\u0b4d" },
            { "cop", "\u0b15\u0b2a\u0b4d\u0b1f\u0b3f\u0b15\u0b4d" },
            { "LR", "\u0b32\u0b3e\u0b07\u0b2c\u0b47\u0b30\u0b3f\u0b06" },
            { "LS", "\u0b32\u0b47\u0b38\u0b4b\u0b25\u0b4b" },
            { "Phlv", "\u0b2c\u0b41\u0b15\u0b4d \u0b2a\u0b3e\u0b39\u0b3e\u0b32\u0b3e\u0b71\u0b40" },
            { "LT", "\u0b32\u0b3f\u0b25\u0b41\u0b06\u0b28\u0b3f\u0b06" },
            { "LU", "\u0b32\u0b15\u0b4d\u0b38\u0b47\u0b2e\u0b2c\u0b30\u0b4d\u0b17" },
            { "LV", "\u0b32\u0b3e\u0b1f\u0b2d\u0b3f\u0b06" },
            { "Kana", "\u0b15\u0b3e\u0b24\u0b3e\u0b15\u0b3e\u0b28\u0b3e" },
            { "LY", "\u0b32\u0b3f\u0b2c\u0b4d\u0b5f\u0b3e" },
            { "lad", "\u0b32\u0b3e\u0b26\u0b3f\u0b28\u0b4b" },
            { "vun", "\u0b2d\u0b41\u0b28\u0b1c\u0b4b" },
            { "lah", "\u0b32\u0b3e\u0b39\u0b3e\u0b23\u0b4d\u0b21\u0b3e" },
            { "lag", "\u0b32\u0b3e\u0b28\u0b17\u0b3f" },
            { "Thaa", "\u0b25\u0b3e\u0b28\u0b3e" },
            { "MA", "\u0b2e\u0b4b\u0b30\u0b4b\u0b15\u0b4d\u0b15\u0b4b" },
            { "MC", "\u0b2e\u0b4b\u0b28\u0b3e\u0b15\u0b4b" },
            { "MD", "\u0b2e\u0b3e\u0b32\u0b21\u0b4b\u0b2d\u0b3e" },
            { "ME", "\u0b2e\u0b23\u0b4d\u0b1f\u0b47\u0b28\u0b3f\u0b17\u0b4d\u0b30\u0b4b" },
            { "MF", "\u0b38\u0b47\u0b23\u0b4d\u0b1f \u0b2e\u0b3e\u0b30\u0b4d\u0b1f\u0b3f\u0b28\u0b4d" },
            { "lam", "\u0b32\u0b3e\u0b2e\u0b4d\u0b2c\u0b3e" },
            { "MG", "\u0b2e\u0b3e\u0b21\u0b3e\u0b17\u0b3e\u0b38\u0b4d\u0b15\u0b30\u0b4d" },
            { "Thai", metaValue_th },
            { "MH", "\u0b2e\u0b3e\u0b30\u0b4d\u0b36\u0b3e\u0b32\u0b4d\u200c \u0b26\u0b4d\u0b71\u0b40\u0b2a\u0b2a\u0b41\u0b1e\u0b4d\u0b1c" },
            { "ale", "\u0b06\u0b32\u0b47\u0b07\u0b1f\u0b41" },
            { "MK", "\u0b2e\u0b3e\u0b38\u0b47\u0b21\u0b4b\u0b28\u0b3f\u0b06" },
            { "ML", "\u0b2e\u0b3e\u0b32\u0b3f" },
            { "MM", "\u0b2e\u0b3f\u0b06\u0b01\u0b2e\u0b3e\u0b30" },
            { "MN", "\u0b2e\u0b19\u0b4d\u0b17\u0b4b\u0b32\u0b3f\u0b06" },
            { "new", "\u0b28\u0b47\u0b71\u0b3e\u0b30\u0b40" },
            { "MO", "\u0b2e\u0b3e\u0b15\u0b3e\u0b09 \u0b0f\u0b38\u0b0f\u0b06\u0b30\u0b4d\u200c \u0b1a\u0b3e\u0b07\u0b28\u0b3e" },
            { "MP", "\u0b09\u0b24\u0b4d\u0b24\u0b30 \u0b2e\u0b3e\u0b30\u0b3f\u0b06\u0b28\u0b3e \u0b26\u0b4d\u0b71\u0b40\u0b2a\u0b2a\u0b41\u0b1e\u0b4d\u0b1c" },
            { "MQ", "\u0b2e\u0b3e\u0b30\u0b4d\u0b1f\u0b3f\u0b28\u0b3f\u0b15\u0b4d\u0b5f\u0b41" },
            { "MR", "\u0b2e\u0b4c\u0b30\u0b3f\u0b1f\u0b3e\u0b28\u0b3f\u0b06" },
            { "MS", "\u0b2e\u0b23\u0b4d\u0b1f\u0b47\u0b38\u0b47\u0b30\u0b3e\u0b1f\u0b4d" },
            { "MT", "\u0b2e\u0b3e\u0b32\u0b4d\u0b1f\u0b3e" },
            { "MU", "\u0b2e\u0b30\u0b3f\u0b38\u0b38" },
            { "alt", "\u0b26\u0b15\u0b4d\u0b37\u0b3f\u0b23 \u0b06\u0b32\u0b4d\u0b1f\u0b3e\u0b07" },
            { "MV", "\u0b2e\u0b3e\u0b32\u0b26\u0b3f\u0b2d\u0b38\u0b4d\u200c" },
            { "MW", "\u0b2e\u0b3e\u0b32\u0b71\u0b3f" },
            { "MX", "\u0b2e\u0b47\u0b15\u0b4d\u0b38\u0b3f\u0b15\u0b4b" },
            { "type.ca.japanese", "\u0b1c\u0b3e\u0b2a\u0b3e\u0b28\u0b3f\u0b1c\u0b4d\u200c \u0b15\u0b4d\u0b5f\u0b3e\u0b32\u0b47\u0b23\u0b4d\u0b21\u0b30\u0b4d\u200c" },
            { "MY", "\u0b2e\u0b3e\u0b32\u0b47\u0b38\u0b3f\u0b06" },
            { "MZ", "\u0b2e\u0b4b\u0b1c\u0b3e\u0b2e\u0b4d\u0b2c\u0b3f\u0b15\u0b4d\u200c" },
            { "Phli", "\u0b07\u0b28\u0b38\u0b4d\u0b15\u0b4d\u0b30\u0b40\u0b2a\u0b38\u0b3e\u0b28\u0b32\u0b4d \u0b2a\u0b3e\u0b39\u0b3e\u0b32\u0b3e\u0b71\u0b40" },
            { "NA", "\u0b28\u0b3e\u0b2e\u0b3f\u0b2c\u0b3f\u0b06" },
            { "202", "\u0b09\u0b2a-\u0b38\u0b3e\u0b39\u0b3e\u0b30\u0b3e \u0b06\u0b2b\u0b4d\u0b30\u0b3f\u0b15\u0b3e" },
            { "type.ca.hebrew", "\u0b39\u0b3f\u0b2c\u0b43 \u0b15\u0b4d\u0b5f\u0b3e\u0b32\u0b47\u0b23\u0b4d\u0b21\u0b30\u0b4d\u200c" },
            { "NC", "\u0b28\u0b42\u0b24\u0b28 \u0b15\u0b3e\u0b32\u0b47\u0b21\u0b4b\u0b28\u0b3f\u0b06" },
            { "NE", "\u0b28\u0b3e\u0b07\u0b1c\u0b30" },
            { "NF", "\u0b28\u0b30\u0b4d\u0b2b\u0b15\u0b4d\u200c \u0b26\u0b4d\u0b71\u0b40\u0b2a" },
            { "NG", "\u0b28\u0b3e\u0b07\u0b1c\u0b47\u0b30\u0b3f\u0b06" },
            { "trv", "\u0b24\u0b3e\u0b30\u0b4b\u0b15\u0b4b" },
            { "Phlp", "\u0b38\u0b4d\u0b32\u0b3e\u0b1f\u0b30\u0b4d \u0b2a\u0b3e\u0b39\u0b3e\u0b32\u0b3e\u0b71\u0b40" },
            { "NI", "\u0b28\u0b3f\u0b15\u0b3e\u0b30\u0b3e\u0b17\u0b41\u0b06" },
            { "Hmng", "\u0b2a\u0b3e\u0b39\u0b4b \u0b39\u0b4b\u0b19\u0b4d\u0b17" },
            { "NL", "\u0b28\u0b47\u0b26\u0b30\u0b32\u0b4d\u0b5f\u0b3e\u0b23\u0b4d\u0b21" },
            { "NO", "\u0b28\u0b30\u0b71\u0b47" },
            { "NP", "\u0b28\u0b47\u0b2a\u0b3e\u0b33" },
            { "NR", metaValue_NR },
            { "NU", "\u0b28\u0b3f\u0b09" },
            { "Phnx", "\u0b2b\u0b47\u0b28\u0b4b\u0b38\u0b3f\u0b06\u0b28\u0b4d" },
            { "rof", "\u0b30\u0b4b\u0b2e\u0b4d\u0b2c\u0b4b" },
            { "tsi", "\u0b24\u0b3f\u0b38\u0b3f\u0b2e\u0b3f\u0b38\u0b3f\u0b06\u0b28\u0b4d" },
            { "NZ", "\u0b28\u0b4d\u0b5f\u0b41\u0b1c\u0b3f\u0b32\u0b3e\u0b23\u0b4d\u0b21" },
            { "rom", "\u0b30\u0b4b\u0b2e\u0b3e\u0b28\u0b3f" },
            { "Mero", "\u0b2e\u0b47\u0b30\u0b4b\u0b07\u0b1f\u0b3f\u0b15\u0b4d" },
            { "crh", "\u0b15\u0b4d\u0b30\u0b40\u0b2e\u0b3f\u0b28\u0b4d \u0b24\u0b41\u0b30\u0b4d\u0b15\u0b40\u0b38\u0b4d" },
            { "ang", "\u0b2a\u0b41\u0b30\u0b41\u0b23\u0b3e \u0b07\u0b01\u0b30\u0b3e\u0b1c\u0b40" },
            { "OM", "\u0b13\u0b2e\u0b3e\u0b28\u0b4d" },
            { "anp", "\u0b05\u0b01\u0b17\u0b40\u0b15\u0b3e" },
            { "crs", "\u0b38\u0b47\u0b38\u0b47\u0b32\u0b71\u0b3e \u0b15\u0b4d\u0b30\u0b47\u0b13\u0b32\u0b47 \u0b2b\u0b4d\u0b30\u0b47\u0b1e\u0b4d\u0b1a\u0b4d" },
            { "Xpeo", "\u0b2a\u0b41\u0b30\u0b41\u0b23\u0b3e \u0b2b\u0b30\u0b3e\u0b38\u0b40" },
            { "PA", "\u0b2a\u0b3e\u0b28\u0b3e\u0b2e\u0b3e" },
            { "csb", "\u0b15\u0b3e\u0b36\u0b41\u0b2c\u0b3f\u0b06\u0b28\u0b4d" },
            { "en_GB", "\u0b2c\u0b4d\u0b30\u0b3f\u0b1f\u0b3f\u0b36\u0b4d\u200c \u0b07\u0b02\u0b30\u0b3e\u0b1c\u0b40" },
            { "PE", "\u0b2a\u0b47\u0b30\u0b41" },
            { "PF", "\u0b2b\u0b4d\u0b30\u0b47\u0b1e\u0b4d\u0b1a \u0b2a\u0b32\u0b3f\u0b28\u0b47\u0b38\u0b3f\u0b06" },
            { "PG", "\u0b2a\u0b2a\u0b41\u0b06 \u0b28\u0b4d\u0b5f\u0b41 \u0b17\u0b41\u0b0f\u0b28\u0b3f\u0b06" },
            { "PH", "\u0b2b\u0b3f\u0b32\u0b3f\u0b2a\u0b3e\u0b07\u0b28\u0b38\u0b4d" },
            { "PK", "\u0b2a\u0b3e\u0b15\u0b3f\u0b38\u0b4d\u0b24\u0b3e\u0b28" },
            { "PL", "\u0b2a\u0b4b\u0b32\u0b3e\u0b23\u0b4d\u0b21" },
            { "ewo", "\u0b07\u0b71\u0b4b\u0b23\u0b4d\u0b21\u0b4b" },
            { "PM", "\u0b38\u0b47\u0b23\u0b4d\u0b1f \u0b2a\u0b3f\u0b0f\u0b30\u0b47 \u0b0f\u0b2c\u0b02 \u0b2e\u0b3f\u0b15\u0b4d\u0b71\u0b47\u0b32\u0b28\u0b4d\u200c" },
            { "PN", "\u0b2a\u0b3f\u0b1f\u0b15\u0b3e\u0b07\u0b30\u0b3f\u0b28\u0b4d\u200c \u0b26\u0b4d\u0b71\u0b40\u0b2a\u0b2a\u0b41\u0b1e\u0b4d\u0b1c" },
            { "PR", "\u0b2a\u0b41\u0b0f\u0b30\u0b4d\u0b24\u0b4d\u0b24\u0b4b \u0b30\u0b3f\u0b15\u0b4b" },
            { "Bali", metaValue_ban },
            { "PS", "\u0b2a\u0b3e\u0b32\u0b47\u0b37\u0b4d\u0b1f\u0b47\u0b28\u0b3f\u0b5f \u0b2d\u0b42\u0b2d\u0b3e\u0b17" },
            { "PT", "\u0b2a\u0b30\u0b4d\u0b24\u0b4d\u0b24\u0b41\u0b17\u0b3e\u0b32\u0b4d" },
            { "PW", "\u0b2a\u0b3e\u0b32\u0b3e\u0b09" },
            { "nia", "\u0b28\u0b40\u0b5f\u0b3e\u0b38\u0b4d" },
            { "type.nu.greklow", "\u0b17\u0b4d\u0b30\u0b40\u0b15\u0b4d\u200c \u0b1b\u0b4b\u0b1f \u0b05\u0b15\u0b4d\u0b37\u0b30 \u0b38\u0b02\u0b16\u0b4d\u0b5f\u0b3e\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "PY", "\u0b2a\u0b3e\u0b30\u0b3e\u0b17\u0b41\u0b0f" },
            { "tum", "\u0b1f\u0b41\u0b2e\u0b4d\u0b2c\u0b41\u0b15\u0b3e" },
            { "Hebr", "\u0b39\u0b3f\u0b2c\u0b43" },
            { "QA", "\u0b15\u0b24\u0b3e\u0b30\u0b4d" },
            { "niu", "\u0b28\u0b3f\u0b5f\u0b41\u0b06\u0b28\u0b4d" },
            { "QO", "\u0b38\u0b40\u0b2e\u0b3e\u0b28\u0b4d\u0b24\u0b2c\u0b30\u0b4d\u0b24\u0b4d\u0b24\u0b40 \u0b13\u0b38\u0b3f\u0b28\u0b3f\u0b06" },
            { "lez", "\u0b32\u0b47\u0b1c\u0b17\u0b3f\u0b5f\u0b3e\u0b28\u0b4d" },
            { "tvl", metaValue_TV },
            { "Tavt", "\u0b24\u0b3e\u0b07 \u0b2d\u0b3f\u0b0f\u0b24\u0b4d" },
            { "001", "\u0b2c\u0b3f\u0b36\u0b4d\u0b71" },
            { "002", "\u0b06\u0b2b\u0b4d\u0b30\u0b3f\u0b15\u0b3e" },
            { "003", "\u0b09\u0b24\u0b4d\u0b24\u0b30 \u0b06\u0b2e\u0b47\u0b30\u0b3f\u0b15\u0b3e" },
            { "RE", "\u0b30\u0b3f\u0b5f\u0b41\u0b28\u0b3f\u0b05\u0b28\u0b4d" },
            { "005", "\u0b26\u0b15\u0b4d\u0b37\u0b3f\u0b23 \u0b06\u0b2e\u0b47\u0b30\u0b3f\u0b15\u0b3e" },
            { "jbo", "\u0b32\u0b4b\u0b1c\u0b2c\u0b3e\u0b28\u0b4d" },
            { "Rjng", "\u0b30\u0b47\u0b1c\u0b3e\u0b19\u0b4d\u0b17" },
            { "009", "\u0b13\u0b38\u0b3f\u0b28\u0b3f\u0b06" },
            { "RO", "\u0b30\u0b4b\u0b2e\u0b3e\u0b28\u0b3f\u0b06" },
            { "RS", "\u0b38\u0b30\u0b4d\u0b2c\u0b3f\u0b06" },
            { "RU", "\u0b30\u0b41\u0b37\u0b3f\u0b06" },
            { "RW", "\u0b30\u0b3e\u0b71\u0b3e\u0b23\u0b4d\u0b21\u0b3e" },
            { "Mani", "\u0b2e\u0b28\u0b36\u0b40\u0b28\u0b4d" },
            { "Ugar", "\u0b5f\u0b41\u0b17\u0b3e\u0b30\u0b3f\u0b1f\u0b3f\u0b15\u0b4d" },
            { "Khar", "\u0b16\u0b3e\u0b30\u0b4b\u0b38\u0b4d\u0b25\u0b3f" },
            { "SA", "\u0b38\u0b3e\u0b09\u0b26\u0b3f \u0b06\u0b30\u0b2c\u0b3f\u0b06" },
            { "pon", "\u0b2a\u0b4b\u0b39\u0b2a\u0b3f\u0b0f\u0b28\u0b4d" },
            { "Mand", "\u0b2e\u0b3e\u0b28\u0b21\u0b47\u0b28\u0b4d" },
            { "SB", "\u0b38\u0b4b\u0b32\u0b4b\u0b2e\u0b28\u0b4d\u200c \u0b26\u0b4d\u0b71\u0b40\u0b2a\u0b2a\u0b41\u0b1e\u0b4d\u0b1c" },
            { "twq", "\u0b24\u0b3e\u0b38\u0b3e\u0b71\u0b3e\u0b15\u0b4d" },
            { "011", "\u0b2a\u0b36\u0b4d\u0b1a\u0b3f\u0b2e \u0b06\u0b2b\u0b4d\u0b30\u0b3f\u0b15\u0b3e" },
            { "SC", "\u0b38\u0b47\u0b1a\u0b47\u0b32\u0b38\u0b4d" },
            { "SD", "\u0b38\u0b41\u0b26\u0b3e\u0b28" },
            { "013", "\u0b2e\u0b27\u0b4d\u0b5f \u0b06\u0b2e\u0b47\u0b30\u0b3f\u0b15\u0b3e" },
            { "SE", "\u0b38\u0b4d\u0b71\u0b47\u0b21\u0b47\u0b28\u0b4d" },
            { "014", "\u0b2a\u0b42\u0b30\u0b4d\u0b2c \u0b06\u0b2b\u0b4d\u0b30\u0b3f\u0b15\u0b3e" },
            { "arc", "\u0b06\u0b30\u0b3e\u0b2e\u0b3e\u0b07\u0b15\u0b4d" },
            { "015", "\u0b09\u0b24\u0b4d\u0b24\u0b30 \u0b06\u0b2b\u0b4d\u0b30\u0b3f\u0b15\u0b3e" },
            { "SG", "\u0b38\u0b3f\u0b19\u0b4d\u0b17\u0b3e\u0b2a\u0b41\u0b30\u0b4d" },
            { "SH", "\u0b38\u0b47\u0b23\u0b4d\u0b1f \u0b39\u0b47\u0b32\u0b47\u0b28\u0b3e" },
            { "type.lb.strict", "\u0b15\u0b20\u0b4b\u0b30 \u0b27\u0b3e\u0b21\u0b3c\u0b3f \u0b2c\u0b3f\u0b30\u0b24\u0b3f \u0b36\u0b48\u0b33\u0b40" },
            { "017", "\u0b2e\u0b27\u0b4d\u0b5f \u0b06\u0b2b\u0b4d\u0b30\u0b3f\u0b15\u0b3e" },
            { "SI", "\u0b38\u0b4d\u0b32\u0b4b\u0b2d\u0b47\u0b28\u0b3f\u0b06" },
            { "018", "\u0b26\u0b15\u0b4d\u0b37\u0b3f\u0b23\u0b38\u0b4d\u0b25 \u0b06\u0b2b\u0b4d\u0b30\u0b3f\u0b15\u0b3e" },
            { "SJ", "\u0b38\u0b3e\u0b32\u0b2c\u0b3e\u0b30\u0b4d\u0b21 \u0b0f\u0b2c\u0b02 \u0b1c\u0b3e\u0b28\u0b4d\u200c \u0b2e\u0b3e\u0b5f\u0b47\u0b28\u0b4d\u200c" },
            { "019", "\u0b06\u0b2e\u0b47\u0b30\u0b3f\u0b15\u0b3e" },
            { "SK", "\u0b38\u0b4d\u0b32\u0b4b\u0b2d\u0b3e\u0b15\u0b3f\u0b06" },
            { "SL", "\u0b38\u0b3f\u0b0f\u0b30\u0b3e \u0b32\u0b3f\u0b13\u0b28" },
            { "SM", "\u0b38\u0b3e\u0b28\u0b4d \u0b2e\u0b3e\u0b30\u0b3f\u0b28\u0b4b" },
            { "SN", "\u0b38\u0b47\u0b28\u0b47\u0b17\u0b3e\u0b32\u0b4d" },
            { "SO", metaValue_SO },
            { "arn", "\u0b2e\u0b3e\u0b2a\u0b41\u0b1a\u0b47" },
            { "arp", "\u0b06\u0b30\u0b3e\u0b2a\u0b3e\u0b39\u0b4b" },
            { "type.nu.taml", "\u0b2a\u0b3e\u0b30\u0b2e\u0b4d\u0b2a\u0b30\u0b3f\u0b15 \u0b24\u0b3e\u0b2e\u0b3f\u0b32\u0b4d \u0b38\u0b02\u0b16\u0b4d\u0b5f\u0b3e\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "SR", "\u0b38\u0b41\u0b30\u0b3f\u0b28\u0b3e\u0b2e" },
            { "SS", "\u0b26\u0b15\u0b4d\u0b37\u0b3f\u0b23 \u0b38\u0b41\u0b26\u0b3e\u0b28" },
            { "ST", "\u0b38\u0b3e\u0b13 \u0b1f\u0b4b\u0b2e\u0b47 \u0b0f\u0b2c\u0b02 \u0b2a\u0b4d\u0b30\u0b3f\u0b28\u0b38\u0b3f\u0b2a\u0b3f" },
            { "SV", "\u0b0f\u0b32\u0b4d \u0b38\u0b3e\u0b32\u0b2d\u0b3e\u0b21\u0b4b\u0b30\u0b4d" },
            { "SX", "\u0b38\u0b3f\u0b23\u0b4d\u0b1f \u0b2e\u0b3e\u0b30\u0b4d\u0b1f\u0b40\u0b28\u0b4d\u200c" },
            { "SY", "\u0b38\u0b3f\u0b30\u0b3f\u0b06" },
            { "yao", "\u0b5f\u0b3e\u0b13" },
            { "SZ", "\u0b38\u0b4d\u0b71\u0b3e\u0b1c\u0b3f\u0b32\u0b4d\u0b5f\u0b3e\u0b23\u0b4d\u0b21" },
            { "arw", "\u0b06\u0b30\u0b71\u0b15" },
            { "yap", "\u0b5f\u0b3e\u0b2a\u0b40\u0b38\u0b4d" },
            { "TA", "\u0b1f\u0b4d\u0b30\u0b3e\u0b07\u0b37\u0b4d\u0b1f\u0b28\u0b4d\u200c \u0b26\u0b3e \u0b15\u0b41\u0b28\u0b4d\u200c\u0b1a\u0b3e" },
            { "asa", "\u0b06\u0b38\u0b41" },
            { "type.ms.ussystem", "\u0b5f\u0b41\u0b0f\u0b38\u0b4d\u200c \u0b2e\u0b3e\u0b2a \u0b2a\u0b26\u0b4d\u0b27\u0b24\u0b3f" },
            { "021", "\u0b09\u0b24\u0b4d\u0b24\u0b30\u0b38\u0b4d\u0b25 \u0b06\u0b2e\u0b47\u0b30\u0b3f\u0b15\u0b3e" },
            { "TC", "\u0b24\u0b41\u0b30\u0b4d\u0b15\u0b38\u0b4d\u200c \u0b0f\u0b2c\u0b02 \u0b15\u0b3e\u0b07\u0b15\u0b4b\u0b38\u0b4d\u200c \u0b26\u0b4d\u0b71\u0b40\u0b2a\u0b2a\u0b41\u0b1e\u0b4d\u0b1c" },
            { "yav", "\u0b5f\u0b3e\u0b02\u0b2c\u0b47\u0b28\u0b4d" },
            { "TD", "\u0b1a\u0b3e\u0b26\u0b4d" },
            { "TF", "\u0b2b\u0b30\u0b3e\u0b38\u0b40 \u0b26\u0b15\u0b4d\u0b37\u0b3f\u0b23 \u0b15\u0b4d\u0b37\u0b47\u0b24\u0b4d\u0b30" },
            { "TG", "\u0b1f\u0b4b\u0b17\u0b4b" },
            { "TH", "\u0b25\u0b3e\u0b07\u0b32\u0b4d\u0b5f\u0b3e\u0b23\u0b4d\u0b21" },
            { "TJ", "\u0b24\u0b3e\u0b1c\u0b3f\u0b15\u0b3f\u0b38\u0b4d\u0b25\u0b3e\u0b28\u0b4d" },
            { "TK", metaValue_TK },
            { "029", "\u0b15\u0b3e\u0b30\u0b3f\u0b2c\u0b3f\u0b06\u0b28\u0b4d" },
            { "TL", "\u0b24\u0b3f\u0b2e\u0b4b\u0b30\u0b4d-\u0b32\u0b47\u0b37\u0b4d\u0b1f\u0b47" },
            { "ybb", "\u0b5f\u0b47\u0b2e\u0b2c\u0b3e" },
            { "TM", "\u0b24\u0b41\u0b30\u0b4d\u0b15\u0b2e\u0b47\u0b28\u0b3f\u0b38\u0b4d\u0b24\u0b3e\u0b28" },
            { "TN", "\u0b1f\u0b4d\u0b5f\u0b41\u0b28\u0b3f\u0b38\u0b3f\u0b06" },
            { "TO", metaValue_TO },
            { "TR", "\u0b24\u0b41\u0b30\u0b4d\u0b15\u0b40" },
            { "TT", "\u0b24\u0b4d\u0b30\u0b3f\u0b28\u0b3f\u0b26\u0b3e\u0b26\u0b4d \u0b0f\u0b2c\u0b02 \u0b1f\u0b4b\u0b2c\u0b3e\u0b17\u0b4b" },
            { "TV", metaValue_TV },
            { "TW", "\u0b24\u0b3e\u0b07\u0b71\u0b3e\u0b28" },
            { "ast", "\u0b06\u0b37\u0b4d\u0b1f\u0b41\u0b30\u0b3f\u0b06\u0b28\u0b4d" },
            { "Orkh", "\u0b13\u0b30\u0b4b\u0b16\u0b28\u0b4d" },
            { "TZ", "\u0b24\u0b3e\u0b1e\u0b4d\u0b1c\u0b3e\u0b28\u0b3f\u0b06" },
            { "nmg", "\u0b15\u0b71\u0b3e\u0b38\u0b3f\u0b13" },
            { "Zzzz", "\u0b05\u0b1c\u0b23\u0b3e \u0b32\u0b3f\u0b2a\u0b3f" },
            { "UA", "\u0b5f\u0b41\u0b15\u0b4d\u0b30\u0b47\u0b28\u0b4d\u200c" },
            { "rup", "\u0b06\u0b30\u0b4b\u0b2e\u0b3e\u0b28\u0b3f\u0b06\u0b28\u0b4d" },
            { "030", "\u0b2a\u0b42\u0b30\u0b4d\u0b2c \u0b0f\u0b38\u0b3f\u0b06" },
            { "tyv", "\u0b24\u0b41\u0b2d\u0b3f\u0b28\u0b3f\u0b06\u0b28\u0b4d" },
            { "sw_CD", "\u0b15\u0b19\u0b4d\u0b17\u0b4b \u0b38\u0b4d\u0b71\u0b3e\u0b39\u0b3f\u0b32\u0b3f" },
            { "034", "\u0b26\u0b15\u0b4d\u0b37\u0b3f\u0b23 \u0b0f\u0b38\u0b3f\u0b06" },
            { "hai", "\u0b39\u0b3e\u0b07\u0b21\u0b3e" },
            { "035", "\u0b26\u0b15\u0b4d\u0b37\u0b3f\u0b23\u0b2a\u0b42\u0b30\u0b4d\u0b2c \u0b0f\u0b38\u0b3f\u0b06" },
            { "UG", "\u0b09\u0b17\u0b3e\u0b23\u0b4d\u0b21\u0b3e" },
            { "039", "\u0b26\u0b15\u0b4d\u0b37\u0b3f\u0b23 \u0b5f\u0b41\u0b30\u0b4b\u0b2a\u0b4d" },
            { "Sinh", "\u0b38\u0b3f\u0b02\u0b39\u0b3e\u0b32\u0b3e" },
            { "UM", "\u0b2f\u0b41\u0b15\u0b4d\u0b24\u0b30\u0b3e\u0b37\u0b4d\u0b1f\u0b4d\u0b30 \u0b06\u0b09\u0b1f\u0b4d\u200c\u0b32\u0b3e\u0b07\u0b19\u0b4d\u0b17 \u0b26\u0b4d\u0b35\u0b40\u0b2a\u0b2a\u0b41\u0b1e\u0b4d\u0b1c" },
            { "UN", "\u0b1c\u0b3e\u0b24\u0b3f\u0b38\u0b02\u0b18" },
            { "US", "\u0b2f\u0b41\u0b15\u0b4d\u0b24 \u0b30\u0b3e\u0b37\u0b4d\u0b1f\u0b4d\u0b30" },
            { "haw", "\u0b39\u0b3e\u0b71\u0b3e\u0b07\u0b28\u0b4d" },
            { "UY", "\u0b09\u0b30\u0b41\u0b17\u0b41\u0b0f" },
            { "prg", "\u0b2a\u0b4d\u0b30\u0b41\u0b38\u0b3f\u0b5f" },
            { "UZ", "\u0b09\u0b1c\u0b2c\u0b47\u0b15\u0b3f\u0b38\u0b4d\u0b24\u0b3e\u0b28" },
            { "tzm", "\u0b15\u0b47\u0b28\u0b4d\u0b26\u0b4d\u0b30\u0b40\u0b5f \u0b06\u0b1f\u0b32\u0b3e\u0b38\u0b4d \u0b1f\u0b3e\u0b2e\u0b3e\u0b1c\u0b3f\u0b18\u0b3e\u0b1f\u0b4d" },
            { "nnh", "\u0b28\u0b3e\u0b17\u0b3f\u0b2e\u0b2c\u0b4b\u0b28\u0b4d" },
            { "VA", "\u0b2d\u0b3e\u0b1f\u0b3f\u0b15\u0b3e\u0b28\u0b4d\u200c \u0b38\u0b3f\u0b1f\u0b3f" },
            { "pro", "\u0b2a\u0b41\u0b30\u0b41\u0b23\u0b3e \u0b2a\u0b4d\u0b30\u0b47\u0b2d\u0b47\u0b28\u0b47\u0b38\u0b3f\u0b06\u0b32\u0b4d" },
            { "VC", "\u0b38\u0b47\u0b23\u0b4d\u0b1f \u0b2d\u0b3f\u0b28\u0b38\u0b47\u0b23\u0b4d\u0b1f \u0b0f\u0b2c\u0b02 \u0b26\u0b3f \u0b17\u0b4d\u0b30\u0b47\u0b28\u0b3e\u0b21\u0b3f\u0b38\u0b4d" },
            { "VE", "\u0b2d\u0b47\u0b28\u0b47\u0b1c\u0b41\u0b0f\u0b32\u0b3e" },
            { "VG", "\u0b2c\u0b4d\u0b30\u0b3f\u0b1f\u0b3f\u0b36\u0b4d\u200c \u0b2d\u0b30\u0b4d\u0b1c\u0b3f\u0b28\u0b4d \u0b26\u0b4d\u0b71\u0b40\u0b2a\u0b2a\u0b41\u0b1e\u0b4d\u0b1c" },
            { "VI", "\u0b2f\u0b41\u0b15\u0b4d\u0b24\u0b30\u0b3e\u0b37\u0b4d\u0b1f\u0b4d\u0b30 \u0b2d\u0b3f\u0b30\u0b4d\u0b1c\u0b3f\u0b28\u0b4d \u0b26\u0b4d\u0b35\u0b40\u0b2a\u0b2a\u0b41\u0b1e\u0b4d\u0b1c" },
            { "VN", "\u0b2d\u0b3f\u0b0f\u0b24\u0b28\u0b3e\u0b2e\u0b4d" },
            { "VU", "\u0b2d\u0b3e\u0b28\u0b41\u0b06\u0b24\u0b41" },
            { "nog", "\u0b28\u0b4b\u0b17\u0b3e\u0b07" },
            { "rwk", "\u0b06\u0b30\u0b21\u0b2c\u0b4d\u0b5f\u0b41\u0b0f" },
            { "non", "\u0b2a\u0b41\u0b30\u0b41\u0b23\u0b3e \u0b28\u0b30\u0b4d\u0b38" },
            { "053", "\u0b05\u0b37\u0b4d\u0b1f\u0b4d\u0b30\u0b47\u0b32\u0b47\u0b38\u0b3f\u0b06" },
            { "054", "\u0b2e\u0b47\u0b32\u0b3e\u0b28\u0b47\u0b38\u0b3f\u0b06" },
            { "WF", "\u0b71\u0b3e\u0b32\u0b3f\u0b38\u0b4d \u0b0f\u0b2c\u0b02 \u0b2b\u0b41\u0b24\u0b41\u0b28\u0b3e" },
            { "057", "\u0b2e\u0b3e\u0b07\u0b15\u0b4d\u0b30\u0b4b\u0b28\u0b47\u0b38\u0b3f\u0b06\u0b28\u0b4d \u0b05\u0b1e\u0b4d\u0b1a\u0b33" },
            { "jgo", "\u0b28\u0b3e\u0b17\u0b4b\u0b2e\u0b4d\u0b35\u0b3e" },
            { "lkt", "\u0b32\u0b3e\u0b15\u0b4b\u0b1f\u0b3e" },
            { "wae", "\u0b71\u0b3e\u0b32\u0b38\u0b47\u0b30\u0b4d" },
            { "WS", "\u0b38\u0b3e\u0b2e\u0b4b\u0b06" },
            { "wal", "\u0b71\u0b3e\u0b32\u0b2e\u0b4b" },
            { "was", "\u0b71\u0b3e\u0b38\u0b4b" },
            { "war", "\u0b71\u0b3e\u0b30\u0b48" },
            { "awa", "\u0b06\u0b71\u0b3e\u0b27\u0b3f" },
            { "061", "\u0b2a\u0b32\u0b3f\u0b28\u0b47\u0b38\u0b3f\u0b06" },
            { "XK", "\u0b15\u0b4b\u0b38\u0b4b\u0b2d\u0b4b" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "\u0b05\u0b32\u0b3f\u0b16\u0b3f\u0b24" },
            { "Olck", "\u0b13\u0b32\u0b4d \u0b1a\u0b3f\u0b15\u0b3f" },
            { "Batk", "\u0b2c\u0b3e\u0b1f\u0b3e\u0b15\u0b4d" },
            { "Blis", metaValue_zbl },
            { "YE", "\u0b5f\u0b47\u0b2e\u0b47\u0b28\u0b4d" },
            { "nqo", "\u0b0f\u0b28\u0b15\u0b4b" },
            { "type.co.standard", "\u0b2e\u0b3e\u0b28\u0b3e\u0b19\u0b4d\u0b15 \u0b38\u0b30\u0b4d\u0b1f\u0b4d\u200c \u0b15\u0b4d\u0b30\u0b2e" },
            { "fan", "\u0b2b\u0b3e\u0b19\u0b4d\u0b17" },
            { "fat", "\u0b2b\u0b3e\u0b23\u0b4d\u0b1f\u0b3f" },
            { "Sgnw", "\u0b38\u0b3e\u0b19\u0b4d\u0b15\u0b47\u0b24\u0b3f\u0b15 \u0b32\u0b3f\u0b16" },
            { "YT", "\u0b2e\u0b3e\u0b5f\u0b4b\u0b1f\u0b47" },
            { "ZA", "\u0b26\u0b15\u0b4d\u0b37\u0b3f\u0b23 \u0b06\u0b2b\u0b4d\u0b30\u0b3f\u0b15\u0b3e" },
            { "type.lb.loose", "\u0b22\u0b3f\u0b32\u0b3e \u0b27\u0b3e\u0b21\u0b3c\u0b3f \u0b2c\u0b3f\u0b30\u0b24\u0b3f \u0b36\u0b48\u0b33\u0b40" },
            { "Deva", "\u0b26\u0b47\u0b2c\u0b28\u0b17\u0b30\u0b40" },
            { "type.nu.geor", "\u0b1c\u0b30\u0b4d\u0b1c\u0b3f\u0b06\u0b28\u0b4d\u200c \u0b38\u0b02\u0b16\u0b4d\u0b5f\u0b3e\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "Hira", "\u0b39\u0b3f\u0b30\u0b3e\u0b17\u0b3e\u0b28\u0b3e" },
            { "ZM", "\u0b1c\u0b3e\u0b2e\u0b4d\u0b2c\u0b3f\u0b06" },
            { "ZW", "\u0b1c\u0b3f\u0b2e\u0b4d\u0b2c\u0b3e\u0b71\u0b47" },
            { "ZZ", "\u0b05\u0b1c\u0b23\u0b3e \u0b05\u0b1e\u0b4d\u0b1a\u0b33" },
            { "Runr", "\u0b30\u0b28\u0b3f\u0b15\u0b4d" },
            { "type.ms.metric", "\u0b2e\u0b47\u0b1f\u0b4d\u0b30\u0b3f\u0b15\u0b4d\u200c \u0b2a\u0b26\u0b4d\u0b27\u0b24\u0b3f" },
            { "type.ca.iso8601", "ISO-8601 \u0b15\u0b4d\u0b5f\u0b3e\u0b32\u0b47\u0b23\u0b4d\u0b21\u0b30\u0b4d\u200c" },
            { "lol", "\u0b2e\u0b19\u0b4d\u0b17\u0b4b" },
            { "nso", "\u0b09\u0b24\u0b4d\u0b24\u0b30\u0b40 \u0b38\u0b4b\u0b25\u0b4b" },
            { "type.nu.telu", "\u0b24\u0b47\u0b32\u0b41\u0b17\u0b41 \u0b05\u0b19\u0b4d\u0b15\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "loz", "\u0b32\u0b4b\u0b1c\u0b3f" },
            { "jmc", "\u0b2e\u0b3e\u0b1a\u0b47\u0b2e\u0b47" },
            { "type.nu.hansfin", "\u0b38\u0b30\u0b33\u0b40\u0b15\u0b43\u0b24 \u0b1a\u0b3f\u0b28\u0b3f \u0b06\u0b30\u0b4d\u0b25\u0b3f\u0b15 \u0b38\u0b02\u0b16\u0b4d\u0b5f\u0b3e\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "hil", "\u0b39\u0b3f\u0b32\u0b3f\u0b17\u0b48\u0b28\u0b28\u0b4d" },
            { "type.nu.arabext", "\u0b2a\u0b30\u0b3f\u0b2c\u0b30\u0b4d\u0b26\u0b4d\u0b27\u0b3f\u0b24 \u0b06\u0b30\u0b2c\u0b3f\u0b15\u0b4d\u200c-\u0b07\u0b23\u0b4d\u0b21\u0b3f\u0b15\u0b4d\u200c \u0b05\u0b19\u0b4d\u0b15\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "nus", "\u0b28\u0b41\u0b0f\u0b30" },
            { "dak", "\u0b21\u0b3e\u0b15\u0b4b\u0b1f\u0b3e" },
            { "type.nu.fullwide", "\u0b2a\u0b42\u0b30\u0b4d\u0b23\u0b4d\u0b23-\u0b2a\u0b4d\u0b30\u0b38\u0b4d\u0b25 \u0b05\u0b19\u0b4d\u0b15\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "hit", "\u0b39\u0b3f\u0b24\u0b40\u0b24\u0b47" },
            { "dar", "\u0b21\u0b3e\u0b30\u0b3e\u0b17\u0b4d\u0b71\u0b3e" },
            { "dav", "\u0b24\u0b3e\u0b07\u0b24\u0b3f" },
            { "Maya", "\u0b2e\u0b5f\u0b3e\u0b28\u0b4d \u0b39\u0b3e\u0b5f\u0b30\u0b32\u0b1c\u0b3f\u0b15\u0b38\u0b4d" },
            { "lrc", "\u0b09\u0b24\u0b4d\u0b24\u0b30 \u0b32\u0b41\u0b30\u0b3f" },
            { "Copt", "\u0b15\u0b2a\u0b1f\u0b3f\u0b15\u0b4d" },
            { "nwc", "\u0b2a\u0b3e\u0b30\u0b2e\u0b4d\u0b2a\u0b30\u0b3f\u0b15 \u0b28\u0b47\u0b71\u0b3e\u0b30\u0b40" },
            { "udm", "\u0b09\u0b26\u0b2e\u0b42\u0b30\u0b4d\u0b24\u0b4d\u0b24" },
            { "Khmr", "\u0b16\u0b2e\u0b47\u0b30\u0b4d" },
            { "Limb", "\u0b32\u0b3f\u0b2e\u0b4d\u0b2c\u0b41" },
            { "sad", "\u0b38\u0b23\u0b4d\u0b21\u0b3e\u0b71\u0b47" },
            { "type.nu.roman", "\u0b30\u0b4b\u0b2e\u0b3e\u0b28\u0b4d\u200c \u0b38\u0b02\u0b16\u0b4d\u0b5f\u0b3e\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "sah", "\u0b38\u0b3e\u0b16\u0b3e" },
            { "sam", "\u0b38\u0b3e\u0b2e\u0b4c\u0b30\u0b3f\u0b1f\u0b28\u0b4d \u0b06\u0b30\u0b2e\u0b3e\u0b07\u0b15\u0b4d" },
            { "saq", "\u0b38\u0b2e\u0b2c\u0b41\u0b30\u0b41" },
            { "sas", "\u0b38\u0b3e\u0b38\u0b3e\u0b15\u0b4d" },
            { "sat", "\u0b38\u0b3e\u0b28\u0b4d\u0b24\u0b3e\u0b33\u0b3f" },
            { "Tfng", "\u0b24\u0b3f\u0b2b\u0b3f\u0b19\u0b4d\u0b18\u0b3e" },
            { "jpr", "\u0b1c\u0b41\u0b21\u0b47\u0b13-\u0b2a\u0b30\u0b4d\u0b38\u0b3f\u0b06\u0b28\u0b4d" },
            { "sba", "\u0b28\u0b17\u0b3e\u0b2e\u0b2c\u0b47" },
            { "Guru", "\u0b17\u0b41\u0b30\u0b2e\u0b41\u0b16\u0b40" },
            { "lua", "\u0b32\u0b41\u0b2c\u0b3e-\u0b32\u0b41\u0b32\u0b41\u0b06" },
            { "sbp", "\u0b38\u0b3e\u0b28\u0b17\u0b41" },
            { "lui", "\u0b32\u0b41\u0b07\u0b38\u0b47\u0b28\u0b4b" },
            { "nyn", "\u0b28\u0b4d\u0b5f\u0b3e\u0b28\u0b15\u0b4b\u0b32\u0b4d" },
            { "nym", "\u0b28\u0b4d\u0b5f\u0b3e\u0b2e\u0b71\u0b47\u0b1c\u0b40" },
            { "lun", "\u0b32\u0b41\u0b23\u0b4d\u0b21\u0b3e" },
            { "nyo", "\u0b28\u0b4d\u0b5f\u0b3e\u0b30\u0b4b" },
            { "luo", "\u0b32\u0b41\u0b13" },
            { "fil", "\u0b2b\u0b3f\u0b32\u0b3f\u0b2a\u0b3f\u0b28\u0b4b" },
            { "hmn", "\u0b39\u0b01\u0b19\u0b4d\u0b17" },
            { "del", "\u0b21\u0b47\u0b32\u0b3e\u0b71\u0b47\u0b30\u0b4d" },
            { "lus", "\u0b2e\u0b3f\u0b1c\u0b4b" },
            { "bal", "\u0b2c\u0b3e\u0b32\u0b41\u0b1a\u0b3f" },
            { "den", "\u0b38\u0b4d\u0b32\u0b47\u0b2d\u0b4d" },
            { "ban", metaValue_ban },
            { "uga", "\u0b5f\u0b41\u0b17\u0b4b\u0b30\u0b1f\u0b3f\u0b15\u0b4d" },
            { "luy", "\u0b32\u0b41\u0b5f\u0b3f\u0b06" },
            { "bas", "\u0b2c\u0b3e\u0b38\u0b3e" },
            { "jrb", "\u0b1c\u0b41\u0b21\u0b47\u0b13-\u0b06\u0b30\u0b2c\u0b40\u0b15\u0b4d" },
            { "es_ES", "\u0b5f\u0b41\u0b30\u0b4b\u0b2a\u0b40\u0b5f \u0b38\u0b4d\u0b2a\u0b3e\u0b28\u0b3f\u0b38\u0b4d\u200c" },
            { "nzi", "\u0b1e\u0b4d\u0b1c\u0b3f\u0b2e\u0b3e" },
            { "sco", "\u0b38\u0b4d\u0b15\u0b1f\u0b38\u0b4d" },
            { "scn", "\u0b38\u0b3f\u0b36\u0b3f\u0b32\u0b3f\u0b06\u0b28\u0b4d" },
            { "aa", "\u0b05\u0b2b\u0b3e\u0b30\u0b4d" },
            { "ab", "\u0b06\u0b2c\u0b4d\u0b16\u0b3e\u0b1c\u0b3f\u0b06\u0b28\u0b4d" },
            { "ae", "\u0b05\u0b2c\u0b47\u0b38\u0b4d\u0b24\u0b28" },
            { "af", "\u0b06\u0b2b\u0b4d\u0b30\u0b3f\u0b15\u0b40\u0b5f" },
            { "ak", "\u0b05\u0b15\u0b28\u0b4d" },
            { "am", "\u0b06\u0b2e\u0b39\u0b3e\u0b30\u0b15\u0b3f" },
            { "Arab", metaValue_ar },
            { "an", "\u0b06\u0b30\u0b4d\u0b17\u0b4b\u0b28\u0b40" },
            { "Jpan", "\u0b1c\u0b3e\u0b2a\u0b3e\u0b28\u0b40\u0b1c\u0b4d" },
            { "ar", metaValue_ar },
            { "Hrkt", "\u0b1c\u0b3e\u0b2a\u0b3e\u0b28\u0b40 \u0b38\u0b3f\u0b32\u0b3e\u0b2c\u0b30\u0b3f\u0b1c\u0b4d\u200c" },
            { "as", "\u0b06\u0b38\u0b3e\u0b2e\u0b40\u0b5f" },
            { "Lina", "\u0b32\u0b3f\u0b28\u0b3f\u0b5f\u0b30\u0b4d" },
            { "av", "\u0b06\u0b2d\u0b3e\u0b30\u0b3f\u0b15\u0b4d" },
            { "Linb", "\u0b32\u0b3f\u0b28\u0b3f\u0b5f\u0b30\u0b4d \u0b2c\u0b3f" },
            { "ay", "\u0b06\u0b5f\u0b2e\u0b3e\u0b30\u0b3e" },
            { "az", "\u0b06\u0b1c\u0b47\u0b30\u0b2c\u0b3e\u0b07\u0b1c\u0b3e\u0b28\u0b3f" },
            { "ba", "\u0b2c\u0b3e\u0b36\u0b15\u0b3f\u0b30\u0b4d\u200c" },
            { "be", "\u0b2c\u0b47\u0b32\u0b3e\u0b30\u0b41\u0b37\u0b3f\u0b06\u0b28\u0b4d" },
            { "bg", "\u0b2c\u0b41\u0b32\u0b17\u0b47\u0b30\u0b3f\u0b06\u0b28\u0b4d" },
            { "bi", "\u0b2c\u0b3f\u0b38\u0b32\u0b3e\u0b2e\u0b3e" },
            { "bm", "\u0b2c\u0b3e\u0b2e\u0b4d\u0b2c\u0b3e\u0b30\u0b3e" },
            { "bn", metaValue_bn },
            { "bo", "\u0b24\u0b3f\u0b2c\u0b4d\u0b2c\u0b24\u0b40\u0b5f" },
            { "dgr", "\u0b21\u0b4b\u0b17\u0b4d\u0b30\u0b3f\u0b2c\u0b4d" },
            { "br", "\u0b2c\u0b4d\u0b30\u0b47\u0b1f\u0b28\u0b4d" },
            { "bs", "\u0b15\u0b3e\u0b1f\u0b32\u0b3e\u0b28\u0b4d" },
            { "Mymr", "\u0b2e\u0b4d\u0b5f\u0b3e\u0b28\u0b2e\u0b3e\u0b30\u0b4d" },
            { "type.nu.laoo", "\u0b32\u0b3e\u0b13 \u0b05\u0b19\u0b4d\u0b15\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "seh", "\u0b38\u0b47\u0b28\u0b3e" },
            { "Nkoo", "\u0b0f\u0b28\u0b4d \u0b15\u0b4b" },
            { "sel", "\u0b38\u0b47\u0b32\u0b4d\u0b15\u0b2a\u0b4d" },
            { "ca", "\u0b15\u0b3e\u0b1f\u0b3e\u0b32\u0b3e\u0b28\u0b4d" },
            { "ses", "\u0b15\u0b4b\u0b5f\u0b30\u0b3e \u0b38\u0b47\u0b28\u0b4d\u0b28\u0b3f" },
            { "ce", "\u0b1a\u0b47\u0b1a\u0b28\u0b4d" },
            { "ch", "\u0b1a\u0b3e\u0b2e\u0b4b\u0b30\u0b4b" },
            { "co", "\u0b15\u0b4b\u0b30\u0b4d\u0b38\u0b3f\u0b15\u0b3e\u0b28\u0b4d" },
            { "Orya", metaValue_or },
            { "cr", "\u0b15\u0b4d\u0b30\u0b40" },
            { "cs", "\u0b1a\u0b47\u0b15\u0b4d" },
            { "cu", "\u0b1a\u0b30\u0b4d\u0b1a\u0b4d\u0b1a \u0b38\u0b4d\u0b32\u0b3e\u0b2d\u0b3f\u0b15\u0b4d" },
            { "cv", "\u0b1a\u0b41\u0b2d\u0b3e\u0b36\u0b4d" },
            { "cy", "\u0b71\u0b47\u0b32\u0b4d\u0b38" },
            { "type.nu.ethi", "\u0b07\u0b25\u0b3f\u0b13\u0b2a\u0b3f\u0b15\u0b4d\u200c \u0b38\u0b02\u0b16\u0b4d\u0b5f\u0b3e\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "Yiii", "\u0b5f\u0b40" },
            { "da", "\u0b21\u0b3e\u0b28\u0b4d\u0b28\u0b3f\u0b38\u0b4d" },
            { "pt_PT", "\u0b5f\u0b41\u0b30\u0b4b\u0b2a\u0b40\u0b5f \u0b2a\u0b30\u0b4d\u0b24\u0b4d\u0b24\u0b41\u0b17\u0b40\u0b1c\u0b4d\u200c" },
            { "de", "\u0b1c\u0b30\u0b4d\u0b2e\u0b3e\u0b28" },
            { "type.cf.standard", "\u0b2e\u0b3e\u0b28\u0b3e\u0b19\u0b4d\u0b15 \u0b2e\u0b41\u0b26\u0b4d\u0b30\u0b3e \u0b2b\u0b30\u0b4d\u0b2e\u0b3e\u0b1f\u0b4d\u200c" },
            { "bej", "\u0b2c\u0b47\u0b1c\u0b3e" },
            { "din", "\u0b26\u0b3f\u0b19\u0b4d\u0b15\u0b3e" },
            { "Bugi", "\u0b2c\u0b41\u0b17\u0b3e\u0b28\u0b40\u0b1c\u0b4d" },
            { "bem", "\u0b2c\u0b47\u0b2e\u0b4d\u0b2c\u0b3e" },
            { "sga", "\u0b2a\u0b41\u0b30\u0b41\u0b23\u0b3e \u0b07\u0b30\u0b3f\u0b36\u0b4d" },
            { "dv", "\u0b21\u0b3f\u0b2d\u0b47\u0b39\u0b40" },
            { "es_419", "\u0b32\u0b3e\u0b1f\u0b3f\u0b28\u0b4d\u200c \u0b06\u0b2e\u0b47\u0b30\u0b3f\u0b15\u0b40\u0b5f \u0b38\u0b4d\u0b2a\u0b3e\u0b28\u0b3f\u0b38\u0b4d\u200c" },
            { "dz", "\u0b26\u0b21\u0b1c\u0b4b\u0b19\u0b4d\u0b17\u0b16\u0b3e" },
            { "bez", "\u0b2c\u0b47\u0b28\u0b3e" },
            { "type.ca.chinese", "\u0b1a\u0b3e\u0b07\u0b28\u0b3f\u0b1c\u0b4d\u200c \u0b15\u0b4d\u0b5f\u0b3e\u0b32\u0b47\u0b23\u0b4d\u0b21\u0b30\u0b4d\u200c" },
            { "dje", "\u0b1c\u0b30\u0b4d\u0b2e\u0b3e" },
            { "type.nu.grek", "\u0b17\u0b4d\u0b30\u0b40\u0b15\u0b4d\u200c \u0b38\u0b02\u0b16\u0b4d\u0b5f\u0b3e\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "ee", "\u0b07\u0b71\u0b47" },
            { "type.lb.normal", "\u0b38\u0b3e\u0b27\u0b3e\u0b30\u0b23 \u0b27\u0b3e\u0b21\u0b3c\u0b3f \u0b2c\u0b3f\u0b30\u0b24\u0b3f \u0b36\u0b48\u0b33\u0b40" },
            { "ro_MD", "\u0b2e\u0b4b\u0b32\u0b21\u0b4b\u0b2d\u0b3f\u0b06\u0b28\u0b4d" },
            { "el", metaValue_el },
            { "en", "\u0b07\u0b02\u0b30\u0b3e\u0b1c\u0b40" },
            { "eo", "\u0b0f\u0b38\u0b4d\u0b2a\u0b3e\u0b30\u0b47\u0b23\u0b4d\u0b1f\u0b4b" },
            { "es", "\u0b38\u0b4d\u0b2a\u0b47\u0b28\u0b3f\u0b5f" },
            { "et", "\u0b0f\u0b38\u0b4d\u0b24\u0b4b\u0b28\u0b3f\u0b06\u0b28\u0b4d" },
            { "Hanb", "\u0b2c\u0b4b\u0b2a\u0b4b\u0b2e\u0b4b\u0b2b\u0b4b \u0b38\u0b39\u0b3f\u0b24 \u0b39\u0b3e\u0b28\u0b4d\u200c" },
            { "eu", "\u0b2c\u0b3e\u0b38\u0b4d\u0b15\u0b4d\u0b71\u0b3f" },
            { "Buhd", "\u0b2c\u0b41\u0b39\u0b3f\u0b26\u0b4d" },
            { "Hang", "\u0b39\u0b3e\u0b19\u0b4d\u0b17\u0b41\u0b32\u0b4d" },
            { "Samr", "\u0b38\u0b2e\u0b4c\u0b30\u0b3f\u0b1f\u0b28\u0b4d" },
            { "shi", "\u0b24\u0b3e\u0b1a\u0b47\u0b32\u0b39\u0b3f\u0b1f\u0b4d" },
            { "hsb", "\u0b09\u0b2a\u0b30 \u0b38\u0b30\u0b4d\u0b2c\u0b3f\u0b06\u0b28\u0b4d" },
            { "Hani", "\u0b39\u0b3e\u0b28\u0b4d" },
            { "shn", "\u0b36\u0b3e\u0b28\u0b4d" },
            { "Hano", "\u0b39\u0b3e\u0b28\u0b41\u0b28\u0b4d" },
            { "fa", "\u0b2a\u0b30\u0b4d\u0b38\u0b3f\u0b06\u0b28\u0b4d" },
            { "Hans", "\u0b38\u0b30\u0b33\u0b40\u0b15\u0b43\u0b24" },
            { "type.nu.latn", "\u0b2a\u0b3e\u0b36\u0b4d\u0b1a\u0b3e\u0b24\u0b4d\u0b5f \u0b05\u0b19\u0b4d\u0b15\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "Hant", "\u0b2a\u0b3e\u0b30\u0b2e\u0b4d\u0b2a\u0b30\u0b3f\u0b15" },
            { "ff", "\u0b2b\u0b41\u0b32\u0b3e\u0b39" },
            { "fi", "\u0b2b\u0b3f\u0b28\u0b4d\u0b28\u0b3f\u0b38\u0b4d" },
            { "fj", metaValue_FJ },
            { "fon", "\u0b2b\u0b28\u0b4d" },
            { "yue", "\u0b15\u0b3e\u0b28\u0b1f\u0b4b\u0b28\u0b47\u0b38\u0b47" },
            { "fo", "\u0b2b\u0b3e\u0b30\u0b4b\u0b0f\u0b38\u0b47" },
            { "umb", "\u0b09\u0b2e\u0b4d\u0b2c\u0b41\u0b23\u0b4d\u0b21\u0b41" },
            { "fr", "\u0b2b\u0b30\u0b3e\u0b38\u0b40" },
            { "sid", "\u0b38\u0b3f\u0b26\u0b3e\u0b2e\u0b4b" },
            { "fy", "\u0b2a\u0b3e\u0b36\u0b4d\u0b1a\u0b3e\u0b24\u0b4d\u0b5f \u0b2b\u0b4d\u0b30\u0b3f\u0b38\u0b3f\u0b06\u0b28\u0b4d" },
            { "ga", "\u0b07\u0b30\u0b3f\u0b38\u0b4d" },
            { "gd", "\u0b38\u0b4d\u0b15\u0b1f\u0b3f\u0b38\u0b4d \u0b17\u0b3e\u0b0f\u0b32\u0b3f\u0b15\u0b4d" },
            { "gl", "\u0b17\u0b3e\u0b32\u0b38\u0b3f\u0b06\u0b28\u0b4d" },
            { "gn", "\u0b17\u0b41\u0b06\u0b30\u0b3e\u0b28\u0b40" },
            { "bho", "\u0b2d\u0b4b\u0b1c\u0b2a\u0b41\u0b30\u0b40" },
            { "und", "\u0b05\u0b1c\u0b23\u0b3e \u0b2d\u0b3e\u0b37\u0b3e" },
            { "gu", metaValue_gu },
            { "gv", "\u0b2e\u0b3e\u0b01\u0b15\u0b4d\u0b38" },
            { "ha", "\u0b39\u0b4c\u0b38\u0b3e" },
            { "he", "\u0b39\u0b47\u0b2c\u0b4d\u0b30\u0b4d\u0b5f\u0b41" },
            { "hi", "\u0b39\u0b3f\u0b28\u0b4d\u0b26\u0b40" },
            { "hup", "\u0b39\u0b41\u0b2a\u0b3e" },
            { "bik", "\u0b2c\u0b3f\u0b15\u0b4b\u0b32\u0b4d" },
            { "bin", "\u0b2c\u0b3f\u0b28\u0b3f" },
            { "ho", "\u0b39\u0b3f\u0b30\u0b3f \u0b2e\u0b4b\u0b1f\u0b41" },
            { "hr", "\u0b15\u0b4d\u0b30\u0b4b\u0b06\u0b1f\u0b3f\u0b06\u0b28\u0b4d" },
            { "ht", "\u0b39\u0b48\u0b24\u0b3e\u0b5f\u0b3f\u0b28\u0b4d" },
            { "hu", "\u0b39\u0b19\u0b4d\u0b17\u0b47\u0b30\u0b40\u0b5f" },
            { "hy", "\u0b06\u0b30\u0b4d\u0b2e\u0b47\u0b28\u0b3f\u0b06\u0b28\u0b4d" },
            { "hz", "\u0b39\u0b47\u0b30\u0b47\u0b30\u0b4b" },
            { "ia", "\u0b07\u0b30\u0b4d\u0b23\u0b4d\u0b1f\u0b32\u0b3f\u0b19\u0b4d\u0b17\u0b41\u0b06" },
            { "Jamo", "\u0b1c\u0b3e\u0b2e\u0b4b" },
            { "id", "\u0b07\u0b23\u0b4d\u0b21\u0b4b\u0b28\u0b47\u0b38\u0b40\u0b5f" },
            { "type.nu.tibt", "\u0b24\u0b3f\u0b2c\u0b24\u0b40 \u0b05\u0b19\u0b4d\u0b15\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "ie", "\u0b07\u0b30\u0b4d\u0b23\u0b4d\u0b1f\u0b30\u0b32\u0b3f\u0b19\u0b4d\u0b17\u0b41\u0b07" },
            { "ig", "\u0b07\u0b17\u0b2c\u0b4b" },
            { "ii", "\u0b38\u0b3f\u0b1a\u0b41\u0b06\u0b28\u0b4d \u0b5f\u0b40" },
            { "frm", "\u0b2e\u0b27\u0b4d\u0b5f \u0b2b\u0b4d\u0b30\u0b47\u0b1e\u0b4d\u0b1a" },
            { "ik", "\u0b07\u0b28\u0b41\u0b2a\u0b3f\u0b5f\u0b3e\u0b15\u0b4d" },
            { "fro", "\u0b2a\u0b41\u0b30\u0b41\u0b23\u0b3e \u0b2b\u0b4d\u0b30\u0b47\u0b1e\u0b4d\u0b1a" },
            { "io", "\u0b07\u0b21\u0b4b" },
            { "frs", "\u0b2a\u0b42\u0b30\u0b4d\u0b2c \u0b2b\u0b4d\u0b30\u0b3f\u0b38\u0b3f\u0b5f\u0b3e\u0b28\u0b4d" },
            { "frr", "\u0b09\u0b24\u0b4d\u0b24\u0b30 \u0b2b\u0b4d\u0b30\u0b3f\u0b38\u0b3f\u0b5f\u0b3e\u0b28\u0b4d" },
            { "is", "\u0b06\u0b07\u0b38\u0b32\u0b3e\u0b23\u0b4d\u0b21\u0b3f\u0b15\u0b4d" },
            { "it", "\u0b07\u0b1f\u0b3e\u0b32\u0b40\u0b5f" },
            { "iu", "\u0b07\u0b28\u0b41\u0b15\u0b1f\u0b41\u0b24\u0b4d\u200c" },
            { "ja", "\u0b1c\u0b3e\u0b2a\u0b3e\u0b28\u0b40" },
            { "Mlym", "\u0b2e\u0b32\u0b5f\u0b3e\u0b32\u0b2e\u0b4d" },
            { "Sara", "\u0b38\u0b3e\u0b30\u0b3e\u0b24\u0b3f" },
            { "doi", "\u0b21\u0b4b\u0b17\u0b4d\u0b30\u0b40" },
            { "sma", "\u0b26\u0b15\u0b4d\u0b37\u0b3f\u0b23 \u0b38\u0b3e\u0b2e\u0b3f" },
            { "jv", metaValue_jv },
            { "Shaw", "\u0b38\u0b3e\u0b2c\u0b3f\u0b5f\u0b3e\u0b28\u0b4d" },
            { "mad", "\u0b2e\u0b3e\u0b26\u0b41\u0b30\u0b40\u0b38\u0b4d" },
            { "smj", "\u0b32\u0b41\u0b32\u0b47 \u0b38\u0b3e\u0b2e\u0b3f" },
            { "mag", "\u0b2e\u0b3e\u0b17\u0b3e\u0b39\u0b40" },
            { "mai", "\u0b2e\u0b48\u0b25\u0b3f\u0b33\u0b40" },
            { "smn", "\u0b07\u0b28\u0b3e\u0b30\u0b40 \u0b38\u0b3e\u0b2e\u0b3f" },
            { "ka", metaValue_ka },
            { "bla", "\u0b38\u0b3f\u0b15\u0b38\u0b3f\u0b15\u0b3e" },
            { "mak", "\u0b2e\u0b15\u0b3e\u0b38\u0b30\u0b4d" },
            { "sms", "\u0b38\u0b4d\u0b15\u0b4b\u0b32\u0b4d\u0b1f \u0b38\u0b3e\u0b2e\u0b40" },
            { "man", "\u0b2e\u0b3e\u0b23\u0b4d\u0b21\u0b3f\u0b19\u0b4d\u0b17\u0b4b" },
            { "kg", "\u0b15\u0b19\u0b4d\u0b17\u0b4b" },
            { "Goth", metaValue_got },
            { "ki", "\u0b15\u0b40\u0b15\u0b41\u0b5f\u0b41" },
            { "mas", "\u0b2e\u0b3e\u0b38\u0b3e\u0b07" },
            { "kj", "\u0b15\u0b4d\u0b71\u0b3e\u0b28\u0b4d\u0b5f\u0b3e\u0b2e\u0b4d" },
            { "kk", "\u0b15\u0b3e\u0b1c\u0b3e\u0b15\u0b4d" },
            { "kl", "\u0b15\u0b3e\u0b32\u0b3e\u0b32\u0b3f\u0b38\u0b41\u0b1f\u0b4d" },
            { "km", "\u0b16\u0b3e\u0b2e\u0b47\u0b30\u0b4d" },
            { "kn", "\u0b15\u0b28\u0b4d\u0b28\u0b21" },
            { "ko", metaValue_ko },
            { "kr", "\u0b15\u0b28\u0b41\u0b30\u0b40" },
            { "ks", "\u0b15\u0b3e\u0b36\u0b4d\u0b2e\u0b3f\u0b30\u0b40" },
            { "Cirt", "\u0b38\u0b3f\u0b30\u0b4d\u0b25" },
            { "Lepc", "\u0b32\u0b47\u0b2a\u0b1a\u0b3e" },
            { "Avst", "\u0b06\u0b2c\u0b47\u0b38\u0b4d\u0b25\u0b3e\u0b28\u0b4d" },
            { "ku", "\u0b15\u0b41\u0b30\u0b4d\u0b26\u0b4d\u0b26\u0b3f\u0b36\u0b4d" },
            { "kv", "\u0b15\u0b4b\u0b2e\u0b3f" },
            { "kw", "\u0b15\u0b4b\u0b30\u0b4d\u0b28\u0b3f\u0b38\u0b4d" },
            { "ky", "\u0b15\u0b40\u0b30\u0b17\u0b40\u0b1c\u0b4d" },
            { "snk", "\u0b38\u0b4b\u0b28\u0b3f\u0b19\u0b4d\u0b15\u0b47" },
            { "la", metaValue_la },
            { "lb", "\u0b32\u0b15\u0b4d\u0b38\u0b47\u0b2e\u0b2c\u0b30\u0b4d\u0b17\u0b3f\u0b38\u0b4d" },
            { "type.nu.mlym", "\u0b2e\u0b32\u0b5f\u0b3e\u0b32\u0b2e\u0b4d \u0b05\u0b19\u0b4d\u0b15\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "lg", "\u0b17\u0b28\u0b4d\u0b26\u0b3e" },
            { "Roro", "\u0b30\u0b4b\u0b19\u0b4d\u0b17\u0b4b\u0b30\u0b4b\u0b19\u0b4d\u0b17\u0b4b" },
            { "li", "\u0b32\u0b3f\u0b2e\u0b4d\u0b2c\u0b41\u0b30\u0b4d\u0b17\u0b3f\u0b38\u0b4d" },
            { "Tibt", "\u0b24\u0b3f\u0b2c\u0b47\u0b24\u0b3e\u0b28\u0b4d" },
            { "ln", "\u0b32\u0b3f\u0b19\u0b4d\u0b17\u0b3e\u0b32\u0b3e" },
            { "fur", "\u0b2b\u0b4d\u0b30\u0b3f\u0b5f\u0b41\u0b32\u0b40\u0b5f\u0b3e\u0b28\u0b4d" },
            { "lo", metaValue_lo },
            { "type.ms.uksystem", "\u0b38\u0b3e\u0b2e\u0b4d\u0b30\u0b3e\u0b1c\u0b4d\u0b5f \u0b38\u0b2e\u0b4d\u0b2c\u0b28\u0b4d\u0b27\u0b40\u0b5f \u0b2e\u0b3e\u0b2a \u0b2a\u0b26\u0b4d\u0b27\u0b24\u0b3f" },
            { "lt", "\u0b32\u0b3f\u0b25\u0b41\u0b06\u0b28\u0b3f\u0b06\u0b28\u0b4d" },
            { "lu", "\u0b32\u0b4d\u0b5f\u0b41\u0b2c\u0b3e-\u0b15\u0b3e\u0b1f\u0b3e\u0b19\u0b4d\u0b17\u0b3e" },
            { "lv", "\u0b32\u0b3e\u0b1f\u0b2d\u0b3f\u0b06\u0b28\u0b4d" },
            { "sog", "\u0b38\u0b4b\u0b17\u0b21\u0b3f\u0b0f\u0b28\u0b4d" },
            { "mg", "\u0b2e\u0b3e\u0b32\u0b3e\u0b17\u0b3e\u0b38\u0b40" },
            { "mh", "\u0b2e\u0b3e\u0b30\u0b4d\u0b36\u0b3e\u0b32\u0b40\u0b1c\u0b4d" },
            { "type.co.ducet", "\u0b21\u0b3f\u0b2b\u0b32\u0b4d\u0b1f \u0b5f\u0b41\u0b28\u0b3f\u0b15\u0b4b\u0b21\u0b4d\u200c \u0b38\u0b30\u0b4d\u0b1f\u0b4d\u200c \u0b15\u0b4d\u0b30\u0b2e" },
            { "mi", "\u0b2e\u0b3e\u0b13\u0b30\u0b40" },
            { "mk", "\u0b2e\u0b3e\u0b38\u0b47\u0b21\u0b4b\u0b28\u0b3f\u0b06\u0b28\u0b4d" },
            { "ml", "\u0b2e\u0b3e\u0b32\u0b3e\u0b5f\u0b32\u0b2e\u0b4d" },
            { "mn", "\u0b2e\u0b19\u0b4d\u0b17\u0b4b\u0b33\u0b3f\u0b5f" },
            { "mr", "\u0b2e\u0b30\u0b3e\u0b20\u0b40" },
            { "ms", "\u0b2e\u0b3e\u0b32\u0b5f" },
            { "mt", "\u0b2e\u0b3e\u0b32\u0b1f\u0b40\u0b1c\u0b4d" },
            { "my", "\u0b2c\u0b30\u0b4d\u0b2e\u0b40\u0b1c\u0b4d" },
            { "Saur", "\u0b38\u0b4c\u0b30\u0b3e\u0b37\u0b4d\u0b1f\u0b4d\u0b30" },
            { "Armn", "\u0b06\u0b30\u0b4d\u0b2e\u0b47\u0b28\u0b40\u0b5f" },
            { "mdf", "\u0b2e\u0b4b\u0b15\u0b4d\u0b37" },
            { "dsb", "\u0b28\u0b3f\u0b2e\u0b4d\u0b28 \u0b38\u0b30\u0b4d\u0b2c\u0b3f\u0b06\u0b28\u0b4d\u200c" },
            { "Armi", "\u0b07\u0b2e\u0b4d\u0b2a\u0b47\u0b30\u0b3f\u0b06\u0b32\u0b4d \u0b06\u0b30\u0b2e\u0b3f\u0b15\u0b4d" },
            { "na", metaValue_NR },
            { "type.co.search", "\u0b38\u0b3e\u0b27\u0b3e\u0b30\u0b23 \u0b09\u0b26\u0b4d\u0b26\u0b47\u0b36\u0b4d\u0b5f-\u0b2c\u0b3f\u0b36\u0b3f\u0b37\u0b4d\u0b1f \u0b38\u0b28\u0b4d\u0b27\u0b3e\u0b28" },
            { "nb", "\u0b28\u0b30\u0b71\u0b47\u0b1c\u0b3f\u0b06\u0b28\u0b4d \u0b2c\u0b4b\u0b15\u0b2e\u0b32\u0b4d" },
            { "nd", "\u0b09\u0b24\u0b4d\u0b24\u0b30 \u0b28\u0b47\u0b21\u0b2c\u0b47\u0b32\u0b47" },
            { "ne", "\u0b28\u0b47\u0b2a\u0b3e\u0b33\u0b40" },
            { "ng", "\u0b21\u0b4b\u0b19\u0b4d\u0b17\u0b3e" },
            { "mdr", "\u0b2e\u0b28\u0b4d\u0b26\u0b3e\u0b30" },
            { "nl", "\u0b21\u0b1a\u0b4d" },
            { "nn", "\u0b28\u0b30\u0b71\u0b47\u0b1c\u0b3f\u0b06\u0b28\u0b4d \u0b28\u0b3f\u0b5f\u0b4b\u0b30\u0b4d\u0b38\u0b4d\u0b15" },
            { "no", "\u0b28\u0b30\u0b71\u0b47\u0b1c\u0b3f\u0b06\u0b28\u0b4d" },
            { "nr", "\u0b26\u0b15\u0b4d\u0b37\u0b3f\u0b23 \u0b28\u0b47\u0b21\u0b2c\u0b47\u0b32\u0b47" },
            { "nv", "\u0b28\u0b3e\u0b2d\u0b3e\u0b1c\u0b4b" },
            { "kaa", "\u0b15\u0b3e\u0b30\u0b3e-\u0b15\u0b32\u0b4d\u0b2a\u0b15\u0b4d" },
            { "ny", "\u0b28\u0b3f\u0b5f\u0b3e\u0b1e\u0b4d\u0b1c" },
            { "kac", "\u0b15\u0b1a\u0b3f\u0b28\u0b4d" },
            { "kab", "\u0b15\u0b2c\u0b3e\u0b07\u0b32\u0b4d" },
            { "oc", "\u0b13\u0b38\u0b3f\u0b1f\u0b3e\u0b28\u0b4d" },
            { "kaj", "\u0b1c\u0b1c\u0b41" },
            { "kam", "\u0b15\u0b2e\u0b4d\u0b2c\u0b3e" },
            { "men", "\u0b2e\u0b47\u0b28\u0b21\u0b47" },
            { "oj", "\u0b13\u0b1c\u0b3f\u0b71\u0b3e" },
            { "mer", "\u0b2e\u0b47\u0b30\u0b41" },
            { "type.nu.armn", "\u0b06\u0b30\u0b4d\u0b2e\u0b47\u0b28\u0b3f\u0b5f \u0b38\u0b02\u0b16\u0b4d\u0b5f\u0b3e\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "om", "\u0b13\u0b30\u0b4b\u0b2e\u0b4b" },
            { "kaw", "\u0b15\u0b3e\u0b71\u0b3f" },
            { "or", metaValue_or },
            { "os", "\u0b13\u0b38\u0b47\u0b1f\u0b3f\u0b15\u0b4d" },
            { "kbd", "\u0b15\u0b3e\u0b2c\u0b3e\u0b30\u0b4d\u0b21\u0b3f\u0b06\u0b28\u0b4d" },
            { "mfe", "\u0b2e\u0b4b\u0b30\u0b3f\u0b38\u0b5f\u0b47\u0b28\u0b4d" },
            { "srn", "\u0b36\u0b3e\u0b30\u0b3e\u0b28\u0b3e \u0b1f\u0b4b\u0b19\u0b4d\u0b17\u0b4b" },
            { "pa", "\u0b2a\u0b1e\u0b4d\u0b1c\u0b3e\u0b2c\u0b40" },
            { "dua", "\u0b21\u0b41\u0b06\u0b28\u0b3e" },
            { "srr", "\u0b36\u0b47\u0b30\u0b47\u0b30\u0b4d" },
            { "pi", "\u0b2a\u0b3e\u0b32\u0b3f" },
            { "pl", "\u0b2a\u0b4b\u0b32\u0b3f\u0b36\u0b4d" },
            { "dum", "\u0b2e\u0b27\u0b4d\u0b5f \u0b2a\u0b30\u0b4d\u0b24\u0b4d\u0b24\u0b41\u0b17\u0b3e\u0b32\u0b40" },
            { "type.ca.dangi", "\u0b26\u0b3e\u0b19\u0b4d\u0b17\u0b3f \u0b15\u0b4d\u0b5f\u0b3e\u0b32\u0b47\u0b23\u0b4d\u0b21\u0b30\u0b4d\u200c" },
            { "ps", "\u0b2a\u0b3e\u0b38\u0b4d\u0b24\u0b4b" },
            { "pt", "\u0b2a\u0b30\u0b4d\u0b24\u0b4d\u0b24\u0b41\u0b17\u0b40\u0b1c\u0b4d\u200c" },
            { "mga", "\u0b2e\u0b27\u0b4d\u0b5f \u0b07\u0b30\u0b3f\u0b36\u0b4d" },
            { "key.co", "\u0b38\u0b30\u0b4d\u0b1f\u0b4d\u200c \u0b15\u0b4d\u0b30\u0b2e" },
            { "pt_BR", "\u0b2c\u0b4d\u0b30\u0b3e\u0b1c\u0b3f\u0b32\u0b3f\u0b06\u0b28\u0b4d \u0b2a\u0b30\u0b4d\u0b24\u0b4d\u0b24\u0b41\u0b17\u0b40\u0b1c\u0b4d" },
            { "kcg", "\u0b24\u0b4d\u0b5f\u0b3e\u0b2a\u0b4d" },
            { "mgh", "\u0b2e\u0b16\u0b41\u0b71\u0b3e-\u0b2e\u0b47\u0b1f\u0b4d\u0b1f\u0b3e" },
            { "key.cf", "\u0b2e\u0b41\u0b26\u0b4d\u0b30\u0b3e \u0b2b\u0b30\u0b4d\u0b2e\u0b3e\u0b1f\u0b4d\u200c" },
            { "bra", "\u0b2c\u0b4d\u0b30\u0b3e\u0b1c\u0b4d" },
            { "key.ca", "\u0b15\u0b4d\u0b5f\u0b3e\u0b32\u0b47\u0b23\u0b4d\u0b21\u0b30\u0b4d" },
            { "Laoo", metaValue_lo },
            { "mgo", "\u0b2e\u0b47\u0b1f\u0b3e" },
            { "type.hc.h23", "24 \u0b18\u0b23\u0b4d\u0b1f\u0b3f\u0b06 \u0b2a\u0b26\u0b4d\u0b27\u0b24\u0b3f (0\u201323)" },
            { "type.hc.h24", "24 \u0b18\u0b23\u0b4d\u0b1f\u0b3f\u0b06 \u0b2a\u0b26\u0b4d\u0b27\u0b24\u0b3f (1\u201324)" },
            { "ssy", "\u0b38\u0b39\u0b4b" },
            { "type.nu.mymr", "\u0b2e\u0b3f\u0b06\u0b01\u0b2e\u0b3e\u0b30\u0b4d\u200c \u0b05\u0b19\u0b4d\u0b15\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "qu", "\u0b15\u0b4d\u0b71\u0b47\u0b1a\u0b41\u0b06" },
            { "zap", "\u0b1c\u0b3e\u0b2a\u0b4b\u0b1f\u0b47\u0b15\u0b4d" },
            { "brx", "\u0b2c\u0b4b\u0b21\u0b4b" },
            { "Lana", "\u0b32\u0b3e\u0b28\u0b3e" },
            { "kde", "\u0b2e\u0b3e\u0b15\u0b4b\u0b23\u0b4d\u0b21\u0b47" },
            { "Ethi", "\u0b07\u0b25\u0b4b\u0b2a\u0b3f\u0b15\u0b4d" },
            { "type.hc.h12", "12 \u0b18\u0b23\u0b4d\u0b1f\u0b3f\u0b06 \u0b2a\u0b26\u0b4d\u0b27\u0b24\u0b3f (1\u201312)" },
            { "type.hc.h11", "12 \u0b18\u0b23\u0b4d\u0b1f\u0b3f\u0b06 \u0b2a\u0b26\u0b4d\u0b27\u0b24\u0b3f (0\u201311)" },
            { "rm", "\u0b30\u0b4b\u0b2e\u0b3e\u0b28\u0b36\u0b4d\u200c" },
            { "rn", "\u0b30\u0b41\u0b23\u0b4d\u0b21\u0b3f" },
            { "key.cu", "\u0b2e\u0b41\u0b26\u0b4d\u0b30\u0b3e" },
            { "ro", "\u0b30\u0b4b\u0b2e\u0b3e\u0b28\u0b3f\u0b06\u0b28\u0b4d" },
            { "type.nu.orya", "\u0b13\u0b21\u0b3c\u0b3f\u0b06 \u0b05\u0b19\u0b4d\u0b15\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "type.nu.hanidec", "\u0b1a\u0b3f\u0b28\u0b3f \u0b26\u0b36\u0b2e\u0b3f\u0b15 \u0b38\u0b02\u0b16\u0b4d\u0b5f\u0b3e\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "ru", "\u0b30\u0b41\u0b37\u0b3f\u0b5f" },
            { "zbl", metaValue_zbl },
            { "rw", "\u0b15\u0b3f\u0b28\u0b4d\u0b5f\u0b3e\u0b30\u0b71\u0b3e\u0b23\u0b4d\u0b21\u0b3e" },
            { "kea", "\u0b15\u0b3e\u0b2c\u0b41\u0b2d\u0b47\u0b30\u0b21\u0b3f\u0b06\u0b28\u0b41" },
            { "mic", "\u0b2e\u0b3f\u0b15\u0b2e\u0b4c\u0b15\u0b4d" },
            { "suk", "\u0b38\u0b41\u0b15\u0b41\u0b2e\u0b3e" },
            { "en_AU", "\u0b05\u0b37\u0b4d\u0b1f\u0b4d\u0b30\u0b47\u0b32\u0b3f\u0b5f \u0b07\u0b02\u0b30\u0b3e\u0b1c\u0b40" },
            { "sa", "\u0b38\u0b02\u0b38\u0b4d\u0b15\u0b43\u0b24" },
            { "sc", "\u0b38\u0b30\u0b4d\u0b26\u0b3f\u0b28\u0b3f\u0b06\u0b28\u0b4d" },
            { "sus", "\u0b36\u0b41\u0b36\u0b41" },
            { "sd", "\u0b38\u0b3f\u0b28\u0b4d\u0b27\u0b40" },
            { "se", "\u0b09\u0b24\u0b4d\u0b24\u0b30 \u0b38\u0b3e\u0b2e\u0b3f" },
            { "min", "\u0b2e\u0b3f\u0b28\u0b3e\u0b19\u0b4d\u0b17\u0b3e\u0b2c\u0b3e\u0b09" },
            { "sg", "\u0b38\u0b3e\u0b19\u0b4d\u0b17\u0b4b" },
            { "sh", "\u0b38\u0b30\u0b4d\u0b2c\u0b4b-\u0b15\u0b4d\u0b30\u0b4b\u0b06\u0b1f\u0b3f\u0b06\u0b28\u0b4d" },
            { "si", "\u0b38\u0b3f\u0b02\u0b39\u0b33" },
            { "sux", "\u0b38\u0b41\u0b2e\u0b47\u0b30\u0b3f\u0b06\u0b28\u0b4d" },
            { "sk", "\u0b38\u0b4d\u0b32\u0b4b\u0b2d\u0b3e\u0b15\u0b4d" },
            { "sl", "\u0b38\u0b4d\u0b32\u0b4b\u0b2d\u0b47\u0b28\u0b3f\u0b06\u0b28\u0b4d" },
            { "sm", "\u0b38\u0b3e\u0b2e\u0b4b\u0b06\u0b28\u0b4d" },
            { "sn", "\u0b36\u0b4b\u0b28\u0b3e" },
            { "so", metaValue_SO },
            { "type.nu.arab", "\u0b06\u0b30\u0b2c\u0b3f\u0b15\u0b4d\u200c-\u0b07\u0b23\u0b4d\u0b21\u0b3f\u0b15\u0b4d\u200c \u0b05\u0b19\u0b4d\u0b15\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "sq", "\u0b06\u0b32\u0b2c\u0b3e\u0b28\u0b3f\u0b06\u0b28\u0b4d" },
            { "sr", "\u0b38\u0b30\u0b4d\u0b2c\u0b3f\u0b5f" },
            { "ss", "\u0b38\u0b4d\u0b35\u0b3e\u0b24\u0b3f" },
            { "type.cf.account", "\u0b0f\u0b15\u0b3e\u0b09\u0b23\u0b4d\u0b1f\u0b3f\u0b02 \u0b2e\u0b41\u0b26\u0b4d\u0b30\u0b3e \u0b2b\u0b30\u0b4d\u0b2e\u0b3e\u0b1f\u0b4d\u200c" },
            { "Java", metaValue_jv },
            { "st", "\u0b38\u0b47\u0b38\u0b4b\u0b25\u0b4b" },
            { "su", metaValue_su },
            { "sv", "\u0b38\u0b4d\u0b71\u0b47\u0b21\u0b3f\u0b38\u0b4d" },
            { "sw", "\u0b38\u0b4d\u0b71\u0b3e\u0b39\u0b3f\u0b32\u0b4d" },
            { "type.nu.hantfin", "\u0b2a\u0b3e\u0b30\u0b2e\u0b4d\u0b2a\u0b30\u0b3f\u0b15 \u0b1a\u0b3f\u0b28\u0b3f \u0b06\u0b30\u0b4d\u0b25\u0b3f\u0b15 \u0b38\u0b02\u0b16\u0b4d\u0b5f\u0b3e\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "ibb", "\u0b07\u0b2c\u0b3f\u0b2c\u0b3f\u0b13" },
            { "iba", "\u0b07\u0b2c\u0b3e\u0b28\u0b4d" },
            { "ta", metaValue_ta },
            { "142", "\u0b0f\u0b38\u0b3f\u0b06" },
            { "bua", "\u0b2c\u0b41\u0b30\u0b3f\u0b06\u0b1f\u0b4d" },
            { "143", "\u0b2e\u0b27\u0b4d\u0b5f \u0b0f\u0b38\u0b3f\u0b06" },
            { "te", metaValue_te },
            { "145", "\u0b2a\u0b36\u0b4d\u0b1a\u0b3f\u0b2e \u0b0f\u0b38\u0b3f\u0b06" },
            { "tg", "\u0b24\u0b3e\u0b1c\u0b3f\u0b15\u0b4d" },
            { "th", metaValue_th },
            { "ti", "\u0b1f\u0b4d\u0b30\u0b3f\u0b17\u0b3f\u0b28\u0b3f\u0b06" },
            { "bug", "\u0b2c\u0b41\u0b17\u0b40\u0b28\u0b40\u0b1c\u0b4d" },
            { "kfo", "\u0b15\u0b4b\u0b30\u0b4b" },
            { "en_CA", "\u0b15\u0b3e\u0b28\u0b3e\u0b21\u0b3f\u0b5f \u0b07\u0b02\u0b30\u0b3e\u0b1c\u0b40" },
            { "tk", "\u0b24\u0b41\u0b30\u0b4d\u0b15\u0b2e\u0b47\u0b28\u0b4d" },
            { "tl", "\u0b1f\u0b3e\u0b17\u0b3e\u0b32\u0b17\u0b4d" },
            { "tn", "\u0b38\u0b71\u0b3e\u0b28\u0b3e" },
            { "to", metaValue_TO },
            { "dyo", "\u0b1c\u0b4b\u0b32\u0b3e-\u0b2b\u0b4b\u0b28\u0b5f\u0b3f" },
            { "type.nu.jpan", "\u0b1c\u0b3e\u0b2a\u0b3e\u0b28\u0b40 \u0b38\u0b02\u0b16\u0b4d\u0b5f\u0b3e\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "tr", "\u0b24\u0b41\u0b30\u0b4d\u0b15\u0b3f\u0b38\u0b4d" },
            { "ts", "\u0b38\u0b4b\u0b19\u0b4d\u0b17\u0b3e" },
            { "swb", "\u0b15\u0b4b\u0b2e\u0b4b\u0b30\u0b3f\u0b5f" },
            { "Cakm", "\u0b1a\u0b15\u0b2e\u0b3e" },
            { "tt", "\u0b24\u0b3e\u0b24\u0b3e\u0b30\u0b4d" },
            { "dyu", "\u0b21\u0b41\u0b06\u0b32\u0b3e" },
            { "tw", "\u0b24\u0b4d\u0b71\u0b3f" },
            { "ty", "\u0b24\u0b3e\u0b39\u0b3f\u0b24\u0b3f\u0b06\u0b28\u0b4d" },
            { "150", "\u0b5f\u0b41\u0b30\u0b4b\u0b2a\u0b4d" },
            { "151", "\u0b2a\u0b42\u0b30\u0b4d\u0b2c \u0b5f\u0b41\u0b30\u0b4b\u0b2a\u0b4d" },
            { "154", "\u0b09\u0b24\u0b4d\u0b24\u0b30 \u0b5f\u0b41\u0b30\u0b4b\u0b2a\u0b4d" },
            { "dzg", "\u0b21\u0b3e\u0b1c\u0b3e\u0b17\u0b3e" },
            { "155", "\u0b2a\u0b36\u0b4d\u0b1a\u0b3f\u0b2e \u0b5f\u0b41\u0b30\u0b4b\u0b2a\u0b4d" },
            { "ug", "\u0b5f\u0b41\u0b18\u0b41\u0b30\u0b4d" },
            { "Kore", metaValue_ko },
            { "Ital", "\u0b2a\u0b41\u0b30\u0b41\u0b23\u0b3e \u0b07\u0b1f\u0b3e\u0b32\u0b40" },
            { "Zyyy", "\u0b38\u0b3e\u0b27\u0b3e\u0b30\u0b23" },
            { "uk", "\u0b5f\u0b41\u0b15\u0b4d\u0b30\u0b3e\u0b28\u0b3f\u0b06\u0b28\u0b4d" },
            { "ur", "\u0b09\u0b30\u0b4d\u0b26\u0b4d\u0b26\u0b41" },
            { "xal", "\u0b15\u0b3e\u0b32\u0b4d\u0b2e\u0b40\u0b15\u0b4d" },
            { "zen", "\u0b1c\u0b47\u0b28\u0b3e\u0b17\u0b3e" },
            { "uz", "\u0b09\u0b1c\u0b2c\u0b47\u0b15\u0b4d" },
            { "kha", "\u0b16\u0b3e\u0b38\u0b40" },
            { "Sylo", "\u0b38\u0b40\u0b32\u0b3f\u0b24\u0b4b \u0b28\u0b17\u0b30\u0b40" },
            { "ve", "\u0b2d\u0b47\u0b23\u0b4d\u0b21\u0b3e" },
            { "type.ca.roc", "\u0b2e\u0b3f\u0b19\u0b4d\u0b17\u0b4b\u0b13 \u0b15\u0b4d\u0b5f\u0b3e\u0b32\u0b47\u0b23\u0b4d\u0b21\u0b30\u0b4d\u200c" },
            { "vi", "\u0b2d\u0b3f\u0b0f\u0b24\u0b28\u0b3e\u0b2e\u0b3f\u0b1c\u0b4d" },
            { "kho", "\u0b16\u0b4b\u0b24\u0b3e\u0b28\u0b40\u0b1c\u0b4d" },
            { "khq", "\u0b15\u0b4b\u0b5f\u0b30\u0b3e \u0b1a\u0b3f\u0b28\u0b3f" },
            { "key.hc", "\u0b18\u0b23\u0b4d\u0b1f\u0b3e \u0b1a\u0b15\u0b4d\u0b30 (12 \u0b2c\u0b28\u0b3e\u0b2e 24)" },
            { "vo", "\u0b2c\u0b4b\u0b32\u0b3e\u0b2a\u0b41\u0b15" },
            { "syc", "\u0b15\u0b4d\u0b32\u0b3e\u0b38\u0b3f\u0b15\u0b3e\u0b32\u0b4d \u0b38\u0b3f\u0b30\u0b3f\u0b15\u0b4d" },
            { "Osma", "\u0b13\u0b38\u0b4b\u0b2e\u0b3e\u0b28\u0b3f\u0b5f\u0b3e" },
            { "quc", "\u0b15\u0b3f\u0b1a\u0b47" },
            { "gaa", "\u0b17\u0b3e" },
            { "wa", "\u0b71\u0b3e\u0b32\u0b41\u0b28\u0b4d" },
            { "syr", "\u0b38\u0b3f\u0b30\u0b3f\u0b15\u0b4d" },
            { "Grek", metaValue_el },
            { "Lydi", "\u0b32\u0b3f\u0b21\u0b3f\u0b5f\u0b28\u0b4d" },
            { "Xsux", "\u0b38\u0b41\u0b2e\u0b47\u0b30\u0b4b-\u0b06\u0b15\u0b4d\u0b15\u0b3e\u0b21\u0b3f\u0b06\u0b28\u0b4d \u0b38\u0b41\u0b28\u0b3f\u0b2b\u0b30\u0b4d\u0b2e" },
            { "wo", "\u0b71\u0b4b\u0b32\u0b2b\u0b4d" },
            { "zgh", "\u0b2e\u0b3e\u0b28\u0b3e\u0b19\u0b4d\u0b15 \u0b2e\u0b30\u0b4b\u0b15\u0b3f\u0b5f \u0b24\u0b3e\u0b2e\u0b3e\u0b1c\u0b3f\u0b18\u0b3e\u0b1f\u0b4d" },
            { "ar_001", "\u0b06\u0b27\u0b41\u0b28\u0b3f\u0b15 \u0b2e\u0b3e\u0b28\u0b3e\u0b19\u0b4d\u0b15 \u0b06\u0b30\u0b2c\u0b40\u0b5f" },
            { "Cans", "\u0b5f\u0b41\u0b28\u0b3f\u0b2b\u0b3e\u0b0f\u0b21\u0b4d \u0b15\u0b3e\u0b28\u0b3e\u0b21\u0b3f\u0b06\u0b28\u0b4d \u0b06\u0b2c\u0b4d\u0b30\u0b4b\u0b1c\u0b3f\u0b28\u0b3e\u0b32\u0b4d \u0b38\u0b3f\u0b32\u0b3e\u0b2c\u0b3f\u0b15\u0b38\u0b4d" },
            { "gay", "\u0b17\u0b3e\u0b5f\u0b4b" },
            { "Mong", "\u0b2e\u0b19\u0b4d\u0b17\u0b4b\u0b32\u0b3f\u0b06\u0b28\u0b4d" },
            { "mnc", "\u0b2e\u0b3e\u0b1e\u0b4d\u0b1a\u0b41" },
            { "Latf", "\u0b2b\u0b4d\u0b30\u0b3e\u0b15\u0b25\u0b41\u0b30\u0b4d \u0b32\u0b3e\u0b1f\u0b3f\u0b28\u0b4d" },
            { "gba", "\u0b17\u0b2c\u0b3e\u0b5f\u0b3e" },
            { "mni", "\u0b2e\u0b23\u0b3f\u0b2a\u0b41\u0b30\u0b40" },
            { "Latn", metaValue_la },
            { "Latg", "\u0b17\u0b3e\u0b0f\u0b32\u0b3f\u0b15\u0b4d \u0b32\u0b3e\u0b1f\u0b3f\u0b28\u0b4d" },
            { "type.nu.hans", "\u0b38\u0b30\u0b33\u0b40\u0b15\u0b43\u0b24 \u0b1a\u0b3f\u0b28\u0b3f \u0b38\u0b02\u0b16\u0b4d\u0b5f\u0b3e\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "type.nu.hant", "\u0b2a\u0b3e\u0b30\u0b2e\u0b4d\u0b2a\u0b30\u0b3f\u0b15 \u0b1a\u0b3f\u0b28\u0b3f \u0b38\u0b02\u0b16\u0b4d\u0b5f\u0b3e\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "xh", "\u0b16\u0b4b\u0b38\u0b3e" },
            { "type.nu.romanlow", "\u0b30\u0b4b\u0b2e\u0b3e\u0b28\u0b4d\u200c \u0b1b\u0b4b\u0b1f \u0b05\u0b15\u0b4d\u0b37\u0b30 \u0b38\u0b02\u0b16\u0b4d\u0b5f\u0b3e\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "byn", "\u0b2c\u0b4d\u0b32\u0b3f\u0b28\u0b4d" },
            { "Lyci", "\u0b32\u0b3f\u0b36\u0b3f\u0b5f\u0b28\u0b4d" },
            { "osa", "\u0b71\u0b4c\u0b38\u0b47\u0b1c\u0b4d" },
            { "Moon", "\u0b1a\u0b28\u0b4d\u0b26\u0b4d\u0b30" },
            { "moh", "\u0b2e\u0b4b\u0b39\u0b4c\u0b15" },
            { "kkj", "\u0b15\u0b3e\u0b15\u0b4b" },
            { "yi", "\u0b5f\u0b3f\u0b21\u0b3f\u0b38\u0b4d" },
            { "mos", "\u0b2e\u0b4b\u0b38\u0b3f" },
            { "Syrc", "\u0b38\u0b3f\u0b30\u0b3f\u0b5f\u0b3e\u0b15\u0b4d" },
            { "Dsrt", "\u0b21\u0b47\u0b38\u0b30\u0b4d\u0b1f" },
            { "yo", "\u0b5f\u0b4b\u0b30\u0b41\u0b2c\u0b3e" },
            { "es_MX", "\u0b2e\u0b47\u0b15\u0b4d\u0b38\u0b3f\u0b15\u0b3e\u0b28 \u0b38\u0b4d\u0b2a\u0b3e\u0b28\u0b3f\u0b38\u0b4d\u200c" },
            { "Syrj", "\u0b71\u0b47\u0b37\u0b4d\u0b1f\u0b30\u0b4d\u0b28 \u0b38\u0b3f\u0b30\u0b3f\u0b15\u0b4d" },
            { "ota", "\u0b13\u0b1f\u0b4d\u0b1f\u0b4b\u0b2e\u0b28\u0b4d \u0b24\u0b41\u0b30\u0b4d\u0b15\u0b3f\u0b38\u0b4d" },
            { "Syre", "\u0b0f\u0b37\u0b4d\u0b1f\u0b4d\u0b30\u0b3e\u0b19\u0b4d\u0b17\u0b47\u0b32\u0b4b \u0b38\u0b3f\u0b30\u0b3f\u0b15\u0b4d" },
            { "vai", "\u0b2d\u0b3e\u0b07" },
            { "za", "\u0b1c\u0b41\u0b06\u0b19\u0b4d\u0b17" },
            { "Cari", "\u0b15\u0b48\u0b30\u0b28\u0b4d" },
            { "kln", "\u0b15\u0b3e\u0b32\u0b47\u0b28\u0b1c\u0b3f\u0b28\u0b4d" },
            { "zh", "\u0b1a\u0b3e\u0b07\u0b28\u0b3f\u0b1c\u0b4d\u200c" },
            { "Bopo", "\u0b2c\u0b4b\u0b2a\u0b4b\u0b2e\u0b4b\u0b2b\u0b4b" },
            { "Perm", "\u0b13\u0b32\u0b4d\u0b21 \u0b2a\u0b30\u0b2e\u0b3f\u0b15\u0b4d" },
            { "key.lb", "\u0b27\u0b3e\u0b21\u0b3c\u0b3f \u0b2c\u0b3f\u0b30\u0b24\u0b3f \u0b36\u0b48\u0b33\u0b40" },
            { "zu", "\u0b1c\u0b41\u0b32\u0b41" },
            { "Geor", metaValue_ka },
            { "kmb", "\u0b15\u0b3f\u0b2e\u0b4d\u0b2c\u0b41\u0b23\u0b4d\u0b21\u0b41" },
            { "type.nu.jpanfin", "\u0b1c\u0b3e\u0b2a\u0b3e\u0b28\u0b40 \u0b06\u0b30\u0b4d\u0b25\u0b3f\u0b15 \u0b38\u0b02\u0b16\u0b4d\u0b5f\u0b3e\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "Cham", "\u0b1b\u0b2e\u0b4d" },
            { "gez", "\u0b17\u0b40\u0b1c\u0b4d" },
            { "Syrn", "\u0b07\u0b37\u0b4d\u0b1f\u0b30\u0b4d\u0b28 \u0b38\u0b3f\u0b30\u0b3f\u0b15\u0b4d" },
            { "Tglg", "\u0b1f\u0b3e\u0b17\u0b3e\u0b32\u0b4b\u0b17\u0b4d" },
            { "Egyd", "\u0b07\u0b1c\u0b3f\u0b2a\u0b4d\u0b1f\u0b3f\u0b06\u0b28\u0b4d \u0b21\u0b47\u0b2e\u0b4b\u0b1f\u0b3f\u0b15\u0b4d" },
            { "Egyh", "\u0b07\u0b1c\u0b3f\u0b2a\u0b4d\u0b1f\u0b3f\u0b06\u0b28\u0b4d \u0b39\u0b3e\u0b07\u0b05\u0b30\u0b1f\u0b3f\u0b15\u0b4d" },
            { "ebu", "\u0b0f\u0b2e\u0b4d\u0b35\u0b41" },
            { "Egyp", "\u0b07\u0b1c\u0b3f\u0b2a\u0b4d\u0b1f\u0b3f\u0b06\u0b28\u0b4d \u0b39\u0b3e\u0b05\u0b30\u0b17\u0b4d\u0b32\u0b3f\u0b2a\u0b38\u0b4d" },
            { "Geok", "\u0b1c\u0b30\u0b4d\u0b1c\u0b3f\u0b06\u0b28\u0b4d \u0b16\u0b41\u0b1f\u0b38\u0b41\u0b30\u0b40" },
            { "zh_Hans", "\u0b38\u0b30\u0b33\u0b40\u0b15\u0b43\u0b24 \u0b1a\u0b3e\u0b07\u0b28\u0b3f\u0b1c\u0b4d\u200c" },
            { "Hung", "\u0b2a\u0b41\u0b30\u0b41\u0b23\u0b3e \u0b39\u0b19\u0b4d\u0b17\u0b47\u0b30\u0b3f\u0b06\u0b28\u0b4d" },
            { "kok", "\u0b15\u0b4b\u0b19\u0b4d\u0b15\u0b23\u0b3f" },
            { "kos", "\u0b15\u0b4b\u0b38\u0b30\u0b48\u0b28\u0b4d" },
            { "zh_Hant", "\u0b2a\u0b3e\u0b30\u0b2e\u0b4d\u0b2a\u0b30\u0b3f\u0b15 \u0b1a\u0b3e\u0b07\u0b28\u0b3f\u0b1c\u0b4d\u200c" },
            { "Sund", metaValue_su },
            { "kpe", "\u0b15\u0b48\u0b2a\u0b47\u0b32\u0b47" },
            { "type.nu.khmr", "\u0b16\u0b3f\u0b2e\u0b30\u0b4d\u200c \u0b05\u0b19\u0b4d\u0b15\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "ilo", "\u0b07\u0b32\u0b4b\u0b15\u0b4b" },
            { "Cprt", "\u0b38\u0b3f\u0b2a\u0b4d\u0b30\u0b05\u0b1f\u0b4d" },
            { "mua", "\u0b2e\u0b41\u0b28\u0b21\u0b3e\u0b02" },
            { "type.nu.guru", "\u0b17\u0b41\u0b30\u0b2e\u0b41\u0b16\u0b40 \u0b05\u0b19\u0b4d\u0b15\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "mul", "\u0b2c\u0b3f\u0b2c\u0b3f\u0b27 \u0b2d\u0b3e\u0b37\u0b3e\u0b2e\u0b3e\u0b28" },
            { "cad", "\u0b15\u0b3e\u0b21\u0b4b" },
            { "key.ms", "\u0b2e\u0b3e\u0b2a \u0b2a\u0b26\u0b4d\u0b27\u0b24\u0b3f" },
            { "mus", "\u0b15\u0b4d\u0b30\u0b40\u0b15\u0b4d" },
            { "Glag", "\u0b17\u0b4d\u0b32\u0b3e\u0b17\u0b4d\u0b32\u0b4b\u0b1f\u0b3f\u0b15\u0b4d" },
            { "gil", "\u0b1c\u0b3f\u0b2c\u0b4d\u0b30\u0b3e\u0b1f\u0b40\u0b1c\u0b4d" },
            { "Cher", "\u0b1a\u0b3f\u0b30\u0b41\u0b15\u0b40" },
            { "car", "\u0b15\u0b3e\u0b30\u0b3f\u0b2c\u0b4d" },
            { "type.nu.tamldec", "\u0b24\u0b3e\u0b2e\u0b3f\u0b32\u0b4d \u0b05\u0b19\u0b4d\u0b15\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "krc", "\u0b15\u0b30\u0b3e\u0b1a\u0b5f-\u0b2c\u0b32\u0b4d\u0b15\u0b3e\u0b30" },
            { "inh", "\u0b07\u0b01\u0b19\u0b4d\u0b17\u0b41\u0b36\u0b4d" },
            { "krl", "\u0b15\u0b3e\u0b30\u0b47\u0b32\u0b3f\u0b5f\u0b3e\u0b28\u0b4d" },
            { "efi", "\u0b0f\u0b2b\u0b3f\u0b15\u0b4d" },
            { "key.nu", "\u0b38\u0b02\u0b16\u0b4d\u0b5f\u0b3e\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "kru", "\u0b15\u0b41\u0b30\u0b41\u0b16" },
            { "ksb", "\u0b36\u0b3e\u0b2e\u0b2c\u0b3e\u0b32\u0b3e" },
            { "Telu", metaValue_te },
            { "ksf", "\u0b2c\u0b3e\u0b2b\u0b32\u0b3e" },
        };
        return data;
    }
}
