/*
 * Copyright (c) 2012, 2022, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ps extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_NR = "\u0646\u0627\u06cc\u0631\u0648";
        final String metaValue_TR = "\u062a\u0631\u06a9\u064a";
        final String metaValue_ar = "\u0639\u0631\u0628\u064a";
        final String metaValue_bo = "\u062a\u0628\u062a\u064a";
        final String metaValue_el = "\u06cc\u0648\u0646\u0627\u0646\u064a";
        final String metaValue_gu = "\u06ab\u062c\u0631\u0627\u062a\u064a";
        final String metaValue_ja = "\u062c\u0627\u067e\u0627\u0646\u064a";
        final String metaValue_km = "\u062e\u0645\u0631";
        final String metaValue_ko = "\u06a9\u0648\u0631\u06cc\u0627\u06cc\u06cc";
        final String metaValue_ta = "\u062a\u0627\u0645\u06cc\u0644";
        final Object[][] data = new Object[][] {
            { "sbp", "\u0633\u0627\u0646\u06ab\u0648\u0648" },
            { "ksh", "\u06a9\u0648\u0644\u0648\u06af\u0646\u064a\u0633\u064a" },
            { "nyn", "\u0646\u06cc\u0646\u06a9\u0648\u0644" },
            { "mwl", "\u0645\u0631\u0627\u0646\u062f\u064a\u0632" },
            { "lun", "\u0644\u0646\u062f\u0627" },
            { "luo", "\u0644\u0648" },
            { "Zsym", "\u0633\u0645\u0628\u0648\u0644\u0648\u0646\u0647" },
            { "fil", "\u0641\u0644\u06cc\u067e\u06cc\u0646\u064a" },
            { "hmn", "\u0647\u0645\u0648\u0646\u06ab" },
            { "lus", "\u0645\u064a\u0632\u0648" },
            { "bal", "\u0628\u0644\u0648\u0685\u064a" },
            { "ban", "\u0628\u0627\u0644\u0646\u06cc" },
            { "Zsye", "\u0627\u06cc\u0645\u0648\u062c\u064a" },
            { "ccp", "\u0686\u06a9\u0645\u0627" },
            { "luy", "\u0644\u0648\u06cc\u0627" },
            { "bas", "\u0628\u0627\u0633\u0627" },
            { "es_ES", "\u0627\u0631\u0648\u067e\u0627\u064a\u064a \u0647\u0633\u067e\u0627\u0646\u0648\u064a" },
            { "tem", "\u062a\u06cc\u0645\u0646\u064a" },
            { "sco", "\u0633\u06a9\u0627\u067c\u0633" },
            { "scn", "\u0633\u06cc\u0644\u06cc\u0633\u064a" },
            { "teo", "\u062a\u06cc\u0633\u0648" },
            { "aa", "\u0627\u0641\u0631\u064a" },
            { "rap", "\u0631\u067e\u0627\u0646\u0648\u0626\u064a" },
            { "ab", "\u0627\u0628\u062e\u0627\u0632\u064a" },
            { "AC", "\u0627\u0633\u064a\u0646\u0634\u0627\u0646 \u067c\u0627\u067e\u0648" },
            { "rar", "\u0631\u0627\u0631\u0648\u067c\u0627\u0646\u06ab\u0627\u0646" },
            { "tet", "\u062a\u062a\u0648\u0645" },
            { "AD", "\u0627\u0646\u062f\u0648\u0631\u0627" },
            { "AE", "\u0645\u062a\u062d\u062f\u0647 \u0639\u0631\u0628 \u0627\u0645\u0627\u0631\u0627\u062a" },
            { "nl_BE", "\u0641\u0644\u06d0\u0645\u06d0\u0634\u064a" },
            { "AF", "\u0627\u0641\u063a\u0627\u0646\u0633\u062a\u0627\u0646" },
            { "af", "\u0627\u0641\u0631\u06cc\u06a9\u0627\u0646\u0633\u064a" },
            { "AG", "\u0627\u0646\u067c\u064a\u06ab\u0648\u0627 \u0627\u0648 \u0628\u0627\u0631\u0628\u0648\u062f\u0627" },
            { "type.ca.ethiopic", "\u0627\u06cc\u062a\u0648\u067e\u064a\u06a9 \u062c\u0646\u062a\u0631\u064a" },
            { "AI", "\u0627\u0646\u06ab\u06cc\u0644\u0627" },
            { "ak", "\u0627\u06a9\u0627\u0646\u064a" },
            { "AL", "\u0627\u0644\u0628\u0627\u0646\u06cc\u0647" },
            { "AM", "\u0627\u0631\u0645\u0646\u0633\u062a\u0627\u0646" },
            { "am", "\u0627\u0645\u0647\u0627\u0631\u064a" },
            { "Arab", metaValue_ar },
            { "an", "\u0627\u0631\u0627\u06af\u0648\u0646\u06d0\u0633\u064a" },
            { "AO", "\u0627\u0646\u06ab\u0648\u0644\u0627" },
            { "Jpan", metaValue_ja },
            { "AQ", "\u0627\u0646\u062a\u0627\u0631\u06a9\u062a\u06cc\u06a9\u0627" },
            { "ar", metaValue_ar },
            { "AR", "\u0627\u0631\u062c\u0646\u067c\u0627\u064a\u0646" },
            { "Hrkt", "\u062f \u062c\u0627\u067e\u0627\u0646\u064a \u0633\u06cc\u0644\u0627\u0628\u0631\u064a" },
            { "AS", "\u0627\u0645\u0631\u06cc\u06a9\u0627\u06cc\u06cc \u0633\u0645\u0648" },
            { "as", "\u0627\u0633\u0627\u0645\u064a" },
            { "AT", "\u0627\u062a\u0631\u06cc\u0634" },
            { "AU", "\u0622\u0633\u067c\u0631\u0627\u0644\u06cc\u0627" },
            { "av", "\u0627\u0648\u0627\u0631\u064a" },
            { "AW", "\u0622\u0631\u0648\u0628\u0627" },
            { "en_US", "\u0627\u0646\u06ab\u0644\u064a\u0633\u064a (US)" },
            { "AX", "\u0627\u0644\u0627\u0646\u062f \u067c\u0627\u067e\u0648\u0627\u0646" },
            { "ay", "\u0627\u06cc\u0645\u0627\u0631\u064a" },
            { "AZ", "\u0627\u0630\u0631\u0628\u0627\u064a\u062c\u0627\u0646" },
            { "az", "\u0627\u0630\u0631\u0628\u0627\u06cc\u062c\u0627\u0646\u064a" },
            { "BA", "\u0628\u0648\u0633\u0646\u064a\u0627 \u0627\u0648 \u0647\u06d0\u0631\u0632\u06ab\u0648\u064a\u0646\u0627" },
            { "ba", "\u0628\u0627\u0634\u06a9\u064a\u0631" },
            { "BB", "\u0628\u0627\u0631\u0628\u0627\u062f\u0648\u0633" },
            { "ceb", "\u0633\u06cc\u0628\u0648\u0627\u0646\u0648\u064a" },
            { "BD", "\u0628\u0646\u06af\u0644\u0647 \u062f\u06d0\u0634" },
            { "kum", "\u06a9\u0648\u0645\u06a9" },
            { "BE", "\u0628\u06cc\u0644\u062c\u06cc\u0645" },
            { "be", "\u0628\u06d0\u0644\u0627\u0631\u0648\u0633\u064a" },
            { "BF", "\u0628\u0648\u0631\u06a9\u06cc\u0646\u0627 \u0641\u0627\u0633\u0648" },
            { "BG", "\u0628\u0644\u063a\u0627\u0631\u06cc\u0647" },
            { "bg", "\u0628\u0644\u063a\u0627\u0631\u064a" },
            { "BH", "\u0628\u062d\u0631\u064a\u0646" },
            { "BI", "\u0628\u0631\u0648\u0646\u062f\u064a" },
            { "bi", "\u0628\u0633\u0644\u0627\u0645\u0627" },
            { "BJ", "\u0628\u06cc\u0646\u0646" },
            { "BL", "\u0633\u064a\u0646\u067c \u0628\u0627\u0631\u062a\u064a\u0644\u0645\u064a" },
            { "BM", "\u0628\u0631\u0645\u0648\u062f\u0627" },
            { "bm", "\u0628\u0627\u0645\u0631\u0647" },
            { "myv", "\u0627\u0631\u0632\u064a\u0627" },
            { "BN", "\u0628\u0631\u0648\u0646\u0627\u0626\u064a" },
            { "bn", "\u0628\u0646\u06af\u0627\u0644\u064a" },
            { "bo", metaValue_bo },
            { "BO", "\u0628\u0648\u0644\u06cc\u0648\u06cc\u0627" },
            { "dgr", "\u062f\u0627\u06af\u0631\u0628" },
            { "BQ", "\u06a9\u06cc\u0631\u06cc\u0628\u06cc\u0646 \u0647\u0627\u0644\u06cc\u0646\u0689" },
            { "BR", "\u0628\u0631\u0627\u0632\u06cc\u0644" },
            { "br", "\u0628\u0631\u06d0\u062a\u0648\u0646" },
            { "BS", "\u0628\u0627\u0647\u0645\u0627\u0633" },
            { "bs", "\u0628\u0648\u0633\u0646\u064a" },
            { "xog", "\u0633\u0648\u06ab\u0627" },
            { "BT", "\u0628\u0647\u0648\u067c\u0627\u0646" },
            { "BV", "\u0628\u0648\u0648\u06cc\u067c \u067c\u0627\u067e\u0648" },
            { "BW", "\u0628\u0648\u062a\u0633\u0648\u0627\u0646\u0647" },
            { "Mymr", "\u0645\u06cc\u0627\u0646\u0645\u0627\u0631" },
            { "BY", "\u0628\u06cc\u0644\u0627\u0631\u0648\u0633" },
            { "seh", "\u0633\u06cc\u0646\u0627" },
            { "BZ", "\u0628\u0644\u06cc\u0632" },
            { "type.ca.persian", "\u062f \u0641\u0627\u0631\u0633\u064a \u062c\u0646\u062a\u0631\u064a" },
            { "CA", "\u06a9\u0627\u0646\u0627\u0689\u0627" },
            { "ca", "\u06a9\u067c\u0644\u0627\u0646\u064a" },
            { "CC", "\u06a9\u0648\u06a9\u0648\u0632 (\u06a9\u064a\u0644\u0646\u06ab) \u067c\u0627\u067e\u0648\u06ab\u0627\u0646" },
            { "mzn", "\u0645\u0632\u0627\u0646\u062f\u0631\u0627\u0646\u064a" },
            { "ses", "\u06a9\u0648\u06cc\u06cc\u0631\u0627\u0628\u0648\u0631\u0648 \u0633\u06cc\u0646\u06cc" },
            { "CD", "\u06a9\u0627\u0646\u06ab\u0648 - \u06a9\u06cc\u0646\u0634\u0627\u0633\u0627" },
            { "ce", "\u0686\u064a\u0686\u064a\u0646\u064a" },
            { "CF", "\u0648\u0633\u0637\u064a \u0627\u0641\u0631\u064a\u0642\u0627 \u062c\u0645\u0647\u0648\u0631" },
            { "CG", "\u06a9\u0627\u0646\u06ab\u0648 - \u0628\u0631\u0648\u0632\u0648\u06cc\u06cc\u0644" },
            { "CH", "\u0633\u0648\u06cc\u0633" },
            { "ch", "\u0686\u0645\u0648\u0631\u0648" },
            { "CI", "\u062f \u0639\u0627\u062c \u0633\u0627\u062d\u0644" },
            { "CK", "\u06a9\u0648\u06a9 \u067c\u0627\u067e\u0648\u06ab\u0627\u0646" },
            { "CL", "\u0686\u06cc\u0644\u064a" },
            { "CM", "\u06a9\u0627\u0645\u0631\u0648\u0646" },
            { "CN", "\u0686\u06cc\u0646" },
            { "CO", "\u06a9\u0648\u0644\u0645\u0628\u06cc\u0627" },
            { "co", "\u06a9\u0648\u0631\u0633\u064a\u06a9\u0627\u0646\u064a" },
            { "CP", "\u062f \u06a9\u0644\u067e\u0631\u067c\u0648\u0646 \u067c\u0627\u067e\u0648" },
            { "Orya", "\u0627\u0648\u06cc\u0627" },
            { "CR", "\u06a9\u0648\u0633\u062a\u0627\u0631\u06cc\u06a9\u0627" },
            { "cs", "\u0686\u06d0\u06a9\u064a" },
            { "CU", "\u06a9\u06cc\u0648\u0628\u0627" },
            { "cu", "\u062f \u06a9\u0644\u064a\u0633\u0627 \u0633\u0644\u0627\u0648\u064a" },
            { "CV", "\u06a9\u06cc\u067e \u0648\u0631\u062f" },
            { "cv", "\u0686\u0648\u0648\u0627\u0634\u064a" },
            { "CW", "\u06a9\u0648\u0631\u0627\u06a9\u0627\u0648" },
            { "CX", "\u062f \u06a9\u0631\u064a\u0633\u0645\u0633 \u067c\u0627\u067e\u0648" },
            { "CY", "\u0642\u0628\u0631\u0633" },
            { "cy", "\u0648\u064a\u0644\u0634\u064a" },
            { "CZ", "\u0686\u06a9\u06cc\u0627" },
            { "eka", "\u0627\u06a9\u062c\u06a9" },
            { "da", "\u062f\u0627\u0646\u0645\u0627\u0631\u06a9\u064a" },
            { "pt_PT", "\u0627\u0631\u0648\u067e\u0627\u064a\u064a \u067e\u0631\u062a\u06ab\u0627\u0644\u064a" },
            { "DE", "\u0627\u0644\u0645\u0627\u0646" },
            { "de", "\u0627\u0644\u0645\u0627\u0646\u064a" },
            { "ace", "\u0627\u0686\u064a\u0646\u064a" },
            { "cgg", "\u0686\u064a\u06af\u0627\u064a\u064a" },
            { "DG", "\u0689\u0627\u06cc\u06ab\u0648 \u06ab\u0627\u0631\u0633\u06cc\u0627" },
            { "type.cf.standard", "\u0645\u0639\u064a\u0627\u0631\u064a \u0627\u0633\u0639\u0627\u0631\u0648 \u0628\u06bc\u0647" },
            { "DJ", "\u062c\u0628\u0648\u062a\u064a" },
            { "DK", "\u0689\u0646\u0645\u0627\u0631\u06a9" },
            { "Brai", "\u0628\u0631\u06cc\u0644\u064a" },
            { "DM", "\u062f\u0648\u0645\u06cc\u0646\u06cc\u06a9\u0627" },
            { "DO", "\u062c\u0645\u0647\u0648\u0631\u064a\u0647 \u0689\u0648\u0645\u064a\u0646\u064a\u06a9\u0646" },
            { "bem", "\u0628\u06cc\u0628\u0627" },
            { "gor", "\u06ab\u0648\u0631\u0646 \u067c\u0627\u0644\u0648" },
            { "dv", "\u062f\u064a\u0648\u06cc\u0647\u06cc" },
            { "zun", "\u0632\u0648\u0646\u064a" },
            { "es_419", "\u0644\u0627\u062a\u064a\u0646\u064a \u0627\u0645\u0631\u064a\u06a9\u0627\u064a\u064a \u0647\u0633\u067e\u0627\u0646\u0648\u064a" },
            { "tig", "\u062a\u06cc\u06ab\u0631" },
            { "DZ", "\u0627\u0644\u062c\u0632\u0627\u06cc\u0631" },
            { "dz", "\u0698\u0648\u0646\u06af\u06a9\u0647" },
            { "bez", "\u0628\u064a\u0646\u0627" },
            { "pag", "\u067e\u0627\u0646\u06ab\u0627\u0633\u06cc\u0646" },
            { "type.ca.chinese", "\u062f \u0686\u064a\u0646 \u062c\u0646\u062a\u0631\u064a" },
            { "EA", "\u0633\u064a\u0648\u062a\u0627 \u0627\u0648 \u0645\u0627\u0644\u064a\u0644\u0627" },
            { "pam", "\u067e\u0645\u067e\u0627\u0646\u06af\u0627" },
            { "EC", "\u0627\u06a9\u0648\u0627\u062f\u0648\u0631" },
            { "dje", "\u0632\u0631\u0645\u0627" },
            { "pap", "\u067e\u0627\u067e\u064a\u0627\u0645\u064a\u0646\u062a\u0648" },
            { "ada", "\u0627\u062f\u0627\u0646\u06af\u0645\u064a" },
            { "EE", "\u0627\u0633\u062a\u0648\u0646\u06cc\u0627" },
            { "ee", "\u0627\u064a\u0648" },
            { "EG", "\u0645\u0635\u0631" },
            { "EH", "\u0644\u0648\u064a\u062f\u064a\u0681 \u0635\u062d\u0627\u0631\u0627" },
            { "ro_MD", "\u0645\u0648\u0644\u062f\u0627\u0648\u06cc\u0627\u06cc\u06cc" },
            { "pau", "\u067e\u0627\u0644\u0627\u0646" },
            { "el", metaValue_el },
            { "chk", "\u0686\u0648\u0627\u0648\u06a9\u064a" },
            { "en", "\u0627\u0646\u06ab\u0631\u06cc\u0632\u064a" },
            { "chm", "\u0645\u0627\u0631\u064a" },
            { "eo", "\u0627\u0633\u067e\u0631\u0627\u0646\u062a\u0648" },
            { "cho", "\u0686\u0648\u06a9\u067c\u0627\u0648\u064a" },
            { "chr", "\u0686\u06d0\u0631\u0648\u06a9\u064a" },
            { "ER", "\u0627\u0631\u06cc\u062a\u0631\u0647" },
            { "ES", "\u0647\u0633\u067e\u0627\u0646\u06cc\u0647" },
            { "es", "\u0647\u0633\u067e\u0627\u0646\u0648\u064a" },
            { "ET", "\u062d\u0628\u0634\u0647" },
            { "et", "\u062d\u0628\u0634\u064a" },
            { "Hanb", "\u0647\u0646 \u0627\u0648 \u0628\u0648\u067e\u0648\u0641\u0648\u0645\u0648" },
            { "EU", "\u0627\u0631\u0648\u067e\u0627\u064a\u064a \u0627\u062a\u062d\u0627\u062f\u064a\u0647" },
            { "eu", "\u0628\u0627\u0633\u06a9\u064a" },
            { "Hang", "\u0647\u0646\u06ab\u0648\u0644\u064a" },
            { "type.ca.gregorian", "\u06ab\u0631\u064a\u06ab\u0648\u0631\u064a\u0646 \u062c\u0646\u062a\u0631\u064a" },
            { "EZ", "\u0627\u0631\u0648\u067e\u0627\u064a\u064a \u0633\u064a\u0645\u0647" },
            { "chy", "\u0634\u064a\u0646\u064a" },
            { "shi", "\u062a\u0627\u06a9\u0644\u0647\u06cc\u067c" },
            { "hsb", "\u067e\u0648\u0631\u062a\u0647 \u0635\u0631\u0628\u064a" },
            { "Hani", "\u0647\u0646" },
            { "ady", "\u0627\u062f\u064a\u063a\u064a" },
            { "shn", "\u0634\u0627\u0646" },
            { "fa", "\u0641\u0627\u0631\u0633\u064a" },
            { "Hans", "\u0633\u0627\u062f\u0647 \u0634\u0648\u06cc" },
            { "type.nu.latn", "\u0644\u0648\u064a\u062f\u064a\u0681 \u0639\u062f\u062f\u0648\u0646\u0647" },
            { "Hant", "\u062f\u0648\u062f\u06cc\u0632\u0647" },
            { "ff", "\u0641\u0644\u0627\u062d\u06c1" },
            { "FI", "\u0641\u0646\u0644\u06cc\u0646\u0689" },
            { "fi", "\u0641\u06cc\u0646\u0644\u0646\u0689\u064a" },
            { "FJ", "\u0641\u062c\u064a" },
            { "fj", "\u0641\u062c\u06cc\u0627\u0646" },
            { "fon", "\u0641\u0627\u0646" },
            { "FK", "\u0641\u0627\u06a9\u0644\u064a\u0646\u0689 \u067c\u0627\u067e\u0648\u06ab\u0627\u0646" },
            { "FM", "\u0645\u06cc\u06a9\u0631\u0648\u0646\u06cc\u0632\u06cc\u0627" },
            { "yue", "\u06a9\u0627\u0646\u067c\u0648\u0646\u064a" },
            { "FO", "\u0641\u0627\u0631\u0648 \u067c\u0627\u067e\u0648" },
            { "fo", "\u0641\u0627\u0631\u0648\u0626\u06d0" },
            { "Taml", metaValue_ta },
            { "umb", "\u0627\u0645\u0628\u0648\u0646\u062f\u0648" },
            { "FR", "\u0641\u0631\u0627\u0646\u0633\u0647" },
            { "fr", "\u0641\u0631\u0627\u0646\u0633\u0648\u064a" },
            { "fy", "\u0641\u0631\u064a\u0632\u064a" },
            { "root", "\u0631\u0648\u067c" },
            { "GA", "\u06ab\u0627\u0628\u0646" },
            { "ga", "\u0627\u0626\u064a\u0631\u0644\u06d0\u0646\u0689\u064a" },
            { "GB", "\u0628\u0631\u062a\u0627\u0646\u06cc\u0647" },
            { "pcm", "\u0646\u0627\u0626\u062c\u06cc\u0631\u06cc\u0627 \u067e\u06cc\u062f\u062c\u0646" },
            { "GD", "\u06ab\u0631\u0646\u0627\u062f\u0627" },
            { "gd", "\u0633\u06a9\u0627\u067c\u0644\u06d0\u0646\u0689\u064a \u06ab\u06d0\u0644\u06a9" },
            { "GE", "\u06af\u0648\u0631\u062c\u0633\u062a\u0627\u0646" },
            { "GF", "\u0641\u0631\u0627\u0646\u0633\u0648\u064a \u06ab\u0627\u0646\u0627" },
            { "GG", "\u06ab\u0631\u0646\u0633\u064a" },
            { "GH", "\u06ab\u0627\u0646\u0627" },
            { "GI", "\u062c\u0628\u0644 \u0627\u0644\u0637\u0627\u0631\u0642" },
            { "GL", "\u06ab\u0631\u06cc\u0646\u0644\u06cc\u0646\u0689" },
            { "gl", "\u06ab\u0644\u06d0\u0634\u064a\u0627\u064a\u064a" },
            { "GM", "\u06ab\u0627\u0645\u0628\u06cc\u0627" },
            { "GN", "\u06ab\u06cc\u0646\u0647" },
            { "gn", "\u06ab\u0648\u0631\u0627\u0646\u064a" },
            { "bho", "\u0628\u0647\u0648\u062c\u067e\u0648\u0631\u064a" },
            { "GP", "\u06ab\u0627\u0644\u0689\u06cc\u067e" },
            { "GQ", "\u0627\u0633\u062a\u0648\u0627\u06cc\u06cc \u06ab\u06cc\u0646\u0647" },
            { "und", "\u0646\u0627\u0645\u0639\u0644\u0648\u0645\u0647 \u0698\u0628\u0647" },
            { "GR", "\u06cc\u0648\u0646\u0627\u0646" },
            { "GS", "\u0633\u0648\u064a\u0644\u064a \u062c\u0627\u0631\u062c\u064a\u0627 \u0627\u0648 \u0633\u0648\u064a\u0644\u064a \u0633\u06d0\u0646\u0689\u0648\u0686 \u067c\u0627\u067e\u0648\u06ab\u0627\u0646" },
            { "GT", "\u06ab\u0648\u0627\u062a\u06cc\u0645\u0627\u0644\u0627" },
            { "gu", metaValue_gu },
            { "GU", "\u06ab\u0648\u0627\u0645" },
            { "type.ca.islamic-tbla", "\u0627\u0633\u0644\u0627\u0645\u064a \u062c\u0646\u062a\u0631\u064a (\u062c\u062f\u0648\u0644\u064a\u060c \u0633\u062a\u0648\u0631\u067e\u0648\u0647\u0646\u064a\u0632 \u0639\u0635\u0631)" },
            { "gv", "\u0645\u06cc\u0646\u06a9\u0633" },
            { "GW", "\u06ab\u06cc\u0646\u0647 \u0628\u06cc\u0633\u0648" },
            { "tlh", "\u06a9\u0644\u064a\u0646\u06ab\u0627\u0646\u064a" },
            { "GY", "\u06ab\u06cc\u0627\u0646\u0627" },
            { "ha", "\u0647\u0648\u0633\u0627" },
            { "ckb", "\u0645\u0646\u0681\u0646\u06cd \u06a9\u0648\u0631\u062f\u064a" },
            { "zxx", "\u0646\u0647 \u0698\u0628\u0646\u064a \u0645\u0646\u0681\u067e\u0627\u0646\u06ab\u0647" },
            { "he", "\u0639\u0628\u0631\u064a" },
            { "hi", "\u0647\u0646\u062f\u064a" },
            { "de_AT", "\u0627\u062a\u0631\u064a\u0634\u064a \u0622\u0644\u0645\u0627\u0646\u064a" },
            { "hup", "\u06be\u0648\u067e\u0627" },
            { "HK", "\u0647\u0627\u0646\u06ab \u06a9\u0627\u0646\u06ab SAR \u0686\u06cc\u0646" },
            { "HM", "\u0647\u0627\u0631\u0689 \u0627\u0648 \u0645\u064a\u06a9\u0689\u0627\u0646\u0644\u0689 \u067c\u0627\u067e\u0648\u06ab\u0627\u0646" },
            { "HN", "\u0647\u0627\u0646\u0689\u0648\u0631\u0627\u0633" },
            { "bin", "\u0628\u06cc\u0646\u06cc" },
            { "HR", "\u06a9\u0631\u0648\u0627\u0634\u064a\u0627" },
            { "hr", "\u06a9\u0631\u0648\u0648\u0627\u0633\u064a" },
            { "agq", "\u0627\u063a\u06cc\u0645\u064a" },
            { "gsw", "\u0633\u0648\u06cc\u0633 \u062c\u0631\u0645\u0646" },
            { "HT", "\u0647\u0627\u06cc\u067c\u064a" },
            { "ht", "\u0647\u064a\u067d\u064a \u06a9\u0631\u0648\u0644\u064a" },
            { "HU", "\u0645\u062c\u0627\u0631\u0633\u062a\u0627\u0646" },
            { "hu", "\u0647\u0646\u06af\u0631\u064a" },
            { "hy", "\u0627\u0631\u0645\u0646\u064a" },
            { "hz", "\u0647\u06cc\u0631\u0648\u0631\u0648" },
            { "ia", "\u0627\u0646\u067c\u0631\u0644\u0646\u06ab\u0648\u0627" },
            { "IC", "\u062f \u06a9\u0646\u0627\u0631\u064a \u067c\u0627\u067e\u0648\u06ab\u0627\u0646" },
            { "Jamo", "\u062c\u0627\u0645\u0648" },
            { "ID", "\u0627\u0646\u062f\u0648\u0646\u06cc\u0632\u06cc\u0627" },
            { "id", "\u0627\u0646\u0689\u0648\u0646\u06d0\u0632\u064a" },
            { "IE", "\u0627\u06cc\u0631\u0644\u06cc\u0646\u0689" },
            { "nap", "\u0646\u064a\u067e\u0627\u0644\u064a\u0646" },
            { "ig", "\u0627\u06ab\u0628\u0648" },
            { "naq", "\u0646\u0627\u0645\u0627" },
            { "ii", "\u0633\u06cc\u0686\u06cc\u0627\u0646 \u06cc\u06cc" },
            { "zza", "\u0632\u0627\u0632\u0627" },
            { "IL", "\u0627\u0633\u0631\u0627\u064a\u064a\u0644" },
            { "IM", "\u062f \u0622\u0626\u0644 \u0622\u0641 \u0645\u06cc\u0646" },
            { "IN", "\u0647\u0646\u062f" },
            { "IO", "\u062f \u0628\u0631\u064a\u062a\u0627\u0646\u0648\u064a \u0647\u0646\u062f \u0633\u0645\u0646\u062f\u0631\u064a \u0633\u064a\u0645\u0647" },
            { "io", "\u0627\u068a\u0648" },
            { "IQ", "\u0639\u0631\u0627\u0642" },
            { "IR", "\u0627\u064a\u0631\u0627\u0646" },
            { "IS", "\u0622\u06cc\u0633\u0644\u06cc\u0646\u0689" },
            { "is", "\u0627\u064a\u0633\u0644\u0646\u0689\u064a" },
            { "IT", "\u0627\u06cc\u067c\u0627\u0644\u06cc\u0647" },
            { "it", "\u0627\u06cc\u067c\u0627\u0644\u0648\u064a" },
            { "iu", "\u0627\u0646\u0648\u06a9\u062a\u06cc\u062a\u0648\u062a" },
            { "Zmth", "\u062f \u0631\u06cc\u0627\u0636\u06cc\u0627\u062a\u0648 \u0646\u0648\u067c\u06cc\u0634\u0646" },
            { "ja", metaValue_ja },
            { "Mlym", "\u0645\u0627\u0644\u0627\u06cc\u0627\u0644\u0645" },
            { "JE", "\u062c\u0631\u0633\u06cc" },
            { "type.ca.islamic", "\u0627\u0633\u0644\u0627\u0645\u064a \u062c\u0646\u062a\u0631\u064a" },
            { "JM", "\u062c\u0645\u06cc\u06a9\u0627" },
            { "Beng", "\u0628\u0646\u06ab\u0644\u0647" },
            { "JO", "\u0627\u0631\u062f\u0646" },
            { "JP", "\u062c\u0627\u067e\u0627\u0646" },
            { "sma", "\u0633\u0648\u06cc\u0644\u064a \u0633\u0627\u0645\u06cc" },
            { "ain", "\u0627\u064a\u0646\u0648\u064a\u064a" },
            { "jv", "\u062c\u0627\u0648\u0627\u064a\u064a" },
            { "guz", "\u06ab\u0648\u0633\u064a" },
            { "mad", "\u0645\u062f\u0631\u0627\u0633\u06cc" },
            { "smj", "\u0644\u0648\u0644 \u0633\u0627\u0645\u064a" },
            { "mag", "\u0645\u06ab\u0647\u064a" },
            { "de_CH", "\u0633\u0648\u0626\u0633 \u0644\u0648\u06cc \u062c\u0631\u0645\u0646" },
            { "mai", "\u0645\u0627\u06cc\u062a\u06be\u0644\u064a" },
            { "smn", "\u0627\u0646\u0627\u0631\u064a \u0633\u0645\u064a\u0639" },
            { "ka", "\u062c\u0648\u0631\u062c\u064a\u0627\u0626\u064a" },
            { "bla", "\u0633\u06a9\u0633\u064a\u06a9\u0627" },
            { "mak", "\u0645\u06a9\u0627\u0633\u0627\u0631" },
            { "type.ca.buddhist", "\u0628\u0648\u062f\u0627\u064a\u064a \u062c\u0646\u062a\u0631\u064a" },
            { "sms", "\u0633\u06a9\u0648\u0644\u067c \u0633\u0645\u06cc\u0639" },
            { "KE", "\u06a9\u06cc\u0646\u06cc\u0627" },
            { "419", "\u0644\u0627\u062a\u06cc\u0646\u064a \u0627\u0645\u0631\u06cc\u06a9\u0627" },
            { "KG", "\u0642\u0631\u063a\u0632\u0633\u062a\u0627\u0646" },
            { "KH", "\u06a9\u0645\u0628\u0648\u062f\u06cc\u0627" },
            { "KI", "\u06a9\u06cc\u0631\u064a \u0628\u0627\u062a\u064a" },
            { "ki", "\u06a9\u06a9\u0648\u0624\u0648" },
            { "mas", "\u0645\u0627\u0633\u0627\u0626\u064a" },
            { "kj", "\u06a9\u0648\u0627\u0646\u0627\u0645\u0627" },
            { "kk", "\u0642\u0627\u0632\u0642" },
            { "kl", "\u06a9\u0644\u0627\u0644\u06cc\u0633\u0679" },
            { "km", metaValue_km },
            { "KM", "\u06a9\u0648\u0645\u0648\u0631\u0648\u0633" },
            { "KN", "\u0633\u06cc\u0646\u067c \u06a9\u067c\u0633 \u0627\u0648 \u0646\u06cc\u0648\u06cc\u0633" },
            { "kn", "\u06a9\u0646\u0623\u0689\u0647" },
            { "Knda", "\u06a9\u0646\u0627\u0689\u0627" },
            { "fr_CA", "\u06a9\u0627\u0646\u0627\u0689\u0627\u064a\u064a \u0641\u0631\u0627\u0646\u0633\u0648\u064a" },
            { "ko", metaValue_ko },
            { "KP", "\u0634\u0645\u0627\u0644\u06cc \u06a9\u0648\u0631\u06cc\u0627" },
            { "KR", "\u0633\u0648\u06cc\u0644\u064a \u06a9\u0648\u0631\u06cc\u0627" },
            { "kr", "\u06a9\u0646\u0648\u0631\u06cc" },
            { "ks", "\u06a9\u0634\u0645\u06cc\u0631\u064a" },
            { "ku", "\u06a9\u0631\u062f\u064a" },
            { "fr_CH", "\u0633\u0648\u064a\u0633\u064a \u0641\u0631\u0627\u0646\u0633\u0648\u064a" },
            { "kv", "\u06a9\u0648\u0645\u06cc" },
            { "KW", "\u06a9\u0648\u06cc\u067c" },
            { "kw", "\u06a9\u0631\u0648\u0646\u064a\u0634\u064a" },
            { "tpi", "\u062a\u0648\u06a9 \u067e\u06cc\u0633\u06cc\u0646" },
            { "KY", "\u06a9\u06cc\u0645\u0627\u0646 \u067c\u0627\u067e\u0648\u06ab\u0627\u0646" },
            { "ky", "\u06a9\u0631\u06ab\u064a\u0632" },
            { "KZ", "\u0642\u0632\u0627\u0642\u0633\u062a\u0627\u0646" },
            { "Cyrl", "\u0633\u06cc\u0631\u06cc\u0644\u06cc\u06a9" },
            { "snk", "\u0633\u0648\u0646\u06cc\u0646\u06ab" },
            { "LA", "\u0644\u0627\u0648\u0633" },
            { "la", "\u0644\u0627\u062a\u06cc\u0646\u064a" },
            { "LB", "\u0644\u0628\u0646\u0627\u0646" },
            { "lb", "\u0644\u0648\u06ab\u0632\u0627\u0645\u0628\u0648\u0631\u06ab\u064a" },
            { "LC", "\u0633\u06cc\u0646\u067c \u0644\u0648\u0633\u06cc\u0627" },
            { "gwi", "\u06ab\u06cc\u0686\u06cc\u0646" },
            { "lg", "\u06ab\u0627\u0646\u062f\u0647" },
            { "nds", "\u06a9\u069a\u062a\u0647 \u0622\u0644\u0645\u0627\u0646\u064a" },
            { "LI", "\u0644\u06cc\u062e\u062a\u0646 \u0627\u0634\u062a\u0627\u06cc\u0646" },
            { "li", "\u0644\u0645\u0628\u0631\u06af\u06cc\u0627\u0646\u06cc" },
            { "LK", "\u0633\u0631\u064a\u0644\u0646\u06a9\u0627" },
            { "Tibt", metaValue_bo },
            { "ln", "\u0644\u0646\u06af\u0644\u0627" },
            { "fur", "\u0641\u0631\u0627\u0626\u06cc\u0644\u06cc\u06cc\u0646" },
            { "lo", "\u0644\u0627\u0648" },
            { "LR", "\u0644\u0627\u06cc\u0628\u0631\u06cc\u0627" },
            { "LS", "\u0644\u0633\u0648\u062a\u0648" },
            { "LT", "\u0644\u06cc\u062a\u0648\u0627\u0646\u06cc\u0627" },
            { "lt", "\u0644\u064a\u062a\u0648\u0627\u0646\u064a" },
            { "LU", "\u0644\u0648\u06ab\u0632\u0627\u0645\u0628\u0648\u0631\u06ab" },
            { "lu", "\u0644\u0648\u0628\u0627-\u06a9\u067c\u0646\u06ab\u0627" },
            { "LV", "\u0644\u064a\u062a\u0647\u0648\u064a\u0627" },
            { "lv", "\u0644\u06d0\u067c\u0648\u0627\u0646\u064a" },
            { "Kana", "\u06a9\u0627\u062a\u0627\u06a9\u0627\u0646\u0627" },
            { "LY", "\u0644\u06cc\u0628\u06cc\u0627" },
            { "lad", "\u0644\u0627\u0689\u06cc\u0646\u0648" },
            { "vun", "\u0648\u0648\u0646\u062c\u0648" },
            { "lag", "\u0644\u0646\u06ab\u06cc" },
            { "Thaa", "\u062a\u0647\u0627\u0646\u0627" },
            { "MA", "\u0645\u0631\u0627\u06a9\u0634" },
            { "MC", "\u0645\u0648\u0646\u0627\u06a9\u0648" },
            { "MD", "\u0645\u0648\u0644\u062f\u0648\u0627" },
            { "ME", "\u0645\u0648\u0646\u067c\u06cc\u0646\u06cc\u06ab\u0631\u0648" },
            { "MF", "\u0633\u06cc\u0646\u067c \u0645\u0627\u0631\u067c\u0646" },
            { "MG", "\u0645\u062f\u06ab\u0627\u0633\u06a9\u0627\u0631" },
            { "mg", "\u0645\u0644\u063a\u0627\u0633\u064a" },
            { "MH", "\u0645\u0627\u0631\u0634\u0644 \u067c\u0627\u067e\u0648\u06ab\u0627\u0646" },
            { "mh", "\u0645\u0627\u0631\u0634\u0644\u06cc\u0632" },
            { "ale", "\u0627\u0644\u064a\u0648\u062a\u064a" },
            { "Thai", "\u062a\u0627\u06cc\u0644\u0646\u0689\u064a" },
            { "type.co.ducet", "\u068a\u0641\u0627\u0644\u067d \u06cc\u0648\u0646\u06cc\u06a9\u0648\u0689 \u062a\u0631\u062a\u06cc\u0628" },
            { "mi", "\u0645\u0627\u0648\u0631\u064a" },
            { "MK", "\u0634\u0645\u0627\u0644\u064a \u0645\u0642\u062f\u0648\u0646\u064a\u0647" },
            { "mk", "\u0645\u0642\u062f\u0648\u0646\u064a" },
            { "ML", "\u0645\u0627\u0644\u064a" },
            { "ml", "\u0645\u0627\u0644\u0627\u064a\u0627\u0644\u0645" },
            { "MM", "\u0645\u064a\u0627\u0646\u0645\u0627\u0631 (\u0628\u0631\u0645\u0627)" },
            { "MN", "\u0645\u063a\u0648\u0644\u0633\u062a\u0627\u0646" },
            { "mn", "\u0645\u0646\u06ab\u0648\u0644\u06cc\u0627\u06cc\u06cc" },
            { "new", "\u0646\u064a\u0648\u0627\u0631\u064a" },
            { "MO", "\u0645\u06a9\u0627\u0648 \u0633\u0627\u0631 \u0686\u06cc\u0646" },
            { "MP", "\u0634\u0645\u0627\u0644\u064a \u0645\u0627\u0631\u064a\u0627\u0646\u0627 \u067c\u0627\u067e\u0648\u06ab\u0627\u0646" },
            { "MQ", "\u0645\u0627\u0631\u067c\u06cc\u0646\u06cc\u06a9" },
            { "MR", "\u0645\u0648\u0631\u06cc\u062a\u0627\u0646\u06cc\u0627" },
            { "mr", "\u0645\u0631\u0627\u067c\u0647\u064a" },
            { "MS", "\u0645\u0627\u0646\u067c\u06cc\u0633\u06cc\u0631\u062a" },
            { "ms", "\u0645\u0644\u0627\u06cc\u0627" },
            { "MT", "\u0645\u0627\u0644\u062a\u0627" },
            { "mt", "\u0645\u0627\u0644\u067c\u0627\u064a\u064a" },
            { "MU", "\u0645\u0648\u0631\u06cc\u0634\u06cc\u0633" },
            { "alt", "\u0633\u0648\u06cc\u0644 \u0627\u0644\u067c\u0627\u06cc" },
            { "MV", "\u0645\u0627\u0644\u062f\u064a\u067e" },
            { "MW", "\u0645\u0627\u0644\u0627\u0648\u064a" },
            { "MX", "\u0645\u06cc\u06a9\u0633\u06cc\u06a9\u0648" },
            { "type.ca.japanese", "\u062f \u062c\u0627\u067e\u0627\u0646\u064a \u062c\u0646\u062a\u0631\u064a" },
            { "MY", "\u0645\u0627\u0644\u06cc\u0632\u06cc\u0627" },
            { "my", "\u0628\u0631\u0645\u0627\u06cc\u06cc" },
            { "MZ", "\u0645\u0648\u0632\u0645\u0628\u064a\u0642" },
            { "Armn", "\u0627\u0631\u0645\u0627\u0646\u06cc\u0627\u06cc\u064a" },
            { "mdf", "\u0645\u0648\u06a9\u0634\u0627" },
            { "dsb", "\u0644\u0648\u0693\u06d0 \u0633\u0631\u0628\u064a" },
            { "na", metaValue_NR },
            { "NA", "\u0646\u06cc\u0645\u0628\u06cc\u0627" },
            { "type.co.search", "\u0639\u0645\u0648\u0645\u064a \u0645\u0648\u062e\u0648 \u062f \u0644\u067c\u0648\u0646" },
            { "202", "\u0633\u0628 \u0633\u0647\u0627\u0631\u0646 \u0627\u0641\u0631\u064a\u0642\u0627" },
            { "nb", "\u0646\u0627\u0631\u0648\u06d0 \u0628\u0648\u06a9\u0645\u0627\u0644" },
            { "type.ca.hebrew", "\u062c\u0648\u0631\u062c\u0648\u06cc\u0627\u0646 \u062c\u0646\u062a\u0631\u064a" },
            { "NC", "\u0646\u0648\u06cc \u06a9\u0627\u0644\u06cc\u0689\u0648\u0646\u06cc\u0627" },
            { "nd", "\u0634\u0645\u0627\u0644\u064a \u0646\u062f\u064a\u0628\u0644" },
            { "NE", "\u0646\u06cc\u062c\u0631" },
            { "ne", "\u0646\u06d0\u067e\u0627\u0644\u064a" },
            { "NF", "\u0646\u0627\u0631\u0641\u0648\u0644\u06a9 \u067c\u0627\u067e\u0648\u06ab\u0627\u0646" },
            { "NG", "\u0646\u0627\u06cc\u062c\u06cc\u0631\u06cc\u0627" },
            { "ng", "\u0646\u062f\u0648\u0646\u06af\u0627" },
            { "trv", "\u062a\u0627\u0631\u0648\u06a9\u0648" },
            { "NI", "\u0646\u06a9\u0627\u0631\u0627\u06ab\u0648\u0627" },
            { "NL", "\u0647\u0627\u0644\u06d0\u0646\u0689" },
            { "nl", "\u0647\u0627\u0644\u06d0\u0646\u0689\u064a" },
            { "nn", "\u0646\u0627\u0631\u0648\u06d0\u0626\u064a (\u0646\u0627\u0626\u0646\u0648\u0631\u0633\u06a9)" },
            { "NO", "\u0646\u0627\u0631\u0648\u06cd" },
            { "NP", "\u0646\u06cc\u067e\u0627\u0644" },
            { "NR", metaValue_NR },
            { "nr", "\u0633\u0648\u064a\u0644\u064a \u0646\u062f\u064a\u0628\u064a\u0644" },
            { "NU", "\u0646\u06cc\u0648\u0648" },
            { "nv", "\u0646\u0648\u0627\u062c\u0648" },
            { "rof", "\u0631\u0648\u0645\u0628\u0648" },
            { "ny", "\u0646\u06cc\u0627\u0646\u062c\u0627" },
            { "NZ", "\u0646\u06cc\u0648\u0632\u06cc\u0644\u0646\u0689" },
            { "kac", "\u06a9\u0627\u0686\u06cc\u0646" },
            { "kab", "\u06a9\u06cc\u0628\u06cc\u0644" },
            { "oc", "\u0627\u0648\u06a9\u0633\u064a\u067c\u0627\u0646\u064a" },
            { "kaj", "\u062c\u062c\u0648" },
            { "kam", "\u06a9\u0627\u0645\u0628\u0627" },
            { "men", "\u0645\u06cc\u0646\u068a\u064a" },
            { "mer", "\u0645\u064a\u0631\u0648" },
            { "OM", "\u0639\u0645\u0627\u0646" },
            { "om", "\u0627\u0648\u0631\u0648\u0645\u0648" },
            { "anp", "\u0627\u0646\u06af\u064a\u06a9\u064a" },
            { "or", "\u0627\u0648\u068a\u064a\u0627" },
            { "os", "\u0627\u0648\u0633\u06cc\u0679\u06a9" },
            { "crs", "\u0633\u0633\u064a\u0644\u0648\u0627 \u06aa\u0631\u0648\u0626\u0644 \u0641\u0631\u0627\u0646\u0633\u0648\u064a" },
            { "kbd", "\u06a9\u0627\u0628\u06cc\u0631\u06cc\u0646" },
            { "mfe", "\u0645\u0627\u0631\u06cc\u0633\u06cc\u0633\u0646" },
            { "srn", "\u0633\u0648\u0631\u0627\u0646 \u067c\u0648\u0646\u06ab\u0648" },
            { "PA", "\u067e\u0627\u0646\u0627\u0645\u0627" },
            { "pa", "\u067e\u0646\u062c\u0627\u0628\u064a" },
            { "dua", "\u062f\u0648\u0627\u0644\u0627" },
            { "type.ca.islamic-civil", "\u062f \u0627\u0633\u0644\u0627\u0645\u064a \u062c\u0646\u062a\u0631\u064a (\u062c\u062f\u0648\u0644\u064a\u060c \u062f \u0645\u062f\u0646\u064a \u0639\u0635\u0631)" },
            { "en_GB", "\u0628\u0631\u064a\u062a\u0627\u0646\u0648\u06cc \u0627\u0646\u06ab\u0644\u06cc\u0633\u064a" },
            { "PE", "\u067e\u06cc\u0631\u0648" },
            { "PF", "\u0641\u0631\u0627\u0646\u0633\u0648\u064a \u067e\u0648\u0644\u064a\u0646\u064a\u0633\u064a\u0627" },
            { "PG", "\u067e\u0627\u067e\u0648\u0627 \u0646\u064a\u0648 \u06ab\u064a\u0646\u064a" },
            { "PH", "\u0641\u0644\u067e\u064a\u0646" },
            { "PK", "\u067e\u0627\u06a9\u0633\u062a\u0627\u0646" },
            { "PL", "\u067e\u0648\u0644\u0646\u0689" },
            { "pl", "\u067e\u0648\u0644\u0646\u0689\u064a" },
            { "ewo", "\u0627\u0648\u0648\u0646\u068a\u0648" },
            { "PM", "\u0633\u06cc\u0646\u067c \u067e\u06cc\u06cc\u0631 \u0627\u0648 \u0645\u06cc\u06a9\u0648\u0644\u0648\u0646" },
            { "PN", "\u067e\u064a\u067c\u06a9\u064a\u0631\u0646 \u067c\u0627\u067e\u0648\u06ab\u0627\u0646" },
            { "type.ca.dangi", "\u0689\u0627\u0646\u06ab\u064a \u062c\u0646\u062a\u0631\u064a" },
            { "PR", "\u067e\u0648\u0631\u062a\u0648 \u0631\u06cc\u06a9\u0648" },
            { "PS", "\u0641\u0644\u0633\u0637\u064a\u0646 \u0633\u064a\u0645\u06d0" },
            { "ps", "\u067e\u069a\u062a\u0648" },
            { "PT", "\u067e\u0648\u0631\u062a\u06ab\u0627\u0644" },
            { "pt", "\u067e\u0648\u0631\u062a\u06ab\u0627\u0644\u064a" },
            { "key.co", "\u062a\u0631\u062a\u064a\u0628" },
            { "PW", "\u067e\u0644\u0627\u0624" },
            { "nia", "\u0646\u064a\u0627\u0633" },
            { "PY", "\u067e\u0627\u0631\u0627\u06ab\u0648\u06cc" },
            { "pt_BR", "\u0628\u0631\u0627\u0632\u06cc\u0644\u064a \u067e\u0631\u062a\u06ab\u0627\u0644\u064a" },
            { "tum", "\u062a\u0627\u0645\u0628\u0648\u06a9\u0627" },
            { "kcg", "\u062a\u0627\u06cc\u067e" },
            { "mgh", "\u0645\u06a9\u06be\u0648\u0627\u0645\u06cc\u062a\u0648" },
            { "Hebr", "\u0639\u0628\u0631\u0627\u0646\u064a" },
            { "key.cf", "\u0627\u0633\u0639\u0627\u0631\u0648 \u0628\u06bc\u0647" },
            { "QA", "\u0642\u0637\u0631" },
            { "key.ca", "\u062c\u0646\u062a\u0631\u064a" },
            { "Laoo", "\u0644\u0627\u0648\u0648" },
            { "mgo", "\u0645\u064a\u067c\u0627" },
            { "ssy", "\u0633\u0647\u0648" },
            { "niu", "\u0646\u06cc\u0627\u0646" },
            { "QO", "\u0628\u0647\u0631\u0646\u06cd \u0627\u0648\u0633\u064a\u0627\u0646\u0647" },
            { "lez", "\u0644\u06cc\u06ab\u063a\u06cc\u0627\u0646" },
            { "qu", "\u06a9\u06d0\u0686\u0648\u0627" },
            { "brx", "\u0628\u0648\u062f\u0648" },
            { "tvl", "\u062a\u0648\u0648\u0627\u0644\u0648" },
            { "kde", "\u0645\u0627\u06a9\u0689\u0648\u0646" },
            { "001", "\u0646\u0693\u06cd" },
            { "Ethi", "\u0627\u06cc\u062a\u0648\u067e\u064a" },
            { "002", "\u0627\u0641\u0631\u064a\u0642\u0627" },
            { "003", "\u0634\u0645\u0627\u0644\u06cc \u0627\u0645\u0631\u06cc\u06a9\u0627" },
            { "RE", "\u0631\u06cc\u0648\u0646\u06cc\u0646" },
            { "005", "\u0633\u0648\u064a\u0644\u064a \u0627\u0645\u0631\u064a\u06a9\u0627" },
            { "jbo", "\u0644\u0648\u062c\u0628\u0627\u0646" },
            { "009", "\u0633\u0645\u0646\u062f\u0631\u064a\u0647" },
            { "rm", "\u0631\u0648\u0645\u0627\u0646\u06cc\u0634" },
            { "rn", "\u0631\u0648\u0646\u0689\u06cc" },
            { "key.cu", "\u0627\u0633\u0639\u0627\u0631\u0648" },
            { "RO", "\u0631\u0648\u0645\u0627\u0646\u06cc\u0627" },
            { "ro", "\u0631\u0648\u0645\u0627\u0646\u06cc\u0627\u06cc\u06cc" },
            { "RS", "\u0633\u0631\u0628\u064a\u0627" },
            { "RU", "\u0631\u0648\u0633\u06cc\u0647" },
            { "ru", "\u0631\u0648\u0633\u064a" },
            { "RW", "\u0631\u0648\u0646\u062f\u0627" },
            { "rw", "\u06a9\u06cc\u0646\u06cc\u0627\u0631\u0648\u0646\u0689\u0627" },
            { "kea", "\u06a9\u0627\u0628\u0648\u0648\u0631\u0689\u06cc\u0627\u0646\u0648" },
            { "mic", "\u0645\u0645\u06a9\u0642" },
            { "suk", "\u0633\u06a9\u0648\u0645\u0627" },
            { "en_AU", "\u0627\u0646\u06ab\u0644\u064a\u0633\u064a (AU)" },
            { "SA", "\u0633\u0639\u0648\u062f\u064a \u0639\u0631\u0628\u0633\u062a\u0627\u0646" },
            { "sa", "\u0633\u0646\u0633\u06a9\u0631\u06cc\u067c" },
            { "SB", "\u0633\u0644\u064a\u0645\u0627\u0646 \u067c\u0627\u067e\u0648\u06ab\u0627\u0646" },
            { "twq", "\u062a\u0633\u0627\u0648\u0627\u0642" },
            { "011", "\u0644\u0648\u06cc\u062f\u06cc\u0681 \u0627\u0641\u0631\u06cc\u0642\u0627" },
            { "SC", "\u0633\u06cc\u0686\u06cc\u0644\u06cc\u0633" },
            { "sc", "\u0633\u0627\u0631\u068a\u064a\u0646\u064a" },
            { "SD", "\u0633\u0648\u0689\u0627\u0646" },
            { "sd", "\u0633\u0646\u062f\u0647\u064a" },
            { "013", "\u0645\u0646\u062e\u0646\u06cd \u0627\u0645\u0631\u064a\u06a9\u0627" },
            { "SE", "\u0633\u0648\u06cc\u0689\u0646" },
            { "se", "\u0634\u0645\u0627\u0644\u064a \u0633\u0627\u0645\u064a" },
            { "014", "\u062e\u062a\u06cc\u0681 \u0627\u0641\u0631\u06cc\u0642\u0627" },
            { "min", "\u0645\u064a\u0646\u064a\u06af\u0627\u0628\u0627\u0648" },
            { "015", "\u0634\u0645\u0627\u0644\u064a \u0627\u0641\u0631\u06cc\u0642\u0627" },
            { "SG", "\u0633\u064a\u0646\u06af\u0627\u067e\u0648\u0631" },
            { "sg", "\u0633\u0627\u0646\u06ab\u0648" },
            { "SH", "\u0633\u06cc\u0646\u067c \u0647\u06cc\u0644\u06cc\u0646\u0627" },
            { "017", "\u0645\u0646\u0681\u0646\u06cd \u0627\u0641\u0631\u06cc\u0642\u0627" },
            { "SI", "\u0633\u0644\u0648\u0627\u0646\u06cc\u0627" },
            { "si", "\u0633\u064a\u0646\u0647\u0627\u0644\u064a" },
            { "018", "\u0633\u0648\u064a\u0644\u064a \u0627\u0641\u0631\u064a\u0642\u0627" },
            { "SJ", "\u0633\u0648\u0627\u0644\u0628\u0627\u0631\u062f \u0627\u0648 \u062c\u0627\u0646 \u0645\u064a\u064a\u0646" },
            { "019", "\u0627\u0645\u0631\u064a\u06a9\u06d0" },
            { "SK", "\u0633\u0644\u0648\u0627\u06a9\u06cc\u0627" },
            { "sk", "\u0633\u0644\u0648\u0648\u0627\u06a9\u064a" },
            { "SL", "\u0633\u06cc\u06cc\u0631\u0627 \u0644\u06cc\u0648\u0646" },
            { "sl", "\u0633\u0644\u0648\u0648\u0627\u0646\u064a" },
            { "SM", "\u0633\u0627\u0646 \u0645\u0627\u0631\u06cc\u0646\u0648" },
            { "sm", "\u0633\u0627\u0645\u0648\u0622\u0646" },
            { "SN", "\u0633\u064a\u0646\u064a\u06ab\u0627\u0644" },
            { "sn", "\u0634\u0648\u0646\u0627" },
            { "SO", "\u0633\u0648\u0645\u0627\u0644\u06cc\u0627" },
            { "so", "\u0633\u0648\u0645\u0627\u0644\u064a" },
            { "arn", "\u0645\u0627\u067e\u0648\u0686\u0647" },
            { "type.nu.arab", "\u0639\u0631\u0628\u064a - \u0627\u0646\u0689\u06cc\u06a9 \u0639\u062f\u062f\u0648\u0646\u0647" },
            { "sq", "\u0627\u0644\u0628\u0627\u0646\u064a" },
            { "arp", "\u0627\u0631\u0627\u067e\u0627\u0647\u0648\u064a" },
            { "SR", "\u0633\u0648\u0631\u06cc\u0646\u0627\u0645" },
            { "sr", "\u0633\u0631\u0628\u064a\u0627\u0626\u064a" },
            { "SS", "\u0633\u0648\u064a\u0644\u064a \u0633\u0648\u0689\u0627\u0646" },
            { "ss", "\u0633\u0648\u0627\u062a\u06cc" },
            { "type.cf.account", "\u0645\u062d\u0627\u0633\u0628\u0647 \u0627\u0633\u0639\u0627\u0631\u0648 \u0628\u06bc\u0647" },
            { "ST", "\u0633\u0627\u0648 \u067c\u06cc\u0645 \u0627\u0648 \u067e\u0631\u0646\u0633\u06cc\u067e" },
            { "st", "\u0633\u064a\u0633\u0648\u062a\u0648" },
            { "su", "\u0633\u0648\u0689\u0627\u0646\u064a" },
            { "SV", "\u0633\u0627\u0644\u0648\u06d0\u0689\u0648\u0631" },
            { "sv", "\u0633\u0648\u06cc\u0689\u0646\u06cc" },
            { "sw", "\u0633\u0648\u0627\u0647\u06d0\u0644\u064a" },
            { "SX", "\u0633\u06cc\u0646\u067c \u0645\u0627\u0631\u067c\u06cc\u0646" },
            { "SY", "\u0633\u0648\u0631\u06cc\u0647" },
            { "SZ", "\u0627\u0633\u0648\u0627\u067c\u064a\u0646\u064a" },
            { "ibb", "\u0627\u0628\u06cc\u0628\u06cc\u0648" },
            { "iba", "\u0627\u0628\u0646" },
            { "ta", metaValue_ta },
            { "TA", "\u062a\u0631\u06cc\u0633\u062a\u0627\u0646 \u062f\u0627 \u06a9\u0646\u0647\u0627" },
            { "asa", "\u0627\u0633\u0648\u064a\u064a" },
            { "021", "\u0634\u0645\u0627\u0644\u064a \u0627\u0645\u0631\u06cc\u06a9\u0627" },
            { "142", "\u0622\u0633\u064a\u0627" },
            { "TC", "\u062f \u062a\u0631\u06a9\u06cc\u06d0 \u0627\u0648 \u06a9\u06cc\u06a9\u0627\u0633\u0648 \u067c\u0627\u067e\u0648" },
            { "yav", "\u06cc\u0646\u06ab\u0628\u06cc\u0646" },
            { "143", "\u0645\u0646\u0681\u0646\u06cd \u0622\u0633\u064a\u0627" },
            { "TD", "\u0686\u0627\u0689" },
            { "te", "\u062a\u06d0\u0644\u064a\u06ab\u0648" },
            { "145", "\u0644\u0648\u06cc\u062f\u06cc\u0681 \u0622\u0633\u06cc\u0627" },
            { "TF", "\u062f \u0641\u0631\u0627\u0646\u0633\u06d0 \u062c\u0646\u0648\u0628\u064a \u0633\u06cc\u0645\u06d0" },
            { "TG", "\u067c\u0648\u06ab\u0648" },
            { "tg", "\u062a\u0627\u062c\u06a9\u064a" },
            { "TH", "\u062a\u0647\u0627\u064a\u0644\u0646\u0689" },
            { "th", "\u062a\u0627\u064a\u0644\u06d0\u0646\u0689\u064a" },
            { "ti", "\u062a\u064a\u06ab\u0631\u064a\u0646\u064a" },
            { "bug", "\u0628\u06af\u0646\u064a\u0627\u064a\u064a" },
            { "kfo", "\u06a9\u0648\u0631\u0648" },
            { "TJ", "\u062a\u0627\u062c\u06a9\u0633\u062a\u0627\u0646" },
            { "en_CA", "\u06a9\u0627\u0646\u0627\u0689\u0627\u064a\u064a \u0627\u0646\u06ab\u0644\u06cc\u0633\u064a" },
            { "029", "\u06a9\u06cc\u0631\u06cc\u0628\u06cc\u0646" },
            { "TK", "\u062a\u0648\u06a9\u06cc\u0644\u0648" },
            { "tk", "\u062a\u0631\u06a9\u0645\u0646\u064a" },
            { "TL", "\u062a\u064a\u0645\u0648\u0631-\u0644\u064a\u0633\u067c" },
            { "ybb", "\u06cc\u0645\u0628\u0627" },
            { "TM", "\u062a\u0648\u0631\u06a9\u0645\u0646\u0633\u062a\u0627\u0646" },
            { "TN", "\u062a\u0648\u0646\u0633" },
            { "tn", "\u0633\u0648\u0648\u0627\u0646\u0627" },
            { "TO", "\u062a\u0648\u0646\u06ab\u0627" },
            { "to", "\u062a\u0648\u0646\u06ab\u0627\u0646" },
            { "dyo", "\u062c\u0648\u0644\u0627 \u0641\u0648\u0646\u064a" },
            { "tr", metaValue_TR },
            { "TR", metaValue_TR },
            { "ts", "\u0633\u0648\u0646\u06ab\u0627" },
            { "swb", "\u06a9\u0648\u0645\u0648\u0631\u064a\u0627\u0646\u064a" },
            { "TT", "\u067c\u0631\u064a\u0646\u064a\u0689\u0627\u0689 \u0627\u0648 \u067c\u0648\u0628\u0627\u06ab\u0648" },
            { "tt", "\u062a\u0627\u062a\u0627\u0631" },
            { "TV", "\u062a\u0648\u0627\u0644\u06cc\u0648" },
            { "TW", "\u062a\u0627\u0626\u064a\u0648\u0627\u0646" },
            { "ast", "\u0627\u0633\u062a\u0648\u0631\u064a\u0627\u0646\u064a" },
            { "ty", "\u062a\u0627\u0647\u06cc\u062a\u064a" },
            { "TZ", "\u062a\u0646\u0632\u0627\u0646\u06cc\u0627" },
            { "nmg", "\u06a9\u0648\u0627\u0633\u06cc\u0648" },
            { "Zzzz", "\u0646\u0627\u0645\u0639\u0644\u0648\u0645\u0647 \u0633\u06a9\u0631\u06d0\u067e\u067c" },
            { "150", "\u0627\u0631\u0648\u067e\u0627" },
            { "UA", "\u0627\u0648\u06a9\u0631\u0627\u06cc\u0646" },
            { "rup", "\u0627\u0631\u0648\u0645\u0627\u0646\u064a" },
            { "030", "\u062e\u062a\u06cc\u0681 \u0622\u0633\u06cc\u0627" },
            { "151", "\u062e\u062a\u064a\u0681\u0647 \u0627\u0631\u0648\u067e\u0627" },
            { "154", "\u0634\u0645\u0627\u0644\u064a \u0627\u0631\u0648\u067e\u0627" },
            { "dzg", "\u0689\u0632\u0627\u06ab\u0627" },
            { "tyv", "\u062a\u0648\u06cc\u0646\u06cc\u0627\u0646" },
            { "sw_CD", "\u06a9\u0627\u0646\u06ab\u0648 \u0633\u0648\u0627\u0647\u0644\u06cc" },
            { "034", "\u0633\u0648\u064a\u0644\u064a \u0622\u0633\u064a\u0627" },
            { "155", "\u0644\u0648\u06cc\u062f\u06cc\u0681\u0647 \u0627\u0631\u0648\u067e\u0627" },
            { "035", "\u0633\u0648\u064a\u0644\u064a \u062e\u062a\u064a\u0681 \u0622\u0633\u064a\u0627" },
            { "UG", "\u06cc\u0648\u06ab\u0627\u0646\u0689\u0627" },
            { "ug", "\u0627\u0648\u064a\u063a\u0648\u0631\u064a" },
            { "Kore", metaValue_ko },
            { "Zyyy", "\u0639\u0627\u0645" },
            { "039", "\u0633\u0648\u064a\u0644\u064a \u0627\u0631\u0648\u067e\u0627" },
            { "uk", "\u0627\u0648\u06a9\u0631\u0627\u0646\u0627\u064a\u064a" },
            { "Sinh", "\u0633\u0646\u0647\u0627\u0644\u0627" },
            { "UM", "\u062f \u0645\u062a\u062d\u062f\u0647 \u0627\u06cc\u0627\u0644\u0627\u062a\u0648 \u067c\u0627\u067e\u0648\u06ab\u0627\u0646" },
            { "UN", "\u0645\u0644\u06af\u0631\u064a \u0645\u0644\u062a\u0648\u0646\u0647" },
            { "ur", "\u0627\u0631\u062f\u0648" },
            { "US", "\u0645\u062a\u062d\u062f\u0647 \u0622\u064a\u0627\u0644\u0627\u062a" },
            { "haw", "\u0647\u0648\u0627\u06cc\u06cc" },
            { "xal", "\u06a9\u0627\u0644\u0645\u06a9" },
            { "UY", "\u06cc\u0648\u0631\u0648\u06ab\u0648\u06cc" },
            { "prg", "\u067e\u0631\u0648\u0634\u064a\u0646" },
            { "UZ", "\u0627\u0648\u0632\u0628\u06a9\u0633\u062a\u0627\u0646" },
            { "uz", "\u0627\u0648\u0632\u0628\u06a9\u064a" },
            { "kha", "\u062e\u0627\u0633\u06d0" },
            { "tzm", "\u0645\u0631\u06a9\u0632\u06cc \u0627\u0637\u0644\u0633 \u062a\u0645\u0627\u0632\u0627\u0626\u064a\u0679" },
            { "nnh", "\u0646\u0627\u06cc\u062c\u06cc\u0645\u0648\u0646" },
            { "VA", "\u0648\u0627\u062a\u06cc\u06a9\u0627\u0646 \u069a\u0627\u0631" },
            { "VC", "\u0633\u06cc\u0646\u067c \u0648\u06cc\u0633\u0646\u067c\u06cc\u0646\u067c \u0627\u0648 \u06ab\u0631\u06cc\u0646\u0689\u06cc\u0646\u0632" },
            { "VE", "\u0648\u06cc\u0646\u0632\u0648\u06cc\u0644\u0627" },
            { "ve", "\u0648\u06cc\u0646\u062f\u0627" },
            { "type.ca.roc", "\u0645\u0646\u06af\u0648\u0648 \u062c\u0646\u062a\u0631\u064a" },
            { "VG", "\u0628\u0631\u06cc\u062a\u0627\u0646\u0648\u06cc \u0648\u06cc\u06ab\u0648\u0631 \u067c\u0627\u067e\u0648\u06ab\u0627\u0646" },
            { "VI", "\u062f \u0645\u062a\u062d\u062f\u0647 \u0622\u064a\u0627\u0644\u0627\u062a\u0648 \u0648\u0631\u062c\u0646 \u067c\u0627\u067e\u0648\u06ab\u0627\u0646" },
            { "vi", "\u0648\u06d0\u062a\u0646\u0627\u0645\u064a" },
            { "khq", "\u06a9\u0648\u06cc\u0631\u0627 \u0686\u06cc\u0646\u06cc" },
            { "VN", "\u0648\u06d0\u062a\u0646\u0627\u0645" },
            { "vo", "\u0648\u0627\u0644\u0627\u067e\u0648\u06a9" },
            { "quc", "\u06a9\u0686\u06cc" },
            { "VU", "\u0648\u0627\u0646\u0627\u062a\u0648" },
            { "gaa", "gaa" },
            { "nog", "\u0646\u0648\u06ab\u06cc" },
            { "wa", "\u0648\u0627\u0644\u0648\u0646" },
            { "syr", "\u0633\u0648\u0631\u06cc\u0627\u0646\u064a" },
            { "053", "\u0622\u0633\u062a\u0631\u0627\u0644\u06cc\u0627" },
            { "054", "\u0645\u0644\u0627\u0646\u0634\u06cc\u0627" },
            { "WF", "\u0648\u0627\u0644\u06cc\u0633 \u0627\u0648 \u0641\u0648\u062a\u0648\u0646\u0627" },
            { "Grek", metaValue_el },
            { "057", "\u062f \u0645\u0627\u06cc\u06a9\u0631\u0648\u0646\u06cc\u0633\u06cc\u0646\u06cc\u0646 \u0633\u06cc\u0645\u0647" },
            { "jgo", "\u0646\u06ab\u0628\u0627" },
            { "lkt", "\u0644\u06a9\u067c\u0648" },
            { "wo", "\u0648\u0644\u0648\u0641" },
            { "wae", "\u0648\u0644\u0633\u06cc\u0631" },
            { "zgh", "\u0645\u0639\u064a\u0627\u0631\u064a \u0645\u0631\u0627\u06a9\u0634 \u062a\u0645\u0627\u0632\u067c\u06cc\u067c" },
            { "ar_001", "\u0646\u0648\u06d0 \u0645\u0639\u064a\u0627\u0631\u064a \u0639\u0631\u0628\u064a" },
            { "WS", "\u0633\u0627\u0645\u0648\u0627" },
            { "Mong", "\u0645\u0646\u06ab\u0648\u0644\u06cc\u0627\u06cc\u064a" },
            { "wal", "\u0648\u0644\u0627\u06cc\u067c\u0627" },
            { "XA", "\u062c\u0639\u0644\u064a \u062e\u062c" },
            { "mni", "\u0645\u0627\u0646\u06cc \u067e\u0648\u0631\u06cc" },
            { "war", "\u0648\u0627\u0631\u06cd" },
            { "XB", "\u062c\u0639\u0644\u064a \u0628\u064a\u062f\u064a" },
            { "awa", "\u0627\u0648\u0627\u062f\u064a" },
            { "061", "\u067e\u0648\u0644\u0646\u064a\u0633\u064a\u0627" },
            { "Latn", "\u0644\u0627\u062a\u064a\u0646/\u0644\u0627\u062a\u064a\u0646\u064a" },
            { "xh", "\u062e\u0648\u0633\u0627" },
            { "XK", "\u06a9\u0648\u0633\u0648\u0648" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "\u0646\u0627\u0644\u064a\u06a9\u0644\u06cc" },
            { "byn", "\u0628\u0644\u06cc\u0646" },
            { "moh", "\u0645\u062d\u0627\u0648\u0627\u06a9" },
            { "kkj", "\u06a9\u0627\u06a9\u0648" },
            { "YE", "\u06cc\u0645\u0646" },
            { "nqo", "\u0646\u06a9\u0648" },
            { "type.co.standard", "\u0645\u0639\u064a\u0627\u0631\u064a \u062f \u0644\u067c\u06d0 \u062a\u0631\u062a\u064a\u0628" },
            { "yi", "\u064a\u062f\u064a\u0634" },
            { "mos", "\u0645\u0627\u0633\u064a" },
            { "yo", "\u06cc\u0648\u0631\u0648\u0628\u0627" },
            { "es_MX", "\u0645\u064a\u06a9\u0633\u064a\u06a9\u0648 \u0647\u0633\u067e\u0627\u0646\u0648\u064a" },
            { "YT", "\u0645\u0627\u064a\u0648\u067c" },
            { "vai", "\u0648\u0627\u06cc" },
            { "ZA", "\u0633\u0648\u06cc\u0644\u064a \u0627\u0641\u0631\u06cc\u0642\u0627" },
            { "kln", "\u06a9\u0644\u06cc\u0646\u062c\u0646" },
            { "Deva", "\u062f\u06cc\u0648\u0627\u0646\u0627\u06ab\u0631\u064a" },
            { "zh", "\u0686\u06cc\u0646\u064a" },
            { "Hira", "\u0647\u06cc\u0631\u0627\u06ab\u0627\u0646\u0627" },
            { "ZM", "\u0632\u06cc\u0645\u0628\u06cc\u0627" },
            { "Bopo", "\u0628\u0648\u067e\u0648\u0645\u0648\u0641\u0648" },
            { "zu", "\u0632\u0648\u0644\u0648" },
            { "ZW", "\u0632\u06cc\u0645\u0628\u0627\u0628\u0648\u06cc" },
            { "ZZ", "\u0646\u0627\u0645\u0639\u0644\u0648\u0645\u0647 \u0633\u064a\u0645\u0647" },
            { "Geor", "\u06ab\u0631\u062c\u0633\u062a\u0627\u0646\u064a" },
            { "kmb", "\u06a9\u06cc\u0645\u0628\u0648\u0646\u062f\u0648" },
            { "type.ca.iso8601", "ISO-8601 \u062c\u0646\u062a\u0631\u064a" },
            { "nso", "\u0634\u0645\u0627\u0644\u064a \u0633\u0648\u062a\u0648" },
            { "loz", "\u0644\u0648\u0632\u06cc" },
            { "gez", "\u06ab\u06cc\u0632" },
            { "ebu", "\u0627\u06cc\u0645\u0648" },
            { "jmc", "\u0645\u0627\u0686\u0645\u06cc" },
            { "zh_Hans", "\u0633\u0627\u062f\u0647 \u0686\u064a\u0646\u064a" },
            { "kok", "\u06a9\u0646\u06a9\u0646\u064a" },
            { "hil", "\u06be\u0644\u06cc\u06ab\u06cc\u0646\u0648\u0646" },
            { "type.nu.arabext", "\u063a\u0681\u06d0\u062f\u0644\u06d0 \u0639\u0631\u0628\u064a \u06d4 \u0627\u064a\u0646\u0689\u064a\u06a9 \u0639\u062f\u062f" },
            { "nus", "\u0646\u0648\u06cc\u0631" },
            { "dak", "\u062f\u0627\u06a9\u0648\u062a\u0627" },
            { "dar", "\u062f\u0631\u06af\u0648\u0627" },
            { "dav", "\u067c\u0627\u06cc\u067c\u0627" },
            { "lrc", "\u0634\u0645\u0627\u0644\u064a \u0644\u0648\u0631\u06cc" },
            { "zh_Hant", "\u062f\u0648\u062f\u064a\u0632\u0647 \u0686\u064a\u0646\u064a" },
            { "kpe", "\u06a9\u06cc\u0644\u064a" },
            { "ilo", "\u0627\u0644\u0648\u06a9\u0648" },
            { "mua", "\u0645\u0646\u062f\u0627\u0646\u06ab" },
            { "udm", "\u0627\u062f\u0645\u0648\u0631\u062a" },
            { "Khmr", metaValue_km },
            { "mul", "\u0685\u0648 \u0698\u0628\u0648" },
            { "mus", "\u06a9\u0631\u064a\u06a9\u064a" },
            { "gil", "\u06af\u0644\u0628\u0631\u062a\u064a" },
            { "sad", "\u0633\u0646\u0689\u0627\u0648\u06cc" },
            { "sah", "\u0633\u062e\u0627" },
            { "krc", "\u06a9\u0631\u0627\u0686\u06cc \u0628\u0627\u0644\u06a9\u0631" },
            { "inh", "\u0627\u0646\u06af\u0634" },
            { "saq", "\u0633\u0645\u0628\u0648\u0631\u0648" },
            { "krl", "\u06a9\u0627\u0631\u06cc\u0644\u06cc\u0646" },
            { "sat", "\u0633\u0646\u062a\u0627\u0644\u064a" },
            { "efi", "\u0627\u0641\u06a9" },
            { "kru", "\u06a9\u0648\u0631\u062e" },
            { "sba", "\u0646\u06ab\u0628\u0627\u06cc" },
            { "Guru", "\u06ab\u0631\u0648\u0645\u064a" },
            { "lua", "\u0644\u0628\u0627 \u0644\u0648\u0644\u0648\u0627" },
            { "ksb", "\u0634\u0645\u0628\u0644\u0627" },
            { "Telu", "\u062a\u06cc\u0644\u06cc\u06ab\u0648" },
            { "ksf", "\u0628\u0641\u06cc\u0627" },
        };
        return data;
    }
}
