/*
 * Copyright (c) 2012, 2022, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_es_US extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Cocos = new String[] {
               "hora de las Islas Cocos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "hora universal coordinada",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Macquarie = new String[] {
               "hora de la isla Macquarie",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] America_Eastern = new String[] {
               "hora est\u00e1ndar oriental",
               "EST",
               "hora de verano oriental",
               "EDT",
               "hora oriental",
               "ET",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "hora est\u00e1ndar de Haw\u00e1i-Aleutianas",
               "HAST",
               "hora de verano de Haw\u00e1i-Aleutianas",
               "HADT",
               "hora de Haw\u00e1i-Aleutianas",
               "HAT",
            };
        final String[] Indian_Ocean = new String[] {
               "hora del Oc\u00e9ano \u00cdndico",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] America_Pacific = new String[] {
               "hora est\u00e1ndar del Pac\u00edfico",
               "PST",
               "hora de verano del Pac\u00edfico",
               "PDT",
               "hora del Pac\u00edfico",
               "PT",
            };
        final String[] Phoenix_Islands = new String[] {
               "hora de las islas F\u00e9nix",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Western = new String[] {
               "hora est\u00e1ndar de Europa occidental",
               "\u2205\u2205\u2205",
               "hora de verano de Europa occidental",
               "\u2205\u2205\u2205",
               "hora de Europa occidental",
               "\u2205\u2205\u2205",
            };
        final String[] Solomon = new String[] {
               "hora de las Islas Salom\u00f3n",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "hora de la isla Norfolk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Marshall_Islands = new String[] {
               "hora de las Islas Marshall",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Eastern = new String[] {
               "hora est\u00e1ndar de Europa oriental",
               "\u2205\u2205\u2205",
               "hora de verano de Europa oriental",
               "\u2205\u2205\u2205",
               "hora de Europa oriental",
               "\u2205\u2205\u2205",
            };
        final String[] Atlantic = new String[] {
               "hora est\u00e1ndar del Atl\u00e1ntico",
               "AST",
               "hora de verano del Atl\u00e1ntico",
               "ADT",
               "hora del Atl\u00e1ntico",
               "AT",
            };
        final String[] Easter = new String[] {
               "hora est\u00e1ndar de la isla de Pascua",
               "",
               "hora de verano de la isla de Pascua",
               "",
               "hora de la isla de Pascua",
               "",
            };
        final String[] America_Central = new String[] {
               "hora est\u00e1ndar central",
               "CST",
               "hora de verano central",
               "CDT",
               "hora central",
               "CT",
            };
        final String[] Gilbert_Islands = new String[] {
               "hora de las islas Gilbert",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] America_Mountain = new String[] {
               "hora est\u00e1ndar de las Monta\u00f1as Rocosas",
               "MST",
               "hora de verano de las Monta\u00f1as Rocosas",
               "MDT",
               "hora de las Monta\u00f1as Rocosas",
               "MT",
            };
        final String[] Marquesas = new String[] {
               "hora de las islas Marquesas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "hora de la isla Wake",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Alaska = new String[] {
               "hora est\u00e1ndar de Alaska",
               "AKST",
               "hora de verano de Alaska",
               "AKDT",
               "hora de Alaska",
               "AKT",
            };
        final String[] Falkland = new String[] {
               "hora est\u00e1ndar de las islas Malvinas",
               "",
               "hora de verano de las islas Malvinas",
               "",
               "hora de las islas Malvinas",
               "",
            };
        final String[] Chamorro = new String[] {
               "hora de Chamorro",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Apia = new String[] {
               "hora est\u00e1ndar de Apia",
               "",
               "hora de verano de Apia",
               "",
               "hora de Apia",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu",
                new String[] {
                    "hora est\u00e1ndar de Haw\u00e1i-Aleutianas",
                    "HST",
                    "hora de verano de Haw\u00e1i-Aleutianas",
                    "HDT",
                    "hora de Haw\u00e1i-Aleutianas",
                    "HST",
                }
            },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "Europe/Bucharest", Europe_Eastern },
            { "UTC", ETC_UTC },
            { "America/Marigot", Atlantic },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "America/El_Salvador", America_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "Africa/Cairo", Europe_Eastern },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Guatemala", America_Central },
            { "PNT", America_Mountain },
            { "America/Cayman", America_Eastern },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Saipan", Chamorro },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "America/Ojinaga", America_Mountain },
            { "America/Tegucigalpa", America_Central },
            { "Asia/Damascus", Europe_Eastern },
            { "MIT", Apia },
            { "ART", Europe_Eastern },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "timezone.excity.Asia/Dushanbe", "Dusamb\u00e9" },
            { "Atlantic/Madeira", Europe_Western },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Grand_Turk", America_Eastern },
            { "AST", Alaska },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "Africa/Tripoli", Europe_Eastern },
            { "timezone.excity.Asia/Barnaul", "Barnaul" },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Europe/Lisbon", Europe_Western },
            { "PRT", Atlantic },
            { "CST6CDT", America_Central },
            { "Pacific/Easter", Easter },
            { "Atlantic/Canary", Europe_Western },
            { "SystemV/HST10",
                new String[] {
                    "hora est\u00e1ndar de Haw\u00e1i-Aleutianas",
                    "HST",
                    "hora de verano de Haw\u00e1i-Aleutianas",
                    "HDT",
                    "hora de Haw\u00e1i-Aleutianas",
                    "HST",
                }
            },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "America/Resolute", America_Central },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "timezone.excity.Europe/Kirov", "Kirov" },
            { "timezone.excity.America/Nassau", "Nassau" },
            { "PST", America_Pacific },
            { "SystemV/EST5", America_Eastern },
            { "America/Edmonton", America_Mountain },
            { "America/Santo_Domingo", Atlantic },
            { "America/Glace_Bay", Atlantic },
            { "Europe/Kiev", Europe_Eastern },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "America/Anguilla", Atlantic },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Cancun", America_Eastern },
            { "timezone.excity.America/Fort_Nelson", "Fort Nelson" },
            { "America/St_Lucia", Atlantic },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "America/Cambridge_Bay", America_Mountain },
            { "timezone.excity.America/St_Thomas", "St. Thomas" },
            { "America/Barbados", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "America/Detroit", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "America/Thule", Atlantic },
            { "America/Curacao", Atlantic },
            { "America/Martinique", Atlantic },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "SystemV/CST6CDT", America_Central },
            { "America/Tortola", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "America/Nome", Alaska },
            { "Indian/Chagos", Indian_Ocean },
            { "Europe/Tallinn", Europe_Eastern },
            { "America/Rainy_River", America_Central },
            { "SystemV/AST4", Atlantic },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Goose_Bay", Atlantic },
            { "America/Swift_Current", America_Central },
            { "America/Metlakatla", Alaska },
            { "America/Pangnirtung", America_Eastern },
            { "Europe/Sofia", Europe_Eastern },
            { "America/Indiana/Vincennes", America_Eastern },
            { "America/Whitehorse", America_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Antigua", Atlantic },
            { "America/Montreal", America_Eastern },
            { "timezone.excity.America/Sao_Paulo", "S\u00e3o Paulo" },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Antarctica/Macquarie", Macquarie },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Moncton", Atlantic },
            { "America/Indiana/Winamac", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "timezone.excity.Africa/Accra", "Acra" },
            { "PST8PDT", America_Pacific },
            { "America/Grenada", Atlantic },
            { "Atlantic/Faeroe", Europe_Western },
            { "America/Yakutat", Alaska },
            { "Indian/Cocos", Cocos },
            { "SystemV/YST9YDT", Alaska },
            { "America/Merida", America_Central },
            { "SystemV/MST7", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/Fort_Nelson", America_Mountain },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "SystemV/PST8PDT", America_Pacific },
            { "America/Boise", America_Mountain },
            { "EST5EDT", America_Eastern },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Wake", Wake },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "America/Shiprock", America_Mountain },
            { "America/Winnipeg", America_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "timezone.excity.Europe/Ulyanovsk", "Ulyanovsk" },
            { "Asia/Amman", Europe_Eastern },
            { "Etc/UTC", ETC_UTC },
            { "SystemV/AST4ADT", Atlantic },
            { "Pacific/Apia", Apia },
            { "CST", America_Central },
            { "America/Toronto", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "Pacific/Majuro", Marshall_Islands },
            { "America/Nassau", America_Eastern },
            { "timezone.excity.Europe/Astrakhan", "Astrakhan" },
            { "SST", Solomon },
            { "America/Jamaica", America_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "Atlantic/Stanley", Falkland },
            { "SystemV/CST6", America_Central },
        };
        return data;
    }
}
