/*
 * Copyright (c) 2012, 2022, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_kok extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "\u092e\u0927\u094d\u092f \u0906\u092b\u094d\u0930\u093f\u0915\u093e \u0935\u0947\u0933",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Paraguay = new String[] {
               "\u092a\u0930\u093e\u0917\u0941\u0906 \u092a\u094d\u0930\u092e\u093e\u0923\u093f\u0924 \u0935\u0947\u0933",
               "",
               "\u092a\u0930\u093e\u0917\u0941\u0906 \u0917\u094d\u0930\u0940\u0937\u094d\u092e \u0935\u0947\u0933",
               "",
               "\u092a\u0930\u093e\u0917\u0941\u0906 \u0935\u0947\u0933",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "\u0938\u092e\u0928\u094d\u0935\u093f\u0924 \u0935\u0948\u0936\u094d\u0935\u093f\u0915 \u0935\u0947\u0933",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] America_Eastern = new String[] {
               "\u0909\u0926\u0947\u0902\u0924 \u092a\u094d\u0930\u092e\u093e\u0923\u093f\u0924 \u0935\u0947\u0933",
               "",
               "\u0909\u0926\u0947\u0902\u0924\u0947\u091a\u094b \u0921\u0947\u0932\u093e\u092f\u091f \u0935\u0947\u0933",
               "",
               "\u0909\u0926\u0947\u0902\u0924 \u0935\u0947\u0933",
               "",
            };
        final String[] Africa_Eastern = new String[] {
               "\u0909\u0926\u0947\u0902\u0924 \u0906\u092b\u094d\u0930\u093f\u0915\u093e \u0935\u0947\u0933",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "\u0928\u094d\u092f\u0941\u092b\u093e\u0935\u0902\u0921\u0932\u0901\u0921 \u092a\u094d\u0930\u092e\u093e\u0923\u093f\u0924 \u0935\u0947\u0933",
               "",
               "\u0928\u094d\u092f\u0941\u092b\u093e\u0935\u0902\u0921\u0932\u0901\u0921 \u0921\u0947\u0932\u093e\u092f\u091f \u0935\u0947\u0933",
               "",
               "\u0928\u094d\u092f\u0941\u092b\u093e\u0935\u0902\u0921\u0932\u0901\u0921 \u0935\u0947\u0933",
               "",
            };
        final String[] Argentina_Western = new String[] {
               "\u0905\u0938\u094d\u0924\u0902\u0924 \u0905\u0930\u094d\u091c\u0947\u0902\u091f\u093f\u0928\u093e \u092a\u094d\u0930\u092e\u093e\u0923\u093f\u0924 \u0935\u0947\u0933",
               "",
               "\u0905\u0938\u094d\u0924\u0902\u0924 \u0905\u0930\u094d\u091c\u0947\u0902\u091f\u093f\u0928\u093e \u0917\u094d\u0930\u0940\u0937\u094d\u092e \u0935\u0947\u0933",
               "",
               "\u0905\u0938\u094d\u0924\u0902\u0924 \u0905\u0930\u094d\u091c\u0947\u0902\u091f\u093f\u0928\u093e \u0935\u0947\u0933",
               "",
            };
        final String[] Atlantic = new String[] {
               "\u0905\u091f\u0932\u093e\u0902\u091f\u0940\u0915 \u092a\u094d\u0930\u092e\u093e\u0923\u093f\u0924 \u0935\u0947\u0933",
               "",
               "\u0905\u091f\u0932\u093e\u0902\u091f\u0940\u0915 \u0921\u0947\u0932\u093e\u092f\u091f \u0935\u0947\u0933",
               "",
               "\u0905\u091f\u0932\u093e\u0902\u091f\u0940\u0915 \u0935\u0947\u0933",
               "",
            };
        final String[] Bolivia = new String[] {
               "\u092c\u094b\u0932\u093f\u0935\u094d\u0939\u093f\u092f\u093e \u0935\u0947\u0933",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "\u0938\u0947\u0902\u091f \u092a\u093f\u092f\u0930 \u0906\u0928\u0940 \u092e\u093f\u0915\u0932\u093e\u0928 \u092a\u094d\u0930\u092e\u093e\u0923\u093f\u0924 \u0935\u0947\u0933",
               "",
               "\u0938\u0947\u0902\u091f \u092a\u093f\u092f\u0930 \u0906\u0928\u0940 \u092e\u093f\u0915\u0932\u093e\u0928 \u0921\u0947\u0932\u093e\u092f\u091f \u0935\u0947\u0933",
               "",
               "\u0938\u0947\u0902\u091f \u092a\u093f\u092f\u0930 \u0906\u0928\u0940 \u092e\u093f\u0915\u0932\u093e\u0928 \u0935\u0947\u0933",
               "",
            };
        final String[] Africa_Southern = new String[] {
               "\u0926\u0915\u094d\u0937\u093f\u0923 \u0906\u092b\u094d\u0930\u093f\u0915\u093e \u092a\u094d\u0930\u092e\u093e\u0923\u093f\u0924 \u0935\u0947\u0933",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "\u0909\u0930\u0941\u0917\u094d\u0935\u0947 \u092a\u094d\u0930\u092e\u093e\u0923\u093f\u0924 \u0935\u0947\u0933",
               "",
               "\u0909\u0930\u0941\u0917\u094d\u0935\u0947 \u0917\u094d\u0930\u0940\u0937\u094d\u092e \u0935\u0947\u0933",
               "",
               "\u0909\u0930\u0941\u0917\u094d\u0935\u0947 \u0935\u0947\u0933",
               "",
            };
        final String[] America_Central = new String[] {
               "\u092e\u0927\u094d\u092f \u092a\u094d\u0930\u092e\u093e\u0923\u093f\u0924 \u0935\u0947\u0933",
               "",
               "\u092e\u0927\u094d\u092f \u0921\u0947\u0932\u093e\u092f\u091f \u0935\u0947\u0933",
               "",
               "\u092e\u0927\u094d\u092f \u0935\u0947\u0933",
               "",
            };
        final String[] Falkland = new String[] {
               "\u092b\u0949\u0915\u0932\u0901\u0921 \u0906\u092f\u0932\u0901\u0921\u094d\u0938 \u092a\u094d\u0930\u092e\u093e\u0923\u093f\u0924 \u0935\u0947\u0933",
               "",
               "\u092b\u0949\u0915\u0932\u0901\u0921 \u0906\u092f\u0932\u0901\u0921\u094d\u0938 \u0917\u094d\u0930\u0940\u0937\u094d\u092e \u0935\u0947\u0933",
               "",
               "\u092b\u0949\u0915\u0932\u0901\u0921 \u0906\u092f\u0932\u0901\u0921\u094d\u0938 \u0935\u0947\u0933",
               "",
            };
        final String[] Suriname = new String[] {
               "\u0938\u0941\u0930\u093f\u0928\u093e\u092e \u0935\u0947\u0933",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Amazon = new String[] {
               "\u0905\u092e\u0947\u091d\u094b\u0928 \u092a\u094d\u0930\u092e\u093e\u0923\u093f\u0924 \u0935\u0947\u0933",
               "",
               "\u0905\u092e\u0947\u091d\u094b\u0928 \u0917\u094d\u0930\u0940\u0937\u094d\u092e \u0935\u0947\u0933",
               "",
               "\u0905\u092e\u0947\u091d\u094b\u0928 \u0935\u0947\u0933",
               "",
            };
        final String[] Argentina = new String[] {
               "\u0905\u0930\u094d\u091c\u0947\u0902\u091f\u093f\u0928\u093e \u092a\u094d\u0930\u092e\u093e\u0923\u093f\u0924 \u0935\u0947\u0933",
               "",
               "\u0905\u0930\u094d\u091c\u0947\u0902\u091f\u093f\u0928\u093e \u0917\u094d\u0930\u0940\u0937\u094d\u092e \u0935\u0947\u0933",
               "",
               "\u0905\u0930\u094d\u091c\u0947\u0902\u091f\u093f\u0928\u093e \u0935\u0947\u0933",
               "",
            };
        final String[] Galapagos = new String[] {
               "\u0917\u093e\u0932\u093e\u092a\u093e\u0917\u094b\u0938 \u0935\u0947\u0933",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "\u0935\u0947\u0928\u0947\u091d\u0941\u090f\u0932\u093e \u0935\u0947\u0933",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "\u0939\u0935\u093e\u0908-\u0905\u0932\u0947\u092f\u0941\u0936\u093f\u0928 \u092a\u094d\u0930\u092e\u093e\u0923\u093f\u0924 \u0935\u0947\u0933",
               "",
               "\u0939\u0935\u093e\u0908-\u0905\u0932\u0947\u092f\u0941\u0936\u093f\u0928 \u0921\u0947\u0932\u093e\u092f\u091f \u0935\u0947\u0933",
               "",
               "\u0939\u0935\u093e\u0908-\u0905\u0932\u0947\u092f\u0941\u0936\u093f\u0928 \u0935\u0947\u0933",
               "",
            };
        final String[] America_Pacific = new String[] {
               "\u092a\u094d\u0930\u0936\u093e\u0902\u0924 \u092a\u094d\u0930\u092e\u093e\u0923\u093f\u0924 \u0935\u0947\u0933",
               "",
               "\u092a\u094d\u0930\u0936\u093e\u0902\u0924 \u0921\u0947\u0932\u093e\u092f\u091f \u0935\u0947\u0933",
               "",
               "\u092a\u094d\u0930\u0936\u093e\u0902\u0924 \u0935\u0947\u0933",
               "",
            };
        final String[] Guyana = new String[] {
               "\u0917\u0941\u092f\u093e\u0928\u093e \u0935\u0947\u0933",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mexico_Pacific = new String[] {
               "\u092e\u0947\u0915\u094d\u0938\u093f\u0915\u0928 \u092a\u094d\u0930\u0936\u093e\u0902\u0924 \u092a\u094d\u0930\u092e\u093e\u0923\u093f\u0924 \u0935\u0947\u0933",
               "",
               "\u092e\u0947\u0915\u094d\u0938\u093f\u0915\u0928 \u092a\u094d\u0930\u0936\u093e\u0902\u0924 \u0921\u0947\u0932\u093e\u092f\u091f \u0935\u0947\u0933",
               "",
               "\u092e\u0947\u0915\u094d\u0938\u093f\u0915\u0928 \u092a\u094d\u0930\u0936\u093e\u0902\u0924 \u0935\u0947\u0933",
               "",
            };
        final String[] Cuba = new String[] {
               "\u0915\u094d\u092f\u0941\u092c\u093e \u092a\u094d\u0930\u092e\u093e\u0923\u093f\u0924 \u0935\u0947\u0933",
               "",
               "\u0915\u094d\u092f\u0941\u092c\u093e \u0921\u0947\u0932\u093e\u092f\u091f \u0935\u0947\u0933",
               "",
               "\u0915\u094d\u092f\u0941\u092c\u093e \u0935\u0947\u0933",
               "",
            };
        final String[] Africa_Western = new String[] {
               "\u0905\u0938\u094d\u0924\u0902\u0924 \u0906\u092b\u094d\u0930\u093f\u0915\u093e \u092a\u094d\u0930\u092e\u093e\u0923\u093f\u0924 \u0935\u0947\u0933",
               "",
               "\u0905\u0938\u094d\u0924\u0902\u0924 \u0906\u092b\u094d\u0930\u093f\u0915\u093e \u0917\u094d\u0930\u0940\u0937\u094d\u092e \u0935\u0947\u0933",
               "",
               "\u0905\u0938\u094d\u0924\u0902\u0924 \u0906\u092b\u094d\u0930\u093f\u0915\u093e \u0935\u0947\u0933",
               "",
            };
        final String[] South_Georgia = new String[] {
               "\u0926\u0915\u094d\u0937\u093f\u0923 \u091c\u0949\u0930\u094d\u091c\u093f\u092f\u093e \u0935\u0947\u0933",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "\u0908\u0938\u094d\u091f\u0930 \u0906\u092f\u0932\u0901\u0921 \u092a\u094d\u0930\u092e\u093e\u0923\u093f\u0924 \u0935\u0947\u0933",
               "",
               "\u0908\u0938\u094d\u091f\u0930 \u0906\u092f\u0932\u0901\u0921 \u0917\u094d\u0930\u0940\u0937\u094d\u092e \u0935\u0947\u0933",
               "",
               "\u0908\u0938\u094d\u091f\u0930 \u0906\u092f\u0932\u0901\u0921 \u0935\u0947\u0933",
               "",
            };
        final String[] Mexico_Northwest = new String[] {
               "\u0935\u093e\u092f\u0935\u094d\u092f \u092e\u0947\u0915\u094d\u0938\u093f\u0915\u094b \u092a\u094d\u0930\u092e\u093e\u0923\u093f\u0924 \u0935\u0947\u0933",
               "",
               "\u0935\u093e\u092f\u0935\u094d\u092f \u092e\u0947\u0915\u094d\u0938\u093f\u0915\u094b \u0921\u0947\u0932\u093e\u092f\u091f \u0935\u0947\u0933",
               "",
               "\u0935\u093e\u092f\u0935\u094d\u092f \u092e\u0947\u0915\u094d\u0938\u093f\u0915\u094b \u0935\u0947\u0933",
               "",
            };
        final String[] Peru = new String[] {
               "\u092a\u0947\u0930\u0942 \u092a\u094d\u0930\u092e\u093e\u0923\u093f\u0924 \u0935\u0947\u0933",
               "",
               "\u092a\u0947\u0930\u0942 \u0917\u094d\u0930\u0940\u0937\u094d\u092e \u0935\u0947\u0933",
               "",
               "\u092a\u0947\u0930\u0942 \u0935\u0947\u0933",
               "",
            };
        final String[] Greenland_Western = new String[] {
               "\u0905\u0938\u094d\u0924\u0902\u0924 \u0917\u094d\u0930\u0940\u0928\u0932\u0901\u0921 \u092a\u094d\u0930\u092e\u093e\u0923\u093f\u0924 \u0935\u0947\u0933",
               "",
               "\u0905\u0938\u094d\u0924\u0902\u0924 \u0917\u094d\u0930\u0940\u0928\u0932\u0901\u0921 \u0917\u094d\u0930\u0940\u0937\u094d\u092e \u0935\u0947\u0933",
               "",
               "\u0905\u0938\u094d\u0924\u0902\u0924 \u0917\u094d\u0930\u0940\u0928\u0932\u0901\u0921 \u0935\u0947\u0933",
               "",
            };
        final String[] Ecuador = new String[] {
               "\u0907\u0915\u094d\u0935\u0947\u0921\u094b\u0930 \u0935\u0947\u0933",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Greenland_Eastern = new String[] {
               "\u0909\u0926\u0947\u0902\u0924 \u0917\u094d\u0930\u0940\u0928\u0932\u0901\u0921 \u092a\u094d\u0930\u092e\u093e\u0923\u093f\u0924 \u0935\u0947\u0933",
               "",
               "\u0909\u0926\u0947\u0902\u0924 \u0917\u094d\u0930\u0940\u0928\u0932\u0901\u0921 \u0917\u094d\u0930\u0940\u0937\u094d\u092e \u0935\u0947\u0933",
               "",
               "\u0909\u0926\u0947\u0902\u0924 \u0917\u094d\u0930\u0940\u0928\u0932\u0901\u0921 \u0935\u0947\u0933",
               "",
            };
        final String[] French_Guiana = new String[] {
               "\u092b\u094d\u0930\u0947\u0902\u091a \u0917\u092f\u093e\u0928\u093e \u0935\u0947\u0933",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Colombia = new String[] {
               "\u0915\u094b\u0932\u0902\u092c\u093f\u092f\u093e \u092a\u094d\u0930\u092e\u093e\u0923\u093f\u0924 \u0935\u0947\u0933",
               "",
               "\u0915\u094b\u0932\u0902\u092c\u093f\u092f\u093e \u0917\u094d\u0930\u0940\u0937\u094d\u092e \u0935\u0947\u0933",
               "",
               "\u0915\u094b\u0932\u0902\u092c\u093f\u092f\u093e",
               "",
            };
        final String[] Chile = new String[] {
               "\u091a\u093f\u0932\u0940 \u092a\u094d\u0930\u092e\u093e\u0923\u093f\u0924 \u0935\u0947\u0933",
               "",
               "\u091a\u093f\u0932\u0940 \u0917\u094d\u0930\u0940\u0937\u094d\u092e \u0935\u0947\u0933",
               "",
               "\u091a\u093f\u0932\u0940 \u0935\u0947\u0933",
               "",
            };
        final String[] America_Mountain = new String[] {
               "\u092a\u0930\u094d\u0935\u0924\u0940\u092f \u092a\u094d\u0930\u092e\u093e\u0923\u093f\u0924 \u0935\u0947\u0933",
               "",
               "\u092a\u0930\u094d\u0935\u0924\u0940\u092f \u0921\u0947\u0932\u093e\u092f\u091f \u0935\u0947\u0933",
               "",
               "\u092a\u0930\u094d\u0935\u0924\u0940\u092f \u0935\u0947\u0933",
               "",
            };
        final String[] Alaska = new String[] {
               "\u0905\u0932\u093e\u0938\u094d\u0915\u093e \u092a\u094d\u0930\u092e\u093e\u0923\u093f\u0924 \u0935\u0947\u0933",
               "",
               "\u0905\u0932\u093e\u0938\u094d\u0915\u093e \u0921\u0947\u0932\u093e\u092f\u091f \u0935\u0947\u0933",
               "",
               "\u0905\u0932\u093e\u0938\u094d\u0915\u093e \u0935\u0947\u0933",
               "",
            };
        final String[] Noronha = new String[] {
               "\u092b\u0930\u094d\u0928\u093e\u0902\u0921\u094b \u0926\u0940 \u0928\u094b\u0930\u094b\u0928\u094d\u0939\u093e \u092a\u094d\u0930\u092e\u093e\u0923\u093f\u0924 \u0935\u0947\u0933",
               "",
               "Vote \u092b\u0930\u094d\u0928\u093e\u0902\u0921\u094b \u0926\u0940 \u0928\u094b\u0930\u094b\u0928\u094d\u0939\u093e \u0917\u094d\u0930\u0940\u0937\u094d\u092e \u0935\u0947\u0933",
               "",
               "\u092b\u0930\u094d\u0928\u093e\u0902\u0921\u094b \u0926\u0940 \u0928\u094b\u0930\u094b\u0928\u094d\u0939\u093e \u0935\u0947\u0933",
               "",
            };
        final String[] Brasilia = new String[] {
               "\u092c\u094d\u0930\u093e\u091d\u093f\u0932\u093f\u092f\u093e \u092a\u094d\u0930\u092e\u093e\u0923\u093f\u0924 \u0935\u0947\u0933",
               "",
               "\u092c\u094d\u0930\u093e\u091d\u093f\u0932\u093f\u092f\u093e \u0917\u094d\u0930\u0940\u0937\u094d\u092e \u0935\u0947\u0933",
               "",
               "\u092c\u094d\u0930\u093e\u091d\u093f\u0932\u093f\u092f\u093e \u0935\u0947\u0933",
               "",
            };
        final String[] India = new String[] {
               "\u092d\u093e\u0930\u0924\u0940\u092f \u0938\u092e\u092f",
               "IST",
               "",
               "",
               "",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "UTC", ETC_UTC },
            { "America/Cuiaba", Amazon },
            { "timezone.excity.America/Phoenix", "\u092b\u093f\u0928\u093f\u0915\u094d\u0938" },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "timezone.excity.America/Antigua", "\u090f\u0901\u091f\u093f\u0917\u0941\u0906" },
            { "America/El_Salvador", America_Central },
            { "timezone.excity.America/Buenos_Aires", "\u092c\u094d\u092f\u0942\u0928\u0938 \u0906\u092f\u0930\u094d\u0938" },
            { "timezone.excity.America/Danmarkshavn", "\u0921\u0947\u0928\u094d\u092e\u093e\u0930\u094d\u0915\u0936\u0949\u0928" },
            { "timezone.excity.America/Anchorage", "\u0910\u0902\u0915\u0930\u091c" },
            { "Africa/Mbabane", Africa_Southern },
            { "America/Guatemala", America_Central },
            { "Europe/London",
                new String[] {
                    "",
                    "",
                    "\u092c\u094d\u0930\u093f\u091f\u093f\u0936 \u0917\u094d\u0930\u0940\u0937\u094d\u092e \u0935\u0947\u0933",
                    "",
                    "",
                    "",
                }
            },
            { "timezone.excity.America/Chihuahua", "\u091a\u093f\u0939\u0941\u0906\u0939\u0941\u0906" },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "timezone.excity.America/Indiana/Winamac", "\u0935\u093f\u0928\u093e\u092e\u0945\u0915, \u0907\u0902\u0921\u093f\u092f\u093e\u0928\u093e" },
            { "America/Managua", America_Central },
            { "timezone.excity.America/North_Dakota/Beulah", "\u092c\u094d\u092f\u0942\u0932\u094d\u0932\u093e\u0939, \u0909\u0924\u094d\u0924\u0930 \u0921\u093e\u0915\u094b\u091f\u093e" },
            { "America/Indiana/Petersburg", America_Eastern },
            { "America/Tegucigalpa", America_Central },
            { "timezone.excity.America/Recife", "\u0930\u0947\u0938\u0940\u092b" },
            { "America/Miquelon", Pierre_Miquelon },
            { "timezone.excity.America/Argentina/San_Juan", "\u0938\u093e\u0928 \u091c\u0941\u0906\u0928" },
            { "timezone.excity.America/Juneau", "\u091c\u0942\u0928\u094b" },
            { "America/Grand_Turk", America_Eastern },
            { "Africa/Kigali", Africa_Central },
            { "timezone.excity.America/El_Salvador", "\u090f\u0932 \u0938\u093e\u0932\u094d\u0935\u093e\u0921\u094b\u0930" },
            { "BET", Brasilia },
            { "America/Araguaina", Brasilia },
            { "timezone.excity.Pacific/Easter", "\u0908\u0938\u094d\u091f\u0930" },
            { "America/Argentina/Salta", Argentina },
            { "Indian/Comoro", Africa_Eastern },
            { "timezone.excity.America/Menominee", "\u092e\u0947\u0928\u094b\u092e\u093f\u0928\u0940" },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "timezone.excity.America/Glace_Bay", "\u0917\u094d\u0932\u0947\u0938 \u092c\u0947" },
            { "Pacific/Easter", Easter },
            { "timezone.excity.America/Kralendijk", "\u0915\u094d\u0930\u093e\u0932\u0947\u0928\u0921\u0940\u0915" },
            { "America/Manaus", Amazon },
            { "timezone.excity.America/Nome", "\u0928\u094b\u092e\u0947" },
            { "timezone.excity.America/Vancouver", "\u0935\u094d\u0939\u0901\u0915\u0941\u0935\u094d\u0939\u0930" },
            { "timezone.excity.America/Matamoros", "\u092e\u093e\u091f\u093e\u092e\u094b\u0930\u094b\u0938" },
            { "timezone.excity.America/Creston", "\u0915\u094d\u0930\u0947\u0938\u094d\u091f\u094b\u0928" },
            { "Africa/Asmera", Africa_Eastern },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "timezone.excity.America/Inuvik", "\u0907\u0928\u0941\u0935\u093f\u0915" },
            { "Africa/Malabo", Africa_Western },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "timezone.excity.America/St_Lucia", "\u0938\u0947\u0902\u091f \u0932\u0941\u0938\u0940\u092f\u093e" },
            { "timezone.excity.America/Indiana/Tell_City", "\u091f\u0947\u0932 \u0938\u093f\u091f\u0940, \u0907\u0902\u0921\u093f\u092f\u093e\u0928\u093e" },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "timezone.excity.America/Godthab", "\u0928\u0942\u0915" },
            { "America/Regina", America_Central },
            { "timezone.excity.America/Martinique", "\u092e\u093e\u0930\u094d\u091f\u093f\u0928\u093f\u0915" },
            { "America/Dawson_Creek", America_Mountain },
            { "America/St_Thomas", Atlantic },
            { "America/Anguilla", Atlantic },
            { "timezone.excity.America/Tegucigalpa", "\u0924\u0947\u0917\u0941\u0938\u093f\u0917\u0932\u094d\u092a\u093e" },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "timezone.excity.America/Edmonton", "\u090d\u0921\u092e\u094b\u0902\u091f\u0928" },
            { "timezone.excity.America/Lower_Princes", "\u0932\u094b\u0935\u0930 \u092a\u094d\u0930\u093f\u0902\u0938\u0947\u0938 \u0915\u094d\u0935\u093e\u0930\u094d\u091f\u0930" },
            { "timezone.excity.America/Dawson", "\u0921\u094c\u0938\u0928" },
            { "America/Barbados", Atlantic },
            { "timezone.excity.America/Miquelon", "\u092e\u093f\u0915\u094d\u0935\u0947\u0932\u094b\u0928" },
            { "timezone.excity.America/Guadeloupe", "\u0917\u094d\u0935\u093e\u0921\u0947\u0932\u094b\u092a" },
            { "America/Louisville", America_Eastern },
            { "timezone.excity.America/Jujuy", "\u091c\u0941\u091c\u0947\u092f" },
            { "timezone.excity.America/Fortaleza", "\u092b\u094b\u0930\u094d\u091f\u093e\u0932\u0947\u091d\u093e" },
            { "timezone.excity.America/Argentina/Ushuaia", "\u0909\u0936\u0941\u0906\u0907\u092f\u093e" },
            { "timezone.excity.America/North_Dakota/Center", "\u092e\u0927\u094d\u092f, \u0909\u0924\u094d\u0924\u0930 \u0921\u093e\u0915\u094b\u091f\u093e" },
            { "timezone.excity.America/Cayenne", "\u0915\u0947\u0907\u0928" },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "America/Sao_Paulo", Brasilia },
            { "timezone.excity.America/Belize", "\u092c\u0947\u0932\u093f\u091d" },
            { "America/Curacao", Atlantic },
            { "America/Guyana", Guyana },
            { "America/Guayaquil", Ecuador },
            { "America/Martinique", Atlantic },
            { "timezone.excity.America/Rainy_River", "\u092a\u093e\u0935\u0938\u093e\u0933\u0940 \u0928\u094d\u0939\u092f" },
            { "timezone.excity.America/Coral_Harbour", "\u0905\u0924\u093f\u0915\u094b\u0915\u0949\u0928" },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "timezone.excity.America/Adak", "\u0905\u0921\u093e\u0915" },
            { "timezone.excity.America/Toronto", "\u091f\u0949\u0930\u0902\u091f\u094b" },
            { "America/Port_of_Spain", Atlantic },
            { "timezone.excity.America/Montevideo", "\u092e\u094b\u0902\u091f\u0947\u0935\u094d\u0939\u093f\u0921\u093f\u092f\u094b" },
            { "timezone.excity.America/Metlakatla", "\u092e\u0947\u091f\u094d\u0932\u093e\u0915\u093e\u091f\u094d\u0932\u093e" },
            { "America/Cayenne", French_Guiana },
            { "Pacific/Galapagos", Galapagos },
            { "timezone.excity.America/Maceio", "\u092e\u093e\u0938\u093f\u092f\u094b" },
            { "timezone.excity.America/Pangnirtung", "\u092a\u0902\u0917\u0928\u093f\u0930\u094d\u091f\u0941\u0902\u0917" },
            { "timezone.excity.America/Guayaquil", "\u0917\u094d\u0935\u093e\u092f\u0947\u0915\u093f\u0932" },
            { "Africa/Ndjamena", Africa_Western },
            { "timezone.excity.America/St_Vincent", "\u0938\u0947\u0902\u091f \u0935\u093f\u0928\u094d\u0938\u0947\u0902\u091f" },
            { "America/Rainy_River", America_Central },
            { "timezone.excity.America/Panama", "\u092a\u0928\u093e\u092e\u093e" },
            { "SystemV/AST4", Atlantic },
            { "timezone.excity.America/Havana", "\u0939\u0935\u093e\u0928\u093e" },
            { "timezone.excity.America/Detroit", "\u0921\u0947\u091f\u094d\u0930\u0949\u0908\u091f" },
            { "America/Yellowknife", America_Mountain },
            { "America/Juneau", Alaska },
            { "CNT", Newfoundland },
            { "America/Indiana/Vevay", America_Eastern },
            { "timezone.excity.America/Grenada", "\u0917\u094d\u0930\u0947\u0928\u0945\u0921\u093e" },
            { "timezone.excity.America/La_Paz", "\u0932\u093e \u092a\u093e\u091d" },
            { "timezone.excity.America/Resolute", "\u0930\u093f\u0938\u094b\u0932\u094d\u092f\u0941\u091f" },
            { "timezone.excity.America/Argentina/Salta", "\u0938\u093e\u0932\u094d\u091f\u093e" },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "timezone.excity.America/Lima", "\u0932\u093f\u092e\u093e" },
            { "timezone.excity.America/North_Dakota/New_Salem", "\u0928\u094d\u092f\u0941 \u0938\u093e\u0932\u0947\u092e, \u0909\u0924\u094d\u0924\u0930 \u0921\u093e\u0915\u094b\u091f\u093e" },
            { "America/Metlakatla", Alaska },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Paramaribo", Suriname },
            { "timezone.excity.America/Indiana/Knox", "\u0928\u0949\u0915\u094d\u0938, \u0907\u0902\u0921\u093f\u092f\u093e\u0928\u093e" },
            { "timezone.excity.America/Porto_Velho", "\u092a\u094b\u0930\u094d\u091f\u094b \u0935\u0947\u0932\u094d\u0939\u094b" },
            { "America/Indiana/Vincennes", America_Eastern },
            { "timezone.excity.America/Paramaribo", "\u092a\u0930\u093e\u092e\u093e\u0930\u093f\u092c\u094b" },
            { "timezone.excity.America/Managua", "\u092e\u0945\u0928\u093e\u0917\u094d\u0935\u093e" },
            { "America/Kralendijk", Atlantic },
            { "timezone.excity.America/Ojinaga", "\u0913\u091c\u093f\u0928\u093e\u0917\u093e" },
            { "America/Antigua", Atlantic },
            { "timezone.excity.America/Sao_Paulo", "\u0938\u093e\u0913 \u092a\u093e\u0935\u0932\u094b" },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "timezone.excity.America/Montserrat", "\u092e\u0949\u0928\u094d\u091f\u0938\u0947\u0930\u093e\u091f" },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "timezone.excity.America/New_York", "\u0928\u094d\u092f\u0941 \u092f\u0949\u0930\u094d\u0915" },
            { "America/St_Vincent", Atlantic },
            { "PST8PDT", America_Pacific },
            { "timezone.excity.Etc/Unknown", "\u0905\u091c\u094d\u091e\u093e\u0924 \u0936\u093e\u0930" },
            { "timezone.excity.America/Thule", "\u0925\u0941\u0932\u0947" },
            { "timezone.excity.America/Grand_Turk", "\u0917\u094d\u0930\u0901\u0921 \u0924\u0941\u0930\u094d\u0915" },
            { "America/Yakutat", Alaska },
            { "timezone.excity.America/Indiana/Petersburg", "\u092a\u093f\u091f\u0930\u094d\u0938\u092c\u0930\u094d\u0917, \u0907\u0902\u0921\u093f\u092f\u093e\u0928\u093e" },
            { "timezone.excity.America/Winnipeg", "\u0935\u093f\u0928\u0940\u092a\u0947\u0917" },
            { "timezone.excity.America/Dawson_Creek", "\u0921\u094c\u0938\u0928 \u0915\u094d\u0930\u093f\u0915" },
            { "timezone.excity.America/Caracas", "\u0915\u0930\u093e\u0915\u0938" },
            { "timezone.excity.America/Bogota", "\u092c\u094b\u0917\u094b\u091f\u093e" },
            { "America/Mazatlan", Mexico_Pacific },
            { "timezone.excity.America/Blanc-Sablon", "\u092c\u094d\u0932\u093e\u0902\u0915-\u0938\u093e\u092c\u094d\u0932\u094b\u0928" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "\u0930\u093f\u092f\u094b \u0917\u0932\u0947\u0917\u0949\u0938" },
            { "SystemV/MST7", America_Mountain },
            { "America/Dominica", Atlantic },
            { "timezone.excity.America/Bahia", "\u092c\u0939\u093f\u092f\u093e" },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "timezone.excity.America/St_Kitts", "\u0938\u0947\u0902\u091f \u0915\u093f\u091f\u094d\u0938" },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "EST5EDT", America_Eastern },
            { "timezone.excity.America/Monterrey", "\u092e\u094b\u0902\u091f\u0947\u0930\u0940" },
            { "Atlantic/Bermuda", Atlantic },
            { "timezone.excity.Pacific/Galapagos", "\u0917\u093e\u0932\u093e\u092a\u093e\u0917\u094b\u0938" },
            { "timezone.excity.America/Belem", "\u092c\u0947\u0932\u0947\u092e" },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "timezone.excity.America/Argentina/Tucuman", "\u091f\u0941\u0915\u0941\u092e\u0945\u0928" },
            { "America/Indiana/Knox", America_Central },
            { "timezone.excity.America/Rio_Branco", "\u0930\u093f\u092f\u094b \u092c\u094d\u0930\u093e\u0902\u0915\u094b" },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/Maceio", Brasilia },
            { "CST", America_Central },
            { "Europe/Dublin",
                new String[] {
                    "",
                    "",
                    "\u0906\u092f\u0930\u093f\u0936 \u092a\u094d\u0930\u092e\u093e\u0923\u093f\u0924 \u0935\u0947\u0933",
                    "",
                    "",
                    "",
                }
            },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Atlantic/Stanley", Falkland },
            { "timezone.excity.America/Yellowknife", "\u092f\u0932\u094b\u0915\u094d\u0928\u093e\u092f\u092b" },
            { "timezone.excity.America/Puerto_Rico", "\u092a\u093f\u0930\u094d\u091f\u094b \u0930\u093f\u0915\u094b" },
            { "SystemV/CST6", America_Central },
            { "timezone.excity.America/Denver", "\u0921\u0947\u0928\u094d\u0935\u0947\u0930" },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "PNT", America_Mountain },
            { "America/Cayman", America_Eastern },
            { "timezone.excity.America/Port-au-Prince", "\u092a\u094b\u0930\u094d\u091f-\u0914-\u092a\u094d\u0930\u093f\u0928\u094d\u0938" },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "timezone.excity.America/Mexico_City", "\u092e\u0947\u0915\u094d\u0938\u093f\u0915\u094b \u0936\u093e\u0930" },
            { "timezone.excity.America/Curacao", "\u0915\u0941\u0930\u093e\u0915\u093e\u0913" },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Ojinaga", America_Mountain },
            { "timezone.excity.America/Guyana", "\u0917\u0941\u092f\u093e\u0928\u093e" },
            { "timezone.excity.America/Boise", "\u092c\u094b\u092f\u0938" },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "timezone.excity.America/Scoresbysund", "\u0907\u091f\u094b\u0915\u0949\u0930\u091f\u0949\u0930\u094d\u092e\u0940\u091f" },
            { "America/Argentina/Ushuaia", Argentina },
            { "timezone.excity.America/Indiana/Vevay", "\u0935\u0947\u0935\u092f, \u0907\u0902\u0921\u093f\u092f\u093e\u0928\u093e" },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "timezone.excity.America/Dominica", "\u0921\u094b\u092e\u093f\u0928\u0940\u0915\u093e" },
            { "timezone.excity.America/Swift_Current", "\u0938\u094d\u0935\u093f\u092b\u094d\u091f \u0915\u0930\u0902\u091f" },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "timezone.excity.America/Tortola", "\u091f\u094b\u0930\u091f\u094b\u0932\u093e" },
            { "America/Thunder_Bay", America_Eastern },
            { "timezone.excity.America/Catamarca", "\u0915\u093e\u091f\u093e\u092e\u093e\u0930\u0915\u093e" },
            { "timezone.excity.America/Port_of_Spain", "\u092a\u094b\u0930\u094d\u091f \u0911\u092b \u0938\u094d\u092a\u0947\u0928" },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "AST", Alaska },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "timezone.excity.America/Rankin_Inlet", "\u0930\u0901\u0915\u093f\u0928 \u0907\u0928\u0932\u0945\u091f" },
            { "timezone.excity.America/Santarem", "\u0938\u093e\u0902\u0924\u093e\u0930\u0947\u092e" },
            { "America/Mexico_City", America_Central },
            { "timezone.excity.America/Yakutat", "\u092f\u093e\u0915\u0941\u091f\u093e\u091f" },
            { "timezone.excity.America/Mendoza", "\u092e\u0947\u0928\u094d\u0921\u094b\u091d\u093e" },
            { "timezone.excity.America/Costa_Rica", "\u0915\u094b\u0938\u094d\u0924\u093e \u0930\u093f\u0915\u093e" },
            { "timezone.excity.America/Noronha", "\u0928\u094b\u0930\u094b\u0928\u094d\u0939\u093e" },
            { "timezone.excity.America/Nipigon", "\u0928\u093f\u092a\u093f\u0917\u094b\u0928" },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "timezone.excity.America/Argentina/San_Luis", "\u0938\u093e\u0928 \u0932\u0941\u0908\u0938" },
            { "timezone.excity.America/Araguaina", "\u0905\u0930\u0917\u0941\u092f\u0947\u0928\u093e" },
            { "Atlantic/South_Georgia", South_Georgia },
            { "PRT", Atlantic },
            { "timezone.excity.America/Cordoba", "\u0915\u094b\u0930\u0921\u094b\u092c\u093e" },
            { "timezone.excity.America/Cambridge_Bay", "\u0915\u0947\u0902\u092c\u094d\u0930\u093f\u091c \u092c\u0947" },
            { "timezone.excity.America/Bahia_Banderas", "\u092c\u0939\u093f\u092f\u093e \u092c\u0902\u0926\u0947\u0930\u0938" },
            { "CST6CDT", America_Central },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "timezone.excity.America/Campo_Grande", "\u0915\u0945\u092e\u094d\u092a\u094b \u0917\u094d\u0930\u093e\u0902\u0921" },
            { "America/Resolute", America_Central },
            { "timezone.excity.America/Nassau", "\u0928\u0938\u093e\u090a" },
            { "Africa/Kampala", Africa_Eastern },
            { "timezone.excity.America/Sitka", "\u0938\u093f\u091f\u094d\u0915\u093e" },
            { "PST", America_Pacific },
            { "SystemV/EST5", America_Eastern },
            { "timezone.excity.America/Santo_Domingo", "\u0938\u093e\u0902\u0924\u094b \u0921\u094b\u092e\u093f\u0902\u0917\u094b" },
            { "America/Edmonton", America_Mountain },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "timezone.excity.America/Aruba", "\u0905\u0930\u0941\u092c\u093e" },
            { "America/Glace_Bay", Atlantic },
            { "America/Port-au-Prince", America_Eastern },
            { "Europe/Belfast",
                new String[] {
                    "",
                    "",
                    "\u092c\u094d\u0930\u093f\u091f\u093f\u0936 \u0917\u094d\u0930\u0940\u0937\u094d\u092e \u0935\u0947\u0933",
                    "",
                    "",
                    "",
                }
            },
            { "America/St_Barthelemy", Atlantic },
            { "timezone.excity.America/Argentina/La_Rioja", "\u0932\u093e \u0930\u093f\u092f\u094b\u091c\u093e" },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "timezone.excity.America/St_Johns", "\u0938\u0947\u0902\u091f \u091c\u0949\u0928\u094d\u0938" },
            { "timezone.excity.America/St_Barthelemy", "\u0938\u0947\u0902\u091f \u092c\u093e\u0930\u094d\u0925\u0947\u0932\u0947\u092e\u0940" },
            { "timezone.excity.America/Santiago", "\u0938\u0901\u091f\u093f\u092f\u093e\u0917\u094b" },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Cancun", America_Eastern },
            { "timezone.excity.America/Fort_Nelson", "\u092b\u094b\u0930\u094d\u091f \u0928\u0947\u0932\u094d\u0938\u0928" },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Kinshasa", Africa_Western },
            { "America/Lima", Peru },
            { "timezone.excity.America/Indianapolis", "\u0907\u0902\u0921\u093f\u092f\u093e\u0928\u093e\u092a\u094b\u0932\u0940\u0938" },
            { "America/St_Lucia", Atlantic },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "timezone.excity.America/St_Thomas", "\u0938\u0947\u0902\u091f \u0925\u0949\u092e\u0938" },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "timezone.excity.America/Marigot", "\u092e\u0947\u0930\u0940\u0917\u0949\u091f" },
            { "Africa/Blantyre", Africa_Central },
            { "America/Detroit", America_Eastern },
            { "timezone.excity.America/Punta_Arenas", "\u092a\u0941\u0902\u091f\u093e \u0905\u0930\u0947\u0928\u093e\u0938" },
            { "timezone.excity.America/Kentucky/Monticello", "\u092e\u094b\u0902\u091f\u0940\u0938\u0945\u0932\u094b, \u0915\u0947\u0902\u091f\u0941\u0915\u093e\u092f" },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "America/Argentina/La_Rioja", Argentina },
            { "SystemV/CST6CDT", America_Central },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "timezone.excity.America/Indiana/Marengo", "\u092e\u093e\u0930\u0947\u0902\u0917\u094b, \u0907\u0902\u0921\u093f\u092f\u093e\u0928\u093e" },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Johannesburg", Africa_Southern },
            { "EAT", Africa_Eastern },
            { "Africa/Bangui", Africa_Western },
            { "timezone.excity.America/Cayman", "\u0915\u0948\u092e\u0947\u0928" },
            { "timezone.excity.America/Barbados", "\u092c\u093e\u0930\u092c\u093e\u0921\u094b\u0938" },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "America/Jujuy", Argentina },
            { "timezone.excity.America/Mazatlan", "\u092e\u093e\u091d\u093e\u091f\u094d\u0932\u093e\u0928" },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "timezone.excity.America/Whitehorse", "\u0935\u094d\u0939\u093e\u092f\u091f\u0939\u0949\u0930\u094d\u0938" },
            { "timezone.excity.America/Halifax", "\u0939\u0947\u0932\u093f\u092b\u0945\u0915\u094d\u0938" },
            { "timezone.excity.America/Merida", "\u092e\u0947\u0930\u093f\u0921\u093e" },
            { "America/Pangnirtung", America_Eastern },
            { "timezone.excity.America/Goose_Bay", "\u0917\u0942\u0938 \u092c\u0947" },
            { "timezone.excity.America/Eirunepe", "\u0908\u0930\u0941\u0928\u0947\u092a\u0947" },
            { "timezone.excity.America/Los_Angeles", "\u0932\u0949\u0938 \u090f\u0902\u091c\u0932\u0940\u0938" },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "timezone.excity.America/Cuiaba", "\u0915\u0941\u092f\u092f\u092c\u093e" },
            { "America/Montreal", America_Eastern },
            { "timezone.excity.America/Anguilla", "\u0905\u0902\u0917\u0941\u0932\u093e" },
            { "America/Argentina/San_Juan", Argentina },
            { "timezone.excity.America/Jamaica", "\u091c\u092e\u0948\u0915\u093e" },
            { "timezone.excity.America/Hermosillo", "\u0939\u0930\u094d\u092e\u094b\u0938\u093f\u0932\u094b" },
            { "America/Indiana/Winamac", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "timezone.excity.America/Manaus", "\u092e\u0928\u094c\u0938" },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "timezone.excity.America/Regina", "\u0930\u0947\u091c\u0940\u0928\u093e" },
            { "SystemV/YST9YDT", Alaska },
            { "America/Merida", America_Central },
            { "CAT", Africa_Central },
            { "America/St_Kitts", Atlantic },
            { "timezone.excity.America/Thunder_Bay", "\u0925\u0902\u0921\u0930 \u092c\u0947" },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "America/Guadeloupe", Atlantic },
            { "SystemV/PST8PDT", America_Pacific },
            { "timezone.excity.America/Louisville", "\u0932\u0941\u0908\u091c\u0935\u093f\u0932\u0947" },
            { "timezone.excity.America/Cancun", "\u0915\u093e\u0928\u0915\u0941\u0928" },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.America/Iqaluit", "\u0907\u0915\u093e\u0932\u0941\u092f\u0940\u091f" },
            { "America/Shiprock", America_Mountain },
            { "America/Winnipeg", America_Central },
            { "timezone.excity.Atlantic/Bermuda", "\u092c\u0930\u094d\u092e\u0941\u0921\u093e" },
            { "timezone.excity.America/Asuncion", "\u0905\u0938\u0902\u0938\u093f\u092f\u0928" },
            { "Etc/UTC", ETC_UTC },
            { "SystemV/AST4ADT", Atlantic },
            { "timezone.excity.America/Indiana/Vincennes", "\u0935\u093f\u0902\u0938\u0947\u0928\u0938, \u0907\u0902\u0921\u093f\u092f\u093e\u0928\u093e" },
            { "timezone.excity.America/Moncton", "\u092e\u094b\u0902\u0915\u094d\u091f\u0949\u0928" },
            { "America/Toronto", America_Eastern },
            { "timezone.excity.America/Guatemala", "\u0917\u094d\u0935\u093e\u091f\u0947\u092e\u093e\u0932\u093e" },
            { "timezone.excity.America/Boa_Vista", "\u092c\u093e\u0913 \u0935\u093f\u0938\u094d\u091f\u093e" },
            { "SystemV/EST5EDT", America_Eastern },
            { "timezone.excity.America/Tijuana", "\u0924\u093f\u091c\u0941\u0906\u0928\u093e" },
            { "timezone.excity.America/Chicago", "\u0936\u093f\u0915\u093e\u0917\u094b" },
        };
        return data;
    }
}
