/*
 * Copyright (c) 2012, 2022, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_lb extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "Zentralafrikanesch Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Moskauer Normalz\u00e4it",
               "",
               "Moskauer Summerz\u00e4it",
               "",
               "Moskauer Z\u00e4it",
               "",
            };
        final String[] Japan = new String[] {
               "Japanesch Normalz\u00e4it",
               "",
               "Japanesch Summerz\u00e4it",
               "",
               "Japanesch Z\u00e4it",
               "",
            };
        final String[] Pakistan = new String[] {
               "Pakistanesch Normalz\u00e4it",
               "",
               "Pakistanesch Summerz\u00e4it",
               "",
               "Pakistanesch Z\u00e4it",
               "",
            };
        final String[] Taipei = new String[] {
               "Taipei-Normalz\u00e4it",
               "",
               "Taipei-Summerz\u00e4it",
               "",
               "Taipei-Z\u00e4it",
               "",
            };
        final String[] Hovd = new String[] {
               "Hovd-Normalz\u00e4it",
               "",
               "Hovd-Summerz\u00e4it",
               "",
               "Hovd-Z\u00e4it",
               "",
            };
        final String[] Magadan = new String[] {
               "Magadan-Normalz\u00e4it",
               "",
               "Magadan-Summerz\u00e4it",
               "",
               "Magadan-Z\u00e4it",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Zentral-/Westaustralesch Normalz\u00e4it",
               "",
               "Zentral-/Westaustralesch Summerz\u00e4it",
               "",
               "Zentral-/Westaustralesch Z\u00e4it",
               "",
            };
        final String[] Europe_Central = new String[] {
               "M\u00ebtteleurop\u00e4esch Normalz\u00e4it",
               "",
               "M\u00ebtteleurop\u00e4esch Summerz\u00e4it",
               "",
               "M\u00ebtteleurop\u00e4esch Z\u00e4it",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Sakhalin-Normalz\u00e4it",
               "",
               "Sakhalin-Summerz\u00e4it",
               "",
               "Sakhalin-Z\u00e4it",
               "",
            };
        final String[] Paraguay = new String[] {
               "Paraguayanesch Normalz\u00e4it",
               "",
               "Paraguayanesch Summerz\u00e4it",
               "",
               "Paraguayanesch Z\u00e4it",
               "",
            };
        final String[] Acre = new String[] {
               "Acre-Normalz\u00e4it",
               "",
               "Acre-Summerz\u00e4it",
               "",
               "Acre-Z\u00e4it",
               "",
            };
        final String[] Malaysia = new String[] {
               "Malaysesch Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] America_Eastern = new String[] {
               "Nordamerikanesch Ostk\u00fcsten-Normalz\u00e4it",
               "",
               "Nordamerikanesch Ostk\u00fcsten-Summerz\u00e4it",
               "",
               "Nordamerikanesch Ostk\u00fcstenz\u00e4it",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Lord-Howe-Normalz\u00e4it",
               "",
               "Lord-Howe-Summerz\u00e4it",
               "",
               "Lord-Howe-Z\u00e4it",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Neis\u00e9iland-Normalz\u00e4it",
               "",
               "Neis\u00e9iland-Summerz\u00e4it",
               "",
               "Neis\u00e9iland-Z\u00e4it",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Indeschen Ozean-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Jakutsk-Normalz\u00e4it",
               "",
               "Jakutsk-Summerz\u00e4it",
               "",
               "Jakutsk-Z\u00e4it",
               "",
            };
        final String[] Mauritius = new String[] {
               "Mauritius-Normalz\u00e4it",
               "",
               "Mauritius-Summerz\u00e4it",
               "",
               "Mauritius-Z\u00e4it",
               "",
            };
        final String[] Africa_Eastern = new String[] {
               "Ostafrikanesch Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] East_Timor = new String[] {
               "Osttimor-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Salomoninselen-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kosrae = new String[] {
               "Kosrae-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Marshall_Islands = new String[] {
               "Marshallinselen-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Eastern = new String[] {
               "Osteurop\u00e4esch Normalz\u00e4it",
               "",
               "Osteurop\u00e4esch Summerz\u00e4it",
               "",
               "Osteurop\u00e4esch Z\u00e4it",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Neifundland-Normalz\u00e4it",
               "",
               "Neifundland-Summerz\u00e4it",
               "",
               "Neifundland-Z\u00e4it",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Afghanistan-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Hong-Kong-Normalz\u00e4it",
               "",
               "Hong-Kong-Summerz\u00e4it",
               "",
               "Hong-Kong-Z\u00e4it",
               "",
            };
        final String[] Argentina_Western = new String[] {
               "Westargentinesch Normalz\u00e4it",
               "",
               "Westargentinesch Summerz\u00e4it",
               "",
               "Westargentinesch Z\u00e4it",
               "",
            };
        final String[] Atlantic = new String[] {
               "Atlantik-Normalz\u00e4it",
               "",
               "Atlantik-Summerz\u00e4it",
               "",
               "Atlantik-Z\u00e4it",
               "",
            };
        final String[] Ponape = new String[] {
               "Ponape-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Bolivia = new String[] {
               "Bolivianesch Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Saint-Pierre-a-Miquelon-Normalz\u00e4it",
               "",
               "Saint-Pierre-a-Miquelon-Summerz\u00e4it",
               "",
               "Saint-Pierre-a-Miquelon-Z\u00e4it",
               "",
            };
        final String[] Indochina = new String[] {
               "Indochina-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Jekaterinbuerg-Normalz\u00e4it",
               "",
               "Jekaterinbuerg-Summerz\u00e4it",
               "",
               "Jekaterinbuerg-Z\u00e4it",
               "",
            };
        final String[] Maldives = new String[] {
               "Maldiven-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "Tahiti-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Israelesch Normalz\u00e4it",
               "",
               "Israelesch Summerz\u00e4it",
               "",
               "Israelesch Z\u00e4it",
               "",
            };
        final String[] Indonesia_Central = new String[] {
               "Zentralindonesesch Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Wallis-a-Futuna-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Africa_Southern = new String[] {
               "S\u00fcdafrikanesch Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Syowa = new String[] {
               "Syowa-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Linneninselen-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Usbekistan-Normalz\u00e4it",
               "",
               "Usbekistan-Summerz\u00e4it",
               "",
               "Usbekistan-Z\u00e4it",
               "",
            };
        final String[] Omsk = new String[] {
               "Omsk-Normalz\u00e4it",
               "",
               "Omsk-Summerz\u00e4it",
               "",
               "Omsk-Z\u00e4it",
               "",
            };
        final String[] Seychelles = new String[] {
               "Seychellen-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Uruguyanesch Normalz\u00e4it",
               "",
               "Uruguayanesch Summerz\u00e4it",
               "",
               "Uruguayanesch Z\u00e4it",
               "",
            };
        final String[] Nepal = new String[] {
               "Nepalesesch Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Ulaanbaatar-Normalz\u00e4it",
               "",
               "Ulaanbaatar-Summerz\u00e4it",
               "",
               "Ulaanbaatar-Z\u00e4it",
               "",
            };
        final String[] America_Central = new String[] {
               "Nordamerikanesch Inland-Normalz\u00e4it",
               "",
               "Nordamerikanesch Inland-Summerz\u00e4it",
               "",
               "Nordamerikanesch Inlandz\u00e4it",
               "",
            };
        final String[] Truk = new String[] {
               "Chuuk-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Niue = new String[] {
               "Niue-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Wake-Insel-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Falkland = new String[] {
               "Falklandinselen-Normalz\u00e4it",
               "",
               "Falklandinselen-Summerz\u00e4it",
               "",
               "Falklandinselen-Z\u00e4it",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Vanuatu-Normalz\u00e4it",
               "",
               "Vanuatu-Summerz\u00e4it",
               "",
               "Vanuatu-Z\u00e4it",
               "",
            };
        final String[] Novosibirsk = new String[] {
               "Nowosibirsk-Normalz\u00e4it",
               "",
               "Nowosibirsk-Summerz\u00e4it",
               "",
               "Nowosibirsk-Z\u00e4it",
               "",
            };
        final String[] Singapore = new String[] {
               "Singapur-Standardz\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azores = new String[] {
               "Azoren-Normalz\u00e4it",
               "",
               "Azoren-Summerz\u00e4it",
               "",
               "Azoren-Z\u00e4it",
               "",
            };
        final String[] Bhutan = new String[] {
               "Bhutan-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Suriname = new String[] {
               "Suriname-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nauru = new String[] {
               "Nauru-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnojarsk-Normalz\u00e4it",
               "",
               "Krasnojarsk-Summerz\u00e4it",
               "",
               "Krasnojarsk-Z\u00e4it",
               "",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Westkasachesch Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Myanmar = new String[] {
               "Myanmar-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Christmas = new String[] {
               "Chr\u00ebschtdagsinsel-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Amazon = new String[] {
               "Amazonas-Normalz\u00e4it",
               "",
               "Amazonas-Summerz\u00e4it",
               "",
               "Amazonas-Z\u00e4it",
               "",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Ostkasachesch Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Fiji = new String[] {
               "Fidschi-Normalz\u00e4it",
               "",
               "Fidschi-Summerz\u00e4it",
               "",
               "Fidschi-Z\u00e4it",
               "",
            };
        final String[] Reunion = new String[] {
               "R\u00e9union-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cocos = new String[] {
               "Kokosinselen-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Chatham-Normalz\u00e4it",
               "",
               "Chatham-Summerz\u00e4it",
               "",
               "Chatham-Z\u00e4it",
               "",
            };
        final String[] Vostok = new String[] {
               "Wostok-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Argentinesch Normalz\u00e4it",
               "",
               "Argentinesch Summerz\u00e4it",
               "",
               "Argentinesch Z\u00e4it",
               "",
            };
        final String[] Gambier = new String[] {
               "Gambier-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Kamtschatka-Normalz\u00e4it",
               "",
               "Kamtschatka-Summerz\u00e4it",
               "",
               "Kamtschatka-Z\u00e4it",
               "",
            };
        final String[] Tuvalu = new String[] {
               "Tuvalu-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Galapagos-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Macquarie = new String[] {
               "Macquarieinsel-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Venezuela-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Hawaii-Aleuten-Normalz\u00e4it",
               "",
               "Hawaii-Aleuten-Summerz\u00e4it",
               "",
               "Hawaii-Aleuten-Z\u00e4it",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Zentralaustralesch Normalz\u00e4it",
               "",
               "Zentralaustralesch Summerz\u00e4it",
               "",
               "Zentralaustralesch Z\u00e4it",
               "",
            };
        final String[] America_Pacific = new String[] {
               "Nordamerikanesch Westk\u00fcsten-Normalz\u00e4it",
               "",
               "Nordamerikanesch Westk\u00fcsten-Summerz\u00e4it",
               "",
               "Nordamerikanesch Westk\u00fcstenz\u00e4it",
               "",
            };
        final String[] Phoenix_Islands = new String[] {
               "Phoenixinselen-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Turkmenistan = new String[] {
               "Turkmenistan-Normalz\u00e4it",
               "",
               "Turkmenistan-Summerz\u00e4it",
               "",
               "Turkmenistan-Z\u00e4it",
               "",
            };
        final String[] Europe_Western = new String[] {
               "Westeurop\u00e4esch Normalz\u00e4it",
               "",
               "Westeurop\u00e4esch Summerz\u00e4it",
               "",
               "Westeurop\u00e4esch Z\u00e4it",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Kap-Verde-Normalz\u00e4it",
               "",
               "Kap-Verde-Summerz\u00e4it",
               "",
               "Kap-Verde-Z\u00e4it",
               "",
            };
        final String[] Norfolk = new String[] {
               "Norfolkinselen-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Guyana = new String[] {
               "Guyana-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Pitcairninselen-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Rothera-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Samoa-Normalz\u00e4it",
               "",
               "Samoa-Summerz\u00e4it",
               "",
               "Samoa-Z\u00e4it",
               "",
            };
        final String[] Palau = new String[] {
               "Palau-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "Aserbeidschanesch Normalz\u00e4it",
               "",
               "Aserbaidschanesch Summerz\u00e4it",
               "",
               "Aserbaidschanesch Z\u00e4it",
               "",
            };
        final String[] Mawson = new String[] {
               "Mawson-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mexico_Pacific = new String[] {
               "Mexikanesch Pazifik-Normalz\u00e4it",
               "",
               "Mexikanesch Pazifik-Summerz\u00e4it",
               "",
               "Mexikanesch Pazifikz\u00e4it",
               "",
            };
        final String[] Davis = new String[] {
               "Davis-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cuba = new String[] {
               "Kubanesch Normalz\u00e4it",
               "",
               "Kubanesch Summerz\u00e4it",
               "",
               "Kubanesch Z\u00e4it",
               "",
            };
        final String[] Africa_Western = new String[] {
               "Westafrikanesch Normalz\u00e4it",
               "",
               "Westafrikanesch Summerz\u00e4it",
               "",
               "Westafrikanesch Z\u00e4it",
               "",
            };
        final String[] GMT = new String[] {
               "M\u00ebttler Greenwich-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Philippines = new String[] {
               "Philippinnesch Normalz\u00e4it",
               "",
               "Philippinnesch Summerz\u00e4it",
               "",
               "Philippinnesch Z\u00e4it",
               "",
            };
        final String[] French_Southern = new String[] {
               "Frans\u00e9isch S\u00fcd- an Antarktisgebidder-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] South_Georgia = new String[] {
               "S\u00fcdgeorgesch Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Neikaledonesch Normalz\u00e4it",
               "",
               "Neikaledonesch Summerz\u00e4it",
               "",
               "Neikaledonesch Z\u00e4it",
               "",
            };
        final String[] Volgograd = new String[] {
               "Wolgograd-Normalz\u00e4it",
               "",
               "Wolgograd-Summerz\u00e4it",
               "",
               "Wolgograd-Z\u00e4it",
               "",
            };
        final String[] Brunei = new String[] {
               "Brunei-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Iran = new String[] {
               "Iranesch Normalz\u00e4it",
               "",
               "Iranesch Summerz\u00e4it",
               "",
               "Iranesch Z\u00e4it",
               "",
            };
        final String[] EMPTY_ZONE = new String[] {
               "",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Ouschterinsel-Normalz\u00e4it",
               "",
               "Ouschterinsel-Summerz\u00e4it",
               "",
               "Ouschterinsel-Z\u00e4it",
               "",
            };
        final String[] Mexico_Northwest = new String[] {
               "Nordwest-Mexiko-Normalz\u00e4it",
               "",
               "Nordwest-Mexiko-Summerz\u00e4it",
               "",
               "Nordwest-Mexiko-Z\u00e4it",
               "",
            };
        final String[] DumontDUrville = new String[] {
               "Dumont-d\u2019Urville-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Tadschikistan-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Tonganesch Normalz\u00e4it",
               "",
               "Tonganesch Summerz\u00e4it",
               "",
               "Tonganesch Z\u00e4it",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Bangladesch-Normalz\u00e4it",
               "",
               "Bangladesch-Summerz\u00e4it",
               "",
               "Bangladesch-Z\u00e4it",
               "",
            };
        final String[] Peru = new String[] {
               "Peruanesch Normalz\u00e4it",
               "",
               "Peruanesch Summerz\u00e4it",
               "",
               "Peruanesch Z\u00e4it",
               "",
            };
        final String[] Greenland_Western = new String[] {
               "Westgr\u00f6nland-Normalz\u00e4it",
               "",
               "Westgr\u00f6nland-Summerz\u00e4it",
               "",
               "Westgr\u00f6nland-Z\u00e4it",
               "",
            };
        final String[] Ecuador = new String[] {
               "Ecuadorianesch Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Greenland_Eastern = new String[] {
               "Ostgr\u00f6nland-Normalz\u00e4it",
               "",
               "Ostgr\u00f6nland-Summerz\u00e4it",
               "",
               "Ostgr\u00f6nland-Z\u00e4it",
               "",
            };
        final String[] Gulf = new String[] {
               "Golf-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Ostindonesesch Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Korea = new String[] {
               "Koreanesch Normalz\u00e4it",
               "",
               "Koreanesch Summerz\u00e4it",
               "",
               "Koreanesch Z\u00e4it",
               "",
            };
        final String[] Australia_Western = new String[] {
               "Westaustralesch Normalz\u00e4it",
               "",
               "Westaustralesch Summerz\u00e4it",
               "",
               "Westaustralesch Z\u00e4it",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Kirgisistan-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Indonesia_Western = new String[] {
               "Westindonesesch Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Eastern = new String[] {
               "Ostaustralesch Normalz\u00e4it",
               "",
               "Ostaustralesch Summerz\u00e4it",
               "",
               "Ostaustralesch Z\u00e4it",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Frans\u00e9isch-Guayane-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Colombia = new String[] {
               "Kolumbianesch Normalz\u00e4it",
               "",
               "Kolumbianesch Summerz\u00e4it",
               "",
               "Kolumbianesch Z\u00e4it",
               "",
            };
        final String[] Chile = new String[] {
               "Chilenesch Normalz\u00e4it",
               "",
               "Chilenesch Summerz\u00e4it",
               "",
               "Chilenesch Z\u00e4it",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Gilbert-Inselen-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Rocky-Mountain-Normalz\u00e4it",
               "",
               "Rocky-Mountain-Summerz\u00e4it",
               "",
               "Rocky-Mountain-Z\u00e4it",
               "",
            };
        final String[] Marquesas = new String[] {
               "Marquesas-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Arabesch Normalz\u00e4it",
               "",
               "Arabesch Summerz\u00e4it",
               "",
               "Arabesch Z\u00e4it",
               "",
            };
        final String[] Alaska = new String[] {
               "Alaska-Normalz\u00e4it",
               "",
               "Alaska-Summerz\u00e4it",
               "",
               "Alaska-Z\u00e4it",
               "",
            };
        final String[] Vladivostok = new String[] {
               "Wladiwostok-Normalz\u00e4it",
               "",
               "Wladiwostok-Summerz\u00e4it",
               "",
               "Wladiwostok-Z\u00e4it",
               "",
            };
        final String[] Chamorro = new String[] {
               "Chamorro-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Irkutsk-Normalz\u00e4it",
               "",
               "Irkutsk-Summerz\u00e4it",
               "",
               "Irkutsk-Z\u00e4it",
               "",
            };
        final String[] Georgia = new String[] {
               "Georgesch Normalz\u00e4it",
               "",
               "Georgesch Summerz\u00e4it",
               "",
               "Georgesch Z\u00e4it",
               "",
            };
        final String[] Tokelau = new String[] {
               "Tokelau-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Papua-Neiguinea-Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Noronha = new String[] {
               "Fernando-de-Noronha-Normalz\u00e4it",
               "",
               "Fernando-de-Noronha-Summerz\u00e4it",
               "",
               "Fernando-de-Noronha-Z\u00e4it",
               "",
            };
        final String[] Choibalsan = new String[] {
               "Choibalsan-Normalz\u00e4it",
               "",
               "Choibalsan-Summerz\u00e4it",
               "",
               "Choibalsan-Z\u00e4it",
               "",
            };
        final String[] Brasilia = new String[] {
               "Bras\u00edlia-Normalz\u00e4it",
               "",
               "Bras\u00edlia-Summerz\u00e4it",
               "",
               "Bras\u00edlia-Z\u00e4it",
               "",
            };
        final String[] China = new String[] {
               "Chinesesch Normalz\u00e4it",
               "",
               "Chinesesch Summerz\u00e4it",
               "",
               "Chinesesch Z\u00e4it",
               "",
            };
        final String[] Armenia = new String[] {
               "Armenesch Normalz\u00e4it",
               "",
               "Armenesch Summerz\u00e4it",
               "",
               "Armenesch Z\u00e4it",
               "",
            };
        final String[] Anadyr = new String[] {
               "Anadyr-Normalz\u00e4it",
               "",
               "Anadyr-Summerz\u00e4it",
               "",
               "Anadyr-Z\u00e4it",
               "",
            };
        final String[] Samara = new String[] {
               "Samara-Normalz\u00e4it",
               "",
               "Samara-Summerz\u00e4it",
               "",
               "Samara-Z\u00e4it",
               "",
            };
        final String[] India = new String[] {
               "Indesch Z\u00e4it",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cook = new String[] {
               "Cookinselen-Normalz\u00e4it",
               "",
               "Cookinselen-Summerz\u00e4it",
               "",
               "Cookinselen-Z\u00e4it",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", EMPTY_ZONE },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London",
                new String[] {
                    "M\u00ebttler Greenwich-Z\u00e4it",
                    "",
                    "Britesch Summerz\u00e4it",
                    "",
                    "",
                    "",
                }
            },
            { "timezone.excity.Antarctica/Vostok", "Wostok" },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "JST", Japan },
            { "timezone.excity.Pacific/Fiji", "Fidschi" },
            { "timezone.excity.Asia/Kamchatka", "Kamtschatka" },
            { "Europe/Warsaw", Europe_Central },
            { "Pacific/Yap", Truk },
            { "timezone.excity.Asia/Yakutsk", "Jakutsk" },
            { "timezone.excity.Africa/Djibouti", "Dschibuti" },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "America/Eirunepe", Acre },
            { "America/Miquelon", Pierre_Miquelon },
            { "Europe/Luxembourg", Europe_Central },
            { "timezone.excity.Asia/Tashkent", "Taschkent" },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "timezone.excity.Africa/Addis_Ababa", "Addis Abeba" },
            { "timezone.excity.Asia/Dushanbe", "Duschanbe" },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", America_Eastern },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "timezone.excity.America/El_Salvador", "Salvador" },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "BET", Brasilia },
            { "America/Araguaina", Brasilia },
            { "timezone.excity.Pacific/Easter", "Ouschterinsel" },
            { "ACT", Australia_Central },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "Antarctica/Syowa", Syowa },
            { "Indian/Reunion", Reunion },
            { "Pacific/Palau", Palau },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Central },
            { "Asia/Karachi", Pakistan },
            { "timezone.excity.Atlantic/Canary", "Kanaresch Inselen" },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Etc/GMT", GMT },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "timezone.excity.Asia/Krasnoyarsk", "Krasnojarsk" },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Pacific/Tahiti", Tahiti },
            { "timezone.excity.Asia/Yerevan", "Erivan" },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "timezone.excity.Africa/Cairo", "Kairo" },
            { "AET", Australia_Eastern },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "timezone.excity.Europe/Warsaw", "Warschau" },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Dili", East_Timor },
            { "Africa/Bamako", GMT },
            { "Pacific/Wallis", Wallis },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "Asia/Choibalsan", Choibalsan },
            { "timezone.excity.Africa/Sao_Tome", "S\u00e3o Tom\u00e9" },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "timezone.excity.Europe/Vatican", "Vatikan" },
            { "timezone.excity.Asia/Tbilisi", "Tiflis" },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Chatham", Chatham },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Guayaquil", Ecuador },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "timezone.excity.Asia/Baghdad", "Bagdad" },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Ndjamena", Africa_Western },
            { "timezone.excity.Atlantic/South_Georgia", "S\u00fcdgeorgien" },
            { "Pacific/Fiji", Fiji },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "SystemV/AST4", Atlantic },
            { "timezone.excity.America/Havana", "Havanna" },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "CNT", Newfoundland },
            { "America/Indiana/Vevay", America_Eastern },
            { "timezone.excity.Europe/Volgograd", "Wolgograd" },
            { "timezone.excity.Europe/Rome", "Roum" },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "timezone.excity.Asia/Muscat", "Muskat" },
            { "timezone.excity.Africa/Tripoli", "Tripoli" },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "timezone.excity.Asia/Pyongyang", "Pj\u00f6ngjang" },
            { "timezone.excity.Africa/El_Aaiun", "El Aai\u00fan" },
            { "Australia/Adelaide", Australia_Central },
            { "timezone.excity.Europe/Bucharest", "Bukarest" },
            { "America/Metlakatla", Alaska },
            { "timezone.excity.Europe/Athens", "Athen" },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Paramaribo", Suriname },
            { "Asia/Qostanay", Kazakhstan_Eastern },
            { "Europe/Simferopol", Moscow },
            { "timezone.excity.Asia/Bishkek", "Bischkek" },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "America/Kralendijk", Atlantic },
            { "Antarctica/Troll", GMT },
            { "timezone.excity.Europe/Zurich", "Z\u00fcrech" },
            { "Europe/Samara", Samara },
            { "Indian/Christmas", Christmas },
            { "America/Antigua", Atlantic },
            { "NET", Armenia },
            { "Pacific/Gambier", Gambier },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "America/Moncton", Atlantic },
            { "timezone.excity.Europe/Copenhagen", "Kopenhagen" },
            { "Africa/Gaborone", Africa_Central },
            { "Asia/Pyongyang", Korea },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "timezone.excity.Africa/Accra", "Accra" },
            { "PST8PDT", America_Pacific },
            { "timezone.excity.Etc/Unknown", "Onbekannt" },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Western },
            { "timezone.excity.Asia/Riyadh", "Riad" },
            { "America/Yakutat", Alaska },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "timezone.excity.Europe/Uzhgorod", "Uschgorod" },
            { "timezone.excity.Asia/Damascus", "Damaskus" },
            { "Pacific/Pitcairn", Pitcairn },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "Europe/Tirane", Europe_Central },
            { "SystemV/MST7", America_Mountain },
            { "timezone.excity.Africa/Algiers", "Alger" },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "timezone.excity.Africa/Khartoum", "Khartum" },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "timezone.excity.Asia/Tehran", "Teheran" },
            { "America/Santarem", Brasilia },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "timezone.excity.Africa/Dar_es_Salaam", "Dar es Salaam" },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Wake", Wake },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Asia/Chongqing", China },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "timezone.excity.Asia/Saigon", "Ho-Chi-Minh-Stad" },
            { "PLT", Pakistan },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Accra", GMT },
            { "America/Maceio", Brasilia },
            { "Pacific/Niue", Niue },
            { "timezone.excity.Asia/Yekaterinburg", "Jekaterinbuerg" },
            { "CST", America_Central },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "M\u00ebttler Greenwich-Z\u00e4it",
                    "",
                    "Iresch Summerz\u00e4it",
                    "",
                    "",
                    "",
                }
            },
            { "Pacific/Truk", Truk },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "SST", Solomon },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "timezone.excity.Europe/Belgrade", "Belgrad" },
            { "SystemV/CST6", America_Central },
            { "timezone.excity.Asia/Calcutta", "Kalkutta" },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "CTT", China },
            { "timezone.excity.Asia/Aqtobe", "Aqt\u00f6be" },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "America/Aruba", Atlantic },
            { "timezone.excity.Europe/Luxembourg", "L\u00ebtzebuerg" },
            { "America/North_Dakota/Center", America_Central },
            { "PNT", America_Mountain },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "timezone.excity.Asia/Hong_Kong", "Hong Kong" },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "BST", Bangladesh },
            { "America/Tijuana", America_Pacific },
            { "timezone.excity.America/Mexico_City", "Mexiko-Stad" },
            { "Pacific/Saipan", Chamorro },
            { "SystemV/YST9", Gambier },
            { "timezone.excity.America/Curacao", "Cura\u00e7ao" },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "timezone.excity.Europe/Lisbon", "Lissabon" },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "timezone.excity.Europe/Zaporozhye", "Saporischschja" },
            { "Asia/Baku", Azerbaijan },
            { "ART", Europe_Eastern },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Asia/Taipei", Taipei },
            { "Antarctica/South_Pole", New_Zealand },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "America/Thunder_Bay", America_Eastern },
            { "timezone.excity.America/Port_of_Spain", "Port-of-Spain" },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "AST", Alaska },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Vientiane", Indochina },
            { "timezone.excity.Asia/Sakhalin", "Sachalin" },
            { "Pacific/Kiritimati", Line_Islands },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Asia/Harbin", China },
            { "PRT", Atlantic },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "timezone.excity.Africa/Mogadishu", "Mogadischu" },
            { "timezone.excity.Asia/Jayapura", "Port Numbay" },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "America/Resolute", America_Central },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "timezone.excity.Asia/Qatar", "Katar" },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "PST", America_Pacific },
            { "SystemV/EST5", America_Eastern },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "timezone.excity.Europe/Moscow", "Moskau" },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Moscow },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "timezone.excity.Asia/Taipei", "Taipeh" },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "SystemV/PST8", Pitcairn },
            { "America/Port-au-Prince", America_Eastern },
            { "Europe/Belfast",
                new String[] {
                    "M\u00ebttler Greenwich-Z\u00e4it",
                    "",
                    "Britesch Summerz\u00e4it",
                    "",
                    "",
                    "",
                }
            },
            { "America/St_Barthelemy", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "timezone.excity.America/St_Barthelemy", "Saint-Barth\u00e9lemy" },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Cancun", America_Eastern },
            { "Africa/Maseru", Africa_Southern },
            { "Pacific/Kosrae", Kosrae },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Europe/Volgograd", Volgograd },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Rio_Branco", Acre },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "timezone.excity.Asia/Vladivostok", "Wladiwostok" },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "timezone.excity.Asia/Macau", "Macau" },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "SystemV/CST6CDT", America_Central },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "timezone.excity.Asia/Novosibirsk", "Nowosibirsk" },
            { "Asia/Kamchatka", Kamchatka },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "NST", New_Zealand },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Johannesburg", Africa_Southern },
            { "EAT", Africa_Eastern },
            { "Africa/Bangui", Africa_Western },
            { "timezone.excity.Asia/Singapore", "Singapur" },
            { "Europe/Belgrade", Europe_Central },
            { "timezone.excity.Europe/Vienna", "Wien" },
            { "Africa/Bissau", GMT },
            { "timezone.excity.America/Cayman", "Kaimaninselen" },
            { "Asia/Tehran", Iran },
            { "timezone.excity.Asia/Nicosia", "Nikosia" },
            { "timezone.excity.Europe/Kiev", "Kiew" },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "timezone.excity.Asia/Tokyo", "Tokio" },
            { "Asia/Saigon", Indochina },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "timezone.excity.Atlantic/Faeroe", "F\u00e4r\u00f6er" },
            { "Africa/Timbuktu", GMT },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "timezone.excity.Atlantic/Cape_Verde", "Kap Verde" },
            { "Asia/Katmandu", Nepal },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Tbilisi", Georgia },
            { "ECT", Europe_Central },
            { "timezone.excity.Atlantic/Azores", "Azoren" },
            { "America/Montreal", America_Eastern },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "timezone.excity.America/Jamaica", "Jamaika" },
            { "timezone.excity.Indian/Reunion", "R\u00e9union" },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "Europe/Bratislava", Europe_Central },
            { "timezone.excity.Indian/Christmas", "Chr\u00ebschtdagsinsel" },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "Pacific/Tongatapu", Tonga },
            { "SystemV/YST9YDT", Alaska },
            { "America/Merida", America_Central },
            { "CAT", Africa_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Indian/Kerguelen", French_Southern },
            { "SystemV/PST8PDT", America_Pacific },
            { "timezone.excity.Africa/Ouagadougou", "Wagadugu" },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Anadyr },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Shiprock", America_Mountain },
            { "timezone.excity.Europe/Tirane", "Tirana" },
            { "America/Winnipeg", America_Central },
            { "timezone.excity.Europe/Prague", "Prag" },
            { "timezone.excity.Atlantic/Bermuda", "Bermudas" },
            { "Europe/Vatican", Europe_Central },
            { "timezone.excity.America/Asuncion", "Asunci\u00f3n" },
            { "Asia/Amman", Europe_Eastern },
            { "SystemV/AST4ADT", Atlantic },
            { "timezone.excity.Europe/Chisinau", "Kischinau" },
            { "America/Toronto", America_Eastern },
            { "Asia/Singapore", Singapore },
            { "timezone.excity.Europe/Brussels", "Br\u00e9issel" },
            { "Australia/Lindeman", Australia_Eastern },
            { "timezone.excity.Indian/Comoro", "Komoren" },
            { "SystemV/EST5EDT", America_Eastern },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "timezone.excity.Europe/Vilnius", "Wilna" },
            { "Europe/Monaco", Europe_Central },
            { "timezone.excity.Indian/Maldives", "Maldiven" },
        };
        return data;
    }
}
