/*
 * Copyright (c) 2012, 2022, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class CurrencyNames_lo extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final Object[][] data = new Object[][] {
            { "AED", "AED" },
            { "AFN", "AFN" },
            { "ALL", "ALL" },
            { "AMD", "AMD" },
            { "ANG", "ANG" },
            { "AOA", "AOA" },
            { "ARS", "ARS" },
            { "AWG", "AWG" },
            { "AZN", "AZN" },
            { "BAM", "BAM" },
            { "BBD", "BBD" },
            { "BDT", "BDT" },
            { "BGN", "BGN" },
            { "BHD", "BHD" },
            { "BIF", "BIF" },
            { "BMD", "BMD" },
            { "BND", "BND" },
            { "BOB", "BOB" },
            { "BSD", "BSD" },
            { "BTN", "BTN" },
            { "BWP", "BWP" },
            { "BYN", "BYN" },
            { "BYR", "BYR" },
            { "BZD", "BZD" },
            { "CDF", "CDF" },
            { "CHF", "CHF" },
            { "CLP", "CLP" },
            { "CRC", "CRC" },
            { "CUC", "CUC" },
            { "CUP", "CUP" },
            { "CVE", "CVE" },
            { "CZK", "CZK" },
            { "DJF", "DJF" },
            { "DKK", "DKK" },
            { "DOP", "DOP" },
            { "DZD", "DZD" },
            { "EGP", "EGP" },
            { "ERN", "ERN" },
            { "ETB", "ETB" },
            { "FJD", "FJD" },
            { "FKP", "FKP" },
            { "GEL", "GEL" },
            { "GHS", "GHS" },
            { "GIP", "GIP" },
            { "GMD", "GMD" },
            { "GNF", "GNF" },
            { "GTQ", "GTQ" },
            { "GYD", "GYD" },
            { "HNL", "HNL" },
            { "HRK", "HRK" },
            { "HTG", "HTG" },
            { "HUF", "HUF" },
            { "IDR", "IDR" },
            { "IQD", "IQD" },
            { "IRR", "IRR" },
            { "ISK", "ISK" },
            { "JMD", "JMD" },
            { "JOD", "JOD" },
            { "KES", "KES" },
            { "KGS", "KGS" },
            { "KHR", "KHR" },
            { "KMF", "KMF" },
            { "KPW", "KPW" },
            { "KWD", "KWD" },
            { "KYD", "KYD" },
            { "KZT", "KZT" },
            { "LAK", "\u20ad" },
            { "LBP", "LBP" },
            { "LKR", "LKR" },
            { "LRD", "LRD" },
            { "LTL", "LTL" },
            { "LVL", "LVL" },
            { "LYD", "LYD" },
            { "MAD", "MAD" },
            { "MDL", "MDL" },
            { "MGA", "MGA" },
            { "MKD", "MKD" },
            { "MMK", "MMK" },
            { "MNT", "MNT" },
            { "MOP", "MOP" },
            { "MRO", "MRO" },
            { "MUR", "MUR" },
            { "MVR", "MVR" },
            { "MWK", "MWK" },
            { "MYR", "MYR" },
            { "MZN", "MZN" },
            { "NAD", "NAD" },
            { "NGN", "NGN" },
            { "NIO", "NIO" },
            { "NOK", "NOK" },
            { "NPR", "NPR" },
            { "OMR", "OMR" },
            { "PAB", "PAB" },
            { "PEN", "PEN" },
            { "PGK", "PGK" },
            { "PHP", "PHP" },
            { "PKR", "PKR" },
            { "PLN", "PLN" },
            { "PYG", "PYG" },
            { "QAR", "QAR" },
            { "RON", "RON" },
            { "RSD", "RSD" },
            { "RUB", "RUB" },
            { "RWF", "RWF" },
            { "SAR", "SAR" },
            { "SBD", "SBD" },
            { "SCR", "SCR" },
            { "SDG", "SDG" },
            { "SEK", "SEK" },
            { "SGD", "SGD" },
            { "SHP", "SHP" },
            { "SLL", "SLL" },
            { "SOS", "SOS" },
            { "SRD", "SRD" },
            { "SSP", "SSP" },
            { "STD", "STD" },
            { "SYP", "SYP" },
            { "SZL", "SZL" },
            { "THB", "\u0e3f" },
            { "TJS", "TJS" },
            { "TMT", "TMT" },
            { "TND", "TND" },
            { "TOP", "TOP" },
            { "TRY", "TRY" },
            { "TTD", "TTD" },
            { "TZS", "TZS" },
            { "UAH", "UAH" },
            { "UGX", "UGX" },
            { "UYU", "UYU" },
            { "UZS", "UZS" },
            { "VEF", "VEF" },
            { "VUV", "VUV" },
            { "WST", "WST" },
            { "YER", "YER" },
            { "ZAR", "ZAR" },
            { "ZMW", "ZMW" },
            { "adp", "\u0ec0\u0e9b\u0ec0\u0e8a\u0e95\u0eb2 \u0ead\u0eb1\u0e99\u0ec2\u0e94\u0ea5\u0eb2" },
            { "aed", "\u0eaa\u0eb0\u200b\u0eab\u0eb0\u200b\u0ea5\u0eb1\u0e94\u200b\u0ead\u0eb2\u200b\u0ea3\u0eb1\u0e9a\u200b\u0ead\u0eb2\u200b\u0ea1\u0eb4\u200b\u0ec0\u0ea3\u0e94 \u0ec0\u0e94\u0eb5\u200b\u0ec1\u0eae\u0ea1" },
            { "afa", "\u0ead\u0eb1\u0e9a\u0e81\u0eb2\u0e99\u0eb4 \u0ead\u0eb1\u0e9a\u0e81\u0eb2\u0e99\u0eb4\u0eaa\u0eb0\u0e96\u0eb2\u0e99 (1927\u20132002)" },
            { "afn", "\u0ead\u0eb1\u0e9f\u200b\u0e81\u0eb1\u0e99 \u0ead\u0eb1\u0e9f\u200b\u0e81\u0eb2\u200b\u0e99\u0eb4" },
            { "all", "\u0ead\u0eb1\u0ea5\u200b\u0e9a\u0eb2\u200b\u0e99\u0ebd\u0e99 \u0ec0\u0ea5\u0e81" },
            { "amd", "\u0ead\u0eb2\u200b\u0ec0\u0ea1\u200b\u0e99\u0ebd\u0e99 \u0ec1\u0e94\u0ea3\u0ea1" },
            { "ang", "\u0ec0\u0e99\u200b\u0ec0\u0e97\u0eb5\u200b\u0ec1\u0ea5\u0e99 \u0ec1\u0ead\u0e99\u200b\u0e95\u0eb4\u200b\u0ea5\u0ebd\u0e99 \u0e81\u0eb4\u0ea7\u200b\u0ec0\u0e94\u0eb5" },
            { "aoa", "\u0ec1\u0ead\u0e87\u200b\u0ec2\u0e81\u200b\u0ea5\u0eb1\u0e99 \u0e84\u0ea7\u0e99\u200b\u0e8a\u0eb2" },
            { "aok", "\u0e81\u0ea7\u0eb2\u0e99\u0e8a\u0eb2 \u0ec1\u0ead\u0e87\u0ec2\u0e81\u0ea5\u0eb2 (1977\u20131991)" },
            { "aon", "\u0e81\u0ea7\u0eb2\u0e99\u0e8a\u0eb2 \u0ec1\u0ead\u0e87\u0ec2\u0e81\u0ea5\u0eb2 \u0ec3\u0edd\u0ec8 (1995\u20131999)" },
            { "aor", "\u0e81\u0ea7\u0eb2\u0e99\u0e8a\u0eb2\u0e81\u0e97\u0eb5\u0ec8\u0ec1\u0e81\u0ec9\u0ec4\u0e82\u0ec3\u0edd\u0ec8 \u0ec1\u0ead\u0e87\u0e81\u0eb9\u0ea5\u0eb2 (1995\u20131999)" },
            { "ara", "\u0ead\u0ead\u0eaa\u0e95\u0ea3\u0eb2\u0e99 \u0ead\u0eb2\u0e81\u0e8a\u0eb1\u0e87\u0e95\u0eb4\u0e99" },
            { "arl", "\u0ec0\u0e9b\u0ec2\u0e8a\u0ec0\u0ea5 \u0ead\u0eb2\u0e81\u0e8a\u0eb1\u0e87\u0e95\u0eb4\u0e99 (1970\u20131983)" },
            { "arm", "\u0ec0\u0e9b\u0ec2\u0e8a \u0ead\u0eb2\u0e81\u0e8a\u0eb1\u0e87\u0e95\u0eb4\u0e99 (1881\u20131970)" },
            { "arp", "\u0ec0\u0e9b\u0ec2\u0e8a \u0ead\u0eb2\u0e81\u0e8a\u0eb1\u0e87\u0e95\u0eb4\u0e99 (1983\u20131985)" },
            { "ars", "\u0ead\u0eb2\u200b\u0ec0\u0e88\u0e99\u200b\u0e97\u0eb4\u200b\u0e99\u0eb2 \u0ec0\u0e9b\u200b\u0ec2\u0e8a" },
            { "ats", "\u0e8a\u0eb4\u0ea5\u0ea5\u0eb4\u0e87 \u0ead\u0ebb\u0e94\u0eaa\u0eb0\u0e95\u0eb2\u0ea5\u0eb5" },
            { "aud", "\u0ead\u0ead\u0eaa\u200b\u0ec0\u0e95\u0ea3\u200b\u0ea5\u0ebd\u0e99 \u0ec2\u0e94\u200b\u0ea5\u0ec8\u0eb2" },
            { "awg", "\u0ead\u0eb0\u0ea3\u0eb9\u0ec1\u0e9a\u0e99 \u0e9f\u0ea5\u0ecd\u0ea3\u0eb4\u0e99" },
            { "azm", "\u0ea1\u0eb2\u0e99\u0eb1\u0e94 \u0ead\u0eb2\u0ec1\u0e8a\u0e81\u0e9a\u0eb2\u0e8d\u0e8a\u0eb2\u0e99 (1993\u20132006)" },
            { "azn", "\u0ead\u0eb2\u200b\u0ec0\u0e8a\u0eb5\u200b\u0ec4\u0e9a\u200b\u0e88\u0eb2\u200b\u0e99\u0eb4 \u0ea1\u0eb2\u200b\u0e99\u0eb1\u0e94" },
            { "bad", "\u0e94\u0eb5\u0e99\u0eb2 \u0e9a\u0ead\u0eaa\u0ec0\u0e99\u0e8d \u0ec0\u0eae\u0eb5\u0ec0\u0e8a\u0ec2\u0e9a\u0ea7\u0eb2\u0ec0\u0e99\u0e8d (1992\u20131994)" },
            { "bam", "\u0e9a\u0ead\u200b\u0eaa\u200b\u0ec0\u0e99\u0e8d-\u0ec0\u0eae\u0eb5\u200b\u0ec0\u0e8a\u200b\u0ec2\u0e81\u0ea7\u0eb4\u200b\u0e99\u0eb2 \u0e84\u0ead\u0e99\u200b\u0ec0\u0ea7\u0eb5\u0e94\u200b\u0e95\u0eb4\u200b\u0ec2\u0e9a \u0ea1\u0eb2\u0e81" },
            { "ban", "\u0e94\u0eb5\u0e99\u0eb2\u0ec3\u0edd\u0ec8 \u0e9a\u0ead\u0eaa\u0ec0\u0e99\u0e8d \u0ec0\u0eae\u0eb5\u0ec0\u0e8a\u0ec2\u0e9a\u0ea7\u0eb5\u0e99\u0eb2(1994\u20131997)" },
            { "bbd", "\u0ec2\u0e94\u0ea5\u0ec8\u0eb2 \u0e9a\u0eb2\u0e9a\u0eb2\u0e94\u0ebd\u0e99" },
            { "bdt", "\u0e9a\u0eb1\u0e87\u200b\u0e84\u0ea5\u0eb2\u200b\u0ec0\u0e97\u0e94 \u0e95\u0eb2\u200b\u0e81\u0eb2" },
            { "bec", "\u0e9f\u0ea3\u0eb1\u0e87 \u0e9a\u0eb9\u0e99\u0e81\u0eb2\u0ea5\u0eb5 (\u0e9b\u0ec8\u0ebd\u0e99\u0ec1\u0e9b\u0e87\u0ec4\u0e94\u0ec9)" },
            { "bef", "\u0e9f\u0ea3\u0eb1\u0e87 \u0e9a\u0eb9\u0e99\u0e81\u0eb2\u0ea5\u0eb5" },
            { "bel", "\u0e9f\u0ea3\u0eb1\u0e87 \u0e9a\u0eb9\u0e99\u0e81\u0eb2\u0ea5\u0eb5 (\u0e81\u0eb2\u0e99\u0ec0\u0e87\u0eb4\u0e99)" },
            { "bgl", "\u0eae\u0eb2\u0e94\u0ec0\u0ea5\u0e9a \u0e9a\u0eb9\u0e99\u0e81\u0eb2\u0ea5\u0eb5" },
            { "bgm", "\u0ec0\u0ea5\u0e9a \u0eaa\u0eb1\u0e87\u0e84\u0ebb\u0ea1\u0e9a\u0eb9\u0e99\u0e81\u0eb2\u0ea5\u0eb5" },
            { "bgn", "\u0e9a\u0eb1\u0e87\u200b\u0e81\u0eb2\u200b\u0ea3\u0ebd\u0e99 \u0ec0\u0ea5\u0e9a" },
            { "bgo", "\u0ec0\u0ea5\u0e9a \u0e9a\u0eb9\u0e99\u0e81\u0eb2\u0ea5\u0eb5 (1879\u20131952)" },
            { "bhd", "\u0e9a\u0eb2\u200b\u0ec4\u0ea3\u200b\u0e99\u0eb4 \u0e94\u0eb4\u200b\u0e99\u0eb2" },
            { "bif", "\u0e9a\u0eb8\u200b\u0ea3\u0eb1\u0e99\u200b\u0e94\u0ebd\u0e99 \u0e9f\u0ea3\u0eb1\u0e87" },
            { "bmd", "\u0ec2\u0e94\u200b\u0ea5\u0ec8\u0eb2\u200b\u0ec0\u0e9a\u0eb5\u200b\u0ea1\u0eb4\u0ea7\u200b\u0e94\u0eb2" },
            { "bnd", "\u0e9a\u0ea3\u0eb9\u200b\u0ec4\u0e99 \u0ec2\u0e94\u200b\u0ea5\u0ec8\u0eb2" },
            { "bob", "\u0ec2\u0e9a\u200b\u0ea5\u0eb4\u200b\u0ea7\u0ebd\u0e99 \u0ec2\u0e9a\u200b\u0ea5\u0eb4\u200b\u0ec0\u0ea7\u0e8d\u200b\u0ec2\u0e99" },
            { "bol", "\u0ec2\u0ea5\u0ea5\u0eb4\u0ec0\u0ea7\u0e8d\u0ec2\u0e99 \u0ec2\u0ea5\u0ea5\u0eb4\u0ec0\u0ea7\u0e8d (1863\u20131963)" },
            { "bop", "\u0ec0\u0e9b\u0ec2\u0e8a\u0ec2\u0ea5\u0ea5\u0eb4\u0ec0\u0ea7\u0e8d" },
            { "bov", "\u0ea1\u0eb0\u0e94\u0ead\u0e99 \u0ec2\u0ea5\u0ea5\u0eb4\u0ec0\u0ea7\u0e8d" },
            { "brb", "\u0e81\u0ea3\u0eb9\u0ec0\u0e8a\u0ec2\u0e94\u0e9a\u0eb2\u0e8a\u0eb4 \u0ec3\u0edd\u0ec8 (1967\u20131986)" },
            { "brc", "\u0e81\u0ea3\u0eb9\u0e8a\u0eb2\u0ec2\u0e94\u0e9a\u0eb2\u0e8a\u0eb4\u0ea7 (1986\u20131989)" },
            { "bre", "\u0e81\u0ea3\u0eb9\u0ec0\u0e8a\u0ec2\u0ea3 \u0e9a\u0eb2\u0e8a\u0eb4 \u0e81\u0ea3\u0eb9\u0ec2\u0e8a \u0e9a\u0eb2\u0e8a\u0eb4\u0ea7 (1993\u20131994)" },
            { "brl", "\u0e9a\u0ea3\u0eb2\u200b\u0e8a\u0eb4\u200b\u0ea5\u0ebd\u0e99 \u0ea3\u0ebd\u0ea7" },
            { "brn", "\u0e81\u0ea3\u0eb9\u0e8a\u0eb2\u0ec2\u0e94 \u0e9a\u0eb2\u0e8a\u0eb4\u0ea7 \u0ec3\u0edd\u0ec8 (1989\u20131990)" },
            { "brr", "\u0e81\u0ea3\u0eb9\u0ec0\u0e8a\u0ec2\u0ea3 \u0e9a\u0eb2\u0e8a\u0eb4\u0ea7 (1993\u20131994)" },
            { "brz", "\u0e81\u0ea3\u0eb9\u0ec0\u0e8a\u0ec2\u0ea3 \u0e9a\u0eb2\u0e8a\u0eb4\u0ea7 (1942\u20131967)" },
            { "bsd", "\u0ec2\u0e94\u0ea5\u0ec8\u0eb2 \u0e9a\u0eb2\u0eae\u0eb2\u0ea1\u0ebd\u0e99" },
            { "btn", "\u0e9e\u0eb9\u200b\u0e96\u0eb2\u0e99 \u0e87\u0eb8\u0e99\u0e94\u0ea3\u0eb1\u0ea1" },
            { "buk", "\u0e88\u0eb2\u0e94 \u0e9e\u0eb0\u0ea1\u0ec9\u0eb2" },
            { "bwp", "\u0e9a\u0ead\u0e94\u200b\u0eaa\u0eb0\u200b\u0ea7\u0eb2\u200b\u0e99\u0eb2\u0e99 \u0e9e\u0eb9\u200b\u0ea5\u0eb2" },
            { "byb", "\u0ea3\u0eb9\u0ec2\u0e9a \u0ec0\u0e9a\u0ea3\u0eb2\u0ea3\u0eb8\u0eaa \u0ec3\u0edd\u0ec8(1994\u20131999)" },
            { "byn", "\u0ec0\u0e9a\u200b\u0ea5\u0eb2\u200b\u0ea3\u0eb8\u200b\u0eaa\u200b\u0e8a\u0ebd\u0e99 \u0ea3\u0eb9\u200b\u0ec0\u0e9a\u0eb4\u0e99" },
            { "byr", "\u0ec0\u0e9a\u200b\u0ea5\u0eb2\u200b\u0ea3\u0eb8\u200b\u0eaa\u200b\u0e8a\u0ebd\u0e99 \u0ea3\u0eb9\u200b\u0ec0\u0e9a\u0eb4\u0e99 (2000\u20132016)" },
            { "bzd", "\u0ec2\u0e94\u200b\u0ea5\u0ec8\u0eb2\u200b\u0ec0\u0e9a\u200b\u0ea5\u0eb4\u200b\u0e8a" },
            { "cad", "\u0ec2\u0e94\u0ea5\u0ec8\u0eb2\u0e84\u0eb2\u0e99\u0eb2\u0e94\u0eb2" },
            { "cdf", "\u0e84\u0ead\u0e87\u200b\u0ec2\u0e81\u200b\u0ea5\u0eb5\u0eaa \u0e9f\u0ea3\u0eb1\u0e87" },
            { "che", "\u0ec0\u0ead\u0eb5\u0ec2\u0ea3 WIR" },
            { "chf", "\u0eaa\u0eb0\u200b\u0ea7\u0eb4\u200b\u0eaa \u0e9f\u200b\u0ea3\u0eb1\u0e87" },
            { "chw", "\u0e9f\u0ea3\u0eb1\u0e87 WIR" },
            { "cle", "\u0ec0\u0ead\u0eaa\u0e81\u0eb9\u0ec2\u0e94 \u0e8a\u0eb4\u0ea5\u0eb5" },
            { "clf", "\u0eab\u0ebb\u0ea7\u0edc\u0ec8\u0ea7\u0e8d\u0e9a\u0eb1\u0e99\u0e8a\u0eb5 (UF) \u0e8a\u0eb4\u0ea5\u0eb5" },
            { "clp", "\u0e8a\u0eb4\u200b\u0ea5\u0ebd\u0e99 \u0ec0\u0e9b\u200b\u0ec2\u0e8a" },
            { "cnh", "\u0ea2\u0ea7\u0e99\u0e88\u0eb5\u0e99 (\u0e99\u0ead\u0e81\u0e9b\u0eb0\u0ec0\u0e97\u0e94)" },
            { "cny", "\u0e88\u0eb5\u0e99 \u0ea2\u0ea7\u0e99" },
            { "cop", "\u0ec2\u0e84\u200b\u0ea5\u0ebb\u0ea1\u200b\u0e9a\u0ebd\u0e99 \u0ec0\u0e9b\u200b\u0ec2\u0e8a" },
            { "cou", "\u0eab\u0ebb\u0ea7\u0edc\u0ec8\u0ea7\u0e8d\u0e84\u0ec8\u0eb2\u0e88\u0eb4\u0e87 \u0ec2\u0e84\u0ea5\u0eb1\u0ea1\u0ec0\u0e9a\u0e8d" },
            { "crc", "\u0ec2\u0e84\u0eaa\u0e95\u0eb2 \u0ea3\u0eb4\u0e81\u0eb1\u0e99 \u0ec2\u0e84\u0ea5\u0ead\u0e99" },
            { "csd", "\u0e94\u0eb5\u0e99\u0eb2 \u0ec0\u0e8a\u0eb5\u0ec0\u0e9a\u0e8d (2002\u20132006)" },
            { "csk", "\u0eae\u0eb2\u0e94\u0ec2\u0e81\u0ea3\u0eb9\u0e99\u0eb2 \u0ec0\u0e8a\u0eb1\u0e81\u0ec2\u0e81\u0eaa\u0eb0\u0ec2\u0ea5\u0ea7\u0eb1\u0e81" },
            { "cuc", "\u0e84\u0eb4\u0ea7\u0ec1\u0e9a\u0e99 \u0e84\u0ead\u0e99\u0ec0\u0ea7\u0eb5\u0e94\u0e95\u0eb4\u0ec2\u0e9a \u0ec0\u0e9b\u0ec2\u0e8a" },
            { "cup", "\u0e84\u0eb4\u0ea7\u0ec1\u0e9a\u0e99 \u0ec0\u0e9b\u0ec2\u0e8a" },
            { "cve", "\u0ec0\u0e84\u0e9a \u0ec0\u0ea7\u0eb5\u0e94\u200b\u0e94\u0eb5\u0e99 \u0ec0\u0ead\u200b\u0eaa\u200b\u0e84\u0eb9\u200b\u0ec2\u0e94" },
            { "cyp", "\u0e9b\u0ead\u0e99 \u0ec4\u0e8a\u0e9b\u0ea3\u0eb1\u0e94" },
            { "czk", "\u0ec2\u0e84\u200b\u0ea3\u0eb9\u200b\u0e99\u0eb2 \u0ec0\u0e8a\u0e81" },
            { "ddm", "\u0ea1\u0eb2\u0e81 \u0ec0\u0ea2\u0e8d\u0ea5\u0eb0\u0ea1\u0eb1\u0e99 \u0e95\u0eb2\u0ec0\u0ea7\u0eb1\u0e99\u0ead\u0ead\u0e81" },
            { "dem", "\u0ea1\u0eb2\u0e81 \u0ec0\u0ea2\u0e8d\u0ea5\u0eb0\u0ea1\u0eb1\u0e99" },
            { "djf", "\u200b\u0e94\u0eb4\u200b\u0e9a\u0eb9\u200b\u0e88\u0ebd\u0e99 \u0e9f\u0ea3\u0eb1\u0e87" },
            { "dkk", "\u0ec1\u0e94\u0e99\u200b\u0e99\u0eb4\u200b\u0e8a \u0ec2\u0e84\u0ea3\u0e99" },
            { "dop", "\u0ec2\u0e94\u200b\u0ea1\u0eb4\u200b\u0e99\u0eb4\u200b\u0e81\u0eb1\u0e99 \u0ec0\u0e9b\u200b\u0ec2\u0e8a" },
            { "dzd", "\u0ead\u0eb1\u0ea5\u200b\u0ec0\u0e88\u0eb5\u200b\u0ea3\u0ebd\u0e99 \u0e94\u0eb4\u200b\u0e99\u0eb2" },
            { "ecs", "\u0e8a\u0eb9\u0ec0\u0e81 \u0ec0\u0ead\u0e81\u0eb2\u0ea7\u0eb2\u0e94\u0ecd" },
            { "ecv", "\u0eab\u0ebb\u0ea7\u0edc\u0ec8\u0ea7\u0e8d\u0e84\u0ec8\u0eb2\u0e84\u0ebb\u0e87\u0e97\u0eb5\u0ec8\u0e82\u0ead\u0e87\u0ec0\u0ead\u0e81\u0eb2\u0ea7\u0eb2\u0e94\u0ecd" },
            { "eek", "\u0e84\u0ea3\u0eb9\u0e99\u0ec0\u0ead\u0eaa \u0ec2\u0e95\u0ec0\u0e99\u0e8d" },
            { "egp", "\u0ead\u0eb5\u200b\u0ea2\u0eb4\u0e9a\u200b\u0e97\u0ebd\u0e99 \u0e9e\u0eb2\u0ea7\u0e94\u0ecc" },
            { "ern", "\u0ead\u0eb4\u200b\u0ea3\u0eb4\u200b\u0e97\u0ea3\u0ebd\u0e99 \u0ec1\u0e99\u0e81\u200b\u0e9f\u200b\u0eb2" },
            { "esa", "\u0ec0\u0e9b\u0ec0\u0e8a\u0e95\u0eb2\u0eaa\u0eb0\u0ec0\u0e9b\u0eb1\u0e99 (\u0e9a\u0eb1\u0e99\u0e8a\u0eb5)" },
            { "esb", "\u0ec0\u0e9b\u0ec0\u0e8a\u0e95\u0eb2\u0eaa\u0eb0\u0ec0\u0e9b\u0e99 (\u0e9b\u0ec8\u0ebd\u0e99\u0ec1\u0e9b\u0e87\u0ec4\u0e94\u0ec9)" },
            { "esp", "\u0ec0\u0e9b\u0ec0\u0e8a\u0e95\u0eb2 \u0eaa\u0eb0\u0ec0\u0e9b\u0e99" },
            { "etb", "\u0ec0\u0ead\u200b\u0e97\u0eb4\u200b\u0ec2\u0ead\u200b\u0e9b\u0ebd\u0e99 \u0ec0\u0e9a\u0eb5\u200b\u0ea3\u0ecc" },
            { "eur", "\u0ea2\u0eb9\u200b\u0ec2\u0ea3" },
            { "fim", "\u0ea1\u0eb2\u0e81\u0e81\u0eb2 \u0e9f\u0eb4\u0e99\u0ec1\u0ea5\u0e99" },
            { "fjd", "\u0e9f\u0eb4\u200b\u0e88\u0ebd\u0e99 \u0ec2\u0e94\u200b\u0ea5\u0ec8\u0eb2" },
            { "fkp", "\u0e9f\u0ead\u200b\u0ea5\u0ecc\u0e81\u200b\u0ec1\u0ea5\u0e99 \u0ec4\u0ead\u200b\u0ec1\u0ea5\u0e99\u200b\u0eaa\u0ecc \u0e9e\u0eb2\u0ea7\u200b\u0e94\u0ecc" },
            { "frf", "\u0e9f\u0ea3\u0eb1\u0e87 \u0e9d\u0ea3\u0eb1\u0ec8\u0e87" },
            { "gbp", "\u0e9b\u0ead\u0e99 \u0eaa\u0eb0\u200b\u0ec0\u0e95\u0eb5\u200b\u0ea3\u0eb4\u0e87 (\u0ead\u0eb1\u0e87\u200b\u0e81\u0eb4\u0e94)" },
            { "gek", "\u0e81\u0eb9\u0e9b\u0ead\u0e99 \u0ea5\u0eb2\u0ea3\u0eb4\u0e97 \u0e88\u0ecd\u0ec0\u0e88\u0e8d" },
            { "gel", "\u0e88\u0ecd\u200b\u0e88\u0ebd\u0e99 \u0ea5\u0eb2\u200b\u0ea3\u0eb4" },
            { "ghc", "\u0ec0\u0e8a\u0e94\u0eb5 \u0e81\u0eb2\u0e99\u0eb2 (1979\u20132007)" },
            { "ghs", "\u0ec0\u0e8a\u200b\u0e94\u0eb4 \u0e81\u0eb2\u200b\u0e99\u0eb2\u200b\u0ead\u0ebd\u0e99" },
            { "gip", "\u0e81\u0eb4\u0e9a\u200b\u0ea3\u0eb2\u200b\u0e97\u0eb2 \u0e9e\u0eb2\u200b\u0ea7\u0e94\u0ecc" },
            { "gmd", "\u200b\u0ec1\u0e81\u0ea1\u200b\u0e9a\u0ebd\u0e99 \u0e94\u0eb2\u200b\u0ea5\u0eb2\u200b\u0e8a\u0eb4" },
            { "gnf", "\u0e81\u0eb4\u200b\u0e99\u0ebd\u0e99 \u0e9f\u0ea3\u0eb1\u0e87" },
            { "gns", "\u0ec4\u0e8a\u0ea5\u0eb4 \u0e81\u0eb5\u0e99\u0eb5" },
            { "gqe", "\u0ec0\u0ead\u0eb1\u0e81\u0ec0\u0ea7\u0ec0\u0ea5 \u0ead\u0eb5\u0e84\u0ea7\u0eb2\u0e95\u0eb4\u0ea3\u0ebd\u0ea7 \u0e81\u0eb4\u0e99\u0eb5" },
            { "grd", "\u0e94\u0eb2\u0e81\u0e8a\u0eb0\u0ea1\u0eb2 \u0ec0\u0e81\u0ea3\u0eb1\u0e81" },
            { "gtq", "\u0e81\u0ebb\u0ea7\u0ec0\u0e95\u0ea1\u0eb2\u0ea5\u0eb2\u0e99 \u0ec0\u0e84\u0eb1\u0e94\u0e8a\u0ead\u0e99" },
            { "gwe", "\u0ec0\u0ead\u0eaa\u0e81\u0eb9\u0ec2\u0e94 \u0e81\u0eb5\u0e99\u0eb5\u0ec2\u0e9b\u0e95\u0eb9\u0ec0\u0e81\u0e94" },
            { "gwp", "\u0ec0\u0e9b\u0ec2\u0e8a\u0e81\u0eb4\u0e99\u0eb5-\u0e9a\u0eb4\u0eaa\u0ec0\u0e8a\u0ebb\u0eb2" },
            { "gyd", "\u0e81\u0eb2\u0e8d\u200b\u0ea2\u0eb2\u200b\u0e99\u0eb5\u200b\u0eaa \u0ec2\u0e94\u200b\u0ea5\u0ec8\u0eb2" },
            { "hkd", "\u0eae\u0ead\u0e87\u200b\u0e81\u0ebb\u0e87 \u0ec2\u0e94\u200b\u0ea5\u0ec8\u0eb2" },
            { "hnl", "\u0eae\u0ead\u0e99\u0e94\u0eb9\u0ec1\u0ea3\u0e99 \u0ec0\u0ea5\u0ea1\u0e9e\u0eb4\u0ea3\u0eb2" },
            { "hrd", "\u0e94\u0eb5\u0e99\u0eb2 \u0ec2\u0e84\u0ea3\u0ec0\u0ead\u0ec0\u0e8a\u0e8d" },
            { "hrk", "\u0ec2\u0e84\u0ea3\u200b\u0ec0\u0ead\u200b\u0e97\u0ebd\u0e99 \u0e84\u0eb9\u200b\u0e99\u0eb2" },
            { "htg", "\u0ec4\u0eae\u200b\u0e95\u0ebd\u0e99 \u0e81\u0ebb\u0ea7\u200b\u0ec0\u0e94" },
            { "huf", "\u0eae\u0eb1\u0e87\u200b\u0e81\u0eb2\u200b\u0ea3\u0ebd\u0e99 \u0e9f\u0ecd\u200b\u0ea3\u0eb4\u0e99" },
            { "idr", "\u0ead\u0eb4\u0e99\u200b\u0ec2\u0e94\u200b\u0ec0\u0e99\u200b\u0e8a\u0ebd\u0e99 \u0ec2\u0e94\u200b\u0ea5\u0ec8\u0eb2" },
            { "iep", "\u0e9b\u0ead\u0e99 \u0ec4\u0ead\u0ea3\u0eb4\u0e8a" },
            { "ilp", "\u0e9b\u0ead\u0e99 \u0ead\u0eb5\u0eaa\u0eb0\u0ea5\u0eb2\u0ec0\u0ead\u0ea7" },
            { "ils", "\u0ead\u0eb4\u0eaa\u200b\u0ea3\u0eb2\u200b\u0ec0\u0ead\u0ea7\u200b\u0ea5\u0eb4 \u0e99\u0eb4\u0ea7 \u0ec0\u0e8a\u200b\u0ec0\u0e81\u0ea7" },
            { "inr", "\u0ead\u0eb4\u0e99\u200b\u0ec0\u0e94\u0e8d \u0ea3\u0eb9\u200b\u0e9b\u0eb5" },
            { "iqd", "\u0ead\u0eb4\u200b\u0ea3\u0eb1\u0e81\u200b\u0e81\u0eb4 \u0e94\u0eb4\u200b\u0e99\u0eb2" },
            { "irr", "\u0ead\u0eb4\u200b\u0ea3\u0eb2\u200b\u0e99\u0eb4 \u0ea3\u0ebd\u0ea7" },
            { "isk", "\u0ec4\u0ead\u200b\u0eaa\u0ecc\u200b\u0ec1\u0ea5\u0e99\u200b\u0e94\u0eb4\u0e81 \u0ec2\u0e84\u0ea3\u200b\u0e99\u0eb2" },
            { "itl", "\u0ea5\u0eb4\u0ea3\u0eb2 \u0ead\u0eb5\u0e95\u0eb2\u0ea5\u0eb5" },
            { "jmd", "\u200b\u0e88\u0eb2\u200b\u0ec4\u0ea1\u200b\u0e81\u0eb1\u0e99 \u0ec2\u0e94\u200b\u0ea5\u0ec8\u0eb2" },
            { "jod", "\u0e88\u0ecd\u200b\u0ec1\u0e94\u200b\u0e99\u0ebd\u0e99 \u0e94\u0eb4\u200b\u0e99\u0eb2" },
            { "jpy", "\u0e8d\u0eb5\u0ec8\u200b\u0e9b\u0eb8\u0ec8\u0e99 \u0ec0\u0ea2\u0e99" },
            { "kes", "\u0ec0\u0e84\u0e99\u200b\u0ea2\u0eb1\u0e99 \u0e8a\u0eb4\u0ea7\u200b\u0ea5\u0eb4\u0e87" },
            { "kgs", "\u0e84\u200b\u0ea3\u0eb5\u200b\u0e81\u0eb4\u0eaa\u200b\u200b\u0e96\u0eb2\u200b\u0e99\u0eb4 \u0ec2\u0e8a\u0ea1" },
            { "khr", "\u0e81\u0eb3\u200b\u0e9b\u0eb9\u200b\u0ec0\u0e88\u0e8d \u0ea3\u0ebd\u0ea7" },
            { "kmf", "\u0ec2\u0e84\u200b\u0ec2\u0ea1\u200b\u0ea3\u0ebd\u0e99 \u0e9f\u0ea3\u0eb1\u0e87" },
            { "kpw", "\u0ec0\u0e81\u0ebb\u0eb2\u200b\u0eab\u0ea5\u0eb5\u200b\u0ec0\u0edc\u0eb7\u0ead \u0ea7\u0ead\u0e99" },
            { "krh", "\u0eae\u0eb2\u0ea7\u0eb2\u0e99 \u0ec0\u0e81\u0ebb\u0eb2\u0eab\u0ebc\u0eb5\u0ec0\u0e99\u0eb7\u0ec9" },
            { "kro", "\u0ea7\u0ead\u0e99 \u0ec0\u0e81\u0ebb\u0eb2\u0eab\u0ebc\u0eb5\u0ec3\u0e95\u0ec9 (1945\u20131953)" },
            { "krw", "\u0ec0\u0e81\u0ebb\u0eb2\u200b\u0eab\u0ea5\u0eb5\u0ec3\u0e95\u0ec9 \u0ea7\u0ead\u0e99" },
            { "kwd", "\u0e84\u0eb9\u200b\u0ec0\u0ea7\u200b\u0e95\u0eb4 \u0e94\u0eb4\u200b\u0e99\u0eb2" },
            { "kyd", "\u0ec0\u0e84\u200b\u0ec1\u0ea1\u0e99 \u0ec4\u0ead\u200b\u0ec1\u0ea5\u0e99 \u0ec2\u0e94\u200b\u0ea5\u0ec8\u0eb2" },
            { "kzt", "\u0e84\u0eb2\u200b\u0e8a\u0eb1\u0e81\u200b\u0eaa\u0eb0\u200b\u0e96\u0eb2\u200b\u0e99\u0eb4 \u0ec0\u0e95\u0eb1\u0e87\u200b\u0ec0\u0e88" },
            { "lak", "\u0ea5\u0eb2\u0ea7 \u0e81\u0eb5\u0e9a" },
            { "lbp", "\u0ec0\u0ea5\u200b\u0e9a\u0eb2\u200b\u0e99\u0eb5\u200b\u0eaa \u0e9e\u0eb2\u0ea7\u0e94\u0ecc" },
            { "lkr", "\u0eaa\u0eb5\u200b\u0ea5\u0eb1\u0e87\u200b\u0e81\u0eb2 \u0ea3\u0eb9\u200b\u0e9b\u0eb5" },
            { "lrd", "\u0ea5\u0eb4\u200b\u0ec0\u0e9a\u0eb5\u200b\u0ea3\u0ebd\u0e99 \u0ec2\u0e94\u200b\u0ea5\u0ec8\u0eb2" },
            { "lsl", "\u0ec2\u0ea5\u0e95\u0eb4 \u0ec0\u0ea5\u0ec2\u0e8a\u0ec2\u0e95" },
            { "ltl", "\u0ea5\u0eb4\u200b\u0e97\u0ebb\u0ea7\u200b\u0e99\u0ebd\u0e99 \u0ea5\u0eb4\u200b\u0e97\u0eb1\u200b\u0eaa" },
            { "ltt", "\u0e97\u0eb2\u0ec2\u0ea5\u0e99\u0eb1\u0eaa \u0ea5\u0eb4\u0e97\u0ebb\u0ea7\u0ec0\u0e99\u0e8d" },
            { "luc", "\u0e9f\u0ea3\u0eb1\u0e87 \u0ea5\u0eb8\u0e81\u0e8a\u0eb3\u0e9a\u0ea7\u0e81 \u0e97\u0eb5\u0ec8\u0e9b\u0ec8\u0ebd\u0e99\u0ec1\u0e9b\u0e87" },
            { "luf", "\u0e9f\u0ea3\u0eb1\u0e87 \u0ea5\u0eb8\u0e81\u0e8a\u0eb3\u0e9a\u0ea7\u0e81" },
            { "lul", "\u0e9f\u0ea3\u0eb1\u0e87 \u0ea5\u0eb8\u0e81\u0e8a\u0eb3\u0e9a\u0ea7\u0e81 \u0e81\u0eb2\u0e99\u0ec0\u0e87\u0eb4\u0e99" },
            { "lvl", "\u0ea5\u0eb1\u0e94\u200b\u0ea7\u0ebd\u0e99 \u0ea5\u0eb1\u0e94\u200b\u0eaa\u0ecc" },
            { "lvr", "\u0ea3\u0eb9\u0ec2\u0e9a \u0ea5\u0eb2\u0ea7\u0ebd\u0e99" },
            { "lyd", "\u0ea5\u0eb4\u0e9a\u200b\u0e9a\u0ebd\u0e99 \u0e94\u0eb4\u200b\u0e99\u0eb2" },
            { "mad", "\u0ea1\u0ecd\u200b\u0ea3\u0eb1\u0ead\u0e81\u200b\u0ec1\u0e84\u0e99\u200b \u0ec0\u0e94\u0eb5\u200b\u0ec1\u0eae\u0ea1" },
            { "maf", "\u0e9f\u0ea3\u0eb1\u0e87 \u0ec2\u0ea1\u0ea3\u0ead\u0e81\u0ec2\u0e81" },
            { "mcf", "\u0e9f\u0ea3\u0eb1\u0e87 \u0ec2\u0ea1\u0e94\u0eb2\u0ec2\u0e81" },
            { "mdc", "\u0e9a\u0eb1\u0e94\u0e9b\u0eb1\u0e99\u0eaa\u0ec8\u0ea7\u0e99 \u0ea1\u0ead\u0e87\u0ec2\u0e94\u0ea7\u0eb2" },
            { "mdl", "\u0ea1\u0ead\u0e99\u200b\u0ec2\u0e94\u200b\u0ec1\u0ea7\u0e99 \u0ec0\u0ea5\u200b\u0ead\u0eb9" },
            { "mga", "\u0ea1\u0eb2\u200b\u0ea5\u0eb2\u200b\u0e81\u0eb2\u200b\u0e8a\u0eb5 \u0ead\u0eb2\u200b\u0ec0\u0ea3\u0e8d\u200b\u0ea3\u0eb5" },
            { "mgf", "\u0e9f\u0ea3\u0eb1\u0e87 \u0ea1\u0eb2\u0e94\u0eb2\u0e81\u0eb1\u0e94\u0eaa\u0eb0\u0e81\u0eb2" },
            { "mkd", "\u0ec1\u0ea1\u0eb1\u0e81\u200b\u0ec0\u0e8a\u200b\u0ec2\u0e94\u200b\u0e99\u0ebd\u0e99 \u0ec0\u0e94\u200b\u0e99\u0eb2" },
            { "mkn", "\u0e94\u0eb5\u0e99\u0eb2 \u0ea1\u0eb2\u0e8a\u0eb5\u0ec2\u0e94\u0ec0\u0e99\u0e8d (1992\u20131993)" },
            { "mlf", "\u0e9f\u0ea3\u0eb1\u0e87 \u0ea1\u0eb2\u0ea5\u0eb5" },
            { "mmk", "\u0ea1\u0ebd\u0e99\u200b\u0ea1\u0eb2 \u0e88\u0eca\u0eb2\u0e94" },
            { "mnt", "\u0ea1\u0ead\u0e87\u200b\u0ec2\u0e81\u200b\u0ea5\u0ebd\u0e99 \u0e95\u0eb9\u0e81\u0ea3\u0eb4\u0e81" },
            { "mop", "\u0ea1\u0eb2\u200b\u0ec0\u0e81\u0ebb\u0ec9\u0eb2 \u0e9b\u0eb2\u200b\u200b\u0e95\u0eb2\u200b\u0e81\u0eb2" },
            { "mro", "\u0ea1\u0ebb\u0ea7\u200b\u0ea3\u0eb4\u200b\u0e97\u0eb2\u200b\u0e99\u0ebd\u0e99 \u0ead\u0eb9\u200b\u0e81\u0eb4\u0ea7\u200b\u0ea2\u0eb2 (1973\u20132017)" },
            { "mru", "\u0ea1\u0ebb\u0ea7\u200b\u0ea3\u0eb4\u200b\u0e97\u0eb2\u200b\u0e99\u0ebd\u0e99 \u0ead\u0eb9\u200b\u0e81\u0eb4\u0ea7\u200b\u0ea2\u0eb2" },
            { "mtl", "\u0ea5\u0eb4\u0ea3\u0eb2 \u0ea1\u0ead\u0e99\u0e95\u0eb2" },
            { "mtp", "\u0e9b\u0ead\u0e99 \u0ea1\u0ead\u0e99\u0e95\u0eb2" },
            { "mur", "\u0ec0\u0ea1\u0ebb\u0eb2\u200b\u0ea3\u0eb4\u200b\u0e97\u0ebd\u0e99 \u0ea3\u0eb9\u200b\u0e9b\u0eb5" },
            { "mvr", "\u0ea1\u0eb1\u200b\u0ea5\u200b\u0e94\u0eb4\u200b\u0ea7\u0ebd\u0e99 \u0ea3\u0eb9\u200b\u0e9f\u0eb4\u200b\u0ea2\u0eb2" },
            { "mwk", "\u0ea1\u0eb2\u200b\u0ea5\u0eb2\u200b\u0ea7\u0ebd\u0e99 \u0e84\u0ea7\u0eb2\u200b\u0e8a\u0eb2" },
            { "mxn", "\u0ec0\u0ea1\u0eb1\u0e81\u0e8a\u0eb4\u0e81\u0eb1\u0e99 \u0ec0\u0e9b\u0ec2\u0e8a" },
            { "mxp", "\u0eab\u0ebb\u0ea7\u0edc\u0ec8\u0ea7\u0e8d\u0ec0\u0e87\u0eb4\u0e99 \u0ec0\u0e9b\u0ec2\u0e8a \u0ec1\u0ea1\u0eb1\u0e81\u0e8a\u0eb4\u0ec2\u0e81(1861\u20131992)" },
            { "mxv", "\u0eab\u0ebb\u0ea7\u0edc\u0ec8\u0ea7\u0e8d\u0e81\u0eb2\u0e99\u0ea5\u0ebb\u0e87\u0e97\u0eb6\u0e99 \u0ec1\u0ea1\u0eb1\u0e81\u0e8a\u0eb4\u0ec2\u0e81" },
            { "myr", "\u0ea1\u0eb2\u200b\u0ec0\u0ea5\u200b\u0ec0\u0e8a\u0e8d \u0ea3\u0eb4\u0e87\u200b\u0e81\u0eb4\u0e94" },
            { "mze", "\u0ec0\u0ead\u0eaa\u0e81\u0eb9\u0ec2\u0e94 \u0ec2\u0ea1\u0e8a\u0eb3\u0e9a\u0eb4\u0e81" },
            { "mzm", "\u0ec0\u0ea1\u0e95\u0eb4\u0e84\u0ecd \u0ec2\u0ea1\u0e8a\u0eb3\u0e9a\u0eb4\u0e81 (1980\u20132006)" },
            { "mzn", "\u0ec2\u0ea1\u200b\u0ec1\u0e8a\u0ea1\u200b\u0e9a\u0eb4\u200b\u0e81\u0eb1\u0e99 \u0ec0\u0ea1\u200b\u0e97\u0eb4\u200b\u0e84\u0ead\u0e99" },
            { "nad", "\u0e99\u0eb2\u200b\u0ea1\u0eb4\u200b\u0e9a\u0ebd\u0e99 \u0ec2\u0e94\u200b\u0ea5\u0ec8\u0eb2" },
            { "ngn", "\u0ec4\u0e99\u200b\u0ea3\u0eb2 \u200b\u0ec4\u0e99\u0ec0\u0e88\u0eb5\u200b\u0ea3\u0ebd\u0e99" },
            { "nic", "\u0e84\u0ecd\u0ec2\u0e94\u0e9a\u0eb2 \u0e99\u0eb4\u0e81\u0eb2\u0ea3\u0eb2\u0e81\u0ebb\u0ea7 (1988\u20131991)" },
            { "nio", "\u0e99\u0eb4\u0e81\u0eb2\u0ea3\u0eb2\u0e81\u0ea7\u0e99 \u0ec2\u0e84\u0ec2\u0e94\u0e9a\u0eb2" },
            { "nlg", "\u0e81\u0eb4\u0ea5\u0ec0\u0e94\u0eb5 \u0ec0\u0e99\u0ec0\u0e97\u0eb5\u0ec1\u0ea5\u0e99" },
            { "nok", "\u0e99\u0ecd\u200b\u0ec0\u0ea7\u200b\u0e81\u0ebd\u0e99 \u200b\u0ec2\u0e84\u0ea3\u0e99" },
            { "npr", "\u0ec0\u0e99\u200b\u0e9b\u0eb2\u0e99 \u0ea3\u0eb9\u200b\u0e9b\u0eb5" },
            { "nzd", "\u0e99\u0eb4\u0ea7\u200b\u0e8a\u0eb5\u200b\u0ec1\u0ea5\u0e99 \u0ec2\u0e94\u200b\u0ea5\u0ec8\u0eb2" },
            { "omr", "\u0ec2\u0ead\u200b\u0ea1\u0eb2\u200b\u0e99\u0eb4 \u0ea3\u0ebd\u0ea7" },
            { "pab", "\u0e9e\u0eb2\u0e99\u0eb2\u0ea1\u0eb2\u0e99\u0ebd\u0e99 \u0e9a\u0ead\u0e99\u0e9a\u0ebb\u0ea7" },
            { "pei", "\u0ead\u0eb4\u0e99\u0e95\u0eb4 \u0ec0\u0e9b\u0ea3\u0eb9" },
            { "pen", "\u0ec0\u0e9b\u200b\u0ea3\u0eb9\u200b\u0ea7\u0ebd\u0e99 \u0ec2\u0e8a\u200b\u0ea5\u0ecc" },
            { "pes", "\u0ec2\u0e8a\u0e99 \u0ec0\u0e9b\u0ea3\u0eb9 (1863\u20131965)" },
            { "pgk", "\u0e9b\u0eb2\u200b\u0e9b\u0ebb\u0ea7 \u0e99\u0eb4\u0ea7 \u0e81\u0eb4\u200b\u0e99\u0ebd\u0e99 \u0e81\u0eb4\u200b\u0e99\u0eb2" },
            { "php", "\u0e9f\u0eb4\u200b\u0ea5\u0eb4\u0e9a\u200b\u0e9b\u0eb4\u0e99 \u0ec0\u0e9b\u200b\u0ec2\u0e8a" },
            { "pkr", "\u0e9b\u0eb2\u200b\u0e81\u0eb4\u200b\u0eaa\u0e96\u0eb2\u0e99 \u0ea3\u0eb9\u200b\u0e9b\u0eb5" },
            { "pln", "\u0ec2\u0e9b\u200b\u0ea5\u0eb4\u200b\u0e8a \u0e8a\u0eb0\u200b\u0ea5\u0ecd\u200b\u0e95\u0eb5" },
            { "plz", "\u0e8a\u0eb0\u0ea5\u0ead\u0eaa\u0e95\u0eb5 \u0ec2\u0e9b\u0ec1\u0ea5\u0e99 (1950\u20131995)" },
            { "pte", "\u0ec0\u0ead\u0eaa\u0e81\u0eb9\u0ec2\u0e94 \u0ec2\u0e9b\u0e95\u0eb9\u0ec0\u0e81\u0eaa" },
            { "pyg", "\u0e81\u0ea7\u0eb2\u0ea3\u0eb2\u0e99\u0eb5 \u0e9b\u0eb2\u0ea3\u0eb2\u0e81\u0ea7\u0eb2\u0e8d" },
            { "qar", "\u0e84\u0eb2\u200b\u0e95\u0eb2\u200b\u0ea3\u0eb4 \u0ea3\u0ebd\u0ea7" },
            { "rhd", "\u0e94\u0ead\u0e99\u0ea5\u0eb2 \u0ec2\u0ea3\u0e94\u0eb5\u0ec0\u0e8a\u0e8d" },
            { "rol", "\u0ea5\u0eb4\u0ea7 \u0ec2\u0ea3\u0ea1\u0eb2\u0ec0\u0e99\u0e8d\u0ec0\u0e81\u0ebb\u0ec8\u0eb2" },
            { "ron", "\u0ec2\u0ea3\u200b\u0ea1\u0eb2\u200b\u0e99\u0ebd\u0e99 \u0ec0\u0ea5\u200b\u0ead\u0eb9" },
            { "rsd", "\u0ec0\u0e8a\u0eb5\u200b\u0e9a\u0ebd\u0e99 \u0e94\u0eb4\u200b\u0e99\u0eb2" },
            { "rub", "\u0ea3\u0eb1\u0eaa\u200b\u0e8a\u0ebd\u0e99 \u0ea3\u0eb9\u200b\u0ec0\u0e9a\u0eb4\u0e99" },
            { "rur", "\u0ea3\u0eb9\u0ec2\u0e9a \u0ea3\u0eb1\u0e94\u0ec0\u0e8a\u0e8d (1991\u20131998)" },
            { "rwf", "\u0ea3\u0eb0\u200b\u0ea7\u0eb1\u0e99\u200b\u0e94\u0eb1\u0e99 \u0e9f\u0ea3\u0eb1\u0e87" },
            { "sar", "\u0e8a\u0eb2\u200b\u0ead\u0eb9\u200b\u0e94\u0eb4 \u0ea3\u0eb4\u200b\u0ea2\u0ead\u0e99" },
            { "sbd", "\u0ec2\u0e8a\u200b\u0ec2\u0ea5\u0ea1\u0ead\u0e99 \u0ec4\u0ead\u200b\u0ec1\u0ea5\u0e99 \u0ec2\u0e94\u200b\u0ea5\u0ec8\u0eb2" },
            { "scr", "\u0ec0\u0e8a\u200b\u0ec0\u0e8a\u0ea7\u200b\u0ea5\u0ead\u0e8d\u200b\u0eaa\u0ecc \u0ea3\u0eb9\u200b\u0e9b\u0eb5" },
            { "sdd", "\u0e94\u0eb5\u0e99\u0eb2 \u0e8a\u0eb9\u0e94\u0eb2\u0e99\u0ec0\u0e81\u0ebb\u0ec8\u0eb2" },
            { "sdg", "\u0e8a\u0eb9\u200b\u0e94\u0eb2\u0e99\u200b\u0e99\u0eb5\u200b\u0eaa \u0e9e\u0eb2\u0ea7\u0e94\u0ecc" },
            { "sdp", "\u0e9b\u0ead\u0e99 \u0e8a\u0eb9\u0e94\u0eb2\u0e99\u0ec0\u0e81\u0ebb\u0ec8\u0eb2" },
            { "sek", "\u0eaa\u0eb0\u200b\u0ea7\u0eb5\u200b\u0e94\u0eb4\u200b\u0e8a \u0ec2\u0e84\u0ea3\u200b\u0e99\u0eb2" },
            { "sgd", "\u0eaa\u0eb4\u0e87\u200b\u0e81\u0eb0\u200b\u0ec2\u0e9b \u0ec2\u0e94\u200b\u0ea5\u0ec8\u0eb2" },
            { "shp", "\u0ec0\u0e8a\u0e99 \u0ec0\u0eae\u200b\u0ec0\u0ea5\u200b\u0e99\u0eb2 \u0e9e\u0eb2\u0ea7\u0e94\u0ecc" },
            { "sit", "\u0ec2\u0e95\u0ea5\u0eb2 \u0eaa\u0eb0\u0ec2\u0ea5\u0ea7\u0eb4\u0ec0\u0e99\u0e8d" },
            { "skk", "\u0e84\u0eb9\u0ec2\u0ea3\u0e99\u0eb2 \u0eaa\u0eb0\u0ec2\u0ea5\u0ea7\u0eb1\u0e81" },
            { "sll", "\u0ec0\u0e8a\u0e8d\u200b\u0e99\u0eb2 \u200b\u0ec0\u0ea5\u0ec2\u0ead\u200b\u0e99\u0ebd\u0e99 \u0ec0\u0ea5\u200b\u0ec2\u0ead\u0e99" },
            { "sos", "\u0ec2\u0e8a\u200b\u0ea1\u0eb2\u200b\u0ea5\u0eb4 \u0e8a\u0eb4\u0ea7\u200b\u0ea5\u0eb4\u0e87" },
            { "srd", "\u0e8a\u0eb9\u200b\u0ea3\u0eb4\u200b\u0e99\u0eb2\u200b\u0ea1\u0eb5\u200b\u0eaa \u0ec2\u0e94\u200b\u0ea5\u0ec8\u0eb2" },
            { "srg", "\u0e81\u0eb4\u0ea5\u0ec0\u0e94\u0eb5 \u0e8a\u0eb9\u0ea3\u0eb4\u0e99\u0eb2\u0ec0\u0ea1" },
            { "ssp", "\u0ec0\u0e8a\u0ebb\u0eb2\u200b\u0e97\u0ecc \u0e8a\u0eb9\u200b\u0e94\u0eb2\u0e99\u200b\u0e99\u0eb5\u200b\u0eaa \u0e9e\u0eb2\u0ea7\u0e94\u0ecc" },
            { "std", "\u0ec0\u0e8a\u0ebb\u0eb2 \u0ec2\u0e97\u200b\u0ec0\u0ea1 \u0ec1\u0ead\u0e99 \u0e9e\u200b\u0ea3\u0eb4\u0e99\u200b\u0e8a\u0eb4\u200b\u0e9b\u0eb5 \u0ec2\u0e94\u0e9a\u0ea3\u0eb2 (1977\u20132017)" },
            { "stn", "\u0ec0\u0e8a\u0ebb\u0eb2 \u0ec2\u0e97\u200b\u0ec0\u0ea1 \u0ec1\u0ead\u0e99 \u0e9e\u200b\u0ea3\u0eb4\u0e99\u200b\u0e8a\u0eb4\u200b\u0e9b\u0eb5 \u0ec2\u0e94\u0e9a\u0ea3\u0eb2" },
            { "sur", "\u0ea3\u0eb9\u0ec2\u0e9a \u0ec2\u0e8a\u0ea7\u0ebd\u0e94" },
            { "svc", "\u0ec2\u0e81\u0ea5\u0ead\u0e87 \u0ec0\u0ead\u0e81\u0eb2\u0ea7\u0eb2\u0e94\u0ecd" },
            { "syp", "\u0e8a\u0eb5\u200b\u0ea3\u0ebd\u0e99 \u0e9e\u0eb2\u0ea7\u0e94\u0ecc" },
            { "szl", "\u0eaa\u0eb0\u200b\u0ea7\u0eb2\u200b\u0e8a\u0eb4 \u0ea5\u0eb4\u200b\u0ea5\u0eb1\u0e99\u200b\u0e81\u0eb4\u200b\u0e99\u0eb5" },
            { "thb", "\u0ec4\u0e97 \u0e9a\u0eb2\u0e94" },
            { "tjr", "\u0ea3\u0eb9\u0ec2\u0e9a \u0e95\u0eb1\u0e88\u0eb5\u0e81\u0eb4\u0eaa\u0e96\u0eb2\u0e99" },
            { "tjs", "\u0e97\u0eb2\u200b\u0e88\u0eb4\u200b\u0e81\u0eb4\u200b\u200b\u0e96\u0eb2\u200b\u0e99\u0eb4 \u0ec2\u0e8a\u200b\u0ec2\u0ea1\u200b\u0e99\u0eb4" },
            { "tmm", "\u0ea1\u0eb2\u0e99\u0eb1\u0e94 \u0e95\u0ea7\u0e81\u0ec0\u0ea1\u0e99\u0eb4\u0eaa\u0e96\u0eb2\u0e99 (1966\u20131987)" },
            { "tmt", "\u0ec0\u0e95\u0eb5\u0e81\u200b\u0ec0\u0ea1\u200b\u0e99\u0eb4\u200b\u0eaa\u200b\u0e96\u0eb2\u200b\u0e99\u0eb4 \u0ea1\u0eb2\u200b\u0e99\u0eb1\u0e94" },
            { "tnd", "\u0e95\u0eb9\u200b\u0e99\u0eb4\u200b\u0e8a\u0ebd\u0e99 \u0e94\u0eb4\u200b\u0e99\u0eb2" },
            { "top", "\u0e95\u0ead\u0e87\u200b\u0e81\u0eb1\u0e99 \u0e9b\u0eb2\u200b\u0ead\u0eb1\u0e87\u200b\u0e81\u0eb2" },
            { "tpe", "\u0ec0\u0ead\u0eaa\u0e81\u0eb9\u0ec2\u0e94 \u0e95\u0eb5\u0ea1\u0ecd" },
            { "trl", "\u0ea5\u0eb5\u0e95\u0eb2 \u0e95\u0eb9\u0ea3\u0eb2\u0e81\u0eb5\u0ec0\u0e81\u0ebb\u0ec8\u0eb2" },
            { "try", "\u0ec0\u0e95\u0eb5\u200b\u0e81\u0eb4\u200b\u0e8a \u0ea5\u0eb4\u200b\u0ea3\u0eb2" },
            { "ttd", "\u0e97\u200b\u0ea3\u0eb4\u200b\u0e99\u0eb4\u200b\u0ec1\u0e94\u0e94 \u0ec1\u0ead\u0e99 \u0ec2\u0e97\u200b\u0e9a\u0eb2\u200b\u0ec2\u0e81 \u0ec2\u0e94\u200b\u0ea5\u0ec8\u0eb2" },
            { "twd", "\u0e99\u0eb4\u0ea7 \u0ec4\u0e95\u0ec9\u200b\u0eab\u0ea7\u0eb1\u0e99 \u0ec2\u0e94\u200b\u0ea5\u0ec8\u0eb2" },
            { "tzs", "\u0e97\u0eb2\u0e99\u200b\u0e8a\u0eb2\u200b\u0e99\u0ebd\u0e99 \u0e8a\u0eb4\u0ea7\u200b\u0ea5\u0eb4\u0e87" },
            { "uah", "\u0ea2\u0eb9\u200b\u0ec0\u0e84\u0ea3\u200b\u0e99\u0ebd\u0e99 \u0eae\u0eb0\u200b\u0ea3\u0eb5\u0e9a\u200b\u0ec0\u0e99\u0e8d" },
            { "uak", "\u0e84\u0eb2\u0ec2\u0e9a\u0ea7\u0eb2\u0ec0\u0e99\u0e94 \u0ead\u0eb9\u0ec1\u0e81\u0ea3\u0e99" },
            { "ugs", "\u0e8a\u0eb4\u0e99\u0ea5\u0eb4\u0e87 \u0ead\u0eb9\u0e81\u0eb1\u0e99\u0e94\u0eb2 (1966\u20131987)" },
            { "ugx", "\u0ead\u0eb9\u200b\u0e81\u0eb1\u0e99\u200b\u0e94\u0eb1\u0e99 \u0e8a\u0eb4\u0ea7\u200b\u0ea5\u0eb4\u0e87" },
            { "usd", "\u200b\u0ec2\u0e94\u200b\u0ea5\u0ec8\u0eb2\u200b\u0eaa\u0eb0\u200b\u0eab\u0eb0\u200b\u0ea5\u0eb1\u0e94\u0eaf" },
            { "usn", "\u0e94\u0ead\u0e99\u0ea5\u0eb2\u0eaa\u0eb0\u0eab\u0eb0\u0ea5\u0eb1\u0e94 (\u0ea1\u0eb7\u0ec9\u0e96\u0eb1\u0e94\u0ec4\u0e9b)" },
            { "uss", "\u0e94\u0ead\u0e99\u0ea5\u0eb2\u0eaa\u0eb0\u0eab\u0eb0\u0ea5\u0eb1\u0e94 (\u0ea1\u0eb7\u0ec9\u0e94\u0ebd\u0ea7\u0e81\u0eb1\u0e99)" },
            { "uyi", "\u0ec0\u0e9b\u0ec2\u0e8a\u0ead\u0eb9\u0ea3\u0eb8\u0e81\u0ea7\u0e8d (\u0eab\u0ebb\u0ea7\u0edc\u0ec8\u0ea7\u0e8d\u0ead\u0eb4\u0e99\u0ec0\u0e94\u0eb1\u0e81)" },
            { "uyp", "\u0ec0\u0e9b\u0ec2\u0e8a \u0ead\u0eb9\u0ea3\u0eb8\u0e81\u0ea7\u0e8d (1975\u20131993)" },
            { "uyu", "\u0ead\u0eb9\u200b\u0ea3\u0eb8\u200b\u0e81\u0ebb\u0ea7\u200b\u0ea2\u0eb2\u0e99 \u0ec0\u0e9b\u200b\u0ec2\u0e8a" },
            { "uzs", "\u0ead\u0eb8\u0eaa\u0ec0\u0e9a\u0e81\u0eb4\u0eaa\u0e96\u0eb2\u0e99\u0eb4 \u0ec2\u0e8a\u0ea1" },
            { "veb", "\u0ec2\u0e9a\u0ea5\u0eb5\u0ea7\u0eb2 \u0ec0\u0ea7\u0ec0\u0e99\u0e8a\u0eb9\u0ec0\u0ead\u0ea5\u0eb2 (1871\u20132008)" },
            { "vef", "\u0ec0\u0ea7\u200b\u0ec0\u0e99\u200b\u0e8a\u0eb9\u200b\u0ec0\u0ead\u200b\u0ea5\u0eb1\u0e99 \u0ec2\u0e9a\u200b\u0ea5\u0eb4\u200b\u0ea7\u0eb2 (2008\u20132018)" },
            { "ves", "\u0ec0\u0ea7\u200b\u0ec0\u0e99\u200b\u0e8a\u0eb9\u200b\u0ec0\u0ead\u200b\u0ea5\u0eb1\u0e99 \u0ec2\u0e9a\u200b\u0ea5\u0eb4\u200b\u0ea7\u0eb2" },
            { "vnd", "\u0eab\u0ea7\u0ebd\u0e94\u200b\u0e99\u0eb2\u0ea1 \u0e94\u0ebb\u0e87" },
            { "vnn", "\u0e94\u0ebb\u0e87 \u0eab\u0ea7\u0ebd\u0e94\u0e99\u0eb2\u0ea1 (1978\u20131985)" },
            { "vuv", "\u200b\u0ea7\u0eb2\u200b\u0e99\u0ebb\u0ea7\u200b\u0e95\u0eb9 \u0ea7\u0eb2\u200b\u0e95\u0eb9" },
            { "wst", "\u0e8a\u0eb2\u200b\u0ec2\u0ea1\u0e99 \u0e97\u0eb2\u200b\u0ea5\u0eb2" },
            { "xaf", "\u0eaa\u0eb2\u0e97\u0eb2\u0ea5\u0eb0\u0e99\u0eb0\u0ea5\u0eb1\u0e94\u0ead\u0eb2\u0e9f\u0ea3\u0eb4\u0e81\u0eb2\u0e81\u0eb2\u0e87" },
            { "xag", "\u0ec0\u0e87\u0eb4\u0e99" },
            { "xau", "\u0e84\u0eb3" },
            { "xba", "\u0eab\u0ebb\u0ea7\u0edc\u0ec8\u0ea7\u0e8d\u0e84\u0ead\u0ea1\u0ec2\u0e9b\u0e8a\u0eb4\u0e94 \u0ec0\u0ead\u0eb5\u0ea3\u0ebb\u0e9a" },
            { "xbb", "\u0eab\u0ebb\u0ea7\u0edc\u0ec8\u0ea7\u0e8d\u0ec2\u0ea1\u0e99\u0eb5\u0ec1\u0e97\u0ea3\u0eb5 \u0ec0\u0ead\u0eb5\u0ea3\u0ebb\u0e9a" },
            { "xbc", "\u0eab\u0ebb\u0ea7\u0edc\u0ec8\u0ea7\u0e8d\u0e9a\u0eb1\u0e99\u0e8a\u0eb5\u0ec0\u0ead\u0eb5\u0ea3\u0ebb\u0e9a (XBC)" },
            { "xbd", "\u0eab\u0ebb\u0ea7\u0edc\u0ec8\u0ea7\u0e8d\u0e9a\u0eb1\u0e99\u0e8a\u0eb5\u0ec0\u0ead\u0eb5\u0ea3\u0ebb\u0e9a (XBD)" },
            { "xcd", "\u0ead\u0eb5\u200b\u0eaa \u0e84\u0eb2\u200b\u0ea3\u0eb4\u200b\u0e9a\u0ebd\u0e99 \u0ec2\u0e94\u200b\u0ea5\u0ec8\u0eb2" },
            { "xdr", "\u0eaa\u0eb4\u0e94\u0e97\u0eb4\u0e96\u0ead\u0e99\u0ec0\u0e87\u0eb4\u0e99\u0e9e\u0eb4\u0ec0\u0eaa\u0e94" },
            { "xeu", "\u0eab\u0ebb\u0ea7\u0edc\u0ec8\u0ea7\u0e8d\u0eaa\u0eb0\u0e81\u0eb8\u0e99\u0ec0\u0e87\u0eb4\u0e99 \u0ec0\u0ead\u0eb5\u0ea3\u0ebb\u0e9a" },
            { "xfo", "\u0e9f\u0ea3\u0eb1\u0e87 \u0e84\u0eb3\u0e9d\u0ea3\u0eb1\u0ec8\u0e87" },
            { "xfu", "\u0e9f\u0ea3\u0eb1\u0e87 \u0ea2\u0eb9\u0ec4\u0ead\u0e8a\u0eb5 \u0e9d\u0ea3\u0eb1\u0ec8\u0e87" },
            { "xof", "\u0e9f\u0eb1\u0e87\u0ec0\u0e8a\u0e9f\u0eb2\u0e99 \u0ead\u0eb2\u0e9f\u0ea3\u0eb4\u0e81\u0eb2\u0e95\u0eb2\u0ec0\u0ea7\u0eb1\u0e99\u0e95\u0ebb\u0e81" },
            { "xpd", "\u0ec1\u0e9e\u0ec0\u0ea5\u0e94\u0ebd\u0ea1" },
            { "xpf", "\u0e8a\u0eb5\u200b\u0ec0\u0ead\u0eb1\u0e9a\u200b\u0e9e\u0eb5 \u0e9f\u0ea3\u0eb1\u0e87" },
            { "xpt", "\u0ec1\u0e9e\u0ea5\u0eb1\u0e94\u0e95\u0eb4\u0e99\u0eb3" },
            { "xre", "\u0e81\u0ead\u0e87\u0e97\u0eb6\u0e99\u0ec4\u0ea3\u0ec0\u0e99\u0eb1\u0e94" },
            { "xts", "\u0ea5\u0eb0\u0eab\u0eb1\u0e94\u0e97\u0ebb\u0e94\u0eaa\u0ead\u0e9a\u0eaa\u0eb0\u0e81\u0eb8\u0e99\u0ec0\u0e87\u0eb4\u0e99" },
            { "xxx", "\u0eaa\u0eb0\u0e81\u0eb8\u0e99\u0ec0\u0e87\u0eb4\u0e99\u0e97\u0eb5\u0ec8\u0e9a\u0ecd\u0ec8\u0eae\u0eb9\u0ec9\u0e88\u0eb1\u0e81" },
            { "ydd", "\u0e94\u0eb5\u0e99\u0eb2 \u0ec0\u0ea2\u0ec0\u0ea1\u0e99" },
            { "yer", "\u0ec0\u0ea2\u200b\u0ec0\u0ea1\u200b\u0e99\u0eb4 \u0ea3\u0ebd\u0ea7" },
            { "yud", "\u0eae\u0eb2\u0e94\u0e94\u0eb5\u0e99\u0eb2 \u0ea2\u0eb9\u0ec2\u0e81\u0eaa\u0eb0\u0ea5\u0eb2\u0ea7\u0eb5" },
            { "yum", "\u0e94\u0eb5\u0e99\u0eb2\u0ec3\u0edd\u0ec8 \u0ea2\u0eb9\u0ec2\u0e81\u0eaa\u0eb0\u0ea5\u0eb2\u0ea7\u0eb5 (1994\u20132002)" },
            { "yun", "\u0e94\u0eb5\u0e99\u0eb2 \u0e97\u0eb5\u0ec8\u0e9b\u0ec8\u0ebd\u0e99\u0eaa\u0eb0\u0e9e\u0eb2\u0e9a \u0ea2\u0eb9\u0ec2\u0e81\u0eaa\u0eb0\u0ea5\u0eb2\u0ea7\u0eb5 (1990\u20131992)" },
            { "yur", "\u0e94\u0eb5\u0e99\u0eb2 \u0e9b\u0eb0\u0e95\u0eb4\u0eae\u0eb9\u0e9a \u0ea2\u0eb9\u0ec2\u0e81\u0eaa\u0eb0\u0ea5\u0eb2\u0ea7\u0eb5 (1992\u20131993)" },
            { "zal", "\u0ec1\u0ea3\u0e99 \u0ead\u0eb2\u0e9f\u0ea3\u0eb4\u0e81\u0eb2\u0ec3\u0e95\u0ec9 (\u0e81\u0eb2\u0e99\u0ec0\u0e87\u0eb4\u0e99)" },
            { "zar", "\u0ec0\u0e8a\u0ebb\u0eb2\u0e97\u0ecc \u0ead\u0eb2\u200b\u0e9f\u0ea3\u0eb4\u200b\u0e81\u0eb1\u0e99 \u0ec1\u0ea3\u0e99\u0e94\u0ecc" },
            { "zmk", "\u0e84\u0ea7\u0eb2\u0e8a\u0eb2 \u0e8a\u0eb1\u0ea1\u0ec0\u0e9a\u0e8d (1968\u20132012)" },
            { "zmw", "\u0ec1\u0e8a\u0ea1\u200b\u0e9a\u0ebd\u0e99 \u0e84\u0ea7\u0eb2\u200b\u0e8a\u0eb2" },
            { "zrn", "\u0ec1\u0e8a \u0e84\u0ead\u0e87\u0ec2\u0e81\u0ec3\u0edd\u0ec8" },
            { "zrz", "\u0ec1\u0e8a\u0e84\u0ead\u0e87\u0ec2\u0e81" },
            { "zwd", "\u0e94\u0ead\u0e99\u0ea5\u0eb2 \u0e8a\u0eb4\u0ea1\u0e9a\u0eb1\u0e9a\u0ec0\u0ea7 (1980\u20132008)" },
            { "zwl", "\u0e94\u0ead\u0e99\u0ea5\u0eb2 \u0e8a\u0eb4\u0ea1\u0e9a\u0eb1\u0e9a\u0ec0\u0ea7 (2009)" },
            { "zwr", "\u0e94\u0ead\u0e99\u0ea5\u0eb2 \u0e8a\u0eb4\u0ea1\u0e9a\u0eb1\u0e9a\u0ec0\u0ea7 (2008)" },
        };
        return data;
    }
}
