/*
 * Copyright (c) 2012, 2022, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class CurrencyNames_th extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final Object[][] data = new Object[][] {
            { "AUD", "AU$" },
            { "CNH", "CNH" },
            { "JPY", "\u00a5" },
            { "STN", "STN" },
            { "THB", "\u0e3f" },
            { "XXX", "XXX" },
            { "adp", "\u0e40\u0e1b\u0e40\u0e0b\u0e15\u0e32\u0e2d\u0e31\u0e19\u0e14\u0e2d\u0e23\u0e4c\u0e23\u0e32" },
            { "aed", "\u0e40\u0e14\u0e2d\u0e23\u0e4c\u0e41\u0e2e\u0e21\u0e2a\u0e2b\u0e23\u0e31\u0e10\u0e2d\u0e32\u0e2b\u0e23\u0e31\u0e1a\u0e40\u0e2d\u0e21\u0e34\u0e40\u0e23\u0e15\u0e2a\u0e4c" },
            { "afa", "\u0e2d\u0e31\u0e1f\u0e01\u0e32\u0e19\u0e35\u0e2d\u0e31\u0e1f\u0e01\u0e32\u0e19\u0e34\u0e2a\u0e16\u0e32\u0e19 (1927\u20132002)" },
            { "afn", "\u0e2d\u0e31\u0e1f\u0e01\u0e32\u0e19\u0e34\u0e2d\u0e31\u0e1f\u0e01\u0e32\u0e19\u0e34\u0e2a\u0e16\u0e32\u0e19" },
            { "all", "\u0e40\u0e25\u0e01\u0e41\u0e2d\u0e25\u0e40\u0e1a\u0e40\u0e19\u0e35\u0e22" },
            { "amd", "\u0e41\u0e14\u0e23\u0e21\u0e2d\u0e32\u0e23\u0e4c\u0e40\u0e21\u0e40\u0e19\u0e35\u0e22" },
            { "ang", "\u0e01\u0e34\u0e25\u0e40\u0e14\u0e2d\u0e23\u0e4c\u0e40\u0e19\u0e40\u0e18\u0e2d\u0e23\u0e4c\u0e41\u0e25\u0e19\u0e14\u0e4c\u0e41\u0e2d\u0e19\u0e17\u0e34\u0e25\u0e25\u0e34\u0e2a" },
            { "aoa", "\u0e01\u0e27\u0e32\u0e19\u0e0b\u0e32\u0e41\u0e2d\u0e07\u0e42\u0e01\u0e25\u0e32" },
            { "aok", "\u0e01\u0e27\u0e32\u0e19\u0e0b\u0e32\u0e41\u0e2d\u0e07\u0e42\u0e01\u0e25\u0e32 (1977\u20131990)" },
            { "aon", "\u0e19\u0e34\u0e27\u0e01\u0e27\u0e32\u0e19\u0e0b\u0e32\u0e41\u0e2d\u0e07\u0e42\u0e01\u0e25\u0e32 (1990\u20132000)" },
            { "aor", "\u0e01\u0e27\u0e32\u0e19\u0e0b\u0e32\u0e23\u0e35\u0e08\u0e31\u0e2a\u0e17\u0e32\u0e42\u0e14\u0e41\u0e2d\u0e07\u0e42\u0e01\u0e25\u0e32 (1995\u20131999)" },
            { "ara", "\u0e2d\u0e2d\u0e2a\u0e15\u0e23\u0e31\u0e25\u0e2d\u0e32\u0e23\u0e4c\u0e40\u0e08\u0e19\u0e15\u0e34\u0e19\u0e32" },
            { "arl", "\u0e40\u0e1b\u0e42\u0e0b\u0e40\u0e25\u0e22\u0e4c\u0e2d\u0e32\u0e23\u0e4c\u0e40\u0e08\u0e19\u0e15\u0e34\u0e19\u0e32 (1970\u20131983)" },
            { "arm", "\u0e40\u0e1b\u0e42\u0e0b\u0e2d\u0e32\u0e23\u0e4c\u0e40\u0e08\u0e19\u0e15\u0e34\u0e19\u0e32 (1881\u20131970)" },
            { "arp", "\u0e40\u0e1b\u0e42\u0e0b\u0e2d\u0e32\u0e23\u0e4c\u0e40\u0e08\u0e19\u0e15\u0e34\u0e19\u0e32 (1983\u20131985)" },
            { "ars", "\u0e40\u0e1b\u0e42\u0e0b\u0e2d\u0e32\u0e23\u0e4c\u0e40\u0e08\u0e19\u0e15\u0e34\u0e19\u0e32" },
            { "ats", "\u0e0a\u0e34\u0e25\u0e25\u0e34\u0e07\u0e2d\u0e2d\u0e2a\u0e40\u0e15\u0e23\u0e35\u0e22" },
            { "aud", "\u0e14\u0e2d\u0e25\u0e25\u0e32\u0e23\u0e4c\u0e2d\u0e2d\u0e2a\u0e40\u0e15\u0e23\u0e40\u0e25\u0e35\u0e22" },
            { "awg", "\u0e1f\u0e25\u0e2d\u0e23\u0e34\u0e19\u0e2d\u0e32\u0e23\u0e39\u0e1a\u0e32" },
            { "azm", "\u0e21\u0e32\u0e19\u0e31\u0e15\u0e2d\u0e32\u0e40\u0e0b\u0e2d\u0e23\u0e4c\u0e44\u0e1a\u0e08\u0e32\u0e19 (1993\u20132006)" },
            { "azn", "\u0e21\u0e32\u0e19\u0e31\u0e15\u0e2d\u0e32\u0e40\u0e0b\u0e2d\u0e23\u0e4c\u0e44\u0e1a\u0e08\u0e32\u0e19" },
            { "bad", "\u0e14\u0e35\u0e19\u0e32\u0e23\u0e4c\u0e1a\u0e2d\u0e2a\u0e40\u0e19\u0e35\u0e22-\u0e40\u0e2e\u0e2d\u0e23\u0e4c\u0e40\u0e0b\u0e42\u0e01\u0e27\u0e35\u0e19\u0e32" },
            { "bam", "\u0e21\u0e32\u0e23\u0e4c\u0e01\u0e1a\u0e2d\u0e2a\u0e40\u0e19\u0e35\u0e22-\u0e40\u0e2e\u0e2d\u0e23\u0e4c\u0e40\u0e0b\u0e42\u0e01\u0e27\u0e35\u0e19\u0e32" },
            { "ban", "\u0e14\u0e35\u0e19\u0e32\u0e23\u0e4c\u0e43\u0e2b\u0e21\u0e48\u0e1a\u0e2d\u0e2a\u0e40\u0e19\u0e35\u0e22-\u0e40\u0e2e\u0e2d\u0e23\u0e4c\u0e40\u0e0b\u0e42\u0e01\u0e27\u0e35\u0e19\u0e32 (1994\u20131997)" },
            { "bbd", "\u0e14\u0e2d\u0e25\u0e25\u0e32\u0e23\u0e4c\u0e1a\u0e32\u0e23\u0e4c\u0e40\u0e1a\u0e42\u0e14\u0e2a" },
            { "bdt", "\u0e15\u0e32\u0e01\u0e32\u0e1a\u0e31\u0e07\u0e01\u0e25\u0e32\u0e40\u0e17\u0e28" },
            { "bec", "\u0e1f\u0e23\u0e31\u0e07\u0e01\u0e4c\u0e40\u0e1a\u0e25\u0e40\u0e22\u0e35\u0e22\u0e21 (\u0e40\u0e1b\u0e25\u0e35\u0e48\u0e22\u0e19\u0e41\u0e1b\u0e25\u0e07\u0e44\u0e14\u0e49)" },
            { "bef", "\u0e1f\u0e23\u0e31\u0e07\u0e01\u0e4c\u0e40\u0e1a\u0e25\u0e40\u0e22\u0e35\u0e22\u0e21" },
            { "bel", "\u0e1f\u0e23\u0e31\u0e07\u0e01\u0e4c\u0e40\u0e1a\u0e25\u0e40\u0e22\u0e35\u0e22\u0e21 (\u0e01\u0e32\u0e23\u0e40\u0e07\u0e34\u0e19)" },
            { "bgl", "\u0e2e\u0e32\u0e23\u0e4c\u0e14\u0e40\u0e25\u0e1f\u0e1a\u0e31\u0e25\u0e41\u0e01\u0e40\u0e23\u0e35\u0e22" },
            { "bgm", "\u0e42\u0e0b\u0e40\u0e0a\u0e35\u0e22\u0e25\u0e25\u0e34\u0e2a\u0e15\u0e4c\u0e40\u0e25\u0e1f\u0e1a\u0e31\u0e25\u0e41\u0e01\u0e40\u0e23\u0e35\u0e22" },
            { "bgn", "\u0e40\u0e25\u0e1f\u0e1a\u0e31\u0e25\u0e41\u0e01\u0e40\u0e23\u0e35\u0e22" },
            { "bgo", "\u0e40\u0e25\u0e1f\u0e1a\u0e31\u0e25\u0e40\u0e01\u0e40\u0e23\u0e35\u0e22 (1879\u20131952)" },
            { "bhd", "\u0e14\u0e35\u0e19\u0e32\u0e23\u0e4c\u0e1a\u0e32\u0e2b\u0e4c\u0e40\u0e23\u0e19" },
            { "bif", "\u0e1f\u0e23\u0e31\u0e07\u0e01\u0e4c\u0e1a\u0e38\u0e23\u0e38\u0e19\u0e14\u0e35" },
            { "bmd", "\u0e14\u0e2d\u0e25\u0e25\u0e32\u0e23\u0e4c\u0e40\u0e1a\u0e2d\u0e23\u0e4c\u0e21\u0e34\u0e27\u0e14\u0e32" },
            { "bnd", "\u0e14\u0e2d\u0e25\u0e25\u0e32\u0e23\u0e4c\u0e1a\u0e23\u0e39\u0e44\u0e19" },
            { "bob", "\u0e42\u0e1a\u0e25\u0e34\u0e40\u0e27\u0e35\u0e22\u0e42\u0e19\u0e42\u0e1a\u0e25\u0e34\u0e40\u0e27\u0e35\u0e22" },
            { "bol", "\u0e42\u0e1a\u0e25\u0e34\u0e40\u0e27\u0e35\u0e22\u0e42\u0e19\u0e42\u0e1a\u0e25\u0e34\u0e40\u0e27\u0e35\u0e22 (1863\u20131963)" },
            { "bop", "\u0e40\u0e1b\u0e42\u0e0b\u0e42\u0e1a\u0e25\u0e34\u0e40\u0e27\u0e35\u0e22" },
            { "bov", "\u0e21\u0e1f\u0e14\u0e2d\u0e25\u0e42\u0e1a\u0e25\u0e34\u0e40\u0e27\u0e35\u0e22" },
            { "brb", "\u0e04\u0e23\u0e39\u0e40\u0e0b\u0e42\u0e23\u0e42\u0e19\u0e42\u0e27\u0e1a\u0e23\u0e32\u0e0b\u0e34\u0e25 (1967\u20131986)" },
            { "brc", "\u0e04\u0e23\u0e39\u0e0b\u0e32\u0e42\u0e14\u0e1a\u0e23\u0e32\u0e0b\u0e34\u0e25" },
            { "bre", "\u0e04\u0e23\u0e39\u0e40\u0e0b\u0e42\u0e23\u0e1a\u0e23\u0e32\u0e0b\u0e34\u0e25 (1990\u20131993)" },
            { "brl", "\u0e40\u0e23\u0e35\u0e22\u0e25\u0e1a\u0e23\u0e32\u0e0b\u0e34\u0e25" },
            { "brn", "\u0e04\u0e23\u0e39\u0e0b\u0e32\u0e42\u0e14\u0e42\u0e19\u0e42\u0e27\u0e1a\u0e23\u0e32\u0e0b\u0e34\u0e25" },
            { "brr", "\u0e04\u0e23\u0e39\u0e40\u0e0b\u0e42\u0e23\u0e1a\u0e23\u0e32\u0e0b\u0e34\u0e25" },
            { "brz", "\u0e04\u0e23\u0e39\u0e40\u0e0b\u0e42\u0e23\u0e1a\u0e23\u0e32\u0e0b\u0e34\u0e25 (1942\u20131967)" },
            { "bsd", "\u0e14\u0e2d\u0e25\u0e25\u0e32\u0e23\u0e4c\u0e1a\u0e32\u0e2e\u0e32\u0e21\u0e32\u0e2a" },
            { "btn", "\u0e40\u0e2d\u0e47\u0e07\u0e01\u0e38\u0e25\u0e15\u0e23\u0e31\u0e21\u0e20\u0e39\u0e0f\u0e32\u0e19" },
            { "buk", "\u0e08\u0e4a\u0e32\u0e14\u0e1e\u0e21\u0e48\u0e32" },
            { "bwp", "\u0e1b\u0e39\u0e25\u0e32\u0e1a\u0e2d\u0e15\u0e2a\u0e27\u0e32\u0e19\u0e32" },
            { "byb", "\u0e19\u0e34\u0e27\u0e23\u0e39\u0e40\u0e1a\u0e34\u0e25\u0e40\u0e1a\u0e25\u0e32\u0e23\u0e38\u0e2a (1994\u20131999)" },
            { "byn", "\u0e23\u0e39\u0e40\u0e1a\u0e34\u0e25\u0e40\u0e1a\u0e25\u0e32\u0e23\u0e38\u0e2a" },
            { "byr", "\u0e23\u0e39\u0e40\u0e1a\u0e34\u0e25\u0e40\u0e1a\u0e25\u0e32\u0e23\u0e38\u0e2a (2000\u20132016)" },
            { "bzd", "\u0e14\u0e2d\u0e25\u0e25\u0e32\u0e23\u0e4c\u0e40\u0e1a\u0e25\u0e35\u0e0b" },
            { "cad", "\u0e14\u0e2d\u0e25\u0e25\u0e32\u0e23\u0e4c\u0e41\u0e04\u0e19\u0e32\u0e14\u0e32" },
            { "cdf", "\u0e1f\u0e23\u0e31\u0e07\u0e01\u0e4c\u0e04\u0e2d\u0e07\u0e42\u0e01" },
            { "che", "\u0e22\u0e39\u0e42\u0e23\u0e14\u0e31\u0e1a\u0e40\u0e1a\u0e34\u0e25\u0e22\u0e39\u0e44\u0e2d\u0e2d\u0e32\u0e23\u0e4c" },
            { "chf", "\u0e1f\u0e23\u0e31\u0e07\u0e01\u0e4c\u0e2a\u0e27\u0e34\u0e2a" },
            { "chw", "\u0e1f\u0e23\u0e31\u0e07\u0e01\u0e4c\u0e14\u0e31\u0e1a\u0e40\u0e1a\u0e34\u0e25\u0e22\u0e39\u0e44\u0e2d\u0e2d\u0e32\u0e23\u0e4c" },
            { "cle", "\u0e40\u0e2d\u0e2a\u0e04\u0e39\u0e42\u0e14\u0e0a\u0e34\u0e25\u0e35" },
            { "clf", "\u0e1f\u0e39\u0e40\u0e21\u0e19\u0e42\u0e15\u0e0a\u0e34\u0e25\u0e35" },
            { "clp", "\u0e40\u0e1b\u0e42\u0e0b\u0e0a\u0e34\u0e25\u0e35" },
            { "cnh", "\u0e2b\u0e22\u0e27\u0e19" },
            { "cny", "\u0e2b\u0e22\u0e27\u0e19\u0e08\u0e35\u0e19" },
            { "cop", "\u0e40\u0e1b\u0e42\u0e0b\u0e42\u0e04\u0e25\u0e2d\u0e21\u0e40\u0e1a\u0e35\u0e22" },
            { "cou", "\u0e27\u0e32\u0e40\u0e25\u0e2d\u0e23\u0e4c\u0e40\u0e23\u0e35\u0e22\u0e25\u0e42\u0e04\u0e25\u0e2d\u0e21\u0e40\u0e1a\u0e35\u0e22" },
            { "crc", "\u0e42\u0e01\u0e25\u0e2d\u0e07\u0e04\u0e2d\u0e2a\u0e15\u0e32\u0e23\u0e34\u0e01\u0e32" },
            { "csd", "\u0e14\u0e35\u0e19\u0e32\u0e23\u0e4c\u0e40\u0e0b\u0e2d\u0e23\u0e4c\u0e40\u0e1a\u0e35\u0e22\u0e40\u0e01\u0e48\u0e32" },
            { "csk", "\u0e2e\u0e32\u0e23\u0e4c\u0e14\u0e42\u0e04\u0e23\u0e39\u0e19\u0e32\u0e40\u0e0a\u0e47\u0e01\u0e42\u0e01\u0e2a\u0e42\u0e25\u0e27\u0e31\u0e01" },
            { "cuc", "\u0e40\u0e1b\u0e42\u0e0b\u0e04\u0e34\u0e27\u0e1a\u0e32 (\u0e41\u0e1b\u0e25\u0e07\u0e2a\u0e20\u0e32\u0e1e)" },
            { "cup", "\u0e40\u0e1b\u0e42\u0e0b\u0e04\u0e34\u0e27\u0e1a\u0e32" },
            { "cve", "\u0e40\u0e2d\u0e2a\u0e04\u0e39\u0e42\u0e14\u0e40\u0e04\u0e1b\u0e40\u0e27\u0e34\u0e23\u0e4c\u0e14" },
            { "cyp", "\u0e1b\u0e2d\u0e19\u0e14\u0e4c\u0e44\u0e0b\u0e1b\u0e23\u0e31\u0e2a" },
            { "czk", "\u0e42\u0e04\u0e23\u0e39\u0e19\u0e32\u0e2a\u0e32\u0e18\u0e32\u0e23\u0e13\u0e23\u0e31\u0e10\u0e40\u0e0a\u0e47\u0e01" },
            { "ddm", "\u0e21\u0e32\u0e23\u0e4c\u0e01\u0e40\u0e22\u0e2d\u0e23\u0e21\u0e31\u0e19\u0e15\u0e30\u0e27\u0e31\u0e19\u0e2d\u0e2d\u0e01" },
            { "dem", "\u0e21\u0e32\u0e23\u0e4c\u0e01\u0e40\u0e22\u0e2d\u0e23\u0e21\u0e31\u0e19" },
            { "djf", "\u0e1f\u0e23\u0e31\u0e07\u0e01\u0e4c\u0e08\u0e34\u0e1a\u0e39\u0e15\u0e35" },
            { "dkk", "\u0e42\u0e04\u0e23\u0e19\u0e40\u0e14\u0e19\u0e21\u0e32\u0e23\u0e4c\u0e01" },
            { "dop", "\u0e40\u0e1b\u0e42\u0e0b\u0e42\u0e14\u0e21\u0e34\u0e19\u0e34\u0e01\u0e31\u0e19" },
            { "dzd", "\u0e14\u0e35\u0e19\u0e32\u0e23\u0e4c\u0e41\u0e2d\u0e25\u0e08\u0e35\u0e40\u0e23\u0e35\u0e22" },
            { "ecs", "\u0e0b\u0e39\u0e40\u0e01\u0e23\u0e40\u0e2d\u0e01\u0e27\u0e32\u0e14\u0e2d\u0e23\u0e4c" },
            { "ecv", "\u0e27\u0e32\u0e40\u0e25\u0e2d\u0e23\u0e4c\u0e04\u0e2d\u0e19\u0e2a\u0e41\u0e15\u0e19\u0e15\u0e4c\u0e40\u0e2d\u0e01\u0e27\u0e32\u0e14\u0e2d\u0e23\u0e4c" },
            { "eek", "\u0e04\u0e23\u0e39\u0e19\u0e40\u0e2d\u0e2a\u0e42\u0e15\u0e40\u0e19\u0e35\u0e22" },
            { "egp", "\u0e1b\u0e2d\u0e19\u0e14\u0e4c\u0e2d\u0e35\u0e22\u0e34\u0e1b\u0e15\u0e4c" },
            { "ern", "\u0e41\u0e19\u0e01\u0e1f\u0e32\u0e40\u0e2d\u0e23\u0e34\u0e40\u0e17\u0e23\u0e35\u0e22" },
            { "esa", "\u0e40\u0e1b\u0e40\u0e0b\u0e15\u0e32\u0e2a\u0e40\u0e1b\u0e19 (\u0e1a\u0e31\u0e0d\u0e0a\u0e35\u0e40\u0e2d)" },
            { "esb", "\u0e40\u0e1b\u0e40\u0e0b\u0e15\u0e32\u0e2a\u0e40\u0e1b\u0e19 (\u0e1a\u0e31\u0e0d\u0e0a\u0e35\u0e17\u0e35\u0e48\u0e40\u0e1b\u0e25\u0e35\u0e48\u0e22\u0e19\u0e41\u0e1b\u0e25\u0e07\u0e44\u0e14\u0e49)" },
            { "esp", "\u0e40\u0e1b\u0e40\u0e0b\u0e15\u0e32\u0e2a\u0e40\u0e1b\u0e19" },
            { "etb", "\u0e40\u0e1a\u0e2d\u0e23\u0e23\u0e4c\u0e40\u0e2d\u0e18\u0e34\u0e42\u0e2d\u0e40\u0e1b\u0e35\u0e22" },
            { "eur", "\u0e22\u0e39\u0e42\u0e23" },
            { "fim", "\u0e21\u0e32\u0e23\u0e4c\u0e01\u0e01\u0e32\u0e1f\u0e34\u0e19\u0e41\u0e25\u0e19\u0e14\u0e4c" },
            { "fjd", "\u0e14\u0e2d\u0e25\u0e25\u0e32\u0e23\u0e4c\u0e1f\u0e34\u0e08\u0e34" },
            { "fkp", "\u0e1b\u0e2d\u0e19\u0e14\u0e4c\u0e2b\u0e21\u0e39\u0e48\u0e40\u0e01\u0e32\u0e30\u0e1f\u0e2d\u0e25\u0e4c\u0e01\u0e41\u0e25\u0e19\u0e14\u0e4c" },
            { "frf", "\u0e1f\u0e23\u0e31\u0e07\u0e01\u0e4c\u0e1d\u0e23\u0e31\u0e48\u0e07\u0e40\u0e28\u0e2a" },
            { "gbp", "\u0e1b\u0e2d\u0e19\u0e14\u0e4c\u0e2a\u0e40\u0e15\u0e2d\u0e23\u0e4c\u0e25\u0e34\u0e07 (\u0e2a\u0e2b\u0e23\u0e32\u0e0a\u0e2d\u0e32\u0e13\u0e32\u0e08\u0e31\u0e01\u0e23)" },
            { "gek", "\u0e04\u0e39\u0e1b\u0e2d\u0e19\u0e25\u0e32\u0e23\u0e34\u0e15\u0e08\u0e2d\u0e23\u0e4c\u0e40\u0e08\u0e35\u0e22" },
            { "gel", "\u0e25\u0e32\u0e23\u0e35\u0e08\u0e2d\u0e23\u0e4c\u0e40\u0e08\u0e35\u0e22" },
            { "ghc", "\u0e40\u0e0b\u0e14\u0e35\u0e01\u0e32\u0e19\u0e32 (1979\u20132007)" },
            { "ghs", "\u0e40\u0e0b\u0e14\u0e35\u0e01\u0e32\u0e19\u0e32" },
            { "gip", "\u0e1b\u0e2d\u0e19\u0e14\u0e4c\u0e22\u0e34\u0e1a\u0e23\u0e2d\u0e25\u0e15\u0e32\u0e23\u0e4c" },
            { "gmd", "\u0e14\u0e32\u0e25\u0e32\u0e0b\u0e35\u0e41\u0e01\u0e21\u0e40\u0e1a\u0e35\u0e22" },
            { "gnf", "\u0e1f\u0e23\u0e31\u0e07\u0e01\u0e4c\u0e01\u0e34\u0e19\u0e35" },
            { "gns", "\u0e44\u0e0b\u0e25\u0e35\u0e01\u0e34\u0e19\u0e35" },
            { "gqe", "\u0e40\u0e2d\u0e47\u0e01\u0e40\u0e27\u0e40\u0e25\u0e2d\u0e34\u0e40\u0e04\u0e27\u0e17\u0e2d\u0e40\u0e23\u0e35\u0e22\u0e25\u0e01\u0e34\u0e19\u0e35" },
            { "grd", "\u0e14\u0e23\u0e31\u0e0a\u0e21\u0e32\u0e01\u0e23\u0e35\u0e01" },
            { "gtq", "\u0e40\u0e04\u0e27\u0e15\u0e0b\u0e31\u0e25\u0e01\u0e31\u0e27\u0e40\u0e15\u0e21\u0e32\u0e25\u0e32" },
            { "gwe", "\u0e40\u0e2d\u0e2a\u0e04\u0e39\u0e42\u0e14\u0e01\u0e34\u0e19\u0e35\u0e42\u0e1b\u0e23\u0e15\u0e38\u0e40\u0e01\u0e2a" },
            { "gwp", "\u0e40\u0e1b\u0e42\u0e0b\u0e01\u0e34\u0e19\u0e35-\u0e1a\u0e34\u0e2a\u0e40\u0e0b\u0e32" },
            { "gyd", "\u0e14\u0e2d\u0e25\u0e25\u0e32\u0e23\u0e4c\u0e01\u0e32\u0e22\u0e2d\u0e32\u0e19\u0e32" },
            { "hkd", "\u0e14\u0e2d\u0e25\u0e25\u0e32\u0e23\u0e4c\u0e2e\u0e48\u0e2d\u0e07\u0e01\u0e07" },
            { "hnl", "\u0e40\u0e25\u0e21\u0e1b\u0e34\u0e23\u0e32\u0e2e\u0e2d\u0e19\u0e14\u0e39\u0e23\u0e31\u0e2a" },
            { "hrd", "\u0e14\u0e35\u0e19\u0e32\u0e23\u0e4c\u0e42\u0e04\u0e23\u0e40\u0e2d\u0e40\u0e0a\u0e35\u0e22" },
            { "hrk", "\u0e04\u0e39\u0e19\u0e32\u0e42\u0e04\u0e23\u0e40\u0e2d\u0e40\u0e0a\u0e35\u0e22" },
            { "htg", "\u0e01\u0e39\u0e23\u0e4c\u0e14\u0e40\u0e2e\u0e15\u0e34" },
            { "huf", "\u0e1f\u0e2d\u0e23\u0e34\u0e19\u0e15\u0e4c\u0e2e\u0e31\u0e07\u0e01\u0e32\u0e23\u0e35" },
            { "idr", "\u0e23\u0e39\u0e40\u0e1b\u0e35\u0e22\u0e2b\u0e4c\u0e2d\u0e34\u0e19\u0e42\u0e14\u0e19\u0e35\u0e40\u0e0b\u0e35\u0e22" },
            { "iep", "\u0e1b\u0e2d\u0e19\u0e14\u0e4c\u0e44\u0e2d\u0e23\u0e34\u0e0a" },
            { "ilp", "\u0e1b\u0e2d\u0e19\u0e14\u0e4c\u0e2d\u0e34\u0e2a\u0e23\u0e32\u0e40\u0e2d\u0e25" },
            { "ils", "\u0e19\u0e34\u0e27\u0e40\u0e0a\u0e40\u0e01\u0e25\u0e2d\u0e34\u0e2a\u0e23\u0e32\u0e40\u0e2d\u0e25" },
            { "inr", "\u0e23\u0e39\u0e1b\u0e35\u0e2d\u0e34\u0e19\u0e40\u0e14\u0e35\u0e22" },
            { "iqd", "\u0e14\u0e35\u0e19\u0e32\u0e23\u0e4c\u0e2d\u0e34\u0e23\u0e31\u0e01" },
            { "irr", "\u0e40\u0e23\u0e35\u0e22\u0e25\u0e2d\u0e34\u0e2b\u0e23\u0e48\u0e32\u0e19" },
            { "isk", "\u0e42\u0e04\u0e23\u0e19\u0e32\u0e44\u0e2d\u0e0b\u0e4c\u0e41\u0e25\u0e19\u0e14\u0e4c" },
            { "itl", "\u0e25\u0e35\u0e23\u0e32\u0e2d\u0e34\u0e15\u0e32\u0e25\u0e35" },
            { "jmd", "\u0e14\u0e2d\u0e25\u0e25\u0e32\u0e23\u0e4c\u0e08\u0e32\u0e40\u0e21\u0e01\u0e32" },
            { "jod", "\u0e14\u0e35\u0e19\u0e32\u0e23\u0e4c\u0e08\u0e2d\u0e23\u0e4c\u0e41\u0e14\u0e19" },
            { "jpy", "\u0e40\u0e22\u0e19\u0e0d\u0e35\u0e48\u0e1b\u0e38\u0e48\u0e19" },
            { "kes", "\u0e0a\u0e34\u0e25\u0e25\u0e34\u0e07\u0e40\u0e04\u0e19\u0e22\u0e32" },
            { "kgs", "\u0e0b\u0e2d\u0e21\u0e04\u0e35\u0e23\u0e4c\u0e01\u0e35\u0e0b\u0e2a\u0e16\u0e32\u0e19" },
            { "khr", "\u0e40\u0e23\u0e35\u0e22\u0e25\u0e01\u0e31\u0e21\u0e1e\u0e39\u0e0a\u0e32" },
            { "kmf", "\u0e1f\u0e23\u0e31\u0e07\u0e01\u0e4c\u0e04\u0e2d\u0e42\u0e21\u0e42\u0e23\u0e2a" },
            { "kpw", "\u0e27\u0e2d\u0e19\u0e40\u0e01\u0e32\u0e2b\u0e25\u0e35\u0e40\u0e2b\u0e19\u0e37\u0e2d" },
            { "krh", "\u0e2e\u0e27\u0e32\u0e19\u0e40\u0e01\u0e32\u0e2b\u0e25\u0e35\u0e43\u0e15\u0e49 (1953\u20131962)" },
            { "kro", "\u0e27\u0e2d\u0e19\u0e40\u0e01\u0e32\u0e2b\u0e25\u0e35\u0e43\u0e15\u0e49 (1945\u20131953)" },
            { "krw", "\u0e27\u0e2d\u0e19\u0e40\u0e01\u0e32\u0e2b\u0e25\u0e35\u0e43\u0e15\u0e49" },
            { "kwd", "\u0e14\u0e35\u0e19\u0e32\u0e23\u0e4c\u0e04\u0e39\u0e40\u0e27\u0e15" },
            { "kyd", "\u0e14\u0e2d\u0e25\u0e25\u0e32\u0e23\u0e4c\u0e2b\u0e21\u0e39\u0e48\u0e40\u0e01\u0e32\u0e30\u0e40\u0e04\u0e22\u0e4c\u0e41\u0e21\u0e19" },
            { "kzt", "\u0e40\u0e17\u0e07\u0e40\u0e08\u0e04\u0e32\u0e0b\u0e31\u0e04\u0e2a\u0e16\u0e32\u0e19" },
            { "lak", "\u0e01\u0e35\u0e1a\u0e25\u0e32\u0e27" },
            { "lbp", "\u0e1b\u0e2d\u0e19\u0e14\u0e4c\u0e40\u0e25\u0e1a\u0e32\u0e19\u0e2d\u0e19" },
            { "lkr", "\u0e23\u0e39\u0e1b\u0e35\u0e28\u0e23\u0e35\u0e25\u0e31\u0e07\u0e01\u0e32" },
            { "lrd", "\u0e14\u0e2d\u0e25\u0e25\u0e32\u0e23\u0e4c\u0e44\u0e25\u0e1a\u0e35\u0e40\u0e23\u0e35\u0e22" },
            { "lsl", "\u0e42\u0e25\u0e15\u0e35\u0e40\u0e25\u0e42\u0e0b\u0e42\u0e17" },
            { "ltl", "\u0e25\u0e35\u0e15\u0e31\u0e2a\u0e25\u0e34\u0e17\u0e31\u0e27\u0e40\u0e19\u0e35\u0e22" },
            { "ltt", "\u0e17\u0e32\u0e42\u0e25\u0e19\u0e31\u0e2a\u0e25\u0e34\u0e17\u0e31\u0e27\u0e40\u0e19\u0e35\u0e22" },
            { "luc", "\u0e04\u0e2d\u0e19\u0e40\u0e27\u0e2d\u0e23\u0e4c\u0e17\u0e34\u0e40\u0e1a\u0e34\u0e25\u0e1f\u0e23\u0e31\u0e07\u0e01\u0e4c\u0e25\u0e31\u0e01\u0e40\u0e0b\u0e21\u0e40\u0e1a\u0e34\u0e23\u0e4c\u0e01" },
            { "luf", "\u0e1f\u0e23\u0e31\u0e07\u0e01\u0e4c\u0e25\u0e31\u0e01\u0e40\u0e0b\u0e21\u0e40\u0e1a\u0e34\u0e23\u0e4c\u0e01" },
            { "lul", "\u0e44\u0e1f\u0e41\u0e19\u0e25\u0e40\u0e0a\u0e35\u0e22\u0e25\u0e1f\u0e23\u0e31\u0e07\u0e01\u0e4c\u0e25\u0e31\u0e01\u0e40\u0e0b\u0e21\u0e40\u0e1a\u0e34\u0e23\u0e4c\u0e01" },
            { "lvl", "\u0e25\u0e31\u0e15\u0e2a\u0e4c\u0e25\u0e31\u0e15\u0e40\u0e27\u0e35\u0e22" },
            { "lvr", "\u0e23\u0e39\u0e40\u0e1a\u0e34\u0e25\u0e25\u0e31\u0e15\u0e40\u0e27\u0e35\u0e22" },
            { "lyd", "\u0e14\u0e35\u0e19\u0e32\u0e23\u0e4c\u0e25\u0e34\u0e40\u0e1a\u0e35\u0e22" },
            { "mad", "\u0e14\u0e35\u0e41\u0e23\u0e2b\u0e4c\u0e21\u0e42\u0e21\u0e23\u0e47\u0e2d\u0e01\u0e42\u0e01" },
            { "maf", "\u0e1f\u0e23\u0e31\u0e07\u0e01\u0e4c\u0e42\u0e21\u0e23\u0e47\u0e2d\u0e01\u0e42\u0e01" },
            { "mcf", "\u0e1f\u0e23\u0e31\u0e07\u0e01\u0e4c\u0e42\u0e21\u0e19\u0e32\u0e42\u0e01" },
            { "mdc", "\u0e1a\u0e31\u0e15\u0e23\u0e1b\u0e31\u0e19\u0e2a\u0e48\u0e27\u0e19\u0e21\u0e2d\u0e25\u0e42\u0e14\u0e27\u0e32" },
            { "mdl", "\u0e25\u0e34\u0e27\u0e21\u0e2d\u0e25\u0e42\u0e14\u0e27\u0e32" },
            { "mga", "\u0e2d\u0e32\u0e40\u0e23\u0e35\u0e22\u0e23\u0e35\u0e21\u0e32\u0e25\u0e32\u0e01\u0e32\u0e0b\u0e35" },
            { "mgf", "\u0e1f\u0e23\u0e31\u0e07\u0e01\u0e4c\u0e21\u0e32\u0e14\u0e32\u0e01\u0e31\u0e2a\u0e01\u0e32\u0e23\u0e4c" },
            { "mkd", "\u0e14\u0e35\u0e19\u0e32\u0e23\u0e4c\u0e21\u0e32\u0e0b\u0e34\u0e42\u0e14\u0e40\u0e19\u0e35\u0e22" },
            { "mkn", "\u0e14\u0e35\u0e19\u0e32\u0e23\u0e4c\u0e21\u0e32\u0e0b\u0e34\u0e42\u0e14\u0e40\u0e19\u0e35\u0e22 (1992\u20131993)" },
            { "mlf", "\u0e1f\u0e23\u0e31\u0e07\u0e01\u0e4c\u0e21\u0e32\u0e25\u0e35" },
            { "mmk", "\u0e08\u0e4a\u0e32\u0e15\u0e1e\u0e21\u0e48\u0e32" },
            { "mnt", "\u0e17\u0e39\u0e01\u0e23\u0e34\u0e01\u0e21\u0e2d\u0e07\u0e42\u0e01\u0e40\u0e25\u0e35\u0e22" },
            { "mop", "\u0e1b\u0e32\u0e15\u0e32\u0e01\u0e32\u0e21\u0e32\u0e40\u0e01\u0e4a\u0e32" },
            { "mro", "\u0e2d\u0e39\u0e01\u0e35\u0e22\u0e32\u0e21\u0e2d\u0e23\u0e34\u0e40\u0e15\u0e40\u0e19\u0e35\u0e22 (1973\u20132017)" },
            { "mru", "\u0e2d\u0e39\u0e01\u0e35\u0e22\u0e32\u0e21\u0e2d\u0e23\u0e34\u0e40\u0e15\u0e40\u0e19\u0e35\u0e22" },
            { "mtl", "\u0e25\u0e35\u0e23\u0e32\u0e21\u0e2d\u0e25\u0e15\u0e32" },
            { "mtp", "\u0e1b\u0e2d\u0e19\u0e14\u0e4c\u0e21\u0e2d\u0e25\u0e15\u0e32" },
            { "mur", "\u0e23\u0e39\u0e1b\u0e35\u0e21\u0e2d\u0e23\u0e34\u0e40\u0e0a\u0e35\u0e22\u0e2a" },
            { "mvr", "\u0e23\u0e39\u0e1f\u0e34\u0e22\u0e32\u0e21\u0e31\u0e25\u0e14\u0e35\u0e1f\u0e2a\u0e4c" },
            { "mwk", "\u0e04\u0e27\u0e32\u0e0a\u0e32\u0e21\u0e32\u0e25\u0e32\u0e27\u0e35" },
            { "mxn", "\u0e40\u0e1b\u0e42\u0e0b\u0e40\u0e21\u0e47\u0e01\u0e0b\u0e34\u0e42\u0e01" },
            { "mxp", "\u0e40\u0e07\u0e34\u0e19\u0e40\u0e1b\u0e42\u0e0b\u0e40\u0e21\u0e47\u0e01\u0e0b\u0e34\u0e42\u0e01 (1861\u20131992)" },
            { "mxv", "\u0e22\u0e39\u0e19\u0e34\u0e41\u0e14\u0e14 \u0e14\u0e35 \u0e2d\u0e34\u0e19\u0e40\u0e27\u0e2d\u0e23\u0e4c\u0e0a\u0e31\u0e48\u0e19 \u0e40\u0e21\u0e47\u0e01\u0e0b\u0e34\u0e42\u0e01" },
            { "myr", "\u0e23\u0e34\u0e07\u0e01\u0e34\u0e15\u0e21\u0e32\u0e40\u0e25\u0e40\u0e0b\u0e35\u0e22" },
            { "mze", "\u0e40\u0e2d\u0e2a\u0e04\u0e39\u0e42\u0e14\u0e42\u0e21\u0e0b\u0e31\u0e21\u0e1a\u0e34\u0e01" },
            { "mzm", "\u0e40\u0e21\u0e15\u0e34\u0e04\u0e31\u0e25\u0e42\u0e21\u0e0b\u0e31\u0e21\u0e1a\u0e34\u0e01\u0e40\u0e01\u0e48\u0e32" },
            { "mzn", "\u0e40\u0e21\u0e15\u0e34\u0e04\u0e31\u0e25\u0e42\u0e21\u0e0b\u0e31\u0e21\u0e1a\u0e34\u0e01" },
            { "nad", "\u0e14\u0e2d\u0e25\u0e25\u0e32\u0e23\u0e4c\u0e19\u0e32\u0e21\u0e34\u0e40\u0e1a\u0e35\u0e22" },
            { "ngn", "\u0e44\u0e19\u0e23\u0e32\u0e44\u0e19\u0e08\u0e35\u0e40\u0e23\u0e35\u0e22" },
            { "nic", "\u0e04\u0e2d\u0e23\u0e4c\u0e42\u0e14\u0e1a\u0e32\u0e19\u0e34\u0e01\u0e32\u0e23\u0e32\u0e01\u0e31\u0e27" },
            { "nio", "\u0e01\u0e2d\u0e23\u0e4c\u0e42\u0e14\u0e1a\u0e32\u0e19\u0e34\u0e01\u0e32\u0e23\u0e32\u0e01\u0e31\u0e27" },
            { "nlg", "\u0e01\u0e34\u0e25\u0e40\u0e14\u0e2d\u0e23\u0e4c\u0e40\u0e19\u0e40\u0e18\u0e2d\u0e23\u0e4c\u0e41\u0e25\u0e19\u0e14\u0e4c" },
            { "nok", "\u0e42\u0e04\u0e23\u0e19\u0e19\u0e2d\u0e23\u0e4c\u0e40\u0e27\u0e22\u0e4c" },
            { "npr", "\u0e23\u0e39\u0e1b\u0e35\u0e40\u0e19\u0e1b\u0e32\u0e25" },
            { "nzd", "\u0e14\u0e2d\u0e25\u0e25\u0e32\u0e23\u0e4c\u0e19\u0e34\u0e27\u0e0b\u0e35\u0e41\u0e25\u0e19\u0e14\u0e4c" },
            { "omr", "\u0e40\u0e23\u0e35\u0e22\u0e25\u0e42\u0e2d\u0e21\u0e32\u0e19" },
            { "pab", "\u0e1a\u0e31\u0e25\u0e1a\u0e31\u0e27\u0e1b\u0e32\u0e19\u0e32\u0e21\u0e32" },
            { "pei", "\u0e2d\u0e34\u0e19\u0e15\u0e35\u0e40\u0e1b\u0e23\u0e39" },
            { "pen", "\u0e0b\u0e2d\u0e25\u0e40\u0e1b\u0e23\u0e39" },
            { "pes", "\u0e0b\u0e2d\u0e25\u0e40\u0e1b\u0e23\u0e39 (1863\u20131965)" },
            { "pgk", "\u0e01\u0e35\u0e19\u0e32\u0e1b\u0e32\u0e1b\u0e31\u0e27\u0e19\u0e34\u0e27\u0e01\u0e34\u0e19\u0e35" },
            { "php", "\u0e40\u0e1b\u0e42\u0e0b\u0e1f\u0e34\u0e25\u0e34\u0e1b\u0e1b\u0e34\u0e19\u0e2a\u0e4c" },
            { "pkr", "\u0e23\u0e39\u0e1b\u0e35\u0e1b\u0e32\u0e01\u0e35\u0e2a\u0e16\u0e32\u0e19" },
            { "pln", "\u0e0b\u0e25\u0e2d\u0e15\u0e35\u0e42\u0e1b\u0e41\u0e25\u0e19\u0e14\u0e4c" },
            { "plz", "\u0e0b\u0e25\u0e2d\u0e15\u0e35\u0e42\u0e1b\u0e41\u0e25\u0e19\u0e14\u0e4c (1950\u20131995)" },
            { "pte", "\u0e40\u0e2d\u0e2a\u0e04\u0e39\u0e42\u0e14\u0e42\u0e1b\u0e23\u0e15\u0e38\u0e40\u0e01\u0e2a" },
            { "pyg", "\u0e01\u0e27\u0e32\u0e23\u0e32\u0e19\u0e35\u0e1b\u0e32\u0e23\u0e32\u0e01\u0e27\u0e31\u0e22" },
            { "qar", "\u0e40\u0e23\u0e35\u0e22\u0e25\u0e01\u0e32\u0e15\u0e32\u0e23\u0e4c" },
            { "rhd", "\u0e14\u0e2d\u0e25\u0e25\u0e32\u0e23\u0e4c\u0e42\u0e23\u0e14\u0e35\u0e40\u0e0b\u0e35\u0e22" },
            { "rol", "\u0e25\u0e34\u0e27\u0e42\u0e23\u0e21\u0e32\u0e40\u0e19\u0e35\u0e22\u0e40\u0e01\u0e48\u0e32" },
            { "ron", "\u0e25\u0e34\u0e27\u0e42\u0e23\u0e21\u0e32\u0e40\u0e19\u0e35\u0e22" },
            { "rsd", "\u0e14\u0e35\u0e19\u0e32\u0e23\u0e4c\u0e40\u0e0b\u0e2d\u0e23\u0e4c\u0e40\u0e1a\u0e35\u0e22" },
            { "rub", "\u0e23\u0e39\u0e40\u0e1a\u0e34\u0e25\u0e23\u0e31\u0e2a\u0e40\u0e0b\u0e35\u0e22" },
            { "rur", "\u0e23\u0e39\u0e40\u0e1a\u0e34\u0e25\u0e23\u0e31\u0e2a\u0e40\u0e0b\u0e35\u0e22 (1991\u20131998)" },
            { "rwf", "\u0e1f\u0e23\u0e31\u0e07\u0e01\u0e4c\u0e23\u0e27\u0e31\u0e19\u0e14\u0e32" },
            { "sar", "\u0e23\u0e34\u0e22\u0e31\u0e25\u0e0b\u0e32\u0e2d\u0e38\u0e14\u0e35\u0e2d\u0e32\u0e23\u0e30\u0e40\u0e1a\u0e35\u0e22" },
            { "sbd", "\u0e14\u0e2d\u0e25\u0e25\u0e32\u0e23\u0e4c\u0e2b\u0e21\u0e39\u0e48\u0e40\u0e01\u0e32\u0e30\u0e42\u0e0b\u0e42\u0e25\u0e21\u0e2d\u0e19" },
            { "scr", "\u0e23\u0e39\u0e1b\u0e35\u0e40\u0e0b\u0e40\u0e0a\u0e25\u0e2a\u0e4c" },
            { "sdd", "\u0e14\u0e35\u0e19\u0e32\u0e23\u0e4c\u0e0b\u0e39\u0e14\u0e32\u0e19\u0e40\u0e01\u0e48\u0e32" },
            { "sdg", "\u0e1b\u0e2d\u0e19\u0e14\u0e4c\u0e0b\u0e39\u0e14\u0e32\u0e19" },
            { "sdp", "\u0e1b\u0e2d\u0e19\u0e14\u0e4c\u0e0b\u0e39\u0e14\u0e32\u0e19\u0e40\u0e01\u0e48\u0e32" },
            { "sek", "\u0e42\u0e04\u0e23\u0e19\u0e32\u0e2a\u0e27\u0e35\u0e40\u0e14\u0e19" },
            { "sgd", "\u0e14\u0e2d\u0e25\u0e25\u0e32\u0e23\u0e4c\u0e2a\u0e34\u0e07\u0e04\u0e42\u0e1b\u0e23\u0e4c" },
            { "shp", "\u0e1b\u0e2d\u0e19\u0e14\u0e4c\u0e40\u0e0b\u0e19\u0e15\u0e4c\u0e40\u0e2e\u0e40\u0e25\u0e19\u0e32" },
            { "sit", "\u0e17\u0e2d\u0e25\u0e32\u0e23\u0e4c\u0e2a\u0e42\u0e25\u0e27\u0e35\u0e40\u0e19\u0e35\u0e22" },
            { "skk", "\u0e42\u0e04\u0e23\u0e39\u0e19\u0e32\u0e2a\u0e42\u0e25\u0e27\u0e31\u0e01" },
            { "sll", "\u0e25\u0e35\u0e42\u0e2d\u0e19\u0e40\u0e0b\u0e35\u0e22\u0e23\u0e4c\u0e23\u0e32\u0e25\u0e35\u0e42\u0e2d\u0e19" },
            { "sos", "\u0e0a\u0e34\u0e25\u0e25\u0e34\u0e07\u0e42\u0e0b\u0e21\u0e32\u0e40\u0e25\u0e35\u0e22" },
            { "srd", "\u0e14\u0e2d\u0e25\u0e25\u0e32\u0e23\u0e4c\u0e0b\u0e39\u0e23\u0e34\u0e19\u0e32\u0e40\u0e21" },
            { "srg", "\u0e01\u0e34\u0e25\u0e40\u0e14\u0e2d\u0e23\u0e4c\u0e0b\u0e39\u0e23\u0e34\u0e19\u0e32\u0e40\u0e21" },
            { "ssp", "\u0e1b\u0e2d\u0e19\u0e14\u0e4c\u0e0b\u0e39\u0e14\u0e32\u0e19\u0e43\u0e15\u0e49" },
            { "std", "\u0e14\u0e2d\u0e1a\u0e23\u0e32\u0e40\u0e0b\u0e32\u0e15\u0e39\u0e40\u0e21\u0e41\u0e25\u0e30\u0e1b\u0e23\u0e34\u0e19\u0e0b\u0e34\u0e1b\u0e35 (1977\u20132017)" },
            { "stn", "\u0e14\u0e2d\u0e1a\u0e23\u0e32\u0e40\u0e0b\u0e32\u0e15\u0e39\u0e40\u0e21\u0e41\u0e25\u0e30\u0e1b\u0e23\u0e34\u0e19\u0e0b\u0e34\u0e1b\u0e35" },
            { "sur", "\u0e23\u0e39\u0e40\u0e1a\u0e34\u0e25\u0e42\u0e0b\u0e40\u0e27\u0e35\u0e22\u0e15" },
            { "svc", "\u0e42\u0e04\u0e25\u0e2d\u0e19\u0e40\u0e2d\u0e25\u0e0b\u0e31\u0e25\u0e27\u0e32\u0e14\u0e2d\u0e23\u0e4c" },
            { "syp", "\u0e1b\u0e2d\u0e19\u0e14\u0e4c\u0e0b\u0e35\u0e40\u0e23\u0e35\u0e22" },
            { "szl", "\u0e25\u0e34\u0e25\u0e31\u0e19\u0e40\u0e08\u0e19\u0e35\u0e2a\u0e27\u0e32\u0e0b\u0e34" },
            { "thb", "\u0e1a\u0e32\u0e17" },
            { "tjr", "\u0e23\u0e39\u0e40\u0e1a\u0e34\u0e25\u0e17\u0e32\u0e08\u0e34\u0e01\u0e34\u0e2a\u0e16\u0e32\u0e19" },
            { "tjs", "\u0e42\u0e0b\u0e42\u0e21\u0e19\u0e34\u0e17\u0e32\u0e08\u0e34\u0e01\u0e34\u0e2a\u0e16\u0e32\u0e19" },
            { "tmm", "\u0e21\u0e32\u0e19\u0e31\u0e15\u0e40\u0e15\u0e34\u0e23\u0e4c\u0e01\u0e40\u0e21\u0e19\u0e34\u0e2a\u0e16\u0e32\u0e19 (1993\u20132009)" },
            { "tmt", "\u0e21\u0e32\u0e19\u0e31\u0e15\u0e40\u0e15\u0e34\u0e23\u0e4c\u0e01\u0e40\u0e21\u0e19\u0e34\u0e2a\u0e16\u0e32\u0e19" },
            { "tnd", "\u0e14\u0e35\u0e19\u0e32\u0e23\u0e4c\u0e15\u0e39\u0e19\u0e34\u0e40\u0e0b\u0e35\u0e22" },
            { "top", "\u0e1e\u0e32\u0e41\u0e2d\u0e07\u0e01\u0e32\u0e15\u0e2d\u0e07\u0e01\u0e32" },
            { "tpe", "\u0e40\u0e2d\u0e2a\u0e04\u0e39\u0e42\u0e14\u0e15\u0e34\u0e21\u0e2d\u0e23\u0e4c" },
            { "trl", "\u0e25\u0e35\u0e23\u0e32\u0e15\u0e38\u0e23\u0e01\u0e35\u0e40\u0e01\u0e48\u0e32" },
            { "try", "\u0e25\u0e35\u0e23\u0e32\u0e15\u0e38\u0e23\u0e01\u0e35" },
            { "ttd", "\u0e14\u0e2d\u0e25\u0e25\u0e32\u0e23\u0e4c\u0e15\u0e23\u0e34\u0e19\u0e34\u0e41\u0e14\u0e14\u0e41\u0e25\u0e30\u0e42\u0e15\u0e40\u0e1a\u0e42\u0e01" },
            { "twd", "\u0e14\u0e2d\u0e25\u0e25\u0e32\u0e23\u0e4c\u0e44\u0e15\u0e49\u0e2b\u0e27\u0e31\u0e19\u0e43\u0e2b\u0e21\u0e48" },
            { "tzs", "\u0e0a\u0e34\u0e25\u0e25\u0e34\u0e07\u0e41\u0e17\u0e19\u0e0b\u0e32\u0e40\u0e19\u0e35\u0e22" },
            { "uah", "\u0e2e\u0e23\u0e35\u0e1f\u0e40\u0e19\u0e35\u0e22\u0e22\u0e39\u0e40\u0e04\u0e23\u0e19" },
            { "uak", "\u0e04\u0e32\u0e23\u0e4c\u0e42\u0e1a\u0e27\u0e32\u0e40\u0e19\u0e15\u0e0b\u0e4c\u0e22\u0e39\u0e40\u0e04\u0e23\u0e19" },
            { "ugs", "\u0e0a\u0e34\u0e25\u0e25\u0e34\u0e07\u0e22\u0e39\u0e01\u0e31\u0e19\u0e14\u0e32 (1966\u20131987)" },
            { "ugx", "\u0e0a\u0e34\u0e25\u0e25\u0e34\u0e07\u0e22\u0e39\u0e01\u0e31\u0e19\u0e14\u0e32" },
            { "usd", "\u0e14\u0e2d\u0e25\u0e25\u0e32\u0e23\u0e4c\u0e2a\u0e2b\u0e23\u0e31\u0e10" },
            { "usn", "\u0e14\u0e2d\u0e25\u0e25\u0e32\u0e23\u0e4c\u0e2a\u0e2b\u0e23\u0e31\u0e10 (\u0e27\u0e31\u0e19\u0e16\u0e31\u0e14\u0e44\u0e1b)" },
            { "uss", "\u0e14\u0e2d\u0e25\u0e25\u0e32\u0e23\u0e4c\u0e2a\u0e2b\u0e23\u0e31\u0e10 (\u0e27\u0e31\u0e19\u0e40\u0e14\u0e35\u0e22\u0e27\u0e01\u0e31\u0e19)" },
            { "uyi", "\u0e40\u0e1b\u0e42\u0e0b\u0e40\u0e2d\u0e19\u0e22\u0e39\u0e19\u0e34\u0e41\u0e14\u0e14\u0e40\u0e0b\u0e2a\u0e2d\u0e34\u0e19\u0e40\u0e14\u0e47\u0e01\u0e0b\u0e32\u0e41\u0e14\u0e2a\u0e2d\u0e38\u0e23\u0e38\u0e01\u0e27\u0e31\u0e22" },
            { "uyp", "\u0e40\u0e1b\u0e42\u0e0b\u0e2d\u0e38\u0e23\u0e38\u0e01\u0e27\u0e31\u0e22 (1975\u20131993)" },
            { "uyu", "\u0e40\u0e1b\u0e42\u0e0b\u0e2d\u0e38\u0e23\u0e38\u0e01\u0e27\u0e31\u0e22" },
            { "uzs", "\u0e0b\u0e2d\u0e21\u0e2d\u0e38\u0e0b\u0e40\u0e1a\u0e01\u0e34\u0e2a\u0e16\u0e32\u0e19" },
            { "veb", "\u0e42\u0e1a\u0e25\u0e34\u0e27\u0e32\u0e23\u0e4c\u0e40\u0e27\u0e40\u0e19\u0e0b\u0e38\u0e40\u0e2d\u0e25\u0e32 (1871\u20132008)" },
            { "vef", "\u0e42\u0e1a\u0e25\u0e34\u0e27\u0e32\u0e23\u0e4c\u0e40\u0e27\u0e40\u0e19\u0e0b\u0e38\u0e40\u0e2d\u0e25\u0e32" },
            { "ves", "\u0e42\u0e1a\u0e25\u0e35\u0e27\u0e32\u0e23\u0e4c\u0e40\u0e27\u0e40\u0e19\u0e0b\u0e38\u0e40\u0e2d\u0e25\u0e32" },
            { "vnd", "\u0e14\u0e2d\u0e07\u0e40\u0e27\u0e35\u0e22\u0e14\u0e19\u0e32\u0e21" },
            { "vnn", "\u0e14\u0e2d\u0e07\u0e40\u0e27\u0e35\u0e22\u0e14\u0e19\u0e32\u0e21 (1978\u20131985)" },
            { "vuv", "\u0e27\u0e32\u0e15\u0e39\u0e27\u0e32\u0e19\u0e39\u0e2d\u0e32\u0e15\u0e39" },
            { "wst", "\u0e17\u0e32\u0e25\u0e32\u0e0b\u0e32\u0e21\u0e31\u0e27" },
            { "xaf", "\u0e1f\u0e23\u0e31\u0e07\u0e01\u0e4c\u0e40\u0e0b\u0e1f\u0e32\u0e18\u0e19\u0e32\u0e04\u0e32\u0e23\u0e23\u0e31\u0e10\u0e41\u0e2d\u0e1f\u0e23\u0e34\u0e01\u0e32\u0e01\u0e25\u0e32\u0e07" },
            { "xag", "\u0e40\u0e07\u0e34\u0e19" },
            { "xau", "\u0e17\u0e2d\u0e07" },
            { "xba", "\u0e2b\u0e19\u0e48\u0e27\u0e22\u0e04\u0e2d\u0e21\u0e42\u0e1e\u0e2a\u0e34\u0e15\u0e22\u0e38\u0e42\u0e23\u0e1b" },
            { "xbb", "\u0e2b\u0e19\u0e48\u0e27\u0e22\u0e42\u0e21\u0e40\u0e19\u0e17\u0e32\u0e23\u0e35\u0e22\u0e38\u0e42\u0e23\u0e1b" },
            { "xbc", "\u0e2b\u0e19\u0e48\u0e27\u0e22\u0e1a\u0e31\u0e0d\u0e0a\u0e35\u0e22\u0e38\u0e42\u0e23\u0e1b [XBC]" },
            { "xbd", "\u0e2b\u0e19\u0e48\u0e27\u0e22\u0e1a\u0e31\u0e0d\u0e0a\u0e35\u0e22\u0e38\u0e42\u0e23\u0e1b [XBD]" },
            { "xcd", "\u0e14\u0e2d\u0e25\u0e25\u0e32\u0e23\u0e4c\u0e41\u0e04\u0e23\u0e34\u0e1a\u0e40\u0e1a\u0e35\u0e22\u0e19\u0e15\u0e30\u0e27\u0e31\u0e19\u0e2d\u0e2d\u0e01" },
            { "xdr", "\u0e2a\u0e34\u0e17\u0e18\u0e34\u0e16\u0e2d\u0e19\u0e40\u0e07\u0e34\u0e19\u0e1e\u0e34\u0e40\u0e28\u0e29" },
            { "xeu", "\u0e2b\u0e19\u0e48\u0e27\u0e22\u0e2a\u0e01\u0e38\u0e25\u0e40\u0e07\u0e34\u0e19\u0e22\u0e38\u0e42\u0e23\u0e1b" },
            { "xfo", "\u0e1f\u0e23\u0e31\u0e07\u0e01\u0e4c\u0e17\u0e2d\u0e07\u0e1d\u0e23\u0e31\u0e48\u0e07\u0e40\u0e28\u0e2a" },
            { "xfu", "\u0e1f\u0e23\u0e31\u0e07\u0e01\u0e4c\u0e22\u0e39\u0e44\u0e2d\u0e0b\u0e35\u0e1d\u0e23\u0e31\u0e48\u0e07\u0e40\u0e28\u0e2a" },
            { "xof", "\u0e1f\u0e23\u0e31\u0e07\u0e01\u0e4c\u0e40\u0e0b\u0e1f\u0e32\u0e18\u0e19\u0e32\u0e04\u0e32\u0e23\u0e01\u0e25\u0e32\u0e07\u0e23\u0e31\u0e10\u0e41\u0e2d\u0e1f\u0e23\u0e34\u0e01\u0e32\u0e15\u0e30\u0e27\u0e31\u0e19\u0e15\u0e01" },
            { "xpd", "\u0e1e\u0e31\u0e25\u0e40\u0e25\u0e40\u0e14\u0e35\u0e22\u0e21" },
            { "xpf", "\u0e1f\u0e23\u0e31\u0e07\u0e01\u0e4c\u0e0b\u0e35\u0e40\u0e2d\u0e1f\u0e1e\u0e35" },
            { "xpt", "\u0e41\u0e1e\u0e25\u0e15\u0e34\u0e19\u0e31\u0e21" },
            { "xre", "\u0e01\u0e2d\u0e07\u0e17\u0e38\u0e19\u0e44\u0e23\u0e40\u0e19\u0e47\u0e15" },
            { "xsu", "\u0e0b\u0e39\u0e40\u0e01\u0e23" },
            { "xts", "\u0e23\u0e2b\u0e31\u0e2a\u0e17\u0e14\u0e2a\u0e2d\u0e1a\u0e2a\u0e01\u0e38\u0e25\u0e40\u0e07\u0e34\u0e19" },
            { "xua", "\u0e2b\u0e19\u0e48\u0e27\u0e22\u0e1a\u0e31\u0e0d\u0e0a\u0e35 \u0e40\u0e2d\u0e14\u0e35\u0e1a\u0e35" },
            { "xxx", "\u0e44\u0e21\u0e48\u0e17\u0e23\u0e32\u0e1a\u0e0a\u0e37\u0e48\u0e2d\u0e2a\u0e01\u0e38\u0e25\u0e40\u0e07\u0e34\u0e19" },
            { "ydd", "\u0e14\u0e35\u0e19\u0e32\u0e23\u0e4c\u0e40\u0e22\u0e40\u0e21\u0e19" },
            { "yer", "\u0e40\u0e23\u0e35\u0e22\u0e25\u0e40\u0e22\u0e40\u0e21\u0e19" },
            { "yud", "\u0e2e\u0e32\u0e23\u0e4c\u0e14\u0e14\u0e35\u0e19\u0e32\u0e23\u0e4c\u0e22\u0e39\u0e42\u0e01\u0e2a\u0e25\u0e32\u0e40\u0e27\u0e35\u0e22" },
            { "yum", "\u0e42\u0e19\u0e27\u0e34\u0e22\u0e4c\u0e14\u0e35\u0e19\u0e32\u0e23\u0e4c\u0e22\u0e39\u0e42\u0e01\u0e2a\u0e25\u0e32\u0e40\u0e27\u0e35\u0e22" },
            { "yun", "\u0e04\u0e2d\u0e19\u0e40\u0e27\u0e2d\u0e23\u0e4c\u0e17\u0e34\u0e40\u0e1a\u0e34\u0e25\u0e14\u0e35\u0e19\u0e32\u0e23\u0e4c\u0e22\u0e39\u0e42\u0e01\u0e2a\u0e25\u0e32\u0e40\u0e27\u0e35\u0e22" },
            { "yur", "\u0e14\u0e35\u0e19\u0e32\u0e23\u0e4c\u0e1b\u0e0f\u0e34\u0e23\u0e39\u0e1b\u0e22\u0e39\u0e42\u0e01\u0e2a\u0e25\u0e32\u0e40\u0e27\u0e35\u0e22 (1992\u20131993)" },
            { "zal", "\u0e41\u0e23\u0e19\u0e14\u0e4c\u0e41\u0e2d\u0e1f\u0e23\u0e34\u0e01\u0e32\u0e43\u0e15\u0e49 (\u0e01\u0e32\u0e23\u0e40\u0e07\u0e34\u0e19)" },
            { "zar", "\u0e41\u0e23\u0e19\u0e14\u0e4c\u0e41\u0e2d\u0e1f\u0e23\u0e34\u0e01\u0e32\u0e43\u0e15\u0e49" },
            { "zmk", "\u0e04\u0e27\u0e32\u0e0a\u0e32\u0e41\u0e0b\u0e21\u0e40\u0e1a\u0e35\u0e22 (1968\u20132012)" },
            { "zmw", "\u0e04\u0e27\u0e32\u0e0a\u0e32\u0e41\u0e0b\u0e21\u0e40\u0e1a\u0e35\u0e22" },
            { "zrn", "\u0e19\u0e34\u0e27\u0e41\u0e0b\u0e23\u0e4c\u0e04\u0e2d\u0e07\u0e42\u0e01" },
            { "zrz", "\u0e41\u0e0b\u0e23\u0e4c\u0e04\u0e2d\u0e07\u0e42\u0e01" },
            { "zwd", "\u0e14\u0e2d\u0e25\u0e25\u0e32\u0e23\u0e4c\u0e0b\u0e34\u0e21\u0e1a\u0e31\u0e1a\u0e40\u0e27" },
            { "zwl", "\u0e14\u0e2d\u0e25\u0e25\u0e32\u0e23\u0e4c\u0e0b\u0e34\u0e21\u0e1a\u0e31\u0e1a\u0e40\u0e27 (2009)" },
            { "zwr", "\u0e14\u0e2d\u0e25\u0e25\u0e32\u0e23\u0e4c\u0e0b\u0e34\u0e21\u0e1a\u0e31\u0e1a\u0e40\u0e27 (2008)" },
        };
        return data;
    }
}
