/*
 * Copyright (c) 2012, 2022, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_cy extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_la = "Lladin";
        final String metaValue_te = "Telugu";
        final Object[][] data = new Object[][] {
            { "ksh", "Cwleneg" },
            { "Ogam", "Ogam" },
            { "mwl", "Mirandeg" },
            { "Zsym", "Symbolau" },
            { "cch", "Atsameg" },
            { "mwr", "Marwari" },
            { "Zsye", "Emoji" },
            { "%%NJIVA", "tafodiaith Gniva/Njiva" },
            { "ccp", "Tsiacma" },
            { "egy", "Hen Eiffteg" },
            { "raj", "Rajasthaneg" },
            { "tem", "Timneg" },
            { "teo", "Teso" },
            { "rap", "Rapan\u0175i" },
            { "ter", "Terena" },
            { "AC", "Ynys Ascension" },
            { "rar", "Raratongeg" },
            { "tet", "Tetumeg" },
            { "AD", "Andorra" },
            { "AE", "Emiradau Arabaidd Unedig" },
            { "nl_BE", "Fflemeg" },
            { "AF", "Afghanistan" },
            { "AG", "Antigua a Barbuda" },
            { "type.ca.ethiopic", "Calendr Ethiopia" },
            { "AI", "Anguilla" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "AO", "Angola" },
            { "AQ", "Antarctica" },
            { "AR", "Yr Ariannin" },
            { "AS", "Samoa America" },
            { "AT", "Awstria" },
            { "AU", "Awstralia" },
            { "AW", "Aruba" },
            { "en_US", "Saesneg America" },
            { "AX", "Ynysoedd \u00c5land" },
            { "AZ", "Azerbaijan" },
            { "%%AREVELA", "Armeneg Dwyreiniol" },
            { "BA", "Bosnia & Herzegovina" },
            { "BB", "Barbados" },
            { "ceb", "Cebuano" },
            { "BD", "Bangladesh" },
            { "kum", "Cwmiceg" },
            { "BE", "Gwlad Belg" },
            { "gmh", "Almaeneg Uchel Canol" },
            { "BF", "Burkina Faso" },
            { "BG", "Bwlgaria" },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Saint Barth\u00e9lemy" },
            { "BM", "Bermuda" },
            { "myv", "Erzya" },
            { "BN", "Brunei" },
            { "BO", "Bolifia" },
            { "BQ", "Antilles yr Iseldiroedd" },
            { "BR", "Brasil" },
            { "BS", "Y Bahamas" },
            { "xog", "Soga" },
            { "BT", "Bhutan" },
            { "BV", "Ynys Bouvet" },
            { "BW", "Botswana" },
            { "BY", "Belarws" },
            { "BZ", "Belize" },
            { "type.ca.persian", "Calendr Persia" },
            { "type.nu.hebr", "Rhifolion Hebreig" },
            { "CA", "Canada" },
            { "CC", "Ynysoedd Cocos (Keeling)" },
            { "mzn", "Masanderani" },
            { "CD", "Y Congo - Kinshasa" },
            { "CF", "Gweriniaeth Canolbarth Affrica" },
            { "CG", "Y Congo - Brazzaville" },
            { "CH", "Y Swistir" },
            { "CI", "C\u00f4te d\u2019Ivoire" },
            { "CK", "Ynysoedd Cook" },
            { "CL", "Chile" },
            { "CM", "Camer\u0175n" },
            { "CN", "Tsieina" },
            { "CO", "Colombia" },
            { "CP", "Ynys Clipperton" },
            { "CR", "Costa Rica" },
            { "CU", "Ciwba" },
            { "CV", "Cabo Verde" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Ynys y Nadolig" },
            { "CY", "Cyprus" },
            { "CZ", "Tsiecia" },
            { "eka", "Ekajuk" },
            { "vls", "Fflemeg Gorllewinol" },
            { "DE", "Yr Almaen" },
            { "goh", "Hen Almaeneg Uchel" },
            { "ace", "Acehneg" },
            { "cgg", "Tsiga" },
            { "DG", "Diego Garcia" },
            { "type.nu.deva", "Digidau Devanagarig" },
            { "DJ", "Djibouti" },
            { "DK", "Denmarc" },
            { "ach", "Acoli" },
            { "Brai", "Braille" },
            { "DM", "Dominica" },
            { "type.nu.armnlow", "Rhifolion Armenaidd mewn Llythrennau Bychain" },
            { "DO", "Gweriniaeth Dominica" },
            { "gor", "Gorontalo" },
            { "got", "Gotheg" },
            { "zun", "Swni" },
            { "tig", "Tigreg" },
            { "DZ", "Algeria" },
            { "pag", "Pangasineg" },
            { "pal", "Pahlafi" },
            { "EA", "Ceuta a Melilla" },
            { "pam", "Pampanga" },
            { "EC", "Ecuador" },
            { "pap", "Papiamento" },
            { "ada", "Adangmeg" },
            { "EE", "Estonia" },
            { "tiv", "Tifeg" },
            { "EG", "Yr Aifft" },
            { "EH", "Gorllewin Sahara" },
            { "pau", "Palawan" },
            { "chk", "Chuukaeg" },
            { "chm", "Marieg" },
            { "cho", "Siocto" },
            { "chr", "Tsieroc\u00ee" },
            { "ER", "Eritrea" },
            { "ES", "Sbaen" },
            { "ET", "Ethiopia" },
            { "EU", "Yr Undeb Ewropeaidd" },
            { "elx", "Elameg" },
            { "type.ca.gregorian", "Calendr Gregori" },
            { "EZ", "Ardal yr Ewro" },
            { "chy", "Cheyenne" },
            { "type.nu.gujr", "Digidau Gwjarataidd" },
            { "ady", "Circaseg Gorllewinol" },
            { "aeb", "Arabeg Tunisia" },
            { "FI", "Y Ffindir" },
            { "FJ", "Fiji" },
            { "FK", "Ynysoedd y Falkland/Malvinas" },
            { "FM", "Micronesia" },
            { "FO", "Ynysoedd Ffaro" },
            { "Taml", "Tamilaidd" },
            { "FR", "Ffrainc" },
            { "pcd", "Picardeg" },
            { "tkl", "Tocelaweg" },
            { "root", "Y Gwraidd" },
            { "%%DAJNKO", "gwyddor Dajnko" },
            { "type.ca.indian", "Calendr Cenedlaethol India" },
            { "grc", "Hen Roeg" },
            { "GA", "Gabon" },
            { "tkr", "Tsakhureg" },
            { "vot", "Foteg" },
            { "GB", "Y Deyrnas Unedig" },
            { "pcm", "Pidgin Nigeria" },
            { "GD", "Grenada" },
            { "GE", "Georgia" },
            { "GF", "Guyane Ffrengig" },
            { "GG", "Ynys y Garn" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "afh", "Affrihili" },
            { "GL", "Yr Ynys Las" },
            { "enm", "Saesneg Canol" },
            { "GM", "Gambia" },
            { "GN", "Guin\u00e9e" },
            { "GP", "Guadeloupe" },
            { "GQ", "Guinea Gyhydeddol" },
            { "GR", "Gwlad Groeg" },
            { "GS", "De Georgia ac Ynysoedd Sandwich y De" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "pdc", "Almaeneg Pensylfania" },
            { "GW", "Guin\u00e9-Bissau" },
            { "tli", "Llingit" },
            { "tlh", "Klingon" },
            { "GY", "Guyana" },
            { "ckb", "Cwrdeg Sorani" },
            { "zxx", "Dim cynnwys ieithyddol" },
            { "tly", "Talysheg" },
            { "de_AT", "Almaeneg Awstria" },
            { "HK", "Hong Kong SAR Tseina" },
            { "HM", "Ynys Heard ac Ynysoedd McDonald" },
            { "HN", "Honduras" },
            { "HR", "Croatia" },
            { "agq", "Aghemeg" },
            { "gsw", "Almaeneg y Swistir" },
            { "HT", "Haiti" },
            { "HU", "Hwngari" },
            { "tmh", "Tamasheceg" },
            { "IC", "Yr Ynysoedd Dedwydd" },
            { "ID", "Indonesia" },
            { "peo", "Hen Bersieg" },
            { "IE", "Iwerddon" },
            { "nap", "Naplieg" },
            { "%%NDYUKA", "tafodiaith Ndyuka" },
            { "naq", "Nama" },
            { "zza", "Sas\u00e4eg" },
            { "IL", "Israel" },
            { "IM", "Ynys Manaw" },
            { "IN", "India" },
            { "type.co.eor", "Rheolau trefnu Ewropeaidd" },
            { "IO", "Tiriogaeth Brydeinig Cefnfor India" },
            { "IQ", "Irac" },
            { "IR", "Iran" },
            { "IS", "Gwlad yr I\u00e2" },
            { "IT", "Yr Eidal" },
            { "Zmth", "Nodiant Mathemategol" },
            { "type.nu.thai", "Digidau Thai" },
            { "%%POSIX", "Cyfrifiadur" },
            { "type.nu.beng", "Digidau Bengalaidd" },
            { "pfl", "Almaeneg Palatin" },
            { "JE", "Jersey" },
            { "type.ca.islamic", "Calendr Islam" },
            { "JM", "Jamaica" },
            { "Beng", "Bangla" },
            { "JO", "Gwlad Iorddonen" },
            { "JP", "Japan" },
            { "%%1606NICT", "Ffrangeg Canol Diweddar hyd at 1606" },
            { "ain", "Ain\u0175eg" },
            { "%%KOCIEWIE", "KOCIEWIE" },
            { "guz", "Gusii" },
            { "type.nu.knda", "Digidau Kannaraidd" },
            { "de_CH", "Almaeneg Safonol y Swistir" },
            { "type.ca.buddhist", "Calendr y Bwdiaid" },
            { "KE", "Kenya" },
            { "419", "America Ladin" },
            { "KG", "Kyrgyzstan" },
            { "KH", "Cambodia" },
            { "KI", "Kiribati" },
            { "KM", "Comoros" },
            { "KN", "Saint Kitts a Nevis" },
            { "Knda", "Canaraidd" },
            { "fr_CA", "Ffrangeg Canada" },
            { "KP", "Gogledd Korea" },
            { "KR", "De Korea" },
            { "fr_CH", "Ffrangeg y Swistir" },
            { "KW", "Kuwait" },
            { "tpi", "Tok Pisin" },
            { "KY", "Ynysoedd Cayman" },
            { "KZ", "Kazakstan" },
            { "Cyrl", "Cyrilig" },
            { "LA", "Laos" },
            { "LB", "Libanus" },
            { "LC", "Saint Lucia" },
            { "phn", "Phoeniceg" },
            { "gwi", "Gwich\u02bcin" },
            { "%%LUNA1918", "LUNA1918" },
            { "nds", "Almaeneg Isel" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "akk", "Acadeg" },
            { "cop", "Copteg" },
            { "LR", "Liberia" },
            { "LS", "Lesotho" },
            { "LT", "Lithuania" },
            { "LU", "Lwcsembwrg" },
            { "LV", "Latfia" },
            { "Kana", "Catacana" },
            { "LY", "Libya" },
            { "lad", "Iddew-Sbaeneg" },
            { "vun", "Funjo" },
            { "akz", "Alabam\u00e4eg" },
            { "%%LAUKIKA", "LAUKIKA" },
            { "lah", "Lahnda" },
            { "lag", "Langi" },
            { "Thaa", "Thaana" },
            { "MA", "Moroco" },
            { "MC", "Monaco" },
            { "MD", "Moldofa" },
            { "ME", "Montenegro" },
            { "MF", "Saint Martin" },
            { "lam", "Lamba" },
            { "MG", "Madagascar" },
            { "MH", "Ynysoedd Marshall" },
            { "ale", "Alewteg" },
            { "Thai", "Tai" },
            { "MK", "Gogledd Macedonia" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Burma)" },
            { "MN", "Mongolia" },
            { "new", "Newaeg" },
            { "MO", "Macau RhGA Tsieina" },
            { "aln", "Ghegeg Albania" },
            { "MP", "Ynysoedd Gogledd Mariana" },
            { "MQ", "Martinique" },
            { "MR", "Mauritania" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Mauritius" },
            { "alt", "Alt\u00e4eg Deheuol" },
            { "MV", "Y Maldives" },
            { "MW", "Malawi" },
            { "MX", "Mecsico" },
            { "type.ca.japanese", "Calendr Japan" },
            { "MY", "Malaysia" },
            { "MZ", "Mozambique" },
            { "NA", "Namibia" },
            { "202", "Affrica Is-Sahara" },
            { "type.ca.hebrew", "Calendr yr Hebraed" },
            { "type.co.dictionary", "Trefn Geiriadur" },
            { "NC", "Caledonia Newydd" },
            { "NE", "Niger" },
            { "NF", "Ynys Norfolk" },
            { "NG", "Nigeria" },
            { "trv", "Taroko" },
            { "NI", "Nicaragua" },
            { "NL", "Yr Iseldiroedd" },
            { "NO", "Norwy" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "tsd", "Tsaconeg" },
            { "NU", "Niue" },
            { "rof", "Rombo" },
            { "NZ", "Seland Newydd" },
            { "rom", "Romani" },
            { "crh", "Tyrceg y Crimea" },
            { "ang", "Hen Saesneg" },
            { "OM", "Oman" },
            { "anp", "Angika" },
            { "crs", "Ffrangeg Seselwa Creole" },
            { "PA", "Panama" },
            { "en_GB", "Saesneg Prydain" },
            { "PE", "Periw" },
            { "PF", "Polynesia Ffrengig" },
            { "PG", "Papua Guinea Newydd" },
            { "PH", "Y Philipinau" },
            { "PK", "Pakistan" },
            { "PL", "Gwlad Pwyl" },
            { "ewo", "Ewondo" },
            { "PM", "Saint-Pierre-et-Miquelon" },
            { "PN", "Ynysoedd Pitcairn" },
            { "PR", "Puerto Rico" },
            { "PS", "Tiriogaethau Palesteinaidd" },
            { "PT", "Portiwgal" },
            { "PW", "Palau" },
            { "nia", "Nias" },
            { "type.nu.greklow", "Rhifolion Groegaidd mewn Llythrennau Bychain" },
            { "PY", "Paraguay" },
            { "tum", "Twmbwca" },
            { "Hebr", "Hebreig" },
            { "QA", "Qatar" },
            { "%%SCOTLAND", "Saesneg Safonol yr Alban" },
            { "pms", "Piedmonteg" },
            { "niu", "Niuean" },
            { "QO", "Oceania Bellennig" },
            { "ext", "Extremadureg" },
            { "lez", "Lezgheg" },
            { "%%FONUPA", "Seineg UPA" },
            { "type.nu.takr", "Digidau Takri" },
            { "tvl", "Twfalweg" },
            { "001", "Y Byd" },
            { "002", "Affrica" },
            { "njo", "Ao Naga" },
            { "003", "Gogledd America" },
            { "RE", "R\u00e9union" },
            { "005", "De America" },
            { "jbo", "Lojban" },
            { "pnt", "Ponteg" },
            { "009", "Oceania" },
            { "%%SURSILV", "SURSILV" },
            { "RO", "Rwmania" },
            { "RS", "Serbia" },
            { "RU", "Rwsia" },
            { "RW", "Rwanda" },
            { "%%METELKO", "gwyddor Metelko" },
            { "SA", "Saudi Arabia" },
            { "pon", "Pohnpeianeg" },
            { "SB", "Ynysoedd Solomon" },
            { "twq", "Tasawaq" },
            { "011", "Gorllewin Affrica" },
            { "SC", "Seychelles" },
            { "SD", "Swdan" },
            { "013", "Canolbarth America" },
            { "SE", "Sweden" },
            { "014", "Dwyrain Affrica" },
            { "arc", "Aramaeg" },
            { "015", "Gogledd Affrica" },
            { "SG", "Singapore" },
            { "SH", "Saint Helena" },
            { "type.lb.strict", "Arddull Torriad Llinell Caeth" },
            { "017", "Canol Affrica" },
            { "SI", "Slofenia" },
            { "018", "Deheudir Affrica" },
            { "SJ", "Svalbard a Jan Mayen" },
            { "019", "Yr Amerig" },
            { "SK", "Slofacia" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "arn", "Arawcaneg" },
            { "arp", "Arapaho" },
            { "type.nu.taml", "Rhifolion Tamilaidd Traddodiadol" },
            { "SR", "Suriname" },
            { "aro", "Araonaeg" },
            { "SS", "De Swdan" },
            { "ST", "S\u00e3o Tom\u00e9 a Pr\u00edncipe" },
            { "arq", "Arabeg Algeria" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "Syria" },
            { "SZ", "Eswatini" },
            { "arw", "Arawaceg" },
            { "arz", "Arabeg yr Aifft" },
            { "ary", "Arabeg Moroco" },
            { "rtm", "Rotumaneg" },
            { "TA", "Tristan da Cunha" },
            { "asa", "Asw" },
            { "type.ms.ussystem", "System Fesur UDA" },
            { "021", "America i\u2019r Gogledd o Fecsico" },
            { "TC", "Ynysoedd Turks a Caicos" },
            { "yav", "Iangben" },
            { "TD", "Tchad" },
            { "TF", "Tiroedd Deheuol ac Antarctig Ffrainc" },
            { "ase", "Iaith Arwyddion America" },
            { "TG", "Togo" },
            { "TH", "Gwlad Thai" },
            { "TJ", "Tajikistan" },
            { "029", "Y Carib\u00ee" },
            { "TK", "Tokelau" },
            { "TL", "Timor-Leste" },
            { "ybb", "Iembaeg" },
            { "TM", "Turkmenistan" },
            { "TN", "Tunisia" },
            { "TO", "Tonga" },
            { "TR", "Twrci" },
            { "TT", "Trinidad a Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "ast", "Astwrianeg" },
            { "TZ", "Tanzania" },
            { "nmg", "Kwasio" },
            { "Zzzz", "Sgript anhysbys" },
            { "UA", "Wcr\u00e1in" },
            { "rup", "Aromaneg" },
            { "030", "Dwyrain Asia" },
            { "tyv", "Twfwnieg" },
            { "sw_CD", "Swahili\u2019r Congo" },
            { "034", "De Asia" },
            { "hai", "Haida" },
            { "035", "De-Ddwyrain Asia" },
            { "UG", "Uganda" },
            { "type.co.pinyin", "Trefn Pinyin" },
            { "039", "De Ewrop" },
            { "Sinh", "Sinhanaidd" },
            { "UM", "Ynysoedd Pellennig UDA" },
            { "UN", "y Cenhedloedd Unedig" },
            { "US", "Yr Unol Daleithiau" },
            { "haw", "Haw\u00e4ieg" },
            { "%%1959ACAD", "Academig" },
            { "type.co.gb2312han", "Trefn Symledig Tsieina - GB2312" },
            { "UY", "Uruguay" },
            { "prg", "Prwseg" },
            { "UZ", "Uzbekistan" },
            { "tzm", "Tamaseit Canolbarth Moroco" },
            { "nnh", "Ngiemboon" },
            { "VA", "Y Fatican" },
            { "pro", "Hen Brofensaleg" },
            { "VC", "Saint Vincent a\u2019r Grenadines" },
            { "VE", "Venezuela" },
            { "VG", "Ynysoedd Gwyryf Prydain" },
            { "VI", "Ynysoedd Gwyryf yr Unol Daleithiau" },
            { "VN", "Fietnam" },
            { "VU", "Vanuatu" },
            { "nog", "Nogai" },
            { "rwk", "Rwa" },
            { "non", "Hen Norseg" },
            { "053", "Awstralasia" },
            { "%%AREVMDA", "Armeneg Gorllewinol" },
            { "054", "Melanesia" },
            { "WF", "Wallis a Futuna" },
            { "type.co.traditional", "Trefn Traddodiadol" },
            { "057", "Rhanbarth Micronesia" },
            { "jgo", "Ngomba" },
            { "lkt", "Lakota" },
            { "wae", "Walsereg" },
            { "WS", "Samoa" },
            { "wal", "Walamo" },
            { "was", "Washo" },
            { "XA", "Acenion Ffug" },
            { "war", "Winarayeg" },
            { "XB", "Bidi Ffug" },
            { "awa", "Awadhi" },
            { "061", "Polynesia" },
            { "%%KSCOR", "yr Orgraff Safonol" },
            { "XK", "Kosovo" },
            { "Gujr", "Gwjarataidd" },
            { "Zxxx", "Anysgrifenedig" },
            { "wbp", "Warlpiri" },
            { "YE", "Yemen" },
            { "nqo", "N\u2019Ko" },
            { "type.co.standard", "Trefn Safonol" },
            { "lmo", "Lombardeg" },
            { "%%SUTSILV", "SUTSILV" },
            { "fat", "Ffanti" },
            { "YT", "Mayotte" },
            { "ZA", "De Affrica" },
            { "type.lb.loose", "Arddull Toriad Llinell Rhydd" },
            { "Deva", "Devanagari" },
            { "type.nu.geor", "Rhifolion Georgaidd" },
            { "type.co.zhuyin", "Trefn Zhuyin" },
            { "Hira", "Hiragana" },
            { "ZM", "Zambia" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "Rhanbarth Anhysbys" },
            { "type.ms.metric", "System Fetrig" },
            { "type.ca.iso8601", "Calendr ISO-8601" },
            { "lol", "Mongo" },
            { "nso", "Sotho Gogleddol" },
            { "type.nu.telu", "Digidau Telugu" },
            { "loz", "Lozi" },
            { "jmc", "Matsiame" },
            { "type.nu.hansfin", "Rhifolion Ariannol Tsieineaidd Symledig" },
            { "hil", "Hiligaynon" },
            { "type.nu.arabext", "Digidau Arabig-Indig Estynedig" },
            { "nus", "N\u0175ereg" },
            { "dak", "Dacotaeg" },
            { "type.nu.fullwide", "Digidau Lled Llawn" },
            { "hit", "Hetheg" },
            { "dar", "Dargwa" },
            { "dav", "Taita" },
            { "lrc", "Luri Gogleddol" },
            { "nwc", "Hen Newari" },
            { "udm", "Fotiaceg" },
            { "Khmr", "Chmeraidd" },
            { "sad", "Sand\u00e4weg" },
            { "type.nu.roman", "Rhifolion Rhufeinig" },
            { "sah", "Sakha" },
            { "ltg", "Latgaleg" },
            { "sam", "Aramaeg Samaria" },
            { "saq", "Samb\u0175rw" },
            { "sas", "Sasaceg" },
            { "sat", "Santali" },
            { "jpr", "Iddew-Bersieg" },
            { "sba", "Ngambeieg" },
            { "Guru", "Gwrmwci" },
            { "%%ALUKU", "tafodiaith Aluku" },
            { "lua", "Luba-Lulua" },
            { "%%BISCAYAN", "BISCAYAN" },
            { "sbp", "Sangw" },
            { "nyn", "Niancole" },
            { "nym", "Niamwezi" },
            { "lun", "Lwnda" },
            { "nyo", "Nioro" },
            { "luo", "L\u0175o" },
            { "fil", "Ffilipineg" },
            { "hmn", "Hmongeg" },
            { "lus", "Lwshaieg" },
            { "bal", "Balwtsi" },
            { "ban", "Bal\u00efeg" },
            { "uga", "Wgariteg" },
            { "fit", "Ffinneg Tornedal" },
            { "luy", "Lwyia" },
            { "bas", "Bas\u00e2eg" },
            { "bax", "Bamwmeg" },
            { "jrb", "Iddew-Arabeg" },
            { "es_ES", "Sbaeneg Ewrop" },
            { "nzi", "Nzimeg" },
            { "sco", "Sgoteg" },
            { "scn", "Sisileg" },
            { "aa", "Affareg" },
            { "ab", "Abchaseg" },
            { "ae", "Afestaneg" },
            { "af", "Affric\u00e2neg" },
            { "ak", "Acaneg" },
            { "am", "Amhareg" },
            { "an", "Aragoneg" },
            { "Arab", "Arabaidd" },
            { "Jpan", "Japaneaidd" },
            { "ar", "Arabeg" },
            { "Hrkt", "Syllwyddor Japaneaidd" },
            { "as", "Asameg" },
            { "sdc", "Sasareseg Sardinia" },
            { "av", "Afareg" },
            { "sdh", "Cwrdeg Deheuol" },
            { "ay", "Aymareg" },
            { "az", "Aserbaijaneg" },
            { "%%OSOJS", "tafodiaith Oseacco/Osojane" },
            { "ba", "Bashcorteg" },
            { "be", "Belarwseg" },
            { "bg", "Bwlgareg" },
            { "bi", "Bislama" },
            { "bm", "Bambareg" },
            { "bn", "Bengaleg" },
            { "bo", "Tibeteg" },
            { "dgr", "Dogrib" },
            { "br", "Llydaweg" },
            { "bs", "Bosnieg" },
            { "see", "Seneca" },
            { "Mymr", "Myanmaraidd" },
            { "sei", "Seri" },
            { "type.nu.laoo", "Digidau Laoaidd" },
            { "seh", "Sena" },
            { "sel", "Selcypeg" },
            { "ca", "Catalaneg" },
            { "ses", "Koyraboro Senni" },
            { "ce", "Tsietsieneg" },
            { "ch", "Tsiamorro" },
            { "co", "Corseg" },
            { "Orya", "Or\u00efaidd" },
            { "cr", "Cri" },
            { "cs", "Tsieceg" },
            { "cu", "Hen Slafoneg" },
            { "cv", "Tshwfasheg" },
            { "cy", "Cymraeg" },
            { "type.nu.ethi", "Rhifolion Ethiopig" },
            { "da", "Daneg" },
            { "pt_PT", "Portiwgeeg Ewrop" },
            { "de", "Almaeneg" },
            { "type.cf.standard", "Fformat Arian Safonol" },
            { "bej", "Bej\u00e4eg" },
            { "din", "Dinca" },
            { "bem", "Bembeg" },
            { "sga", "Hen Wyddeleg" },
            { "type.nu.mong", "Digidau Mongolia" },
            { "dv", "Difehi" },
            { "es_419", "Sbaeneg America Ladin" },
            { "dz", "Dzongkha" },
            { "bez", "Bena" },
            { "type.ca.chinese", "Calendr Tseina" },
            { "dje", "Sarmaeg" },
            { "sgs", "Samogiteg" },
            { "type.nu.grek", "Rhifolion Groegaidd" },
            { "ee", "Ewe" },
            { "bfd", "Baffwteg" },
            { "type.lb.normal", "Arddull Toriad Llinell Arferol" },
            { "ro_MD", "Moldofeg" },
            { "el", "Groeg" },
            { "en", "Saesneg" },
            { "eo", "Esperanto" },
            { "bfq", "Badaga" },
            { "type.co.big5han", "Trefn Traddodiadol Tsieina - Big5" },
            { "es", "Sbaeneg" },
            { "et", "Estoneg" },
            { "Hanb", "Han gyda Bopomofo" },
            { "eu", "Basgeg" },
            { "Hang", "Hangul" },
            { "shi", "Tachelhit" },
            { "hsb", "Sorbeg Uchaf" },
            { "Hani", "Han" },
            { "shn", "Shan" },
            { "fa", "Perseg" },
            { "Hans", "Symledig" },
            { "type.nu.latn", "Digidau Gorllewinol" },
            { "Hant", "Traddodiadol" },
            { "az_Arab", "Aserbaijaneg Deheuol" },
            { "ff", "Ffwla" },
            { "shu", "Arabeg Chad" },
            { "fi", "Ffinneg" },
            { "fj", "Ffij\u00efeg" },
            { "fon", "Fon" },
            { "bgn", "Balochi Gorllewinol" },
            { "yue", "Cantoneeg" },
            { "fo", "Ffar\u00f6eg" },
            { "umb", "Umbundu" },
            { "fr", "Ffrangeg" },
            { "sid", "Sidamo" },
            { "fy", "Ffriseg y Gorllewin" },
            { "ga", "Gwyddeleg" },
            { "gd", "Gaeleg yr Alban" },
            { "gl", "Galisieg" },
            { "gn", "Guaran\u00ed" },
            { "bho", "Bhojpuri" },
            { "und", "Iaith anhysbys" },
            { "type.ca.ethiopic-amete-alem", "Calendr Amete Alem Ethiopia" },
            { "gu", "Gwjarati" },
            { "gv", "Manaweg" },
            { "ha", "Hawsa" },
            { "he", "Hebraeg" },
            { "hi", "Hindi" },
            { "hup", "Hupa" },
            { "bin", "Bini" },
            { "hr", "Croateg" },
            { "ht", "Creol Haiti" },
            { "hu", "Hwngareg" },
            { "hy", "Armeneg" },
            { "hz", "Herero" },
            { "frc", "Ffrangeg Cajwn" },
            { "%%FONIPA", "Seineg IPA" },
            { "ia", "Interlingua" },
            { "Jamo", "Jamo" },
            { "id", "Indoneseg" },
            { "type.nu.tibt", "Digidau Tibetaidd" },
            { "ie", "Interlingue" },
            { "ig", "Igbo" },
            { "ii", "Nwosw" },
            { "frm", "Ffrangeg Canol" },
            { "ik", "Inwpiaceg" },
            { "fro", "Hen Ffrangeg" },
            { "frp", "Arpitaneg" },
            { "io", "Ido" },
            { "frs", "Ffriseg y Dwyrain" },
            { "frr", "Ffriseg Gogleddol" },
            { "is", "Islandeg" },
            { "it", "Eidaleg" },
            { "iu", "Inwctitwt" },
            { "sli", "Is-silesieg" },
            { "%%HOGNORSK", "HOGNORSK" },
            { "ja", "Japaneeg" },
            { "Mlym", "Malayalamaidd" },
            { "doi", "Dogri" },
            { "bkm", "Comeg" },
            { "sma", "Sami Deheuol" },
            { "jv", "Jafanaeg" },
            { "%%BAUDDHA", "BAUDDHA" },
            { "mad", "Madwreg" },
            { "smj", "Sami Lwle" },
            { "mag", "Magahi" },
            { "mai", "Maithili" },
            { "smn", "Sami Inari" },
            { "ka", "Georgeg" },
            { "bla", "Siksika" },
            { "mak", "Macasareg" },
            { "sms", "Sami Scolt" },
            { "man", "Mandingo" },
            { "kg", "Congo" },
            { "ki", "Kikuyu" },
            { "mas", "Masai" },
            { "kj", "Kuanyama" },
            { "kk", "Casacheg" },
            { "kl", "Kalaallisut" },
            { "km", "Chmereg" },
            { "kn", "Kannada" },
            { "ko", "Coreeg" },
            { "kr", "Canwri" },
            { "ks", "Cashmireg" },
            { "ku", "Cwrdeg" },
            { "kv", "Comi" },
            { "kw", "Cernyweg" },
            { "ky", "Cirgiseg" },
            { "snk", "Soninceg" },
            { "la", metaValue_la },
            { "lb", "Lwcsembwrgeg" },
            { "type.nu.mlym", "Digidau Malayalamaidd" },
            { "lg", "Ganda" },
            { "li", "Limbwrgeg" },
            { "Tibt", "Tibetaidd" },
            { "ln", "Lingala" },
            { "fur", "Ffriwleg" },
            { "lo", "Laoeg" },
            { "type.ms.uksystem", "System Fesur Imperialaidd" },
            { "lt", "Lithwaneg" },
            { "lu", "Luba-Katanga" },
            { "lv", "Latfieg" },
            { "sog", "Sogdeg" },
            { "mg", "Malagaseg" },
            { "mh", "Marsialeg" },
            { "type.co.ducet", "Trefn Rhagosodedig Unicode" },
            { "mi", "Maori" },
            { "mk", "Macedoneg" },
            { "ml", "Malayalam" },
            { "mn", "Mongoleg" },
            { "mr", "Marathi" },
            { "ms", "Maleieg" },
            { "mt", "Malteg" },
            { "my", "Byrmaneg" },
            { "Armn", "Armenaidd" },
            { "mdf", "Mocsia" },
            { "dsb", "Sorbeg Isaf" },
            { "na", "Nawr\u0175eg" },
            { "type.co.search", "Chwilio at Ddibenion Cyffredinol" },
            { "nb", "Norwyeg Bokm\u00e5l" },
            { "nd", "Ndebele Gogleddol" },
            { "ne", "Nepaleg" },
            { "ng", "Ndonga" },
            { "mdr", "Mandareg" },
            { "nl", "Iseldireg" },
            { "nn", "Norwyeg Nynorsk" },
            { "no", "Norwyeg" },
            { "nr", "Ndebele Deheuol" },
            { "nv", "Nafaho" },
            { "kaa", "Cara-Calpaceg" },
            { "ny", "Nianja" },
            { "kac", "Kachin" },
            { "kab", "Cabileg" },
            { "oc", "Ocsitaneg" },
            { "kaj", "Jju" },
            { "kam", "Camba" },
            { "men", "Mendeg" },
            { "%%EMODENG", "Saesneg Modern Cynnar" },
            { "oj", "Ojibwa" },
            { "mer", "M\u00earw" },
            { "type.nu.armn", "Rhifolion Armenaidd" },
            { "om", "Oromo" },
            { "or", "Odia" },
            { "os", "Oseteg" },
            { "kbd", "Cabardieg" },
            { "mfe", "Morisyen" },
            { "srn", "Sranan Tongo" },
            { "pa", "Pwnjabeg" },
            { "dua", "Diwaleg" },
            { "srr", "Serereg" },
            { "pi", "Pali" },
            { "pl", "Pwyleg" },
            { "dum", "Iseldireg Canol" },
            { "type.ca.dangi", "Calendr Dangi" },
            { "%%VALLADER", "VALLADER" },
            { "ps", "Pashto" },
            { "pt", "Portiwgeeg" },
            { "mga", "Gwyddeleg Canol" },
            { "key.co", "Trefn" },
            { "pt_BR", "Portiwgeeg Brasil" },
            { "%%BOHORIC", "Gwyddor Bohori\u010d" },
            { "kcg", "Tyapeg" },
            { "mgh", "Makhuwa-Meetto" },
            { "key.cf", "Fformat Arian" },
            { "key.ca", "Calendr" },
            { "%%JAUER", "JAUER" },
            { "Laoo", "Laoaidd" },
            { "%%SURMIRAN", "SURMIRAN" },
            { "mgo", "Meta" },
            { "type.hc.h23", "System 24 Awr (0\u201323)" },
            { "type.hc.h24", "System 24 Awr (1\u201324)" },
            { "ssy", "Saho" },
            { "brh", "Brahui" },
            { "type.nu.mymr", "Digidau Myanmar" },
            { "qu", "Quechua" },
            { "zap", "Zapoteceg" },
            { "brx", "Bodo" },
            { "kde", "Macondeg" },
            { "%%VAIDIKA", "VAIDIKA" },
            { "stq", "Ffriseg Saterland" },
            { "Ethi", "Ethiopig" },
            { "%%JYUTPING", "JYUTPING" },
            { "type.hc.h12", "System 12 Awr (1\u201312)" },
            { "type.hc.h11", "System 12 Awr (0\u201311)" },
            { "rm", "Rom\u00e1nsh" },
            { "rn", "Rwndi" },
            { "key.cu", "Arian Breiniol" },
            { "ro", "Rwmaneg" },
            { "type.nu.orya", "Digidau Or\u00efaidd" },
            { "type.nu.hanidec", "Rhifolion Degol Tsieineaidd" },
            { "ru", "Rwseg" },
            { "bss", "Acwseg" },
            { "rw", "Ciniar\u0175andeg" },
            { "zbl", "Blisssymbols" },
            { "kea", "Caboferdianeg" },
            { "mic", "Micmaceg" },
            { "suk", "Swcwma" },
            { "en_AU", "Saesneg Awstralia" },
            { "sa", "Sansgrit" },
            { "sc", "Sardeg" },
            { "sus", "Sws\u0175eg" },
            { "sd", "Sindhi" },
            { "se", "Sami Gogleddol" },
            { "min", "Minangkabau" },
            { "sg", "Sango" },
            { "sh", "Serbo-Croateg" },
            { "si", "Sinhaleg" },
            { "sux", "Swmereg" },
            { "sk", "Slofaceg" },
            { "sl", "Slofeneg" },
            { "sm", "Sam\u00f6eg" },
            { "sn", "Shona" },
            { "so", "Somaleg" },
            { "type.nu.arab", "Digidau Arabig-Indig" },
            { "sq", "Albaneg" },
            { "sr", "Serbeg" },
            { "ss", "Swati" },
            { "type.cf.account", "Fformat Arian Cyfrifeg" },
            { "st", "Sesotheg Deheuol" },
            { "su", "Swndaneg" },
            { "%%NEDIS", "tafodiaith Natisone" },
            { "sv", "Swedeg" },
            { "sw", "Swahili" },
            { "type.nu.hantfin", "Rhifolion Ariannol Tsieineaidd Traddodiadol" },
            { "ibb", "Ibibio" },
            { "iba", "Ibaneg" },
            { "ta", "Tamileg" },
            { "142", "Asia" },
            { "bua", "Bwriateg" },
            { "143", "Canol Asia" },
            { "te", metaValue_te },
            { "145", "Gorllewin Asia" },
            { "tg", "Tajiceg" },
            { "th", "Thai" },
            { "ti", "Tigrinya" },
            { "bug", "Bwginaeg" },
            { "kfo", "Koro" },
            { "en_CA", "Saesneg Canada" },
            { "tk", "Twrcmeneg" },
            { "tl", "Tagalog" },
            { "tn", "Tswana" },
            { "to", "Tongeg" },
            { "bum", "Bwlw" },
            { "dyo", "Jola-Fonyi" },
            { "type.nu.jpan", "Rhifolion Japaneaidd" },
            { "tr", "Tyrceg" },
            { "ts", "Tsongaeg" },
            { "swb", "Comoreg" },
            { "tt", "Tatareg" },
            { "tw", "Twi" },
            { "ty", "Tahit\u00efeg" },
            { "150", "Ewrop" },
            { "151", "Dwyrain Ewrop" },
            { "154", "Gogledd Ewrop" },
            { "dzg", "Dazaga" },
            { "155", "Gorllewin Ewrop" },
            { "ug", "Uighur" },
            { "Kore", "Coreaidd" },
            { "Zyyy", "Cyffredin" },
            { "uk", "Wcreineg" },
            { "zea", "Z\u00ealandeg" },
            { "type.ca.coptic", "Calendr y Coptiaid" },
            { "ur", "Wrdw" },
            { "xal", "Calmyceg" },
            { "uz", "Wsbeceg" },
            { "kha", "C\u00e0seg" },
            { "nds_NL", "Sacsoneg Isel" },
            { "ve", "Fendeg" },
            { "type.ca.roc", "Calendr Gweriniaeth Tseina" },
            { "vi", "Fietnameg" },
            { "khq", "Koyra Chiini" },
            { "key.hc", "Cylched Awr (12 vs 24)" },
            { "vo", "Folap\u00fck" },
            { "khw", "Chowareg" },
            { "syc", "Hen Syrieg" },
            { "quc", "K\u2019iche\u2019" },
            { "gaa", "Ga" },
            { "wa", "Walwneg" },
            { "gag", "Gagauz" },
            { "syr", "Syrieg" },
            { "Grek", "Groegaidd" },
            { "wo", "Woloff" },
            { "zgh", "Tamaseit Safonol" },
            { "ar_001", "Arabeg Modern Safonol" },
            { "%%FONXSAMP", "FONXSAMP" },
            { "gay", "Gaio" },
            { "Mong", "Mongolaidd" },
            { "mnc", "Manshw" },
            { "szl", "Silesieg" },
            { "gba", "Gbaia" },
            { "mni", "Manipwri" },
            { "Latn", metaValue_la },
            { "type.nu.hans", "Rhifolion Tsieineaidd Symledig" },
            { "type.nu.hant", "Rhifolion Tsieineaidd Traddodiadol" },
            { "xh", "Xhosa" },
            { "type.nu.romanlow", "Rhifolion Rhufeinig mewn Llythrennau Bychain" },
            { "byn", "Blin" },
            { "%%PAMAKA", "tafodiaith Pamaka" },
            { "osa", "Osageg" },
            { "gbz", "Dareg y Zoroastriaid" },
            { "moh", "Mohoceg" },
            { "kkj", "Kako" },
            { "%%1694ACAD", "Ffrangeg Modern Cynnar" },
            { "yi", "Iddew-Almaeneg" },
            { "mos", "Mosi" },
            { "yo", "Iorwba" },
            { "es_MX", "Sbaeneg Mecsico" },
            { "ota", "Tyrceg Otoman" },
            { "vai", "Faieg" },
            { "kln", "Kalenjin" },
            { "zh", "Tsieineeg" },
            { "Bopo", "Bopomofo" },
            { "key.lb", "Arddull Toriad Llinell" },
            { "zu", "Swlw" },
            { "type.co.phonebook", "Trefn Llyfr Ff\u00f4n" },
            { "Geor", "Georgaidd" },
            { "kmb", "Kimbundu" },
            { "type.nu.jpanfin", "Rhifolion Ariannol Japaneaidd" },
            { "gez", "Geez" },
            { "mrj", "Mari Gorllewinol" },
            { "type.co.reformed", "Trefn Diwygiedig" },
            { "%%ITIHASA", "ITIHASA" },
            { "ebu", "Embw" },
            { "zh_Hans", "Tsieineeg Symledig" },
            { "koi", "Komi-Permyak" },
            { "kok", "Concani" },
            { "%%1901", "orgraff draddodiadol yr Almaeneg" },
            { "vec", "Feniseg" },
            { "zh_Hant", "Tsieineeg Traddodiadol" },
            { "vep", "Feps" },
            { "kpe", "Kpelle" },
            { "type.nu.khmr", "Digidau Chmeraidd" },
            { "ilo", "Ilocaneg" },
            { "mua", "Mundang" },
            { "type.nu.guru", "Digidau Gwrmwcaidd" },
            { "mul", "Mwy nag un iaith" },
            { "cad", "Cado" },
            { "key.ms", "System Fesur" },
            { "mus", "Creek" },
            { "gil", "Gilberteg" },
            { "%%KKCOR", "yr Orgraff Gyffredin" },
            { "car", "Caribeg" },
            { "type.nu.tamldec", "Digidau Tamilaidd" },
            { "krc", "Karachay-Balkar" },
            { "inh", "Ingwsieg" },
            { "krl", "Careleg" },
            { "efi", "Efik" },
            { "tcy", "Tulu" },
            { "key.nu", "Rhifau" },
            { "kru", "Kurukh" },
            { "ksb", "Shambala" },
            { "Telu", metaValue_te },
            { "ksf", "Baffia" },
        };
        return data;
    }
}
