/*
 * Copyright (c) 2012, 2022, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_gd extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_MM = "Mi\u00e0nmar";
        final String metaValue_NR = "Nabhru";
        final String metaValue_TK = "Tokelau";
        final String metaValue_TO = "Tonga";
        final String metaValue_TV = "Tubhalu";
        final String metaValue_ae = "Avestanais";
        final String metaValue_ar = "Arabais";
        final String metaValue_bo = "Tibeitis";
        final String metaValue_el = "Greugais";
        final String metaValue_gu = "Gujarati";
        final String metaValue_he = "Eabhra";
        final String metaValue_hy = "Airmeinis";
        final String metaValue_ja = "Seapanais";
        final String metaValue_jv = "De\u00e0bhanais";
        final String metaValue_ka = "Cairtbheilis";
        final String metaValue_km = "Cm\u00e8ar";
        final String metaValue_kn = "Kannada";
        final String metaValue_ko = "Coir\u00e8anais";
        final String metaValue_la = "Laideann";
        final String metaValue_lo = "L\u00e0tho";
        final String metaValue_ml = "Malayalam";
        final String metaValue_mn = "Mongolais";
        final String metaValue_si = "Sinhala";
        final String metaValue_te = "Telugu";
        final String metaValue_tl = "Tagalog";
        final String metaValue_chr = "Cherokee";
        final String metaValue_cop = "Coptais";
        final String metaValue_gez = "Ge\u2019ez";
        final String metaValue_got = "Gotais";
        final String metaValue_kpe = "Kpelle";
        final String metaValue_mak = "Makasar";
        final String metaValue_men = "Mende";
        final String metaValue_osa = "Osage";
        final String metaValue_peo = "Seann-Pheirsis";
        final String metaValue_saz = "Saurashtra";
        final String metaValue_ssy = "Saho";
        final String metaValue_syr = "Suraidheac";
        final String metaValue_vai = "Vai";
        final String metaValue_zbl = "Comharran Bliss";
        final Object[][] data = new Object[][] {
            { "ksh", "Gearmailtis Chologne" },
            { "Ogam", "Ogham-chraobh" },
            { "mwl", "Miorandais" },
            { "Zsym", "Samhlaidhean" },
            { "cch", "Atsam" },
            { "mwr", "Marwari" },
            { "type.nu.lanatham", "\u00c0ireamhan Tai Tham Tham" },
            { "mwv", "Mentawai" },
            { "Tagb", "Tagbanwa" },
            { "Zsye", "Emoji" },
            { "%%NJIVA", "Dual-chainnt Gniva/Njiva" },
            { "egy", "\u00c8ipheitis \u00c0rsaidh" },
            { "raj", "Rajasthani" },
            { "Phag", "Phags-pa" },
            { "tem", "Timne" },
            { "Medf", "Medefaidrin" },
            { "type.nu.sind", "\u00c0ireamhan Khudawadi" },
            { "teo", "Teso" },
            { "rap", "Rapa Nui" },
            { "ter", "Ter\u00eana" },
            { "AC", "Eilean na Deasgabhalach" },
            { "rar", "C\u00e0nan Rarotonga" },
            { "tet", "Tetum" },
            { "%%BARLA", "Dual-chainntean Barlavento de Kabuverdianu" },
            { "type.nu.sinh", "\u00c0ireamhan Lith na Sinhala" },
            { "AD", "Andorra" },
            { "AE", "Na h-Iomaratan Arabach Aonaichte" },
            { "nl_BE", "Flannrais" },
            { "AF", "Afghanast\u00e0n" },
            { "AG", "Aint\u00ecoga is Barbuda" },
            { "type.nu.mroo", "\u00c0ireamhan Mro" },
            { "type.ca.ethiopic", "M\u00ecosachan na h-Itioipe" },
            { "glk", "Gilaki" },
            { "AI", "Anguillia" },
            { "AL", "Alb\u00e0inia" },
            { "AM", "Airmeinea" },
            { "Teng", "Tengwar" },
            { "AO", "Ang\u00f2la" },
            { "AQ", "An Antartaig" },
            { "AR", "An Argantain" },
            { "Prti", "Partais snaidh-sgr\u00ecobhte" },
            { "AS", "Samotha na h-Aimeireaga" },
            { "AT", "An Ostair" },
            { "AU", "Astr\u00e0ilia" },
            { "AW", "Ar\u00f9ba" },
            { "en_US", "Beurla na h-Aimeireaga" },
            { "AX", "Na h-Eileanan \u00c5land" },
            { "mye", "Myene" },
            { "AZ", "Asarbaide\u00e0n" },
            { "%%AREVELA", "Airmeinis an Ear" },
            { "BA", "Bosna is Hearsagobhana" },
            { "BB", "Barbados" },
            { "ceb", "Cebuano" },
            { "BD", "Bangladais" },
            { "kum", "Kumyk" },
            { "BE", "A\u2019 Bheilg" },
            { "gmh", "Meadhan-\u00c0rd-Gearmailtis" },
            { "Sogo", "Seann-Sogdianais" },
            { "BF", "Buirciona Faso" },
            { "BG", "A\u2019 Bhulgair" },
            { "BH", "Bachrain" },
            { "BI", "Burundaidh" },
            { "BJ", "Beinin" },
            { "BL", "Saint Barth\u00e9lemy" },
            { "BM", "Bearm\u00f9da" },
            { "kut", "Kutenai" },
            { "myv", "Erzya" },
            { "BN", "Br\u00f9naigh" },
            { "BO", "Boilibhia" },
            { "BQ", "Na T\u00ecrean \u00ccsle Caraibeach" },
            { "BR", "Braisil" },
            { "BS", "Na h-Eileanan Bhathama" },
            { "xog", "Soga" },
            { "BT", "But\u00e0n" },
            { "BV", "Eilean Bouvet" },
            { "BW", "Botsuana" },
            { "BY", "A\u2019 Bhealaruis" },
            { "BZ", "A\u2019 Bheil\u00ecs" },
            { "type.ca.persian", "Am M\u00ecosachan Pearsach" },
            { "type.nu.hebr", "\u00c0ireamhan na h-Eabhra" },
            { "CA", "Canada" },
            { "CC", "Na h-Eileanan Chocos (Keeling)" },
            { "mzn", "Mazanderani" },
            { "CD", "Congo - Kinshasa" },
            { "CF", "Poblachd Meadhan Afraga" },
            { "CG", "A\u2019 Chongo - Brazzaville" },
            { "CH", "An Eilbheis" },
            { "CI", "C\u00f4te d\u2019Ivoire" },
            { "CK", "Eileanan Cook" },
            { "CL", "An t-Sile" },
            { "Kthi", "Kaithi" },
            { "CM", "Camarun" },
            { "CN", "An t-S\u00ecn" },
            { "CO", "Coloimbia" },
            { "CP", "Eilean Clipperton" },
            { "CR", "Costa R\u00eccea" },
            { "CU", "C\u00f9ba" },
            { "CV", "An Ceap Uaine" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Eilean na Nollaig" },
            { "CY", "C\u00ecopras" },
            { "type.nu.bali", "\u00c0ireamhan Bali" },
            { "CZ", "An t-Seic" },
            { "eka", "Ekajuk" },
            { "Ahom", "Ahom" },
            { "Pauc", "Pau Cin Hau" },
            { "vls", "Flannrais Siarach" },
            { "%%RIGIK", "Volap\u00fck chlasaigeach" },
            { "Sogd", "Sogdianais" },
            { "DE", "A\u2019 Ghearmailt" },
            { "goh", "Seann-\u00c0rd-Gearmailtis" },
            { "ace", "Basa Ac\u00e8h" },
            { "cgg", "Chiga" },
            { "DG", "Diego Garcia" },
            { "gom", "Konkani Goa" },
            { "type.nu.deva", "\u00c0ireamhan Devanagari" },
            { "DJ", "Diob\u00f9taidh" },
            { "DK", "An Danmhairg" },
            { "ach", "Acoli" },
            { "gon", "Gondi" },
            { "Brai", "Braille" },
            { "Brah", "Brahmi" },
            { "DM", "Doiminicea" },
            { "type.nu.armnlow", "\u00c0ireamhan beaga na h-Airmeinise" },
            { "DO", "A\u2019 Phoblachd Dhoiminiceach" },
            { "gor", "Gorontalo" },
            { "got", metaValue_got },
            { "Mtei", "Meitei Mayek" },
            { "zun", "Zu\u00f1i" },
            { "tig", "Tigre" },
            { "Takr", "Takri" },
            { "DZ", "Aildiria" },
            { "pag", "Pangasinan" },
            { "type.d0.hwidth", "Leth-Leud" },
            { "pal", "Pahlavi" },
            { "EA", "Ceuta agus Melilla" },
            { "chb", "Chibcha" },
            { "pam", "Pampanga" },
            { "EC", "Eacuador" },
            { "pap", "Papiamentu" },
            { "ada", "Adangme" },
            { "EE", "An Eastoin" },
            { "tiv", "Tiv" },
            { "EG", "An \u00c8iphit" },
            { "EH", "Sathara an Iar" },
            { "chg", "Chagatai" },
            { "pau", "Palabhais" },
            { "chk", "C\u00e0nan Chuuk" },
            { "chn", "Chinuk Wawa" },
            { "chm", "Mari" },
            { "chp", "Chipewyan" },
            { "cho", "Choctaw" },
            { "type.nu.mathbold", "\u00c0ireamhan matamataig troma" },
            { "chr", metaValue_chr },
            { "ER", "Eartra" },
            { "ES", "An Sp\u00e0innt" },
            { "ET", "An Itiop" },
            { "EU", "An t-Aonadh E\u00f2rpach" },
            { "elx", "Elamais" },
            { "type.ca.gregorian", "Am M\u00ecosachan Griogarach" },
            { "EZ", "Raon an E\u00f2ro" },
            { "chy", "Cheyenne" },
            { "type.nu.gujr", "\u00c0ireamhan Gujarati" },
            { "ady", "Adyghe" },
            { "aeb", "Arabais Thuiniseach" },
            { "FI", "An Fhionnlann" },
            { "FJ", "F\u00ecdi" },
            { "FK", "Na h-Eileanan F\u00e0clannach" },
            { "FM", "Na Meanbh-eileanan" },
            { "FO", "Na h-Eileanan F\u00e0ro" },
            { "Taml", "Taimil" },
            { "FR", "An Fhraing" },
            { "Kpel", metaValue_kpe },
            { "%%SIMPLE", "SIMPLE" },
            { "pcd", "Picard" },
            { "tkl", metaValue_TK },
            { "grb", "Grebo" },
            { "root", "Root" },
            { "%%DAJNKO", "Aibidil Dajnko" },
            { "type.ca.indian", "M\u00ecosachan N\u00e0iseanta nan Innseachan" },
            { "rgn", "Romagnol" },
            { "grc", "Greugais \u00c0rsaidh" },
            { "GA", "Gabon" },
            { "tkr", "Tsakhur" },
            { "GB", "An R\u00ecoghachd Aonaichte" },
            { "pcm", "Beurla Nig\u00e8iriach" },
            { "GD", "Grean\u00e0da" },
            { "GE", "A\u2019 Chairtbheil" },
            { "GF", "Guidhe\u00e0na na Frainge" },
            { "GG", "Ge\u00e0rnsaidh" },
            { "GH", "G\u00e0na" },
            { "Tale", "Tai Le" },
            { "GI", "Diobraltar" },
            { "afh", "Afrihili" },
            { "GL", "A\u2019 Ghraonlann" },
            { "enm", "Meadhan-Bheurla" },
            { "GM", "A\u2019 Ghaimbia" },
            { "GN", "Gini" },
            { "GP", "Guadalup" },
            { "GQ", "Gini Mheadhan-Chriosach" },
            { "GR", "A\u2019 Ghreug" },
            { "GS", "Se\u00f2irsea a Deas is na h-Eileanan Sandwich a Deas" },
            { "GT", "Guatamala" },
            { "GU", "Guam" },
            { "pdc", "Gearmailtis Phennsylvania" },
            { "type.nu.mathmono", "\u00c0ireamhan matamataig aon-leud" },
            { "GW", "Gini-Bioso" },
            { "tli", "Tlingit" },
            { "tlh", "Klingon" },
            { "Talu", "Tai Lue \u00d9r" },
            { "GY", "Guidhe\u00e0na" },
            { "ckb", "C\u00f9rdais Mheadhanach" },
            { "zxx", "Susbaint nach eil \u2019na ch\u00e0nan" },
            { "Jurc", "Jurchen" },
            { "tly", "Talysh" },
            { "pdt", "Plautdietsch" },
            { "de_AT", "Gearmailtis na h-Ostaire" },
            { "Vaii", metaValue_vai },
            { "HK", "Hong Kong SAR na S\u00ecne" },
            { "HM", "Eilean Heard is MhicDh\u00f2mhnaill" },
            { "HN", "Hond\u00f9ras" },
            { "HR", "A\u2019 Chr\u00f2thais" },
            { "agq", "Aghem" },
            { "gsw", "Gearmailtis Eilbheiseach" },
            { "type.ca.islamic-umalqura", "Am M\u00ecosachan Ioslamach (Umm al-Qura)" },
            { "HT", "Haidhti" },
            { "HU", "An Ungair" },
            { "tmh", "Tamashek" },
            { "IC", "Na h-Eileanan Can\u00e0rach" },
            { "nan", "Min Nan" },
            { "peo", metaValue_peo },
            { "ID", "Na h-Innd-innse" },
            { "Adlm", "Adlam" },
            { "type.nu.kali", "\u00c0ireamhan Kayah Li" },
            { "IE", "\u00c8irinn" },
            { "nap", "Eadailtis Napoli" },
            { "%%NDYUKA", "Dual-chainnt Ndyuka" },
            { "naq", "Nama" },
            { "type.nu.sora", "\u00c0ireamhan Sora Sompeng" },
            { "zza", "Zazaki" },
            { "Tang", "Tangut" },
            { "IL", "Iosrael" },
            { "Nbat", "Nabataean" },
            { "IM", "Eilean Mhanainn" },
            { "IN", "Na h-Innseachan" },
            { "type.co.eor", "\u00d2rdugh se\u00f2rsachaidh E\u00f2rpach" },
            { "IO", "Ranntair Breatannach Cuan nan Innseachan" },
            { "IQ", "Ior\u00e0c" },
            { "IR", "Ior\u00e0n" },
            { "IS", "Innis T\u00ecle" },
            { "IT", "An Eadailt" },
            { "Zmth", "Gn\u00ecomhairean matamataig" },
            { "type.nu.thai", "\u00c0ireamhan T\u00e0idh" },
            { "vro", "V\u00f5ro" },
            { "guc", "Wayuu" },
            { "%%POSIX", "Coimpiutair" },
            { "type.nu.beng", "\u00c0ireamhan na Beangailise" },
            { "type.nu.cyrl", "\u00c0ireamhan na Cirilise" },
            { "JE", "De\u00e0rsaidh" },
            { "type.ca.islamic", "Am M\u00ecosachan Ioslamach" },
            { "JM", "Diameuga" },
            { "Beng", "Beangailis" },
            { "%%EKAVSK", "S\u00e8irbhis le fuaimneachadh iarach" },
            { "JO", "I\u00f2rdan" },
            { "gur", "Frafra" },
            { "JP", "An t-Seapan" },
            { "%%1606NICT", "Meadhan-Fhraingis anmoch gu 1606" },
            { "ain", "Ainu" },
            { "%%KOCIEWIE", "Kociewie" },
            { "Mend", metaValue_men },
            { "guz", "Gusii" },
            { "tog", "Nyasa Tonga" },
            { "type.nu.knda", "\u00c0ireamhan Kannada" },
            { "Kali", "Kayah Li" },
            { "Sidd", "Siddham" },
            { "de_CH", "\u00c0rd-Ghearmailtis na h-Eilbheise" },
            { "type.ca.buddhist", "Am M\u00ecosachan Budach" },
            { "KE", "Ceinia" },
            { "419", "Aimeireaga Laidinneach" },
            { "KG", "C\u00ecorgastan" },
            { "KH", "Cambuidea" },
            { "KI", "Ciribeas" },
            { "KM", "Comoros" },
            { "Knda", metaValue_kn },
            { "KN", "Naomh Cr\u00ecstean is Nibheis" },
            { "Zinh", "D\u00ecleab" },
            { "fr_CA", "Fraingis Chanada" },
            { "KP", "Coir\u00e8a a Tuath" },
            { "KR", "Coir\u00e8a" },
            { "Plrd", "Miao Phollard" },
            { "fr_CH", "Fraingis Eilbheiseach" },
            { "KW", "Cuibh\u00e8it" },
            { "tpi", "Tok Pisin" },
            { "KY", "Na h-Eileanan Caimean" },
            { "KZ", "Casachst\u00e0n" },
            { "Cyrl", "Cirilis" },
            { "LA", "L\u00e0thos" },
            { "LB", "Leabanon" },
            { "LC", "Naomh L\u00f9isea" },
            { "phn", "Phenicis" },
            { "Cyrs", "Cirilis Seann-Sl\u00e0bhais na h-Eaglaise" },
            { "gwi", "Gwich\u02bcin" },
            { "%%LUNA1918", "LUNA1918" },
            { "nds", "Gearmailtis \u00ccochdarach" },
            { "LI", "Lichtenstein" },
            { "LK", "Sri Lanca" },
            { "akk", "Acadais" },
            { "cop", metaValue_cop },
            { "LR", "Lib\u00e8ir" },
            { "esu", "Yupik Mheadhanach" },
            { "LS", "Leasoto" },
            { "LT", "An Liotuain" },
            { "LU", "Lugsamburg" },
            { "LV", "An Laitbhe" },
            { "Kana", "Katakana" },
            { "Sora", "Sora Sompeng" },
            { "LY", "Libia" },
            { "lad", "Ladino" },
            { "vun", "Vunjo" },
            { "akz", "Alabama" },
            { "%%LAUKIKA", "Laukika" },
            { "lah", "Lahnda" },
            { "Mahj", "Mahajani" },
            { "lag", "Langi" },
            { "Thaa", "Thaana" },
            { "MA", "Moroco" },
            { "MC", "Monaco" },
            { "MD", "A\u2019 Mholdobha" },
            { "Nshu", "N\u00fcshu" },
            { "ME", "Am Monadh Neagrach" },
            { "MF", "Naomh M\u00e0rtainn" },
            { "lam", "Lamba" },
            { "MG", "Madagasgar" },
            { "MH", "Eileanan Mharshall" },
            { "ale", "Aleutais" },
            { "Thai", "T\u00e0idh" },
            { "type.nu.vaii", "\u00c0ireamhan Vai" },
            { "MK", "A\u2019 Mhasadon a Tuath" },
            { "type.nu.mathdbl", "\u00c0ireamhan matamataig le loidhne dh\u00f9bailte" },
            { "ML", "M\u00e0ili" },
            { "MM", metaValue_MM },
            { "MN", "D\u00f9thaich nam Mongol" },
            { "new", "Newari" },
            { "MO", "Mac\u00e0thu SAR na S\u00ecne" },
            { "aln", "Alb\u00e0inis Ghegeach" },
            { "MP", "Na h-Eileanan Mairianach a Tuath" },
            { "MQ", "Mairtinic" },
            { "MR", "Morat\u00e0inea" },
            { "MS", "Montsarat" },
            { "MT", "Malta" },
            { "cps", "Capiznon" },
            { "type.m0.ungegn", "Tar-litreachadh GEGN nan D\u00f9thchannan Aonaichte" },
            { "MU", "Na h-Eileanan Mhoiriseas" },
            { "alt", "Altais Dheasach" },
            { "MV", "Na h-Eileanan Mhaladaibh" },
            { "MW", "Malabhaidh" },
            { "MX", "Meagsago" },
            { "type.ca.japanese", "Am M\u00ecosachan Seapanach" },
            { "MY", "Malaidhsea" },
            { "MZ", "M\u00f2saimbic" },
            { "Phli", "Pahlavi nan snaidh-sgr\u00ecobhaidhean" },
            { "NA", "An Namaib" },
            { "202", "Afraga Deas air an t-Sathara" },
            { "type.ca.hebrew", "Am M\u00ecosachan Eabhrach" },
            { "type.co.dictionary", "\u00d2rdugh se\u00f2rsachaidh an fhaclair" },
            { "NC", "Cailleann Nuadh" },
            { "%%WADEGILE", "R\u00f2manachadh Wade-Giles" },
            { "tru", "Turoyo" },
            { "%%UCRCOR", "Litreachadh aonaichte \u2019s l\u00e8irmheasaichte" },
            { "NE", "N\u00ecgeir" },
            { "NF", "Eilean Norfolk" },
            { "NG", "Nig\u00e8iria" },
            { "trv", "Taroko" },
            { "Phlp", "Pahlavi nan saltair" },
            { "NI", "Niocaragua" },
            { "Hmng", "Pahawh Hmong" },
            { "NL", "Na T\u00ecrean \u00ccsle" },
            { "NO", "Nirribhidh" },
            { "NP", "Neap\u00e0l" },
            { "NR", metaValue_NR },
            { "NU", "Niue" },
            { "Phnx", "Pheniceach" },
            { "rof", "Rombo" },
            { "tsi", "Tsimshian" },
            { "NZ", "Sealainn Nuadh" },
            { "Merc", "Meroiticeach ceangailte" },
            { "%%COLB1945", "Aonta litreachaidh eadar a\u2019 Phortagail is Braisil 1945" },
            { "rom", "Romanais" },
            { "Mero", "Meroiticeach" },
            { "crh", "Turcais Chriomach" },
            { "ang", "Seann-Bheurla" },
            { "OM", "Om\u00e0n" },
            { "%%PETR1708", "Litreachadh Pheadair 1708" },
            { "anp", "Angika" },
            { "crs", "Seiseallais" },
            { "Xpeo", metaValue_peo },
            { "type.nu.hmng", "\u00c0ireamhan Pahawh Hmong" },
            { "PA", "Panama" },
            { "type.ca.islamic-civil", "Am M\u00ecosachan Ioslamach (cl\u00e0rach, linn s\u00ecobhalta)" },
            { "csb", "Caisiubais" },
            { "en_GB", "Beurla Bhreatainn" },
            { "PE", "Pear\u00f9" },
            { "ttt", "Tati" },
            { "PF", "Poilin\u00e8is na Frainge" },
            { "PG", "Gini Nuadh Phaputhach" },
            { "PH", "Na h-Eileanan Filipineach" },
            { "PK", "Pagast\u00e0n" },
            { "PL", "A\u2019 Ph\u00f2lainn" },
            { "ewo", "Ewondo" },
            { "PM", "Saint Pierre agus Miquelon" },
            { "PN", "Eileanan Pheit a\u2019 Ch\u00e0irn" },
            { "PR", "Porto R\u00ecceo" },
            { "PS", "\u00d9ghdarras nam Palastaineach" },
            { "Bali", "Bali" },
            { "PT", "A\u2019 Phortagail" },
            { "PW", "Palabh" },
            { "nia", "Nias" },
            { "type.nu.greklow", "\u00c0ireamhan beaga na Greugaise" },
            { "PY", "Paraguaidh" },
            { "tum", "Tumbuka" },
            { "Hebr", metaValue_he },
            { "QA", "Catar" },
            { "%%SCOTLAND", "Beurla Stannardach na h-Alba" },
            { "jam", "Beurla Cr\u00ectheolach Diameuga" },
            { "pms", "Piedmontese" },
            { "niu", "C\u00e0nan Niue" },
            { "QO", "Roinn Iomallach a\u2019 Chuain S\u00e8imh" },
            { "ext", "C\u00e0nan na h-Extremadura" },
            { "lez", "Leasgais" },
            { "type.nu.ahom", "\u00c0ireamhan Ahom" },
            { "%%FONUPA", "Comharran fuaim-e\u00f2lais an UPA" },
            { "type.nu.takr", "\u00c0ireamhan Takri" },
            { "tvl", metaValue_TV },
            { "Tavt", "Tai Viet" },
            { "%%SOTAV", "Dual-chainntean Sotavento de Kabuverdianu" },
            { "Maka", metaValue_mak },
            { "001", "An Saoghal" },
            { "002", "Afraga" },
            { "njo", "Ao Naga" },
            { "003", "Aimeireaga a Tuath" },
            { "RE", "R\u00e9union" },
            { "005", "Aimeireaga a Deas" },
            { "lfn", "Lingua Franca Nova" },
            { "jbo", "Lojban" },
            { "Rjng", "Rejang" },
            { "009", "Roinn a\u2019 Chuain S\u00e8imh" },
            { "%%SURSILV", "Sursilvan" },
            { "RO", "Rom\u00e0inia" },
            { "RS", "An t-S\u00e8irb" },
            { "Mroo", "Mro" },
            { "RU", "An Ruis" },
            { "RW", "Rubhanda" },
            { "type.nu.talu", "\u00c0ireamhan Tai Lue \u00d9r" },
            { "%%METELKO", "Aibidil Metelko" },
            { "Mani", "Manichaean" },
            { "Ugar", "Ugariticeach" },
            { "Khar", "Kharoshthi" },
            { "SA", "Ar\u00e0ibia nan Sabhd" },
            { "pon", "C\u00e0nan Pohnpei" },
            { "Mand", "Mandaean" },
            { "SB", "Eileanan Sholaimh" },
            { "twq", "Tasawaq" },
            { "011", "Afraga an Iar" },
            { "SC", "Na h-Eileanan Sheiseall" },
            { "SD", "Sud\u00e0n" },
            { "013", "Meadhan Aimeireaga" },
            { "SE", "An t-Suain" },
            { "014", "Afraga an Ear" },
            { "arc", "Aramais" },
            { "Loma", "Loma" },
            { "015", "Afraga a Tuath" },
            { "SG", "Singeap\u00f2r" },
            { "SH", "Eilean Naomh Eilidh" },
            { "type.lb.strict", "Brisidhean-loidhe teanna" },
            { "017", "Meadhan Afraga" },
            { "SI", "An t-Sl\u00f2bhain" },
            { "type.nu.mymrtlng", "\u00c0ireamhan Tai Laing Mi\u00e0nmar" },
            { "018", "Ceann a Deas Afraga" },
            { "SJ", "Svalbard agus Jan Mayen" },
            { "019", "An D\u00e0 Aimeireaga" },
            { "SK", "An t-Sl\u00f2bhac" },
            { "Bamu", "Bamum" },
            { "Wole", "Woleai" },
            { "SL", "Siarra Le\u00f2mhann" },
            { "SM", "San Marino" },
            { "SN", "Seanagal" },
            { "SO", "Som\u00e0ilia" },
            { "arn", "Mapudungun" },
            { "arp", "Arapaho" },
            { "type.nu.taml", "\u00c0ireamhan na Taimilise Tradaiseanta" },
            { "SR", "Suranam" },
            { "aro", "Araona" },
            { "SS", "Sud\u00e0n a Deas" },
            { "ST", "S\u00e3o Tom\u00e9 agus Pr\u00edncipe" },
            { "arq", "Arabais Aildireach" },
            { "SV", "An Salbhador" },
            { "SX", "Sint Maarten" },
            { "SY", "Siridhea" },
            { "yao", "Yao" },
            { "SZ", "D\u00f9thaich nan Suasaidh" },
            { "arw", "Arawak" },
            { "arz", "Arabais \u00c8ipheiteach" },
            { "ary", "Arabais Mhorocach" },
            { "yap", "C\u00e0nan Yap" },
            { "TA", "Tristan da Cunha" },
            { "asa", "Asu" },
            { "type.ms.ussystem", "Tomhas nan St\u00e0itean Aonaichte" },
            { "021", "Ceann a Tuath Aimeireaga" },
            { "TC", "Na h-Eileanan Turcach is Caiceo" },
            { "yav", "Yangben" },
            { "TD", "An t-Se\u00e0d" },
            { "TF", "Ranntairean a Deas na Frainge" },
            { "ase", "Cainnt-shanais na h-Aimeireaga" },
            { "TG", "Togo" },
            { "TH", "D\u00f9thaich nan T\u00e0idh" },
            { "TJ", "Taidigeast\u00e0n" },
            { "TK", metaValue_TK },
            { "029", "Am Muir Caraibeach" },
            { "TL", "Timor-Leste" },
            { "ybb", "Yemba" },
            { "type.co.searchjl", "Lorg leis a\u2019 chiad chonnrag Hangul" },
            { "TM", "Turcmanast\u00e0n" },
            { "%%BOONT", "Boontling" },
            { "TN", "Tuinisea" },
            { "TO", metaValue_TO },
            { "%%NULIK", "Nua-Volap\u00fck" },
            { "TR", "An Tuirc" },
            { "TT", "Trianaid agus Tobago" },
            { "TV", metaValue_TV },
            { "TW", "Taidh-Bh\u00e0n" },
            { "ast", "Ast\u00f9rais" },
            { "rue", "Rusyn" },
            { "rug", "Roviana" },
            { "Orkh", "Orkhon" },
            { "TZ", "An Tansan" },
            { "nmg", "Kwasio" },
            { "Zzzz", "Litreadh neo-aithnichte" },
            { "Sind", "Khudawadi" },
            { "UA", "An Ucr\u00e0in" },
            { "lij", "Liog\u00f9rais" },
            { "rup", "Aromanais" },
            { "030", "\u00c0isia an Ear" },
            { "tyv", "C\u00e0nan Tuva" },
            { "sw_CD", "Kiswahili na Congo" },
            { "034", "\u00c0isia a Deas" },
            { "hai", "Haida" },
            { "035", "\u00c0isia an Ear-dheas" },
            { "UG", "Uganda" },
            { "hak", "Hakka" },
            { "type.co.pinyin", "\u00d2rdugh se\u00f2rsachaidh Pinyin" },
            { "039", "An Roinn-E\u00f2rpa a Deas" },
            { "Sinh", metaValue_si },
            { "UM", "Meanbh-Eileanan Iomallach nan SA" },
            { "UN", "Na D\u00f9thchannan Aonaichte" },
            { "US", "Na St\u00e0itean Aonaichte" },
            { "haw", "C\u00e0nan Hawai\u2019i" },
            { "%%1959ACAD", "Bealaruisis Acadamaigeach" },
            { "%%IVANCHOV", "IVANCHOV" },
            { "type.co.gb2312han", "\u00d2rdugh se\u00f2rsachaidh na S\u00ecnise Simplichte - GB2312" },
            { "UY", "Uruguaidh" },
            { "prg", "Pruisis" },
            { "UZ", "Usbagast\u00e0n" },
            { "tzm", "Tamazight an Atlais Mheadhanaich" },
            { "type.co.stroke", "\u00d2rdugh nan str\u00e0can" },
            { "nnh", "Ngiemboon" },
            { "VA", "Cathair na Bhatacain" },
            { "pro", "Seann-Phroven\u00e7al" },
            { "VC", "Naomh Bhionsant agus Eileanan Greanadach" },
            { "%%HSISTEMO", "HSISTEMO" },
            { "VE", "A\u2019 Bheiniseala" },
            { "VG", "Eileanan Breatannach na Maighdinn" },
            { "VI", "Eileanan na Maighdinn aig na SA" },
            { "Soyo", "Soyombo" },
            { "VN", "Bhiet-Nam" },
            { "VU", "Vanuatu" },
            { "Marc", "Marchen" },
            { "nog", "Nogai" },
            { "rwk", "Rwa" },
            { "non", "Seann-Lochlannais" },
            { "053", "Astr\u00e0ilia is Sealainn Nuadh" },
            { "%%AREVMDA", "Airmeinis an Iar" },
            { "054", "Na h-Eileanan Dubha" },
            { "WF", "Uallas agus Futuna" },
            { "type.co.traditional", "\u00d2rdugh se\u00f2rsachaidh tradaiseanta" },
            { "057", "Roinn nam Meanbh-Eileanan" },
            { "jgo", "Ngomba" },
            { "lkt", "Lakh\u00f3ta" },
            { "nov", "Novial" },
            { "avk", "Kotava" },
            { "%%HEPBURN", "R\u00f2manachadh Hepburn" },
            { "type.co.compat", "\u00d2rdugh se\u00f2rsachaidh roimhe a chum co-ch\u00f2rdalachd" },
            { "wae", "Gearmailtis Wallis" },
            { "WS", "Samotha" },
            { "Bass", "Bassa Vah" },
            { "type.nu.mtei", "\u00c0ireamhan Meetei Mayek" },
            { "wal", "Wolaytta" },
            { "was", "Washo" },
            { "war", "Waray" },
            { "awa", "Awadhi" },
            { "061", "Poilin\u00e8is" },
            { "%%KSCOR", "Litreachadh stannardach" },
            { "XK", "A\u2019 Chosobho" },
            { "type.nu.brah", "\u00c0ireamhan Brahmi" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "Gun sgr\u00ecobhadh" },
            { "Olck", "Ol Chiki" },
            { "wbp", "Warlpiri" },
            { "Batk", "Batak" },
            { "Blis", metaValue_zbl },
            { "YE", "An Eaman" },
            { "nqo", "N\u2019Ko" },
            { "type.co.standard", "\u00d2rdugh se\u00f2rsachaidh stannardach" },
            { "lmo", "Lombardais" },
            { "Zanb", "Zanabazar ce\u00e0rnagach" },
            { "fan", "Fang" },
            { "%%BALANKA", "Dual-chainnt Balanka de Anii" },
            { "%%ROZAJ", "Dual-chainnt Resia" },
            { "%%SUTSILV", "Sutsilvan" },
            { "fat", "Fanti" },
            { "Sgnw", "Sgr\u00ecobhadh cainnte-sanais" },
            { "YT", "Mayotte" },
            { "type.nu.cham", "\u00c0ireamhan Cham" },
            { "%%NEWFOUND", "Beurla Talamh an \u00c8isg" },
            { "ZA", "Afraga a Deas" },
            { "type.nu.sund", "\u00c0ireamhan Sunda" },
            { "type.lb.loose", "Brisidhean-loidhe fuasgailte" },
            { "Deva", "Devanagari" },
            { "type.nu.geor", "\u00c0ireamhan na Cairtbheilise" },
            { "type.co.zhuyin", "\u00d2rdugh se\u00f2rsachaidh Zhuyin" },
            { "Hira", "Hiragana" },
            { "ZM", "S\u00e0imbia" },
            { "%%PINYIN", "R\u00f2manachadh Pinyin" },
            { "ZW", "An t-S\u00ecombab" },
            { "ZZ", "Roinn-d\u00f9thcha neo-aithnichte" },
            { "Runr", "R\u00f9n-sgr\u00ecobhadh" },
            { "type.ms.metric", "Tomhas meatrach" },
            { "type.ca.iso8601", "M\u00ecosachan ISO-8601" },
            { "lol", "Mongo" },
            { "nso", "Sesotho sa Leboa" },
            { "type.nu.telu", "\u00c0ireamhan Telugu" },
            { "lou", "Cr\u00ectheol Louisiana" },
            { "loz", "Lozi" },
            { "Nkgb", "Naxi Geba" },
            { "%%ASANTE", "ASANTE" },
            { "jmc", "Machame" },
            { "hif", "Hindis Fh\u00ecditheach" },
            { "type.nu.hansfin", "\u00c0ireamhan ionmhasail na S\u00ecnise Shimplichte" },
            { "hil", "Hiligaynon" },
            { "type.nu.arabext", "\u00c0ireamhan Arabach-Innseanach leudaichte" },
            { "nus", "Nuer" },
            { "dak", "Dakota" },
            { "type.nu.fullwide", "\u00c0ireamhan l\u00e0n-leud" },
            { "hit", "C\u00e0nan Het" },
            { "dar", "Dargwa" },
            { "dav", "Taita" },
            { "Maya", "Dealbh-sgr\u00ecobhadh Mayach" },
            { "lrc", "Luri Thuathach" },
            { "type.co.emoji", "\u00d2rdugh se\u00f2rsachaidh Emoji" },
            { "Copt", metaValue_cop },
            { "nwc", "Newari Chlasaigeach" },
            { "udm", "Udmurt" },
            { "Khmr", metaValue_km },
            { "%%FONNAPA", "FONNAPA" },
            { "type.ca.islamic-rgsa", "Am M\u00ecosachan Ioslamach (Ar\u00e0ibia nan Sabhd, sealladh)" },
            { "Limb", "Limbu" },
            { "sad", "Sandawe" },
            { "type.nu.roman", "\u00c0ireamhan R\u00f2manach" },
            { "sah", "Sakha" },
            { "type.nu.shrd", "\u00c0ireamhan Sharada" },
            { "sam", "Aramais Shamaritanach" },
            { "Aghb", "Alb\u00e0inis Chabhcasach" },
            { "%%SCOUSE", "Scouse" },
            { "saq", "Samburu" },
            { "sas", "Sasak" },
            { "sat", "Santali" },
            { "Tfng", "Tifinagh" },
            { "saz", metaValue_saz },
            { "jpr", "Peirsis I\u00f9dhach" },
            { "type.d0.npinyin", "\u00c0ireamhach" },
            { "sba", "Ngambay" },
            { "Guru", "Gurmukhi" },
            { "%%ALUKU", "Dual-chainnt Aluku" },
            { "lua", "Luba-Lulua" },
            { "%%BISCAYAN", "Dual-chainnt Bizkaia" },
            { "type.nu.tirh", "\u00c0ireamhan Tirhuta" },
            { "type.d0.fwidth", "L\u00e0n-Leud" },
            { "sbp", "Sangu" },
            { "lui", "Luise\u00f1o" },
            { "nyn", "Nyankole" },
            { "nym", "Nyamwezi" },
            { "lun", "Lunda" },
            { "nyo", "Nyoro" },
            { "luo", "Luo" },
            { "fil", "Filipinis" },
            { "hmn", "Hmong" },
            { "del", "Delaware" },
            { "lus", "Mizo" },
            { "bal", "Baluch\u00ec" },
            { "den", "Slavey" },
            { "ban", "C\u00e0nan Bali" },
            { "type.nu.wara", "\u00c0ireamhan Warang Citi" },
            { "fit", "Me\u00e4nkieli" },
            { "luy", "Luyia" },
            { "bas", "Basaa" },
            { "bax", "Bamun" },
            { "%%ABL1943", "Gn\u00e0thas-litreachaidh 1943" },
            { "jrb", "Arabais I\u00f9dhach" },
            { "es_ES", "Sp\u00e0inntis E\u00f2rpach" },
            { "nzi", "Nzima" },
            { "sco", "Albais" },
            { "scn", "Sisilis" },
            { "aa", "Afar" },
            { "ab", "Abchasais" },
            { "bbc", "Batak Toba" },
            { "ae", metaValue_ae },
            { "af", "Afraganais" },
            { "ak", "Akan" },
            { "type.nu.cakm", "\u00c0ireamhan Chakma" },
            { "bbj", "Ghomala" },
            { "am", "Amtharais" },
            { "Arab", metaValue_ar },
            { "an", "Aragonais" },
            { "%%SOLBA", "Dual-chainnt Stolvizza/Solbica" },
            { "Jpan", metaValue_ja },
            { "ar", metaValue_ar },
            { "Hrkt", "Katakana no Hiragana" },
            { "as", "Asamais" },
            { "sdc", "Sassarese" },
            { "Lina", "Linear A" },
            { "av", "Avarais" },
            { "Linb", "Linear B" },
            { "sdh", "C\u00f9rdais Dheasach" },
            { "ay", "Aymara" },
            { "az", "Asarbaide\u00e0nais" },
            { "Rohg", "Hanifi Rohingya" },
            { "Khoj", "Khojki" },
            { "%%OSOJS", "Dual-chainnt Oseacco/Osojane" },
            { "%%UNIFON", "Aibidil fuaim-e\u00f2lais Unifon" },
            { "ba", "Bashkir" },
            { "type.co.unihan", "\u00d2rdugh an fhreumha \u2019s nan str\u00e0can" },
            { "be", "Bealaruisis" },
            { "bg", "Bulgarais" },
            { "bi", "Bislama" },
            { "type.nu.java", "\u00c0ireamhan na De\u00e0bhanaise" },
            { "bm", "Bambara" },
            { "bn", "Bangla" },
            { "bo", metaValue_bo },
            { "dgr", "Dogrib" },
            { "br", "Breatnais" },
            { "bs", "Bosnais" },
            { "Bhks", "Bhaiksuki" },
            { "see", "Seneca" },
            { "Mymr", metaValue_MM },
            { "sei", "Seri" },
            { "type.nu.laoo", "\u00c0ireamhan L\u00e0tho" },
            { "seh", "Sena" },
            { "Nkoo", "N\u2019ko" },
            { "sel", "Selkup" },
            { "ca", "Catalanais" },
            { "ses", "Koyraboro Senni" },
            { "ce", "Deideanais" },
            { "ch", "Chamorro" },
            { "%%REVISED", "Litreachadh l\u00e8irmheasaichte" },
            { "co", "Corsais" },
            { "Orya", "Oriya" },
            { "cr", "Cree" },
            { "cs", "Seicis" },
            { "cu", "Sl\u00e0bhais na h-Eaglaise" },
            { "yrl", "Nheengatu" },
            { "cv", "Chuvash" },
            { "cy", "Cuimris" },
            { "type.nu.ethi", "\u00c0ireamhan Itiopach" },
            { "Yiii", "Yi" },
            { "da", "Danmhairgis" },
            { "pt_PT", "Portagailis E\u00f2rpach" },
            { "de", "Gearmailtis" },
            { "type.cf.standard", "F\u00f2rmat stannardach an airgeadra" },
            { "bej", "Beja" },
            { "din", "Dinka" },
            { "Bugi", "Lontara" },
            { "bem", "Bemba" },
            { "sga", "Seann-Ghaeilge" },
            { "type.nu.mong", "\u00c0ireamhan na Mongolaise" },
            { "dv", "Divehi" },
            { "es_419", "Sp\u00e0inntis na h-Aimeireaga Laidinneach" },
            { "bew", "Betawi" },
            { "dz", "Dzongkha" },
            { "bez", "Bena" },
            { "type.ca.chinese", "Am M\u00ecosachan S\u00ecneach" },
            { "lzh", "S\u00ecnis an Litreachais" },
            { "Lisu", "Lisu" },
            { "dje", "Zarma" },
            { "type.nu.grek", "\u00c0ireamhan na Greugaise" },
            { "ee", "Ewe" },
            { "bfd", "Bafut" },
            { "type.lb.normal", "Brisidhean-loidhe \u00e0bhaisteach" },
            { "ro_MD", "Moldobhais" },
            { "el", metaValue_el },
            { "en", "Beurla" },
            { "eo", "Esperanto" },
            { "bfq", "Badaga" },
            { "lzz", "Laz" },
            { "type.co.big5han", "\u00d2rdugh se\u00f2rsachaidh na S\u00ecnise Tradaiseanta - Big5" },
            { "es", "Sp\u00e0inntis" },
            { "et", "Eastoinis" },
            { "Hanb", "Han le Bopomofo" },
            { "eu", "Basgais" },
            { "Buhd", "Buhid" },
            { "Hang", "Hangul" },
            { "Samr", "Samaritanais" },
            { "shi", "Tachelhit" },
            { "hsb", "S\u00f2rbais Uachdarach" },
            { "Hani", "Han" },
            { "%%ULSTER", "Albais Uladh" },
            { "shn", "Shan" },
            { "Hano", "Hanunoo" },
            { "fa", "Peirsis" },
            { "Hans", "Simplichte" },
            { "type.nu.latn", "\u00c0ireamhan Siarach" },
            { "Hant", "Tradaiseanta" },
            { "ff", "Fulah" },
            { "shu", "Arabais Se\u00e0dach" },
            { "hsn", "Xiang" },
            { "fi", "Fionnlannais" },
            { "fj", "F\u00ecdis" },
            { "fon", "Fon" },
            { "bgn", "Balochi Shiarach" },
            { "yue", "Cantonais" },
            { "fo", "F\u00e0rothais" },
            { "type.m0.bgn", "Tar-litreachadh BGN nan St\u00e0itean Aonaichte" },
            { "umb", "Umbundu" },
            { "fr", "Fraingis" },
            { "%%AKUAPEM", "AKUAPEM" },
            { "sid", "Sidamo" },
            { "fy", "Fr\u00ecoslannais Shiarach" },
            { "ga", "Gaeilge" },
            { "gd", "G\u00e0idhlig" },
            { "Gong", "Gunjala Gondi" },
            { "gl", "Gail\u00ecsis" },
            { "Gonm", "Masaram Gondi" },
            { "gn", "Guaran\u00ed" },
            { "bho", "Bhojpuri" },
            { "und", "C\u00e0nan neo-aithnichte" },
            { "type.ca.ethiopic-amete-alem", "M\u00ecosachan Itiopach Amete Alem" },
            { "gu", metaValue_gu },
            { "type.ca.islamic-tbla", "Am M\u00ecosachan Ioslamach (cl\u00e0rach, linn reul-e\u00f2lach)" },
            { "gv", "Gaelg" },
            { "type.nu.osma", "\u00c0ireamhan Osmanya" },
            { "ha", "Hausa" },
            { "he", metaValue_he },
            { "hi", "Hindis" },
            { "hup", "Hupa" },
            { "bik", "Bikol" },
            { "bin", "Bini" },
            { "ho", "Hiri Motu" },
            { "hr", "Cr\u00f2thaisis" },
            { "ht", "Cr\u00ectheol Haidhti" },
            { "hu", "Ungairis" },
            { "hy", metaValue_hy },
            { "hz", "Herero" },
            { "frc", "Fraingis nan Cajun" },
            { "%%FONIPA", "Comharran fuaim-e\u00f2lais an IPA" },
            { "ia", "Interlingua" },
            { "Jamo", "Jamo" },
            { "id", "Innd-Innsis" },
            { "type.nu.tibt", "\u00c0ireamhan na Tibeitise" },
            { "ie", "Interlingue" },
            { "ig", "Igbo" },
            { "ii", "Yi Sichuan" },
            { "frm", "Meadhan-Fhraingis" },
            { "%%RUMGR", "Rumantsch Grischun" },
            { "%%AO1990", "Aonta litreachadh na Portagailise 1990" },
            { "ik", "Inupiaq" },
            { "fro", "Seann-Fhraingis" },
            { "frp", "Arpitan" },
            { "io", "Ido" },
            { "frs", "Fr\u00ecoslannais Earach" },
            { "bjn", "Banjar" },
            { "frr", "Fr\u00ecoslannais Thuathach" },
            { "is", "Innis T\u00eclis" },
            { "it", "Eadailtis" },
            { "iu", "Inuktitut" },
            { "%%CORNU", "Beurla na C\u00f2irne" },
            { "%%HOGNORSK", "H\u00f8gnorsk" },
            { "ja", metaValue_ja },
            { "Mlym", metaValue_ml },
            { "Sarb", "Seann-Arabais Dheasach" },
            { "Sara", "Sarati" },
            { "doi", "Dogri" },
            { "sly", "Selayar" },
            { "type.nu.lepc", "\u00c0ireamhan Lepcha" },
            { "bkm", "Kom" },
            { "sma", "S\u00e0mais Dheasach" },
            { "jv", metaValue_jv },
            { "Shaw", "Sgr\u00ecobhadh an t-Seathaich" },
            { "%%BAUDDHA", "Bauddha" },
            { "mad", "C\u00e0nan Madhura" },
            { "smj", "S\u00e0mais Lule" },
            { "mag", "Magahi" },
            { "maf", "Mafa" },
            { "mai", "Maithili" },
            { "smn", "S\u00e0mais Inari" },
            { "ka", metaValue_ka },
            { "mak", metaValue_mak },
            { "bla", "Siksika" },
            { "wuu", "Wu" },
            { "sms", "S\u00e0mais Skolt" },
            { "man", "Mandingo" },
            { "kg", "Kongo" },
            { "Goth", metaValue_got },
            { "ki", "Kikuyu" },
            { "mas", "Maasai" },
            { "kj", "Kuanyama" },
            { "kk", "Casachais" },
            { "kl", "Kalaallisut" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "Kanuri" },
            { "ks", "Caismiris" },
            { "Cirt", "Cirth" },
            { "Lepc", "Lepcha" },
            { "Avst", metaValue_ae },
            { "ku", "C\u00f9rdais" },
            { "kv", "Komi" },
            { "kw", "C\u00f2rnais" },
            { "ky", "C\u00ecorgasais" },
            { "snk", "Soninke" },
            { "Mult", "Multani" },
            { "la", metaValue_la },
            { "Hatr", "Hatran" },
            { "lb", "Lugsamburgais" },
            { "type.nu.mlym", "\u00c0ireamhan Malayalam" },
            { "lg", "Ganda" },
            { "Roro", "Rongorongo" },
            { "li", "C\u00e0nan Limburg" },
            { "Tibt", metaValue_bo },
            { "ln", "Lingala" },
            { "fur", "Fri\u00f9ilis" },
            { "lo", metaValue_lo },
            { "type.ms.uksystem", "Tomhas impireil" },
            { "type.nu.lana", "\u00c0ireamhan Tai Tham Hora" },
            { "lt", "Liotuainis" },
            { "lu", "Luba-Katanga" },
            { "lv", "Laitbheis" },
            { "mg", "Malagasais" },
            { "mh", "Marshallais" },
            { "type.co.ducet", "\u00d2rdugh se\u00f2rsachaidh Unicode bunaiteach" },
            { "mi", "M\u0101ori" },
            { "mk", "Masadonais" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "Marathi" },
            { "ms", "Malaidhis" },
            { "mt", "Maltais" },
            { "Saur", metaValue_saz },
            { "my", "Burmais" },
            { "Armn", metaValue_hy },
            { "mdf", "Moksha" },
            { "mde", "Maba" },
            { "dsb", "S\u00f2rbais \u00ccochdarach" },
            { "Armi", "Aramais impireil" },
            { "na", metaValue_NR },
            { "type.co.search", "Lorg coitcheann" },
            { "nb", "Bokm\u00e5l na Nirribhidh" },
            { "nd", "Ndebele Thuathach" },
            { "ne", "Neap\u00e0lais" },
            { "ng", "Ndonga" },
            { "mdr", "Mandar" },
            { "nl", "Duitsis" },
            { "nn", "Nynorsk na Nirribhidh" },
            { "no", "Nirribhis" },
            { "nr", "Ndebele Dheasach" },
            { "type.nu.modi", "\u00c0ireamhan Modi" },
            { "Osge", metaValue_osa },
            { "nv", "Navajo" },
            { "kaa", "Kara-Kalpak" },
            { "ny", "Nyanja" },
            { "kac", "Kachin" },
            { "kab", "Kabyle" },
            { "%%POLYTON", "Greugais phoiliotonach" },
            { "oc", "Ogsatanais" },
            { "kaj", "Jju" },
            { "kam", "Kamba" },
            { "men", metaValue_men },
            { "%%EMODENG", "Nua-Bheurla thr\u00e0th" },
            { "oj", "Ojibwa" },
            { "mer", "Meru" },
            { "type.nu.armn", "\u00c0ireamhan na h-Airmeinise" },
            { "om", "Oromo" },
            { "kaw", "Kawi" },
            { "dtp", "Dusun Mheadhanach" },
            { "or", "Odia" },
            { "Modi", "Modi" },
            { "os", "Ossetic" },
            { "%%ALALC97", "R\u00f2manachadh ALA-LC 1997" },
            { "bpy", "Bishnupriya" },
            { "kbd", "Cabardais" },
            { "mfe", "Morisyen" },
            { "srn", "Sranan Tongo" },
            { "pa", "Panjabi" },
            { "dua", "Duala" },
            { "srr", "Serer" },
            { "%%LIPAW", "Dual-chainnt Lipovaz Resia" },
            { "kbl", "Kanembu" },
            { "pi", "Pali" },
            { "bqi", "Bakhtiari" },
            { "pl", "P\u00f2lainnis" },
            { "dum", "Meadhan-Dhuitsis" },
            { "type.nu.saur", "\u00c0ireamhan Saurashtra" },
            { "type.ca.dangi", "M\u00ecosachan Dangi" },
            { "%%VALLADER", "Vallader" },
            { "ps", "Pashto" },
            { "pt", "Portagailis" },
            { "mga", "Meadhan-Ghaeilge" },
            { "key.co", "\u00d2rdugh an t-se\u00f2rsachaidh" },
            { "pt_BR", "Portagailis Bhraisileach" },
            { "%%BOHORIC", "Aibidil Bohori\u010d" },
            { "kcg", "Tyap" },
            { "mgh", "Makhuwa-Meetto" },
            { "key.cf", "F\u00f2rmat an airgeadra" },
            { "type.nu.nkoo", "\u00c0ireamhan N\u2019Ko" },
            { "bra", "Braj" },
            { "key.ca", "M\u00ecosachan" },
            { "%%JAUER", "Jauer" },
            { "Laoo", metaValue_lo },
            { "%%SURMIRAN", "Surmiran" },
            { "mgo", "Meta\u2019" },
            { "type.hc.h23", "Cleoc 24 uair a th\u00ecde (0\u201323)" },
            { "type.hc.h24", "Cleoc 24 uair a th\u00ecde (1\u201324)" },
            { "ssy", metaValue_ssy },
            { "brh", "Brahui" },
            { "type.nu.mymr", "\u00c0ireamhan Mi\u00e0nmar" },
            { "qu", "Quechua" },
            { "zap", "Zapotec" },
            { "brx", "Bodo" },
            { "Lana", "Lanna" },
            { "kde", "Makonde" },
            { "%%VAIDIKA", "Vaidika" },
            { "Ethi", metaValue_gez },
            { "%%JYUTPING", "Jyutping" },
            { "type.hc.h12", "Cleoc 12 uair a th\u00ecde (1\u201312)" },
            { "type.hc.h11", "Cleoc 12 uair a th\u00ecde (0\u201311)" },
            { "rm", "Rumains" },
            { "rn", "Kirundi" },
            { "key.cu", "Airgeadra" },
            { "ro", "Rom\u00e0inis" },
            { "%%SAAHO", metaValue_ssy },
            { "type.nu.orya", "\u00c0ireamhan Odia" },
            { "type.nu.hanidec", "\u00c0ireamhan deicheach na S\u00ecnise" },
            { "ru", "Ruisis" },
            { "bss", "Akoose" },
            { "zbl", metaValue_zbl },
            { "rw", "Kinyarwanda" },
            { "kea", "Kabuverdianu" },
            { "mic", "Mi\u2019kmaq" },
            { "suk", "Sukuma" },
            { "en_AU", "Beurla Astr\u00e0ilia" },
            { "Dupl", "Gearr-sgr\u00ecobhadh Duploy\u00e9" },
            { "sa", "Sanskrit" },
            { "%%UCCOR", "Litreachadh aonaichte" },
            { "sc", "S\u00e0rdais" },
            { "sus", "Susu" },
            { "sd", "Sindhi" },
            { "se", "S\u00e0mais Thuathach" },
            { "min", "Minangkabau" },
            { "sg", "Sango" },
            { "sh", "S\u00e8irb-Chr\u00f2thaisis" },
            { "ken", "Kenyang" },
            { "si", metaValue_si },
            { "sux", "C\u00e0nan Sumer" },
            { "sk", "Sl\u00f2bhacais" },
            { "sl", "Sl\u00f2bhainis" },
            { "Gran", "Grantha" },
            { "sm", "Samothais" },
            { "%%BASICENG", "Beurla bhunasach" },
            { "sn", "Shona" },
            { "so", "Som\u00e0ilis" },
            { "type.nu.arab", "\u00c0ireamhan Arabach-Innseanach" },
            { "sq", "Alb\u00e0inis" },
            { "sr", "S\u00e8irbis" },
            { "ss", "Swati" },
            { "type.cf.account", "F\u00f2rmat airgeadra na cunntasachd" },
            { "Java", metaValue_jv },
            { "st", "Sesotho" },
            { "su", "C\u00e0nan Sunda" },
            { "%%NEDIS", "Dual-chainnt Natisone" },
            { "sv", "Suainis" },
            { "sw", "Kiswahili" },
            { "type.nu.hantfin", "\u00c0ireamhan ionmhasail na S\u00ecnise Thradaiseanta" },
            { "ibb", "Ibibio" },
            { "iba", "Iban" },
            { "ta", "Taimilis" },
            { "142", "\u00c0isia" },
            { "bua", "Buriat" },
            { "143", "Meadhan \u00c0isia" },
            { "te", metaValue_te },
            { "145", "\u00c0isia an Iar" },
            { "tg", "Taidigis" },
            { "th", "C\u00e0nan nan T\u00e0idh" },
            { "%%SPANGLIS", "Spanglish" },
            { "ti", "Tigrinya" },
            { "bug", "C\u00e0nan nam Bugis" },
            { "kfo", "Koro" },
            { "en_CA", "Beurla Chanada" },
            { "tk", "Turcmanais" },
            { "tl", metaValue_tl },
            { "tn", "Tswana" },
            { "to", metaValue_TO },
            { "bum", "Bulu" },
            { "dyo", "Jola-Fonyi" },
            { "type.nu.jpan", "\u00c0ireamhan na Seapanaise" },
            { "tr", "Turcais" },
            { "ts", "Tsonga" },
            { "swb", "Comorais" },
            { "Cakm", "Chakma" },
            { "tt", "Tatarais" },
            { "%%XSISTEMO", "XSISTEMO" },
            { "dyu", "Dyula" },
            { "tw", "Twi" },
            { "ty", "C\u00e0nan Tahiti" },
            { "%%BISKE", "Dual-chainnt San Giorgio/Bila" },
            { "150", "An Roinn-E\u00f2rpa" },
            { "151", "An Roinn-E\u00f2rpa an Ear" },
            { "type.nu.rohg", "\u00c0ireamhan Hanifi Rohingya" },
            { "type.nu.mathsanb", "\u00c0ireamhan matamataig sans-serif troma" },
            { "154", "An Roinn-E\u00f2rpa a Tuath" },
            { "dzg", "Dazaga" },
            { "155", "An Roinn-E\u00f2rpa an Iar" },
            { "ug", "\u00d9igiurais" },
            { "Kore", metaValue_ko },
            { "Ital", "Seann-Eadailtis" },
            { "kgp", "Kaingang" },
            { "Zyyy", "Coitcheann" },
            { "uk", "Ucr\u00e0inis" },
            { "zea", "C\u00e0nan Zeeland" },
            { "type.ca.coptic", "Am M\u00ecosachan Coptach" },
            { "ur", "\u00d9rdu" },
            { "%%1994", "Litreachadh stannardach dual-chainnt Resia" },
            { "xal", "Kalmyk" },
            { "zen", "Zenaga" },
            { "uz", "Usbagais" },
            { "kha", "Khasi" },
            { "%%1996", "Litreachadh na Gearmailtise 1996" },
            { "nds_NL", "Sagsannais \u00ccochdarach" },
            { "Sylo", "Syloti Nagri" },
            { "ve", "Venda" },
            { "Wara", "Varang Kshiti" },
            { "type.ca.roc", "M\u00ecosachan Poblachd na S\u00ecne" },
            { "vi", "Bhiet-Namais" },
            { "kho", "C\u00e0nan Khotan" },
            { "khq", "Koyra Chiini" },
            { "key.hc", "Cearcall an ama (12 no 24 uair)" },
            { "%%TARASK", "Litreachadh Tara\u0161kievica" },
            { "vo", "Volap\u00fck" },
            { "khw", "Khowar" },
            { "syc", "Suraidheac Chlasaigeach" },
            { "type.nu.mathsans", "\u00c0ireamhan matamataig sans-serif" },
            { "Osma", "Osmanya" },
            { "quc", "K\u2019iche\u2019" },
            { "type.nu.gonm", "\u00c0ireamhan Masaram Gondi" },
            { "qug", "Quichua \u00c0rd-t\u00ecr Chimborazo" },
            { "Newa", "Newa" },
            { "gaa", "Ga" },
            { "wa", "Walloon" },
            { "gag", "Gagauz" },
            { "syr", metaValue_syr },
            { "type.nu.gong", "\u00c0ireamhan Gunjala Gondi" },
            { "Grek", metaValue_el },
            { "gan", "Gan" },
            { "kiu", "Kirmanjki" },
            { "Lydi", "Lydian" },
            { "Xsux", "G\u00e8inn-sgr\u00ecobhadh Sumer is Akkad" },
            { "wo", "Wolof" },
            { "zgh", "Tamazight Stannardach Moroco" },
            { "ar_001", "Nuadh-Arabais Stannardach" },
            { "Cans", "Sgr\u00ecobhadh Lideach Aonaichte nan T\u00f9sanach Canadach" },
            { "%%FONXSAMP", "FONXSAMP" },
            { "gay", "Gayo" },
            { "Mong", metaValue_mn },
            { "mnc", "Manchu" },
            { "Latf", "Laideann fraktur" },
            { "Hluw", "Dealbh-sgr\u00ecobhadh Anatolach" },
            { "gba", "Gbaya" },
            { "mni", "Manipuri" },
            { "Latn", metaValue_la },
            { "Latg", "Laideann Gh\u00e0idhealach" },
            { "type.nu.hans", "\u00c0ireamhan na S\u00ecnise Shimplichte" },
            { "type.nu.hant", "\u00c0ireamhan na S\u00ecnise Thradaiseanta" },
            { "xh", "Xhosa" },
            { "type.nu.romanlow", "\u00c0ireamhan beaga R\u00f2manach" },
            { "byn", "Blin" },
            { "Dogr", "Dogra" },
            { "%%PAMAKA", "Dual-chainnt Pamaka" },
            { "Lyci", "Lycian" },
            { "osa", metaValue_osa },
            { "byv", "Medumba" },
            { "gbz", "Dari Zoroastrach" },
            { "moh", "Mohawk" },
            { "kkj", "Kako" },
            { "%%1694ACAD", "Nua-Fhraingis thr\u00e0th" },
            { "Syrc", metaValue_syr },
            { "yi", "I\u00f9dhais" },
            { "mos", "Mossi" },
            { "Dsrt", "Deseret" },
            { "yo", "Yoruba" },
            { "es_MX", "Sp\u00e0inntis Mheagsagach" },
            { "Syrj", "Suraidheac Siarach" },
            { "ota", "Turcais Otomanach" },
            { "vai", metaValue_vai },
            { "za", "Zhuang" },
            { "Cari", "Carian" },
            { "kln", "Kalenjin" },
            { "zh", "S\u00ecnis" },
            { "Afak", "Afaka" },
            { "Bopo", "Bopomofo" },
            { "Perm", "Seann-Phermic" },
            { "key.lb", "Stoidhle nam brisidhean-loidhe" },
            { "zu", "Zulu" },
            { "type.co.phonebook", "\u00d2rdugh se\u00f2rsachaidh nan leabhraichean-f\u00f2n" },
            { "%%MONOTON", "Greugais mhonotonach" },
            { "Geor", metaValue_ka },
            { "Shrd", "Sharada" },
            { "kmb", "Kimbundu" },
            { "type.nu.jpanfin", "\u00c0ireamhan ionmhasail na Seapanaise" },
            { "Cham", "Cham" },
            { "gez", metaValue_gez },
            { "mrj", "Mari Shiarach" },
            { "Syrn", "Suraidheac Earach" },
            { "type.nu.mymrshan", "\u00c0ireamhan Shan Mi\u00e0nmar" },
            { "Elba", "Elbasan" },
            { "Narb", "Seann-Arabach Thuathach" },
            { "type.nu.olck", "\u00c0ireamhan Ol Chiki" },
            { "type.co.reformed", "\u00d2rdugh se\u00f2rsachaidh ath-leasaichte" },
            { "Tglg", metaValue_tl },
            { "%%ITIHASA", "Itihasa" },
            { "Palm", "Palmyrene" },
            { "ebu", "Embu" },
            { "Egyp", "Sealbh-sgr\u00ecobhadh \u00c8ipheiteach" },
            { "zh_Hans", "S\u00ecnis Shimplichte" },
            { "koi", "Komi-Permyak" },
            { "Hung", "Seann-Ungarais" },
            { "kok", "Konkani" },
            { "%%1901", "Litreachadh tradaiseanta na Gearmailtise" },
            { "%%PAHAWH2", "Pahawh Hmong na 2na \u00ecre" },
            { "%%PAHAWH3", "Pahawh Hmong na 3s \u00ecre" },
            { "%%PAHAWH4", "Pahawh Hmong na 4mh \u00ecre" },
            { "type.nu.limb", "\u00c0ireamhan Limbu" },
            { "zh_Hant", "S\u00ecnis Thradaiseanta" },
            { "Sund", "Sunda" },
            { "vep", "Veps" },
            { "kpe", metaValue_kpe },
            { "type.nu.khmr", "\u00c0ireamhan Cm\u00e8ar" },
            { "Tirh", "Tirhuta" },
            { "ilo", "Iloko" },
            { "%%VALENCIA", "Valenci\u00e0" },
            { "Cprt", "C\u00ecoprasais" },
            { "%%BAKU1926", "Abidil Laideann aonaichte na Turcaise" },
            { "%%IJEKAVSK", "S\u00e8irbis le fuaimneachadh Ijekavia" },
            { "mua", "Mundang" },
            { "type.nu.guru", "\u00c0ireamhan Gurmukhi" },
            { "mul", "Iomadh c\u00e0nan" },
            { "%%PUTER", "Puter" },
            { "cad", "Caddo" },
            { "key.ms", "Siostam tomhais" },
            { "mus", "Creek" },
            { "Glag", "Glagoliticeach" },
            { "gil", "Ciribeasais" },
            { "%%KKCOR", "Litreachadh coitcheann" },
            { "Cher", metaValue_chr },
            { "car", "Carib" },
            { "cay", "Cayuga" },
            { "type.nu.tamldec", "\u00c0ireamhan na Taimilise" },
            { "krc", "Karachay-Balkar" },
            { "inh", "Ingush" },
            { "krj", "Kinaray-a" },
            { "kri", "Krio" },
            { "krl", "Cairealais" },
            { "%%OXENDICT", "Litreachadh faclair Oxford na Beurla" },
            { "efi", "Efik" },
            { "tcy", "Tulu" },
            { "key.nu", "\u00c0ireamhan" },
            { "kru", "Kurukh" },
            { "ksb", "Shambala" },
            { "Telu", metaValue_te },
            { "ksf", "Bafia" },
        };
        return data;
    }
}
