/*
 * Copyright (c) 2012, 2022, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_hi extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_TR = "\u0924\u0941\u0930\u094d\u0915\u0940";
        final String metaValue_ar = "\u0905\u0930\u092c\u0940";
        final String metaValue_bn = "\u092c\u0902\u0917\u093e\u0932\u0940";
        final String metaValue_bo = "\u0924\u093f\u092c\u094d\u092c\u0924\u0940";
        final String metaValue_el = "\u092f\u0942\u0928\u093e\u0928\u0940";
        final String metaValue_gu = "\u0917\u0941\u091c\u0930\u093e\u0924\u0940";
        final String metaValue_he = "\u0939\u093f\u092c\u094d\u0930\u0942";
        final String metaValue_hy = "\u0906\u0930\u094d\u092e\u0947\u0928\u093f\u092f\u093e\u0908";
        final String metaValue_ja = "\u091c\u093e\u092a\u093e\u0928\u0940";
        final String metaValue_km = "\u0916\u092e\u0947\u0930";
        final String metaValue_kn = "\u0915\u0928\u094d\u0928\u0921\u093c";
        final String metaValue_ko = "\u0915\u094b\u0930\u093f\u092f\u093e\u0908";
        final String metaValue_la = "\u0932\u0948\u091f\u093f\u0928";
        final String metaValue_lo = "\u0932\u093e\u0913";
        final String metaValue_ml = "\u092e\u0932\u092f\u093e\u0932\u092e";
        final String metaValue_mn = "\u092e\u0902\u0917\u094b\u0932\u093f\u092f\u093e\u0908";
        final String metaValue_or = "\u0909\u0921\u093c\u093f\u092f\u093e";
        final String metaValue_si = "\u0938\u093f\u0902\u0939\u0932\u0940";
        final String metaValue_ta = "\u0924\u092e\u093f\u0932";
        final String metaValue_te = "\u0924\u0947\u0932\u0941\u0917\u0942";
        final String metaValue_th = "\u0925\u093e\u0908";
        final String metaValue_bug = "\u092c\u0917\u093f\u0928\u0940\u0938";
        final String metaValue_chr = "\u091a\u0947\u0930\u094b\u0915\u0940";
        final String metaValue_cop = "\u0915\u0949\u092a\u094d\u091f\u093f\u0915";
        final String metaValue_peo = "\u092a\u0941\u0930\u093e\u0928\u0940 \u092b\u093e\u0930\u0938\u0940";
        final String metaValue_vai = "\u0935\u093e\u0908";
        final String metaValue_zbl = "\u092c\u094d\u0932\u093f\u0938\u093f\u092e\u094d\u092c\u0949\u0932\u094d\u0938";
        final Object[][] data = new Object[][] {
            { "ksh", "\u0915\u094b\u0932\u094b\u0928\u093f\u092f\u093e\u0908" },
            { "Ogam", "\u0913\u0917\u092e" },
            { "mwl", "\u092e\u093f\u0930\u093e\u0902\u0921\u0940" },
            { "Zsym", "\u091a\u093f\u0939\u094d\u0928" },
            { "cch", "\u0905\u0924\u094d\u0938\u092e" },
            { "mwr", "\u092e\u093e\u0930\u0935\u093e\u0921\u093c\u0940" },
            { "Tagb", "\u0924\u0917\u092c\u0928\u094d\u0935\u093e" },
            { "Zsye", "\u0908\u092e\u094b\u091c\u0940" },
            { "%%NJIVA", "\u091c\u0940\u0935\u093e \u092c\u094b\u0932\u0940" },
            { "egy", "\u092a\u094d\u0930\u093e\u091a\u0940\u0928 \u092e\u093f\u0938\u094d\u0930\u0940" },
            { "raj", "\u0930\u093e\u091c\u0938\u094d\u0925\u093e\u0928\u0940" },
            { "Phag", "\u092b\u093e\u0917\u094d\u0938-\u092a\u093e" },
            { "tem", "\u091f\u093f\u092e\u094d\u0928\u0947" },
            { "teo", "\u091f\u0947\u0938\u094b" },
            { "rap", "\u0930\u093e\u092a\u093e\u0928\u0941\u0908" },
            { "ter", "\u0924\u0947\u0930\u0947\u0928\u094b" },
            { "AC", "\u0905\u0938\u0947\u0902\u0936\u0928 \u0926\u094d\u0935\u0940\u092a" },
            { "rar", "\u0930\u093e\u0930\u094b\u0924\u094b\u0902\u0917\u0928" },
            { "tet", "\u0924\u0947\u0924\u0941\u092e" },
            { "AD", "\u090f\u0902\u0921\u094b\u0930\u093e" },
            { "AE", "\u0938\u0902\u092f\u0941\u0915\u094d\u0924 \u0905\u0930\u092c \u0905\u092e\u0940\u0930\u093e\u0924" },
            { "nl_BE", "\u092b\u093c\u094d\u0932\u0947\u092e\u093f\u0936" },
            { "AF", "\u0905\u092b\u093c\u0917\u093e\u0928\u093f\u0938\u094d\u0924\u093e\u0928" },
            { "AG", "\u090f\u0902\u091f\u093f\u0917\u0941\u0906 \u0914\u0930 \u092c\u0930\u092c\u0941\u0921\u093e" },
            { "type.ca.ethiopic", "\u0907\u0925\u093f\u092f\u094b\u092a\u093f\u0915 \u0915\u0948\u0932\u0947\u0902\u0921\u0930" },
            { "AI", "\u090f\u0902\u0917\u094d\u0935\u093f\u0932\u093e" },
            { "key.tz", "\u0938\u092e\u092f \u0915\u094d\u0937\u0947\u0924\u094d\u0930" },
            { "AL", "\u0905\u0932\u094d\u092c\u093e\u0928\u093f\u092f\u093e" },
            { "AM", "\u0906\u0930\u094d\u092e\u0947\u0928\u093f\u092f\u093e" },
            { "Teng", "\u0924\u0947\u0928\u094d\u0917\u0935\u093e\u0930" },
            { "AO", "\u0905\u0902\u0917\u094b\u0932\u093e" },
            { "AQ", "\u0905\u0902\u091f\u093e\u0930\u094d\u0915\u091f\u093f\u0915\u093e" },
            { "AR", "\u0905\u0930\u094d\u091c\u0947\u0902\u091f\u0940\u0928\u093e" },
            { "Prti", "\u0907\u0902\u0938\u094d\u0915\u094d\u0930\u093f\u092a\u0936\u094d\u0928\u0932 \u092a\u093e\u0930\u094d\u0925\u093f\u092f\u0928" },
            { "AS", "\u0905\u092e\u0947\u0930\u093f\u0915\u0940 \u0938\u092e\u094b\u0906" },
            { "AT", "\u0911\u0938\u094d\u091f\u094d\u0930\u093f\u092f\u093e" },
            { "AU", "\u0911\u0938\u094d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u093e" },
            { "AW", "\u0905\u0930\u0942\u092c\u093e" },
            { "en_US", "\u0905\u092e\u0947\u0930\u093f\u0915\u0940 \u0905\u0902\u0917\u094d\u0930\u0947\u091c\u093c\u0940" },
            { "AX", "\u090f\u0932\u0948\u0902\u0921 \u0926\u094d\u0935\u0940\u092a\u0938\u092e\u0942\u0939" },
            { "AZ", "\u0905\u091c\u093c\u0930\u092c\u0948\u091c\u093e\u0928" },
            { "%%AREVELA", "\u092a\u0942\u0930\u094d\u0935\u0940 \u0905\u0930\u094d\u092e\u0947\u0928\u093f\u092f\u093e\u0908" },
            { "BA", "\u092c\u094b\u0938\u094d\u0928\u093f\u092f\u093e \u0914\u0930 \u0939\u0930\u094d\u091c\u093c\u0947\u0917\u094b\u0935\u093f\u0928\u093e" },
            { "BB", "\u092c\u093e\u0930\u092c\u093e\u0921\u094b\u0938" },
            { "ceb", "\u0938\u093f\u092c\u0941\u0906\u0928\u094b" },
            { "BD", "\u092c\u093e\u0902\u0917\u094d\u0932\u093e\u0926\u0947\u0936" },
            { "kum", "\u0915\u0941\u092e\u0940\u0915" },
            { "BE", "\u092c\u0947\u0932\u094d\u091c\u093f\u092f\u092e" },
            { "gmh", "\u092e\u0927\u094d\u092f\u0915\u093e\u0932\u0940\u0928 \u0939\u093e\u0907 \u091c\u0930\u094d\u092e\u0928" },
            { "BF", "\u092c\u0941\u0930\u094d\u0915\u093f\u0928\u093e \u092b\u093c\u093e\u0938\u094b" },
            { "BG", "\u092c\u0941\u0932\u094d\u0917\u093e\u0930\u093f\u092f\u093e" },
            { "BH", "\u092c\u0939\u0930\u0940\u0928" },
            { "BI", "\u092c\u0941\u0930\u0941\u0902\u0921\u0940" },
            { "BJ", "\u092c\u0947\u0928\u093f\u0928" },
            { "BL", "\u0938\u0947\u0902\u091f \u092c\u093e\u0930\u094d\u0925\u0947\u0932\u0947\u092e\u0940" },
            { "BM", "\u092c\u0930\u092e\u0942\u0921\u093e" },
            { "kut", "\u0915\u094d\u092f\u0942\u0924\u0928\u093e\u0908" },
            { "myv", "\u090f\u0930\u094d\u091c\u093c\u092f\u093e" },
            { "BN", "\u092c\u094d\u0930\u0942\u0928\u0947\u0908" },
            { "BO", "\u092c\u094b\u0932\u0940\u0935\u093f\u092f\u093e" },
            { "BQ", "\u0915\u0948\u0930\u093f\u092c\u093f\u092f\u0928 \u0928\u0940\u0926\u0930\u0932\u0948\u0902\u0921" },
            { "BR", "\u092c\u094d\u0930\u093e\u091c\u093c\u0940\u0932" },
            { "BS", "\u092c\u0939\u093e\u092e\u093e\u0938" },
            { "xog", "\u0938\u094b\u0917\u093e" },
            { "BT", "\u092d\u0942\u091f\u093e\u0928" },
            { "BV", "\u092c\u094b\u0935\u0947\u0924 \u0926\u094d\u0935\u0940\u092a" },
            { "BW", "\u092c\u094b\u0924\u094d\u0938\u094d\u0935\u093e\u0928\u093e" },
            { "BY", "\u092c\u0947\u0932\u093e\u0930\u0942\u0938" },
            { "BZ", "\u092c\u0947\u0932\u0940\u091c\u093c" },
            { "Visp", "\u0935\u093f\u0938\u093f\u092c\u0932 \u0938\u094d\u092a\u0940\u091a" },
            { "type.ca.persian", "\u092b\u093c\u093e\u0930\u0938\u0940 \u0915\u0948\u0932\u0947\u0902\u0921\u0930" },
            { "type.nu.hebr", "\u0939\u093f\u092c\u094d\u0930\u0942 \u0938\u0902\u0916\u094d\u092f\u093e\u090f\u0901" },
            { "CA", "\u0915\u0928\u093e\u0921\u093e" },
            { "CC", "\u0915\u094b\u0915\u094b\u0938 (\u0915\u0940\u0932\u093f\u0902\u0917) \u0926\u094d\u0935\u0940\u092a\u0938\u092e\u0942\u0939" },
            { "mzn", "\u092e\u093e\u091c\u093c\u0928\u094d\u0926\u0947\u0930\u093e\u0928\u0940" },
            { "CD", "\u0915\u093e\u0902\u0917\u094b - \u0915\u093f\u0902\u0936\u093e\u0938\u093e" },
            { "CF", "\u092e\u0927\u094d\u092f \u0905\u092b\u093c\u094d\u0930\u0940\u0915\u0940 \u0917\u0923\u0930\u093e\u091c\u094d\u092f" },
            { "CG", "\u0915\u093e\u0902\u0917\u094b \u2013 \u092c\u094d\u0930\u093e\u091c\u093c\u093e\u0935\u093f\u0932" },
            { "CH", "\u0938\u094d\u0935\u093f\u091f\u094d\u091c\u093c\u0930\u0932\u0948\u0902\u0921" },
            { "CI", "\u0915\u094b\u091f \u0921\u0940 \u0906\u0907\u0935\u0930" },
            { "CK", "\u0915\u0941\u0915 \u0926\u094d\u0935\u0940\u092a\u0938\u092e\u0942\u0939" },
            { "CL", "\u091a\u093f\u0932\u0940" },
            { "Kthi", "\u0915\u0948\u0925\u0940" },
            { "CM", "\u0915\u0948\u092e\u0930\u0942\u0928" },
            { "CN", "\u091a\u0940\u0928" },
            { "CO", "\u0915\u094b\u0932\u0902\u092c\u093f\u092f\u093e" },
            { "CP", "\u0915\u094d\u0932\u093f\u092a\u0930\u094d\u091f\u0928 \u0926\u094d\u0935\u0940\u092a" },
            { "CR", "\u0915\u094b\u0938\u094d\u091f\u093e\u0930\u093f\u0915\u093e" },
            { "CU", "\u0915\u094d\u092f\u0942\u092c\u093e" },
            { "CV", "\u0915\u0947\u092a \u0935\u0930\u094d\u0921" },
            { "CW", "\u0915\u094d\u092f\u0942\u0930\u093e\u0938\u093e\u0913" },
            { "CX", "\u0915\u094d\u0930\u093f\u0938\u092e\u0938 \u0926\u094d\u0935\u0940\u092a" },
            { "CY", "\u0938\u093e\u0907\u092a\u094d\u0930\u0938" },
            { "CZ", "\u091a\u0947\u0915\u093f\u092f\u093e" },
            { "eka", "\u090f\u0915\u093e\u091c\u0941\u0915" },
            { "DE", "\u091c\u0930\u094d\u092e\u0928\u0940" },
            { "goh", "\u092a\u0941\u0930\u093e\u0924\u0928 \u0939\u093e\u0907 \u091c\u0930\u094d\u092e\u0928" },
            { "ace", "\u0905\u091a\u093e\u0907\u0928\u0940\u0938" },
            { "cgg", "\u0936\u093f\u0917\u093e" },
            { "DG", "\u0921\u093f\u090f\u0917\u094b \u0917\u093e\u0930\u094d\u0938\u093f\u092f\u093e" },
            { "type.nu.deva", "\u0926\u0947\u0935\u0928\u093e\u0917\u0930\u0940 \u0905\u0902\u0915" },
            { "DJ", "\u091c\u093f\u092c\u0942\u0924\u0940" },
            { "DK", "\u0921\u0947\u0928\u092e\u093e\u0930\u094d\u0915" },
            { "ach", "\u0905\u0915\u094b\u0932\u0940" },
            { "gon", "\u0917\u093e\u0901\u0921\u0940" },
            { "Brai", "\u092c\u094d\u0930\u0947\u0932" },
            { "Brah", "\u092c\u094d\u0930\u0939\u094d\u092e\u0940" },
            { "DM", "\u0921\u094b\u092e\u093f\u0928\u093f\u0915\u093e" },
            { "type.nu.armnlow", "\u0906\u0930\u094d\u092e\u0947\u0928\u093f\u092f\u093e\u0908 \u0932\u094b\u0905\u0930\u0915\u0947\u0938 \u0938\u0902\u0916\u094d\u092f\u093e\u090f\u0901" },
            { "DO", "\u0921\u094b\u092e\u093f\u0928\u093f\u0915\u0928 \u0917\u0923\u0930\u093e\u091c\u094d\u092f" },
            { "gor", "\u0917\u094b\u0930\u094b\u0928\u094d\u0924\u093e\u0932\u094b" },
            { "got", "\u0917\u0949\u0925\u093f\u0915" },
            { "Mtei", "\u092e\u0947\u0907\u0924\u0947\u0907 \u092e\u093e\u092f\u0947\u0915" },
            { "zun", "\u091c\u093c\u0942\u0928\u0940" },
            { "tig", "\u091f\u093e\u0907\u0917\u094d\u0930\u0947" },
            { "DZ", "\u0905\u0932\u094d\u091c\u0940\u0930\u093f\u092f\u093e" },
            { "pag", "\u092a\u0902\u0917\u093e\u0938\u0940\u0928\u093e\u0928" },
            { "type.d0.hwidth", "\u0906\u0927\u0940-\u091a\u094c\u0921\u093c\u093e\u0908" },
            { "pal", "\u092a\u093e\u0939\u094d\u0932\u093e\u0935\u0940" },
            { "EA", "\u0938\u0947\u0909\u091f\u093e \u0914\u0930 \u092e\u0947\u0932\u093f\u0932\u093e" },
            { "chb", "\u091a\u093f\u092c\u094d\u091a\u093e" },
            { "pam", "\u092a\u093e\u092e\u094d\u092a\u093e\u0928\u094d\u0917\u093e" },
            { "EC", "\u0907\u0915\u094d\u0935\u093e\u0921\u094b\u0930" },
            { "pap", "\u092a\u093e\u092a\u093f\u092f\u093e\u092e\u0947\u0928\u094d\u091f\u094b" },
            { "ada", "\u0905\u0926\u093e\u0928\u094d\u0917\u092e\u0947" },
            { "EE", "\u090f\u0938\u094d\u091f\u094b\u0928\u093f\u092f\u093e" },
            { "tiv", "\u0924\u093f\u0935" },
            { "EG", "\u092e\u093f\u0938\u094d\u0930" },
            { "EH", "\u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u0938\u0939\u093e\u0930\u093e" },
            { "chg", "\u091b\u0917\u093e\u0924\u093e\u0908" },
            { "pau", "\u092a\u0932\u094b\u0909\u0906\u0928" },
            { "chk", "\u091a\u0942\u0915\u0940\u0938" },
            { "chn", "\u091a\u093f\u0928\u0942\u0915 \u091c\u093e\u0930\u0917\u0949\u0928" },
            { "chm", "\u092e\u093e\u0930\u0940" },
            { "chp", "\u0936\u093f\u092a\u0947\u0935\u094d\u092f\u093e\u0928" },
            { "cho", "\u091a\u094b\u0915\u094d\u0924\u094c" },
            { "chr", metaValue_chr },
            { "ER", "\u0907\u0930\u093f\u091f\u094d\u0930\u093f\u092f\u093e" },
            { "ES", "\u0938\u094d\u092a\u0947\u0928" },
            { "ET", "\u0907\u0925\u093f\u092f\u094b\u092a\u093f\u092f\u093e" },
            { "EU", "\u092f\u0942\u0930\u094b\u092a\u0940\u092f \u0938\u0902\u0918" },
            { "elx", "\u090f\u0932\u093e\u092e\u093e\u0907\u091f" },
            { "type.ca.gregorian", "\u0917\u094d\u0930\u0947\u0917\u094b\u0930\u093f\u092f\u0928 \u0915\u0948\u0932\u0947\u0902\u0921\u0930" },
            { "EZ", "\u092f\u0942\u0930\u094b\u091c\u093c\u094b\u0928" },
            { "chy", "\u0936\u0947\u092f\u0947\u0928\u094d\u0928" },
            { "type.nu.gujr", "\u0917\u0941\u091c\u0930\u093e\u0924\u0940 \u0905\u0902\u0915" },
            { "Inds", "\u0938\u093f\u0928\u094d\u0927\u0941" },
            { "ady", "\u0905\u0926\u093f\u0918\u0947" },
            { "FI", "\u092b\u093c\u093f\u0928\u0932\u0948\u0902\u0921" },
            { "FJ", "\u092b\u093c\u093f\u091c\u0940" },
            { "FK", "\u092b\u093c\u0949\u0915\u0932\u0948\u0902\u0921 \u0926\u094d\u0935\u0940\u092a\u0938\u092e\u0942\u0939" },
            { "FM", "\u092e\u093e\u0907\u0915\u094d\u0930\u094b\u0928\u0947\u0936\u093f\u092f\u093e" },
            { "key.va", "\u0938\u094d\u0925\u093e\u0928\u0940\u092f \u092a\u094d\u0930\u0915\u093e\u0930" },
            { "FO", "\u092b\u093c\u0947\u0930\u094b \u0926\u094d\u0935\u0940\u092a\u0938\u092e\u0942\u0939" },
            { "Taml", metaValue_ta },
            { "FR", "\u092b\u093c\u094d\u0930\u093e\u0902\u0938" },
            { "tkl", "\u0924\u094b\u0915\u0947\u0932\u093e\u090a" },
            { "grb", "\u0917\u094d\u0930\u0947\u092c\u094b" },
            { "root", "\u0930\u0942\u091f" },
            { "type.ca.indian", "\u092d\u093e\u0930\u0924\u0940\u092f \u0930\u093e\u0937\u094d\u091f\u094d\u0930\u0940\u092f \u0915\u0948\u0932\u0947\u0902\u0921\u0930" },
            { "grc", "\u092a\u094d\u0930\u093e\u091a\u0940\u0928 \u092f\u0942\u0928\u093e\u0928\u0940" },
            { "GA", "\u0917\u0948\u092c\u0949\u0928" },
            { "vot", "\u0935\u0949\u091f\u093f\u0915" },
            { "GB", "\u092f\u0942\u0928\u093e\u0907\u091f\u0947\u0921 \u0915\u093f\u0902\u0917\u0921\u092e" },
            { "pcm", "\u0928\u093e\u0907\u091c\u0940\u0930\u093f\u092f\u093e\u0908 \u092a\u093f\u0921\u0917\u093f\u0928" },
            { "GD", "\u0917\u094d\u0930\u0947\u0928\u093e\u0921\u093e" },
            { "GE", "\u091c\u0949\u0930\u094d\u091c\u093f\u092f\u093e" },
            { "GF", "\u092b\u093c\u094d\u0930\u0947\u0902\u091a \u0917\u0941\u092f\u093e\u0928\u093e" },
            { "GG", "\u0917\u0930\u094d\u0928\u0938\u0940" },
            { "GH", "\u0918\u093e\u0928\u093e" },
            { "Tale", "\u0924\u093e\u0908 \u0932\u0940" },
            { "GI", "\u091c\u093f\u092c\u094d\u0930\u093e\u0932\u094d\u091f\u0930" },
            { "afh", "\u0905\u092b\u094d\u0930\u093f\u0939\u093f\u0932\u0940" },
            { "GL", "\u0917\u094d\u0930\u0940\u0928\u0932\u0948\u0902\u0921" },
            { "enm", "\u092e\u0927\u094d\u092f\u0915\u093e\u0932\u0940\u0928 \u0905\u0902\u0917\u094d\u0930\u0947\u091c\u093c\u0940" },
            { "GM", "\u0917\u093e\u092e\u094d\u092c\u093f\u092f\u093e" },
            { "GN", "\u0917\u093f\u0928\u0940" },
            { "GP", "\u0917\u094d\u0935\u093e\u0921\u0947\u0932\u0942\u092a" },
            { "GQ", "\u0907\u0915\u094d\u0935\u0947\u091f\u094b\u0930\u093f\u092f\u0932 \u0917\u093f\u0928\u0940" },
            { "GR", "\u092f\u0942\u0928\u093e\u0928" },
            { "GS", "\u0926\u0915\u094d\u0937\u093f\u0923 \u091c\u0949\u0930\u094d\u091c\u093f\u092f\u093e \u0914\u0930 \u0926\u0915\u094d\u0937\u093f\u0923 \u0938\u0948\u0902\u0921\u0935\u093f\u091a \u0926\u094d\u0935\u0940\u092a\u0938\u092e\u0942\u0939" },
            { "GT", "\u0917\u094d\u0935\u093e\u091f\u0947\u092e\u093e\u0932\u093e" },
            { "GU", "\u0917\u0941\u0906\u092e" },
            { "GW", "\u0917\u093f\u0928\u0940-\u092c\u093f\u0938\u093e\u0909" },
            { "tli", "\u0924\u094d\u0932\u093f\u0902\u0917\u093f\u0924" },
            { "tlh", "\u0915\u094d\u0932\u093f\u0902\u0917\u0928" },
            { "Talu", "\u0928\u092f\u093e \u0924\u093e\u0908 \u0932\u0941" },
            { "GY", "\u0917\u0941\u092f\u093e\u0928\u093e" },
            { "ckb", "\u0938\u094b\u0930\u093e\u0928\u0940 \u0915\u0941\u0930\u094d\u0926\u093f\u0936" },
            { "zxx", "\u0915\u094b\u0908 \u092d\u093e\u0937\u093e \u0938\u093e\u092e\u0917\u094d\u0930\u0940 \u0928\u0939\u0940\u0902" },
            { "de_AT", "\u0911\u0938\u094d\u091f\u094d\u0930\u093f\u092f\u093e\u0908 \u091c\u0930\u094d\u092e\u0928" },
            { "Vaii", metaValue_vai },
            { "HK", "\u0939\u093e\u0901\u0917 \u0915\u093e\u0901\u0917 (\u091a\u0940\u0928 \u0935\u093f\u0936\u0947\u0937 \u092a\u094d\u0930\u0936\u093e\u0938\u0928\u093f\u0915 \u0915\u094d\u0937\u0947\u0924\u094d\u0930)" },
            { "HM", "\u0939\u0930\u094d\u0921 \u0926\u094d\u0935\u0940\u092a \u0914\u0930 \u092e\u0948\u0915\u0921\u094b\u0928\u0949\u0932\u094d\u0921 \u0926\u094d\u0935\u0940\u092a\u0938\u092e\u0942\u0939" },
            { "HN", "\u0939\u094b\u0902\u0921\u0942\u0930\u093e\u0938" },
            { "HR", "\u0915\u094d\u0930\u094b\u090f\u0936\u093f\u092f\u093e" },
            { "agq", "\u0905\u0917\u094d\u0939\u0947\u092e" },
            { "gsw", "\u0938\u094d\u0935\u093f\u0938 \u091c\u0930\u094d\u092e\u0928" },
            { "type.ca.islamic-umalqura", "\u0907\u0938\u094d\u0932\u093e\u092e\u0940 \u0915\u0948\u0932\u0947\u0902\u0921\u0930 (\u0909\u092e\u094d\u092e \u0905\u0932-\u0915\u093c\u0941\u0930\u093e)" },
            { "HT", "\u0939\u0948\u0924\u0940" },
            { "HU", "\u0939\u0902\u0917\u0930\u0940" },
            { "tmh", "\u0924\u093e\u092e\u093e\u0936\u0947\u0915" },
            { "IC", "\u0915\u0948\u0928\u0947\u0930\u0940 \u0926\u094d\u0935\u0940\u092a\u0938\u092e\u0942\u0939" },
            { "nan", "nan" },
            { "peo", metaValue_peo },
            { "ID", "\u0907\u0902\u0921\u094b\u0928\u0947\u0936\u093f\u092f\u093e" },
            { "IE", "\u0906\u092f\u0930\u0932\u0948\u0902\u0921" },
            { "nap", "\u0928\u0940\u092a\u094b\u0932\u093f\u091f\u0928" },
            { "naq", "\u0928\u093e\u092e\u093e" },
            { "zza", "\u091c\u093c\u093e\u091c\u093c\u093e" },
            { "IL", "\u0907\u091c\u093c\u0930\u093e\u0907\u0932" },
            { "IM", "\u0906\u0907\u0932 \u0911\u092b\u093c \u092e\u0948\u0928" },
            { "IN", "\u092d\u093e\u0930\u0924" },
            { "type.co.eor", "\u092f\u0942\u0930\u094b\u092a\u0940\u092f \u0915\u094d\u0930\u092e\u0923 \u0928\u093f\u092f\u092e" },
            { "IO", "\u092c\u094d\u0930\u093f\u091f\u093f\u0936 \u0939\u093f\u0902\u0926 \u092e\u0939\u093e\u0938\u093e\u0917\u0930\u0940\u092f \u0915\u094d\u0937\u0947\u0924\u094d\u0930" },
            { "IQ", "\u0907\u0930\u093e\u0915" },
            { "IR", "\u0908\u0930\u093e\u0928" },
            { "IS", "\u0906\u0907\u0938\u0932\u0948\u0902\u0921" },
            { "IT", "\u0907\u091f\u0932\u0940" },
            { "Zmth", "\u0917\u0923\u093f\u0924\u0940\u092f \u0938\u0902\u0915\u0947\u0924\u0928" },
            { "type.nu.thai", "\u0925\u093e\u0908 \u0905\u0902\u0915" },
            { "%%POSIX", "\u0915\u092e\u094d\u092a\u094d\u092f\u0942\u091f\u0930" },
            { "type.nu.beng", "\u092c\u0902\u0917\u093e\u0932\u0940 \u0905\u0902\u0915" },
            { "JE", "\u091c\u0930\u094d\u0938\u0940" },
            { "type.ca.islamic", "\u0907\u0938\u094d\u0932\u093e\u092e\u0940 \u092a\u0902\u091a\u093e\u0902\u0917" },
            { "Beng", metaValue_bn },
            { "JM", "\u091c\u092e\u0948\u0915\u093e" },
            { "JO", "\u091c\u0949\u0930\u094d\u0921\u0928" },
            { "JP", "\u091c\u093e\u092a\u093e\u0928" },
            { "ain", "\u0910\u0928\u0942" },
            { "guz", "\u0917\u0941\u0938\u0940" },
            { "tog", "\u0928\u094d\u092f\u093e\u0938\u093e \u091f\u094b\u0928\u094d\u0917\u093e" },
            { "type.nu.knda", "\u0915\u0928\u094d\u0928\u0921\u093c \u0905\u0902\u0915" },
            { "Kali", "\u0915\u093e\u092f\u093e\u0939 \u0932\u0940" },
            { "de_CH", "\u0938\u094d\u0935\u093f\u0938 \u0909\u091a\u094d\u091a \u091c\u0930\u094d\u092e\u0928" },
            { "type.co.phonetic", "\u0927\u094d\u200d\u0935\u0928\u094d\u092f\u093e\u0924\u094d\u092e\u0915 \u0915\u094d\u0930\u092e\u093f\u0924 \u0915\u0930\u0928\u0947 \u0915\u093e \u0915\u094d\u0930\u092e" },
            { "type.ca.buddhist", "\u092c\u094c\u0926\u094d\u0927 \u092a\u0902\u091a\u093e\u0902\u0917" },
            { "KE", "\u0915\u0947\u0928\u094d\u092f\u093e" },
            { "419", "\u0932\u0948\u091f\u093f\u0928 \u0905\u092e\u0947\u0930\u093f\u0915\u093e" },
            { "KG", "\u0915\u093f\u0930\u094d\u0917\u093f\u091c\u093c\u0938\u094d\u0924\u093e\u0928" },
            { "KH", "\u0915\u0902\u092c\u094b\u0921\u093f\u092f\u093e" },
            { "KI", "\u0915\u093f\u0930\u093f\u092c\u093e\u0924\u0940" },
            { "KM", "\u0915\u094b\u092e\u094b\u0930\u094b\u0938" },
            { "Knda", metaValue_kn },
            { "KN", "\u0938\u0947\u0902\u091f \u0915\u093f\u091f\u094d\u0938 \u0914\u0930 \u0928\u0947\u0935\u093f\u0938" },
            { "Zinh", "\u0935\u093f\u0930\u093e\u0938\u0924" },
            { "fr_CA", "\u0915\u0928\u093e\u0921\u093e\u0908 \u092b\u093c\u094d\u0930\u0947\u0902\u091a" },
            { "KP", "\u0909\u0924\u094d\u0924\u0930 \u0915\u094b\u0930\u093f\u092f\u093e" },
            { "KR", "\u0926\u0915\u094d\u0937\u093f\u0923 \u0915\u094b\u0930\u093f\u092f\u093e" },
            { "Plrd", "\u092a\u0949\u0932\u093e\u0930\u094d\u0921 \u092b\u094b\u0928\u0947\u091f\u093f\u0915" },
            { "fr_CH", "\u0938\u094d\u0935\u093f\u0938 \u092b\u093c\u094d\u0930\u0947\u0902\u091a" },
            { "KW", "\u0915\u0941\u0935\u0948\u0924" },
            { "tpi", "\u091f\u094b\u0915 \u092a\u093f\u0938\u093f\u0928" },
            { "KY", "\u0915\u0948\u092e\u0947\u0928 \u0926\u094d\u0935\u0940\u092a\u0938\u092e\u0942\u0939" },
            { "KZ", "\u0915\u091c\u093c\u093e\u0916\u0938\u094d\u0924\u093e\u0928" },
            { "Cyrl", "\u0938\u093f\u0930\u093f\u0932\u093f\u0915" },
            { "LA", "\u0932\u093e\u0913\u0938" },
            { "LB", "\u0932\u0947\u092c\u0928\u093e\u0928" },
            { "LC", "\u0938\u0947\u0902\u091f \u0932\u0942\u0938\u093f\u092f\u093e" },
            { "phn", "\u092b\u094b\u090f\u0928\u093f\u0936\u093f\u092f\u0928" },
            { "Cyrs", "\u0913\u0932\u094d\u0921 \u091a\u0930\u094d\u091a \u0938\u094d\u0932\u093e\u0935\u094b\u0928\u093f\u0915 \u0938\u093f\u0930\u093f\u0932\u093f\u0915" },
            { "gwi", "\u0917\u094d\u0935\u093f\u091a\u0907\u0928" },
            { "nds", "\u0928\u093f\u091a\u0932\u093e \u091c\u0930\u094d\u092e\u0928" },
            { "LI", "\u0932\u093f\u091a\u0947\u0902\u0938\u094d\u091f\u0940\u0928" },
            { "LK", "\u0936\u094d\u0930\u0940\u0932\u0902\u0915\u093e" },
            { "akk", "\u0905\u0915\u094d\u0915\u093e\u0926\u0940" },
            { "cop", metaValue_cop },
            { "LR", "\u0932\u093e\u0907\u092c\u0947\u0930\u093f\u092f\u093e" },
            { "LS", "\u0932\u0947\u0938\u094b\u0925\u094b" },
            { "Phlv", "\u092c\u0941\u0915 \u092a\u093e\u0939\u0932\u0935\u0940" },
            { "LT", "\u0932\u093f\u0925\u0941\u0906\u0928\u093f\u092f\u093e" },
            { "LU", "\u0932\u0917\u094d\u091c\u093c\u092e\u092c\u0930\u094d\u0917" },
            { "LV", "\u0932\u093e\u0924\u0935\u093f\u092f\u093e" },
            { "Kana", "\u0915\u093e\u0924\u093e\u0915\u093e\u0928\u093e" },
            { "LY", "\u0932\u0940\u092c\u093f\u092f\u093e" },
            { "lad", "\u0932\u093e\u0926\u0940\u0928\u094b" },
            { "vun", "\u0935\u0941\u0902\u091c\u094b" },
            { "lah", "\u0932\u093e\u0939\u094d\u0928\u094d\u0921\u093e" },
            { "lag", "\u0932\u093e\u0902\u0917\u093f" },
            { "Thaa", "\u0925\u093e\u0928\u093e" },
            { "MA", "\u092e\u094b\u0930\u0915\u094d\u0915\u094b" },
            { "MC", "\u092e\u094b\u0928\u093e\u0915\u094b" },
            { "MD", "\u092e\u0949\u0932\u094d\u0921\u094b\u0935\u093e" },
            { "ME", "\u092e\u094b\u0902\u091f\u0947\u0928\u0947\u0917\u094d\u0930\u094b" },
            { "MF", "\u0938\u0947\u0902\u091f \u092e\u093e\u0930\u094d\u091f\u093f\u0928" },
            { "lam", "\u0932\u093e\u092e\u094d\u092c\u093e" },
            { "MG", "\u092e\u0947\u0921\u093e\u0917\u093e\u0938\u094d\u0915\u0930" },
            { "Thai", metaValue_th },
            { "MH", "\u092e\u093e\u0930\u094d\u0936\u0932 \u0926\u094d\u0935\u0940\u092a\u0938\u092e\u0942\u0939" },
            { "ale", "\u0905\u0932\u0947\u0909\u0924" },
            { "type.nu.vaii", "\u0935\u093e\u0908 \u0905\u0902\u0915" },
            { "MK", "\u092e\u0915\u0926\u0942\u0928\u093f\u092f\u093e" },
            { "ML", "\u092e\u093e\u0932\u0940" },
            { "MM", "\u092e\u094d\u092f\u093e\u0902\u092e\u093e\u0930 (\u092c\u0930\u094d\u092e\u093e)" },
            { "MN", "\u092e\u0902\u0917\u094b\u0932\u093f\u092f\u093e" },
            { "new", "\u0928\u0947\u0935\u093e\u0921\u093c\u0940" },
            { "MO", "\u092e\u0915\u093e\u090a (\u0935\u093f\u0936\u0947\u0937 \u092a\u094d\u0930\u0936\u093e\u0938\u0928\u093f\u0915 \u0915\u094d\u0937\u0947\u0924\u094d\u0930 \u091a\u0940\u0928)" },
            { "MP", "\u0909\u0924\u094d\u0924\u0930\u0940 \u092e\u093e\u0930\u093f\u092f\u093e\u0928\u093e \u0926\u094d\u0935\u0940\u092a\u0938\u092e\u0942\u0939" },
            { "MQ", "\u092e\u093e\u0930\u094d\u091f\u0940\u0928\u093f\u0915" },
            { "MR", "\u092e\u0949\u0930\u093f\u091f\u093e\u0928\u093f\u092f\u093e" },
            { "MS", "\u092e\u094b\u0902\u091f\u0938\u0947\u0930\u093e\u0924" },
            { "MT", "\u092e\u093e\u0932\u094d\u091f\u093e" },
            { "type.m0.ungegn", "UNGEGN \u0932\u093f\u092a\u094d\u092f\u0902\u0924\u0930\u0923" },
            { "MU", "\u092e\u0949\u0930\u0940\u0936\u0938" },
            { "alt", "\u0926\u0915\u094d\u0937\u093f\u0923\u0940 \u0905\u0932\u094d\u0924\u093e\u0908" },
            { "MV", "\u092e\u093e\u0932\u0926\u0940\u0935" },
            { "MW", "\u092e\u0932\u093e\u0935\u0940" },
            { "MX", "\u092e\u0948\u0915\u094d\u0938\u093f\u0915\u094b" },
            { "type.ca.japanese", "\u091c\u093e\u092a\u093e\u0928\u0940 \u092a\u0902\u091a\u093e\u0902\u0917" },
            { "MY", "\u092e\u0932\u0947\u0936\u093f\u092f\u093e" },
            { "MZ", "\u092e\u094b\u091c\u093c\u093e\u0902\u092c\u093f\u0915" },
            { "Phli", "\u0907\u0902\u0938\u094d\u0915\u094d\u0930\u093f\u092a\u0936\u094d\u0928\u0932 \u092a\u093e\u0939\u0932\u0935\u0940" },
            { "NA", "\u0928\u093e\u092e\u0940\u092c\u093f\u092f\u093e" },
            { "202", "\u0909\u092a-\u0938\u0939\u093e\u0930\u093e \u0905\u092b\u093c\u094d\u0930\u0940\u0915\u093e" },
            { "type.ca.hebrew", "\u0939\u093f\u092c\u094d\u0930\u0942 \u092a\u0902\u091a\u093e\u0902\u0917" },
            { "type.co.dictionary", "\u0936\u092c\u094d\u0926\u0915\u094b\u0936 \u0915\u094d\u0930\u092e \u0935\u093f\u0928\u094d\u092f\u093e\u0938" },
            { "NC", "\u0928\u094d\u092f\u0942 \u0915\u0948\u0932\u0947\u0921\u094b\u0928\u093f\u092f\u093e" },
            { "NE", "\u0928\u093e\u0907\u091c\u0930" },
            { "NF", "\u0928\u0949\u0930\u092b\u093c\u0949\u0915 \u0926\u094d\u0935\u0940\u092a" },
            { "NG", "\u0928\u093e\u0907\u091c\u0940\u0930\u093f\u092f\u093e" },
            { "trv", "\u0924\u093e\u0930\u094b\u0915\u094b" },
            { "Phlp", "\u0938\u0949\u0932\u094d\u091f\u0930 \u092a\u093e\u0939\u0932\u0935\u0940" },
            { "NI", "\u0928\u093f\u0915\u093e\u0930\u093e\u0917\u0941\u0906" },
            { "Hmng", "\u092a\u093e\u0939\u094b \u0939\u094d\u092e\u094b\u0928\u094d\u0917" },
            { "NL", "\u0928\u0940\u0926\u0930\u0932\u0948\u0902\u0921" },
            { "NO", "\u0928\u0949\u0930\u094d\u0935\u0947" },
            { "NP", "\u0928\u0947\u092a\u093e\u0932" },
            { "NR", "\u0928\u093e\u0909\u0930\u0941" },
            { "NU", "\u0928\u0940\u092f\u0942" },
            { "Phnx", "\u092b\u094b\u0928\u093f\u0936\u093f\u092f\u0928" },
            { "rof", "\u0930\u094b\u092e\u094d\u092c\u094b" },
            { "tsi", "\u0924\u094d\u0938\u093f\u092e\u0940\u0936\u093f\u092f\u0928" },
            { "NZ", "\u0928\u094d\u092f\u0942\u091c\u093c\u0940\u0932\u0948\u0902\u0921" },
            { "rom", "\u0930\u094b\u092e\u093e\u0928\u0940" },
            { "Mero", "\u092e\u0947\u0930\u094b\u0907\u091f\u093f\u0915" },
            { "crh", "\u0915\u094d\u0930\u0940\u092e\u0940\u0928 \u0924\u0941\u0930\u094d\u0915\u0940" },
            { "ang", "\u092a\u0941\u0930\u093e\u0928\u0940 \u0905\u0902\u0917\u094d\u0930\u0947\u091c\u093c\u0940" },
            { "OM", "\u0913\u092e\u093e\u0928" },
            { "anp", "\u0905\u0902\u0917\u093f\u0915\u093e" },
            { "crs", "\u0938\u0947\u0938\u0947\u0932\u094d\u0935\u093e \u0915\u094d\u0930\u093f\u0913\u0932 \u092b\u094d\u0930\u0947\u0902\u091a" },
            { "Xpeo", metaValue_peo },
            { "PA", "\u092a\u0928\u093e\u092e\u093e" },
            { "type.ca.islamic-civil", "\u0907\u0938\u094d\u0932\u093e\u092e\u0940 \u0928\u093e\u0917\u0930\u093f\u0915 \u092a\u0902\u091a\u093e\u0902\u0917" },
            { "csb", "\u0915\u093e\u0936\u0941\u092c\u093f\u092f\u0928" },
            { "en_GB", "\u092c\u094d\u0930\u093f\u091f\u093f\u0936 \u0905\u0902\u0917\u094d\u0930\u0947\u091c\u093c\u0940" },
            { "PE", "\u092a\u0947\u0930\u0942" },
            { "PF", "\u092b\u093c\u094d\u0930\u0947\u0902\u091a \u092a\u094b\u0932\u093f\u0928\u0947\u0936\u093f\u092f\u093e" },
            { "PG", "\u092a\u093e\u092a\u0941\u0906 \u0928\u094d\u092f\u0942 \u0917\u093f\u0928\u0940" },
            { "PH", "\u092b\u093c\u093f\u0932\u093f\u092a\u0940\u0902\u0938" },
            { "PK", "\u092a\u093e\u0915\u093f\u0938\u094d\u0924\u093e\u0928" },
            { "PL", "\u092a\u094b\u0932\u0948\u0902\u0921" },
            { "ewo", "\u0907\u0935\u094b\u0928\u094d\u0921\u094b" },
            { "PM", "\u0938\u0947\u0902\u091f \u092a\u093f\u090f\u0930\u0947 \u0914\u0930 \u092e\u093f\u0915\u094d\u0935\u0947\u0932\u093e\u0928" },
            { "PN", "\u092a\u093f\u091f\u0915\u0948\u0930\u094d\u0928 \u0926\u094d\u0935\u0940\u092a\u0938\u092e\u0942\u0939" },
            { "PR", "\u092a\u094b\u0930\u094d\u091f\u094b \u0930\u093f\u0915\u094b" },
            { "PS", "\u092b\u093c\u093f\u0932\u093f\u0938\u094d\u0924\u0940\u0928\u0940 \u0915\u094d\u0937\u0947\u0924\u094d\u0930" },
            { "Bali", "\u092c\u093e\u0932\u0940" },
            { "PT", "\u092a\u0941\u0930\u094d\u0924\u0917\u093e\u0932" },
            { "PW", "\u092a\u0932\u093e\u090a" },
            { "nia", "\u0928\u093f\u092f\u093e\u0938" },
            { "type.nu.greklow", "\u092f\u0942\u0928\u093e\u0928\u0940 \u0932\u094b\u0905\u0930\u0915\u0947\u0938 \u0938\u0902\u0916\u094d\u092f\u093e\u090f\u0901" },
            { "PY", "\u092a\u0930\u093e\u0917\u094d\u0935\u0947" },
            { "tum", "\u0924\u092e\u094d\u092c\u0942\u0915\u093e" },
            { "Hebr", metaValue_he },
            { "QA", "\u0915\u093c\u0924\u0930" },
            { "niu", "\u0928\u093f\u092f\u0941\u0906\u0928" },
            { "QO", "\u0906\u0909\u091f\u0932\u093e\u0907\u0902\u0917 \u0913\u0936\u093f\u0928\u093f\u092f\u093e" },
            { "lez", "\u0932\u0947\u091c\u093c\u094d\u0918\u0940\u092f\u0928" },
            { "tvl", "\u0924\u0941\u0935\u093e\u0932\u0941" },
            { "Tavt", "\u0924\u093e\u0908 \u0935\u093f\u090f\u0924" },
            { "001", "\u0935\u093f\u0936\u094d\u0935" },
            { "002", "\u0905\u092b\u093c\u094d\u0930\u0940\u0915\u093e" },
            { "003", "\u0909\u0924\u094d\u0924\u0930 \u0905\u092e\u0947\u0930\u093f\u0915\u093e" },
            { "RE", "\u0930\u093f\u092f\u0942\u0928\u093f\u092f\u0928" },
            { "005", "\u0926\u0915\u094d\u0937\u093f\u0923 \u0905\u092e\u0947\u0930\u093f\u0915\u093e" },
            { "jbo", "\u0932\u094b\u091c\u094d\u092c\u093e\u0928" },
            { "Rjng", "\u0930\u0940\u091c\u093e\u0902\u0917" },
            { "009", "\u0913\u0936\u093f\u0906\u0928\u093f\u092f\u093e" },
            { "RO", "\u0930\u094b\u092e\u093e\u0928\u093f\u092f\u093e" },
            { "RS", "\u0938\u0930\u094d\u092c\u093f\u092f\u093e" },
            { "RU", "\u0930\u0942\u0938" },
            { "RW", "\u0930\u0935\u093e\u0902\u0921\u093e" },
            { "Mani", "\u092e\u0928\u0940\u0936\u0940\u0928" },
            { "Ugar", "\u092f\u0941\u0917\u093e\u0930\u093f\u091f\u093f\u0915" },
            { "Khar", "\u0916\u093e\u0930\u094b\u0936\u0925\u0940" },
            { "SA", "\u0938\u090a\u0926\u0940 \u0905\u0930\u092c" },
            { "pon", "\u092a\u094b\u0939\u094d\u0928\u092a\u093f\u090f\u0928" },
            { "Mand", "\u092e\u0928\u0921\u0947\u0928" },
            { "SB", "\u0938\u094b\u0932\u094b\u092e\u0928 \u0926\u094d\u0935\u0940\u092a\u0938\u092e\u0942\u0939" },
            { "twq", "\u091f\u093e\u0938\u0935\u093e\u0915" },
            { "011", "\u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u0905\u092b\u093c\u094d\u0930\u0940\u0915\u093e" },
            { "SC", "\u0938\u0947\u0936\u0947\u0932\u094d\u0938" },
            { "SD", "\u0938\u0942\u0921\u093e\u0928" },
            { "013", "\u092e\u0927\u094d\u092f \u0905\u092e\u0947\u0930\u093f\u0915\u093e" },
            { "SE", "\u0938\u094d\u0935\u0940\u0921\u0928" },
            { "014", "\u092a\u0942\u0930\u094d\u0935\u0940 \u0905\u092b\u093c\u094d\u0930\u0940\u0915\u093e" },
            { "arc", "\u0910\u0930\u0947\u092e\u0947\u0915" },
            { "015", "\u0909\u0924\u094d\u0924\u0930\u0940 \u0905\u092b\u093c\u094d\u0930\u0940\u0915\u093e" },
            { "SG", "\u0938\u093f\u0902\u0917\u093e\u092a\u0941\u0930" },
            { "SH", "\u0938\u0947\u0902\u091f \u0939\u0947\u0932\u0947\u0928\u093e" },
            { "type.lb.strict", "\u0938\u0916\u094d\u0924 \u092a\u0902\u0915\u094d\u0924\u093f \u0935\u093f\u091a\u094d\u091b\u0947\u0926 \u0936\u0948\u0932\u0940" },
            { "017", "\u092e\u0927\u094d\u092f \u0905\u092b\u093c\u094d\u0930\u0940\u0915\u093e" },
            { "SI", "\u0938\u094d\u0932\u094b\u0935\u0947\u0928\u093f\u092f\u093e" },
            { "018", "\u0926\u0915\u094d\u0937\u093f\u0923\u0940 \u0905\u092b\u093c\u094d\u0930\u0940\u0915\u093e" },
            { "SJ", "\u0938\u094d\u0935\u093e\u0932\u092c\u093e\u0930\u094d\u0921 \u0914\u0930 \u091c\u093e\u0928 \u092e\u093e\u092f\u0947\u0928" },
            { "019", "\u0905\u092e\u0947\u0930\u093f\u0915\u093e\u091c\u093c" },
            { "SK", "\u0938\u094d\u0932\u094b\u0935\u093e\u0915\u093f\u092f\u093e" },
            { "SL", "\u0938\u093f\u090f\u0930\u093e \u0932\u093f\u092f\u094b\u0928" },
            { "SM", "\u0938\u0948\u0928 \u092e\u0947\u0930\u0940\u0928\u094b" },
            { "SN", "\u0938\u0947\u0928\u0947\u0917\u0932" },
            { "SO", "\u0938\u094b\u092e\u093e\u0932\u093f\u092f\u093e" },
            { "arn", "\u092e\u093e\u092a\u0942\u091a\u0947" },
            { "arp", "\u0905\u0930\u093e\u092a\u093e\u0939\u094b" },
            { "type.nu.taml", "\u092a\u093e\u0930\u0902\u092a\u0930\u093f\u0915 \u0924\u092e\u093f\u0932 \u0938\u0902\u0916\u094d\u092f\u093e\u090f\u0901" },
            { "SR", "\u0938\u0942\u0930\u0940\u0928\u093e\u092e" },
            { "SS", "\u0926\u0915\u094d\u0937\u093f\u0923 \u0938\u0942\u0921\u093e\u0928" },
            { "ST", "\u0938\u093e\u0913 \u091f\u094b\u092e \u0914\u0930 \u092a\u094d\u0930\u093f\u0902\u0938\u093f\u092a\u0947" },
            { "SV", "\u0905\u0932 \u0938\u0932\u094d\u0935\u093e\u0921\u094b\u0930" },
            { "ars", "\u0928\u091c\u094d\u0926\u0940 \u0905\u0930\u092c\u0940" },
            { "SX", "\u0938\u093f\u0902\u091f \u092e\u093e\u0930\u094d\u091f\u093f\u0928" },
            { "SY", "\u0938\u0940\u0930\u093f\u092f\u093e" },
            { "yao", "\u092f\u093e\u0913" },
            { "SZ", "\u0938\u094d\u0935\u093e\u091c\u093c\u0940\u0932\u0948\u0902\u0921" },
            { "arw", "\u0905\u0930\u093e\u0935\u0915" },
            { "yap", "\u092f\u093e\u092a\u0940\u0938" },
            { "TA", "\u091f\u094d\u0930\u093f\u0938\u094d\u091f\u0928 \u0926\u093e \u0915\u0941\u0928\u093e" },
            { "asa", "\u0905\u0938\u0941" },
            { "type.ms.ussystem", "\u0905\u092e\u0947\u0930\u093f\u0915\u0940 \u092e\u093e\u092a\u0928 \u092a\u094d\u0930\u0923\u093e\u0932\u0940" },
            { "021", "\u0909\u0924\u094d\u0924\u0930\u0940 \u0905\u092e\u0947\u0930\u093f\u0915\u093e" },
            { "TC", "\u0924\u0941\u0930\u094d\u0915 \u0914\u0930 \u0915\u0948\u0915\u094b\u091c\u093c \u0926\u094d\u0935\u0940\u092a\u0938\u092e\u0942\u0939" },
            { "yav", "\u092f\u093e\u0902\u0917\u092c\u0947\u0928" },
            { "TD", "\u091a\u093e\u0921" },
            { "TF", "\u092b\u093c\u094d\u0930\u093e\u0902\u0938\u0940\u0938\u0940 \u0926\u0915\u094d\u0937\u093f\u0923\u0940 \u0915\u094d\u0937\u0947\u0924\u094d\u0930" },
            { "TG", "\u091f\u094b\u0917\u094b" },
            { "TH", "\u0925\u093e\u0908\u0932\u0948\u0902\u0921" },
            { "TJ", "\u0924\u093e\u091c\u093c\u093f\u0915\u093f\u0938\u094d\u0924\u093e\u0928" },
            { "029", "\u0915\u0948\u0930\u093f\u092c\u093f\u092f\u0928" },
            { "TK", "\u0924\u094b\u0915\u0947\u0932\u093e\u0909" },
            { "TL", "\u0924\u093f\u092e\u094b\u0930-\u0932\u0947\u0938\u094d\u0924" },
            { "ybb", "\u092f\u0947\u0902\u092c\u093e" },
            { "type.co.searchjl", "\u0939\u093e\u0902\u0917\u0941\u0932 \u0906\u0930\u0902\u092d\u093f\u0915 \u0935\u094d\u200d\u092f\u0902\u091c\u0928 \u0926\u094d\u0935\u093e\u0930\u093e \u0916\u094b\u091c\u0947\u0902" },
            { "TM", "\u0924\u0941\u0930\u094d\u0915\u092e\u0947\u0928\u093f\u0938\u094d\u0924\u093e\u0928" },
            { "TN", "\u091f\u094d\u092f\u0942\u0928\u0940\u0936\u093f\u092f\u093e" },
            { "TO", "\u091f\u094b\u0902\u0917\u093e" },
            { "TR", metaValue_TR },
            { "TT", "\u0924\u094d\u0930\u093f\u0928\u093f\u0926\u093e\u0926 \u0914\u0930 \u091f\u094b\u092c\u0948\u0917\u094b" },
            { "TV", "\u0924\u0941\u0935\u093e\u0932\u0942" },
            { "TW", "\u0924\u093e\u0907\u0935\u093e\u0928" },
            { "ast", "\u0905\u0938\u094d\u0924\u0941\u0930\u093f\u092f\u0928" },
            { "Orkh", "\u0913\u0930\u0916\u094b\u0928" },
            { "TZ", "\u0924\u0902\u091c\u093c\u093e\u0928\u093f\u092f\u093e" },
            { "nmg", "\u0915\u094d\u0935\u093e\u0938\u093f\u0913" },
            { "Zzzz", "\u0905\u091c\u094d\u091e\u093e\u0924 \u0932\u093f\u092a\u093f" },
            { "UA", "\u092f\u0942\u0915\u094d\u0930\u0947\u0928" },
            { "rup", "\u0905\u0930\u094b\u092e\u093e\u0928\u093f\u092f\u0928" },
            { "030", "\u092a\u0942\u0930\u094d\u0935\u0940 \u090f\u0936\u093f\u092f\u093e" },
            { "tyv", "\u0924\u0941\u0935\u0940\u0928\u093f\u092f\u0928" },
            { "sw_CD", "\u0915\u093e\u0902\u0917\u094b \u0938\u094d\u0935\u093e\u0939\u093f\u0932\u0940" },
            { "034", "\u0926\u0915\u094d\u0937\u093f\u0923\u0940 \u090f\u0936\u093f\u092f\u093e" },
            { "hai", "\u0939\u0948\u0921\u093e" },
            { "035", "\u0926\u0915\u094d\u0937\u093f\u0923-\u092a\u0942\u0930\u094d\u0935 \u090f\u0936\u093f\u092f\u093e" },
            { "UG", "\u092f\u0941\u0917\u093e\u0902\u0921\u093e" },
            { "type.co.pinyin", "\u092a\u093f\u0928\u092f\u0940\u0928 \u0935\u0930\u094d\u0917\u0940\u0915\u0930\u0923" },
            { "039", "\u0926\u0915\u094d\u0937\u093f\u0923\u0940 \u092f\u0942\u0930\u094b\u092a" },
            { "Sinh", metaValue_si },
            { "UM", "\u092f\u0942\u0970\u090f\u0938\u0970 \u0906\u0909\u091f\u0932\u093e\u0907\u0902\u0917 \u0926\u094d\u0935\u0940\u092a\u0938\u092e\u0942\u0939" },
            { "UN", "\u0938\u0902\u092f\u0941\u0915\u094d\u0924 \u0930\u093e\u0937\u094d\u091f\u094d\u0930" },
            { "US", "\u0938\u0902\u092f\u0941\u0915\u094d\u0924 \u0930\u093e\u091c\u094d\u092f" },
            { "haw", "\u0939\u0935\u093e\u0908" },
            { "type.co.gb2312han", "\u0938\u0930\u0932\u0940\u0915\u0943\u0924 \u091a\u0940\u0928\u0940 \u0935\u0930\u094d\u0917\u0940\u0915\u0930\u0923" },
            { "UY", "\u0909\u0930\u0942\u0917\u094d\u0935\u0947" },
            { "prg", "\u092a\u094d\u0930\u0941\u0936\u093f\u092f\u093e\u0908" },
            { "UZ", "\u0909\u091c\u093c\u094d\u092c\u0947\u0915\u093f\u0938\u094d\u0924\u093e\u0928" },
            { "tzm", "\u092e\u0927\u094d\u092f \u090f\u091f\u0932\u0938 \u0924\u092e\u093e\u091c\u093c\u093f\u0924" },
            { "type.co.stroke", "\u0938\u094d\u091f\u094d\u0930\u094b\u0915 \u0935\u0930\u094d\u0917\u0940\u0915\u0930\u0923" },
            { "nnh", "\u0917\u0948\u092e\u094d\u092c\u0942" },
            { "VA", "\u0935\u0947\u091f\u093f\u0915\u0928 \u0938\u093f\u091f\u0940" },
            { "pro", "\u092a\u0941\u0930\u093e\u0928\u0940 \u092a\u094d\u0930\u094b\u0935\u0947\u0928\u094d\u0938\u0932" },
            { "VC", "\u0938\u0947\u0902\u091f \u0935\u093f\u0902\u0938\u0947\u0902\u091f \u0914\u0930 \u0917\u094d\u0930\u0947\u0928\u093e\u0921\u093e\u0907\u0902\u0938" },
            { "VE", "\u0935\u0947\u0928\u0947\u091c\u093c\u0941\u090f\u0932\u093e" },
            { "VG", "\u092c\u094d\u0930\u093f\u091f\u093f\u0936 \u0935\u0930\u094d\u091c\u093f\u0928 \u0926\u094d\u0935\u0940\u092a\u0938\u092e\u0942\u0939" },
            { "VI", "\u092f\u0942\u0970\u090f\u0938\u0970 \u0935\u0930\u094d\u091c\u093f\u0928 \u0926\u094d\u0935\u0940\u092a\u0938\u092e\u0942\u0939" },
            { "VN", "\u0935\u093f\u092f\u0924\u0928\u093e\u092e" },
            { "VU", "\u0935\u0928\u0941\u0906\u0924\u0942" },
            { "nog", "\u0928\u094b\u0917\u093e\u0908" },
            { "rwk", "\u0930\u0935\u093e" },
            { "non", "\u092a\u0941\u0930\u093e\u0928\u093e \u0928\u0949\u0930\u094d\u0938" },
            { "053", "\u0911\u0938\u094d\u091f\u094d\u0930\u0947\u0932\u0947\u0936\u093f\u092f\u093e" },
            { "054", "\u092e\u0947\u0932\u093e\u0928\u0947\u0936\u093f\u092f\u093e" },
            { "WF", "\u0935\u093e\u0932\u093f\u0938 \u0914\u0930 \u092b\u093c\u094d\u092f\u0942\u091a\u0942\u0928\u093e" },
            { "type.co.traditional", "\u092a\u093e\u0930\u092e\u094d\u092a\u093e\u0930\u093f\u0915 \u0935\u0930\u094d\u0917\u0940\u0915\u0930\u0923" },
            { "057", "\u092e\u093e\u0907\u0915\u094d\u0930\u094b\u0928\u0947\u0936\u093f\u092f\u093e\u0908 \u0915\u094d\u0937\u0947\u0924\u094d\u0930" },
            { "jgo", "\u0928\u0917\u094b\u0902\u092c\u093e" },
            { "lkt", "\u0932\u0948\u0915\u094b\u091f\u093e" },
            { "type.nu.finance", "\u0935\u093f\u0924\u094d\u0924\u0940\u092f \u0905\u0902\u0915" },
            { "type.co.compat", "\u0938\u0902\u0917\u0924\u0924\u093e \u0915\u0947 \u0932\u093f\u090f \u092a\u093f\u091b\u0932\u093e \u0915\u094d\u0930\u092e\u0923" },
            { "wae", "\u0935\u093e\u0932\u094d\u0938\u0930" },
            { "WS", "\u0938\u092e\u094b\u0906" },
            { "wal", "\u0935\u0932\u093e\u092e\u094b" },
            { "was", "\u0935\u093e\u0936\u094b" },
            { "war", "\u0935\u093e\u0930\u0948" },
            { "awa", "\u0905\u0935\u0927\u0940" },
            { "061", "\u092a\u094b\u0932\u093f\u0928\u0947\u0936\u093f\u092f\u093e" },
            { "XK", "\u0915\u094b\u0938\u094b\u0935\u094b" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "\u0905\u0932\u093f\u0916\u093f\u0924" },
            { "Olck", "\u0911\u0932 \u091a\u093f\u0915\u0940" },
            { "wbp", "\u0935\u0949\u0932\u094d\u092a\u0947\u0930\u0940" },
            { "Batk", "\u092c\u091f\u0915\u0940" },
            { "Blis", metaValue_zbl },
            { "YE", "\u092f\u092e\u0928" },
            { "nqo", "\u090f\u0928\u094d\u0915\u094b" },
            { "type.co.standard", "\u092e\u093e\u0928\u0915 \u0938\u0949\u0930\u094d\u091f \u0915\u094d\u0930\u092e" },
            { "fan", "\u092b\u0948\u0928\u094d\u0917" },
            { "fat", "\u092b\u0928\u094d\u091f\u0940" },
            { "Sgnw", "\u0938\u093e\u0902\u0915\u0947\u0924\u093f\u0915 \u0932\u0947\u0916" },
            { "YT", "\u092e\u093e\u092f\u094b\u0924\u0947" },
            { "ZA", "\u0926\u0915\u094d\u0937\u093f\u0923 \u0905\u092b\u093c\u094d\u0930\u0940\u0915\u093e" },
            { "type.lb.loose", "\u0922\u0940\u0932\u0940 \u092a\u0902\u0915\u094d\u0924\u093f \u0935\u093f\u091a\u094d\u091b\u0947\u0926 \u0936\u0948\u0932\u0940" },
            { "Deva", "\u0926\u0947\u0935\u0928\u093e\u0917\u0930\u0940" },
            { "type.nu.geor", "\u091c\u0949\u0930\u094d\u091c\u093f\u092f\u0928 \u0938\u0902\u0916\u094d\u092f\u093e\u090f\u0901" },
            { "Hira", "\u0939\u093f\u0930\u093e\u0917\u093e\u0928\u093e" },
            { "ZM", "\u091c\u093c\u093e\u092e\u094d\u092c\u093f\u092f\u093e" },
            { "ZW", "\u091c\u093c\u093f\u092e\u094d\u092c\u093e\u092c\u094d\u0935\u0947" },
            { "ZZ", "\u0905\u091c\u094d\u091e\u093e\u0924 \u0915\u094d\u0937\u0947\u0924\u094d\u0930" },
            { "Runr", "\u0930\u0942\u0928\u093f\u0915" },
            { "type.ms.metric", "\u092e\u0947\u091f\u094d\u0930\u093f\u0915 \u092a\u094d\u0930\u0923\u093e\u0932\u0940" },
            { "type.ca.iso8601", "\u0906\u0908\u090f\u0938\u0913-8601 \u0915\u0948\u0932\u0947\u0902\u0921\u0930" },
            { "lol", "\u092e\u094b\u0902\u0917\u094b" },
            { "nso", "\u0909\u0924\u094d\u0924\u0930\u0940 \u0938\u094b\u0925\u094b" },
            { "type.nu.telu", "\u0924\u0947\u0932\u0941\u0917\u0942 \u0905\u0902\u0915" },
            { "lou", "\u0932\u0941\u0908\u091c\u093c\u093f\u092f\u093e\u0928\u093e \u0915\u094d\u0930\u093f\u092f\u094b\u0932" },
            { "loz", "\u0932\u094b\u091c\u093c\u0940" },
            { "jmc", "\u092e\u0948\u0915\u0939\u0948\u092e\u0947" },
            { "type.nu.hansfin", "\u0938\u0930\u0932\u0940\u0915\u0943\u0924 \u091a\u0940\u0928\u0940 \u0935\u093f\u0924\u094d\u0924\u0940\u092f \u0938\u0902\u0916\u094d\u092f\u093e\u090f\u0901" },
            { "hil", "\u0939\u093f\u0932\u093f\u0917\u0947\u0928\u0928" },
            { "type.nu.arabext", "\u0935\u093f\u0938\u094d\u0924\u0943\u0924 \u0905\u0930\u092c\u0940-\u092d\u093e\u0930\u0924\u0940\u092f \u0905\u0902\u0915" },
            { "nus", "\u0928\u0941\u090f\u0930" },
            { "dak", "\u0926\u093e\u0915\u094b\u0924\u093e" },
            { "type.nu.fullwide", "\u092a\u0942\u0930\u094d\u0923 \u091a\u094c\u0921\u093c\u093e\u0908 \u0905\u0902\u0915" },
            { "hit", "\u0939\u093f\u0924\u093e\u0907\u0924" },
            { "dar", "\u0926\u093e\u0930\u094d\u0917\u0935\u093e" },
            { "dav", "\u0924\u0948\u0924\u093e" },
            { "Maya", "\u092e\u092f\u093e\u0928 \u0939\u093e\u0907\u0930\u094b\u0917\u094d\u0932\u093f\u092b\u094d\u0938" },
            { "lrc", "\u0909\u0924\u094d\u0924\u0930\u0940 \u0932\u0942\u0930\u0940" },
            { "Copt", metaValue_cop },
            { "nwc", "\u092a\u093e\u0930\u092e\u094d\u092a\u0930\u093f\u0915 \u0928\u0947\u0935\u093e\u0930\u0940" },
            { "udm", "\u0909\u0926\u092e\u0941\u0930\u094d\u0924" },
            { "Khmr", metaValue_km },
            { "Limb", "\u0932\u093f\u092e\u094d\u092c\u0942" },
            { "sad", "\u0938\u0928\u094d\u0921\u093e\u0935\u0947" },
            { "type.nu.roman", "\u0930\u094b\u092e\u0928 \u0938\u0902\u0916\u094d\u092f\u093e\u090f\u0901" },
            { "sah", "\u092f\u093e\u0915\u0942\u0924" },
            { "sam", "\u0938\u093e\u092e\u0948\u0930\u093f\u091f\u0928 \u0905\u0930\u0948\u092e\u093f\u0915" },
            { "saq", "\u0938\u0948\u092e\u094d\u092c\u0941\u0930\u0941" },
            { "sas", "\u0938\u093e\u0938\u093e\u0915" },
            { "sat", "\u0938\u0902\u0925\u093e\u0932\u0940" },
            { "Tfng", "\u0924\u093f\u092b\u093f\u0928\u093e\u0918" },
            { "jpr", "\u091c\u0941\u0926\u0947\u0913-\u092a\u0930\u094d\u0936\u093f\u092f\u0928" },
            { "type.d0.npinyin", "\u0938\u093e\u0902\u0916\u094d\u092f\u093f\u0915" },
            { "type.nu.native", "\u0938\u094d\u0925\u093e\u0928\u0940\u092f \u0905\u0902\u0915" },
            { "sba", "\u0928\u094d\u0917\u093e\u092e\u094d\u092c\u0947" },
            { "Guru", "\u0917\u0941\u0930\u092e\u0941\u0916\u0940" },
            { "lua", "\u0932\u094d\u092f\u0942\u092c\u093e-\u0932\u0941\u0932\u0941\u0906" },
            { "type.d0.fwidth", "\u092a\u0942\u0930\u094d\u0923-\u091a\u094c\u0921\u093c\u093e\u0908" },
            { "sbp", "\u0938\u0948\u0902\u0917\u0941" },
            { "lui", "\u0932\u0941\u0907\u0938\u0947\u0928\u094b" },
            { "nyn", "\u0928\u094d\u092f\u093e\u0928\u0915\u094b\u0932" },
            { "nym", "\u0928\u094d\u092f\u093e\u092e\u0935\u0947\u091c\u093c\u0940" },
            { "lun", "\u0932\u0941\u0928\u094d\u0921\u093e" },
            { "nyo", "\u0928\u094d\u092f\u094b\u0930\u094b" },
            { "luo", "\u0932\u094d\u092f\u0941\u0913" },
            { "fil", "\u092b\u093c\u093f\u0932\u093f\u092a\u0940\u0928\u094b" },
            { "hmn", "\u0939\u094d\u092e\u0949\u0902\u0917" },
            { "del", "\u0921\u093f\u0932\u0948\u0935\u0947\u092f\u0930" },
            { "lus", "\u092e\u093f\u091c\u093c\u094b" },
            { "bal", "\u092c\u0932\u0942\u091a\u0940" },
            { "den", "\u0938\u094d\u0932\u0947\u0935" },
            { "ban", "\u092c\u093e\u0932\u093f\u0928\u0940\u0938" },
            { "uga", "\u092f\u0941\u0917\u0948\u0930\u093f\u091f\u093f\u0915" },
            { "luy", "\u0932\u094d\u092f\u0941\u0908\u0906" },
            { "bas", "\u092c\u0938\u093e" },
            { "jrb", "\u091c\u0941\u0926\u0947\u0913-\u0905\u0930\u0947\u092c\u093f\u0915" },
            { "es_ES", "\u092f\u0942\u0930\u094b\u092a\u0940\u092f \u0938\u094d\u092a\u0947\u0928\u093f\u0936" },
            { "nzi", "\u0928\u094d\u091c\u093c\u0940\u092e\u093e" },
            { "sco", "\u0938\u094d\u0915\u0949\u091f\u094d\u0938" },
            { "scn", "\u0938\u093f\u0938\u093f\u0932\u093f\u092f\u0928" },
            { "aa", "\u0905\u092b\u093c\u093e\u0930" },
            { "ab", "\u0905\u092c\u094d\u0916\u093c\u093e\u091c\u093c\u093f\u092f\u0928" },
            { "ae", "\u0905\u0935\u0938\u094d\u0924\u093e\u0908" },
            { "af", "\u0905\u092b\u093c\u094d\u0930\u0940\u0915\u0940" },
            { "ak", "\u0905\u0915\u0928" },
            { "am", "\u0905\u092e\u094d\u0939\u0947\u0930\u0940" },
            { "Arab", metaValue_ar },
            { "an", "\u0905\u0930\u094d\u0917\u094b\u0928\u0940" },
            { "Jpan", metaValue_ja },
            { "ar", metaValue_ar },
            { "Hrkt", "\u091c\u093e\u092a\u093e\u0928\u0940 \u0938\u093f\u0932\u0947\u092c\u0930\u0940\u091c\u093c" },
            { "as", "\u0905\u0938\u092e\u093f\u092f\u093e" },
            { "Lina", "\u0932\u0940\u0928\u093f\u092f\u0930 A" },
            { "av", "\u0905\u0935\u0947\u0930\u093f\u0915" },
            { "Linb", "\u0932\u0940\u0928\u093f\u092f\u0930 \u092c\u0940" },
            { "sdh", "\u0926\u0915\u094d\u0937\u093f\u0923\u0940 \u0915\u093e\u0930\u094d\u0921\u093f\u0936" },
            { "ay", "\u0906\u092f\u092e\u093e\u0930\u093e" },
            { "az", "\u0905\u091c\u093c\u0930\u092c\u0948\u091c\u093e\u0928\u0940" },
            { "ba", "\u092c\u0936\u0916\u093c\u093f\u0930" },
            { "type.co.unihan", "\u0930\u0947\u0921\u093f\u0915\u0932-\u0938\u094d\u091f\u094d\u0930\u094b\u0915 \u0915\u094d\u0930\u092e \u0935\u093f\u0928\u094d\u092f\u093e\u0938" },
            { "be", "\u092c\u0947\u0932\u093e\u0930\u0942\u0938\u0940" },
            { "bg", "\u092c\u0941\u0932\u094d\u0917\u093e\u0930\u093f\u092f\u093e\u0908" },
            { "bi", "\u092c\u093f\u0938\u094d\u0932\u093e\u092e\u093e" },
            { "bm", "\u092c\u093e\u092e\u094d\u092c\u093e\u0930\u093e" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "dgr", "\u0921\u094b\u0917\u094d\u0930\u093f\u092c" },
            { "br", "\u092c\u094d\u0930\u0947\u091f\u0928" },
            { "bs", "\u092c\u094b\u0938\u094d\u0928\u093f\u092f\u093e\u0908" },
            { "Mymr", "\u092e\u094d\u092f\u093e\u0902\u092e\u093e\u0930" },
            { "type.nu.laoo", "\u0932\u093e\u0913 \u0905\u0902\u0915" },
            { "seh", "\u0938\u0947\u0928\u093e" },
            { "Nkoo", "\u090f\u0928\u094d\u2018\u0915\u094b" },
            { "sel", "\u0938\u0947\u0932\u094d\u0915\u092a" },
            { "ca", "\u0915\u093e\u0924\u093e\u0932\u093e\u0928" },
            { "ses", "\u0915\u094b\u092f\u0930\u093e\u092c\u094b\u0930\u094b \u0938\u0947\u0928\u094d\u0928\u0940" },
            { "ce", "\u091a\u0947\u091a\u0928" },
            { "ch", "\u0915\u092e\u094b\u0930\u094b" },
            { "%%REVISED", "\u0938\u0902\u0936\u094b\u0927\u093f\u0924 \u0935\u0930\u094d\u0924\u0928\u0940" },
            { "co", "\u0915\u094b\u0930\u094d\u0938\u0940\u0915\u0928" },
            { "Orya", metaValue_or },
            { "cr", "\u0915\u094d\u0930\u0940" },
            { "cs", "\u091a\u0947\u0915" },
            { "cu", "\u091a\u0930\u094d\u091a \u0938\u093e\u0932\u094d\u0935\u093f\u0915" },
            { "cv", "\u091a\u0942\u0935\u093e\u0936" },
            { "cy", "\u0935\u0947\u0932\u094d\u0936" },
            { "type.nu.ethi", "\u0907\u0925\u093f\u092f\u094b\u092a\u093f\u092f\u093e\u0908 \u0938\u0902\u0916\u094d\u092f\u093e\u090f\u0901" },
            { "Yiii", "\u092f\u0940" },
            { "da", "\u0921\u0947\u0928\u093f\u0936" },
            { "pt_PT", "\u092f\u0942\u0930\u094b\u092a\u0940\u092f \u092a\u0941\u0930\u094d\u0924\u0917\u093e\u0932\u0940" },
            { "de", "\u091c\u0930\u094d\u092e\u0928" },
            { "type.cf.standard", "\u092e\u093e\u0928\u0915 \u092e\u0941\u0926\u094d\u0930\u093e \u092a\u094d\u0930\u093e\u0930\u0942\u092a" },
            { "bej", "\u092c\u0947\u091c\u093e" },
            { "din", "\u0926\u093f\u0928\u094d\u0915\u093e" },
            { "Bugi", metaValue_bug },
            { "bem", "\u092c\u0947\u092e\u094d\u092c\u093e" },
            { "sga", "\u092a\u0941\u0930\u093e\u0928\u0940 \u0906\u0907\u0930\u093f\u0936" },
            { "type.nu.mong", "\u092e\u0902\u0917\u094b\u0932\u093f\u092f\u093e\u0908 \u0905\u0902\u0915" },
            { "dv", "\u0926\u093f\u0935\u0947\u0939\u0940" },
            { "es_419", "\u0932\u0948\u091f\u093f\u0928 \u0905\u092e\u0947\u0930\u093f\u0915\u0940 \u0938\u094d\u092a\u0947\u0928\u093f\u0936" },
            { "dz", "\u091c\u093c\u094b\u0928\u094d\u0917\u0916\u093e" },
            { "bez", "\u092c\u0947\u0928\u093e" },
            { "type.ca.chinese", "\u091a\u0940\u0928\u0940 \u092a\u0902\u091a\u093e\u0902\u0917" },
            { "dje", "\u091d\u093e\u0930\u094d\u092e\u093e" },
            { "type.nu.grek", "\u092f\u0942\u0928\u093e\u0928\u0940 \u0938\u0902\u0916\u094d\u092f\u093e\u090f\u0901" },
            { "ee", "\u0908\u0935\u0947" },
            { "type.lb.normal", "\u0938\u093e\u092e\u093e\u0928\u094d\u092f \u092a\u0902\u0915\u094d\u0924\u093f \u0935\u093f\u091a\u094d\u091b\u0947\u0926 \u0936\u0948\u0932\u0940" },
            { "ro_MD", "\u092e\u094b\u0932\u0921\u093e\u0935\u093f\u092f\u0928" },
            { "el", metaValue_el },
            { "en", "\u0905\u0902\u0917\u094d\u0930\u0947\u091c\u093c\u0940" },
            { "eo", "\u090f\u0938\u094d\u092a\u0947\u0930\u0947\u0902\u0924\u094b" },
            { "type.co.big5han", "\u092a\u093e\u0930\u092e\u094d\u092a\u093e\u0930\u093f\u0915 \u091a\u0940\u0928\u0940 \u0935\u0930\u094d\u0917\u0940\u0915\u0930\u0923" },
            { "es", "\u0938\u094d\u092a\u0947\u0928\u0940" },
            { "et", "\u090f\u0938\u094d\u091f\u094b\u0928\u093f\u092f\u093e\u0908" },
            { "Hanb", "\u0939\u093e\u0902\u092c" },
            { "eu", "\u092c\u093e\u0938\u094d\u0915" },
            { "Buhd", "\u092c\u0941\u0939\u093f\u0926" },
            { "Hang", "\u0939\u0902\u0917\u0941\u0932" },
            { "Samr", "\u0938\u092e\u0930\u093f\u091f\u0928" },
            { "shi", "\u0924\u0948\u091a\u0947\u0932\u094d\u0939\u093f\u0924" },
            { "hsb", "\u090a\u092a\u0930\u0940 \u0938\u0949\u0930\u094d\u092c\u093f\u092f\u0928" },
            { "Hani", "\u0939\u093e\u0928" },
            { "shn", "\u0936\u0948\u0928" },
            { "Hano", "\u0939\u0928\u0941\u0928\u0942" },
            { "fa", "\u092b\u093c\u093e\u0930\u0938\u0940" },
            { "Hans", "\u0938\u0930\u0932\u0940\u0915\u0943\u0924" },
            { "type.nu.latn", "\u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u0905\u0902\u0915" },
            { "Hant", "\u092a\u093e\u0930\u0902\u092a\u0930\u093f\u0915" },
            { "ff", "\u092b\u0941\u0932\u093e\u0939" },
            { "fi", "\u092b\u093c\u093f\u0928\u093f\u0936" },
            { "fj", "\u092b\u093f\u091c\u093f\u092f\u0928" },
            { "fon", "\u092b\u0949\u0928" },
            { "bgn", "\u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u092c\u0932\u094b\u091a\u0940" },
            { "yue", "\u0915\u0948\u0902\u091f\u094b\u0928\u0940\u091c\u093c" },
            { "fo", "\u092b\u093c\u0948\u0930\u094b\u0907\u091c\u093c" },
            { "type.m0.bgn", "BGN \u0932\u093f\u092a\u094d\u092f\u0902\u0924\u0930\u0923" },
            { "umb", "\u0909\u092e\u094d\u092c\u0941\u0928\u094d\u0921\u0941" },
            { "fr", "\u092b\u093c\u094d\u0930\u0947\u0902\u091a" },
            { "sid", "\u0938\u093f\u0926\u093e\u092e\u094b" },
            { "fy", "\u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u092b\u093c\u094d\u0930\u093f\u0938\u093f\u092f\u093e\u0908" },
            { "ga", "\u0906\u092f\u0930\u093f\u0936" },
            { "gd", "\u0938\u094d\u0915\u0949\u091f\u093f\u0936 \u0917\u093e\u090f\u0932\u093f\u0915" },
            { "gl", "\u0917\u0948\u0932\u093f\u0936\u093f\u092f\u0928" },
            { "gn", "\u0917\u0941\u0906\u0930\u093e\u0928\u0940" },
            { "bho", "\u092d\u094b\u091c\u092a\u0941\u0930\u0940" },
            { "und", "\u0905\u091c\u094d\u091e\u093e\u0924 \u092d\u093e\u0937\u093e" },
            { "type.ca.ethiopic-amete-alem", "\u0907\u0925\u093f\u092f\u094b\u092a\u093f\u0915 \u0905\u092e\u0947\u0924\u0947 \u0905\u0932\u0947\u092e \u0915\u0948\u0932\u0947\u0902\u0921\u0930" },
            { "gu", metaValue_gu },
            { "gv", "\u092e\u0948\u0902\u0915\u094d\u0938" },
            { "ha", "\u0939\u094c\u0938\u093e" },
            { "he", metaValue_he },
            { "hi", "\u0939\u093f\u0928\u094d\u0926\u0940" },
            { "hup", "\u0939\u0942\u092a\u093e" },
            { "bik", "\u092c\u093f\u0915\u094b\u0932" },
            { "bin", "\u092c\u093f\u0928\u0940" },
            { "ho", "\u0939\u093f\u0930\u0940 \u092e\u094b\u091f\u0942" },
            { "hr", "\u0915\u094d\u0930\u094b\u090f\u0936\u093f\u092f\u093e\u0908" },
            { "ht", "\u0939\u0948\u0924\u093f\u092f\u093e\u0908" },
            { "hu", "\u0939\u0902\u0917\u0947\u0930\u093f\u092f\u093e\u0908" },
            { "hy", metaValue_hy },
            { "hz", "\u0939\u0930\u0948\u0930\u094b" },
            { "frc", "\u0915\u0947\u091c\u0928 \u092b\u093c\u094d\u0930\u0947\u0902\u091a" },
            { "ia", "\u0907\u0902\u091f\u0930\u0932\u093f\u0902\u0917\u0941\u0906" },
            { "Jamo", "\u091c\u093e\u092e\u094b" },
            { "id", "\u0907\u0902\u0921\u094b\u0928\u0947\u0936\u093f\u092f\u093e\u0908" },
            { "type.nu.tibt", "\u0924\u093f\u092c\u094d\u092c\u0924\u0940 \u0905\u0902\u0915" },
            { "ie", "\u0908\u0928\u094d\u091f\u0930\u0932\u093f\u0902\u0917\u0941\u0907" },
            { "ig", "\u0908\u0917\u094d\u092c\u094b" },
            { "ii", "\u0938\u093f\u091a\u0941\u0906\u0928 \u092f\u0940" },
            { "frm", "\u092e\u0927\u094d\u092f\u0915\u093e\u0932\u0940\u0928 \u092b\u093c\u094d\u0930\u093e\u0902\u0938\u0940\u0938\u0940" },
            { "ik", "\u0907\u0928\u0941\u092a\u093f\u092f\u093e\u0915\u094d" },
            { "fro", "\u092a\u0941\u0930\u093e\u0924\u0928 \u092b\u093c\u094d\u0930\u093e\u0902\u0938\u0940\u0938\u0940" },
            { "io", "\u0907\u0921\u094c" },
            { "frs", "\u092a\u0942\u0930\u094d\u0935\u0940 \u092b\u093c\u094d\u0930\u0940\u0938\u093f\u092f\u093e\u0908" },
            { "frr", "\u0909\u0924\u094d\u0924\u0930\u0940 \u092b\u093c\u094d\u0930\u0940\u0938\u093f\u092f\u093e\u0908" },
            { "is", "\u0906\u0907\u0938\u0932\u0948\u0902\u0921\u093f\u0915" },
            { "it", "\u0907\u0924\u093e\u0932\u0935\u0940" },
            { "iu", "\u0907\u0928\u0942\u0915\u0940\u091f\u0942\u0924\u094d" },
            { "ja", metaValue_ja },
            { "Mlym", metaValue_ml },
            { "Sara", "\u0938\u0930\u093e\u0924\u0940" },
            { "doi", "\u0921\u094b\u0917\u094d\u0930\u0940" },
            { "sma", "\u0926\u0915\u094d\u0937\u093f\u0923\u0940 \u0938\u093e\u092e\u0940" },
            { "jv", "\u091c\u093e\u0935\u093e\u0928\u0940\u091c\u093c" },
            { "Shaw", "\u0936\u093e\u0935\u093f\u092f\u093e\u0928" },
            { "mad", "\u092e\u093e\u0926\u0941\u0930\u0940\u0938" },
            { "smj", "\u0932\u094d\u092f\u0941\u0932 \u0938\u093e\u092e\u0940" },
            { "mag", "\u092e\u0917\u0939\u0940" },
            { "mai", "\u092e\u0948\u0925\u093f\u0932\u0940" },
            { "smn", "\u0907\u0928\u093e\u0930\u0940 \u0938\u093e\u092e\u0940" },
            { "ka", "\u091c\u0949\u0930\u094d\u091c\u093f\u092f\u093e\u0908" },
            { "bla", "\u0938\u093f\u0915\u094d\u0938\u093f\u0915\u093e" },
            { "mak", "\u092e\u0915\u093e\u0938\u0930" },
            { "wuu", "\u0935\u0942 \u091a\u0940\u0928\u0940" },
            { "sms", "\u0938\u094d\u0915\u094b\u0932\u094d\u091f \u0938\u093e\u092e\u0940" },
            { "man", "\u092e\u0928\u094d\u0921\u093f\u0928\u094d\u0917\u094b" },
            { "kg", "\u0915\u094b\u0902\u0917\u094b" },
            { "Goth", "\u0917\u094b\u0925\u093f\u0915" },
            { "ki", "\u0915\u093f\u0915\u0941\u092f\u0942" },
            { "mas", "\u092e\u0938\u093e\u0908" },
            { "kj", "\u0915\u094d\u0935\u093e\u0928\u094d\u092f\u093e\u092e\u093e" },
            { "kk", "\u0915\u091c\u093c\u093e\u0916\u093c" },
            { "kl", "\u0915\u0932\u093e\u0932\u0940\u0938\u0941\u0924" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "\u0915\u0928\u0941\u0930\u0940" },
            { "ks", "\u0915\u0936\u094d\u092e\u0940\u0930\u0940" },
            { "Cirt", "\u0915\u093f\u0930\u094d\u0925" },
            { "Lepc", "\u0932\u0947\u092a\u091a\u093e" },
            { "Avst", "\u0905\u0935\u0947\u0938\u094d\u0924\u0928" },
            { "ku", "\u0915\u0941\u0930\u094d\u0926\u093f\u0936" },
            { "kv", "\u0915\u094b\u092e\u0940" },
            { "kw", "\u0915\u094b\u0930\u094d\u0928\u093f\u0936" },
            { "ky", "\u0915\u093f\u0930\u094d\u0917\u0940\u091c\u093c" },
            { "snk", "\u0938\u094b\u0928\u093f\u0928\u094d\u0915\u0947" },
            { "la", metaValue_la },
            { "lb", "\u0932\u0917\u094d\u091c\u093c\u092e\u092c\u0930\u094d\u0917\u0940" },
            { "type.nu.mlym", "\u092e\u0932\u092f\u093e\u0932\u092e \u0905\u0902\u0915" },
            { "lg", "\u0917\u093e\u0902\u0921\u093e" },
            { "Roro", "\u0930\u094b\u0928\u094d\u0917\u094b\u0930\u094b\u0928\u094d\u0917\u094b" },
            { "li", "\u0932\u093f\u0902\u092c\u0930\u094d\u0917\u093f\u0936" },
            { "Tibt", metaValue_bo },
            { "ln", "\u0932\u093f\u0902\u0917\u093e\u0932\u093e" },
            { "fur", "\u092b\u094d\u0930\u0940\u092f\u0941\u0932\u0940\u092f\u093e\u0928" },
            { "lo", metaValue_lo },
            { "type.ms.uksystem", "\u0907\u092e\u094d\u092a\u0940\u0930\u093f\u092f\u0932 \u092e\u093e\u092a\u0928 \u092a\u094d\u0930\u0923\u093e\u0932\u0940" },
            { "lt", "\u0932\u093f\u0925\u0941\u0906\u0928\u093f\u092f\u093e\u0908" },
            { "lu", "\u0932\u094d\u092f\u0942\u092c\u093e-\u0915\u091f\u093e\u0902\u0917\u093e" },
            { "lv", "\u0932\u093e\u0924\u0935\u093f\u092f\u093e\u0908" },
            { "sog", "\u0938\u094b\u0917\u094d\u0921\u093f\u090f\u0928" },
            { "mg", "\u092e\u093e\u0932\u093e\u0917\u093e\u0938\u0940" },
            { "mh", "\u092e\u093e\u0930\u094d\u0936\u0932\u0940\u091c\u093c" },
            { "type.co.ducet", "\u0921\u093f\u092b\u093c\u0949\u0932\u094d\u091f \u092f\u0942\u0928\u093f\u0915\u094b\u0921 \u0938\u0949\u0930\u094d\u091f \u0915\u094d\u0930\u092e" },
            { "mi", "\u092e\u093e\u0913\u0930\u0940" },
            { "mk", "\u092e\u0915\u0926\u0942\u0928\u093f\u092f\u093e\u0908" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "\u092e\u0930\u093e\u0920\u0940" },
            { "ms", "\u092e\u0932\u092f" },
            { "mt", "\u092e\u093e\u0932\u094d\u091f\u0940\u091c\u093c" },
            { "my", "\u092c\u0930\u094d\u092e\u0940\u091c\u093c" },
            { "Saur", "\u0938\u094c\u0930\u093e\u0937\u094d\u091f\u094d\u0930" },
            { "Armn", metaValue_hy },
            { "mdf", "\u092e\u094b\u0915\u094d\u0937" },
            { "dsb", "\u0928\u093f\u091a\u0932\u093e \u0938\u0949\u0930\u094d\u092c\u093f\u092f\u0928" },
            { "Armi", "\u0907\u092e\u094d\u092a\u093f\u0930\u093f\u092f\u0932 \u0906\u0930\u094d\u092e\u0947\u0928\u093f\u0915" },
            { "na", "\u0928\u093e\u0909\u0930\u0942" },
            { "type.co.search", "\u0938\u093e\u092e\u093e\u0928\u094d\u092f-\u0909\u0926\u094d\u0926\u0947\u0936\u094d\u092f \u0916\u094b\u091c" },
            { "nb", "\u0928\u0949\u0930\u094d\u0935\u0947\u091c\u093f\u092f\u093e\u0908 \u092c\u094b\u0915\u092e\u093e\u0932" },
            { "nd", "\u0909\u0924\u094d\u0924\u0930\u0940 \u0926\u0947\u092c\u0947\u0932" },
            { "ne", "\u0928\u0947\u092a\u093e\u0932\u0940" },
            { "ng", "\u0921\u094b\u0928\u094d\u0917\u093e" },
            { "mdr", "\u092e\u0902\u0926\u093e\u0930" },
            { "nl", "\u0921\u091a" },
            { "nn", "\u0928\u0949\u0930\u094d\u0935\u0947\u091c\u093f\u092f\u093e\u0908 \u0928\u0949\u092f\u0928\u0949\u0930\u094d\u0938\u094d\u0915" },
            { "no", "\u0928\u0949\u0930\u094d\u0935\u0947\u091c\u093f\u092f\u093e\u0908" },
            { "nr", "\u0926\u0915\u094d\u0937\u093f\u0923 \u0926\u0947\u092c\u0947\u0932" },
            { "nv", "\u0928\u093e\u0935\u093e\u091c\u094b" },
            { "kaa", "\u0915\u093e\u0930\u093e-\u0915\u0932\u094d\u092a\u0915" },
            { "ny", "\u0928\u094d\u092f\u093e\u0928\u091c\u093e" },
            { "kac", "\u0915\u093e\u091a\u093f\u0928" },
            { "kab", "\u0915\u092c\u093e\u0907\u0932" },
            { "%%POLYTON", "\u092c\u0939\u0941\u0938\u094d\u0935\u0930\u0940\u092f" },
            { "oc", "\u0913\u0938\u0940\u091f\u093e\u0928" },
            { "kaj", "\u091c\u094d\u091c\u0941" },
            { "kam", "\u0915\u092e\u094d\u092c\u093e" },
            { "men", "\u092e\u0947\u0928\u094d\u0921\u0947" },
            { "oj", "\u0913\u091c\u093f\u092c\u094d\u0935\u093e" },
            { "mer", "\u092e\u0947\u0930\u0941" },
            { "type.nu.armn", "\u0906\u0930\u094d\u092e\u0947\u0928\u093f\u092f\u093e\u0908 \u0938\u0902\u0916\u094d\u092f\u093e\u090f\u0901" },
            { "om", "\u0913\u0930\u094b\u092e\u094b" },
            { "kaw", "\u0915\u093e\u0935\u0940" },
            { "or", metaValue_or },
            { "os", "\u0913\u0938\u094d\u0938\u0947\u091f\u093f\u0915" },
            { "kbd", "\u0915\u092c\u093e\u0930\u094d\u0921\u093f\u092f\u0928" },
            { "mfe", "\u092e\u094b\u0930\u0940\u0938\u094d\u092f\u0947\u0928" },
            { "srn", "\u0938\u094d\u0930\u093e\u0928\u093e\u0928 \u091f\u0949\u0928\u094d\u0917\u094b" },
            { "pa", "\u092a\u0902\u091c\u093e\u092c\u0940" },
            { "dua", "\u0926\u0941\u0906\u0932\u093e" },
            { "srr", "\u0938\u0947\u0930\u0947\u0930" },
            { "pi", "\u092a\u093e\u0932\u0940" },
            { "pl", "\u092a\u094b\u0932\u093f\u0936" },
            { "dum", "\u092e\u0927\u094d\u092f\u0915\u093e\u0932\u0940\u0928 \u092a\u0941\u0930\u094d\u0924\u0917\u093e\u0932\u0940" },
            { "type.ca.dangi", "\u0926\u093e\u0902\u0917\u0940 \u0915\u0948\u0932\u0947\u0902\u0921\u0930" },
            { "ps", "\u092a\u0936\u094d\u0924\u094b" },
            { "pt", "\u092a\u0941\u0930\u094d\u0924\u0917\u093e\u0932\u0940" },
            { "mga", "\u092e\u0927\u094d\u092f\u0915\u093e\u0932\u0940\u0928 \u0906\u0907\u0930\u093f\u0936" },
            { "key.co", "\u0938\u0949\u0930\u094d\u091f \u0915\u094d\u0930\u092e" },
            { "pt_BR", "\u092c\u094d\u0930\u093e\u091c\u093c\u0940\u0932\u0940 \u092a\u0941\u0930\u094d\u0924\u0917\u093e\u0932\u0940" },
            { "kcg", "\u0924\u094d\u092f\u093e\u092a" },
            { "mgh", "\u092e\u0948\u0916\u0941\u0935\u093e-\u092e\u0940\u091f\u094d\u091f\u094b" },
            { "key.cf", "\u092e\u0941\u0926\u094d\u0930\u093e \u092a\u094d\u0930\u093e\u0930\u0942\u092a" },
            { "bra", "\u092c\u094d\u0930\u091c" },
            { "key.ca", "\u0915\u0948\u0932\u0947\u0902\u0921\u0930" },
            { "Laoo", metaValue_lo },
            { "mgo", "\u092e\u0947\u091f\u093e" },
            { "type.hc.h23", "24 \u0918\u0902\u091f\u094b\u0902 \u0915\u0940 \u092a\u094d\u0930\u0923\u093e\u0932\u0940 (0\u201323)" },
            { "type.hc.h24", "24 \u0918\u0902\u091f\u094b\u0902 \u0915\u0940 \u092a\u094d\u0930\u0923\u093e\u0932\u0940 (1\u201324)" },
            { "ssy", "\u0938\u093e\u0939\u094b" },
            { "type.nu.mymr", "\u092e\u094d\u092f\u093e\u0902\u092e\u093e\u0930 \u0905\u0902\u0915" },
            { "qu", "\u0915\u094d\u0935\u0947\u091a\u0941\u0906" },
            { "zap", "\u091c\u093c\u0947\u092a\u094b\u091f\u0947\u0915" },
            { "brx", "\u092c\u094b\u0921\u094b" },
            { "Lana", "\u0932\u093e\u0928\u093e" },
            { "kde", "\u092e\u0948\u0915\u094b\u0902\u0921" },
            { "Ethi", "\u0907\u0925\u093f\u092f\u094b\u092a\u093f\u092f\u093e\u0908" },
            { "type.hc.h12", "12 \u0918\u0902\u091f\u094b\u0902 \u0915\u0940 \u092a\u094d\u0930\u0923\u093e\u0932\u0940 (1\u201312)" },
            { "type.hc.h11", "12 \u0918\u0902\u091f\u094b\u0902 \u0915\u0940 \u092a\u094d\u0930\u0923\u093e\u0932\u0940 (0\u201311)" },
            { "rm", "\u0930\u094b\u092e\u093e\u0928\u094d\u0936" },
            { "rn", "\u0930\u0941\u0928\u094d\u0926\u0940" },
            { "key.cu", "\u092e\u0941\u0926\u094d\u0930\u093e" },
            { "ro", "\u0930\u094b\u092e\u093e\u0928\u093f\u092f\u093e\u0908" },
            { "type.nu.orya", "\u0909\u0921\u093c\u093f\u092f\u093e \u0905\u0902\u0915" },
            { "type.nu.hanidec", "\u091a\u0940\u0928\u0940 \u0926\u0936\u092e\u0932\u0935 \u0938\u0902\u0916\u094d\u092f\u093e\u090f\u0901" },
            { "ru", "\u0930\u0942\u0938\u0940" },
            { "zbl", metaValue_zbl },
            { "rw", "\u0915\u093f\u0928\u094d\u092f\u093e\u0930\u0935\u093e\u0902\u0921\u093e" },
            { "kea", "\u0915\u093e\u092c\u0941\u0935\u0947\u0930\u094d\u0926\u093f\u092f\u093e\u0928\u0941" },
            { "mic", "\u092e\u093f\u0915\u092e\u0948\u0915" },
            { "suk", "\u0938\u0941\u0915\u0941\u092e\u093e" },
            { "en_AU", "\u0911\u0938\u094d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u093e\u0908 \u0905\u0902\u0917\u094d\u0930\u0947\u091c\u093c\u0940" },
            { "sa", "\u0938\u0902\u0938\u094d\u0915\u0943\u0924" },
            { "sc", "\u0938\u093e\u0930\u094d\u0926\u093f\u0928\u093f\u092f\u0928" },
            { "sus", "\u0938\u0941\u0938\u0941" },
            { "sd", "\u0938\u093f\u0902\u0927\u0940" },
            { "se", "\u0928\u0949\u0930\u094d\u0926\u0928 \u0938\u093e\u092e\u0940" },
            { "min", "\u092e\u093f\u0928\u093e\u0902\u0917\u094d\u0915\u093e\u092c\u093e\u0909" },
            { "sg", "\u0938\u093e\u0902\u0917\u094b" },
            { "sh", "\u0938\u0947\u0930\u094d\u092c\u094b-\u0915\u094d\u0930\u094b\u090f\u0936\u093f\u092f\u093e\u0908" },
            { "si", metaValue_si },
            { "sux", "\u0938\u0941\u092e\u0947\u0930\u093f\u092f\u0928" },
            { "sk", "\u0938\u094d\u0932\u094b\u0935\u093e\u0915" },
            { "sl", "\u0938\u094d\u0932\u094b\u0935\u0947\u0928\u093f\u092f\u093e\u0908" },
            { "Gran", "\u0917\u094d\u0930\u0928\u094d\u0925" },
            { "sm", "\u0938\u093e\u092e\u094b\u0928" },
            { "sn", "\u0936\u094b\u0923\u093e" },
            { "so", "\u0938\u094b\u092e\u093e\u0932\u0940" },
            { "type.nu.arab", "\u0905\u0930\u092c\u0940-\u092d\u093e\u0930\u0924\u0940\u092f \u0905\u0902\u0915" },
            { "sq", "\u0905\u0932\u094d\u092c\u093e\u0928\u093f\u092f\u093e\u0908" },
            { "sr", "\u0938\u0930\u094d\u092c\u093f\u092f\u093e\u0908" },
            { "ss", "\u0938\u094d\u0935\u093e\u0924\u0940" },
            { "type.cf.account", "\u0932\u0947\u0916\u093e\u0902\u0915\u0928 \u092e\u0941\u0926\u094d\u0930\u093e \u092a\u094d\u0930\u093e\u0930\u0942\u092a" },
            { "st", "\u0926\u0915\u094d\u0937\u093f\u0923\u0940 \u0938\u0947\u0938\u0947\u0925\u094b" },
            { "Java", "\u091c\u093e\u0935\u093e\u0928\u0940\u0938" },
            { "su", "\u0938\u0941\u0902\u0921\u093e\u0928\u0940" },
            { "sv", "\u0938\u094d\u0935\u0940\u0921\u093f\u0936" },
            { "sw", "\u0938\u094d\u0935\u093e\u0939\u093f\u0932\u0940" },
            { "type.nu.hantfin", "\u092a\u093e\u0930\u0902\u092a\u0930\u093f\u0915 \u091a\u0940\u0928\u0940 \u0935\u093f\u0924\u094d\u0924\u0940\u092f \u0938\u0902\u0916\u094d\u092f\u093e\u090f\u0901" },
            { "ibb", "\u0907\u092c\u093f\u092c\u093f\u092f\u094b" },
            { "iba", "\u0907\u092c\u093e\u0928" },
            { "ta", metaValue_ta },
            { "142", "\u090f\u0936\u093f\u092f\u093e" },
            { "bua", "\u092c\u0941\u0930\u093f\u092f\u093e\u0924" },
            { "143", "\u092e\u0927\u094d\u092f \u090f\u0936\u093f\u092f\u093e" },
            { "te", metaValue_te },
            { "145", "\u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u090f\u0936\u093f\u092f\u093e" },
            { "tg", "\u0924\u093e\u091c\u093f\u0915" },
            { "th", metaValue_th },
            { "bug", metaValue_bug },
            { "ti", "\u0924\u093f\u0917\u094d\u0930\u0940\u0928\u094d\u092f\u093e" },
            { "kfo", "\u0915\u094b\u0930\u094b" },
            { "en_CA", "\u0915\u0928\u093e\u0921\u093e\u0908 \u0905\u0902\u0917\u094d\u0930\u0947\u091c\u093c\u0940" },
            { "tk", "\u0924\u0941\u0930\u094d\u0915\u092e\u0947\u0928" },
            { "tl", "\u091f\u0948\u0917\u0932\u0949\u0917" },
            { "tn", "\u0938\u0947\u0924\u094d\u0938\u094d\u0935\u093e\u0928\u093e" },
            { "to", "\u091f\u094b\u0902\u0917\u0928" },
            { "dyo", "\u091c\u094b\u0932\u093e-\u092b\u094b\u0902\u0908" },
            { "type.nu.jpan", "\u091c\u093e\u092a\u093e\u0928\u0940 \u0938\u0902\u0916\u094d\u092f\u093e\u090f\u0901" },
            { "tr", metaValue_TR },
            { "ts", "\u0938\u094b\u0902\u0917\u093e" },
            { "swb", "\u0915\u094b\u092e\u094b\u0930\u093f\u092f\u0928" },
            { "Cakm", "\u091a\u0915\u092e\u093e" },
            { "tt", "\u0924\u093e\u0924\u093e\u0930" },
            { "dyu", "\u0921\u094d\u092f\u0941\u0932\u093e" },
            { "tw", "\u091f\u094d\u0935\u0940" },
            { "ty", "\u0924\u093e\u0939\u093f\u0924\u093f\u092f\u0928" },
            { "150", "\u092f\u0942\u0930\u094b\u092a" },
            { "151", "\u092a\u0942\u0930\u094d\u0935\u0940 \u092f\u0942\u0930\u094b\u092a" },
            { "154", "\u0909\u0924\u094d\u0924\u0930\u0940 \u092f\u0942\u0930\u094b\u092a" },
            { "dzg", "\u0926\u091c\u093c\u093e\u0917\u093e" },
            { "155", "\u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u092f\u0942\u0930\u094b\u092a" },
            { "ug", "\u0909\u0907\u0917\u0930" },
            { "Kore", metaValue_ko },
            { "Ital", "\u092a\u0941\u0930\u093e\u0928\u0940 \u0907\u091f\u0932\u0940" },
            { "Zyyy", "\u0938\u093e\u092e\u093e\u0928\u094d\u092f" },
            { "uk", "\u092f\u0942\u0915\u094d\u0930\u0947\u0928\u093f\u092f\u093e\u0908" },
            { "type.ca.coptic", "\u0915\u094b\u092a\u094d\u091f\u093f\u0915 \u0915\u0948\u0932\u0947\u0902\u0921\u0930" },
            { "ur", "\u0909\u0930\u094d\u0926\u0942" },
            { "xal", "\u0915\u093e\u0932\u094d\u092e\u093f\u0915" },
            { "zen", "\u091c\u093c\u0947\u0928\u093e\u0928\u094d\u0917\u093e" },
            { "uz", "\u0909\u091c\u093c\u094d\u092c\u0947\u0915" },
            { "kha", "\u0916\u093e\u0938\u0940" },
            { "%%1996", "\u091c\u0930\u094d\u092e\u0947\u0928\u0940 \u0915\u0940 1996 \u0935\u0930\u094d\u0924\u0928\u0940" },
            { "nds_NL", "\u0928\u093f\u091a\u0932\u0940 \u0938\u0948\u0915\u094d\u0938\u0928" },
            { "Sylo", "\u0938\u093f\u0932\u094b\u0924\u0940 \u0928\u093e\u0917\u0930\u0940" },
            { "ve", "\u0935\u0947\u0928\u094d\u0926\u093e" },
            { "type.ca.roc", "\u091a\u0940\u0928\u0940 \u0917\u0923\u0924\u0902\u0924\u094d\u0930 \u092a\u0902\u091a\u093e\u0902\u0917" },
            { "vi", "\u0935\u093f\u092f\u0924\u0928\u093e\u092e\u0940" },
            { "kho", "\u0916\u094b\u0924\u093e\u0928\u0940\u0938" },
            { "khq", "\u0915\u094b\u092f\u0930\u093e \u091a\u0940\u0928\u0940" },
            { "key.hc", "\u0918\u0902\u091f\u094b\u0902 \u0915\u093e \u091a\u0915\u094d\u0930 (12 \u092c\u0928\u093e\u092e 24)" },
            { "vo", "\u0935\u094b\u0932\u093e\u092a\u0941\u0915" },
            { "syc", "\u0915\u094d\u0932\u093e\u0938\u093f\u0915\u0932 \u0938\u093f\u0930\u093f\u090f\u0915" },
            { "Osma", "\u0913\u0938\u094d\u092e\u093e\u0928\u094d\u092f\u093e" },
            { "quc", "\u0915\u093f\u0936" },
            { "gaa", "\u0917\u093e" },
            { "wa", "\u0935\u093e\u0932\u094d\u0932\u0942\u0928" },
            { "gag", "\u0917\u093e\u0917\u094c\u091c\u093c" },
            { "syr", "\u0938\u093f\u0930\u093f\u090f\u0915" },
            { "Grek", metaValue_el },
            { "Lydi", "\u0932\u093f\u0921\u093f\u092f\u0928" },
            { "Xsux", "\u0938\u0941\u092e\u0947\u0930\u094b \u0905\u0915\u094d\u0915\u093e\u0926\u093f\u092f\u0928 \u0938\u0941\u0928\u093f\u092b\u0949\u0930\u094d\u092e" },
            { "wo", "\u0935\u094b\u0932\u094b\u092b\u093c" },
            { "zgh", "\u092e\u093e\u0928\u0915 \u092e\u094b\u0930\u0915\u094d\u0915\u0928 \u0924\u093e\u092e\u093e\u091c\u093c\u093e\u0907\u091f" },
            { "ar_001", "\u0906\u0927\u0941\u0928\u093f\u0915 \u092e\u093e\u0928\u0915 \u0905\u0930\u092c\u0940" },
            { "Cans", "\u092f\u0941\u0928\u093f\u092b\u093e\u0907\u0921 \u0915\u0948\u0928\u0947\u0921\u093f\u092f\u0928 \u090f\u092c\u094b\u0930\u093f\u091c\u0928\u0932 \u0938\u093f\u0932\u0947\u092c\u093f\u0915\u094d\u0938" },
            { "gay", "\u0917\u093e\u092f\u094b" },
            { "Mong", metaValue_mn },
            { "mnc", "\u092e\u0928\u094d\u091a\u0941" },
            { "Latf", "\u092b\u093c\u094d\u0930\u0948\u0915\u094d\u091f\u0941\u0930 \u0932\u093e\u0924\u093f\u0928\u0940" },
            { "gba", "\u0917\u094d\u092c\u093e\u092f\u093e" },
            { "mni", "\u092e\u0923\u093f\u092a\u0941\u0930\u0940" },
            { "Latn", metaValue_la },
            { "Latg", "\u0917\u0947\u0932\u0940 \u0932\u093e\u0924\u093f\u0928\u0940" },
            { "type.nu.hans", "\u0938\u0930\u0932\u0940\u0915\u0943\u0924 \u091a\u0940\u0928\u0940 \u0938\u0902\u0916\u094d\u092f\u093e\u090f\u0901" },
            { "type.nu.hant", "\u092a\u093e\u0930\u0902\u092a\u0930\u093f\u0915 \u091a\u0940\u0928\u0940 \u0938\u0902\u0916\u094d\u092f\u093e\u090f\u0901" },
            { "xh", "\u0916\u093c\u094b\u0938\u093e" },
            { "type.nu.romanlow", "\u0930\u094b\u092e\u0928 \u0932\u094b\u0905\u0930\u0915\u0947\u0938 \u0938\u0902\u0916\u094d\u092f\u093e\u090f\u0901" },
            { "byn", "\u092c\u094d\u0932\u093f\u0928" },
            { "Lyci", "\u0932\u093f\u0936\u093f\u092f\u0928" },
            { "osa", "\u0913\u0938\u0947\u091c" },
            { "Moon", "\u092e\u0942\u0928" },
            { "moh", "\u092e\u094b\u0939\u094c\u0915" },
            { "kkj", "\u0915\u093e\u0915\u094b" },
            { "yi", "\u092f\u0939\u0942\u0926\u0940" },
            { "mos", "\u092e\u094b\u0938\u094d\u0938\u0940" },
            { "Syrc", "\u0938\u093f\u0930\u093f\u092f\u0947\u0915" },
            { "Dsrt", "\u0921\u0947\u0938\u0930\u0947\u091f" },
            { "yo", "\u092f\u094b\u0930\u0942\u092c\u093e" },
            { "type.nu.traditional", "\u092a\u0930\u0902\u092a\u0930\u093e\u0917\u0924 \u0905\u0902\u0915" },
            { "es_MX", "\u092e\u0948\u0915\u094d\u0938\u093f\u0915\u0928 \u0938\u094d\u092a\u0947\u0928\u093f\u0936" },
            { "Syrj", "\u092a\u0936\u094d\u091a\u093f\u092e \u0938\u093f\u0930\u093f\u090f\u0915" },
            { "ota", "\u0913\u091f\u094b\u092e\u093e\u0928 \u0924\u0941\u0930\u094d\u0915\u093f\u0936" },
            { "Syre", "\u090f\u0938\u094d\u0924\u094d\u0930\u0947\u0928\u094d\u091c\u0947\u0932\u094b \u0938\u093f\u0930\u093f\u090f\u0915" },
            { "vai", metaValue_vai },
            { "za", "\u091c\u093c\u0941\u0906\u0902\u0917" },
            { "Cari", "\u0915\u0930\u0948\u0928" },
            { "kln", "\u0915\u0932\u0947\u0902\u091c\u093f\u0928" },
            { "zh", "\u091a\u0940\u0928\u0940" },
            { "Bopo", "\u092c\u094b\u092a\u094b\u092e\u094b\u092b\u093c\u094b" },
            { "Perm", "\u0913\u0932\u094d\u0921 \u092a\u0930\u092e\u093f\u0915" },
            { "key.lb", "\u092a\u0902\u0915\u094d\u0924\u093f \u0935\u093f\u091a\u094d\u091b\u0947\u0926 \u0936\u0948\u0932\u0940" },
            { "zu", "\u091c\u093c\u0941\u0932\u0942" },
            { "type.co.phonebook", "\u0926\u0942\u0930\u092d\u093e\u0937 \u0928\u093f\u0930\u094d\u0926\u0947\u0936\u093f\u0915\u093e \u0935\u0930\u094d\u0917\u0940\u0915\u0930\u0923" },
            { "%%MONOTON", "\u090f\u0915\u0938\u094d\u0935\u0930\u0940\u092f" },
            { "Geor", "\u091c\u0949\u0930\u094d\u091c\u093f\u092f\u0928" },
            { "kmb", "\u0915\u093f\u092e\u094d\u092c\u0928\u094d\u0926\u0941" },
            { "type.nu.jpanfin", "\u091c\u093e\u092a\u093e\u0928\u0940 \u0935\u093f\u0924\u094d\u0924\u0940\u092f \u0938\u0902\u0916\u094d\u092f\u093e\u090f\u0901" },
            { "Cham", "\u091a\u093e\u092e" },
            { "gez", "\u0917\u0940\u091c\u093c" },
            { "Syrn", "\u092a\u0942\u0930\u094d\u0935 \u0938\u093f\u0930\u093f\u090f\u0915" },
            { "type.co.reformed", "\u092a\u0941\u0928\u0930\u094d\u0928\u093f\u0930\u094d\u092e\u093f\u0924 \u0915\u094d\u0930\u092e \u0935\u093f\u0928\u094d\u092f\u093e\u0938" },
            { "Tglg", "\u091f\u0948\u0917\u093e\u0932\u094b\u0917" },
            { "Egyd", "\u0907\u091c\u093f\u092a\u094d\u0936\u093f\u092f\u0928 \u0921\u0947\u092e\u094b\u091f\u093f\u0915" },
            { "Egyh", "\u0907\u091c\u093f\u092a\u094d\u0936\u093f\u092f\u0928 \u0939\u093e\u0907\u0930\u0947\u091f\u093f\u0915" },
            { "ebu", "\u090f\u092e\u094d\u092c\u0941" },
            { "Egyp", "\u0907\u091c\u093f\u092a\u094d\u0936\u093f\u092f\u0928 \u0939\u093e\u0907\u0930\u094b\u0917\u094d\u0932\u093f\u092b\u094d\u0938" },
            { "Geok", "\u091c\u0949\u0930\u094d\u091c\u093f\u092f\u0928 \u0916\u0941\u0924\u0938\u0941\u0930\u0940" },
            { "zh_Hans", "\u0938\u0930\u0932\u0940\u0915\u0943\u0924 \u091a\u0940\u0928\u0940" },
            { "koi", "\u0915\u094b\u092e\u0940-\u092a\u0930\u094d\u092e\u092f\u093e\u0915" },
            { "Hung", "\u0911\u0932\u094d\u0921 \u0939\u0902\u0917\u0947\u0930\u093f\u092f\u0928" },
            { "kok", "\u0915\u094b\u0902\u0915\u0923\u0940" },
            { "%%1901", "\u092a\u093e\u0930\u092e\u094d\u092a\u093e\u0930\u093f\u0915 \u091c\u0930\u094d\u092e\u0928 \u0935\u0930\u094d\u0924\u0928\u0940" },
            { "kos", "\u0915\u094b\u0938\u0930\u0948\u0928" },
            { "zh_Hant", "\u092a\u093e\u0930\u0902\u092a\u0930\u093f\u0915 \u091a\u0940\u0928\u0940" },
            { "Sund", "\u0938\u0942\u0921\u093e\u0928\u0940" },
            { "kpe", "\u0915\u094d\u092a\u0947\u0932" },
            { "type.nu.khmr", "\u0916\u092e\u0947\u0930 \u0905\u0902\u0915" },
            { "ilo", "\u0907\u0932\u094b\u0915\u094b" },
            { "Cprt", "\u0915\u093e\u0907\u092a\u094d\u0930\u093e\u092f\u091f" },
            { "mua", "\u092e\u0941\u0902\u0921\u0948\u0902\u0917" },
            { "type.nu.guru", "\u0917\u0941\u0930\u092e\u0941\u0916\u0940 \u0905\u0902\u0915" },
            { "mul", "\u090f\u0915\u093e\u0927\u093f\u0915 \u092d\u093e\u0937\u093e\u090f\u0901" },
            { "cad", "\u0915\u0948\u0921\u094d\u0921\u094b" },
            { "key.ms", "\u092e\u093e\u092a\u0928 \u092a\u094d\u0930\u0923\u093e\u0932\u0940" },
            { "mus", "\u0915\u094d\u0930\u0940\u0915" },
            { "Glag", "\u0917\u094d\u0932\u0947\u0917\u094b\u0932\u093f\u091f\u093f\u0915" },
            { "gil", "\u0917\u093f\u0932\u094d\u092c\u0930\u0924\u0940\u0938" },
            { "Cher", metaValue_chr },
            { "car", "\u0915\u0948\u0930\u093f\u092c" },
            { "type.nu.tamldec", "\u0924\u092e\u093f\u0932 \u0905\u0902\u0915" },
            { "krc", "\u0915\u0930\u093e\u091a\u092f-\u092c\u0932\u094d\u0915\u093e\u0930" },
            { "inh", "\u0907\u0902\u0917\u0941\u0936" },
            { "krl", "\u0915\u0930\u0947\u0932\u093f\u092f\u0928" },
            { "efi", "\u090f\u092b\u093f\u0915" },
            { "key.nu", "\u0938\u0902\u0916\u094d\u092f\u093e\u090f\u0901" },
            { "kru", "\u0915\u0941\u0930\u0942\u0916" },
            { "ksb", "\u0936\u092e\u094d\u092c\u093e\u0932\u093e" },
            { "Telu", metaValue_te },
            { "ksf", "\u092c\u092b\u093f\u0906" },
        };
        return data;
    }
}
