/*
 * Copyright (c) 2012, 2022, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.text.resources.cldr.ext;

import java.util.ListResourceBundle;

public class FormatData_pa extends ListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] metaValue_MonthNames = new String[] {
               "\u0a1c\u0a28\u0a35\u0a30\u0a40",
               "\u0a2b\u0a3c\u0a30\u0a35\u0a30\u0a40",
               "\u0a2e\u0a3e\u0a30\u0a1a",
               "\u0a05\u0a2a\u0a4d\u0a30\u0a48\u0a32",
               "\u0a2e\u0a08",
               "\u0a1c\u0a42\u0a28",
               "\u0a1c\u0a41\u0a32\u0a3e\u0a08",
               "\u0a05\u0a17\u0a38\u0a24",
               "\u0a38\u0a24\u0a70\u0a2c\u0a30",
               "\u0a05\u0a15\u0a24\u0a42\u0a2c\u0a30",
               "\u0a28\u0a35\u0a70\u0a2c\u0a30",
               "\u0a26\u0a38\u0a70\u0a2c\u0a30",
               "",
            };
        final String[] metaValue_MonthAbbreviations = new String[] {
               "\u0a1c\u0a28",
               "\u0a2b\u0a3c\u0a30",
               "\u0a2e\u0a3e\u0a30\u0a1a",
               "\u0a05\u0a2a\u0a4d\u0a30\u0a48",
               "\u0a2e\u0a08",
               "\u0a1c\u0a42\u0a28",
               "\u0a1c\u0a41\u0a32\u0a3e",
               "\u0a05\u0a17",
               "\u0a38\u0a24\u0a70",
               "\u0a05\u0a15\u0a24\u0a42",
               "\u0a28\u0a35\u0a70",
               "\u0a26\u0a38\u0a70",
               "",
            };
        final String[] metaValue_MonthNarrows = new String[] {
               "\u0a1c",
               "\u0a2b\u0a3c",
               "\u0a2e\u0a3e",
               "\u0a05",
               "\u0a2e",
               "\u0a1c\u0a42",
               "\u0a1c\u0a41",
               "\u0a05",
               "\u0a38",
               "\u0a05",
               "\u0a28",
               "\u0a26",
               "",
            };
        final String[] metaValue_DayNames = new String[] {
               "\u0a10\u0a24\u0a35\u0a3e\u0a30",
               "\u0a38\u0a4b\u0a2e\u0a35\u0a3e\u0a30",
               "\u0a2e\u0a70\u0a17\u0a32\u0a35\u0a3e\u0a30",
               "\u0a2c\u0a41\u0a71\u0a27\u0a35\u0a3e\u0a30",
               "\u0a35\u0a40\u0a30\u0a35\u0a3e\u0a30",
               "\u0a38\u0a3c\u0a41\u0a71\u0a15\u0a30\u0a35\u0a3e\u0a30",
               "\u0a38\u0a3c\u0a28\u0a3f\u0a71\u0a1a\u0a30\u0a35\u0a3e\u0a30",
            };
        final String[] metaValue_DayAbbreviations = new String[] {
               "\u0a10\u0a24",
               "\u0a38\u0a4b\u0a2e",
               "\u0a2e\u0a70\u0a17\u0a32",
               "\u0a2c\u0a41\u0a71\u0a27",
               "\u0a35\u0a40\u0a30",
               "\u0a38\u0a3c\u0a41\u0a71\u0a15\u0a30",
               "\u0a38\u0a3c\u0a28\u0a3f\u0a71\u0a1a\u0a30",
            };
        final String[] metaValue_DayNarrows = new String[] {
               "\u0a10",
               "\u0a38\u0a4b",
               "\u0a2e\u0a70",
               "\u0a2c\u0a41\u0a71",
               "\u0a35\u0a40",
               "\u0a38\u0a3c\u0a41\u0a71",
               "\u0a38\u0a3c",
            };
        final String[] metaValue_QuarterNames = new String[] {
               "\u0a2a\u0a39\u0a3f\u0a32\u0a40 \u0a24\u0a3f\u0a2e\u0a3e\u0a39\u0a40",
               "\u0a26\u0a42\u0a1c\u0a40 \u0a24\u0a3f\u0a2e\u0a3e\u0a39\u0a40",
               "\u0a24\u0a40\u0a1c\u0a40 \u0a24\u0a3f\u0a2e\u0a3e\u0a39\u0a40",
               "\u0a1a\u0a4c\u0a25\u0a40 \u0a24\u0a3f\u0a2e\u0a3e\u0a39\u0a40",
            };
        final String[] metaValue_QuarterAbbreviations = new String[] {
               "\u0a24\u0a3f\u0a2e\u0a3e\u0a39\u0a401",
               "\u0a24\u0a3f\u0a2e\u0a3e\u0a39\u0a402",
               "\u0a24\u0a3f\u0a2e\u0a3e\u0a39\u0a403",
               "\u0a24\u0a3f\u0a2e\u0a3e\u0a39\u0a404",
            };
        final String[] metaValue_AmPmMarkers = new String[] {
               "\u0a2a\u0a42.\u0a26\u0a41.",
               "\u0a2c\u0a3e.\u0a26\u0a41.",
            };
        final String[] metaValue_narrow_AmPmMarkers = new String[] {
               "\u0a38.",
               "\u0a38\u0a3c.",
            };
        final String[] metaValue_TimePatterns = new String[] {
               "h:mm:ss a zzzz",
               "h:mm:ss a z",
               "h:mm:ss a",
               "h:mm a",
            };
        final String[] metaValue_buddhist_QuarterNarrows = new String[] {
               "1",
               "2",
               "3",
               "4",
            };
        final String[] metaValue_java_time_buddhist_long_Eras = new String[] {
               "BC",
               "\u0a08\u0a38\u0a35\u0a40 \u0a2a\u0a42\u0a30\u0a35",
            };
        final String[] metaValue_java_time_buddhist_narrow_Eras = new String[] {
               "BC",
               "\u0a08. \u0a2a\u0a42.",
            };
        final String[] metaValue_java_time_buddhist_DatePatterns = new String[] {
               "EEEE, dd MMMM y G",
               "d MMMM y G",
               "d MMM y G",
               "dd/MM/y GGGGG",
            };
        final String[] metaValue_buddhist_DatePatterns = new String[] {
               "EEEE, dd MMMM y GGGG",
               "d MMMM y GGGG",
               "d MMM y GGGG",
               "dd/MM/y G",
            };
        final String[] metaValue_java_time_roc_long_Eras = new String[] {
               "\u0a1a\u0a40\u0a28 \u0a26\u0a47 \u0a17\u0a23\u0a30\u0a3e\u0a1c \u0a24\u0a4b\u0a02 \u0a2a\u0a39\u0a3f\u0a32\u0a3e\u0a02",
               "\u0a2e\u0a3f\u0a70\u0a17",
            };
        final String[] metaValue_java_time_roc_Eras = new String[] {
               "\u0a06\u0a30.\u0a13.\u0a38\u0a40 \u0a24\u0a4b\u0a02 \u0a2a\u0a39\u0a3f\u0a32\u0a3e\u0a02",
               "\u0a2e\u0a3f\u0a70\u0a17",
            };
        final String[] metaValue_java_time_islamic_long_Eras = new String[] {
               "",
               "AH",
            };
        final String metaValue_calendarname_gregorian = "\u0a17\u0a30\u0a47\u0a17\u0a4b\u0a30\u0a40\u0a05\u0a28 \u0a15\u0a48\u0a32\u0a70\u0a21\u0a30";
        final Object[][] data = new Object[][] {
            { "MonthNames", metaValue_MonthNames },
            { "field.year", "\u0a38\u0a3e\u0a32" },
            { "calendarname.islamic-umalqura", "\u0a07\u0a38\u0a32\u0a3e\u0a2e\u0a40 \u0a15\u0a48\u0a32\u0a70\u0a21\u0a30 (\u0a05\u0a2e \u0a05\u0a32-\u0a15\u0a41\u0a30\u0a3e)" },
            { "arabext.NumberElements",
                new String[] {
                    "\u066b",
                    ",",
                    "\u061b",
                    "\u066a",
                    "\u06f0",
                    "#",
                    "-",
                    "\u00d7\u06f1\u06f0^",
                    "\u0609",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "japanese.AmPmMarkers", metaValue_AmPmMarkers },
            { "buddhist.narrow.Eras", metaValue_java_time_buddhist_narrow_Eras },
            { "AmPmMarkers", metaValue_AmPmMarkers },
            { "java.time.japanese.DatePatterns", metaValue_java_time_buddhist_DatePatterns },
            { "standalone.QuarterAbbreviations", metaValue_QuarterAbbreviations },
            { "roc.QuarterNames", metaValue_QuarterNames },
            { "roc.MonthNarrows", metaValue_MonthNarrows },
            { "calendarname.islamic-civil", "\u0a07\u0a38\u0a32\u0a3e\u0a2e\u0a40 \u0a15\u0a48\u0a32\u0a70\u0a21\u0a30 (\u0a38\u0a3e\u0a30\u0a28\u0a40\u0a2c\u0a71\u0a27, \u0a38\u0a2e\u0a3e\u0a1c\u0a3f\u0a15 \u0a2f\u0a41\u0a71\u0a17)" },
            { "islamic.narrow.AmPmMarkers", metaValue_narrow_AmPmMarkers },
            { "japanese.TimePatterns", metaValue_TimePatterns },
            { "roc.long.Eras", metaValue_java_time_roc_long_Eras },
            { "narrow.Eras",
                new String[] {
                    "\u0a08.\u0a2a\u0a42.",
                    "\u0a38\u0a70\u0a28",
                }
            },
            { "abbreviated.AmPmMarkers", metaValue_AmPmMarkers },
            { "timezone.regionFormat.standard", "{0} \u0a2e\u0a3f\u0a06\u0a30\u0a40 \u0a35\u0a47\u0a32\u0a3e" },
            { "japanese.abbreviated.AmPmMarkers", metaValue_AmPmMarkers },
            { "calendarname.japanese", "\u0a1c\u0a2a\u0a3e\u0a28\u0a40 \u0a15\u0a48\u0a32\u0a70\u0a21\u0a30" },
            { "japanese.MonthNames", metaValue_MonthNames },
            { "standalone.DayAbbreviations", metaValue_DayAbbreviations },
            { "roc.MonthAbbreviations", metaValue_MonthAbbreviations },
            { "java.time.islamic.narrow.Eras", metaValue_java_time_islamic_long_Eras },
            { "long.Eras",
                new String[] {
                    "\u0a08\u0a38\u0a35\u0a40 \u0a2a\u0a42\u0a30\u0a35",
                    "\u0a08\u0a38\u0a35\u0a40 \u0a38\u0a70\u0a28",
                }
            },
            { "roc.QuarterNarrows", metaValue_buddhist_QuarterNarrows },
            { "islamic.DayNames", metaValue_DayNames },
            { "buddhist.MonthAbbreviations", metaValue_MonthAbbreviations },
            { "buddhist.MonthNames", metaValue_MonthNames },
            { "DateTimePatterns",
                new String[] {
                    "{1} {0}",
                    "{1} {0}",
                    "{1}, {0}",
                    "{1}, {0}",
                }
            },
            { "narrow.AmPmMarkers", metaValue_narrow_AmPmMarkers },
            { "latn.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "0",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "MonthNarrows", metaValue_MonthNarrows },
            { "japanese.DatePatterns", metaValue_buddhist_DatePatterns },
            { "guru.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\u0a66",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "buddhist.DayNames", metaValue_DayNames },
            { "field.minute", "\u0a2e\u0a3f\u0a70\u0a1f" },
            { "field.era", "\u0a38\u0a70\u0a2e\u0a24" },
            { "buddhist.AmPmMarkers", metaValue_AmPmMarkers },
            { "field.dayperiod", "\u0a2a\u0a42.\u0a26\u0a41./\u0a2c\u0a3e.\u0a26\u0a41." },
            { "standalone.MonthNarrows", metaValue_MonthNarrows },
            { "islamic.MonthNames",
                new String[] {
                    "\u0a2e\u0a41\u0a39\u0a71\u0a30\u0a2e",
                    "\u0a38\u0a2b\u0a30",
                    "\u0a30\u0a2c\u0a40 \u02bb I",
                    "\u0a30\u0a2c\u0a40 \u02bb II",
                    "\u0a1c\u0a41\u0a2e\u0a3e\u0a26\u0a3e I",
                    "\u0a1c\u0a41\u0a2e\u0a3e\u0a26\u0a3e II",
                    "\u0a30\u0a1c\u0a2c",
                    "\u0a38\u0a3c\u0a2c\u0a3e\u0a28",
                    "\u0a30\u0a2e\u0a1c\u0a3c\u0a3e\u0a28",
                    "\u0a38\u0a3c\u0a35\u0a3e\u0a32",
                    "\u0a26\u0a42-\u0a05\u0a32-\u0a15\u0a40\u0a26\u0a3e\u0a39",
                    "\u0a26\u0a42-\u0a05\u0a32-\u0a39\u0a3f\u0a1c\u0a4d\u0a39\u0a3e",
                    "",
                }
            },
            { "japanese.QuarterNarrows", metaValue_buddhist_QuarterNarrows },
            { "calendarname.roc", "\u0a2e\u0a3f\u0a70\u0a17\u0a42\u0a13 \u0a15\u0a48\u0a32\u0a70\u0a21\u0a30" },
            { "islamic.DatePatterns", metaValue_buddhist_DatePatterns },
            { "roc.QuarterAbbreviations", metaValue_QuarterAbbreviations },
            { "islamic.Eras", metaValue_java_time_islamic_long_Eras },
            { "field.month", "\u0a2e\u0a39\u0a40\u0a28\u0a3e" },
            { "arabext.NumberPatterns",
                new String[] {
                    "#,##,##0.###",
                    "\u00a4#,##,##0.00",
                    "#,##,##0%",
                    "",
                }
            },
            { "roc.Eras", metaValue_java_time_roc_Eras },
            { "field.second", "\u0a38\u0a15\u0a3f\u0a70\u0a1f" },
            { "DayAbbreviations", metaValue_DayAbbreviations },
            { "DayNarrows", metaValue_DayNarrows },
            { "roc.DatePatterns", metaValue_buddhist_DatePatterns },
            { "calendarname.islamic", "\u0a07\u0a38\u0a32\u0a3e\u0a2e\u0a40 \u0a15\u0a48\u0a32\u0a70\u0a21\u0a30" },
            { "guru.NumberPatterns",
                new String[] {
                    "#,##,##0.###",
                    "\u00a4\u00a0#,##,##0.00",
                    "#,##,##0%",
                    "",
                }
            },
            { "java.time.roc.long.Eras", metaValue_java_time_roc_long_Eras },
            { "java.time.roc.narrow.Eras", metaValue_java_time_roc_Eras },
            { "japanese.narrow.AmPmMarkers", metaValue_narrow_AmPmMarkers },
            { "buddhist.TimePatterns", metaValue_TimePatterns },
            { "standalone.MonthAbbreviations", metaValue_MonthAbbreviations },
            { "timezone.regionFormat", "{0} \u0a35\u0a47\u0a32\u0a3e" },
            { "long.CompactNumberPatterns",
                new String[] {
                    "",
                    "",
                    "",
                    "{one:0' '\u0a39\u0a1c\u0a3c\u0a3e\u0a30 other:0' '\u0a39\u0a1c\u0a3c\u0a3e\u0a30}",
                    "{one:00' '\u0a39\u0a1c\u0a3c\u0a3e\u0a30 other:00' '\u0a39\u0a1c\u0a3c\u0a3e\u0a30}",
                    "{one:0' '\u0a32\u0a71\u0a16 other:0' '\u0a32\u0a71\u0a16}",
                    "{one:00' '\u0a32\u0a71\u0a16 other:00' '\u0a32\u0a71\u0a16}",
                    "{one:0' '\u0a15\u0a30\u0a4b\u0a5c other:0' '\u0a15\u0a30\u0a4b\u0a5c}",
                    "{one:00' '\u0a15\u0a30\u0a4b\u0a5c other:00' '\u0a15\u0a30\u0a4b\u0a5c}",
                    "{one:0' '\u0a05\u0a30\u0a2c other:0' '\u0a05\u0a30\u0a2c}",
                    "{one:00' '\u0a05\u0a30\u0a2c other:00' '\u0a05\u0a30\u0a2c}",
                    "{one:0' '\u0a16\u0a30\u0a2c other:0' '\u0a16\u0a30\u0a2c}",
                    "{one:00' '\u0a16\u0a30\u0a2c other:00' '\u0a16\u0a30\u0a2c}",
                    "{one:0' '\u0a28\u0a40\u0a32 other:0' '\u0a28\u0a40\u0a32}",
                    "{one:00' '\u0a28\u0a40\u0a32 other:00' '\u0a28\u0a40\u0a32}",
                }
            },
            { "roc.narrow.AmPmMarkers", metaValue_narrow_AmPmMarkers },
            { "buddhist.QuarterNarrows", metaValue_buddhist_QuarterNarrows },
            { "standalone.QuarterNames", metaValue_QuarterNames },
            { "japanese.MonthNarrows", metaValue_MonthNarrows },
            { "islamic.QuarterAbbreviations", metaValue_QuarterAbbreviations },
            { "roc.DayAbbreviations", metaValue_DayAbbreviations },
            { "standalone.DayNarrows", metaValue_DayNarrows },
            { "java.time.buddhist.long.Eras", metaValue_java_time_buddhist_long_Eras },
            { "islamic.AmPmMarkers", metaValue_AmPmMarkers },
            { "buddhist.long.Eras", metaValue_java_time_buddhist_long_Eras },
            { "TimePatterns", metaValue_TimePatterns },
            { "islamic.DayNarrows", metaValue_DayNarrows },
            { "java.time.roc.Eras", metaValue_java_time_roc_Eras },
            { "field.zone", "\u0a07\u0a32\u0a3e\u0a15\u0a3e\u0a08 \u0a35\u0a47\u0a32\u0a3e" },
            { "japanese.QuarterAbbreviations", metaValue_QuarterAbbreviations },
            { "roc.narrow.Eras", metaValue_java_time_roc_Eras },
            { "buddhist.narrow.AmPmMarkers", metaValue_narrow_AmPmMarkers },
            { "buddhist.abbreviated.AmPmMarkers", metaValue_AmPmMarkers },
            { "Eras",
                new String[] {
                    "\u0a08. \u0a2a\u0a42.",
                    "\u0a38\u0a70\u0a28",
                }
            },
            { "roc.DayNames", metaValue_DayNames },
            { "islamic.QuarterNames", metaValue_QuarterNames },
            { "islamic.abbreviated.AmPmMarkers", metaValue_AmPmMarkers },
            { "java.time.islamic.DatePatterns", metaValue_java_time_buddhist_DatePatterns },
            { "field.weekday", "\u0a39\u0a2b\u0a3c\u0a24\u0a47 \u0a26\u0a3e \u0a26\u0a3f\u0a28" },
            { "japanese.MonthAbbreviations", metaValue_MonthAbbreviations },
            { "islamic.DayAbbreviations", metaValue_DayAbbreviations },
            { "islamic.long.Eras", metaValue_java_time_islamic_long_Eras },
            { "java.time.islamic.Eras", metaValue_java_time_islamic_long_Eras },
            { "japanese.QuarterNames", metaValue_QuarterNames },
            { "buddhist.QuarterAbbreviations", metaValue_QuarterAbbreviations },
            { "java.time.buddhist.Eras", metaValue_java_time_buddhist_long_Eras },
            { "japanese.DayNames", metaValue_DayNames },
            { "japanese.DayAbbreviations", metaValue_DayAbbreviations },
            { "DayNames", metaValue_DayNames },
            { "buddhist.DatePatterns", metaValue_buddhist_DatePatterns },
            { "roc.MonthNames", metaValue_MonthNames },
            { "buddhist.Eras", metaValue_java_time_buddhist_long_Eras },
            { "field.week", "\u0a39\u0a2b\u0a3c\u0a24\u0a3e" },
            { "buddhist.DateTimePatterns",
                new String[] {
                    "{0} \u0a35\u0a3f\u0a16\u0a47 {1}",
                    "{0} \u0a35\u0a3f\u0a16\u0a47 {1}",
                    "{1}, {0}",
                    "{1}, {0}",
                }
            },
            { "buddhist.MonthNarrows", metaValue_MonthNarrows },
            { "buddhist.QuarterNames", metaValue_QuarterNames },
            { "islamic.QuarterNarrows", metaValue_buddhist_QuarterNarrows },
            { "roc.DayNarrows", metaValue_DayNarrows },
            { "roc.AmPmMarkers", metaValue_AmPmMarkers },
            { "java.time.roc.DatePatterns", metaValue_java_time_buddhist_DatePatterns },
            { "java.time.buddhist.DatePatterns", metaValue_java_time_buddhist_DatePatterns },
            { "short.CompactNumberPatterns",
                new String[] {
                    "",
                    "",
                    "",
                    "{one:0\u00a0\u0a39\u0a1c\u0a3c\u0a3e\u0a30 other:0\u00a0\u0a39\u0a1c\u0a3c\u0a3e\u0a30}",
                    "{one:00\u00a0\u0a39\u0a1c\u0a3c\u0a3e\u0a30 other:00\u00a0\u0a39\u0a1c\u0a3c\u0a3e\u0a30}",
                    "{one:0\u00a0\u0a32\u0a71\u0a16 other:0\u00a0\u0a32\u0a71\u0a16}",
                    "{one:00\u00a0\u0a32\u0a71\u0a16 other:00\u00a0\u0a32\u0a71\u0a16}",
                    "{one:0\u00a0\u0a15\u0a30\u0a4b\u0a5c other:0\u00a0\u0a15\u0a30\u0a4b\u0a5c}",
                    "{one:00\u00a0\u0a15\u0a30\u0a4b\u0a5c other:00\u00a0\u0a15\u0a30\u0a4b\u0a5c}",
                    "{one:0\u00a0\u0a05\u0a30\u0a2c other:0\u00a0\u0a05\u0a30\u0a2c}",
                    "{one:00\u00a0\u0a05\u0a30\u0a2c other:00\u00a0\u0a05\u0a30\u0a2c}",
                    "{one:0\u00a0\u0a16\u0a30\u0a2c other:0\u00a0\u0a16\u0a30\u0a2c}",
                    "{one:00\u00a0\u0a16\u0a30\u0a2c other:00\u00a0\u0a16\u0a30\u0a2c}",
                    "{one:0\u00a0\u0a28\u0a40\u0a32 other:0\u00a0\u0a28\u0a40\u0a32}",
                    "{one:00\u00a0\u0a28\u0a40\u0a32 other:00\u00a0\u0a28\u0a40\u0a32}",
                }
            },
            { "calendarname.gregorian", metaValue_calendarname_gregorian },
            { "java.time.buddhist.narrow.Eras", metaValue_java_time_buddhist_narrow_Eras },
            { "timezone.regionFormat.daylight", "{0} \u0a2a\u0a4d\u0a30\u0a15\u0a3e\u0a38\u0a3c \u0a35\u0a47\u0a32\u0a3e" },
            { "DatePatterns",
                new String[] {
                    "EEEE, d MMMM y",
                    "d MMMM y",
                    "d MMM y",
                    "d/M/yy",
                }
            },
            { "buddhist.DayAbbreviations", metaValue_DayAbbreviations },
            { "islamic.TimePatterns", metaValue_TimePatterns },
            { "MonthAbbreviations", metaValue_MonthAbbreviations },
            { "standalone.DayNames", metaValue_DayNames },
            { "field.hour", "\u0a18\u0a70\u0a1f\u0a3e" },
            { "islamic.MonthAbbreviations",
                new String[] {
                    "\u0a2e\u0a41\u0a39\u0a71.",
                    "\u0a38\u0a2b.",
                    "\u0a30\u0a2c. I",
                    "\u0a30\u0a2c. II",
                    "\u0a1c\u0a41\u0a2e. I",
                    "\u0a1c\u0a41\u0a2e. II",
                    "\u0a30\u0a3e\u0a1c.",
                    "\u0a38\u0a3c\u0a3e.",
                    "\u0a30\u0a3e\u0a2e.",
                    "\u0a38\u0a3c\u0a05.",
                    "\u0a26\u0a42-\u0a05\u0a32-\u0a15\u0a40.",
                    "\u0a26\u0a42-\u0a05\u0a32-\u0a39\u0a3f.",
                    "",
                }
            },
            { "islamic.narrow.Eras", metaValue_java_time_islamic_long_Eras },
            { "calendarname.buddhist", "\u0a2c\u0a4b\u0a27\u0a40 \u0a15\u0a48\u0a32\u0a70\u0a21\u0a30" },
            { "standalone.MonthNames", metaValue_MonthNames },
            { "latn.NumberPatterns",
                new String[] {
                    "#,##,##0.###",
                    "\u00a4\u00a0#,##,##0.00",
                    "#,##,##0%",
                    "\u00a4\u00a0#,##0.00",
                }
            },
            { "buddhist.DayNarrows", metaValue_DayNarrows },
            { "java.time.islamic.long.Eras", metaValue_java_time_islamic_long_Eras },
            { "japanese.DayNarrows", metaValue_DayNarrows },
            { "QuarterNames", metaValue_QuarterNames },
            { "roc.TimePatterns", metaValue_TimePatterns },
            { "QuarterAbbreviations", metaValue_QuarterAbbreviations },
            { "roc.abbreviated.AmPmMarkers", metaValue_AmPmMarkers },
            { "calendarname.gregory", metaValue_calendarname_gregorian },
        };
        return data;
    }
}
