/*
 * Copyright (c) 2012, 2022, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ceb extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ja = "Hinapon";
        final String metaValue_ko = "Korean";
        final Object[][] data = new Object[][] {
            { "PR", "Puerto Rico" },
            { "PS", "Palestinian Territories" },
            { "PT", "Portugal" },
            { "pt", "Portuguese" },
            { "PW", "Palau" },
            { "PY", "Paraguay" },
            { "pt_BR", "Brazilyanong Portuguese" },
            { "QA", "Qatar" },
            { "es_ES", "Espanyol sa Europe" },
            { "QO", "Outlying Oceania" },
            { "AC", "Ascension Island" },
            { "AD", "Andorra" },
            { "AE", "United Arab Emirates" },
            { "nl_BE", "Flemish" },
            { "AF", "Afghanistan" },
            { "AG", "Antigua & Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "Arab", "Arabo" },
            { "AO", "Angola" },
            { "Jpan", metaValue_ja },
            { "AQ", "Antarctica" },
            { "001", "Kalibutan" },
            { "AR", "Argentina" },
            { "ar", "Arabic" },
            { "002", "Africa" },
            { "AS", "American Samoa" },
            { "003", "North America" },
            { "AT", "Austria" },
            { "RE", "Reunion" },
            { "AU", "Australia" },
            { "005", "South America" },
            { "AW", "Aruba" },
            { "en_US", "Ingles sa Amerika" },
            { "AX", "Aland Islands" },
            { "009", "Oceania" },
            { "AZ", "Azerbaijan" },
            { "RO", "Romania" },
            { "BA", "Bosnia & Herzegovina" },
            { "BB", "Barbados" },
            { "RS", "Serbia" },
            { "ceb", "Binisaya" },
            { "BD", "Bangladesh" },
            { "BE", "Belgium" },
            { "RU", "Russia" },
            { "ru", "Ruso" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgaria" },
            { "RW", "Rwanda" },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "en_AU", "Ingles sa Australia" },
            { "BL", "St. Barthelemy" },
            { "BM", "Bermuda" },
            { "BN", "Brunei" },
            { "bn", "Bangla" },
            { "BO", "Bolivia" },
            { "SA", "Saudi Arabia" },
            { "BQ", "Caribbean Netherlands" },
            { "SB", "Solomon Islands" },
            { "011", "Western Africa" },
            { "BR", "Brazil" },
            { "SC", "Seychelles" },
            { "BS", "Bahamas" },
            { "SD", "Sudan" },
            { "013", "Central America" },
            { "BT", "Bhutan" },
            { "SE", "Sweden" },
            { "014", "Eastern Africa" },
            { "015", "Northern Africa" },
            { "BV", "Bouvet Island" },
            { "SG", "Singapore" },
            { "BW", "Botswana" },
            { "SH", "St. Helena" },
            { "017", "Middle Africa" },
            { "SI", "Slovenia" },
            { "018", "Southern Africa" },
            { "BY", "Belarus" },
            { "SJ", "Svalbard & Jan Mayen" },
            { "019", "Mga Amerika" },
            { "BZ", "Belize" },
            { "SK", "Slovakia" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "CA", "Canada" },
            { "SR", "Suriname" },
            { "CC", "Cocos (Keeling) Islands" },
            { "SS", "South Sudan" },
            { "CD", "Congo - Kinshasa" },
            { "ST", "Sao Tome & Principe" },
            { "CF", "Central African Republic" },
            { "SV", "El Salvador" },
            { "CG", "Congo - Brazzaville" },
            { "CH", "Switzerland" },
            { "SX", "Sint Maarten" },
            { "CI", "Cote d\u2019Ivoire" },
            { "SY", "Syria" },
            { "SZ", "Eswatini" },
            { "CK", "Cook Islands" },
            { "CL", "Chile" },
            { "CM", "Cameroon" },
            { "CN", "Tsina" },
            { "CO", "Colombia" },
            { "CP", "Clipperton Island" },
            { "TA", "Tristan da Cunha" },
            { "021", "Northern America" },
            { "142", "Asya" },
            { "CR", "Costa Rica" },
            { "TC", "Turks & Caicos Islands" },
            { "143", "Central Asia" },
            { "TD", "Chad" },
            { "145", "Western Asia" },
            { "CU", "Cuba" },
            { "TF", "French Southern Territories" },
            { "CV", "Cape Verde" },
            { "TG", "Togo" },
            { "CW", "Curacao" },
            { "TH", "Thailand" },
            { "th", "Thai" },
            { "CX", "Christmas Island" },
            { "CY", "Cyprus" },
            { "TJ", "Tajikistan" },
            { "en_CA", "Ingles sa Canada" },
            { "029", "Caribbean" },
            { "CZ", "Czechia" },
            { "TK", "Tokelau" },
            { "TL", "Timor-Leste" },
            { "TM", "Turkmenistan" },
            { "TN", "Tunisia" },
            { "TO", "Tonga" },
            { "TR", "Turkey" },
            { "tr", "Turkish" },
            { "pt_PT", "Portuguese sa Europe" },
            { "TT", "Trinidad & Tobago" },
            { "DE", "Alemanya" },
            { "de", "Aleman" },
            { "TV", "Tuvalu" },
            { "DG", "Diego Garcia" },
            { "TW", "Taiwan" },
            { "DJ", "Djibouti" },
            { "TZ", "Tanzania" },
            { "DK", "Denmark" },
            { "DM", "Dominica" },
            { "Zzzz", "Wala Mailhing Script" },
            { "DO", "Dominican Republic" },
            { "150", "Europe" },
            { "UA", "Ukraine" },
            { "030", "Eastern Asia" },
            { "151", "Eastern Europe" },
            { "154", "Northern Europe" },
            { "034", "Southern Asia" },
            { "155", "Western Europe" },
            { "035", "Southeast Asia" },
            { "UG", "Uganda" },
            { "es_419", "Espanyol sa Latin Amerika" },
            { "Kore", metaValue_ko },
            { "039", "Southern Europe" },
            { "DZ", "Algeria" },
            { "UM", "U.S. Outlying Islands" },
            { "UN", "United Nations" },
            { "EA", "Ceuta & Melilla" },
            { "EC", "Ecuador" },
            { "US", "Estados Unidos" },
            { "EE", "Estonia" },
            { "EG", "Egypt" },
            { "EH", "Western Sahara" },
            { "UY", "Uruguay" },
            { "UZ", "Uzbekistan" },
            { "en", "Ingles" },
            { "VA", "Vatican City" },
            { "ER", "Eritrea" },
            { "VC", "St. Vincent & Grenadines" },
            { "ES", "Spain" },
            { "es", "Espanyol" },
            { "ET", "Ethiopia" },
            { "VE", "Venezuela" },
            { "EU", "European Union" },
            { "type.ca.gregorian", "Gregorian nga Kalendaryo" },
            { "VG", "British Virgin Islands" },
            { "VI", "U.S. Virgin Islands" },
            { "EZ", "Eurozone" },
            { "VN", "Vietnam" },
            { "Hans", "Pinasimple" },
            { "type.nu.latn", "Mga Western Digit" },
            { "Hant", "Tradisyonal" },
            { "VU", "Vanuatu" },
            { "FI", "Finland" },
            { "FJ", "Fiji" },
            { "FK", "Falkland Islands" },
            { "FM", "Micronesia" },
            { "FO", "Faroe Islands" },
            { "FR", "Pransya" },
            { "fr", "Pranses" },
            { "053", "Australasia" },
            { "054", "Melanesia" },
            { "WF", "Wallis & Futuna" },
            { "057", "Micronesian Region" },
            { "GA", "Gabon" },
            { "GB", "United Kingdom" },
            { "ar_001", "Modernong Tamdanang Arabic" },
            { "WS", "Samoa" },
            { "GD", "Grenada" },
            { "GE", "Georgia" },
            { "GF", "French Guiana" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "GL", "Greenland" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guadeloupe" },
            { "XA", "Pseudo-Accents" },
            { "GQ", "Equatorial Guinea" },
            { "XB", "Pseudo-Bidi" },
            { "und", "Wala Mailhing Lengguwahe" },
            { "061", "Polynesia" },
            { "GR", "Greece" },
            { "Latn", "Latin" },
            { "GS", "South Georgia & South Sandwich Islands" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guinea-Bissau" },
            { "GY", "Guyana" },
            { "XK", "Kosovo" },
            { "Zxxx", "Dili Sinulat" },
            { "hi", "Hindi" },
            { "de_AT", "Austriano nga Aleman" },
            { "HK", "Hong Kong SAR China" },
            { "HM", "Heard & McDonald Islands" },
            { "HN", "Honduras" },
            { "HR", "Croatia" },
            { "HT", "Haiti" },
            { "YE", "Yemen" },
            { "HU", "Hungary" },
            { "type.co.standard", "Tamdanang Paagi sa Paghan-ay" },
            { "es_MX", "Espanyol sa Mexico" },
            { "IC", "Canary Islands" },
            { "ID", "Indonesia" },
            { "YT", "Mayotte" },
            { "id", "Indonesian" },
            { "IE", "Ireland" },
            { "IL", "Israel" },
            { "IM", "Isle of Man" },
            { "IN", "India" },
            { "IO", "British Indian Ocean Territory" },
            { "ZA", "South Africa" },
            { "IQ", "Iraq" },
            { "IR", "Iran" },
            { "IS", "Iceland" },
            { "IT", "Italya" },
            { "it", "Italiano" },
            { "zh", "Inintsik" },
            { "ZM", "Zambia" },
            { "ja", metaValue_ja },
            { "JE", "Jersey" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "Wala Mailhing Rehiyon" },
            { "JM", "Jamaica" },
            { "JO", "Jordan" },
            { "JP", "Japan" },
            { "type.ca.iso8601", "Kalendaryo sa ISO-8601" },
            { "de_CH", "Swiss nga Taas nga Aleman" },
            { "KE", "Kenya" },
            { "419", "Latin America" },
            { "KG", "Kyrgyzstan" },
            { "KH", "Cambodia" },
            { "KI", "Kiribati" },
            { "KM", "Comoros" },
            { "KN", "St. Kitts & Nevis" },
            { "fr_CA", "Pranses sa Canada" },
            { "ko", metaValue_ko },
            { "KP", "North Korea" },
            { "KR", "South Korea" },
            { "fr_CH", "Swiss nga Pranses" },
            { "KW", "Kuwait" },
            { "KY", "Cayman Islands" },
            { "KZ", "Kazakhstan" },
            { "Cyrl", "Sirilisko" },
            { "LA", "Laos" },
            { "LB", "Lebanon" },
            { "LC", "St. Lucia" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "zh_Hans", "Pinasimpleng Inintsik" },
            { "LR", "Liberia" },
            { "LS", "Lesotho" },
            { "LT", "Lithuania" },
            { "LU", "Luxembourg" },
            { "LV", "Latvia" },
            { "LY", "Libya" },
            { "MA", "Morocco" },
            { "MC", "Monaco" },
            { "MD", "Moldova" },
            { "ME", "Montenegro" },
            { "MF", "St. Martin" },
            { "MG", "Madagascar" },
            { "MH", "Marshall Islands" },
            { "zh_Hant", "Tradisyonal nga Ininstsik" },
            { "MK", "North Macedonia" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Burma)" },
            { "MN", "Mongolia" },
            { "MO", "Macao SAR China" },
            { "MP", "Northern Mariana Islands" },
            { "MQ", "Martinique" },
            { "MR", "Mauritania" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Mauritius" },
            { "MV", "Maldives" },
            { "MW", "Malawi" },
            { "MX", "Mexico" },
            { "MY", "Malaysia" },
            { "MZ", "Mozambique" },
            { "NA", "Namibia" },
            { "202", "Sub-Saharan Africa" },
            { "NC", "New Caledonia" },
            { "NE", "Niger" },
            { "NF", "Norfolk Island" },
            { "NG", "Nigeria" },
            { "NI", "Nicaragua" },
            { "NL", "Netherlands" },
            { "nl", "Dutch" },
            { "NO", "Norway" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "New Zealand" },
            { "OM", "Oman" },
            { "PA", "Panama" },
            { "en_GB", "Britanikong Ingles" },
            { "PE", "Peru" },
            { "PF", "French Polynesia" },
            { "PG", "Papua New Guinea" },
            { "PH", "Pilipinas" },
            { "PK", "Pakistan" },
            { "PL", "Poland" },
            { "pl", "Polish" },
            { "PM", "St. Pierre & Miquelon" },
            { "PN", "Pitcairn Islands" },
        };
        return data;
    }
}
