/*
 * Copyright (c) 2012, 2023, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class CurrencyNames_fy extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final Object[][] data = new Object[][] {
            { "AUD", "AU$" },
            { "CAD", "C$" },
            { "FJD", "FJ$" },
            { "SBD", "SI$" },
            { "THB", "\u0e3f" },
            { "XPF", "XPF" },
            { "adp", "Andorrese peseta" },
            { "aed", "Verenigde Arabyske Emiraten-dirham" },
            { "afa", "Afghani (1927\u20132002)" },
            { "afn", "Afghaanske afghani" },
            { "all", "Albanese lek" },
            { "amd", "Armeense dram" },
            { "ang", "Nederl\u00e2nsk-Antilliaanske g\u00fbne" },
            { "aoa", "Angolese kwanza" },
            { "aok", "Angolese kwanza (1977\u20131990)" },
            { "aon", "Angolese nieuwe kwanza (1990\u20132000)" },
            { "aor", "Angolese kwanza reajustado (1995\u20131999)" },
            { "ara", "Argentynske austral" },
            { "arl", "Argentynske peso ley (1970\u20131983)" },
            { "arm", "Argentynske peso (1881\u20131970)" },
            { "arp", "Argentynske peso (1983\u20131985)" },
            { "ars", "Argentynske peso" },
            { "ats", "Eastenrykse schilling" },
            { "aud", "Australyske dollar" },
            { "awg", "Arubaanske gulden" },
            { "azm", "Azerbeidzjaanske manat (1993\u20132006)" },
            { "azn", "Azerbeidzjaanske manat" },
            { "bad", "Bosnyske dinar" },
            { "bam", "Bosnyske convertibele mark" },
            { "ban", "Nije Bosnyske dinar (1994\u20131997)" },
            { "bbd", "Barbadaanske dollar" },
            { "bdt", "Bengalese taka" },
            { "bec", "Belgyske frank (convertibel)" },
            { "bef", "Belgyske frank" },
            { "bel", "Belgyske frank (finansjeel)" },
            { "bgl", "Bulgaarse harde lev" },
            { "bgm", "Bulgaarse socialistyske lev" },
            { "bgn", "Bulgaarse lev" },
            { "bgo", "Bulgaarse lev (1879\u20131952)" },
            { "bhd", "Bahreinse dinar" },
            { "bif", "Burundese frank" },
            { "bmd", "Bermuda-dollar" },
            { "bnd", "Bruneise dollar" },
            { "bob", "Boliviaanske boliviano" },
            { "bol", "Boliviaanske boliviano (1863\u20131963)" },
            { "bop", "Boliviaanske peso" },
            { "bov", "Boliviaanske mvdol" },
            { "brb", "Braziliaanske cruzeiro novo (1967\u20131986)" },
            { "brc", "Braziliaanske cruzado" },
            { "bre", "Braziliaanske cruzeiro (1990\u20131993)" },
            { "brl", "Braziliaanske real" },
            { "brn", "Braziliaanske cruzado novo" },
            { "brr", "Braziliaanske cruzeiro" },
            { "brz", "Braziliaanske cruzeiro (1942\u20131967)" },
            { "bsd", "Bahamaanske dollar" },
            { "btn", "Bhutaanske ngultrum" },
            { "buk", "Birmese kyat" },
            { "bwp", "Botswaanske pula" },
            { "byb", "Wit-Russyske nieuwe roebel (1994\u20131999)" },
            { "byn", "Wit-Russyske roebel" },
            { "byr", "Wit-Russyske roebel (2000\u20132016)" },
            { "bzd", "Belizaanske dollar" },
            { "cad", "Canadese dollar" },
            { "cdf", "Congolese frank" },
            { "che", "WIR euro" },
            { "chf", "Zwitserse frank" },
            { "chw", "WIR franc" },
            { "cle", "Sileenske escudo" },
            { "clf", "Sileenske unidades de fomento" },
            { "clp", "Sileenske peso" },
            { "cny", "Sineeske yuan renminbi" },
            { "cop", "Kolombiaanske peso" },
            { "cou", "Unidad de Valor Real" },
            { "crc", "Costaricaanske col\u00f3n" },
            { "csd", "Alde Servyske dinar" },
            { "csk", "Tsjechoslowaakse harde koruna" },
            { "cuc", "Kubaanske convertibele peso" },
            { "cup", "Kubaanske peso" },
            { "cve", "Kaapverdyske escudo" },
            { "cyp", "Cyprysk p\u00fbn" },
            { "czk", "Tsjechyske kroon" },
            { "ddm", "East-D\u00fatske ostmark" },
            { "dem", "D\u00fatske mark" },
            { "djf", "Djiboutiaanske frank" },
            { "dkk", "Deenske kroon" },
            { "dop", "Dominikaanske peso" },
            { "dzd", "Algerynske dinar" },
            { "ecs", "Ecuadoraanske sucre" },
            { "ecv", "Ecuadoraanske unidad de valor constante (UVC)" },
            { "eek", "Estl\u00e2nske kroon" },
            { "egp", "Egyptysk p\u00fbn" },
            { "ern", "Eritrese nakfa" },
            { "esa", "Spaanske peseta (account A)" },
            { "esb", "Spaanske peseta (convertibele account)" },
            { "esp", "Spaanske peseta" },
            { "etb", "Ethiopyske birr" },
            { "eur", "Euro" },
            { "fim", "Finse markka" },
            { "fjd", "Fiji-dollar" },
            { "fkp", "Falkl\u00e2neil\u00e2nske p\u00fbn" },
            { "frf", "Franske franc" },
            { "gbp", "Brits p\u00fbn" },
            { "gek", "Georgyske kupon larit" },
            { "gel", "Georgyske lari" },
            { "ghc", "Ghanese cedi (1979\u20132007)" },
            { "ghs", "Ghanese cedi" },
            { "gip", "Gibraltarees p\u00fbn" },
            { "gmd", "Gambiaanske dalasi" },
            { "gnf", "Guinese franc" },
            { "gns", "Guinese syli" },
            { "gqe", "Equatoriaal-Guinese ekwele guineana" },
            { "grd", "Grykse drachme" },
            { "gtq", "Guatemalteekse quetzal" },
            { "gwe", "Portugees-Guinese escudo" },
            { "gwp", "Guinee-Bissause peso" },
            { "gyd", "Guyaanske dollar" },
            { "hkd", "Hongkongske dollar" },
            { "hnl", "Hondurese lempira" },
            { "hrd", "Kroatyske dinar" },
            { "hrk", "Kroatyske kuna" },
            { "htg", "Ha\u00eftiaanske gourde" },
            { "huf", "Hongaarse forint" },
            { "idr", "Indonesyske roepia" },
            { "iep", "Ierske p\u00fbn" },
            { "ilp", "Isra\u00eblysk p\u00fbn" },
            { "ils", "Isra\u00eblyske nieuwe shekel" },
            { "inr", "Indiase roepie" },
            { "iqd", "Iraakse dinar" },
            { "irr", "Iraanske rial" },
            { "isk", "Ysl\u00e2nske kroon" },
            { "itl", "Italiaanske lire" },
            { "jmd", "Jamaikaanske dollar" },
            { "jod", "Jordaanske dinar" },
            { "jpy", "Japanse yen" },
            { "kes", "Keniaanske shilling" },
            { "kgs", "Kirgizyske som" },
            { "khr", "Kambodjaanske riel" },
            { "kmf", "Komorese frank" },
            { "kpw", "Noard-Koreaanske won" },
            { "krh", "S\u00fbd-Koreaanske hwan (1953\u20131962)" },
            { "kro", "Alde S\u00fbd-Koreaanske won (1945\u20131953)" },
            { "krw", "S\u00fbd-Koreaanske won" },
            { "kwd", "Koeweitse dinar" },
            { "kyd", "Caymaneil\u00e2nske dollar" },
            { "kzt", "Kazachstaanske tenge" },
            { "lak", "Laotiaanske kip" },
            { "lbp", "Libaneeske p\u00fbn" },
            { "lkr", "Sri Lankaanske roepie" },
            { "lrd", "Liberiaanske dollar" },
            { "lsl", "Lesothaanske loti" },
            { "ltl", "Litouwse litas" },
            { "ltt", "Litouwse talonas" },
            { "luc", "L\u00faksemboargske convertibele franc" },
            { "luf", "L\u00faksemboargske frank" },
            { "lul", "L\u00faksemboargske finansjele franc" },
            { "lvl", "Letse lats" },
            { "lvr", "Letse roebel" },
            { "lyd", "Libyske dinar" },
            { "mad", "Marokkaanske dirham" },
            { "maf", "Marokkaanske franc" },
            { "mcf", "Monegaskyske frank" },
            { "mdc", "Moldavyske cupon" },
            { "mdl", "Moldavyske leu" },
            { "mga", "Malagassyske ariary" },
            { "mgf", "Malagassyske franc" },
            { "mkd", "Macedonyske denar" },
            { "mkn", "Macedonyske denar (1992\u20131993)" },
            { "mlf", "Malinese franc" },
            { "mmk", "Myanmarese kyat" },
            { "mnt", "Mongoalske tugrik" },
            { "mop", "Macause pataca" },
            { "mro", "Mauritaanske ouguiya (1973\u20132017)" },
            { "mru", "Mauritaanske ouguiya" },
            { "mtl", "Maltese lire" },
            { "mtp", "Maltees p\u00fbn" },
            { "mur", "Mauritiaanske roepie" },
            { "mvr", "Maldivyske rufiyaa" },
            { "mwk", "Malawyske kwacha" },
            { "mxn", "Meksikaanske peso" },
            { "mxp", "Meksikaanske sulveren peso (1861\u20131992)" },
            { "mxv", "Meksikaanske unidad de inversion (UDI)" },
            { "myr", "Maleisyske ringgit" },
            { "mze", "Mozambikaanske escudo" },
            { "mzm", "Alde Mozambikaanske metical" },
            { "mzn", "Mozambikaanske metical" },
            { "nad", "Namibyske dollar" },
            { "ngn", "Nigeriaanske naira" },
            { "nic", "Nicaraguaanske c\u00f3rdoba (1988\u20131991)" },
            { "nio", "Nicaraguaanske c\u00f3rdoba" },
            { "nlg", "Nederl\u00e2nske g\u00fbne" },
            { "nok", "Noarske kroon" },
            { "npr", "Nepalese roepie" },
            { "nzd", "Nij-Seel\u00e2nske dollar" },
            { "omr", "Omaanske rial" },
            { "pab", "Panamese balboa" },
            { "pei", "Peruaanske inti" },
            { "pen", "Peruaanske sol" },
            { "pes", "Peruaanske sol (1863\u20131985)" },
            { "pgk", "Papuaanske kina" },
            { "php", "Filipynske peso" },
            { "pkr", "Pakistaanske roepie" },
            { "pln", "Poalske zloty" },
            { "plz", "Poalske zloty (1950\u20131995)" },
            { "pte", "Portugeeske escudo" },
            { "pyg", "Paraguayaanske guarani" },
            { "qar", "Katarese rial" },
            { "rhd", "Rhodesyske dollar" },
            { "rol", "Alde Roemeenske leu" },
            { "ron", "Roemeenske leu" },
            { "rsd", "Servyske dinar" },
            { "rub", "Russyske roebel" },
            { "rur", "Russyske roebel (1991\u20131998)" },
            { "rwf", "Rwandese frank" },
            { "sar", "Saoedi-Arabyske riyal" },
            { "sbd", "Salomon-dollar" },
            { "scr", "Seychelse roepie" },
            { "sdd", "Soedaneeske dinar" },
            { "sdg", "Soedaneeske p\u00fbn" },
            { "sdp", "Soedaneeske p\u00fbn (1957\u20131998)" },
            { "sek", "Sweedske kroon" },
            { "sgd", "Singaporese dollar" },
            { "shp", "Sint-Heleenske p\u00fbn" },
            { "sit", "Sloveenske tolar" },
            { "skk", "Slowaakse koruna" },
            { "sll", "Sierraleoonse leone" },
            { "sos", "Somalyske shilling" },
            { "srd", "Surinaamske dollar" },
            { "srg", "Surinaamske gulden" },
            { "ssp", "S\u00fbd-Soedaneeske p\u00fbn" },
            { "std", "Santomese dobra (1977\u20132017)" },
            { "stn", "Santomese dobra" },
            { "sur", "Sovjet-roebel" },
            { "svc", "Salvadoraanske col\u00f3n" },
            { "syp", "Syrysk p\u00fbn" },
            { "szl", "Swazyske lilangeni" },
            { "thb", "Thaise baht" },
            { "tjr", "Tadzjikistaanske roebel" },
            { "tjs", "Tadzjikistaanske somoni" },
            { "tmm", "Turkmeense manat (1993\u20132009)" },
            { "tmt", "Turkmeense manat" },
            { "tnd", "Tunesyske dinar" },
            { "top", "Tongaanske pa\u02bbanga" },
            { "tpe", "Timorese escudo" },
            { "trl", "Turkse lire" },
            { "try", "Turkse lira" },
            { "ttd", "Trinidad en Tobago-dollar" },
            { "twd", "Nije Taiwanese dollar" },
            { "tzs", "Tanzaniaanske shilling" },
            { "uah", "Oekra\u00efense hryvnia" },
            { "uak", "Oekra\u00efense karbovanetz" },
            { "ugs", "Oegandese shilling (1966\u20131987)" },
            { "ugx", "Oegandese shilling" },
            { "usd", "Amerikaanske dollar" },
            { "usn", "Amerikaanske dollar (folgjende dei)" },
            { "uss", "Amerikaanske dollar (zelfde dei)" },
            { "uyi", "Uruguayaanske peso en ge\u00efndexeerde eenheden" },
            { "uyp", "Uruguayaanske peso (1975\u20131993)" },
            { "uyu", "Uruguayaanske peso" },
            { "uzs", "Oezbekistaanske sum" },
            { "veb", "Fenezolaanske bolivar (1871\u20132008)" },
            { "vef", "Fenezolaanske bolivar (2008\u20132018)" },
            { "ves", "Fenezolaanske bolivar" },
            { "vnd", "Fietnameeske dong" },
            { "vnn", "Alde Fietnameeske dong (1978\u20131985)" },
            { "vuv", "Vanuatuaanske vatu" },
            { "wst", "Samoaanske tala" },
            { "xaf", "CFA-frank" },
            { "xag", "Sulver" },
            { "xau", "Goud" },
            { "xba", "Europeeske gearfoege ienheid" },
            { "xbb", "Europeeske monetaire ienheid" },
            { "xbc", "Europeeske rekkenienheid (XBC)" },
            { "xbd", "Europeeske rekkenienheid (XBD)" },
            { "xcd", "East-Karibyske dollar" },
            { "xdr", "Special Drawing Rights" },
            { "xeu", "European Currency Unit" },
            { "xfo", "Franse gouden franc" },
            { "xfu", "Franse UIC-franc" },
            { "xof", "CFA-franc BCEAO" },
            { "xpd", "Palladium" },
            { "xpf", "CFP-franc" },
            { "xpt", "Platina" },
            { "xre", "RINET-fondsen" },
            { "xsu", "Sucre" },
            { "xts", "Valutacode voor testdoeleinden" },
            { "xua", "ADB-rekkenienheid" },
            { "xxx", "Unbekende muntienheid" },
            { "ydd", "Jemenityske dinar" },
            { "yer", "Jemenityske rial" },
            { "yud", "Joegoslavyske harde dinar" },
            { "yum", "Joegoslavyske noviy-dinar" },
            { "yun", "Joegoslavyske convertibele dinar" },
            { "yur", "Joegoslavyske herfoarme dinar (1992\u20131993)" },
            { "zal", "S\u00fbd-Afrikaanske rand (finansjeel)" },
            { "zar", "S\u00fbd-Afrikaanske rand" },
            { "zmk", "Sambiaanske kwacha (1968\u20132012)" },
            { "zmw", "Sambiaanske kwacha" },
            { "zrn", "Sa\u00efreeske nije Sa\u00efre" },
            { "zrz", "Sa\u00efreeske Sa\u00efre" },
            { "zwd", "Simbabwaanske dollar" },
            { "zwl", "Simbabwaanske dollar (2009)" },
            { "zwr", "Simbabwaanske dollar (2008)" },
        };
        return data;
    }
}
