/*
 * Copyright (c) 2012, 2023, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class CurrencyNames_ko extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final Object[][] data = new Object[][] {
            { "AED", "AED" },
            { "AFN", "AFN" },
            { "ALL", "ALL" },
            { "AMD", "AMD" },
            { "ANG", "ANG" },
            { "AOA", "AOA" },
            { "ARS", "ARS" },
            { "AUD", "AU$" },
            { "AWG", "AWG" },
            { "AZN", "AZN" },
            { "BAM", "BAM" },
            { "BBD", "BBD" },
            { "BDT", "BDT" },
            { "BGN", "BGN" },
            { "BHD", "BHD" },
            { "BIF", "BIF" },
            { "BMD", "BMD" },
            { "BND", "BND" },
            { "BOB", "BOB" },
            { "BSD", "BSD" },
            { "BTN", "BTN" },
            { "BWP", "BWP" },
            { "BYN", "BYN" },
            { "BYR", "BYR" },
            { "BZD", "BZD" },
            { "CDF", "CDF" },
            { "CHF", "CHF" },
            { "CLP", "CLP" },
            { "CNH", "CNH" },
            { "COP", "COP" },
            { "CRC", "CRC" },
            { "CUC", "CUC" },
            { "CUP", "CUP" },
            { "CVE", "CVE" },
            { "CZK", "CZK" },
            { "DJF", "DJF" },
            { "DKK", "DKK" },
            { "DOP", "DOP" },
            { "DZD", "DZD" },
            { "EGP", "EGP" },
            { "ERN", "ERN" },
            { "ETB", "ETB" },
            { "FJD", "FJD" },
            { "FKP", "FKP" },
            { "GEL", "GEL" },
            { "GHS", "GHS" },
            { "GIP", "GIP" },
            { "GMD", "GMD" },
            { "GNF", "GNF" },
            { "GTQ", "GTQ" },
            { "GYD", "GYD" },
            { "HNL", "HNL" },
            { "HRK", "HRK" },
            { "HTG", "HTG" },
            { "HUF", "HUF" },
            { "IDR", "IDR" },
            { "IQD", "IQD" },
            { "IRR", "IRR" },
            { "ISK", "ISK" },
            { "JMD", "JMD" },
            { "JOD", "JOD" },
            { "KES", "KES" },
            { "KGS", "KGS" },
            { "KHR", "KHR" },
            { "KMF", "KMF" },
            { "KPW", "KPW" },
            { "KWD", "KWD" },
            { "KYD", "KYD" },
            { "KZT", "KZT" },
            { "LAK", "LAK" },
            { "LBP", "LBP" },
            { "LKR", "LKR" },
            { "LRD", "LRD" },
            { "LTL", "LTL" },
            { "LVL", "LVL" },
            { "LYD", "LYD" },
            { "MAD", "MAD" },
            { "MDL", "MDL" },
            { "MGA", "MGA" },
            { "MKD", "MKD" },
            { "MMK", "MMK" },
            { "MNT", "MNT" },
            { "MOP", "MOP" },
            { "MRO", "MRO" },
            { "MRU", "MRU" },
            { "MUR", "MUR" },
            { "MVR", "MVR" },
            { "MWK", "MWK" },
            { "MYR", "MYR" },
            { "MZN", "MZN" },
            { "NAD", "NAD" },
            { "NGN", "NGN" },
            { "NIO", "NIO" },
            { "NOK", "NOK" },
            { "NPR", "NPR" },
            { "OMR", "OMR" },
            { "PAB", "PAB" },
            { "PEN", "PEN" },
            { "PGK", "PGK" },
            { "PHP", "PHP" },
            { "PKR", "PKR" },
            { "PLN", "PLN" },
            { "PYG", "PYG" },
            { "QAR", "QAR" },
            { "RON", "RON" },
            { "RSD", "RSD" },
            { "RUB", "RUB" },
            { "RWF", "RWF" },
            { "SAR", "SAR" },
            { "SBD", "SBD" },
            { "SCR", "SCR" },
            { "SDG", "SDG" },
            { "SEK", "SEK" },
            { "SGD", "SGD" },
            { "SHP", "SHP" },
            { "SLL", "SLL" },
            { "SOS", "SOS" },
            { "SRD", "SRD" },
            { "SSP", "SSP" },
            { "STD", "STD" },
            { "STN", "STN" },
            { "SYP", "SYP" },
            { "SZL", "SZL" },
            { "THB", "THB" },
            { "TJS", "TJS" },
            { "TMT", "TMT" },
            { "TND", "TND" },
            { "TOP", "TOP" },
            { "TRY", "TRY" },
            { "TTD", "TTD" },
            { "TZS", "TZS" },
            { "UAH", "UAH" },
            { "UGX", "UGX" },
            { "UYU", "UYU" },
            { "UZS", "UZS" },
            { "VEF", "VEF" },
            { "VES", "VES" },
            { "VUV", "VUV" },
            { "WST", "WST" },
            { "YER", "YER" },
            { "ZAR", "ZAR" },
            { "ZMW", "ZMW" },
            { "adp", "\uc548\ub3c4\ub77c \ud398\uc138\ud0c0" },
            { "aed", "\uc544\ub78d\uc5d0\ubbf8\ub9ac\ud2b8 \ub514\ub974\ud568" },
            { "afa", "\uc544\ud504\uac00\ub2c8 (1927\u20132002)" },
            { "afn", "\uc544\ud504\uac00\ub2c8\uc2a4\ud0c4 \uc544\ud504\uac00\ub2c8" },
            { "all", "\uc54c\ubc14\ub2c8\uc544 \ub808\ud06c" },
            { "amd", "\uc544\ub974\uba54\ub2c8\uc544 \ub4dc\ub78c" },
            { "ang", "\ub124\ub35c\ub780\ub4dc\ub839 \uc548\ud2f8\ub808\uc2a4 \uae38\ub354" },
            { "aoa", "\uc559\uace8\ub77c \ucf74\uc790" },
            { "aok", "\uc559\uace8\ub77c \ucf74\uc790 (1977\u20131990)" },
            { "aon", "\uc559\uace8\ub77c \uc2e0\ucf74\uc790 (1990\u20132000)" },
            { "aor", "\uc559\uace8\ub77c \uc7ac\uc870\uc815 \ucf74\uc790 (1995\u20131999)" },
            { "ara", "\uc544\ub974\ud5e8\ud2f0\ub098 \uc624\uc2a4\ud2b8\ub784" },
            { "arl", "\uc544\ub974\ud5e8\ud2f0\ub098 \ud398\uc18c \ub808\uc774 (1970\u20131983)" },
            { "arm", "\uc544\ub974\ud5e8\ud2f0\ub098 \ud398\uc18c (18810\u20131970)" },
            { "arp", "\uc544\ub974\ud5e8\ud2f0\ub098 \ud398\uc18c (1983\u20131985)" },
            { "ars", "\uc544\ub974\ud5e8\ud2f0\ub098 \ud398\uc18c" },
            { "ats", "\ud638\uc8fc \uc2e4\ub9c1" },
            { "aud", "\ud638\uc8fc \ub2ec\ub7ec" },
            { "awg", "\uc544\ub8e8\ubc14 \ud50c\ub85c\ub9b0" },
            { "azm", "\uc544\uc81c\ub974\ubc14\uc774\uc820 \ub9c8\ub098\ud2b8(1993\u20132006)" },
            { "azn", "\uc544\uc81c\ub974\ubc14\uc774\uc794 \ub9c8\ub098\ud2b8" },
            { "bad", "\ubcf4\uc2a4\ub2c8\uc544-\ud5e4\ub974\uccb4\uace0\ube44\ub098 \ub514\ub098\ub974" },
            { "bam", "\ubcf4\uc2a4\ub2c8\uc544-\ud5e4\ub974\uccb4\uace0\ube44\ub098 \ud0dc\ud658 \ub9c8\ub974\ud06c" },
            { "ban", "\ubcf4\uc2a4\ub2c8\uc544-\ud5e4\ub974\uccb4\uace0\ube44\ub098 \uc2e0\ub514\ub098\ub974 (1994\u20131997)" },
            { "bbd", "\ubc14\ubca0\uc774\ub3c4\uc2a4 \ub2ec\ub7ec" },
            { "bdt", "\ubc29\uae00\ub77c\ub370\uc2dc \ud0c0\uce74" },
            { "bec", "\ubca8\uae30\uc5d0 \ud504\ub791 (\ud0dc\ud658)" },
            { "bef", "\ubca8\uae30\uc5d0 \ud504\ub791" },
            { "bel", "\ubca8\uae30\uc5d0 \ud504\ub791 (\uae08\uc735)" },
            { "bgl", "\ubd88\uac00\ub9ac\uc544 \ub3d9\uc804 \ub81b" },
            { "bgm", "\ubd88\uac00\ub9ac\uc544 \uc0ac\ud68c\uc8fc\uc758\uc790 \ub81b" },
            { "bgn", "\ubd88\uac00\ub9ac\uc544 \ub808\ud504" },
            { "bgo", "\ubd88\uac00\ub9ac\uc544 \ub81b (1879\u20131952)" },
            { "bhd", "\ubc14\ub808\uc778 \ub514\ub098\ub974" },
            { "bif", "\ubd80\ub8ec\ub514 \ud504\ub791" },
            { "bmd", "\ubc84\ubba4\ub2e4 \ub2ec\ub7ec" },
            { "bnd", "\ubd80\ub8e8\ub098\uc774 \ub2ec\ub7ec" },
            { "bob", "\ubcfc\ub9ac\ube44\uc544\ub178" },
            { "bol", "\ubcfc\ub9ac\ube44\uc544 \ubcfc\ub9ac\ube44\uc544\ub178 (1863\u20131963)" },
            { "bop", "\ubcfc\ub9ac\ube44\uc544\ub178 \ud398\uc18c" },
            { "bov", "\ubcfc\ub9ac\ube44\uc544\ub178 Mvdol(\uae30\uae08)" },
            { "brb", "\ubcfc\ub9ac\ube44\uc544\ub178 \ud06c\ub8e8\uc81c\uc774\ub8e8 \ub178\ubcf4 (1967\u20131986)" },
            { "brc", "\ube0c\ub77c\uc9c8 \ud06c\ub8e8\uc790\ub450" },
            { "bre", "\ube0c\ub77c\uc9c8 \ud06c\ub8e8\uc81c\uc774\ub8e8 (1990\u20131993)" },
            { "brl", "\ube0c\ub77c\uc9c8 \ub808\uc54c" },
            { "brn", "\ube0c\ub77c\uc9c8 \ud06c\ub8e8\uc790\ub450 \ub178\ubcf4" },
            { "brr", "\ube0c\ub77c\uc9c8 \ud06c\ub8e8\uc81c\uc774\ub8e8" },
            { "brz", "\ube0c\ub77c\uc9c8 \ud06c\ub8e8\uc81c\uc774\ub8e8 (1942\u20131967)" },
            { "bsd", "\ubc14\ud558\ub9c8 \ub2ec\ub7ec" },
            { "btn", "\ubd80\ud0c4 \ub20c\ud22c\ub214" },
            { "buk", "\ubc84\ub9c8 \ucc28\ud2b8" },
            { "bwp", "\ubcf4\uce20\uc640\ub098 \ud3f4\ub77c" },
            { "byb", "\ubca8\ub77c\ub8e8\uc2a4 \uc2e0\uad8c \ub8e8\ube14 (1994\u20131999)" },
            { "byn", "\ubca8\ub77c\ub8e8\uc2a4 \ub8e8\ube14" },
            { "byr", "\ubca8\ub77c\ub8e8\uc2a4 \ub8e8\ube14 (2000\u20132016)" },
            { "bzd", "\ubca8\ub9ac\uc988 \ub2ec\ub7ec" },
            { "cad", "\uce90\ub098\ub2e4 \ub2ec\ub7ec" },
            { "cdf", "\ucf69\uace0 \ud504\ub791 \ucf69\uace8\ub77c\uc2a4" },
            { "che", "\uc720\ub85c (WIR)" },
            { "chf", "\uc2a4\uc704\uc2a4 \ud504\ub791" },
            { "chw", "\ud504\ub791 (WIR)" },
            { "cle", "\uce60\ub808 \uc5d0\uc2a4\ucfe0\ub3c4" },
            { "clf", "\uce60\ub808 (UF)" },
            { "clp", "\uce60\ub808 \ud398\uc18c" },
            { "cnh", "\uc911\uad6d \uc704\uc548\ud654(\uc5ed\uc678)" },
            { "cny", "\uc911\uad6d \uc704\uc548\ud654" },
            { "cop", "\ucf5c\ub86c\ube44\uc544 \ud398\uc18c" },
            { "cou", "\ucf5c\ub86c\ube44\uc544 \uc2e4\uac00 \ub2e8\uc704" },
            { "crc", "\ucf54\uc2a4\ud0c0\ub9ac\uce74 \ucf5c\ub860" },
            { "csd", "\uace0 \uc138\ub974\ube44\uc544 \ub514\ub098\ub974" },
            { "csk", "\uccb4\ucf54\uc2ac\ub85c\ubc14\ud0a4\uc544 \ub3d9\uc804 \ucf54\ub8e8\ub098" },
            { "cuc", "\ucfe0\ubc14 \ud0dc\ud658 \ud398\uc18c" },
            { "cup", "\ucfe0\ubc14 \ud398\uc18c" },
            { "cve", "\uce74\ubcf4\ubca0\ub974\ub370 \uc5d0\uc2a4\ucfe0\ub3c4" },
            { "cyp", "\uc2f8\uc774\ud504\ub7ec\uc2a4 \ud30c\uc6b4\ub4dc" },
            { "czk", "\uccb4\ucf54 \uacf5\ud654\uad6d \ucf54\ub8e8\ub098" },
            { "ddm", "\ub3d9\ub3c5 \uc624\uc2a4\ud2b8\ub9c8\ub974\ud06c" },
            { "dem", "\ub3c5\uc77c \ub9c8\ub974\ud06c" },
            { "djf", "\uc9c0\ubd80\ud2f0 \ud504\ub791" },
            { "dkk", "\ub374\ub9c8\ud06c \ud06c\ub85c\ub124" },
            { "dop", "\ub3c4\ubbf8\ub2c8\uce74 \ud398\uc18c" },
            { "dzd", "\uc54c\uc81c\ub9ac \ub514\ub098\ub974" },
            { "ecs", "\uc5d0\ucfe0\uc544\ub3c4\ub974 \uc218\ud06c\ub808" },
            { "ecv", "\uc5d0\ucf70\ub3c4\ub974 (UVC)" },
            { "eek", "\uc5d0\uc2a4\ud1a0\ub2c8\uc544 \ud06c\ub8ec" },
            { "egp", "\uc774\uc9d1\ud2b8 \ud30c\uc6b4\ub4dc" },
            { "ern", "\uc5d0\ub9ac\ud2b8\ub9ac\uc544 \ub098\ud06c\ud30c" },
            { "esa", "\uc2a4\ud398\uc778 \ud398\uc138\ud0c0(\uc608\uae08)" },
            { "esb", "\uc2a4\ud398\uc778 \ud398\uc138\ud0c0(\ubcc0\ud658 \uc608\uae08)" },
            { "esp", "\uc2a4\ud398\uc778 \ud398\uc138\ud0c0" },
            { "etb", "\uc5d0\ud2f0\uc624\ud53c\uc544 \ube44\ub974" },
            { "eur", "\uc720\ub85c" },
            { "fim", "\ud540\ub780\ub4dc \ub9c8\ub974\uce74" },
            { "fjd", "\ud53c\uc9c0 \ub2ec\ub7ec" },
            { "fkp", "\ud3ec\ud074\ub79c\ub4dc\uc81c\ub3c4 \ud30c\uc6b4\ub4dc" },
            { "frf", "\ud504\ub791\uc2a4 \ud504\ub791" },
            { "gbp", "\ud30c\uc6b4\ub4dc" },
            { "gek", "\uadf8\ub8e8\uc9c0\uc57c \uc9c0\ud3d0 \ub77c\ub9ac\ud2b8" },
            { "gel", "\uc870\uc9c0\uc544 \ub77c\ub9ac" },
            { "ghc", "\uac00\ub098 \uc2dc\ub514 (1979\u20132007)" },
            { "ghs", "\uac00\ub098 \uc2dc\ub514" },
            { "gip", "\uc9c0\ube0c\ub864\ud130 \ud30c\uc6b4\ub4dc" },
            { "gmd", "\uac10\ube44\uc544 \ub2ec\ub77c\uc2dc" },
            { "gnf", "\uae30\ub2c8 \ud504\ub791" },
            { "gns", "\uae30\ub2c8 \uc2dc\ub9ac" },
            { "gqe", "\uc801\ub3c4 \uae30\ub2c8 \uc5d0\ucfe8 (Ekwele)" },
            { "grd", "\uadf8\ub9ac\uc2a4 \ub4dc\ub77c\ud06c\ub9c8" },
            { "gtq", "\uacfc\ud14c\ub9d0\ub77c \ucf00\ud2b8\uc0b4" },
            { "gwe", "\ud3ec\ub974\ud22c\uac08\ub839 \uae30\ub2c8 \uc5d0\uc2a4\ucfe0\ub3c4" },
            { "gwp", "\uae30\ub124\ube44\uc3d8 \ud398\uc18c" },
            { "gyd", "\uac00\uc774\uc544\ub098 \ub2ec\ub7ec" },
            { "hkd", "\ud64d\ucf69 \ub2ec\ub7ec" },
            { "hnl", "\uc628\ub450\ub77c\uc2a4 \ub818\ud53c\ub77c" },
            { "hrd", "\ud06c\ub85c\uc544\ud2f0\uc544 \ub514\ub098\ub974" },
            { "hrk", "\ud06c\ub85c\uc544\ud2f0\uc544 \ucfe0\ub098" },
            { "htg", "\ud558\uc774\ud2f0 \uad6c\ub974\ub4dc" },
            { "huf", "\ud5dd\uac00\ub9ac \ud3ec\ub9b0\ud2b8" },
            { "idr", "\uc778\ub3c4\ub124\uc2dc\uc544 \ub8e8\ud53c\uc544" },
            { "iep", "\uc544\uc77c\ub79c\ub4dc \ud30c\uc6b4\ub4dc" },
            { "ilp", "\uc774\uc2a4\ub77c\uc5d8 \ud30c\uc6b4\ub4dc" },
            { "ils", "\uc774\uc2a4\ub77c\uc5d8 \uc2e0\uad8c \uc138\ucf08" },
            { "inr", "\uc778\ub3c4 \ub8e8\ud53c" },
            { "iqd", "\uc774\ub77c\ud06c \ub514\ub098\ub974" },
            { "irr", "\uc774\ub780 \ub9ac\uc584" },
            { "isk", "\uc544\uc774\uc2ac\ub780\ub4dc \ud06c\ub85c\ub098" },
            { "itl", "\uc774\ud0c8\ub9ac\uc544 \ub9ac\ub77c" },
            { "jmd", "\uc790\uba54\uc774\uce74 \ub2ec\ub7ec" },
            { "jod", "\uc694\ub974\ub2e8 \ub514\ub098\ub974" },
            { "jpy", "\uc77c\ubcf8 \uc5d4\ud654" },
            { "kes", "\ucf00\ub0d0 \uc2e4\ub9c1" },
            { "kgs", "\ud0a4\ub974\uae30\uc2a4\uc2a4\ud0c4 \uc19c" },
            { "khr", "\uce84\ubcf4\ub514\uc544 \ub9ac\uc584" },
            { "kmf", "\ucf54\ubaa8\ub974 \ud504\ub791" },
            { "kpw", "\uc870\uc120 \ubbfc\uc8fc\uc8fc\uc758 \uc778\ubbfc \uacf5\ud654\uad6d \uc6d0" },
            { "krh", "\ub300\ud55c\ubbfc\uad6d \ud658 (1953\u20131962)" },
            { "krw", "\ub300\ud55c\ubbfc\uad6d \uc6d0" },
            { "kwd", "\ucfe0\uc6e8\uc774\ud2b8 \ub514\ub098\ub974" },
            { "kyd", "\ucf00\uc774\ub9e8 \uc81c\ub3c4 \ub2ec\ub7ec" },
            { "kzt", "\uce74\uc790\ud750\uc2a4\ud0c4 \ud150\uac8c" },
            { "lak", "\ub77c\uc624\uc2a4 \ud0a4\ud504" },
            { "lbp", "\ub808\ubc14\ub17c \ud30c\uc6b4\ub4dc" },
            { "lkr", "\uc2a4\ub9ac\ub791\uce74 \ub8e8\ud53c" },
            { "lrd", "\ub77c\uc774\ubca0\ub9ac\uc544 \ub2ec\ub7ec" },
            { "lsl", "\ub808\uc18c\ud1a0 \ub85c\ud2f0" },
            { "ltl", "\ub9ac\ud22c\uc544\ub2c8\uc544 \ub9ac\ud0c0" },
            { "ltt", "\ub8e9\uc148\ubd80\ub974\ud06c \ud0c0\ub85c\ub098" },
            { "luc", "\ub8e9\uc148\ubd80\ub974\ud06c \ubcc0\ud658 \ud504\ub791" },
            { "luf", "\ub8e9\uc148\ubd80\ub974\ud06c \ud504\ub791" },
            { "lul", "\ub8e9\uc148\ubd80\ub974\ud06c \uc7ac\uc815 \ud504\ub791" },
            { "lvl", "\ub77c\ud2b8\ube44\uc544 \ub77c\ud2b8" },
            { "lvr", "\ub77c\ud2b8\ube44\uc544 \ub8e8\ube14" },
            { "lyd", "\ub9ac\ube44\uc544 \ub514\ub098\ub974" },
            { "mad", "\ubaa8\ub85c\ucf54 \ub514\ub818" },
            { "maf", "\ubaa8\ub85c\ucf54 \ud504\ub791" },
            { "mcf", "\ubaa8\ub098\ucf54 \ud504\ub791" },
            { "mdc", "\ubab0\ub3c4\ubc14 \ucfe0\ud3f0" },
            { "mdl", "\ubab0\ub3c4\ubc14 \ub808\uc774" },
            { "mga", "\ub9c8\ub2e4\uac00\uc2a4\uce74\ub974 \uc544\ub9ac\uc544\ub9ac" },
            { "mgf", "\ub9c8\ub2e4\uac00\uc2a4\uce74\ub974 \ud504\ub791" },
            { "mkd", "\ub9c8\ucf00\ub3c4\ub2c8\uc544 \ub514\ub098\ub974" },
            { "mlf", "\ub9d0\ub9ac \ud504\ub791" },
            { "mmk", "\ubbf8\uc580\ub9c8 \ud0a4\uc58f" },
            { "mnt", "\ubabd\uace8 \ud22c\uadf8\ub9ad" },
            { "mop", "\ub9c8\uce74\uc624 \ud30c\ud0c0\uce74" },
            { "mro", "\ubaa8\ub9ac\ud0c0\ub2c8 \uc6b0\uae30\uc57c (1973\u20132017)" },
            { "mru", "\ubaa8\ub9ac\ud0c0\ub2c8 \uc6b0\uae30\uc57c" },
            { "mtl", "\ubab0\ud0c0 \ub9ac\ub77c" },
            { "mtp", "\ubab0\ud0c0 \ud30c\uc6b4\ub4dc" },
            { "mur", "\ubaa8\ub9ac\uc154\uc2a4 \ub8e8\ud53c" },
            { "mvr", "\ubab0\ub514\ube0c \uc81c\ub3c4 \ub8e8\ud53c\uc544" },
            { "mwk", "\ub9d0\ub77c\uc704 \ucf70\uccd0" },
            { "mxn", "\uba55\uc2dc\ucf54 \ud398\uc18c" },
            { "mxp", "\uba55\uc2dc\ucf54 \uc2e4\ubc84 \ud398\uc18c (1861\u20131992)" },
            { "mxv", "\uba55\uc2dc\ucf54 (UDI)" },
            { "myr", "\ub9d0\ub808\uc774\uc2dc\uc544 \ub9c1\uae43" },
            { "mze", "\ubaa8\uc7a0\ube44\ud06c \uc5d0\uc2a4\ucfe0\ub3c4" },
            { "mzm", "\uace0 \ubaa8\uc7a0\ube44\ud06c \uba54\ud2f0\uce7c" },
            { "mzn", "\ubaa8\uc7a0\ube44\ud06c \uba54\ud2f0\uce7c" },
            { "nad", "\ub098\ubbf8\ube44\uc544 \ub2ec\ub7ec" },
            { "ngn", "\ub2c8\uc81c\ub974 \ub098\uc774\ub77c" },
            { "nic", "\ub2c8\uce74\ub77c\uacfc \ucf54\ub974\ub3c4\ubc14" },
            { "nio", "\ub2c8\uce74\ub77c\uacfc \ucf54\ub974\ub3c4\ubc14 \uc624\ub85c" },
            { "nlg", "\ub124\ub378\ub780\ub4dc \uae38\ub354" },
            { "nok", "\ub178\ub974\uc6e8\uc774 \ud06c\ub85c\ub124" },
            { "npr", "\ub124\ud314 \ub8e8\ud53c" },
            { "nzd", "\ub274\uc9c8\ub79c\ub4dc \ub2ec\ub7ec" },
            { "omr", "\uc624\ub9cc \ub9ac\uc584" },
            { "pab", "\ud30c\ub098\ub9c8 \ubc1c\ubcf4\uc544" },
            { "pei", "\ud398\ub8e8 \uc778\ud2f0" },
            { "pen", "\ud398\ub8e8 \uc194" },
            { "pes", "\ud398\ub8e8 \uc194 (1863\u20131965)" },
            { "pgk", "\ud30c\ud478\uc544\ub274\uae30\ub2c8 \ud0a4\ub098" },
            { "php", "\ud544\ub9ac\ud540 \ud398\uc18c" },
            { "pkr", "\ud30c\ud0a4\uc2a4\ud0c4 \ub8e8\ud53c" },
            { "pln", "\ud3f4\ub780\ub4dc \uc990\ub85c\ud2f0" },
            { "plz", "\ud3f4\ub780\ub4dc \uc990\ub85c\ud2f0 (1950\u20131995)" },
            { "pte", "\ud3ec\ub974\ud22c\uac08 \uc5d0\uc2a4\ucfe0\ub3c4" },
            { "pyg", "\ud30c\ub77c\uacfc\uc774 \uacfc\ub77c\ub2c8" },
            { "qar", "\uce74\ud0c0\ub974 \ub9ac\uc584" },
            { "rhd", "\ub85c\ub514\uc9c0\uc544 \ub2ec\ub7ec" },
            { "rol", "\ub8e8\ub9c8\ub2c8\uc544 \ub808\uc774" },
            { "ron", "\ub8e8\ub9c8\ub2c8\uc544 \ub808\uc6b0" },
            { "rsd", "\uc138\ub974\ube44\uc544 \ub514\ub098\ub974" },
            { "rub", "\ub7ec\uc2dc\uc544 \ub8e8\ube14" },
            { "rur", "\ub7ec\uc2dc\uc544 \ub8e8\ube14 (1991\u20131998)" },
            { "rwf", "\ub974\uc644\ub2e4 \ud504\ub791" },
            { "sar", "\uc0ac\uc6b0\ub514\uc544\ub77c\ube44\uc544 \ub9ac\uc584" },
            { "sbd", "\uc194\ub85c\ubaac \uc81c\ub3c4 \ub2ec\ub7ec" },
            { "scr", "\uc138\uc774\uc178 \ub8e8\ud53c" },
            { "sdd", "\uc218\ub2e8 \ub514\ub098\ub974" },
            { "sdg", "\uc218\ub2e8 \ud30c\uc6b4\ub4dc" },
            { "sdp", "\uace0 \uc218\ub2e8 \ud30c\uc6b4\ub4dc" },
            { "sek", "\uc2a4\uc6e8\ub374 \ud06c\ub85c\ub098" },
            { "sgd", "\uc2f1\uac00\ud3f4 \ub2ec\ub7ec" },
            { "shp", "\uc138\uc778\ud2b8\ud5ec\ub808\ub098 \ud30c\uc6b4\ub4dc" },
            { "sit", "\uc2ac\ub85c\ubca0\ub2c8\uc544 \ud1a8\ub77c\ub974" },
            { "skk", "\uc2ac\ub85c\ubc14\ud0a4\uc544 \ucf54\ub8e8\ub098" },
            { "sll", "\uc2dc\uc5d0\ub77c\ub9ac\uc628 \ub9ac\uc628" },
            { "sos", "\uc18c\ub9d0\ub9ac\uc544 \uc2e4\ub9c1" },
            { "srd", "\uc218\ub9ac\ub0a8 \ub2ec\ub7ec" },
            { "srg", "\uc218\ub9ac\ub0a8 \uae38\ub354" },
            { "ssp", "\ub0a8\uc218\ub2e8 \ud30c\uc6b4\ub4dc" },
            { "std", "\uc0c1\ud22c\uba54 \ud504\ub9b0\uc2dc\ud398 \ub3c4\ube0c\ub77c (1977\u20132017)" },
            { "stn", "\uc0c1\ud22c\uba54 \ud504\ub9b0\uc2dc\ud398 \ub3c4\ube0c\ub77c" },
            { "sur", "\uc18c\ub828 \ub8e8\ube14" },
            { "svc", "\uc5d8\uc0b4\ubc14\ub3c4\ub974 \ucf5c\ub860" },
            { "syp", "\uc2dc\ub9ac\uc544 \ud30c\uc6b4\ub4dc" },
            { "szl", "\uc2a4\uc640\uc9c8\ub780\ub4dc \ub9b4\ub791\uac8c\ub2c8" },
            { "thb", "\ud0dc\uad6d \ubc14\ud2b8" },
            { "tjr", "\ud0c0\uc9c0\ud0a4\uc2a4\ud0c4 \ub8e8\ube14" },
            { "tjs", "\ud0c0\uc9c0\ud0a4\uc2a4\ud0c4 \uc18c\ubaa8\ub2c8" },
            { "tmm", "\ud22c\ub974\ud06c\uba54\ub2c8\uc2a4\ud0c4 \ub9c8\ub098\ud2b8 (1993\u20132009)" },
            { "tmt", "\ud22c\ub974\ud06c\uba54\ub2c8\uc2a4\ud0c4 \ub9c8\ub098\ud2b8" },
            { "tnd", "\ud280\ub2c8\uc9c0 \ub514\ub098\ub974" },
            { "top", "\ud1b5\uac00 \ud30c\uc559\uac00" },
            { "tpe", "\ud2f0\ubaa8\ub974 \uc5d0\uc2a4\ucfe0\ub3c4" },
            { "trl", "\ud130\ud0a4 \ub9ac\ub77c" },
            { "try", "\uc2e0 \ud130\ud0a4 \ub9ac\ub77c" },
            { "ttd", "\ud2b8\ub9ac\ub2c8\ub2e4\ub4dc \ud1a0\ubc14\uace0 \ub2ec\ub7ec" },
            { "twd", "\uc2e0 \ud0c0\uc774\uc644 \ub2ec\ub7ec" },
            { "tzs", "\ud0c4\uc790\ub2c8\uc544 \uc2e4\ub9c1" },
            { "uah", "\uc6b0\ud06c\ub77c\uc774\ub098 \uadf8\ub9ac\ube0c\ub098" },
            { "uak", "\uc6b0\ud06c\ub77c\uc774\ub098 \uce74\ubcf4\ubc14\ub124\uce20" },
            { "ugs", "\uc6b0\uac04\ub2e4 \uc2e4\ub9c1 (1966\u20131987)" },
            { "ugx", "\uc6b0\uac04\ub2e4 \uc2e4\ub9c1" },
            { "usd", "\ubbf8\uad6d \ub2ec\ub7ec" },
            { "usn", "\ubbf8\uad6d \ub2ec\ub7ec(\ub2e4\uc74c\ub0a0)" },
            { "uss", "\ubbf8\uad6d \ub2ec\ub7ec(\ub2f9\uc77c)" },
            { "uyi", "\uc6b0\ub8e8\uacfc\uc774 \ud398\uc18c (UI)" },
            { "uyp", "\uc6b0\ub8e8\uacfc\uc774 \ud398\uc18c (1975\u20131993)" },
            { "uyu", "\uc6b0\ub8e8\uacfc\uc774 \ud398\uc18c \uc6b0\ub8e8\uacfc\uc694" },
            { "uzs", "\uc6b0\uc988\ubca0\ud0a4\uc2a4\ud0c4 \uc228" },
            { "veb", "\ubca0\ub124\uc8fc\uc5d8\ub77c \ubcfc\ub9ac\ubc14\ub974 (1871\u20132008)" },
            { "vef", "\ubca0\ub124\uc218\uc5d8\ub77c \ubcfc\ub9ac\ubc14\ub974 (2008\u20132018)" },
            { "ves", "\ubca0\ub124\uc218\uc5d8\ub77c \ubcfc\ub9ac\ubc14\ub974" },
            { "vnd", "\ubca0\ud2b8\ub0a8 \ub3d9" },
            { "vnn", "\ubca0\ud2b8\ub0a8 \ub3d9 (1978\u20131985)" },
            { "vuv", "\ubc14\ub204\uc544\ud22c \ubc14\ud22c" },
            { "wst", "\uc11c \uc0ac\ubaa8\uc544 \ud0c8\ub77c" },
            { "xaf", "\uc911\uc559\uc544\ud504\ub9ac\uce74 CFA \ud504\ub791" },
            { "xag", "\uc740\ud654" },
            { "xau", "\uae08" },
            { "xba", "\uc720\ub974\ucf54 (\uc720\ub7fd \ud68c\uacc4 \ub2e8\uc704)" },
            { "xbb", "\uc720\ub7fd \ud1b5\ud654 \ub3d9\ub9f9" },
            { "xbc", "\uc720\ub7fd \uacc4\uc0b0 \ub2e8\uc704 (XBC)" },
            { "xbd", "\uc720\ub7fd \uacc4\uc0b0 \ub2e8\uc704 (XBD)" },
            { "xcd", "\ub3d9\uce74\ub9ac\ube0c \ub2ec\ub7ec" },
            { "xdr", "\ud2b9\ubcc4\uc778\ucd9c\uad8c" },
            { "xeu", "\uc720\ub7fd \ud658\uc728 \ub2e8\uc704" },
            { "xfo", "\ud504\ub791\uc2a4 \ud504\ub791 (Gold)" },
            { "xfu", "\ud504\ub791\uc2a4 \ud504\ub791 (UIC)" },
            { "xof", "\uc11c\uc544\ud504\ub9ac\uce74 CFA \ud504\ub791" },
            { "xpd", "\ud314\ub77c\ub4d0" },
            { "xpf", "CFP \ud504\ub791" },
            { "xpt", "\ubc31\uae08" },
            { "xre", "RINET \uae30\uae08" },
            { "xts", "\ud14c\uc2a4\ud2b8 \ud1b5\ud654 \ucf54\ub4dc" },
            { "xxx", "\uc54c \uc218 \uc5c6\ub294 \ud1b5\ud654 \ub2e8\uc704" },
            { "ydd", "\uc608\uba58 \ub514\ub098\ub974" },
            { "yer", "\uc608\uba58 \ub9ac\uc54c" },
            { "yud", "\uc720\uace0\uc2ac\ub77c\ube44\uc544 \ub3d9\uc804 \ub514\ub098\ub974" },
            { "yum", "\uc720\uace0\uc2ac\ub77c\ube44\uc544 \ub178\ube44 \ub514\ub098\ub974" },
            { "yun", "\uc720\uace0\uc2ac\ub77c\ube44\uc544 \uc804\ud658 \ub514\ub098\ub974" },
            { "zal", "\ub0a8\uc544\ud504\ub9ac\uce74 \ub79c\ub4dc (\uae08\uc735)" },
            { "zar", "\ub0a8\uc544\ud504\ub9ac\uce74 \ub79c\ub4dc" },
            { "zmk", "\uc7d8\ube44\uc544 \ucf70\uccd0 (1968\u20132012)" },
            { "zmw", "\uc7a0\ube44\uc544 \ucf70\uccd0" },
            { "zrn", "\uc790\uc774\ub974 \uc2e0\uad8c \uc790\uc774\ub974" },
            { "zrz", "\uc790\uc774\ub974 \uc790\uc774\ub974" },
            { "zwd", "\uc9d0\ubc14\ube0c\uc6e8 \ub2ec\ub7ec" },
            { "zwl", "\uc9d0\ubc14\ube0c\uc6e8 \ub2ec\ub7ec (2009)" },
            { "zwr", "\uc9d0\ubc14\ube0c\uc6e8 \ub2ec\ub7ec (2008)" },
        };
        return data;
    }
}
