/*
 * Copyright (c) 2012, 2023, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_be extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_gu = "\u0433\u0443\u0434\u0436\u0430\u0440\u0430\u0446\u0456";
        final String metaValue_kn = "\u043a\u0430\u043d\u0430\u0434\u0430";
        final String metaValue_ml = "\u043c\u0430\u043b\u0430\u044f\u043b\u0430\u043c";
        final String metaValue_or = "\u043e\u0440\u044b\u044f";
        final String metaValue_te = "\u0442\u044d\u043b\u0443\u0433\u0443";
        final Object[][] data = new Object[][] {
            { "ksh", "\u043a\u0451\u043b\u044c\u043d\u0441\u043a\u0430\u044f" },
            { "mwl", "\u043c\u0456\u0440\u0430\u043d\u0434\u044b\u0439\u0441\u043a\u0430\u044f" },
            { "Zsym", "\u0441\u0456\u043c\u0432\u0430\u043b\u044b" },
            { "Zsye", "\u044d\u043c\u043e\u0434\u0437\u0456" },
            { "ccp", "\u0447\u0430\u043a\u043c\u0430" },
            { "egy", "\u0441\u0442\u0430\u0440\u0430\u0436\u044b\u0442\u043d\u0430\u0435\u0433\u0456\u043f\u0435\u0446\u043a\u0430\u044f" },
            { "raj", "\u0440\u0430\u0434\u0436\u0430\u0441\u0442\u0445\u0430\u043d\u0441\u043a\u0430\u044f" },
            { "tem", "\u0442\u044d\u043c\u043d\u044d" },
            { "teo", "\u0442\u044d\u0441\u043e" },
            { "rap", "\u0440\u0430\u043f\u0430\u043d\u0443\u0456" },
            { "AC", "\u0412\u043e\u0441\u0442\u0440\u0430\u045e \u0423\u0437\u043d\u044f\u0441\u0435\u043d\u043d\u044f" },
            { "rar", "\u0440\u0430\u0440\u0430\u0442\u043e\u043d\u0433" },
            { "tet", "\u0442\u044d\u0442\u0443\u043c" },
            { "AD", "\u0410\u043d\u0434\u043e\u0440\u0430" },
            { "AE", "\u0410\u0431\u2019\u044f\u0434\u043d\u0430\u043d\u044b\u044f \u0410\u0440\u0430\u0431\u0441\u043a\u0456\u044f \u042d\u043c\u0456\u0440\u0430\u0442\u044b" },
            { "nl_BE", "\u0444\u043b\u0430\u043c\u0430\u043d\u0434\u0441\u043a\u0430\u044f" },
            { "AF", "\u0410\u0444\u0433\u0430\u043d\u0456\u0441\u0442\u0430\u043d" },
            { "AG", "\u0410\u043d\u0442\u044b\u0433\u0443\u0430 \u0456 \u0411\u0430\u0440\u0431\u0443\u0434\u0430" },
            { "type.ca.ethiopic", "\u044d\u0444\u0456\u043e\u043f\u0441\u043a\u0456 \u043a\u0430\u043b\u044f\u043d\u0434\u0430\u0440" },
            { "AI", "\u0410\u043d\u0433\u0456\u043b\u044c\u044f" },
            { "AL", "\u0410\u043b\u0431\u0430\u043d\u0456\u044f" },
            { "AM", "\u0410\u0440\u043c\u0435\u043d\u0456\u044f" },
            { "AO", "\u0410\u043d\u0433\u043e\u043b\u0430" },
            { "AQ", "\u0410\u043d\u0442\u0430\u0440\u043a\u0442\u044b\u043a\u0430" },
            { "AR", "\u0410\u0440\u0433\u0435\u043d\u0446\u0456\u043d\u0430" },
            { "AS", "\u0410\u043c\u0435\u0440\u044b\u043a\u0430\u043d\u0441\u043a\u0430\u0435 \u0421\u0430\u043c\u043e\u0430" },
            { "AT", "\u0410\u045e\u0441\u0442\u0440\u044b\u044f" },
            { "AU", "\u0410\u045e\u0441\u0442\u0440\u0430\u043b\u0456\u044f" },
            { "AW", "\u0410\u0440\u0443\u0431\u0430" },
            { "en_US", "\u0430\u043c\u0435\u0440\u044b\u043a\u0430\u043d\u0441\u043a\u0430\u044f \u0430\u043d\u0433\u043b\u0456\u0439\u0441\u043a\u0430\u044f" },
            { "AX", "\u0410\u043b\u0430\u043d\u0434\u0441\u043a\u0456\u044f \u0430\u0441\u0442\u0440\u0430\u0432\u044b" },
            { "AZ", "\u0410\u0437\u0435\u0440\u0431\u0430\u0439\u0434\u0436\u0430\u043d" },
            { "BA", "\u0411\u043e\u0441\u043d\u0456\u044f \u0456 \u0413\u0435\u0440\u0446\u0430\u0433\u0430\u0432\u0456\u043d\u0430" },
            { "BB", "\u0411\u0430\u0440\u0431\u0430\u0434\u0430\u0441" },
            { "ceb", "\u0441\u0435\u0431\u0443\u0430\u043d\u0430" },
            { "BD", "\u0411\u0430\u043d\u0433\u043b\u0430\u0434\u044d\u0448" },
            { "kum", "\u043a\u0443\u043c\u044b\u0446\u043a\u0430\u044f" },
            { "BE", "\u0411\u0435\u043b\u044c\u0433\u0456\u044f" },
            { "BF", "\u0411\u0443\u0440\u043a\u0456\u043d\u0430-\u0424\u0430\u0441\u043e" },
            { "BG", "\u0411\u0430\u043b\u0433\u0430\u0440\u044b\u044f" },
            { "BH", "\u0411\u0430\u0445\u0440\u044d\u0439\u043d" },
            { "BI", "\u0411\u0443\u0440\u0443\u043d\u0434\u0437\u0456" },
            { "BJ", "\u0411\u0435\u043d\u0456\u043d" },
            { "BL", "\u0421\u0435\u043d-\u0411\u0430\u0440\u0442\u044d\u043b\u044c\u043c\u0456" },
            { "BM", "\u0411\u0435\u0440\u043c\u0443\u0434\u0441\u043a\u0456\u044f \u0430\u0441\u0442\u0440\u0430\u0432\u044b" },
            { "myv", "\u044d\u0440\u0437\u044f\u043d\u0441\u043a\u0430\u044f" },
            { "BN", "\u0411\u0440\u0443\u043d\u0435\u0439" },
            { "BO", "\u0411\u0430\u043b\u0456\u0432\u0456\u044f" },
            { "BQ", "\u041a\u0430\u0440\u044b\u0431\u0441\u043a\u0456\u044f \u041d\u0456\u0434\u044d\u0440\u043b\u0430\u043d\u0434\u044b" },
            { "BR", "\u0411\u0440\u0430\u0437\u0456\u043b\u0456\u044f" },
            { "BS", "\u0411\u0430\u0433\u0430\u043c\u0441\u043a\u0456\u044f \u0430\u0441\u0442\u0440\u0430\u0432\u044b" },
            { "xog", "\u0441\u043e\u0433\u0430" },
            { "BT", "\u0411\u0443\u0442\u0430\u043d" },
            { "BV", "\u0412\u043e\u0441\u0442\u0440\u0430\u045e \u0411\u0443\u0432\u044d" },
            { "BW", "\u0411\u0430\u0442\u0441\u0432\u0430\u043d\u0430" },
            { "BY", "\u0411\u0435\u043b\u0430\u0440\u0443\u0441\u044c" },
            { "BZ", "\u0411\u0435\u043b\u0456\u0437" },
            { "type.ca.persian", "\u043f\u0435\u0440\u0441\u0456\u0434\u0441\u043a\u0456 \u043a\u0430\u043b\u044f\u043d\u0434\u0430\u0440" },
            { "type.nu.hebr", "\u044f\u045e\u0440\u044d\u0439\u0441\u043a\u0456\u044f \u043b\u0456\u0447\u0431\u044b" },
            { "CA", "\u041a\u0430\u043d\u0430\u0434\u0430" },
            { "CC", "\u041a\u0430\u043a\u043e\u0441\u0430\u0432\u044b\u044f (\u041a\u0456\u043b\u0456\u043d\u0433) \u0430\u0441\u0442\u0440\u0430\u0432\u044b" },
            { "mzn", "\u043c\u0430\u0437\u0430\u043d\u0434\u044d\u0440\u0430\u043d\u0441\u043a\u0430\u044f" },
            { "CD", "\u041a\u043e\u043d\u0433\u0430 (\u041a\u0456\u043d\u0448\u0430\u0441\u0430)" },
            { "CF", "\u0426\u044d\u043d\u0442\u0440\u0430\u043b\u044c\u043d\u0430-\u0410\u0444\u0440\u044b\u043a\u0430\u043d\u0441\u043a\u0430\u044f \u0420\u044d\u0441\u043f\u0443\u0431\u043b\u0456\u043a\u0430" },
            { "CG", "\u041a\u043e\u043d\u0433\u0430 - \u0411\u0440\u0430\u0437\u0430\u0432\u0456\u043b\u044c" },
            { "CH", "\u0428\u0432\u0435\u0439\u0446\u0430\u0440\u044b\u044f" },
            { "CI", "\u041a\u043e\u0442-\u0434\u2019\u0406\u0432\u0443\u0430\u0440" },
            { "CK", "\u0410\u0441\u0442\u0440\u0430\u0432\u044b \u041a\u0443\u043a\u0430" },
            { "CL", "\u0427\u044b\u043b\u0456" },
            { "CM", "\u041a\u0430\u043c\u0435\u0440\u0443\u043d" },
            { "CN", "\u041a\u0456\u0442\u0430\u0439" },
            { "CO", "\u041a\u0430\u043b\u0443\u043c\u0431\u0456\u044f" },
            { "CP", "\u0412\u043e\u0441\u0442\u0440\u0430\u045e \u041a\u043b\u0456\u043f\u0435\u0440\u0442\u0430\u043d" },
            { "CR", "\u041a\u043e\u0441\u0442\u0430-\u0420\u044b\u043a\u0430" },
            { "CU", "\u041a\u0443\u0431\u0430" },
            { "CV", "\u041a\u0430\u0431\u0430-\u0412\u0435\u0440\u0434\u044d" },
            { "CW", "\u041a\u044e\u0440\u0430\u0441\u0430\u0430" },
            { "CX", "\u0412\u043e\u0441\u0442\u0440\u0430\u045e \u041a\u0430\u043b\u044f\u0434" },
            { "CY", "\u041a\u0456\u043f\u0440" },
            { "CZ", "\u0427\u044d\u0445\u0456\u044f" },
            { "eka", "\u044d\u043a\u0430\u0434\u0436\u0443\u043a" },
            { "DE", "\u0413\u0435\u0440\u043c\u0430\u043d\u0456\u044f" },
            { "ace", "\u0430\u0447\u044d\u0445" },
            { "cgg", "\u0447\u044b\u0433\u0430" },
            { "DG", "\u0412\u043e\u0441\u0442\u0440\u0430\u045e \u0414\u044b\u0435\u0433\u0430-\u0413\u0430\u0440\u0441\u0456\u044f" },
            { "type.nu.deva", "\u043b\u0456\u0447\u0431\u044b \u0434\u044d\u0432\u0430\u043d\u0430\u0433\u0430\u0440\u044b" },
            { "DJ", "\u0414\u0436\u044b\u0431\u0443\u0446\u0456" },
            { "DK", "\u0414\u0430\u043d\u0456\u044f" },
            { "Brai", "\u0448\u0440\u044b\u0444\u0442 \u0411\u0440\u0430\u0439\u043b\u044f" },
            { "DM", "\u0414\u0430\u043c\u0456\u043d\u0456\u043a\u0430" },
            { "type.nu.armnlow", "\u0430\u0440\u043c\u044f\u043d\u0441\u043a\u0456\u044f \u043b\u0456\u0447\u0431\u044b \u045e \u043d\u0456\u0436\u043d\u0456\u043c \u0440\u044d\u0433\u0456\u0441\u0442\u0440\u044b" },
            { "DO", "\u0414\u0430\u043c\u0456\u043d\u0456\u043a\u0430\u043d\u0441\u043a\u0430\u044f \u0420\u044d\u0441\u043f\u0443\u0431\u043b\u0456\u043a\u0430" },
            { "gor", "\u0433\u0430\u0440\u0430\u043d\u0442\u0430\u043b\u0430" },
            { "zun", "\u0437\u0443\u043d\u0456" },
            { "tig", "\u0442\u044b\u0433\u0440\u044d" },
            { "DZ", "\u0410\u043b\u0436\u044b\u0440" },
            { "pag", "\u043f\u0430\u043d\u0433\u0430\u0441\u0456\u043d\u0430\u043d" },
            { "EA", "\u0421\u0435\u0443\u0442\u0430 \u0456 \u041c\u0435\u043b\u0456\u043b\u044c\u044f" },
            { "chb", "\u0447\u044b\u0431\u0447\u0430" },
            { "pam", "\u043f\u0430\u043c\u043f\u0430\u043d\u0433\u0430" },
            { "EC", "\u042d\u043a\u0432\u0430\u0434\u043e\u0440" },
            { "pap", "\u043f\u0430\u043f\u2019\u044f\u043c\u0435\u043d\u0442\u0443" },
            { "ada", "\u0430\u0434\u0430\u043d\u0433\u043c\u044d" },
            { "EE", "\u042d\u0441\u0442\u043e\u043d\u0456\u044f" },
            { "EG", "\u0415\u0433\u0456\u043f\u0435\u0442" },
            { "EH", "\u0417\u0430\u0445\u043e\u0434\u043d\u044f\u044f \u0421\u0430\u0445\u0430\u0440\u0430" },
            { "pau", "\u043f\u0430\u043b\u0430\u0443" },
            { "chk", "\u0447\u0443\u0443\u043a" },
            { "chm", "\u043c\u0430\u0440\u044b" },
            { "cho", "\u0447\u043e\u043a\u0442\u0430" },
            { "chr", "\u0447\u044d\u0440\u043e\u043a\u0456" },
            { "ER", "\u042d\u0440\u044b\u0442\u0440\u044d\u044f" },
            { "ES", "\u0406\u0441\u043f\u0430\u043d\u0456\u044f" },
            { "ET", "\u042d\u0444\u0456\u043e\u043f\u0456\u044f" },
            { "EU", "\u0415\u045e\u0440\u0430\u043f\u0435\u0439\u0441\u043a\u0456 \u0441\u0430\u044e\u0437" },
            { "type.ca.gregorian", "\u0433\u0440\u044b\u0433\u0430\u0440\u044b\u044f\u043d\u0441\u043a\u0456 \u043a\u0430\u043b\u044f\u043d\u0434\u0430\u0440" },
            { "EZ", "\u0415\u045e\u0440\u0430\u0437\u043e\u043d\u0430" },
            { "chy", "\u0448\u044d\u0439\u0435\u043d" },
            { "type.nu.gujr", "\u043b\u0456\u0447\u0431\u044b \u0433\u0443\u0434\u0436\u0430\u0440\u0430\u0446\u0456" },
            { "ady", "\u0430\u0434\u044b\u0433\u0435\u0439\u0441\u043a\u0430\u044f" },
            { "FI", "\u0424\u0456\u043d\u043b\u044f\u043d\u0434\u044b\u044f" },
            { "FJ", "\u0424\u0456\u0434\u0436\u044b" },
            { "FK", "\u0424\u0430\u043b\u043a\u043b\u0435\u043d\u0434\u0441\u043a\u0456\u044f \u0430\u0441\u0442\u0440\u0430\u0432\u044b" },
            { "FM", "\u041c\u0456\u043a\u0440\u0430\u043d\u0435\u0437\u0456\u044f" },
            { "FO", "\u0424\u0430\u0440\u044d\u0440\u0441\u043a\u0456\u044f \u0430\u0441\u0442\u0440\u0430\u0432\u044b" },
            { "Taml", "\u0442\u0430\u043c\u0456\u043b\u044c\u0441\u043a\u0430\u0435" },
            { "FR", "\u0424\u0440\u0430\u043d\u0446\u044b\u044f" },
            { "root", "\u043a\u043e\u0440\u0430\u043d\u044c" },
            { "grc", "\u0441\u0442\u0430\u0440\u0430\u0436\u044b\u0442\u043d\u0430\u0433\u0440\u044d\u0447\u0430\u0441\u043a\u0430\u044f" },
            { "GA", "\u0413\u0430\u0431\u043e\u043d" },
            { "GB", "\u0412\u044f\u043b\u0456\u043a\u0430\u0431\u0440\u044b\u0442\u0430\u043d\u0456\u044f" },
            { "pcm", "\u043d\u0456\u0433\u0435\u0440\u044b\u0439\u0441\u043a\u0456 \u043f\u0456\u0434\u0436\u044b\u043d" },
            { "GD", "\u0413\u0440\u044d\u043d\u0430\u0434\u0430" },
            { "GE", "\u0413\u0440\u0443\u0437\u0456\u044f" },
            { "GF", "\u0424\u0440\u0430\u043d\u0446\u0443\u0437\u0441\u043a\u0430\u044f \u0413\u0432\u0456\u044f\u043d\u0430" },
            { "GG", "\u0413\u0435\u0440\u043d\u0441\u0456" },
            { "GH", "\u0413\u0430\u043d\u0430" },
            { "GI", "\u0413\u0456\u0431\u0440\u0430\u043b\u0442\u0430\u0440" },
            { "GL", "\u0413\u0440\u044d\u043d\u043b\u0430\u043d\u0434\u044b\u044f" },
            { "GM", "\u0413\u0430\u043c\u0431\u0456\u044f" },
            { "GN", "\u0413\u0432\u0456\u043d\u0435\u044f" },
            { "GP", "\u0413\u0432\u0430\u0434\u044d\u043b\u0443\u043f\u0430" },
            { "GQ", "\u042d\u043a\u0432\u0430\u0442\u0430\u0440\u044b\u044f\u043b\u044c\u043d\u0430\u044f \u0413\u0432\u0456\u043d\u0435\u044f" },
            { "GR", "\u0413\u0440\u044d\u0446\u044b\u044f" },
            { "GS", "\u041f\u0430\u045e\u0434\u043d\u0451\u0432\u0430\u044f \u0413\u0435\u043e\u0440\u0433\u0456\u044f \u0456 \u041f\u0430\u045e\u0434\u043d\u0451\u0432\u044b\u044f \u0421\u0430\u043d\u0434\u0432\u0456\u0447\u0430\u0432\u044b \u0430\u0441\u0442\u0440\u0430\u0432\u044b" },
            { "GT", "\u0413\u0432\u0430\u0442\u044d\u043c\u0430\u043b\u0430" },
            { "GU", "\u0413\u0443\u0430\u043c" },
            { "GW", "\u0413\u0432\u0456\u043d\u0435\u044f-\u0411\u0456\u0441\u0430\u0443" },
            { "tlh", "\u043a\u043b\u0456\u043d\u0433\u0430\u043d" },
            { "GY", "\u0413\u0430\u044f\u043d\u0430" },
            { "ckb", "\u0446\u044d\u043d\u0442\u0440\u0430\u043b\u044c\u043d\u0430\u043a\u0443\u0440\u0434\u0441\u043a\u0430\u044f" },
            { "zxx", "\u043d\u044f\u043c\u0430 \u043c\u043e\u045e\u043d\u0430\u0433\u0430 \u043c\u0430\u0442\u044d\u0440\u044b\u044f\u043b\u0443" },
            { "de_AT", "\u0430\u045e\u0441\u0442\u0440\u044b\u0439\u0441\u043a\u0430\u044f \u043d\u044f\u043c\u0435\u0446\u043a\u0430\u044f" },
            { "HK", "\u0413\u0430\u043d\u043a\u043e\u043d\u0433, \u0421\u0410\u0420 (\u041a\u0456\u0442\u0430\u0439)" },
            { "HM", "\u0410\u0441\u0442\u0440\u0430\u0432\u044b \u0425\u0435\u0440\u0434 \u0456 \u041c\u0430\u043a\u0434\u043e\u043d\u0430\u043b\u044c\u0434" },
            { "HN", "\u0413\u0430\u043d\u0434\u0443\u0440\u0430\u0441" },
            { "HR", "\u0425\u0430\u0440\u0432\u0430\u0442\u044b\u044f" },
            { "agq", "\u0430\u0433\u0435\u043c" },
            { "gsw", "\u0448\u0432\u0435\u0439\u0446\u0430\u0440\u0441\u043a\u0430\u044f \u043d\u044f\u043c\u0435\u0446\u043a\u0430\u044f" },
            { "HT", "\u0413\u0430\u0456\u0446\u0456" },
            { "HU", "\u0412\u0435\u043d\u0433\u0440\u044b\u044f" },
            { "IC", "\u041a\u0430\u043d\u0430\u0440\u0441\u043a\u0456\u044f \u0430\u0441\u0442\u0440\u0430\u0432\u044b" },
            { "ID", "\u0406\u043d\u0434\u0430\u043d\u0435\u0437\u0456\u044f" },
            { "peo", "\u0441\u0442\u0430\u0440\u0430\u043f\u0435\u0440\u0441\u0456\u0434\u0441\u043a\u0430\u044f" },
            { "IE", "\u0406\u0440\u043b\u0430\u043d\u0434\u044b\u044f" },
            { "nap", "\u043d\u0435\u0430\u043f\u0430\u043b\u0456\u0442\u0430\u043d\u0441\u043a\u0430\u044f" },
            { "naq", "\u043d\u0430\u043c\u0430" },
            { "zza", "\u0437\u0430\u0437\u0430\u043a\u0456" },
            { "IL", "\u0406\u0437\u0440\u0430\u0456\u043b\u044c" },
            { "IM", "\u0412\u043e\u0441\u0442\u0440\u0430\u045e \u041c\u044d\u043d" },
            { "IN", "\u0406\u043d\u0434\u044b\u044f" },
            { "IO", "\u0411\u0440\u044b\u0442\u0430\u043d\u0441\u043a\u0430\u044f \u0442\u044d\u0440\u044b\u0442\u043e\u0440\u044b\u044f \u045e \u0406\u043d\u0434\u044b\u0439\u0441\u043a\u0456\u043c \u0430\u043a\u0456\u044f\u043d\u0435" },
            { "IQ", "\u0406\u0440\u0430\u043a" },
            { "IR", "\u0406\u0440\u0430\u043d" },
            { "IS", "\u0406\u0441\u043b\u0430\u043d\u0434\u044b\u044f" },
            { "IT", "\u0406\u0442\u0430\u043b\u0456\u044f" },
            { "Zmth", "\u043c\u0430\u0442\u044d\u043c\u0430\u0442\u044b\u0447\u043d\u044b\u044f \u0437\u043d\u0430\u043a\u0456" },
            { "type.nu.thai", "\u0442\u0430\u0439\u0441\u043a\u0456\u044f \u043b\u0456\u0447\u0431\u044b" },
            { "type.nu.beng", "\u0431\u0435\u043d\u0433\u0430\u043b\u044c\u0441\u043a\u0456\u044f \u043b\u0456\u0447\u0431\u044b" },
            { "JE", "\u0414\u0436\u044d\u0440\u0441\u0456" },
            { "type.ca.islamic", "\u043c\u0443\u0441\u0443\u043b\u044c\u043c\u0430\u043d\u0441\u043a\u0456 \u043a\u0430\u043b\u044f\u043d\u0434\u0430\u0440" },
            { "JM", "\u042f\u043c\u0430\u0439\u043a\u0430" },
            { "Beng", "\u0431\u0435\u043d\u0433\u0430\u043b\u044c\u0441\u043a\u0430\u0435" },
            { "JO", "\u0406\u0430\u0440\u0434\u0430\u043d\u0456\u044f" },
            { "JP", "\u042f\u043f\u043e\u043d\u0456\u044f" },
            { "ain", "\u0430\u0439\u043d\u0441\u043a\u0430\u044f" },
            { "guz", "\u0433\u0443\u0441\u0456\u0456" },
            { "type.nu.knda", "\u043b\u0456\u0447\u0431\u044b \u043a\u0430\u043d\u0430\u0434\u0430" },
            { "de_CH", "\u0448\u0432\u0435\u0439\u0446\u0430\u0440\u0441\u043a\u0430\u044f \u043b\u0456\u0442\u0430\u0440\u0430\u0442\u0443\u0440\u043d\u0430\u044f \u043d\u044f\u043c\u0435\u0446\u043a\u0430\u044f" },
            { "type.ca.buddhist", "\u0431\u0443\u0434\u044b\u0439\u0441\u043a\u0456 \u043a\u0430\u043b\u044f\u043d\u0434\u0430\u0440" },
            { "KE", "\u041a\u0435\u043d\u0456\u044f" },
            { "419", "\u041b\u0430\u0446\u0456\u043d\u0441\u043a\u0430\u044f \u0410\u043c\u0435\u0440\u044b\u043a\u0430" },
            { "KG", "\u041a\u044b\u0440\u0433\u044b\u0437\u0441\u0442\u0430\u043d" },
            { "KH", "\u041a\u0430\u043c\u0431\u043e\u0434\u0436\u0430" },
            { "KI", "\u041a\u0456\u0440\u044b\u0431\u0430\u0446\u0456" },
            { "KM", "\u041a\u0430\u043c\u043e\u0440\u0441\u043a\u0456\u044f \u0430\u0441\u0442\u0440\u0430\u0432\u044b" },
            { "Knda", metaValue_kn },
            { "KN", "\u0421\u0435\u043d\u0442-\u041a\u0456\u0442\u0441 \u0456 \u041d\u0435\u0432\u0456\u0441" },
            { "fr_CA", "\u043a\u0430\u043d\u0430\u0434\u0441\u043a\u0430\u044f \u0444\u0440\u0430\u043d\u0446\u0443\u0437\u0441\u043a\u0430\u044f" },
            { "KP", "\u041f\u0430\u045e\u043d\u043e\u0447\u043d\u0430\u044f \u041a\u0430\u0440\u044d\u044f" },
            { "KR", "\u041f\u0430\u045e\u0434\u043d\u0451\u0432\u0430\u044f \u041a\u0430\u0440\u044d\u044f" },
            { "fr_CH", "\u0448\u0432\u0435\u0439\u0446\u0430\u0440\u0441\u043a\u0430\u044f \u0444\u0440\u0430\u043d\u0446\u0443\u0437\u0441\u043a\u0430\u044f" },
            { "KW", "\u041a\u0443\u0432\u0435\u0439\u0442" },
            { "tpi", "\u0442\u043e\u043a-\u043f\u0456\u0441\u0456\u043d" },
            { "KY", "\u041a\u0430\u0439\u043c\u0430\u043d\u0430\u0432\u044b \u0430\u0441\u0442\u0440\u0430\u0432\u044b" },
            { "KZ", "\u041a\u0430\u0437\u0430\u0445\u0441\u0442\u0430\u043d" },
            { "Cyrl", "\u043a\u0456\u0440\u044b\u043b\u0456\u0446\u0430" },
            { "LA", "\u041b\u0430\u043e\u0441" },
            { "LB", "\u041b\u0456\u0432\u0430\u043d" },
            { "LC", "\u0421\u0435\u043d\u0442-\u041b\u044e\u0441\u0456\u044f" },
            { "phn", "\u0444\u0456\u043d\u0456\u043a\u0456\u0439\u0441\u043a\u0430\u044f" },
            { "gwi", "\u0433\u0443\u0456\u0447\u2019\u0456\u043d" },
            { "nds", "\u043d\u0456\u0436\u043d\u0435\u043d\u044f\u043c\u0435\u0446\u043a\u0430\u044f" },
            { "LI", "\u041b\u0456\u0445\u0442\u044d\u043d\u0448\u0442\u044d\u0439\u043d" },
            { "LK", "\u0428\u0440\u044b-\u041b\u0430\u043d\u043a\u0430" },
            { "akk", "\u0430\u043a\u0430\u0434\u0441\u043a\u0430\u044f" },
            { "cop", "\u043a\u043e\u043f\u0446\u043a\u0430\u044f" },
            { "LR", "\u041b\u0456\u0431\u0435\u0440\u044b\u044f" },
            { "LS", "\u041b\u0435\u0441\u043e\u0442\u0430" },
            { "LT", "\u041b\u0456\u0442\u0432\u0430" },
            { "LU", "\u041b\u044e\u043a\u0441\u0435\u043c\u0431\u0443\u0440\u0433" },
            { "LV", "\u041b\u0430\u0442\u0432\u0456\u044f" },
            { "Kana", "\u043a\u0430\u0442\u0430\u043a\u0430\u043d\u0430" },
            { "LY", "\u041b\u0456\u0432\u0456\u044f" },
            { "lad", "\u043b\u0430\u0434\u044b\u043d\u0430" },
            { "vun", "\u0432\u0443\u043d\u0434\u0436\u043e" },
            { "lag", "\u043b\u0430\u043d\u0433\u0456" },
            { "Thaa", "\u0442\u0430\u043d\u0430" },
            { "MA", "\u041c\u0430\u0440\u043e\u043a\u0430" },
            { "MC", "\u041c\u0430\u043d\u0430\u043a\u0430" },
            { "MD", "\u041c\u0430\u043b\u0434\u043e\u0432\u0430" },
            { "ME", "\u0427\u0430\u0440\u043d\u0430\u0433\u043e\u0440\u044b\u044f" },
            { "MF", "\u0421\u0435\u043d-\u041c\u0430\u0440\u0442\u044d\u043d" },
            { "MG", "\u041c\u0430\u0434\u0430\u0433\u0430\u0441\u043a\u0430\u0440" },
            { "MH", "\u041c\u0430\u0440\u0448\u0430\u043b\u0430\u0432\u044b \u0430\u0441\u0442\u0440\u0430\u0432\u044b" },
            { "ale", "\u0430\u043b\u0435\u0443\u0446\u043a\u0430\u044f" },
            { "Thai", "\u0442\u0430\u0439\u0441\u043a\u0430\u0435" },
            { "MK", "\u041f\u0430\u045e\u043d\u043e\u0447\u043d\u0430\u044f \u041c\u0430\u043a\u0435\u0434\u043e\u043d\u0456\u044f" },
            { "ML", "\u041c\u0430\u043b\u0456" },
            { "MM", "\u041c\u2019\u044f\u043d\u043c\u0430 (\u0411\u0456\u0440\u043c\u0430)" },
            { "MN", "\u041c\u0430\u043d\u0433\u043e\u043b\u0456\u044f" },
            { "new", "\u043d\u0435\u045e\u0430\u0440\u044b" },
            { "MO", "\u041c\u0430\u043a\u0430\u0430, \u0421\u0410\u0420 (\u041a\u0456\u0442\u0430\u0439)" },
            { "MP", "\u041f\u0430\u045e\u043d\u043e\u0447\u043d\u044b\u044f \u041c\u0430\u0440\u044b\u044f\u043d\u0441\u043a\u0456\u044f \u0430\u0441\u0442\u0440\u0430\u0432\u044b" },
            { "MQ", "\u041c\u0430\u0440\u0446\u0456\u043d\u0456\u043a\u0430" },
            { "MR", "\u041c\u0430\u045e\u0440\u044b\u0442\u0430\u043d\u0456\u044f" },
            { "MS", "\u041c\u0430\u043d\u0442\u0441\u0435\u0440\u0430\u0442" },
            { "MT", "\u041c\u0430\u043b\u044c\u0442\u0430" },
            { "MU", "\u041c\u0430\u045e\u0440\u044b\u043a\u0456\u0439" },
            { "alt", "\u043f\u0430\u045e\u0434\u043d\u0451\u0432\u0430\u0430\u043b\u0442\u0430\u0439\u0441\u043a\u0430\u044f" },
            { "MV", "\u041c\u0430\u043b\u044c\u0434\u044b\u0432\u044b" },
            { "MW", "\u041c\u0430\u043b\u0430\u0432\u0456" },
            { "MX", "\u041c\u0435\u043a\u0441\u0456\u043a\u0430" },
            { "type.ca.japanese", "\u044f\u043f\u043e\u043d\u0441\u043a\u0456 \u043a\u0430\u043b\u044f\u043d\u0434\u0430\u0440" },
            { "MY", "\u041c\u0430\u043b\u0430\u0439\u0437\u0456\u044f" },
            { "MZ", "\u041c\u0430\u0437\u0430\u043c\u0431\u0456\u043a" },
            { "NA", "\u041d\u0430\u043c\u0456\u0431\u0456\u044f" },
            { "202", "\u0422\u0440\u0430\u043f\u0456\u0447\u043d\u0430\u044f \u0410\u0444\u0440\u044b\u043a\u0430" },
            { "type.ca.hebrew", "\u044f\u045e\u0440\u044d\u0439\u0441\u043a\u0456 \u043a\u0430\u043b\u044f\u043d\u0434\u0430\u0440" },
            { "NC", "\u041d\u043e\u0432\u0430\u044f \u041a\u0430\u043b\u0435\u0434\u043e\u043d\u0456\u044f" },
            { "NE", "\u041d\u0456\u0433\u0435\u0440" },
            { "NF", "\u0412\u043e\u0441\u0442\u0440\u0430\u045e \u041d\u043e\u0440\u0444\u0430\u043b\u043a" },
            { "NG", "\u041d\u0456\u0433\u0435\u0440\u044b\u044f" },
            { "trv", "\u0442\u0430\u0440\u043e\u043a\u0430" },
            { "NI", "\u041d\u0456\u043a\u0430\u0440\u0430\u0433\u0443\u0430" },
            { "NL", "\u041d\u0456\u0434\u044d\u0440\u043b\u0430\u043d\u0434\u044b" },
            { "NO", "\u041d\u0430\u0440\u0432\u0435\u0433\u0456\u044f" },
            { "NP", "\u041d\u0435\u043f\u0430\u043b" },
            { "NR", "\u041d\u0430\u0443\u0440\u0443" },
            { "NU", "\u041d\u0456\u0443\u044d" },
            { "rof", "\u0440\u043e\u043c\u0431\u0430" },
            { "NZ", "\u041d\u043e\u0432\u0430\u044f \u0417\u0435\u043b\u0430\u043d\u0434\u044b\u044f" },
            { "ang", "\u0441\u0442\u0430\u0440\u0430\u0430\u043d\u0433\u043b\u0456\u0439\u0441\u043a\u0430\u044f" },
            { "OM", "\u0410\u043c\u0430\u043d" },
            { "anp", "\u0430\u043d\u0433\u0456\u043a\u0430" },
            { "crs", "\u0441\u044d\u0441\u044d\u043b\u044c\u0432\u0430" },
            { "PA", "\u041f\u0430\u043d\u0430\u043c\u0430" },
            { "type.ca.islamic-civil", "\u043c\u0443\u0441\u0443\u043b\u044c\u043c\u0430\u043d\u0441\u043a\u0456 \u0441\u0432\u0435\u0446\u043a\u0456 \u043a\u0430\u043b\u044f\u043d\u0434\u0430\u0440" },
            { "en_GB", "\u0431\u0440\u044b\u0442\u0430\u043d\u0441\u043a\u0430\u044f \u0430\u043d\u0433\u043b\u0456\u0439\u0441\u043a\u0430\u044f" },
            { "PE", "\u041f\u0435\u0440\u0443" },
            { "PF", "\u0424\u0440\u0430\u043d\u0446\u0443\u0437\u0441\u043a\u0430\u044f \u041f\u0430\u043b\u0456\u043d\u0435\u0437\u0456\u044f" },
            { "PG", "\u041f\u0430\u043f\u0443\u0430-\u041d\u043e\u0432\u0430\u044f \u0413\u0432\u0456\u043d\u0435\u044f" },
            { "PH", "\u0424\u0456\u043b\u0456\u043f\u0456\u043d\u044b" },
            { "PK", "\u041f\u0430\u043a\u0456\u0441\u0442\u0430\u043d" },
            { "PL", "\u041f\u043e\u043b\u044c\u0448\u0447\u0430" },
            { "ewo", "\u044d\u0432\u043e\u043d\u0434\u0430" },
            { "PM", "\u0421\u0435\u043d-\u041f\u2019\u0435\u0440 \u0456 \u041c\u0456\u043a\u0435\u043b\u043e\u043d" },
            { "PN", "\u0410\u0441\u0442\u0440\u0430\u0432\u044b \u041f\u0456\u0442\u043a\u044d\u0440\u043d" },
            { "PR", "\u041f\u0443\u044d\u0440\u0442\u0430-\u0420\u044b\u043a\u0430" },
            { "PS", "\u041f\u0430\u043b\u0435\u0441\u0446\u0456\u043d\u0441\u043a\u0456\u044f \u0422\u044d\u0440\u044b\u0442\u043e\u0440\u044b\u0456" },
            { "PT", "\u041f\u0430\u0440\u0442\u0443\u0433\u0430\u043b\u0456\u044f" },
            { "PW", "\u041f\u0430\u043b\u0430\u0443" },
            { "nia", "\u043d\u0456\u0430\u0441" },
            { "type.nu.greklow", "\u0433\u0440\u044d\u0447\u0430\u0441\u043a\u0456\u044f \u043b\u0456\u0447\u0431\u044b \u045e \u043d\u0456\u0436\u043d\u0456\u043c \u0440\u044d\u0433\u0456\u0441\u0442\u0440\u044b" },
            { "PY", "\u041f\u0430\u0440\u0430\u0433\u0432\u0430\u0439" },
            { "tum", "\u0442\u0443\u043c\u0431\u0443\u043a\u0430" },
            { "Hebr", "\u044f\u045e\u0440\u044d\u0439\u0441\u043a\u0430\u0435" },
            { "QA", "\u041a\u0430\u0442\u0430\u0440" },
            { "niu", "\u043d\u0456\u045e\u044d" },
            { "QO", "\u0410\u0434\u0434\u0430\u043b\u0435\u043d\u044b\u044f \u0442\u044d\u0440\u044b\u0442\u043e\u0440\u044b\u0456 \u0410\u043a\u0456\u044f\u043d\u0456\u0456" },
            { "lez", "\u043b\u0435\u0437\u0433\u0456\u043d\u0441\u043a\u0430\u044f" },
            { "tvl", "\u0442\u0443\u0432\u0430\u043b\u0443" },
            { "001", "\u0421\u0432\u0435\u0442" },
            { "002", "\u0410\u0444\u0440\u044b\u043a\u0430" },
            { "003", "\u041f\u0430\u045e\u043d\u043e\u0447\u043d\u0430\u044f \u0410\u043c\u0435\u0440\u044b\u043a\u0430" },
            { "RE", "\u0420\u044d\u044e\u043d\u044c\u0451\u043d" },
            { "005", "\u041f\u0430\u045e\u0434\u043d\u0451\u0432\u0430\u044f \u0410\u043c\u0435\u0440\u044b\u043a\u0430" },
            { "jbo", "\u043b\u043e\u0436\u0431\u0430\u043d" },
            { "009", "\u0410\u043a\u0456\u044f\u043d\u0456\u044f" },
            { "RO", "\u0420\u0443\u043c\u044b\u043d\u0456\u044f" },
            { "RS", "\u0421\u0435\u0440\u0431\u0456\u044f" },
            { "RU", "\u0420\u0430\u0441\u0456\u044f" },
            { "RW", "\u0420\u0443\u0430\u043d\u0434\u0430" },
            { "SA", "\u0421\u0430\u0443\u0434\u0430\u045e\u0441\u043a\u0430\u044f \u0410\u0440\u0430\u0432\u0456\u044f" },
            { "SB", "\u0421\u0430\u043b\u0430\u043c\u043e\u043d\u0430\u0432\u044b \u0430\u0441\u0442\u0440\u0430\u0432\u044b" },
            { "twq", "\u0442\u0430\u0441\u0430\u045e\u0430\u043a" },
            { "011", "\u0417\u0430\u0445\u043e\u0434\u043d\u044f\u044f \u0410\u0444\u0440\u044b\u043a\u0430" },
            { "SC", "\u0421\u0435\u0439\u0448\u044d\u043b\u044c\u0441\u043a\u0456\u044f \u0430\u0441\u0442\u0440\u0430\u0432\u044b" },
            { "SD", "\u0421\u0443\u0434\u0430\u043d" },
            { "013", "\u0426\u044d\u043d\u0442\u0440\u0430\u043b\u044c\u043d\u0430\u044f \u0410\u043c\u0435\u0440\u044b\u043a\u0430" },
            { "SE", "\u0428\u0432\u0435\u0446\u044b\u044f" },
            { "014", "\u0423\u0441\u0445\u043e\u0434\u043d\u044f\u044f \u0410\u0444\u0440\u044b\u043a\u0430" },
            { "arc", "\u0430\u0440\u0430\u043c\u0435\u0439\u0441\u043a\u0430\u044f" },
            { "015", "\u041f\u0430\u045e\u043d\u043e\u0447\u043d\u0430\u044f \u0410\u0444\u0440\u044b\u043a\u0430" },
            { "SG", "\u0421\u0456\u043d\u0433\u0430\u043f\u0443\u0440" },
            { "SH", "\u0412\u043e\u0441\u0442\u0440\u0430\u045e \u0421\u0432\u044f\u0442\u043e\u0439 \u0410\u043b\u0435\u043d\u044b" },
            { "type.lb.strict", "\u0441\u0442\u0440\u043e\u0433\u0456\u044f \u043f\u0440\u0430\u0432\u0456\u043b\u044b \u0440\u0430\u0437\u0440\u044b\u0432\u0443 \u0440\u0430\u0434\u043a\u0430" },
            { "017", "\u0421\u044f\u0440\u044d\u0434\u043d\u044f\u044f \u0410\u0444\u0440\u044b\u043a\u0430" },
            { "SI", "\u0421\u043b\u0430\u0432\u0435\u043d\u0456\u044f" },
            { "018", "\u041f\u0430\u045e\u0434\u043d\u0451\u0432\u0430\u044f \u0410\u0444\u0440\u044b\u043a\u0430" },
            { "SJ", "\u0428\u043f\u0456\u0446\u0431\u0435\u0440\u0433\u0435\u043d \u0456 \u042f\u043d-\u041c\u0430\u0435\u043d" },
            { "019", "\u041f\u0430\u045e\u043d\u043e\u0447\u043d\u0430\u044f \u0456 \u041f\u0430\u045e\u0434\u043d\u0451\u0432\u0430\u044f \u0410\u043c\u0435\u0440\u044b\u043a\u0456" },
            { "SK", "\u0421\u043b\u0430\u0432\u0430\u043a\u0456\u044f" },
            { "SL", "\u0421\u044c\u0435\u0440\u0430-\u041b\u0435\u043e\u043d\u044d" },
            { "SM", "\u0421\u0430\u043d-\u041c\u0430\u0440\u044b\u043d\u0430" },
            { "SN", "\u0421\u0435\u043d\u0435\u0433\u0430\u043b" },
            { "SO", "\u0421\u0430\u043c\u0430\u043b\u0456" },
            { "arn", "\u043c\u0430\u043f\u0443\u0434\u0443\u043d\u0433\u0443\u043d" },
            { "arp", "\u0430\u0440\u0430\u043f\u0430\u0445\u0430" },
            { "type.nu.taml", "\u0442\u0430\u043c\u0456\u043b\u044c\u0441\u043a\u0456\u044f \u0442\u0440\u0430\u0434\u044b\u0446\u044b\u0439\u043d\u044b\u044f \u043b\u0456\u0447\u0431\u044b" },
            { "SR", "\u0421\u0443\u0440\u044b\u043d\u0430\u043c" },
            { "SS", "\u041f\u0430\u045e\u0434\u043d\u0451\u0432\u044b \u0421\u0443\u0434\u0430\u043d" },
            { "ST", "\u0421\u0430\u043d-\u0422\u0430\u043c\u044d \u0456 \u041f\u0440\u044b\u043d\u0441\u0456\u043f\u0456" },
            { "SV", "\u0421\u0430\u043b\u044c\u0432\u0430\u0434\u043e\u0440" },
            { "SX", "\u0421\u0456\u043d\u0442-\u041c\u0430\u0440\u0442\u044d\u043d" },
            { "SY", "\u0421\u0456\u0440\u044b\u044f" },
            { "SZ", "\u042d\u0441\u0432\u0430\u0442\u044b\u043d\u0456" },
            { "TA", "\u0422\u0440\u044b\u0441\u0442\u0430\u043d-\u0434\u0430-\u041a\u0443\u043d\u044c\u044f" },
            { "asa", "\u0430\u0441\u0443" },
            { "type.ms.ussystem", "\u0430\u043c\u0435\u0440\u044b\u043a\u0430\u043d\u0441\u043a\u0430\u044f \u0441\u0456\u0441\u0442\u044d\u043c\u0430 \u043c\u0435\u0440" },
            { "021", "\u041f\u0430\u045e\u043d\u043e\u0447\u043d\u0430\u0430\u043c\u0435\u0440\u044b\u043a\u0430\u043d\u0441\u043a\u0456 \u0440\u044d\u0433\u0456\u0451\u043d" },
            { "TC", "\u0410\u0441\u0442\u0440\u0430\u0432\u044b \u0426\u0451\u0440\u043a\u0441 \u0456 \u041a\u0430\u0439\u043a\u0430\u0441" },
            { "yav", "\u044f\u043d\u0433\u0431\u044d\u043d" },
            { "TD", "\u0427\u0430\u0434" },
            { "TF", "\u0424\u0440\u0430\u043d\u0446\u0443\u0437\u0441\u043a\u0456\u044f \u043f\u0430\u045e\u0434\u043d\u0451\u0432\u044b\u044f \u0442\u044d\u0440\u044b\u0442\u043e\u0440\u044b\u0456" },
            { "TG", "\u0422\u043e\u0433\u0430" },
            { "TH", "\u0422\u0430\u0439\u043b\u0430\u043d\u0434" },
            { "TJ", "\u0422\u0430\u0434\u0436\u044b\u043a\u0456\u0441\u0442\u0430\u043d" },
            { "029", "\u041a\u0430\u0440\u044b\u0431\u0441\u043a\u0456 \u0440\u044d\u0433\u0456\u0451\u043d" },
            { "TK", "\u0422\u0430\u043a\u0435\u043b\u0430\u0443" },
            { "TL", "\u0422\u044b\u043c\u043e\u0440-\u041b\u0435\u0448\u0446\u0456" },
            { "ybb", "\u0439\u0435\u043c\u0431\u0430" },
            { "TM", "\u0422\u0443\u0440\u043a\u043c\u0435\u043d\u0456\u0441\u0442\u0430\u043d" },
            { "TN", "\u0422\u0443\u043d\u0456\u0441" },
            { "TO", "\u0422\u043e\u043d\u0433\u0430" },
            { "TR", "\u0422\u0443\u0440\u0446\u044b\u044f" },
            { "TT", "\u0422\u0440\u044b\u043d\u0456\u0434\u0430\u0434 \u0456 \u0422\u0430\u0431\u0430\u0433\u0430" },
            { "TV", "\u0422\u0443\u0432\u0430\u043b\u0443" },
            { "TW", "\u0422\u0430\u0439\u0432\u0430\u043d\u044c" },
            { "ast", "\u0430\u0441\u0442\u0443\u0440\u044b\u0439\u0441\u043a\u0430\u044f" },
            { "TZ", "\u0422\u0430\u043d\u0437\u0430\u043d\u0456\u044f" },
            { "nmg", "\u043d\u0433\u0443\u043c\u0431\u0430" },
            { "Zzzz", "\u043d\u0435\u0432\u044f\u0434\u043e\u043c\u0430\u0435 \u043f\u0456\u0441\u044c\u043c\u043e" },
            { "UA", "\u0423\u043a\u0440\u0430\u0456\u043d\u0430" },
            { "rup", "\u0430\u0440\u0443\u043c\u0443\u043d\u0441\u043a\u0430\u044f" },
            { "030", "\u0423\u0441\u0445\u043e\u0434\u043d\u044f\u044f \u0410\u0437\u0456\u044f" },
            { "tyv", "\u0442\u0443\u0432\u0456\u043d\u0441\u043a\u0430\u044f" },
            { "sw_CD", "\u043a\u0430\u043d\u0433\u0430\u043b\u0435\u0437\u0441\u043a\u0430\u044f \u0441\u0443\u0430\u0445\u0456\u043b\u0456" },
            { "034", "\u041f\u0430\u045e\u0434\u043d\u0451\u0432\u0430\u044f \u0410\u0437\u0456\u044f" },
            { "035", "\u041f\u0430\u045e\u0434\u043d\u0451\u0432\u0430-\u0423\u0441\u0445\u043e\u0434\u043d\u044f\u044f \u0410\u0437\u0456\u044f" },
            { "UG", "\u0423\u0433\u0430\u043d\u0434\u0430" },
            { "039", "\u041f\u0430\u045e\u0434\u043d\u0451\u0432\u0430\u044f \u0415\u045e\u0440\u043e\u043f\u0430" },
            { "Sinh", "\u0441\u0456\u043d\u0433\u0430\u043b\u044c\u0441\u043a\u0430\u0435" },
            { "UM", "\u041c\u0430\u043b\u044b\u044f \u0410\u0434\u0434\u0430\u043b\u0435\u043d\u044b\u044f \u0430\u0441\u0442\u0440\u0430\u0432\u044b \u0417\u0428\u0410" },
            { "UN", "\u0410\u0440\u0433\u0430\u043d\u0456\u0437\u0430\u0446\u044b\u044f \u0410\u0431\u2019\u044f\u0434\u043d\u0430\u043d\u044b\u0445 \u041d\u0430\u0446\u044b\u0439" },
            { "US", "\u0417\u043b\u0443\u0447\u0430\u043d\u044b\u044f \u0428\u0442\u0430\u0442\u044b" },
            { "haw", "\u0433\u0430\u0432\u0430\u0439\u0441\u043a\u0430\u044f" },
            { "UY", "\u0423\u0440\u0443\u0433\u0432\u0430\u0439" },
            { "prg", "\u043f\u0440\u0443\u0441\u043a\u0430\u044f" },
            { "UZ", "\u0423\u0437\u0431\u0435\u043a\u0456\u0441\u0442\u0430\u043d" },
            { "tzm", "\u0441\u044f\u0440\u044d\u0434\u043d\u0435\u0430\u0442\u043b\u0430\u0441\u043a\u0430\u044f \u0442\u0430\u043c\u0430\u0437\u0456\u0433\u0445\u0442" },
            { "nnh", "\u043d\u0433\u2019\u0435\u043c\u0431\u043e\u043d" },
            { "VA", "\u0412\u0430\u0442\u044b\u043a\u0430\u043d" },
            { "pro", "\u0441\u0442\u0430\u0440\u0430\u043f\u0440\u0430\u0432\u0430\u043d\u0441\u0430\u043b\u044c\u0441\u043a\u0430\u044f" },
            { "VC", "\u0421\u0435\u043d\u0442-\u0412\u0456\u043d\u0441\u0435\u043d\u0442 \u0456 \u0413\u0440\u044d\u043d\u0430\u0434\u0437\u0456\u043d\u044b" },
            { "VE", "\u0412\u0435\u043d\u0435\u0441\u0443\u044d\u043b\u0430" },
            { "VG", "\u0411\u0440\u044b\u0442\u0430\u043d\u0441\u043a\u0456\u044f \u0412\u0456\u0440\u0433\u0456\u043d\u0441\u043a\u0456\u044f \u0430\u0441\u0442\u0440\u0430\u0432\u044b" },
            { "VI", "\u0410\u043c\u0435\u0440\u044b\u043a\u0430\u043d\u0441\u043a\u0456\u044f \u0412\u0456\u0440\u0433\u0456\u043d\u0441\u043a\u0456\u044f \u0430\u0441\u0442\u0440\u0430\u0432\u044b" },
            { "VN", "\u0412\u2019\u0435\u0442\u043d\u0430\u043c" },
            { "VU", "\u0412\u0430\u043d\u0443\u0430\u0442\u0443" },
            { "nog", "\u043d\u0430\u0433\u0430\u0439\u0441\u043a\u0430\u044f" },
            { "rwk", "\u0440\u0443\u0430" },
            { "non", "\u0441\u0442\u0430\u0440\u0430\u043d\u0430\u0440\u0432\u0435\u0436\u0441\u043a\u0430\u044f" },
            { "053", "\u0410\u045e\u0441\u0442\u0440\u0430\u043b\u0430\u0437\u0456\u044f" },
            { "054", "\u041c\u0435\u043b\u0430\u043d\u0435\u0437\u0456\u044f" },
            { "WF", "\u0423\u043e\u043b\u0456\u0441 \u0456 \u0424\u0443\u0442\u0443\u043d\u0430" },
            { "057", "\u041c\u0456\u043a\u0440\u0430\u043d\u0435\u0437\u0456\u0439\u0441\u043a\u0456 \u0440\u044d\u0433\u0456\u0451\u043d" },
            { "jgo", "\u043d\u0433\u043e\u043c\u0431\u0430" },
            { "lkt", "\u043b\u0430\u043a\u043e\u0442\u0430" },
            { "wae", "\u0432\u0430\u043b\u044c\u0448\u0441\u043a\u0430\u044f" },
            { "WS", "\u0421\u0430\u043c\u043e\u0430" },
            { "wal", "\u0432\u043e\u043b\u0430\u0439\u0442\u0430" },
            { "XA", "\u041f\u0441\u0435\u045e\u0434\u0430\u0430\u043a\u0446\u044d\u043d\u0442\u044b" },
            { "war", "\u0432\u0430\u0440\u0430\u0439" },
            { "XB", "\u041f\u0441\u0435\u045e\u0434\u0430-Bidi" },
            { "awa", "\u0430\u0432\u0430\u0434\u0445\u0456" },
            { "061", "\u041f\u0430\u043b\u0456\u043d\u0435\u0437\u0456\u044f" },
            { "XK", "\u041a\u043e\u0441\u0430\u0432\u0430" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "\u0431\u0435\u0441\u043f\u0456\u0441\u044c\u043c\u0435\u043d\u043d\u0430\u044f" },
            { "wbp", "\u0432\u0430\u0440\u043b\u043f\u0456\u0440\u044b" },
            { "YE", "\u0415\u043c\u0435\u043d" },
            { "nqo", "\u043d\u043a\u043e" },
            { "type.co.standard", "\u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u044b \u043f\u0430\u0440\u0430\u0434\u0430\u043a \u0441\u0430\u0440\u0442\u0430\u0432\u0430\u043d\u043d\u044f" },
            { "YT", "\u041c\u0430\u0451\u0442\u0430" },
            { "ZA", "\u041f\u0430\u045e\u0434\u043d\u0451\u0432\u0430-\u0410\u0444\u0440\u044b\u043a\u0430\u043d\u0441\u043a\u0430\u044f \u0420\u044d\u0441\u043f\u0443\u0431\u043b\u0456\u043a\u0430" },
            { "type.lb.loose", "\u043d\u044f\u0441\u0442\u0440\u043e\u0433\u0456\u044f \u043f\u0440\u0430\u0432\u0456\u043b\u044b \u0440\u0430\u0437\u0440\u044b\u0432\u0443 \u0440\u0430\u0434\u043a\u0430" },
            { "Deva", "\u0434\u044d\u0432\u0430\u043d\u0430\u0433\u0430\u0440\u044b" },
            { "type.nu.geor", "\u0433\u0440\u0443\u0437\u0456\u043d\u0441\u043a\u0456\u044f \u043b\u0456\u0447\u0431\u044b" },
            { "Hira", "\u0445\u0456\u0440\u0430\u0433\u0430\u043d\u0430" },
            { "ZM", "\u0417\u0430\u043c\u0431\u0456\u044f" },
            { "ZW", "\u0417\u0456\u043c\u0431\u0430\u0431\u0432\u044d" },
            { "ZZ", "\u041d\u0435\u0432\u044f\u0434\u043e\u043c\u044b \u0440\u044d\u0433\u0456\u0451\u043d" },
            { "type.ms.metric", "\u043c\u0435\u0442\u0440\u044b\u0447\u043d\u0430\u044f \u0441\u0456\u0441\u0442\u044d\u043c\u0430 \u043c\u0435\u0440" },
            { "type.ca.iso8601", "\u043a\u0430\u043b\u044f\u043d\u0434\u0430\u0440 ISO-8601" },
            { "lol", "\u043c\u043e\u043d\u0433\u0430" },
            { "nso", "\u043f\u0430\u045e\u043d\u043e\u0447\u043d\u0430\u044f \u0441\u043e\u0442\u0430" },
            { "type.nu.telu", "\u043b\u0456\u0447\u0431\u044b \u0442\u044d\u043b\u0443\u0433\u0443" },
            { "loz", "\u043b\u043e\u0437\u0456" },
            { "jmc", "\u043c\u0430\u0447\u0430\u043c\u0431\u044d" },
            { "type.nu.hansfin", "\u043a\u0456\u0442\u0430\u0439\u0441\u043a\u0456\u044f \u0441\u043f\u0440\u043e\u0448\u0447\u0430\u043d\u044b\u044f \u043b\u0456\u0447\u0431\u044b (\u0444\u0456\u043d\u0430\u043d\u0441\u044b)" },
            { "hil", "\u0445\u0456\u043b\u0456\u0433\u0430\u0439\u043d\u043e\u043d" },
            { "type.nu.arabext", "\u043f\u0430\u0448\u044b\u0440\u0430\u043d\u0430\u044f \u0441\u0456\u0441\u0442\u044d\u043c\u0430 \u0430\u0440\u0430\u0431\u0441\u043a\u0430-\u0456\u043d\u0434\u044b\u0439\u0441\u043a\u0456\u0445 \u043b\u0456\u0447\u0431\u0430\u045e" },
            { "nus", "\u043d\u0443\u044d\u0440" },
            { "dak", "\u0434\u0430\u043a\u043e\u0442\u0430" },
            { "type.nu.fullwide", "\u043f\u043e\u045e\u043d\u0430\u0448\u044b\u0440\u044b\u043d\u043d\u044b\u044f \u043b\u0456\u0447\u0431\u044b" },
            { "dar", "\u0434\u0430\u0440\u0433\u0456\u043d\u0441\u043a\u0430\u044f" },
            { "dav", "\u0442\u0430\u0456\u0442\u0430" },
            { "lrc", "\u043f\u0430\u045e\u043d\u043e\u0447\u043d\u0430\u044f \u043b\u0443\u0440\u044b" },
            { "udm", "\u0443\u0434\u043c\u0443\u0440\u0446\u043a\u0430\u044f" },
            { "Khmr", "\u043a\u0445\u043c\u0435\u0440\u0441\u043a\u0430\u0435" },
            { "sad", "\u0441\u0430\u043d\u0434\u0430\u045e\u044d" },
            { "type.nu.roman", "\u0440\u044b\u043c\u0441\u043a\u0456\u044f \u043b\u0456\u0447\u0431\u044b" },
            { "sah", "\u044f\u043a\u0443\u0446\u043a\u0430\u044f" },
            { "saq", "\u0441\u0430\u043c\u0431\u0443\u0440\u0443" },
            { "sat", "\u0441\u0430\u043d\u0442\u0430\u043b\u0456" },
            { "sba", "\u043d\u0433\u0430\u043c\u0431\u0430\u0439" },
            { "Guru", "\u0433\u0443\u0440\u043c\u0443\u043a\u0445\u0456" },
            { "lua", "\u043b\u0443\u0431\u0430-\u043a\u0430\u0441\u0430\u0456" },
            { "sbp", "\u0441\u0430\u043d\u0433\u0443" },
            { "nyn", "\u043d\u044c\u044f\u043d\u043a\u043e\u043b\u0435" },
            { "lun", "\u043b\u0443\u043d\u0434\u0430" },
            { "luo", "\u043b\u0443\u043e" },
            { "fil", "\u0444\u0456\u043b\u0456\u043f\u0456\u043d\u0441\u043a\u0430\u044f" },
            { "hmn", "\u0445\u043c\u043e\u043d\u0433" },
            { "lus", "\u043c\u0456\u0437\u043e" },
            { "ban", "\u0431\u0430\u043b\u0456\u0439\u0441\u043a\u0430\u044f" },
            { "luy", "\u043b\u0443\u0439\u044f" },
            { "bas", "\u0431\u0430\u0441\u0430\u0430" },
            { "es_ES", "\u0435\u045e\u0440\u0430\u043f\u0435\u0439\u0441\u043a\u0430\u044f \u0456\u0441\u043f\u0430\u043d\u0441\u043a\u0430\u044f" },
            { "sco", "\u0448\u0430\u0442\u043b\u0430\u043d\u0434\u0441\u043a\u0430\u044f" },
            { "scn", "\u0441\u0456\u0446\u044b\u043b\u0456\u0439\u0441\u043a\u0430\u044f" },
            { "aa", "\u0430\u0444\u0430\u0440\u0441\u043a\u0430\u044f" },
            { "ab", "\u0430\u0431\u0445\u0430\u0437\u0441\u043a\u0430\u044f" },
            { "af", "\u0430\u0444\u0440\u044b\u043a\u0430\u0430\u043d\u0441" },
            { "ak", "\u0430\u043a\u0430\u043d" },
            { "am", "\u0430\u043c\u0445\u0430\u0440\u0441\u043a\u0430\u044f" },
            { "an", "\u0430\u0440\u0430\u0433\u043e\u043d\u0441\u043a\u0430\u044f" },
            { "Arab", "\u0430\u0440\u0430\u0431\u0441\u043a\u0430\u0435" },
            { "Jpan", "\u044f\u043f\u043e\u043d\u0441\u043a\u0430\u0435" },
            { "ar", "\u0430\u0440\u0430\u0431\u0441\u043a\u0430\u044f" },
            { "Hrkt", "\u044f\u043f\u043e\u043d\u0441\u043a\u0456\u044f \u0441\u043a\u043b\u0430\u0434\u043e\u0432\u044b\u044f \u043f\u0456\u0441\u044c\u043c\u044b" },
            { "as", "\u0430\u0441\u0430\u043c\u0441\u043a\u0430\u044f" },
            { "av", "\u0430\u0432\u0430\u0440\u0441\u043a\u0430\u044f" },
            { "sdh", "\u043f\u0430\u045e\u0434\u043d\u0451\u0432\u0430\u043a\u0443\u0440\u0434\u0441\u043a\u0430\u044f" },
            { "ay", "\u0430\u0439\u043c\u0430\u0440\u0430" },
            { "az", "\u0430\u0437\u0435\u0440\u0431\u0430\u0439\u0434\u0436\u0430\u043d\u0441\u043a\u0430\u044f" },
            { "ba", "\u0431\u0430\u0448\u043a\u0456\u0440\u0441\u043a\u0430\u044f" },
            { "be", "\u0431\u0435\u043b\u0430\u0440\u0443\u0441\u043a\u0430\u044f" },
            { "bg", "\u0431\u0430\u043b\u0433\u0430\u0440\u0441\u043a\u0430\u044f" },
            { "bi", "\u0431\u0456\u0441\u043b\u0430\u043c\u0430" },
            { "bm", "\u0431\u0430\u043c\u0431\u0430\u0440\u0430" },
            { "bn", "\u0431\u0435\u043d\u0433\u0430\u043b\u044c\u0441\u043a\u0430\u044f" },
            { "bo", "\u0442\u044b\u0431\u0435\u0446\u043a\u0430\u044f" },
            { "dgr", "\u0434\u043e\u0433\u0440\u044b\u0431" },
            { "br", "\u0431\u0440\u044d\u0442\u043e\u043d\u0441\u043a\u0430\u044f" },
            { "bs", "\u0431\u0430\u0441\u043d\u0456\u0439\u0441\u043a\u0430\u044f" },
            { "Mymr", "\u0431\u0456\u0440\u043c\u0430\u043d\u0441\u043a\u0430\u0435" },
            { "type.nu.laoo", "\u043b\u0430\u043e\u0441\u043a\u0456\u044f \u043b\u0456\u0447\u0431\u044b" },
            { "seh", "\u0441\u0435\u043d\u0430" },
            { "ca", "\u043a\u0430\u0442\u0430\u043b\u0430\u043d\u0441\u043a\u0430\u044f" },
            { "ses", "\u043a\u0430\u0439\u0440\u0430\u0431\u043e\u0440\u0430 \u0441\u044d\u043d\u0456" },
            { "ce", "\u0447\u0430\u0447\u044d\u043d\u0441\u043a\u0430\u044f" },
            { "ch", "\u0447\u0430\u043c\u043e\u0440\u0430" },
            { "co", "\u043a\u0430\u0440\u0441\u0456\u043a\u0430\u043d\u0441\u043a\u0430\u044f" },
            { "Orya", metaValue_or },
            { "cs", "\u0447\u044d\u0448\u0441\u043a\u0430\u044f" },
            { "cu", "\u0446\u0430\u0440\u043a\u043e\u045e\u043d\u0430\u0441\u043b\u0430\u0432\u044f\u043d\u0441\u043a\u0430\u044f" },
            { "cv", "\u0447\u0443\u0432\u0430\u0448\u0441\u043a\u0430\u044f" },
            { "cy", "\u0432\u0430\u043b\u0456\u0439\u0441\u043a\u0430\u044f" },
            { "type.nu.ethi", "\u044d\u0444\u0456\u043e\u043f\u0441\u043a\u0456\u044f \u043b\u0456\u0447\u0431\u044b" },
            { "da", "\u0434\u0430\u0446\u043a\u0430\u044f" },
            { "pt_PT", "\u0435\u045e\u0440\u0430\u043f\u0435\u0439\u0441\u043a\u0430\u044f \u043f\u0430\u0440\u0442\u0443\u0433\u0430\u043b\u044c\u0441\u043a\u0430\u044f" },
            { "de", "\u043d\u044f\u043c\u0435\u0446\u043a\u0430\u044f" },
            { "type.cf.standard", "\u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u044b \u0444\u0430\u0440\u043c\u0430\u0442 \u0432\u0430\u043b\u044e\u0442\u044b" },
            { "bem", "\u0431\u0435\u043c\u0431\u0430" },
            { "sga", "\u0441\u0442\u0430\u0440\u0430\u0456\u0440\u043b\u0430\u043d\u0434\u0441\u043a\u0430\u044f" },
            { "dv", "\u043c\u0430\u043b\u044c\u0434\u044b\u045e\u0441\u043a\u0430\u044f" },
            { "es_419", "\u043b\u0430\u0446\u0456\u043d\u0430\u0430\u043c\u0435\u0440\u044b\u043a\u0430\u043d\u0441\u043a\u0430\u044f \u0456\u0441\u043f\u0430\u043d\u0441\u043a\u0430\u044f" },
            { "dz", "\u0434\u0437\u043e\u043d\u0433-\u043a\u044d" },
            { "bez", "\u0431\u0435\u043d\u0430" },
            { "type.ca.chinese", "\u043a\u0456\u0442\u0430\u0439\u0441\u043a\u0456 \u043a\u0430\u043b\u044f\u043d\u0434\u0430\u0440" },
            { "dje", "\u0437\u0430\u0440\u043c\u0430" },
            { "type.nu.grek", "\u0433\u0440\u044d\u0447\u0430\u0441\u043a\u0456\u044f \u043b\u0456\u0447\u0431\u044b" },
            { "ee", "\u044d\u0432\u0435" },
            { "type.lb.normal", "\u0437\u0432\u044b\u0447\u0430\u0439\u043d\u044b\u044f \u043f\u0440\u0430\u0432\u0456\u043b\u044b \u0440\u0430\u0437\u0440\u044b\u0432\u0443 \u0440\u0430\u0434\u043a\u0430" },
            { "ro_MD", "\u043c\u0430\u043b\u0434\u0430\u045e\u0441\u043a\u0430\u044f" },
            { "el", "\u0433\u0440\u044d\u0447\u0430\u0441\u043a\u0430\u044f" },
            { "en", "\u0430\u043d\u0433\u043b\u0456\u0439\u0441\u043a\u0430\u044f" },
            { "eo", "\u044d\u0441\u043f\u0435\u0440\u0430\u043d\u0442\u0430" },
            { "es", "\u0456\u0441\u043f\u0430\u043d\u0441\u043a\u0430\u044f" },
            { "et", "\u044d\u0441\u0442\u043e\u043d\u0441\u043a\u0430\u044f" },
            { "Hanb", "\u0445\u0430\u043d \u0437 \u0431\u0430\u043f\u0430\u043c\u043e\u0444\u0430" },
            { "eu", "\u0431\u0430\u0441\u043a\u0441\u043a\u0430\u044f" },
            { "Hang", "\u0445\u0430\u043d\u0433\u044b\u043b\u044c" },
            { "shi", "\u0442\u0430\u0448\u044d\u043b\u044c\u0445\u0456\u0442" },
            { "hsb", "\u0432\u0435\u0440\u0445\u043d\u044f\u043b\u0443\u0436\u044b\u0446\u043a\u0430\u044f" },
            { "Hani", "\u0445\u0430\u043d" },
            { "shn", "\u0448\u0430\u043d" },
            { "fa", "\u0444\u0430\u0440\u0441\u0456" },
            { "Hans", "\u0441\u043f\u0440\u043e\u0448\u0447\u0430\u043d\u0430\u0435 \u043a\u0456\u0442\u0430\u0439\u0441\u043a\u0430\u0435" },
            { "type.nu.latn", "\u0441\u0443\u0447\u0430\u0441\u043d\u044b\u044f \u0430\u0440\u0430\u0431\u0441\u043a\u0456\u044f \u043b\u0456\u0447\u0431\u044b" },
            { "Hant", "\u0442\u0440\u0430\u0434\u044b\u0446\u044b\u0439\u043d\u0430\u0435 \u043a\u0456\u0442\u0430\u0439\u0441\u043a\u0430\u0435" },
            { "ff", "\u0444\u0443\u043b\u0430" },
            { "fi", "\u0444\u0456\u043d\u0441\u043a\u0430\u044f" },
            { "fj", "\u0444\u0456\u0434\u0436\u044b\u0439\u0441\u043a\u0430\u044f" },
            { "fon", "\u0444\u043e\u043d" },
            { "bgn", "\u0437\u0430\u0445\u043e\u0434\u043d\u044f\u044f \u0431\u0435\u043b\u0443\u0434\u0436\u0441\u043a\u0430\u044f" },
            { "yue", "\u043a\u0430\u043d\u0442\u043e\u043d\u0441\u043a\u0456 \u0434\u044b\u044f\u043b\u0435\u043a\u0442 \u043a\u0456\u0442\u0430\u0439\u0441\u043a\u0430\u0439" },
            { "fo", "\u0444\u0430\u0440\u044d\u0440\u0441\u043a\u0430\u044f" },
            { "umb", "\u0443\u043c\u0431\u0443\u043d\u0434\u0443" },
            { "fr", "\u0444\u0440\u0430\u043d\u0446\u0443\u0437\u0441\u043a\u0430\u044f" },
            { "fy", "\u0437\u0430\u0445\u043e\u0434\u043d\u044f\u044f \u0444\u0440\u044b\u0437\u0441\u043a\u0430\u044f" },
            { "ga", "\u0456\u0440\u043b\u0430\u043d\u0434\u0441\u043a\u0430\u044f" },
            { "gd", "\u0448\u0430\u0442\u043b\u0430\u043d\u0434\u0441\u043a\u0430\u044f \u0433\u044d\u043b\u044c\u0441\u043a\u0430\u044f" },
            { "gl", "\u0433\u0430\u043b\u0456\u0441\u0456\u0439\u0441\u043a\u0430\u044f" },
            { "gn", "\u0433\u0443\u0430\u0440\u0430\u043d\u0456" },
            { "bho", "\u0431\u0445\u0430\u0434\u0436\u043f\u0443\u0440\u044b" },
            { "und", "\u043d\u0435\u0432\u044f\u0434\u043e\u043c\u0430\u044f \u043c\u043e\u0432\u0430" },
            { "gu", metaValue_gu },
            { "gv", "\u043c\u044d\u043d\u0441\u043a\u0430\u044f" },
            { "ha", "\u0445\u0430\u0443\u0441\u0430" },
            { "he", "\u0456\u045e\u0440\u044b\u0442" },
            { "hi", "\u0445\u0456\u043d\u0434\u0437\u0456" },
            { "hup", "\u0445\u0443\u043f\u0430" },
            { "bin", "\u044d\u0434\u0430" },
            { "hr", "\u0445\u0430\u0440\u0432\u0430\u0446\u043a\u0430\u044f" },
            { "ht", "\u0433\u0430\u0456\u0446\u044f\u043d\u0441\u043a\u0430\u044f \u043a\u0440\u044d\u043e\u043b\u044c\u0441\u043a\u0430\u044f" },
            { "hu", "\u0432\u0435\u043d\u0433\u0435\u0440\u0441\u043a\u0430\u044f" },
            { "hy", "\u0430\u0440\u043c\u044f\u043d\u0441\u043a\u0430\u044f" },
            { "hz", "\u0433\u0435\u0440\u044d\u0440\u0430" },
            { "ia", "\u0456\u043d\u0442\u044d\u0440\u043b\u0456\u043d\u0433\u0432\u0430" },
            { "Jamo", "\u0447\u0430\u043c\u043e" },
            { "id", "\u0456\u043d\u0434\u0430\u043d\u0435\u0437\u0456\u0439\u0441\u043a\u0430\u044f" },
            { "type.nu.tibt", "\u0442\u044b\u0431\u0435\u0446\u043a\u0456\u044f \u043b\u0456\u0447\u0431\u044b" },
            { "ie", "\u0456\u043d\u0442\u044d\u0440\u043b\u0456\u043d\u0433\u0432\u044d" },
            { "ig", "\u0456\u0433\u0431\u0430" },
            { "ii", "\u0441\u044b\u0447\u0443\u0430\u043d\u044c\u0441\u043a\u0430\u044f \u0439\u0456" },
            { "fro", "\u0441\u0442\u0430\u0440\u0430\u0444\u0440\u0430\u043d\u0446\u0443\u0437\u0441\u043a\u0430\u044f" },
            { "io", "\u0456\u0434\u0430" },
            { "is", "\u0456\u0441\u043b\u0430\u043d\u0434\u0441\u043a\u0430\u044f" },
            { "it", "\u0456\u0442\u0430\u043b\u044c\u044f\u043d\u0441\u043a\u0430\u044f" },
            { "iu", "\u0456\u043d\u0443\u043a\u0442\u044b\u0442\u0443\u0442" },
            { "Mlym", metaValue_ml },
            { "ja", "\u044f\u043f\u043e\u043d\u0441\u043a\u0430\u044f" },
            { "sma", "\u043f\u0430\u045e\u0434\u043d\u0451\u0432\u0430\u0441\u0430\u0430\u043c\u0441\u043a\u0430\u044f" },
            { "jv", "\u044f\u0432\u0430\u043d\u0441\u043a\u0430\u044f" },
            { "mad", "\u043c\u0430\u0434\u0443\u0440\u0441\u043a\u0430\u044f" },
            { "smj", "\u043b\u0443\u043b\u0435-\u0441\u0430\u0430\u043c\u0441\u043a\u0430\u044f" },
            { "mag", "\u043c\u0430\u0433\u0430\u0445\u0456" },
            { "mai", "\u043c\u0430\u0439\u0442\u0445\u0456\u043b\u0456" },
            { "smn", "\u0456\u043d\u0430\u0440\u044b-\u0441\u0430\u0430\u043c\u0441\u043a\u0430\u044f" },
            { "ka", "\u0433\u0440\u0443\u0437\u0456\u043d\u0441\u043a\u0430\u044f" },
            { "bla", "\u0431\u043b\u044d\u043a\u0444\u0443\u0442" },
            { "mak", "\u043c\u0430\u043a\u0430\u0441\u0430\u0440" },
            { "sms", "\u043a\u043e\u043b\u0442\u0430-\u0441\u0430\u0430\u043c\u0441\u043a\u0430\u044f" },
            { "man", "\u043c\u0430\u043d\u0434\u044b\u043d\u0433" },
            { "ki", "\u043a\u0456\u043a\u0443\u0439\u044e" },
            { "mas", "\u043c\u0430\u0430\u0441\u0430\u0439" },
            { "kj", "\u043a\u0443\u0430\u043d\u044c\u044f\u043c\u0430" },
            { "kk", "\u043a\u0430\u0437\u0430\u0445\u0441\u043a\u0430\u044f" },
            { "kl", "\u0433\u0440\u044d\u043d\u043b\u0430\u043d\u0434\u0441\u043a\u0430\u044f" },
            { "km", "\u043a\u0445\u043c\u0435\u0440\u0441\u043a\u0430\u044f" },
            { "kn", metaValue_kn },
            { "ko", "\u043a\u0430\u0440\u044d\u0439\u0441\u043a\u0430\u044f" },
            { "kr", "\u043a\u0430\u043d\u0443\u0440\u044b" },
            { "ks", "\u043a\u0430\u0448\u043c\u0456\u0440\u0441\u043a\u0430\u044f" },
            { "ku", "\u043a\u0443\u0440\u0434\u0441\u043a\u0430\u044f" },
            { "kv", "\u043a\u043e\u043c\u0456" },
            { "kw", "\u043a\u043e\u0440\u043d\u0441\u043a\u0430\u044f" },
            { "ky", "\u043a\u0456\u0440\u0433\u0456\u0437\u0441\u043a\u0430\u044f" },
            { "snk", "\u0441\u0430\u043d\u0456\u043d\u043a\u0435" },
            { "la", "\u043b\u0430\u0446\u0456\u043d\u0441\u043a\u0430\u044f" },
            { "lb", "\u043b\u044e\u043a\u0441\u0435\u043c\u0431\u0443\u0440\u0433\u0441\u043a\u0430\u044f" },
            { "type.nu.mlym", "\u043b\u0456\u0447\u0431\u044b \u043c\u0430\u043b\u0430\u044f\u043b\u0430\u043c" },
            { "lg", "\u0433\u0430\u043d\u0434\u0430" },
            { "li", "\u043b\u0456\u043c\u0431\u0443\u0440\u0433\u0441\u043a\u0430\u044f" },
            { "Tibt", "\u0442\u044b\u0431\u0435\u0446\u043a\u0430\u0435" },
            { "ln", "\u043b\u0456\u043d\u0433\u0430\u043b\u0430" },
            { "fur", "\u0444\u0440\u044b\u0443\u043b\u044c\u0441\u043a\u0430\u044f" },
            { "lo", "\u043b\u0430\u043e\u0441\u043a\u0430\u044f" },
            { "type.ms.uksystem", "\u0431\u0440\u044b\u0442\u0430\u043d\u0441\u043a\u0430\u044f \u0441\u0456\u0441\u0442\u044d\u043c\u0430 \u043c\u0435\u0440" },
            { "lt", "\u043b\u0456\u0442\u043e\u045e\u0441\u043a\u0430\u044f" },
            { "lu", "\u043b\u0443\u0431\u0430-\u043a\u0430\u0442\u0430\u043d\u0433\u0430" },
            { "lv", "\u043b\u0430\u0442\u044b\u0448\u0441\u043a\u0430\u044f" },
            { "mg", "\u043c\u0430\u043b\u0430\u0433\u0430\u0441\u0456\u0439\u0441\u043a\u0430\u044f" },
            { "mh", "\u043c\u0430\u0440\u0448\u0430\u043b\u044c\u0441\u043a\u0430\u044f" },
            { "type.co.ducet", "\u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u044b \u043f\u0430\u0440\u0430\u0434\u0430\u043a \u0441\u0430\u0440\u0442\u0430\u0432\u0430\u043d\u043d\u044f \u0423\u043d\u0456\u043a\u043e\u0434" },
            { "mi", "\u043c\u0430\u0430\u0440\u044b" },
            { "mk", "\u043c\u0430\u043a\u0435\u0434\u043e\u043d\u0441\u043a\u0430\u044f" },
            { "ml", metaValue_ml },
            { "mn", "\u043c\u0430\u043d\u0433\u043e\u043b\u044c\u0441\u043a\u0430\u044f" },
            { "mr", "\u043c\u0430\u0440\u0430\u0442\u0445\u0456" },
            { "ms", "\u043c\u0430\u043b\u0430\u0439\u0441\u043a\u0430\u044f" },
            { "mt", "\u043c\u0430\u043b\u044c\u0442\u044b\u0439\u0441\u043a\u0430\u044f" },
            { "my", "\u0431\u0456\u0440\u043c\u0430\u043d\u0441\u043a\u0430\u044f" },
            { "Armn", "\u0430\u0440\u043c\u044f\u043d\u0441\u043a\u0430\u0435" },
            { "mdf", "\u043c\u0430\u043a\u0448\u0430\u043d\u0441\u043a\u0430\u044f" },
            { "dsb", "\u043d\u0456\u0436\u043d\u044f\u043b\u0443\u0436\u044b\u0446\u043a\u0430\u044f" },
            { "na", "\u043d\u0430\u0443\u0440\u0443" },
            { "type.co.search", "\u0443\u043d\u0456\u0432\u0435\u0440\u0441\u0430\u043b\u044c\u043d\u044b \u043f\u043e\u0448\u0443\u043a" },
            { "nb", "\u043d\u0430\u0440\u0432\u0435\u0436\u0441\u043a\u0430\u044f (\u0431\u0443\u043a\u043c\u043e\u043b)" },
            { "nd", "\u043f\u0430\u045e\u043d\u043e\u0447\u043d\u0430\u044f \u043d\u0434\u044d\u0431\u0435\u043b\u0435" },
            { "ne", "\u043d\u0435\u043f\u0430\u043b\u044c\u0441\u043a\u0430\u044f" },
            { "ng", "\u043d\u0434\u043e\u043d\u0433\u0430" },
            { "nl", "\u043d\u0456\u0434\u044d\u0440\u043b\u0430\u043d\u0434\u0441\u043a\u0430\u044f" },
            { "nn", "\u043d\u0430\u0440\u0432\u0435\u0436\u0441\u043a\u0430\u044f (\u043d\u044e\u043d\u043e\u0448\u043a)" },
            { "no", "\u043d\u0430\u0440\u0432\u0435\u0436\u0441\u043a\u0430\u044f" },
            { "nr", "\u043f\u0430\u045e\u0434\u043d\u0451\u0432\u0430\u044f \u043d\u0434\u044d\u0431\u0435\u043b\u0435" },
            { "nv", "\u043d\u0430\u0432\u0430\u0445\u0430" },
            { "ny", "\u043d\u044c\u044f\u043d\u0434\u0436\u0430" },
            { "kac", "\u043a\u0430\u0447\u044b\u043d\u0441\u043a\u0430\u044f" },
            { "kab", "\u043a\u0430\u0431\u0456\u043b\u044c\u0441\u043a\u0430\u044f" },
            { "oc", "\u0430\u043a\u0441\u0456\u0442\u0430\u043d\u0441\u043a\u0430\u044f" },
            { "kaj", "\u0434\u0434\u0436\u0443" },
            { "kam", "\u043a\u0430\u043c\u0431\u0430" },
            { "men", "\u043c\u0435\u043d\u0434\u044d" },
            { "oj", "\u0430\u0434\u0436\u044b\u0431\u0432\u0430" },
            { "mer", "\u043c\u0435\u0440\u0443" },
            { "type.nu.armn", "\u0430\u0440\u043c\u044f\u043d\u0441\u043a\u0456\u044f \u043b\u0456\u0447\u0431\u044b" },
            { "om", "\u0430\u0440\u043e\u043c\u0430" },
            { "or", metaValue_or },
            { "os", "\u0430\u0441\u0435\u0446\u0456\u043d\u0441\u043a\u0430\u044f" },
            { "kbd", "\u043a\u0430\u0431\u0430\u0440\u0434\u0437\u0456\u043d\u0441\u043a\u0430\u044f" },
            { "mfe", "\u043c\u0430\u0440\u044b\u0441\u044c\u0435\u043d" },
            { "srn", "\u0441\u0440\u0430\u043d\u0430\u043d-\u0442\u043e\u043d\u0433\u0430" },
            { "pa", "\u043f\u0430\u043d\u0434\u0436\u0430\u0431\u0456" },
            { "dua", "\u0434\u0443\u0430\u043b\u0430" },
            { "pl", "\u043f\u043e\u043b\u044c\u0441\u043a\u0430\u044f" },
            { "type.ca.dangi", "\u043a\u0430\u043b\u044f\u043d\u0434\u0430\u0440 \u0434\u0430\u043d\u0433\u0456" },
            { "ps", "\u043f\u0443\u0448\u0442\u0443" },
            { "pt", "\u043f\u0430\u0440\u0442\u0443\u0433\u0430\u043b\u044c\u0441\u043a\u0430\u044f" },
            { "key.co", "\u043f\u0430\u0440\u0430\u0434\u0430\u043a \u0441\u0430\u0440\u0442\u0430\u0432\u0430\u043d\u043d\u044f" },
            { "pt_BR", "\u0431\u0440\u0430\u0437\u0456\u043b\u044c\u0441\u043a\u0430\u044f \u043f\u0430\u0440\u0442\u0443\u0433\u0430\u043b\u044c\u0441\u043a\u0430\u044f" },
            { "kcg", "\u0442\u2019\u044f\u043f" },
            { "mgh", "\u043c\u0430\u043a\u0443\u045e\u0430-\u043c\u0435\u0435\u0442\u0430" },
            { "key.cf", "\u0444\u0430\u0440\u043c\u0430\u0442 \u0432\u0430\u043b\u044e\u0442\u044b" },
            { "key.ca", "\u043a\u0430\u043b\u044f\u043d\u0434\u0430\u0440" },
            { "Laoo", "\u043b\u0430\u043e\u0441\u043a\u0430\u0435" },
            { "mgo", "\u043c\u0435\u0442\u0430" },
            { "type.hc.h23", "24-\u0433\u0430\u0434\u0437\u0456\u043d\u043d\u044b \u0444\u0430\u0440\u043c\u0430\u0442 \u0447\u0430\u0441\u0443 (0-23)" },
            { "type.hc.h24", "24-\u0433\u0430\u0434\u0437\u0456\u043d\u043d\u044b \u0444\u0430\u0440\u043c\u0430\u0442 \u0447\u0430\u0441\u0443 (1-24)" },
            { "ssy", "\u0441\u0430\u0445\u0430" },
            { "type.nu.mymr", "\u0431\u0456\u0440\u043c\u0430\u043d\u0441\u043a\u0456\u044f \u043b\u0456\u0447\u0431\u044b" },
            { "qu", "\u043a\u0435\u0447\u0443\u0430" },
            { "zap", "\u0441\u0430\u043f\u0430\u0442\u044d\u043a" },
            { "brx", "\u0431\u043e\u0434\u0430" },
            { "kde", "\u043c\u0430\u043a\u043e\u043d\u0434\u044d" },
            { "Ethi", "\u044d\u0444\u0456\u043e\u043f\u0441\u043a\u0430\u0435" },
            { "type.hc.h12", "12-\u0433\u0430\u0434\u0437\u0456\u043d\u043d\u044b \u0444\u0430\u0440\u043c\u0430\u0442 \u0447\u0430\u0441\u0443 (1-12)" },
            { "type.hc.h11", "12-\u0433\u0430\u0434\u0437\u0456\u043d\u043d\u044b \u0444\u0430\u0440\u043c\u0430\u0442 \u0447\u0430\u0441\u0443 (0-11)" },
            { "rm", "\u0440\u044d\u0442\u0430\u0440\u0430\u043c\u0430\u043d\u0441\u043a\u0430\u044f" },
            { "rn", "\u0440\u0443\u043d\u0434\u0437\u0456" },
            { "key.cu", "\u0432\u0430\u043b\u044e\u0442\u0430" },
            { "ro", "\u0440\u0443\u043c\u044b\u043d\u0441\u043a\u0430\u044f" },
            { "type.nu.orya", "\u043b\u0456\u0447\u0431\u044b \u043e\u0440\u044b\u044f" },
            { "type.nu.hanidec", "\u043a\u0456\u0442\u0430\u0439\u0441\u043a\u0456\u044f \u0434\u0437\u0435\u0441\u044f\u0442\u043a\u043e\u0432\u044b\u044f \u043b\u0456\u0447\u0431\u044b" },
            { "ru", "\u0440\u0443\u0441\u043a\u0430\u044f" },
            { "rw", "\u0440\u0443\u0430\u043d\u0434\u0430" },
            { "kea", "\u043a\u0430\u0431\u0443\u0432\u0435\u0440\u0434\u044b\u044f\u043d\u0443" },
            { "mic", "\u043c\u0456\u043a\u043c\u0430\u043a" },
            { "suk", "\u0441\u0443\u043a\u0443\u043c\u0430" },
            { "en_AU", "\u0430\u045e\u0441\u0442\u0440\u0430\u043b\u0456\u0439\u0441\u043a\u0430\u044f \u0430\u043d\u0433\u043b\u0456\u0439\u0441\u043a\u0430\u044f" },
            { "sa", "\u0441\u0430\u043d\u0441\u043a\u0440\u044b\u0442" },
            { "sc", "\u0441\u0430\u0440\u0434\u0437\u0456\u043d\u0441\u043a\u0430\u044f" },
            { "sd", "\u0441\u0456\u043d\u0434\u0445\u0456" },
            { "se", "\u043f\u0430\u045e\u043d\u043e\u0447\u043d\u0430\u0441\u0430\u0430\u043c\u0441\u043a\u0430\u044f" },
            { "min", "\u043c\u0456\u043d\u0430\u043d\u0433\u043a\u0430\u0431\u0430\u0443" },
            { "sg", "\u0441\u0430\u043d\u0433\u0430" },
            { "sh", "\u0441\u0435\u0440\u0431\u0441\u043a\u0430\u0445\u0430\u0440\u0432\u0430\u0446\u043a\u0430\u044f" },
            { "si", "\u0441\u0456\u043d\u0433\u0430\u043b\u044c\u0441\u043a\u0430\u044f" },
            { "sux", "\u0448\u0443\u043c\u0435\u0440\u0441\u043a\u0430\u044f" },
            { "sk", "\u0441\u043b\u0430\u0432\u0430\u0446\u043a\u0430\u044f" },
            { "sl", "\u0441\u043b\u0430\u0432\u0435\u043d\u0441\u043a\u0430\u044f" },
            { "sm", "\u0441\u0430\u043c\u043e\u0430" },
            { "sn", "\u0448\u043e\u043d\u0430" },
            { "so", "\u0441\u0430\u043c\u0430\u043b\u0456" },
            { "type.nu.arab", "\u0430\u0440\u0430\u0431\u0441\u043a\u0430-\u0456\u043d\u0434\u044b\u0439\u0441\u043a\u0456\u044f \u043b\u0456\u0447\u0431\u044b" },
            { "sq", "\u0430\u043b\u0431\u0430\u043d\u0441\u043a\u0430\u044f" },
            { "sr", "\u0441\u0435\u0440\u0431\u0441\u043a\u0430\u044f" },
            { "ss", "\u0441\u0443\u0430\u0446\u0456" },
            { "type.cf.account", "\u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0430\u0440\u0441\u043a\u0456 \u0444\u0430\u0440\u043c\u0430\u0442 \u0432\u0430\u043b\u044e\u0442\u044b" },
            { "st", "\u0441\u0435\u0441\u0443\u0442\u0430" },
            { "su", "\u0441\u0443\u043d\u0434\u0430" },
            { "sv", "\u0448\u0432\u0435\u0434\u0441\u043a\u0430\u044f" },
            { "sw", "\u0441\u0443\u0430\u0445\u0456\u043b\u0456" },
            { "type.nu.hantfin", "\u043a\u0456\u0442\u0430\u0439\u0441\u043a\u0456\u044f \u0442\u0440\u0430\u0434\u044b\u0446\u044b\u0439\u043d\u044b\u044f \u043b\u0456\u0447\u0431\u044b (\u0444\u0456\u043d\u0430\u043d\u0441\u044b)" },
            { "ibb", "\u0456\u0431\u0456\u0431\u0456\u044f" },
            { "iba", "\u0456\u0431\u0430\u043d" },
            { "ta", "\u0442\u0430\u043c\u0456\u043b\u044c\u0441\u043a\u0430\u044f" },
            { "142", "\u0410\u0437\u0456\u044f" },
            { "bua", "\u0431\u0443\u0440\u0430\u0446\u043a\u0430\u044f" },
            { "143", "\u0426\u044d\u043d\u0442\u0440\u0430\u043b\u044c\u043d\u0430\u044f \u0410\u0437\u0456\u044f" },
            { "te", metaValue_te },
            { "145", "\u0417\u0430\u0445\u043e\u0434\u043d\u044f\u044f \u0410\u0437\u0456\u044f" },
            { "tg", "\u0442\u0430\u0434\u0436\u044b\u043a\u0441\u043a\u0430\u044f" },
            { "th", "\u0442\u0430\u0439\u0441\u043a\u0430\u044f" },
            { "ti", "\u0442\u044b\u0433\u0440\u044b\u043d\u044c\u044f" },
            { "bug", "\u0431\u0443\u0433\u0456\u0441" },
            { "kfo", "\u043a\u043e\u0440\u0430" },
            { "en_CA", "\u043a\u0430\u043d\u0430\u0434\u0441\u043a\u0430\u044f \u0430\u043d\u0433\u043b\u0456\u0439\u0441\u043a\u0430\u044f" },
            { "tk", "\u0442\u0443\u0440\u043a\u043c\u0435\u043d\u0441\u043a\u0430\u044f" },
            { "tn", "\u0442\u0441\u0432\u0430\u043d\u0430" },
            { "to", "\u0442\u0430\u043d\u0433\u0430\u043d\u0441\u043a\u0430\u044f" },
            { "dyo", "\u0434\u0436\u043e\u043b\u0430-\u0444\u043e\u043d\u044c\u0456" },
            { "type.nu.jpan", "\u044f\u043f\u043e\u043d\u0441\u043a\u0456\u044f \u043b\u0456\u0447\u0431\u044b" },
            { "tr", "\u0442\u0443\u0440\u044d\u0446\u043a\u0430\u044f" },
            { "ts", "\u0442\u0441\u043e\u043d\u0433\u0430" },
            { "swb", "\u043a\u0430\u043c\u043e\u0440\u0441\u043a\u0430\u044f" },
            { "tt", "\u0442\u0430\u0442\u0430\u0440\u0441\u043a\u0430\u044f" },
            { "ty", "\u0442\u0430\u0456\u0446\u0456" },
            { "150", "\u0415\u045e\u0440\u043e\u043f\u0430" },
            { "151", "\u0423\u0441\u0445\u043e\u0434\u043d\u044f\u044f \u0415\u045e\u0440\u043e\u043f\u0430" },
            { "154", "\u041f\u0430\u045e\u043d\u043e\u0447\u043d\u0430\u044f \u0415\u045e\u0440\u043e\u043f\u0430" },
            { "dzg", "\u0434\u0430\u0437\u0430\u0433\u0430" },
            { "155", "\u0417\u0430\u0445\u043e\u0434\u043d\u044f\u044f \u0415\u045e\u0440\u043e\u043f\u0430" },
            { "ug", "\u0443\u0439\u0433\u0443\u0440\u0441\u043a\u0430\u044f" },
            { "Kore", "\u043a\u0430\u0440\u044d\u0439\u0441\u043a\u0430\u0435" },
            { "Zyyy", "\u0430\u0433\u0443\u043b\u044c\u043d\u0430\u0435" },
            { "uk", "\u0443\u043a\u0440\u0430\u0456\u043d\u0441\u043a\u0430\u044f" },
            { "ur", "\u0443\u0440\u0434\u0443" },
            { "xal", "\u043a\u0430\u043b\u043c\u044b\u0446\u043a\u0430\u044f" },
            { "uz", "\u0443\u0437\u0431\u0435\u043a\u0441\u043a\u0430\u044f" },
            { "kha", "\u043a\u0445\u0430\u0441\u0456" },
            { "nds_NL", "\u043d\u0456\u0436\u043d\u0435\u0441\u0430\u043a\u0441\u043e\u043d\u0441\u043a\u0430\u044f" },
            { "ve", "\u0432\u0435\u043d\u0434\u0430" },
            { "type.ca.roc", "\u043a\u0430\u043b\u044f\u043d\u0434\u0430\u0440 \u041c\u0456\u043d\u044c\u0433\u043e" },
            { "vi", "\u0432\u2019\u0435\u0442\u043d\u0430\u043c\u0441\u043a\u0430\u044f" },
            { "khq", "\u043a\u043e\u0439\u0440\u0430 \u0447\u044b\u0456\u043d\u0456" },
            { "key.hc", "\u0433\u0430\u0434\u0437\u0456\u043d\u043d\u044b \u0446\u044b\u043a\u043b (12 \u0430\u0431\u043e 24)" },
            { "vo", "\u0432\u0430\u043b\u0430\u043f\u044e\u043a" },
            { "quc", "\u043a\u0456\u0447\u044d" },
            { "gaa", "\u0433\u0430" },
            { "wa", "\u0432\u0430\u043b\u043e\u043d\u0441\u043a\u0430\u044f" },
            { "gag", "\u0433\u0430\u0433\u0430\u0443\u0437\u0441\u043a\u0430\u044f" },
            { "syr", "\u0441\u0456\u0440\u044b\u0439\u0441\u043a\u0430\u044f" },
            { "Grek", "\u0433\u0440\u044d\u0447\u0430\u0441\u043a\u0430\u0435" },
            { "wo", "\u0432\u0430\u043b\u043e\u0444" },
            { "zgh", "\u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u0430\u044f \u043c\u0430\u0440\u0430\u043a\u0430\u043d\u0441\u043a\u0430\u044f \u0442\u0430\u043c\u0430\u0437\u0456\u0445\u0442" },
            { "ar_001", "\u0441\u0443\u0447\u0430\u0441\u043d\u0430\u044f \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u0430\u044f \u0430\u0440\u0430\u0431\u0441\u043a\u0430\u044f" },
            { "Mong", "\u0441\u0442\u0430\u0440\u0430\u043c\u0430\u043d\u0433\u043e\u043b\u044c\u0441\u043a\u0430\u0435" },
            { "mni", "\u043c\u0435\u0439\u0442\u044d\u0439" },
            { "Latn", "\u043b\u0430\u0446\u0456\u043d\u0456\u0446\u0430" },
            { "type.nu.hans", "\u043a\u0456\u0442\u0430\u0439\u0441\u043a\u0456\u044f \u0441\u043f\u0440\u043e\u0448\u0447\u0430\u043d\u044b\u044f \u043b\u0456\u0447\u0431\u044b" },
            { "type.nu.hant", "\u043a\u0456\u0442\u0430\u0439\u0441\u043a\u0456\u044f \u0442\u0440\u0430\u0434\u044b\u0446\u044b\u0439\u043d\u044b\u044f \u043b\u0456\u0447\u0431\u044b" },
            { "xh", "\u043a\u043e\u0441\u0430" },
            { "type.nu.romanlow", "\u0440\u044b\u043c\u0441\u043a\u0456\u044f \u043b\u0456\u0447\u0431\u044b \u045e \u043d\u0456\u0436\u043d\u0456\u043c \u0440\u044d\u0433\u0456\u0441\u0442\u0440\u044b" },
            { "byn", "\u0431\u0456\u043b\u0435\u043d" },
            { "moh", "\u043c\u043e\u0445\u0430\u043a" },
            { "kkj", "\u043a\u0430\u043a\u043e" },
            { "yi", "\u0456\u0434\u044b\u0448" },
            { "mos", "\u043c\u043e\u0441\u0456" },
            { "yo", "\u0451\u0440\u0443\u0431\u0430" },
            { "es_MX", "\u043c\u0435\u043a\u0441\u0456\u043a\u0430\u043d\u0441\u043a\u0430\u044f \u0456\u0441\u043f\u0430\u043d\u0441\u043a\u0430\u044f" },
            { "vai", "\u0432\u0430\u0456" },
            { "kln", "\u043a\u0430\u043b\u0435\u043d\u0434\u0436\u044b\u043d" },
            { "zh", "\u043a\u0456\u0442\u0430\u0439\u0441\u043a\u0430\u044f" },
            { "Bopo", "\u0431\u0430\u043f\u0430\u043c\u043e\u0444\u0430" },
            { "key.lb", "\u043f\u0440\u0430\u0432\u0456\u043b\u044b \u0440\u0430\u0437\u0440\u044b\u0432\u0443 \u0440\u0430\u0434\u043a\u0430" },
            { "zu", "\u0437\u0443\u043b\u0443" },
            { "Geor", "\u0433\u0440\u0443\u0437\u0456\u043d\u0441\u043a\u0430\u0435" },
            { "kmb", "\u043a\u0456\u043c\u0431\u0443\u043d\u0434\u0443" },
            { "type.nu.jpanfin", "\u044f\u043f\u043e\u043d\u0441\u043a\u0456\u044f \u043b\u0456\u0447\u0431\u044b (\u0444\u0456\u043d\u0430\u043d\u0441\u044b)" },
            { "gez", "\u0433\u0435\u044d\u0437" },
            { "ebu", "\u044d\u043c\u0431\u0443" },
            { "zh_Hans", "\u043a\u0456\u0442\u0430\u0439\u0441\u043a\u0430\u044f (\u0441\u043f\u0440\u043e\u0448\u0447\u0430\u043d\u044b\u044f \u0456\u0435\u0440\u043e\u0433\u043b\u0456\u0444\u044b)" },
            { "koi", "\u043a\u043e\u043c\u0456-\u043f\u044f\u0440\u043c\u044f\u0446\u043a\u0430\u044f" },
            { "kok", "\u043a\u0430\u043d\u043a\u0430\u043d\u0456" },
            { "zh_Hant", "\u043a\u0456\u0442\u0430\u0439\u0441\u043a\u0430\u044f (\u0442\u0440\u0430\u0434\u044b\u0446\u044b\u0439\u043d\u044b\u044f \u0456\u0435\u0440\u043e\u0433\u043b\u0456\u0444\u044b)" },
            { "kpe", "\u043a\u043f\u0435\u043b\u0435" },
            { "type.nu.khmr", "\u043a\u0445\u043c\u0435\u0440\u0441\u043a\u0456\u044f \u043b\u0456\u0447\u0431\u044b" },
            { "ilo", "\u0456\u043b\u0430\u043a\u0430\u043d\u0430" },
            { "mua", "\u043c\u0443\u043d\u0434\u0430\u043d\u0433" },
            { "type.nu.guru", "\u043b\u0456\u0447\u0431\u044b \u0433\u0443\u0440\u043c\u0443\u043a\u0445\u0456" },
            { "mul", "\u043d\u0435\u043a\u0430\u043b\u044c\u043a\u0456 \u043c\u043e\u045e" },
            { "key.ms", "\u0441\u0456\u0441\u0442\u044d\u043c\u0430 \u043c\u0435\u0440" },
            { "mus", "\u043c\u0443\u0441\u043a\u043e\u0433\u0456" },
            { "gil", "\u043a\u0456\u0440\u044b\u0431\u0430\u0446\u0456" },
            { "type.nu.tamldec", "\u0442\u0430\u043c\u0456\u043b\u044c\u0441\u043a\u0456\u044f \u043b\u0456\u0447\u0431\u044b" },
            { "krc", "\u043a\u0430\u0440\u0430\u0447\u0430\u0439-\u0431\u0430\u043b\u043a\u0430\u0440\u0441\u043a\u0430\u044f" },
            { "inh", "\u0456\u043d\u0433\u0443\u0448\u0441\u043a\u0430\u044f" },
            { "fa_AF", "\u0434\u0430\u0440\u044b" },
            { "krl", "\u043a\u0430\u0440\u044d\u043b\u044c\u0441\u043a\u0430\u044f" },
            { "efi", "\u044d\u0444\u0456\u043a" },
            { "key.nu", "\u043b\u0456\u0447\u0431\u044b" },
            { "kru", "\u043a\u0443\u0440\u0443\u0445" },
            { "ksb", "\u0448\u0430\u043c\u0431\u0430\u043b\u0430" },
            { "Telu", metaValue_te },
            { "ksf", "\u0431\u0430\u0444\u0456\u044f" },
        };
        return data;
    }
}
