/*
 * Copyright (c) 2012, 2023, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_fur extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "arap";
        final String metaValue_bn = "bengal\u00eas";
        final String metaValue_bo = "tibetan";
        final String metaValue_el = "gr\u00eac";
        final String metaValue_gu = "gujarati";
        final String metaValue_hy = "armen";
        final String metaValue_ja = "gjapon\u00eas";
        final String metaValue_km = "khmer";
        final String metaValue_kn = "kannada";
        final String metaValue_ko = "corean";
        final String metaValue_la = "latin";
        final String metaValue_lo = "lao";
        final String metaValue_ml = "malayalam";
        final String metaValue_mn = "mongul";
        final String metaValue_or = "oriya";
        final String metaValue_ta = "tamil";
        final String metaValue_te = "telegu";
        final String metaValue_th = "thai";
        final String metaValue_tl = "tagalog";
        final String metaValue_got = "gotic";
        final String metaValue_peo = "vieri persian";
        final Object[][] data = new Object[][] {
            { "mwl", "mirand\u00eas" },
            { "fil", "filipin" },
            { "den", "scl\u00e2f" },
            { "%%NJIVA", "dialet di Gnive" },
            { "egy", "vieri egjizian" },
            { "es_ES", "spagn\u00fbl iberic" },
            { "sco", "scoz\u00eas" },
            { "scn", "sicilian" },
            { "aa", "afar" },
            { "ab", "abcazian" },
            { "tet", "tetum" },
            { "AD", "Andorra" },
            { "AE", "Emir\u00e2ts araps un\u00eets" },
            { "ae", "avestan" },
            { "nl_BE", "flamant" },
            { "AF", "Afghanistan" },
            { "af", "afrikaans" },
            { "AG", "Antigua e Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Albanie" },
            { "AM", "Armenie" },
            { "am", "amaric" },
            { "Arab", metaValue_ar },
            { "an", "aragon\u00eas" },
            { "AO", "Angola" },
            { "%%SOLBA", "dialet di Stolvize" },
            { "Jpan", metaValue_ja },
            { "AQ", "Antartic" },
            { "ar", metaValue_ar },
            { "AR", "Argjentine" },
            { "Hrkt", "katakana o hiragana" },
            { "AS", "Samoa merecanis" },
            { "as", "assam\u00eas" },
            { "AT", "Austrie" },
            { "AU", "Australie" },
            { "Lina", "line\u00e2r A" },
            { "av", "avar" },
            { "Linb", "line\u00e2r B" },
            { "AW", "Aruba" },
            { "en_US", "ingles merecan" },
            { "AX", "Isulis Aland" },
            { "ay", "aymar\u00e0" },
            { "AZ", "Azerbaigian" },
            { "az", "azerbaijani" },
            { "%%OSOJS", "dialet di Oseac" },
            { "%%AREVELA", "armen orient\u00e2l" },
            { "BA", "Bosnie e Ercegovine" },
            { "BB", "Barbados" },
            { "BD", "Bangladesh" },
            { "BE", "Belgjiche" },
            { "be", "bielor\u00f9s" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgarie" },
            { "bg", "bulgar" },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Sant Barth\u00e9lemy" },
            { "BM", "Bermuda" },
            { "bn", metaValue_bn },
            { "BN", "Brunei" },
            { "bo", metaValue_bo },
            { "BO", "Bolivie" },
            { "BR", "Bras\u00eel" },
            { "br", "breton" },
            { "BS", "Bahamas" },
            { "bs", "bosniac" },
            { "BT", "Bhutan" },
            { "BV", "Isule Bouvet" },
            { "BW", "Botswana" },
            { "Mymr", "myanmar" },
            { "BY", "Bielorussie" },
            { "BZ", "Belize" },
            { "CA", "Canade" },
            { "ca", "catalan" },
            { "CC", "Isulis Cocos" },
            { "CD", "Republiche Democratiche dal Congo" },
            { "ce", "cecen" },
            { "CF", "Republiche centri africane" },
            { "CG", "Congo - Brazzaville" },
            { "CH", "Svuizare" },
            { "ch", "chamorro" },
            { "CI", "Cueste di Avoli" },
            { "%%REVISED", "Ortografie revisade" },
            { "CK", "Isulis Cook" },
            { "CL", "Cile" },
            { "CM", "Camerun" },
            { "CN", "Cine" },
            { "CO", "Colombie" },
            { "co", "cors" },
            { "CP", "Isule Clipperton" },
            { "Orya", metaValue_or },
            { "CR", "Costa Rica" },
            { "cr", "cree" },
            { "cs", "cec" },
            { "CU", "Cuba" },
            { "cu", "scl\u00e2f de glesie" },
            { "CV", "Cj\u00e2f vert" },
            { "CX", "Isule Christmas" },
            { "CY", "Cipri" },
            { "cy", "gal\u00eas" },
            { "CZ", "Republiche ceche" },
            { "da", "dan\u00eas" },
            { "pt_PT", "portugh\u00eas iberic" },
            { "DE", "Gjermanie" },
            { "de", "todesc" },
            { "DG", "Diego Garcia" },
            { "DJ", "Gibuti" },
            { "DK", "Danimarcje" },
            { "Brai", "Braille" },
            { "DM", "Dominiche" },
            { "Bugi", "bugin\u00eas" },
            { "DO", "Republiche dominicane" },
            { "sga", "vieri irland\u00eas" },
            { "got", metaValue_got },
            { "es_419", "spagn\u00fbl de Americhe Latine" },
            { "DZ", "Alzerie" },
            { "type.ca.chinese", "calendari cin\u00eas" },
            { "EA", "Ceuta e Melilla" },
            { "EC", "Ecuador" },
            { "pap", "papiamento" },
            { "EE", "Estonie" },
            { "EG", "Egjit" },
            { "EH", "Sahara ocident\u00e2l" },
            { "ro_MD", "mold\u00e2f" },
            { "el", metaValue_el },
            { "en", "ingl\u00eas" },
            { "eo", "esperanto" },
            { "ER", "Eritree" },
            { "type.co.big5han", "ordin cin\u00eas tradizion\u00e2l - Big5" },
            { "ES", "Spagne" },
            { "es", "spagn\u00fbl" },
            { "ET", "Etiopie" },
            { "et", "eston" },
            { "EU", "Union europeane" },
            { "eu", "basc" },
            { "type.ca.gregorian", "calendari gregorian" },
            { "Hani", "han" },
            { "fa", "persian" },
            { "Hans", "Han semplific\u00e2t" },
            { "type.nu.latn", "numars ocident\u00e2i" },
            { "Hant", "Han tradizion\u00e2l" },
            { "ff", "fulah" },
            { "FI", "Finlandie" },
            { "fi", "finland\u00eas" },
            { "FJ", "Fizi" },
            { "fj", "fizian" },
            { "FK", "Isulis Falkland" },
            { "FM", "Micronesie" },
            { "FO", "Isulis Faroe" },
            { "fo", "faro\u00eas" },
            { "Taml", metaValue_ta },
            { "FR", "France" },
            { "fr", "franc\u00eas" },
            { "fy", "frisian" },
            { "type.ca.indian", "calendari nazion\u00e2l indian" },
            { "grc", "vieri gr\u00eac" },
            { "GA", "Gabon" },
            { "ga", "gaelic irland\u00eas" },
            { "GB", "Ream un\u00eet" },
            { "GD", "Grenada" },
            { "gd", "gaelic scoz\u00eas" },
            { "GE", "Gjeorgjie" },
            { "GF", "Guiana franc\u00eas" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Gjibraltar" },
            { "GL", "Groenlande" },
            { "gl", "galizian" },
            { "GM", "Gambia" },
            { "GN", "Guinee" },
            { "gn", "guaran\u00ec" },
            { "GP", "Guadalupe" },
            { "GQ", "Guinee ecuatori\u00e2l" },
            { "und", "indeterminade" },
            { "GR", "Grecie" },
            { "GS", "Georgia dal Sud e Isulis Sandwich dal Sud" },
            { "GT", "Guatemala" },
            { "gu", metaValue_gu },
            { "GU", "Guam" },
            { "gv", "manx" },
            { "GW", "Guinea-Bissau" },
            { "GY", "Guyana" },
            { "he", "ebraic" },
            { "hi", "hindi" },
            { "de_AT", "todesc de Austrie" },
            { "HK", "Regjon aministrative speci\u00e2l de Cine di Hong Kong" },
            { "HM", "Isule Heard e Isulis McDonald" },
            { "HN", "Honduras" },
            { "HR", "Cravuazie" },
            { "hr", "cravuat" },
            { "HT", "Haiti" },
            { "ht", "haitian" },
            { "HU", "Ongjarie" },
            { "hu", "ongjar\u00eas" },
            { "hy", metaValue_hy },
            { "IC", "Isulis Canariis" },
            { "peo", metaValue_peo },
            { "ID", "Indonesie" },
            { "id", "indonesian" },
            { "IE", "Irlande" },
            { "nap", "napoletan" },
            { "ig", "igbo" },
            { "ik", "inupiaq" },
            { "fro", "vieri franc\u00eas" },
            { "IL", "Isra\u00eal" },
            { "IM", "Isule di Man" },
            { "IN", "India" },
            { "IO", "Teritori britanic dal Ocean Indian" },
            { "io", "ido" },
            { "IQ", "Iraq" },
            { "IR", "Iran" },
            { "IS", "Islande" },
            { "is", "island\u00eas" },
            { "IT", "Italie" },
            { "it", "talian" },
            { "iu", "inuktitut" },
            { "ja", metaValue_ja },
            { "Mlym", metaValue_ml },
            { "JE", "Jersey" },
            { "type.ca.islamic", "calendari islamic" },
            { "Beng", metaValue_bn },
            { "JM", "Gjamaiche" },
            { "JO", "Jordanie" },
            { "JP", "Gjapon" },
            { "de_CH", "alt todesc de Svuizare" },
            { "ka", "gjeorgjian" },
            { "type.ca.buddhist", "calendari budist" },
            { "KE", "Kenya" },
            { "419", "Americhe latine" },
            { "KG", "Kirghizstan" },
            { "Goth", metaValue_got },
            { "KH", "Camboze" },
            { "KI", "Kiribati" },
            { "kk", "kazac" },
            { "kl", "kalaallisut" },
            { "km", metaValue_km },
            { "KM", "Comoris" },
            { "Knda", metaValue_kn },
            { "kn", metaValue_kn },
            { "KN", "San Kitts e Nevis" },
            { "fr_CA", "franc\u00eas dal Canade" },
            { "ko", metaValue_ko },
            { "KP", "Coree dal nord" },
            { "KR", "Coree dal sud" },
            { "ku", "curd" },
            { "fr_CH", "franc\u00eas de Svuizare" },
            { "KW", "Kuwait" },
            { "kw", "cornuali\u00eas" },
            { "KY", "Isulis Cayman" },
            { "KZ", "Kazachistan" },
            { "Cyrl", "cirilic" },
            { "la", metaValue_la },
            { "LA", "Laos" },
            { "LB", "Liban" },
            { "lb", "lussemburgh\u00eas" },
            { "LC", "Sante Lusie" },
            { "Cyrs", "cirilic dal vieri slavonic de glesie" },
            { "nds", "bas todesc" },
            { "LI", "Liechtenstein" },
            { "li", "limburgh\u00eas" },
            { "LK", "Sri Lanka" },
            { "Tibt", metaValue_bo },
            { "ln", "lingala" },
            { "fur", "furlan" },
            { "lo", metaValue_lo },
            { "cop", "coptic" },
            { "LR", "Liberie" },
            { "LS", "Lesotho" },
            { "LT", "Lituanie" },
            { "lt", "lituan" },
            { "LU", "Lussemburc" },
            { "LV", "Letonie" },
            { "lv", "leton" },
            { "LY", "Libie" },
            { "lad", "ladin" },
            { "Thaa", "thaana" },
            { "MA", "Maroc" },
            { "MC", "Monaco" },
            { "MD", "Moldavie" },
            { "ME", "Montenegro" },
            { "MF", "Sant Martin" },
            { "MG", "Madagascar" },
            { "mg", "malagasy" },
            { "Thai", metaValue_th },
            { "MH", "Isulis Marshall" },
            { "type.co.ducet", "ordenament predetermin\u00e2t Unicode" },
            { "mi", "maori" },
            { "mk", "macedon" },
            { "ml", metaValue_ml },
            { "ML", "Mali" },
            { "MM", "Birmanie" },
            { "mn", metaValue_mn },
            { "MN", "Mongolie" },
            { "MO", "Regjon aministrative speci\u00e2l de Cine di Macao" },
            { "MP", "Isulis Mariana dal Nord" },
            { "MQ", "Martiniche" },
            { "MR", "Mauritanie" },
            { "mr", "marathi" },
            { "MS", "Montserrat" },
            { "ms", "mal\u00eas" },
            { "MT", "Malta" },
            { "mt", "malt\u00eas" },
            { "MU", "Maurizi" },
            { "MV", "Maldivis" },
            { "MW", "Malawi" },
            { "MX", "Messic" },
            { "type.ca.japanese", "calendari gjapon\u00eas" },
            { "MY", "Malaysia" },
            { "Armn", metaValue_hy },
            { "MZ", "Mozambic" },
            { "NA", "Namibie" },
            { "type.co.search", "ricercje par fins gjener\u00e2i" },
            { "nb", "norvegj\u00eas bokm\u00e5l" },
            { "type.ca.hebrew", "calendari ebreu" },
            { "NC", "Gnove Caledonie" },
            { "nd", "ndebele setentrion\u00e2l" },
            { "NE", "Niger" },
            { "ne", "nepal\u00eas" },
            { "NF", "Isole Norfolk" },
            { "NG", "Nigerie" },
            { "NI", "Nicaragua" },
            { "NL", "Pa\u00ees bas" },
            { "nl", "oland\u00eas" },
            { "nn", "norvegj\u00eas nynorsk" },
            { "NO", "Norvegje" },
            { "no", "norvegj\u00eas" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "nv", "navajo" },
            { "NZ", "Gnove Zelande" },
            { "%%POLYTON", "Politoniche" },
            { "oc", "ocitan" },
            { "ang", "vieri ingl\u00eas" },
            { "OM", "Oman" },
            { "or", metaValue_or },
            { "os", "osetic" },
            { "Xpeo", metaValue_peo },
            { "PA", "Panam\u00e0" },
            { "pa", "punjabi" },
            { "type.ca.islamic-civil", "calendari islamic civ\u00eel" },
            { "%%LIPAW", "dialet di Lipovaz dal resian" },
            { "en_GB", "ingl\u00eas britanic" },
            { "PE", "Per\u00f9" },
            { "PF", "Polinesie franc\u00eas" },
            { "PG", "Papue Gnove Guinee" },
            { "PH", "Filipinis" },
            { "PK", "Pakistan" },
            { "PL", "Polonie" },
            { "pl", "polac" },
            { "PM", "San Pierre e Miquelon" },
            { "PN", "Pitcairn" },
            { "PR", "Porto Rico" },
            { "PS", "Teritoris palestin\u00eas" },
            { "ps", "pashto" },
            { "Bali", "balin\u00eas" },
            { "PT", "Portugal" },
            { "pt", "portugh\u00eas" },
            { "key.co", "ordenament" },
            { "PW", "Palau" },
            { "PY", "Paraguay" },
            { "pt_BR", "portugh\u00eas brasilian" },
            { "Hebr", "ebreu" },
            { "QA", "Qatar" },
            { "key.ca", "calendari" },
            { "Laoo", metaValue_lo },
            { "QO", "Oceanie periferiche" },
            { "qu", "quechua" },
            { "001", "Mont" },
            { "Ethi", "etiopic" },
            { "002", "Afriche" },
            { "003", "Americhe dal Nord" },
            { "RE", "Reunion" },
            { "005", "Americhe meridion\u00e2l" },
            { "009", "Oceanie" },
            { "rm", "ruman\u00e7" },
            { "key.cu", "monede" },
            { "RO", "Romanie" },
            { "ro", "romen" },
            { "RS", "Serbie" },
            { "RU", "Russie" },
            { "ru", "rus" },
            { "RW", "Ruande" },
            { "en_AU", "ingl\u00eas australian" },
            { "Ugar", "ugaritic" },
            { "SA", "Arabie Saudide" },
            { "sa", "sanscrit" },
            { "SB", "Isulis Salomon" },
            { "011", "Afriche ocident\u00e2l" },
            { "SC", "Seychelles" },
            { "sc", "sardegn\u00fbl" },
            { "SD", "Sudan" },
            { "sd", "sindhi" },
            { "013", "Americhe centr\u00e2l" },
            { "SE", "Svezie" },
            { "se", "sami setentrion\u00e2l" },
            { "014", "Afriche orient\u00e2l" },
            { "arc", "aramaic" },
            { "015", "Afriche setentrion\u00e2l" },
            { "SG", "Singapore" },
            { "sg", "sango" },
            { "SH", "Sante Eline" },
            { "017", "Afriche di mie\u00e7" },
            { "SI", "Slovenie" },
            { "si", "sinal\u00eas" },
            { "018", "Afriche meridion\u00e2l" },
            { "SJ", "Svalbard e Jan Mayen" },
            { "sux", "sumeric" },
            { "019", "Americhis" },
            { "SK", "Slovachie" },
            { "sk", "slovac" },
            { "SL", "Sierra Leone" },
            { "sl", "sloven" },
            { "SM", "San Marin" },
            { "sm", "samoan" },
            { "SN", "Senegal" },
            { "SO", "Somalie" },
            { "so", "somal" },
            { "sq", "alban\u00eas" },
            { "SR", "Suriname" },
            { "sr", "serp" },
            { "ss", "swati" },
            { "ST", "Sao Tom\u00e8 e Principe" },
            { "st", "sotho meridion\u00e2l" },
            { "Java", "gjavan\u00eas" },
            { "su", "sundan\u00eas" },
            { "%%NEDIS", "Dialet des valadis dal Nadison" },
            { "SV", "El Salvador" },
            { "sv", "sved\u00eas" },
            { "sw", "swahili" },
            { "SY", "Sirie" },
            { "SZ", "Swaziland" },
            { "ta", metaValue_ta },
            { "TA", "Tristan da Cunha" },
            { "021", "Americhe setentrion\u00e2l" },
            { "142", "Asie" },
            { "TC", "Isulis Turks e Caicos" },
            { "143", "Asie centr\u00e2l" },
            { "TD", "\u00c7ad" },
            { "te", metaValue_te },
            { "145", "Asie ocident\u00e2l" },
            { "TF", "Teritoris meridion\u00e2i franc\u00eas" },
            { "TG", "Togo" },
            { "tg", "tagic" },
            { "th", metaValue_th },
            { "TH", "Tailandie" },
            { "TJ", "Tazikistan" },
            { "en_CA", "ingl\u00eas canad\u00eas" },
            { "029", "caraibic" },
            { "TK", "Tokelau" },
            { "tk", "turcmen" },
            { "tl", metaValue_tl },
            { "TL", "Timor orient\u00e2l" },
            { "TM", "Turkmenistan" },
            { "TN", "Tunisie" },
            { "TO", "Tonga" },
            { "TR", "Turchie" },
            { "tr", "turc" },
            { "TT", "Trinidad e Tobago" },
            { "tt", "tartar" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "ast", "asturian" },
            { "ty", "tahitian" },
            { "TZ", "Tanzanie" },
            { "%%BISKE", "dialet di San Zor\u00e7 di Resie" },
            { "Zzzz", "codi\u00e7 par scrituris no codificadis" },
            { "150", "Europe" },
            { "UA", "Ucraine" },
            { "030", "Asie orient\u00e2l" },
            { "151", "Europe orient\u00e2l" },
            { "154", "Europe setentrion\u00e2l" },
            { "034", "Asie meridion\u00e2l" },
            { "155", "Europe ocident\u00e2l" },
            { "035", "Asie sud orient\u00e2l" },
            { "UG", "Uganda" },
            { "ug", "uigur" },
            { "type.co.pinyin", "ordin pinyin" },
            { "Kore", metaValue_ko },
            { "Ital", "vieri italic" },
            { "Zyyy", "comun" },
            { "039", "Europe meridion\u00e2l" },
            { "uk", "ucrain" },
            { "Sinh", "sinhala" },
            { "UM", "Isulis periferichis min\u00f4rs dai St\u00e2ts Un\u00eets" },
            { "ur", "urdu" },
            { "US", "St\u00e2ts Un\u00eets" },
            { "%%1994", "Ortografie resiane standard" },
            { "type.co.gb2312han", "ordin cin\u00eas semplific\u00e2t - GB2312" },
            { "UY", "Uruguay" },
            { "UZ", "Uzbechistan" },
            { "uz", "uzbec" },
            { "%%1996", "Ortografie todescje dal 1996" },
            { "type.co.stroke", "ordin segns" },
            { "VA", "Vatican" },
            { "pro", "vieri provenz\u00e2l" },
            { "VC", "San Vincent e lis Grenadinis" },
            { "VE", "Venezuela" },
            { "ve", "venda" },
            { "type.ca.roc", "calendari de Republiche di Cine" },
            { "VG", "Isulis vergjinis britanichis" },
            { "VI", "Isulis vergjinis americanis" },
            { "vi", "vietnamite" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "wa", "valon" },
            { "non", "vieri norvegj\u00eas" },
            { "053", "Australie e Gnove Zelande" },
            { "%%AREVMDA", "armen ocident\u00e2l" },
            { "054", "Melanesie" },
            { "WF", "Wallis e Futuna" },
            { "Grek", metaValue_el },
            { "type.co.traditional", "ordin tradizion\u00e2l" },
            { "057", "Regjon de Micronesie" },
            { "Xsux", "cuneiform sumeric-acadic" },
            { "wo", "wolof" },
            { "WS", "Samoa" },
            { "Cans", "Silabari unific\u00e2t aborigjens canad\u00eas" },
            { "Mong", metaValue_mn },
            { "Latf", "latin Fraktur" },
            { "Latn", metaValue_la },
            { "061", "Polinesie" },
            { "Latg", "latin gaelic" },
            { "xh", "xhosa" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "codi\u00e7 pes lenghis no scritis" },
            { "YE", "Yemen" },
            { "yi", "yiddish" },
            { "Syrc", "siriac" },
            { "%%ROZAJ", "Resian" },
            { "yo", "yoruba" },
            { "Syrj", "siriac ocident\u00e2l" },
            { "YT", "Mayotte" },
            { "ota", "turc otoman" },
            { "Syre", "siriac Estrangelo" },
            { "ZA", "Sud Afriche" },
            { "Deva", "devanagari" },
            { "zh", "cin\u00eas" },
            { "ZM", "Zambia" },
            { "zu", "zulu" },
            { "ZW", "Zimbabwe" },
            { "type.co.phonebook", "ordin elenc telefonic" },
            { "ZZ", "Regjon no cognossude o no valide" },
            { "Geor", "georgjian" },
            { "Runr", "runic" },
            { "nso", "sotho setentrion\u00e2l" },
            { "Syrn", "siriac orient\u00e2l" },
            { "Tglg", metaValue_tl },
            { "Egyd", "demotic egjizian" },
            { "Egyh", "jeratic egjizian" },
            { "Egyp", "jeroglifics egjizians" },
            { "zh_Hans", "cin\u00eas semplific\u00e2t" },
            { "Hung", "vieri ongjar\u00eas" },
            { "%%1901", "Ortografie todescje tradizion\u00e2l" },
            { "Maya", "jeroglifics Maya" },
            { "zh_Hant", "cin\u00eas tradizion\u00e2l" },
            { "%%VALENCIA", "valenzian" },
            { "Cprt", "cipriot" },
            { "Copt", "copt" },
            { "Khmr", metaValue_km },
            { "mul", "lenghis multiplis" },
            { "Glag", "glagolitic" },
            { "Telu", metaValue_te },
        };
        return data;
    }
}
