/*
 * Copyright (c) 2012, 2023, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_gu extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_TV = "\u0aa4\u0ac1\u0ab5\u0abe\u0ab2\u0ac1";
        final String metaValue_ae = "\u0a85\u0ab5\u0ac7\u0ab8\u0acd\u0aa4\u0aa8";
        final String metaValue_ar = "\u0a85\u0ab0\u0aac\u0ac0";
        final String metaValue_el = "\u0a97\u0acd\u0ab0\u0ac0\u0a95";
        final String metaValue_gu = "\u0a97\u0ac1\u0a9c\u0ab0\u0abe\u0aa4\u0ac0";
        final String metaValue_he = "\u0ab9\u0ac0\u0aac\u0acd\u0ab0\u0ac1";
        final String metaValue_jv = "\u0a9c\u0abe\u0ab5\u0abe\u0aa8\u0ac0\u0ab8";
        final String metaValue_km = "\u0a96\u0acd\u0aae\u0ac7\u0ab0";
        final String metaValue_ko = "\u0a95\u0acb\u0ab0\u0abf\u0aaf\u0aa8";
        final String metaValue_la = "\u0ab2\u0ac7\u0a9f\u0abf\u0aa8";
        final String metaValue_lo = "\u0ab2\u0abe\u0a93";
        final String metaValue_ml = "\u0aae\u0ab2\u0aaf\u0abe\u0ab2\u0aae";
        final String metaValue_mn = "\u0aae\u0acb\u0a82\u0a97\u0acb\u0ab2\u0abf\u0aaf\u0aa8";
        final String metaValue_or = "\u0a89\u0aa1\u0abf\u0aaf\u0abe";
        final String metaValue_ta = "\u0aa4\u0aae\u0abf\u0ab2";
        final String metaValue_te = "\u0aa4\u0ac7\u0ab2\u0ac1\u0a97\u0ac1";
        final String metaValue_ccp = "\u0a9a\u0a95\u0aae\u0abe";
        final String metaValue_cop = "\u0a95\u0acb\u0aaa\u0acd\u0a9f\u0abf\u0a95";
        final String metaValue_got = "\u0a97\u0acb\u0aa5\u0abf\u0a95";
        final String metaValue_phn = "\u0aab\u0acb\u0aa8\u0abf\u0ab6\u0abf\u0aaf\u0aa8";
        final String metaValue_vai = "\u0ab5\u0abe\u0a87";
        final String metaValue_zbl = "\u0aac\u0acd\u0ab2\u0abf\u0ab8\u0abf\u0aae\u0acd\u0aac\u0acb\u0ab2\u0acd\u0ab8";
        final Object[][] data = new Object[][] {
            { "ksh", "\u0a95\u0acb\u0ab2\u0acb\u0a97\u0acd\u0aa8\u0abf\u0aaf\u0aa8" },
            { "Ogam", "\u0a93\u0a98\u0abe\u0aae" },
            { "mwl", "\u0aae\u0abf\u0ab0\u0abe\u0a82\u0aa1\u0ac0" },
            { "Zsym", "\u0aaa\u0acd\u0ab0\u0aa4\u0ac0\u0a95\u0acb" },
            { "cch", "\u0a85\u0aa4\u0acd\u0ab8\u0aae" },
            { "mwr", "\u0aae\u0abe\u0ab0\u0ab5\u0abe\u0aa1\u0ac0" },
            { "Tagb", "\u0aa4\u0a97\u0aac\u0aa8\u0acd\u0ab5\u0abe" },
            { "Zsye", "\u0a87\u0aae\u0acb\u0a9c\u0ac0" },
            { "ccp", metaValue_ccp },
            { "egy", "\u0aaa\u0acd\u0ab0\u0abe\u0a9a\u0ac0\u0aa8 \u0a87\u0a9c\u0ac0\u0aaa\u0acd\u0ab6\u0abf\u0aaf\u0aa8" },
            { "raj", "\u0ab0\u0abe\u0a9c\u0ab8\u0acd\u0aa5\u0abe\u0aa8\u0ac0" },
            { "Phag", "\u0aab\u0abe\u0a97\u0acd\u0ab8-\u0aaa\u0abe" },
            { "tem", "\u0a9f\u0abf\u0aae\u0acd\u0aa8\u0ac7" },
            { "teo", "\u0aa4\u0ac7\u0ab8\u0acb" },
            { "rap", "\u0ab0\u0abe\u0aaa\u0abe\u0aa8\u0ac1\u0a87" },
            { "ter", "\u0aa4\u0ac7\u0ab0\u0ac7\u0aa8\u0acb" },
            { "AC", "\u0a8f\u0ab8\u0ac7\u0aa8\u0acd\u0ab6\u0aa8 \u0a86\u0a87\u0ab2\u0ac7\u0aa8\u0acd\u0aa1" },
            { "rar", "\u0ab0\u0abe\u0ab0\u0acb\u0a9f\u0acb\u0a82\u0a97\u0aa8" },
            { "tet", "\u0aa4\u0ac7\u0aa4\u0ac1\u0aae" },
            { "AD", "\u0a8d\u0a82\u0aa1\u0acb\u0ab0\u0abe" },
            { "AE", "\u0aaf\u0ac1\u0aa8\u0abe\u0a87\u0a9f\u0ac7\u0aa1 \u0a86\u0ab0\u0aac \u0a85\u0aae\u0ac0\u0ab0\u0abe\u0aa4" },
            { "nl_BE", "\u0aab\u0acd\u0ab2\u0ac7\u0aae\u0abf\u0ab6" },
            { "AF", "\u0a85\u0aab\u0a98\u0abe\u0aa8\u0abf\u0ab8\u0acd\u0aa4\u0abe\u0aa8" },
            { "AG", "\u0a8d\u0aa8\u0acd\u0a9f\u0abf\u0a97\u0ac1\u0a86 \u0a85\u0aa8\u0ac7 \u0aac\u0ab0\u0acd\u0aae\u0ac1\u0aa1\u0abe" },
            { "type.ca.ethiopic", "\u0a87\u0aa5\u0abf\u0a93\u0aaa\u0abf\u0a95 \u0a95\u0ac7\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0ab0" },
            { "AI", "\u0a8d\u0a82\u0a97\u0acd\u0ab5\u0abf\u0ab2\u0abe" },
            { "key.tz", "\u0ab8\u0aae\u0aaf \u0a9d\u0acb\u0aa8" },
            { "AL", "\u0a85\u0ab2\u0acd\u0aac\u0ac7\u0aa8\u0abf\u0aaf\u0abe" },
            { "AM", "\u0a86\u0ab0\u0acd\u0aae\u0ac7\u0aa8\u0abf\u0aaf\u0abe" },
            { "Teng", "\u0aa4\u0ac7\u0aa8\u0acd\u0a97\u0ab5\u0abe\u0ab0" },
            { "AO", "\u0a85\u0a82\u0a97\u0acb\u0ab2\u0abe" },
            { "AQ", "\u0a8f\u0aa8\u0acd\u0a9f\u0abe\u0ab0\u0acd\u0a95\u0a9f\u0abf\u0a95\u0abe" },
            { "AR", "\u0a86\u0ab0\u0acd\u0a9c\u0ac7\u0aa8\u0acd\u0a9f\u0ac0\u0aa8\u0abe" },
            { "Prti", "\u0a87\u0aa8\u0acd\u0ab8\u0acd\u0a95\u0acd\u0ab0\u0abf\u0aaa\u0acd\u0ab6\u0aa8\u0ab2 \u0aaa\u0abe\u0ab0\u0acd\u0aa5\u0abf\u0aaf\u0aa8" },
            { "AS", "\u0a85\u0aae\u0ac7\u0ab0\u0abf\u0a95\u0aa8 \u0ab8\u0aae\u0acb\u0a86" },
            { "AT", "\u0a91\u0ab8\u0acd\u0a9f\u0acd\u0ab0\u0abf\u0aaf\u0abe" },
            { "AU", "\u0a91\u0ab8\u0acd\u0a9f\u0acd\u0ab0\u0ac7\u0ab2\u0abf\u0aaf\u0abe" },
            { "AW", "\u0a85\u0ab0\u0ac1\u0aac\u0abe" },
            { "en_US", "\u0a85\u0aae\u0ac7\u0ab0\u0abf\u0a95\u0aa8 \u0a85\u0a82\u0a97\u0acd\u0ab0\u0ac7\u0a9c\u0ac0" },
            { "AX", "\u0a91\u0ab2\u0ac7\u0aa8\u0acd\u0aa1 \u0a86\u0a87\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0acd\u0ab8" },
            { "AZ", "\u0a85\u0a9d\u0ab0\u0aac\u0ac8\u0a9c\u0abe\u0aa8" },
            { "BA", "\u0aac\u0acb\u0ab8\u0acd\u0aa8\u0abf\u0aaf\u0abe \u0a85\u0aa8\u0ac7 \u0ab9\u0ab0\u0acd\u0a9d\u0ac7\u0a97\u0acb\u0ab5\u0abf\u0aa8\u0abe" },
            { "BB", "\u0aac\u0abe\u0ab0\u0aac\u0abe\u0aa1\u0acb\u0ab8" },
            { "ceb", "\u0ab8\u0abf\u0aac\u0ac1\u0a86\u0aa8\u0acb" },
            { "BD", "\u0aac\u0abe\u0a82\u0a97\u0acd\u0ab2\u0abe\u0aa6\u0ac7\u0ab6" },
            { "kum", "\u0a95\u0ac1\u0aae\u0ac0\u0a95" },
            { "BE", "\u0aac\u0ac7\u0ab2\u0acd\u0a9c\u0ac0\u0aaf\u0aae" },
            { "gmh", "\u0aae\u0aa7\u0acd\u0aaf \u0ab9\u0abe\u0a87 \u0a9c\u0ab0\u0acd\u0aae\u0aa8" },
            { "BF", "\u0aac\u0ac1\u0ab0\u0acd\u0a95\u0abf\u0aa8\u0abe \u0aab\u0abe\u0ab8\u0acb" },
            { "BG", "\u0aac\u0ab2\u0acd\u0a97\u0ac7\u0ab0\u0abf\u0aaf\u0abe" },
            { "BH", "\u0aac\u0ac7\u0ab9\u0ab0\u0ac0\u0aa8" },
            { "BI", "\u0aac\u0ac1\u0ab0\u0ac1\u0a82\u0aa1\u0ac0" },
            { "BJ", "\u0aac\u0ac7\u0aa8\u0abf\u0aa8" },
            { "BL", "\u0ab8\u0ac7\u0a82\u0a9f \u0aac\u0abe\u0ab0\u0acd\u0aa5\u0ac7\u0ab2\u0ac7\u0aae\u0ac0" },
            { "BM", "\u0aac\u0ab0\u0acd\u0aae\u0ac1\u0aa1\u0abe" },
            { "kut", "\u0a95\u0ac1\u0aa4\u0ac7\u0aa8\u0abe\u0a87" },
            { "myv", "\u0a8f\u0ab0\u0acd\u0a9d\u0aaf\u0abe" },
            { "BN", "\u0aac\u0acd\u0ab0\u0ac1\u0aa8\u0ac7\u0a87" },
            { "BO", "\u0aac\u0acb\u0ab2\u0abf\u0ab5\u0abf\u0aaf\u0abe" },
            { "BQ", "\u0a95\u0ac7\u0ab0\u0ac7\u0aac\u0abf\u0aaf\u0aa8 \u0aa8\u0ac7\u0aa7\u0ab0\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0acd\u0a9d" },
            { "BR", "\u0aac\u0acd\u0ab0\u0abe\u0a9d\u0abf\u0ab2" },
            { "BS", "\u0aac\u0ab9\u0abe\u0aae\u0abe\u0ab8" },
            { "xog", "\u0ab8\u0acb\u0a97\u0abe" },
            { "BT", "\u0aad\u0ac2\u0a9f\u0abe\u0aa8" },
            { "BV", "\u0aac\u0acc\u0ab5\u0ac7\u0aa4 \u0a86\u0a87\u0ab2\u0ac7\u0aa8\u0acd\u0aa1" },
            { "BW", "\u0aac\u0acb\u0aa4\u0acd\u0ab8\u0acd\u0ab5\u0abe\u0aa8\u0abe" },
            { "BY", "\u0aac\u0ac7\u0ab2\u0abe\u0ab0\u0ac1\u0ab8" },
            { "BZ", "\u0aac\u0ac7\u0ab2\u0ac0\u0a9d" },
            { "Visp", "\u0ab5\u0abf\u0ab8\u0abf\u0aac\u0ab2 \u0ab8\u0acd\u0aaa\u0ac0\u0a9a" },
            { "type.ca.persian", "\u0aaa\u0ab0\u0acd\u0ab6\u0abf\u0aaf\u0aa8 \u0a95\u0ac7\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0ab0" },
            { "type.nu.hebr", "\u0ab9\u0abf\u0aac\u0acd\u0ab0\u0ac1 \u0ab8\u0a82\u0a96\u0acd\u0aaf\u0abe\u0a93" },
            { "CA", "\u0a95\u0ac7\u0aa8\u0ac7\u0aa1\u0abe" },
            { "CC", "\u0a95\u0acb\u0a95\u0acb\u0a9d (\u0a95\u0ac0\u0ab2\u0ac0\u0a82\u0a97) \u0a86\u0a87\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0acd\u0ab8" },
            { "mzn", "\u0aae\u0a9d\u0abe\u0aa8\u0acd\u0aa6\u0ac7\u0ab0\u0abe\u0aa8\u0ac0" },
            { "CD", "\u0a95\u0acb\u0a82\u0a97\u0acb - \u0a95\u0abf\u0a82\u0ab6\u0abe\u0ab8\u0abe" },
            { "CF", "\u0ab8\u0ac7\u0aa8\u0acd\u0a9f\u0acd\u0ab0\u0ab2 \u0a86\u0aab\u0acd\u0ab0\u0abf\u0a95\u0aa8 \u0ab0\u0abf\u0aaa\u0aac\u0acd\u0ab2\u0abf\u0a95" },
            { "CG", "\u0a95\u0acb\u0a82\u0a97\u0acb - \u0aac\u0acd\u0ab0\u0abe\u0a9d\u0abe\u0ab5\u0abf\u0ab2\u0ac7" },
            { "CH", "\u0ab8\u0acd\u0ab5\u0abf\u0a9f\u0acd\u0a9d\u0ab0\u0acd\u0ab2\u0ac5\u0aa8\u0acd\u0aa1" },
            { "CI", "\u0a95\u0acb\u0a9f \u0aa1\u0ac0\u0a86\u0a87\u0ab5\u0ab0\u0ac0" },
            { "CK", "\u0a95\u0ac1\u0a95 \u0a86\u0a87\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0acd\u0ab8" },
            { "CL", "\u0a9a\u0abf\u0ab2\u0ac0" },
            { "Kthi", "\u0a95\u0ac8\u0aa5\u0ac0" },
            { "CM", "\u0a95\u0ac5\u0aae\u0ab0\u0ac2\u0aa8" },
            { "CN", "\u0a9a\u0ac0\u0aa8" },
            { "CO", "\u0a95\u0acb\u0ab2\u0aae\u0acd\u0aac\u0abf\u0aaf\u0abe" },
            { "CP", "\u0a95\u0acd\u0ab2\u0abf\u0aaa\u0ab0\u0a9f\u0aa8 \u0a86\u0a87\u0ab2\u0ac7\u0aa8\u0acd\u0aa1" },
            { "CR", "\u0a95\u0acb\u0ab8\u0acd\u0a9f\u0abe \u0ab0\u0abf\u0a95\u0abe" },
            { "CU", "\u0a95\u0acd\u0aaf\u0ac1\u0aac\u0abe" },
            { "CV", "\u0a95\u0ac5\u0aaa \u0ab5\u0ab0\u0acd\u0aa1\u0ac7" },
            { "CW", "\u0a95\u0acd\u0aaf\u0ac1\u0ab0\u0abe\u0ab8\u0abe\u0a93" },
            { "CX", "\u0a95\u0acd\u0ab0\u0abf\u0ab8\u0aae\u0ab8 \u0a86\u0a87\u0ab2\u0ac7\u0aa8\u0acd\u0aa1" },
            { "CY", "\u0ab8\u0abe\u0aaf\u0aaa\u0acd\u0ab0\u0ab8" },
            { "CZ", "\u0a9a\u0ac7\u0a95\u0ac0\u0aaf\u0abe" },
            { "eka", "\u0a8f\u0a95\u0abe\u0a9c\u0ac1\u0a95" },
            { "DE", "\u0a9c\u0ab0\u0acd\u0aae\u0aa8\u0ac0" },
            { "goh", "\u0a9c\u0ac2\u0aa8\u0ac0 \u0ab9\u0abe\u0a87 \u0a9c\u0ab0\u0acd\u0aae\u0aa8" },
            { "ace", "\u0a85\u0a9a\u0ac0\u0aa8\u0ac0" },
            { "cgg", "\u0a9a\u0abf\u0a97\u0abe" },
            { "DG", "\u0aa1\u0abf\u0a8f\u0a97\u0acb \u0a97\u0abe\u0ab0\u0ab8\u0abf\u0a86" },
            { "gom", "\u0a97\u0acb\u0a85\u0aa8 \u0a95\u0acb\u0a82\u0a95\u0aa3\u0ac0" },
            { "type.nu.deva", "\u0aa6\u0ac7\u0ab5\u0aa8\u0abe\u0a97\u0ab0\u0ac0 \u0a85\u0a82\u0a95\u0acb" },
            { "DJ", "\u0a9c\u0ac0\u0aac\u0acc\u0a9f\u0ac0" },
            { "DK", "\u0aa1\u0ac7\u0aa8\u0aae\u0abe\u0ab0\u0acd\u0a95" },
            { "ach", "\u0a8f\u0a95\u0acb\u0ab2\u0ac0" },
            { "gon", "\u0a97\u0acb\u0a82\u0aa1\u0ac0" },
            { "Brai", "\u0aac\u0acd\u0ab0\u0ac7\u0ab2" },
            { "Brah", "\u0aac\u0acd\u0ab0\u0ab9\u0acd\u0aae\u0ac0" },
            { "DM", "\u0aa1\u0acb\u0aae\u0abf\u0aa8\u0abf\u0a95\u0abe" },
            { "type.nu.armnlow", "\u0a85\u0ab0\u0acd\u0aae\u0ac7\u0aa8\u0abf\u0aaf\u0aa8 \u0aa8\u0abe\u0aa8\u0abe \u0a85\u0a95\u0acd\u0ab7\u0ab0\u0aa8\u0ac0 \u0ab8\u0a82\u0a96\u0acd\u0aaf\u0abe\u0a93" },
            { "DO", "\u0aa1\u0acb\u0aae\u0abf\u0aa8\u0abf\u0a95\u0aa8 \u0ab0\u0abf\u0aaa\u0aac\u0acd\u0ab2\u0abf\u0a95" },
            { "gor", "\u0a97\u0acb\u0ab0\u0acb\u0aa8\u0acd\u0aa4\u0abe\u0ab2\u0acb" },
            { "got", metaValue_got },
            { "Mtei", "\u0aae\u0ac7\u0a87\u0aa4\u0ac7\u0a87 \u0aae\u0abe\u0aaf\u0ac7\u0a95" },
            { "zun", "\u0a9d\u0ac2\u0aa8\u0ac0" },
            { "tig", "\u0a9f\u0abe\u0a87\u0a97\u0acd\u0ab0\u0ac7" },
            { "DZ", "\u0a85\u0ab2\u0acd\u0a9c\u0ac0\u0ab0\u0abf\u0aaf\u0abe" },
            { "pag", "\u0aaa\u0a82\u0a97\u0abe\u0ab8\u0ac0\u0aa8\u0abe\u0aa8" },
            { "type.d0.hwidth", "\u0a85\u0ab0\u0acd\u0aa7\u0aaa\u0ab9\u0acb\u0ab3\u0abe\u0a88" },
            { "pal", "\u0aaa\u0ab9\u0ab2\u0ab5\u0ac0" },
            { "EA", "\u0ab8\u0acd\u0aaf\u0ac1\u0a9f\u0abe \u0a85\u0aa8\u0ac7 \u0aae\u0ac7\u0ab2\u0abf\u0ab2\u0abe" },
            { "chb", "\u0a9a\u0abf\u0aac\u0acd\u0a9a\u0abe" },
            { "pam", "\u0aaa\u0aae\u0acd\u0aaa\u0abe\u0aa8\u0acd\u0a97\u0abe" },
            { "EC", "\u0a8f\u0a95\u0acd\u0ab5\u0abe\u0aa1\u0acb\u0ab0" },
            { "pap", "\u0aaa\u0abe\u0aaa\u0abf\u0aaf\u0abe\u0aae\u0ac7\u0aa8\u0acd\u0a9f\u0acb" },
            { "ada", "\u0a85\u0aa6\u0abe\u0a82\u0a97\u0acd\u0aae\u0ac0" },
            { "EE", "\u0a8f\u0ab8\u0acd\u0a9f\u0acb\u0aa8\u0abf\u0aaf\u0abe" },
            { "tiv", "\u0aa4\u0abf\u0ab5" },
            { "EG", "\u0a87\u0a9c\u0abf\u0aaa\u0acd\u0aa4" },
            { "EH", "\u0aaa\u0ab6\u0acd\u0a9a\u0abf\u0aae\u0ac0 \u0ab8\u0ab9\u0abe\u0ab0\u0abe" },
            { "chg", "\u0a9b\u0a97\u0abe\u0aa4\u0abe\u0a87" },
            { "pau", "\u0aaa\u0ab2\u0abe\u0a89\u0a86\u0aa8" },
            { "chk", "\u0a9a\u0ac2\u0a95\u0ac0\u0ab8" },
            { "chn", "\u0a9a\u0abf\u0aa8\u0ac2\u0a95 \u0a9c\u0abe\u0ab0\u0acd\u0a97\u0aa8" },
            { "chm", "\u0aae\u0abe\u0ab0\u0ac0" },
            { "chp", "\u0ab6\u0abf\u0aaa\u0ac7\u0ab5\u0acd\u0aaf\u0abe\u0aa8" },
            { "cho", "\u0a9a\u0acb\u0a95\u0acd\u0aa4\u0acc" },
            { "chr", "\u0ab6\u0ac7\u0ab0\u0acb\u0a95\u0ac0" },
            { "ER", "\u0a8f\u0ab0\u0abf\u0a9f\u0acd\u0ab0\u0abf\u0aaf\u0abe" },
            { "ES", "\u0ab8\u0acd\u0aaa\u0ac7\u0aa8" },
            { "ET", "\u0a87\u0aa5\u0abf\u0a93\u0aaa\u0abf\u0aaf\u0abe" },
            { "EU", "\u0aaf\u0ac1\u0ab0\u0acb\u0aaa\u0abf\u0aaf\u0aa8 \u0ab8\u0a82\u0a98" },
            { "elx", "\u0a8f\u0ab2\u0abe\u0aae\u0abe\u0a87\u0a9f" },
            { "type.ca.gregorian", "\u0a97\u0acd\u0ab0\u0ac7\u0a97\u0acb\u0ab0\u0abf\u0a85\u0aa8 \u0a95\u0ac7\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0ab0" },
            { "EZ", "\u0aaf\u0ac1\u0ab0\u0acb\u0a9d\u0acb\u0aa8" },
            { "chy", "\u0ab6\u0ac7\u0aaf\u0ac7\u0aa8\u0acd\u0aa8" },
            { "type.nu.gujr", "\u0a97\u0ac1\u0a9c\u0ab0\u0abe\u0aa4\u0ac0 \u0a85\u0a82\u0a95\u0acb" },
            { "Inds", "\u0ab8\u0abf\u0aa8\u0acd\u0aa7\u0ac1" },
            { "ady", "\u0a85\u0aa6\u0abf\u0a98\u0ac7" },
            { "FI", "\u0aab\u0abf\u0aa8\u0ab2\u0ac7\u0aa8\u0acd\u0aa1" },
            { "FJ", "\u0aab\u0ac0\u0a9c\u0ac0" },
            { "FK", "\u0aab\u0ac9\u0a95\u0ab2\u0ac7\u0aa8\u0acd\u0aa1 \u0a86\u0a87\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0acd\u0ab8" },
            { "FM", "\u0aae\u0abe\u0a87\u0a95\u0acd\u0ab0\u0acb\u0aa8\u0ac7\u0ab6\u0abf\u0aaf\u0abe" },
            { "key.va", "\u0ab2\u0acb\u0a95\u0ac7\u0ab2 \u0ab5\u0ac7\u0ab0\u0abf\u0a8f\u0aa8\u0acd\u0a9f" },
            { "FO", "\u0aab\u0ac7\u0ab0\u0acb \u0a86\u0a87\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0acd\u0ab8" },
            { "Taml", metaValue_ta },
            { "FR", "\u0aab\u0acd\u0ab0\u0abe\u0a82\u0ab8" },
            { "tkl", "\u0aa4\u0acb\u0a95\u0ac7\u0ab2\u0abe\u0a89" },
            { "grb", "\u0a97\u0acd\u0ab0\u0ac7\u0aac\u0acb" },
            { "root", "\u0ab0\u0ac2\u0a9f" },
            { "type.ca.indian", "\u0aad\u0abe\u0ab0\u0aa4\u0ac0\u0aaf \u0ab0\u0abe\u0ab7\u0acd\u0a9f\u0acd\u0ab0\u0ac0\u0aaf \u0a95\u0ac7\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0ab0" },
            { "grc", "\u0aaa\u0acd\u0ab0\u0abe\u0a9a\u0ac0\u0aa8 \u0a97\u0acd\u0ab0\u0ac0\u0a95" },
            { "GA", "\u0a97\u0ac7\u0aac\u0aa8" },
            { "vot", "\u0ab5\u0acb\u0a9f\u0abf\u0a95" },
            { "GB", "\u0aaf\u0ac1\u0aa8\u0abe\u0a87\u0a9f\u0ac7\u0aa1 \u0a95\u0abf\u0a82\u0a97\u0aa1\u0aae" },
            { "pcm", "\u0aa8\u0abe\u0a87\u0a9c\u0ac7\u0ab0\u0abf\u0aaf\u0aa8 \u0aaa\u0ac0\u0a9c\u0ac0\u0aa8" },
            { "GD", "\u0a97\u0acd\u0ab0\u0ac7\u0aa8\u0ac7\u0aa1\u0abe" },
            { "GE", "\u0a9c\u0acd\u0aaf\u0acb\u0ab0\u0acd\u0a9c\u0abf\u0aaf\u0abe" },
            { "GF", "\u0aab\u0acd\u0ab0\u0ac7\u0a82\u0a9a \u0a97\u0aaf\u0abe\u0aa8\u0abe" },
            { "GG", "\u0a97\u0acd\u0ab5\u0ac7\u0ab0\u0acd\u0aa8\u0ab8\u0ac7" },
            { "GH", "\u0a98\u0abe\u0aa8\u0abe" },
            { "Tale", "\u0aa4\u0abe\u0a87 \u0ab2\u0ac0" },
            { "GI", "\u0a9c\u0ac0\u0aac\u0acd\u0ab0\u0abe\u0ab2\u0acd\u0a9f\u0ab0" },
            { "afh", "\u0a85\u0aab\u0acd\u0ab0\u0abf\u0ab9\u0abf\u0ab2\u0ac0" },
            { "GL", "\u0a97\u0acd\u0ab0\u0ac0\u0aa8\u0ab2\u0ac7\u0aa8\u0acd\u0aa1" },
            { "enm", "\u0aae\u0abf\u0aa1\u0abf\u0ab2 \u0a85\u0a82\u0a97\u0acd\u0ab0\u0ac7\u0a9c\u0ac0" },
            { "GM", "\u0a97\u0ac7\u0aae\u0acd\u0aac\u0abf\u0aaf\u0abe" },
            { "GN", "\u0a97\u0abf\u0aa8\u0ac0" },
            { "GP", "\u0a97\u0acd\u0ab5\u0abe\u0aa1\u0ac7\u0ab2\u0acb\u0aaa" },
            { "GQ", "\u0a87\u0a95\u0acd\u0ab5\u0ac7\u0a9f\u0acb\u0ab0\u0abf\u0aaf\u0ab2 \u0a97\u0abf\u0aa8\u0ac0" },
            { "GR", "\u0a97\u0acd\u0ab0\u0ac0\u0ab8" },
            { "GS", "\u0aa6\u0a95\u0acd\u0ab7\u0abf\u0aa3 \u0a9c\u0acd\u0aaf\u0acb\u0ab0\u0acd\u0a9c\u0abf\u0aaf\u0abe \u0a85\u0aa8\u0ac7 \u0aa6\u0a95\u0acd\u0ab7\u0abf\u0aa3 \u0ab8\u0ac7\u0aa8\u0acd\u0aa1\u0ab5\u0abf\u0a9a \u0a86\u0a87\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0acd\u0ab8" },
            { "GT", "\u0a97\u0acd\u0ab5\u0abe\u0a9f\u0ac7\u0aae\u0abe\u0ab2\u0abe" },
            { "GU", "\u0a97\u0acd\u0ab5\u0abe\u0aae" },
            { "GW", "\u0a97\u0abf\u0aa8\u0ac0-\u0aac\u0abf\u0ab8\u0abe\u0a89" },
            { "tli", "\u0a95\u0acd\u0ab2\u0ac0\u0aa8\u0acd\u0a97\u0a95\u0abf\u0a9f" },
            { "tlh", "\u0a95\u0acd\u0ab2\u0abf\u0aa8\u0acd\u0a97\u0acb\u0aa8" },
            { "Talu", "\u0aa8\u0ab5\u0ac0\u0aa8 \u0aa4\u0abe\u0a87 \u0ab2\u0ac2" },
            { "GY", "\u0a97\u0aaf\u0abe\u0aa8\u0abe" },
            { "ckb", "\u0ab8\u0ac7\u0aa8\u0acd\u0a9f\u0acd\u0ab0\u0ab2 \u0a95\u0ac1\u0ab0\u0acd\u0aa6\u0abf\u0ab6" },
            { "zxx", "\u0a95\u0acb\u0a87 \u0aad\u0abe\u0ab7\u0abe\u0ab6\u0abe\u0ab8\u0acd\u0aa4\u0acd\u0ab0\u0ac0\u0aaf \u0ab8\u0abe\u0aae\u0a97\u0acd\u0ab0\u0ac0 \u0aa8\u0aa5\u0ac0" },
            { "de_AT", "\u0a93\u0ab8\u0acd\u0a9f\u0acd\u0ab0\u0abf\u0a85\u0aa8 \u0a9c\u0ab0\u0acd\u0aae\u0aa8" },
            { "Vaii", metaValue_vai },
            { "HK", "\u0ab9\u0acb\u0a82\u0a97\u0a95\u0acb\u0a82\u0a97 SAR \u0a9a\u0ac0\u0aa8" },
            { "HM", "\u0ab9\u0ab0\u0acd\u0aa1 \u0a85\u0aa8\u0ac7 \u0aae\u0ac7\u0a95\u0aa1\u0acb\u0aa8\u0abe\u0ab2\u0acd\u0aa1 \u0a86\u0a87\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0acd\u0ab8" },
            { "HN", "\u0ab9\u0acb\u0aa8\u0acd\u0aa1\u0ac1\u0ab0\u0ab8" },
            { "HR", "\u0a95\u0acd\u0ab0\u0acb\u0a8f\u0ab6\u0abf\u0aaf\u0abe" },
            { "agq", "\u0a85\u0a98\u0ac7\u0aae" },
            { "gsw", "\u0ab8\u0acd\u0ab5\u0abf\u0ab8 \u0a9c\u0ab0\u0acd\u0aae\u0aa8" },
            { "type.ca.islamic-umalqura", "\u0a87\u0ab8\u0acd\u0ab2\u0abe\u0aae\u0abf\u0a95 \u0a95\u0ac7\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0ab0 (\u0a89\u0aae\u0aae \u0a85\u0ab2-\u0a95\u0ac1\u0ab0\u0abe)" },
            { "HT", "\u0ab9\u0ac8\u0aa4\u0abf" },
            { "HU", "\u0ab9\u0a82\u0a97\u0ac7\u0ab0\u0ac0" },
            { "tmh", "\u0aa4\u0abe\u0aae\u0abe\u0ab6\u0ac7\u0a96" },
            { "IC", "\u0a95\u0ac5\u0aa8\u0ac7\u0ab0\u0ac0 \u0a86\u0a87\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0acd\u0ab8" },
            { "ID", "\u0a87\u0aa8\u0acd\u0aa1\u0acb\u0aa8\u0ac7\u0ab6\u0abf\u0aaf\u0abe" },
            { "peo", "\u0a9c\u0ac2\u0aa8\u0ac0 \u0aab\u0abe\u0ab0\u0ab8\u0ac0" },
            { "IE", "\u0a86\u0aaf\u0ab0\u0acd\u0ab2\u0ac7\u0aa8\u0acd\u0aa1" },
            { "nap", "\u0aa8\u0ac7\u0aaa\u0acb\u0ab2\u0abf\u0a9f\u0abe\u0aa8" },
            { "naq", "\u0aa8\u0aae\u0abe" },
            { "zza", "\u0a9d\u0abe\u0a9d\u0abe" },
            { "IL", "\u0a87\u0a9d\u0ab0\u0abe\u0a87\u0ab2" },
            { "IM", "\u0a86\u0a87\u0ab2 \u0a91\u0aab \u0aae\u0ac7\u0aa8" },
            { "IN", "\u0aad\u0abe\u0ab0\u0aa4" },
            { "type.co.eor", "\u0aaf\u0ac1\u0ab0\u0acb\u0aaa\u0ac0\u0aaf\u0aa8 \u0a95\u0acd\u0ab0\u0aae \u0a86\u0aaa\u0ab5\u0abe\u0aa8\u0abe \u0aa8\u0abf\u0aaf\u0aae\u0acb" },
            { "IO", "\u0aac\u0acd\u0ab0\u0abf\u0a9f\u0abf\u0ab6 \u0a87\u0aa8\u0acd\u0aa1\u0abf\u0aaf\u0aa8 \u0a93\u0ab6\u0aa8 \u0a9f\u0ac7\u0ab0\u0abf\u0a9f\u0ab0\u0ac0" },
            { "IQ", "\u0a87\u0ab0\u0abe\u0a95" },
            { "IR", "\u0a88\u0ab0\u0abe\u0aa8" },
            { "IS", "\u0a86\u0a87\u0ab8\u0ab2\u0ac7\u0aa8\u0acd\u0aa1" },
            { "IT", "\u0a87\u0a9f\u0abe\u0ab2\u0ac0" },
            { "Zmth", "\u0a97\u0aa3\u0abf\u0aa4\u0ac0\u0aaf \u0ab8\u0a82\u0a95\u0ac7\u0aa4\u0ab2\u0abf\u0aaa\u0abf" },
            { "type.nu.thai", "\u0aa5\u0abe\u0a87 \u0a85\u0a82\u0a95\u0acb" },
            { "type.nu.beng", "\u0aac\u0a82\u0a97\u0abe\u0ab3\u0ac0 \u0a85\u0a82\u0a95\u0acb" },
            { "JE", "\u0a9c\u0ab0\u0acd\u0ab8\u0ac0" },
            { "type.ca.islamic", "\u0a87\u0ab8\u0acd\u0ab2\u0abe\u0aae\u0abf\u0a95 \u0a95\u0ac7\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0ab0" },
            { "JM", "\u0a9c\u0aae\u0ac8\u0a95\u0abe" },
            { "Beng", "\u0aac\u0a82\u0a97\u0abe\u0ab3\u0ac0" },
            { "JO", "\u0a9c\u0acb\u0ab0\u0acd\u0aa1\u0aa8" },
            { "JP", "\u0a9c\u0abe\u0aaa\u0abe\u0aa8" },
            { "ain", "\u0a90\u0aa8\u0ac1" },
            { "guz", "\u0a97\u0ac1\u0ab8\u0ac0" },
            { "tog", "\u0aa8\u0acd\u0aaf\u0abe\u0ab8\u0abe \u0a9f\u0acb\u0aa8\u0acd\u0a97\u0abe" },
            { "type.nu.knda", "\u0a95\u0aa8\u0acd\u0aa8\u0aa1\u0abe \u0a85\u0a82\u0a95\u0acb" },
            { "Kali", "\u0a95\u0abe\u0aaf\u0abe\u0ab9 \u0ab2\u0ac0" },
            { "de_CH", "\u0ab8\u0acd\u0ab5\u0abf\u0ab8 \u0ab9\u0abe\u0aaf \u0a9c\u0ab0\u0acd\u0aae\u0aa8" },
            { "type.co.phonetic", "\u0aa7\u0acd\u0ab5\u0aa8\u0acd\u0aaf\u0abe\u0aa4\u0acd\u0aae\u0a95 \u0ab8\u0ac9\u0ab0\u0acd\u0a9f \u0a95\u0acd\u0ab0\u0aae" },
            { "type.ca.buddhist", "\u0aac\u0ac1\u0aa6\u0acd\u0aa7\u0abf\u0ab8\u0acd\u0a9f \u0a95\u0ac7\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0ab0" },
            { "KE", "\u0a95\u0ac7\u0aa8\u0acd\u0aaf\u0abe" },
            { "419", "\u0ab2\u0ac7\u0a9f\u0abf\u0aa8 \u0a85\u0aae\u0ac7\u0ab0\u0abf\u0a95\u0abe" },
            { "KG", "\u0a95\u0abf\u0ab0\u0acd\u0a97\u0abf\u0a9d\u0acd\u0ab8\u0acd\u0aa4\u0abe\u0aa8" },
            { "KH", "\u0a95\u0a82\u0aac\u0acb\u0aa1\u0abf\u0aaf\u0abe" },
            { "KI", "\u0a95\u0abf\u0ab0\u0abf\u0aac\u0abe\u0a9f\u0ac0" },
            { "KM", "\u0a95\u0acb\u0aae\u0acb\u0ab0\u0ab8" },
            { "KN", "\u0ab8\u0ac7\u0a82\u0a9f \u0a95\u0abf\u0a9f\u0acd\u0ab8 \u0a85\u0aa8\u0ac7 \u0aa8\u0ac7\u0ab5\u0abf\u0ab8" },
            { "Knda", "\u0a95\u0aa8\u0acd\u0aa8\u0aa1\u0abe" },
            { "Zinh", "\u0ab5\u0a82\u0ab6\u0abe\u0a97\u0aa4" },
            { "fr_CA", "\u0a95\u0ac7\u0aa8\u0ac7\u0aa1\u0abf\u0aaf\u0aa8 \u0aab\u0acd\u0ab0\u0ac7\u0a82\u0a9a" },
            { "KP", "\u0a89\u0aa4\u0acd\u0aa4\u0ab0 \u0a95\u0acb\u0ab0\u0abf\u0aaf\u0abe" },
            { "KR", "\u0aa6\u0a95\u0acd\u0ab7\u0abf\u0aa3 \u0a95\u0acb\u0ab0\u0abf\u0aaf\u0abe" },
            { "Plrd", "\u0aaa\u0acb\u0ab2\u0abe\u0ab0\u0acd\u0aa1 \u0aab\u0acb\u0aa8\u0ac7\u0a9f\u0abf\u0a95" },
            { "fr_CH", "\u0ab8\u0acd\u0ab5\u0abf\u0ab8 \u0aab\u0acd\u0ab0\u0ac7\u0a82\u0a9a" },
            { "KW", "\u0a95\u0ac1\u0ab5\u0ac8\u0aa4" },
            { "tpi", "\u0a9f\u0acb\u0a95 \u0aaa\u0abf\u0ab8\u0abf\u0aa8" },
            { "KY", "\u0a95\u0ac7\u0aae\u0ac7\u0aa8 \u0a86\u0a87\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0acd\u0ab8" },
            { "KZ", "\u0a95\u0a9d\u0abe\u0a95\u0abf\u0ab8\u0acd\u0aa4\u0abe\u0aa8" },
            { "Cyrl", "\u0ab8\u0abf\u0ab0\u0abf\u0ab2\u0abf\u0a95" },
            { "LA", "\u0ab2\u0abe\u0a93\u0ab8" },
            { "LB", "\u0ab2\u0ac7\u0aac\u0aa8\u0acb\u0aa8" },
            { "phn", metaValue_phn },
            { "LC", "\u0ab8\u0ac7\u0a82\u0a9f \u0ab2\u0ac1\u0ab8\u0abf\u0aaf\u0abe" },
            { "Cyrs", "\u0a93\u0ab2\u0acd\u0aa1 \u0a9a\u0ab0\u0acd\u0a9a \u0ab8\u0acd\u0ab2\u0abe\u0ab5\u0acb\u0aa8\u0abf\u0a95 \u0ab8\u0abf\u0ab0\u0abf\u0ab2\u0abf\u0a95" },
            { "gwi", "\u0a97\u0acd\u0ab5\u0abf\u0a9a\u2019\u0a87\u0aa8" },
            { "nds", "\u0ab2\u0acb \u0a9c\u0ab0\u0acd\u0aae\u0aa8" },
            { "LI", "\u0ab2\u0ac8\u0a9a\u0a9f\u0ac7\u0a82\u0ab8\u0acd\u0a9f\u0ac7\u0a87\u0aa8" },
            { "LK", "\u0ab6\u0acd\u0ab0\u0ac0\u0ab2\u0a82\u0a95\u0abe" },
            { "akk", "\u0a85\u0a95\u0acd\u0a95\u0abe\u0aa6\u0ac0\u0aaf\u0abe\u0aa8" },
            { "cop", metaValue_cop },
            { "LR", "\u0ab2\u0abe\u0a87\u0aac\u0ac7\u0ab0\u0abf\u0aaf\u0abe" },
            { "LS", "\u0ab2\u0ac7\u0ab8\u0acb\u0aa5\u0acb" },
            { "Phlv", "\u0aac\u0ac1\u0a95 \u0aaa\u0ab9\u0ab2\u0ab5\u0ac0" },
            { "LT", "\u0ab2\u0abf\u0aa5\u0ac1\u0a86\u0aa8\u0abf\u0aaf\u0abe" },
            { "LU", "\u0ab2\u0a95\u0acd\u0a9d\u0aae\u0aac\u0ab0\u0acd\u0a97" },
            { "LV", "\u0ab2\u0abe\u0aa4\u0acd\u0ab5\u0abf\u0aaf\u0abe" },
            { "Kana", "\u0a95\u0a9f\u0abe\u0a95\u0abe\u0aa8\u0abe" },
            { "LY", "\u0ab2\u0abf\u0aac\u0abf\u0aaf\u0abe" },
            { "lad", "\u0ab2\u0abe\u0aa6\u0ac0\u0aa8\u0acb" },
            { "vun", "\u0ab5\u0ac1\u0aa8\u0acd\u0a9c\u0acb" },
            { "lah", "\u0ab2\u0abe\u0ab9\u0aa8\u0acd\u0aa1\u0abe" },
            { "lag", "\u0ab2\u0a82\u0a97\u0ac0" },
            { "Thaa", "\u0aa5\u0abe\u0aa8\u0abe" },
            { "MA", "\u0aae\u0acb\u0ab0\u0acb\u0a95\u0acd\u0a95\u0acb" },
            { "MC", "\u0aae\u0acb\u0aa8\u0abe\u0a95\u0acb" },
            { "MD", "\u0aae\u0acb\u0ab2\u0aa1\u0acb\u0ab5\u0abe" },
            { "ME", "\u0aae\u0ac9\u0aa8\u0acd\u0a9f\u0ac7\u0aa8\u0ac7\u0a97\u0acd\u0ab0\u0acb" },
            { "MF", "\u0ab8\u0ac7\u0a82\u0a9f \u0aae\u0abe\u0ab0\u0acd\u0a9f\u0abf\u0aa8" },
            { "lam", "\u0ab2\u0abe\u0aae\u0acd\u0aac\u0abe" },
            { "MG", "\u0aae\u0ac7\u0aa1\u0abe\u0a97\u0abe\u0ab8\u0acd\u0a95\u0ab0" },
            { "MH", "\u0aae\u0abe\u0ab0\u0acd\u0ab6\u0ab2 \u0a86\u0a87\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0acd\u0ab8" },
            { "ale", "\u0a85\u0ab2\u0ac7\u0a89\u0aa4" },
            { "Thai", "\u0aa5\u0abe\u0a87" },
            { "type.nu.vaii", "\u0ab5\u0abe\u0a87 \u0a85\u0a82\u0a95\u0acb" },
            { "MK", "\u0a89\u0aa4\u0acd\u0aa4\u0ab0 \u0aae\u0ac7\u0ab8\u0ac7\u0aa1\u0acb\u0aa8\u0abf\u0aaf\u0abe" },
            { "ML", "\u0aae\u0abe\u0ab2\u0ac0" },
            { "MM", "\u0aae\u0acd\u0aaf\u0abe\u0a82\u0aae\u0abe\u0ab0 (\u0aac\u0ab0\u0acd\u0aae\u0abe)" },
            { "MN", "\u0aae\u0a82\u0a97\u0acb\u0ab2\u0abf\u0aaf\u0abe" },
            { "new", "\u0aa8\u0ac7\u0ab5\u0abe\u0ab0\u0ac0" },
            { "MO", "\u0aae\u0a95\u0abe\u0a89 SAR \u0a9a\u0ac0\u0aa8" },
            { "MP", "\u0a89\u0aa4\u0acd\u0aa4\u0ab0\u0ac0 \u0aae\u0abe\u0ab0\u0abf\u0aaf\u0abe\u0aa8\u0abe \u0a86\u0a87\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0acd\u0ab8" },
            { "MQ", "\u0aae\u0abe\u0ab0\u0acd\u0a9f\u0ac0\u0aa8\u0ac0\u0a95" },
            { "MR", "\u0aae\u0acc\u0ab0\u0abf\u0a9f\u0abe\u0aa8\u0abf\u0aaf\u0abe" },
            { "MS", "\u0aae\u0acb\u0a82\u0a9f\u0ab8\u0ac7\u0ab0\u0abe\u0aa4" },
            { "MT", "\u0aae\u0abe\u0ab2\u0acd\u0a9f\u0abe" },
            { "type.m0.ungegn", "UNGEGN" },
            { "MU", "\u0aae\u0acb\u0ab0\u0abf\u0ab6\u0abf\u0aaf\u0ab8" },
            { "alt", "\u0aa6\u0a95\u0acd\u0ab7\u0abf\u0aa3 \u0a85\u0ab2\u0acd\u0aa4\u0abe\u0a87" },
            { "MV", "\u0aae\u0abe\u0ab2\u0aa6\u0abf\u0ab5\u0acd\u0ab8" },
            { "MW", "\u0aae\u0abe\u0ab2\u0abe\u0ab5\u0ac0" },
            { "MX", "\u0aae\u0ac7\u0a95\u0acd\u0ab8\u0abf\u0a95\u0acb" },
            { "type.ca.japanese", "\u0a9c\u0abe\u0aaa\u0abe\u0aa8\u0ac0\u0a9d \u0a95\u0ac7\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0ab0" },
            { "MY", "\u0aae\u0ab2\u0ac7\u0ab6\u0abf\u0aaf\u0abe" },
            { "MZ", "\u0aae\u0acb\u0a9d\u0abe\u0aae\u0acd\u0aac\u0abf\u0a95" },
            { "Phli", "\u0a87\u0aa8\u0acd\u0ab8\u0acd\u0a95\u0acd\u0ab0\u0abf\u0aaa\u0acd\u0ab6\u0aa8\u0ab2 \u0aaa\u0ab9\u0ab2\u0ab5\u0ac0" },
            { "NA", "\u0aa8\u0abe\u0aae\u0abf\u0aac\u0abf\u0aaf\u0abe" },
            { "202", "\u0ab8\u0aac-\u0ab8\u0ab9\u0abe\u0ab0\u0aa8 \u0a86\u0aab\u0acd\u0ab0\u0abf\u0a95\u0abe" },
            { "type.ca.hebrew", "\u0ab9\u0abf\u0aac\u0acd\u0ab0\u0ac1 \u0a95\u0ac7\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0ab0" },
            { "type.co.dictionary", "\u0ab6\u0aac\u0acd\u0aa6\u0a95\u0acb\u0ab6 \u0a85\u0aa8\u0ac1\u0a95\u0acd\u0aae" },
            { "NC", "\u0aa8\u0acd\u0aaf\u0ac1 \u0ab8\u0ac7\u0ab2\u0ac7\u0aa1\u0acb\u0aa8\u0abf\u0aaf\u0abe" },
            { "%%WADEGILE", "\u0ab5\u0ac7\u0aa1-\u0a97\u0abf\u0ab2\u0acd\u0ab8 \u0ab0\u0acb\u0aae\u0aa8\u0abe\u0a87\u0a9d\u0ac7\u0ab6\u0aa8" },
            { "NE", "\u0aa8\u0abe\u0a87\u0a9c\u0ab0" },
            { "NF", "\u0aa8\u0acb\u0ab0\u0aab\u0acb\u0a95 \u0a86\u0a87\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0acd\u0ab8" },
            { "NG", "\u0aa8\u0abe\u0a87\u0a9c\u0ac7\u0ab0\u0abf\u0aaf\u0abe" },
            { "trv", "\u0a9f\u0abe\u0ab0\u0acb\u0a95\u0acb" },
            { "Phlp", "\u0ab8\u0abe\u0ab2\u0a9f\u0ab0 \u0aaa\u0ab9\u0ab2\u0ab5\u0ac0" },
            { "NI", "\u0aa8\u0abf\u0a95\u0abe\u0ab0\u0abe\u0a97\u0ac1\u0a86" },
            { "Hmng", "\u0aaa\u0ab9\u0abe\u0a89 \u0aae\u0acb\u0aa8\u0acd\u0a97" },
            { "NL", "\u0aa8\u0ac7\u0aa7\u0ab0\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0acd\u0ab8" },
            { "NO", "\u0aa8\u0ac9\u0ab0\u0acd\u0ab5\u0ac7" },
            { "NP", "\u0aa8\u0ac7\u0aaa\u0abe\u0ab3" },
            { "NR", "\u0aa8\u0acc\u0ab0\u0ac1" },
            { "Phnx", metaValue_phn },
            { "NU", "\u0aa8\u0ac0\u0aaf\u0ac1" },
            { "rof", "\u0ab0\u0acb\u0aae\u0acd\u0aac\u0acb" },
            { "tsi", "\u0ab8\u0abf\u0aae\u0acd\u0ab6\u0abf\u0aaf\u0aa8" },
            { "NZ", "\u0aa8\u0acd\u0aaf\u0ac1\u0a9d\u0ac0\u0ab2\u0ac7\u0aa8\u0acd\u0aa1" },
            { "rom", "\u0ab0\u0acb\u0aae\u0abe\u0aa8\u0ac0" },
            { "Mero", "\u0aae\u0ac7\u0ab0\u0acb\u0a87\u0a9f\u0abf\u0a95" },
            { "crh", "\u0a95\u0acd\u0ab0\u0abf\u0aae\u0abf\u0aaf\u0aa8 \u0aa4\u0ac1\u0ab0\u0acd\u0a95\u0ac0" },
            { "ang", "\u0a9c\u0ac1\u0aa8\u0ac0 \u0a85\u0a82\u0a97\u0acd\u0ab0\u0ac7\u0a9c\u0ac0" },
            { "OM", "\u0a93\u0aae\u0abe\u0aa8" },
            { "anp", "\u0a85\u0a82\u0a97\u0ac0\u0a95\u0abe" },
            { "crs", "\u0ab8\u0ac7\u0ab8\u0ac7\u0ab2\u0acd\u0ab5\u0abe \u0a95\u0acd\u0ab0\u0ac7\u0a93\u0ab2\u0ac7 \u0aab\u0acd\u0ab0\u0ac7\u0aa8\u0acd\u0a9a" },
            { "Xpeo", "\u0a9c\u0ac1\u0aa8\u0ac0 \u0aab\u0abe\u0ab0\u0ab8\u0ac0" },
            { "PA", "\u0aaa\u0aa8\u0abe\u0aae\u0abe" },
            { "type.ca.islamic-civil", "\u0a87\u0ab8\u0acd\u0ab2\u0abe\u0aae\u0abf\u0a95-\u0aa8\u0abe\u0a97\u0ab0\u0abf\u0a95 \u0a95\u0ac7\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0ab0" },
            { "csb", "\u0a95\u0abe\u0ab6\u0ac1\u0aac\u0abf\u0aaf\u0aa8" },
            { "en_GB", "\u0aac\u0acd\u0ab0\u0abf\u0a9f\u0abf\u0ab6 \u0a85\u0a82\u0a97\u0acd\u0ab0\u0ac7\u0a9c\u0ac0" },
            { "PE", "\u0aaa\u0ac7\u0ab0\u0ac1" },
            { "ttt", "\u0aae\u0ac1\u0ab8\u0acd\u0ab2\u0abf\u0aae \u0aa4\u0abe\u0a9f" },
            { "PF", "\u0aab\u0acd\u0ab0\u0ac7\u0a82\u0a9a \u0aaa\u0acb\u0ab2\u0abf\u0aa8\u0ac7\u0ab6\u0abf\u0aaf\u0abe" },
            { "PG", "\u0aaa\u0abe\u0aaa\u0ac1\u0a86 \u0aa8\u0acd\u0aaf\u0ac2 \u0a97\u0abf\u0aa8\u0ac0" },
            { "PH", "\u0aab\u0abf\u0ab2\u0abf\u0aaa\u0abf\u0aa8\u0acd\u0ab8" },
            { "PK", "\u0aaa\u0abe\u0a95\u0abf\u0ab8\u0acd\u0aa4\u0abe\u0aa8" },
            { "PL", "\u0aaa\u0acb\u0ab2\u0ac7\u0a82\u0aa1" },
            { "ewo", "\u0a87\u0ab5\u0acb\u0aa8\u0acd\u0aa1\u0acb" },
            { "PM", "\u0ab8\u0ac7\u0a82\u0a9f \u0aaa\u0ac0\u0a8f\u0ab0\u0ac0 \u0a85\u0aa8\u0ac7 \u0aae\u0abf\u0a95\u0acd\u0aaf\u0ac1\u0ab2\u0acb\u0aa8" },
            { "PN", "\u0aaa\u0ac0\u0a9f\u0a95\u0ac8\u0ab0\u0acd\u0aa8 \u0a86\u0a87\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0acd\u0ab8" },
            { "PR", "\u0aaa\u0acd\u0aaf\u0ac1\u0a85\u0ab0\u0acd\u0a9f\u0acb \u0ab0\u0abf\u0a95\u0acb" },
            { "PS", "\u0aaa\u0ac7\u0ab2\u0ac7\u0ab8\u0acd\u0a9f\u0abf\u0aa8\u0abf\u0aaf\u0aa8 \u0a9f\u0ac7\u0ab0\u0abf\u0a9f\u0ab0\u0ac0" },
            { "Bali", "\u0aac\u0abe\u0ab2\u0ac0\u0aa8\u0ac0\u0a9d" },
            { "PT", "\u0aaa\u0acb\u0ab0\u0acd\u0a9f\u0ac1\u0a97\u0ab2" },
            { "PW", "\u0aaa\u0ab2\u0abe\u0a89" },
            { "nia", "\u0aa8\u0abf\u0aaf\u0abe\u0ab8" },
            { "type.nu.greklow", "\u0a97\u0acd\u0ab0\u0ac0\u0a95 \u0aa8\u0abe\u0aa8\u0abe \u0a85\u0a95\u0acd\u0ab7\u0ab0\u0aa8\u0ac0 \u0ab8\u0a82\u0a96\u0acd\u0aaf\u0abe\u0a93" },
            { "PY", "\u0aaa\u0ac7\u0ab0\u0abe\u0a97\u0acd\u0ab5\u0ac7" },
            { "tum", "\u0aa4\u0ac1\u0aae\u0acd\u0aac\u0ac1\u0a95\u0abe" },
            { "Hebr", metaValue_he },
            { "QA", "\u0a95\u0aa4\u0abe\u0ab0" },
            { "niu", "\u0aa8\u0abf\u0aaf\u0ac1\u0a86\u0aa8" },
            { "QO", "\u0a86\u0a89\u0a9f\u0ab2\u0abe\u0a88\u0aa8\u0acd\u0a97 \u0a93\u0ab6\u0aa8\u0abf\u0aaf\u0abe" },
            { "lez", "\u0ab2\u0ac7\u0a9d\u0aa7\u0ac0\u0aaf\u0aa8" },
            { "tvl", metaValue_TV },
            { "Tavt", "\u0aa4\u0abe\u0a87 \u0ab5\u0ac7\u0a87\u0aa4" },
            { "001", "\u0ab5\u0abf\u0ab6\u0acd\u0ab5" },
            { "002", "\u0a86\u0aab\u0acd\u0ab0\u0abf\u0a95\u0abe" },
            { "003", "\u0a89\u0aa4\u0acd\u0aa4\u0ab0 \u0a85\u0aae\u0ac7\u0ab0\u0abf\u0a95\u0abe" },
            { "RE", "\u0ab0\u0ac0\u0aaf\u0ac1\u0aa8\u0abf\u0aaf\u0aa8" },
            { "005", "\u0aa6\u0a95\u0acd\u0ab7\u0abf\u0aa3 \u0a85\u0aae\u0ac7\u0ab0\u0abf\u0a95\u0abe" },
            { "lfn", "\u0ab2\u0abf\u0a82\u0a97\u0acd\u0ab5\u0abe \u0aab\u0ac7\u0aa8\u0acd\u0a95\u0abe \u0aa8\u0acb\u0ab5\u0abe" },
            { "jbo", "\u0ab2\u0acb\u0a9c\u0acd\u0aac\u0abe\u0aa8" },
            { "Rjng", "\u0ab0\u0ac0\u0a9c\u0abe\u0a82\u0a97" },
            { "009", "\u0a93\u0ab6\u0aa8\u0abf\u0aaf\u0abe" },
            { "RO", "\u0ab0\u0acb\u0aae\u0abe\u0aa8\u0abf\u0aaf\u0abe" },
            { "RS", "\u0ab8\u0ab0\u0acd\u0aac\u0abf\u0aaf\u0abe" },
            { "RU", "\u0ab0\u0ab6\u0abf\u0aaf\u0abe" },
            { "RW", "\u0ab0\u0ab5\u0abe\u0a82\u0aa1\u0abe" },
            { "Mani", "\u0aae\u0abe\u0aa8\u0ac0\u0a9a\u0abe\u0aaf\u0ac0\u0aa8" },
            { "Ugar", "\u0aaf\u0ac1\u0a97\u0abe\u0aa4\u0abf\u0a9f\u0abf\u0a95" },
            { "Khar", "\u0a96\u0abe\u0ab0\u0acb\u0ab6\u0acd\u0aa5\u0ac0" },
            { "SA", "\u0ab8\u0abe\u0a89\u0aa6\u0ac0 \u0a85\u0ab0\u0ac7\u0aac\u0abf\u0aaf\u0abe" },
            { "pon", "\u0aaa\u0acb\u0ab9\u0aaa\u0abf\u0a8f\u0aa8" },
            { "Mand", "\u0aae\u0abe\u0aa8\u0acd\u0aa1\u0abe\u0aaf\u0ac0\u0aa8" },
            { "SB", "\u0ab8\u0acb\u0ab2\u0acb\u0aae\u0aa8 \u0a86\u0a87\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0acd\u0ab8" },
            { "twq", "\u0aa4\u0ab8\u0abe\u0ab5\u0abe\u0a95" },
            { "011", "\u0aaa\u0ab6\u0acd\u0a9a\u0abf\u0aae\u0ac0 \u0a86\u0aab\u0acd\u0ab0\u0abf\u0a95\u0abe" },
            { "SC", "\u0ab8\u0ac7\u0ab6\u0ac7\u0ab2\u0acd\u0ab8" },
            { "SD", "\u0ab8\u0ac1\u0aa6\u0abe\u0aa8" },
            { "013", "\u0aae\u0aa7\u0acd\u0aaf \u0a85\u0aae\u0ac7\u0ab0\u0abf\u0a95\u0abe" },
            { "SE", "\u0ab8\u0acd\u0ab5\u0ac0\u0aa1\u0aa8" },
            { "014", "\u0aaa\u0ac2\u0ab0\u0acd\u0ab5\u0ac0\u0aaf \u0a86\u0aab\u0acd\u0ab0\u0abf\u0a95\u0abe" },
            { "arc", "\u0a8f\u0ab0\u0aae\u0ac8\u0a95" },
            { "015", "\u0a89\u0aa4\u0acd\u0aa4\u0ab0\u0ac0 \u0a86\u0aab\u0acd\u0ab0\u0abf\u0a95\u0abe" },
            { "SG", "\u0ab8\u0abf\u0a82\u0a97\u0abe\u0aaa\u0ac1\u0ab0" },
            { "SH", "\u0ab8\u0ac7\u0a82\u0a9f \u0ab9\u0ac7\u0ab2\u0ac7\u0aa8\u0abe" },
            { "type.lb.strict", "\u0a9a\u0ac1\u0ab8\u0acd\u0aa4 \u0ab0\u0ac7\u0a96\u0abe \u0ab5\u0abf\u0ab0\u0abe\u0aae \u0aaa\u0acd\u0ab0\u0a95\u0abe\u0ab0" },
            { "017", "\u0aae\u0aa7\u0acd\u0aaf \u0a86\u0aab\u0acd\u0ab0\u0abf\u0a95\u0abe" },
            { "SI", "\u0ab8\u0acd\u0ab2\u0acb\u0ab5\u0ac7\u0aa8\u0abf\u0aaf\u0abe" },
            { "018", "\u0ab8\u0aa7\u0ab0\u0acd\u0aa8 \u0a86\u0aab\u0acd\u0ab0\u0abf\u0a95\u0abe" },
            { "SJ", "\u0ab8\u0acd\u0ab5\u0abe\u0ab2\u0aac\u0ab0\u0acd\u0aa1 \u0a85\u0aa8\u0ac7 \u0a9c\u0ac7\u0aa8 \u0aae\u0ac7\u0aaf\u0aa8" },
            { "019", "\u0a85\u0aae\u0ac7\u0ab0\u0abf\u0a95\u0abe" },
            { "SK", "\u0ab8\u0acd\u0ab2\u0acb\u0ab5\u0ac7\u0a95\u0abf\u0aaf\u0abe" },
            { "SL", "\u0ab8\u0ac0\u0a8f\u0ab0\u0abe \u0ab2\u0ac7\u0a93\u0aa8" },
            { "SM", "\u0ab8\u0ac5\u0aa8 \u0aae\u0ac7\u0ab0\u0abf\u0aa8\u0acb" },
            { "SN", "\u0ab8\u0ac7\u0aa8\u0ac7\u0a97\u0ab2" },
            { "SO", "\u0ab8\u0acb\u0aae\u0abe\u0ab2\u0abf\u0aaf\u0abe" },
            { "arn", "\u0aae\u0ac7\u0aaa\u0ac1\u0a9a\u0ac7" },
            { "arp", "\u0a85\u0ab0\u0abe\u0aaa\u0abe\u0ab9\u0acb" },
            { "type.nu.taml", "\u0aaa\u0abe\u0ab0\u0a82\u0aaa\u0ab0\u0abf\u0a95 \u0aa4\u0aae\u0abf\u0ab2 \u0ab8\u0a82\u0a96\u0acd\u0aaf\u0abe\u0a93" },
            { "SR", "\u0ab8\u0ac1\u0ab0\u0ac0\u0aa8\u0abe\u0aae" },
            { "SS", "\u0aa6\u0a95\u0acd\u0ab7\u0abf\u0aa3 \u0ab8\u0ac1\u0aa6\u0abe\u0aa8" },
            { "ST", "\u0ab8\u0abe\u0a93 \u0a9f\u0ac9\u0aae \u0a85\u0aa8\u0ac7 \u0aaa\u0acd\u0ab0\u0abf\u0a82\u0ab8\u0abf\u0aaa\u0ac7" },
            { "arq", "\u0a86\u0ab2\u0acd\u0a9c\u0ac7\u0ab0\u0abf\u0aaf\u0aa8 \u0a85\u0ab0\u0aac\u0ac0" },
            { "SV", "\u0a8f\u0ab2 \u0ab8\u0ac7\u0ab2\u0acd\u0ab5\u0abe\u0aa1\u0acb\u0ab0" },
            { "SX", "\u0ab8\u0abf\u0a82\u0a9f \u0aae\u0abe\u0ab0\u0acd\u0a9f\u0ac7\u0aa8" },
            { "SY", "\u0ab8\u0ac0\u0ab0\u0abf\u0aaf\u0abe" },
            { "yao", "\u0aaf\u0abe\u0a93" },
            { "SZ", "\u0a8f\u0ab8\u0acd\u0ab5\u0abe\u0a9f\u0ac0\u0aa8\u0ac0" },
            { "arw", "\u0a85\u0ab0\u0abe\u0ab5\u0a95" },
            { "arz", "\u0a88\u0a9c\u0abf\u0aaa\u0acd\u0ab6\u0abf\u0aaf\u0aa8 \u0a85\u0ab0\u0aac\u0ac0" },
            { "ary", "\u0aae\u0acb\u0ab0\u0acb\u0a95\u0acd\u0a95\u0aa8 \u0a85\u0ab0\u0aac\u0ac0" },
            { "yap", "\u0aaf\u0abe\u0aaa\u0ac0\u0ab8" },
            { "TA", "\u0aa4\u0acd\u0ab0\u0abf\u0ab8\u0acd\u0aa4\u0abe\u0aa8 \u0aa6\u0abe \u0a95\u0ac1\u0aa8\u0acd\u0ab9\u0abe" },
            { "asa", "\u0a85\u0ab8\u0ac1" },
            { "type.ms.ussystem", "\u0a85\u0aae\u0ac7\u0ab0\u0abf\u0a95\u0aa8 \u0aae\u0abe\u0aaa\u0aa6\u0a82\u0aa1 \u0aaa\u0aa6\u0acd\u0aa7\u0aa4\u0abf" },
            { "021", "\u0a89\u0aa4\u0acd\u0aa4\u0ab0\u0ac0 \u0a85\u0aae\u0ac7\u0ab0\u0abf\u0a95\u0abe" },
            { "TC", "\u0aa4\u0ac1\u0ab0\u0acd\u0a95\u0acd\u0ab8 \u0a85\u0aa8\u0ac7 \u0a95\u0ac7\u0a95\u0acb\u0a9d \u0a86\u0a87\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0acd\u0ab8" },
            { "yav", "\u0aaf\u0abe\u0aa8\u0acd\u0a97\u0aac\u0ac7\u0aa8" },
            { "TD", "\u0a9a\u0abe\u0aa1" },
            { "TF", "\u0aab\u0acd\u0ab0\u0ac7\u0a82\u0a9a \u0ab8\u0aa7\u0ab0\u0acd\u0aa8 \u0a9f\u0ac7\u0ab0\u0abf\u0a9f\u0ab0\u0ac0\u0a9d" },
            { "TG", "\u0a9f\u0acb\u0a97\u0acb" },
            { "TH", "\u0aa5\u0abe\u0a87\u0ab2\u0ac7\u0a82\u0aa1" },
            { "TJ", "\u0aa4\u0abe\u0a9c\u0ac0\u0a95\u0abf\u0ab8\u0acd\u0aa4\u0abe\u0aa8" },
            { "029", "\u0a95\u0ac7\u0ab0\u0abf\u0aac\u0abf\u0aaf\u0aa8" },
            { "TK", "\u0a9f\u0acb\u0a95\u0ac7\u0ab2\u0abe\u0a89" },
            { "TL", "\u0aa4\u0abf\u0aae\u0acb\u0ab0-\u0ab2\u0ac7\u0ab8\u0acd\u0aa4\u0ac7" },
            { "ybb", "\u0aaf\u0ac7\u0aae\u0acd\u0aac\u0abe" },
            { "type.co.searchjl", "\u0ab9\u0a82\u0a97\u0ac1\u0ab2 \u0aaa\u0acd\u0ab0\u0abe\u0ab0\u0a82\u0aad\u0abf\u0a95 \u0ab5\u0acd\u0aaf\u0a82\u0a9c\u0aa8 \u0aa6\u0acd\u0ab5\u0abe\u0ab0\u0abe \u0ab6\u0acb\u0aa7\u0acb" },
            { "TM", "\u0aa4\u0ac1\u0ab0\u0acd\u0a95\u0aae\u0ac7\u0aa8\u0abf\u0ab8\u0acd\u0aa4\u0abe\u0aa8" },
            { "TN", "\u0a9f\u0acd\u0aaf\u0ac1\u0aa8\u0abf\u0ab6\u0abf\u0aaf\u0abe" },
            { "TO", "\u0a9f\u0acb\u0a82\u0a97\u0abe" },
            { "TR", "\u0aa4\u0ac1\u0ab0\u0acd\u0a95\u0ac0" },
            { "TT", "\u0a9f\u0acd\u0ab0\u0abf\u0aa8\u0ac0\u0aa6\u0abe\u0aa6 \u0a85\u0aa8\u0ac7 \u0a9f\u0acb\u0aac\u0ac7\u0a97\u0acb" },
            { "TV", metaValue_TV },
            { "TW", "\u0aa4\u0abe\u0a87\u0ab5\u0abe\u0aa8" },
            { "ast", "\u0a85\u0ab8\u0acd\u0aa4\u0ac1\u0ab0\u0abf\u0aaf\u0aa8" },
            { "Orkh", "\u0a93\u0ab0\u0a96\u0acb\u0aa8" },
            { "TZ", "\u0aa4\u0abe\u0a82\u0a9d\u0abe\u0aa8\u0abf\u0aaf\u0abe" },
            { "nmg", "\u0a95\u0acd\u0ab5\u0abe\u0ab8\u0abf\u0a93" },
            { "Zzzz", "\u0a85\u0a9c\u0acd\u0a9e\u0abe\u0aa4 \u0ab2\u0abf\u0aaa\u0abf" },
            { "UA", "\u0aaf\u0ac1\u0a95\u0acd\u0ab0\u0ac7\u0aa8" },
            { "rup", "\u0a85\u0ab0\u0acb\u0aae\u0ac7\u0aa8\u0abf\u0aaf\u0aa8" },
            { "030", "\u0aaa\u0ac2\u0ab0\u0acd\u0ab5\u0ac0\u0aaf \u0a8f\u0ab6\u0abf\u0aaf\u0abe" },
            { "tyv", "\u0a9f\u0ac1\u0ab5\u0ac0\u0aa8\u0abf\u0aaf\u0aa8" },
            { "sw_CD", "\u0a95\u0acb\u0a82\u0a97\u0acb \u0ab8\u0acd\u0ab5\u0abe\u0ab9\u0abf\u0ab2\u0ac0" },
            { "034", "\u0aa6\u0a95\u0acd\u0ab7\u0abf\u0aa3 \u0a8f\u0ab6\u0abf\u0aaf\u0abe" },
            { "hai", "\u0ab9\u0ac8\u0aa1\u0abe" },
            { "035", "\u0aa6\u0a95\u0acd\u0ab7\u0abf\u0aa3\u0aaa\u0ac2\u0ab0\u0acd\u0ab5 \u0a8f\u0ab6\u0abf\u0aaf\u0abe" },
            { "UG", "\u0aaf\u0ac1\u0a97\u0abe\u0a82\u0aa1\u0abe" },
            { "type.co.pinyin", "\u0aaa\u0abf\u0aa8\u0aaf\u0abf\u0aa8 \u0a85\u0aa8\u0ac1\u0a95\u0acd\u0aae" },
            { "039", "\u0aa6\u0a95\u0acd\u0ab7\u0abf\u0aa3 \u0aaf\u0ac1\u0ab0\u0acb\u0aaa" },
            { "Sinh", "\u0ab8\u0abf\u0a82\u0ab9\u0ab2\u0ac0" },
            { "UM", "\u0aaf\u0ac1.\u0a8f\u0ab8. \u0a86\u0a89\u0a9f\u0ab2\u0abe\u0a87\u0aa8\u0abf\u0a82\u0a97 \u0a86\u0a87\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0acd\u0ab8" },
            { "UN", "\u0ab8\u0a82\u0aaf\u0ac1\u0a95\u0acd\u0aa4 \u0ab0\u0abe\u0ab7\u0acd\u0a9f\u0acd\u0ab0" },
            { "US", "\u0aaf\u0ac1\u0aa8\u0abe\u0a87\u0a9f\u0ac7\u0aa1 \u0ab8\u0acd\u0a9f\u0ac7\u0a9f\u0acd\u0ab8" },
            { "haw", "\u0ab9\u0ab5\u0abe\u0a87\u0aaf\u0aa8" },
            { "type.co.gb2312han", "\u0ab8\u0ab0\u0ab3\u0ac0\u0a95\u0ac3\u0aa4 \u0a9a\u0abe\u0a87\u0aa8\u0ac0\u0a9d \u0ab8\u0ac9\u0ab0\u0acd\u0a9f \u0a95\u0acd\u0ab0\u0aae - GB2312" },
            { "UY", "\u0a89\u0ab0\u0ac1\u0a97\u0acd\u0ab5\u0ac7" },
            { "prg", "\u0aaa\u0acd\u0ab0\u0ac1\u0ab8\u0acd\u0ab8\u0ac0\u0aaf\u0aa8" },
            { "UZ", "\u0a89\u0a9d\u0acd\u0aac\u0ac7\u0a95\u0abf\u0ab8\u0acd\u0aa4\u0abe\u0aa8" },
            { "tzm", "\u0ab8\u0ac7\u0aa8\u0acd\u0a9f\u0acd\u0ab0\u0ab2 \u0a8f\u0a9f\u0ab2\u0abe\u0ab8 \u0aa4\u0abe\u0aae\u0abe\u0a9d\u0abf\u0a9f" },
            { "type.co.stroke", "\u0ab8\u0acd\u0a9f\u0acd\u0ab0\u0acb\u0a95 \u0a85\u0aa8\u0ac1\u0a95\u0acd\u0aae" },
            { "nnh", "\u0aa8\u0ac0\u0a8f\u0aae\u0aac\u0ac1\u0aa8" },
            { "VA", "\u0ab5\u0ac7\u0a9f\u0abf\u0a95\u0aa8 \u0ab8\u0abf\u0a9f\u0ac0" },
            { "pro", "\u0a9c\u0ac1\u0aa8\u0ac0 \u0aaa\u0acd\u0ab0\u0acb\u0ab5\u0ac7\u0aa8\u0acd\u0ab8\u0ab2" },
            { "VC", "\u0ab8\u0ac7\u0a82\u0a9f \u0ab5\u0abf\u0aa8\u0acd\u0ab8\u0ac7\u0a82\u0a9f \u0a85\u0aa8\u0ac7 \u0a97\u0acd\u0ab0\u0ac7\u0aa8\u0ac7\u0aa1\u0abe\u0a87\u0a82\u0ab8" },
            { "VE", "\u0ab5\u0ac7\u0aa8\u0ac7\u0a9d\u0ac1\u0a8f\u0ab2\u0abe" },
            { "VG", "\u0aac\u0acd\u0ab0\u0abf\u0a9f\u0abf\u0ab6 \u0ab5\u0ab0\u0acd\u0a9c\u0abf\u0aa8 \u0a86\u0a87\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0acd\u0ab8" },
            { "VI", "\u0aaf\u0ac1\u0a8f\u0ab8 \u0ab5\u0ab0\u0acd\u0a9c\u0abf\u0aa8 \u0a86\u0a87\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0acd\u0ab8" },
            { "VN", "\u0ab5\u0abf\u0aaf\u0ac7\u0aa4\u0aa8\u0abe\u0aae" },
            { "VU", "\u0ab5\u0abe\u0aa8\u0ac1\u0a86\u0aa4\u0ac1" },
            { "nog", "\u0aa8\u0acb\u0a97\u0abe\u0a87" },
            { "rwk", "\u0ab0\u0ab5\u0abe" },
            { "non", "\u0a9c\u0ac2\u0aa8\u0ac0 \u0aa8\u0acb\u0ab0\u0acd\u0ab8" },
            { "053", "\u0a93\u0ab8\u0acd\u0a9f\u0acd\u0ab0\u0ac7\u0ab2\u0ac7\u0ab6\u0abf\u0aaf\u0abe" },
            { "054", "\u0aae\u0ac7\u0ab2\u0abe\u0aa8\u0ac7\u0ab6\u0abf\u0aaf\u0abe" },
            { "WF", "\u0ab5\u0ac9\u0ab2\u0abf\u0ab8 \u0a85\u0aa8\u0ac7 \u0aab\u0acd\u0aaf\u0ac1\u0a9a\u0ac1\u0aa8\u0abe" },
            { "type.co.traditional", "\u0aaa\u0ab0\u0a82\u0aaa\u0ab0\u0abe\u0a97\u0aa4 \u0a85\u0aa8\u0ac1\u0a95\u0acd\u0aae" },
            { "057", "\u0aae\u0abe\u0a88\u0a95\u0acd\u0ab0\u0acb\u0aa8\u0ac7\u0ab6\u0abf\u0aaf\u0aa8 \u0a95\u0acd\u0ab7\u0ac7\u0aa4\u0acd\u0ab0" },
            { "jgo", "\u0aa8\u0a97\u0acb\u0aae\u0acd\u0aac\u0abe" },
            { "lkt", "\u0ab2\u0abe\u0a95\u0acb\u0a9f\u0abe" },
            { "type.nu.finance", "\u0aa8\u0abe\u0aa3\u0abe\u0a95\u0ac0\u0aaf \u0ab8\u0a82\u0a96\u0acd\u0aaf\u0abe\u0a93" },
            { "type.co.compat", "\u0a85\u0a97\u0abe\u0a89\u0aa8\u0acb \u0ab8\u0acb\u0ab0\u0acd\u0a9f \u0a95\u0acd\u0ab0\u0aae, \u0ab8\u0ac1\u0ab8\u0a82\u0a97\u0aa4\u0aa4\u0abe \u0aae\u0abe\u0a9f\u0ac7" },
            { "wae", "\u0ab5\u0ac7\u0ab2\u0acd\u0ab8\u0ac7\u0ab0" },
            { "WS", "\u0ab8\u0aae\u0acb\u0a86" },
            { "wal", "\u0ab5\u0acb\u0ab2\u0abe\u0aaf\u0a9f\u0acd\u0a9f\u0abe" },
            { "was", "\u0ab5\u0abe\u0ab6\u0acb" },
            { "XA", "\u0ab8\u0acd\u0aaf\u0ac1\u0aa1\u0acb-\u0a8d\u0a95\u0acd\u0ab8\u0aa8\u0acd\u0a9f" },
            { "war", "\u0ab5\u0abe\u0ab0\u0ac7\u0aaf" },
            { "XB", "\u0ab8\u0acd\u0aaf\u0ac1\u0aa1\u0acb-\u0aa6\u0acd\u0ab5\u0abf\u0aa6\u0abf\u0ab6" },
            { "awa", "\u0a85\u0ab5\u0aa7\u0ac0" },
            { "061", "\u0aaa\u0acb\u0ab2\u0abf\u0aa8\u0ac7\u0ab6\u0abf\u0aaf\u0abe" },
            { "XK", "\u0a95\u0acb\u0ab8\u0acb\u0ab5\u0acb" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "\u0a85\u0ab2\u0abf\u0a96\u0abf\u0aa4" },
            { "Olck", "\u0a93\u0ab2 \u0a9a\u0abf\u0a95\u0ac0" },
            { "wbp", "\u0ab5\u0abe\u0ab0\u0acd\u0ab2\u0acd\u0aaa\u0ac0\u0ab0\u0ac0" },
            { "Batk", "\u0aac\u0a9f\u0abe\u0a95" },
            { "Blis", metaValue_zbl },
            { "YE", "\u0aaf\u0aae\u0aa8" },
            { "nqo", "\u0a8f\u0aa8\u2019\u0a95\u0acb" },
            { "type.co.standard", "\u0aae\u0abe\u0aa8\u0a95 \u0ab8\u0ac9\u0ab0\u0acd\u0a9f \u0a95\u0acd\u0ab0\u0aae" },
            { "fan", "\u0aab\u0ac7\u0a82\u0a97" },
            { "fat", "\u0aab\u0aa8\u0acd\u0a9f\u0ac0" },
            { "Sgnw", "\u0ab8\u0a82\u0a95\u0ac7\u0aa4 \u0ab2\u0abf\u0aaa\u0ac0" },
            { "YT", "\u0aae\u0ac7\u0aaf\u0acb\u0a9f" },
            { "ZA", "\u0aa6\u0a95\u0acd\u0ab7\u0abf\u0aa3 \u0a86\u0aab\u0acd\u0ab0\u0abf\u0a95\u0abe" },
            { "type.lb.loose", "\u0ab6\u0abf\u0aa5\u0abf\u0ab2 \u0ab0\u0ac7\u0a96\u0abe \u0ab5\u0abf\u0ab0\u0abe\u0aae \u0aaa\u0acd\u0ab0\u0a95\u0abe\u0ab0" },
            { "Deva", "\u0aa6\u0ac7\u0ab5\u0aa8\u0abe\u0a97\u0ab0\u0ac0" },
            { "type.nu.geor", "\u0a9c\u0acd\u0aaf\u0acb\u0ab0\u0acd\u0a9c\u0abf\u0a85\u0aa8 \u0ab8\u0a82\u0a96\u0acd\u0aaf\u0abe\u0a93" },
            { "Hira", "\u0ab9\u0abf\u0ab0\u0abe\u0a97\u0abe\u0aa8\u0abe" },
            { "ZM", "\u0a9d\u0abe\u0aae\u0acd\u0aac\u0abf\u0aaf\u0abe" },
            { "%%PINYIN", "\u0aaa\u0abf\u0aa8\u0aaf\u0abf\u0aa8 \u0ab0\u0acb\u0aae\u0aa8\u0abe\u0a87\u0a9d\u0ac7\u0ab6\u0aa8" },
            { "ZW", "\u0a9d\u0abf\u0aae\u0acd\u0aac\u0abe\u0aac\u0acd\u0ab5\u0ac7" },
            { "ZZ", "\u0a85\u0a9c\u0acd\u0a9e\u0abe\u0aa4 \u0aaa\u0acd\u0ab0\u0aa6\u0ac7\u0ab6" },
            { "Runr", "\u0ab0\u0ac2\u0aa8\u0abf\u0a95" },
            { "type.ms.metric", "\u0aa6\u0ab6\u0abe\u0a82\u0ab6 \u0aaa\u0aa6\u0acd\u0aa7\u0aa4\u0abf" },
            { "type.ca.iso8601", "ISO-8601 \u0a95\u0ac7\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0ab0" },
            { "lol", "\u0aae\u0acb\u0a82\u0a97\u0acb" },
            { "nso", "\u0a89\u0aa4\u0acd\u0aa4\u0ab0\u0ac0 \u0ab8\u0acb\u0aa5\u0acb" },
            { "type.nu.telu", "\u0aa4\u0ac7\u0ab2\u0ac1\u0a97\u0ac1 \u0a85\u0a82\u0a95\u0acb" },
            { "lou", "\u0ab2\u0acd\u0aaf\u0ac1\u0a87\u0ab8\u0abf\u0aaf\u0abe\u0aa8\u0abe \u0a95\u0acd\u0ab0\u0ac7\u0a93\u0ab2" },
            { "loz", "\u0ab2\u0acb\u0a9d\u0ac0" },
            { "jmc", "\u0aae\u0a95\u0abe\u0aae\u0ac7" },
            { "hif", "\u0aab\u0ac0\u0a9c\u0ac0 \u0ab9\u0abf\u0a82\u0aa6\u0ac0" },
            { "type.nu.hansfin", "\u0ab8\u0ab0\u0ab3\u0ac0\u0a95\u0ac3\u0aa4 \u0a9a\u0abe\u0a87\u0aa8\u0ac0\u0a9d \u0aa8\u0abe\u0aa3\u0abe\u0a95\u0ac0\u0aaf \u0ab8\u0a82\u0a96\u0acd\u0aaf\u0abe\u0a93" },
            { "hil", "\u0ab9\u0abf\u0ab2\u0abf\u0a97\u0ac7\u0aa8\u0acb\u0aa8" },
            { "type.nu.arabext", "\u0ab5\u0abf\u0ab8\u0acd\u0aa4\u0ac3\u0aa4 \u0a85\u0ab0\u0ac7\u0aac\u0abf\u0a95-\u0a87\u0aa8\u0acd\u0aa1\u0abf\u0a95 \u0a85\u0a82\u0a95\u0acb" },
            { "nus", "\u0aa8\u0ac1\u0a8f\u0ab0" },
            { "dak", "\u0aa6\u0abe\u0a95\u0acb\u0aa4\u0abe" },
            { "type.nu.fullwide", "\u0aaa\u0ac2\u0ab0\u0acd\u0aa3 \u0aaa\u0ab9\u0acb\u0ab3\u0abe\u0a88 \u0a85\u0a82\u0a95\u0acb" },
            { "hit", "\u0ab9\u0abf\u0a9f\u0acd\u0a9f\u0abf\u0aa4\u0ac7" },
            { "dar", "\u0aa6\u0abe\u0ab0\u0acd\u0a97\u0ab5\u0abe" },
            { "dav", "\u0aa4\u0ac8\u0aa4\u0abe" },
            { "Maya", "\u0aae\u0aaf\u0abe\u0aa8 \u0ab9\u0abe\u0a87\u0ab0\u0acb\u0a97\u0acd\u0ab2\u0abf\u0aab\u0acd\u0ab8" },
            { "lrc", "\u0a89\u0aa4\u0acd\u0aa4\u0ab0\u0ac0 \u0ab2\u0ac1\u0ab0\u0ac0" },
            { "Copt", metaValue_cop },
            { "nwc", "\u0aaa\u0ab0\u0a82\u0aaa\u0ab0\u0abe\u0a97\u0aa4 \u0aa8\u0ac7\u0ab5\u0abe\u0ab0\u0ac0" },
            { "udm", "\u0a89\u0aa6\u0aae\u0ac1\u0ab0\u0acd\u0aa4" },
            { "Khmr", metaValue_km },
            { "type.ca.islamic-rgsa", "\u0a87\u0ab8\u0acd\u0ab2\u0abe\u0aae\u0abf\u0a95 \u0a95\u0ac7\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0ab0 (\u0ab8\u0abe\u0a89\u0aa6\u0ac0 \u0a85\u0ab0\u0ac7\u0aac\u0abf\u0aaf\u0abe, \u0aa8\u0abf\u0ab0\u0ac0\u0a95\u0acd\u0ab7\u0aa3)" },
            { "Limb", "\u0ab2\u0abf\u0aae\u0acd\u0aac\u0ac2" },
            { "sad", "\u0ab8\u0acb\u0a82\u0aa1\u0ab5\u0ac7" },
            { "type.nu.roman", "\u0ab0\u0acb\u0aae\u0aa8 \u0ab8\u0a82\u0a96\u0acd\u0aaf\u0abe\u0a93" },
            { "sah", "\u0ab8\u0a96\u0abe" },
            { "sam", "\u0ab8\u0abe\u0aae\u0ab0\u0abf\u0a9f\u0abe\u0aa8 \u0a85\u0ab0\u0ac7\u0aae\u0abf\u0a95" },
            { "saq", "\u0ab8\u0aae\u0acd\u0aac\u0ac1\u0ab0\u0ac1" },
            { "sas", "\u0ab8\u0abe\u0ab8\u0abe\u0a95" },
            { "sat", "\u0ab8\u0a82\u0aa4\u0abe\u0ab2\u0ac0" },
            { "Tfng", "\u0aa4\u0abf\u0aab\u0abf\u0aa8\u0abe\u0a98" },
            { "jpr", "\u0a9c\u0ac1\u0aa6\u0ac7\u0a93-\u0aaa\u0ab0\u0acd\u0ab6\u0abf\u0aaf\u0aa8" },
            { "type.d0.npinyin", "\u0ab8\u0a82\u0a96\u0acd\u0aaf\u0abe" },
            { "type.nu.native", "\u0aae\u0ac2\u0ab3 \u0a85\u0a82\u0a95\u0acb" },
            { "sba", "\u0aa8\u0acd\u0a97\u0abe\u0aae\u0acd\u0aac\u0ac7\u0aaf" },
            { "Guru", "\u0a97\u0ac1\u0ab0\u0ac2\u0aae\u0ac1\u0a96\u0ac0" },
            { "lua", "\u0ab2\u0ac2\u0aac\u0abe-\u0ab2\u0ac1\u0ab2\u0ac1\u0a86" },
            { "type.d0.fwidth", "\u0aaa\u0ac2\u0ab0\u0acd\u0aa3\u0aaa\u0ab9\u0acb\u0ab3\u0abe\u0a87" },
            { "sbp", "\u0ab8\u0abe\u0a82\u0a97\u0ac1" },
            { "lui", "\u0ab2\u0ac1\u0a87\u0ab8\u0ac7\u0aa8\u0acb" },
            { "nyn", "\u0aa8\u0acd\u0aaf\u0abe\u0aa8\u0a95\u0acb\u0ab2" },
            { "nym", "\u0aa8\u0acd\u0aaf\u0abe\u0aae\u0ab5\u0ac7\u0a9d\u0ac0" },
            { "lun", "\u0ab2\u0ac1\u0aa8\u0acd\u0aa1\u0abe" },
            { "nyo", "\u0aa8\u0acd\u0aaf\u0acb\u0ab0\u0acb" },
            { "luo", "\u0ab2\u0acd\u0aaf\u0ac1\u0a93" },
            { "fil", "\u0aab\u0abf\u0ab2\u0abf\u0aaa\u0abf\u0aa8\u0acb" },
            { "hmn", "\u0ab9\u0aae\u0acb\u0a82\u0a97" },
            { "del", "\u0aa6\u0ac7\u0ab2\u0ab5\u0ac7\u0ab0" },
            { "lus", "\u0aae\u0abf\u0a9d\u0acb" },
            { "bal", "\u0aac\u0ab2\u0ac2\u0a9a\u0ac0" },
            { "den", "\u0ab8\u0acd\u0ab2\u0ac7\u0ab5" },
            { "ban", "\u0aac\u0abe\u0ab2\u0abf\u0aa8\u0ac0\u0ab8" },
            { "uga", "\u0aaf\u0ac1\u0a97\u0ac7\u0ab0\u0abf\u0a9f\u0abf\u0a95" },
            { "luy", "\u0ab2\u0ac1\u0a88\u0aaf\u0abe" },
            { "bas", "\u0aac\u0ab8\u0abe" },
            { "bax", "\u0aac\u0abe\u0aae\u0aa8" },
            { "jrb", "\u0a9c\u0ac1\u0aa6\u0ac7\u0a93-\u0a85\u0ab0\u0aac\u0ac0" },
            { "es_ES", "\u0aaf\u0ac1\u0ab0\u0acb\u0aaa\u0abf\u0aaf\u0aa8 \u0ab8\u0acd\u0aaa\u0ac7\u0aa8\u0abf\u0ab6" },
            { "nzi", "\u0aa8\u0acd\u0a9d\u0abf\u0aae\u0abe" },
            { "sco", "\u0ab8\u0acd\u0a95\u0acb\u0a9f\u0acd\u0ab8" },
            { "scn", "\u0ab8\u0abf\u0ab8\u0abf\u0ab2\u0abf\u0aaf\u0abe\u0aa8" },
            { "aa", "\u0a85\u0aab\u0abe\u0ab0" },
            { "ab", "\u0a85\u0aac\u0a96\u0abe\u0a9c\u0abf\u0aaf\u0aa8" },
            { "ae", metaValue_ae },
            { "af", "\u0a86\u0aab\u0acd\u0ab0\u0abf\u0a95\u0aa8\u0acd\u0ab8" },
            { "ak", "\u0a85\u0a95\u0abe\u0aa8" },
            { "am", "\u0a8f\u0aae\u0acd\u0ab9\u0abe\u0ab0\u0abf\u0a95" },
            { "Arab", metaValue_ar },
            { "an", "\u0a85\u0ab0\u0acd\u0a97\u0acb\u0aa8\u0ac0\u0a9d" },
            { "Jpan", "\u0a9c\u0abe\u0aaa\u0abe\u0aa8\u0ac0" },
            { "ar", metaValue_ar },
            { "Hrkt", "\u0a9c\u0abe\u0aaa\u0abe\u0aa8\u0ac0\u0a9d \u0ab5\u0ab0\u0acd\u0aa3\u0aae\u0abe\u0ab3\u0abe" },
            { "as", "\u0a86\u0ab8\u0abe\u0aae\u0ac0" },
            { "Lina", "\u0ab2\u0ac0\u0aa8\u0abf\u0aaf\u0ab0 \u0a85" },
            { "av", "\u0a85\u0ab5\u0ac7\u0ab0\u0abf\u0a95" },
            { "Linb", "\u0ab2\u0ac0\u0aa8\u0abf\u0aaf\u0ab0 \u0aac\u0ac0" },
            { "sdh", "\u0ab8\u0ab0\u0acd\u0a98\u0aa8 \u0a95\u0ac1\u0ab0\u0acd\u0aa6\u0ac0\u0ab6" },
            { "ay", "\u0a86\u0aaf\u0aae\u0abe\u0ab0\u0abe" },
            { "az", "\u0a85\u0a9d\u0ab0\u0aac\u0ac8\u0a9c\u0abe\u0aa8\u0ac0" },
            { "ba", "\u0aac\u0ab6\u0acd\u0a95\u0ac0\u0ab0" },
            { "type.co.unihan", "\u0ab0\u0ac7\u0aa1\u0abf\u0a95\u0ab2-\u0ab8\u0acd\u0a9f\u0acd\u0ab0\u0acb\u0a95" },
            { "be", "\u0aac\u0ac7\u0ab2\u0abe\u0ab0\u0ac1\u0ab6\u0abf\u0aaf\u0aa8" },
            { "bg", "\u0aac\u0ab2\u0acd\u0a97\u0ac7\u0ab0\u0abf\u0aaf\u0aa8" },
            { "bi", "\u0aac\u0abf\u0ab8\u0acd\u0ab2\u0abe\u0aae\u0abe" },
            { "bm", "\u0aac\u0abe\u0aae\u0acd\u0aac\u0abe\u0ab0\u0abe" },
            { "bn", "\u0aac\u0abe\u0a82\u0a97\u0acd\u0ab2\u0abe" },
            { "bo", "\u0aa4\u0abf\u0aac\u0ac7\u0a9f\u0ac0\u0aaf\u0aa8" },
            { "dgr", "\u0aa1\u0acb\u0a97\u0acd\u0ab0\u0abf\u0aac" },
            { "br", "\u0aac\u0acd\u0ab0\u0ac7\u0a9f\u0acb\u0aa8" },
            { "bs", "\u0aac\u0acb\u0ab8\u0acd\u0aa8\u0abf\u0aaf\u0aa8" },
            { "Mymr", "\u0aae\u0acd\u0aaf\u0abe\u0a82\u0aae\u0abe\u0ab0" },
            { "type.nu.laoo", "\u0ab2\u0abe\u0a93 \u0a85\u0a82\u0a95\u0acb" },
            { "seh", "\u0ab8\u0ac7\u0aa8\u0abe" },
            { "Nkoo", "\u0a8f\u0aa8\u2019 \u0a95\u0acb" },
            { "sel", "\u0ab8\u0ac7\u0ab2\u0acd\u0a95\u0aaa" },
            { "ca", "\u0a95\u0aa4\u0ab2\u0abe\u0aa8" },
            { "ses", "\u0a95\u0acb\u0aaf\u0ab0\u0abe\u0aac\u0acb\u0ab0\u0acb \u0ab8\u0ac7\u0aa8\u0acd\u0aa8\u0ac0" },
            { "ce", "\u0a9a\u0ac7\u0a9a\u0aa8" },
            { "ch", "\u0a95\u0ac7\u0aae\u0acb\u0ab0\u0acb" },
            { "co", "\u0a95\u0acb\u0ab0\u0acd\u0ab8\u0abf\u0a95\u0aa8" },
            { "Orya", metaValue_or },
            { "cr", "\u0a95\u0acd\u0ab0\u0ac0" },
            { "cs", "\u0a9a\u0ac7\u0a95" },
            { "cu", "\u0a9a\u0ab0\u0acd\u0a9a \u0ab8\u0acd\u0ab2\u0abe\u0ab5\u0abf\u0a95" },
            { "cv", "\u0a9a\u0ac2\u0ab5\u0abe\u0ab6" },
            { "cy", "\u0ab5\u0ac7\u0ab2\u0acd\u0ab6" },
            { "type.nu.ethi", "\u0a87\u0aa5\u0abf\u0aaf\u0acb\u0aaa\u0ac0\u0a95 \u0ab8\u0a82\u0a96\u0acd\u0aaf\u0abe\u0a93" },
            { "Yiii", "\u0aaf\u0ac0" },
            { "da", "\u0aa1\u0ac7\u0aa8\u0abf\u0ab6" },
            { "pt_PT", "\u0aaf\u0ac1\u0ab0\u0acb\u0aaa\u0abf\u0aaf\u0aa8 \u0aaa\u0acb\u0ab0\u0acd\u0a9f\u0ac1\u0a97\u0ac0\u0a9d" },
            { "de", "\u0a9c\u0ab0\u0acd\u0aae\u0aa8" },
            { "type.cf.standard", "\u0aaa\u0acd\u0ab0\u0aae\u0abe\u0aa3\u0aad\u0ac2\u0aa4 \u0a9a\u0ab2\u0aa3\u0ac0 \u0aac\u0a82\u0aa7\u0abe\u0ab0\u0aa3" },
            { "bej", "\u0aac\u0ac7\u0a9c\u0abe" },
            { "din", "\u0aa6\u0abf\u0aa8\u0acd\u0a95\u0abe" },
            { "Bugi", "\u0aac\u0a97\u0abf\u0aa8\u0ac0\u0ab8" },
            { "bem", "\u0aac\u0ac7\u0aae\u0acd\u0aac\u0abe" },
            { "sga", "\u0a9c\u0ac2\u0aa8\u0ac0 \u0a86\u0aaf\u0ab0\u0abf\u0ab6" },
            { "type.nu.mong", "\u0aae\u0acb\u0a82\u0a97\u0acb\u0ab2\u0abf\u0aaf\u0aa8 \u0a85\u0a82\u0a95\u0acb" },
            { "dv", "\u0aa6\u0abf\u0ab5\u0ac7\u0ab9\u0ac0" },
            { "es_419", "\u0ab2\u0ac7\u0a9f\u0abf\u0aa8 \u0a85\u0aae\u0ac7\u0ab0\u0abf\u0a95\u0aa8 \u0ab8\u0acd\u0aaa\u0ac7\u0aa8\u0abf\u0ab6" },
            { "dz", "\u0aa1\u0acd\u0a9d\u0acb\u0a82\u0a97\u0acd\u0a96\u0abe" },
            { "bez", "\u0aac\u0ac7\u0aa8\u0abe" },
            { "type.ca.chinese", "\u0a9a\u0abe\u0a87\u0aa8\u0ac0\u0a9d \u0a95\u0ac7\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0ab0" },
            { "dje", "\u0a9d\u0ab0\u0acd\u0aae\u0abe" },
            { "type.nu.grek", "\u0a97\u0acd\u0ab0\u0ac0\u0a95 \u0ab8\u0a82\u0a96\u0acd\u0aaf\u0abe\u0a93" },
            { "ee", "\u0a88\u0ab5" },
            { "type.lb.normal", "\u0ab8\u0abe\u0aae\u0abe\u0aa8\u0acd\u0aaf \u0ab0\u0ac7\u0a96\u0abe \u0ab5\u0abf\u0ab0\u0abe\u0aae \u0aaa\u0acd\u0ab0\u0a95\u0abe\u0ab0" },
            { "ro_MD", "\u0aae\u0acb\u0ab2\u0aa1\u0abe\u0ab5\u0abf\u0aaf\u0aa8" },
            { "el", metaValue_el },
            { "en", "\u0a85\u0a82\u0a97\u0acd\u0ab0\u0ac7\u0a9c\u0ac0" },
            { "eo", "\u0a8f\u0ab8\u0acd\u0aaa\u0ac7\u0ab0\u0abe\u0aa8\u0acd\u0a9f\u0acb" },
            { "type.co.big5han", "\u0aaa\u0ab0\u0a82\u0aaa\u0ab0\u0abe\u0a97\u0aa4 \u0a9a\u0abe\u0a87\u0aa8\u0abf\u0a9d \u0ab8\u0acb\u0ab0\u0acd\u0a9f \u0a95\u0acd\u0ab0\u0aae\u0aac\u0aa6\u0acd\u0aa7" },
            { "es", "\u0ab8\u0acd\u0aaa\u0ac7\u0aa8\u0abf\u0ab6" },
            { "et", "\u0a8f\u0ab8\u0acd\u0a9f\u0acb\u0aa8\u0abf\u0aaf\u0aa8" },
            { "Hanb", "\u0ab9\u0abe\u0aa8\u0acd\u0aac" },
            { "eu", "\u0aac\u0abe\u0ab8\u0acd\u0a95" },
            { "Buhd", "\u0aac\u0ac1\u0ab9\u0abf\u0aa6" },
            { "Hang", "\u0ab9\u0a82\u0a97\u0ac1\u0ab2" },
            { "Samr", "\u0ab8\u0aae\u0ab0\u0abf\u0a9f\u0abe\u0aa8" },
            { "shi", "\u0aa4\u0ac7\u0ab6\u0ac0\u0ab2\u0ab9\u0abf\u0a9f" },
            { "hsb", "\u0a85\u0aaa\u0ab0 \u0ab8\u0acb\u0ab0\u0acd\u0aac\u0abf\u0aaf\u0aa8" },
            { "Hani", "\u0ab9\u0abe\u0aa8" },
            { "shn", "\u0ab6\u0ac7\u0aa8" },
            { "Hano", "\u0ab9\u0aa8\u0ac1\u0aa8\u0ac2" },
            { "fa", "\u0aab\u0abe\u0ab0\u0ab8\u0ac0" },
            { "Hans", "\u0ab8\u0ab0\u0ab3\u0ac0\u0a95\u0ac3\u0aa4" },
            { "type.nu.latn", "\u0aaa\u0ab6\u0acd\u0a9a\u0abf\u0aae\u0ac0 \u0a85\u0a82\u0a95\u0acb" },
            { "Hant", "\u0aaa\u0ab0\u0a82\u0aaa\u0ab0\u0abe\u0a97\u0aa4" },
            { "ff", "\u0aab\u0ac1\u0ab2\u0abe\u0ab9" },
            { "fi", "\u0aab\u0abf\u0aa8\u0abf\u0ab6" },
            { "fj", "\u0aab\u0ac0\u0a9c\u0ac0\u0aaf\u0aa8" },
            { "fon", "\u0aab\u0acb\u0aa8" },
            { "bgn", "\u0aaa\u0ab6\u0acd\u0a9a\u0abf\u0aae\u0ac0 \u0aac\u0abe\u0ab2\u0acb\u0a9a\u0ac0" },
            { "yue", "\u0a95\u0ac7\u0a82\u0a9f\u0acb\u0aa8\u0ac0\u0a9d" },
            { "fo", "\u0aab\u0acb\u0ab0\u0abf\u0ab8\u0acd\u0aa4" },
            { "type.m0.bgn", "BGN" },
            { "umb", "\u0a89\u0aae\u0acd\u0aac\u0ac1\u0aa8\u0acd\u0aa1\u0ac2" },
            { "fr", "\u0aab\u0acd\u0ab0\u0ac7\u0aa8\u0acd\u0a9a" },
            { "sid", "\u0ab8\u0abf\u0aa6\u0abe\u0aae\u0acb" },
            { "fy", "\u0aaa\u0ab6\u0acd\u0a9a\u0abf\u0aae\u0ac0 \u0aab\u0acd\u0ab0\u0abf\u0ab8\u0abf\u0aaf\u0aa8" },
            { "ga", "\u0a86\u0a87\u0ab0\u0abf\u0ab6" },
            { "gd", "\u0ab8\u0acd\u0a95\u0acb\u0a9f\u0ac0\u0ab8 \u0a97\u0ac7\u0ab2\u0abf\u0a95" },
            { "gl", "\u0a97\u0ac7\u0ab2\u0abf\u0ab6\u0abf\u0aaf\u0aa8" },
            { "gn", "\u0a97\u0ac1\u0a86\u0ab0\u0abe\u0aa8\u0ac0" },
            { "bho", "\u0aad\u0acb\u0a9c\u0aaa\u0ac1\u0ab0\u0ac0" },
            { "und", "\u0a85\u0a9c\u0acd\u0a9e\u0abe\u0aa4 \u0aad\u0abe\u0ab7\u0abe" },
            { "type.ca.ethiopic-amete-alem", "\u0a87\u0aa5\u0abf\u0a93\u0aaa\u0abf\u0a95 \u0a8f\u0aae\u0ac7\u0a9f \u0a8f\u0ab2\u0ac7\u0aae \u0a95\u0ac7\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0ab0" },
            { "gu", metaValue_gu },
            { "type.ca.islamic-tbla", "\u0a87\u0ab8\u0acd\u0ab2\u0abe\u0aae\u0abf\u0a95 \u0a95\u0ac7\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0ab0 (\u0a9f\u0ac7\u0aac\u0acd\u0aaf\u0ac1\u0ab2\u0ab0, \u0a96\u0a97\u0acb\u0ab3\u0ab6\u0abe\u0ab8\u0acd\u0aa4\u0acd\u0ab0\u0ac0\u0aaf \u0aaf\u0ac1\u0a97)" },
            { "gv", "\u0aae\u0abe\u0a82\u0a95\u0acd\u0ab8" },
            { "ha", "\u0ab9\u0acc\u0ab8\u0abe" },
            { "he", metaValue_he },
            { "hi", "\u0ab9\u0abf\u0aa8\u0acd\u0aa6\u0ac0" },
            { "hup", "\u0ab9\u0ac2\u0aaa\u0abe" },
            { "bik", "\u0aac\u0abf\u0a95\u0acb\u0ab2" },
            { "bin", "\u0aac\u0abf\u0aa8\u0ac0" },
            { "ho", "\u0ab9\u0abf\u0ab0\u0ac0 \u0aae\u0acb\u0a9f\u0ac2" },
            { "hr", "\u0a95\u0acd\u0ab0\u0acb\u0a8f\u0ab6\u0abf\u0aaf\u0aa8" },
            { "ht", "\u0ab9\u0ac8\u0aa4\u0abf\u0a85\u0aa8 \u0a95\u0acd\u0ab0\u0ac7\u0a93\u0ab2\u0ac7" },
            { "hu", "\u0ab9\u0a82\u0a97\u0ac7\u0ab0\u0abf\u0aaf\u0aa8" },
            { "hy", "\u0a86\u0ab0\u0acd\u0aae\u0ac7\u0aa8\u0abf\u0aaf\u0aa8" },
            { "hz", "\u0ab9\u0ac7\u0ab0\u0ac7\u0ab0\u0acb" },
            { "frc", "\u0a95\u0abe\u0a9c\u0ac2\u0aa8 \u0aab\u0acd\u0ab0\u0ac7\u0aa8\u0acd\u0a9a" },
            { "ia", "\u0a87\u0a82\u0a9f\u0ab0\u0ab2\u0abf\u0a82\u0a97\u0ac1\u0a86" },
            { "Jamo", "\u0a9c\u0ac7\u0aae\u0acb" },
            { "id", "\u0a87\u0aa8\u0acd\u0aa1\u0acb\u0aa8\u0ac7\u0ab6\u0abf\u0aaf\u0aa8" },
            { "type.nu.tibt", "\u0aa4\u0abf\u0aac\u0ac7\u0a9f\u0abf\u0aaf\u0aa8 \u0a85\u0a82\u0a95\u0acb" },
            { "ie", "\u0a87\u0a82\u0a9f\u0ab0\u0ab2\u0abf\u0a82\u0a97" },
            { "ig", "\u0a87\u0a97\u0acd\u0aac\u0acb" },
            { "ii", "\u0ab8\u0abf\u0a9a\u0ac1\u0a86\u0aa8 \u0aaf\u0ac0" },
            { "frm", "\u0aae\u0abf\u0aa1\u0abf\u0ab2 \u0aab\u0acd\u0ab0\u0ac7\u0a82\u0a9a" },
            { "ik", "\u0a87\u0aa8\u0ac1\u0aaa\u0abf\u0aaf\u0abe\u0a95" },
            { "fro", "\u0a9c\u0ac2\u0aa8\u0ac0 \u0aab\u0acd\u0ab0\u0ac7\u0a82\u0a9a" },
            { "io", "\u0a88\u0aa1\u0acb" },
            { "frs", "\u0aaa\u0ac2\u0ab0\u0acd\u0ab5 \u0aab\u0acd\u0ab0\u0abf\u0ab6\u0abf\u0aaf\u0aa8" },
            { "frr", "\u0a89\u0aa4\u0acd\u0aa4\u0ab0\u0ac0\u0aaf \u0aab\u0acd\u0ab0\u0abf\u0ab6\u0abf\u0aaf\u0aa8" },
            { "is", "\u0a86\u0a87\u0ab8\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0abf\u0a95" },
            { "it", "\u0a87\u0a9f\u0abe\u0ab2\u0abf\u0aaf\u0aa8" },
            { "iu", "\u0a87\u0aa8\u0ac1\u0a95\u0abf\u0a9f\u0ac2\u0a9f" },
            { "Mlym", metaValue_ml },
            { "ja", "\u0a9c\u0abe\u0aaa\u0abe\u0aa8\u0ac0\u0a9d" },
            { "Sara", "\u0ab8\u0ab0\u0abe\u0aa4\u0ac0" },
            { "doi", "\u0aa1\u0acb\u0a97\u0acd\u0ab0\u0ac0" },
            { "sma", "\u0aa6\u0a95\u0acd\u0ab7\u0abf\u0aa3\u0ac0 \u0ab8\u0abe\u0aae\u0ac0" },
            { "jv", metaValue_jv },
            { "Shaw", "\u0ab6\u0abe\u0ab5\u0abf\u0aaf\u0abe\u0aa8" },
            { "mad", "\u0aae\u0abe\u0aa6\u0ac1\u0ab0\u0ac0\u0ab8" },
            { "smj", "\u0ab2\u0ac1\u0ab2\u0ac7 \u0ab8\u0abe\u0aae\u0ac0" },
            { "mag", "\u0aae\u0a97\u0ab9\u0ac0" },
            { "mai", "\u0aae\u0ac8\u0aa5\u0abf\u0ab2\u0ac0" },
            { "smn", "\u0a87\u0aa8\u0abe\u0ab0\u0ac0 \u0ab8\u0abe\u0aae\u0ac0" },
            { "ka", "\u0a9c\u0acd\u0aaf\u0acb\u0ab0\u0acd\u0a9c\u0abf\u0aaf\u0aa8" },
            { "bla", "\u0ab8\u0abf\u0a95\u0acd\u0ab8\u0abf\u0a95\u0abe" },
            { "mak", "\u0aae\u0a95\u0abe\u0ab8\u0ab0" },
            { "sms", "\u0ab8\u0acd\u0a95\u0acb\u0ab2\u0acd\u0a9f \u0ab8\u0abe\u0aae\u0ac0" },
            { "man", "\u0aae\u0aa8\u0acd\u0aa1\u0abf\u0aa8\u0acd\u0a97\u0acb" },
            { "kg", "\u0a95\u0acb\u0a82\u0a97\u0acb" },
            { "Goth", metaValue_got },
            { "ki", "\u0a95\u0abf\u0a95\u0ac1\u0aaf\u0ac2" },
            { "mas", "\u0aae\u0ab8\u0abe\u0a87" },
            { "kj", "\u0a95\u0acd\u0ab5\u0abe\u0aa8\u0acd\u0aaf\u0abe\u0aae\u0abe" },
            { "kk", "\u0a95\u0a9d\u0abe\u0a96" },
            { "kl", "\u0a95\u0ab2\u0abe\u0ab2\u0acd\u0ab2\u0abf\u0ab8\u0ac1\u0aa4" },
            { "km", metaValue_km },
            { "kn", "\u0a95\u0aa8\u0acd\u0aa8\u0aa1" },
            { "ko", metaValue_ko },
            { "kr", "\u0a95\u0aa8\u0ac1\u0ab0\u0ac0" },
            { "ks", "\u0a95\u0abe\u0ab6\u0acd\u0aae\u0ac0\u0ab0\u0ac0" },
            { "Cirt", "\u0ab8\u0abf\u0ab0\u0acd\u0aa5" },
            { "Lepc", "\u0ab2\u0ac7\u0aaa\u0a9a\u0abe" },
            { "Avst", metaValue_ae },
            { "ku", "\u0a95\u0ac1\u0ab0\u0acd\u0aa6\u0abf\u0ab6" },
            { "kv", "\u0a95\u0acb\u0aae\u0ac0" },
            { "kw", "\u0a95\u0acb\u0ab0\u0acd\u0aa8\u0abf\u0ab6" },
            { "ky", "\u0a95\u0abf\u0ab0\u0acd\u0a97\u0ac0\u0a9d" },
            { "snk", "\u0ab8\u0acb\u0aa8\u0abf\u0aa8\u0acd\u0a95\u0ac7" },
            { "la", metaValue_la },
            { "lb", "\u0ab2\u0a95\u0acd\u0a9d\u0ac7\u0aae\u0aac\u0ab0\u0acd\u0a97\u0abf\u0ab6" },
            { "type.nu.mlym", "\u0aae\u0ab2\u0aaf\u0abe\u0ab2\u0aae \u0a85\u0a82\u0a95\u0acb" },
            { "lg", "\u0a97\u0abe\u0a82\u0aa1\u0abe" },
            { "Roro", "\u0ab0\u0acb\u0a82\u0a97\u0acb\u0ab0\u0acb\u0a82\u0a97\u0acb" },
            { "li", "\u0ab2\u0abf\u0a82\u0aac\u0ac2\u0ab0\u0acd\u0a97\u0abf\u0ab6" },
            { "Tibt", "\u0a9f\u0abf\u0aac\u0ac7\u0a9f\u0ac0" },
            { "ln", "\u0ab2\u0abf\u0a82\u0a97\u0abe\u0ab2\u0abe" },
            { "fur", "\u0aab\u0acd\u0ab0\u0abf\u0aaf\u0ac1\u0ab2\u0abf\u0aaf\u0abe\u0aa8" },
            { "lo", metaValue_lo },
            { "type.ms.uksystem", "\u0ab0\u0a9c\u0ab5\u0abe\u0aa1\u0ac1\u0a82 \u0aae\u0abe\u0aaa\u0aa6\u0a82\u0aa1 \u0aaa\u0aa6\u0acd\u0aa7\u0aa4\u0abf" },
            { "lt", "\u0ab2\u0abf\u0aa5\u0ac1\u0a86\u0aa8\u0abf\u0aaf\u0aa8" },
            { "lu", "\u0ab2\u0ac2\u0aac\u0abe-\u0a95\u0a9f\u0abe\u0a82\u0a97\u0abe" },
            { "lv", "\u0ab2\u0abe\u0aa4\u0ab5\u0abf\u0aaf\u0aa8" },
            { "sog", "\u0ab8\u0acb\u0a97\u0acd\u0aa1\u0abf\u0a8f\u0aa8" },
            { "mg", "\u0aae\u0ab2\u0abe\u0a97\u0ab8\u0ac0" },
            { "mh", "\u0aae\u0abe\u0ab0\u0acd\u0ab6\u0ab2\u0ac0\u0a9d" },
            { "type.co.ducet", "\u0aa1\u0abf\u0aab\u0acb\u0ab2\u0acd\u0a9f \u0aaf\u0ac1\u0aa8\u0abf\u0a95\u0acb\u0aa1 \u0ab8\u0ac9\u0ab0\u0acd\u0a9f \u0a95\u0acd\u0ab0\u0aae" },
            { "mi", "\u0aae\u0abe\u0a93\u0ab0\u0ac0" },
            { "mk", "\u0aae\u0ac7\u0ab8\u0ac7\u0aa1\u0acb\u0aa8\u0abf\u0aaf\u0aa8" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "\u0aae\u0ab0\u0abe\u0aa0\u0ac0" },
            { "ms", "\u0aae\u0ab2\u0aaf" },
            { "mt", "\u0aae\u0abe\u0ab2\u0acd\u0a9f\u0abf\u0a9d" },
            { "my", "\u0aac\u0ab0\u0acd\u0aae\u0ac0\u0a9d" },
            { "Saur", "\u0ab8\u0acc\u0ab0\u0abe\u0ab7\u0acd\u0a9f\u0acd\u0ab0" },
            { "Armn", "\u0a85\u0ab0\u0acd\u0aae\u0ac7\u0aa8\u0abf\u0aaf\u0aa8" },
            { "mdf", "\u0aae\u0acb\u0a95\u0acd\u0ab7" },
            { "dsb", "\u0ab2\u0acb\u0a85\u0ab0 \u0ab8\u0acb\u0ab0\u0acd\u0aac\u0abf\u0aaf\u0aa8" },
            { "Armi", "\u0a87\u0aae\u0acd\u0aaa\u0abf\u0ab0\u0abf\u0aaf\u0ab2 \u0a86\u0ab0\u0acd\u0aae\u0aa8\u0abf\u0a95" },
            { "na", "\u0aa8\u0abe\u0a89\u0ab0\u0ac2" },
            { "type.co.search", "\u0ab8\u0abe\u0aae\u0abe\u0aa8\u0acd\u0aaf-\u0a89\u0aa6\u0acd\u0aa6\u0ac7\u0ab6 \u0ab6\u0acb\u0aa7" },
            { "nb", "\u0aa8\u0acb\u0ab0\u0acd\u0ab5\u0ac7\u0a9c\u0abf\u0aaf\u0aa8 \u0aac\u0acb\u0a95\u0aae\u0abe\u0ab2" },
            { "nd", "\u0a89\u0aa4\u0acd\u0aa4\u0ab0 \u0aa6\u0ac7\u0aac\u0ac7\u0ab2" },
            { "ne", "\u0aa8\u0ac7\u0aaa\u0abe\u0ab3\u0ac0" },
            { "ng", "\u0aa1\u0acb\u0aa8\u0acd\u0a97\u0abe" },
            { "mdr", "\u0aae\u0a82\u0aa6\u0abe\u0ab0" },
            { "nl", "\u0aa1\u0a9a" },
            { "nn", "\u0aa8\u0acb\u0ab0\u0acd\u0ab5\u0ac7\u0a9c\u0abf\u0aaf\u0aa8 \u0aa8\u0abe\u0aaf\u0aa8\u0ac9\u0ab0\u0acd\u0ab8\u0acd\u0a95" },
            { "no", "\u0aa8\u0ac9\u0ab0\u0acd\u0ab5\u0ac7\u0a9c\u0ac0\u0aaf\u0aa8" },
            { "nr", "\u0aa6\u0a95\u0acd\u0ab7\u0abf\u0aa3 \u0aa6\u0ac7\u0aac\u0ac7\u0ab2" },
            { "nv", "\u0aa8\u0abe\u0ab5\u0abe\u0a9c\u0acb" },
            { "kaa", "\u0a95\u0abe\u0ab0\u0abe-\u0a95\u0ab2\u0acd\u0aaa\u0a95" },
            { "ny", "\u0aa8\u0acd\u0aaf\u0abe\u0aa8\u0acd\u0a9c\u0abe" },
            { "kac", "\u0a95\u0abe\u0a9a\u0abf\u0aa8" },
            { "kab", "\u0a95\u0aac\u0abe\u0a87\u0ab2" },
            { "oc", "\u0a93\u0a95\u0acd\u0ab8\u0abf\u0a9f\u0aa8" },
            { "kaj", "\u0a9c\u0acd\u0a9c\u0ac1" },
            { "kam", "\u0a95\u0aae\u0acd\u0aac\u0abe" },
            { "men", "\u0aae\u0ac7\u0aa8\u0acd\u0aa1\u0ac7" },
            { "oj", "\u0a93\u0a9c\u0abf\u0aac\u0acd\u0ab5\u0abe" },
            { "mer", "\u0aae\u0ac7\u0ab0\u0ac1" },
            { "type.nu.armn", "\u0a85\u0ab0\u0acd\u0aae\u0ac7\u0aa8\u0abf\u0aaf\u0aa8 \u0ab8\u0a82\u0a96\u0acd\u0aaf\u0abe\u0a93" },
            { "om", "\u0a93\u0ab0\u0acb\u0aae\u0acb" },
            { "kaw", "\u0a95\u0abe\u0ab5\u0ac0" },
            { "or", metaValue_or },
            { "os", "\u0a93\u0ab8\u0acd\u0ab8\u0ac7\u0a9f\u0abf\u0a95" },
            { "bpy", "\u0aac\u0abf\u0ab7\u0acd\u0aa8\u0ac1\u0aaa\u0acd\u0ab0\u0abf\u0aaf\u0abe" },
            { "kbd", "\u0a95\u0aac\u0abe\u0ab0\u0acd\u0aa1\u0abf\u0aaf\u0aa8" },
            { "mfe", "\u0aae\u0acb\u0ab0\u0ac0\u0ab8\u0acd\u0aaf\u0ac7\u0aa8" },
            { "srn", "\u0ab8\u0acd\u0ab0\u0abe\u0aa8\u0aa8 \u0a9f\u0acb\u0aa8\u0acd\u0a97\u0acb" },
            { "pa", "\u0aaa\u0a82\u0a9c\u0abe\u0aac\u0ac0" },
            { "dua", "\u0aa6\u0ac1\u0a86\u0ab2\u0abe" },
            { "srr", "\u0ab8\u0ac7\u0ab0\u0ac7\u0ab0" },
            { "pi", "\u0aaa\u0abe\u0ab2\u0ac0" },
            { "pl", "\u0aaa\u0acb\u0ab2\u0ac0\u0ab6" },
            { "dum", "\u0aae\u0aa7\u0acd\u0aaf \u0aa1\u0a9a" },
            { "type.ca.dangi", "\u0aa1\u0abe\u0a82\u0a97\u0ac0 \u0a95\u0ac7\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0ab0" },
            { "ps", "\u0aaa\u0ab6\u0acd\u0aa4\u0acb" },
            { "pt", "\u0aaa\u0acb\u0ab0\u0acd\u0a9f\u0ac1\u0a97\u0ac0\u0a9d" },
            { "mga", "\u0aae\u0aa7\u0acd\u0aaf \u0a86\u0a88\u0ab0\u0abf\u0ab6" },
            { "key.co", "\u0ab8\u0ac9\u0ab0\u0acd\u0a9f \u0a95\u0acd\u0ab0\u0aae" },
            { "pt_BR", "\u0aac\u0acd\u0ab0\u0abe\u0a9d\u0abf\u0ab2\u0ac0\u0aaf\u0aa8 \u0aaa\u0acb\u0ab0\u0acd\u0a9f\u0ac1\u0a97\u0ac0\u0a9d" },
            { "kcg", "\u0aa4\u0acd\u0aaf\u0abe\u0aaa" },
            { "mgh", "\u0aae\u0abe\u0a96\u0ac1\u0ab5\u0abe-\u0aae\u0ac0\u0a9f\u0acd\u0a9f\u0ac1" },
            { "key.cf", "\u0a9a\u0ab2\u0aa3\u0ac0 \u0aac\u0a82\u0aa7\u0abe\u0ab0\u0aa3" },
            { "bra", "\u0ab5\u0acd\u0ab0\u0a9c" },
            { "key.ca", "\u0a95\u0ac7\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0ab0" },
            { "Laoo", metaValue_lo },
            { "mgo", "\u0aae\u0ac7\u0aa4\u0abe" },
            { "type.hc.h23", "24 \u0a95\u0ab2\u0abe\u0a95\u0aa8\u0ac0 \u0ab8\u0abf\u0ab8\u0acd\u0a9f\u0aae (0\u201323)" },
            { "type.hc.h24", "24 \u0a95\u0ab2\u0abe\u0a95\u0aa8\u0ac0 \u0ab8\u0abf\u0ab8\u0acd\u0a9f\u0aae (1\u201324)" },
            { "ssy", "\u0ab8\u0abe\u0ab9\u0acb" },
            { "brh", "\u0aac\u0acd\u0ab0\u0abe\u0ab9\u0ac1\u0a88" },
            { "type.nu.mymr", "\u0aae\u0acd\u0aaf\u0abe\u0aa8\u0acd\u0aae\u0abe\u0ab0 \u0a85\u0a82\u0a95\u0acb" },
            { "qu", "\u0a95\u0acd\u0ab5\u0ac7\u0a9a\u0ac1\u0a86" },
            { "zap", "\u0a9d\u0ac7\u0aaa\u0acb\u0a9f\u0ac7\u0a95" },
            { "brx", "\u0aac\u0acb\u0aa1\u0acb" },
            { "Lana", "\u0ab2\u0abe\u0aa8\u0abe" },
            { "kde", "\u0aae\u0a95\u0acb\u0aa8\u0acd\u0aa1\u0ac7" },
            { "Ethi", "\u0a87\u0aa5\u0abf\u0aaf\u0acb\u0aaa\u0abf\u0a95" },
            { "type.hc.h12", "12 \u0a95\u0ab2\u0abe\u0a95\u0aa8\u0ac0 \u0ab8\u0abf\u0ab8\u0acd\u0a9f\u0aae (1\u201312)" },
            { "type.hc.h11", "12 \u0a95\u0ab2\u0abe\u0a95\u0aa8\u0ac0 \u0ab8\u0abf\u0ab8\u0acd\u0a9f\u0aae (0\u201311)" },
            { "rm", "\u0ab0\u0acb\u0aae\u0abe\u0aa8\u0acd\u0ab6" },
            { "rn", "\u0ab0\u0ac2\u0aa8\u0acd\u0aa6\u0ac0" },
            { "key.cu", "\u0a9a\u0ab2\u0aa3" },
            { "ro", "\u0ab0\u0acb\u0aae\u0abe\u0aa8\u0abf\u0aaf\u0aa8" },
            { "type.nu.orya", "\u0a93\u0ab0\u0abf\u0aaf\u0abe \u0a85\u0a82\u0a95\u0acb" },
            { "type.nu.hanidec", "\u0a9a\u0abe\u0a87\u0aa8\u0ac0\u0a9d \u0aa6\u0ab6\u0abe\u0a82\u0ab6 \u0ab8\u0a82\u0a96\u0acd\u0aaf\u0abe\u0a93" },
            { "ru", "\u0ab0\u0ab6\u0abf\u0aaf\u0aa8" },
            { "zbl", metaValue_zbl },
            { "rw", "\u0a95\u0abf\u0aa8\u0acd\u0aaf\u0abe\u0ab0\u0ab5\u0abe\u0aa8\u0acd\u0aa1\u0abe" },
            { "kea", "\u0a95\u0abe\u0aac\u0ac1\u0ab5\u0ab0\u0acd\u0aa1\u0abf\u0a86\u0aa8\u0ac1" },
            { "mic", "\u0aae\u0abf\u0a95\u0aae\u0ac7\u0a95" },
            { "suk", "\u0ab8\u0ac1\u0a95\u0ac1\u0aae\u0abe" },
            { "en_AU", "\u0a93\u0ab8\u0acd\u0a9f\u0acd\u0ab0\u0ac7\u0ab2\u0abf\u0aaf\u0aa8 \u0a85\u0a82\u0a97\u0acd\u0ab0\u0ac7\u0a9c\u0ac0" },
            { "sa", "\u0ab8\u0a82\u0ab8\u0acd\u0a95\u0ac3\u0aa4" },
            { "sc", "\u0ab8\u0abe\u0ab0\u0acd\u0aa6\u0abf\u0aa8\u0abf\u0aaf\u0aa8" },
            { "sus", "\u0ab8\u0ac1\u0ab8\u0ac1" },
            { "sd", "\u0ab8\u0abf\u0a82\u0aa7\u0ac0" },
            { "se", "\u0a89\u0aa4\u0acd\u0aa4\u0ab0\u0ac0 \u0ab8\u0abe\u0aae\u0ac0" },
            { "min", "\u0aae\u0abf\u0aa8\u0abe\u0a82\u0a97\u0acd\u0a95\u0abe\u0aac\u0abe\u0a89" },
            { "sg", "\u0ab8\u0abe\u0a82\u0a97\u0acb" },
            { "sh", "\u0ab8\u0ab0\u0acd\u0aac\u0acb-\u0a95\u0acd\u0ab0\u0acb\u0a8f\u0ab6\u0abf\u0aaf\u0aa8" },
            { "si", "\u0ab8\u0abf\u0a82\u0ab9\u0abe\u0ab2\u0ac0" },
            { "sux", "\u0ab8\u0ac1\u0aae\u0ac7\u0ab0\u0abf\u0aaf\u0aa8" },
            { "sk", "\u0ab8\u0acd\u0ab2\u0acb\u0ab5\u0ac5\u0a95" },
            { "sl", "\u0ab8\u0acd\u0ab2\u0acb\u0ab5\u0ac7\u0aa8\u0abf\u0aaf\u0aa8" },
            { "sm", "\u0ab8\u0abe\u0aae\u0acb\u0aa8" },
            { "sn", "\u0ab6\u0acb\u0aa8\u0abe" },
            { "so", "\u0ab8\u0acb\u0aae\u0abe\u0ab2\u0ac0" },
            { "type.nu.arab", "\u0a85\u0ab0\u0ac7\u0aac\u0abf\u0a95-\u0aad\u0abe\u0ab0\u0aa4\u0ac0\u0aaf \u0a85\u0a82\u0a95\u0acb" },
            { "sq", "\u0a85\u0ab2\u0acd\u0aac\u0ac7\u0aa8\u0abf\u0aaf\u0aa8" },
            { "sr", "\u0ab8\u0ab0\u0acd\u0aac\u0abf\u0aaf\u0aa8" },
            { "ss", "\u0ab8\u0acd\u0ab5\u0abe\u0aa4\u0ac0" },
            { "type.cf.account", "\u0ab9\u0abf\u0ab8\u0abe\u0aac\u0ac0 \u0a9a\u0ab2\u0aa3\u0ac0 \u0aac\u0a82\u0aa7\u0abe\u0ab0\u0aa3" },
            { "Java", metaValue_jv },
            { "st", "\u0aa6\u0a95\u0acd\u0ab7\u0abf\u0aa3 \u0ab8\u0acb\u0aa5\u0acb" },
            { "su", "\u0ab8\u0a82\u0aa1\u0ac7\u0aa8\u0ac0\u0a9d" },
            { "sv", "\u0ab8\u0acd\u0ab5\u0ac0\u0aa1\u0abf\u0ab6" },
            { "sw", "\u0ab8\u0acd\u0ab5\u0abe\u0ab9\u0abf\u0ab2\u0ac0" },
            { "type.nu.hantfin", "\u0aaa\u0ab0\u0a82\u0aaa\u0ab0\u0abe\u0a97\u0aa4 \u0a9a\u0abe\u0a87\u0aa8\u0ac0\u0a9d \u0aa8\u0abe\u0aa3\u0abe\u0a95\u0ac0\u0aaf \u0ab8\u0a82\u0a96\u0acd\u0aaf\u0abe\u0a93" },
            { "ibb", "\u0a87\u0aac\u0abf\u0aac\u0abf\u0a93" },
            { "iba", "\u0a87\u0aac\u0abe\u0aa8" },
            { "ta", metaValue_ta },
            { "142", "\u0a8f\u0ab6\u0abf\u0aaf\u0abe" },
            { "bua", "\u0aac\u0ac1\u0ab0\u0abf\u0aaf\u0abe\u0aa4" },
            { "143", "\u0aae\u0aa7\u0acd\u0aaf \u0a8f\u0ab6\u0abf\u0aaf\u0abe" },
            { "te", metaValue_te },
            { "145", "\u0aaa\u0ab6\u0acd\u0a9a\u0abf\u0aae\u0ac0 \u0a8f\u0ab6\u0abf\u0aaf\u0abe" },
            { "tg", "\u0aa4\u0abe\u0a9c\u0ac0\u0a95" },
            { "th", "\u0aa5\u0abe\u0a88" },
            { "ti", "\u0a9f\u0abe\u0a87\u0a97\u0acd\u0ab0\u0abf\u0aa8\u0abf\u0aaf\u0abe" },
            { "bug", "\u0aac\u0ac1\u0a97\u0abf\u0aa8\u0ac0\u0ab8" },
            { "kfo", "\u0a95\u0acb\u0ab0\u0acb" },
            { "en_CA", "\u0a95\u0ac7\u0aa8\u0ac7\u0aa1\u0abf\u0aaf\u0aa8 \u0a85\u0a82\u0a97\u0acd\u0ab0\u0ac7\u0a9c\u0ac0" },
            { "tk", "\u0aa4\u0ac1\u0ab0\u0acd\u0a95\u0aae\u0ac7\u0aa8" },
            { "tl", "\u0a9f\u0abe\u0a97\u0abe\u0ab2\u0acb\u0a97" },
            { "tn", "\u0aa4\u0acd\u0ab8\u0acd\u0ab5\u0abe\u0aa8\u0abe" },
            { "to", "\u0a9f\u0acb\u0a82\u0a97\u0abe\u0aa8" },
            { "dyo", "\u0a9c\u0acb\u0ab2\u0abe-\u0aab\u0acb\u0aa8\u0acd\u0aaf\u0ac0" },
            { "type.nu.jpan", "\u0a9c\u0abe\u0aaa\u0abe\u0aa8\u0ac0\u0a9d \u0ab8\u0a82\u0a96\u0acd\u0aaf\u0abe\u0a93" },
            { "tr", "\u0a9f\u0ab0\u0acd\u0a95\u0abf\u0ab6" },
            { "Cakm", metaValue_ccp },
            { "ts", "\u0ab8\u0acb\u0a82\u0a97\u0abe" },
            { "swb", "\u0a95\u0acb\u0aae\u0acb\u0ab0\u0abf\u0aaf\u0aa8" },
            { "tt", "\u0aa4\u0aa4\u0abe\u0ab0" },
            { "dyu", "\u0aa1\u0acd\u0aaf\u0ac1\u0ab2\u0abe" },
            { "tw", "\u0a9f\u0acd\u0ab5\u0abe\u0a87" },
            { "ty", "\u0aa4\u0abe\u0ab9\u0abf\u0aa4\u0abf\u0aaf\u0aa8" },
            { "150", "\u0aaf\u0ac1\u0ab0\u0acb\u0aaa" },
            { "151", "\u0aaa\u0ac2\u0ab0\u0acd\u0ab5\u0ac0\u0aaf \u0aaf\u0ac1\u0ab0\u0acb\u0aaa" },
            { "154", "\u0a89\u0aa4\u0acd\u0aa4\u0ab0\u0ac0\u0aaf \u0aaf\u0ac1\u0ab0\u0acb\u0aaa" },
            { "dzg", "\u0aa6\u0abe\u0a9d\u0abe\u0a97\u0abe" },
            { "155", "\u0aaa\u0ab6\u0acd\u0a9a\u0abf\u0aae\u0ac0 \u0aaf\u0ac1\u0ab0\u0acb\u0aaa" },
            { "ug", "\u0a89\u0a87\u0a97\u0ac1\u0ab0" },
            { "Kore", metaValue_ko },
            { "Ital", "\u0a9c\u0ac2\u0aa8\u0ac1 \u0a87\u0a9f\u0abe\u0ab2\u0abf\u0a95" },
            { "Zyyy", "\u0ab8\u0abe\u0aae\u0abe\u0aa8\u0acd\u0aaf" },
            { "uk", "\u0aaf\u0ac1\u0a95\u0acd\u0ab0\u0ac7\u0aa8\u0abf\u0aaf\u0aa8" },
            { "type.ca.coptic", "\u0a95\u0acb\u0aaa\u0acd\u0a9f\u0abf\u0a95 \u0a95\u0ac7\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0ab0" },
            { "ur", "\u0a89\u0ab0\u0acd\u0aa6\u0ac2" },
            { "xal", "\u0a95\u0abe\u0ab2\u0acd\u0aae\u0abf\u0a95" },
            { "zen", "\u0a9d\u0ac7\u0aa8\u0abe\u0a97\u0abe" },
            { "uz", "\u0a89\u0a9d\u0acd\u0aac\u0ac7\u0a95" },
            { "kha", "\u0a96\u0abe\u0ab8\u0ac0" },
            { "nds_NL", "\u0ab2\u0acb \u0ab8\u0ac7\u0a95\u0acd\u0ab8\u0acb\u0aa8" },
            { "Sylo", "\u0ab8\u0abf\u0ab2\u0acb\u0aa4\u0ac0 \u0aa8\u0abe\u0a97\u0ab0\u0ac0" },
            { "ve", "\u0ab5\u0ac7\u0aa8\u0acd\u0aa6\u0abe" },
            { "type.ca.roc", "\u0aae\u0abf\u0a82\u0a97\u0ac1\u0a93 \u0a95\u0ac7\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0ab0" },
            { "vi", "\u0ab5\u0abf\u0aaf\u0ac7\u0aa4\u0aa8\u0abe\u0aae\u0ac0\u0ab8" },
            { "kho", "\u0a96\u0acb\u0aa4\u0abe\u0aa8\u0ac0\u0ab8" },
            { "khq", "\u0a95\u0acb\u0aaf\u0ab0\u0abe \u0a9a\u0abf\u0aa8\u0abf" },
            { "key.hc", "\u0a95\u0ab2\u0abe\u0a95\u0aa8\u0ac1\u0a82 \u0a86\u0ab5\u0ab0\u0acd\u0aa4\u0aa8 (12 \u0ab5\u0abf.24)" },
            { "vo", "\u0ab5\u0acb\u0ab2\u0abe\u0aaa\u0ac1\u0a95" },
            { "syc", "\u0aaa\u0ab0\u0a82\u0aaa\u0ab0\u0abe\u0a97\u0aa4 \u0ab8\u0abf\u0ab0\u0abf\u0a8f\u0a95" },
            { "Osma", "\u0a93\u0ab8\u0acd\u0aae\u0abe\u0aa8\u0acd\u0aaf\u0abe" },
            { "quc", "\u0a95\u0abf\u0a9a\u0ac7" },
            { "gaa", "\u0a97\u0abe" },
            { "wa", "\u0ab5\u0abe\u0ab2\u0ac2\u0aa8" },
            { "gag", "\u0a97\u0abe\u0a97\u0abe\u0a9d" },
            { "syr", "\u0ab8\u0abf\u0ab0\u0abf\u0a8f\u0a95" },
            { "Grek", metaValue_el },
            { "gan", "gan" },
            { "Lydi", "\u0ab2\u0abf\u0aa1\u0abf\u0aaf\u0aa8" },
            { "Xsux", "\u0ab8\u0ac1\u0aae\u0ac7\u0ab0\u0acb \u0a85\u0a95\u0acd\u0a95\u0abe\u0aa6\u0abf\u0aaf\u0aa8 \u0ab8\u0ac1\u0aa8\u0abf\u0aab\u0acb\u0ab0\u0acd\u0aae" },
            { "wo", "\u0ab5\u0acb\u0ab2\u0acb\u0aab" },
            { "zgh", "\u0aae\u0abe\u0aa8\u0a95 \u0aae\u0acb\u0ab0\u0acb\u0a95\u0acd\u0a95\u0aa8 \u0aa4\u0abe\u0aae\u0abe\u0a9d\u0abf\u0a9f" },
            { "ar_001", "\u0aae\u0acb\u0aa1\u0ab0\u0acd\u0aa8 \u0ab8\u0acd\u0a9f\u0abe\u0aa8\u0acd\u0aa1\u0ab0\u0acd\u0aa1 \u0a85\u0ab0\u0aac\u0ac0" },
            { "Cans", "\u0aaf\u0ac1\u0aa8\u0abe\u0a87\u0a9f\u0ac7\u0aa1 \u0a95\u0ac7\u0aa8\u0ac7\u0aa1\u0abf\u0aaf\u0aa8 \u0a8f\u0aac\u0acb\u0ab0\u0abf\u0a9c\u0aa8\u0ab2 \u0ab8\u0abf\u0ab2\u0ac7\u0aac\u0abf\u0a95\u0acd\u0ab8" },
            { "gay", "\u0a97\u0abe\u0aaf\u0acb" },
            { "Mong", metaValue_mn },
            { "mnc", "\u0aae\u0abe\u0aa8\u0acd\u0a9a\u0ac1" },
            { "Latf", "\u0aab\u0acd\u0ab0\u0ac7\u0a95\u0aa4\u0ac1\u0ab0 \u0ab2\u0ac7\u0a9f\u0abf\u0aa8" },
            { "gba", "\u0aac\u0abe\u0aaf\u0abe" },
            { "mni", "\u0aae\u0aa3\u0abf\u0aaa\u0ac1\u0ab0\u0ac0" },
            { "Latn", metaValue_la },
            { "Latg", "\u0a97\u0ac8\u0ab2\u0abf\u0a95 \u0ab2\u0ac7\u0a9f\u0abf\u0aa8" },
            { "type.nu.hans", "\u0ab8\u0ab0\u0ab3\u0ac0\u0a95\u0ac3\u0aa4 \u0a9a\u0abe\u0a87\u0aa8\u0ac0\u0a9d \u0ab8\u0a82\u0a96\u0acd\u0aaf\u0abe\u0a93" },
            { "type.nu.hant", "\u0aaa\u0ab0\u0a82\u0aaa\u0ab0\u0abe\u0a97\u0aa4 \u0a9a\u0abe\u0a87\u0aa8\u0ac0\u0a9d \u0ab8\u0a82\u0a96\u0acd\u0aaf\u0abe\u0a93" },
            { "xh", "\u0a96\u0acb\u0ab8\u0abe" },
            { "type.nu.romanlow", "\u0ab0\u0acb\u0aae\u0aa8 \u0aa8\u0abe\u0aa8\u0abe \u0a85\u0a95\u0acd\u0ab7\u0ab0\u0aa8\u0ac0 \u0ab8\u0a82\u0a96\u0acd\u0aaf\u0abe" },
            { "byn", "\u0aac\u0acd\u0ab2\u0abf\u0aa8" },
            { "Lyci", "\u0ab2\u0abf\u0ab6\u0abf\u0aaf\u0aa8" },
            { "osa", "\u0a93\u0ab8\u0ac7\u0a9c" },
            { "gbz", "\u0a9d\u0acb\u0ab0\u0acb\u0ab8\u0acd\u0a9f\u0acd\u0ab0\u0abf\u0a85\u0aa8 \u0aa6\u0abe\u0ab0\u0ac0" },
            { "Moon", "\u0aae\u0ac2\u0aa8" },
            { "moh", "\u0aae\u0acb\u0ab9\u0acc\u0a95" },
            { "kkj", "\u0a95\u0abe\u0a95\u0acb" },
            { "yi", "\u0aaf\u0abf\u0aa6\u0acd\u0aa6\u0abf\u0ab6" },
            { "mos", "\u0aae\u0acb\u0ab8\u0acd\u0ab8\u0ac0" },
            { "Syrc", "\u0ab8\u0abf\u0ab0\u0abf\u0aaf\u0ac7\u0a95" },
            { "Dsrt", "\u0aa1\u0ac7\u0ab8\u0ab0\u0ac7\u0a9f" },
            { "yo", "\u0aaf\u0acb\u0ab0\u0ac2\u0aac\u0abe" },
            { "type.nu.traditional", "\u0aaa\u0ab0\u0a82\u0aaa\u0ab0\u0abe\u0a97\u0aa4 \u0a85\u0a82\u0a95\u0acb" },
            { "es_MX", "\u0aae\u0ac7\u0a95\u0acd\u0ab8\u0abf\u0a95\u0aa8 \u0ab8\u0acd\u0aaa\u0ac7\u0aa8\u0abf\u0ab6" },
            { "Syrj", "\u0aaa\u0ab6\u0acd\u0a9a\u0abf\u0aae \u0ab8\u0abf\u0ab0\u0abf\u0aaf\u0abe\u0a95" },
            { "ota", "\u0a93\u0a9f\u0acb\u0aae\u0abe\u0aa8 \u0aa4\u0ac1\u0ab0\u0acd\u0a95\u0abf\u0ab6" },
            { "Syre", "\u0a8f\u0ab8\u0acd\u0aa4\u0acd\u0ab0\u0ac7\u0aa8\u0acd\u0a9c\u0ac7\u0ab2\u0acb \u0ab8\u0abf\u0ab0\u0abf\u0aaf\u0abe\u0a95" },
            { "vai", metaValue_vai },
            { "za", "\u0a9d\u0ac1\u0a86\u0a97" },
            { "Cari", "\u0a95\u0ab0\u0ac8\u0aa8" },
            { "kln", "\u0a95\u0ab2\u0ac7\u0a9c\u0abf\u0aa8" },
            { "zh", "\u0a9a\u0abe\u0a87\u0aa8\u0ac0\u0a9d" },
            { "Bopo", "\u0aac\u0acb\u0aaa\u0acb\u0aae\u0acb\u0aab\u0acb" },
            { "Perm", "\u0a93\u0ab2\u0acd\u0aa1 \u0aaa\u0ab0\u0aae\u0abf\u0a95" },
            { "key.lb", "\u0ab0\u0ac7\u0a96\u0abe \u0ab5\u0abf\u0ab0\u0abe\u0aae \u0aaa\u0acd\u0ab0\u0a95\u0abe\u0ab0" },
            { "zu", "\u0a9d\u0ac1\u0ab2\u0ac1" },
            { "type.co.phonebook", "\u0aab\u0acb\u0aa8\u0aac\u0ac1\u0a95 \u0a85\u0aa8\u0ac1\u0a95\u0acd\u0aae" },
            { "Geor", "\u0a9c\u0acd\u0aaf\u0acb\u0ab0\u0acd\u0a9c\u0abf\u0a85\u0aa8" },
            { "kmb", "\u0a95\u0abf\u0aae\u0acd\u0aac\u0aa8\u0acd\u0aa6\u0ac1" },
            { "type.nu.jpanfin", "\u0a9c\u0abe\u0aaa\u0abe\u0aa8\u0ac0\u0a9d \u0aa8\u0abe\u0aa3\u0abe\u0a95\u0ac0\u0aaf \u0ab8\u0a82\u0a96\u0acd\u0aaf\u0abe\u0a93" },
            { "gez", "\u0a97\u0ac0\u0a9d" },
            { "mrj", "\u0aaa\u0ab6\u0acd\u0a9a\u0abf\u0aae\u0ac0 \u0aae\u0abe\u0ab0\u0ac0" },
            { "Syrn", "\u0aaa\u0ac2\u0ab0\u0acd\u0ab5 \u0ab8\u0abf\u0ab0\u0abf\u0aaf\u0abe\u0a95" },
            { "type.co.reformed", "\u0aaa\u0ac2\u0aa8\u0ab0\u0acd\u0ab8\u0acd\u0ab5\u0ab0\u0ac2\u0aaa\u0abf\u0aa4 \u0a85\u0aa8\u0ac1\u0a95\u0acd\u0aae" },
            { "Tglg", "\u0a9f\u0ac7\u0a97\u0abe\u0ab2\u0acb\u0a97" },
            { "Egyd", "\u0a87\u0a9c\u0abf\u0aaa\u0acd\u0ab6\u0abf\u0aaf\u0aa8 \u0aa1\u0ac7\u0aae\u0acb\u0a9f\u0abf\u0a95" },
            { "Egyh", "\u0a87\u0a9c\u0abf\u0aaa\u0acd\u0ab6\u0abf\u0aaf\u0aa8 \u0ab9\u0abe\u0a87\u0ab0\u0ac7\u0a9f\u0abf\u0a95" },
            { "ebu", "\u0a8d\u0aae\u0acd\u0aac\u0ac1" },
            { "Egyp", "\u0a87\u0a9c\u0abf\u0aaa\u0acd\u0ab6\u0abf\u0aaf\u0aa8 \u0ab9\u0abe\u0a87\u0ab0\u0acb\u0a97\u0acd\u0ab2\u0abf\u0aab\u0acd\u0ab8" },
            { "Geok", "\u0a9c\u0acd\u0aaf\u0acb\u0ab0\u0acd\u0a9c\u0abf\u0a85\u0aa8 \u0a96\u0ac1\u0aa4\u0ab8\u0ac1\u0ab0\u0ac0" },
            { "zh_Hans", "\u0ab8\u0ab0\u0ab3\u0ac0\u0a95\u0ac3\u0aa4 \u0a9a\u0abe\u0a87\u0aa8\u0ac0\u0a9d" },
            { "koi", "\u0a95\u0acb\u0aae\u0ac0-\u0aaa\u0ab0\u0acd\u0aae\u0acd\u0aaf\u0abe\u0a95" },
            { "Hung", "\u0a93\u0ab2\u0acd\u0aa1 \u0ab9\u0a82\u0a97\u0ac7\u0ab0\u0abf\u0aaf\u0aa8" },
            { "kok", "\u0a95\u0acb\u0a82\u0a95\u0aa3\u0ac0" },
            { "kos", "\u0a95\u0acb\u0ab8\u0ab0\u0abf\u0aaf\u0aa8" },
            { "zh_Hant", "\u0aaa\u0abe\u0ab0\u0a82\u0aaa\u0ab0\u0abf\u0a95 \u0a9a\u0abe\u0a87\u0aa8\u0ac0\u0a9d" },
            { "Sund", "\u0ab8\u0ac1\u0aa6\u0abe\u0aa8\u0ac0\u0a9d" },
            { "kpe", "\u0a95\u0acd\u0aaa\u0ac7\u0ab2\u0acd\u0ab2\u0ac7" },
            { "type.nu.khmr", "\u0a96\u0acd\u0aae\u0ac7\u0ab0 \u0a85\u0a82\u0a95\u0acb" },
            { "ilo", "\u0a87\u0ab2\u0acb\u0a95\u0acb" },
            { "Cprt", "\u0ab8\u0abf\u0aaa\u0acd\u0ab0\u0abe\u0aaf\u0a9f" },
            { "mua", "\u0aae\u0ac1\u0aa8\u0aa1\u0abe\u0aa8\u0acd\u0a97" },
            { "type.nu.guru", "\u0a97\u0ac1\u0ab0\u0aae\u0ac1\u0a96\u0ac0 \u0a85\u0a82\u0a95\u0acb" },
            { "mul", "\u0aac\u0ab9\u0ac1\u0ab5\u0abf\u0aa7 \u0aad\u0abe\u0ab7\u0abe\u0a93" },
            { "cad", "\u0a95\u0aa1\u0acd\u0aa1\u0acb" },
            { "key.ms", "\u0aae\u0abe\u0aaa\u0aa6\u0a82\u0aa1 \u0aaa\u0aa6\u0acd\u0aa7\u0aa4\u0abf" },
            { "mus", "\u0a95\u0acd\u0ab0\u0abf\u0a95" },
            { "Glag", "\u0a97\u0acd\u0ab2\u0ac7\u0a97\u0acb\u0ab2\u0abf\u0a9f\u0abf\u0a95" },
            { "gil", "\u0a9c\u0abf\u0ab2\u0acd\u0aac\u0ab0\u0a9f\u0ac0\u0a9d" },
            { "Cher", "\u0a9a\u0ac7\u0ab0\u0acb\u0a95\u0ac0" },
            { "car", "\u0a95\u0ab0\u0abf\u0aac" },
            { "type.nu.tamldec", "\u0aa4\u0aae\u0abf\u0ab2 \u0a85\u0a82\u0a95\u0acb" },
            { "krc", "\u0a95\u0ab0\u0abe\u0a9a\u0aaf-\u0aac\u0ab2\u0acd\u0a95\u0abe\u0ab0" },
            { "inh", "\u0a87\u0a82\u0a97\u0ac1\u0ab6" },
            { "fa_AF", "\u0aa1\u0abe\u0ab0\u0ac0" },
            { "krl", "\u0a95\u0ab0\u0ac7\u0ab2\u0abf\u0aaf\u0aa8" },
            { "efi", "\u0a8f\u0aab\u0abf\u0a95" },
            { "tcy", "\u0aa4\u0ac1\u0ab2\u0ac1" },
            { "key.nu", "\u0a86\u0a82\u0a95\u0aa1\u0abe\u0a93" },
            { "kru", "\u0a95\u0ac1\u0ab0\u0ac2\u0a96" },
            { "ksb", "\u0ab6\u0aae\u0acd\u0aac\u0abe\u0ab2\u0abe" },
            { "Telu", metaValue_te },
            { "ksf", "\u0aac\u0aab\u0abf\u0aaf\u0abe" },
        };
        return data;
    }
}
