/*
 * Copyright (c) 2012, 2023, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_kea extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_bn = "bengali";
        final String metaValue_bo = "tibetanu";
        final String metaValue_el = "gregu";
        final String metaValue_gu = "gujarati";
        final String metaValue_he = "ebraiku";
        final String metaValue_hy = "arm\u00e9niu";
        final String metaValue_ja = "japones";
        final String metaValue_ka = "jorjianu";
        final String metaValue_km = "kmer";
        final String metaValue_kn = "kanares";
        final String metaValue_ko = "korianu";
        final String metaValue_lo = "lausianu";
        final String metaValue_ml = "malaialam";
        final String metaValue_my = "birmanes";
        final String metaValue_si = "singales";
        final String metaValue_ta = "tamil";
        final String metaValue_te = "telugu";
        final String metaValue_th = "tailandes";
        final Object[][] data = new Object[][] {
            { "ksh", "kolonhanu" },
            { "luo", "luo" },
            { "Zsym", "s\u00edmbulus" },
            { "fil", "filipinu" },
            { "hmn", "hmong" },
            { "ban", "balines" },
            { "Zsye", "emoji" },
            { "ccp", "xakma" },
            { "luy", "luyia" },
            { "bas", "basa" },
            { "es_ES", "spanhol europeu" },
            { "ab", "abk\u00e1ziu" },
            { "AC", "Ilha di Asenson" },
            { "AD", "Andora" },
            { "AE", "Emiradus \u00c1rabi Unidu" },
            { "nl_BE", "flamengu" },
            { "AF", "Afeganist\u00e3u" },
            { "af", "afrikaner" },
            { "AG", "Antigua i Barbuda" },
            { "type.ca.ethiopic", "Kalend\u00e1riu eti\u00f3piku" },
            { "AI", "Angila" },
            { "ak", "akan" },
            { "AL", "Alb\u00e1nia" },
            { "AM", "Arm\u00e9nia" },
            { "am", "am\u00e1riku" },
            { "Arab", "ar\u00e1biku" },
            { "AO", "Angola" },
            { "Jpan", metaValue_ja },
            { "AQ", "Ant\u00e1rtika" },
            { "AR", "Arjentina" },
            { "ar", "\u00e1rabi" },
            { "Hrkt", "silab\u00e1riu japunes" },
            { "AS", "Samoa Merkanu" },
            { "as", "asames" },
            { "AT", "\u00c1ustria" },
            { "AU", "Austr\u00e1lia" },
            { "AW", "Aruba" },
            { "en_US", "ingles merkanu" },
            { "AX", "Ilhas \u00c5land" },
            { "ay", "aimara" },
            { "AZ", "Azerbaidjan" },
            { "az", "azerbaijanu" },
            { "BA", "B\u00f3snia i Erzegovina" },
            { "ba", "baxkir" },
            { "BB", "Barbadus" },
            { "ceb", "sebuanu" },
            { "BD", "Bangladexi" },
            { "BE", "B\u00e9ljika" },
            { "be", "bielorusu" },
            { "BF", "Burkina Fasu" },
            { "BG", "Bulg\u00e1ria" },
            { "bg", "b\u00falgaru" },
            { "BH", "Barain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "San Bartolomeu" },
            { "BM", "Bermudas" },
            { "bm", "bambara" },
            { "bn", metaValue_bn },
            { "BN", "Brunei" },
            { "bo", metaValue_bo },
            { "BO", "Bol\u00edvia" },
            { "BQ", "Karaibas Olandezas" },
            { "BR", "Brazil" },
            { "br", "bret\u00e3u" },
            { "BS", "Baamas" },
            { "bs", "bosniu" },
            { "BT", "Butan" },
            { "BV", "Ilha Buv\u00ea" },
            { "Mymr", metaValue_my },
            { "BW", "Botsuana" },
            { "BY", "Belarus" },
            { "BZ", "Belizi" },
            { "type.ca.persian", "Kalend\u00e1riu persa" },
            { "CA", "Kanad\u00e1" },
            { "ca", "katal\u00e3u" },
            { "CC", "Ilhas Kokus (Keeling)" },
            { "ses", "koiraboro seni" },
            { "CD", "Kongu - Kinxasa" },
            { "ce", "txetxenu" },
            { "CF", "Republika Sentru-Afrikanu" },
            { "CG", "Kongu - Brazavili" },
            { "CH", "Suisa" },
            { "CI", "Kosta di Marfin" },
            { "CK", "Ilhas Kuk" },
            { "CL", "Xili" },
            { "CM", "Kamarons" },
            { "CN", "Xina" },
            { "CO", "Kol\u00f4mbia" },
            { "co", "k\u00f3rsiku" },
            { "CP", "Ilha Kliperton" },
            { "Orya", "oriya" },
            { "CR", "Kosta Rika" },
            { "cs", "txeku" },
            { "CU", "Kuba" },
            { "cu", "slavu kl\u00e9riku" },
            { "CV", "Kabu Verdi" },
            { "cv", "txuvaxi" },
            { "CW", "Kurasau" },
            { "CX", "Ilha di Natal" },
            { "CY", "Xipri" },
            { "cy", "gales" },
            { "CZ", "Tx\u00e9kia" },
            { "da", "dinamarkes" },
            { "pt_PT", "purtuges europeu" },
            { "DE", "Alimanha" },
            { "de", "alemon" },
            { "cgg", "xiga" },
            { "DG", "Diegu Garsia" },
            { "type.cf.standard", "Formatu di mueda padron" },
            { "DJ", "Djibuti" },
            { "DK", "Dinamarka" },
            { "Brai", "braille" },
            { "DM", "Dominika" },
            { "DO", "Rep\u00fablika Dominikana" },
            { "bem", "bemba" },
            { "es_419", "spanhol latinu-merkanu" },
            { "DZ", "Arj\u00e9lia" },
            { "dz", "dzonka" },
            { "bez", "bena" },
            { "type.ca.chinese", "Kalend\u00e1riu xines" },
            { "EA", "Seuta i Melilha" },
            { "EC", "Ekuador" },
            { "dje", "zarma" },
            { "EE", "St\u00f3nia" },
            { "ee", "eve" },
            { "type.lb.normal", "Stilu padron di kebra di linha" },
            { "EG", "Ejitu" },
            { "EH", "Sara Osidental" },
            { "ro_MD", "rumenu mold\u00e1viku" },
            { "el", metaValue_el },
            { "en", "ingles" },
            { "eo", "sperantu" },
            { "chr", "xeroki" },
            { "ER", "Iritreia" },
            { "ES", "Spanha" },
            { "es", "spanhol" },
            { "ET", "Eti\u00f3pia" },
            { "et", "stonianu" },
            { "EU", "Union Europeia" },
            { "eu", "basku" },
            { "Hang", "hangul" },
            { "type.ca.gregorian", "Kalend\u00e1riu Gregorianu" },
            { "EZ", "Eurozona" },
            { "hsb", "s\u00f3rbiu altu" },
            { "Hani", "han" },
            { "fa", "persa" },
            { "Hans", "simplifikadu" },
            { "type.nu.latn", "Nunbru osidental" },
            { "Hant", "tradisional" },
            { "ff", "fula" },
            { "FI", "Finl\u00e1ndia" },
            { "fi", "finlandes" },
            { "FJ", "Fidji" },
            { "fj", "fijianu" },
            { "FK", "Ilhas Malvinas" },
            { "FM", "Mikron\u00e9zia" },
            { "yue", "kantunes" },
            { "FO", "Ilhas Faroe" },
            { "fo", "faroes" },
            { "Taml", metaValue_ta },
            { "FR", "Fransa" },
            { "fr", "franses" },
            { "fy", "fr\u00edziu osidental" },
            { "GA", "Gabon" },
            { "ga", "irlandes" },
            { "GB", "Reinu Unidu" },
            { "GD", "Granada" },
            { "GE", "Ji\u00f3rjia" },
            { "GF", "Giana Franseza" },
            { "GG", "Gernzi" },
            { "GH", "Gana" },
            { "GI", "Jibraltar" },
            { "GL", "Gronel\u00e1ndia" },
            { "gl", "galegu" },
            { "GM", "G\u00e1mbia" },
            { "GN", "Gine" },
            { "gn", "guarani" },
            { "GP", "Guadalupi" },
            { "GQ", "Gine Ekuatorial" },
            { "und", "l\u00edngua diskonxedu" },
            { "GR", "Gr\u00e9sia" },
            { "GS", "Ilhas Je\u00f3rjia di Sul i Sanduixi di Sul" },
            { "GT", "Guatimala" },
            { "gu", metaValue_gu },
            { "GU", "Guam" },
            { "gv", "manks" },
            { "GW", "Gine-Bisau" },
            { "GY", "Giana" },
            { "ha", "auza" },
            { "ckb", "kurdu sentral" },
            { "zxx", "sen kontiudu lingu\u00edstiku" },
            { "he", metaValue_he },
            { "hi", "indi" },
            { "de_AT", "alemon austr\u00edaku" },
            { "HK", "Hong Kong, Rejion Administrativu Spesial di Xina" },
            { "HM", "Ilhas Heard i McDonald" },
            { "HN", "Onduras" },
            { "HR", "Kro\u00e1sia" },
            { "hr", "kroata" },
            { "agq", "aghem" },
            { "gsw", "alemon su\u00edsu" },
            { "HT", "Ait\u00ed" },
            { "ht", "aitianu" },
            { "HU", "Ungria" },
            { "hu", "\u00fangaru" },
            { "hy", metaValue_hy },
            { "ia", "interlingua" },
            { "IC", "Kan\u00e1rias" },
            { "ID", "Indon\u00e9zia" },
            { "id", "indon\u00e9ziu" },
            { "IE", "Irlanda" },
            { "ig", "ibo" },
            { "ii", "nuosu" },
            { "IL", "Israel" },
            { "IM", "Ilha di Man" },
            { "IN", "\u00cdndia" },
            { "IO", "Ilhas Brit\u00e1nikas di \u00cdndiku" },
            { "IQ", "Iraki" },
            { "IR", "Ir\u00e3u" },
            { "IS", "Isl\u00e1ndia" },
            { "is", "islandes" },
            { "IT", "It\u00e1lia" },
            { "it", "italianu" },
            { "iu", "inuktitut" },
            { "Zmth", "notason matim\u00e1tiku" },
            { "ja", metaValue_ja },
            { "Mlym", metaValue_ml },
            { "JE", "Jersi" },
            { "type.ca.islamic", "Kalend\u00e1riu isl\u00e1miku" },
            { "Beng", metaValue_bn },
            { "JM", "Jamaika" },
            { "JO", "Jord\u00e1nia" },
            { "JP", "Japon" },
            { "jv", "javanes" },
            { "guz", "gusii" },
            { "de_CH", "alemon altu suisu" },
            { "smn", "inari sami" },
            { "ka", metaValue_ka },
            { "type.ca.buddhist", "Kalend\u00e1riu budista" },
            { "KE", "K\u00e9nia" },
            { "419", "Merka Latinu" },
            { "KG", "Kirgistan" },
            { "KH", "Kambodja" },
            { "KI", "Kiribati" },
            { "ki", "kikuiu" },
            { "kk", "kazak" },
            { "kl", "groenlandes" },
            { "km", metaValue_km },
            { "KM", "Kamoris" },
            { "Knda", metaValue_kn },
            { "kn", metaValue_kn },
            { "KN", "San Kristovan i Nevis" },
            { "fr_CA", "franses kanadianu" },
            { "ko", metaValue_ko },
            { "KP", "Koreia di Norti" },
            { "KR", "Koreia di Sul" },
            { "ks", "kaxmira" },
            { "ku", "kurdu" },
            { "fr_CH", "franses suisu" },
            { "KW", "Kueiti" },
            { "kw", "k\u00f3rniku" },
            { "KY", "Ilhas Kaimon" },
            { "ky", "kirgiz" },
            { "KZ", "Kazakistan" },
            { "Cyrl", "sir\u00edliku" },
            { "LA", "Laus" },
            { "la", "latin" },
            { "LB", "L\u00edbanu" },
            { "lb", "luxemburges" },
            { "LC", "Santa L\u00fasia" },
            { "lg", "luganda" },
            { "nds", "alemon baxu" },
            { "LI", "Lixenstain" },
            { "LK", "Sri Lanka" },
            { "Tibt", metaValue_bo },
            { "ln", "lingala" },
            { "fur", "friulanu" },
            { "lo", metaValue_lo },
            { "type.ms.uksystem", "Sistema di midida brit\u00e1niku" },
            { "LR", "Lib\u00e9ria" },
            { "LS", "Lezotu" },
            { "LT", "Litu\u00e1nia" },
            { "lt", "lituanu" },
            { "LU", "Luxemburgu" },
            { "lu", "luba-katanga" },
            { "LV", "Let\u00f3nia" },
            { "lv", "let\u00e3u" },
            { "Kana", "katakana" },
            { "LY", "L\u00edbia" },
            { "lag", "langi" },
            { "Thaa", "taana" },
            { "MA", "Marokus" },
            { "MC", "M\u00f3naku" },
            { "MD", "Mold\u00e1via" },
            { "ME", "Montenegru" },
            { "MF", "San Martinhu (Fransa)" },
            { "MG", "Madagaskar" },
            { "mg", "malgaxi" },
            { "Thai", metaValue_th },
            { "MH", "Ilhas Marxal" },
            { "type.co.ducet", "\u00d3rdi padron di Unicode" },
            { "mi", "maori" },
            { "MK", "Masid\u00f3nia di Norti" },
            { "mk", "mased\u00f3niu" },
            { "ml", metaValue_ml },
            { "ML", "Mali" },
            { "MM", "Mianmar (Birm\u00e1nia)" },
            { "MN", "Mong\u00f3lia" },
            { "MO", "Makau, Rejion Administrativu Spesial di Xina" },
            { "MP", "Ilhas Marianas di Norti" },
            { "MQ", "Martinika" },
            { "MR", "Maurit\u00e1nia" },
            { "mr", "marati" },
            { "MS", "Monserat" },
            { "ms", "mal\u00e1iu" },
            { "MT", "Malta" },
            { "mt", "maltes" },
            { "MU", "Maur\u00edsia" },
            { "MV", "Maldivas" },
            { "MW", "Malaui" },
            { "MX", "M\u00e9xiku" },
            { "type.ca.japanese", "Kalend\u00e1riu japones" },
            { "my", metaValue_my },
            { "MY", "Mal\u00e1zia" },
            { "Armn", metaValue_hy },
            { "MZ", "Musambiki" },
            { "dsb", "s\u00f3rbiu baxu" },
            { "NA", "Nam\u00edbia" },
            { "type.co.search", "Piskiza di uzu jeral" },
            { "202", "\u00c1frika Subisariana" },
            { "nb", "norueges bokm\u00e5l" },
            { "type.ca.hebrew", "Kalend\u00e1riu ebraiku" },
            { "NC", "Nova Kalid\u00f3nia" },
            { "NE", "Nijer" },
            { "ne", "nepales" },
            { "NF", "Ilhas Norfolk" },
            { "NG", "Nij\u00e9ria" },
            { "NI", "Nikar\u00e1gua" },
            { "NL", "Olanda" },
            { "nl", "olandes" },
            { "nn", "norueges nynorsk" },
            { "NO", "Noruega" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "rof", "rombu" },
            { "NZ", "Nova Zil\u00e1ndia" },
            { "kab", "kabila" },
            { "kam", "kamba" },
            { "OM", "Oman" },
            { "om", "oromo" },
            { "or", "od\u00eda" },
            { "os", "os\u00e9tiku" },
            { "PA", "Panam\u00e1" },
            { "pa", "pandjabi" },
            { "dua", "duala" },
            { "en_GB", "ingles brit\u00e1niku" },
            { "PE", "Peru" },
            { "PF", "Polin\u00e9zia Franseza" },
            { "PG", "Papua-Nova Gine" },
            { "PH", "Filipinas" },
            { "PK", "Pakistan" },
            { "PL", "Pul\u00f3nia" },
            { "pl", "pulaku" },
            { "ewo", "ewondo" },
            { "PM", "San Piere i Mikelon" },
            { "PN", "Ilhas Pitkairn" },
            { "type.ca.dangi", "Kalend\u00e1riu dangi" },
            { "PR", "Portu Riku" },
            { "PS", "Tirit\u00f3riu palistinianu" },
            { "ps", "paxto" },
            { "PT", "Purtugal" },
            { "pt", "purtuges" },
            { "key.co", "Ordenason" },
            { "PW", "Palau" },
            { "PY", "Paraguai" },
            { "pt_BR", "purtuges brazileru" },
            { "Hebr", metaValue_he },
            { "mgh", "makua" },
            { "key.cf", "Formatu di mueda" },
            { "QA", "Katar" },
            { "key.ca", "Kalend\u00e1riu" },
            { "Laoo", metaValue_lo },
            { "type.hc.h23", "Sistema di 24 ora (0\u201323)" },
            { "type.hc.h24", "Sistema di 24 ora (1\u201324)" },
            { "QO", "Ilhas di Oseania" },
            { "qu", "kexua" },
            { "brx", "bodo" },
            { "kde", "makonde" },
            { "001", "Mundu" },
            { "Ethi", "eti\u00f3piku" },
            { "002", "\u00c1frika" },
            { "003", "Merka di Norti" },
            { "RE", "Runion" },
            { "type.hc.h12", "Sistema di 12 ora (1\u201312)" },
            { "005", "Merka di Sul" },
            { "type.hc.h11", "Sistema di 12 ora (0\u201311)" },
            { "009", "Oseania" },
            { "rm", "romanxi" },
            { "rn", "rundi" },
            { "key.cu", "Mueda" },
            { "RO", "Rum\u00e9nia" },
            { "ro", "rumenu" },
            { "RS", "S\u00e9rvia" },
            { "RU", "R\u00fasia" },
            { "ru", "rusu" },
            { "RW", "Ruanda" },
            { "rw", "kiniaruanda" },
            { "kea", "kabuverdianu" },
            { "en_AU", "ingles australianu" },
            { "SA", "Ar\u00e1bia Saudita" },
            { "sa", "s\u00e1nskritu" },
            { "SB", "Ilhas Salum\u00e3u" },
            { "011", "\u00c1frika Osidental" },
            { "SC", "Seixelis" },
            { "SD", "Sudon" },
            { "sd", "sindi" },
            { "013", "Merka Sentral" },
            { "SE", "Su\u00e9sia" },
            { "014", "\u00c1frika Oriental" },
            { "015", "Norti di \u00c1frika" },
            { "SG", "Singapura" },
            { "SH", "Santa Ilena" },
            { "type.lb.strict", "Stilu r\u00edjidu di kebra di linha" },
            { "si", metaValue_si },
            { "017", "\u00c1frika Sentral" },
            { "SI", "Slov\u00e9nia" },
            { "018", "Sul di \u00c1frika" },
            { "SJ", "Svalbard i Jan Maien" },
            { "019", "Merkas" },
            { "SK", "Slov\u00e1kia" },
            { "sk", "slovaku" },
            { "SL", "Sera Lioa" },
            { "sl", "slov\u00e9niu" },
            { "SM", "San Marinu" },
            { "SN", "Senegal" },
            { "SO", "Sum\u00e1lia" },
            { "so", "somali" },
            { "arn", "araukanu" },
            { "sq", "albanes" },
            { "SR", "Surinami" },
            { "sr", "s\u00e9rviu" },
            { "SS", "Sudon di Sul" },
            { "type.cf.account", "Formatu di mueda kontabil\u00edstiku" },
            { "ST", "San Tume i Pr\u00ednsipi" },
            { "su", "sundanes" },
            { "SV", "El Salvador" },
            { "sv", "sueku" },
            { "sw", "sua\u00edli" },
            { "SX", "San Martinhu (Olanda)" },
            { "SY", "S\u00edria" },
            { "SZ", "Eswatini" },
            { "ta", metaValue_ta },
            { "TA", "Tristan da Kunha" },
            { "asa", "asu" },
            { "type.ms.ussystem", "Sistema di midida merkanu" },
            { "021", "Norti di Merka" },
            { "142", "\u00c1zia" },
            { "TC", "Ilhas Turkas i Kaikus" },
            { "143", "\u00c1zia Sentral" },
            { "TD", "Txadi" },
            { "te", metaValue_te },
            { "145", "\u00c1zia Osidental" },
            { "TF", "Terras Franses di Sul" },
            { "TG", "Togu" },
            { "tg", "tadjiki" },
            { "th", metaValue_th },
            { "TH", "Tail\u00e1ndia" },
            { "ti", "tigrinia" },
            { "TJ", "Tadjikistan" },
            { "en_CA", "ingles kanadianu" },
            { "029", "Karaibas" },
            { "TK", "Tokelau" },
            { "tk", "turkmenu" },
            { "TL", "Timor Lesti" },
            { "TM", "Turkumenistan" },
            { "TN", "Tun\u00edzia" },
            { "TO", "Tonga" },
            { "to", "tonganes" },
            { "dyo", "jola-fonyi" },
            { "TR", "Turkia" },
            { "tr", "turku" },
            { "TT", "Trinidad i Tobagu" },
            { "tt", "tatar" },
            { "TV", "Tuvalu" },
            { "TW", "Taiuan" },
            { "ast", "asturianu" },
            { "TZ", "Tanz\u00e1nia" },
            { "nmg", "kuazio" },
            { "Zzzz", "skrita diskonxedu" },
            { "150", "Europa" },
            { "UA", "Ukr\u00e1nia" },
            { "030", "\u00c1zia Oriental" },
            { "151", "Europa Oriental" },
            { "154", "Europa di Norti" },
            { "sw_CD", "sua\u00edli kongoles" },
            { "034", "Sul di \u00c1zia" },
            { "155", "Europa Osidental" },
            { "035", "Sudesti Azi\u00e1tiku" },
            { "UG", "Uganda" },
            { "ug", "uigur" },
            { "Kore", metaValue_ko },
            { "Zyyy", "komun" },
            { "039", "Europa di Sul" },
            { "uk", "ukranianu" },
            { "Sinh", metaValue_si },
            { "UM", "Ilhas Minoris Distantis de Stadus Unidus" },
            { "UN", "Nasons Unidas" },
            { "ur", "urdu" },
            { "US", "Stadus Unidos di Merka" },
            { "haw", "avaianu" },
            { "UY", "Uruguai" },
            { "prg", "prusianu" },
            { "UZ", "Uzbekistan" },
            { "uz", "uzbeki" },
            { "tzm", "tamazait di Atlas Sentral" },
            { "VA", "Vatikanu" },
            { "VC", "San Bisenti i Granadinas" },
            { "VE", "Vinizuela" },
            { "type.ca.roc", "Kalend\u00e1riu di Rep\u00fablika di Xina" },
            { "VG", "Ilhas Virjens Brit\u00e1nikas" },
            { "VI", "Ilhas Virjens Merkanas" },
            { "vi", "vietnamita" },
            { "khq", "koira txiini" },
            { "key.hc", "Siklu or\u00e1riu (12 o 24)" },
            { "VN", "Vietnam" },
            { "quc", "kitxe" },
            { "VU", "Vanuatu" },
            { "rwk", "rwa" },
            { "gag", "gagauz" },
            { "053", "Austral\u00e1zia" },
            { "054", "Melan\u00e9zia" },
            { "WF", "Ualis i Futuna" },
            { "Grek", metaValue_el },
            { "057", "Rejion di Mikron\u00e9zia" },
            { "jgo", "\u00f1omba" },
            { "lkt", "lakota" },
            { "wo", "uolof" },
            { "zgh", "tamazait marokinu padron" },
            { "ar_001", "\u00e1rabi mudernu" },
            { "WS", "Samoa" },
            { "Mong", "mongol" },
            { "XA", "Pseudo-sotakis" },
            { "XB", "Pseudo-bidiresional" },
            { "061", "Polin\u00e9zia" },
            { "Latn", "latinu" },
            { "xh", "koza" },
            { "XK", "Kozovu" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "n\u00e3u skritu" },
            { "kkj", "kako" },
            { "YE", "I\u00e9men" },
            { "type.co.standard", "\u00d3rdi padron" },
            { "yo", "ioruba" },
            { "es_MX", "spanhol mexikanu" },
            { "YT", "Maiote" },
            { "ZA", "\u00c1frika di Sul" },
            { "type.lb.loose", "Stilu fleks\u00edvel di kebra di linha" },
            { "kln", "kalenjin" },
            { "Deva", "devanagari" },
            { "zh", "xines" },
            { "Hira", "iragana" },
            { "ZM", "Z\u00e1mbia" },
            { "Bopo", "bopomofo" },
            { "key.lb", "Stilu di kebra di linha" },
            { "zu", "zulu" },
            { "ZW", "Zimb\u00e1bui" },
            { "Geor", metaValue_ka },
            { "ZZ", "Rejion Diskonxedu" },
            { "type.ms.metric", "Sistema m\u00e9triku" },
            { "type.ca.iso8601", "Kalend\u00e1riu ISO-8601" },
            { "ebu", "embu" },
            { "jmc", "matxame" },
            { "zh_Hans", "xines simplifikadu" },
            { "koi", "komi-permiak" },
            { "kok", "konkani" },
            { "dav", "taita" },
            { "zh_Hant", "xines tradisional" },
            { "Khmr", metaValue_km },
            { "key.ms", "Sistema di midida" },
            { "key.nu", "Nunbru" },
            { "Guru", "gurmuki" },
            { "Telu", metaValue_te },
            { "ksf", "bafia" },
        };
        return data;
    }
}
