/*
 * Copyright (c) 2012, 2023, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ps extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_NR = "\u0646\u0627\u06cc\u0631\u0648";
        final String metaValue_TR = "\u062a\u0631\u06a9\u064a";
        final String metaValue_ar = "\u0639\u0631\u0628\u064a";
        final String metaValue_bo = "\u062a\u0628\u062a\u064a";
        final String metaValue_el = "\u06cc\u0648\u0646\u0627\u0646\u064a";
        final String metaValue_gu = "\u06ab\u062c\u0631\u0627\u062a\u064a";
        final String metaValue_he = "\u0639\u0628\u0631\u0627\u0646\u064a";
        final String metaValue_ja = "\u062c\u0627\u067e\u0627\u0646\u064a";
        final String metaValue_km = "\u062e\u0645\u0631";
        final String metaValue_kn = "\u06a9\u0646\u0627\u0689\u0627";
        final String metaValue_ko = "\u06a9\u0648\u0631\u06cc\u0627\u06cc\u06cc";
        final String metaValue_ta = "\u062a\u0627\u0645\u0644";
        final Object[][] data = new Object[][] {
            { "ksh", "\u06a9\u0648\u0644\u0648\u06ab\u0646\u064a\u0627\u064a\u064a" },
            { "mwl", "\u0645\u0631\u0627\u0646\u062f\u064a\u0632" },
            { "Zsym", "\u0633\u0645\u0628\u0648\u0644\u0648\u0646\u0647" },
            { "Zsye", "\u0627\u06cc\u0645\u0648\u062c\u064a" },
            { "ccp", "\u0686\u06a9\u0645\u0627" },
            { "tem", "\u062a\u06cc\u0645\u0646\u064a" },
            { "teo", "\u062a\u06cc\u0633\u0648" },
            { "rap", "\u0631\u067e\u0627\u0646\u0648\u0626\u064a" },
            { "AC", "\u0627\u0633\u064a\u0646\u0634\u0627\u0646 \u067c\u0627\u067e\u0648" },
            { "rar", "\u0631\u0627\u0631\u0648\u067c\u0627\u0646\u06ab\u0627\u0646" },
            { "tet", "\u062a\u062a\u0648\u0645" },
            { "AD", "\u0627\u0646\u062f\u0648\u0631\u0627" },
            { "AE", "\u0645\u062a\u062d\u062f\u0647 \u0639\u0631\u0628 \u0627\u0645\u0627\u0631\u0627\u062a" },
            { "nl_BE", "\u0641\u0644\u06d0\u0645\u06d0\u0634\u064a" },
            { "AF", "\u0627\u0641\u063a\u0627\u0646\u0633\u062a\u0627\u0646" },
            { "AG", "\u0627\u0646\u067c\u064a\u06ab\u0648\u0627 \u0627\u0648 \u0628\u0627\u0631\u0628\u0648\u062f\u0627" },
            { "type.ca.ethiopic", "\u0627\u06cc\u062a\u0648\u067e\u064a\u06a9 \u062c\u0646\u062a\u0631\u064a" },
            { "AI", "\u0627\u0646\u06ab\u06cc\u0644\u0627" },
            { "AL", "\u0627\u0644\u0628\u0627\u0646\u06cc\u0647" },
            { "AM", "\u0627\u0631\u0645\u0646\u0633\u062a\u0627\u0646" },
            { "AO", "\u0627\u0646\u06ab\u0648\u0644\u0627" },
            { "AQ", "\u0627\u0646\u062a\u0627\u0631\u06a9\u062a\u06cc\u06a9\u0627" },
            { "AR", "\u0627\u0631\u062c\u0646\u067c\u0627\u064a\u0646" },
            { "AS", "\u0627\u0645\u0631\u06cc\u06a9\u0627\u06cc\u06cc \u0633\u0645\u0648" },
            { "AT", "\u0627\u062a\u0631\u06cc\u0634" },
            { "AU", "\u0622\u0633\u067c\u0631\u0627\u0644\u06cc\u0627" },
            { "AW", "\u0622\u0631\u0648\u0628\u0627" },
            { "AX", "\u0627\u0644\u0627\u0646\u062f \u067c\u0627\u067e\u0648\u0627\u0646" },
            { "AZ", "\u0627\u0630\u0631\u0628\u0627\u064a\u062c\u0627\u0646" },
            { "BA", "\u0628\u0648\u0633\u0646\u064a\u0627 \u0627\u0648 \u0647\u06d0\u0631\u0632\u06ab\u0648\u064a\u0646\u0627" },
            { "BB", "\u0628\u0627\u0631\u0628\u0627\u062f\u0648\u0633" },
            { "ceb", "\u0633\u06cc\u0628\u0648\u0627\u0646\u0648\u064a" },
            { "BD", "\u0628\u0646\u06af\u0644\u0647 \u062f\u06d0\u0634" },
            { "kum", "\u06a9\u0648\u0645\u06a9" },
            { "BE", "\u0628\u06cc\u0644\u062c\u06cc\u0645" },
            { "BF", "\u0628\u0648\u0631\u06a9\u06cc\u0646\u0627 \u0641\u0627\u0633\u0648" },
            { "BG", "\u0628\u0644\u063a\u0627\u0631\u06cc\u0647" },
            { "BH", "\u0628\u062d\u0631\u064a\u0646" },
            { "BI", "\u0628\u0631\u0648\u0646\u062f\u064a" },
            { "BJ", "\u0628\u06cc\u0646\u0646" },
            { "BL", "\u0633\u064a\u0646\u067c \u0628\u0627\u0631\u062a\u064a\u0644\u0645\u064a" },
            { "BM", "\u0628\u0631\u0645\u0648\u062f\u0627" },
            { "myv", "\u0627\u0631\u0632\u064a\u0627" },
            { "BN", "\u0628\u0631\u0648\u0646\u0627\u0626\u064a" },
            { "BO", "\u0628\u0648\u0644\u06cc\u0648\u06cc\u0627" },
            { "BQ", "\u06a9\u06cc\u0631\u06cc\u0628\u06cc\u0646 \u0647\u0627\u0644\u06cc\u0646\u0689" },
            { "BR", "\u0628\u0631\u0627\u0632\u06cc\u0644" },
            { "BS", "\u0628\u0627\u0647\u0645\u0627\u0633" },
            { "xog", "\u0633\u0648\u06ab\u0627" },
            { "BT", "\u0628\u0647\u0648\u067c\u0627\u0646" },
            { "BV", "\u0628\u0648\u0648\u06cc\u067c \u067c\u0627\u067e\u0648" },
            { "BW", "\u0628\u0648\u062a\u0633\u0648\u0627\u0646\u0647" },
            { "BY", "\u0628\u06cc\u0644\u0627\u0631\u0648\u0633" },
            { "BZ", "\u0628\u0644\u06cc\u0632" },
            { "type.ca.persian", "\u0641\u0627\u0631\u0633\u064a \u062c\u0646\u062a\u0631\u064a" },
            { "type.nu.hebr", "\u0639\u0628\u0631\u0627\u0646\u064a \u0627\u0639\u062f\u0627\u062f" },
            { "CA", "\u06a9\u0627\u0646\u0627\u0689\u0627" },
            { "CC", "\u06a9\u0648\u06a9\u0648\u0632 (\u06a9\u064a\u0644\u0646\u06ab) \u067c\u0627\u067e\u0648\u06ab\u0627\u0646" },
            { "mzn", "\u0645\u0632\u0627\u0646\u062f\u0631\u0627\u0646\u064a" },
            { "CD", "\u06a9\u0627\u0646\u06ab\u0648 - \u06a9\u06cc\u0646\u0634\u0627\u0633\u0627" },
            { "CF", "\u0648\u0633\u0637\u064a \u0627\u0641\u0631\u064a\u0642\u0627 \u062c\u0645\u0647\u0648\u0631" },
            { "CG", "\u06a9\u0627\u0646\u06ab\u0648 - \u0628\u0631\u0648\u0632\u0648\u06cc\u06cc\u0644" },
            { "CH", "\u0633\u0648\u06cc\u0633" },
            { "CI", "\u062f \u0639\u0627\u062c \u0633\u0627\u062d\u0644" },
            { "CK", "\u06a9\u0648\u06a9 \u067c\u0627\u067e\u0648\u06ab\u0627\u0646" },
            { "CL", "\u0686\u06cc\u0644\u064a" },
            { "CM", "\u06a9\u0627\u0645\u0631\u0648\u0646" },
            { "CN", "\u0686\u06cc\u0646" },
            { "CO", "\u06a9\u0648\u0644\u0645\u0628\u06cc\u0627" },
            { "CP", "\u062f \u06a9\u0644\u067e\u0631\u067c\u0648\u0646 \u067c\u0627\u067e\u0648" },
            { "CR", "\u06a9\u0648\u0633\u062a\u0627\u0631\u06cc\u06a9\u0627" },
            { "CU", "\u06a9\u06cc\u0648\u0628\u0627" },
            { "CV", "\u06a9\u06cc\u067e \u0648\u0631\u062f" },
            { "CW", "\u06a9\u0648\u0631\u0627\u06a9\u0627\u0648" },
            { "CX", "\u062f \u06a9\u0631\u064a\u0633\u0645\u0633 \u067c\u0627\u067e\u0648" },
            { "CY", "\u0642\u0628\u0631\u0633" },
            { "CZ", "\u0686\u06a9\u06cc\u0627" },
            { "eka", "\u0627\u06a9\u062c\u06a9" },
            { "DE", "\u0627\u0644\u0645\u0627\u0646" },
            { "ace", "\u0627\u0686\u064a\u0646\u064a" },
            { "cgg", "\u0686\u064a\u06af\u0627\u064a\u064a" },
            { "DG", "\u0689\u0627\u06cc\u06ab\u0648 \u06ab\u0627\u0631\u0633\u06cc\u0627" },
            { "type.nu.deva", "\u062f\u064a\u0648\u0627\u0646\u06ab\u0631\u064a \u0627\u0639\u062f\u0627\u062f" },
            { "DJ", "\u062c\u0628\u0648\u062a\u064a" },
            { "DK", "\u0689\u0646\u0645\u0627\u0631\u06a9" },
            { "Brai", "\u0628\u0631\u06cc\u0644\u064a" },
            { "DM", "\u062f\u0648\u0645\u06cc\u0646\u06cc\u06a9\u0627" },
            { "type.nu.armnlow", "\u0622\u0631\u0645\u064a\u0646\u064a\u0627\u064a\u064a \u06a9\u0648\u0686\u0646\u064a \u0627\u0639\u062f\u0627\u062f" },
            { "DO", "\u062c\u0645\u0647\u0648\u0631\u064a\u0647 \u0689\u0648\u0645\u064a\u0646\u064a\u06a9\u0646" },
            { "gor", "\u06ab\u0648\u0631\u0646 \u067c\u0627\u0644\u0648" },
            { "zun", "\u0632\u0648\u0646\u064a" },
            { "tig", "\u062a\u06cc\u06ab\u0631" },
            { "DZ", "\u0627\u0644\u062c\u0632\u0627\u06cc\u0631" },
            { "pag", "\u067e\u0627\u0646\u06ab\u0627\u0633\u06cc\u0646" },
            { "EA", "\u0633\u064a\u0648\u062a\u0627 \u0627\u0648 \u0645\u0627\u0644\u064a\u0644\u0627" },
            { "pam", "\u067e\u0645\u067e\u0627\u0646\u06af\u0627" },
            { "EC", "\u0627\u06a9\u0648\u0627\u062f\u0648\u0631" },
            { "pap", "\u067e\u0627\u067e\u064a\u0627\u0645\u064a\u0646\u062a\u0648" },
            { "ada", "\u0627\u062f\u0627\u0646\u06af\u0645\u064a" },
            { "EE", "\u0627\u0633\u062a\u0648\u0646\u06cc\u0627" },
            { "EG", "\u0645\u0635\u0631" },
            { "EH", "\u0644\u0648\u064a\u062f\u064a\u0681 \u0635\u062d\u0627\u0631\u0627" },
            { "pau", "\u067e\u0627\u0644\u0627\u0646" },
            { "chk", "\u0686\u0648\u0627\u0648\u06a9\u064a" },
            { "chm", "\u0645\u0627\u0631\u064a" },
            { "cho", "\u0686\u0648\u06a9\u067c\u0627\u0648\u064a" },
            { "chr", "\u0686\u06d0\u0631\u0648\u06a9\u064a" },
            { "ER", "\u0627\u0631\u06cc\u062a\u0631\u0647" },
            { "ES", "\u0647\u0633\u067e\u0627\u0646\u06cc\u0647" },
            { "ET", "\u062d\u0628\u0634\u0647" },
            { "EU", "\u0627\u0631\u0648\u067e\u0627\u064a\u064a \u0627\u062a\u062d\u0627\u062f\u064a\u0647" },
            { "type.ca.gregorian", "\u06ab\u0631\u064a\u06ab\u0648\u0631\u064a\u0646 \u062c\u0646\u062a\u0631\u064a" },
            { "EZ", "\u0627\u0631\u0648\u067e\u0627\u064a\u064a \u0633\u064a\u0645\u0647" },
            { "chy", "\u0634\u064a\u0646\u064a" },
            { "type.nu.gujr", "\u06ab\u0648\u062c\u0631\u0627\u062a\u064a \u0627\u0639\u062f\u0627\u062f" },
            { "ady", "\u0627\u062f\u064a\u063a\u064a" },
            { "FI", "\u0641\u0646\u0644\u06cc\u0646\u0689" },
            { "FJ", "\u0641\u062c\u064a" },
            { "FK", "\u0641\u0627\u06a9\u0644\u064a\u0646\u0689 \u067c\u0627\u067e\u0648\u06ab\u0627\u0646" },
            { "FM", "\u0645\u06cc\u06a9\u0631\u0648\u0646\u06cc\u0632\u06cc\u0627" },
            { "FO", "\u0641\u0627\u0631\u0648 \u067c\u0627\u067e\u0648" },
            { "Taml", metaValue_ta },
            { "FR", "\u0641\u0631\u0627\u0646\u0633\u0647" },
            { "root", "\u0631\u0648\u067c" },
            { "GA", "\u06ab\u0627\u0628\u0646" },
            { "GB", "\u0628\u0631\u062a\u0627\u0646\u06cc\u0647" },
            { "pcm", "\u0646\u0627\u0626\u062c\u06cc\u0631\u06cc\u0627 \u067e\u06cc\u062f\u062c\u0646" },
            { "GD", "\u06ab\u0631\u0646\u0627\u062f\u0627" },
            { "GE", "\u06af\u0648\u0631\u062c\u0633\u062a\u0627\u0646" },
            { "GF", "\u0641\u0631\u0627\u0646\u0633\u0648\u064a \u06ab\u0627\u0646\u0627" },
            { "GG", "\u06ab\u0631\u0646\u0633\u064a" },
            { "GH", "\u06ab\u0627\u0646\u0627" },
            { "GI", "\u062c\u0628\u0644 \u0627\u0644\u0637\u0627\u0631\u0642" },
            { "GL", "\u06ab\u0631\u06cc\u0646\u0644\u06cc\u0646\u0689" },
            { "GM", "\u06ab\u0627\u0645\u0628\u06cc\u0627" },
            { "GN", "\u06ab\u06cc\u0646\u0647" },
            { "GP", "\u06ab\u0627\u0644\u0689\u06cc\u067e" },
            { "GQ", "\u0627\u0633\u062a\u0648\u0627\u06cc\u06cc \u06ab\u06cc\u0646\u0647" },
            { "GR", "\u06cc\u0648\u0646\u0627\u0646" },
            { "GS", "\u0633\u0648\u064a\u0644\u064a \u062c\u0627\u0631\u062c\u064a\u0627 \u0627\u0648 \u0633\u0648\u064a\u0644\u064a \u0633\u06d0\u0646\u0689\u0648\u0686 \u067c\u0627\u067e\u0648\u06ab\u0627\u0646" },
            { "GT", "\u06ab\u0648\u0627\u062a\u06cc\u0645\u0627\u0644\u0627" },
            { "GU", "\u06ab\u0648\u0627\u0645" },
            { "GW", "\u06ab\u06cc\u0646\u0647 \u0628\u06cc\u0633\u0648" },
            { "tlh", "\u06a9\u0644\u064a\u0646\u06ab\u0627\u0646\u064a" },
            { "GY", "\u06ab\u06cc\u0627\u0646\u0627" },
            { "ckb", "\u0645\u0646\u0681\u0646\u06cd \u06a9\u0648\u0631\u062f\u064a" },
            { "zxx", "\u0646\u0647 \u0698\u0628\u0646\u064a \u0645\u0646\u0681\u067e\u0627\u0646\u06ab\u0647" },
            { "de_AT", "\u0627\u062a\u0631\u064a\u0634\u064a \u0622\u0644\u0645\u0627\u0646\u064a" },
            { "HK", "\u0647\u0627\u0646\u06ab \u06a9\u0627\u0646\u06ab SAR \u0686\u06cc\u0646" },
            { "HM", "\u0647\u0627\u0631\u0689 \u0627\u0648 \u0645\u064a\u06a9\u0689\u0627\u0646\u0644\u0689 \u067c\u0627\u067e\u0648\u06ab\u0627\u0646" },
            { "HN", "\u0647\u0627\u0646\u0689\u0648\u0631\u0627\u0633" },
            { "HR", "\u06a9\u0631\u0648\u0627\u0634\u064a\u0627" },
            { "agq", "\u0627\u063a\u06cc\u0645\u064a" },
            { "gsw", "\u0633\u0648\u06cc\u0633 \u062c\u0631\u0645\u0646" },
            { "HT", "\u0647\u0627\u06cc\u067c\u064a" },
            { "HU", "\u0645\u062c\u0627\u0631\u0633\u062a\u0627\u0646" },
            { "IC", "\u062f \u06a9\u0646\u0627\u0631\u064a \u067c\u0627\u067e\u0648\u06ab\u0627\u0646" },
            { "ID", "\u0627\u0646\u062f\u0648\u0646\u06cc\u0632\u06cc\u0627" },
            { "IE", "\u0622\u064a\u0631\u0644\u06d0\u0646\u0689" },
            { "nap", "\u0646\u064a\u067e\u0627\u0644\u064a\u0646" },
            { "naq", "\u0646\u0627\u0645\u0627" },
            { "zza", "\u0632\u0627\u0632\u0627" },
            { "IL", "\u0627\u0633\u0631\u0627\u064a\u064a\u0644" },
            { "IM", "\u062f \u0622\u0626\u0644 \u0622\u0641 \u0645\u06cc\u0646" },
            { "IN", "\u0647\u0646\u062f" },
            { "IO", "\u062f \u0628\u0631\u064a\u062a\u0627\u0646\u0648\u064a \u0647\u0646\u062f \u0633\u0645\u0646\u062f\u0631\u064a \u0633\u064a\u0645\u0647" },
            { "IQ", "\u0639\u0631\u0627\u0642" },
            { "IR", "\u0627\u064a\u0631\u0627\u0646" },
            { "IS", "\u0622\u06cc\u0633\u0644\u06cc\u0646\u0689" },
            { "IT", "\u0627\u06cc\u067c\u0627\u0644\u06cc\u0647" },
            { "Zmth", "\u062f \u0631\u06cc\u0627\u0636\u06cc\u0627\u062a\u0648 \u0646\u0648\u067c\u06cc\u0634\u0646" },
            { "type.nu.thai", "\u062a\u0627\u064a\u064a \u0627\u0639\u062f\u0627\u062f" },
            { "type.nu.beng", "\u062f \u0628\u0646\u06ab\u0644\u0627 \u0627\u0639\u062f\u0627\u062f" },
            { "JE", "\u062c\u0631\u0633\u06cc" },
            { "type.ca.islamic", "\u0627\u0633\u0644\u0627\u0645\u064a \u062c\u0646\u062a\u0631\u064a" },
            { "JM", "\u062c\u0645\u06cc\u06a9\u0627" },
            { "Beng", "\u0628\u0646\u06ab\u0644\u0647" },
            { "JO", "\u0627\u0631\u062f\u0646" },
            { "JP", "\u062c\u0627\u067e\u0627\u0646" },
            { "ain", "\u0627\u064a\u0646\u0648\u064a\u064a" },
            { "guz", "\u06ab\u0648\u0633\u064a" },
            { "type.nu.knda", "\u06a9\u0627\u0646\u0627\u0689\u0627 \u064a\u064a \u0627\u0639\u062f\u0627\u062f" },
            { "de_CH", "\u0633\u0648\u0626\u0633 \u0644\u0648\u06cc \u062c\u0631\u0645\u0646" },
            { "type.ca.buddhist", "\u0628\u0648\u062f\u0627\u064a\u064a \u062c\u0646\u062a\u0631\u064a" },
            { "KE", "\u06a9\u06cc\u0646\u06cc\u0627" },
            { "419", "\u0644\u0627\u062a\u06cc\u0646\u064a \u0627\u0645\u0631\u06cc\u06a9\u0627" },
            { "KG", "\u0642\u0631\u063a\u0632\u0633\u062a\u0627\u0646" },
            { "KH", "\u06a9\u0645\u0628\u0648\u062f\u06cc\u0627" },
            { "KI", "\u06a9\u06cc\u0631\u064a \u0628\u0627\u062a\u064a" },
            { "KM", "\u06a9\u0648\u0645\u0648\u0631\u0648\u0633" },
            { "Knda", metaValue_kn },
            { "KN", "\u0633\u06cc\u0646\u067c \u06a9\u067c\u0633 \u0627\u0648 \u0646\u06cc\u0648\u06cc\u0633" },
            { "fr_CA", "\u06a9\u0627\u0646\u0627\u0689\u0627\u064a\u064a \u0641\u0631\u0627\u0646\u0633\u0648\u064a" },
            { "KP", "\u0634\u0645\u0627\u0644\u06cc \u06a9\u0648\u0631\u06cc\u0627" },
            { "KR", "\u0633\u0648\u06cc\u0644\u064a \u06a9\u0648\u0631\u06cc\u0627" },
            { "fr_CH", "\u0633\u0648\u064a\u0633\u064a \u0641\u0631\u0627\u0646\u0633\u0648\u064a" },
            { "KW", "\u06a9\u0648\u064a\u062a" },
            { "tpi", "\u062a\u0648\u06a9 \u067e\u06cc\u0633\u06cc\u0646" },
            { "KY", "\u06a9\u06cc\u0645\u0627\u0646 \u067c\u0627\u067e\u0648\u06ab\u0627\u0646" },
            { "KZ", "\u0642\u0632\u0627\u0642\u0633\u062a\u0627\u0646" },
            { "Cyrl", "\u0633\u06cc\u0631\u06cc\u0644\u06cc\u06a9" },
            { "LA", "\u0644\u0627\u0648\u0633" },
            { "LB", "\u0644\u0628\u0646\u0627\u0646" },
            { "LC", "\u0633\u06cc\u0646\u067c \u0644\u0648\u0633\u06cc\u0627" },
            { "gwi", "\u06ab\u06cc\u0686\u06cc\u0646" },
            { "nds", "\u06a9\u069a\u062a\u0647 \u0622\u0644\u0645\u0627\u0646\u064a" },
            { "LI", "\u0644\u06cc\u062e\u062a\u0646 \u0627\u0634\u062a\u0627\u06cc\u0646" },
            { "LK", "\u0633\u0631\u064a\u0644\u0646\u06a9\u0627" },
            { "LR", "\u0644\u0627\u064a\u0628\u064a\u0631\u064a\u0627" },
            { "LS", "\u0644\u0633\u0648\u062a\u0648" },
            { "LT", "\u0644\u06cc\u062a\u0648\u0627\u0646\u06cc\u0627" },
            { "LU", "\u0644\u0648\u06ab\u0632\u0627\u0645\u0628\u0648\u0631\u06ab" },
            { "LV", "\u0644\u064a\u062a\u0647\u0648\u064a\u0627" },
            { "Kana", "\u06a9\u0627\u062a\u0627\u06a9\u0627\u0646\u0627" },
            { "LY", "\u0644\u06cc\u0628\u06cc\u0627" },
            { "lad", "\u0644\u0627\u0689\u06cc\u0646\u0648" },
            { "vun", "\u0648\u0648\u0646\u062c\u0648" },
            { "lag", "\u0644\u0646\u06ab\u06cc" },
            { "Thaa", "\u062a\u0647\u0627\u0646\u0627" },
            { "MA", "\u0645\u0631\u0627\u06a9\u0634" },
            { "MC", "\u0645\u0648\u0646\u0627\u06a9\u0648" },
            { "MD", "\u0645\u0648\u0644\u062f\u0648\u0627" },
            { "ME", "\u0645\u0648\u0646\u067c\u06cc\u0646\u06cc\u06ab\u0631\u0648" },
            { "MF", "\u0633\u06cc\u0646\u067c \u0645\u0627\u0631\u067c\u0646" },
            { "MG", "\u0645\u062f\u063a\u0627\u0633\u06a9\u0631" },
            { "MH", "\u0645\u0627\u0631\u0634\u0644 \u067c\u0627\u067e\u0648\u06ab\u0627\u0646" },
            { "ale", "\u0627\u0644\u064a\u0648\u062a\u064a" },
            { "Thai", "\u062a\u0627\u06cc\u0644\u0646\u0689\u064a" },
            { "MK", "\u0634\u0645\u0627\u0644\u064a \u0645\u0642\u062f\u0648\u0646\u064a\u0647" },
            { "ML", "\u0645\u0627\u0644\u064a" },
            { "MM", "\u0645\u064a\u0627\u0646\u0645\u0627\u0631 (\u0628\u0631\u0645\u0627)" },
            { "MN", "\u0645\u0646\u06ab\u0648\u0644\u064a\u0627" },
            { "new", "\u0646\u064a\u0648\u0627\u0631\u064a" },
            { "MO", "\u0645\u06a9\u0627\u0648 \u0633\u0627\u0631 \u0686\u06cc\u0646" },
            { "MP", "\u0634\u0645\u0627\u0644\u064a \u0645\u0627\u0631\u064a\u0627\u0646\u0627 \u067c\u0627\u067e\u0648\u06ab\u0627\u0646" },
            { "MQ", "\u0645\u0627\u0631\u067c\u06cc\u0646\u06cc\u06a9" },
            { "MR", "\u0645\u0648\u0631\u06cc\u062a\u0627\u0646\u06cc\u0627" },
            { "MS", "\u0645\u0627\u0646\u067c\u06cc\u0633\u06cc\u0631\u062a" },
            { "MT", "\u0645\u0627\u0644\u067c\u0627" },
            { "MU", "\u0645\u0648\u0631\u06cc\u0634\u06cc\u0633" },
            { "alt", "\u0633\u0648\u06cc\u0644 \u0627\u0644\u067c\u0627\u06cc" },
            { "MV", "\u0645\u0627\u0644\u062f\u064a\u067e" },
            { "MW", "\u0645\u0627\u0644\u0627\u0648\u064a" },
            { "MX", "\u0645\u06cc\u06a9\u0633\u06cc\u06a9\u0648" },
            { "type.ca.japanese", "\u062c\u0627\u067e\u0627\u0646\u064a \u062c\u0646\u062a\u0631\u064a" },
            { "MY", "\u0645\u0627\u0644\u06cc\u0632\u06cc\u0627" },
            { "MZ", "\u0645\u0648\u0632\u0645\u0628\u064a\u0642" },
            { "NA", "\u0646\u06cc\u0645\u0628\u06cc\u0627" },
            { "202", "\u0633\u0628 \u0633\u0647\u0627\u0631\u0646 \u0627\u0641\u0631\u064a\u0642\u0627" },
            { "type.ca.hebrew", "\u062c\u0648\u0631\u062c\u0648\u06cc\u0627\u0646 \u062c\u0646\u062a\u0631\u064a" },
            { "NC", "\u0646\u0648\u06cc \u06a9\u0627\u0644\u06cc\u0689\u0648\u0646\u06cc\u0627" },
            { "NE", "\u0646\u06cc\u062c\u0631" },
            { "NF", "\u0646\u0627\u0631\u0641\u0648\u0644\u06a9 \u067c\u0627\u067e\u0648\u06ab\u0627\u0646" },
            { "NG", "\u0646\u0627\u06cc\u062c\u06cc\u0631\u06cc\u0627" },
            { "trv", "\u062a\u0627\u0631\u0648\u06a9\u0648" },
            { "NI", "\u0646\u06a9\u0627\u0631\u0627\u06ab\u0648\u0627" },
            { "NL", "\u0647\u0627\u0644\u06d0\u0646\u0689" },
            { "NO", "\u0646\u0627\u0631\u0648\u06cd" },
            { "NP", "\u0646\u06cc\u067e\u0627\u0644" },
            { "NR", metaValue_NR },
            { "NU", "\u0646\u06cc\u0648\u0648" },
            { "rof", "\u0631\u0648\u0645\u0628\u0648" },
            { "NZ", "\u0646\u06cc\u0648\u0632\u06cc\u0644\u0646\u0689" },
            { "OM", "\u0639\u0645\u0627\u0646" },
            { "anp", "\u0627\u0646\u06af\u064a\u06a9\u064a" },
            { "crs", "\u0633\u0633\u064a\u0644\u0648\u0627 \u06aa\u0631\u0648\u0626\u0644 \u0641\u0631\u0627\u0646\u0633\u0648\u064a" },
            { "PA", "\u067e\u0627\u0646\u0627\u0645\u0627" },
            { "type.ca.islamic-civil", "\u0627\u0633\u0644\u0627\u0645\u064a \u062c\u0646\u062a\u0631\u064a (\u062c\u062f\u0648\u0644\u064a\u060c \u0645\u062f\u0646\u064a \u0639\u0635\u0631)" },
            { "en_GB", "\u0628\u0631\u064a\u062a\u0627\u0646\u0648\u06cc \u0627\u0646\u06ab\u0644\u06cc\u0633\u064a" },
            { "PE", "\u067e\u06cc\u0631\u0648" },
            { "PF", "\u0641\u0631\u0627\u0646\u0633\u0648\u064a \u067e\u0648\u0644\u064a\u0646\u064a\u0633\u064a\u0627" },
            { "PG", "\u067e\u0627\u067e\u0648\u0627 \u0646\u064a\u0648 \u06ab\u064a\u0646\u064a" },
            { "PH", "\u0641\u0644\u067e\u064a\u0646" },
            { "PK", "\u067e\u0627\u06a9\u0633\u062a\u0627\u0646" },
            { "PL", "\u067e\u0648\u0644\u0646\u0689" },
            { "ewo", "\u0627\u0648\u0648\u0646\u068a\u0648" },
            { "PM", "\u0633\u06cc\u0646\u067c \u067e\u06cc\u06cc\u0631 \u0627\u0648 \u0645\u06cc\u06a9\u0648\u0644\u0648\u0646" },
            { "PN", "\u067e\u064a\u067c\u06a9\u064a\u0631\u0646 \u067c\u0627\u067e\u0648\u06ab\u0627\u0646" },
            { "PR", "\u067e\u0648\u0631\u062a\u0648 \u0631\u06cc\u06a9\u0648" },
            { "PS", "\u0641\u0644\u0633\u0637\u064a\u0646 \u0633\u064a\u0645\u06d0" },
            { "PT", "\u067e\u0648\u0631\u062a\u06ab\u0627\u0644" },
            { "PW", "\u067e\u0644\u0627\u0624" },
            { "nia", "\u0646\u064a\u0627\u0633" },
            { "type.nu.greklow", "\u064a\u0648\u0646\u0627\u0646\u064a \u06a9\u0648\u0686\u0646\u064a \u0627\u0639\u062f\u0627\u062f" },
            { "PY", "\u067e\u0627\u0631\u0627\u06ab\u0648\u06cc" },
            { "tum", "\u062a\u0627\u0645\u0628\u0648\u06a9\u0627" },
            { "Hebr", metaValue_he },
            { "QA", "\u0642\u0637\u0631" },
            { "niu", "\u0646\u06cc\u0627\u0646" },
            { "QO", "\u0628\u0647\u0631\u0646\u06cd \u0627\u0648\u0633\u064a\u0627\u0646\u0647" },
            { "lez", "\u0644\u06cc\u06ab\u063a\u06cc\u0627\u0646" },
            { "tvl", "\u062a\u0648\u0648\u0627\u0644\u0648" },
            { "001", "\u0646\u0693\u06cd" },
            { "002", "\u0627\u0641\u0631\u064a\u0642\u0627" },
            { "003", "\u0634\u0645\u0627\u0644\u06cc \u0627\u0645\u0631\u06cc\u06a9\u0627" },
            { "RE", "\u0631\u06cc\u0648\u0646\u06cc\u0646" },
            { "005", "\u0633\u0648\u064a\u0644\u064a \u0627\u0645\u0631\u064a\u06a9\u0627" },
            { "jbo", "\u0644\u0648\u062c\u0628\u0627\u0646" },
            { "009", "\u0627\u0648\u0642\u064a\u0627\u0646\u0648\u0633\u064a\u0647" },
            { "RO", "\u0631\u0648\u0645\u0627\u0646\u06cc\u0627" },
            { "RS", "\u0633\u0631\u0628\u064a\u0627" },
            { "RU", "\u0631\u0648\u0633\u06cc\u0647" },
            { "RW", "\u0631\u0648\u0646\u062f\u0627" },
            { "SA", "\u0633\u0639\u0648\u062f\u064a \u0639\u0631\u0628\u0633\u062a\u0627\u0646" },
            { "SB", "\u0633\u0644\u064a\u0645\u0627\u0646 \u067c\u0627\u067e\u0648\u06ab\u0627\u0646" },
            { "twq", "\u062a\u0633\u0627\u0648\u0627\u0642" },
            { "011", "\u0644\u0648\u06cc\u062f\u06cc\u0681 \u0627\u0641\u0631\u06cc\u0642\u0627" },
            { "SC", "\u0633\u06cc\u0686\u06cc\u0644\u06cc\u0633" },
            { "SD", "\u0633\u0648\u0689\u0627\u0646" },
            { "013", "\u0645\u0646\u062e\u0646\u06cd \u0627\u0645\u0631\u064a\u06a9\u0627" },
            { "SE", "\u0633\u0648\u06cc\u0689\u0646" },
            { "014", "\u062e\u062a\u06cc\u0681 \u0627\u0641\u0631\u06cc\u0642\u0627" },
            { "015", "\u0634\u0645\u0627\u0644\u064a \u0627\u0641\u0631\u06cc\u0642\u0627" },
            { "SG", "\u0633\u064a\u0646\u06af\u0627\u067e\u0648\u0631" },
            { "SH", "\u0633\u06cc\u0646\u067c \u0647\u06cc\u0644\u06cc\u0646\u0627" },
            { "type.lb.strict", "\u062f \u0633\u062e\u062a\u06d0 \u0645\u0627\u062a\u06d0 \u06a9\u0631\u069a\u06d0 \u0689\u0648\u0644" },
            { "017", "\u0645\u0646\u0681\u0646\u06cd \u0627\u0641\u0631\u06cc\u0642\u0627" },
            { "SI", "\u0633\u0644\u0648\u0627\u0646\u06cc\u0627" },
            { "018", "\u0633\u0648\u064a\u0644\u064a \u0627\u0641\u0631\u064a\u0642\u0627" },
            { "SJ", "\u0633\u0648\u0627\u0644\u0628\u0627\u0631\u062f \u0627\u0648 \u062c\u0627\u0646 \u0645\u064a\u064a\u0646" },
            { "019", "\u0627\u0645\u0631\u064a\u06a9\u06d0" },
            { "SK", "\u0633\u0644\u0648\u0627\u06a9\u06cc\u0627" },
            { "SL", "\u0633\u06cc\u06cc\u0631\u0627 \u0644\u06cc\u0648\u0646" },
            { "SM", "\u0633\u0627\u0646 \u0645\u0627\u0631\u06cc\u0646\u0648" },
            { "SN", "\u0633\u064a\u0646\u064a\u06ab\u0627\u0644" },
            { "SO", "\u0633\u0648\u0645\u0627\u0644\u06cc\u0627" },
            { "arn", "\u0645\u0627\u067e\u0648\u0686\u0647" },
            { "arp", "\u0627\u0631\u0627\u067e\u0627\u0647\u0648\u064a" },
            { "type.nu.taml", "\u062f\u0648\u062f\u064a\u0632 \u062a\u0627\u0645\u0644 \u0627\u0639\u062f\u0627\u062f" },
            { "SR", "\u0633\u0648\u0631\u06cc\u0646\u0627\u0645" },
            { "SS", "\u0633\u0648\u064a\u0644\u064a \u0633\u0648\u0689\u0627\u0646" },
            { "ST", "\u0633\u0627\u0648 \u067c\u06cc\u0645 \u0627\u0648 \u067e\u0631\u0646\u0633\u06cc\u067e" },
            { "SV", "\u0633\u0627\u0644\u0648\u06d0\u0689\u0648\u0631" },
            { "SX", "\u0633\u06cc\u0646\u067c \u0645\u0627\u0631\u067c\u06cc\u0646" },
            { "SY", "\u0633\u0648\u0631\u06cc\u0647" },
            { "SZ", "\u0627\u0633\u0648\u0627\u067c\u064a\u0646\u064a" },
            { "TA", "\u062a\u0631\u06cc\u0633\u062a\u0627\u0646 \u062f\u0627 \u06a9\u0646\u0647\u0627" },
            { "asa", "\u0627\u0633\u0648\u064a\u064a" },
            { "type.ms.ussystem", "\u062f \u0645\u062a\u062d\u062f\u0647 \u0622\u064a\u0627\u0644\u0627\u062a\u0648 \u062f \u0646\u0627\u067e \u0646\u0638\u0627\u0645" },
            { "021", "\u0634\u0645\u0627\u0644\u064a \u0627\u0645\u0631\u06cc\u06a9\u0627" },
            { "TC", "\u062f \u062a\u0631\u06a9\u06cc\u06d0 \u0627\u0648 \u06a9\u06cc\u06a9\u0627\u0633\u0648 \u067c\u0627\u067e\u0648" },
            { "yav", "\u06cc\u0646\u06ab\u0628\u06cc\u0646" },
            { "TD", "\u0686\u0627\u0689" },
            { "TF", "\u062f \u0641\u0631\u0627\u0646\u0633\u06d0 \u062c\u0646\u0648\u0628\u064a \u0633\u06cc\u0645\u06d0" },
            { "TG", "\u067c\u0648\u06ab\u0648" },
            { "TH", "\u062a\u0647\u0627\u064a\u0644\u0646\u0689" },
            { "TJ", "\u062a\u0627\u062c\u06a9\u0633\u062a\u0627\u0646" },
            { "029", "\u06a9\u06cc\u0631\u06cc\u0628\u06cc\u0646" },
            { "TK", "\u062a\u0648\u06a9\u06cc\u0644\u0648" },
            { "TL", "\u062a\u064a\u0645\u0648\u0631-\u0644\u064a\u0633\u067c" },
            { "ybb", "\u06cc\u0645\u0628\u0627" },
            { "TM", "\u062a\u0648\u0631\u06a9\u0645\u0646\u0633\u062a\u0627\u0646" },
            { "TN", "\u062a\u0648\u0646\u0633" },
            { "TO", "\u062a\u0648\u0646\u06ab\u0627" },
            { "TR", metaValue_TR },
            { "TT", "\u067c\u0631\u064a\u0646\u064a\u0689\u0627\u0689 \u0627\u0648 \u067c\u0648\u0628\u0627\u06ab\u0648" },
            { "TV", "\u062a\u0648\u0627\u0644\u06cc\u0648" },
            { "TW", "\u062a\u0627\u0626\u064a\u0648\u0627\u0646" },
            { "ast", "\u0627\u0633\u062a\u0648\u0631\u064a\u0627\u0646\u064a" },
            { "TZ", "\u062a\u0646\u0632\u0627\u0646\u06cc\u0627" },
            { "nmg", "\u06a9\u0648\u0627\u0633\u06cc\u0648" },
            { "Zzzz", "\u0646\u0627\u0645\u0639\u0644\u0648\u0645\u0647 \u0633\u06a9\u0631\u06d0\u067e\u067c" },
            { "UA", "\u0627\u0648\u06a9\u0631\u0627\u06cc\u0646" },
            { "rup", "\u0627\u0631\u0648\u0645\u0627\u0646\u064a" },
            { "030", "\u062e\u062a\u06cc\u0681 \u0622\u0633\u06cc\u0627" },
            { "tyv", "\u062a\u0648\u06cc\u0646\u06cc\u0627\u0646" },
            { "sw_CD", "\u06a9\u0627\u0646\u06ab\u0648 \u0633\u0648\u0627\u0647\u0644\u06cc" },
            { "034", "\u0633\u0648\u064a\u0644\u064a \u0622\u0633\u064a\u0627" },
            { "035", "\u0633\u0648\u064a\u0644\u064a \u062e\u062a\u064a\u0681 \u0622\u0633\u064a\u0627" },
            { "UG", "\u06cc\u0648\u06ab\u0627\u0646\u0689\u0627" },
            { "039", "\u0633\u0648\u064a\u0644\u064a \u0627\u0631\u0648\u067e\u0627" },
            { "Sinh", "\u0633\u0646\u0647\u0627\u0644\u0627" },
            { "UM", "\u062f \u0645\u062a\u062d\u062f\u0647 \u0627\u06cc\u0627\u0644\u0627\u062a\u0648 \u067c\u0627\u067e\u0648\u06ab\u0627\u0646" },
            { "UN", "\u0645\u0644\u06af\u0631\u064a \u0645\u0644\u062a\u0648\u0646\u0647" },
            { "US", "\u0645\u062a\u062d\u062f\u0647 \u0622\u064a\u0627\u0644\u0627\u062a" },
            { "haw", "\u0647\u0648\u0627\u06cc\u06cc" },
            { "UY", "\u06cc\u0648\u0631\u0648\u06ab\u0648\u06cc" },
            { "prg", "\u067e\u0631\u0648\u0634\u064a\u0646" },
            { "UZ", "\u0627\u0648\u0632\u0628\u06a9\u0633\u062a\u0627\u0646" },
            { "tzm", "\u0645\u0631\u06a9\u0632\u06cc \u0627\u0637\u0644\u0633 \u062a\u0645\u0627\u0632\u0627\u0626\u064a\u0679" },
            { "nnh", "\u0646\u0627\u06cc\u062c\u06cc\u0645\u0648\u0646" },
            { "VA", "\u0648\u0627\u062a\u06cc\u06a9\u0627\u0646 \u069a\u0627\u0631" },
            { "VC", "\u0633\u06cc\u0646\u067c \u0648\u06cc\u0633\u0646\u067c\u06cc\u0646\u067c \u0627\u0648 \u06ab\u0631\u06cc\u0646\u0689\u06cc\u0646\u0632" },
            { "VE", "\u0648\u06cc\u0646\u0632\u0648\u06cc\u0644\u0627" },
            { "VG", "\u0628\u0631\u06cc\u062a\u0627\u0646\u0648\u06cc \u0648\u06cc\u06ab\u0648\u0631 \u067c\u0627\u067e\u0648\u06ab\u0627\u0646" },
            { "VI", "\u062f \u0645\u062a\u062d\u062f\u0647 \u0622\u064a\u0627\u0644\u0627\u062a\u0648 \u0648\u0631\u062c\u0646 \u067c\u0627\u067e\u0648\u06ab\u0627\u0646" },
            { "VN", "\u0648\u06d0\u062a\u0646\u0627\u0645" },
            { "VU", "\u0648\u0627\u0646\u0627\u062a\u0648" },
            { "nog", "\u0646\u0648\u06ab\u06cc" },
            { "rwk", "\u0631\u0648\u0627" },
            { "053", "\u0622\u0633\u062a\u0631\u0627\u0644\u06cc\u0627" },
            { "054", "\u0645\u0644\u0627\u0646\u0634\u06cc\u0627" },
            { "WF", "\u0648\u0627\u0644\u06cc\u0633 \u0627\u0648 \u0641\u0648\u062a\u0648\u0646\u0627" },
            { "057", "\u062f \u0645\u0627\u06cc\u06a9\u0631\u0648\u0646\u06cc\u0633\u06cc\u0646\u06cc\u0646 \u0633\u06cc\u0645\u0647" },
            { "jgo", "\u0646\u06ab\u0648\u0645\u0628\u0627" },
            { "lkt", "\u0644\u06a9\u0648\u067c\u0627" },
            { "wae", "\u0648\u0644\u0633\u06cc\u0631" },
            { "WS", "\u0633\u0627\u0645\u0648\u0627" },
            { "wal", "\u0648\u0644\u0627\u06cc\u067c\u0627" },
            { "XA", "\u062c\u0639\u0644\u064a \u062e\u062c" },
            { "war", "\u0648\u0627\u0631\u06cd" },
            { "XB", "\u062c\u0639\u0644\u064a \u0628\u064a\u062f\u064a" },
            { "awa", "\u0627\u0648\u0627\u062f\u064a" },
            { "061", "\u067e\u0648\u0644\u0646\u064a\u0633\u064a\u0627" },
            { "XK", "\u06a9\u0648\u0633\u0648\u0648" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "\u0646\u0627\u0644\u064a\u06a9\u0644\u06cc" },
            { "YE", "\u06cc\u0645\u0646" },
            { "nqo", "\u0646\u06a9\u0648" },
            { "type.co.standard", "\u0645\u0639\u064a\u0627\u0631\u064a \u062f \u0644\u067c\u06d0 \u062a\u0631\u062a\u064a\u0628" },
            { "YT", "\u0645\u0627\u064a\u0648\u067c" },
            { "ZA", "\u0633\u0648\u06cc\u0644\u064a \u0627\u0641\u0631\u06cc\u0642\u0627" },
            { "type.lb.loose", "\u062f \u063a\u0693\u0646\u062f\u06d0 \u0645\u0627\u062a\u06d0 \u06a9\u0631\u069a\u06d0 \u0689\u0648\u0644" },
            { "Deva", "\u062f\u06cc\u0648\u0627\u0646\u0627\u06ab\u0631\u064a" },
            { "type.nu.geor", "\u06ab\u0631\u064a\u06ab\u0648\u0631\u064a\u0646 \u0627\u0639\u062f\u0627\u062f" },
            { "Hira", "\u0647\u06cc\u0631\u0627\u06ab\u0627\u0646\u0627" },
            { "ZM", "\u0632\u06cc\u0645\u0628\u06cc\u0627" },
            { "ZW", "\u0632\u06cc\u0645\u0628\u0627\u0628\u0648\u06cc" },
            { "ZZ", "\u0646\u0627\u0645\u0639\u0644\u0648\u0645\u0647 \u0633\u064a\u0645\u0647" },
            { "type.ms.metric", "\u0645\u064a\u067c\u0631\u06a9 \u0646\u0638\u0627\u0645" },
            { "type.ca.iso8601", "ISO-8601 \u062c\u0646\u062a\u0631\u064a" },
            { "nso", "\u0634\u0645\u0627\u0644\u064a \u0633\u0648\u062a\u0648" },
            { "type.nu.telu", "\u062a\u064a\u0644\u0648\u06ab\u0648 \u0627\u0639\u062f\u0627\u062f" },
            { "loz", "\u0644\u0648\u0632\u06cc" },
            { "jmc", "\u0645\u0627\u0686\u0645\u06cc" },
            { "type.nu.hansfin", "\u0633\u0627\u062f\u0647 \u0686\u064a\u0646\u064a \u0645\u0627\u0644\u064a \u0627\u0639\u062f\u0627\u062f" },
            { "hil", "\u06be\u0644\u06cc\u06ab\u06cc\u0646\u0648\u0646" },
            { "type.nu.arabext", "\u063a\u0681\u06d0\u062f\u0644\u06d0 \u0639\u0631\u0628\u064a \u06d4 \u0627\u064a\u0646\u0689\u064a\u06a9 \u0639\u062f\u062f" },
            { "nus", "\u0646\u0648\u06cc\u0631" },
            { "dak", "\u062f\u0627\u06a9\u0648\u062a\u0627" },
            { "type.nu.fullwide", "\u062f \u0628\u0634\u067e\u0693\u0647 \u067e\u0631\u0627\u062e\u062a\u064a\u0627 \u0627\u0639\u062f\u0627\u062f" },
            { "dar", "\u062f\u0631\u06af\u0648\u0627" },
            { "dav", "\u067c\u0627\u06cc\u067c\u0627" },
            { "lrc", "\u0634\u0645\u0627\u0644\u064a \u0644\u0648\u0631\u06cc" },
            { "udm", "\u0627\u062f\u0645\u0648\u0631\u062a" },
            { "Khmr", metaValue_km },
            { "sad", "\u0633\u0646\u0689\u0627\u0648\u06cc" },
            { "type.nu.roman", "\u0631\u0648\u0645\u0646 \u0627\u0639\u062f\u0627\u062f" },
            { "sah", "\u0633\u062e\u0627" },
            { "saq", "\u0633\u0645\u0628\u0648\u0631\u0648" },
            { "sat", "\u0633\u0646\u062a\u0627\u0644\u064a" },
            { "sba", "\u0646\u06ab\u0628\u0627\u06cc" },
            { "Guru", "\u06ab\u0631\u0648\u0645\u064a" },
            { "lua", "\u0644\u0628\u0627 \u0644\u0648\u0644\u0648\u0627" },
            { "sbp", "\u0633\u0627\u0646\u06ab\u0648\u0648" },
            { "nyn", "\u0646\u06cc\u0646\u06a9\u0648\u0644" },
            { "lun", "\u0644\u0646\u062f\u0627" },
            { "luo", "\u0644\u0648" },
            { "fil", "\u0641\u0644\u06cc\u067e\u06cc\u0646\u064a" },
            { "hmn", "\u0647\u0645\u0648\u0646\u06ab" },
            { "lus", "\u0645\u064a\u0632\u0648" },
            { "bal", "\u0628\u0644\u0648\u0685\u064a" },
            { "ban", "\u0628\u0627\u0644\u0646\u06cc" },
            { "luy", "\u0644\u0648\u06cc\u0627" },
            { "bas", "\u0628\u0627\u0633\u0627" },
            { "es_ES", "\u0627\u0631\u0648\u067e\u0627\u064a\u064a \u0647\u0633\u067e\u0627\u0646\u0648\u064a" },
            { "sco", "\u0633\u06a9\u0627\u067c\u0633" },
            { "scn", "\u0633\u06cc\u0644\u06cc\u0633\u064a" },
            { "aa", "\u0627\u0641\u0631\u064a" },
            { "ab", "\u0627\u0628\u062e\u0627\u0632\u064a" },
            { "af", "\u0627\u0641\u0631\u06cc\u06a9\u0627\u0646\u0633\u064a" },
            { "ak", "\u0627\u06a9\u0627\u0646\u064a" },
            { "am", "\u0627\u0645\u0647\u0627\u0631\u064a" },
            { "Arab", metaValue_ar },
            { "an", "\u0627\u0631\u0627\u06af\u0648\u0646\u06d0\u0633\u064a" },
            { "Jpan", metaValue_ja },
            { "ar", metaValue_ar },
            { "Hrkt", "\u062f \u062c\u0627\u067e\u0627\u0646\u064a \u0633\u06cc\u0644\u0627\u0628\u0631\u064a" },
            { "as", "\u0627\u0633\u0627\u0645\u064a" },
            { "av", "\u0627\u0648\u0627\u0631\u064a" },
            { "ay", "\u0627\u06cc\u0645\u0627\u0631\u064a" },
            { "az", "\u0627\u0630\u0631\u0628\u0627\u06cc\u062c\u0627\u0646\u064a" },
            { "ba", "\u0628\u0627\u0634\u06a9\u064a\u0631" },
            { "be", "\u0628\u06d0\u0644\u0627\u0631\u0648\u0633\u064a" },
            { "bg", "\u0628\u0644\u063a\u0627\u0631\u064a" },
            { "bi", "\u0628\u0633\u0644\u0627\u0645\u0627" },
            { "bm", "\u0628\u0645\u0628\u0627\u0631\u0627" },
            { "bn", "\u0628\u0646\u06af\u0627\u0644\u064a" },
            { "bo", metaValue_bo },
            { "dgr", "\u062f\u0627\u06af\u0631\u0628" },
            { "br", "\u0628\u0631\u06d0\u062a\u0648\u0646" },
            { "bs", "\u0628\u0648\u0633\u0646\u064a" },
            { "Mymr", "\u0645\u06cc\u0627\u0646\u0645\u0627\u0631" },
            { "type.nu.laoo", "\u0644\u0627\u0648\u064a \u0627\u0639\u062f\u0627\u062f" },
            { "seh", "\u0633\u06cc\u0646\u0627" },
            { "ca", "\u06a9\u067c\u0644\u0627\u0646\u064a" },
            { "ses", "\u06a9\u0648\u06cc\u06cc\u0631\u0627\u0628\u0648\u0631\u0648 \u0633\u06cc\u0646\u06cc" },
            { "ce", "\u0686\u064a\u0686\u0646\u064a" },
            { "ch", "\u0686\u0645\u0648\u0631\u0648" },
            { "co", "\u06a9\u0648\u0631\u0633\u064a\u06a9\u0627\u0646\u064a" },
            { "Orya", "\u0627\u0648\u062f\u064a\u0627" },
            { "cs", "\u0686\u06d0\u06a9\u064a" },
            { "cu", "\u062f \u06a9\u0644\u064a\u0633\u0627 \u0633\u0644\u0627\u0648\u064a" },
            { "cv", "\u0686\u0648\u0648\u0627\u0634\u064a" },
            { "cy", "\u0648\u064a\u0644\u0634\u064a" },
            { "type.nu.ethi", "\u0627\u064a\u062a\u0647\u0648\u067e\u064a\u0627\u064a\u064a \u0627\u0639\u062f\u0627\u062f" },
            { "da", "\u0689\u0646\u0645\u0627\u0631\u06a9\u064a" },
            { "pt_PT", "\u0627\u0631\u0648\u067e\u0627\u064a\u064a \u067e\u0631\u062a\u06ab\u0627\u0644\u064a" },
            { "de", "\u0627\u0644\u0645\u0627\u0646\u064a" },
            { "type.cf.standard", "\u0645\u0639\u064a\u0627\u0631\u064a \u0627\u0633\u0639\u0627\u0631\u0648 \u0628\u06bc\u0647" },
            { "bem", "\u0628\u064a\u0645\u0628\u0627" },
            { "dv", "\u062f\u064a\u0648\u06cc\u0647\u06cc" },
            { "es_419", "\u0644\u0627\u062a\u064a\u0646\u064a \u0627\u0645\u0631\u064a\u06a9\u0627\u064a\u064a \u0647\u0633\u067e\u0627\u0646\u0648\u064a" },
            { "dz", "\u0698\u0648\u0646\u06af\u06a9\u0647" },
            { "bez", "\u0628\u064a\u0646\u0627" },
            { "type.ca.chinese", "\u062f \u0686\u064a\u0646 \u062c\u0646\u062a\u0631\u064a" },
            { "dje", "\u0632\u0631\u0645\u0627" },
            { "type.nu.grek", "\u064a\u0648\u0646\u0627\u0646\u064a \u0627\u0639\u062f\u0627\u062f" },
            { "ee", "\u0627\u064a\u0648" },
            { "type.lb.normal", "\u062f \u0639\u0627\u062f\u064a \u0645\u0627\u062a\u06d0 \u06a9\u0631\u069a\u06d0 \u0689\u0648\u0644" },
            { "ro_MD", "\u0645\u0648\u0644\u062f\u0627\u0648\u06cc\u0627\u06cc\u06cc" },
            { "el", metaValue_el },
            { "en", "\u0627\u0646\u06ab\u0644\u064a\u0633\u064a" },
            { "eo", "\u0627\u0633\u067e\u0631\u0627\u0646\u062a\u0648" },
            { "es", "\u0647\u0633\u067e\u0627\u0646\u0648\u064a" },
            { "et", "\u062d\u0628\u0634\u064a" },
            { "Hanb", "\u0647\u0646 \u0627\u0648 \u0628\u0648\u067e\u0648\u0641\u0648\u0645\u0648" },
            { "eu", "\u0628\u0627\u0633\u06a9\u064a" },
            { "Hang", "\u0647\u0646\u06ab\u0648\u0644\u064a" },
            { "shi", "\u062a\u0627\u06a9\u0644\u0647\u06cc\u067c" },
            { "hsb", "\u067e\u0648\u0631\u062a\u0647 \u0633\u0631\u0628\u064a\u0627\u064a\u064a" },
            { "Hani", "\u0647\u0646" },
            { "shn", "\u0634\u0627\u0646" },
            { "fa", "\u0641\u0627\u0631\u0633\u064a" },
            { "Hans", "\u0633\u0627\u062f\u0647 \u0634\u0648\u06cc" },
            { "type.nu.latn", "\u0644\u0648\u064a\u062f\u064a\u0681 \u0639\u062f\u062f\u0648\u0646\u0647" },
            { "Hant", "\u062f\u0648\u062f\u06cc\u0632\u0647" },
            { "ff", "\u0641\u0648\u0644\u0627\u062d" },
            { "fi", "\u0641\u06cc\u0646\u0644\u0646\u0689\u064a" },
            { "fj", "\u0641\u062c\u06cc\u0627\u0646" },
            { "fon", "\u0641\u0627\u0646" },
            { "yue", "\u06a9\u0627\u0646\u067c\u0648\u0646\u064a" },
            { "fo", "\u0641\u0627\u0631\u0648\u0626\u06d0" },
            { "umb", "\u0627\u0645\u0628\u0648\u0646\u062f\u0648" },
            { "fr", "\u0641\u0631\u0627\u0646\u0633\u0648\u064a" },
            { "fy", "\u0644\u0648\u06d0\u062f\u064a\u0681 \u0641\u0631\u064a\u0634\u064a" },
            { "ga", "\u0627\u0626\u064a\u0631\u0644\u06d0\u0646\u0689\u064a" },
            { "gd", "\u0633\u06a9\u0627\u067c\u0644\u06d0\u0646\u0689\u064a \u06ab\u06d0\u0644\u06a9" },
            { "gl", "\u06ab\u0644\u06d0\u0634\u064a\u0627\u064a\u064a" },
            { "gn", "\u06ab\u0648\u0631\u0627\u0646\u064a" },
            { "bho", "\u0628\u0647\u0648\u062c\u067e\u0648\u0631\u064a" },
            { "und", "\u0646\u0627\u0645\u0639\u0644\u0648\u0645\u0647 \u0698\u0628\u0647" },
            { "gu", metaValue_gu },
            { "type.ca.islamic-tbla", "\u0627\u0633\u0644\u0627\u0645\u064a \u062c\u0646\u062a\u0631\u064a (\u062c\u062f\u0648\u0644\u064a\u060c \u0633\u062a\u0648\u0631\u067e\u0648\u0647\u0646\u064a\u0632 \u0639\u0635\u0631)" },
            { "gv", "\u0645\u06cc\u0646\u06a9\u0633" },
            { "ha", "\u0647\u0648\u0633\u0627" },
            { "he", metaValue_he },
            { "hi", "\u0647\u0646\u062f\u064a" },
            { "hup", "\u06be\u0648\u067e\u0627" },
            { "bin", "\u0628\u06cc\u0646\u06cc" },
            { "hr", "\u06a9\u0631\u0648\u0627\u064a\u0634\u064a\u0627\u064a\u064a" },
            { "ht", "\u0647\u064a\u067c\u064a \u06a9\u0631\u064a\u0648\u0644" },
            { "hu", "\u0647\u0646\u06af\u0631\u064a" },
            { "hy", "\u0622\u0631\u0645\u064a\u0646\u064a\u0627\u064a\u064a" },
            { "hz", "\u0647\u06cc\u0631\u0648\u0631\u0648" },
            { "ia", "\u0627\u0646\u067c\u0631\u0644\u0646\u06ab\u0648\u0627" },
            { "Jamo", "\u062c\u0627\u0645\u0648" },
            { "id", "\u0627\u0646\u0689\u0648\u0646\u06d0\u0632\u064a" },
            { "type.nu.tibt", "\u062a\u0628\u062a\u064a \u0627\u0639\u062f\u0627\u062f" },
            { "ig", "\u0627\u06ab\u0628\u0648" },
            { "ii", "\u0633\u06cc\u0686\u06cc\u0627\u0646 \u06cc\u06cc" },
            { "io", "\u0627\u068a\u0648" },
            { "is", "\u0627\u064a\u0633\u0644\u0646\u0689\u064a" },
            { "it", "\u0627\u06cc\u067c\u0627\u0644\u0648\u064a" },
            { "iu", "\u0627\u0646\u0648\u06a9\u062a\u06cc\u062a\u0648\u062a" },
            { "ja", metaValue_ja },
            { "Mlym", "\u0645\u0627\u0644\u0627\u06cc\u0627\u0644\u0645" },
            { "sma", "\u0633\u0648\u06cc\u0644\u064a \u0633\u0627\u0645\u06cc" },
            { "jv", "\u062c\u0627\u0648\u0627\u064a\u064a" },
            { "mad", "\u0645\u062f\u0631\u0627\u0633\u06cc" },
            { "smj", "\u0644\u0648\u0644 \u0633\u0627\u0645\u064a" },
            { "mag", "\u0645\u06ab\u0647\u064a" },
            { "mai", "\u0645\u0627\u06cc\u062a\u06be\u0644\u064a" },
            { "smn", "\u0627\u0646\u0627\u0631\u064a \u0633\u0645\u064a\u0639" },
            { "ka", "\u062c\u0648\u0631\u062c\u064a\u0627\u0626\u064a" },
            { "bla", "\u0633\u06a9\u0633\u064a\u06a9\u0627" },
            { "mak", "\u0645\u06a9\u0627\u0633\u0627\u0631" },
            { "sms", "\u0633\u06a9\u0648\u0644\u067c \u0633\u0645\u06cc\u0639" },
            { "ki", "\u06a9\u06a9\u0648\u0624\u0648" },
            { "mas", "\u0645\u0627\u0633\u0627\u0626\u064a" },
            { "kj", "\u06a9\u0648\u0627\u0646\u0627\u0645\u0627" },
            { "kk", "\u0642\u0627\u0632\u0642" },
            { "kl", "\u06a9\u0644\u0627\u0644\u06cc\u0633\u0679" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "\u06a9\u0646\u0648\u0631\u06cc" },
            { "ks", "\u06a9\u0634\u0645\u06cc\u0631\u064a" },
            { "ku", "\u06a9\u0631\u062f\u064a" },
            { "kv", "\u06a9\u0648\u0645\u06cc" },
            { "kw", "\u06a9\u0648\u0631\u0646\u064a\u0634\u064a" },
            { "ky", "\u06a9\u0631\u063a\u064a\u0632\u064a" },
            { "snk", "\u0633\u0648\u0646\u06cc\u0646\u06ab" },
            { "la", "\u0644\u0627\u062a\u06cc\u0646\u064a" },
            { "lb", "\u0644\u0648\u06ab\u0632\u0627\u0645\u0628\u0648\u0631\u06ab\u064a" },
            { "type.nu.mlym", "\u0645\u0644\u0627\u064a \u0644\u0627\u0645 \u0627\u0639\u062f\u0627\u062f" },
            { "lg", "\u06ab\u0627\u0646\u062f\u0647" },
            { "li", "\u0644\u0645\u0628\u0631\u06af\u06cc\u0627\u0646\u06cc" },
            { "Tibt", metaValue_bo },
            { "ln", "\u0644\u0646\u06ab\u0627\u0644\u0627" },
            { "fur", "\u0641\u0631\u0627\u0626\u06cc\u0644\u06cc\u06cc\u0646" },
            { "lo", "\u0644\u0627\u0648" },
            { "lt", "\u0644\u064a\u062a\u0648\u0627\u0646\u064a" },
            { "lu", "\u0644\u0648\u0628\u0627-\u06a9\u067c\u0646\u06ab\u0627" },
            { "lv", "\u0644\u06d0\u067c\u0648\u0627\u0646\u064a" },
            { "mg", "\u0645\u0644\u063a\u0627\u0633\u064a" },
            { "mh", "\u0645\u0627\u0631\u0634\u0644\u06cc\u0632" },
            { "type.co.ducet", "\u0689\u064a\u0641\u0627\u0644\u067c \u064a\u0648\u0646\u064a\u06a9\u0648\u0689 \u062a\u0631\u062a\u064a\u0628" },
            { "mi", "\u0645\u0627\u0648\u0631\u064a" },
            { "mk", "\u0645\u0642\u062f\u0648\u0646\u064a" },
            { "ml", "\u0645\u0627\u0644\u0627\u064a\u0627\u0644\u0645" },
            { "mn", "\u0645\u0646\u06ab\u0648\u0644\u06cc\u0627\u06cc\u06cc" },
            { "mr", "\u0645\u0631\u0627\u067c\u0647\u064a" },
            { "ms", "\u0645\u0644\u0627\u06cc\u0627" },
            { "mt", "\u0645\u0627\u0644\u067c\u0627\u064a\u064a" },
            { "my", "\u0628\u0631\u0645\u0627\u06cc\u06cc" },
            { "Armn", "\u0627\u0631\u0645\u0627\u0646\u06cc\u0627\u06cc\u064a" },
            { "mdf", "\u0645\u0648\u06a9\u0634\u0627" },
            { "dsb", "\u06a9\u069a\u062a\u0647 \u0633\u0631\u0628\u064a\u0627\u064a\u064a" },
            { "na", metaValue_NR },
            { "type.co.search", "\u062f \u0639\u0645\u0648\u0645\u064a \u0645\u0648\u062e\u064a \u0644\u067c\u0648\u0646" },
            { "nb", "\u0646\u0627\u0631\u0648\u06d0 \u0628\u0648\u06a9\u0645\u0627\u0644" },
            { "nd", "\u0634\u0645\u0627\u0644\u064a \u0646\u062f\u064a\u0628\u0644" },
            { "ne", "\u0646\u06d0\u067e\u0627\u0644\u064a" },
            { "ng", "\u0646\u062f\u0648\u0646\u06af\u0627" },
            { "nl", "\u0647\u0627\u0644\u06d0\u0646\u0689\u064a" },
            { "nn", "\u0646\u0627\u0631\u0648\u06d0\u0626\u064a (\u0646\u0627\u0626\u0646\u0648\u0631\u0633\u06a9)" },
            { "nr", "\u0633\u0648\u064a\u0644\u064a \u0646\u062f\u064a\u0628\u064a\u0644" },
            { "nv", "\u0646\u0648\u0627\u062c\u0648" },
            { "ny", "\u0646\u06cc\u0627\u0646\u062c\u0627" },
            { "kac", "\u06a9\u0627\u0686\u06cc\u0646" },
            { "kab", "\u06a9\u06cc\u0628\u06cc\u0644" },
            { "oc", "\u0627\u0648\u06a9\u0633\u064a\u067c\u0627\u0646\u064a" },
            { "kaj", "\u062c\u062c\u0648" },
            { "kam", "\u06a9\u0627\u0645\u0628\u0627" },
            { "men", "\u0645\u06cc\u0646\u068a\u064a" },
            { "mer", "\u0645\u064a\u0631\u0648" },
            { "type.nu.armn", "\u0622\u0631\u0645\u064a\u0646\u064a\u0627\u064a\u064a \u0627\u0639\u062f\u0627\u062f" },
            { "om", "\u0627\u0648\u0631\u0648\u0645\u0648" },
            { "or", "\u0627\u0648\u068a\u064a\u0627" },
            { "os", "\u0627\u0648\u0633\u064a\u067c\u06a9" },
            { "kbd", "\u06a9\u0627\u0628\u06cc\u0631\u06cc\u0646" },
            { "mfe", "\u0645\u0627\u0631\u06cc\u0633\u06cc\u0633\u0646" },
            { "srn", "\u0633\u0648\u0631\u0627\u0646 \u067c\u0648\u0646\u06ab\u0648" },
            { "pa", "\u067e\u0646\u062c\u0627\u0628\u064a" },
            { "dua", "\u062f\u0648\u0627\u0644\u0627" },
            { "pl", "\u067e\u0648\u0644\u0646\u0689\u064a" },
            { "type.ca.dangi", "\u0689\u0627\u0646\u06ab\u064a \u062c\u0646\u062a\u0631\u064a" },
            { "ps", "\u067e\u069a\u062a\u0648" },
            { "pt", "\u067e\u0648\u0631\u062a\u06ab\u0627\u0644\u064a" },
            { "key.co", "\u062a\u0631\u062a\u064a\u0628" },
            { "pt_BR", "\u0628\u0631\u0627\u0632\u06cc\u0644\u064a \u067e\u0631\u062a\u06ab\u0627\u0644\u064a" },
            { "kcg", "\u062a\u0627\u06cc\u067e" },
            { "mgh", "\u0645\u06a9\u06be\u0648\u0627\u0645\u06cc\u062a\u0648" },
            { "key.cf", "\u0627\u0633\u0639\u0627\u0631\u0648 \u0628\u06bc\u0647" },
            { "key.ca", "\u062c\u0646\u062a\u0631\u064a" },
            { "Laoo", "\u0644\u0627\u0648\u0648" },
            { "mgo", "\u0645\u064a\u067c\u0627" },
            { "type.hc.h23", "\u062f \u06f2\u06f4 \u0633\u0627\u0639\u062a\u0648 \u0646\u0638\u0627\u0645 (\u06f0\u0640\u06f2\u06f3)" },
            { "type.hc.h24", "\u062f \u0633\u0627\u0639\u062a\u0648 \u0646\u0638\u0627\u0645 (\u06f1\u0640\u06f2\u06f4)" },
            { "ssy", "\u0633\u0647\u0648" },
            { "type.nu.mymr", "\u062f \u0645\u064a\u0627\u0646\u0645\u0627\u0631 \u0627\u0639\u062f\u0627\u062f" },
            { "qu", "\u06a9\u06d0\u0686\u0648\u0627" },
            { "brx", "\u0628\u0648\u062f\u0648" },
            { "kde", "\u0645\u064a\u06a9\u0648\u0646\u0689\u064a" },
            { "Ethi", "\u0627\u06cc\u062a\u0648\u067e\u064a" },
            { "type.hc.h12", "\u062f \u06f1\u06f2 \u0633\u0627\u0639\u062a\u0648 \u0646\u0638\u0627\u0645 (\u06f1 \u0640 \u06f1\u06f2)" },
            { "type.hc.h11", "\u062f \u06f1\u06f2 \u0633\u0627\u0639\u062a\u0648 \u0646\u0638\u0627\u0645 (\u06f0\u0640\u06f1\u06f1)" },
            { "rm", "\u0631\u0648\u0645\u0627\u0646\u06cc\u0634" },
            { "rn", "\u0631\u0648\u0646\u0689\u06cc" },
            { "key.cu", "\u0627\u0633\u0639\u0627\u0631\u0648" },
            { "ro", "\u0631\u0648\u0645\u0627\u0646\u06cc\u0627\u06cc\u06cc" },
            { "type.nu.orya", "\u062f \u0627\u0648\u0689\u064a\u0627 \u0627\u0639\u062f\u0627\u062f" },
            { "type.nu.hanidec", "\u0686\u0627\u064a\u0646\u064a \u0627\u0639\u0634\u0627\u0631\u064a \u0627\u0639\u062f\u0627\u062f" },
            { "ru", "\u0631\u0648\u0633\u064a" },
            { "rw", "\u06a9\u06cc\u0646\u06cc\u0627\u0631\u0648\u0646\u0689\u0627" },
            { "kea", "\u06a9\u0627\u0628\u0648\u0648\u0631\u0689\u06cc\u0627\u0646\u0648" },
            { "mic", "\u0645\u0645\u06a9\u0642" },
            { "suk", "\u0633\u06a9\u0648\u0645\u0627" },
            { "en_AU", "\u0622\u0633\u067c\u0631\u0627\u0644\u064a\u0627\u0648\u064a \u0627\u0646\u06ab\u0644\u064a\u0633\u064a" },
            { "sa", "\u0633\u0646\u0633\u06a9\u0631\u06cc\u067c" },
            { "sc", "\u0633\u0627\u0631\u068a\u064a\u0646\u064a" },
            { "sd", "\u0633\u0646\u062f\u0647\u064a" },
            { "se", "\u0634\u0645\u0627\u0644\u064a \u0633\u0627\u0645\u064a" },
            { "min", "\u0645\u064a\u0646\u064a\u06af\u0627\u0628\u0627\u0648" },
            { "sg", "\u0633\u0627\u0646\u06ab\u0648" },
            { "si", "\u0633\u064a\u0646\u0647\u0627\u0644\u064a" },
            { "sk", "\u0633\u0644\u0648\u0648\u0627\u06a9\u064a" },
            { "sl", "\u0633\u0644\u0648\u0648\u0627\u0646\u064a" },
            { "sm", "\u0633\u0627\u0645\u0648\u0622\u0646" },
            { "sn", "\u0634\u0648\u0646\u0627" },
            { "so", "\u0633\u0648\u0645\u0627\u0644\u064a" },
            { "type.nu.arab", "\u0639\u0631\u0628\u064a - \u0627\u0646\u0689\u06cc\u06a9 \u0639\u062f\u062f\u0648\u0646\u0647" },
            { "sq", "\u0627\u0644\u0628\u0627\u0646\u064a" },
            { "sr", "\u0633\u0631\u0628\u064a\u0627\u0626\u064a" },
            { "ss", "\u0633\u0648\u0627\u062a\u06cc" },
            { "type.cf.account", "\u0645\u062d\u0627\u0633\u0628\u0647 \u0627\u0633\u0639\u0627\u0631\u0648 \u0628\u06bc\u0647" },
            { "st", "\u0633\u0648\u064a\u0644\u064a \u0633\u0648\u062a\u0648" },
            { "su", "\u0633\u0648\u0689\u0627\u0646\u064a" },
            { "sv", "\u0633\u0648\u06cc\u0689\u0646\u06cc" },
            { "sw", "\u0633\u0648\u0627\u0647\u06d0\u0644\u064a" },
            { "type.nu.hantfin", "\u062f\u0648\u062f\u064a\u0632 \u0686\u064a\u0646\u064a \u0645\u0627\u0644\u064a \u0627\u0639\u062f\u0627\u062f" },
            { "ibb", "\u0627\u0628\u06cc\u0628\u06cc\u0648" },
            { "iba", "\u0627\u0628\u0646" },
            { "ta", metaValue_ta },
            { "142", "\u0622\u0633\u064a\u0627" },
            { "143", "\u0645\u0646\u0681\u0646\u06cd \u0622\u0633\u064a\u0627" },
            { "te", "\u062a\u06d0\u0644\u064a\u06ab\u0648" },
            { "145", "\u0644\u0648\u06cc\u062f\u06cc\u0681 \u0622\u0633\u06cc\u0627" },
            { "tg", "\u062a\u0627\u062c\u06a9\u064a" },
            { "th", "\u062a\u0627\u064a\u0644\u06d0\u0646\u0689\u064a" },
            { "ti", "\u062a\u064a\u06ab\u0631\u064a\u0646\u064a" },
            { "bug", "\u0628\u06af\u0646\u064a\u0627\u064a\u064a" },
            { "kfo", "\u06a9\u0648\u0631\u0648" },
            { "en_CA", "\u06a9\u0627\u0646\u0627\u0689\u0627\u064a\u064a \u0627\u0646\u06ab\u0644\u06cc\u0633\u064a" },
            { "tk", "\u062a\u0631\u06a9\u0645\u0646\u064a" },
            { "tn", "\u0633\u0648\u0648\u0627\u0646\u0627" },
            { "to", "\u062a\u0648\u0646\u06ab\u0627\u0646" },
            { "dyo", "\u062c\u0648\u0644\u0627 \u0641\u0648\u0646\u064a" },
            { "type.nu.jpan", "\u062c\u0627\u067e\u0627\u0646\u064a \u0627\u0639\u062f\u0627\u062f" },
            { "tr", metaValue_TR },
            { "ts", "\u0633\u0648\u0646\u06ab\u0627" },
            { "swb", "\u06a9\u0648\u0645\u0648\u0631\u064a\u0627\u0646\u064a" },
            { "tt", "\u062a\u0627\u062a\u0627\u0631" },
            { "ty", "\u062a\u0627\u0647\u06cc\u062a\u064a" },
            { "150", "\u0627\u0631\u0648\u067e\u0627" },
            { "151", "\u062e\u062a\u064a\u0681 \u0627\u0631\u0648\u067e\u0627" },
            { "154", "\u0634\u0645\u0627\u0644\u064a \u0627\u0631\u0648\u067e\u0627" },
            { "dzg", "\u0689\u0632\u0627\u06ab\u0627" },
            { "155", "\u0644\u0648\u06d0\u062f\u064a\u0681 \u0627\u0631\u0648\u067e\u0627" },
            { "ug", "\u0627\u0648\u064a\u063a\u0648\u0631\u064a" },
            { "Kore", metaValue_ko },
            { "Zyyy", "\u0639\u0627\u0645" },
            { "uk", "\u0627\u0648\u06a9\u0631\u0627\u064a\u0646\u064a" },
            { "ur", "\u0627\u0631\u062f\u0648" },
            { "xal", "\u06a9\u0627\u0644\u0645\u06a9" },
            { "uz", "\u0627\u0648\u0632\u0628\u06a9\u064a" },
            { "kha", "\u062e\u0627\u0633\u06d0" },
            { "ve", "\u0648\u06cc\u0646\u062f\u0627" },
            { "type.ca.roc", "\u0645\u0646\u06af\u0648\u0648 \u062c\u0646\u062a\u0631\u064a" },
            { "vi", "\u0648\u06d0\u062a\u0646\u0627\u0645\u064a" },
            { "khq", "\u06a9\u0648\u06cc\u0631\u0627 \u0686\u06cc\u0646\u06cc" },
            { "key.hc", "\u062f \u0633\u0627\u0639\u062a \u0686\u06a9\u0631 (\u06f1\u06f2 \u067e\u0631\u062a\u0644\u0647 \u06f2\u06f4)" },
            { "vo", "\u0648\u0627\u0644\u0627\u067e\u0648\u06a9" },
            { "quc", "\u06a9\u0686\u06cc" },
            { "wa", "\u0648\u0627\u0644\u0648\u0646" },
            { "syr", "\u0633\u0648\u0631\u06cc\u0627\u0646\u064a" },
            { "Grek", metaValue_el },
            { "wo", "\u0648\u0644\u0648\u0641" },
            { "zgh", "\u0645\u0639\u064a\u0627\u0631\u064a \u0645\u0631\u0627\u06a9\u0634\u064a \u062a\u0645\u0627\u0632\u064a\u067c" },
            { "ar_001", "\u0646\u0648\u06d0 \u0645\u0639\u064a\u0627\u0631\u064a \u0639\u0631\u0628\u064a" },
            { "Mong", "\u0645\u0646\u06ab\u0648\u0644\u06cc\u0627\u06cc\u064a" },
            { "mni", "\u0645\u0627\u0646\u06cc \u067e\u0648\u0631\u06cc" },
            { "Latn", "\u0644\u0627\u062a\u064a\u0646/\u0644\u0627\u062a\u064a\u0646\u064a" },
            { "type.nu.hans", "\u0633\u0627\u062f\u0647 \u0686\u064a\u0646\u064a \u0627\u0639\u062f\u0627\u062f" },
            { "type.nu.hant", "\u062f\u0648\u062f\u064a\u0632 \u0686\u064a\u0646\u064a \u0627\u0639\u062f\u0627\u062f" },
            { "xh", "\u062e\u0648\u0633\u0627" },
            { "type.nu.romanlow", "\u0631\u0648\u0645\u0646 \u06a9\u0648\u0686\u0646\u064a \u0627\u0639\u062f\u0627\u062f" },
            { "byn", "\u0628\u0644\u06cc\u0646" },
            { "moh", "\u0645\u062d\u0627\u0648\u0627\u06a9" },
            { "kkj", "\u06a9\u0627\u06a9\u0648" },
            { "yi", "\u064a\u062f\u064a\u0634" },
            { "mos", "\u0645\u0627\u0633\u064a" },
            { "yo", "\u06cc\u0648\u0631\u0648\u0628\u0627" },
            { "es_MX", "\u0645\u064a\u06a9\u0633\u064a\u06a9\u064a \u0647\u0633\u067e\u0627\u0646\u0648\u064a" },
            { "vai", "\u0648\u0627\u06cc" },
            { "kln", "\u06a9\u0644\u06cc\u0646\u062c\u0646" },
            { "zh", "\u0686\u06cc\u0646\u064a" },
            { "Bopo", "\u0628\u0648\u067e\u0648\u0645\u0648\u0641\u0648" },
            { "key.lb", "\u062f \u0645\u0627\u062a\u06d0 \u06a9\u0631\u069a\u06d0 \u0689\u0648\u0644" },
            { "zu", "\u0632\u0648\u0644\u0648" },
            { "Geor", "\u06ab\u0631\u062c\u0633\u062a\u0627\u0646\u064a" },
            { "kmb", "\u06a9\u06cc\u0645\u0628\u0648\u0646\u062f\u0648" },
            { "type.nu.jpanfin", "\u062c\u0627\u067e\u0627\u0646\u064a \u0645\u0627\u0644\u064a \u0627\u0639\u062f\u0627\u062f" },
            { "gez", "\u06ab\u06cc\u0632" },
            { "ebu", "\u0627\u064a\u0645\u0628\u0648" },
            { "zh_Hans", "\u0633\u0627\u062f\u0647 \u0686\u064a\u0646\u064a" },
            { "kok", "\u06a9\u0648\u0646\u06a9\u0627\u0646\u064a" },
            { "zh_Hant", "\u062f\u0648\u062f\u064a\u0632\u0647 \u0686\u064a\u0646\u064a" },
            { "kpe", "\u06a9\u06cc\u0644\u064a" },
            { "type.nu.khmr", "\u062e\u0645\u0631\u064a \u0627\u0639\u062f\u0627\u062f" },
            { "ilo", "\u0627\u0644\u0648\u06a9\u0648" },
            { "mua", "\u0645\u0646\u062f\u0627\u0646\u06ab" },
            { "type.nu.guru", "\u06ab\u0631\u0645\u062e\u06d0 \u0627\u0639\u062f\u0627\u062f" },
            { "mul", "\u0645\u062a\u0639\u062f\u062f \u0698\u0628\u06d0" },
            { "key.ms", "\u062f \u0646\u0627\u067e \u0646\u0638\u0627\u0645" },
            { "mus", "\u06a9\u0631\u064a\u06a9\u064a" },
            { "gil", "\u06af\u0644\u0628\u0631\u062a\u064a" },
            { "type.nu.tamldec", "\u062a\u0627\u0645\u0644 \u0627\u0639\u062f\u0627\u062f" },
            { "krc", "\u06a9\u0631\u0627\u0686\u06cc \u0628\u0627\u0644\u06a9\u0631" },
            { "inh", "\u0627\u0646\u06af\u0634" },
            { "fa_AF", "\u062f\u0631\u06cc (\u0627\u0641\u063a\u0627\u0646\u0633\u062a\u0627\u0646)" },
            { "krl", "\u06a9\u0627\u0631\u06cc\u0644\u06cc\u0646" },
            { "efi", "\u0627\u0641\u06a9" },
            { "key.nu", "\u0634\u0645\u06d0\u0631\u06d0" },
            { "kru", "\u06a9\u0648\u0631\u062e" },
            { "ksb", "\u0634\u0645\u0628\u0627\u0644\u0627" },
            { "Telu", "\u062a\u06cc\u0644\u06cc\u06ab\u0648" },
            { "ksf", "\u0628\u0641\u06cc\u0627" },
        };
        return data;
    }
}
