/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_ro extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Ora de Greenwhich",
               "GMT",
               "",
               "",
               "",
               "",
            };
        final String[] Acre = new String[] {
               "Ora standard Acre",
               "",
               "Ora de var\u0103 Acre",
               "",
               "Ora Acre",
               "",
            };
        final String[] Apia = new String[] {
               "Ora standard din Apia",
               "",
               "Ora de var\u0103 din Apia",
               "",
               "Ora din Apia",
               "",
            };
        final String[] Cook = new String[] {
               "Ora standard a Insulelor Cook",
               "",
               "Ora de var\u0103 a Insulelor Cook",
               "",
               "Ora Insulelor Cook",
               "",
            };
        final String[] Cuba = new String[] {
               "Ora standard a Cubei",
               "",
               "Ora de var\u0103 a Cubei",
               "",
               "Ora Cubei",
               "",
            };
        final String[] Fiji = new String[] {
               "Ora standard din Fiji",
               "",
               "Ora de var\u0103 din Fiji",
               "",
               "Ora din Fiji",
               "",
            };
        final String[] Gulf = new String[] {
               "Ora standard a Golfului",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Ora standard din Hovd",
               "",
               "Ora de var\u0103 din Hovd",
               "",
               "Ora din Hovd",
               "",
            };
        final String[] Iran = new String[] {
               "Ora standard a Iranului",
               "",
               "Ora de var\u0103 a Iranului",
               "",
               "Ora Iranului",
               "",
            };
        final String[] Niue = new String[] {
               "Ora din Niue",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Ora standard din Omsk",
               "",
               "Ora de var\u0103 din Omsk",
               "",
               "Ora din Omsk",
               "",
            };
        final String[] Peru = new String[] {
               "Ora standard din Peru",
               "",
               "Ora de var\u0103 din Peru",
               "",
               "Ora din Peru",
               "",
            };
        final String[] Truk = new String[] {
               "Ora din Chuuk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Ora Insulei Wake",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Ora standard din Chile",
               "",
               "Ora de var\u0103 din Chile",
               "",
               "Ora din Chile",
               "",
            };
        final String[] China = new String[] {
               "Ora standard a Chinei",
               "",
               "Ora de var\u0103 a Chinei",
               "",
               "Ora Chinei",
               "",
            };
        final String[] Cocos = new String[] {
               "Ora Insulelor Cocos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Ora din Davis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Ora Indiei",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Japan = new String[] {
               "Ora standard a Japoniei",
               "",
               "Ora de var\u0103 a Japoniei",
               "",
               "Ora Japoniei",
               "",
            };
        final String[] Korea = new String[] {
               "Ora standard a Coreei",
               "",
               "Ora de var\u0103 a Coreei",
               "",
               "Ora Coreei",
               "",
            };
        final String[] Nauru = new String[] {
               "Ora din Nauru",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Ora Nepalului",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Ora din Palau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Ora standard din Samoa",
               "",
               "Ora de var\u0103 din Samoa",
               "",
               "Ora din Samoa",
               "",
            };
        final String[] Syowa = new String[] {
               "Ora din Syowa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Ora standard din Tonga",
               "",
               "Ora de var\u0103 din Tonga",
               "",
               "Ora din Tonga",
               "",
            };
        final String[] Alaska = new String[] {
               "Ora standard din Alaska",
               "",
               "Ora de var\u0103 din Alaska",
               "",
               "Ora din Alaska",
               "",
            };
        final String[] Amazon = new String[] {
               "Ora standard a Amazonului",
               "",
               "Ora de var\u0103 a Amazonului",
               "",
               "Ora Amazonului",
               "",
            };
        final String[] Anadyr = new String[] {
               "Ora standard din Anadyr",
               "",
               "Ora de var\u0103 din Anadyr",
               "",
               "Ora din Anadyr",
               "",
            };
        final String[] Azores = new String[] {
               "Ora standard din Azore",
               "",
               "Ora de var\u0103 din Azore",
               "",
               "Ora din Azore",
               "",
            };
        final String[] Bhutan = new String[] {
               "Ora Bhutanului",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Ora din Brunei Darussalam",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Ora standard din Insula Pa\u0219telui",
               "",
               "Ora de var\u0103 din Insula Pa\u0219telui",
               "",
               "Ora din Insula Pa\u0219telui",
               "",
            };
        final String[] Guyana = new String[] {
               "Ora din Guyana",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Ora standard a Israelului",
               "",
               "Ora de var\u0103 a Israelului",
               "",
               "Ora Israelului",
               "",
            };
        final String[] Kosrae = new String[] {
               "Ora din Kosrae",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Ora din Mawson",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Ora standard a Moscovei",
               "",
               "Ora de var\u0103 a Moscovei",
               "",
               "Ora Moscovei",
               "",
            };
        final String[] Ponape = new String[] {
               "Ora din Ponape",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "Ora standard din Samara",
               "",
               "Ora de var\u0103 din Samara",
               "",
               "Ora din Samara",
               "",
            };
        final String[] Tahiti = new String[] {
               "Ora din Tahiti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Ora standard din Taipei",
               "",
               "Ora de var\u0103 din Taipei",
               "",
               "Ora din Taipei",
               "",
            };
        final String[] Tuvalu = new String[] {
               "Ora din Tuvalu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Ora din Vostok",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Ora din Wallis \u0219i Futuna",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Ora standard arab\u0103",
               "",
               "Ora de var\u0103 arab\u0103",
               "",
               "Ora arab\u0103",
               "",
            };
        final String[] Armenia = new String[] {
               "Ora standard a Armeniei",
               "",
               "Ora de var\u0103 a Armeniei",
               "",
               "Ora Armeniei",
               "",
            };
        final String[] Bolivia = new String[] {
               "Ora Boliviei",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Ora standard din Chatham",
               "",
               "Ora de var\u0103 din Chatham",
               "",
               "Ora din Chatham",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Timpul universal coordonat",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Ora Ecuadorului",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Ora din Gambier",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Ora standard a Georgiei",
               "",
               "Ora de var\u0103 a Georgiei",
               "",
               "Ora Georgiei",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Ora standard din Irku\u021bk",
               "",
               "Ora de var\u0103 din Irku\u021bk",
               "",
               "Ora din Irku\u021bk",
               "",
            };
        final String[] Magadan = new String[] {
               "Ora standard din Magadan",
               "",
               "Ora de var\u0103 din Magadan",
               "",
               "Ora din Magadan",
               "",
            };
        final String[] Myanmar = new String[] {
               "Ora Myanmarului",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Ora standard Insulelor Norfolk",
               "",
               "Ora de var\u0103 Insulelor Norfolk",
               "",
               "Ora Insulelor Norfolk",
               "",
            };
        final String[] Noronha = new String[] {
               "Ora standard din Fernando de Noronha",
               "",
               "Ora de var\u0103 din Fernando de Noronha",
               "",
               "Ora din Fernando de Noronha",
               "",
            };
        final String[] Reunion = new String[] {
               "Ora din Reunion",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Ora din Rothera",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Ora Insulelor Solomon",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Ora din Tokelau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Ora standard a Uruguayului",
               "",
               "Ora de var\u0103 a Uruguayului",
               "",
               "Ora Uruguayului",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Ora standard din Vanuatu",
               "",
               "Ora de var\u0103 din Vanuatu",
               "",
               "Ora din Vanuatu",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Ora standard din Iaku\u021bk",
               "",
               "Ora de var\u0103 din Iaku\u021bk",
               "",
               "Ora din Iaku\u021bk",
               "",
            };
        final String[] Atlantic = new String[] {
               "Ora standard \u00een zona Atlantic nord-american\u0103",
               "",
               "Ora de var\u0103 \u00een zona Atlantic nord-american\u0103",
               "",
               "Ora zonei Atlantic nord-americane",
               "",
            };
        final String[] Brasilia = new String[] {
               "Ora standard a Brasiliei",
               "",
               "Ora de var\u0103 a Brasiliei",
               "",
               "Ora Brasiliei",
               "",
            };
        final String[] Chamorro = new String[] {
               "Ora din Chamorro",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Colombia = new String[] {
               "Ora standard a Columbiei",
               "",
               "Ora de var\u0103 a Columbiei",
               "",
               "Ora Columbiei",
               "",
            };
        final String[] Falkland = new String[] {
               "Ora standard din Insulele Falkland",
               "",
               "Ora de var\u0103 din Insulele Falkland",
               "",
               "Ora din Insulele Falkland",
               "",
            };
        final String[] Malaysia = new String[] {
               "Ora din Malaysia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Ora din Maldive",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Ora standard din Ulan Bator",
               "",
               "Ora de var\u0103 din Ulan Bator",
               "",
               "Ora din Ulan Bator",
               "",
            };
        final String[] Pakistan = new String[] {
               "Ora standard a Pakistanului",
               "",
               "Ora de var\u0103 a Pakistanului",
               "",
               "Ora Pakistanului",
               "",
            };
        final String[] Paraguay = new String[] {
               "Ora standard din Paraguay",
               "",
               "Ora de var\u0103 din Paraguay",
               "",
               "Ora din Paraguay",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Ora din Pitcairn",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Ora standard din Sahalin",
               "",
               "Ora de var\u0103 din Sahalin",
               "",
               "Ora din Sahalin",
               "",
            };
        final String[] Suriname = new String[] {
               "Ora Surinamului",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Ora standard a Argentinei",
               "",
               "Ora de var\u0103 a Argentinei",
               "",
               "Ora Argentinei",
               "",
            };
        final String[] Christmas = new String[] {
               "Ora din Insula Christmas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Ora din Galapagos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Ora standard din Hong Kong",
               "",
               "Ora de var\u0103 din Hong Kong",
               "",
               "Ora din Hong Kong",
               "",
            };
        final String[] Indochina = new String[] {
               "Ora Indochinei",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Ora standard din Petropavlovsk-Kamcia\u021bki",
               "",
               "Ora de var\u0103 din Petropavlovsk-Kamcia\u021bki",
               "",
               "Ora din Petropavlovsk-Kamcia\u021bki",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Ora din K\u00e2rg\u00e2zstan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Ora standard din Lord Howe",
               "",
               "Ora de var\u0103 din Lord Howe",
               "",
               "Ora din Lord Howe",
               "",
            };
        final String[] Macquarie = new String[] {
               "Ora din Macquarie",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Marquesas = new String[] {
               "Ora Insulelor Marchize",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Ora standard din Mauritius",
               "",
               "Ora de var\u0103 din Mauritius",
               "",
               "Ora din Mauritius",
               "",
            };
        final String[] Singapore = new String[] {
               "Ora din Singapore",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Ora Venezuelei",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Ora standard din Volgograd",
               "",
               "Ora de var\u0103 din Volgograd",
               "",
               "Ora din Volgograd",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "Ora standard a Azerbaidjanului",
               "",
               "Ora de var\u0103 a Azerbaidjanului",
               "",
               "Ora Azerbaidjanului",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Ora standard din Bangladesh",
               "",
               "Ora de var\u0103 din Bangladesh",
               "",
               "Ora din Bangladesh",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Ora standard din Capul Verde",
               "",
               "Ora de var\u0103 din Capul Verde",
               "",
               "Ora din Capul Verde",
               "",
            };
        final String[] East_Timor = new String[] {
               "Ora Timorului de Est",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Ora din Seychelles",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Ora din Tadjikistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Ora standard din Uzbekistan",
               "",
               "Ora de var\u0103 din Uzbekistan",
               "",
               "Ora din Uzbekistan",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Ora Afganistanului",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Ora standard din Krasnoiarsk",
               "",
               "Ora de var\u0103 din Krasnoiarsk",
               "",
               "Ora din Krasnoiarsk",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Ora standard a Noii Zeelande",
               "",
               "Ora de var\u0103 a Noii Zeelande",
               "",
               "Ora Noii Zeelande",
               "",
            };
        final String[] Novosibirsk = new String[] {
               "Ora standard din Novosibirsk",
               "",
               "Ora de var\u0103 din Novosibirsk",
               "",
               "Ora din Novosibirsk",
               "",
            };
        final String[] Philippines = new String[] {
               "Ora standard din Filipine",
               "",
               "Ora de var\u0103 din Filipine",
               "",
               "Ora din Filipine",
               "",
            };
        final String[] Vladivostok = new String[] {
               "Ora standard din Vladivostok",
               "",
               "Ora de var\u0103 din Vladivostok",
               "",
               "Ora din Vladivostok",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Ora Oceanului Indian",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Ora din Insulele Line",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Ora standard din Newfoundland",
               "",
               "Ora de var\u0103 din Newfoundland",
               "",
               "Ora din Newfoundland",
               "",
            };
        final String[] Turkmenistan = new String[] {
               "Ora standard din Turkmenistan",
               "",
               "Ora de var\u0103 din Turkmenistan",
               "",
               "Ora din Turkmenistan",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Ora din Guyana Francez\u0103",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Ora standard a Noii Caledonii",
               "",
               "Ora de var\u0103 a Noii Caledonii",
               "",
               "Ora Noii Caledonii",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Ora Georgiei de Sud",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Ora standard din Ekaterinburg",
               "",
               "Ora de var\u0103 din Ekaterinburg",
               "",
               "Ora din Ekaterinburg",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Ora Africii Centrale",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Africa_Eastern = new String[] {
               "Ora Africii Orientale",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Africa_Western = new String[] {
               "Ora standard a Africii Occidentale",
               "",
               "Ora de var\u0103 a Africii Occidentale",
               "",
               "Ora Africii Occidentale",
               "",
            };
        final String[] DumontDUrville = new String[] {
               "Ora din Dumont-d\u2019Urville",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Ora standard a Europei Centrale",
               "CET",
               "Ora de var\u0103 a Europei Centrale",
               "CEST",
               "Ora Europei Centrale",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Ora standard a Europei de Est",
               "EET",
               "Ora de var\u0103 a Europei de Est",
               "EEST",
               "Ora Europei de Est",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Ora standard a Europei de Vest",
               "WET",
               "Ora de var\u0103 a Europei de Vest",
               "WEST",
               "Ora Europei de Vest",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Ora standard a zonei Pacific mexicane",
               "",
               "Ora de var\u0103 a zonei Pacific mexicane",
               "",
               "Ora zonei Pacific mexicane",
               "",
            };
        final String[] Africa_Southern = new String[] {
               "Ora Africii Meridionale",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] America_Central = new String[] {
               "Ora standard central\u0103 nord-american\u0103",
               "",
               "Ora de var\u0103 central\u0103 nord-american\u0103",
               "",
               "Ora central\u0103 nord-american\u0103",
               "",
            };
        final String[] America_Eastern = new String[] {
               "Ora standard oriental\u0103 nord-american\u0103",
               "",
               "Ora de var\u0103 oriental\u0103 nord-american\u0103",
               "",
               "Ora oriental\u0103 nord-american\u0103",
               "",
            };
        final String[] America_Pacific = new String[] {
               "Ora standard \u00een zona Pacific nord-american\u0103",
               "",
               "Ora de var\u0103 \u00een zona Pacific nord-american\u0103",
               "",
               "Ora zonei Pacific nord-americane",
               "",
            };
        final String[] French_Southern = new String[] {
               "Ora din Teritoriile Australe \u0219i Antarctice Franceze",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Ora Insulelor Gilbert",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Ora standard din Hawaii-Aleutine",
               "",
               "Ora de var\u0103 din Hawaii-Aleutine",
               "",
               "Ora din Hawaii-Aleutine",
               "",
            };
        final String[] Phoenix_Islands = new String[] {
               "Ora Insulelor Phoenix",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Ora standard din Saint-Pierre \u0219i Miquelon",
               "",
               "Ora de var\u0103 din Saint-Pierre \u0219i Miquelon",
               "",
               "Ora din Saint-Pierre \u0219i Miquelon",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Ora standard \u00een zona montan\u0103 nord-american\u0103",
               "",
               "Ora de var\u0103 \u00een zona montan\u0103 nord-american\u0103",
               "",
               "Ora zonei montane nord-americane",
               "",
            };
        final String[] Marshall_Islands = new String[] {
               "Ora Insulelor Marshall",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mexico_Northwest = new String[] {
               "Ora standard a Mexicului de nord-vest",
               "",
               "Ora de var\u0103 a Mexicului de nord-vest",
               "",
               "Ora Mexicului de nord-vest",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Ora din Papua Noua Guinee",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Ora standard a Australiei Centrale",
               "",
               "Ora de var\u0103 a Australiei Centrale",
               "",
               "Ora Australiei Centrale",
               "",
            };
        final String[] Australia_Eastern = new String[] {
               "Ora standard a Australiei Orientale",
               "",
               "Ora de var\u0103 a Australiei Orientale",
               "",
               "Ora Australiei Orientale",
               "",
            };
        final String[] Australia_Western = new String[] {
               "Ora standard a Australiei Occidentale",
               "",
               "Ora de var\u0103 a Australiei Occidentale",
               "",
               "Ora Australiei Occidentale",
               "",
            };
        final String[] Greenland_Eastern = new String[] {
               "Ora standard a Groenlandei orientale",
               "",
               "Ora de var\u0103 a Groenlandei orientale",
               "",
               "Ora Groenlandei orientale",
               "",
            };
        final String[] Greenland_Western = new String[] {
               "Ora standard a Groenlandei occidentale",
               "",
               "Ora de var\u0103 a Groenlandei occidentale",
               "",
               "Ora Groenlandei occidentale",
               "",
            };
        final String[] Indonesia_Central = new String[] {
               "Ora Indoneziei Centrale",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Ora Indoneziei de Est",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Indonesia_Western = new String[] {
               "Ora Indoneziei de Vest",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Ora din Kazahstanul de Est",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Ora din Kazahstanul de Vest",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Ora standard a Australiei Central Occidentale",
               "",
               "Ora de var\u0103 a Australiei Central Occidentale",
               "",
               "Ora Australiei Central Occidentale",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "JST", Japan },
            { "MIT", Apia },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "SST", Solomon },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UTC", ETC_UTC },
            { "MST7MDT", America_Mountain },
            { "PST8PDT", America_Pacific },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan_Western },
            { "Asia/Amman", Europe_Eastern },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Africa/Juba", Africa_Eastern },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Anadyr", Anadyr },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Truk },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kuching", Malaysia },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Damascus", Europe_Eastern },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan_Eastern },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Ust-Nera", Vladivostok },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Ora de Greenwhich",
                    "GMT",
                    "Ora de var\u0103 a Irlandei",
                    "",
                    "",
                    "",
                }
            },
            { "Europe/Jersey", GMT },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Ora de Greenwhich",
                    "GMT",
                    "Ora de var\u0103 britanic\u0103",
                    "",
                    "",
                    "",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", America_Pacific },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "Asia/Chongqing", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan_Western },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Ora de Greenwhich",
                    "GMT",
                    "Ora de var\u0103 britanic\u0103",
                    "",
                    "",
                    "",
                }
            },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Pacific/Easter", Easter },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Ponape },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Pacific/Wallis", Wallis },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Godthab", Greenland_Western },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Mountain },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/Perth", Australia_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey", GMT },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", Maldives },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", America_Pacific },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Europe/Isle_of_Man", GMT },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Antarctica/Macquarie", Macquarie },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "Aden" },
            { "timezone.excity.Asia/Baku", "Baku" },
            { "timezone.excity.Asia/Dili", "Dili" },
            { "timezone.excity.Asia/Gaza", "Gaza" },
            { "timezone.excity.Asia/Hovd", "Hovd" },
            { "timezone.excity.Asia/Omsk", "Omsk" },
            { "timezone.excity.Asia/Oral", "Uralsk" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "Amman" },
            { "timezone.excity.Asia/Aqtau", "Aktau" },
            { "timezone.excity.Asia/Chita", "Cita" },
            { "timezone.excity.Asia/Dhaka", "Dacca" },
            { "timezone.excity.Asia/Dubai", "Dubai" },
            { "timezone.excity.Asia/Kabul", "Kabul" },
            { "timezone.excity.Asia/Qatar", "Qatar" },
            { "timezone.excity.Asia/Seoul", "Seoul" },
            { "timezone.excity.Asia/Tokyo", "Tokyo" },
            { "timezone.excity.Asia/Tomsk", "Tomsk" },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "Juba" },
            { "timezone.excity.Africa/Lome", "Lome" },
            { "timezone.excity.Asia/Almaty", "Almat\u00ee" },
            { "timezone.excity.Asia/Anadyr", "Anadir" },
            { "timezone.excity.Asia/Aqtobe", "Aktobe" },
            { "timezone.excity.Asia/Atyrau", "At\u00eerau" },
            { "timezone.excity.Asia/Beirut", "Beirut" },
            { "timezone.excity.Asia/Brunei", "Brunei" },
            { "timezone.excity.Asia/Hebron", "Hebron" },
            { "timezone.excity.Asia/Kuwait", "Kuweit" },
            { "timezone.excity.Asia/Manila", "Manila" },
            { "timezone.excity.Asia/Muscat", "Muscat" },
            { "timezone.excity.Asia/Riyadh", "Riad" },
            { "timezone.excity.Asia/Saigon", "Ho \u0218i Min" },
            { "timezone.excity.Asia/Taipei", "Taipei" },
            { "timezone.excity.Asia/Tehran", "Teheran" },
            { "timezone.excity.Asia/Urumqi", "Urumqi" },
            { "timezone.excity.Etc/Unknown", "Ora\u0219 necunoscut" },
            { "timezone.excity.Europe/Kiev", "Kiev" },
            { "timezone.excity.Europe/Oslo", "Oslo" },
            { "timezone.excity.Europe/Riga", "Riga" },
            { "timezone.excity.Europe/Rome", "Roma" },
            { "timezone.excity.Indian/Mahe", "Mahe" },
            { "timezone.excity.Africa/Accra", "Accra" },
            { "timezone.excity.Africa/Cairo", "Cairo" },
            { "timezone.excity.Africa/Ceuta", "Ceuta" },
            { "timezone.excity.Africa/Dakar", "Dakar" },
            { "timezone.excity.Africa/Lagos", "Lagos" },
            { "timezone.excity.Africa/Tunis", "Tunis" },
            { "timezone.excity.America/Adak", "Adak" },
            { "timezone.excity.America/Lima", "Lima" },
            { "timezone.excity.America/Nome", "Nome" },
            { "timezone.excity.Asia/Baghdad", "Bagdad" },
            { "timezone.excity.Asia/Bahrain", "Bahrain" },
            { "timezone.excity.Asia/Bangkok", "Bangkok" },
            { "timezone.excity.Asia/Barnaul", "Barnaul" },
            { "timezone.excity.Asia/Bishkek", "Bi\u0219kek" },
            { "timezone.excity.Asia/Colombo", "Colombo" },
            { "timezone.excity.Asia/Irkutsk", "Irku\u021bk" },
            { "timezone.excity.Asia/Jakarta", "Jakarta" },
            { "timezone.excity.Asia/Karachi", "Karachi" },
            { "timezone.excity.Asia/Kuching", "Kuching" },
            { "timezone.excity.Asia/Magadan", "Magadan" },
            { "timezone.excity.Asia/Nicosia", "Nicosia" },
            { "timezone.excity.Asia/Tbilisi", "Tbilisi" },
            { "timezone.excity.Asia/Thimphu", "Thimphu" },
            { "timezone.excity.Asia/Yakutsk", "Iaku\u021bk" },
            { "timezone.excity.Asia/Yerevan", "Erevan" },
            { "timezone.excity.Europe/Kirov", "Kirov" },
            { "timezone.excity.Europe/Malta", "Malta" },
            { "timezone.excity.Europe/Minsk", "Minsk" },
            { "timezone.excity.Europe/Paris", "Paris" },
            { "timezone.excity.Europe/Sofia", "Sofia" },
            { "timezone.excity.Europe/Vaduz", "Vaduz" },
            { "timezone.excity.Indian/Cocos", "Cocos" },
            { "timezone.excity.Pacific/Apia", "Apia" },
            { "timezone.excity.Pacific/Fiji", "Fiji" },
            { "timezone.excity.Pacific/Guam", "Guam" },
            { "timezone.excity.Pacific/Niue", "Niue" },
            { "timezone.excity.Pacific/Wake", "Wake" },
            { "timezone.excity.Africa/Bamako", "Bamako" },
            { "timezone.excity.Africa/Bangui", "Bangui" },
            { "timezone.excity.Africa/Banjul", "Banjul" },
            { "timezone.excity.Africa/Bissau", "Bissau" },
            { "timezone.excity.Africa/Douala", "Douala" },
            { "timezone.excity.Africa/Harare", "Harare" },
            { "timezone.excity.Africa/Kigali", "Kigali" },
            { "timezone.excity.Africa/Luanda", "Luanda" },
            { "timezone.excity.Africa/Lusaka", "Lusaka" },
            { "timezone.excity.Africa/Malabo", "Malabo" },
            { "timezone.excity.Africa/Maputo", "Maputo" },
            { "timezone.excity.Africa/Maseru", "Maseru" },
            { "timezone.excity.Africa/Niamey", "Niamey" },
            { "timezone.excity.America/Aruba", "Aruba" },
            { "timezone.excity.America/Bahia", "Bahia" },
            { "timezone.excity.America/Belem", "Belem" },
            { "timezone.excity.America/Boise", "Boise" },
            { "timezone.excity.America/Jujuy", "Jujuy" },
            { "timezone.excity.America/Sitka", "Sitka" },
            { "timezone.excity.America/Thule", "Thule" },
            { "timezone.excity.Asia/Ashgabat", "A\u0219gabat" },
            { "timezone.excity.Asia/Calcutta", "Calcutta" },
            { "timezone.excity.Asia/Damascus", "Damasc" },
            { "timezone.excity.Asia/Dushanbe", "Du\u0219anbe" },
            { "timezone.excity.Asia/Jayapura", "Jayapura" },
            { "timezone.excity.Asia/Khandyga", "Khandyga" },
            { "timezone.excity.Asia/Makassar", "Makassar" },
            { "timezone.excity.Asia/Qostanay", "Kostanay" },
            { "timezone.excity.Asia/Sakhalin", "Sahalin" },
            { "timezone.excity.Asia/Shanghai", "Shanghai" },
            { "timezone.excity.Asia/Tashkent", "Ta\u0219kent" },
            { "timezone.excity.Asia/Ust-Nera", "Ust-Nera" },
            { "timezone.excity.Europe/Athens", "Atena" },
            { "timezone.excity.Europe/Berlin", "Berlin" },
            { "timezone.excity.Europe/Dublin", "Dublin" },
            { "timezone.excity.Europe/Jersey", "Jersey" },
            { "timezone.excity.Europe/Lisbon", "Lisabona" },
            { "timezone.excity.Europe/London", "Londra" },
            { "timezone.excity.Europe/Madrid", "Madrid" },
            { "timezone.excity.Europe/Monaco", "Monaco" },
            { "timezone.excity.Europe/Moscow", "Moscova" },
            { "timezone.excity.Europe/Prague", "Praga" },
            { "timezone.excity.Europe/Samara", "Samara" },
            { "timezone.excity.Europe/Skopje", "Skopje" },
            { "timezone.excity.Europe/Tirane", "Tirana" },
            { "timezone.excity.Europe/Vienna", "Viena" },
            { "timezone.excity.Europe/Warsaw", "Var\u0219ovia" },
            { "timezone.excity.Europe/Zagreb", "Zagreb" },
            { "timezone.excity.Europe/Zurich", "Z\u00fcrich" },
            { "timezone.excity.Indian/Chagos", "Chagos" },
            { "timezone.excity.Indian/Comoro", "Comore" },
            { "timezone.excity.Pacific/Efate", "Efate" },
            { "timezone.excity.Pacific/Nauru", "Nauru" },
            { "timezone.excity.Pacific/Palau", "Palau" },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "Abidjan" },
            { "timezone.excity.Africa/Algiers", "Alger" },
            { "timezone.excity.Africa/Conakry", "Conakry" },
            { "timezone.excity.Africa/Kampala", "Kampala" },
            { "timezone.excity.Africa/Mbabane", "Mbabane" },
            { "timezone.excity.Africa/Nairobi", "Nairobi" },
            { "timezone.excity.Africa/Tripoli", "Tripoli" },
            { "timezone.excity.America/Belize", "Belize" },
            { "timezone.excity.America/Bogota", "Bogota" },
            { "timezone.excity.America/Cancun", "Cancun" },
            { "timezone.excity.America/Cayman", "Cayman" },
            { "timezone.excity.America/Cuiaba", "Cuiaba" },
            { "timezone.excity.America/Dawson", "Dawson" },
            { "timezone.excity.America/Denver", "Denver" },
            { "timezone.excity.America/Guyana", "Guyana" },
            { "timezone.excity.America/Havana", "Havana" },
            { "timezone.excity.America/Inuvik", "Inuvik" },
            { "timezone.excity.America/Juneau", "Juneau" },
            { "timezone.excity.America/La_Paz", "La Paz" },
            { "timezone.excity.America/Maceio", "Maceio" },
            { "timezone.excity.America/Manaus", "Manaus" },
            { "timezone.excity.America/Merida", "Merida" },
            { "timezone.excity.America/Nassau", "Nassau" },
            { "timezone.excity.America/Panama", "Panama" },
            { "timezone.excity.America/Recife", "Recife" },
            { "timezone.excity.America/Regina", "Regina" },
            { "timezone.excity.Asia/Famagusta", "Famagusta" },
            { "timezone.excity.Asia/Hong_Kong", "Hong Kong" },
            { "timezone.excity.Asia/Jerusalem", "Ierusalim" },
            { "timezone.excity.Asia/Kamchatka", "Kamciatka" },
            { "timezone.excity.Asia/Pontianak", "Pontianak" },
            { "timezone.excity.Asia/Pyongyang", "Phenian" },
            { "timezone.excity.Asia/Qyzylorda", "Kyzylorda" },
            { "timezone.excity.Asia/Samarkand", "Samarkand" },
            { "timezone.excity.Asia/Singapore", "Singapore" },
            { "timezone.excity.Asia/Vientiane", "Vientiane" },
            { "timezone.excity.Europe/Andorra", "Andorra" },
            { "timezone.excity.Europe/Saratov", "Saratov" },
            { "timezone.excity.Europe/Tallinn", "Tallinn" },
            { "timezone.excity.Europe/Vatican", "Vatican" },
            { "timezone.excity.Europe/Vilnius", "Vilnius" },
            { "timezone.excity.Indian/Mayotte", "Mayotte" },
            { "timezone.excity.Indian/Reunion", "R\u00e9union" },
            { "timezone.excity.Pacific/Easter", "Insula Pa\u0219telui" },
            { "timezone.excity.Pacific/Kosrae", "Kosrae" },
            { "timezone.excity.Pacific/Majuro", "Majuro" },
            { "timezone.excity.Pacific/Midway", "Midway" },
            { "timezone.excity.Pacific/Noumea", "Noumea" },
            { "timezone.excity.Pacific/Saipan", "Saipan" },
            { "timezone.excity.Pacific/Tahiti", "Tahiti" },
            { "timezone.excity.Pacific/Tarawa", "Tarawa" },
            { "timezone.excity.Pacific/Wallis", "Wallis" },
            { "timezone.excity.Africa/Blantyre", "Blantyre" },
            { "timezone.excity.Africa/Djibouti", "Djibouti" },
            { "timezone.excity.Africa/El_Aaiun", "El Aaiun" },
            { "timezone.excity.Africa/Freetown", "Freetown" },
            { "timezone.excity.Africa/Gaborone", "Gaborone" },
            { "timezone.excity.Africa/Khartoum", "Khartoum" },
            { "timezone.excity.Africa/Kinshasa", "Kinshasa" },
            { "timezone.excity.Africa/Monrovia", "Monrovia" },
            { "timezone.excity.Africa/Ndjamena", "N\u2019Djamena" },
            { "timezone.excity.Africa/Sao_Tome", "Sao Tom\u00e9" },
            { "timezone.excity.Africa/Windhoek", "Windhoek" },
            { "timezone.excity.America/Antigua", "Antigua" },
            { "timezone.excity.America/Caracas", "Caracas" },
            { "timezone.excity.America/Cayenne", "Cayenne" },
            { "timezone.excity.America/Chicago", "Chicago" },
            { "timezone.excity.America/Cordoba", "Cordoba" },
            { "timezone.excity.America/Creston", "Creston" },
            { "timezone.excity.America/Curacao", "Cura\u00e7ao" },
            { "timezone.excity.America/Detroit", "Detroit" },
            { "timezone.excity.America/Grenada", "Grenada" },
            { "timezone.excity.America/Halifax", "Halifax" },
            { "timezone.excity.America/Iqaluit", "Iqaluit" },
            { "timezone.excity.America/Jamaica", "Jamaica" },
            { "timezone.excity.America/Managua", "Managua" },
            { "timezone.excity.America/Marigot", "Marigot" },
            { "timezone.excity.America/Mendoza", "Mendoza" },
            { "timezone.excity.America/Moncton", "Moncton" },
            { "timezone.excity.America/Nipigon", "Nipigon" },
            { "timezone.excity.America/Noronha", "Noronha" },
            { "timezone.excity.America/Ojinaga", "Ojinaga" },
            { "timezone.excity.America/Phoenix", "Phoenix" },
            { "timezone.excity.America/Tijuana", "Tijuana" },
            { "timezone.excity.America/Toronto", "Toronto" },
            { "timezone.excity.America/Tortola", "Tortola" },
            { "timezone.excity.America/Yakutat", "Yakutat" },
            { "timezone.excity.Asia/Choibalsan", "Choibalsan" },
            { "timezone.excity.Asia/Phnom_Penh", "Phnom Penh" },
            { "timezone.excity.Atlantic/Azores", "Azore" },
            { "timezone.excity.Atlantic/Canary", "Canare" },
            { "timezone.excity.Australia/Eucla", "Eucla" },
            { "timezone.excity.Australia/Perth", "Perth" },
            { "timezone.excity.Europe/Belgrade", "Belgrad" },
            { "timezone.excity.Europe/Brussels", "Bruxelles" },
            { "timezone.excity.Europe/Budapest", "Budapesta" },
            { "timezone.excity.Europe/Busingen", "Busingen" },
            { "timezone.excity.Europe/Chisinau", "Chi\u0219in\u0103u" },
            { "timezone.excity.Europe/Guernsey", "Guernsey" },
            { "timezone.excity.Europe/Helsinki", "Helsinki" },
            { "timezone.excity.Europe/Istanbul", "Istanbul" },
            { "timezone.excity.Europe/Sarajevo", "Sarajevo" },
            { "timezone.excity.Europe/Uzhgorod", "Ujhorod" },
            { "timezone.excity.Indian/Maldives", "Maldive" },
            { "timezone.excity.Pacific/Chatham", "Chatham" },
            { "timezone.excity.Pacific/Fakaofo", "Fakaofo" },
            { "timezone.excity.Pacific/Gambier", "Gambier" },
            { "timezone.excity.Pacific/Norfolk", "Norfolk" },
            { "timezone.excity.Africa/Bujumbura", "Bujumbura" },
            { "timezone.excity.Africa/Mogadishu", "Mogadiscio" },
            { "timezone.excity.America/Anguilla", "Anguilla" },
            { "timezone.excity.America/Asuncion", "Asunci\u00f3n" },
            { "timezone.excity.America/Barbados", "Barbados" },
            { "timezone.excity.America/Dominica", "Dominica" },
            { "timezone.excity.America/Edmonton", "Edmonton" },
            { "timezone.excity.America/Eirunepe", "Eirunepe" },
            { "timezone.excity.America/Mazatlan", "Mazatlan" },
            { "timezone.excity.America/Miquelon", "Miquelon" },
            { "timezone.excity.America/New_York", "New York" },
            { "timezone.excity.America/Resolute", "Resolute" },
            { "timezone.excity.America/Santarem", "Santarem" },
            { "timezone.excity.America/Santiago", "Santiago" },
            { "timezone.excity.America/Winnipeg", "Winnipeg" },
            { "timezone.excity.Antarctica/Casey", "Casey" },
            { "timezone.excity.Antarctica/Davis", "Davis" },
            { "timezone.excity.Antarctica/Syowa", "Showa" },
            { "timezone.excity.Antarctica/Troll", "Troll" },
            { "timezone.excity.Asia/Krasnoyarsk", "Krasnoiarsk" },
            { "timezone.excity.Asia/Novosibirsk", "Novosibirsk" },
            { "timezone.excity.Asia/Ulaanbaatar", "Ulan Bator" },
            { "timezone.excity.Asia/Vladivostok", "Vladivostok" },
            { "timezone.excity.Atlantic/Bermuda", "Bermuda" },
            { "timezone.excity.Atlantic/Madeira", "Madeira" },
            { "timezone.excity.Atlantic/Stanley", "Stanley" },
            { "timezone.excity.Australia/Currie", "Currie" },
            { "timezone.excity.Australia/Darwin", "Darwin" },
            { "timezone.excity.Australia/Hobart", "Hobart" },
            { "timezone.excity.Australia/Sydney", "Sydney" },
            { "timezone.excity.Europe/Amsterdam", "Amsterdam" },
            { "timezone.excity.Europe/Astrakhan", "Astrahan" },
            { "timezone.excity.Europe/Bucharest", "Bucure\u0219ti" },
            { "timezone.excity.Europe/Gibraltar", "Gibraltar" },
            { "timezone.excity.Europe/Ljubljana", "Ljubljana" },
            { "timezone.excity.Europe/Mariehamn", "Mariehamn" },
            { "timezone.excity.Europe/Podgorica", "Podgorica" },
            { "timezone.excity.Europe/Stockholm", "Stockholm" },
            { "timezone.excity.Europe/Ulyanovsk", "Ulianovsk" },
            { "timezone.excity.Europe/Volgograd", "Volgograd" },
            { "timezone.excity.Indian/Christmas", "Christmas" },
            { "timezone.excity.Indian/Kerguelen", "Kerguelen" },
            { "timezone.excity.Indian/Mauritius", "Mauritius" },
            { "timezone.excity.Pacific/Auckland", "Auckland" },
            { "timezone.excity.Pacific/Funafuti", "Funafuti" },
            { "timezone.excity.Pacific/Honolulu", "Honolulu" },
            { "timezone.excity.Pacific/Johnston", "Johnston" },
            { "timezone.excity.Pacific/Pitcairn", "Insula Pitcairn" },
            { "timezone.excity.Africa/Casablanca", "Casablanca" },
            { "timezone.excity.Africa/Libreville", "Libreville" },
            { "timezone.excity.Africa/Lubumbashi", "Lubumbashi" },
            { "timezone.excity.Africa/Nouakchott", "Nouakchott" },
            { "timezone.excity.Africa/Porto-Novo", "Porto-Novo" },
            { "timezone.excity.America/Anchorage", "Anchorage" },
            { "timezone.excity.America/Araguaina", "Araguaina" },
            { "timezone.excity.America/Boa_Vista", "Boa Vista" },
            { "timezone.excity.America/Catamarca", "Catamarca" },
            { "timezone.excity.America/Chihuahua", "Chihuahua" },
            { "timezone.excity.America/Fortaleza", "Fortaleza" },
            { "timezone.excity.America/Glace_Bay", "Glace Bay" },
            { "timezone.excity.America/Goose_Bay", "Goose Bay" },
            { "timezone.excity.America/Guatemala", "Guatemala" },
            { "timezone.excity.America/Guayaquil", "Guayaquil" },
            { "timezone.excity.America/Matamoros", "Matamoros" },
            { "timezone.excity.America/Menominee", "Menominee" },
            { "timezone.excity.America/Monterrey", "Monterrey" },
            { "timezone.excity.America/Sao_Paulo", "Sao Paulo" },
            { "timezone.excity.America/Vancouver", "Vancouver" },
            { "timezone.excity.Antarctica/Mawson", "Mawson" },
            { "timezone.excity.Antarctica/Palmer", "Palmer" },
            { "timezone.excity.Antarctica/Vostok", "Vostok" },
            { "timezone.excity.Asia/Kuala_Lumpur", "Kuala Lumpur" },
            { "timezone.excity.Asia/Novokuznetsk", "Novokuzne\u021bk" },
            { "timezone.excity.Europe/Bratislava", "Bratislava" },
            { "timezone.excity.Europe/Copenhagen", "Copenhaga" },
            { "timezone.excity.Europe/Luxembourg", "Luxemburg" },
            { "timezone.excity.Europe/San_Marino", "San Marino" },
            { "timezone.excity.Europe/Simferopol", "Simferopol" },
            { "timezone.excity.Europe/Zaporozhye", "Zaporoje" },
            { "timezone.excity.Pacific/Enderbury", "Enderbury" },
            { "timezone.excity.Pacific/Galapagos", "Galapagos" },
            { "timezone.excity.Pacific/Kwajalein", "Kwajalein" },
            { "timezone.excity.Pacific/Marquesas", "Marchize" },
            { "timezone.excity.Pacific/Pago_Pago", "Pago Pago" },
            { "timezone.excity.Pacific/Rarotonga", "Rarotonga" },
            { "timezone.excity.Pacific/Tongatapu", "Tongatapu" },
            { "timezone.excity.Africa/Addis_Ababa", "Addis Abeba" },
            { "timezone.excity.Africa/Brazzaville", "Brazzaville" },
            { "timezone.excity.Africa/Ouagadougou", "Ouagadougou" },
            { "timezone.excity.America/Costa_Rica", "Costa Rica" },
            { "timezone.excity.America/Grand_Turk", "Grand Turk" },
            { "timezone.excity.America/Guadeloupe", "Guadelupa" },
            { "timezone.excity.America/Hermosillo", "Hermosillo" },
            { "timezone.excity.America/Kralendijk", "Kralendijk" },
            { "timezone.excity.America/Louisville", "Louisville" },
            { "timezone.excity.America/Martinique", "Martinica" },
            { "timezone.excity.America/Metlakatla", "Metlakatla" },
            { "timezone.excity.America/Montevideo", "Montevideo" },
            { "timezone.excity.America/Montserrat", "Montserrat" },
            { "timezone.excity.America/Paramaribo", "Paramaribo" },
            { "timezone.excity.America/Rio_Branco", "Rio Branco" },
            { "timezone.excity.America/Whitehorse", "Whitehorse" },
            { "timezone.excity.Antarctica/McMurdo", "McMurdo" },
            { "timezone.excity.Antarctica/Rothera", "Rothera" },
            { "timezone.excity.Asia/Srednekolymsk", "Srednekolimsk" },
            { "timezone.excity.Asia/Yekaterinburg", "Ekaterinburg" },
            { "timezone.excity.Atlantic/Reykjavik", "Reykjavik" },
            { "timezone.excity.Atlantic/St_Helena", "Sf. Elena" },
            { "timezone.excity.Australia/Adelaide", "Adelaide" },
            { "timezone.excity.Australia/Brisbane", "Brisbane" },
            { "timezone.excity.Australia/Lindeman", "Lindeman" },
            { "timezone.excity.Europe/Isle_of_Man", "Insula Man" },
            { "timezone.excity.Europe/Kaliningrad", "Kaliningrad" },
            { "timezone.excity.Pacific/Kiritimati", "Kiritimati" },
            { "timezone.excity.Africa/Johannesburg", "Johannesburg" },
            { "timezone.excity.America/El_Salvador", "El Salvador" },
            { "timezone.excity.America/Fort_Nelson", "Fort Nelson" },
            { "timezone.excity.America/Los_Angeles", "Los Angeles" },
            { "timezone.excity.America/Mexico_City", "Ciudad de Mexico" },
            { "timezone.excity.America/Pangnirtung", "Pangnirtung" },
            { "timezone.excity.America/Porto_Velho", "Porto Velho" },
            { "timezone.excity.America/Puerto_Rico", "Puerto Rico" },
            { "timezone.excity.America/Rainy_River", "Rainy River" },
            { "timezone.excity.America/Tegucigalpa", "Tegucigalpa" },
            { "timezone.excity.America/Thunder_Bay", "Thunder Bay" },
            { "timezone.excity.America/Yellowknife", "Yellowknife" },
            { "timezone.excity.Arctic/Longyearbyen", "Longyearbyen" },
            { "timezone.excity.Atlantic/Cape_Verde", "Capul Verde" },
            { "timezone.excity.Australia/Lord_Howe", "Lord Howe" },
            { "timezone.excity.Australia/Melbourne", "Melbourne" },
            { "timezone.excity.Indian/Antananarivo", "Antananarivo" },
            { "timezone.excity.Pacific/Guadalcanal", "Guadalcanal" },
            { "timezone.excity.Africa/Dar_es_Salaam", "Dar es Salaam" },
            { "timezone.excity.America/Blanc-Sablon", "Blanc-Sablon" },
            { "timezone.excity.America/Buenos_Aires", "Buenos Aires" },
            { "timezone.excity.America/Campo_Grande", "Campo Grande" },
            { "timezone.excity.America/Danmarkshavn", "Danmarkshavn" },
            { "timezone.excity.America/Dawson_Creek", "Dawson Creek" },
            { "timezone.excity.America/Indianapolis", "Indianapolis" },
            { "timezone.excity.America/Punta_Arenas", "Punta Arenas" },
            { "timezone.excity.America/Rankin_Inlet", "Rankin Inlet" },
            { "timezone.excity.America/Santa_Isabel", "Santa Isabel" },
            { "timezone.excity.Antarctica/Macquarie", "Macquarie" },
            { "timezone.excity.Pacific/Bougainville", "Bougainville" },
            { "timezone.excity.Pacific/Port_Moresby", "Port Moresby" },
            { "timezone.excity.America/Cambridge_Bay", "Cambridge Bay" },
            { "timezone.excity.America/Port_of_Spain", "Port of Spain" },
            { "timezone.excity.America/Santo_Domingo", "Santo Domingo" },
            { "timezone.excity.America/St_Barthelemy", "Saint Barth\u00e9lemy" },
            { "timezone.excity.America/Swift_Current", "Swift Current" },
            { "timezone.excity.Australia/Broken_Hill", "Broken Hill" },
            { "timezone.excity.America/Bahia_Banderas", "Bahia Banderas" },
            { "timezone.excity.America/Port-au-Prince", "Port-au-Prince" },
            { "timezone.excity.Atlantic/South_Georgia", "Georgia de Sud" },
            { "timezone.excity.America/Argentina/Salta", "Salta" },
            { "timezone.excity.America/Argentina/Tucuman", "Tucuman" },
            { "timezone.excity.America/Argentina/Ushuaia", "Ushuaia" },
            { "timezone.excity.America/Argentina/La_Rioja", "La Rioja" },
            { "timezone.excity.America/Argentina/San_Juan", "San Juan" },
            { "timezone.excity.America/Argentina/San_Luis", "San Luis" },
            { "timezone.excity.America/North_Dakota/Beulah", "Beulah, Dakota de Nord" },
            { "timezone.excity.America/North_Dakota/Center", "Center, Dakota de Nord" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "Rio Gallegos" },
            { "timezone.excity.America/North_Dakota/New_Salem", "New Salem, Dakota de Nord" },
        };
        return data;
    }
}
