/*
 * Copyright (c) 2012, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2020 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_pl extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_gu = "gud\u017carati";
        final String metaValue_kn = "kannada";
        final String metaValue_ml = "malajalam";
        final String metaValue_or = "orija";
        final String metaValue_te = "telugu";
        final String metaValue_chr = "czirokeski";
        final String metaValue_nqo = "n\u2019ko";
        final String metaValue_phn = "fenicki";
        final String metaValue_syr = "syryjski";
        final Object[][] data = new Object[][] {
            { "ksh", "gwara kolo\u0144ska" },
            { "Ogam", "ogham" },
            { "mwl", "mirandyjski" },
            { "Zsym", "symbole" },
            { "cch", "atsam" },
            { "mwr", "marwari" },
            { "egl", "emilijski" },
            { "mwv", "mentawai" },
            { "Tagb", "tagbanwa" },
            { "Zsye", "emoji" },
            { "%%NJIVA", "dialekt Gniva/Njiva" },
            { "xmf", "megrelski" },
            { "ccp", "czakma" },
            { "egy", "staroegipski" },
            { "raj", "rad\u017aasthani" },
            { "Phag", "phags-pa" },
            { "tem", "temne" },
            { "teo", "ateso" },
            { "rap", "rapanui" },
            { "ter", "tereno" },
            { "AC", "Wyspa Wniebowst\u0105pienia" },
            { "rar", "rarotonga" },
            { "tet", "tetum" },
            { "AD", "Andora" },
            { "AE", "Zjednoczone Emiraty Arabskie" },
            { "nl_BE", "flamandzki" },
            { "AF", "Afganistan" },
            { "AG", "Antigua i Barbuda" },
            { "type.ca.ethiopic", "kalendarz etiopski" },
            { "glk", "gilia\u0144ski" },
            { "AI", "Anguilla" },
            { "key.tz", "strefa czasowa" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "Teng", "tengwar" },
            { "AO", "Angola" },
            { "AQ", "Antarktyda" },
            { "AR", "Argentyna" },
            { "Prti", "partyjski inskrypcyjny" },
            { "AS", "Samoa Ameryka\u0144skie" },
            { "AT", "Austria" },
            { "AU", "Australia" },
            { "AW", "Aruba" },
            { "en_US", "angielski ameryka\u0144ski" },
            { "AX", "Wyspy Alandzkie" },
            { "mye", "myene" },
            { "AZ", "Azerbejd\u017can" },
            { "%%AREVELA", "ormia\u0144ski wchodni" },
            { "BA", "Bo\u015bnia i Hercegowina" },
            { "BB", "Barbados" },
            { "ceb", "cebua\u0144ski" },
            { "BD", "Bangladesz" },
            { "kum", "kumycki" },
            { "BE", "Belgia" },
            { "gmh", "\u015brednio-wysoko-niemiecki" },
            { "BF", "Burkina Faso" },
            { "BG", "Bu\u0142garia" },
            { "BH", "Bahrajn" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Saint-Barth\u00e9lemy" },
            { "BM", "Bermudy" },
            { "kut", "kutenai" },
            { "myv", "erzja" },
            { "BN", "Brunei" },
            { "BO", "Boliwia" },
            { "BQ", "Niderlandy Karaibskie" },
            { "BR", "Brazylia" },
            { "BS", "Bahamy" },
            { "xog", "soga" },
            { "BT", "Bhutan" },
            { "BV", "Wyspa Bouveta" },
            { "BW", "Botswana" },
            { "BY", "Bia\u0142oru\u015b" },
            { "BZ", "Belize" },
            { "Visp", "Visible Speech" },
            { "type.ca.persian", "kalendarz perski" },
            { "type.nu.hebr", "cyfry hebrajskie" },
            { "CA", "Kanada" },
            { "CC", "Wyspy Kokosowe" },
            { "mzn", "mazandera\u0144ski" },
            { "CD", "Demokratyczna Republika Konga" },
            { "CF", "Republika \u015arodkowoafryka\u0144ska" },
            { "CG", "Kongo" },
            { "CH", "Szwajcaria" },
            { "CI", "C\u00f4te d\u2019Ivoire" },
            { "CK", "Wyspy Cooka" },
            { "CL", "Chile" },
            { "Kthi", "kaithi" },
            { "CM", "Kamerun" },
            { "CN", "Chiny" },
            { "CO", "Kolumbia" },
            { "CP", "Wyspa Clippertona" },
            { "CR", "Kostaryka" },
            { "CU", "Kuba" },
            { "CV", "Republika Zielonego Przyl\u0105dka" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Wyspa Bo\u017cego Narodzenia" },
            { "CY", "Cypr" },
            { "CZ", "Czechy" },
            { "eka", "ekajuk" },
            { "vls", "zachodnioflamandzki" },
            { "DE", "Niemcy" },
            { "goh", "staro-wysoko-niemiecki" },
            { "ace", "aceh" },
            { "cgg", "chiga" },
            { "DG", "Diego Garcia" },
            { "gom", "konkani (Goa)" },
            { "type.nu.deva", "cyfry dewanagari" },
            { "DJ", "D\u017cibuti" },
            { "DK", "Dania" },
            { "ach", "aczoli" },
            { "gon", "gondi" },
            { "Brai", "Braille\u2019a" },
            { "Brah", "brahmi" },
            { "DM", "Dominika" },
            { "type.nu.armnlow", "cyfry ormia\u0144skie (ma\u0142e litery)" },
            { "DO", "Dominikana" },
            { "gor", "gorontalo" },
            { "got", "gocki" },
            { "vmf", "me\u0144ski franko\u0144ski" },
            { "Mtei", "meitei mayek" },
            { "zun", "zuni" },
            { "tig", "tigre" },
            { "DZ", "Algieria" },
            { "pag", "pangasinan" },
            { "type.d0.hwidth", "po\u0142owa szeroko\u015bci" },
            { "pal", "pahlavi" },
            { "EA", "Ceuta i Melilla" },
            { "chb", "czibcza" },
            { "pam", "pampango" },
            { "EC", "Ekwador" },
            { "pap", "papiamento" },
            { "ada", "adangme" },
            { "EE", "Estonia" },
            { "tiv", "tiw" },
            { "EG", "Egipt" },
            { "EH", "Sahara Zachodnia" },
            { "chg", "czagatajski" },
            { "pau", "palau" },
            { "chk", "chuuk" },
            { "chn", "\u017cargon czinucki" },
            { "chm", "maryjski" },
            { "chp", "czipewia\u0144ski" },
            { "cho", "czoktawski" },
            { "chr", metaValue_chr },
            { "ER", "Erytrea" },
            { "ES", "Hiszpania" },
            { "ET", "Etiopia" },
            { "EU", "Unia Europejska" },
            { "elx", "elamicki" },
            { "type.ca.gregorian", "kalendarz gregoria\u0144ski" },
            { "EZ", "strefa euro" },
            { "chy", "czeje\u0144ski" },
            { "type.nu.gujr", "cyfry gud\u017carati" },
            { "Inds", "indus" },
            { "ady", "adygejski" },
            { "aeb", "tunezyjski arabski" },
            { "FI", "Finlandia" },
            { "FJ", "Fid\u017ci" },
            { "FK", "Falklandy" },
            { "FM", "Mikronezja" },
            { "key.va", "wariant regionalny" },
            { "FO", "Wyspy Owcze" },
            { "Taml", "tamilskie" },
            { "FR", "Francja" },
            { "pcd", "pikardyjski" },
            { "tkl", "tokelau" },
            { "grb", "grebo" },
            { "type.ca.indian", "narodowy kalendarz hinduski" },
            { "rgn", "romagnol" },
            { "grc", "starogrecki" },
            { "GA", "Gabon" },
            { "tkr", "cachurski" },
            { "vot", "wotiacki" },
            { "GB", "Wielka Brytania" },
            { "pcm", "pid\u017cyn nigeryjski" },
            { "GD", "Grenada" },
            { "GE", "Gruzja" },
            { "GF", "Gujana Francuska" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "Tale", "tai le" },
            { "GI", "Gibraltar" },
            { "afh", "afrihili" },
            { "GL", "Grenlandia" },
            { "enm", "\u015brednioangielski" },
            { "GM", "Gambia" },
            { "GN", "Gwinea" },
            { "GP", "Gwadelupa" },
            { "GQ", "Gwinea R\u00f3wnikowa" },
            { "GR", "Grecja" },
            { "GS", "Georgia Po\u0142udniowa i Sandwich Po\u0142udniowy" },
            { "GT", "Gwatemala" },
            { "GU", "Guam" },
            { "pdc", "pensylwa\u0144ski" },
            { "GW", "Gwinea Bissau" },
            { "tli", "tlingit" },
            { "tlh", "klingo\u0144ski" },
            { "Talu", "nowy tai lue" },
            { "GY", "Gujana" },
            { "ckb", "sorani" },
            { "zxx", "brak tre\u015bci o charakterze j\u0119zykowym" },
            { "tly", "ta\u0142yski" },
            { "pdt", "plautdietsch" },
            { "de_AT", "niemiecki austriacki" },
            { "HK", "SRA Hongkong (Chiny)" },
            { "Vaii", "vai" },
            { "HM", "Wyspy Heard i McDonalda" },
            { "HN", "Honduras" },
            { "HR", "Chorwacja" },
            { "agq", "aghem" },
            { "gsw", "szwajcarski niemiecki" },
            { "type.ca.islamic-umalqura", "kalendarz islamski (Umm al-Kura)" },
            { "HT", "Haiti" },
            { "HU", "W\u0119gry" },
            { "rif", "tarifit" },
            { "tmh", "tamaszek" },
            { "IC", "Wyspy Kanaryjskie" },
            { "nan", "minna\u0144ski" },
            { "ID", "Indonezja" },
            { "peo", "staroperski" },
            { "IE", "Irlandia" },
            { "nap", "neapolita\u0144ski" },
            { "naq", "nama" },
            { "zza", "zazaki" },
            { "IL", "Izrael" },
            { "IM", "Wyspa Man" },
            { "IN", "Indie" },
            { "type.co.eor", "europejskie regu\u0142y okre\u015blania kolejno\u015bci" },
            { "IO", "Brytyjskie Terytorium Oceanu Indyjskiego" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "Islandia" },
            { "IT", "W\u0142ochy" },
            { "Zmth", "notacja matematyczna" },
            { "type.nu.thai", "cyfry tajskie" },
            { "vro", "v\u00f5ro" },
            { "guc", "way\u00fau" },
            { "%%POSIX", "komputerowy" },
            { "type.nu.beng", "cyfry bengalskie" },
            { "pfl", "palatynacki" },
            { "JE", "Jersey" },
            { "type.ca.islamic", "kalendarz muzu\u0142ma\u0144ski" },
            { "JM", "Jamajka" },
            { "Beng", "bengalskie" },
            { "JO", "Jordania" },
            { "gur", "frafra" },
            { "JP", "Japonia" },
            { "%%1606NICT", "szesnastowieczny francuski" },
            { "ain", "ajnu" },
            { "guz", "gusii" },
            { "tog", "tonga (Niasa)" },
            { "type.nu.knda", "cyfry kannada" },
            { "Kali", "kayah li" },
            { "de_CH", "wysokoniemiecki szwajcarski" },
            { "type.co.phonetic", "sortowanie fonetyczne" },
            { "izh", "ingryjski" },
            { "type.ca.buddhist", "kalendarz buddyjski" },
            { "KE", "Kenia" },
            { "419", "Ameryka \u0141aci\u0144ska" },
            { "KG", "Kirgistan" },
            { "KH", "Kambod\u017ca" },
            { "KI", "Kiribati" },
            { "KM", "Komory" },
            { "Knda", metaValue_kn },
            { "KN", "Saint Kitts i Nevis" },
            { "Zinh", "dziedziczone" },
            { "fr_CA", "francuski kanadyjski" },
            { "KP", "Korea P\u00f3\u0142nocna" },
            { "KR", "Korea Po\u0142udniowa" },
            { "Plrd", "fonetyczny Pollard\u2019a" },
            { "fr_CH", "francuski szwajcarski" },
            { "KW", "Kuwejt" },
            { "tpi", "tok pisin" },
            { "KY", "Kajmany" },
            { "KZ", "Kazachstan" },
            { "Cyrl", "cyrylica" },
            { "LA", "Laos" },
            { "LB", "Liban" },
            { "phn", metaValue_phn },
            { "LC", "Saint Lucia" },
            { "Cyrs", "cyrylica staro-cerkiewno-s\u0142owia\u0144ska" },
            { "gwi", "gwich\u02bcin" },
            { "nds", "dolnoniemiecki" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "akk", "akadyjski" },
            { "cop", "koptyjski" },
            { "LR", "Liberia" },
            { "esu", "yupik \u015brodkowosyberyjski" },
            { "LS", "Lesotho" },
            { "Phlv", "pahlawi ksi\u0105\u017ckowy" },
            { "LT", "Litwa" },
            { "LU", "Luksemburg" },
            { "LV", "\u0141otwa" },
            { "Kana", "katakana" },
            { "LY", "Libia" },
            { "lad", "lady\u0144ski" },
            { "vun", "vunjo" },
            { "akz", "alabama" },
            { "lah", "lahnda" },
            { "lag", "langi" },
            { "Thaa", "taana" },
            { "MA", "Maroko" },
            { "MC", "Monako" },
            { "MD", "Mo\u0142dawia" },
            { "ME", "Czarnog\u00f3ra" },
            { "MF", "Saint-Martin" },
            { "lam", "lamba" },
            { "MG", "Madagaskar" },
            { "MH", "Wyspy Marshalla" },
            { "ale", "aleucki" },
            { "Thai", "tajskie" },
            { "type.nu.vaii", "Cyfry vai" },
            { "MK", "Macedonia P\u00f3\u0142nocna" },
            { "ML", "Mali" },
            { "MM", "Mjanma (Birma)" },
            { "MN", "Mongolia" },
            { "new", "newarski" },
            { "MO", "SRA Makau (Chiny)" },
            { "aln", "alba\u0144ski gegijski" },
            { "MP", "Mariany P\u00f3\u0142nocne" },
            { "MQ", "Martynika" },
            { "MR", "Mauretania" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "cps", "capiznon" },
            { "type.m0.ungegn", "transliteracja UNGEGN" },
            { "MU", "Mauritius" },
            { "alt", "po\u0142udniowoa\u0142tajski" },
            { "MV", "Malediwy" },
            { "MW", "Malawi" },
            { "MX", "Meksyk" },
            { "type.ca.japanese", "kalendarz japo\u0144ski" },
            { "MY", "Malezja" },
            { "MZ", "Mozambik" },
            { "Phli", "inskrypcyjne pahlawi" },
            { "NA", "Namibia" },
            { "202", "Afryka Subsaharyjska" },
            { "type.ca.hebrew", "kalendarz hebrajski" },
            { "type.co.dictionary", "sortowanie s\u0142ownikowe" },
            { "NC", "Nowa Kaledonia" },
            { "%%WADEGILE", "latynizacja Wade\u2019a i Gilesa" },
            { "tru", "turoyo" },
            { "%%UCRCOR", "zreformowana ortografia ujednolicona" },
            { "NE", "Niger" },
            { "NF", "Norfolk" },
            { "NG", "Nigeria" },
            { "trv", "taroko" },
            { "Phlp", "pahlawi psa\u0142terzowy" },
            { "NI", "Nikaragua" },
            { "Hmng", "pahawh hmong" },
            { "NL", "Holandia" },
            { "NO", "Norwegia" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "tsd", "cako\u0144ski" },
            { "Phnx", metaValue_phn },
            { "NU", "Niue" },
            { "rof", "rombo" },
            { "tsi", "tsimshian" },
            { "NZ", "Nowa Zelandia" },
            { "rom", "cyga\u0144ski" },
            { "Mero", "meroickie" },
            { "crh", "krymskotatarski" },
            { "ang", "staroangielski" },
            { "OM", "Oman" },
            { "anp", "angika" },
            { "crs", "kreolski seszelski" },
            { "Xpeo", "staroperskie" },
            { "PA", "Panama" },
            { "type.ca.islamic-civil", "kalendarz islamski (metoda obliczeniowa)" },
            { "csb", "kaszubski" },
            { "en_GB", "angielski brytyjski" },
            { "PE", "Peru" },
            { "ttt", "tacki" },
            { "PF", "Polinezja Francuska" },
            { "PG", "Papua-Nowa Gwinea" },
            { "PH", "Filipiny" },
            { "PK", "Pakistan" },
            { "PL", "Polska" },
            { "ewo", "ewondo" },
            { "PM", "Saint-Pierre i Miquelon" },
            { "PN", "Pitcairn" },
            { "PR", "Portoryko" },
            { "PS", "Terytoria Palesty\u0144skie" },
            { "Bali", "balijskie" },
            { "PT", "Portugalia" },
            { "PW", "Palau" },
            { "nia", "nias" },
            { "type.nu.greklow", "cyfry greckie (ma\u0142e litery)" },
            { "PY", "Paragwaj" },
            { "tum", "tumbuka" },
            { "Hebr", "hebrajskie" },
            { "QA", "Katar" },
            { "%%SCOTLAND", "standardowy szkocki angielski" },
            { "jam", "jamajski" },
            { "pms", "piemoncki" },
            { "niu", "niue" },
            { "QO", "Oceania \u2014 wyspy dalekie" },
            { "ext", "estremadurski" },
            { "lez", "lezgijski" },
            { "%%FONUPA", "fonetyczny" },
            { "tvl", "tuvalu" },
            { "Tavt", "tai viet" },
            { "001", "\u015bwiat" },
            { "002", "Afryka" },
            { "njo", "ao" },
            { "003", "Ameryka P\u00f3\u0142nocna" },
            { "RE", "Reunion" },
            { "005", "Ameryka Po\u0142udniowa" },
            { "lfn", "Lingua Franca Nova" },
            { "jbo", "lojban" },
            { "pnt", "pontyjski" },
            { "Rjng", "rejang" },
            { "009", "Oceania" },
            { "RO", "Rumunia" },
            { "RS", "Serbia" },
            { "RU", "Rosja" },
            { "RW", "Rwanda" },
            { "Mani", "manichejskie" },
            { "Ugar", "ugaryckie" },
            { "Khar", "charosti" },
            { "SA", "Arabia Saudyjska" },
            { "pon", "ponpejski" },
            { "Mand", "mandejskie" },
            { "SB", "Wyspy Salomona" },
            { "twq", "tasawaq" },
            { "011", "Afryka Zachodnia" },
            { "SC", "Seszele" },
            { "SD", "Sudan" },
            { "013", "Ameryka \u015arodkowa" },
            { "SE", "Szwecja" },
            { "014", "Afryka Wschodnia" },
            { "arc", "aramejski" },
            { "015", "Afryka P\u00f3\u0142nocna" },
            { "SG", "Singapur" },
            { "SH", "Wyspa \u015awi\u0119tej Heleny" },
            { "type.lb.strict", "\u015bcis\u0142y styl podzia\u0142u wiersza" },
            { "017", "Afryka \u015arodkowa" },
            { "SI", "S\u0142owenia" },
            { "018", "Afryka Po\u0142udniowa" },
            { "SJ", "Svalbard i Jan Mayen" },
            { "019", "Ameryka" },
            { "SK", "S\u0142owacja" },
            { "Bamu", "bamun" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "arn", "mapudungun" },
            { "arp", "arapaho" },
            { "type.nu.taml", "tradycyjne cyfry tamilskie" },
            { "SR", "Surinam" },
            { "aro", "araona" },
            { "SS", "Sudan Po\u0142udniowy" },
            { "ST", "Wyspy \u015awi\u0119tego Tomasza i Ksi\u0105\u017c\u0119ca" },
            { "arq", "algierski arabski" },
            { "SV", "Salwador" },
            { "ars", "arabski nad\u017cdyjski" },
            { "SX", "Sint Maarten" },
            { "SY", "Syria" },
            { "yao", "yao" },
            { "SZ", "Eswatini" },
            { "arw", "arawak" },
            { "arz", "egipski arabski" },
            { "ary", "maroka\u0144ski arabski" },
            { "yap", "japski" },
            { "rtm", "rotuma\u0144ski" },
            { "TA", "Tristan da Cunha" },
            { "asa", "asu" },
            { "type.ms.ussystem", "ameryka\u0144ski system miar" },
            { "021", "Ameryka P\u00f3\u0142nocna (USA, Kanada)" },
            { "TC", "Turks i Caicos" },
            { "yav", "yangben" },
            { "TD", "Czad" },
            { "Qaag", "zawgyi" },
            { "TF", "Francuskie Terytoria Po\u0142udniowe i Antarktyczne" },
            { "ase", "ameryka\u0144ski j\u0119zyk migowy" },
            { "TG", "Togo" },
            { "TH", "Tajlandia" },
            { "TJ", "Tad\u017cykistan" },
            { "029", "Karaiby" },
            { "TK", "Tokelau" },
            { "TL", "Timor Wschodni" },
            { "ybb", "yemba" },
            { "type.co.searchjl", "Wyszukiwanie wed\u0142ug pocz\u0105tkowej sp\u00f3\u0142g\u0142oski hangul" },
            { "TM", "Turkmenistan" },
            { "%%BOONT", "dialekt Boontling" },
            { "TN", "Tunezja" },
            { "TO", "Tonga" },
            { "TR", "Turcja" },
            { "TT", "Trynidad i Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Tajwan" },
            { "ast", "asturyjski" },
            { "rue", "rusi\u0144ski" },
            { "rug", "roviana" },
            { "Orkh", "orcho\u0144skie" },
            { "TZ", "Tanzania" },
            { "nmg", "ngumba" },
            { "Zzzz", "nieznane pismo" },
            { "UA", "Ukraina" },
            { "lij", "liguryjski" },
            { "rup", "arumu\u0144ski" },
            { "030", "Azja Wschodnia" },
            { "tyv", "tuwi\u0144ski" },
            { "sw_CD", "kongijski suahili" },
            { "034", "Azja Po\u0142udniowa" },
            { "hai", "haida" },
            { "035", "Azja Po\u0142udniowo-Wschodnia" },
            { "UG", "Uganda" },
            { "hak", "hakka" },
            { "type.co.pinyin", "porz\u0105dek sortowania pinyin" },
            { "039", "Europa Po\u0142udniowa" },
            { "Sinh", "syngaleskie" },
            { "UM", "Dalekie Wyspy Mniejsze Stan\u00f3w Zjednoczonych" },
            { "liv", "liwski" },
            { "UN", "Organizacja Narod\u00f3w Zjednoczonych" },
            { "US", "Stany Zjednoczone" },
            { "haw", "hawajski" },
            { "type.co.gb2312han", "chi\u0144ski uproszczony porz\u0105dek sortowania - GB2312" },
            { "UY", "Urugwaj" },
            { "prg", "pruski" },
            { "UZ", "Uzbekistan" },
            { "tzm", "tamazight (Atlas \u015arodkowy)" },
            { "type.co.stroke", "porz\u0105dek akcent\u00f3w" },
            { "nnh", "ngiemboon" },
            { "VA", "Watykan" },
            { "pro", "staroprowansalski" },
            { "VC", "Saint Vincent i Grenadyny" },
            { "VE", "Wenezuela" },
            { "VG", "Brytyjskie Wyspy Dziewicze" },
            { "VI", "Wyspy Dziewicze Stan\u00f3w Zjednoczonych" },
            { "VN", "Wietnam" },
            { "VU", "Vanuatu" },
            { "nog", "nogajski" },
            { "rwk", "rwa" },
            { "non", "staronordyjski" },
            { "053", "Australazja" },
            { "%%AREVMDA", "ormia\u0144ski zachodni" },
            { "054", "Melanezja" },
            { "WF", "Wallis i Futuna" },
            { "type.co.traditional", "tradycyjny porz\u0105dek sortowania" },
            { "057", "Region Mikronezji" },
            { "jgo", "ngombe" },
            { "lkt", "lakota" },
            { "nov", "novial" },
            { "type.nu.finance", "Liczebniki ksi\u0119gowe" },
            { "avk", "kotava" },
            { "type.co.compat", "poprzedni porz\u0105dek sortowania, dla zgodno\u015bci" },
            { "wae", "walser" },
            { "WS", "Samoa" },
            { "wal", "wolayta" },
            { "was", "washo" },
            { "XA", "Pseudoakcenty" },
            { "war", "waraj" },
            { "XB", "Pseudodwukierunkowe" },
            { "awa", "awadhi" },
            { "061", "Polinezja" },
            { "XK", "Kosowo" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "j\u0119zyk bez systemu pisma" },
            { "Olck", "ol chiki" },
            { "wbp", "warlpiri" },
            { "Batk", "batak" },
            { "Blis", "symbole Blissa" },
            { "YE", "Jemen" },
            { "nqo", metaValue_nqo },
            { "type.co.standard", "standardowa kolejno\u015b\u0107 sortowania" },
            { "lmo", "lombardzki" },
            { "fan", "fang" },
            { "%%ROZAJ", "dialekt regionu Resia" },
            { "fat", "fanti" },
            { "Sgnw", "pismo znakowe" },
            { "YT", "Majotta" },
            { "ZA", "Republika Po\u0142udniowej Afryki" },
            { "type.lb.loose", "lu\u017any styl podzia\u0142u wiersza" },
            { "Deva", "dewanagari" },
            { "type.nu.geor", "cyfry gruzi\u0144skie" },
            { "Hira", "hiragana" },
            { "ZM", "Zambia" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "Nieznany region" },
            { "Runr", "runiczne" },
            { "type.ms.metric", "system metryczny" },
            { "type.ca.iso8601", "kalendarz ISO-8601" },
            { "lol", "mongo" },
            { "nso", "sotho p\u00f3\u0142nocny" },
            { "type.nu.telu", "cyfry telugu" },
            { "lou", "kreolski luizja\u0144ski" },
            { "loz", "lozi" },
            { "jmc", "machame" },
            { "hif", "hindi fid\u017cyjskie" },
            { "type.nu.hansfin", "uproszczone chi\u0144skie cyfry ksi\u0119gowe" },
            { "hil", "hiligaynon" },
            { "type.nu.arabext", "rozszerzone cyfry arabsko-indyjskie" },
            { "nus", "nuer" },
            { "dak", "dakota" },
            { "type.nu.fullwide", "cyfry o pe\u0142nej szeroko\u015bci" },
            { "hit", "hetycki" },
            { "dar", "dargwijski" },
            { "dav", "taita" },
            { "Maya", "hieroglify Maj\u00f3w" },
            { "lrc", "luryjski p\u00f3\u0142nocny" },
            { "Copt", "koptyjskie" },
            { "nwc", "newarski klasyczny" },
            { "udm", "udmurcki" },
            { "Khmr", "khmerskie" },
            { "type.ca.islamic-rgsa", "kalendarz islamski (Arabia Saudyjska, metoda wzrokowa)" },
            { "Limb", "limbu" },
            { "sad", "sandawe" },
            { "type.nu.roman", "cyfry rzymskie" },
            { "sah", "jakucki" },
            { "ltg", "\u0142atgalski" },
            { "sam", "samaryta\u0144ski aramejski" },
            { "%%SCOUSE", "dialekt Scouse" },
            { "saq", "samburu" },
            { "sas", "sasak" },
            { "sat", "santali" },
            { "Tfng", "tifinagh (berberski)" },
            { "jpr", "judeo-perski" },
            { "saz", "saurasztryjski" },
            { "type.d0.npinyin", "Liczbowe" },
            { "type.nu.native", "Cyfry macierzyste" },
            { "sba", "ngambay" },
            { "Guru", "gurmukhi" },
            { "lua", "luba-lulua" },
            { "type.d0.fwidth", "pe\u0142na szeroko\u015b\u0107" },
            { "sbp", "sangu" },
            { "lui", "luiseno" },
            { "nyn", "nyankole" },
            { "nym", "niamwezi" },
            { "lun", "lunda" },
            { "nyo", "nyoro" },
            { "luo", "luo" },
            { "fil", "filipi\u0144ski" },
            { "hmn", "hmong" },
            { "del", "delaware" },
            { "lus", "mizo" },
            { "bal", "belud\u017ci" },
            { "den", "slave" },
            { "ban", "balijski" },
            { "uga", "ugarycki" },
            { "fit", "me\u00e4nkieli" },
            { "luy", "luhya" },
            { "bar", "bawarski" },
            { "bas", "basaa" },
            { "bax", "bamum" },
            { "jrb", "judeoarabski" },
            { "es_ES", "europejski hiszpa\u0144ski" },
            { "nzi", "nzema" },
            { "sco", "scots" },
            { "scn", "sycylijski" },
            { "aa", "afar" },
            { "ab", "abchaski" },
            { "Aran", "nastaliq" },
            { "bbc", "batak toba" },
            { "ae", "awestyjski" },
            { "af", "afrikaans" },
            { "ak", "akan" },
            { "bbj", "ghomala" },
            { "am", "amharski" },
            { "an", "arago\u0144ski" },
            { "Arab", "arabskie" },
            { "%%SOLBA", "dialekt Stolvizza/Solbica" },
            { "Jpan", "japo\u0144skie" },
            { "ar", "arabski" },
            { "Hrkt", "sylabariusze japo\u0144skie" },
            { "as", "asamski" },
            { "sdc", "sassarski" },
            { "Lina", "linearne A" },
            { "av", "awarski" },
            { "Linb", "linearne B" },
            { "sdh", "po\u0142udniowokurdyjski" },
            { "ay", "ajmara" },
            { "az", "azerbejd\u017ca\u0144ski" },
            { "%%OSOJS", "dialekt Oseacco/Osojane" },
            { "ba", "baszkirski" },
            { "type.co.unihan", "sortowanie wg kluczy i ich liczby kresek" },
            { "be", "bia\u0142oruski" },
            { "bg", "bu\u0142garski" },
            { "bi", "bislama" },
            { "bm", "bambara" },
            { "bn", "bengalski" },
            { "bo", "tybeta\u0144ski" },
            { "dgr", "dogrib" },
            { "br", "breto\u0144ski" },
            { "bs", "bo\u015bniacki" },
            { "see", "seneka" },
            { "Mymr", "birma\u0144skie" },
            { "sei", "seri" },
            { "type.nu.laoo", "cyfry laota\u0144skie" },
            { "seh", "sena" },
            { "Nkoo", metaValue_nqo },
            { "sel", "selkupski" },
            { "ca", "katalo\u0144ski" },
            { "ses", "koyraboro senni" },
            { "ce", "czecze\u0144ski" },
            { "ch", "czamorro" },
            { "%%REVISED", "ortografia zreformowana" },
            { "co", "korsyka\u0144ski" },
            { "Orya", metaValue_or },
            { "cr", "kri" },
            { "cs", "czeski" },
            { "cu", "cerkiewnos\u0142owia\u0144ski" },
            { "yrl", "nheengatu" },
            { "cv", "czuwaski" },
            { "cy", "walijski" },
            { "type.nu.ethi", "cyfry etiopskie" },
            { "Yiii", "yi" },
            { "da", "du\u0144ski" },
            { "pt_PT", "europejski portugalski" },
            { "de", "niemiecki" },
            { "type.cf.standard", "standardowy format waluty" },
            { "bej", "bed\u017ca" },
            { "din", "dinka" },
            { "jut", "jutlandzki" },
            { "Bugi", "bugi\u0144skie" },
            { "bem", "bemba" },
            { "sga", "staroirlandzki" },
            { "type.nu.mong", "Cyfry mongolskie" },
            { "dv", "malediwski" },
            { "es_419", "ameryka\u0144ski hiszpa\u0144ski" },
            { "bew", "betawi" },
            { "dz", "dzongkha" },
            { "bez", "bena" },
            { "type.ca.chinese", "kalendarz chi\u0144ski" },
            { "lzh", "chi\u0144ski klasyczny" },
            { "dje", "d\u017cerma" },
            { "sgs", "\u017cmudzki" },
            { "type.nu.grek", "cyfry greckie" },
            { "ee", "ewe" },
            { "bfd", "bafut" },
            { "type.lb.normal", "normalny styl podzia\u0142u wiersza" },
            { "ro_MD", "mo\u0142dawski" },
            { "el", "grecki" },
            { "en", "angielski" },
            { "eo", "esperanto" },
            { "bfq", "badaga" },
            { "lzz", "lazyjski" },
            { "type.co.big5han", "chi\u0144ski tradycyjny porz\u0105dek sortowania - Big5" },
            { "es", "hiszpa\u0144ski" },
            { "et", "esto\u0144ski" },
            { "Hanb", "chi\u0144skie z bopomofo" },
            { "eu", "baskijski" },
            { "Buhd", "buhid" },
            { "Hang", "hangul" },
            { "Samr", "samaryta\u0144ski" },
            { "shi", "tashelhiyt" },
            { "hsb", "g\u00f3rno\u0142u\u017cycki" },
            { "Hani", "chi\u0144skie" },
            { "shn", "szan" },
            { "Hano", "hanunoo" },
            { "fa", "perski" },
            { "Hans", "uproszczone" },
            { "type.nu.latn", "cyfry arabskie" },
            { "Hant", "tradycyjne" },
            { "ff", "fulani" },
            { "shu", "arabski (Czad)" },
            { "hsn", "xiang" },
            { "fi", "fi\u0144ski" },
            { "fj", "fid\u017cijski" },
            { "fon", "fon" },
            { "bgn", "belud\u017ci p\u00f3\u0142nocny" },
            { "yue", "kanto\u0144ski" },
            { "fo", "farerski" },
            { "type.m0.bgn", "transliteracja BGN" },
            { "umb", "umbundu" },
            { "fr", "francuski" },
            { "sid", "sidamo" },
            { "fy", "zachodniofryzyjski" },
            { "ga", "irlandzki" },
            { "gd", "szkocki gaelicki" },
            { "gl", "galicyjski" },
            { "gn", "guarani" },
            { "bho", "bhod\u017cpuri" },
            { "und", "nieznany j\u0119zyk" },
            { "type.ca.ethiopic-amete-alem", "Kalendarz etiopski Amete Alem" },
            { "gu", metaValue_gu },
            { "type.ca.islamic-tbla", "kalendarz islamski (metoda obliczeniowa, epoka astronomiczna)" },
            { "gv", "manx" },
            { "ha", "hausa" },
            { "he", "hebrajski" },
            { "hi", "hindi" },
            { "hup", "hupa" },
            { "bik", "bikol" },
            { "bin", "bini" },
            { "ho", "hiri motu" },
            { "hr", "chorwacki" },
            { "ht", "kreolski haita\u0144ski" },
            { "hu", "w\u0119gierski" },
            { "hy", "ormia\u0144ski" },
            { "hz", "herero" },
            { "frc", "caju\u0144ski" },
            { "%%FONIPA", "fonetyczny mi\u0119dzynarodowy" },
            { "ia", "interlingua" },
            { "Jamo", "jamo" },
            { "id", "indonezyjski" },
            { "type.nu.tibt", "cyfry tybeta\u0144skie" },
            { "ie", "interlingue" },
            { "ig", "igbo" },
            { "ii", "syczua\u0144ski" },
            { "frm", "\u015bredniofrancuski" },
            { "ik", "inupiak" },
            { "fro", "starofrancuski" },
            { "frp", "franko-prowansalski" },
            { "io", "ido" },
            { "frs", "wschodniofryzyjski" },
            { "bjn", "banjar" },
            { "frr", "p\u00f3\u0142nocnofryzyjski" },
            { "is", "islandzki" },
            { "it", "w\u0142oski" },
            { "iu", "inuktitut" },
            { "sli", "dolno\u015bl\u0105ski" },
            { "Mlym", metaValue_ml },
            { "ja", "japo\u0144ski" },
            { "Sara", "sarati" },
            { "doi", "dogri" },
            { "sly", "selayar" },
            { "bkm", "kom" },
            { "sma", "po\u0142udniowolapo\u0144ski" },
            { "jv", "jawajski" },
            { "Shaw", "shawa" },
            { "mad", "madurski" },
            { "smj", "lule" },
            { "mag", "magahi" },
            { "maf", "mafa" },
            { "mai", "maithili" },
            { "smn", "inari" },
            { "ka", "gruzi\u0144ski" },
            { "bla", "siksika" },
            { "mak", "makasar" },
            { "wuu", "wu" },
            { "sms", "skolt" },
            { "man", "mandingo" },
            { "kg", "kongo" },
            { "Goth", "gotyckie" },
            { "ki", "kikuju" },
            { "mas", "masajski" },
            { "kj", "kwanyama" },
            { "kk", "kazachski" },
            { "kl", "grenlandzki" },
            { "km", "khmerski" },
            { "kn", metaValue_kn },
            { "ko", "korea\u0144ski" },
            { "kr", "kanuri" },
            { "ks", "kaszmirski" },
            { "Cirt", "cirth" },
            { "Lepc", "lepcha" },
            { "Avst", "awestyjskie" },
            { "ku", "kurdyjski" },
            { "kv", "komi" },
            { "kw", "kornijski" },
            { "ky", "kirgiski" },
            { "snk", "soninke" },
            { "la", "\u0142aci\u0144ski" },
            { "lb", "luksemburski" },
            { "type.nu.mlym", "cyfry malajalam" },
            { "lg", "ganda" },
            { "Roro", "rongorongo" },
            { "li", "limburski" },
            { "Tibt", "tybeta\u0144skie" },
            { "ln", "lingala" },
            { "fur", "friulski" },
            { "lo", "laota\u0144ski" },
            { "type.ms.uksystem", "imperialny system miar" },
            { "lt", "litewski" },
            { "lu", "luba-katanga" },
            { "lv", "\u0142otewski" },
            { "sog", "sogdyjski" },
            { "mg", "malgaski" },
            { "mh", "marszalski" },
            { "type.co.ducet", "domy\u015blna kolejno\u015b\u0107 sortowania Unicode" },
            { "mi", "maoryjski" },
            { "mk", "macedo\u0144ski" },
            { "ml", metaValue_ml },
            { "mn", "mongolski" },
            { "mr", "marathi" },
            { "ms", "malajski" },
            { "mt", "malta\u0144ski" },
            { "my", "birma\u0144ski" },
            { "Saur", "saurashtra" },
            { "Armn", "ormia\u0144skie" },
            { "mdf", "moksza" },
            { "mde", "maba" },
            { "dsb", "dolno\u0142u\u017cycki" },
            { "Armi", "armi" },
            { "na", "naurua\u0144ski" },
            { "type.co.search", "wyszukiwanie og\u00f3lnego zastosowania" },
            { "nb", "norweski (bokm\u00e5l)" },
            { "nd", "ndebele p\u00f3\u0142nocny" },
            { "ne", "nepalski" },
            { "ng", "ndonga" },
            { "mdr", "mandar" },
            { "nl", "niderlandzki" },
            { "nn", "norweski (nynorsk)" },
            { "no", "norweski" },
            { "nr", "ndebele po\u0142udniowy" },
            { "nv", "nawaho" },
            { "kaa", "karaka\u0142packi" },
            { "ny", "njand\u017ca" },
            { "kac", "kaczin" },
            { "kab", "kabylski" },
            { "%%POLYTON", "politoniczny" },
            { "oc", "oksyta\u0144ski" },
            { "kaj", "jju" },
            { "kam", "kamba" },
            { "men", "mende" },
            { "oj", "od\u017cibwa" },
            { "mer", "meru" },
            { "type.nu.armn", "cyfry ormia\u0144skie" },
            { "om", "oromo" },
            { "kaw", "kawi" },
            { "dtp", "dusun centralny" },
            { "or", metaValue_or },
            { "os", "osetyjski" },
            { "bpy", "bisznuprija-manipuri" },
            { "kbd", "kabardyjski" },
            { "mfe", "kreolski Mauritiusa" },
            { "srn", "sranan tongo" },
            { "pa", "pend\u017cabski" },
            { "dua", "duala" },
            { "srr", "serer" },
            { "%%LIPAW", "dialekt Lipovaz w regionie Resia" },
            { "kbl", "kanembu" },
            { "pi", "palijski" },
            { "bqi", "bachtiarski" },
            { "pl", "polski" },
            { "dum", "\u015bredniowieczny niderlandzki" },
            { "type.ca.dangi", "kalendarz korea\u0144ski" },
            { "ps", "paszto" },
            { "pt", "portugalski" },
            { "mga", "\u015brednioirlandzki" },
            { "key.co", "kolejno\u015b\u0107 sortowania" },
            { "pt_BR", "brazylijski portugalski" },
            { "kcg", "tyap" },
            { "mgh", "makua" },
            { "key.cf", "format waluty" },
            { "bra", "brad\u017a" },
            { "key.ca", "kalendarz" },
            { "Laoo", "laota\u0144skie" },
            { "mgo", "meta" },
            { "type.hc.h23", "system 24-godzinny (0\u201323)" },
            { "type.hc.h24", "system 24-godzinny (1\u201324)" },
            { "ssy", "saho" },
            { "brh", "brahui" },
            { "type.nu.mymr", "cyfry birma\u0144skie" },
            { "qu", "keczua" },
            { "zap", "zapotecki" },
            { "brx", "bodo" },
            { "Lana", "lanna" },
            { "kde", "makonde" },
            { "stq", "fryzyjski saterlandzki" },
            { "Ethi", "etiopskie" },
            { "type.hc.h12", "system 12-godzinny (1\u201312)" },
            { "type.hc.h11", "system 12-godzinny (0\u201311)" },
            { "rm", "retoroma\u0144ski" },
            { "rn", "rundi" },
            { "key.cu", "waluta" },
            { "ro", "rumu\u0144ski" },
            { "%%SAAHO", "dialekt Saho" },
            { "type.nu.orya", "cyfry orija" },
            { "type.nu.hanidec", "chi\u0144skie cyfry dziesi\u0119tne" },
            { "ru", "rosyjski" },
            { "bss", "akoose" },
            { "rw", "kinya-ruanda" },
            { "zbl", "bliss" },
            { "kea", "kreolski Wysp Zielonego Przyl\u0105dka" },
            { "mic", "mikmak" },
            { "suk", "sukuma" },
            { "en_AU", "angielski australijski" },
            { "sa", "sanskryt" },
            { "%%UCCOR", "ortografia ujednolicona" },
            { "sc", "sardy\u0144ski" },
            { "sus", "susu" },
            { "sd", "sindhi" },
            { "se", "p\u00f3\u0142nocnolapo\u0144ski" },
            { "min", "minangkabu" },
            { "sg", "sango" },
            { "sh", "serbsko-chorwacki" },
            { "ken", "kenyang" },
            { "si", "syngaleski" },
            { "sux", "sumeryjski" },
            { "sk", "s\u0142owacki" },
            { "sl", "s\u0142owe\u0144ski" },
            { "sm", "samoa\u0144ski" },
            { "sn", "shona" },
            { "so", "somalijski" },
            { "type.nu.arab", "cyfry arabsko-indyjskie" },
            { "sq", "alba\u0144ski" },
            { "sr", "serbski" },
            { "ss", "suazi" },
            { "type.cf.account", "ksi\u0119gowy format waluty" },
            { "st", "sotho po\u0142udniowy" },
            { "Java", "jawajskie" },
            { "su", "sundajski" },
            { "%%NEDIS", "dialekt Natisone" },
            { "sv", "szwedzki" },
            { "sw", "suahili" },
            { "type.nu.hantfin", "tradycyjne chi\u0144skie cyfry ksi\u0119gowe" },
            { "ibb", "ibibio" },
            { "iba", "iban" },
            { "ta", "tamilski" },
            { "142", "Azja" },
            { "bua", "buriacki" },
            { "143", "Azja \u015arodkowa" },
            { "te", metaValue_te },
            { "145", "Azja Zachodnia" },
            { "tg", "tad\u017cycki" },
            { "th", "tajski" },
            { "ti", "tigrinia" },
            { "bug", "bugijski" },
            { "kfo", "koro" },
            { "en_CA", "angielski kanadyjski" },
            { "tk", "turkme\u0144ski" },
            { "tl", "tagalski" },
            { "tn", "setswana" },
            { "to", "tonga" },
            { "bum", "bulu" },
            { "dyo", "diola" },
            { "type.nu.jpan", "cyfry japo\u0144skie" },
            { "tr", "turecki" },
            { "ts", "tsonga" },
            { "swb", "komoryjski" },
            { "Cakm", "chakma" },
            { "tt", "tatarski" },
            { "dyu", "diula" },
            { "tw", "twi" },
            { "ty", "tahita\u0144ski" },
            { "%%BISKE", "dialekt San Giorgio/Bila" },
            { "150", "Europa" },
            { "151", "Europa Wschodnia" },
            { "154", "Europa P\u00f3\u0142nocna" },
            { "dzg", "dazaga" },
            { "155", "Europa Zachodnia" },
            { "ug", "ujgurski" },
            { "Ital", "starow\u0142oskie" },
            { "Kore", "korea\u0144skie" },
            { "kgp", "kaingang" },
            { "Zyyy", "wsp\u00f3lne" },
            { "uk", "ukrai\u0144ski" },
            { "zea", "zelandzki" },
            { "type.ca.coptic", "Kalendarz koptyjski" },
            { "ur", "urdu" },
            { "%%1994", "standardowa ortografia regionu Resia" },
            { "xal", "ka\u0142mucki" },
            { "zen", "zenaga" },
            { "uz", "uzbecki" },
            { "kha", "khasi" },
            { "%%1996", "ortografia niemiecka z 1996 r." },
            { "nds_NL", "dolnosakso\u0144ski" },
            { "Sylo", "syloti nagri" },
            { "ve", "venda" },
            { "type.ca.roc", "kalendarz Republiki Chi\u0144skiej" },
            { "vi", "wietnamski" },
            { "kho", "chota\u0144ski" },
            { "khq", "koyra chiini" },
            { "key.hc", "cykl (12- lub 24-godzinny)" },
            { "%%TARASK", "ortografia taraszkiewicka" },
            { "vo", "wolapik" },
            { "khw", "khowar" },
            { "syc", "syriacki" },
            { "Osma", "osmanya" },
            { "quc", "kicze" },
            { "qug", "keczua g\u00f3rski (Chimborazo)" },
            { "gaa", "ga" },
            { "wa", "walo\u0144ski" },
            { "gag", "gagauski" },
            { "syr", metaValue_syr },
            { "Grek", "greckie" },
            { "gan", "gan" },
            { "kiu", "kirmand\u017cki" },
            { "Lydi", "lidyjskie" },
            { "Xsux", "klinowe sumero-akadyjskie" },
            { "wo", "wolof" },
            { "zgh", "standardowy maroka\u0144ski tamazight" },
            { "ar_001", "wsp\u00f3\u0142czesny arabski" },
            { "Cans", "zunifikowane symbole kanadyjskich autochton\u00f3w" },
            { "gay", "gayo" },
            { "Mong", "mongolskie" },
            { "mnc", "manchu" },
            { "Latf", "\u0142aci\u0144ski - fraktura" },
            { "szl", "\u015bl\u0105ski" },
            { "gba", "gbaya" },
            { "mni", "manipuri" },
            { "Latn", "\u0142aci\u0144skie" },
            { "Latg", "\u0142aci\u0144ski - odmiana gaelicka" },
            { "type.nu.hans", "uproszczone cyfry chi\u0144skie" },
            { "type.nu.hant", "tradycyjne cyfry chi\u0144skie" },
            { "xh", "khosa" },
            { "type.nu.romanlow", "cyfry rzymskie (ma\u0142e litery)" },
            { "byn", "blin" },
            { "Lyci", "likijskie" },
            { "osa", "osage" },
            { "byv", "medumba" },
            { "gbz", "zaratusztria\u0144ski dari" },
            { "Moon", "Moon\u2019a" },
            { "moh", "mohawk" },
            { "kkj", "kako" },
            { "%%1694ACAD", "siedemnastowieczny francuski" },
            { "Syrc", metaValue_syr },
            { "yi", "jidysz" },
            { "mos", "mossi" },
            { "Dsrt", "deseret" },
            { "yo", "joruba" },
            { "type.nu.traditional", "Liczebniki tradycyjne" },
            { "es_MX", "meksyka\u0144ski hiszpa\u0144ski" },
            { "Syrj", "syryjski (odmiana zachodnia)" },
            { "ota", "osma\u0144sko-turecki" },
            { "Syre", "syriacki estrangelo" },
            { "vai", "wai" },
            { "za", "czuang" },
            { "Cari", "karyjskie" },
            { "kln", "kalenjin" },
            { "zh", "chi\u0144ski" },
            { "Bopo", "bopomofo" },
            { "Perm", "staropermskie" },
            { "key.lb", "styl podzia\u0142u wiersza" },
            { "zu", "zulu" },
            { "type.co.phonebook", "porz\u0105dek sortowania ksi\u0105\u017cki telefonicznej" },
            { "%%MONOTON", "monotoniczny" },
            { "Geor", "gruzi\u0144skie" },
            { "kmb", "kimbundu" },
            { "type.nu.jpanfin", "japo\u0144skie cyfry ksi\u0119gowe" },
            { "Cham", "czamskie" },
            { "gez", "gyyz" },
            { "mrj", "zachodniomaryjski" },
            { "Syrn", "syryjski (odmiana wschodnia)" },
            { "type.co.reformed", "sortowanie zreformowane" },
            { "Tglg", "tagalog" },
            { "Egyd", "egipskie demotyczne" },
            { "Egyh", "egipskie hieratyczne" },
            { "ebu", "embu" },
            { "Egyp", "hieroglify egipskie" },
            { "Geok", "gruzi\u0144skie chucuri" },
            { "zh_Hans", "chi\u0144ski uproszczony" },
            { "koi", "komi-permiacki" },
            { "Hung", "starow\u0119gierskie" },
            { "kok", "konkani" },
            { "%%1901", "tradycyjna ortografia niemiecka" },
            { "kos", "kosrae" },
            { "vec", "wenecki" },
            { "zh_Hant", "chi\u0144ski tradycyjny" },
            { "Sund", "sundajskie" },
            { "vep", "wepski" },
            { "kpe", "kpelle" },
            { "type.nu.khmr", "cyfry khmerskie" },
            { "ilo", "ilokano" },
            { "%%VALENCIA", "walencki" },
            { "Cprt", "cypryjskie" },
            { "%%BAKU1926", "turecki zunifikowany alfabet \u0142aci\u0144ski" },
            { "mua", "mundang" },
            { "type.nu.guru", "cyfry gurmukhi" },
            { "mul", "wiele j\u0119zyk\u00f3w" },
            { "cad", "kaddo" },
            { "key.ms", "system miar" },
            { "mus", "krik" },
            { "Glag", "g\u0142agolica" },
            { "gil", "gilberta\u0144ski" },
            { "%%KKCOR", "ortografia wsp\u00f3lna" },
            { "Cher", metaValue_chr },
            { "car", "karaibski" },
            { "cay", "kajuga" },
            { "type.nu.tamldec", "cyfry tamilskie" },
            { "krc", "karaczajsko-ba\u0142karski" },
            { "inh", "inguski" },
            { "krj", "kinaraya" },
            { "kri", "krio" },
            { "fa_AF", "dari" },
            { "krl", "karelski" },
            { "efi", "efik" },
            { "tcy", "tulu" },
            { "key.nu", "cyfry" },
            { "kru", "kurukh" },
            { "ksb", "sambala" },
            { "Telu", metaValue_te },
            { "ksf", "bafia" },
        };
        return data;
    }
}
