/*
 * Copyright (c) 2012, 2022, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class CurrencyNames_kgp extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final Object[][] data = new Object[][] {
            { "AED", "AED" },
            { "AFN", "AFN" },
            { "ALL", "ALL" },
            { "AMD", "AMD" },
            { "ANG", "ANG" },
            { "AOA", "AOA" },
            { "ARS", "ARS" },
            { "AUD", "AU$" },
            { "AWG", "AWG" },
            { "AZN", "AZN" },
            { "BAM", "BAM" },
            { "BBD", "BBD" },
            { "BDT", "BDT" },
            { "BGN", "BGN" },
            { "BHD", "BHD" },
            { "BIF", "BIF" },
            { "BMD", "BMD" },
            { "BND", "BND" },
            { "BOB", "BOB" },
            { "BSD", "BSD" },
            { "BTN", "BTN" },
            { "BWP", "BWP" },
            { "BYN", "BYN" },
            { "BYR", "BYR" },
            { "BZD", "BZD" },
            { "CDF", "CDF" },
            { "CHF", "CHF" },
            { "CLP", "CLP" },
            { "CNH", "CNH" },
            { "COP", "COP" },
            { "CRC", "CRC" },
            { "CUC", "CUC" },
            { "CUP", "CUP" },
            { "CVE", "CVE" },
            { "CZK", "CZK" },
            { "DJF", "DJF" },
            { "DKK", "DKK" },
            { "DOP", "DOP" },
            { "DZD", "DZD" },
            { "EGP", "EGP" },
            { "ERN", "ERN" },
            { "ETB", "ETB" },
            { "FJD", "FJC" },
            { "FKP", "FKP" },
            { "GEL", "GEL" },
            { "GHS", "GHS" },
            { "GIP", "GIP" },
            { "GMD", "GMD" },
            { "GNF", "GNF" },
            { "GTQ", "GTQ" },
            { "GYD", "GYD" },
            { "HNL", "HNL" },
            { "HRK", "HRK" },
            { "HTG", "HTG" },
            { "HUF", "HUF" },
            { "IDR", "IDR" },
            { "IQD", "IQD" },
            { "IRR", "IRR" },
            { "ISK", "ISK" },
            { "JMD", "JMD" },
            { "JOD", "JOD" },
            { "KES", "KES" },
            { "KGS", "KGS" },
            { "KHR", "KHR" },
            { "KMF", "KMF" },
            { "KPW", "KPW" },
            { "KWD", "KWD" },
            { "KYD", "KYD" },
            { "KZT", "KZT" },
            { "LAK", "LAK" },
            { "LBP", "LBP" },
            { "LKR", "LKR" },
            { "LRD", "LRD" },
            { "LYD", "LYD" },
            { "MAD", "MAD" },
            { "MDL", "MDL" },
            { "MGA", "MGA" },
            { "MKD", "MKD" },
            { "MMK", "MMK" },
            { "MNT", "MNT" },
            { "MOP", "MOP" },
            { "MRO", "MRO" },
            { "MRU", "MRU" },
            { "MUR", "MUR" },
            { "MVR", "MVR" },
            { "MWK", "MWK" },
            { "MYR", "MYR" },
            { "MZN", "MZN" },
            { "NAD", "NAD" },
            { "NGN", "NGN" },
            { "NIO", "NIO" },
            { "NOK", "NOK" },
            { "NPR", "NPR" },
            { "OMR", "OMR" },
            { "PAB", "PAB" },
            { "PEN", "PEN" },
            { "PGK", "PGK" },
            { "PHP", "PHP" },
            { "PKR", "PKR" },
            { "PLN", "PLN" },
            { "PTE", "V\u1ebdj." },
            { "PYG", "PYG" },
            { "QAR", "QAR" },
            { "RON", "RON" },
            { "RSD", "RSD" },
            { "RUB", "RUB" },
            { "RWF", "RWF" },
            { "SAR", "SAR" },
            { "SBD", "SBD" },
            { "SCR", "SCR" },
            { "SDG", "SDG" },
            { "SEK", "SEK" },
            { "SGD", "SGD" },
            { "SHP", "SHP" },
            { "SLL", "SLL" },
            { "SOS", "SOS" },
            { "SRD", "SRD" },
            { "SSP", "SSP" },
            { "STD", "STD" },
            { "STN", "STN" },
            { "SYP", "SYP" },
            { "SZL", "SZL" },
            { "THB", "\u0e3f" },
            { "TJS", "TJS" },
            { "TMT", "TMT" },
            { "TND", "TND" },
            { "TOP", "TOP" },
            { "TRY", "TRY" },
            { "TTD", "TTD" },
            { "TZS", "TZS" },
            { "UAH", "UAH" },
            { "UGX", "UGX" },
            { "UYU", "UYU" },
            { "UZS", "UZS" },
            { "VEF", "VEF" },
            { "VES", "VES" },
            { "VUV", "VUV" },
            { "WST", "WST" },
            { "XOF", "CFA" },
            { "YER", "YER" },
            { "ZAR", "ZAR" },
            { "ZMK", "SMK" },
            { "ZMW", "ZMW" },
            { "adp", "\u1ef8noha Kufy-s\u0129" },
            { "aed", "\u1ebcm\u0129rano Arame J\u00e3nkamu" },
            { "afa", "Afegan\u0129 (1927\u20132002)" },
            { "afn", "Afegan\u0129 afeg\u1ef9v" },
            { "alk", "Ar\u00e1m\u00e1nja R\u00e9g (1946\u20131965)" },
            { "all", "Ar\u00e1m\u00e1nja R\u00e9g" },
            { "amd", "Ar\u00e1m\u1ebdnja Daram" },
            { "ang", "\u1ef8tiria Or\u1ef9nesa Kafejs\u0129" },
            { "aoa", "\u1ef8gora Kwanza" },
            { "aok", "\u1ef8gora Cuanza (1977\u20131990)" },
            { "aon", "\u1ef8gora cuanza t\u00e3g (1990\u20132000)" },
            { "aor", "\u1ef8gora cuanza ki hynhan ka n\u0129 (1990\u20132000)" },
            { "ara", "Arj\u1ebdtin\u1ef9 Asufraw" },
            { "arl", "Arj\u1ebdtin\u1ef9 Kufy Rej (1970\u20131983)" },
            { "arm", "Arj\u1ebdtin\u1ef9 Kufy (1881\u20131970)" },
            { "arp", "Arj\u1ebdtin\u1ef9 Kufy (1983\u20131985)" },
            { "ars", "Arj\u1ebdtin\u1ef9 Kufy // Arj\u1ebdnt\u0129n\u1ef9 Kufy" },
            { "ats", "Agtirija Ser\u0129m" },
            { "aud", "Awotyraria N\u00f3rar Si" },
            { "awg", "Aruma Kafejs\u0129" },
            { "azm", "Ajermajj\u00e1v Manati (1993\u20132006)" },
            { "azn", "Manati aseri" },
            { "bad", "M\u00f3sin\u0129ja-Hersegov\u0129na Nin\u1ef9 (1992\u20131994)" },
            { "bam", "M\u00f3sin\u0129ja Hersegov\u0129na-mr\u00e9 M\u1ef9rko ta \u0169n h\u00e1" },
            { "ban", "M\u00f3sin\u0129ja-Hersegov\u0129na Nin\u1ef9 T\u00e3g (1994\u20131997)" },
            { "bbd", "Juv\u00e3-m\u00e1g N\u00f3rar" },
            { "bdt", "M\u00e1gran\u00e9si Taka" },
            { "bec", "M\u00e9rjika V\u0129pir (conv)" },
            { "bef", "M\u00e9rjika V\u0129pir" },
            { "bel", "M\u00e9rjika V\u0129pir (financ)" },
            { "bgl", "Mugarja Rev Tar" },
            { "bgm", "Mugarja Ver kynkar" },
            { "bgn", "Mugarja Rev" },
            { "bgo", "Mugarja Rev (1879\u20131952)" },
            { "bhd", "Mar\u1ebdnh Nin\u1ef9" },
            { "bif", "Mur\u0169ni V\u0129pir" },
            { "bmd", "Karsa-ror-ag N\u00f3rar" },
            { "bnd", "Mrun\u1ebdj N\u00f3rar" },
            { "bob", "Morivija J\u00e3nkamu" },
            { "bol", "Morivijan\u0169 (1863\u20131963)" },
            { "bop", "Morivija Kufy" },
            { "bov", "Morivija Mun\u00f3r" },
            { "brb", "Mrasir Krujeru T\u00e3g (1967\u20131986)" },
            { "brc", "Mrasir Krusanu (1986\u20131989)" },
            { "bre", "Mrasir Krujeru (1990\u20131993)" },
            { "brl", "Mrasir Rejar" },
            { "brn", "Mrasir Krusanu T\u00e3g (1989\u20131990)" },
            { "brr", "Mrasir Krujeru (1993\u20131994)" },
            { "brz", "Mrasir Krujeru (1942\u20131967)" },
            { "bsd", "Maham\u1ef9 N\u00f3rar" },
            { "btn", "But\u1ef9 Gutur\u0169m" },
            { "buk", "Mirm\u1ef9nja Kyate" },
            { "bwp", "Monsuv\u1ef9n\u1ef9 Pura" },
            { "byb", "Miero-Husija Humro T\u00e3g (1994\u20131999)" },
            { "byn", "Miero-Husija Humro" },
            { "byr", "Miero-Husija Humro (2000\u20132016)" },
            { "bzd", "Merise N\u00f3rar" },
            { "cad", "Kan\u1ef9na N\u00f3rar" },
            { "cdf", "K\u00e3gu V\u0129pir" },
            { "che", "WIR Evoro" },
            { "chf", "Suvisa V\u0129pir" },
            { "chw", "WIR V\u0129pir" },
            { "cle", "Sire V\u1ebdjuven" },
            { "clf", "Siren\u0169 ag v\u1ebdnhk\u00e3mur \u0169" },
            { "clp", "Sire Kufy" },
            { "cnh", "S\u0129n\u1ef9 Yv\u1ef9n (offshore)" },
            { "cnx", "N\u00f3rar v\u1ebdnhkar m\u1ef9 m\u00e1ko m\u0129 S\u0129n\u1ef9 t\u00e1" },
            { "cny", "S\u0129n\u1ef9 Yv\u1ef9n" },
            { "cop", "Kol\u00e3mja Kufy" },
            { "cou", "V\u1ebdnhk\u00e3mun \u0169 kaja uri" },
            { "crc", "Kotahika Kor\u00e3n" },
            { "csd", "S\u00e9rvija Nin\u1ef9 (2002\u20132006)" },
            { "csk", "S\u00e9korovaka R\u00e3gre Tar" },
            { "cuc", "Kuma Kufy conv" },
            { "cup", "Kuma Kufy" },
            { "cve", "Pu-T\u00e1nh V\u1ebdjuven" },
            { "cyp", "Sipre Rimra" },
            { "czk", "S\u00e9ka R\u00e3gre" },
            { "ddm", "Arem\u1ef9ja R\u00e3jur t\u00e1 J\u00e3nkamu" },
            { "dem", "Arem\u1ef9nh\u1ef9 M\u1ef9rko" },
            { "djf", "Nhimuti V\u0129pir" },
            { "dkk", "Nin\u1ef9m\u1ef9rka R\u00e3gre" },
            { "dop", "Nom\u0129n\u0129ka Kufy" },
            { "dzd", "Argerija Nin\u1ef9" },
            { "ecs", "Ekuvanor Sukri" },
            { "ecv", "Ekuvanor UVC" },
            { "eek", "Enhton\u0129ja R\u00e3gre" },
            { "egp", "Ejimto Rimra" },
            { "ern", "Eriter\u00e9ja Nagfa" },
            { "esa", "Esip\u1ef9nja Kufy-s\u0129 (k\u00e3t\u00e1 A)" },
            { "esb", "Esip\u1ef9nja Kufy-s\u0129 (k\u00e3t\u00e1 conv)" },
            { "esp", "Esip\u1ef9nja Kufy-s\u0129" },
            { "etb", "Eti\u00f3pija Mir" },
            { "eur", "Evoro" },
            { "fim", "F\u0129r\u1ef9nija M\u1ef9rka" },
            { "fjd", "Fiji N\u00f3rar" },
            { "fkp", "M\u1ef9rvin\u1ef9 Rimra" },
            { "frf", "Fr\u1ef9sa V\u0129pir" },
            { "gbp", "Rimra Eter\u0129n\u1ef9" },
            { "gek", "Ji\u00f3rja Kup\u00e3ni Rari" },
            { "gel", "Ji\u00f3rja Rari" },
            { "ghc", "G\u1ef9n\u1ef9 Senhi (1979\u20132007)" },
            { "ghs", "G\u1ef9n\u1ef9 Senhi" },
            { "gip", "Nhimratar Rimra" },
            { "gmd", "G\u1ef9mija Narasi" },
            { "gnf", "Gin\u1ebd V\u0129pir" },
            { "gns", "Gin\u1ebd Syri" },
            { "gqe", "Gin\u1ebd Ekuvanor Ekuvele" },
            { "grd", "Gr\u00e9sija Narakym\u1ef9" },
            { "gtq", "Guv\u1ef9tem\u1ef9ra Kensav" },
            { "gwe", "F\u00f3g t\u1ef9 Gin\u1ebd V\u1ebdjuven" },
            { "gwp", "Gin\u1ebd-Misav Kufy" },
            { "gyd", "Gij\u1ef9n\u1ef9 N\u00f3rar" },
            { "hkd", "H\u00e3g-K\u00e3g N\u00f3rar" },
            { "hnl", "\u00c3nura R\u1ebdpir\u00e1" },
            { "hrd", "Krovasija Nin\u1ef9" },
            { "hrk", "Krovasija Kuna" },
            { "htg", "Ajti Runja" },
            { "huf", "\u0168grija Kafejs\u0129" },
            { "idr", "\u0128non\u1ebdsija Rupija" },
            { "iep", "Ir\u1ef9na Rimra" },
            { "ilp", "Isiha\u00e9 Rimra" },
            { "ilr", "Isiha\u00e9 Sek\u00e9v Si" },
            { "ils", "Isiha\u00e9 Sek\u00e9v T\u00e3g" },
            { "inr", "\u0128nija Rupija" },
            { "iqd", "Iraki Nin\u1ef9" },
            { "irr", "Ir\u1ef9 Hi\u2019av" },
            { "isj", "Kukryr-ga R\u00e3gre Si" },
            { "isk", "Kukryr-ga R\u00e3gre" },
            { "itl", "Itarija Rira" },
            { "jmd", "Jam\u1ef9jka N\u00f3rar" },
            { "jod", "Jorn\u00e1n\u0129ja Nin\u1ef9" },
            { "jpy", "Jap\u00e3 Jen\u1ebd" },
            { "kes", "K\u1ebdnja Ser\u0129m" },
            { "kgs", "Kirgi-Ga Kyr" },
            { "khr", "K\u1ef9m\u00f3sa Hij\u00e9v" },
            { "kmf", "Komor V\u0129pir" },
            { "kpw", "N\u00e3rti-Kor\u00e9ja V\u00e3n" },
            { "krh", "Kor\u00e9ja Sur Huv\u1ef9 (1953\u20131962)" },
            { "kro", "Kor\u00e9ja Sur V\u00e3n (1945\u20131953)" },
            { "krw", "Kor\u00e9ja Sur V\u00e3n" },
            { "kwd", "Kuvajti Nin\u1ef9" },
            { "kyd", "Kanhm\u1ef9 V\u00e3sogso N\u00f3rar" },
            { "kzt", "Kajakinht\u1ef9v T\u1ebdge" },
            { "lak", "Ravusi Kim" },
            { "lbp", "Riman\u0169 Rimra" },
            { "lkr", "Sirij\u1ef9k\u00e1 Rupija" },
            { "lrd", "Rim\u00e9rij\u1ef9 N\u00f3rar" },
            { "lsl", "Resotu Roti" },
            { "ltl", "Rituv\u1ef9nja Ritasi" },
            { "ltt", "Rituv\u1ef9nja Taron\u1ef9" },
            { "luc", "Rus\u1ebdmurgo V\u0129pir conv." },
            { "luf", "Rus\u1ebdmurgo V\u0129pir" },
            { "lul", "Rus\u1ebdmurgo V\u0129pir J\u00e3nkamu" },
            { "lvl", "Rativija Rati" },
            { "lvr", "Rativija Humro" },
            { "lyd", "Rimija Nin\u1ef9" },
            { "mad", "Ar-Magrim Nirham" },
            { "maf", "Ar-Magrim V\u0129pir" },
            { "mcf", "M\u00f5n\u1ef9ku V\u0129pir" },
            { "mdc", "M\u00e3rnova Kop\u00e3" },
            { "mdl", "M\u00e3rnova Revu" },
            { "mga", "M\u1ef9na-Gasikar Ari-ary" },
            { "mgf", "M\u1ef9na-Gasikar V\u0129pir" },
            { "mkd", "M\u1ef9senon\u0129ja Nin\u1ef9" },
            { "mkn", "M\u1ef9senon\u0129ja Nin\u1ef9 (1992\u20131993)" },
            { "mlf", "M\u1ef9ri V\u0129pir" },
            { "mmk", "Mij\u1ebdn-M\u1ef9 Kijate" },
            { "mnt", "M\u00e3g\u00f3rija Tugrig" },
            { "mop", "M\u1ef9kav Pataka" },
            { "mro", "M\u0169rit\u1ef9ni Ov-Gija (1973\u20132017)" },
            { "mru", "M\u0169rit\u1ef9ni Ov-Gija" },
            { "mtl", "M\u1ef9rta Rir\u00e1" },
            { "mtp", "M\u1ef9rta Rimra" },
            { "mur", "M\u00e3riso Rupija" },
            { "mvr", "M\u1ef9rniva Rupija" },
            { "mwk", "M\u1ef9ravi Kuvasa" },
            { "mxn", "M\u1ebdsiku Kufy" },
            { "mxp", "M\u1ebdsiku Kufy Kupri (1861\u20131992)" },
            { "mxv", "M\u1ebdsiku Pir R\u00e3g (UDI)" },
            { "myr", "M\u1ef9raja R\u0129ggin" },
            { "mze", "M\u00e3s\u1ef9miki V\u1ebdjuven" },
            { "mzm", "M\u00e3s\u1ef9miki M\u1ebdtikar (1980\u20132006)" },
            { "mzn", "M\u00e3s\u1ef9miki M\u1ebdtikar" },
            { "nad", "N\u1ef9m\u0129mija N\u00f3rar" },
            { "ngn", "N\u0129j\u00e9rija N\u1ef9jra" },
            { "nic", "N\u0129karaguva K\u00f3rnoma (1988\u20131991)" },
            { "nio", "N\u0129karaguva K\u00f3rnoma" },
            { "nlg", "Or\u1ef9na Kafejs\u0129" },
            { "nok", "N\u00e3rov\u00e9ga R\u00e3gre" },
            { "npr", "N\u1ebdpar Rupija" },
            { "nzd", "Zir\u1ef9nija T\u00e3g N\u00f3rar" },
            { "omr", "Om\u1ef9 Hijar" },
            { "pab", "Pan\u1ef9m\u1ef9 Mavo-Mova" },
            { "pei", "Peru \u0128nti" },
            { "pen", "Peru R\u00e3 T\u00e3g" },
            { "pes", "Peru R\u00e3 (1863\u20131965)" },
            { "pgk", "Papuva Kin\u1ef9" },
            { "php", "Firipin\u1ef9 Kufy" },
            { "pkr", "Pakinht\u1ef9v Rupiya" },
            { "pln", "Poron\u0129ja R\u1ebdr\u0129r" },
            { "plz", "Poron\u0129ja R\u1ebdr\u0129r (1950\u20131995)" },
            { "pte", "Purutuga V\u1ebdjuven" },
            { "pyg", "Paraguvaj Garn\u0129" },
            { "qar", "Katar Hijar" },
            { "rhd", "Ron\u00e9sija N\u00f3rar" },
            { "rol", "Rom\u1ebdnija Rev (1952\u20132006)" },
            { "ron", "Rom\u1ebdnija Rev" },
            { "rsd", "S\u00e9ruvija Nin\u1ef9" },
            { "rub", "Husija Humro" },
            { "rur", "Husija Humro (1991\u20131998)" },
            { "rwf", "Huv\u1ef9na V\u0129pir" },
            { "sar", "Aramija Savnita Hijar" },
            { "sbd", "Sarom\u1ef9 V\u1ebdsogso N\u00f3rar" },
            { "scr", "Sejs\u00e9ri Rupija" },
            { "sdd", "Sun\u00e1 Nin\u1ef9 (1992\u20132007)" },
            { "sdg", "Sun\u00e1 Rimbra" },
            { "sdp", "Sun\u00e1 Rimbra (1957\u20131998)" },
            { "sek", "Suv\u00e9sija R\u00e3gre" },
            { "sgd", "S\u0129gapur N\u00f3rar" },
            { "shp", "S\u1ef9ta Heren\u1ef9 Rimra" },
            { "sit", "Enhroven\u0129ja Torar H\u00e1" },
            { "skk", "Enhrovakija R\u00e3gre" },
            { "sll", "Kr\u0129 M\u0129gkus\u0169g-fi Re\u2019on\u0129" },
            { "sos", "Som\u1ef9rija Ser\u0129m" },
            { "srd", "Surin\u1ef9m N\u00f3rar" },
            { "srg", "Surin\u1ef9m Kafejs\u0129" },
            { "ssp", "Sun\u00e1-Sur Rimra" },
            { "std", "S\u1ef9tom\u1ebd Pr\u0129sipi-mr\u00e9 N\u00f3mra (1977\u20132017)" },
            { "stn", "S\u1ef9tom\u1ebd Pr\u0129sipi-mr\u00e9 N\u00f3mra" },
            { "sur", "Sovij\u00e9ti Humro" },
            { "svc", "Er Sarvanor Kor\u00e3n" },
            { "syp", "Sirija Rimra" },
            { "szl", "Suvasi-Ga Rir\u1ef9gen\u0129" },
            { "thb", "Taj-Ga Mati" },
            { "tjr", "Tanijikinht\u1ef9v Humro" },
            { "tjs", "Tanijikinht\u1ef9v Som\u00e3n\u0129" },
            { "tmm", "Turkom\u1ebdnisit\u1ef9 Manati (1993\u20132009)" },
            { "tmt", "Tukom\u1ebdn\u0169 Manati" },
            { "tnd", "Tun\u0129sija Nin\u1ef9" },
            { "top", "T\u00e3ga Pa\u2019\u1ef9ga" },
            { "tpe", "Timor V\u1ebdjuven" },
            { "trl", "Turkija Rira (1922\u20132005)" },
            { "try", "Turkija Rira" },
            { "ttd", "Tirin\u0129na Tomago-mr\u00e9 N\u00f3rar" },
            { "twd", "Tajv\u1ef9 N\u00f3rar T\u00e3g" },
            { "tzs", "T\u1ef9nj\u1ef9n\u0129ja Ser\u0129m" },
            { "uah", "Ukr\u1ef9n\u0129ja Hyryvinja" },
            { "uak", "Ukr\u1ef9n\u0129ja Karbovan\u1ebd" },
            { "ugs", "Ug\u1ef9na Ser\u0129m (1966\u20131987)" },
            { "ugx", "Ug\u1ef9na Ser\u0129m" },
            { "usd", "N\u00e3rti-Am\u1ebdrik\u1ef9 N\u00f3rar" },
            { "usn", "N\u00e3rti-Am\u1ebdrik\u1ef9 N\u00f3rar (kur\u00e3 \u0169 k\u00e3)" },
            { "uss", "N\u00e3rti-Am\u1ebdrik\u1ef9 N\u00f3rar (kur\u00e3 h\u00e3)" },
            { "uyi", "Uruguvaj Kufy v\u1ebdk\u00e3mur \u0169" },
            { "uyp", "Uruguvaj Kufy (1975\u20131993)" },
            { "uyu", "Uruguvaj Kufy" },
            { "uzs", "Unhmekinht\u1ef9v Kyr" },
            { "veb", "Ven\u1ebdjuv\u00e9ra Morivar (1871\u20132008)" },
            { "vef", "Ven\u1ebdjuv\u00e9ra Morivar (2008\u20132018)" },
            { "ves", "Ven\u1ebdjuv\u00e9ra Morivar" },
            { "vnd", "Vij\u00e9tin\u1ef9m N\u00e3g" },
            { "vnn", "Vij\u00e9tin\u1ef9m N\u00e3g (1978\u20131985)" },
            { "vuv", "Van\u0169vatu Vatu" },
            { "wst", "Sam\u00e3va Tara" },
            { "xaf", "V\u0129pir CFA t\u1ef9 BEAC" },
            { "xag", "Kyf\u00e9 Kupri" },
            { "xau", "Kyf\u00e9 M\u1ef9r\u00e9r" },
            { "xba", "Or\u00f3pa V\u1ebdnhk\u00e3mur \u0169 \u2018e" },
            { "xbb", "Or\u00f3pa J\u00e3nkamu \u0169-pir (XBB)" },
            { "xbc", "Or\u00f3pa N\u0129kr\u00e9n-ja \u0169-pir (XBC)" },
            { "xbd", "Or\u00f3pa N\u0129kr\u00e9n-ja \u0169-pir" },
            { "xcd", "Karime R\u00e3jur N\u00f3rar" },
            { "xdr", "Kuryj h\u00e1 ty Jiro" },
            { "xeu", "Or\u00f3pa N\u0129kri \u0169-pir" },
            { "xfo", "Fr\u1ef9sa V\u0129pir-Oro" },
            { "xfu", "Fr\u1ef9sa UIC V\u0129pir" },
            { "xof", "V\u0129pir CFA t\u1ef9 BCEAO" },
            { "xpd", "Paranho" },
            { "xpf", "V\u0129pir CFP" },
            { "xpt", "Pratin\u1ef9" },
            { "xre", "RINET K\u00e3ryjgy" },
            { "xts", "R\u00e1 t\u1ef9 N\u0129kri V\u1ebdnh-k\u00e3gran-ja" },
            { "xxx", "N\u0129kri veja t\u0169" },
            { "ydd", "Jem\u1ebdn Nin\u1ef9" },
            { "yer", "Jem\u1ebdn Hijar" },
            { "yud", "Jugusiravija Nin\u1ef9 Tar (1966\u20131990)" },
            { "yum", "Jugusiravija Nin\u1ef9 T\u00e3g (1994\u20132002)" },
            { "yun", "Jugusiravija Nin\u1ef9 ta \u0169n h\u00e1 (1990\u20131992)" },
            { "yur", "Jugusiravija Nin\u1ef9 han m\u00e3n t\u00e3g (1992\u20131993)" },
            { "zal", "Ran surafrik\u1ef9n\u0169 (virh\u00e1r)" },
            { "zar", "Ran surafrik\u1ef9n\u0169" },
            { "zmk", "Kuvasa J\u1ef9mijan\u0169 (1968\u20132012)" },
            { "zmw", "Kuvasa j\u1ef9mijan\u0169" },
            { "zrn", "Jajre T\u00e3g Sajr\u1ebdse" },
            { "zrz", "Jajre Sajr\u1ebdse (1971\u20131993)" },
            { "zwd", "Jimamuv\u00e9 N\u00f3rar (1980\u2013 2008)" },
            { "zwl", "Jimamuv\u00e9 N\u00f3rar (2009)" },
            { "zwr", "Jimamuv\u00e9 N\u00f3rar (2008)" },
        };
        return data;
    }
}
