/*
 * Copyright (c) 2012, 2022, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_sah extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Iran = new String[] {
               "\u0418\u0440\u0430\u0430\u043d \u0441\u04af\u0440\u04af\u043d \u043a\u044d\u043c\u044d",
               "",
               "\u042b\u0440\u0430\u0430\u043d \u0441\u0430\u0439\u044b\u04a5\u04a5\u044b \u043a\u044d\u043c\u044d",
               "",
               "\u0418\u0440\u0430\u0430\u043d \u043a\u044d\u043c\u044d",
               "",
            };
        final String[] Omsk = new String[] {
               "\u041e\u043c\u0441\u043a\u0430\u0439 \u0441\u04af\u0440\u04af\u043d \u043a\u044d\u043c\u044d",
               "",
               "\u041e\u043c\u0441\u043a\u0430\u0439 \u0441\u0430\u0439\u044b\u04a5\u04a5\u044b \u043a\u044d\u043c\u044d",
               "",
               "\u041e\u043c\u0441\u043a\u0430\u0439 \u043a\u044d\u043c\u044d",
               "",
            };
        final String[] China = new String[] {
               "\u041a\u044b\u0442\u0430\u0439 \u0441\u04af\u0440\u04af\u043d \u043a\u044d\u043c\u044d",
               "",
               "\u041a\u044b\u0442\u0430\u0439 \u0441\u0430\u0439\u044b\u04a5\u04a5\u044b \u043a\u044d\u043c\u044d",
               "",
               "\u041a\u044b\u0442\u0430\u0439 \u043a\u044d\u043c\u044d",
               "",
            };
        final String[] India = new String[] {
               "\u0418\u0438\u043d\u0434\u0438\u0439\u044d \u0441\u04af\u0440\u04af\u043d \u043a\u044d\u043c\u044d",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Japan = new String[] {
               "\u0414\u044c\u043e\u043f\u043f\u0443\u043e\u043d \u0441\u04af\u0440\u04af\u043d \u043a\u044d\u043c\u044d",
               "",
               "\u0414\u044c\u043e\u043f\u043f\u0443\u043e\u043d \u0441\u0430\u0439\u044b\u04a5\u04a5\u044b \u043a\u044d\u043c\u044d",
               "",
               "\u0414\u044c\u043e\u043f\u043f\u0443\u043e\u043d \u043a\u044d\u043c\u044d",
               "",
            };
        final String[] Korea = new String[] {
               "\u041a\u044d\u0440\u0438\u044d\u0439 \u0441\u04af\u0440\u04af\u043d \u043a\u044d\u043c\u044d",
               "",
               "\u041a\u044d\u0440\u0438\u044d\u0439 \u0441\u0430\u0439\u044b\u04a5\u04a5\u044b \u043a\u044d\u043c\u044d",
               "",
               "\u041a\u044d\u0440\u0438\u044d\u0439 \u043a\u044d\u043c\u044d",
               "",
            };
        final String[] Moscow = new String[] {
               "\u041c\u043e\u0441\u043a\u0443\u0431\u0430 \u0441\u04af\u0440\u04af\u043d \u043a\u044d\u043c\u044d",
               "",
               "\u041c\u043e\u0441\u043a\u0443\u0431\u0430 \u0441\u0430\u0439\u044b\u04a5\u04a5\u044b \u043a\u044d\u043c\u044d",
               "",
               "\u041c\u043e\u0441\u043a\u0443\u0431\u0430 \u043a\u044d\u043c\u044d",
               "",
            };
        final String[] Arabian = new String[] {
               "\u0410\u0440\u0430\u0430\u0431 \u0441\u04af\u0440\u04af\u043d \u043a\u044d\u043c\u044d",
               "",
               "\u0410\u0440\u0430\u0430\u0431 \u0441\u0430\u0439\u044b\u04a5\u04a5\u044b \u043a\u044d\u043c\u044d",
               "",
               "\u0410\u0440\u0430\u0430\u0431 \u043a\u044d\u043c\u044d",
               "",
            };
        final String[] Armenia = new String[] {
               "\u042d\u0440\u043c\u044d\u044d\u043d \u0441\u04af\u0440\u04af\u043d \u043a\u044d\u043c\u044d",
               "",
               "\u042d\u0440\u043c\u044d\u044d\u043d \u0441\u0430\u0439\u044b\u04a5\u04a5\u044b \u043a\u044d\u043c\u044d",
               "",
               "\u042d\u0440\u043c\u044d\u044d\u043d \u043a\u044d\u043c\u044d",
               "",
            };
        final String[] Georgia = new String[] {
               "\u041a\u0443\u0440\u0443\u0441\u0443\u0443\u043d \u0441\u04af\u0440\u04af\u043d \u043a\u044d\u043c\u044d",
               "",
               "\u041a\u0443\u0440\u0443\u0441\u0443\u0443\u043d \u0441\u0430\u0439\u044b\u04a5\u04a5\u044b \u043a\u044d\u043c\u044d",
               "",
               "\u041a\u0443\u0440\u0443\u0441\u0443\u0443\u043d \u043a\u044d\u043c\u044d",
               "",
            };
        final String[] Magadan = new String[] {
               "\u041c\u0430\u0433\u0430\u0434\u0430\u0430\u043d \u0441\u04af\u0440\u04af\u043d \u043a\u044d\u043c\u044d",
               "",
               "\u041c\u0430\u0433\u0430\u0434\u0430\u0430\u043d \u0441\u0430\u0439\u044b\u04a5\u04a5\u044b \u043a\u044d\u043c\u044d",
               "",
               "\u041c\u0430\u0433\u0430\u0434\u0430\u0430\u043d \u043a\u044d\u043c\u044d",
               "",
            };
        final String[] Yakutsk = new String[] {
               "\u0414\u044c\u043e\u043a\u0443\u0443\u0441\u043a\u0430\u0439 \u0441\u04af\u0440\u04af\u043d \u043a\u044d\u043c\u044d",
               "",
               "\u0414\u044c\u043e\u043a\u0443\u0443\u0441\u043a\u0430\u0439 \u0441\u0430\u0439\u044b\u04a5\u04a5\u044b \u043a\u044d\u043c\u044d",
               "",
               "\u0414\u044c\u043e\u043a\u0443\u0443\u0441\u043a\u0430\u0439 \u043a\u044d\u043c\u044d",
               "",
            };
        final String[] Mongolia = new String[] {
               "\u0423\u043b\u0430\u043d \u0411\u0430\u0430\u0442\u0430\u0440 \u0441\u04af\u0440\u04af\u043d \u043a\u044d\u043c\u044d",
               "",
               "\u0423\u043b\u0430\u043d \u0411\u0430\u0430\u0442\u0430\u0440 \u0441\u0430\u0439\u044b\u04a5\u04a5\u044b \u043a\u044d\u043c\u044d",
               "",
               "\u0423\u043b\u0430\u043d \u0411\u0430\u0430\u0442\u0430\u0440 \u043a\u044d\u043c\u044d",
               "",
            };
        final String[] Pakistan = new String[] {
               "\u041f\u0430\u043a\u0438\u0441\u0442\u0430\u0430\u043d \u0441\u04af\u0440\u04af\u043d \u043a\u044d\u043c\u044d",
               "",
               "\u041f\u0430\u043a\u0438\u0441\u0442\u0430\u0430\u043d \u0441\u0430\u0439\u044b\u04a5\u04a5\u044b \u043a\u044d\u043c\u044d",
               "",
               "\u041f\u0430\u043a\u0438\u0441\u0442\u0430\u0430\u043d \u043a\u044d\u043c\u044d",
               "",
            };
        final String[] Sakhalin = new String[] {
               "\u0421\u0430\u0445\u0430\u043b\u044b\u044b\u043d \u0441\u04af\u0440\u04af\u043d \u043a\u044d\u043c\u044d",
               "",
               "\u0421\u0430\u0445\u0430\u043b\u044b\u044b\u043d \u0441\u0430\u0439\u044b\u04a5\u04a5\u044b \u043a\u044d\u043c\u044d",
               "",
               "\u0421\u0430\u0445\u0430\u043b\u0438\u0438\u043d \u043a\u044d\u043c\u044d",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "\u041a\u044b\u0440\u0433\u044b\u0441\u0442\u0430\u0430\u043d \u043a\u044d\u043c\u044d",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "\u0412\u043e\u043b\u0433\u043e\u0433\u0440\u0430\u0434 \u0441\u04af\u0440\u04af\u043d \u043a\u044d\u043c\u044d",
               "",
               "\u0412\u043e\u043b\u0433\u043e\u0433\u0440\u0430\u0434 \u0441\u0430\u0439\u044b\u04a5\u04a5\u044b \u043a\u044d\u043c\u044d",
               "",
               "\u0412\u043e\u043b\u0433\u043e\u0433\u0440\u0430\u0434 \u043a\u044d\u043c\u044d",
               "",
            };
        final String[] EMPTY_ZONE = new String[] {
               "",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "\u041a\u0440\u0430\u0441\u043d\u043e\u044f\u0440\u0441\u043a\u0430\u0439 \u0441\u04af\u0440\u04af\u043d \u043a\u044d\u043c\u044d",
               "",
               "\u041a\u0440\u0430\u0441\u043d\u043e\u044f\u0440\u0441\u043a\u0430\u0439 \u0441\u0430\u0439\u044b\u04a5\u04a5\u044b \u043a\u044d\u043c\u044d",
               "",
               "\u041a\u0440\u0430\u0441\u043d\u043e\u044f\u0440\u0441\u043a\u0430\u0439 \u043a\u044d\u043c\u044d",
               "",
            };
        final String[] New_Zealand = new String[] {
               "\u0421\u0430\u04a5\u0430 \u0421\u044d\u0439\u043b\u044d\u043d\u0434 \u0441\u04af\u0440\u04af\u043d \u043a\u044d\u043c\u044d",
               "",
               "\u0421\u0430\u04a5\u0430 \u0421\u044d\u0439\u043b\u044d\u043d\u0434 \u0441\u0430\u0439\u044b\u04a5\u04a5\u044b \u043a\u044d\u043c\u044d",
               "",
               "\u0421\u0430\u04a5\u0430 \u0417\u0435\u043b\u0430\u043d\u0434\u0438\u044f \u043a\u044d\u043c\u044d",
               "",
            };
        final String[] Novosibirsk = new String[] {
               "\u041d\u043e\u0432\u043e\u0441\u0438\u0431\u0438\u0440\u0441\u043a\u0430\u0439 \u0441\u04af\u0440\u04af\u043d \u043a\u044d\u043c\u044d",
               "",
               "\u041d\u043e\u0432\u043e\u0441\u0438\u0431\u0438\u0440\u0441\u043a\u0430\u0439 \u0441\u0430\u0439\u044b\u04a5\u04a5\u044b \u043a\u044d\u043c\u044d",
               "",
               "\u041d\u043e\u0432\u043e\u0441\u0438\u0431\u0438\u0440\u0441\u043a\u0430\u0439 \u043a\u044d\u043c\u044d",
               "",
            };
        final String[] Vladivostok = new String[] {
               "\u0411\u044b\u043b\u0430\u0434\u044c\u044b\u0431\u0430\u0441\u0442\u044b\u0430\u043a \u0441\u04af\u0440\u04af\u043d \u043a\u044d\u043c\u044d",
               "",
               "\u0411\u044b\u043b\u0430\u0434\u044c\u044b\u0431\u0430\u0441\u0442\u044b\u0430\u043a \u0441\u0430\u0439\u044b\u04a5\u04a5\u044b \u043a\u044d\u043c\u044d",
               "",
               "\u0412\u043b\u0430\u0434\u0438\u0432\u043e\u0441\u0442\u043e\u043a \u043a\u044d\u043c\u044d",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "\u0415\u043a\u0430\u0442\u0435\u0440\u0438\u043d\u0431\u0443\u0443\u0440 \u0441\u04af\u0440\u04af\u043d \u043a\u044d\u043c\u044d",
               "",
               "\u0415\u043a\u0430\u0442\u0435\u0440\u0438\u043d\u0431\u0443\u0443\u0440 \u0441\u0430\u0439\u044b\u04a5\u04a5\u044b \u043a\u044d\u043c\u044d",
               "",
               "\u0415\u043a\u0430\u0442\u0435\u0440\u0438\u043d\u0431\u0443\u0440\u0433 \u043a\u044d\u043c\u044d",
               "",
            };
        final String[] Australia_Central = new String[] {
               "\u041a\u0438\u0438\u043d \u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u044f \u0441\u04af\u0440\u04af\u043d \u043a\u044d\u043c\u044d",
               "",
               "\u041a\u0438\u0438\u043d \u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u044f \u0441\u0430\u0439\u044b\u04a5\u04a5\u044b \u043a\u044d\u043c\u044d",
               "",
               "\u041a\u0438\u0438\u043d \u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u044f \u043a\u044d\u043c\u044d",
               "",
            };
        final String[] Australia_Eastern = new String[] {
               "\u0418\u043b\u0438\u043d \u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u044f \u0441\u04af\u0440\u04af\u043d \u043a\u044d\u043c\u044d",
               "",
               "\u0418\u043b\u0438\u043d \u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u044f \u0441\u0430\u0439\u044b\u04a5\u04a5\u044b \u043a\u044d\u043c\u044d",
               "",
               "\u0418\u043b\u0438\u043d \u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u044f \u043a\u044d\u043c\u044d",
               "",
            };
        final String[] Australia_Western = new String[] {
               "\u0410\u0440\u0495\u0430\u0430 \u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u044f \u0441\u04af\u0440\u04af\u043d \u043a\u044d\u043c\u044d",
               "",
               "\u0410\u0440\u0495\u0430\u0430 \u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u044f \u0441\u0430\u0439\u044b\u04a5\u04a5\u044b \u043a\u044d\u043c\u044d",
               "",
               "\u0410\u0440\u0495\u0430\u0430 \u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u044f \u043a\u044d\u043c\u044d",
               "",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "\u0418\u043b\u0438\u043d \u041a\u0430\u0437\u0430\u0445\u0441\u0442\u0430\u0430\u043d \u043a\u044d\u043c\u044d",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan_Western = new String[] {
               "\u0410\u0440\u0495\u0430\u0430 \u041a\u0430\u0437\u0430\u0445\u0441\u0442\u0430\u0430\u043d \u043a\u044d\u043c\u044d",
               "",
               "",
               "",
               "",
               "",
            };
        final Object[][] data = new Object[][] {
            { "Asia/Tokyo", Japan },
            { "Asia/Shanghai", China },
            { "UTC", EMPTY_ZONE },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "CTT", China },
            { "JST", Japan },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "Asia/Aden", Arabian },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan_Western },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Asia/Chita", Yakutsk },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Asia/Harbin", China },
            { "Asia/Kuwait", Arabian },
            { "Asia/Riyadh", Arabian },
            { "Asia/Tehran", Iran },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Karachi", Pakistan },
            { "Asia/Magadan", Magadan },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Europe/Minsk", Moscow },
            { "Asia/Calcutta", India },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Qostanay", Kazakhstan_Eastern },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Ust-Nera", Vladivostok },
            { "Europe/Moscow", Moscow },
            { "Asia/Chongqing", China },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan_Western },
            { "Asia/Choibalsan", Mongolia },
            { "Australia/Perth", Australia_Western },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Europe/Volgograd", Volgograd },
            { "Pacific/Auckland", New_Zealand },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Europe/Simferopol", Moscow },
            { "Antarctica/McMurdo", New_Zealand },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Melbourne", Australia_Eastern },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "timezone.excity.Asia/Baku", "\u0411\u0430\u043a\u0443\u0443" },
            { "timezone.excity.Asia/Omsk", "\u041e\u043c\u0441\u043a\u0430\u0439" },
            { "timezone.excity.Asia/Chita", "\u0427\u0438\u0442\u0430\u0430" },
            { "timezone.excity.Asia/Dubai", "\u0414\u0443\u0431\u0430\u0430\u0439" },
            { "timezone.excity.Asia/Kabul", "\u041a\u0430\u0431\u0443\u0443\u043b" },
            { "timezone.excity.Asia/Almaty", "\u0410\u043b\u043c\u0430\u0442\u044b" },
            { "timezone.excity.Asia/Anadyr", "\u0410\u043d\u0430\u0430\u0434\u044b\u0440" },
            { "timezone.excity.Asia/Urumqi", "\u0423\u0440\u0443\u043c\u0447\u0443" },
            { "timezone.excity.Etc/Unknown", "\u0411\u0438\u043b\u043b\u0438\u0431\u044d\u0442" },
            { "timezone.excity.Asia/Baghdad", "\u0411\u0430\u0433\u0434\u0430\u0430\u0434" },
            { "timezone.excity.Asia/Barnaul", "\u0411\u0430\u0440\u043d\u0430\u0443\u043b" },
            { "timezone.excity.Asia/Colombo", "\u041a\u043e\u043b\u043e\u043c\u0431\u043e" },
            { "timezone.excity.Asia/Irkutsk", "\u0418\u0440\u043a\u0443\u0442\u0441\u043a\u0430\u0439" },
            { "timezone.excity.Asia/Magadan", "\u041c\u0430\u0433\u0430\u0434\u0430\u0430\u043d" },
            { "timezone.excity.Asia/Yakutsk", "\u0414\u044c\u043e\u043a\u0443\u0443\u0441\u043a\u0430\u0439" },
            { "timezone.excity.Asia/Ashgabat", "\u0410\u0441\u0445\u0430\u0431\u0430\u0430\u0442" },
            { "timezone.excity.Asia/Damascus", "\u0414\u0430\u043c\u0430\u0430\u0441" },
            { "timezone.excity.Asia/Khandyga", "\u0425\u0430\u0430\u043d\u0434\u044b\u0433\u0430" },
            { "timezone.excity.Asia/Sakhalin", "\u0421\u0430\u0445\u0430\u043b\u0438\u0438\u043d" },
            { "timezone.excity.Asia/Ust-Nera", "\u0423\u0443\u0441 \u041d\u044c\u0430\u0440\u0430" },
            { "timezone.excity.Europe/Moscow", "\u041c\u043e\u0441\u043a\u0443\u0431\u0430" },
            { "timezone.excity.Europe/Samara", "\u0421\u0430\u043c\u0430\u0430\u0440\u0430" },
            { "timezone.excity.Asia/Kamchatka", "\u041a\u0430\u043c\u0447\u0430\u0430\u0442\u043a\u0430" },
            { "timezone.excity.Asia/Samarkand", "\u0421\u0430\u043c\u0430\u0440\u043a\u0430\u0430\u043d" },
            { "timezone.excity.Asia/Choibalsan", "\u0427\u043e\u0439\u0431\u0430\u043b\u0441\u0430\u043d" },
            { "timezone.excity.Europe/Istanbul", "\u0421\u0442\u0430\u043c\u0431\u0443\u0443\u043b" },
            { "timezone.excity.Asia/Krasnoyarsk", "\u041a\u0440\u0430\u0441\u043d\u043e\u044f\u0440\u0441\u043a\u0430\u0439" },
            { "timezone.excity.Asia/Novosibirsk", "\u041d\u043e\u0432\u043e\u0441\u0438\u0431\u0438\u0440\u0441\u043a\u0430\u0439" },
            { "timezone.excity.Asia/Ulaanbaatar", "\u0423\u043b\u0430\u043d \u0411\u0430\u0430\u0442\u0430\u0440" },
            { "timezone.excity.Europe/Astrakhan", "\u0410\u0430\u0441\u0442\u0440\u0430\u0445\u0430\u043d" },
            { "timezone.excity.Europe/Ulyanovsk", "\u0423\u043b\u044c\u044f\u043d\u043e\u0432\u0441\u043a\u0430\u0439" },
            { "timezone.excity.Europe/Simferopol", "\u0421\u0438\u043c\u0444\u0435\u0440\u043e\u043f\u043e\u043b\u044c" },
            { "timezone.excity.Asia/Srednekolymsk", "\u041e\u0440\u0442\u043e \u0425\u0430\u043b\u044b\u043c\u0430" },
            { "timezone.excity.Asia/Yekaterinburg", "\u0415\u043a\u0430\u0442\u0435\u0440\u0438\u043d\u0431\u0443\u0443\u0440" },
            { "timezone.excity.Europe/Kaliningrad", "\u041a\u0430\u043b\u0438\u043d\u0438\u043d\u0433\u0440\u0430\u0434" },
        };
        return data;
    }
}
