/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_so extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_CA = "Kanada";
        final String metaValue_DE = "Jarmal";
        final String metaValue_ET = "Itoobiya";
        final String metaValue_FR = "Faransiis";
        final String metaValue_GE = "Joorjiya";
        final String metaValue_IT = "Talyaani";
        final String metaValue_RU = "Ruush";
        final String metaValue_ar = "Carabi";
        final String metaValue_el = "Giriik";
        final String metaValue_gu = "Gujaraati";
        final String metaValue_he = "Cibraani";
        final String metaValue_hy = "Armeeniyaan";
        final String metaValue_ja = "Jabaaniis";
        final String metaValue_ko = "Kuuriyaan";
        final String metaValue_la = "Laatiin";
        final String metaValue_or = "Oodhiya";
        final String metaValue_ccp = "Jakma";
        final Object[][] data = new Object[][] {
            { "ksh", "Kologniyaan" },
            { "Ogam", "Ogham" },
            { "Zsym", "Calaamado" },
            { "type.nu.lanatham", "Godadka Tai Tham" },
            { "Tagb", "Tagbanwa" },
            { "Zsye", "Calaamad Dareen Muujin" },
            { "%%NJIVA", "lahjada Gniva/Njiva" },
            { "ccp", metaValue_ccp },
            { "Phag", "Qoraalka Phags-pa" },
            { "Medf", "Madefaidrin" },
            { "type.nu.sind", "Godadka Khudawadi" },
            { "teo", "Teeso" },
            { "AC", "Jasiiradda Asensiyoon" },
            { "%%BARLA", "lahjada kooxda Barlavento ee kabuverdianu" },
            { "type.nu.sinh", "Godadka Sinhala Lith" },
            { "AD", "Andora" },
            { "AE", "Midawga Imaaraatka Carabta" },
            { "nl_BE", "Af faleemi" },
            { "AF", "Afgaanistaan" },
            { "AG", "Antigua & Barbuuda" },
            { "type.nu.mroo", "Godadka Mro" },
            { "type.ca.ethiopic", "Habeentiriska Itoobiya" },
            { "AI", "Anguula" },
            { "AL", "Albaaniya" },
            { "AM", "Armeeniya" },
            { "AO", "Angoola" },
            { "AQ", "Antaarktika" },
            { "AR", "Arjentiina" },
            { "Prti", "Qoraalka Parthian" },
            { "AS", "Samowa Ameerika" },
            { "AT", "Awsteriya" },
            { "AU", "Awstaraaliya" },
            { "AW", "Aruba" },
            { "en_US", "Ingiriis Maraykan" },
            { "AX", "Jasiiradda Aland" },
            { "AZ", "Asarbajan" },
            { "BA", "Boosniya & Harsegofina" },
            { "BB", "Baarbadoos" },
            { "ceb", "Sebuano" },
            { "BD", "Bangaladhesh" },
            { "BE", "Biljam" },
            { "Sogo", "Sogdiyaankii Hore" },
            { "BF", "Burkiina Faaso" },
            { "BG", "Bulgaariya" },
            { "BH", "Baxreyn" },
            { "BI", "Burundi" },
            { "BJ", "Biniin" },
            { "BL", "St. Baathelemiy" },
            { "BM", "Barmuuda" },
            { "BN", "Buruneey" },
            { "BO", "Boliifiya" },
            { "BQ", "Karibiyaan Nadarlands" },
            { "BR", "Baraasiil" },
            { "BS", "Bahaamas" },
            { "xog", "Sooga" },
            { "BT", "Buutan" },
            { "BV", "Buufet Island" },
            { "BW", "Botuswaana" },
            { "BY", "Belarus" },
            { "BZ", "Beliis" },
            { "type.ca.persian", "Habeentiriska Baarshiyaanka" },
            { "type.nu.hebr", "Nidaam Tireedka Cibraanka" },
            { "CA", metaValue_CA },
            { "Kits", "Qoraalka yar ee Khitan" },
            { "CC", "Jasiiradda Kookoos" },
            { "mzn", "Masanderaani" },
            { "CD", "Jamhuuriyadda Dimuquraadiga Kongo" },
            { "CF", "Jamhuuriyadda Afrikada Dhexe" },
            { "CG", "Kongo" },
            { "CH", "Swiiserlaand" },
            { "CI", "Ayfori Koost" },
            { "CK", "Jasiiradda Kook" },
            { "CL", "Jili" },
            { "Kthi", "kaithi" },
            { "CM", "Kaameruun" },
            { "CN", "Shiinaha" },
            { "CO", "Koloombiya" },
            { "CP", "Jasiiradda Kilibarton" },
            { "CR", "Costa Rica" },
            { "CU", "Kuuba" },
            { "CV", "Jasiiradda Kayb Faarde" },
            { "CW", "Kurakaaw" },
            { "CX", "Jasiiradda Kirismas" },
            { "CY", "Qubrus" },
            { "type.nu.bali", "Godadka Balinese" },
            { "CZ", "Jekiya" },
            { "Ahom", "Dadka Ahom" },
            { "Pauc", "Baaw Sin Haaw" },
            { "Sogd", "Sogdiyaan" },
            { "DE", metaValue_DE },
            { "cgg", "Jiga" },
            { "DG", "Diyeego Karsiya" },
            { "type.nu.deva", "Godadka Defangaari" },
            { "DJ", "Jabuuti" },
            { "DK", "Denmark" },
            { "Brai", "Qoraalka Indhoolaha" },
            { "Brah", "Dhirta Brahmi" },
            { "DM", "Dominika" },
            { "type.nu.armnlow", "Nidaam Tireedka Yaryar ee Armeeniya" },
            { "DO", "Jamhuuriyaddda Dominika" },
            { "Mtei", "Qoraalka Luuqada Meitei" },
            { "Takr", "Takri" },
            { "DZ", "Aljeeriya" },
            { "EA", "Seyuta & Meliila" },
            { "EC", "Ikuwadoor" },
            { "EE", "Estooniya" },
            { "EG", "Masar" },
            { "EH", "Saxaraha Galbeed" },
            { "type.nu.mathbold", "Godad Xisaabeedka Waaweeyn" },
            { "chr", "Jerookee" },
            { "ER", "Eritreeya" },
            { "ES", "Isbeyn" },
            { "ET", metaValue_ET },
            { "EU", "Midowga Yurub" },
            { "type.ca.gregorian", "Habeetiriska Geregoriyaan" },
            { "EZ", "Yurusoon" },
            { "type.nu.gujr", "Godadka Gujaraati" },
            { "FI", "Finland" },
            { "FJ", "Fiji" },
            { "FK", "Jaziiradaha Fooklaan" },
            { "FM", "Mikroneesiya" },
            { "FO", "Jasiiradda Faroo" },
            { "Taml", "Taamiil" },
            { "FR", metaValue_FR },
            { "%%SIMPLE", "Fudud" },
            { "%%DAJNKO", "alfabeetka Dajnko" },
            { "type.ca.indian", "Habeentiris Qarameedka Hindiya" },
            { "GA", "Gaaboon" },
            { "GB", "Boqortooyada Midowday" },
            { "pcm", "Bidjinka Nayjeeriya" },
            { "GD", "Giriinaada" },
            { "GE", metaValue_GE },
            { "GF", "Faransiis Gini" },
            { "GG", "Guurnsey" },
            { "GH", "Gaana" },
            { "Tale", "Tai Le" },
            { "GI", "Gibraltar" },
            { "GL", "Greenland" },
            { "GM", "Gambiya" },
            { "GN", "Gini" },
            { "GP", "Guadeluub" },
            { "GQ", "Ekuwatooriyal Gini" },
            { "GR", "Giriig" },
            { "GS", "Jasiiradda Joorjiyada Koonfureed & Sandwij" },
            { "GT", "Guwaatamaala" },
            { "GU", "Guaam" },
            { "type.nu.mathmono", "Godad Xisaabeedka Monospace" },
            { "GW", "Gini-Bisaaw" },
            { "rhg", "Rohingya" },
            { "Talu", "Tai Lue cusub" },
            { "GY", "Guyana" },
            { "ckb", "Bartamaha Kurdish" },
            { "zxx", "Luuqad Looma Hayo" },
            { "de_AT", "Jarmal Awsteeriya" },
            { "HK", "Hong Kong" },
            { "Vaii", "Dadka Vai" },
            { "HM", "Jasiiradda Haad & MakDonald" },
            { "HN", "Honduras" },
            { "HR", "Korweeshiya" },
            { "agq", "Ageem" },
            { "gsw", "Jarmal Iswiis" },
            { "type.ca.islamic-umalqura", "Taariikhda Islaamiga(Umm al-Qura)" },
            { "HT", "Haiti" },
            { "HU", "Hangari" },
            { "IC", "Jasiiradda Kanari" },
            { "ID", "Indoneesiya" },
            { "Adlm", "Adlam" },
            { "type.nu.kali", "Godadka Kayah Li" },
            { "IE", "Ayrlaand" },
            { "%%NDYUKA", "lahjada Ndyuka" },
            { "naq", "Nama" },
            { "type.nu.sora", "Godadka Sora Sompeng" },
            { "Tang", "Luuqada Tangut" },
            { "IL", "Israa\u02bciil" },
            { "Nbat", "Nabataean" },
            { "IM", "Jasiiradda Isle of Man" },
            { "IN", "Hindiya" },
            { "type.co.eor", "Xeerarka Dalabka Yurub" },
            { "IO", "Dhul xadeedka Badweynta Hindiya ee Biritishka" },
            { "IQ", "Ciraaq" },
            { "IR", "Iiraan" },
            { "IS", "Ayslaand" },
            { "IT", metaValue_IT },
            { "Zmth", "Aqoonsiga Xisaabta" },
            { "type.nu.thai", "Godka Tirada Thai" },
            { "%%POSIX", "Kombiyuutar" },
            { "type.nu.beng", "Godadka Banglaa" },
            { "type.nu.cyrl", "Lambarada Cyrillic" },
            { "JE", "Jaarsey" },
            { "type.ca.islamic", "Habeentiriska islaamka" },
            { "JM", "Jamaaika" },
            { "Beng", "Baangla" },
            { "%%EKAVSK", "dhaqyada isku jirka ah ee Serbiyaanka iyo Ekviyaan" },
            { "JO", "Urdun" },
            { "JP", "Jabaan" },
            { "%%1606NICT", "Fransiiskii dhexe ee ugu dambeeyay ilaa 1606" },
            { "Mend", "Mende" },
            { "guz", "Guusii" },
            { "type.nu.knda", "Godadka Kanada" },
            { "Kali", "Kayah LI" },
            { "Sidd", "Siddham" },
            { "de_CH", "Iswiiska Sare ee Jarmal" },
            { "type.ca.buddhist", "Habeentiriska Buudhist" },
            { "KE", "Kenya" },
            { "419", "Laatiin Ameerika" },
            { "KG", "Kirgistaan" },
            { "KH", "Kamboodiya" },
            { "KI", "Kiribati" },
            { "KM", "Komooros" },
            { "Knda", metaValue_CA },
            { "KN", "St. Kitts iyo Nevis" },
            { "Zinh", "Dhaxlay" },
            { "fr_CA", "Faransiiska Kanada" },
            { "KP", "Kuuriyada Waqooyi" },
            { "KR", "Kuuriyada Koonfureed" },
            { "Plrd", "Shibanaha" },
            { "fr_CH", "Faransiis (Iswiiserlaand)" },
            { "KW", "Kuwayt" },
            { "KY", "Cayman Islands" },
            { "KZ", "Kasaakhistaan" },
            { "Cyrl", "Siriylik" },
            { "LA", "Laos" },
            { "LB", "Lubnaan" },
            { "LC", "St. Lusia" },
            { "%%LUNA1918", "LUUNA1918" },
            { "nds", "Jarmal Hooseeya" },
            { "LI", "Liyjtensteyn" },
            { "LK", "Sirilaanka" },
            { "Hmnp", "Hmonga Nyiakeng Puachue" },
            { "LR", "Laybeeriya" },
            { "LS", "Losooto" },
            { "LT", "Lituweeniya" },
            { "LU", "Luksemboorg" },
            { "LV", "Latfiya" },
            { "Kana", "Katakaana" },
            { "Sora", "Qoraalka Sora Sompeng" },
            { "LY", "Liibya" },
            { "vun", "Fuunjo" },
            { "Mahj", "Mahajani" },
            { "lag", "Laangi" },
            { "Thaa", "Daana" },
            { "MA", "Morooko" },
            { "MC", "Moonako" },
            { "MD", "Moldofa" },
            { "Nshu", "N\u00fcshu" },
            { "ME", "Moontenegro" },
            { "MF", "St. Maartin" },
            { "MG", "Madagaskar" },
            { "MH", "Jasiiradda Maarshal" },
            { "Thai", "Taay" },
            { "type.nu.vaii", "Godadka Vai" },
            { "MK", "Masedooniya Waqooyi" },
            { "type.nu.mathdbl", "Godad Xisaabeedka Labalaabma" },
            { "ML", "Maali" },
            { "MM", "Mayanmar" },
            { "MN", "Mongooliya" },
            { "MO", "Makaaw" },
            { "MP", "Jasiiradda Waqooyiga Mariaana" },
            { "MQ", "Maartinik" },
            { "MR", "Muritaaniya" },
            { "MS", "Montserrat" },
            { "Chrs", "Luuqada Korasmiyaanka" },
            { "MT", "Maalta" },
            { "MU", "Mawrishiyaas" },
            { "MV", "Maaldiifis" },
            { "MW", "Malaawi" },
            { "MX", "Meksiko" },
            { "type.ca.japanese", "Habeentiriska jabbaanka" },
            { "MY", "Malaysiya" },
            { "MZ", "Musambiik" },
            { "Phli", "Qoraaladii hore ee Pahlavi" },
            { "NA", "Namiibiya" },
            { "202", "Afrikada ka hooseysa Saxaraha" },
            { "type.ca.hebrew", "Habeentiriska yuhuudda" },
            { "type.co.dictionary", "Isku hagaajinta Qaamuuska" },
            { "NC", "Jasiiradda Niyuu Kaledooniya" },
            { "%%UCRCOR", "orthographyga mideeysan ee hadana ladul maray" },
            { "NE", "Nayjer" },
            { "NF", "Jasiiradda Noorfolk" },
            { "NG", "Nayjeeriya" },
            { "Phlp", "Qoraalka midig laga bilaabo ee faarsiyiintii" },
            { "NI", "Nikaraaguwa" },
            { "Hmng", "Hmonga pahawh" },
            { "NL", "Nederlaands" },
            { "NO", "Noorweey" },
            { "NP", "Nebaal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "Phnx", "Luuqada Phoenicianka" },
            { "rof", "Rombo" },
            { "NZ", "Niyuusiilaand" },
            { "Merc", "Meroitic Curve" },
            { "%%COLB1945", "Shirkii orthografiga ee Portuguese-Brazilian 1945" },
            { "Mero", "Meroitic" },
            { "OM", "Cumaan" },
            { "type.nu.hmnp", "Godadka Nyiakeng Puachue Hmong" },
            { "Xpeo", "Faarsigii Hore" },
            { "type.nu.hmng", "Nidaam Tireedka Hebrew" },
            { "PA", "Baanama" },
            { "type.ca.islamic-civil", "Taariikhda Islaamiga (tabular, civil epoch)" },
            { "en_GB", "Ingiriis Biritish" },
            { "PE", "Beeru" },
            { "PF", "Booliyneesiya Faransiiska" },
            { "PG", "Babwa Niyuu Gini" },
            { "PH", "Filibiin" },
            { "PK", "Bakistaan" },
            { "%%NICARD", "KAARKANI" },
            { "PL", "Booland" },
            { "ewo", "Eewondho" },
            { "PM", "St. Pierre iyo Miquelon" },
            { "PN", "Bitkairn" },
            { "PR", "Bueerto Riiko" },
            { "PS", "Dhulka Falastiiniyiinta daanta galbeed iyo marinka qasa" },
            { "Bali", "Baliniis" },
            { "PT", "Bortugaal" },
            { "PW", "Balaaw" },
            { "type.nu.greklow", "Nidaam Tireedka Yaryar ee Giriiga" },
            { "PY", "Baraguaay" },
            { "Hebr", metaValue_he },
            { "QA", "Qadar" },
            { "%%SCOTLAND", "Heerka Ingiriisiga Iskootishka" },
            { "QO", "Dhulxeebeedka Osheeniya" },
            { "type.nu.ahom", "Godadka Ahom" },
            { "type.nu.takr", "Godadka Takri" },
            { "Tavt", "Farta lagu Qoro Luuqadaha Tai" },
            { "Maka", "Makasar" },
            { "001", "Dunida" },
            { "002", "Afrika" },
            { "003", "Waqooyi Ameerika" },
            { "RE", "Riyuuniyon" },
            { "005", "Koonfur Ameerika" },
            { "Rjng", "Dadka Rejan" },
            { "009", "Osheeniya" },
            { "Elym", "Qoraalka Elymaic" },
            { "RO", "Rumaaniya" },
            { "RS", "Seerbiya" },
            { "Mroo", "Mro" },
            { "RU", metaValue_RU },
            { "RW", "Ruwanda" },
            { "type.nu.talu", "Godadka cusub ee Tai Lue" },
            { "%%METELKO", "alfaabeetka nmetelko" },
            { "Mani", "Manichaean" },
            { "Ugar", "Luuqada Ugaritic" },
            { "Khar", "Koraalka kharooshi" },
            { "SA", "Sacuudi Carabiya" },
            { "Mand", "Luuqada Mandaean" },
            { "SB", "Jasiiradda Solomon" },
            { "twq", "Tasaawaq" },
            { "011", "Galbeeka Afrika" },
            { "SC", "Sishelis" },
            { "SD", "Suudaan" },
            { "013", "Bartamaha Ameerika" },
            { "SE", "Iswidhan" },
            { "014", "Afrikada Bari" },
            { "015", "Waqooyiga Afrika" },
            { "SG", "Singaboor" },
            { "SH", "Saynt Helena" },
            { "type.lb.strict", "Habka Jabinta Xariiqda Adag" },
            { "017", "Afrikada Dhexe" },
            { "SI", "Islofeeniya" },
            { "type.nu.mymrtlng", "Godadka Myanmar Tai Laing" },
            { "018", "Afrikada Koonfureed" },
            { "SJ", "Jasiiradda Sfaldbaad & Jaan Mayen" },
            { "019", "Ameerikaas" },
            { "SK", "Islofaakiya" },
            { "Bamu", "Bamum" },
            { "SL", "Siraaliyoon" },
            { "SM", "San Marino" },
            { "SN", "Sinigaal" },
            { "SO", "Soomaaliya" },
            { "type.nu.taml", "Nidaam Tireedki Hore ee Taaamiil" },
            { "SR", "Surineym" },
            { "SS", "Koonfur Suudaan" },
            { "ST", "Sao Tome & Birincibal" },
            { "SV", "El Salfadoor" },
            { "SX", "Siint Maarteen" },
            { "SY", "Suuriya" },
            { "SZ", "Eswaatiini" },
            { "TA", "Tiristan da Kunha" },
            { "asa", "Asu" },
            { "type.ms.ussystem", "Nidaamka Cabbirka ee US" },
            { "021", "Waqooyiga Ameerika" },
            { "TC", "Turks & Kaikos Island" },
            { "yav", "Yaangbeen" },
            { "TD", "Jaad" },
            { "Qaag", "Qoraalka Sawgiga" },
            { "TF", "Dhul xadeedka Koonfureed ee Faransiiska" },
            { "TG", "Toogo" },
            { "TH", "Taylaand" },
            { "TJ", "Tajikistan" },
            { "029", "Karibiyaan" },
            { "TK", "Tokelaaw" },
            { "TL", "Timoor" },
            { "type.co.searchjl", "Raadinta Shibanaha Hangul" },
            { "TM", "Turkmenistan" },
            { "%%BOONT", "Luuqada Boontling" },
            { "TN", "Tuniisiya" },
            { "TO", "Tonga" },
            { "%%NULIK", "Folabuka casriga ah" },
            { "TR", "Turki" },
            { "TT", "Tirinidaad & Tobago" },
            { "TV", "Tufaalu" },
            { "TW", "Taywaan" },
            { "ast", "Astuuriyaan" },
            { "Orkh", "Orkhon" },
            { "TZ", "Tansaaniya" },
            { "nmg", "Kuwaasiyo" },
            { "Zzzz", "Far aan la aqoon amase aan saxnayn" },
            { "Sind", "khudwadi" },
            { "UA", "Yukrayn" },
            { "030", "Aasiyada Bari" },
            { "034", "Aasiyada Koonfureed" },
            { "035", "Aasiyada Koonfur-galbeed" },
            { "UG", "Ugaanda" },
            { "type.co.pinyin", "Isku hagaajinta Pinyin" },
            { "039", "Yurubta Koonfureed" },
            { "Sinh", "Sinhaala" },
            { "UM", "Jasiiradaha ka baxsan Maraykanka" },
            { "UN", "Qaramada Midoobay" },
            { "US", "Maraykanka" },
            { "haw", "Hawaay" },
            { "%%1959ACAD", "Tacliin" },
            { "type.co.gb2312han", "Isku hagaajinta Farta shiineeska" },
            { "UY", "Uruguwaay" },
            { "prg", "Brashiyaanki Hore" },
            { "UZ", "Usbakistan" },
            { "tzm", "Bartamaha Atlaas Tamasayt" },
            { "type.co.stroke", "Isku hagaajinta Farta" },
            { "nnh", "Ingiyembuun" },
            { "VA", "Faatikaan" },
            { "VC", "St. Finsent & Girenadiins" },
            { "VE", "Fenisuweela" },
            { "VG", "Biritish Farjin Island" },
            { "VI", "U.S Fargin Island" },
            { "Soyo", "Soyombo" },
            { "VN", "Fiyetnaam" },
            { "VU", "Fanuaatu" },
            { "Marc", "Marchen" },
            { "rwk", "Raawa" },
            { "053", "Austraalaasiya" },
            { "054", "Melaneesiya" },
            { "WF", "Walis & Futuna" },
            { "type.co.traditional", "Isku hagaajin Fareedkii Hore" },
            { "057", "Gobolka Aasiyada yar" },
            { "jgo", "Ingoomba" },
            { "lkt", "Laakoota" },
            { "type.co.compat", "Iswaafajinta Isku hajintii hore" },
            { "wae", "Walseer" },
            { "WS", "Samoowa" },
            { "Bass", "Qoraalka Vah" },
            { "type.nu.mtei", "Godadka Meetei Mayek" },
            { "XA", "Lahjadaha Pseudo" },
            { "XB", "Pseudo-Bidi" },
            { "061", "Booliyneesiya" },
            { "%%KSCOR", "heerka orthographyga" },
            { "XK", "Koosofo" },
            { "type.nu.brah", "Godadka Brahmi" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "Aan la qorin" },
            { "Olck", "Ol Jiki" },
            { "Batk", "Batak" },
            { "YE", "Yaman" },
            { "type.co.standard", "Amarka Kala Soocidda Caadiga ah" },
            { "Zanb", "Xarafka laba jibaaran ee kujira Xarfaha Zanabazar" },
            { "%%BALANKA", "Lahjada Balanka ee Anii" },
            { "Sgnw", "Qaabka dhagoolka loola hadlo" },
            { "YT", "Mayotte" },
            { "type.nu.cham", "Godadka cham" },
            { "%%NEWFOUND", "HELITAANCUSUB" },
            { "ZA", "Koonfur Afrika" },
            { "type.nu.sund", "Godadka Sundaniiska" },
            { "type.lb.loose", "Habka Jabinta Xariiqda Dabacsan" },
            { "Deva", "Dhefangaari" },
            { "type.nu.geor", "Nidaam Tireedka Giyoorgiyaanka" },
            { "type.co.zhuyin", "Isku hagaajinta Farta Zhuyin" },
            { "Hira", "Hiragana" },
            { "ZM", "Saambiya" },
            { "ZW", "Simbaabwe" },
            { "ZZ", "Gobol aan la aqoonin" },
            { "Runr", "Dadka Rejang" },
            { "type.ms.metric", "Nidaamka Metric" },
            { "type.ca.iso8601", "Habeentiriska ISO-8601" },
            { "type.nu.telu", "Godka Tirada Telugu" },
            { "lou", "Louisiana Creole" },
            { "jmc", "Chaga" },
            { "type.nu.hansfin", "Nidaam Tireedka Hore La Fududeeyay ee Dhaqaalaha Shiinaha" },
            { "type.nu.arabext", "Tirooyinka Dheeraadka ah ee Godadka Carabi-Hindiya" },
            { "nus", "Nuweer" },
            { "type.nu.fullwide", "Ballac Godadka Buuxa" },
            { "dav", "Taiita" },
            { "lrc", "Luri Waqooyi" },
            { "type.co.emoji", "Isku hagaajinta Emojiga" },
            { "Copt", "Dadka Kotiga" },
            { "Khmr", "Khamer" },
            { "type.ca.islamic-rgsa", "Habeentiriska Islaamka (Sacuudiga, aragtida)" },
            { "Limb", "Limbu" },
            { "type.nu.roman", "Nidaam Tireedka Roomaanka" },
            { "sah", "Saaqa" },
            { "type.nu.shrd", "Godadka Sharada" },
            { "Aghb", "Qoraalka Luuqada Caucasian Albanian" },
            { "%%SCOUSE", "GARAACID" },
            { "saq", "Sambuuru" },
            { "sat", "Santali" },
            { "Tfng", "Farta Tifinagh" },
            { "Guru", "Luuqada gujarati" },
            { "%%ALUKU", "Lahjada Aluku" },
            { "type.nu.diak", "Godadka Dives Akuru" },
            { "type.nu.tirh", "Godadka Tirhuta" },
            { "sbp", "Sangu" },
            { "nyn", "Inyankoole" },
            { "luo", "Luwada" },
            { "fil", "Filibiino" },
            { "hmn", "Hamong" },
            { "type.nu.wara", "Godadka Warang Citi" },
            { "luy", "Luyia" },
            { "bas", "Basaa" },
            { "%%ABL1943", "Qaacideeynta orthographygii 1943" },
            { "es_ES", "Isbaanish (Isbayn)" },
            { "Aran", "Farta Luuqada Faarsiga" },
            { "af", "Afrikaanka" },
            { "ak", "Akan" },
            { "type.nu.cakm", "Godadka Chakma" },
            { "am", "Axmaari" },
            { "Arab", metaValue_ar },
            { "%%SOLBA", "lahjada Stolvizza/Solbica" },
            { "Jpan", metaValue_ja },
            { "ar", metaValue_ar },
            { "Hrkt", "Qoraalka Xuruufta Jabaaniiska" },
            { "as", "Asaamiis" },
            { "Lina", "Nidaamka qoraalka Linear A" },
            { "Linb", "Nidaamka qoraalka Linear B" },
            { "az", "Asarbayjan" },
            { "Rohg", "Hanifi Rohingya" },
            { "Khoj", "Qoraalka Khojki" },
            { "%%OSOJS", "lahjada Oseacco/Osojane" },
            { "type.co.unihan", "Isku hagaajinta Farta Radical-Stroke" },
            { "be", "Beleruusiyaan" },
            { "bg", "Bulgeeriyaan" },
            { "type.nu.java", "Godadka Javanese" },
            { "bm", "Bambaara" },
            { "bn", "Bangladesh" },
            { "bo", "Tibeetaan" },
            { "br", "Biriton" },
            { "bs", "Bosniyaan" },
            { "Bhks", "Qoraalka Bhaiksuki" },
            { "Mymr", "Mayanmaar" },
            { "type.nu.laoo", "Godadka Laao" },
            { "seh", "Seena" },
            { "Nkoo", "N\u2019Ko" },
            { "ca", "Katalaan" },
            { "ses", "Koyraboro Seenni" },
            { "ce", "Jejen" },
            { "co", "Korsikan" },
            { "Orya", metaValue_or },
            { "cs", "Jeeg" },
            { "cu", "Kaniisadda Islaafik" },
            { "cy", "Welsh" },
            { "type.nu.ethi", "Nidaam Tireedka Itoobiya" },
            { "Yiii", "Tiknoolajiyada Yi" },
            { "da", "Dhaanish" },
            { "pt_PT", "Boortaqiis (Boortuqaal)" },
            { "de", metaValue_DE },
            { "type.cf.standard", "Habka Heerka Lacagta" },
            { "Bugi", "Luuqada Buginiiska" },
            { "bem", "Bemba" },
            { "type.nu.mong", "Godadka Mongooliyaanka" },
            { "es_419", "Isbaanishka Laatiin Ameerika" },
            { "dz", "D\u2019zongqa" },
            { "bez", "Bena" },
            { "type.ca.chinese", "Habeetiriska Shiinaha" },
            { "Lisu", "Wabiga Fraser" },
            { "dje", "Sarma" },
            { "type.nu.grek", "Nidaam Tireedka Giriiga" },
            { "ee", "Eewe" },
            { "type.lb.normal", "Habka Jabinta Xariiqda Caadiga ah" },
            { "el", metaValue_el },
            { "en", "Ingiriisi" },
            { "eo", "Isberaanto" },
            { "type.co.big5han", "Isku hagaajinta Shiineeskii Hore - Big5" },
            { "es", "Isbaanish" },
            { "et", "Istooniyaan" },
            { "Hanb", "Han iyo Bobomofo" },
            { "eu", "Basquu" },
            { "Buhd", "Luuqada Buhid" },
            { "Hang", "Hanguul" },
            { "Samr", "Dadka Samaritan" },
            { "shi", "Shilha" },
            { "hsb", "Sorobiyaanka Sare" },
            { "Hani", "Han" },
            { "Hano", "Qoraalka Hanunoo" },
            { "fa", "Faarisi" },
            { "Hans", "La fududeeyay" },
            { "type.nu.latn", "Godadka Ree Galbeedka" },
            { "Hant", "Hore" },
            { "ff", "Fuulah" },
            { "fi", "Finishka" },
            { "yue", "Kantoneese" },
            { "fo", "Farowsi" },
            { "fr", metaValue_FR },
            { "fy", "Firiisiyan Galbeed" },
            { "ga", "Ayrish" },
            { "Wcho", "Dadka wanjo" },
            { "gd", "Iskot Giilik" },
            { "Gong", "Gumjala Gondi" },
            { "gl", "Galiisiyaan" },
            { "Gonm", "Qoraalka Masaram Gondi" },
            { "und", "Af aan la aqoon ama aan sax ahayn" },
            { "type.ca.ethiopic-amete-alem", "Taariikhda Itoobiya ee Amete Alem" },
            { "gu", metaValue_gu },
            { "type.ca.islamic-tbla", "Taariikhda Islaamiga (tabular, astronomical epoch)" },
            { "gv", "Mankis" },
            { "type.nu.osma", "Godadka Osmanya" },
            { "ha", "Hawsa" },
            { "he", metaValue_he },
            { "hi", "Hindi" },
            { "hr", "Koro\u2019eeshiyaan" },
            { "ht", "Heeytiyaan Karawle" },
            { "hu", "Hangariyaan" },
            { "hy", metaValue_hy },
            { "frc", "Faransiiska Cajun" },
            { "ia", "Interlinguwa" },
            { "Jamo", "Jaamo" },
            { "id", "Indunusiyaan" },
            { "type.nu.tibt", "Godka Tirada Tibetan" },
            { "ig", "Igbo" },
            { "ii", "Sijuwan Yi" },
            { "%%AO1990", "Heshiiska luuqada orthografiga burtuqiiska 1990" },
            { "is", "Ayslandays" },
            { "it", metaValue_IT },
            { "ja", metaValue_ja },
            { "Mlym", "Maalayalam" },
            { "Sarb", "Crabiyaankii Hore ee Wuqooyi" },
            { "doi", "Dogri" },
            { "type.nu.lepc", "Godadka Lepcha" },
            { "jv", "Jafaaniis" },
            { "Shaw", "calaamad qoris" },
            { "mai", "Dadka Maithili" },
            { "smn", "Inaari Saami" },
            { "ka", "Joorijiyaan" },
            { "Goth", "Dadka Gothic" },
            { "ki", "Kikuuyu" },
            { "mas", "Masaay" },
            { "kk", "Kasaaq" },
            { "kl", "Kalaallisuut" },
            { "km", "Kamboodhian" },
            { "kn", "Kannadays" },
            { "ko", metaValue_ko },
            { "ks", "Kaashmiir" },
            { "Lepc", "Lebja" },
            { "Avst", "Luuqada Avestan" },
            { "ku", "Kurdishka" },
            { "kw", "Kornish" },
            { "ky", "Kirgiis" },
            { "Mult", "Multani" },
            { "la", metaValue_la },
            { "Hatr", "Qoraalka Hatran" },
            { "lb", "Luksaamboorgish" },
            { "type.nu.mlym", "Godadka Malayalam" },
            { "lg", "Gandha" },
            { "Tibt", "Tibetaan" },
            { "ln", "Lingala" },
            { "fur", "Firiyuuliyaan" },
            { "lo", "Lao" },
            { "type.ms.uksystem", "Nidaamka Cabbirka Imperial-ka" },
            { "type.nu.lana", "Godadka Tai Tham Hora" },
            { "lt", "Lituwaanays" },
            { "lu", "Luuba-kataanga" },
            { "lv", "Laatfiyaan" },
            { "mg", "Malagaasi" },
            { "type.co.ducet", "Lambar Sireedka Caalamiga ee Kala Soocidda Dalabka" },
            { "mi", "Maaoori" },
            { "mk", "Masadooniyaan" },
            { "ml", "Malayalam" },
            { "mn", "Mangooli" },
            { "mr", "Maarati" },
            { "ms", "Malaay" },
            { "mt", "Maltiis" },
            { "my", "Burmese" },
            { "Saur", "Sawrashtra" },
            { "Armn", metaValue_hy },
            { "dsb", "Soorbiyaanka Hoose" },
            { "Armi", "Luuqada Imperial Aramaic" },
            { "type.co.search", "Raadinta Guud" },
            { "nb", "Nawrijii Bokm\u00e5l" },
            { "nd", "Indhebeele Waqooyi" },
            { "ne", "Nebaali" },
            { "nl", "Holandays" },
            { "nn", "Nawriijiga Nynorsk" },
            { "no", "Nawriiji" },
            { "type.nu.modi", "Godadka Modi" },
            { "Osge", "Osage" },
            { "ny", "Inyaanja" },
            { "kab", "Kabayle" },
            { "kam", "Kaamba" },
            { "%%EMODENG", "Ingiriiskii hore ee casriga ahaa" },
            { "mer", "Meeru" },
            { "type.nu.armn", "Nidaam Tireedka Armeeniya" },
            { "om", "Oromo" },
            { "or", metaValue_or },
            { "Modi", "Moodi" },
            { "os", "Oseetic" },
            { "%%ALALC97", "ALA-LC Romanization, 1997 daabacaad" },
            { "mfe", "Moorisayn" },
            { "pa", "Bunjaabi" },
            { "dua", "Duaala" },
            { "%%LIPAW", "Lahjada Lipavaz ee Resiyaanka" },
            { "pl", "Boolish" },
            { "type.nu.saur", "Godadka Saurashtra" },
            { "type.ca.dangi", "Habeetiriska Dangi" },
            { "ps", "Bashtuu" },
            { "pt", "Boortaqiis" },
            { "key.co", "Kala Soocidda Dalabka" },
            { "pt_BR", "Boortaqiiska Baraasiil" },
            { "%%BOHORIC", "Farta Bohori\u010d" },
            { "mgh", "Makhuwa" },
            { "key.cf", "Habka Lacagta" },
            { "type.nu.nkoo", "Godadka N\u2019Ko" },
            { "key.ca", "Habeentiris" },
            { "Laoo", "Dalka Lao" },
            { "mgo", "Meetaa" },
            { "type.hc.h23", "24 Saac ee Nidaamka Saacadda (0\u201323)" },
            { "type.hc.h24", "24 Saac ee Nidaamka Saacadda (1\u201324)" },
            { "type.nu.mymr", "Godadka Mayanmaar" },
            { "qu", "Quwejuwa" },
            { "brx", "Bodo" },
            { "Lana", "Lanna" },
            { "kde", "Kimakonde" },
            { "Ethi", metaValue_ET },
            { "type.hc.h12", "12 Saac ee Nidaamka Saacadda (1\u201312)" },
            { "type.hc.h11", "12 Saac ee Nidaamka Saacadda (0\u201312)" },
            { "rm", "Romaanis" },
            { "rn", "Rundhi" },
            { "key.cu", "Lacagta" },
            { "ro", "Romanka" },
            { "%%SAAHO", "Saaho" },
            { "type.nu.orya", "Godadka Oodhiya" },
            { "type.nu.hanidec", "Nidaamka Tireedka Tobanle ee Shiinaha" },
            { "ru", metaValue_RU },
            { "rw", "Ruwaandha" },
            { "kea", "Kabuferdiyanu" },
            { "en_AU", "Ingiriis Austaraaliyaan" },
            { "Dupl", "Qoraalka Duployan shorthand" },
            { "sa", "Sanskrit" },
            { "%%UCCOR", "orthograpghyga mideeysan" },
            { "sd", "Siindhi" },
            { "se", "Sami Waqooyi" },
            { "sg", "Sango" },
            { "si", "Sinhaleys" },
            { "sk", "Isloofaak" },
            { "sl", "Islofeeniyaan" },
            { "Gran", "Qoraalka Grantha" },
            { "sm", "Samowan" },
            { "sn", "Shoona" },
            { "so", "Soomaali" },
            { "type.nu.arab", "Gdadka Carabi-Hindiya" },
            { "sq", "Albeeniyaan" },
            { "sr", "Seerbiyaan" },
            { "type.cf.account", "Habka Xisaabinta Lacagta" },
            { "st", "Sesooto" },
            { "Java", "Jafaniis" },
            { "su", "Suudaaniis" },
            { "%%NEDIS", "lahjada Natisone" },
            { "sv", "Iswiidhish" },
            { "sw", "Sawaaxili" },
            { "type.nu.wcho", "Godadka Wancho" },
            { "type.nu.hantfin", "Nidaam Tireedkii Hore ee Dhaqaalaha Shiinaha" },
            { "ta", "Tamiil" },
            { "142", "Aasiya" },
            { "143", "Bartamaha Aasiya" },
            { "te", "Teluugu" },
            { "145", "Aasiyada Galbeed" },
            { "tg", "Taajik" },
            { "th", "Taaylandays" },
            { "ti", "Tigrinya" },
            { "en_CA", "Ingiriis Kanadiyaan" },
            { "tk", "Turkumaanish" },
            { "to", "Toongan" },
            { "dyo", "Joola-Foonyi" },
            { "type.nu.jpan", "Nidaam Tireedka Jabbaanka" },
            { "tr", "Turkish" },
            { "Cakm", metaValue_ccp },
            { "tt", "Taatar" },
            { "%%BISKE", "Lahjada San Giorgio/Bila" },
            { "150", "Yurub" },
            { "151", "Yurubta Bari" },
            { "type.nu.rohg", "Godadka Hanifi Rohingya" },
            { "type.nu.mathsanb", "Godad xisaabeedka waaweeyn ee Sans-Serif" },
            { "154", "Yurubta Waqooyi" },
            { "155", "Yurubta Galbeed" },
            { "ug", "Uighur" },
            { "Kore", metaValue_ko },
            { "Ital", "Itaaliggii Hore" },
            { "Zyyy", "Caadi ahaan" },
            { "uk", "Yukreeniyaan" },
            { "type.ca.coptic", "Habeentiriska Koptiga" },
            { "ur", "Urduu" },
            { "%%1994", "Heerka orthographyga Resiyaanka" },
            { "uz", "Usbakis" },
            { "%%1996", "Orthigraphygii jarmal ee 1996" },
            { "Sylo", "Qoraalka Luuqada Sylheti" },
            { "Wara", "Nidaamka Qoraalka Luuqada Ho" },
            { "type.ca.roc", "Habeentiriska Minguwo" },
            { "vi", "Fiitnaamays" },
            { "khq", "Koyra Jiini" },
            { "key.hc", "Wareegga Saacadda (12 ilaa 24)" },
            { "%%TARASK", "orthographyga Taraskievica" },
            { "vo", "Folabuuk" },
            { "type.nu.mathsans", "Godad xisaabeedka Sans-Serif" },
            { "Osma", "Osmanya" },
            { "type.nu.gonm", "Lambarada Masaram Gondi" },
            { "Newa", "Newa" },
            { "type.nu.gong", "Godadka Gunjala Gondi" },
            { "Grek", metaValue_el },
            { "Lydi", "Lydian" },
            { "Xsux", "Qoraalkii Hore ee dadka Sumaariyiinta ee dhulka mesobataamiya" },
            { "wo", "Woolof" },
            { "zgh", "Morokaanka Tamasayt Rasmiga" },
            { "ar_001", "Carabiga rasmiga ah" },
            { "Cans", "Qoraalka Luuqada Aborajiinka ee Kanada" },
            { "Mong", "Mongooliyaan" },
            { "Hluw", "Qoraalka Anatolian Hieroglyphs" },
            { "mni", "Maniburi" },
            { "Latn", metaValue_la },
            { "Nand", "Nandinagari" },
            { "type.nu.hans", "Nidaam Tireedka Hore La Fududeeyay ee Shiinaha" },
            { "type.nu.hant", "Nidaam Tireedka Hore ee Shiinaha" },
            { "xh", "Hoosta" },
            { "type.nu.romanlow", "Nidaam Tireedka yaryar ee Roomaanka" },
            { "Dogr", "Dadka Dogra" },
            { "Lyci", "Lyciantii Hore" },
            { "kkj", "Kaako" },
            { "%%1694ACAD", "Faransiiskii Hore" },
            { "yi", "Yadhish" },
            { "Syrc", "Lahjada Syriac" },
            { "Dsrt", "Gobalka Deseret" },
            { "yo", "Yoruuba" },
            { "es_MX", "Isbaanishka Mexico" },
            { "vai", "Faayi" },
            { "Cari", "Luuqada kaariyaanka" },
            { "kln", "Kalenjiin" },
            { "zh", "Shiinaha Mandarin" },
            { "Bopo", "Bobomofo" },
            { "Perm", "Permic gii hore" },
            { "key.lb", "Habka Jebinta Xariiqda" },
            { "zu", "Zuulu" },
            { "type.co.phonebook", "Isku hagaajinta foonbuuga" },
            { "%%MONOTON", "MOONOTOONIK" },
            { "Geor", metaValue_GE },
            { "Shrd", "Sharada" },
            { "%%LENGADOC", "LENGADOK" },
            { "type.nu.jpanfin", "Nidaam Tireedka Dhaqaalaha Jabbaanka" },
            { "Cham", "Jam" },
            { "type.nu.mymrshan", "Godadka Myanmar Shan" },
            { "Elba", "Magaalada Elbasan" },
            { "Narb", "Carabiyadii Hore ee Wuqooye" },
            { "type.nu.olck", "Godadka Ol Chiki" },
            { "type.co.reformed", "Isku hagaajinta Reformed" },
            { "Tglg", "Luuqada Tagalog" },
            { "Yezi", "Dadka Yesiidiga" },
            { "Palm", "Palmyrene" },
            { "ebu", "Embu" },
            { "Egyp", "Fartii hore ee Masaarida" },
            { "zh_Hans", "Shiinaha Rasmiga ah" },
            { "Hung", "Hangariyaankii Hore" },
            { "kok", "Konkani" },
            { "%%1901", "orthofraphygii hore ee Jarmalka" },
            { "type.nu.limb", "Godadka Limbu" },
            { "zh_Hant", "Shiinahii Hore" },
            { "Sund", "Dadka Sundaniiska" },
            { "type.nu.khmr", "Godadka Khamer" },
            { "Tirh", "Qoraalka Luuqada Maithili" },
            { "%%VALENCIA", "Faleensiyaawi" },
            { "Cprt", "sibraas dhalad ah" },
            { "Diak", "Luuqadaha Dives Akuru" },
            { "%%BAKU1926", "Farta Latin Turkiga ee Mideeysan" },
            { "%%IJEKAVSK", "dhawaaqyada Serbiyaanka iyo Ijekaviyaan" },
            { "mua", "Miyundhaang" },
            { "type.nu.guru", "Godadka Gurmukhi" },
            { "%%BORNHOLM", "BOONHOLM" },
            { "mul", "Luuqado kala duwan" },
            { "key.ms", "Nidaamka Cabbiraadda" },
            { "Glag", "Qoraalka Glagolitic" },
            { "%%KKCOR", "orhographyga caadiga ah" },
            { "Cher", "Jerokee" },
            { "type.nu.tamldec", "Godka Tirada Taamiil" },
            { "fa_AF", "Faarsi" },
            { "%%OXENDICT", "hinggaadinta Qaamuuska Ingiriisiga Oxford" },
            { "key.nu", "Tirooyinka" },
            { "ksb", "Shambaala" },
            { "Telu", "Teeluguu" },
            { "ksf", "Bafiya" },
        };
        return data;
    }
}
