/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_cs extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Greenwichsk\u00fd st\u0159edn\u00ed \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Acre = new String[] {
               "Acrejsk\u00fd standardn\u00ed \u010das",
               "",
               "Acrejsk\u00fd letn\u00ed \u010das",
               "",
               "Acrejsk\u00fd \u010das",
               "",
            };
        final String[] Apia = new String[] {
               "Apijsk\u00fd standardn\u00ed \u010das",
               "",
               "Apijsk\u00fd letn\u00ed \u010das",
               "",
               "Apijsk\u00fd \u010das",
               "",
            };
        final String[] Cook = new String[] {
               "Standardn\u00ed \u010das Cookov\u00fdch ostrov\u016f",
               "",
               "Letn\u00ed \u010das Cookov\u00fdch ostrov\u016f",
               "",
               "\u010cas Cookov\u00fdch ostrov\u016f",
               "",
            };
        final String[] Cuba = new String[] {
               "Kub\u00e1nsk\u00fd standardn\u00ed \u010das",
               "",
               "Kub\u00e1nsk\u00fd letn\u00ed \u010das",
               "",
               "Kub\u00e1nsk\u00fd \u010das",
               "",
            };
        final String[] Fiji = new String[] {
               "Fid\u017eijsk\u00fd standardn\u00ed \u010das",
               "",
               "Fid\u017eijsk\u00fd letn\u00ed \u010das",
               "",
               "Fid\u017eijsk\u00fd \u010das",
               "",
            };
        final String[] Gulf = new String[] {
               "Standardn\u00ed \u010das Persk\u00e9ho z\u00e1livu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Hovdsk\u00fd standardn\u00ed \u010das",
               "",
               "Hovdsk\u00fd letn\u00ed \u010das",
               "",
               "Hovdsk\u00fd \u010das",
               "",
            };
        final String[] Iran = new String[] {
               "\u00cdr\u00e1nsk\u00fd standardn\u00ed \u010das",
               "",
               "\u00cdr\u00e1nsk\u00fd letn\u00ed \u010das",
               "",
               "\u00cdr\u00e1nsk\u00fd \u010das",
               "",
            };
        final String[] Niue = new String[] {
               "Niuejsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Omsk\u00fd standardn\u00ed \u010das",
               "",
               "Omsk\u00fd letn\u00ed \u010das",
               "",
               "Omsk\u00fd \u010das",
               "",
            };
        final String[] Peru = new String[] {
               "Peru\u00e1nsk\u00fd standardn\u00ed \u010das",
               "",
               "Peru\u00e1nsk\u00fd letn\u00ed \u010das",
               "",
               "Peru\u00e1nsk\u00fd \u010das",
               "",
            };
        final String[] Truk = new String[] {
               "Chuuksk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "\u010cas ostrova Wake",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Casey = new String[] {
               "\u010cas Caseyho stanice",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Chilsk\u00fd standardn\u00ed \u010das",
               "",
               "Chilsk\u00fd letn\u00ed \u010das",
               "",
               "Chilsk\u00fd \u010das",
               "",
            };
        final String[] China = new String[] {
               "\u010c\u00ednsk\u00fd standardn\u00ed \u010das",
               "",
               "\u010c\u00ednsk\u00fd letn\u00ed \u010das",
               "",
               "\u010c\u00ednsk\u00fd \u010das",
               "",
            };
        final String[] Cocos = new String[] {
               "\u010cas Kokosov\u00fdch ostrov\u016f",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "\u010cas Davisovy stanice",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Indick\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Japan = new String[] {
               "Japonsk\u00fd standardn\u00ed \u010das",
               "",
               "Japonsk\u00fd letn\u00ed \u010das",
               "",
               "Japonsk\u00fd \u010das",
               "",
            };
        final String[] Korea = new String[] {
               "Korejsk\u00fd standardn\u00ed \u010das",
               "",
               "Korejsk\u00fd letn\u00ed \u010das",
               "",
               "Korejsk\u00fd \u010das",
               "",
            };
        final String[] Nauru = new String[] {
               "Naursk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Nep\u00e1lsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Palausk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Samojsk\u00fd standardn\u00ed \u010das",
               "",
               "Samojsk\u00fd letn\u00ed \u010das",
               "",
               "Samojsk\u00fd \u010das",
               "",
            };
        final String[] Syowa = new String[] {
               "\u010cas stanice \u0160\u00f3wa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Ton\u017esk\u00fd standardn\u00ed \u010das",
               "",
               "Ton\u017esk\u00fd letn\u00ed \u010das",
               "",
               "Ton\u017esk\u00fd \u010das",
               "",
            };
        final String[] Yukon = new String[] {
               "Yukonsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Alaska = new String[] {
               "Alja\u0161sk\u00fd standardn\u00ed \u010das",
               "AKST",
               "Alja\u0161sk\u00fd letn\u00ed \u010das",
               "AKDT",
               "Alja\u0161sk\u00fd \u010das",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Amazonsk\u00fd standardn\u00ed \u010das",
               "",
               "Amazonsk\u00fd letn\u00ed \u010das",
               "",
               "Amazonsk\u00fd \u010das",
               "",
            };
        final String[] Anadyr = new String[] {
               "Anadyrsk\u00fd standardn\u00ed \u010das",
               "",
               "Anadyrsk\u00fd letn\u00ed \u010das",
               "",
               "Anadyrsk\u00fd \u010das",
               "",
            };
        final String[] Azores = new String[] {
               "Azorsk\u00fd standardn\u00ed \u010das",
               "",
               "Azorsk\u00fd letn\u00ed \u010das",
               "",
               "Azorsk\u00fd \u010das",
               "",
            };
        final String[] Bhutan = new String[] {
               "Bh\u00fat\u00e1nsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Brunejsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Standardn\u00ed \u010das Velikono\u010dn\u00edho ostrova",
               "",
               "Letn\u00ed \u010das Velikono\u010dn\u00edho ostrova",
               "",
               "\u010cas Velikono\u010dn\u00edho ostrova",
               "",
            };
        final String[] Guyana = new String[] {
               "Guyansk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Izraelsk\u00fd standardn\u00ed \u010das",
               "",
               "Izraelsk\u00fd letn\u00ed \u010das",
               "",
               "Izraelsk\u00fd \u010das",
               "",
            };
        final String[] Kosrae = new String[] {
               "Kosrajsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "\u010cas Mawsonovy stanice",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Moskevsk\u00fd standardn\u00ed \u010das",
               "",
               "Moskevsk\u00fd letn\u00ed \u010das",
               "",
               "Moskevsk\u00fd \u010das",
               "",
            };
        final String[] Ponape = new String[] {
               "Ponapsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "Samarsk\u00fd standardn\u00ed \u010das",
               "",
               "Samarsk\u00fd letn\u00ed \u010das",
               "",
               "Samarsk\u00fd \u010das",
               "",
            };
        final String[] Tahiti = new String[] {
               "Tahitsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Tchajpejsk\u00fd standardn\u00ed \u010das",
               "",
               "Tchajpejsk\u00fd letn\u00ed \u010das",
               "",
               "Tchajpejsk\u00fd \u010das",
               "",
            };
        final String[] Tuvalu = new String[] {
               "Tuvalsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "\u010cas stanice Vostok",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "\u010cas ostrov\u016f Wallis a Futuna",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Arabsk\u00fd standardn\u00ed \u010das",
               "",
               "Arabsk\u00fd letn\u00ed \u010das",
               "",
               "Arabsk\u00fd \u010das",
               "",
            };
        final String[] Armenia = new String[] {
               "Arm\u00e9nsk\u00fd standardn\u00ed \u010das",
               "",
               "Arm\u00e9nsk\u00fd letn\u00ed \u010das",
               "",
               "Arm\u00e9nsk\u00fd \u010das",
               "",
            };
        final String[] Bolivia = new String[] {
               "Bolivijsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Chathamsk\u00fd standardn\u00ed \u010das",
               "",
               "Chathamsk\u00fd letn\u00ed \u010das",
               "",
               "Chathamsk\u00fd \u010das",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Koordinovan\u00fd sv\u011btov\u00fd \u010das",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Ekv\u00e1dorsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Gambiersk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Gruz\u00ednsk\u00fd standardn\u00ed \u010das",
               "",
               "Gruz\u00ednsk\u00fd letn\u00ed \u010das",
               "",
               "Gruz\u00ednsk\u00fd \u010das",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Irkutsk\u00fd standardn\u00ed \u010das",
               "",
               "Irkutsk\u00fd letn\u00ed \u010das",
               "",
               "Irkutsk\u00fd \u010das",
               "",
            };
        final String[] Magadan = new String[] {
               "Magadansk\u00fd standardn\u00ed \u010das",
               "",
               "Magadansk\u00fd letn\u00ed \u010das",
               "",
               "Magadansk\u00fd \u010das",
               "",
            };
        final String[] Myanmar = new String[] {
               "Myanmarsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Norfolksk\u00fd standardn\u00ed \u010das",
               "",
               "Norfolksk\u00fd letn\u00ed \u010das",
               "",
               "Norfolksk\u00fd \u010das",
               "",
            };
        final String[] Noronha = new String[] {
               "Standardn\u00ed \u010das souostrov\u00ed Fernando de Noronha",
               "",
               "Letn\u00ed \u010das souostrov\u00ed Fernando de Noronha",
               "",
               "\u010cas souostrov\u00ed Fernando de Noronha",
               "",
            };
        final String[] Reunion = new String[] {
               "R\u00e9unionsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "\u010cas Rotherovy stanice",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "\u010cas \u0160alamounov\u00fdch ostrov\u016f",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Tokelausk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Uruguaysk\u00fd standardn\u00ed \u010das",
               "",
               "Uruguaysk\u00fd letn\u00ed \u010das",
               "",
               "Uruguaysk\u00fd \u010das",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Vanuatsk\u00fd standardn\u00ed \u010das",
               "",
               "Vanuatsk\u00fd letn\u00ed \u010das",
               "",
               "Vanuatsk\u00fd \u010das",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Jakutsk\u00fd standardn\u00ed \u010das",
               "",
               "Jakutsk\u00fd letn\u00ed \u010das",
               "",
               "Jakutsk\u00fd \u010das",
               "",
            };
        final String[] Atlantic = new String[] {
               "Atlantick\u00fd standardn\u00ed \u010das",
               "AST",
               "Atlantick\u00fd letn\u00ed \u010das",
               "ADT",
               "Atlantick\u00fd \u010das",
               "AT",
            };
        final String[] Brasilia = new String[] {
               "Brasilijsk\u00fd standardn\u00ed \u010das",
               "",
               "Brasilijsk\u00fd letn\u00ed \u010das",
               "",
               "Brasilijsk\u00fd \u010das",
               "",
            };
        final String[] Chamorro = new String[] {
               "Chamorrsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Colombia = new String[] {
               "Kolumbijsk\u00fd standardn\u00ed \u010das",
               "",
               "Kolumbijsk\u00fd letn\u00ed \u010das",
               "",
               "Kolumbijsk\u00fd \u010das",
               "",
            };
        final String[] Falkland = new String[] {
               "Falklandsk\u00fd standardn\u00ed \u010das",
               "",
               "Falklandsk\u00fd letn\u00ed \u010das",
               "",
               "Falklandsk\u00fd \u010das",
               "",
            };
        final String[] Malaysia = new String[] {
               "Malajsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Maledivsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Ul\u00e1nb\u00e1tarsk\u00fd standardn\u00ed \u010das",
               "",
               "Ul\u00e1nb\u00e1tarsk\u00fd letn\u00ed \u010das",
               "",
               "Ul\u00e1nb\u00e1tarsk\u00fd \u010das",
               "",
            };
        final String[] Pakistan = new String[] {
               "P\u00e1kist\u00e1nsk\u00fd standardn\u00ed \u010das",
               "",
               "P\u00e1kist\u00e1nsk\u00fd letn\u00ed \u010das",
               "",
               "P\u00e1kist\u00e1nsk\u00fd \u010das",
               "",
            };
        final String[] Paraguay = new String[] {
               "Paraguaysk\u00fd standardn\u00ed \u010das",
               "",
               "Paraguaysk\u00fd letn\u00ed \u010das",
               "",
               "Paraguaysk\u00fd \u010das",
               "",
            };
        final String[] Pitcairn = new String[] {
               "\u010cas Pitcairnov\u00fdch ostrov\u016f",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Sachalinsk\u00fd standardn\u00ed \u010das",
               "",
               "Sachalinsk\u00fd letn\u00ed \u010das",
               "",
               "Sachalinsk\u00fd \u010das",
               "",
            };
        final String[] Suriname = new String[] {
               "Surinamsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Argentinsk\u00fd standardn\u00ed \u010das",
               "",
               "Argentinsk\u00fd letn\u00ed \u010das",
               "",
               "Argentinsk\u00fd \u010das",
               "",
            };
        final String[] Christmas = new String[] {
               "\u010cas V\u00e1no\u010dn\u00edho ostrova",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Galap\u00e1\u017esk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Hongkongsk\u00fd standardn\u00ed \u010das",
               "",
               "Hongkongsk\u00fd letn\u00ed \u010das",
               "",
               "Hongkongsk\u00fd \u010das",
               "",
            };
        final String[] Indochina = new String[] {
               "Indo\u010d\u00ednsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Petropavlovsko-kam\u010datsk\u00fd standardn\u00ed \u010das",
               "",
               "Petropavlovsko-kam\u010datsk\u00fd letn\u00ed \u010das",
               "",
               "Petropavlovsko-kam\u010datsk\u00fd \u010das",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Kyrgyzsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Standardn\u00ed \u010das ostrova lorda Howa",
               "",
               "Letn\u00ed \u010das ostrova lorda Howa",
               "",
               "\u010cas ostrova lorda Howa",
               "",
            };
        final String[] Marquesas = new String[] {
               "Mark\u00e9zsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Mauricijsk\u00fd standardn\u00ed \u010das",
               "",
               "Mauricijsk\u00fd letn\u00ed \u010das",
               "",
               "Mauricijsk\u00fd \u010das",
               "",
            };
        final String[] Singapore = new String[] {
               "Singapursk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Venezuelsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Volgogradsk\u00fd standardn\u00ed \u010das",
               "",
               "Volgogradsk\u00fd letn\u00ed \u010das",
               "",
               "Volgogradsk\u00fd \u010das",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "\u00c1zerb\u00e1jd\u017e\u00e1nsk\u00fd standardn\u00ed \u010das",
               "",
               "\u00c1zerb\u00e1jd\u017e\u00e1nsk\u00fd letn\u00ed \u010das",
               "",
               "\u00c1zerb\u00e1jd\u017e\u00e1nsk\u00fd \u010das",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Banglad\u00e9\u0161sk\u00fd standardn\u00ed \u010das",
               "",
               "Banglad\u00e9\u0161sk\u00fd letn\u00ed \u010das",
               "",
               "Banglad\u00e9\u0161sk\u00fd \u010das",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Kapverdsk\u00fd standardn\u00ed \u010das",
               "",
               "Kapverdsk\u00fd letn\u00ed \u010das",
               "",
               "Kapverdsk\u00fd \u010das",
               "",
            };
        final String[] East_Timor = new String[] {
               "V\u00fdchodotimorsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Seychelsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "T\u00e1d\u017eick\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Uzbeck\u00fd standardn\u00ed \u010das",
               "",
               "Uzbeck\u00fd letn\u00ed \u010das",
               "",
               "Uzbeck\u00fd \u010das",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Afgh\u00e1nsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnojarsk\u00fd standardn\u00ed \u010das",
               "",
               "Krasnojarsk\u00fd letn\u00ed \u010das",
               "",
               "Krasnojarsk\u00fd \u010das",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Novoz\u00e9landsk\u00fd standardn\u00ed \u010das",
               "",
               "Novoz\u00e9landsk\u00fd letn\u00ed \u010das",
               "",
               "Novoz\u00e9landsk\u00fd \u010das",
               "",
            };
        final String[] Novosibirsk = new String[] {
               "Novosibirsk\u00fd standardn\u00ed \u010das",
               "",
               "Novosibirsk\u00fd letn\u00ed \u010das",
               "",
               "Novosibirsk\u00fd \u010das",
               "",
            };
        final String[] Philippines = new String[] {
               "Filip\u00ednsk\u00fd standardn\u00ed \u010das",
               "",
               "Filip\u00ednsk\u00fd letn\u00ed \u010das",
               "",
               "Filip\u00ednsk\u00fd \u010das",
               "",
            };
        final String[] Vladivostok = new String[] {
               "Vladivostock\u00fd standardn\u00ed \u010das",
               "",
               "Vladivostock\u00fd letn\u00ed \u010das",
               "",
               "Vladivostock\u00fd \u010das",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Indickooce\u00e1nsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "\u010cas Rovn\u00edkov\u00fdch ostrov\u016f",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Newfoundlandsk\u00fd standardn\u00ed \u010das",
               "",
               "Newfoundlandsk\u00fd letn\u00ed \u010das",
               "",
               "Newfoundlandsk\u00fd \u010das",
               "",
            };
        final String[] Turkmenistan = new String[] {
               "Turkmensk\u00fd standardn\u00ed \u010das",
               "",
               "Turkmensk\u00fd letn\u00ed \u010das",
               "",
               "Turkmensk\u00fd \u010das",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Francouzskoguyansk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Novokaledonsk\u00fd standardn\u00ed \u010das",
               "",
               "Novokaledonsk\u00fd letn\u00ed \u010das",
               "",
               "Novokaledonsk\u00fd \u010das",
               "",
            };
        final String[] South_Georgia = new String[] {
               "\u010cas Ji\u017en\u00ed Georgie",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Jekat\u011brinbursk\u00fd standardn\u00ed \u010das",
               "",
               "Jekat\u011brinbursk\u00fd letn\u00ed \u010das",
               "",
               "Jekat\u011brinbursk\u00fd \u010das",
               "",
            };
        final String[] Africa_Central = new String[] {
               "St\u0159edoafrick\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Africa_Eastern = new String[] {
               "V\u00fdchodoafrick\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Africa_Western = new String[] {
               "Z\u00e1padoafrick\u00fd standardn\u00ed \u010das",
               "",
               "Z\u00e1padoafrick\u00fd letn\u00ed \u010das",
               "",
               "Z\u00e1padoafrick\u00fd \u010das",
               "",
            };
        final String[] DumontDUrville = new String[] {
               "\u010cas stanice Dumonta d\u2019Urvilla",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "St\u0159edoevropsk\u00fd standardn\u00ed \u010das",
               "SE\u010c",
               "St\u0159edoevropsk\u00fd letn\u00ed \u010das",
               "SEL\u010c",
               "St\u0159edoevropsk\u00fd \u010das",
               "SE\u010c",
            };
        final String[] Europe_Eastern = new String[] {
               "V\u00fdchodoevropsk\u00fd standardn\u00ed \u010das",
               "",
               "V\u00fdchodoevropsk\u00fd letn\u00ed \u010das",
               "",
               "V\u00fdchodoevropsk\u00fd \u010das",
               "",
            };
        final String[] Europe_Western = new String[] {
               "Z\u00e1padoevropsk\u00fd standardn\u00ed \u010das",
               "",
               "Z\u00e1padoevropsk\u00fd letn\u00ed \u010das",
               "",
               "Z\u00e1padoevropsk\u00fd \u010das",
               "",
            };
        final String[] Mexico_Pacific = new String[] {
               "Mexick\u00fd pacifick\u00fd standardn\u00ed \u010das",
               "",
               "Mexick\u00fd pacifick\u00fd letn\u00ed \u010das",
               "",
               "Mexick\u00fd pacifick\u00fd \u010das",
               "",
            };
        final String[] Africa_Southern = new String[] {
               "Jihoafrick\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] America_Central = new String[] {
               "Severoamerick\u00fd centr\u00e1ln\u00ed standardn\u00ed \u010das",
               "CST",
               "Severoamerick\u00fd centr\u00e1ln\u00ed letn\u00ed \u010das",
               "CDT",
               "Severoamerick\u00fd centr\u00e1ln\u00ed \u010das",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Severoamerick\u00fd v\u00fdchodn\u00ed standardn\u00ed \u010das",
               "EST",
               "Severoamerick\u00fd v\u00fdchodn\u00ed letn\u00ed \u010das",
               "EDT",
               "Severoamerick\u00fd v\u00fdchodn\u00ed \u010das",
               "ET",
            };
        final String[] America_Pacific = new String[] {
               "Severoamerick\u00fd pacifick\u00fd standardn\u00ed \u010das",
               "PST",
               "Severoamerick\u00fd pacifick\u00fd letn\u00ed \u010das",
               "PDT",
               "Severoamerick\u00fd pacifick\u00fd \u010das",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "\u010cas Francouzsk\u00fdch ji\u017en\u00edch a antarktick\u00fdch \u00fazem\u00ed",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "\u010cas Gilbertov\u00fdch ostrov\u016f",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Havajsko-aleutsk\u00fd standardn\u00ed \u010das",
               "",
               "Havajsko-aleutsk\u00fd letn\u00ed \u010das",
               "",
               "Havajsko-aleutsk\u00fd \u010das",
               "",
            };
        final String[] Phoenix_Islands = new String[] {
               "\u010cas F\u00e9nixov\u00fdch ostrov\u016f",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Pierre-miquelonsk\u00fd standardn\u00ed \u010das",
               "",
               "Pierre-miquelonsk\u00fd letn\u00ed \u010das",
               "",
               "Pierre-miquelonsk\u00fd \u010das",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Severoamerick\u00fd horsk\u00fd standardn\u00ed \u010das",
               "MST",
               "Severoamerick\u00fd horsk\u00fd letn\u00ed \u010das",
               "MDT",
               "Severoamerick\u00fd horsk\u00fd \u010das",
               "MT",
            };
        final String[] Marshall_Islands = new String[] {
               "\u010cas Marshallov\u00fdch ostrov\u016f",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mexico_Northwest = new String[] {
               "Severoz\u00e1padn\u00ed mexick\u00fd standardn\u00ed \u010das",
               "",
               "Severoz\u00e1padn\u00ed mexick\u00fd letn\u00ed \u010das",
               "",
               "Severoz\u00e1padn\u00ed mexick\u00fd \u010das",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "\u010cas Papuy-Nov\u00e9 Guiney",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "St\u0159edoaustralsk\u00fd standardn\u00ed \u010das",
               "",
               "St\u0159edoaustralsk\u00fd letn\u00ed \u010das",
               "",
               "St\u0159edoaustralsk\u00fd \u010das",
               "",
            };
        final String[] Australia_Eastern = new String[] {
               "V\u00fdchodoaustralsk\u00fd standardn\u00ed \u010das",
               "",
               "V\u00fdchodoaustralsk\u00fd letn\u00ed \u010das",
               "",
               "V\u00fdchodoaustralsk\u00fd \u010das",
               "",
            };
        final String[] Australia_Western = new String[] {
               "Z\u00e1padoaustralsk\u00fd standardn\u00ed \u010das",
               "",
               "Z\u00e1padoaustralsk\u00fd letn\u00ed \u010das",
               "",
               "Z\u00e1padoaustralsk\u00fd \u010das",
               "",
            };
        final String[] Greenland_Eastern = new String[] {
               "V\u00fdchodogr\u00f3nsk\u00fd standardn\u00ed \u010das",
               "",
               "V\u00fdchodogr\u00f3nsk\u00fd letn\u00ed \u010das",
               "",
               "V\u00fdchodogr\u00f3nsk\u00fd \u010das",
               "",
            };
        final String[] Greenland_Western = new String[] {
               "Z\u00e1padogr\u00f3nsk\u00fd standardn\u00ed \u010das",
               "",
               "Z\u00e1padogr\u00f3nsk\u00fd letn\u00ed \u010das",
               "",
               "Z\u00e1padogr\u00f3nsk\u00fd \u010das",
               "",
            };
        final String[] Indonesia_Central = new String[] {
               "St\u0159edoindon\u00e9sk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Indonesia_Eastern = new String[] {
               "V\u00fdchodoindon\u00e9sk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Indonesia_Western = new String[] {
               "Z\u00e1padoindon\u00e9sk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "V\u00fdchodokazachst\u00e1nsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Z\u00e1padokazachst\u00e1nsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "St\u0159edoz\u00e1padn\u00ed australsk\u00fd standardn\u00ed \u010das",
               "",
               "St\u0159edoz\u00e1padn\u00ed australsk\u00fd letn\u00ed \u010das",
               "",
               "St\u0159edoz\u00e1padn\u00ed australsk\u00fd \u010das",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu",
                new String[] {
                    "Havajsko-aleutsk\u00fd standardn\u00ed \u010das",
                    "HST",
                    "Havajsko-aleutsk\u00fd letn\u00ed \u010das",
                    "HDT",
                    "Havajsko-aleutsk\u00fd \u010das",
                    "HST",
                }
            },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "JST", Japan },
            { "MIT", Apia },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "SST", Solomon },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UTC", ETC_UTC },
            { "MST7MDT", America_Mountain },
            { "PST8PDT", America_Pacific },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan_Western },
            { "Asia/Amman", Europe_Eastern },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Anadyr", Anadyr },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Truk },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kuching", Malaysia },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Damascus", Europe_Eastern },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan_Eastern },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Ust-Nera", Vladivostok },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Greenwichsk\u00fd st\u0159edn\u00ed \u010das",
                    "",
                    "Irsk\u00fd letn\u00ed \u010das",
                    "",
                    "",
                    "",
                }
            },
            { "Europe/Jersey", GMT },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Greenwichsk\u00fd st\u0159edn\u00ed \u010das",
                    "",
                    "Britsk\u00fd letn\u00ed \u010das",
                    "",
                    "",
                    "",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "SystemV/HST10",
                new String[] {
                    "Havajsko-aleutsk\u00fd standardn\u00ed \u010das",
                    "HST",
                    "Havajsko-aleutsk\u00fd letn\u00ed \u010das",
                    "HDT",
                    "Havajsko-aleutsk\u00fd \u010das",
                    "HST",
                }
            },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "Asia/Chongqing", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan_Western },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Greenwichsk\u00fd st\u0159edn\u00ed \u010das",
                    "",
                    "Britsk\u00fd letn\u00ed \u010das",
                    "",
                    "",
                    "",
                }
            },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Pacific/Easter", Easter },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Ponape },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Pacific/Wallis", Wallis },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Godthab", Greenland_Western },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Mountain },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/Perth", Australia_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey", GMT },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", Maldives },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Casey },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Europe/Isle_of_Man", GMT },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "Aden" },
            { "timezone.excity.Asia/Baku", "Baku" },
            { "timezone.excity.Asia/Dili", "Dili" },
            { "timezone.excity.Asia/Gaza", "Gaza" },
            { "timezone.excity.Asia/Hovd", "Hovd" },
            { "timezone.excity.Asia/Omsk", "Omsk" },
            { "timezone.excity.Asia/Oral", "Uralsk" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "Amm\u00e1n" },
            { "timezone.excity.Asia/Aqtau", "Aktau" },
            { "timezone.excity.Asia/Chita", "\u010cita" },
            { "timezone.excity.Asia/Dhaka", "Dh\u00e1ka" },
            { "timezone.excity.Asia/Dubai", "Dubaj" },
            { "timezone.excity.Asia/Kabul", "K\u00e1bul" },
            { "timezone.excity.Asia/Qatar", "Katar" },
            { "timezone.excity.Asia/Seoul", "Soul" },
            { "timezone.excity.Asia/Tokyo", "Tokio" },
            { "timezone.excity.Asia/Tomsk", "Tomsk" },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "Juba" },
            { "timezone.excity.Africa/Lome", "Lom\u00e9" },
            { "timezone.excity.Asia/Almaty", "Almaty" },
            { "timezone.excity.Asia/Anadyr", "Anadyr" },
            { "timezone.excity.Asia/Aqtobe", "Aktobe" },
            { "timezone.excity.Asia/Atyrau", "Atyrau" },
            { "timezone.excity.Asia/Beirut", "Bejr\u00fat" },
            { "timezone.excity.Asia/Brunei", "Brunej" },
            { "timezone.excity.Asia/Hebron", "Hebron" },
            { "timezone.excity.Asia/Kuwait", "Kuvajt" },
            { "timezone.excity.Asia/Manila", "Manila" },
            { "timezone.excity.Asia/Muscat", "Maskat" },
            { "timezone.excity.Asia/Riyadh", "Rij\u00e1d" },
            { "timezone.excity.Asia/Saigon", "Ho \u010ci Minovo m\u011bsto" },
            { "timezone.excity.Asia/Taipei", "Tchaj-pej" },
            { "timezone.excity.Asia/Tehran", "Teher\u00e1n" },
            { "timezone.excity.Asia/Urumqi", "Urum\u010di" },
            { "timezone.excity.Etc/Unknown", "nezn\u00e1m\u00e9 m\u011bsto" },
            { "timezone.excity.Europe/Kiev", "Kyjev" },
            { "timezone.excity.Europe/Oslo", "Oslo" },
            { "timezone.excity.Europe/Riga", "Riga" },
            { "timezone.excity.Europe/Rome", "\u0158\u00edm" },
            { "timezone.excity.Indian/Mahe", "Mah\u00e9" },
            { "timezone.excity.Africa/Accra", "Accra" },
            { "timezone.excity.Africa/Cairo", "K\u00e1hira" },
            { "timezone.excity.Africa/Ceuta", "Ceuta" },
            { "timezone.excity.Africa/Dakar", "Dakar" },
            { "timezone.excity.Africa/Lagos", "Lagos" },
            { "timezone.excity.Africa/Tunis", "Tunis" },
            { "timezone.excity.America/Adak", "Adak" },
            { "timezone.excity.America/Lima", "Lima" },
            { "timezone.excity.America/Nome", "Nome" },
            { "timezone.excity.Asia/Baghdad", "Bagd\u00e1d" },
            { "timezone.excity.Asia/Bahrain", "Bahrajn" },
            { "timezone.excity.Asia/Bangkok", "Bangkok" },
            { "timezone.excity.Asia/Barnaul", "Barnaul" },
            { "timezone.excity.Asia/Bishkek", "Bi\u0161kek" },
            { "timezone.excity.Asia/Colombo", "Kolombo" },
            { "timezone.excity.Asia/Irkutsk", "Irkutsk" },
            { "timezone.excity.Asia/Jakarta", "Jakarta" },
            { "timezone.excity.Asia/Karachi", "Kar\u00e1\u010d\u00ed" },
            { "timezone.excity.Asia/Kuching", "Ku\u010ding" },
            { "timezone.excity.Asia/Magadan", "Magadan" },
            { "timezone.excity.Asia/Nicosia", "Nik\u00f3sie" },
            { "timezone.excity.Asia/Rangoon", "Rang\u00fan" },
            { "timezone.excity.Asia/Tbilisi", "Tbilisi" },
            { "timezone.excity.Asia/Thimphu", "Thimb\u00fa" },
            { "timezone.excity.Asia/Yakutsk", "Jakutsk" },
            { "timezone.excity.Asia/Yerevan", "Jerevan" },
            { "timezone.excity.Europe/Kirov", "Kirov" },
            { "timezone.excity.Europe/Malta", "Malta" },
            { "timezone.excity.Europe/Minsk", "Minsk" },
            { "timezone.excity.Europe/Paris", "Pa\u0159\u00ed\u017e" },
            { "timezone.excity.Europe/Sofia", "Sofie" },
            { "timezone.excity.Europe/Vaduz", "Vaduz" },
            { "timezone.excity.Indian/Cocos", "Kokosov\u00e9 ostrovy" },
            { "timezone.excity.Pacific/Apia", "Apia" },
            { "timezone.excity.Pacific/Fiji", "Fid\u017ei" },
            { "timezone.excity.Pacific/Guam", "Guam" },
            { "timezone.excity.Pacific/Niue", "Niue" },
            { "timezone.excity.Pacific/Truk", "Chuuksk\u00e9 ostrovy" },
            { "timezone.excity.Pacific/Wake", "Wake" },
            { "timezone.excity.Africa/Bamako", "Bamako" },
            { "timezone.excity.Africa/Bangui", "Bangui" },
            { "timezone.excity.Africa/Banjul", "Banjul" },
            { "timezone.excity.Africa/Bissau", "Bissau" },
            { "timezone.excity.Africa/Douala", "Douala" },
            { "timezone.excity.Africa/Harare", "Harare" },
            { "timezone.excity.Africa/Kigali", "Kigali" },
            { "timezone.excity.Africa/Luanda", "Luanda" },
            { "timezone.excity.Africa/Lusaka", "Lusaka" },
            { "timezone.excity.Africa/Malabo", "Malabo" },
            { "timezone.excity.Africa/Maputo", "Maputo" },
            { "timezone.excity.Africa/Maseru", "Maseru" },
            { "timezone.excity.Africa/Niamey", "Niamey" },
            { "timezone.excity.America/Aruba", "Aruba" },
            { "timezone.excity.America/Bahia", "Bah\u00eda" },
            { "timezone.excity.America/Belem", "Bel\u00e9m" },
            { "timezone.excity.America/Boise", "Boise" },
            { "timezone.excity.America/Jujuy", "Jujuy" },
            { "timezone.excity.America/Sitka", "Sitka" },
            { "timezone.excity.America/Thule", "Thule" },
            { "timezone.excity.Asia/Ashgabat", "A\u0161chabad" },
            { "timezone.excity.Asia/Calcutta", "Kalkata" },
            { "timezone.excity.Asia/Damascus", "Dama\u0161ek" },
            { "timezone.excity.Asia/Dushanbe", "Du\u0161anbe" },
            { "timezone.excity.Asia/Jayapura", "Jayapura" },
            { "timezone.excity.Asia/Katmandu", "K\u00e1thm\u00e1nd\u00fa" },
            { "timezone.excity.Asia/Khandyga", "Chandyga" },
            { "timezone.excity.Asia/Makassar", "Makassar" },
            { "timezone.excity.Asia/Qostanay", "Kostanaj" },
            { "timezone.excity.Asia/Sakhalin", "Sachalin" },
            { "timezone.excity.Asia/Shanghai", "\u0160anghaj" },
            { "timezone.excity.Asia/Tashkent", "Ta\u0161kent" },
            { "timezone.excity.Asia/Ust-Nera", "Ust-Nera" },
            { "timezone.excity.Europe/Athens", "Ath\u00e9ny" },
            { "timezone.excity.Europe/Berlin", "Berl\u00edn" },
            { "timezone.excity.Europe/Dublin", "Dublin" },
            { "timezone.excity.Europe/Jersey", "Jersey" },
            { "timezone.excity.Europe/Lisbon", "Lisabon" },
            { "timezone.excity.Europe/London", "Lond\u00fdn" },
            { "timezone.excity.Europe/Madrid", "Madrid" },
            { "timezone.excity.Europe/Monaco", "Monako" },
            { "timezone.excity.Europe/Moscow", "Moskva" },
            { "timezone.excity.Europe/Prague", "Praha" },
            { "timezone.excity.Europe/Samara", "Samara" },
            { "timezone.excity.Europe/Skopje", "Skopje" },
            { "timezone.excity.Europe/Tirane", "Tirana" },
            { "timezone.excity.Europe/Vienna", "V\u00edde\u0148" },
            { "timezone.excity.Europe/Warsaw", "Var\u0161ava" },
            { "timezone.excity.Europe/Zagreb", "Z\u00e1h\u0159eb" },
            { "timezone.excity.Europe/Zurich", "Curych" },
            { "timezone.excity.Indian/Chagos", "Chagos" },
            { "timezone.excity.Indian/Comoro", "Komory" },
            { "timezone.excity.Pacific/Efate", "\u00c9fat\u00e9" },
            { "timezone.excity.Pacific/Nauru", "Nauru" },
            { "timezone.excity.Pacific/Palau", "Palau" },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "Abid\u017ean" },
            { "timezone.excity.Africa/Algiers", "Al\u017e\u00edr" },
            { "timezone.excity.Africa/Conakry", "Conakry" },
            { "timezone.excity.Africa/Kampala", "Kampala" },
            { "timezone.excity.Africa/Mbabane", "Mbabane" },
            { "timezone.excity.Africa/Nairobi", "Nairobi" },
            { "timezone.excity.Africa/Tripoli", "Tripolis" },
            { "timezone.excity.America/Belize", "Belize" },
            { "timezone.excity.America/Bogota", "Bogot\u00e1" },
            { "timezone.excity.America/Cancun", "Canc\u00fan" },
            { "timezone.excity.America/Cayman", "Kajmansk\u00e9 ostrovy" },
            { "timezone.excity.America/Cuiaba", "Cuiaba" },
            { "timezone.excity.America/Dawson", "Dawson" },
            { "timezone.excity.America/Denver", "Denver" },
            { "timezone.excity.America/Guyana", "Guyana" },
            { "timezone.excity.America/Havana", "Havana" },
            { "timezone.excity.America/Inuvik", "Inuvik" },
            { "timezone.excity.America/Juneau", "Juneau" },
            { "timezone.excity.America/La_Paz", "La Paz" },
            { "timezone.excity.America/Maceio", "Maceio" },
            { "timezone.excity.America/Manaus", "Manaus" },
            { "timezone.excity.America/Merida", "Merida" },
            { "timezone.excity.America/Nassau", "Nassau" },
            { "timezone.excity.America/Panama", "Panama" },
            { "timezone.excity.America/Recife", "Recife" },
            { "timezone.excity.America/Regina", "Regina" },
            { "timezone.excity.Asia/Famagusta", "Famagusta" },
            { "timezone.excity.Asia/Hong_Kong", "Hongkong" },
            { "timezone.excity.Asia/Jerusalem", "Jeruzal\u00e9m" },
            { "timezone.excity.Asia/Kamchatka", "Kam\u010datka" },
            { "timezone.excity.Asia/Pontianak", "Pontianak" },
            { "timezone.excity.Asia/Pyongyang", "Pchjongjang" },
            { "timezone.excity.Asia/Qyzylorda", "Kyzylorda" },
            { "timezone.excity.Asia/Samarkand", "Samarkand" },
            { "timezone.excity.Asia/Singapore", "Singapur" },
            { "timezone.excity.Asia/Vientiane", "Vientiane" },
            { "timezone.excity.Europe/Andorra", "Andorra" },
            { "timezone.excity.Europe/Saratov", "Saratov" },
            { "timezone.excity.Europe/Tallinn", "Tallinn" },
            { "timezone.excity.Europe/Vatican", "Vatik\u00e1n" },
            { "timezone.excity.Europe/Vilnius", "Vilnius" },
            { "timezone.excity.Indian/Mayotte", "Mayotte" },
            { "timezone.excity.Indian/Reunion", "R\u00e9union" },
            { "timezone.excity.Pacific/Easter", "Velikono\u010dn\u00ed ostrov" },
            { "timezone.excity.Pacific/Kanton", "Kanton" },
            { "timezone.excity.Pacific/Kosrae", "Kosrae" },
            { "timezone.excity.Pacific/Majuro", "Majuro" },
            { "timezone.excity.Pacific/Midway", "Midway" },
            { "timezone.excity.Pacific/Noumea", "Noum\u00e9a" },
            { "timezone.excity.Pacific/Saipan", "Saipan" },
            { "timezone.excity.Pacific/Tahiti", "Tahiti" },
            { "timezone.excity.Pacific/Tarawa", "Tarawa" },
            { "timezone.excity.Pacific/Wallis", "Wallis" },
            { "timezone.excity.Africa/Blantyre", "Blantyre" },
            { "timezone.excity.Africa/Djibouti", "D\u017eibuti" },
            { "timezone.excity.Africa/El_Aaiun", "El Aaiun" },
            { "timezone.excity.Africa/Freetown", "Freetown" },
            { "timezone.excity.Africa/Gaborone", "Gaborone" },
            { "timezone.excity.Africa/Khartoum", "Chart\u00fam" },
            { "timezone.excity.Africa/Kinshasa", "Kinshasa" },
            { "timezone.excity.Africa/Monrovia", "Monrovia" },
            { "timezone.excity.Africa/Ndjamena", "Nd\u017eamena" },
            { "timezone.excity.Africa/Sao_Tome", "Svat\u00fd Tom\u00e1\u0161" },
            { "timezone.excity.Africa/Windhoek", "Windhoek" },
            { "timezone.excity.America/Antigua", "Antigua" },
            { "timezone.excity.America/Caracas", "Caracas" },
            { "timezone.excity.America/Cayenne", "Cayenne" },
            { "timezone.excity.America/Chicago", "Chicago" },
            { "timezone.excity.America/Cordoba", "C\u00f3rdoba" },
            { "timezone.excity.America/Creston", "Creston" },
            { "timezone.excity.America/Curacao", "Cura\u00e7ao" },
            { "timezone.excity.America/Detroit", "Detroit" },
            { "timezone.excity.America/Grenada", "Grenada" },
            { "timezone.excity.America/Halifax", "Halifax" },
            { "timezone.excity.America/Iqaluit", "Iqaluit" },
            { "timezone.excity.America/Jamaica", "Jamajka" },
            { "timezone.excity.America/Managua", "Managua" },
            { "timezone.excity.America/Marigot", "Marigot" },
            { "timezone.excity.America/Mendoza", "Mendoza" },
            { "timezone.excity.America/Moncton", "Moncton" },
            { "timezone.excity.America/Nipigon", "Nipigon" },
            { "timezone.excity.America/Noronha", "Noronha" },
            { "timezone.excity.America/Ojinaga", "Ojinaga" },
            { "timezone.excity.America/Phoenix", "Phoenix" },
            { "timezone.excity.America/Tijuana", "Tijuana" },
            { "timezone.excity.America/Toronto", "Toronto" },
            { "timezone.excity.America/Tortola", "Tortola" },
            { "timezone.excity.America/Yakutat", "Yakutat" },
            { "timezone.excity.Asia/Choibalsan", "\u010cojbalsan" },
            { "timezone.excity.Asia/Phnom_Penh", "Phnompenh" },
            { "timezone.excity.Atlantic/Azores", "Azorsk\u00e9 ostrovy" },
            { "timezone.excity.Atlantic/Canary", "Kan\u00e1rsk\u00e9 ostrovy" },
            { "timezone.excity.Atlantic/Faeroe", "Faersk\u00e9 ostrovy" },
            { "timezone.excity.Australia/Eucla", "Eucla" },
            { "timezone.excity.Australia/Perth", "Perth" },
            { "timezone.excity.Europe/Belgrade", "B\u011blehrad" },
            { "timezone.excity.Europe/Brussels", "Brusel" },
            { "timezone.excity.Europe/Budapest", "Budape\u0161\u0165" },
            { "timezone.excity.Europe/Busingen", "Busingen" },
            { "timezone.excity.Europe/Chisinau", "Ki\u0161in\u011bv" },
            { "timezone.excity.Europe/Guernsey", "Guernsey" },
            { "timezone.excity.Europe/Helsinki", "Helsinky" },
            { "timezone.excity.Europe/Istanbul", "Istanbul" },
            { "timezone.excity.Europe/Sarajevo", "Sarajevo" },
            { "timezone.excity.Europe/Uzhgorod", "U\u017ehorod" },
            { "timezone.excity.Indian/Maldives", "Maledivy" },
            { "timezone.excity.Pacific/Chatham", "Chathamsk\u00e9 ostrovy" },
            { "timezone.excity.Pacific/Fakaofo", "Fakaofo" },
            { "timezone.excity.Pacific/Gambier", "Gambierovy ostrovy" },
            { "timezone.excity.Pacific/Norfolk", "Norfolk" },
            { "timezone.excity.Africa/Bujumbura", "Bujumbura" },
            { "timezone.excity.Africa/Mogadishu", "Mogadi\u0161u" },
            { "timezone.excity.America/Anguilla", "Anguilla" },
            { "timezone.excity.America/Asuncion", "Asunci\u00f3n" },
            { "timezone.excity.America/Barbados", "Barbados" },
            { "timezone.excity.America/Dominica", "Dominika" },
            { "timezone.excity.America/Edmonton", "Edmonton" },
            { "timezone.excity.America/Eirunepe", "Eirunepe" },
            { "timezone.excity.America/Mazatlan", "Mazatl\u00e1n" },
            { "timezone.excity.America/Miquelon", "Miquelon" },
            { "timezone.excity.America/New_York", "New York" },
            { "timezone.excity.America/Resolute", "Resolute" },
            { "timezone.excity.America/Santarem", "Santar\u00e9m" },
            { "timezone.excity.America/Santiago", "Santiago" },
            { "timezone.excity.America/St_Kitts", "Svat\u00fd Kry\u0161tof" },
            { "timezone.excity.America/St_Lucia", "Svat\u00e1 Lucie" },
            { "timezone.excity.America/Winnipeg", "Winnipeg" },
            { "timezone.excity.Antarctica/Casey", "Casey" },
            { "timezone.excity.Antarctica/Davis", "Davis" },
            { "timezone.excity.Antarctica/Syowa", "Syowa" },
            { "timezone.excity.Antarctica/Troll", "Troll" },
            { "timezone.excity.Asia/Krasnoyarsk", "Krasnojarsk" },
            { "timezone.excity.Asia/Novosibirsk", "Novosibirsk" },
            { "timezone.excity.Asia/Ulaanbaatar", "Ul\u00e1nb\u00e1tar" },
            { "timezone.excity.Asia/Vladivostok", "Vladivostok" },
            { "timezone.excity.Atlantic/Bermuda", "Bermudy" },
            { "timezone.excity.Atlantic/Madeira", "Madeira" },
            { "timezone.excity.Atlantic/Stanley", "Stanley" },
            { "timezone.excity.Australia/Currie", "Currie" },
            { "timezone.excity.Australia/Darwin", "Darwin" },
            { "timezone.excity.Australia/Hobart", "Hobart" },
            { "timezone.excity.Australia/Sydney", "Sydney" },
            { "timezone.excity.Europe/Amsterdam", "Amsterdam" },
            { "timezone.excity.Europe/Astrakhan", "Astracha\u0148" },
            { "timezone.excity.Europe/Bucharest", "Bukure\u0161\u0165" },
            { "timezone.excity.Europe/Gibraltar", "Gibraltar" },
            { "timezone.excity.Europe/Ljubljana", "Lubla\u0148" },
            { "timezone.excity.Europe/Mariehamn", "Mariehamn" },
            { "timezone.excity.Europe/Podgorica", "Podgorica" },
            { "timezone.excity.Europe/Stockholm", "Stockholm" },
            { "timezone.excity.Europe/Ulyanovsk", "Uljanovsk" },
            { "timezone.excity.Europe/Volgograd", "Volgograd" },
            { "timezone.excity.Indian/Christmas", "V\u00e1no\u010dn\u00ed ostrov" },
            { "timezone.excity.Indian/Kerguelen", "Kerguelenovy ostrovy" },
            { "timezone.excity.Indian/Mauritius", "Mauricius" },
            { "timezone.excity.Pacific/Auckland", "Auckland" },
            { "timezone.excity.Pacific/Funafuti", "Funafuti" },
            { "timezone.excity.Pacific/Honolulu", "Honolulu" },
            { "timezone.excity.Pacific/Johnston", "Johnston" },
            { "timezone.excity.Pacific/Pitcairn", "Pitcairnovy ostrovy" },
            { "timezone.excity.Africa/Casablanca", "Casablanca" },
            { "timezone.excity.Africa/Libreville", "Libreville" },
            { "timezone.excity.Africa/Lubumbashi", "Lubumbashi" },
            { "timezone.excity.Africa/Nouakchott", "Nuak\u0161ott" },
            { "timezone.excity.Africa/Porto-Novo", "Porto-Novo" },
            { "timezone.excity.America/Anchorage", "Anchorage" },
            { "timezone.excity.America/Araguaina", "Araguaina" },
            { "timezone.excity.America/Boa_Vista", "Boa Vista" },
            { "timezone.excity.America/Catamarca", "Catamarca" },
            { "timezone.excity.America/Chihuahua", "Chihuahua" },
            { "timezone.excity.America/Fortaleza", "Fortaleza" },
            { "timezone.excity.America/Glace_Bay", "Glace Bay" },
            { "timezone.excity.America/Goose_Bay", "Goose Bay" },
            { "timezone.excity.America/Guatemala", "Guatemala" },
            { "timezone.excity.America/Guayaquil", "Guayaquil" },
            { "timezone.excity.America/Matamoros", "Matamoros" },
            { "timezone.excity.America/Menominee", "Menominee" },
            { "timezone.excity.America/Monterrey", "Monterrey" },
            { "timezone.excity.America/Sao_Paulo", "S\u00e3o Paulo" },
            { "timezone.excity.America/St_Thomas", "Svat\u00fd Tom\u00e1\u0161 (Karibik)" },
            { "timezone.excity.America/Vancouver", "Vancouver" },
            { "timezone.excity.Antarctica/Mawson", "Mawson" },
            { "timezone.excity.Antarctica/Palmer", "Palmer" },
            { "timezone.excity.Antarctica/Vostok", "Vostok" },
            { "timezone.excity.Asia/Kuala_Lumpur", "Kuala Lumpur" },
            { "timezone.excity.Asia/Novokuznetsk", "Novokuzn\u011bck" },
            { "timezone.excity.Europe/Bratislava", "Bratislava" },
            { "timezone.excity.Europe/Copenhagen", "Koda\u0148" },
            { "timezone.excity.Europe/Luxembourg", "Lucemburk" },
            { "timezone.excity.Europe/San_Marino", "San Marino" },
            { "timezone.excity.Europe/Simferopol", "Simferopol" },
            { "timezone.excity.Europe/Zaporozhye", "Z\u00e1poro\u017e\u00ed" },
            { "timezone.excity.Pacific/Enderbury", "Enderbury" },
            { "timezone.excity.Pacific/Galapagos", "Galap\u00e1gy" },
            { "timezone.excity.Pacific/Kwajalein", "Kwajalein" },
            { "timezone.excity.Pacific/Marquesas", "Mark\u00e9zy" },
            { "timezone.excity.Pacific/Pago_Pago", "Pago Pago" },
            { "timezone.excity.Pacific/Rarotonga", "Rarotonga" },
            { "timezone.excity.Pacific/Tongatapu", "Tongatapu" },
            { "timezone.excity.Africa/Addis_Ababa", "Addis Abeba" },
            { "timezone.excity.Africa/Brazzaville", "Brazzaville" },
            { "timezone.excity.Africa/Ouagadougou", "Ouagadougou" },
            { "timezone.excity.America/Costa_Rica", "Kostarika" },
            { "timezone.excity.America/Grand_Turk", "Grand Turk" },
            { "timezone.excity.America/Guadeloupe", "Guadeloupe" },
            { "timezone.excity.America/Hermosillo", "Hermosillo" },
            { "timezone.excity.America/Kralendijk", "Kralendijk" },
            { "timezone.excity.America/Louisville", "Louisville" },
            { "timezone.excity.America/Martinique", "Martinik" },
            { "timezone.excity.America/Metlakatla", "Metlakatla" },
            { "timezone.excity.America/Montevideo", "Montevideo" },
            { "timezone.excity.America/Montserrat", "Montserrat" },
            { "timezone.excity.America/Paramaribo", "Paramaribo" },
            { "timezone.excity.America/Rio_Branco", "Rio Branco" },
            { "timezone.excity.America/St_Vincent", "Svat\u00fd Vincenc" },
            { "timezone.excity.America/Whitehorse", "Whitehorse" },
            { "timezone.excity.Antarctica/McMurdo", "McMurdo" },
            { "timezone.excity.Antarctica/Rothera", "Rothera" },
            { "timezone.excity.Asia/Srednekolymsk", "Sredn\u011bkolymsk" },
            { "timezone.excity.Asia/Yekaterinburg", "Jekat\u011brinburg" },
            { "timezone.excity.Atlantic/Reykjavik", "Reykjav\u00edk" },
            { "timezone.excity.Atlantic/St_Helena", "Svat\u00e1 Helena" },
            { "timezone.excity.Australia/Adelaide", "Adelaide" },
            { "timezone.excity.Australia/Brisbane", "Brisbane" },
            { "timezone.excity.Australia/Lindeman", "Lindeman" },
            { "timezone.excity.Europe/Isle_of_Man", "Ostrov Man" },
            { "timezone.excity.Europe/Kaliningrad", "Kaliningrad" },
            { "timezone.excity.Pacific/Kiritimati", "Kiritimati" },
            { "timezone.excity.Africa/Johannesburg", "Johannesburg" },
            { "timezone.excity.America/El_Salvador", "Salvador" },
            { "timezone.excity.America/Fort_Nelson", "Fort Nelson" },
            { "timezone.excity.America/Los_Angeles", "Los Angeles" },
            { "timezone.excity.America/Mexico_City", "Ciudad de M\u00e9xico" },
            { "timezone.excity.America/Pangnirtung", "Pangnirtung" },
            { "timezone.excity.America/Porto_Velho", "Porto Velho" },
            { "timezone.excity.America/Puerto_Rico", "Portoriko" },
            { "timezone.excity.America/Rainy_River", "Rainy River" },
            { "timezone.excity.America/Tegucigalpa", "Tegucigalpa" },
            { "timezone.excity.America/Thunder_Bay", "Thunder Bay" },
            { "timezone.excity.America/Yellowknife", "Yellowknife" },
            { "timezone.excity.Arctic/Longyearbyen", "Longyearbyen" },
            { "timezone.excity.Atlantic/Cape_Verde", "Kapverdy" },
            { "timezone.excity.Australia/Lord_Howe", "Lord Howe" },
            { "timezone.excity.Australia/Melbourne", "Melbourne" },
            { "timezone.excity.Indian/Antananarivo", "Antananarivo" },
            { "timezone.excity.Pacific/Guadalcanal", "Guadalcanal" },
            { "timezone.excity.Africa/Dar_es_Salaam", "Dar es Salaam" },
            { "timezone.excity.America/Blanc-Sablon", "Blanc-Sablon" },
            { "timezone.excity.America/Buenos_Aires", "Buenos Aires" },
            { "timezone.excity.America/Campo_Grande", "Campo Grande" },
            { "timezone.excity.America/Danmarkshavn", "Danmarkshavn" },
            { "timezone.excity.America/Dawson_Creek", "Dawson Creek" },
            { "timezone.excity.America/Indianapolis", "Indianapolis" },
            { "timezone.excity.America/Punta_Arenas", "Punta Arenas" },
            { "timezone.excity.America/Rankin_Inlet", "Rankin Inlet" },
            { "timezone.excity.America/Santa_Isabel", "Santa Isabel" },
            { "timezone.excity.Antarctica/Macquarie", "Macquarie" },
            { "timezone.excity.Pacific/Bougainville", "Bougainville" },
            { "timezone.excity.Pacific/Port_Moresby", "Port Moresby" },
            { "timezone.excity.America/Cambridge_Bay", "Cambridge Bay" },
            { "timezone.excity.America/Port_of_Spain", "Port of Spain" },
            { "timezone.excity.America/Santo_Domingo", "Santo Domingo" },
            { "timezone.excity.America/St_Barthelemy", "Svat\u00fd Bartolom\u011bj" },
            { "timezone.excity.America/Swift_Current", "Swift Current" },
            { "timezone.excity.Australia/Broken_Hill", "Broken Hill" },
            { "timezone.excity.America/Bahia_Banderas", "Bahia Banderas" },
            { "timezone.excity.America/Port-au-Prince", "Port-au-Prince" },
            { "timezone.excity.Atlantic/South_Georgia", "Ji\u017en\u00ed Georgie" },
            { "timezone.excity.America/Argentina/Salta", "Salta" },
            { "timezone.excity.America/Argentina/Tucuman", "Tucuman" },
            { "timezone.excity.America/Argentina/Ushuaia", "Ushuaia" },
            { "timezone.excity.America/Argentina/La_Rioja", "La Rioja" },
            { "timezone.excity.America/Argentina/San_Juan", "San Juan" },
            { "timezone.excity.America/Argentina/San_Luis", "San Luis" },
            { "timezone.excity.America/North_Dakota/Beulah", "Beulah, Severn\u00ed Dakota" },
            { "timezone.excity.America/North_Dakota/Center", "Center, Severn\u00ed Dakota" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "Rio Gallegos" },
            { "timezone.excity.America/North_Dakota/New_Salem", "New Salem, Severn\u00ed Dakota" },
        };
        return data;
    }
}
