/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_as extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_NR = "\u09a8\u09be\u0989\u09f0\u09c1";
        final String metaValue_TV = "\u099f\u09c1\u09ad\u09be\u09b2\u09c1";
        final String metaValue_ar = "\u0986\u09f0\u09ac\u09c0";
        final String metaValue_hy = "\u0986\u09f0\u09cd\u09ae\u09c7\u09a8\u09c0\u09af\u09bc";
        final String metaValue_bn = "\u09ac\u09be\u0982\u09b2\u09be";
        final String metaValue_ka = "\u099c\u09f0\u09cd\u099c\u09bf\u09af\u09bc\u09be\u09a8";
        final String metaValue_el = "\u0997\u09cd\u09f0\u09c0\u0995";
        final String metaValue_gu = "\u0997\u09c1\u099c\u09f0\u09be\u099f\u09c0";
        final String metaValue_he = "\u09b9\u09bf\u09ac\u09cd\u09f0\u09c1";
        final String metaValue_ja = "\u099c\u09be\u09aa\u09be\u09a8\u09c0";
        final String metaValue_km = "\u0996\u09ae\u09c7\u09f0";
        final String metaValue_kn = "\u0995\u09be\u09a8\u09be\u09a1\u09bc\u09be";
        final String metaValue_ko = "\u0995\u09cb\u09f0\u09bf\u09af\u09bc\u09be\u09a8";
        final String metaValue_lo = "\u09b2\u09be\u0993";
        final String metaValue_la = "\u09b2\u09c7\u099f\u09bf\u09a8";
        final String metaValue_ml = "\u09ae\u09be\u09b2\u09be\u09af\u09bc\u09be\u09b2\u09ae";
        final String metaValue_or = "\u0993\u09a1\u09bc\u09bf\u09af\u09bc\u09be";
        final String metaValue_ta = "\u09a4\u09be\u09ae\u09bf\u09b2";
        final String metaValue_te = "\u09a4\u09c7\u09b2\u09c1\u0997\u09c1";
        final String metaValue_th = "\u09a5\u09be\u0987";
        final String metaValue_bo = "\u09a4\u09bf\u09ac\u09cd\u09ac\u09a4\u09c0";
        final String metaValue_vai = "\u09ad\u09be\u0987";
        final Object[][] data = new Object[][] {
            { "001", "\u09ac\u09bf\u09b6\u09cd\u09ac" },
            { "002", "\u0986\u09ab\u09cd\u09f0\u09bf\u0995\u09be" },
            { "003", "\u0989\u09a4\u09cd\u09a4\u09f0 \u0986\u09ae\u09c7\u09f0\u09bf\u0995\u09be" },
            { "005", "\u09a6\u0995\u09cd\u09b7\u09bf\u09a3 \u0986\u09ae\u09c7\u09f0\u09bf\u0995\u09be" },
            { "009", "\u0985\u2019\u099a\u09c7\u09a8\u09c0\u09af\u09bc\u09be" },
            { "011", "\u09aa\u09be\u09b6\u09cd\u099a\u09be\u09a4\u09cd\u09af \u0986\u09ab\u09cd\u09f0\u09bf\u0995\u09be" },
            { "013", "\u09ae\u09a7\u09cd\u09af \u0986\u09ae\u09c7\u09f0\u09bf\u0995\u09be" },
            { "014", "\u09aa\u09cd\u09f0\u09be\u099a\u09cd\u09af \u0986\u09ab\u09cd\u09f0\u09bf\u0995\u09be" },
            { "015", "\u0989\u09a6\u09c0\u099a\u09cd\u09af \u0986\u09ab\u09cd\u09f0\u09bf\u0995\u09be" },
            { "017", "\u09ae\u09a7\u09cd\u09af \u0986\u09ab\u09cd\u09f0\u09bf\u0995\u09be" },
            { "018", "\u09a6\u09be\u0995\u09cd\u09b7\u09bf\u09a3\u09be\u09a4\u09cd\u09af \u0986\u09ab\u09cd\u09f0\u09bf\u0995\u09be" },
            { "019", "\u0986\u09ae\u09c7\u09f0\u09bf\u0995\u09be\u099b\u09cd" },
            { "021", "\u0989\u09a6\u09c0\u099a\u09cd\u09af \u0986\u09ae\u09c7\u09f0\u09bf\u0995\u09be" },
            { "029", "\u0995\u09c7\u09f0\u09bf\u09ac\u09bf\u09af\u09bc\u09be\u09a8" },
            { "030", "\u09aa\u09cd\u09f0\u09be\u099a\u09cd\u09af \u098f\u099b\u09bf\u09af\u09bc\u09be" },
            { "034", "\u09a6\u09be\u0995\u09cd\u09b7\u09bf\u09a3\u09be\u09a4\u09cd\u09af \u098f\u099b\u09bf\u09af\u09bc\u09be" },
            { "035", "\u09a6\u0995\u09cd\u09b7\u09bf\u09a3-\u09aa\u09c2\u09ac \u098f\u099b\u09bf\u09af\u09bc\u09be" },
            { "039", "\u09a6\u09be\u0995\u09cd\u09b7\u09bf\u09a3\u09be\u09a4\u09cd\u09af \u0987\u0989\u09f0\u09cb\u09aa" },
            { "053", "\u0985\u09b7\u09cd\u099f\u09cd\u09f0\u09c7\u09b2\u09c7\u099b\u09bf\u09af\u09bc\u09be" },
            { "054", "\u09ae\u09c7\u09b2\u09be\u09a8\u09c7\u099b\u09bf\u09af\u09bc\u09be" },
            { "057", "\u09ae\u09be\u0987\u0995\u09cd\u09f0\u09cb\u09a8\u09c7\u099a\u09bf\u09af\u09bc \u0995\u09cd\u09b7\u09c7\u09a4\u09cd\u09f0" },
            { "061", "\u09aa\u09b2\u09bf\u09a8\u09c7\u099a\u09bf\u09af\u09bc\u09be" },
            { "142", "\u098f\u099b\u09bf\u09af\u09bc\u09be" },
            { "143", "\u09ae\u09a7\u09cd\u09af \u098f\u099b\u09bf\u09af\u09bc\u09be" },
            { "145", "\u09aa\u09be\u09b6\u09cd\u099a\u09be\u09a4\u09cd\u09af \u098f\u099b\u09bf\u09af\u09bc\u09be" },
            { "150", "\u0987\u0989\u09f0\u09cb\u09aa" },
            { "151", "\u09aa\u09cd\u09f0\u09be\u099a\u09cd\u09af \u0987\u0989\u09f0\u09cb\u09aa" },
            { "154", "\u0989\u09a6\u09c0\u099a\u09cd\u09af \u0987\u0989\u09f0\u09cb\u09aa" },
            { "155", "\u09aa\u09be\u09b6\u09cd\u099a\u09be\u09a4\u09cd\u09af \u0987\u0989\u09f0\u09cb\u09aa" },
            { "202", "\u0989\u09aa-\u099b\u09be\u09b9\u09be\u09f0\u09be\u09a8 \u0986\u09ab\u09cd\u09f0\u09bf\u0995\u09be" },
            { "419", "\u09b2\u09c7\u099f\u09bf\u09a8 \u0986\u09ae\u09c7\u09f0\u09bf\u0995\u09be" },
            { "AC", "\u098f\u099a\u09c7\u09a8\u099a\u09bf\u09af\u09bc\u09a8 \u09a6\u09cd\u09ac\u09c0\u09aa" },
            { "AD", "\u0986\u09a8\u09cd\u09a6\u09cb\u09f0\u09be" },
            { "AE", "\u09b8\u0982\u09af\u09c1\u0995\u09cd\u09a4 \u0986\u09f0\u09ac \u0986\u09ae\u09bf\u09f0\u09be\u09a4" },
            { "AF", "\u0986\u09ab\u0997\u09be\u09a8\u09bf\u09b8\u09cd\u09a4\u09be\u09a8" },
            { "AG", "\u098f\u09a3\u09cd\u099f\u09bf\u0997\u09c1\u09f1\u09be \u0986\u09f0\u09c1 \u09ac\u09be\u09f0\u09cd\u09ac\u09c1\u09a1\u09be" },
            { "AI", "\u098f\u09a8\u0997\u09c1\u0987\u09b2\u09be" },
            { "AL", "\u0986\u09b2\u09ac\u09c7\u09a8\u09bf\u09af\u09bc\u09be" },
            { "AM", "\u0986\u09f0\u09cd\u09ae\u09c7\u09a8\u09bf\u09af\u09bc\u09be" },
            { "AO", "\u098f\u0982\u0997\u09cb\u09b2\u09be" },
            { "AQ", "\u098f\u09a3\u09cd\u099f\u09be\u09f0\u09cd\u0995\u099f\u09bf\u0995\u09be" },
            { "AR", "\u0986\u09f0\u09cd\u099c\u09c7\u09a3\u09cd\u099f\u09bf\u09a8\u09be" },
            { "AS", "\u0986\u09ae\u09c7\u09f0\u09bf\u0995\u09be\u09a8 \u099a\u09be\u09ae\u09cb\u09f1\u09be" },
            { "AT", "\u0985\u09b7\u09cd\u099f\u09cd\u09f0\u09bf\u09af\u09bc\u09be" },
            { "AU", "\u0985\u09b7\u09cd\u099f\u09cd\u09f0\u09c7\u09b2\u09bf\u09af\u09bc\u09be" },
            { "AW", "\u0986\u09f0\u09c1\u09ac\u09be" },
            { "AX", "\u0986\u09b2\u09a3\u09cd\u09a1 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "AZ", "\u0986\u099c\u09be\u09f0\u09ac\u09c7\u0987\u099c\u09be\u09a8" },
            { "BA", "\u09ac\u2019\u099b\u09a8\u09bf\u09af\u09bc\u09be \u0986\u09f0\u09c1 \u09b9\u09be\u09f0\u09cd\u099c\u09c7\u0997\u2019\u09ad\u09bf\u09a8\u09be" },
            { "BB", "\u09ac\u09be\u09f0\u09cd\u09ac\u09be\u09a1\u09cb\u099a" },
            { "BD", "\u09ac\u09be\u0982\u09b2\u09be\u09a6\u09c7\u09b6" },
            { "BE", "\u09ac\u09c7\u09b2\u099c\u09bf\u09af\u09bc\u09be\u09ae" },
            { "BF", "\u09ac\u09c1\u09f0\u0995\u09bf\u09a8\u09be \u09ab\u09be\u099a\u09cb" },
            { "BG", "\u09ac\u09c1\u09b2\u0997\u09c7\u09f0\u09bf\u09af\u09bc\u09be" },
            { "BH", "\u09ac\u09be\u09b9\u09f0\u09c7\u0987\u09a8" },
            { "BI", "\u09ac\u09c1\u09f0\u09c1\u09a3\u09cd\u09a1\u09bf" },
            { "BJ", "\u09ac\u09c7\u09a8\u09bf\u09a8" },
            { "BL", "\u099b\u09c7\u0987\u09a3\u09cd\u099f \u09ac\u09be\u09f0\u09cd\u09a5\u09b2\u09c7\u09ae\u09c7" },
            { "BM", "\u09ac\u09be\u09f0\u09cd\u09ae\u09c1\u09a1\u09be" },
            { "BN", "\u09ac\u09cd\u09f0\u09c1\u09a8\u09c7\u0987" },
            { "BO", "\u09ac\u09b2\u09bf\u09ad\u09bf\u09af\u09bc\u09be" },
            { "BQ", "\u0995\u09c7\u09f0\u09bf\u09ac\u09bf\u09af\u09bc\u09be\u09a8 \u09a8\u09c7\u09a6\u09be\u09f0\u09b2\u09c7\u09a3\u09cd\u09a1\u099b" },
            { "BR", "\u09ac\u09cd\u09f0\u09be\u099c\u09bf\u09b2" },
            { "BS", "\u09ac\u09be\u09b9\u09be\u09ae\u09be\u099b" },
            { "BT", "\u09ad\u09c1\u099f\u09be\u09a8" },
            { "BV", "\u09ac\u09c1\u09ad\u09c7 \u09a6\u09cd\u09ac\u09c0\u09aa" },
            { "BW", "\u09ac\u2019\u099f\u099a\u09cb\u09f1\u09be\u09a8\u09be" },
            { "BY", "\u09ac\u09c7\u09b2\u09be\u09f0\u09c1\u099b" },
            { "BZ", "\u09ac\u09c7\u09b2\u09bf\u099c" },
            { "CA", "\u0995\u09be\u09a8\u09be\u09a1\u09be" },
            { "CC", "\u0995\u09cb\u0995\u09cb\u099a (\u0995\u09c0\u09b2\u09bf\u0982) \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "CD", "\u0995\u0999\u09cd\u0997\u09cb - \u0995\u09bf\u09a8\u099a\u09be\u099b\u09be" },
            { "CF", "\u09ae\u09a7\u09cd\u09af \u0986\u09ab\u09cd\u09b0\u09bf\u0995\u09be\u09a8 \u09aa\u09cd\u09b0\u099c\u09be\u09a4\u09a8\u09cd\u09a4\u09cd\u09b0" },
            { "CG", "\u0995\u0999\u09cd\u0997\u09cb - \u09ac\u09cd\u09b0\u09be\u099c\u09be\u09ad\u09bf\u09b2" },
            { "CH", "\u099a\u09c1\u0987\u099c\u09be\u09f0\u09b2\u09c7\u09a3\u09cd\u09a1" },
            { "CI", "\u0995\u09cb\u099f\u09c7 \u09a1\u09bf \u0986\u0987\u09ad\u09f0" },
            { "CK", "\u0995\u09c1\u0995 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "CL", "\u099a\u09bf\u09b2\u09bf" },
            { "CM", "\u0995\u09c7\u09ae\u09c7\u09f0\u09c1\u09a3" },
            { "CN", "\u099a\u09c0\u09a8" },
            { "CO", "\u0995\u09b2\u09ae\u09cd\u09ac\u09bf\u09af\u09bc\u09be" },
            { "CP", "\u0995\u09cd\u09b2\u09bf\u09aa\u09be\u09f0\u099f\u09cb\u09a8 \u09a6\u09cd\u09ac\u09c0\u09aa" },
            { "CR", "\u0995\u09cb\u09b7\u09cd\u099f\u09be \u09f0\u09bf\u0995\u09be" },
            { "CU", "\u0995\u09bf\u0989\u09ac\u09be" },
            { "CV", "\u0995\u09c7\u09aa \u09ad\u09be\u09b0\u09cd\u09a6\u09c7" },
            { "CW", "\u0995\u09c1\u09f0\u09be\u0995\u09be\u0993" },
            { "CX", "\u0996\u09cd\u09f0\u09c0\u09b7\u09cd\u099f\u09ae\u09be\u099b \u09a6\u09cd\u09ac\u09c0\u09aa" },
            { "CY", "\u099a\u09be\u0987\u09aa\u09cd\u09f0\u09be\u099b" },
            { "CZ", "\u099a\u09bf\u099c\u09c7\u099a\u09bf\u09af\u09bc\u09be" },
            { "DE", "\u099c\u09be\u09f0\u09cd\u09ae\u09be\u09a8\u09c0" },
            { "DG", "\u09a1\u09bf\u09af\u09bc\u09c7\u0997\u09cb \u0997\u09be\u09f0\u09cd\u099a\u09bf\u09af\u09bc\u09be" },
            { "DJ", "\u099c\u09bf\u09ac\u09c1\u099f\u09bf" },
            { "DK", "\u09a1\u09c7\u09a8\u09ae\u09be\u09f0\u09cd\u0995" },
            { "DM", "\u09a1\u2019\u09ae\u09bf\u09a8\u09bf\u0995\u09be" },
            { "DO", "\u09a1\u2019\u09ae\u09bf\u09a8\u09bf\u0995\u09be\u09a8 \u09f0\u09bf\u09aa\u09be\u09ac\u09cd\u09b2\u09bf\u0995" },
            { "DZ", "\u0986\u09b2\u099c\u09c7\u09f0\u09bf\u09af\u09bc\u09be" },
            { "EA", "\u099a\u09c7\u0989\u099f\u09be \u0986\u09f0\u09c1 \u09ae\u09c7\u09b2\u09bf\u09b2\u09be" },
            { "EC", "\u0987\u0995\u09c1\u09f1\u09c7\u09a1\u09f0" },
            { "EE", "\u0987\u09b7\u09cd\u099f\u09cb\u09a8\u09bf\u09af\u09bc\u09be" },
            { "EG", "\u0987\u099c\u09bf\u09aa\u09cd\u09a4" },
            { "EH", "\u09aa\u09b6\u09cd\u099a\u09bf\u09ae\u09c0\u09af\u09bc \u099b\u09be\u09b9\u09be\u09f0\u09be" },
            { "ER", "\u098f\u09f0\u09bf\u09a4\u09cd\u09f0\u09bf\u09af\u09bc\u09be" },
            { "ES", "\u09b8\u09cd\u09aa\u09c7\u0987\u09a8" },
            { "ET", "\u0987\u09a5\u09bf\u0985\u2019\u09aa\u09bf\u09af\u09bc\u09be" },
            { "EU", "\u0987\u0989\u09f0\u09cb\u09aa\u09c0\u09af\u09bc \u09b8\u0982\u0998" },
            { "EZ", "\u0987\u0989\u09f0\u09cb\u099c\u2019\u09a8" },
            { "FI", "\u09ab\u09bf\u09a8\u09b2\u09c7\u09a3\u09cd\u09a1" },
            { "FJ", "\u09ab\u09bf\u099c\u09bf" },
            { "FK", "\u09ab\u0995\u09b2\u09c7\u09a3\u09cd\u09a1 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "FM", "\u09ae\u09be\u0987\u0995\u09cd\u09f0\u09cb\u09a8\u09c7\u099a\u09bf\u09af\u09bc\u09be" },
            { "FO", "\u09ab\u09be\u09f0\u09cb \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "FR", "\u09ab\u09cd\u09f0\u09be\u09a8\u09cd\u09b8" },
            { "GA", "\u0997\u09c7\u09ac\u09a8" },
            { "GB", "\u09b8\u0982\u09af\u09c1\u0995\u09cd\u09a4 \u09f0\u09be\u099c\u09cd\u09af" },
            { "GD", "\u0997\u09cd\u09f0\u09c7\u09a8\u09be\u09a1\u09be" },
            { "GE", "\u099c\u09f0\u09cd\u099c\u09bf\u09af\u09bc\u09be" },
            { "GF", "\u09ab\u09cd\u09f0\u09be\u09a8\u09cd\u09b8 \u0997\u09af\u09bc\u09be\u09a8\u09be" },
            { "GG", "\u0997\u09cb\u09f0\u09c7\u09a8\u099a\u09bf" },
            { "GH", "\u0998\u09be\u09a8\u09be" },
            { "GI", "\u099c\u09bf\u09ac\u09cd\u09f0\u09be\u09b2\u09cd\u099f\u09f0" },
            { "GL", "\u0997\u09cd\u09f0\u09c0\u09a3\u09b2\u09c7\u09a3\u09cd\u09a1" },
            { "GM", "\u0997\u09be\u09ae\u09cd\u09ac\u09bf\u09af\u09bc\u09be" },
            { "GN", "\u0997\u09bf\u09a8\u09bf" },
            { "GP", "\u0997\u09c1\u09f1\u09be\u09a1\u09c7\u09b2\u09c1\u09aa" },
            { "GQ", "\u0987\u0995\u09c1\u09f1\u09c7\u099f\u09f0\u09bf\u09af\u09bc\u09c7\u09b2 \u0997\u09bf\u09a8\u09bf" },
            { "GR", "\u0997\u09cd\u09f0\u09c0\u099a" },
            { "GS", "\u09a6\u0995\u09cd\u09b7\u09bf\u09a3 \u099c\u09f0\u09cd\u099c\u09bf\u09af\u09bc\u09be \u0986\u09f0\u09c1 \u09a6\u0995\u09cd\u09b7\u09bf\u09a3 \u099a\u09c7\u09a3\u09cd\u09a1\u09f1\u09bf\u099a \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "GT", "\u0997\u09c1\u09f1\u09be\u099f\u09c7\u09ae\u09be\u09b2\u09be" },
            { "GU", "\u0997\u09c1\u09f1\u09be\u09ae" },
            { "GW", "\u0997\u09bf\u09a8\u09bf-\u09ac\u09bf\u099b\u09be\u0993" },
            { "GY", "\u0997\u09be\u09af\u09bc\u09be\u09a8\u09be" },
            { "HK", "\u09b9\u0982 \u0995\u0982 \u098f\u099b. \u098f. \u0986\u09f0. \u099a\u09c0\u09a8" },
            { "HM", "\u09b9\u09be\u09f0\u09cd\u09a1 \u09a6\u09cd\u09ac\u09c0\u09aa \u0986\u09f0\u09c1 \u09ae\u09c7\u0995\u09a1\u09cb\u09a8\u09be\u09b2\u09cd\u09a1 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "HN", "\u09b9\u09a8\u09cd\u09a6\u09c1\u09f0\u09be\u099b" },
            { "HR", "\u0995\u09cd\u09f0\u09cb\u09f1\u09c7\u099b\u09bf\u09af\u09bc\u09be" },
            { "HT", "\u09b9\u09be\u0987\u099f\u09bf" },
            { "HU", "\u09b9\u09be\u0982\u0997\u09c7\u09f0\u09c0" },
            { "IC", "\u0995\u09c7\u09a8\u09c7\u09f0\u09c0 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "ID", "\u0987\u09a3\u09cd\u09a1\u09cb\u09a8\u09c7\u099a\u09bf\u09af\u09bc\u09be" },
            { "IE", "\u0986\u09af\u09bc\u09be\u09f0\u09b2\u09c7\u09a3\u09cd\u09a1" },
            { "IL", "\u0987\u099c\u09f0\u09be\u0987\u09b2" },
            { "IM", "\u0986\u0987\u09b2 \u0985\u09ab \u09ae\u09c7\u09a8" },
            { "IN", "\u09ad\u09be\u09f0\u09a4" },
            { "IO", "\u09ac\u09cd\u09f0\u09bf\u099f\u09bf\u099b \u0987\u09a3\u09cd\u09a1\u09bf\u09af\u09bc\u09be\u09a8 \u0985\u2019\u099a\u09a8 \u099f\u09c7\u09f0\u09bf\u099f\u2019\u09f0\u09bf" },
            { "IQ", "\u0987\u09f0\u09be\u0995" },
            { "IR", "\u0987\u09f0\u09be\u09a8" },
            { "IS", "\u0986\u0987\u099a\u09b2\u09c7\u09a3\u09cd\u09a1" },
            { "IT", "\u0987\u099f\u09be\u09b2\u09bf" },
            { "JE", "\u099c\u09be\u09f0\u09cd\u099a\u09bf" },
            { "JM", "\u099c\u09be\u09ae\u09be\u0987\u0995\u09be" },
            { "JO", "\u099c\u09f0\u09cd\u09a1\u09be\u09a8" },
            { "JP", "\u099c\u09be\u09aa\u09be\u09a8" },
            { "KE", "\u0995\u09c7\u09a8\u09bf\u09af\u09bc\u09be" },
            { "KG", "\u0995\u09bf\u09f0\u09cd\u0997\u09bf\u099c\u09b8\u09cd\u09a4\u09be\u09a8" },
            { "KH", "\u0995\u09ae\u09cd\u09ac\u09cb\u09a1\u09bf\u09af\u09bc\u09be" },
            { "KI", "\u0995\u09bf\u09f0\u09bf\u09ac\u09be\u099f\u09bf" },
            { "KM", "\u0995\u09cb\u09ae\u09cb\u09f0\u09cb\u099c" },
            { "KN", "\u099b\u09c7\u0987\u09a3\u09cd\u099f \u0995\u09bf\u099f\u099b \u0986\u09f0\u09c1 \u09a8\u09c7\u09ad\u09bf\u099b" },
            { "KP", "\u0989\u09a4\u09cd\u09a4\u09f0 \u0995\u09cb\u09f0\u09bf\u09af\u09bc\u09be" },
            { "KR", "\u09a6\u0995\u09cd\u09b7\u09bf\u09a3 \u0995\u09cb\u09f0\u09bf\u09af\u09bc\u09be" },
            { "KW", "\u0995\u09c1\u09f1\u09c7\u0987\u099f" },
            { "KY", "\u0995\u09c7\u0987\u09ae\u09c7\u09a8 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "KZ", "\u0995\u09be\u099c\u09be\u0996\u09be\u09b8\u09cd\u09a4\u09be\u09a8" },
            { "LA", "\u09b2\u09be\u0993\u099a" },
            { "LB", "\u09b2\u09c7\u09ac\u09be\u09a8\u09a8" },
            { "LC", "\u099b\u09c7\u0987\u09a3\u09cd\u099f \u09b2\u09c1\u099a\u09bf\u09af\u09bc\u09be" },
            { "LI", "\u09b2\u09bf\u099a\u099f\u09c7\u09a8\u09b7\u09cd\u099f\u09c7\u0987\u09a8" },
            { "LK", "\u09b6\u09cd\u09b0\u09c0\u09b2\u0982\u0995\u09be" },
            { "LR", "\u09b2\u09bf\u09ac\u09c7\u09f0\u09bf\u09af\u09bc\u09be" },
            { "LS", "\u09b2\u09c7\u099b\u2019\u09a5\u2019" },
            { "LT", "\u09b2\u09bf\u09a5\u09c1\u09f1\u09be\u09a8\u09bf\u09af\u09bc\u09be" },
            { "LU", "\u09b2\u09be\u0995\u09cd\u09b8\u09c7\u09ae\u09ac\u09be\u09f0\u09cd\u0997" },
            { "LV", "\u09b2\u09be\u099f\u09ad\u09bf\u09af\u09bc\u09be" },
            { "LY", "\u09b2\u09bf\u09ac\u09bf\u09af\u09bc\u09be" },
            { "MA", "\u09ae\u09f0\u0995\u09cd\u0995\u09cb" },
            { "MC", "\u09ae\u09cb\u09a8\u09be\u0995\u09cb" },
            { "MD", "\u09ae\u09cb\u09b2\u09a1\u09cb\u09ad\u09be" },
            { "ME", "\u09ae\u09a3\u09cd\u099f\u09c7\u09a8\u09c7\u0997\u09cd\u09f0\u09c1" },
            { "MF", "\u099b\u09c7\u0987\u09a3\u09cd\u099f \u09ae\u09be\u09f0\u09cd\u099f\u09bf\u09a8" },
            { "MG", "\u09ae\u09be\u09a6\u09be\u0997\u09be\u09b8\u09cd\u0995\u09be\u09f0" },
            { "MH", "\u09ae\u09be\u09f0\u09cd\u09b6\u09cd\u09ac\u09be\u09b2 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "MK", "\u0989\u09a4\u09cd\u09a4\u09f0 \u09ae\u09c7\u099a\u09bf\u09a1\u09cb\u09a8\u09c0\u09af\u09bc\u09be" },
            { "ML", "\u09ae\u09be\u09b2\u09bf" },
            { "MM", "\u09ae\u09cd\u09af\u09be\u09a8\u09ae\u09be\u09f0 (\u09ac\u09be\u09f0\u09cd\u09ae\u09be)" },
            { "MN", "\u09ae\u0999\u09cd\u0997\u09cb\u09b2\u09bf\u09af\u09bc\u09be" },
            { "MO", "\u09ae\u09be\u0995\u09be\u0993 \u098f\u099b. \u098f. \u0986\u09f0. \u099a\u09c0\u09a8" },
            { "MP", "\u0989\u09a4\u09cd\u09a4\u09f0 \u09ae\u09be\u09f0\u09bf\u09af\u09bc\u09be\u09a8\u09be \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "MQ", "\u09ae\u09be\u09f0\u09cd\u099f\u09bf\u09a8\u09bf\u0995" },
            { "MR", "\u09ae\u09be\u0989\u09f0\u09bf\u099f\u09be\u09a8\u09bf\u09af\u09bc\u09be" },
            { "MS", "\u09ae\u2019\u09a3\u09cd\u099f\u099b\u09c7\u09f0\u09be\u099f" },
            { "MT", "\u09ae\u09be\u09b2\u09cd\u099f\u09be" },
            { "MU", "\u09ae\u09f0\u09bf\u099b\u09be\u099b" },
            { "MV", "\u09ae\u09be\u09b2\u09a6\u09cd\u09ac\u09c0\u09aa" },
            { "MW", "\u09ae\u09be\u09b2\u09be\u09f1\u09bf" },
            { "MX", "\u09ae\u09c7\u0995\u09cd\u09b8\u09bf\u0995\u09cb" },
            { "MY", "\u09ae\u09be\u09b2\u09af\u09bc\u09c7\u099a\u09bf\u09af\u09bc\u09be" },
            { "MZ", "\u09ae\u2019\u099c\u09be\u09ae\u09ac\u09bf\u0995" },
            { "NA", "\u09a8\u09be\u09ae\u09bf\u09ac\u09bf\u09af\u09bc\u09be" },
            { "NC", "\u09a8\u09bf\u0989 \u0995\u09c7\u09b2\u09bf\u09a1\u09cb\u09a8\u09bf\u09af\u09bc\u09be" },
            { "NE", "\u09a8\u09be\u0987\u099c\u09be\u09f0" },
            { "NF", "\u09a8\u2019\u09f0\u09ab\u2019\u0995 \u09a6\u09cd\u09ac\u09c0\u09aa" },
            { "NG", "\u09a8\u09be\u0987\u099c\u09c7\u09f0\u09bf\u09af\u09bc\u09be" },
            { "NI", "\u09a8\u09bf\u0995\u09be\u09f0\u09be\u0997\u09c1\u09f1\u09be" },
            { "NL", "\u09a8\u09c7\u09a1\u09be\u09f0\u09b2\u09c7\u09a3\u09cd\u09a1" },
            { "NO", "\u09a8\u09f0\u09f1\u09c7" },
            { "NP", "\u09a8\u09c7\u09aa\u09be\u09b2" },
            { "NR", metaValue_NR },
            { "NU", "\u09a8\u09bf\u0989" },
            { "NZ", "\u09a8\u09bf\u0989\u099c\u09bf\u09b2\u09c7\u09a3\u09cd\u09a1" },
            { "OM", "\u0993\u09ae\u09be\u09a8" },
            { "PA", "\u09aa\u09be\u09a8\u09be\u09ae\u09be" },
            { "PE", "\u09aa\u09c7\u09f0\u09c1" },
            { "PF", "\u09ab\u09cd\u09f0\u09be\u09a8\u09cd\u09b8 \u09aa\u09cb\u09b2\u09c7\u09a8\u099a\u09bf\u09af\u09bc\u09be" },
            { "PG", "\u09aa\u09be\u09aa\u09c1\u09f1\u09be \u09a8\u09bf\u0989 \u0997\u09bf\u09a8\u09bf" },
            { "PH", "\u09ab\u09bf\u09b2\u09bf\u09aa\u09be\u0987\u09a8\u099b" },
            { "PK", "\u09aa\u09be\u0995\u09bf\u09b8\u09cd\u09a4\u09be\u09a8" },
            { "PL", "\u09aa\u09cb\u09b2\u09c7\u09a3\u09cd\u09a1" },
            { "PM", "\u099b\u09c7\u0987\u09a3\u09cd\u099f \u09aa\u09bf\u09af\u09bc\u09c7\u09f0\u09c7 \u0986\u09f0\u09c1 \u09ae\u09bf\u0995\u09bf\u0989\u09f1\u09c7\u09b2\u09a8" },
            { "PN", "\u09aa\u09bf\u099f\u0995\u09c7\u0987\u09f0\u09cd\u09a3 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "PR", "\u09aa\u09c1\u09f1\u09c7\u09f0\u09cd\u099f\u09cb \u09f0\u09bf\u0995\u09cb" },
            { "PS", "\u09ab\u09bf\u09b2\u09bf\u09b8\u09cd\u09a4\u09bf\u09a8 \u0985\u099e\u09cd\u099a\u09b2" },
            { "PT", "\u09aa\u09f0\u09cd\u09a4\u09c1\u0997\u09be\u09b2" },
            { "PW", "\u09aa\u09be\u09b2\u09be\u0989" },
            { "PY", "\u09aa\u09be\u09f0\u09be\u0997\u09c1\u09f1\u09c7" },
            { "QA", "\u0995\u09be\u099f\u09be\u09f0" },
            { "QO", "\u0986\u0989\u099f\u09b2\u09be\u09af\u09bc\u09bf\u0982 \u0985\u2019\u099a\u09bf\u09af\u09bc\u09be\u09a8\u09bf\u09af\u09bc\u09be" },
            { "RE", "\u09f0\u09bf\u0987\u0989\u09a8\u09bf\u09af\u09bc\u09a8" },
            { "RO", "\u09f0\u09cb\u09ae\u09be\u09a8\u09bf\u09af\u09bc\u09be" },
            { "RS", "\u099b\u09be\u09f0\u09cd\u09ac\u09bf\u09af\u09bc\u09be" },
            { "RU", "\u09f0\u09be\u099b\u09bf\u09af\u09bc\u09be" },
            { "RW", "\u09f0\u09cb\u09f1\u09be\u09a3\u09cd\u09a1\u09be" },
            { "SA", "\u099a\u09cc\u09a1\u09bf \u0986\u09f0\u09ac\u09bf\u09af\u09bc\u09be" },
            { "SB", "\u099a\u09cb\u09b2\u09cb\u09ae\u09cb\u09a8 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "SC", "\u099b\u09bf\u099a\u09bf\u09b2\u09bf\u099b" },
            { "SD", "\u099a\u09c1\u09a1\u09be\u09a8" },
            { "SE", "\u099a\u09c1\u0987\u09a1\u09c7\u09a8" },
            { "SG", "\u099b\u09bf\u0982\u0997\u09be\u09aa\u09c1\u09f0" },
            { "SH", "\u099b\u09c7\u0987\u09a3\u09cd\u099f \u09b9\u09c7\u09b2\u09c7\u09a8\u09be" },
            { "SI", "\u09b6\u09cd\u09b2\u09cb\u09ad\u09c7\u09a8\u09bf\u09af\u09bc\u09be" },
            { "SJ", "\u099a\u09be\u09ad\u09be\u09b2\u09ac\u09be\u09f0\u09cd\u09a1 \u0986\u09f0\u09c1 \u099c\u09a8 \u09ae\u09c7\u09af\u09bc\u09a8" },
            { "SK", "\u09b6\u09cd\u09b2\u09cb\u09ad\u09be\u0995\u09bf\u09af\u09bc\u09be" },
            { "SL", "\u099a\u09bf\u09af\u09bc\u09c7\u09f0\u09be \u09b2\u09bf\u0985\u2019\u09a8" },
            { "SM", "\u099a\u09be\u09a8 \u09ae\u09be\u09f0\u09bf\u09a8\u09cb" },
            { "SN", "\u099a\u09c7\u09a8\u09c7\u0997\u09be\u09b2" },
            { "SO", "\u099a\u09cb\u09ae\u09be\u09b2\u09bf\u09af\u09bc\u09be" },
            { "SR", "\u099b\u09c1\u09f0\u09bf\u09a8\u09be\u09ae" },
            { "SS", "\u09a6\u0995\u09cd\u09b7\u09bf\u09a3 \u099a\u09c1\u09a1\u09be\u09a8" },
            { "ST", "\u099a\u09be\u0993 \u099f\u09cb\u09ae\u09c7 \u0986\u09f0\u09c1 \u09aa\u09cd\u09f0\u09bf\u09a8\u099a\u09bf\u09aa\u09c7" },
            { "SV", "\u098f\u09b2 \u099b\u09c7\u09b2\u09ad\u09c7\u09a1\u2019\u09f0" },
            { "SX", "\u099a\u09bf\u09a3\u09cd\u099f \u09ae\u09be\u09f0\u09cd\u099f\u09c7\u09a8" },
            { "SY", "\u099a\u09bf\u09f0\u09bf\u09af\u09bc\u09be" },
            { "SZ", "\u0987\u099a\u09cd\u099a\u09c1\u099f\u09bf\u09a8\u09bf" },
            { "TA", "\u09a4\u09cd\u09f0\u09bf\u09b8\u09cd\u09a4\u09be\u09a8 \u09a6\u09cd\u09af\u09be \u0995\u09c1\u09a8\u09b9\u09be" },
            { "TC", "\u099f\u09be\u09f0\u09cd\u0995\u099b \u0985\u09f0\u09c1 \u0995\u09c7\u0987\u0995\u2019\u099b \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "TD", "\u099a\u09be\u09a1" },
            { "TF", "\u09a6\u0995\u09cd\u09b7\u09bf\u09a3 \u09ab\u09cd\u09f0\u09be\u09a8\u09cd\u09b8\u09f0 \u0985\u099e\u09cd\u099a\u09b2" },
            { "TG", "\u099f\u09cb\u0997\u09cb" },
            { "TH", "\u09a5\u09be\u0987\u09b2\u09c7\u09a3\u09cd\u09a1" },
            { "TJ", "\u09a4\u09be\u099c\u09bf\u0995\u09bf\u09b8\u09cd\u09a4\u09be\u09a8" },
            { "TK", "\u099f\u09cb\u0995\u09c7\u09b2\u09be\u0989" },
            { "TL", "\u099f\u09bf\u09ae\u09cb\u09f0-\u09b2\u09c7\u099a\u099f\u09c7" },
            { "TM", "\u09a4\u09c1\u09f0\u09cd\u0995\u09ae\u09c7\u09a8\u09bf\u09b8\u09cd\u09a4\u09be\u09a8" },
            { "TN", "\u099f\u09c1\u09a8\u09bf\u099a\u09bf\u09af\u09bc\u09be" },
            { "TO", "\u099f\u0982\u0997\u09be" },
            { "TR", "\u09a4\u09c1\u09f0\u09cd\u0995\u09bf" },
            { "TT", "\u099f\u09cd\u09f0\u09bf\u09a8\u09bf\u09a1\u09be\u09a1 \u0986\u09f0\u09c1 \u099f\u09cb\u09ac\u09be\u0997\u09cb" },
            { "TV", metaValue_TV },
            { "TW", "\u099f\u09be\u0987\u09f1\u09be\u09a8" },
            { "TZ", "\u09a4\u09be\u099e\u09cd\u099c\u09be\u09a8\u09bf\u09af\u09bc\u09be" },
            { "UA", "\u0987\u0989\u0995\u09cd\u09f0\u09c7\u0987\u09a8" },
            { "UG", "\u0989\u0997\u09be\u09a3\u09cd\u09a1\u09be" },
            { "UM", "\u0987\u0989. \u098f\u099b. \u0986\u0989\u099f\u09b2\u09be\u09af\u09bc\u09bf\u0982 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "UN", "\u09f0\u09be\u09b7\u09cd\u099f\u09cd\u09f0\u09b8\u0982\u0998" },
            { "US", "\u09ae\u09be\u09f0\u09cd\u0995\u09bf\u09a8 \u09af\u09c1\u0995\u09cd\u09a4\u09f0\u09be\u09b7\u09cd\u099f\u09cd\u09f0" },
            { "UY", "\u0989\u09f0\u09c1\u0997\u09c1\u09f1\u09c7" },
            { "UZ", "\u0989\u099c\u09ac\u09c7\u0995\u09bf\u09b8\u09cd\u09a4\u09be\u09a8" },
            { "VA", "\u09ad\u09c7\u099f\u09bf\u0995\u09be\u09a8 \u099a\u09bf\u099f\u09bf" },
            { "VC", "\u099b\u09c7\u0987\u09a3\u09cd\u099f \u09ad\u09bf\u09a8\u099a\u09c7\u09a3\u09cd\u099f \u0986\u09f0\u09c1 \u0997\u09cd\u09f0\u09c0\u09a3\u09be\u09a1\u09be\u0987\u09a8\u099b" },
            { "VE", "\u09ad\u09c7\u09a8\u09bf\u099c\u09c1\u09f1\u09c7\u09b2\u09be" },
            { "VG", "\u09ac\u09cd\u09f0\u09bf\u099f\u09bf\u099b \u09ad\u09be\u09f0\u09cd\u099c\u09bf\u09a8 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "VI", "\u0987\u0989. \u098f\u099b. \u09ad\u09be\u09f0\u09cd\u099c\u09bf\u09a8 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "VN", "\u09ad\u09bf\u09af\u09bc\u09c7\u099f\u09a8\u09be\u09ae" },
            { "VU", "\u09ad\u09be\u09a8\u09be\u099f\u09c1" },
            { "WF", "\u09f1\u09be\u09b2\u09bf\u099b \u0986\u09f0\u09c1 \u09ab\u09c1\u099f\u09c1\u09a8\u09be" },
            { "WS", "\u099a\u09be\u09ae\u09cb\u09f1\u09be" },
            { "XA", "\u099b\u09c1\u09a1\u09c1-\u098f\u0995\u099a\u09c7\u09a3\u09cd\u099f" },
            { "XB", "\u099b\u09c1\u09a1\u09c1-\u09ac\u09bf\u09a1\u09bf" },
            { "XK", "\u0995\u099a\u2019\u09ad\u2019" },
            { "YE", "\u09af\u09bc\u09c7\u09ae\u09c7\u09a8" },
            { "YT", "\u09ae\u09be\u09af\u09bc\u09cb\u099f\u09cd\u099f\u09c7" },
            { "ZA", "\u09a6\u0995\u09cd\u09b7\u09bf\u09a3 \u0986\u09ab\u09cd\u09b0\u09bf\u0995\u09be" },
            { "ZM", "\u099c\u09be\u09ae\u09cd\u09ac\u09bf\u09af\u09bc\u09be" },
            { "ZW", "\u099c\u09bf\u09ae\u09cd\u09ac\u09be\u09ac\u09f1\u09c7" },
            { "ZZ", "\u0985\u099c\u09cd\u099e\u09be\u09a4 \u0995\u09cd\u09b7\u09c7\u09a4\u09cd\u09f0" },
            { "aa", "\u0986\u09ab\u09be\u09f0" },
            { "ab", "\u0986\u09ac\u0996\u09be\u099c\u09bf\u09af\u09bc\u09be\u09a8" },
            { "af", "\u0986\u09ab\u09cd\u09f0\u09bf\u0995\u09be\u09a8\u099b\u09cd" },
            { "ak", "\u0986\u0995\u09be\u09a8" },
            { "am", "\u0986\u09ae\u09b9\u09be\u09f0\u09bf\u0995" },
            { "an", "\u0986\u09f0\u09cd\u0997\u09cb\u09a8\u09bf\u099c" },
            { "ar", metaValue_ar },
            { "as", "\u0985\u09b8\u09ae\u09c0\u09af\u09bc\u09be" },
            { "av", "\u0986\u09ad\u09c7\u09f0\u09bf\u0995" },
            { "ay", "\u0986\u09af\u09bc\u09ae\u09be\u09f0\u09be" },
            { "az", "\u0986\u099c\u09c7\u09f0\u09ac\u09be\u0987\u099c\u09be\u09a8\u09c0" },
            { "ba", "\u09ac\u09be\u099b\u0996\u09bf\u09f0" },
            { "be", "\u09ac\u09c7\u09b2\u09be\u09f0\u09c1\u099b\u09c0\u09af\u09bc" },
            { "bg", "\u09ac\u09c1\u09b2\u0997\u09c7\u09f0\u09c0\u09af\u09bc" },
            { "bi", "\u09ac\u09bf\u099b\u09b2\u09be\u09ae\u09be" },
            { "bm", "\u09ac\u09be\u09ae\u09ac\u09be\u09f0\u09be" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "\u09ac\u09cd\u09f0\u09c7\u099f\u09a8" },
            { "bs", "\u09ac\u099b\u09a8\u09c0\u09af\u09bc" },
            { "ca", "\u0995\u09be\u09a4\u09be\u09b2\u09be\u09a8" },
            { "ce", "\u099a\u09c7\u099a\u09c7\u09a8" },
            { "ch", "\u099a\u09be\u09ae\u09cb\u09f0\u09cb" },
            { "co", "\u0995\u09cb\u09f0\u09cd\u099b\u09bf\u0995\u09be\u09a8" },
            { "cs", "\u099a\u09c7\u0995" },
            { "cu", "\u099a\u09be\u09f0\u09cd\u099a \u09b6\u09cd\u09b2\u09c7\u09ad\u09bf\u0995" },
            { "cv", "\u099a\u09c1\u09ad\u09be\u099a" },
            { "cy", "\u09f1\u09c7\u09b2\u099a" },
            { "da", "\u09a1\u09c7\u09a8\u09bf\u099a" },
            { "de", "\u099c\u09be\u09f0\u09cd\u09ae\u09be\u09a8" },
            { "dv", "\u09a6\u09bf\u09ac\u09c7\u09b9\u09bf" },
            { "dz", "\u099c\u09cb\u0982\u0996\u09be" },
            { "ee", "\u0987\u09f1\u09c7" },
            { "el", metaValue_el },
            { "en", "\u0987\u0982\u09f0\u09be\u099c\u09c0" },
            { "eo", "\u098f\u09b8\u09cd\u09aa\u09c7\u09f0\u09be\u09a8\u09cd\u09a4\u09cb" },
            { "es", "\u09b8\u09cd\u09aa\u09c7\u09a8\u09bf\u099a" },
            { "et", "\u098f\u09b7\u09cd\u099f\u09cb\u09a8\u09bf\u09af\u09bc" },
            { "eu", "\u09ac\u09be\u09b8\u09cd\u0995" },
            { "fa", "\u09ab\u09be\u09f0\u09cd\u099b\u09c0" },
            { "ff", "\u09ab\u09c1\u09b2\u09be\u09b9" },
            { "fi", "\u09ab\u09bf\u09a8\u09bf\u099a" },
            { "fj", "\u09ab\u09bf\u099c\u09bf\u09af\u09bc\u09be\u09a8" },
            { "fo", "\u09ab\u09be\u09f0\u09cb\u0987\u099c" },
            { "fr", "\u09ab\u09cd\u09f0\u09c7\u09a8\u09cd\u09b8" },
            { "fy", "\u09f1\u09c7\u09b7\u09cd\u099f\u09be\u09f0\u09cd\u09a3 \u09ab\u09cd\u09f0\u09bf\u099b\u09bf\u09af\u09bc\u09be\u09a8" },
            { "ga", "\u0986\u0987\u09f0\u09bf\u099a" },
            { "gd", "\u09b8\u09cd\u0995\u099f\u09bf\u099a \u0997\u09c7\u0987\u09b2\u09bf\u0995" },
            { "gl", "\u0997\u09c7\u09b2\u09bf\u099a\u09bf\u09af\u09bc\u09be\u09a8" },
            { "gn", "\u0997\u09c1\u09f1\u09be\u09f0\u09be\u09a3\u09c0" },
            { "gu", metaValue_gu },
            { "gv", "\u09ae\u09c7\u0982\u0995\u09cd\u09b8" },
            { "ha", "\u09b9\u09be\u0989\u099b\u09be" },
            { "he", metaValue_he },
            { "hi", "\u09b9\u09bf\u09a8\u09cd\u09a6\u09c0" },
            { "hr", "\u0995\u09cd\u09f0\u09cb\u09f1\u09c7\u099a\u09bf\u09af\u09bc\u09be\u09a8" },
            { "ht", "\u09b9\u09c7\u0987\u099f\u09bf\u09af\u09bc\u09be\u09a8 \u0995\u09cd\u09f0\u09bf\u09af\u09bc\u09b2" },
            { "hu", "\u09b9\u09be\u0999\u09cd\u0997\u09c7\u09f0\u09bf\u09af\u09bc\u09be\u09a8" },
            { "hy", metaValue_hy },
            { "hz", "\u09b9\u09c7\u09f0\u09c7\u09f0\u09cb" },
            { "ia", "\u0987\u09a3\u09cd\u099f\u09be\u09f0\u09b2\u09bf\u0982\u0997\u09c1\u09f1\u09be" },
            { "id", "\u0987\u09a3\u09cd\u09a1\u09cb\u09a8\u09c7\u099a\u09bf\u09af\u09bc" },
            { "ig", "\u0987\u0997\u09cd\u09ac\u09cb" },
            { "ii", "\u099b\u09bf\u099a\u09c1\u09f1\u09be\u09a8 \u0987" },
            { "io", "\u0987\u09a1\u09cb" },
            { "is", "\u0986\u0987\u099a\u09b2\u09c7\u09a3\u09cd\u09a1\u09bf\u0995" },
            { "it", "\u0987\u099f\u09be\u09b2\u09bf\u09af\u09bc\u09be\u09a8" },
            { "iu", "\u0987\u09a8\u09c1\u0995\u09cd\u099f\u09bf\u099f\u09c1\u099f" },
            { "ja", metaValue_ja },
            { "jv", "\u099c\u09be\u09ad\u09be\u09a8\u09c0" },
            { "ka", metaValue_ka },
            { "ki", "\u0995\u09bf\u0995\u09c1\u09af\u09bc\u09c1" },
            { "kj", "\u0995\u09c1\u09af\u09bc\u09be\u09a8\u09bf\u09af\u09bc\u09be\u09ae\u09be" },
            { "kk", "\u0995\u09be\u099c\u09be\u0996" },
            { "kl", "\u0995\u09be\u09b2\u09be\u09b2\u09bf\u099b\u09c1\u099f" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "\u0995\u09be\u09a8\u09c1\u09f0\u09bf" },
            { "ks", "\u0995\u09be\u09b6\u09cd\u09ae\u09bf\u09f0\u09c0" },
            { "ku", "\u0995\u09c1\u09f0\u09cd\u09a1\u09bf\u099a" },
            { "kv", "\u0995\u09cb\u09ae\u09bf" },
            { "kw", "\u0995\u09cb\u09f0\u09cd\u09a8\u09bf\u099a" },
            { "ky", "\u0995\u09bf\u09f0\u09cd\u0997\u09bf\u099c" },
            { "la", metaValue_la },
            { "lb", "\u09b2\u09be\u0995\u09cd\u09b8\u09c7\u09ae\u09ac\u09be\u09f0\u09cd\u0997\u09bf\u099a" },
            { "lg", "\u0997\u09be\u09a8\u09cd\u09a6\u09be" },
            { "li", "\u09b2\u09bf\u09ae\u09cd\u09ac\u09c1\u09f0\u09cd\u0997\u09bf\u099a" },
            { "ln", "\u09b2\u09bf\u0982\u0997\u09be\u09b2\u09be" },
            { "lo", metaValue_lo },
            { "lt", "\u09b2\u09bf\u09a5\u09c1\u09f1\u09be\u09a8\u09bf\u09af\u09bc\u09be\u09a8" },
            { "lu", "\u09b2\u09c1\u09ac\u09be-\u0995\u09be\u099f\u09be\u0982\u0997\u09be" },
            { "lv", "\u09b2\u09be\u099f\u09ad\u09bf\u09af\u09bc\u09be\u09a8" },
            { "mg", "\u09ae\u09be\u09b2\u09be\u0997\u09be\u099b\u09c0" },
            { "mh", "\u09ae\u09be\u09f0\u09cd\u099a\u09b2\u09bf\u099c" },
            { "mi", "\u09ae\u09be\u0993\u09f0\u09bf" },
            { "mk", "\u09ae\u09c7\u099a\u09bf\u09a1\u09cb\u09a8\u09c0\u09af\u09bc" },
            { "ml", metaValue_ml },
            { "mn", "\u09ae\u0982\u0997\u09cb\u09b2\u09c0\u09af\u09bc" },
            { "mr", "\u09ae\u09be\u09f0\u09be\u09a0\u09c0" },
            { "ms", "\u09ae\u09be\u09b2\u09af\u09bc" },
            { "mt", "\u09ae\u09be\u09b2\u09cd\u099f\u09bf\u099c" },
            { "my", "\u09ac\u09be\u09f0\u09cd\u09ae\u09c0\u099c" },
            { "na", metaValue_NR },
            { "nb", "\u09a8\u09f0\u09f1\u09c7\u099c\u09bf\u09af\u09bc\u09be\u09a8 \u09ac\u09cb\u0995\u09ae\u09be\u09b2" },
            { "nd", "\u0989\u09a4\u09cd\u09a4\u09f0 \u09a8\u09bf\u09ac\u09c7\u09ac\u09c7\u09b2\u09c7" },
            { "ne", "\u09a8\u09c7\u09aa\u09be\u09b2\u09c0" },
            { "ng", "\u098f\u09a8\u09cd\u09a6\u09cb\u0999\u09cd\u0997\u09be" },
            { "nl", "\u09a1\u09be\u099a" },
            { "nn", "\u09a8\u09f0\u09f1\u09c7\u099c\u09bf\u09af\u09bc\u09be\u09a8 \u09a8\u09be\u09af\u09bc\u09a8\u09cb\u09f0\u09cd\u09b8\u09cd\u0995" },
            { "no", "\u09a8\u09f0\u09f1\u09c7\u099c\u09bf\u09af\u09bc\u09be\u09a8" },
            { "nr", "\u09a6\u0995\u09cd\u09b7\u09bf\u09a3 \u09a6\u09c7\u09ac\u09c7\u09b2" },
            { "nv", "\u09a8\u09be\u09ad\u09be\u099c\u09cb" },
            { "ny", "\u09a8\u09cd\u09af\u09be\u099e\u09cd\u099c\u09be" },
            { "oc", "\u0985\u2019\u099a\u09bf\u099f\u09be\u09a8" },
            { "om", "\u0993\u09f0\u09cb\u09ae\u09cb" },
            { "or", metaValue_or },
            { "os", "\u0993\u099b\u09c7\u099f\u09bf\u0995" },
            { "pa", "\u09aa\u09be\u099e\u09cd\u099c\u09be\u09ac\u09c0" },
            { "pl", "\u09aa\u2019\u09b2\u09bf\u099a" },
            { "ps", "\u09aa\u09c1\u09b8\u09cd\u09a4" },
            { "pt", "\u09aa\u09f0\u09cd\u09a4\u09c1\u0997\u09c0\u099c" },
            { "qu", "\u0995\u09c1\u09f1\u09c7\u099a\u09c1\u09f1\u09be" },
            { "rm", "\u09f0\u09cb\u09ae\u09be\u09a8\u099a" },
            { "rn", "\u09f0\u09c1\u09a8\u09cd\u09a6\u09bf" },
            { "ro", "\u09f0\u09cb\u09ae\u09be\u09a8\u09c0\u09af\u09bc" },
            { "ru", "\u09f0\u09be\u099b\u09bf\u09af\u09bc\u09be\u09a8" },
            { "rw", "\u0995\u09bf\u09a8\u09af\u09bc\u09be\u09f0\u09cb\u09f1\u09be\u09a3\u09cd\u09a1\u09be" },
            { "sa", "\u09b8\u0982\u09b8\u09cd\u0995\u09c3\u09a4" },
            { "sc", "\u099b\u09be\u09f0\u09cd\u09a1\u09bf\u09a8\u09bf\u09af\u09bc\u09be\u09a8" },
            { "sd", "\u09b8\u09bf\u09a8\u09cd\u09a7\u09c0" },
            { "se", "\u0989\u09a6\u09c0\u099a\u09cd\u09af \u099b\u09be\u09ae\u09bf" },
            { "sg", "\u099b\u09be\u0999\u09cd\u0997\u09cb" },
            { "si", "\u09b8\u09bf\u0982\u09b9\u09b2\u09be" },
            { "sk", "\u09b6\u09cd\u09b2\u09cb\u09ad\u09be\u0995" },
            { "sl", "\u09b6\u09cd\u09b2\u09cb\u09ad\u09c7\u09a8\u09bf\u09af\u09bc\u09be\u09a8" },
            { "sm", "\u099b\u09be\u09ae\u09cb\u09a8" },
            { "sn", "\u099a\u09cb\u09a8\u09be" },
            { "so", "\u099b\u09cb\u09ae\u09be\u09b2\u09bf" },
            { "sq", "\u0986\u09b2\u09ac\u09c7\u09a8\u09c0\u09af\u09bc" },
            { "sr", "\u099b\u09be\u09f0\u09cd\u09ac\u09bf\u09af\u09bc\u09be\u09a8" },
            { "ss", "\u09b8\u09cd\u09ac\u09be\u09a4\u09bf" },
            { "st", "\u09a6\u09be\u0995\u09cd\u09b7\u09bf\u09a3\u09be\u09a4\u09cd\u09af \u099b\u09cb\u09a5\u09cb" },
            { "su", "\u099b\u09c1\u09a3\u09cd\u09a1\u09be\u09a8\u09c0\u099c" },
            { "sv", "\u099b\u09c1\u0987\u09a1\u09bf\u099a" },
            { "sw", "\u09b8\u09cd\u09ac\u09be\u09b9\u09bf\u09b2\u09bf" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "\u09a4\u09be\u099c\u09bf\u0995" },
            { "th", metaValue_th },
            { "ti", "\u099f\u09bf\u0997\u09f0\u09bf\u09a8\u09bf\u09af\u09bc\u09be" },
            { "tk", "\u09a4\u09c1\u09f0\u09cd\u0995\u09ae\u09c7\u09a8" },
            { "tn", "\u099b\u09cb\u09f1\u09be\u09a8\u09be" },
            { "to", "\u099f\u09cb\u0999\u09cd\u0997\u09be\u09a8" },
            { "tr", "\u09a4\u09c1\u09f0\u09cd\u0995\u09c0" },
            { "ts", "\u099b\u09cb\u0999\u09cd\u0997\u09be" },
            { "tt", "\u09a4\u09be\u09a4\u09be\u09f0" },
            { "ty", "\u09a4\u09be\u09b9\u09bf\u09a4\u09bf\u09af\u09bc\u09be\u09a8" },
            { "ug", "\u0989\u0987\u0998\u09c1\u09f0" },
            { "uk", "\u0987\u0989\u0995\u09cd\u09f0\u09c7\u0987\u09a8\u09c0\u09af\u09bc" },
            { "ur", "\u0989\u09f0\u09cd\u09a6\u09c1" },
            { "uz", "\u0989\u099c\u09ac\u09c7\u0995" },
            { "ve", "\u09ad\u09c7\u09a3\u09cd\u09a1\u09be" },
            { "vi", "\u09ad\u09bf\u09af\u09bc\u09c7\u099f\u09a8\u09be\u09ae\u09c0" },
            { "vo", "\u09ad\u09cb\u09b2\u09be\u09aa\u09c1\u0995" },
            { "wa", "\u09f1\u09be\u09b2\u09c1\u09a8" },
            { "wo", "\u09f1\u09cb\u09b2\u09be\u09ab" },
            { "xh", "\u09b9\u09cb\u099b\u09be" },
            { "yi", "\u0987\u09a6\u09cd\u09a6\u09bf\u099b" },
            { "yo", "\u0987\u0989\u09f0\u09c1\u09ac\u09be" },
            { "zh", "\u099a\u09c0\u09a8\u09be" },
            { "zu", "\u099d\u09c1\u09b2\u09c1" },
            { "ace", "\u0986\u099a\u09bf\u09a8\u09bf\u099c" },
            { "ada", "\u0986\u09a6\u09be\u0982\u09ae\u09c7" },
            { "ady", "\u0986\u09a6\u09bf\u0997\u09c7" },
            { "agq", "\u0986\u0998\u09c7\u09ae" },
            { "ain", "\u0986\u0987\u09a8\u09c1" },
            { "ale", "\u0986\u09b2\u09c7\u0989\u099f" },
            { "alt", "\u09a6\u09be\u0995\u09cd\u09b7\u09bf\u09a3\u09be\u09a4\u09cd\u09af \u0986\u09b2\u09cd\u099f\u09be\u0987" },
            { "ann", "\u0985\u2019\u09ac\u2019\u09b2\u2019" },
            { "anp", "\u0986\u0999\u09cd\u0997\u09bf\u0995\u09be" },
            { "arn", "\u09ae\u09be\u09aa\u09c1\u099a\u09c7" },
            { "arp", "\u0986\u09f0\u09be\u09aa\u09be\u09b9\u09cb" },
            { "ars", "\u09a8\u09be\u099c\u09a1\u09bf \u0986\u09f0\u09ac\u09c0" },
            { "asa", "\u0986\u099b\u09c1" },
            { "ast", "\u098f\u09b7\u09cd\u099f\u09c1\u09f0\u09c0\u09af\u09bc" },
            { "atj", "\u0986\u09a4\u09bf\u0995\u09be\u09ae\u09c7\u0995" },
            { "awa", "\u0985\u09f1\u09a7\u09c0" },
            { "ban", "\u09ac\u09be\u09b2\u09bf\u09a8\u09c0\u099c" },
            { "bas", "\u09ac\u09be\u099b\u09be" },
            { "bem", "\u09ac\u09c7\u09ae\u09cd\u09ac\u09be" },
            { "bez", "\u09ac\u09c7\u09a8\u09be" },
            { "bho", "\u09ad\u09cb\u099c\u09aa\u09c1\u09f0\u09c0" },
            { "bin", "\u09ac\u09bf\u09a8\u09bf" },
            { "bla", "\u099b\u09bf\u0995\u09cd\u09b8\u09bf\u0995\u09be" },
            { "brx", "\u09ac\u09a1\u09bc\u09cb" },
            { "bug", "\u09ac\u0997\u09bf\u09a8\u09c0\u099c" },
            { "byn", "\u09ac\u09cd\u09b2\u09bf\u09a8" },
            { "cay", "\u0995\u09be\u09af\u09bc\u09c1\u0997\u09be" },
            { "ccp", "\u099a\u09be\u0995\u09cd\u200c\u09ae\u09be" },
            { "ceb", "\u099a\u09bf\u09ac\u09c1\u09f1\u09be\u09a8\u09cb" },
            { "cgg", "\u099a\u09bf\u0997\u09be" },
            { "chk", "\u099a\u09c1\u0995\u09bf\u099c" },
            { "chm", "\u09ae\u09be\u09f0\u09bf" },
            { "cho", "\u099a\u09cb\u0995\u09cd\u099f\u09be\u0989" },
            { "chp", "\u099a\u09bf\u09aa\u09c7\u0989\u09af\u09bc\u09be\u09a8" },
            { "chr", "\u099a\u09c7\u09f0\u09cb\u0995\u09bf" },
            { "chy", "\u099a\u09be\u0987\u09af\u09bc\u09c7\u09a8" },
            { "ckb", "\u099a\u09c7\u09a3\u09cd\u099f\u09cd\u09f0\u09c7\u09b2 \u0995\u09c1\u09f0\u09cd\u09a1\u09bf\u099a" },
            { "clc", "\u099a\u09bf\u09b2\u0995\u2019\u099f\u09bf\u09a8" },
            { "crg", "\u09ae\u09bf\u099a\u09bf\u09ab" },
            { "crj", "\u09a6\u09be\u0995\u09cd\u09b7\u09bf\u09a3\u09be\u09a4\u09cd\u09af \u0987\u09b7\u09cd\u099f \u0995\u09cd\u09f0\u09c0" },
            { "crk", "\u09aa\u09cd\u09b2\u09c7\u0987\u09a8\u099b \u0995\u09cd\u09f0\u09c0" },
            { "crl", "\u09a8\u09f0\u09cd\u09a6\u09be\u09f0\u09cd\u09a8 \u0987\u09b7\u09cd\u099f \u0995\u09cd\u09f0\u09c0" },
            { "crm", "\u09ae\u09c1\u099c \u0995\u09cd\u09f0\u09c0" },
            { "crr", "\u0995\u09c7\u09f0\u2019\u09b2\u09bf\u09a8\u09be \u0986\u09b2\u0997\u0982\u0995\u09bf\u09af\u09bc\u09be\u09a8" },
            { "crs", "\u099b\u09c7\u099b\u09c7\u09b2\u09f1\u09be \u0995\u09cd\u09f0\u09bf\u0993\u09b2 \u09ab\u09cd\u09f0\u09c7\u09a8\u09cd\u09b8" },
            { "csw", "\u09b8\u09cd\u09ac\u09be\u09ae\u09cd\u09aa\u09c0 \u0995\u09cd\u09f0\u09c0" },
            { "dak", "\u09a1\u09be\u0995\u09cb\u099f\u09be" },
            { "dar", "\u09a6\u09be\u09f0\u09cd\u0997\u09f1\u09be" },
            { "dav", "\u09a4\u09c7\u0987\u09a4\u09be" },
            { "dgr", "\u09a1\u09cb\u0997\u09cd\u09f0\u09bf\u09ac" },
            { "dje", "\u099d\u09be\u09f0\u09cd\u09ae\u09be" },
            { "doi", "\u09a1\u09cb\u0997\u09cd\u09f0\u09c0" },
            { "dsb", "\u09b2\u2019\u09f1\u09be\u09f0 \u099b\u09cb\u09f0\u09cd\u09ac\u09bf\u09af\u09bc\u09be\u09a8" },
            { "dua", "\u09a1\u09c1\u09f1\u09be\u09b2\u09be" },
            { "dyo", "\u099c\u09cb\u09b2\u09be-\u09ab\u2019\u09a8\u09bf" },
            { "dzg", "\u09a6\u09be\u099c\u09be\u0997\u09be" },
            { "ebu", "\u098f\u09ae\u09cd\u09ac\u09c1" },
            { "efi", "\u098f\u09ab\u09bf\u0995" },
            { "eka", "\u098f\u0995\u09be\u099c\u09c1\u0995" },
            { "ewo", "\u0987\u0993\u09a8\u09cd\u09a6\u09cb" },
            { "fil", "\u09ab\u09bf\u09b2\u09bf\u09aa\u09bf\u09a8\u09cb" },
            { "fon", "\u09ab\u2019\u09a8" },
            { "frc", "\u0995\u09c7\u099c\u2019\u09a8 \u09ab\u09f0\u09be\u099b\u09c0" },
            { "frr", "\u09a8\u09f0\u09cd\u09a6\u09be\u09f0\u09cd\u09a8 \u09ab\u09cd\u09f0\u09bf\u099b\u09bf\u09af\u09bc\u09be\u09a8" },
            { "fur", "\u09ab\u09cd\u09f0\u09bf\u0989\u09b2\u09bf\u09af\u09bc\u09be\u09a8" },
            { "gaa", "\u0997\u09be" },
            { "gez", "\u0997\u09c0\u099c" },
            { "gil", "\u0997\u09bf\u09b2\u09ac\u09be\u09f0\u09cd\u099f\u09bf\u099b" },
            { "gor", "\u0997\u09cb\u09f0\u09cb\u09a8\u09cd\u09a4\u09be\u09b2\u09cb" },
            { "gsw", "\u099b\u09c1\u0987\u099a \u099c\u09be\u09f0\u09cd\u09ae\u09be\u09a8" },
            { "guz", "\u0997\u09c1\u099b\u09bf" },
            { "gwi", "\u099c\u09bf\u0989\u0987\u099a\u09bf\u09a8" },
            { "hai", "\u09b9\u09c7\u0987\u09a1\u09be" },
            { "haw", "\u09b9\u09be\u09f1\u09be\u0987" },
            { "hax", "\u09a6\u09be\u0995\u09cd\u09b7\u09bf\u09a3\u09be\u09a4\u09cd\u09af\u09f0 \u09b9\u09be\u0987\u09a1\u09be" },
            { "hil", "\u09b9\u09bf\u09b2\u09bf\u0997\u09be\u09af\u09bc\u09a8\u09cb\u09a8" },
            { "hmn", "\u09b9\u09ae\u0982" },
            { "hsb", "\u0986\u09aa\u09be\u09f0 \u099b\u09cb\u09f0\u09cd\u09ac\u09bf\u09af\u09bc\u09be\u09a8" },
            { "hup", "\u09b9\u09c1\u09aa\u09be" },
            { "hur", "\u09b9\u09c7\u09b2\u0995\u09cb\u09ae\u09c7\u09b2\u09c7\u09ae" },
            { "iba", "\u0987\u09ac\u09be\u09a8" },
            { "ibb", "\u0987\u09ac\u09bf\u09ac\u09bf\u0993" },
            { "ikt", "\u09f1\u09c7\u09b7\u09cd\u099f\u09be\u09f0\u09cd\u09a3 \u0995\u09be\u09a8\u09be\u09a1\u09bf\u09af\u09bc\u09be\u09a8 \u0987\u09a8\u0995\u09cd\u099f\u09bf\u099f\u09c1\u099f" },
            { "ilo", "\u0987\u09b2\u09cb\u0995\u09cb" },
            { "inh", "\u0987\u0982\u0997\u09c1\u099a" },
            { "jbo", "\u09b2\u09cb\u099c\u09cd\u09ac\u09be\u09a8" },
            { "jgo", "\u09a8\u0997\u09cb\u09ae\u09cd\u09ac\u09be" },
            { "jmc", "\u09ae\u09c7\u0995\u09b9\u09c7\u09ae" },
            { "kab", "\u0995\u09be\u09ac\u09be\u0987\u09b2" },
            { "kac", "\u0995\u09be\u099a\u09bf\u09a8" },
            { "kaj", "\u099c\u099c\u09c1" },
            { "kam", "\u0995\u09be\u09ae\u09cd\u09ac\u09be" },
            { "kbd", "\u0995\u09be\u09ac\u09be\u09f0\u09cd\u09a1\u09bf\u09af\u09bc\u09be\u09a8" },
            { "kcg", "\u09a4\u09cd\u09af\u09be\u09aa" },
            { "kde", "\u09ae\u09be\u0995\u09cb\u09a3\u09cd\u09a1" },
            { "kea", "\u0995\u09be\u09ac\u09c1\u09ad\u09c7\u09f0\u09cd\u09a1\u09bf\u09af\u09bc\u09be\u09a8\u09c1" },
            { "kfo", "\u0995\u09cb\u09f0\u09cb" },
            { "kgp", "\u0995\u09c7\u0987\u0982\u0997\u09be\u0982" },
            { "kha", "\u0996\u09be\u099a\u09bf" },
            { "khq", "\u0995\u09cb\u09af\u09bc\u09be\u09f0 \u099a\u09bf\u09a8\u09bf" },
            { "kkj", "\u0995\u09be\u0995\u09cb" },
            { "kln", "\u0995\u09be\u09b2\u09c7\u09a8\u099c\u09bf\u09a8" },
            { "kmb", "\u0995\u09bf\u09ae\u09cd\u09ac\u09c1\u09a8\u09cd\u09a6\u09c1" },
            { "kok", "\u0995\u09cb\u0982\u0995\u09a3\u09c0" },
            { "kpe", "\u0995\u09c7\u09aa\u09c7\u09b2" },
            { "krc", "\u0995\u09be\u09f0\u09be\u099a\u09c7-\u09ac\u09be\u09b2\u09cd\u0995\u09be\u09f0" },
            { "krl", "\u0995\u09c7\u09f0\u09c7\u09b2\u09bf\u09af\u09bc\u09be\u09a8" },
            { "kru", "\u0995\u09c1\u09f0\u09c1\u0996" },
            { "ksb", "\u099a\u09be\u09ae\u09cd\u09ac\u09be\u09b2\u09be" },
            { "ksf", "\u09ac\u09be\u09ab\u09bf\u09af\u09bc\u09be" },
            { "ksh", "\u0995\u09cb\u09b2\u09cb\u0997\u09a8\u09bf\u09af\u09bc\u09be\u09a8" },
            { "kum", "\u0995\u09c1\u09ae\u09bf\u0995" },
            { "kwk", "\u0995\u09cd\u09ac\u09be\u0995\u09f1\u09be\u09b2\u09be" },
            { "lad", "\u09b2\u09be\u09a1\u09bf\u09a8\u09cb" },
            { "lag", "\u09b2\u09be\u0982\u0997\u09bf" },
            { "lez", "\u09b2\u09c7\u099c\u0998\u09bf\u09af\u09bc\u09be\u09a8" },
            { "lil", "\u09b2\u09bf\u09b2\u09cd\u09b2\u09cb\u09f1\u09c7\u099f" },
            { "lkt", "\u09b2\u09be\u0995\u09cb\u099f\u09be" },
            { "lou", "\u09b2\u09c1\u0987\u099c\u09bf\u09af\u09bc\u09be\u09a8\u09be \u0995\u09c7\u09f0\u2019\u09b2" },
            { "loz", "\u09b2\u09cb\u099c\u09bf" },
            { "lrc", "\u0989\u09a6\u09c0\u099a\u09cd\u09af \u09b2\u09c1\u09f0\u09bf" },
            { "lsm", "\u099a\u09be\u09ae\u09bf\u09af\u09bc\u09be" },
            { "lua", "\u09b2\u09c1\u09ac\u09be-\u09b2\u09c1\u09b2\u09c1\u09f1\u09be" },
            { "lun", "\u09b2\u09c1\u09a3\u09cd\u09a1\u09be" },
            { "luo", "\u09b2\u09c1\u0993" },
            { "lus", "\u09ae\u09bf\u099c\u09cb" },
            { "luy", "\u09b2\u09c1\u0987\u09af\u09bc\u09be" },
            { "mad", "\u09ae\u09be\u09a6\u09c1\u09f0\u09c7\u099b\u09c7" },
            { "mag", "\u09ae\u09be\u0997\u09be\u09b9\u09bf" },
            { "mai", "\u09ae\u09c8\u09a5\u09bf\u09b2\u09c0" },
            { "mak", "\u09ae\u09be\u0995\u09be\u099b\u09be\u09f0" },
            { "mas", "\u09ae\u09be\u099b\u09be\u0987" },
            { "mdf", "\u09ae\u09cb\u0995\u09cd\u09b8\u09be" },
            { "men", "\u09ae\u09c7\u09a3\u09cd\u09a1\u09c7" },
            { "mer", "\u09ae\u09c7\u09f0\u09c1" },
            { "mfe", "\u09ae\u09f0\u09bf\u099b\u09bf\u09af\u09bc\u09be\u09a8" },
            { "mgh", "\u09ae\u09be\u0996\u09c1\u09f1\u09be-\u09ae\u09bf\u099f\u09cd\u099f\u09cb" },
            { "mgo", "\u09ae\u09c7\u099f\u09be" },
            { "mic", "\u09ae\u09bf\u0995\u09ae\u09c7\u0995" },
            { "min", "\u09ae\u09bf\u09a8\u09be\u0982\u0995\u09be\u09ac\u09be\u0989" },
            { "mni", "\u09ae\u09a3\u09bf\u09aa\u09c1\u09f0\u09c0" },
            { "moe", "\u0987\u09a8\u09cd\u09a8\u09c1-\u0986\u0987\u09ae\u09c1\u09a8" },
            { "moh", "\u09ae\u09cb\u09b9\u09cb\u0995" },
            { "mos", "\u09ae\u09cb\u099b\u09bf" },
            { "mua", "\u09ae\u09c1\u09a3\u09cd\u09a1\u09be\u0982" },
            { "mul", "\u098f\u0995\u09be\u09a7\u09bf\u0995 \u09ad\u09be\u09b7\u09be" },
            { "mus", "\u0995\u09cd\u09f0\u09c0\u0995" },
            { "mwl", "\u09ae\u09bf\u09f0\u09be\u09a3\u09cd\u09a1\u09bf\u099c" },
            { "myv", "\u098f\u09f0\u099c\u09bf\u09af\u09bc\u09be" },
            { "mzn", "\u09ae\u09be\u099c\u09c7\u09a8\u09cd\u09a6\u09be\u09f0\u09be\u09a8\u09bf" },
            { "nap", "\u09a8\u09bf\u09af\u09bc\u09be\u09aa\u09cb\u09b2\u09bf\u099f\u09c7\u09a8" },
            { "naq", "\u09a8\u09be\u09ae\u09be" },
            { "nds", "\u09b2\u2019 \u099c\u09be\u09f0\u09cd\u09ae\u09be\u09a8" },
            { "new", "\u09a8\u09c7\u09f1\u09be\u09f0\u09bf" },
            { "nia", "\u09a8\u09bf\u09af\u09bc\u09be\u099b" },
            { "niu", "\u09a8\u09bf\u09af\u09bc\u09c1\u09f1\u09be\u09a8" },
            { "nmg", "\u0995\u09cb\u09f1\u09be\u099b\u09bf\u0985\u2019" },
            { "nnh", "\u09a8\u09bf\u09af\u09bc\u09c7\u09ae\u09cd\u09ac\u09cb\u09a8" },
            { "nog", "\u09a8\u09cb\u0997\u09be\u0987" },
            { "nqo", "\u098f\u09a8\u09cd\u0995\u09cb" },
            { "nso", "\u0989\u09a6\u09c0\u099a\u09cd\u09af \u099b\u09cb\u09a5\u09cb" },
            { "nus", "\u09a8\u09c1\u09af\u09bc\u09c7\u09f0" },
            { "nyn", "\u09a8\u09cd\u09af\u09be\u09a8\u0995\u09cb\u09b2" },
            { "ojb", "\u09a8\u09f0\u09cd\u09a5-\u09f1\u09c7\u09b7\u09cd\u099f\u09be\u09f0\u09cd\u09a3 \u0985\u099c\u09bf\u09ac\u09f1\u09be" },
            { "ojc", "\u099a\u09c7\u09a8\u09cd\u099f\u09cd\u09f0\u09c7\u0995 \u0985\u099c\u09bf\u09ac\u09f1\u09be" },
            { "ojs", "\u0985\u2019\u099c\u09bf-\u0995\u09cd\u09f0\u09c0" },
            { "ojw", "\u09f1\u09c7\u09b7\u09cd\u099f\u09be\u09f0\u09cd\u09a3 \u0985\u099c\u09bf\u09ac\u09f1\u09be" },
            { "oka", "\u0985\u2019\u0995\u09be\u09a8\u09be\u0997\u09be\u09a8" },
            { "pag", "\u09aa\u0982\u0997\u09be\u099b\u09bf\u09a8\u09be\u09a8" },
            { "pam", "\u09aa\u09be\u09ae\u09cd\u09aa\u09be\u09a8\u09cd\u0997\u09be" },
            { "pap", "\u09aa\u09be\u09aa\u09bf\u09af\u09bc\u09be\u09ae\u09c7\u09a3\u09cd\u099f\u09cb" },
            { "pau", "\u09aa\u09be\u09b2\u09be\u0989\u09f1\u09be\u09a8" },
            { "pcm", "\u09a8\u09be\u0987\u099c\u09c7\u09f0\u09bf\u09af\u09bc\u09be\u09a8 \u09aa\u09bf\u099c\u09bf\u09a8" },
            { "pis", "\u09aa\u09bf\u099c\u09bf\u09a8" },
            { "pqm", "\u09ae\u09be\u09b2\u09bf\u099b\u09c0\u099f-\u09aa\u09be\u099b\u09be\u09ae\u09be\u0995\u09c1\u2019\u09a1\u09c0" },
            { "prg", "\u09aa\u09cd\u09f0\u09c1\u099b\u09bf\u09af\u09bc\u09be\u09a8" },
            { "quc", "\u0995\u09bf\u099a\u09bf\u09af\u09bc\u09c7" },
            { "rap", "\u09f0\u09be\u09aa\u09be\u09a8\u09c1\u0987" },
            { "rar", "\u09f0\u09be\u09f0\u09cb\u09a4\u09cb\u0999\u09cd\u0997\u09a8" },
            { "rhg", "\u09f0\u09cb\u09b9\u09bf\u0999\u09cd\u0997\u09bf\u09af\u09bc\u09be" },
            { "rof", "\u09f0\u09cb\u09ae\u09cd\u09ac\u09cb" },
            { "rup", "\u0986\u09f0\u09cb\u09ae\u09be\u09a8\u09c0\u09af\u09bc" },
            { "rwk", "\u09f0\u09f1\u09be" },
            { "sad", "\u099b\u09be\u09a8\u09cd\u09a6\u09be\u09f1\u09c7" },
            { "sah", "\u099b\u09be\u0996\u09be" },
            { "saq", "\u099b\u09be\u09ae\u09cd\u09ac\u09c1\u09f0\u09c1" },
            { "sat", "\u099a\u09be\u0993\u09a4\u09be\u09b2\u09bf" },
            { "sba", "\u09a8\u09be\u0982\u09ae\u09cd\u09ac\u09c7" },
            { "sbp", "\u099b\u09be\u0999\u09cd\u0997\u09c1" },
            { "scn", "\u099b\u09bf\u099a\u09bf\u09b2\u09bf\u09af\u09bc\u09be\u09a8" },
            { "sco", "\u09b8\u09cd\u0995\u099f\u099b" },
            { "seh", "\u099b\u09c7\u09a8\u09be" },
            { "ses", "\u0995\u09cb\u0987\u09f0\u09be\u09ac\u09cb\u09f0\u09cb \u099a\u09c7\u09a8\u09cd\u09a8\u09bf" },
            { "shi", "\u09a4\u09be\u099a\u09c7\u09b2\u09b9\u09bf\u099f" },
            { "shn", "\u099a\u09be\u09a8" },
            { "slh", "\u09a6\u09be\u0995\u09cd\u09b7\u09bf\u09a3\u09be\u09a4\u09cd\u09af\u09f0 \u09b2\u09c1\u099b\u09c1\u099f\u099a\u09c0\u09a1" },
            { "sma", "\u09a6\u09be\u0995\u09cd\u09b7\u09bf\u09a3\u09be\u09a4\u09cd\u09af \u099b\u09be\u09ae\u09bf" },
            { "smj", "\u09b2\u09c1\u09b2\u09c7 \u099b\u09be\u09ae\u09bf" },
            { "smn", "\u0987\u09a8\u09be\u09f0\u09bf \u099b\u09be\u09ae\u09bf" },
            { "sms", "\u09b8\u09cd\u0995\u09cb\u09b2\u09cd\u099f \u099b\u09be\u09ae\u09bf" },
            { "snk", "\u099b\u09cb\u09a8\u09bf\u09a8\u0995\u09c7" },
            { "srn", "\u09b8\u09cd\u09f0\u09be\u09a8\u09be\u09a8 \u099f\u09cb\u0999\u09cd\u0997\u09cb" },
            { "ssy", "\u099b\u09be\u09b9\u09cb" },
            { "str", "\u09b7\u09cd\u099f\u09cd\u09f0\u09c7\u0987\u099f\u099b \u099b\u09c7\u09b2\u09bf\u09b6\u09cd\u09ac" },
            { "suk", "\u099b\u09c1\u0995\u09c1\u09ae\u09be" },
            { "swb", "\u0995\u09cb\u09ae\u09cb\u09f0\u09bf\u09af\u09bc\u09be\u09a8" },
            { "syr", "\u099a\u09bf\u09f0\u09bf\u09af\u09bc\u09be\u0995" },
            { "tce", "\u09a6\u09be\u0995\u09cd\u09b7\u09bf\u09a3\u09be\u09a4\u09cd\u09af\u09f0 \u099f\u09c1\u099f\u099a\u2019\u09a8" },
            { "tem", "\u099f\u09bf\u09ae\u09cd\u09a8\u09c7" },
            { "teo", "\u09a4\u09c7\u099b\u09cb" },
            { "tet", "\u09a4\u09c7\u09a4\u09c1\u09ae" },
            { "tgx", "\u099f\u09c7\u0997\u09bf\u09b6\u09cd\u09ac" },
            { "tht", "\u099f\u09be\u09b9\u09b2\u099f\u09be\u09a8" },
            { "tig", "\u09a4\u09be\u0987\u0997\u09cd\u09f0\u09c7" },
            { "tlh", "\u0995\u09cd\u09b2\u09bf\u0982\u0997\u09a8" },
            { "tli", "\u09b2\u09bf\u0982\u0997\u09bf\u099f" },
            { "tok", "\u099f\u2019\u0995\u09bf \u09aa\u2019\u09a8\u09be" },
            { "tpi", "\u099f\u09cb\u0995 \u09aa\u09bf\u099b\u09bf\u09a8" },
            { "trv", "\u09a4\u09be\u09f0\u09cb\u0995\u09cb" },
            { "ttm", "\u09a8\u09f0\u09cd\u09a6\u09be\u09f0\u09cd\u09a8 \u099f\u09c1\u099f\u099a\u2019\u09a8" },
            { "tum", "\u09a4\u09c1\u09ae\u09cd\u09ac\u09c1\u0995\u09be" },
            { "tvl", metaValue_TV },
            { "twq", "\u099f\u09be\u099b\u09be\u09f1\u09be\u0995" },
            { "tyv", "\u09a4\u09c1\u09ad\u09bf\u09a8\u09bf\u09af\u09bc\u09be\u09a8" },
            { "tzm", "\u099a\u09c7\u09a3\u09cd\u099f\u09cd\u09f0\u09c7\u09b2 \u098f\u099f\u09b2\u09be\u099b \u099f\u09be\u09ae\u09be\u099c\u09be\u0987\u099f" },
            { "udm", "\u0989\u09a6\u09ae\u09c1\u09f0\u09cd\u09a4" },
            { "umb", "\u0989\u09ae\u09cd\u09ac\u09c1\u09a8\u09cd\u09a6\u09c1" },
            { "und", "\u0985\u099c\u09cd\u099e\u09be\u09a4 \u09ad\u09be\u09b7\u09be" },
            { "vai", metaValue_vai },
            { "vun", "\u09ad\u09c1\u099e\u09cd\u099c\u09c1" },
            { "wae", "\u09f1\u09be\u09b2\u099b\u09c7\u09f0" },
            { "wal", "\u0993\u09b2\u09c7\u0987\u099f\u09be" },
            { "war", "\u09f1\u09be\u09f0\u09c7" },
            { "wuu", "\u09f1\u09c1 \u099a\u09be\u0987\u09a8\u09bf\u099c" },
            { "xal", "\u0995\u09be\u09b2\u09cd\u09ae\u09bf\u0995" },
            { "xog", "\u099b\u09cb\u0997\u09be" },
            { "yav", "\u09af\u09bc\u09be\u0982\u09ac\u09c7\u09a8" },
            { "ybb", "\u09af\u09bc\u09c7\u09ae\u09cd\u09ac\u09be" },
            { "yrl", "\u09b9\u09bf\u0982\u0997\u09be\u099f\u09cb" },
            { "yue", "\u0995\u09c7\u09a3\u09cd\u099f\u09cb\u09a8\u09c0\u099c" },
            { "zgh", "\u09b7\u09cd\u099f\u09c7\u09a3\u09cd\u09a1\u09be\u09f0\u09cd\u09a1 \u09ae\u09cb\u09f0\u09cb\u0995\u09cd\u0995\u09be\u09a8 \u09a4\u09be\u09ae\u09be\u099c\u09be\u0987\u099f" },
            { "zun", "\u099d\u09c1\u09a8\u09bf" },
            { "zxx", "\u0995\u09cb\u09a8\u09cb \u09ad\u09be\u09b7\u09be \u09b8\u09ae\u09b2 \u09a8\u09be\u0987" },
            { "zza", "\u099d\u09be\u099d\u09be" },
            { "Adlm", "\u098f\u09a1\u09b2\u09be\u09ae" },
            { "Arab", metaValue_ar },
            { "Aran", "\u09a8\u09be\u09b7\u09cd\u099f\u09be\u09b2\u09bf\u0995" },
            { "Armn", metaValue_hy },
            { "Beng", metaValue_bn },
            { "Bopo", "\u09ac\u09cb\u09aa\u09cb\u09ae\u09cb\u09ab\u09cb" },
            { "Brai", "\u09ac\u09cd\u09f0\u09c7\u0987\u09b2" },
            { "Cakm", "\u099a\u09be\u0995\u09ae\u09be" },
            { "Cans", "\u0987\u0989\u09a8\u09bf\u09ab\u09be\u0987\u09a1 \u0995\u09be\u09a8\u09be\u09a1\u09bf\u09af\u09bc\u09be\u09a8 \u098f\u09ac\u2019\u09f0\u09bf\u099c\u09bf\u09a8\u09c7\u09b2 \u099b\u09bf\u09b2\u09c7\u09ac\u09bf\u0995\u099b" },
            { "Cher", "\u099a\u09c7\u09f0\u2019\u0995\u09c0" },
            { "Cyrl", "\u099a\u09bf\u09f0\u09bf\u09b2\u09bf\u0995" },
            { "Deva", "\u09a6\u09c7\u09f1\u09a8\u09be\u0997\u09f0\u09c0" },
            { "Ethi", "\u0987\u09a5\u09bf\u0985\u2019\u09aa\u09bf\u0995" },
            { "Geor", metaValue_ka },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "\u0997\u09c1\u09f0\u09c1\u09ae\u09c1\u0996\u09c0" },
            { "Hanb", "\u09ac\u09cb\u09aa\u09cb\u09ae\u09cb\u09ab\u09cb\u09f0 \u09b8\u09c8\u09a4\u09c7 \u09b9\u09be\u09a8" },
            { "Hang", "\u09b9\u09c7\u0999\u09cd\u0997\u09c1\u09b2" },
            { "Hani", "\u09b9\u09be\u09a8" },
            { "Hans", "\u09b8\u09f0\u09b2\u09c0\u0995\u09c3\u09a4" },
            { "Hant", "\u09aa\u09f0\u09ae\u09cd\u09aa\u09f0\u09be\u0997\u09a4" },
            { "Hebr", metaValue_he },
            { "Hira", "\u09b9\u09bf\u09f0\u09be\u0997\u09be\u09a8\u09be" },
            { "Hrkt", "\u099c\u09be\u09aa\u09be\u09a8\u09c0 \u099b\u09bf\u09b2\u09c7\u09ac\u09c7\u09f0\u09bf\u099c" },
            { "Jamo", "\u099c\u09be\u09ae\u09cb" },
            { "Jpan", metaValue_ja },
            { "Kana", "\u0995\u09be\u099f\u09be\u0995\u09be\u09a8\u09be" },
            { "Khmr", metaValue_km },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Laoo", metaValue_lo },
            { "Latn", metaValue_la },
            { "Mlym", metaValue_ml },
            { "Mong", "\u09ae\u0999\u09cd\u0997\u09cb\u09b2\u09bf\u09af\u09bc" },
            { "Mtei", "\u09ae\u09c7\u0987\u09a4\u09c7\u0987 \u09ae\u09be\u09af\u09bc\u09c7\u0995" },
            { "Mymr", "\u09ae\u09cd\u09af\u09be\u09a8\u09ae\u09be\u09f0" },
            { "Nkoo", "\u098f\u09a8\u09cd\u200d\u0995\u2019" },
            { "Olck", "\u0985\u2019\u09b2 \u099a\u09bf\u0995\u09bf" },
            { "Orya", metaValue_or },
            { "Rohg", "\u09b9\u09be\u09a8\u09bf\u09ab\u09bf" },
            { "Sinh", "\u09b8\u09bf\u0982\u09b9\u09b2\u09c0" },
            { "Sund", "\u099b\u09be\u09a3\u09cd\u09a1\u09be\u09a8\u09bf\u099c" },
            { "Syrc", "\u099b\u09bf\u09f0\u09bf\u09af\u09bc\u09be\u0995" },
            { "Taml", metaValue_ta },
            { "Telu", metaValue_te },
            { "Tfng", "\u099f\u09bf\u09ab\u09bf\u09a8\u09be\u0998" },
            { "Thaa", "\u09a5\u09be\u09a8\u09be" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Vaii", metaValue_vai },
            { "Yiii", "\u09af\u09bc\u09bf" },
            { "Zmth", "\u0997\u09be\u09a3\u09bf\u09a4\u09bf\u0995 \u099a\u09bf\u09b9\u09cd\u09a8" },
            { "Zsye", "\u0987\u09ae\u2019\u099c\u09bf" },
            { "Zsym", "\u09aa\u09cd\u09f0\u09a4\u09c0\u0995" },
            { "Zxxx", "\u0985\u09b2\u09bf\u0996\u09bf\u09a4" },
            { "Zyyy", "\u0995\u09cb\u09ae\u09cb\u09a8" },
            { "Zzzz", "\u0985\u099c\u09cd\u099e\u09be\u09a4 \u09b2\u09bf\u09aa\u09bf" },
            { "de_AT", "\u0985\u09b7\u09cd\u099f\u09cd\u09f0\u09c7\u09b2\u09bf\u09af\u09bc\u09be\u09a8 \u099c\u09be\u09f0\u09cd\u09ae\u09be\u09a8" },
            { "de_CH", "\u099b\u09c1\u0987\u099a \u09b9\u09be\u0987 \u099c\u09be\u09f0\u09cd\u09ae\u09be\u09a8" },
            { "en_AU", "\u0985\u09b7\u09cd\u099f\u09cd\u09f0\u09c7\u09b2\u09bf\u09af\u09bc\u09be\u09a8 \u0987\u0982\u09f0\u09be\u099c\u09c0" },
            { "en_CA", "\u0995\u09be\u09a8\u09be\u09a1\u09bf\u09af\u09bc\u09be\u09a8 \u0987\u0982\u09f0\u09be\u099c\u09c0" },
            { "en_GB", "\u09ac\u09cd\u09f0\u09bf\u099f\u09bf\u099b \u0987\u0982\u09f0\u09be\u099c\u09c0" },
            { "en_US", "\u0986\u09ae\u09c7\u09f0\u09bf\u0995\u09be\u09a8 \u0987\u0982\u09f0\u09be\u099c\u09c0" },
            { "es_ES", "\u0987\u0989\u09f0\u09cb\u09aa\u09c0\u09af\u09bc\u09be\u09a8 \u09b8\u09cd\u09aa\u09c7\u09a8\u09bf\u099a" },
            { "es_MX", "\u09ae\u09c7\u0995\u09cd\u09b8\u09bf\u0995\u09be\u09a8 \u09b8\u09cd\u09aa\u09c7\u09a8\u09bf\u099a" },
            { "fa_AF", "\u09a6\u09be\u09f0\u09bf" },
            { "fr_CA", "\u0995\u09be\u09a8\u09be\u09a1\u09bf\u09af\u09bc\u09be\u09a8 \u09ab\u09cd\u09f0\u09c7\u09a8\u09cd\u09b8" },
            { "fr_CH", "\u099b\u09c1\u0987\u099a \u09ab\u09cd\u09f0\u09c7\u09a8\u09cd\u09b8" },
            { "nl_BE", "\u09ab\u09cd\u09b2\u09c7\u09ae\u09bf\u099a" },
            { "pt_BR", "\u09ac\u09cd\u09f0\u09be\u099c\u09bf\u09b2\u09bf\u09af\u09bc\u09be\u09a8 \u09aa\u09f0\u09cd\u09a4\u09c1\u0997\u09c0\u099c" },
            { "pt_PT", "\u0987\u0989\u09f0\u09cb\u09aa\u09c0\u09af\u09bc\u09be\u09a8 \u09aa\u09f0\u09cd\u09a4\u09c1\u0997\u09c0\u099c" },
            { "ro_MD", "\u09ae\u09cb\u09b2\u09cd\u09a1\u09be\u09ad\u09bf\u09af\u09bc\u09be\u09a8" },
            { "sw_CD", "\u0995\u0999\u09cd\u0997\u09cb \u09b8\u09cd\u09ac\u09be\u09b9\u09bf\u09b2\u09bf" },
            { "ar_001", "\u0986\u09a7\u09c1\u09a8\u09bf\u0995 \u09ae\u09be\u09a8\u0995 \u0986\u09f0\u09ac\u09c0" },
            { "es_419", "\u09b2\u09c7\u099f\u09bf\u09a8 \u0986\u09ae\u09c7\u09f0\u09bf\u0995\u09be\u09a8 \u09b8\u09cd\u09aa\u09c7\u09a8\u09bf\u099a" },
            { "key.ca", "\u0995\u09c7\u09b2\u09c7\u09a3\u09cd\u09a1\u09be\u09f0" },
            { "key.cf", "\u09ae\u09c1\u09a6\u09cd\u09f0\u09be \u09b8\u099c\u09cd\u099c\u09be" },
            { "key.co", "\u09b8\u099c\u09cb\u09f1\u09be \u0995\u09cd\u09f0\u09ae" },
            { "key.cu", "\u09ae\u09c1\u09a6\u09cd\u09f0\u09be" },
            { "key.hc", "\u0998\u09a3\u09cd\u099f\u09c0\u09af\u09bc\u09be \u099a\u0995\u09cd\u09f0 (\u09e7\u09e8 \u09ac\u09a8\u09be\u09ae \u09e8\u09ea)" },
            { "key.lb", "\u09aa\u0982\u0995\u09cd\u09a4\u09bf \u09ac\u09bf\u099a\u09cd\u099b\u09c7\u09a6 \u09b6\u09c8\u09b2\u09c0" },
            { "key.ms", "\u099c\u09cb\u0996-\u09ae\u09be\u0996\u09f0 \u09aa\u09cd\u09f0\u09a3\u09be\u09b2\u09c0" },
            { "key.nu", "\u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "zh_Hans", "\u09b8\u09f0\u09b2\u09c0\u0995\u09c3\u09a4 \u099a\u09c0\u09a8\u09be" },
            { "zh_Hant", "\u09aa\u09f0\u09ae\u09cd\u09aa\u09f0\u09be\u0997\u09a4 \u099a\u09c0\u09a8\u09be" },
            { "type.ca.roc", "\u099a\u09c0\u09a8\u09be \u09aa\u09cd\u09f0\u099c\u09be\u09a4\u09a8\u09cd\u09a4\u09cd\u09f0\u09f0 \u0995\u09c7\u09b2\u09c7\u09a3\u09cd\u09a1\u09be\u09f0" },
            { "type.hc.h11", "\u09e7\u09e8 \u0998\u09a3\u09cd\u099f\u09c0\u09af\u09bc\u09be \u09aa\u09cd\u09f0\u09a3\u09be\u09b2\u09c0 (\u09e6\u2013\u09e7\u09e7)" },
            { "type.hc.h12", "\u09e7\u09e8 \u0998\u09a3\u09cd\u099f\u09c0\u09af\u09bc\u09be \u09aa\u09cd\u09f0\u09a3\u09be\u09b2\u09c0 (\u09e7\u2013\u09e7\u09e8)" },
            { "type.hc.h23", "\u09e8\u09ea \u0998\u09a3\u09cd\u099f\u09c0\u09af\u09bc\u09be \u09aa\u09cd\u09f0\u09a3\u09be\u09b2\u09c0 (\u09e6\u2013\u09e8\u09e9)" },
            { "type.hc.h24", "\u09e8\u09ea \u0998\u09a3\u09cd\u099f\u09c0\u09af\u09bc\u09be \u09aa\u09cd\u09f0\u09a3\u09be\u09b2\u09c0 (\u09e7\u2013\u09e8\u09ea)" },
            { "type.nu.arab", "\u0986\u09f0\u09ac\u09c0-\u09ad\u09be\u09f0\u09a4\u09c0\u09af\u09bc \u0985\u0982\u0995" },
            { "type.nu.armn", "\u0986\u09f0\u09cd\u09ae\u09c7\u09a8\u09c0\u09af\u09bc \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.beng", "\u09ac\u09be\u0982\u09b2\u09be \u0985\u0982\u0995" },
            { "type.nu.cakm", "\u099a\u09be\u0995\u09ae\u09be \u0985\u0982\u0995" },
            { "type.nu.deva", "\u09a6\u09c7\u09f1\u09a8\u09be\u0997\u09f0\u09c0 \u0985\u0982\u0995" },
            { "type.nu.ethi", "\u0987\u09a5\u09bf\u0985\u2019\u09aa\u09bf\u0995 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.geor", "\u099c\u09f0\u09cd\u099c\u09c0\u09af\u09bc\u09be\u09a8 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.grek", "\u0997\u09cd\u09f0\u09c0\u0995 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.gujr", "\u0997\u09c1\u099c\u09f0\u09be\u099f\u09c0 \u0985\u0982\u0995" },
            { "type.nu.guru", "\u0997\u09c1\u09f0\u09c1\u09ae\u09c1\u0996\u09c0 \u0985\u0982\u0995" },
            { "type.nu.hans", "\u09b8\u09f0\u09b2\u09c0\u0995\u09c3\u09a4 \u099a\u09c0\u09a8\u09be \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.hant", "\u09aa\u09f0\u09ae\u09cd\u09aa\u09f0\u09be\u0997\u09a4 \u099a\u09c0\u09a8\u09be \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.hebr", "\u09b9\u09bf\u09ac\u09cd\u09f0\u09c1 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.java", "\u099c\u09be\u09ad\u09be\u09a8\u09c0\u099c \u0985\u0982\u0995" },
            { "type.nu.jpan", "\u099c\u09be\u09aa\u09be\u09a8\u09c0 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.khmr", "\u0996\u09ae\u09c7\u09f0 \u0985\u0982\u0995" },
            { "type.nu.knda", "\u0995\u09be\u09a8\u09be\u09a1\u09bc\u09be \u0985\u0982\u0995" },
            { "type.nu.laoo", "\u09b2\u09be\u0993 \u0985\u0982\u0995" },
            { "type.nu.latn", "\u09aa\u09b6\u09cd\u099a\u09bf\u09ae\u09c0\u09af\u09bc\u09be \u0985\u0982\u0995" },
            { "type.nu.mlym", "\u09ae\u09be\u09b2\u09be\u09af\u09bc\u09be\u09b2\u09ae \u0985\u0982\u0995" },
            { "type.nu.mtei", "\u09ae\u09c7\u0987\u09a4\u09c7\u0987 \u09ae\u09be\u09af\u09bc\u09c7\u0995 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.mymr", "\u09ae\u09cd\u09af\u09be\u09a8\u09ae\u09be\u09f0 \u0985\u0982\u0995" },
            { "type.nu.olck", "\u0985\u2019\u09b2 \u099a\u09bf\u0995\u09bf \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.orya", "\u0993\u09a1\u09bc\u09bf\u09af\u09bc\u09be \u0985\u0982\u0995" },
            { "type.nu.taml", "\u09aa\u09f0\u09ae\u09cd\u09aa\u09f0\u09be\u0997\u09a4 \u09a4\u09be\u09ae\u09bf\u09b2 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.telu", "\u09a4\u09c7\u09b2\u09c1\u0997\u09c1 \u0985\u0982\u0995" },
            { "type.nu.thai", "\u09a5\u09be\u0987 \u0985\u0982\u0995" },
            { "type.nu.tibt", "\u09a4\u09bf\u09ac\u09cd\u09ac\u09a4\u09c0 \u0985\u0982\u0995" },
            { "type.nu.vaii", "\u09ad\u09c7\u0987 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.ca.dangi", "\u09a6\u09be\u0982\u0997\u09bf \u0995\u09c7\u09b2\u09c7\u09a3\u09cd\u09a1\u09be\u09f0" },
            { "type.co.ducet", "\u09a1\u09bf\u09ab\u2019\u09b2\u09cd\u099f \u0987\u0989\u09a8\u09bf\u0995\u09cb\u09a1 \u09b8\u099c\u09cb\u09f1\u09be \u0995\u09cd\u09f0\u09ae" },
            { "type.lb.loose", "\u09a2\u09bf\u09b2\u09be \u09aa\u0982\u0995\u09cd\u09a4\u09bf \u09ac\u09bf\u099a\u09cd\u099b\u09c7\u09a6 \u09b6\u09c8\u09b2\u09c0" },
            { "type.nu.roman", "\u09f0\u09cb\u09ae\u09be\u09a8 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.ca.coptic", "\u0995\u2019\u09aa\u09cd\u099f\u09bf\u0995 \u0995\u09c7\u09b2\u09c7\u09a3\u09cd\u09a1\u09be\u09f0" },
            { "type.ca.hebrew", "\u09b9\u09bf\u09ac\u09cd\u09f0\u09c1 \u0995\u09c7\u09b2\u09c7\u09a3\u09cd\u09a1\u09be\u09f0" },
            { "type.ca.indian", "\u09ad\u09be\u09f0\u09a4\u09c0\u09af\u09bc \u09f0\u09be\u09b7\u09cd\u099f\u09cd\u09f0\u09c0\u09af\u09bc \u09aa\u099e\u09cd\u099c\u09bf\u0995\u09be" },
            { "type.co.pinyin", "\u09aa\u09bf\u09a8\u09cd\u200c\u09af\u09bc\u09bf\u09a8 \u09b6\u09c3\u0999\u09cd\u0996\u09b2\u09be\u09ac\u09a6\u09cd\u09a7 \u0995\u09f0\u09be\u09f0 \u0995\u09cd\u09f0\u09ae" },
            { "type.co.search", "\u09b8\u09be\u09a7\u09be\u09f0\u09a3 \u0989\u09a6\u09cd\u09a6\u09c7\u09b6\u09cd\u09af\u09c7 \u0985\u09a8\u09c1\u09b8\u09a8\u09cd\u09a7\u09be\u09a8" },
            { "type.co.stroke", "\u09b8\u09cd\u099f\u09cd\u09f0\u09cb\u0995 \u09b6\u09c3\u0999\u09cd\u0996\u09b2\u09be\u09ac\u09a6\u09cd\u09a7 \u0995\u09f0\u09be\u09f0 \u0995\u09cd\u09f0\u09ae" },
            { "type.lb.normal", "\u09b8\u09be\u09a7\u09be\u09f0\u09a3 \u09aa\u0982\u0995\u09cd\u09a4\u09bf \u09ac\u09bf\u099a\u09cd\u099b\u09c7\u09a6 \u09b6\u09c8\u09b2\u09c0" },
            { "type.lb.strict", "\u0995\u09a0\u09cb\u09f0 \u09aa\u0982\u0995\u09cd\u09a4\u09bf \u09ac\u09bf\u099a\u09cd\u099b\u09c7\u09a6 \u09b6\u09c8\u09b2\u09c0" },
            { "type.ms.metric", "\u09ae\u09c7\u099f\u09cd\u09f0\u09bf\u0995 \u09aa\u09cd\u09f0\u09a3\u09be\u09b2\u09c0" },
            { "type.ca.chinese", "\u099a\u09c0\u09a8\u09be \u0995\u09c7\u09b2\u09c7\u09a3\u09cd\u09a1\u09be\u09f0" },
            { "type.ca.islamic", "\u0987\u099b\u09b2\u09be\u09ae\u09c0 \u0995\u09c7\u09b2\u09c7\u09a3\u09cd\u09a1\u09be\u09f0" },
            { "type.ca.iso8601", "\u0986\u0987. \u098f\u099b. \u0985\u2019.-\u09ee\u09ec\u09e6\u09e7 \u0995\u09c7\u09b2\u09c7\u09a3\u09cd\u09a1\u09be\u09f0" },
            { "type.ca.persian", "\u09ab\u09be\u09f0\u09cd\u099a\u09c0 \u0995\u09c7\u09b2\u09c7\u09a3\u09cd\u09a1\u09be\u09f0" },
            { "type.cf.account", "\u0997\u09be\u09a3\u09a8\u09bf\u0995 \u09ae\u09c1\u09a6\u09cd\u09f0\u09be \u09b8\u099c\u09cd\u099c\u09be" },
            { "type.co.big5han", "\u09aa\u09f0\u09ae\u09cd\u09aa\u09f0\u09be\u0997\u09a4 \u099a\u09c0\u09a8\u09be \u09b6\u09c3\u0999\u09cd\u0996\u09b2\u09be\u09ac\u09a6\u09cd\u09a7 \u0995\u09f0\u09be\u09f0 \u0995\u09cd\u09f0\u09ae - Big5" },
            { "type.nu.arabext", "\u09ac\u09bf\u09b8\u09cd\u09a4\u09be\u09f0\u09bf\u09a4 \u0986\u09f0\u09ac\u09c0-\u09ad\u09be\u09f0\u09a4\u09c0\u09af\u09bc \u0985\u0982\u0995" },
            { "type.nu.armnlow", "\u0986\u09f0\u09cd\u09ae\u09c7\u09a8\u09c0\u09af\u09bc \u09b8\u09f0\u09c1\u09ab\u09b2\u09be \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.greklow", "\u0997\u09cd\u09f0\u09c0\u0995 \u09b8\u09f0\u09c1\u09ab\u09b2\u09be \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.hanidec", "\u099a\u09c0\u09a8\u09be \u09a6\u09b6\u09ae\u09bf\u0995 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.hansfin", "\u09b8\u09f0\u09b2\u09c0\u0995\u09c3\u09a4 \u099a\u09c0\u09a8\u09be \u09ac\u09bf\u09a4\u09cd\u09a4\u09c0\u09af\u09bc \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.hantfin", "\u09aa\u09f0\u09ae\u09cd\u09aa\u09f0\u09be\u0997\u09a4 \u099a\u09c0\u09a8\u09be \u09ac\u09bf\u09a4\u09cd\u09a4\u09c0\u09af\u09bc \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.jpanfin", "\u099c\u09be\u09aa\u09be\u09a8\u09c0 \u09ac\u09bf\u09a4\u09cd\u09a4\u09c0\u09af\u09bc \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.tamldec", "\u09a4\u09be\u09ae\u09bf\u09b2 \u0985\u0982\u0995" },
            { "type.ca.buddhist", "\u09ac\u09cc\u09a6\u09cd\u09a7 \u0995\u09c7\u09b2\u09c7\u09a3\u09cd\u09a1\u09be\u09f0" },
            { "type.ca.ethiopic", "\u0987\u09a5\u09bf\u0985\u2019\u09aa\u09bf\u0995 \u0995\u09c7\u09b2\u09c7\u09a3\u09cd\u09a1\u09be\u09f0" },
            { "type.ca.japanese", "\u099c\u09be\u09aa\u09be\u09a8\u09c0 \u0995\u09c7\u09b2\u09c7\u09a3\u09cd\u09a1\u09be\u09f0" },
            { "type.cf.standard", "\u09ae\u09be\u09a8\u09cd\u09af \u09ae\u09c1\u09a6\u09cd\u09f0\u09be \u09b8\u099c\u09cd\u099c\u09be" },
            { "type.co.standard", "\u09ae\u09be\u09a8\u09cd\u09af \u09b8\u099c\u09cb\u09f1\u09be \u0995\u09cd\u09f0\u09ae" },
            { "type.ms.uksystem", "\u0987\u09ae\u09cd\u09aa\u09c7\u09f0\u09bf\u09af\u09bc\u09c7\u09b2 \u099c\u09cb\u0996-\u09ae\u09be\u0996\u09f0 \u09aa\u09cd\u09f0\u09a3\u09be\u09b2\u09c0" },
            { "type.ms.ussystem", "\u09ae\u09be\u09f0\u09cd\u0995\u09bf\u09a8 \u09af\u09c1\u0995\u09cd\u09a4\u09f0\u09be\u09b7\u09cd\u099f\u09cd\u09f0\u09f0 \u099c\u09cb\u0996-\u09ae\u09be\u0996\u09f0 \u09aa\u09cd\u09f0\u09a3\u09be\u09b2\u09c0" },
            { "type.nu.fullwide", "\u09aa\u09c2\u09f0\u09cd\u09a3-\u09aa\u09cd\u09f0\u09b8\u09cd\u09a5\u09f0 \u0985\u0982\u0995" },
            { "type.nu.romanlow", "\u09f0\u09cb\u09ae\u09be\u09a8 \u09b8\u09f0\u09c1\u09ab\u09b2\u09be \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.ca.gregorian", "\u0997\u09cd\u09f0\u09c7\u0997\u09cb\u09f0\u09bf\u09af\u09bc\u09be\u09a8 \u0995\u09c7\u09b2\u09c7\u09a3\u09cd\u09a1\u09be\u09f0" },
            { "type.co.gb2312han", "\u09b8\u09f0\u09b2 \u099a\u09c0\u09a8\u09be \u09b6\u09c3\u0999\u09cd\u0996\u09b2\u09be\u09ac\u09a6\u09cd\u09a7 \u0995\u09f0\u09be\u09f0 \u0995\u09cd\u09f0\u09ae - GB2312" },
            { "type.co.phonebook", "\u099f\u09c7\u09b2\u09bf\u09ab\u09cb\u09a8 \u09ac\u09b9\u09bf\u09f0 \u09ae\u09a4\u09c7\u09b6\u09c3\u0999\u09cd\u0996\u09b2\u09be\u09ac\u09a6\u09cd\u09a7 \u0995\u09f0\u09be\u09f0 \u0995\u09cd\u09f0\u09ae" },
            { "type.co.traditional", "\u09aa\u09f0\u09ae\u09cd\u09aa\u09f0\u09be\u0997\u09a4\u09ad\u09be\u09ac\u09c7 \u09b6\u09c3\u0999\u09cd\u0996\u09b2\u09be\u09ac\u09a6\u09cd\u09a7 \u0995\u09f0\u09be\u09f0 \u0995\u09cd\u09f0\u09ae" },
            { "type.ca.islamic-civil", "\u0987\u099a\u09b2\u09be\u09ae\u09c0-\u09a8\u09be\u0997\u09f0\u09bf\u0995\u09f0 \u09aa\u099e\u09cd\u099c\u09bf\u0995\u09be" },
            { "type.ca.islamic-umalqura", "\u0987\u099a\u09b2\u09be\u09ae\u09c0 \u0995\u09c7\u09b2\u09c7\u09a3\u09cd\u09a1\u09be\u09f0 (\u0989\u09ae \u0985\u09b2-\u0995\u09c1\u09f0\u09be)" },
            { "type.ca.ethiopic-amete-alem", "\u0987\u09a5\u09bf\u0985\u2019\u09aa\u09bf\u0995 \u098f\u09ae\u09bf\u099f\u09bf \u098f\u09b2\u09c7\u09ae \u0995\u09c7\u09b2\u09c7\u09a3\u09cd\u09a1\u09be\u09f0" },
        };
        return data;
    }
}
